C     Last change:  VP   30 Dec 97    7:40 am
      subroutine DatRed
      include 'params.cmn'
      include 'basic.cmn'
      include 'datred.cmn'
      include 'fepc.cmn'
      dimension nmen(12)
      character*31 men(12)
      integer FeMenuNew
      logical ExistFile,Change,FeYesNo,UzExistovalM95
      data men/'%Import data collection file',
     1         'Imp%ort psi-scan file',
     2         '%Decay and Lp correction',
     3         '%Absorption correction',
     4         'S%how crystal shape',
     5         'Show/correct p%rofile',
     6         'Run %X-shape',
     7         '%Simulation of precession photo',
     8         'Space %group test',
     9         '%Cell transformation',
     a         'Change of %modulation vector',
     1         '%Export to SHELX'/
      equivalence (IdNumbers( 1),IdImport),
     1            (IdNumbers( 2),IdImportPsi),
     2            (IdNumbers( 3),IdDecayLp),
     3            (IdNumbers( 4),IdAbsCorr),
     4            (IdNumbers( 5),IdCrystShape),
     5            (IdNumbers( 6),IdProfile),
     6            (IdNumbers( 7),IdRunXShape),
     7            (IdNumbers( 8),IdPrecession),
     8            (IdNumbers( 9),IdGroupTest),
     9            (IdNumbers(10),IdCellTr),
     a            (IdNumbers(11),IdChngQ),
     1            (IdNumbers(12),IdExportSHELX)
      data pgraf/6.7079/
      Change=.false.
      UzExistovalM95=ExistM95
      call PrelimDatRed
      if(ErrJana.ne.0) go to 9999
      if(.not.UzExistovalM95.and.ExistM95) Change=.true.
1000  do 1250j=1,12
        if(((j.eq.IdImport.or.j.eq.IdImportPsi.or.j.eq.IdGroupTest.or.
     1       j.eq.IdAbsCorr.or.j.eq.IdCrystShape).and.
     2       DifCode.ne.IdNoName).or.
     3     (j.eq.IdDecayLp.and.(DifCode.eq.IdCAD4.or.
     4      DifCode.eq.IdSiemensP4.or.DifCode.eq.IdKumaPD)).or.
     5     (j.eq.IdProfile.and.Profil).or.
     6     (j.eq.IdRunXShape.and.CallXShape.ne.' '.and.
     7      DifCode.ne.IdNoName).or.
     8     (j.eq.IdChngQ.and.ndim.gt.3).or.
     9      j.eq.IdPrecession.or.j.eq.IdCellTr.or.j.eq.IdExportSHELX)
     a    then
          nmen(j)=1
        else
          nmen(j)=0
        endif
1250  continue
      ErrJana=0
      call FeMakeGrWin(0.,0.,14.,0.)
      j=FeMenuNew(-1.,-1.,men,nmen,1,12,1,0)
      if(j.lt.1.or.j.gt.12) j=0
      if(j.eq.IdImport) then
        call NactiM95(1)
        if(ErrJana.eq.0) then
          Change=.true.
        else
          go to 9999
        endif
      else if(j.eq.IdImportPsi) then
        call NactiM95(2)
        if(ErrJana.eq.0) then
          Change=.true.
        else
          go to 9999
        endif
      else if(j.eq.IdDecayLp) then
        snm=LamAve(1)/pgraf
        cs2m=1.-2.*snm**2
        cs2mq=cs2m**2
        call KorStLp
        if(ErrJana.eq.0) Change=.true.
      else if(j.eq.IdAbsCorr) then
        call abskvse
        if(ErrJana.eq.0) Change=.true.
      else if(j.eq.IdCrystShape) then
        call MorfCryst
      else if(j.eq.IdProfile) then
        call PrfShow
      else if(j.eq.IdRunXShape) then
        call EM50GenSym(RunForFirstTimeYes,MakeCellTestNo,AskForDeltaNo,
     1                  ich)
        call RunXShape
      else if(j.eq.IdPrecession) then
        call Simulace
      else if(j.eq.IdGroupTest) then
        call DRSGTest(Change)
      else if(j.eq.IdCellTr) then
        call CellTr
      else if(j.eq.IdChngQ) then
        call DRChngModVec
      else if(j.eq.IdExportSHELX) then
        call DRExport(0,' ')
      else
        go to 9999
      endif
      go to 1000
9999  if((Change.or..not.ExistM91).and.ExistM95.and.CorrLp.gt.0.and.
     1   ErrJana.eq.0.) then
        if(ExistM50.and.StatusM50.le.100) then
          if(FeYesNo(-1.,-1.,'Do you want to create refinement '//
     1               'reflection file (m91)?',1)) call ExportM91
        else
          if(FeYesNo(-1.,-1.,'Do you want to create or complete basic'//
     1               ' data file (m50)?',1)) call Editm50
        endif
      endif
      return
      end
      subroutine PrelimDatRed
      include 'params.cmn'
      include 'basic.cmn'
      include 'datred.cmn'
      include 'profil.cmn'
      include 'fepc.cmn'
      character*80 t80
      character*80 FormulaM50
      logical ExistFile,EqIgCase
      AccessTransparent='transparent'
      FileInDatRed=' '
      call SetIntArrayTo(igauss,3,10)
      CorrLp=1
      CorrAbs=0
      nref95=0
      nref96=0
      nfaces=0
      radiusDatRed=0.
      ami=0.
      DRmmax=4
      DifCode=IdKumaCCD
      call SetRealArrayTo(DRDiffSat,3,.001)
      ExistM96=ExistFile(fln(:ifln)//'.m96')
      if(.not.ExistM94.and..not.ExistM95.and.StatusM50.lt.10000) then
        call iom50(0,0)
        if(ErrJana.ne.0) go to 9999
        call SetBasicM94
        DifCode=IdKumaCCD
        call iom94(1)
      endif
      if(ExistM95) then
        if(ExistM94) then
          if(ExistM50) then
            call iom50(0,0)
            FormulaM50=Formula
            nzM50=nz
            ncompM50=ncomp
            call iom94(0)
            if(Formula.ne.FormulaM50.or.nz.ne.nzM50) then
              nz=nzM50
              Formula=FormulaM50
              call iom94(1)
            endif 
            ncomp=ncompM50
          endif  
          call iom94(0)
        else
          call FeChybne(-1.,-1.,'the file M95 exist but the M94 '//
     1                  'doesn''t',' ',0,SeriousError)
          ErrJana=1
          go to 9999
        endif
        call OpenFile(95,fln(:ifln)//'.m95','formatted','old')
        if(nref95.le.0) then
          nref95=0
2000      call DRGetReflectionFromM95(95,iend,ich)
          if(iend.ne.0.or.ich.ne.0) then
            go to 2100
          else
            nref95=nref95+1
            go to 2000
          endif
2100      close(95)
          call iom94(1)
        endif
        rewind 95
        call DRGetReflectionFromM95(95,iend,ich)
        Profil=KProf.gt.0
        close(95)
      else
        call NactiM95(0)
        if(ErrJana.ne.0) go to 9999
      endif
      NFacesR=NFaces
      call CopyVek(DFace,DFaceR,4*NFaces)
      call GetFromSummary('datred')
      t80=fln(:ifln)//'_datred.tmp'
      if(.not.ExistFile(t80)) then
        call OpenFile(89,t80,'formatted','new')
        if(ErrJana.ne.0) go to 9999
        write(89,'(''datred'')')
        write(89,'(''standards: ?'')')
        write(89,'(''standards:'')')
        write(89,'(''absorption: ?'')')
        write(89,'(''end'')')
        call CloseIfOpened(89)
      endif
9999  return
      end
      subroutine NactiM95(KeyIn)
      include 'params.cmn'
      include 'basic.cmn'
      include 'datred.cmn'
      include 'profil.cmn'
      include 'fepc.cmn'
      character*256 EdwStringQuest
      character*80  t80,p80
      character*15 men(11)
      character*4  mene(12)
      character*2  nty
      logical ExistFile,FeYesNoHeader,EqIgCase
      integer EdwStateQuest,EdwIntQuest,DiffOrder(11),DiffOrderSel
      dimension kdef(7)
      data men/'%CAD4',
     1         '%Siemens P4',
     2         '%IPDS Stoe',
     3         'D%9-ILL',
     4         'Hasylab %F1',
     5         'Hasylab %HUBER',
     6         '%Kuma-CCD',
     7         'K%uma-PD',
     8         '%Nonius-CCD',
     9         'B%ruker-CCD',
     a         '%XDS'/
      data mene/'.dat','.p4o','.hkl','.col','.raw','.hkl','.hkl',
     1          '.dca','.hkl','.raw','.hkl','.psi'/,NDiffTypes/11/
      save kdef
      DiffOrder( 1)=IdCAD4
      DiffOrder( 2)=IdSiemensP4
      DiffOrder( 3)=IdIPDSStoe
      DiffOrder( 4)=IdD9ILL
      DiffOrder( 5)=IdHasyLabF1
      DiffOrder( 6)=IdHasyLabHuber
      DiffOrder( 7)=IdKumaCCD
      DiffOrder( 8)=IdKumaPD
      DiffOrder( 9)=IdNoniusCCD
      DiffOrder(10)=IdBrukerCCD
      DiffOrder(11)=IdXDS
      Key=KeyIn
      nsold=ns
      if(Key.le.1) then
        t80='Data reduction file'
        p80=fln(:ifln)//'.m95'
      else
        t80='Psi-scan file'
        p80=fln(:ifln)//'.m96'
      endif
      call OpenFile(95,p80,'formatted','unknown')
      if(ErrJana.ne.0) go to 9999
      call NastavM95(t80,nref956,ich)
      if(ErrJana.ne.0.or.ich.ne.0) go to 9000
      if(FileInDatRed.eq.' ') call SetIntArrayTo(kdef,7,0)
      if(nref956.le.0) then
        nref956=0
        if(ExistM95.and.Key.le.1) then
          NInfo=3
          TextInfo(1)='You have asked to rewrite reflection data file'//
     1                ' m95. The'
          TextInfo(2)='procedure will also rewrite basic crystal data'//
     1                ' file m94'
          TextInfo(3)='and delete basic file m50 and refinement '//
     1                'reflection file m91.'
          if(FeYesNoHeader(-1.,-1.,'Do you really want to continue?',0))
     1      then
            call DeleteFile(fln(:ifln)//'.m50')
            call DeleteFile(fln(:ifln)//'.m91')
            call DeleteFile(fln(:ifln)//'.m94')
            call DeleteFile(fln(:ifln)//'.m95')
            ExistM50=.false.
            StatusM50=11100
            ExistM91=.false.
            ExistM94=.false.
            ExistM95=.false.
            if(Key.eq.1) Key=0
            call OpenFile(95,p80,'formatted','unknown')
            if(ErrJana.ne.0) go to 9999
            nref95=0
          else
            ErrJana=1
            go to 9999
          endif
        endif
      endif
1000  DifCode=IdKumaCCD
      if(.not.ExistM94.and..not.ExistM50) then
        ndim=3
        ndimq=9
        ndimi=0
      else
        if(.not.ExistM94) then
          do 1002j=1,ndimi
            do 1001i=1,3
              call CopyVek(Qu(1,j,1,KPhase),QuDatRed(1,j,i),3)
1001        continue
1002      continue
          do 1003i=1,3
            call CopyVek(CellPar(1,1,KPhase),CellDatRed(1,i),6)
1003      continue
        else
          call iom94(0)
        endif
        call SetIntArrayTo(kdef,ndimi,1)
        kdef(4)=1
        kdef(5)=1
      endif
      if(Key.le.1) then
        t80='Specify data collection file'
      else
        t80='Specify psi-scan file'
      endif
      ndimo=ndim
      id=NextQuestId()
      if(Key.eq.1) then
        il=1
        t80=t80(:idel(t80))//' to appended'
        do 1005i=1,NDiffTypes
          if(DiffOrder(i).eq.DifCode) then
            DiffOrderSel=i
            go to 1006
          endif
1005    continue
        DiffOrderSel=7
      else
        il=NDiffTypes+3
      endif
1006  call FeQuestCreate(id,-1.,-1.,220.,0,il,t80,1,LightGray,0,0)
      if(Key.eq.0) then
        il=1
        do 1010i=1,NDiffTypes
          il=il+1
          call FeQuestCrwMake(id,150.,il,207.,il,men(i),'L',CrwgXd,
     1                        CrwgYd,1,1)
          if(i.eq.1) nCrwTypeFr=CrwLastMade
          call FeQuestCrwOpen(CrwLastMade,DiffOrder(i).eq.DifCode)
          if(DiffOrder(i).eq.DifCode) DiffOrderSel=i
1010    continue
        nCrwTypeTo=CrwLastMade
      else
        nCrwTypeFr=0
      endif
      il=1
      call FeQuestEdwMake(id,5.,il,45.,il,'Fi%le name','L',130.,EdwYd,
     1                    0)
      nEdwFileName=EdwLastMade
      call FeQuestButtonMake(id,180.,il,35.,ButYd,'%Browse')
      nButBrowse=ButtonLastMade
      call FeQuestButtonOpen(nButBrowse,ButtonOff)
      if(Key.eq.0) then
        il=il+1
        call FeQuestEudMake(id,5.,il,85.,il,'Target %dimension','L',
     1                      15.,EdwYd,1)
        nEdwDim=EdwLastMade
        if(DifCode.ne.IdBrukerCCD) then
          call FeQuestIntEdwOpen(nEdwDim,ndim,.false.)
          call FeQuestEudOpen(nEdwDim,3,6,1,0.,0.,0.)
        endif
        do 1012i=1,3
          il=il+1
          write(p80,'(''%'',i1,a2,'' modulation vector'')') i,nty(i)
          call FeQuestEdwMake(id,5.,il,85.,il,p80,'L',60.,EdwYd,0)
          nEdw=EdwLastMade
          if(i.eq.1) then
            nEdwModFr=EdwLastMade
          else if(i.eq.3) then
            nEdwModTo=EdwLastMade
          endif
          if(i.le.ndimi.and.DifCode.ne.IdKumaCCD.and.
     1                      DifCode.ne.IdBrukerCCD)
     2      call FeQuestRealAEdwOpen(nEdw,QuDatRed(1,i,1),3,
     3                               kdef(i).eq.0,.false.)
1012    continue
        il=il+1
        p80='%Maximum satellite index'
        call FeQuestEudMake(id,5.,il,85.,il,p80,'L',20.,EdwYd,0)
        nEdwMMax=EdwLastMade
        p80='Accurac%y'
        il=il+1
        call FeQuestEdwMake(id,5.,il,85.,il,p80,'L',60.,EdwYd,0)
        nEdwDiffSat=EdwLastMade
        if(ndimi.gt.0.and.(DifCode.eq.IdCAD4.or.DifCode.eq.IdD9ILL.or.
     1     DifCode.eq.IdHasyLabF1.or.DifCode.eq.IdKumaPD.or.
     2     DifCode.eq.IdHasylabHuber).or.DifCode.eq.IdXDS) then
          call FeQuestIntEdwOpen(nEdwMMax,DRmmax,.false.)
          call FeQuestEudOpen(nEdwMMax,0,111,1,0.,0.,0.)
          call FeQuestRealAEdwOpen(nEdwDiffSat,DRDiffSat,3,.false.,
     1                             .false.)
        endif
        il=NDiffTypes+2
        call FeQuestEdwMake(id,5.,il,65.,il,'Cell %parameters','L',
     1                      150.,EdwYd,1)
        nEdwCell=EdwLastMade
        il=il+1
        call FeQuestEdwMake(id,5.,il,65.,il,'%Wave length','L',50.,
     1                      EdwYd,0)
        nEdwWaveLength=EdwLastMade
        if(DifCode.eq.IdIPDSStoe.or.DifCode.eq.IdNoniusCCD) then
          call FeQuestRealAEdwOpen(nEdwCell,CellDatRed,6,kdef(4).eq.0,
     1                             .false.)
          if(kdef(5).eq.0) then
            LamAve(1)=.71073
            kdef(5)=1
          endif
          call FeQuestRealEdwOpen(nEdwWaveLength,LamAve(1),.false.,
     1                            .false.)
        endif
      else
        nEdwDim=0
        nEdwModFr=0
        nEdwModTo=0
        nEdwMMax=0
        nEdwDiffSat=0
        nEdwCell=0
        nEdwWaveLength=0
      endif
1015  if(FileInDatRed.eq.' ') then
        if(Key.le.1) then
          FileInDatRed=fln(:ifln)//mene(DiffOrderSel)
        else
          FileInDatRed=mene(12)
        endif
      endif
      call FeQuestStringEdwOpen(nEdwFileName,FileInDatRed)
      icont=0
1020  if(Key.eq.1) go to 1025
      if((DifCode.eq.IdCAD4.or.DifCode.eq.IdD9ILL.or.
     1    DifCode.eq.IdHasyLabF1.or.DifCode.eq.IdKumaPD.or.
     2    DifCode.eq.IdHasyLabHuber.or.DifCode.eq.IdXDS).and.
     3   ndim.gt.3.and.nEdwMMax.gt.0) then
        if(EdwStateQuest(nEdwMMax).ne.EdwOpened) then
          call FeQuestIntEdwOpen(nEdwMMax,DRmmax,.false.)
          call FeQuestEudOpen(nEdwMMax,0,111,1,0.,0.,0.)
          call FeQuestRealAEdwOpen(nEdwDiffSat,DRDiffSat,3,
     1                             .false.,.false.)
        endif
      else
        call FeQuestEdwClose(nEdwMMax)
        call FeQuestEdwClose(nEdwDiffSat)
      endif
1025  call FeQuestEvent(id,icont,ich)
      icont=1
      if(CheckType.eq.EventButton.and.CheckNumberAbs.eq.ButtonOK) then
        ib=CheckNumber
        if(Key.ne.1.and.DifCode.ne.IdKumaCCD.and.
     1                  DifCode.ne.IdBrukerCCD)
     2    then
          t80='Please complete the form'
          j=0
          do 1031i=nEdwModFr,nEdwModTo
            j=j+1
            if(j.gt.ndimi) go to 1031
            if(EdwStringQuest(i).eq.' ') then
              kdef(j)=0
              write(p80,'(i1,a2)') j,nty(j)
              p80=p80(1:3)//' modulation vector wasn''t defined'
              go to 1033
            endif
1031      continue
          if(DifCode.eq.IdIPDSStoe.or.DifCode.eq.IdNoniusCCD) then
            do 1032i=nEdwCell,nEdwWaveLength
              j=j+1
              if(EdwStringQuest(i).eq.' ') then
                kdef(j)=0
                if(j.eq.4) then
                  p80='cell parameters weren''t defined'
                else if(i.eq.5) then
                  p80='wave length wasn''t defined'
                endif
                go to 1033
              else
                kdef(j)=1
              endif
1032        continue
          endif
        endif
        FileInDatRed=EdwStringQuest(nEdwFileName)
        if(.not.ExistFile(FileInDatRed)) then
          p80='the file "'//FileInDatRed(:idel(FileInDatRed))//
     1        '" does not exist, try again'
          t80=' '
          i=nEdwFileName
          go to 1033
        endif
        QuestCheck(id)=0
        go to 1020
1033    call FeChybne(-1.,-1.,p80,t80,0,SeriousError)
        EventType=EventEdw
        EventNumber=i
        call FeQuestButtonOff(ib)
        go to 1020
      else if(CheckType.eq.EventEdw.and.CheckNumber.eq.nEdwDim) then
        ndim=EdwIntQuest(1,nEdwDim)
        ndimq=ndim**2
        ndimi=ndim-3
        if(ndim.lt.3.or.ndim.gt.6) then
          call FeChybne(-1.,-1.,'dimension out of interval <3,6>',' ',
     1                  0,SeriousError)
          EventType=EventEdw
          EventNumber=nEdwDim
          go to 1020
        endif
        if(DifCode.ne.IdKumaCCD) then
          nEdw=nEdwModFr
          do 1035i=1,3
            if(i.le.ndimi) then
              if(EdwStateQuest(nEdw).ne.EdwOpened)
     1          call FeQuestRealAEdwOpen(nEdw,QuDatRed(1,i,1),3,
     2                                   .true.,.true.)
            else
              call FeQuestEdwClose(nEdw)
            endif
            nEdw=nEdw+1
1035      continue
        endif
        go to 1020
      else if(CheckType.eq.EventEdw.and.CheckNumber.eq.nEdwCell) then
        if(EdwStringQuest(nEdwCell).eq.' ') go to 1020
        csa=cos(EdwRealQuest(4,nEdwCell)*torad)
        csb=cos(EdwRealQuest(5,nEdwCell)*torad)
        csg=cos(EdwRealQuest(6,nEdwCell)*torad)
        pom=1.-csa**2-csb**2-csg**2+2.*csa*csb*csg
        if(pom.le.0.) then
          call FeChybne(-1.,-1.,'basic vectors are coplanar, try '//
     1                  'again',' ',0,SeriousError)
          EventType=EventEdw
          EventNumber=6
          go to 1036
        endif
        if(EdwRealQuest(1,nEdwCell).le.0..or.
     1     EdwRealQuest(2,nEdwCell).le.0..or.
     2     EdwRealQuest(3,nEdwCell).le.0.) then
          call FeChybne(-1.,-1.,'non-positive, try again',' ',0,
     1                  SeriousError)
          go to 1036
        endif
        go to 1020
1036    EventType=EventEdw
        EventNumber=nEdwCell
        go to 1020
      else if(CheckType.eq.EventCrw.and.CheckNumber.ge.nCrwTypeFr.and.
     1        CheckNumber.le.nCrwTypeTo) then
        if(Key.le.1) then
          t80=fln(:ifln)//mene(DiffOrderSel)
        else
          t80=fln(:ifln)//mene(NDiffTypes+1)
        endif
        DiffOrderSel=CheckNumber-nCrwTypeFr+1
        DifCode=DiffOrder(DiffOrderSel)
        if(EqIgCase(EdwStringQuest(nEdwFileName),t80)) then
          if(Key.le.1) then
            t80=fln(:ifln)//mene(DiffOrderSel)
          else
            t80=fln(:ifln)//mene(NDiffTypes+1)
          endif
          call FeQuestStringEdwOpen(nEdwFileName,t80)
        endif
        if(DifCode.ne.IdBrukerCCD) then
          if(EdwStateQuest(nEdwDim).eq.EdwClosed)
     1      call FeQuestIntEdwOpen(nEdwDim,ndim,.false.)
        else
          call FeQuestEdwClose(nEdwDim)
        endif
        if(DifCode.eq.IdKumaCCD.or.
     1     DifCode.eq.IdBrukerCCD) then
          nEdw=nEdwModFr
          do 1042i=1,3
            call FeQuestEdwClose(nEdw)
            nEdw=nEdw+1
1042      continue
        else
          nEdw=nEdwModFr
          do 1045i=1,3
            if(i.le.ndimi) then
              if(EdwStateQuest(nEdw).ne.EdwOpened)
     1           call FeQuestRealAEdwOpen(nEdw,QuDatRed(1,i,1),3,.true.,
     2                                   .true.)
            else
              call FeQuestEdwClose(nEdw)
            endif
            nEdw=nEdw+1
1045      continue
        endif
        if(DifCode.eq.IdIPDSStoe.or.DifCode.eq.IdNoniusCCD) then
          if(EdwStateQuest(nEdwCell).eq.EdwClosed) then
            LamAve(1)=.71073
            call FeQuestRealAEdwOpen(nEdwCell,CellDatRed,6,.false.,
     1                               .false.)
            call FeQuestRealEdwOpen(nEdwWaveLength,LamAve(1),.false.,
     1                             .false.)
          endif
        else
          call FeQuestEdwClose(nEdwCell)
          call FeQuestEdwClose(nEdwWaveLength)
        endif
        icont=0
        go to 1020
      else if(CheckType.eq.EventButton.and.CheckNumber.eq.nButBrowse)
     1  then
        if(Key.le.1) then
          t80='Select data collection file'
        else
          t80='Select psi-scans file'
        endif
        FileInDatRed=EdwStringQuest(nEdwFileName)
        call FeFileManager(t80,FileInDatRed,'*'//mene(DiffOrderSel),0,
     1                     .true.,ich)
        call FeQuestButtonOff(nButBrowse)
        go to 1015
      else if(CheckType.ne.0) then
        call NebylOsetren
        go to 1020
      endif
      if(ich.eq.0) then
        if(Key.ne.1) then
          if(DifCode.ne.IdKumaCCD.and.DifCode.ne.IdBrukerCCD) then
            do 1090i=nEdwModFr,nEdwModFr+ndimi-1
              call FeQuestRealAFromEdw(i,QuDatRed(1,i-nEdwModFr+1,1))
1090        continue
          endif
          if(DifCode.eq.IdIPDSStoe.or.DifCode.eq.IdNoniusCCD) then
            call FeQuestRealAFromEdw(nEdwCell,CellDatRed)
            call FeQuestRealFromEdw(nEdwWaveLength,LamAve(1))
            call DRSetCell
            CellVol(1,KPhase)=
     1        TrToOrtho(1,1,KPhase)*TrToOrtho(5,1,KPhase)*
     2                              TrToOrtho(9,1,KPhase)
          endif
          if(EdwStateQuest(nEdwMMax).eq.EdwOpened) then
            call FeQuestIntFromEdw(nEdwMMax,DRmmax)
            call FeQuestRealAFromEdw(nEdwDiffSat,DRDiffSat)
          endif
        endif
      endif
      call FeQuestRemove(id)
      if(ich.ne.0) then
        if(.not.ExistM95) call DeleteFile(fln(:ifln)//'.m94')
        ErrJana=1
        go to 9999
      endif
      if(ndim.ne.ndimo.and.ExistM95) then
        NInfo=2
        write(p80,'(i1)') ndimo
        call Zhusti(p80)
        write(t80,'(i1)') ndim
        call Zhusti(t80)
        TextInfo(1)='You have changed the dimension from '//p80(1:1)//
     1              ' to '//t80(1:1)//' and '
        TextInfo(2)='therefore old files M94, M95 and M96 will be '//
     1              'deleted'
        if(FeYesNoHeader(-1.,-1.,'Do you really want to continue?',0))
     1    then
          call DeleteFile(fln(:ifln)//'.m94')
          call DeleteFile(fln(:ifln)//'.m95')
          call DeleteFile(fln(:ifln)//'.m96')
          ExistM94=.false.
          ExistM95=.false.
          if(Key.eq.1) Key=0
          DifCode=IdKumaCCD
          ndim=3
          ndimq=9
          ndimi=0
        else
          go to 9999
        endif
      endif
      call CheckEOLOnFile(FileInDatRed,2)
      if(ErrJana.ne.0) go to 1000
      call OpenFile(71,FileInDatRed,'formatted','old')
      if(ErrJana.ne.0) go to 1000
      Profil=.false.
      ThOmRatio=2.
      Radiation(1)=XRayRadiation
      if(DifCode.eq.IdCAD4) then
1100    read(71,FormA80) t80
1110    if(idel(t80).lt.4) go to 1100
        if(ichar(t80(1:1)).lt.32) then
          t80=t80(2:)
          go to 1110
        endif
        if(t80(1:4).eq.'    ') go to 1100
        jentri=t80(4:4).eq.' '
        rewind 71
        call CtiCad
      else if(DifCode.eq.IdSiemensP4) then
        call CtiP4
      else if(DifCode.eq.IdIPDSStoe) then
        call CtiIpStoe
      else if(DifCode.eq.IdD9ILL) then
        call CtiMonstrum
      else if(DifCode.eq.IdHasyLabF1) then
        call CtiMonstrum
      else if(DifCode.eq.IdHasyLabHuber) then
        call CtiMonstrum
      else if(DifCode.eq.IdKumaCCD) then
        call CtiKumaCCD
      else if(DifCode.eq.IdKumaPD) then
        call CtiKumaPD
      else if(DifCode.eq.IdNoniusCCD) then
        call CtiNoniusCCD
      else if(DifCode.eq.IdBrukerCCD) then
        call CtiBrukerCCD
      else if(DifCode.eq.IdXDS) then
        call CtiXDS
      else if(DifCode.eq.99) then
        call CtiM91
      endif
      if(ErrJana.ne.0) go to 9000
      if(Key.gt.1) Profil=.false.
      call matinv(ub,ubi,pom,3)
      if(Key.eq.0.and.DifCode.ne.IdNoName) then
        if(ndim.gt.3.and.
     1     (DifCode.eq.IdCAD4.or.
     2      DifCode.eq.IdSiemensP4.or.
     3      DifCode.eq.IdD9ILL.or.
     4      DifCode.eq.IdHasyLabF1.or.
     4      DifCode.eq.IdHasyLabHuber.or.
     5      DifCode.eq.IdKumaPD)) then
1320      call EM50ReadCellCentr(ich)
          if(ich.ne.0) then
            call CoDalDR
            if(ErrJana.ne.0) then
              go to 9000
            else
              go to 1320
            endif
          endif
          call iom94(1)
        endif
        formula=' '
        nfaces=0
        radiusDatRed=0.
        do 1400j=2,3
          call CopyVek(CellDatRed(1,1),CellDatRed(1,j),6)
1400    continue
        if(ndim.gt.3) then
          do 1500k=2,3
            do 1480j=1,ndimi
              call CopyVek(QuDatRed(1,j,1),QuDatRed(1,j,k),3)
              if(k.eq.2) call CopyVek(QuDatRed(1,j,1),Qu(1,j,1,KPhase),
     1                                3)
1480        continue
1500      continue
        endif
        call UnitMat(trmp,ndim)
      endif
      call iom94(1)
      call iom94(0)
1900  t80='     0 reflections already read'
      do 1980j=1,ndimi
        call CopyVek(QuDatRed(1,j,1),Qu(1,j,1,KPhase),3)
1980  continue
      call FeTxOut(-1.,-1.,t80)
      if(nref956.le.0) expold=0.
      addtime=0.
      expos0=-1.
      noa=0
      PrvniCteni=.true.
      IntFromProfile=DifCode.eq.IdSiemensP4.or.DifCode.eq.IdKumaPD
      ns=1
      nread=0
      nref956o=nref956
      call SetRealArrayTo(corrf,2,1.)
      call SetIntArrayTo(iflg,2,1)
      tbar=1.
      KProf=0
      NProf=0
2000  nread=nread+1
2010  call ctiref(nread,ich)
      if(KProf.eq.1) call CopyVekI(IProf(1,1),IProf(1,2),NProf)
      if(ich.eq.1) then
        go to 2020
      else if(ich.eq.2) then
        go to 2050
      else if(ich.eq.3) then
        go to 3000
      else if(ich.eq.4) then
        go to 3000
      else if(ich.eq.5) then
        go to 2000
      endif
      ik=0
      go to 2021
2020  ik=1
2021  if(rs.le.0.) go to 2010
      nref956=nref956+1
      call DRPutReflectionToM95(95)
      if(mod(nread,50).eq.0) then
        write(t80(1:6),100) nread
        call FeTxOutCont(t80)
      endif
      if(ik.eq.0) go to 2000
2050  nread=nread-1
      write(t80(1:6),'(i6)') nread
      call FeTxOutCont(t80)
      call FeTxOutEnd
      if(nread+nref956o.eq.nref956) then
        NInfo=1
        write(Cislo,100) nread
        call Zhusti(Cislo)
        TextInfo(1)='All '//Cislo(:idel(Cislo))//
     1              ' measured reflections were properly handled'
      else
        NInfo=3
        write(Cislo,100) nread
        TextInfo(1)='From '//Cislo(:idel(Cislo))//
     1              ' measured reflections read'
        write(Cislo,100) nref956-nref956o
        TextInfo(2)='     '//Cislo(:idel(Cislo))//
     1              ' sucessefully handled'
        write(Cislo,100) nread-nref956+nref956o
        TextInfo(3)='     '//Cislo(:idel(Cislo))//' skipped'
      endif
      call FeInfoOut(-1.,-1.,'INFORMATION')
      CorrAbs=0
      if(DifCode.eq.IdCAD4.or.
     1   DifCode.eq.IdSiemensP4.or.DifCode.eq.IdKumaPD) then
        CorrLp=0
      else
        Corrlp=1
      endif
      if(Key.le.1) then
        nref95=nref956
        call iom94(1)
        ExistM94=.true.
        ExistM95=.true.
        call iom94(0)
      else
        call iom94(0)
        nref96=nref956
        call iom94(1)
        ExistM94=.true.
        ExistM96=.true.
      endif
      go to 9999
3000  call FeTxOutEnd
      if(ich.eq.3) then
        call FeReadError(71)
        ErrJana=1
        if(.not.ExistM94) call DeleteFile(fln(:ifln)//'.m94')
        go to 9000
      endif
      go to 9999
9000  if(.not.ExistM95) close(95,status='delete')
9999  call CloseIfOpened(71)
      call CloseIfOpened(95)
      ns=nsold
      return
100   format(i6)
      end
      subroutine NastavM95(Text,n,ich)
      include 'params.cmn'
      include 'basic.cmn'
      include 'datred.cmn'
      include 'fepc.cmn'
      character*(*) Text
      character*80 t80
      logical CrwLogicQuest,EqIgCase
      ich=0
      nn=0
      n=0
      call PrvniM95(ich)
      if(ich.ne.0) go to 9999
1000  read(95,format95,end=1100) no,(ih(i),i=1,ndim),uhly,ri,rs,
     1                           expom
      nn=nn+1
      read(95,'(a)',end=1100)
      nn=nn+1
      n=n+1
1050  read(95,FormA80,end=1100) t80
      k=0
      call kus(t80,k,Cislo)
      if(EqIgCase(Cislo(1:4),'prof')) then
        nn=nn+1
        go to 1050
      endif
      backspace 95
      expold=expom
      go to 1000
1100  rewind 95
      if(n.gt.0) then
        write(Cislo,'(i10)') n
        call Zhusti(Cislo)
        t80=Text(:idel(Text))//' already contains '//
     1      Cislo(1:idel(Cislo))//' reflections'
        id=NextQuestId()
        call FeQuestCreate(id,-1.,-1.,200.,0,2,t80,0,LightGray,0,0)
        call FeQuestCrwMake(id, 60.,1, 56.,2,'%Append' ,'C',CrwgXd,
     1                      CrwgYd,0,1)
        nCrwAppend=CrwLastMade
        call FeQuestCrwOpen(CrwLastMade,.true.)
        call FeQuestCrwMake(id,140.,1,136.,2,'%Rewrite','C',CrwgXd,
     1                      CrwgYd,0,1)
        nCrwRewrite=CrwLastMade
        call FeQuestCrwOpen(CrwLastMade,.false.)
        icont=0
1500    call FeQuestEvent(id,icont,ich)
        icont=1
        if(CheckType.ne.0) then
          call NebylOsetren
          go to 1500
        endif
        if(ich.eq.0) then
          if(CrwLogicQuest(nCrwRewrite)) then
            n=0
          else
            do 1520i=1,nn
              read(95,'(a)')
1520        continue
          endif
        endif
        call FeQuestRemove(id)
      endif
9999  return
      end
      subroutine PrvniM95(ich)
      include 'params.cmn'
      include 'basic.cmn'
      include 'datred.cmn'
      include 'fepc.cmn'
      character*80 Veta,ZalozniSoubor,PuvodniSoubor
      character*6  Stat
      logical FeYesNoHeader
500   ich=0
      it=0
      read(95,FormA80,end=9990,err=9010) Veta
      if(Veta.ne.ImportTextB) then
        rewind 95
        go to 2000
      else
        it=1
1000    read(95,FormA80,end=9000,err=9010) Veta
        it=it+1
        if(Veta.ne.ImportTextE) go to 1000
      endif
2000  read(95,FormA80,end=9990,err=9010) Veta
      if(index(Veta,'E').le.0.and.index(Veta,'e').le.0) then
        inquire(95,name=PuvodniSoubor)
        i=index(PuvodniSoubor,'.')
        if(i.le.0) then
          i=idel(PuvodniSoubor)
        else
          i=i-1
        endif
        ZalozniSoubor=PuvodniSoubor(:i)//'.r95'
        Ninfo=4
        TextInfo(1)=PuvodniSoubor
        TextInfo(2)='The program has detected the Jana98 format for '//
     1              'this m95 file.'
        TextInfo(3)='The file will be transformed into the new format'//
     1              ' and the old'
        TextInfo(4)='one can be saved on request.'
        call CloseIfOpened(95)
        if(FeYesNoHeader(-1.,-1.,'Do you want to save the old file?',0))
     1    then
          Stat='keep'
          call FeFileManager('Select file name for the old m95 file',
     1                       ZalozniSoubor,'*.*',0,.true.,ich)
          if(ich.ne.0) go to 9999
        else
          Stat='delete'
        endif
        call CopyFile(PuvodniSoubor,ZalozniSoubor)
        call OpenFile(96,ZalozniSoubor,'formatted','old')
        call OpenFile(95,PuvodniSoubor,'formatted','unknown')
        do 2100i=1,it
          read(96,FormA80,err=9020) Veta
          write(95,FormA80) Veta
2100    continue
2200    read(96,Format95Old,err=9020,end=2500)
     1    no,(ih(i),i=1,ndim),uhly,ri,rs,expos,iflg,corrf,tbar,
     2    dircos
        write(95,Format95)
     1    no,(ih(i),i=1,ndim),uhly,ri,rs,expos,iflg,corrf,tbar,
     2    dircos
        go to 2200
2500    close(96,status=Stat)
        rewind(95)
        go to 500
      else
        backspace 95
        go to 9999
      endif
9000  call FeChybne(-1.,-1.,'M95 has incorrect import header',' ',0,
     1              SeriousError)
      go to 9900
9010  i=95
      go to 9050
9020  i=96
9050  call FeReadError(i)
      if(i.eq.96) call CloseIfOpened(95)
      call MoveFile(ZalozniSoubor,PuvodniSoubor,.false.)
9900  ich=1
      go to 9999
9990  rewind 95
9999  return
      end
      subroutine CoDalDR
      include 'params.cmn'
      include 'basic.cmn'
      logical FeYesNo
      call FeMsgOut(-1.,-1.,'Information is necessary to continue work')
      if(FeYesNo(-1.,-1.,'Do you want to quit Datred program?',0))
     1   ErrJana=1
      return
      end
      subroutine DRSetCell
      include 'params.cmn'
      include 'basic.cmn'
      include 'datred.cmn'
      do 1500j=1,3
        do 1200i=1,3
          rcp(i,j,KPhase)=CellDatRed(i,j)
          rcp(i+3,j,KPhase)=cos(CellDatRed(i+3,j)*torad)
1200    continue
        call recip(rcp(1,j,KPhase),rcp(1,j,KPhase),pom)
        do 1300i=1,3
          prcp(i,j,KPhase)=.25*rcp(i,j,KPhase)**2
1300    continue
        prcp(4,j,KPhase)=.5*rcp(1,j,KPhase)*rcp(2,j,KPhase)*
     1                                      rcp(6,j,KPhase)
        prcp(5,j,KPhase)=.5*rcp(1,j,KPhase)*rcp(3,j,KPhase)*
     1                                      rcp(5,j,KPhase)
        prcp(6,j,KPhase)=.5*rcp(2,j,KPhase)*rcp(3,j,KPhase)*
     1                                      rcp(4,j,KPhase)
1500  continue
      csa=cos(CellDatRed(4,1)*torad)
      csb=cos(CellDatRed(5,1)*torad)
      csg=cos(CellDatRed(6,1)*torad)
      snb=sqrt(1.-csb**2)
      sng=sqrt(1.-csg**2)
      pom=(csa-csb*csg)/sng
      TrToOrtho(1,1,KPhase)=CellDatRed(1,1)
      TrToOrtho(2,1,KPhase)=0.
      TrToOrtho(3,1,KPhase)=0.
      TrToOrtho(4,1,KPhase)=CellDatRed(2,1)*csg
      TrToOrtho(5,1,KPhase)=CellDatRed(2,1)*sng
      TrToOrtho(6,1,KPhase)=0.
      TrToOrtho(7,1,KPhase)=CellDatRed(3,1)*csb
      TrToOrtho(8,1,KPhase)=CellDatRed(3,1)*pom
      TrToOrtho(9,1,KPhase)=CellDatRed(3,1)*snb*sqrt(1.-(pom/snb)**2)
      MetTens(1,1,KPhase)=CellDatRed(1,1)**2
      MetTens(5,1,KPhase)=CellDatRed(2,1)**2
      MetTens(9,1,KPhase)=CellDatRed(3,1)**2
      MetTens(2,1,KPhase)=CellDatRed(1,1)*CellDatRed(2,1)*csg
      MetTens(4,1,KPhase)=MetTens(2,1,KPhase)
      MetTens(3,1,KPhase)=CellDatRed(1,1)*CellDatRed(3,1)*csb
      MetTens(7,1,KPhase)=MetTens(3,1,KPhase)
      MetTens(6,1,KPhase)=CellDatRed(2,1)*CellDatRed(3,1)*csa
      MetTens(8,1,KPhase)=MetTens(6,1,KPhase)
      call matinv(MetTens(1,1,KPhase),MetTensI(1,1,KPhase),pom,3)
      CellVol(1,KPhase)=TrToOrtho(1,1,KPhase)*TrToOrtho(5,1,KPhase)*
     1                                        TrToOrtho(9,1,KPhase)
      return
      end
      subroutine CtiCad
      include 'params.cmn'
      include 'basic.cmn'
      include 'datred.cmn'
      include 'profil.cmn'
      include 'fepc.cmn'
      dimension dfa(2)
      character*80 veta
      logical FeYesNo
      call vetacad(veta,31,1,*9000,*9100)
      read(veta,100,err=9100)((ub(i,j,1),j=1,3),i=1,2)
      call vetacad(veta,32,1,*9000,*9100)
      read(veta,100,err=9100)(ub(3,j,1),j=1,3),dfa,attfac
      LamAve(1)=(2.*dfa(1)+dfa(2))/3.
      call CellFromUB
      call vetacad(veta,26,1,*9000,*9100)
      read(veta,'(35x,2f10.7)',err=9100) snalfaq,csalfa
      snalfa=sqrt(snalfaq)
      csalfaq=csalfa**2
      call vetacad(veta,22,1,*9000,*9100)
      read(veta,'(16x,2f5.2,10x,i2,6x,f6.3,6x,i2)',err=9100)
     1  doma,domb,i,pom,CAD4ProfFlag
      ThOmRatio=float(i)*.333333
      Profil=CAD4ProfFlag.ne.0
      if(CAD4ProfFlag.eq.1) then
        CAD4ProfFormat='(4(i5,2i4))'
      else if(CAD4ProfFlag.eq.4) then
        CAD4ProfFormat='(2x,12i5)'
      else if(CAD4ProfFlag.eq.6) then
        CAD4ProfFormat='(2x,12z5)'
      else
        Profil=.false.
        CAD4ProfFormat=' '
      endif
      if(pom.lt.0.) then
        BerBPB=.not.FeYesNo(-1.,-1.,'Do you want to use I and '//
     1                      'sig(I) from profile analysis?',0)
      else
        BerBPB=.true.
      endif
1200  call vetacad(veta,23,1,*9000,*9100)
      read(veta,'(4x,i2)',err=9100) NonEqCheck
      call SetRealArrayTo(SenseOfAngle,4,-1.)
      PocitatDirCos=.true.
      DirCosFromPsi=.false.
      go to 9999
9000  call FeChybne(-1.,-1.,'CAD4 - basic information missing',' ',0,
     1              SeriousError)
      go to 9900
9100  call FeReadError(71)
9900  ErrJana=1
9999  return
100   format(4x,2(2x,3f9.6))
      end
      subroutine CellFromUB
      include 'params.cmn'
      include 'basic.cmn'
      include 'datred.cmn'
      dimension ubt(9)
      call trmat(ub,ubt,3,3)
      call multm(ubt,ub,MetTensI(1,1,KPhase),3,3,3)
      call matinv(MetTensI(1,1,KPhase),MetTens(1,1,KPhase),pom,3)
      do 1000i=1,3
        CellDatRed(i,1)=sqrt(MetTens(4*(i-1)+1,1,KPhase))
1000  continue
      CellDatRed(4,1)=acos(MetTens(6,1,KPhase)/
     1                     (CellDatRed(2,1)*CellDatRed(3,1)))/torad
      CellDatRed(5,1)=acos(MetTens(3,1,KPhase)/
     1                     (CellDatRed(1,1)*CellDatRed(3,1)))/torad
      CellDatRed(6,1)=acos(MetTens(2,1,KPhase)/
     1                     (CellDatRed(1,1)*CellDatRed(2,1)))/torad
      return
      end
      subroutine ctip4
      include 'params.cmn'
      include 'basic.cmn'
      include 'datred.cmn'
      dimension idn(7),rmp(9),rmpp(9),rr(9)
      character*8  nazev,id(7)
      character*80 t80
      data id/'cell','ort1','ort2','ort3','source','qvec','latvec'/,
     1     idn/5*0,2*-1/
      data rmp/1.,0.,1.,1.,0.,-1.,0.,1.,0./
      call SetRealArrayTo(SenseOfAngle,4,1.)
      SenseOfAngle(1)=-1.
      PocitatDirCos=.true.
      DirCosFromPsi=.false.      
      KdoToVola=0
      go to 900
      entry CtiBrukerCCD
      KdoToVola=1
      call OpenFile(72,FileInDatRed(:idel(FileInDatRed)-4)//'.p4p',
     1              'formatted','old')
      if(ErrJana.ne.0) go to 9500
      PocitatDirCos=.false.
      DirCosFromPsi=.false.
900   ln=71+KdoToVola
      rewind ln
      nvt=0
      ndimi=0
1000  read(ln,FormA80,end=8000) t80
      call mala(t80)
      k=0
      call kus(t80,k,nazev)
      if(nazev.eq.'data') go to 8000
      i=islovo(nazev,id,7)
      if(i.le.0) go to 1000
      idn(i)=1
      if(i.eq.1) then
        call StToReal(t80,k,CellDatRed,6,.false.,ich)
        if(ich.ne.0) go to 9100
      else if(i.gt.1.and.i.le.4) then
        do 1200j=1,3
          call StToReal(t80,k,ub(i-1,j,1),1,.false.,ich)
          if(ich.ne.0) go to 9100
          if(i.le.3) ub(i-1,j,1)=-ub(i-1,j,1)
c     matice pro Siemens definovana jinak uprava prevadi na definici
c     CAD4 a novy Hilger
1200    continue
      else if(i.eq.5) then
        call kus(t80,k,Cislo)
        call StToReal(t80,k,LamAve(1),1,.false.,ich)
        if(ich.ne.0) go to 9100
      else if(i.eq.6) then
        ndimi=ndimi+1
        call StToReal(t80,k,QuDatRed(1,ndimi,1),3,.false.,ich)
        if(ich.ne.0) go to 9100
      else if(i.eq.7) then
        nvt=nvt+1
        call StToReal(t80,k,vt6(1,nvt,1,1),6,.false.,ich)
        if(ich.ne.0) go to 9100
      endif
      go to 1000
8000  continue
      ndim=3+ndimi
      ndimq=ndim**2
      if(nvt.eq.0) then
        nvt=1
        call SetRealArrayTo(vt6,ndim,0.)
      endif
      do 8100i=1,5
        if(idn(i).eq.0) go to 9000
8100  continue
      Profil=KdoToVola.eq.0
      go to 9999
9000  if(KdoToVola.eq.0) then
        Cislo='p4o'
      else
        Cislo='p4p'
      endif
      call FeChybne(-1.,-1.,'the "'//Cislo(:idel(Cislo))//
     1              '" file doesn''t contain basic information',' ',0,
     2              SeriousError)
      go to 9500
9100  call FeChybne(-1.,-1.,'the syntactic error in the following line',
     1              t80,0,SeriousError)
9500  ErrJana=1
9999  if(KdoToVola.ne.0) call CloseIfOpened(ln)
      ndstoe=3
      FormatInDatRed='(3i4,2f8.2,4x,6f8.5)'
      if(ndimi.ne.0) then
        ndstoe=6
        FormatInDatRed(2:2)='6'
      endif
      return
101   format(f15.0)
102   format(e15.0)
      end
      subroutine CtiIpStoe
      include 'params.cmn'
      include 'basic.cmn'
      include 'datred.cmn'
      ncomp=1
      call matinv(TrToOrtho(1,1,KPhase),ub(1,1,1),pom,3)
      FormatInDatRed='(.i4,2f8.2,4x,6f8.5)'
      if(ndim.eq.3) then
        ndstoe=3
      else
        ndstoe=6
      endif
      write(FormatInDatRed(2:2),'(i1)') ndstoe
      DirCosFromPsi=.false.
      PocitatDirCos=.false.
      return
      end
      subroutine CtiNoniusCCD
      include 'params.cmn'
      include 'basic.cmn'
      include 'datred.cmn'
      ncomp=1
      call matinv(TrToOrtho(1,1,KPhase),ub(1,1,1),pom,3)
      FormatInDatRed='(.i4,2f8.2,4x,6f8.5)'
      ndstoe=ndim
      write(FormatInDatRed(2:2),'(i1)') ndstoe
      DirCosFromPsi=.false.
      PocitatDirCos=.false.
      return
      end
      subroutine CtiMonstrum
      include 'params.cmn'
      include 'basic.cmn'
      include 'datred.cmn'
      include 'fepc.cmn'
      dimension xp(3),ip(3)
      character*80 t80,FileInMat
      character*2  nty
      logical FileReadIn,ExistFile,EqIgCase,CrwLogicQuest,FeYesNoHeader
      equivalence (xp,ip)
      nstd=0
      call SetIntArrayTo(ihs,60,0)
      KappaGeom=.false.
      ii=index(FileInDatRed,'.')-1
      if(ii.le.0) ii=idel(FileInDatRed)
      if(DifCode.eq.IdD9ILL) then
        FileInMat=FileInDatRed(:ii)//'.ubm'
        if(ExistFile(FileInMat)) then
          call CheckEOLOnFile(FileInMat,2)
          call OpenFile(70,FileInMat,'formatted','unknown')
          if(ErrJana.ne.0) go to 1070
1000      read(70,FormA80,end=1015) t80
          call Mala(t80)
          i=index(t80,'wavelength')
          if(i.le.0) go to 1000
          k=0
          do 1010j=1,3
            call kus(t80,k,Cislo)
1010      continue
          call posun(Cislo,1)
          read(Cislo,'(f15.0)') LamAve(1)
1015      rewind 70
1020      read(70,FormA80,end=1070) t80
          call Mala(t80)
          i=index(t80,'final orientation [ub] matrix')
          if(i.le.0) go to 1020
          read(70,FormA80,end=1070) t80
          do 1050i=1,3
            read(70,FormA80,end=1070) t80
            k=0
            call StToReal(t80,k,xp,3,.false.,ich)
            if(ich.ne.0) go to 1070
            do 1040j=1,3
              ub(i,j,1)=xp(j)
1040        continue
1050      continue
          call CloseIfOpened(70)
          FileReadIn=.true.
          go to 1300
        endif
1070    call CloseIfOpened(70)
      endif
      FileInMat=FileInDatRed(:ii)//'.mat'
      if(ExistFile(FileInMat)) then
        FileReadIn=.true.
        call CheckEOLOnFile(FileInMat,2)
        if(ErrJana.ne.0) go to 1200
        call OpenFile(70,FileInMat,'formatted','old')
        if(ErrJana.ne.0) go to 1200
        do 1120i=1,3
          read(70,FormA80,end=1200) t80
          k=0
          call StToReal(t80,k,xp,3,.false.,ich)
          if(ich.ne.0) go to 1200
          do 1110j=1,3
            ub(i,j,1)=xp(j)
1110      continue
1120    continue
        read(70,FormA80,end=1200) t80
        k=0
        call StToReal(t80,k,LamAve(1),1,.false.,ich)
        if(ich.ne.0) go to 1200
        call StToInt(t80,k,ip,1,.false.,ich)
        if(ich.eq.0) then
          KappaGeom=ip(1).ne.0
        else
          go to 1140
        endif
        call StToInt(t80,k,ip,1,.false.,ich)
        if(ich.eq.0) iskipHasy=ip(1)
1140    read(70,FormA80,err=1300,end=1300) t80
        call mala(t80)
        if(EqIgCase(t80,'end')) go to 1300
        if(nstd.ge.10) go to 1300
        nstd=nstd+1
        k=0
        call StToInt(t80,k,ihs(1,nstd),3,.false.,ich)
        if(ich.ne.0) go to 1200
        go to 1140
      endif
1200  FileReadIn=.false.
      call SetRealArrayTo(ub,9,0.)
      LamAve(1)=1.
      iskipHasy=0
      KappaGeom=.false.
1300  call CloseIfOpened(70)
      id=NextQuestId()
      xqd=210.
      il=9
      t80='Define basic data for the data collection'
      call FeQuestCreate(id,-1.,-1.,xqd,0,il,t80,0,LightGray,0,0)
      tpom=5.
      t80='Orientation matrix: %... row'
      xpom=tpom+FeTxLengthUnder(t80)+5.
      dpom=xqd-xpom-5.
      il=0
      do 1410i=1,3
        il=il+1
        write(t80(22:24),'(i1,a2)') i,nty(i)
        call FeQuestEdwMake(id,tpom,il,xpom,il,t80,'L',dpom,EdwYd,0)
        do 1400j=1,3
          xp(j)=ub(i,j,1)
1400    continue
        if(i.eq.1) then
          t80(:20)=' '
          nEdwOrMatFirst=EdwLastMade
        endif
        call FeQuestRealAEdwOpen(EdwLastMade,xp,3,.not.FileReadIn,
     1                           .false.)
1410  continue
      il=il+1
      t80='%Wave length:'
      dpom=50.
      call FeQuestEdwMake(id,tpom,il,xpom,il,t80,'L',dpom,EdwYd,0)
      nEdwWaveLength=EdwLastMade
      call FeQuestRealEdwOpen(EdwLastMade,LamAve(1),.not.FileReadIn,
     1                        .false.)
      il=il+1
      if(DifCode.eq.IdHasyLabF1) then
        t80='%Kappa geometry used'
        xpom=tpom+FeTxLengthUnder(t80)+3.
        call FeQuestCrwMake(id,tpom,il,xpom,il,t80,'L',CrwXd,CrwYd,0,0)
        nCrwKappa=CrwLastMade
        call FeQuestCrwOpen(CrwLastMade,KappaGeom)
        tpom=xpom+CrwXd+15.
      else
        nCrwKappa=0
        tpom=5.
      endif
      t80='%Number of standard reflections'
      xpom=tpom+FeTxLengthUnder(t80)+3.
      dpom=15.
      call FeQuestEudMake(id,tpom,il,xpom,il,t80,'L',dpom,EdwYd,1)
      nEdwNstd=EdwLastMade
      call FeQuestIntEdwOpen(EdwLastMade,nstd,.not.FileReadIn)
      call FeQuestEudOpen(EdwLastMade,0,10,1,0.,0.,0.)
      tpom=5.
      t80='#11'
      xpom=tpom+FeTxLength(t80)+3.
      spom=xqd/3.
      dpom=spom-xpom-5.
      do 1420i=1,10
        if(mod(i,3).eq.1) il=il+1
        write(t80,'(''#'',i2)') i
        call Zhusti(t80)
        call FeQuestEdwMake(id,tpom,il,xpom,il,t80,'L',dpom,EdwYd,0)
        if(i.eq.1) nEdwStd=EdwLastMade
        if(mod(i,3).eq.0) then
          tpom=tpom-2.*spom
          xpom=xpom-2.*spom
        else
          tpom=tpom+spom
          xpom=xpom+spom
        endif
        call FeQuestStringEdwOpen(EdwLastMade,' ')
1420  continue
1450  nEdw=nEdwStd
      do 1460i=1,10
        if(i.le.nstd) then
          k=0
          do 1455j=1,3
            k=k+iabs(ihs(j,i))
1455      continue
          call FeQuestIntAEdwOpen(nEdw,ihs(1,i),3,k.eq.0)
        else
          call FeQuestEdwClose(nEdw)
        endif
        nEdw=nEdw+1
1460  continue
      icont=0
1500  call FeQuestEvent(id,icont,ich)
      icont=1
      if(CheckType.eq.EventEdw.and.CheckNumber.eq.nEdwNstd) then
        call FeQuestIntFromEdw(nEdwNstd,nstd)
        go to 1450
      else if(CheckType.ne.0) then
        call NebylOsetren
        go to 1500
      endif
      if(ich.eq.0) then
        nEdw=nEdwOrMatFirst
        do 1520i=1,3
          call FeQuestRealAFromEdw(nEdw,xp)
          do 1510j=1,3
            ub(i,j,1)=xp(j)
1510      continue
          nEdw=nEdw+1
1520    continue
        NInfo=1
        call CellFromUB
        NInfo=2
        TextInfo(1)='Cell parameters derived the from orientation '//
     1              'matrix'
        write(TextInfo(2),'(3f9.3,3f8.2)')(CellDatRed(j,1),j=1,6)
        if(.not.FeYesNoHeader(-1.,-1.,'Do you want to continue?',1))
     1    then
          call FeButtonOff(ButtonOK)
          go to 1450
        endif
        call FeQuestRealFromEdw(nEdwWaveLength,LamAve(1))
        KappaGeom=CrwLogicQuest(nCrwKappa)
        call FeQuestIntFromEdw(nEdwNstd,nstd)
        nEdw=nEdwStd
        do 1530i=1,nstd
          call FeQuestIntFromEdw(nEdw,ihs(1,i))
          nEdw=nEdw+1
1530    continue
      endif
      call FeQuestRemove(id)
      if(ich.ne.0) go to 9900
      FileInMat=FileInDatRed(:ii)//'.mat'
      call OpenFile(70,FileInMat,'formatted','unknown')
      write(70,'(3f10.6)')((ub(i,j,1),j=1,3),i=1,3)
      if(KappaGeom) then
        i=1
      else
        i=0
      endif
      write(70,'(f9.5,2i2)') LamAve(1),i,iskipHasy
      do 1550i=1,nstd
        write(70,'(6i4)')(ihs(j,i),j=1,3)
1550  continue
      call DeleteFile(FileInDatRed(:ii)//'.ubm')
      PocitatDirCos=.true.
      DirCosFromPsi=.false.
      call SetRealArrayTo(SenseOfAngle,4,-1.)
      SenseOfAngle(2)=1.
      if(DifCode.eq.IdD9ILL) then
        zn=-1.
      else
        zn= 1.
      endif
      do 1600j=1,3
        pom=ub(1,j,1)
        ub(1,j,1)=zn*ub(2,j,1)
        ub(2,j,1)=pom
1600  continue
      do 1650j=1,3
        ub(3,j,1)=-ub(3,j,1)
1650  continue
      if(KappaGeom) then
        csalfa =cos(60.*torad)
        csalfaq=csalfa**2
        snalfa=sin(60.*torad)
        snalfaq=snalfa**2
      endif
      go to 9999
9000  call FeChybne(-1.,-1.,'during reading of the file '//fln(:ifln)//
     1              '.mat',' ',0,SeriousError)
9900  ErrJana=1
      go to 9999
9999  return
      end
      subroutine CtiKumaCCD
      include 'params.cmn'
      include 'basic.cmn'
      include 'datred.cmn'
      include 'fepc.cmn'
      character*120 radka
      character*2   nty
      integer Vyskyt
      logical FeYesNoHeader,Zprava,FeYesNo
      dimension QuKuma(3),UBKuma(3,3),Trp(36),pa(3,3),pq(3)
      FormatInDatRed='(.i4,2f8.4,4x,6f8.5)'
      write(FormatInDatRed(2:2),'(i1)') min(ndim,4)
      ip=1
400   i=index(FileInDatRed(ip:),'.')
      if(i.gt.0) then
        ip=ip+i
        go to 400
      endif
      if(ip.le.1) then
        ip=idel(FileInDatRed)
      else
        ip=ip-2
      endif
      Radka=FileInDatRed(:ip)//'.sum'
      call CheckEOLOnFile(Radka,2)
      if(ErrJana.ne.0) go to 9999
      call OpenFile(70,Radka,'formatted','old')
      if(ErrJana.ne.0) go to 9999
      Vyskyt=0
500   read(70,101,end=5000) radka
      if(Radka.eq.' ') go to 500
      if(radka(1:14).eq.'   U - MATRIX:'.or.
     1   radka(1:15).eq.'   UB - MATRIX:') then
        do 600i=1,3
510       read(70,101,end=9000) radka
          if(Radka.eq.' ') go to 510
          k=1
          do 550j=1,3
            call kus(radka,k,cislo)
            call posun(cislo,1)
            read(cislo,100,err=9000) UBKuma(i,j)
            if(k.ge.len(radka).and.k.lt.3) go to 9000
550       continue
600     continue
        Vyskyt=Vyskyt+1
        go to 500
      else if(radka(1:17).eq.'WAVELENGTH (ANG):'.and.nref956.le.0) then
        LamA1(1)=0.
        LamA2(1)=0.
        LamAve(1)=0.
        k=18
        kt=0
620     call kus(radka,k,cislo)
        if(cislo.eq.'A1')then
          kt=1
        else if(cislo.eq.'A2')then
          kt=2
        else
          if(kt.ne.0) call posun(cislo,1)
          if(kt.eq.1) read(cislo,100,err=9000) LamA1(1)
          if(kt.eq.2) read(cislo,100,err=9000) LamA2(1)
          kt=0
        endif
        if(k.lt.len(radka)) go to 620
        if(LamA1(1).le.0.)then
          TextInfo(1) = 'Information about wavelength '//
     1      'not found.'
          TextInfo(2) = 'Cannot calculate cell parameters'
          NInfo = 2
          call FeInfoOut(-1.,-1.,'Warning')
        else
          if(LamA2(1).le.0.) then
            LamAve(1)=LamA1(1)
            LamA1(1)=0.
          else
            LamAve(1)=(2.*LamA1(1)+LamA2(1))/3.
          endif
        endif
        go to 500
      else if(radka(1:14).eq.'MONOCHROMATOR '.and.nref956.le.0) then
        ipis=0
        k=15
640     call kus(radka,k,cislo)
        if(cislo.eq.'(DEG)') then
          ipis=1
        else
          if(ipis.ne.1) go to 640
          call posun(cislo,1)
          read(cislo,100,err=9000) Uhmon(1)
        endif
        if(k.lt.len(radka)) go to 640
      else if(radka(1:31).eq.'Incommensurate integration: q =') then
        k=32
        do 2000i=1,3
          call kus(Radka,k,Cislo)
          call posun(Cislo,1)
          read(Cislo,100,err=9000) QuKuma(i)
          call kus(Radka,k,Cislo)
          call kus(Radka,k,Cislo)
2000    continue
      endif
      go to 500
5000  if(Vyskyt.gt.1) then
        write(Cislo,FormI15) Vyskyt
        call Zhusti(Cislo)
        Radka='Your sum file consists of '//Cislo(:idel(Cislo))//
     1        ' appended data reduction runs.'
        call FeChybne(-1.,-1.,Radka,'DATRED will use the last run.',0,
     1                Warning)
      endif
      do 5035i=1,3
        do 5030j=1,3
          if(LamAve(1).gt.0.) UBKuma(i,j)=UBKuma(i,j)/LamA1(1)
5030    continue
5035  continue
      if(nref956.le.0) then
        call CopyVek(QuKuma,quDatRed,3)
        call CopyMat(UBKuma,ub,3)
        call CellFromUB
        if(ndimi.gt.1) then
          id=NextQuestId()
          call FeQuestCreate(id,-1.,-1.,180.,0,ndimi,
     1                      'Complete/modify modulation vectors',0,
     2                       LightGray,0,0)
          Radka='%1st modulation vector'
          xpom=FeTxLengthUnder(Radka)+10.
          do 5100i=1,ndimi
            write(Radka(2:4),'(i1,a2)') i,nty(i)
            call FeQuestEdwMake(id,5.,i,xpom,i,Radka,'L',175.-xpom,
     1                          EdwYd,0)
            if(i.eq.1) nEdwQ=EdwLastMade
            call FeQuestRealAEdwOpen(EdwLastMade,QuDatRed(1,i,1),3,
     1                               i.gt.1,.false.)
5100      continue
          icont=0
5200      call FeQuestEvent(id,icont,ich)
          icont=1
          if(CheckType.ne.0) then
            call NebylOsetren
            go to 5200
          endif
          if(ich.eq.0) then
            nEdw=nEdwQ
            do 5250i=1,ndimi
              call FeQuestRealAFromEdw(nEdw,QuDatRed(1,i,1))
              nEdw=nEdw+1
5250        continue
          endif
          call FeQuestRemove(id)
          if(ich.ne.0) go to 9100
        endif
      endif
      if(ndimi.le.1) then
        call UnitMatI(TrKuma,ndim)
      else
        call Matinv(ub,ubi,pom,3)
        call Multm(ubi,UBKuma,pa,3,3,3)
        k=0
        do 5310i=1,ndim
          do 5300j=1,ndim
            k=k+1
            if(i.le.3.and.j.le.3) then
              Trp(k)=pa(i,j)
            else
              if(i.eq.j) then
                Trp(k)=1.
              else
                Trp(k)=0.
              endif
            endif
5300      continue
5310    continue
        n1=0
        n2=0
        k1=0
        k2=0
        if(ndim.gt.4) then
          k1=-1
          k2= 1
          if(ndim.gt.5) then
            n1=-1
            n2= 1
          endif
        endif
        SumMin=999999.
        do 6400n=n1,n2
          do 6300k=k1,k2
            do 6200j=-1,1
              Sum=0.
              do 6100l=1,3
                pq(l)=QuKuma(l)-float(j)*QuDatRed(l,1,1)
                if(ndim.gt.4)
     1            pq(l)=pq(l)-float(k)*QuDatRed(l,2,1)
                if(ndim.gt.5)
     1            pq(l)=pq(l)-float(n)*QuDatRed(l,3,1)
                Sum=Sum+abs(pq(l)-anint(pq(l)))
6100          continue
              if(Sum.lt.SumMin) then
                l=4
                do 6150ll=1,3
                  trp(l)=pq(ll)
                  l=l+ndim
6150            continue
                trp(l)=j
                if(ndim.gt.4) then
                  l=l+ndim
                  trp(l)=k
                  if(ndim.gt.5) then
                    l=l+ndim
                    trp(l)=n
                  endif
                endif
                SumMin=Sum
              endif
6200        continue
6300      continue
6400    continue
        Zprava=.false.
        do 6500i=1,ndimq
          TrKuma(i)=nint(trp(i))
          if(abs(trp(i)-float(TrKuma(i))).gt..0001) Zprava=.true.
6500    continue
        if(Zprava) then
          Ninfo=ndim+1
          TextInfo(1)='The transformation matrix 4d->.d deviates'
          TextInfo(2)='         too much from integers:'
          write(TextInfo(1)(31:31),'(i1)') ndim
          do 6520i=1,ndim-1
            write(TextInfo(i+2),'(6f8.4)')
     1        (trp(j),j=i,i+ndimq-ndim,ndim)
6520      continue
          if(.not.FeYesNoHeader(-1.,-1.,'Do you want to continue '//
     1                          'anyhow?',0)) go to 9100
        endif
        SkipMain=FeYesNo(-1.,-1.,'Do you want to skip main '//
     1                   'reflections?',0)
      endif
      go to 9999
9000  call FeReadError(70)
9100  ErrJana=1
      go to 9999
9999  call CloseIfOpened(70)
      DirCosFromPsi=.false.
      PocitatDirCos=.false.
      return
100   format(f15.0)
101   format(a)
      end
      subroutine CtiKumaPD
      include 'params.cmn'
      include 'basic.cmn'
      include 'datred.cmn'
      dimension xp(3)
      character*80 Radka
      Profil=.true.
      doma=-9999.
      domb=-9999.
      domc=-9999.
      n=0
      j=0
1000  if(n.ge.131) go to 2000
      read(71,FormA80,end=9000,err=9100) Radka
      call Mala(Radka)
      if(Radka(1:1).eq.'p') then
        k=1
        call Kus(Radka,k,Cislo)
        if(Cislo.ne.'wave') go to 1000
        call Kus(Radka,k,Cislo)
        if(Cislo.ne.'length') go to 1000
        call Kus(Radka,k,Cislo)
        if(Cislo.ne.'wl') go to 1000
        call StToReal(Radka,k,xp,2,.false.,ich)
        if(ich.ne.0) go to 9000
        LamAve(1)=(2.*xp(1)+xp(2))/3.
        n=n+1
      else if(Radka(1:1).eq.'u') then
        k=1
        call StToReal(Radka,k,xp,3,.false.,ich)
        if(ich.ne.0) go to 9000
        j=j+1
        n=n+10
        do 1100i=1,3
          ub(j,i,1)=xp(i)
1100    continue
      else if(Radka(1:1).eq.'j') then
        k=1
        n=n+100
        call Kus(Radka,k,Cislo)
        if(Cislo.ne.'attenuation') go to 1000
        call Kus(Radka,k,Cislo)
        if(Cislo.ne.'factor') go to 1000
        call StToReal(Radka,k,xp,1,.false.,ich)
        if(ich.ne.0) go to 9000
        AttFac=xp(1)
        call Kus(Radka,k,Cislo)
        if(Cislo.ne.'alpha') go to 1000
        call StToReal(Radka,k,xp,1,.false.,ich)
        if(ich.ne.0) go to 9000
        AlphaKuma=xp(1)
        call Kus(Radka,k,Cislo)
        if(Cislo.ne.'beta') go to 1000
        call StToReal(Radka,k,xp,1,.false.,ich)
        if(ich.ne.0) go to 9000
        BetaKuma=xp(1)
      endif
      go to 1000
2000  pom=1./LamAve(1)
      do 2200i=1,3
        do 2100j=1,3
          ub(j,i,1)=ub(j,i,1)*pom
2100    continue
2200  continue
      call CellFromUB
      call SetRealArrayTo(SenseOfAngle,4,-1.)
      SenseOfAngle(2)=1.
      PocitatDirCos=.true.
      DirCosFromPsi=.false.
      go to 9999
9000  call FeChybne(-1.,-1.,'KUMA - basic information missing',' ',0,
     1              SeriousError)
      go to 9900
9100  call FeReadError(71)
9900  ErrJana=1
9999  rewind 71
      return
      end
      subroutine CtiXDS
      include 'params.cmn'
      include 'basic.cmn'
      include 'datred.cmn'
      dimension xp(3)
      character*80 Radka
      logical EqIgCase
1000  read(71,FormA80,end=9000) Radka
      if(EqIgCase(radka(1:14),'!END_OF_HEADER')) go to 9999
      k=1
      call kus(Radka,k,Cislo)
      if(EqIgCase(Radka(1:18),'!X-RAY_WAVELENGTH=')) then
        call StToReal(Radka,k,LamAve(1),1,.false.,ich)
        if(ich.ne.0) goto 9100
      else if(EqIgCase(Radka(1:21),'!UNIT_CELL_CONSTANTS=')) then
        call StToReal(radka,k,CellDatRed,6,.false.,ich)
        if(ich.ne.0) goto 9100
        call DRSetCell
      endif      
      go to 1000
9000  call FeChybne(-1.,-1.,'XDS - the keyword END_OF_HEADER not found.'
     1               ,'File probably corrupt.',SeriousError)
      go to 9900
9100  call FeReadError(71)
9900  ErrJana=1
9999  continue
      PocitatDirCos=.true.
      DirCosFromPsi=.true.
      return
      end
      subroutine CtiM91
      include 'params.cmn'
      include 'basic.cmn'
      include 'datred.cmn'
      call matinv(TrToOrtho(1,1,KPhase),ub(1,1,1),pom,3)
      return
      end
      subroutine CtiRef(nread,ich)
      include 'params.cmn'
      include 'basic.cmn'
      include 'datred.cmn'
      include 'profil.cmn'
      include 'fepc.cmn'
      dimension uhlyk(4),c(3),h(3),ia(4),q(3),fq(3)
      dimension rot(3,3),rt(3,3),tt(3,3)
      character*128 dlouha
      character*80 Radka
      character*6  priznaky
      character*3  Flag
      logical eqiv,PrijdeVen,stejne
      equivalence (i,ia)
      data attenhw/12.74/
      data ScanSpeed,BckgFactor/2*-9999./
      ich=0
      ik=0
1000  if(DifCode.eq.IdCAD4) then
        call vetacad(Radka,1,0,*9920,*9930)
        i=index(Radka,'.')
        if(i.eq.0.or.i.ge.27) then
          read(Radka,'(4x,i6,3i5,1x,a6,f7.2,f4.0,f6.0,f7.0,f6.0)',
     1      err=9930) no,(ih(i),i=1,3),priznaky,pom,rych,b1,p,b2
        else
          read(Radka,'(3x,i5,3f6.2)',err=9930) no,h
          read(Radka(27:),'(a6,f7.2,f4.0,f6.0,f7.0,f6.0)',err=9930)
     1      priznaky,pom,rych,b1,p,b2
          do 1100i=1,3
            ih(i)=nint(h(i))
1100      continue
        endif
        rych=1./rych
        if(rych.lt.0.) rych=attfac*rych
        call vetacad(Radka,2,0,*9920,*9930)
        read(Radka,'(10x,f8.3,3f9.3,7x,f7.0)',err=9930) uhlyk,expos
        if(expos0.lt.0.) expos0=expos
        expos=expos-expos0
        ih(4)=0
        if(priznaky(1:1).eq.'I') then
          no=-no
        else
          no= no
        endif
        if(priznaky(2:2).eq.'C'.or.priznaky(2:2).eq.'X') go to 1000
        if(priznaky(4:4).eq.'T') go to 1000
        snkp=sin(uhlyk(4)*torad/2.)
        cskp=cos(uhlyk(4)*torad/2.)
        chi=2.*atan2(snalfa*snkp,sqrt(csalfaq+snalfaq*cskp**2))/torad
        call uprav(chi)
        theta=uhlyk(1)
        call uprav(theta)
        delta=atan2(csalfa*snkp,cskp)/torad
        fi=uhlyk(2)+delta
        call uprav(fi)
        omega=uhlyk(3)+delta
        call uprav(omega)
        if(ndim.gt.3) then
          eps=omega-theta
          sinc=sin(chi*torad)
          cosc=cos(chi*torad)
          sine=sin(eps*torad)
          cose=cos(eps*torad)
          chib=atan2(cose*sinc,sign(sqrt((sinc*sine)**2+cosc**2),cose))
          coscb=cos(chib)
          sincb=sin(chib)
          if(coscb.ne.0.) then
            fib=fi*torad-atan2(-sine/coscb,cose*cosc/coscb)
          else
            fib=fi*torad
          endif
          cosfb=cos(fib)
          sinfb=sin(fib)
          pom=2.*sin(theta*torad)/LamAve(1)
          c(1)=-sinfb*coscb*pom
          c(2)= cosfb*coscb*pom
          c(3)= sincb*pom
          call multm(ubi(1,1,1),c,h,3,3,1)
          call chngind(h,ih,1,c,DRmmax,1,CheckExtRefYes)
          do 1120i=1,3
            if(abs(c(i)).gt.DRDiffSat(i)) go to 9900
1120      continue
        endif
        if(Profil) then
          j=1
          do 1150i=3,10
            if(CAD4ProfFlag.eq.1) then
              call vetacad(Radka,i,0,*1190,*9930)
              kp=11
            else
              read(71,FormA80) Radka
              kp=1
            endif
            do 1140k=kp,idel(Radka)
              if(Radka(k:k).eq.'*') Radka(k:k)='9'
1140        continue
            read(Radka(kp:),CAD4ProfFormat,err=9930)
     1        (iprof(k,1),k=j,j+11)
            j=j+12
1150      continue
          if(NonEqCheck.eq.0) then
            nprof=96
            nbckg=16
          else
            nprof=48
            nbckg=8
            j=1
            do 1170i=1,48
              iprof(i,1)=iprof(j,1)+iprof(j+1,1)
              j=j+2
1170        continue
          endif
          KProf=1
        endif
1190    call VetaCad(Radka,19,0,*1200,*9930)
        go to 1210
1200    Radka=' '
        ik=1
1210    if(Radka.eq.' '.or.BerBPB) then
          rych=abs(rych)
          ri=(p-2.*(b1+b2))*rych
          rs=sqrt((p+4.*(b1+b2)))*rych
          if(rs.le.0.) rs=3.
        else
          read(Radka,'(29x,f8.1,f6.1)',err=9930) ri,rs
          if(rych.lt.0.) then
            ri=ri*attfac
            rs=rs*attfac
          endif
          if(rs.le.0.) rs=3.
        endif
        expnew=expos/3600.+addtime
        if(expnew.lt.expold) then
          expos=expold+1./3600.
          addtime=expos-expnew
        else
          expos=expnew
        endif
        expold=expos
        if(Profil) then
          tmn=theta
          tmx=theta
          dt=(doma+domb*tan(theta*torad))*.75
          omn=theta-dt
          omx=theta+dt
        endif
      else if(DifCode.eq.IdSiemensP4) then
        read(71,FormA128,end=9920,err=9930) dlouha
        if(dlouha(1:1).ne.' ') go to 1000
3005    read(dlouha,'(i7,3i4,4f8.2,f5.2,f8.2,i6,i12,i6,g15.1,g8.1,f8.2)'
     1      ,end=9920,err=9930) no,(ih(i),i=1,ndim),theta,omega,
     2                          fi,chi,delta,rych,i,i,i,ri,rs,expos
        theta=theta/2.
        delta=delta*.5
        tmn=theta-delta
        tmx=theta+delta
        omn=omega-delta
        omx=omega+delta
        if(no.eq.0) go to 1000
        nprof=0
3010    read(71,FormA128,end=3012,err=9930) dlouha
        go to 3015
3012    Dlouha=' '
3015    if(dlouha(1:1).eq.' ') then
          nbckg=nprof/6
c          call BPB(ri,rs,1,nbckg)
          backspace 71
        else
          idl=idel(Dlouha)
          k=1
3020      nprof=nprof+1
          call SiemensUncompress(Dlouha,k,iprof(nprof,1))
          py(nprof,1)=iprof(nprof,1)
          if(k.le.idl) go to 3020
          go to 3010
        endif
      else if(DifCode.eq.IdIPDSStoe.or.DifCode.eq.IdNoniusCCD.or.
     1        DifCode.eq.IdBrukerCCD) then
        read(71,FormatInDatRed,end=9920,err=9930)
     1   (ih(i),i=1,ndstoe),ri,rs,((dircos(i,j),j=1,2),i=1,3)
        ri=ri*10.
        rs=rs*10.
        j=0
        do 3450i=1,ndim
          j=j+iabs(ih(i))
3450    continue
        if(j.le.0) go to 9910
        call RealVectorToOpposite(dircos(1,1),dircos(1,1),3)
        noa=noa+1
        no=noa
        fi=0.
        chi=0.
        call FromIndSinthl(ih,h,sinthl,sinthlq,1,0)
        pomo=sinthl*LamAve(1)
        if(pomo.gt..99999) go to 9800
        omega=asin(sinthl*LamAve(1))/torad
        theta=omega
        expos=1.
      else if(DifCode.eq.IdD9ILL) then
        read(71,FormA128,end=9920,err=9930) dlouha
        k=0
        call kus(Dlouha,k,Cislo)
        call posun(Cislo,0)
        read(Cislo,FormI15,err=9930) no
        call StToReal(Dlouha,k,h,3,.false.,ich)
        if(ich.eq.1) go to 9930
        do 3700i=1,3
          if(h(i).gt.900.) go to 9920
          if(ndim.le.3) ih(i)=nint(h(i))
3700    continue
        if(ndim.gt.3) then
          call chngind(h,ih,1,c,DRmmax,1,CheckExtRefYes)
          do 3710i=1,3
            if(abs(c(i)).gt.DRDiffSat(i)) go to 9900
3710      continue
        endif
        call StToReal(Dlouha,k,h,2,.false.,ich)
        if(ich.ne.0) go to 9930
        ri=h(1)
        rs=h(2)
        call StToReal(Dlouha,k,uhlyk,4,.false.,ich)
        uhly(1)=uhlyk(4)
        uhly(2)=uhlyk(3)
        uhly(3)=uhlyk(2)
        uhly(4)=uhlyk(1)
        if(ich.ne.0) go to 9930
      else if(DifCode.eq.IdHasyLabF1.or.DifCode.eq.IdHasyLabHuber) then
        read(71,FormA128,end=9920,err=9930) Dlouha
        i=1
        if(Dlouha.eq.' ') go to 1000
4010    if(Dlouha(i:i).eq.' ') then
          i=i+1
          go to 4010
        else
          if(index(cifry,Dlouha(i:i)).le.0) go to 1000
        endif
        k=0
        call StToReal(Dlouha,k,h,3,.false.,ich)
        if(ich.eq.1) go to 9930
        do 4020i=1,3
          if(h(i).gt.900.) go to 9920
          if(ndim.le.3) ih(i)=nint(h(i))
4020    continue
        if(ndim.gt.3) then
          call chngind(h,ih,1,c,DRmmax,1,CheckExtRefYes)
          do 4025i=1,3
            if(abs(c(i)).gt.DRDiffSat(i)) go to 9900
4025      continue
        endif
        do 4030i=1,iskipHasy
          read(71,FormA80)
4030    continue
        noa=noa+1
        expos=float(noa)*.01
        no=noa
        do 4040i=1,nstd
          if(eqiv(ih,ihs(1,i),ndim)) no=-no
4040    continue
        call kus(Dlouha,k,Cislo)
        call posun(Cislo,1)
        read(Cislo,100,err=9930) ri
        call kus(Dlouha,k,Cislo)
        call posun(Cislo,1)
        read(Cislo,100,err=9930) rs
        if(DifCode.eq.IdHasyLabHuber) then
          ri=ri*10.
          rs=rs*10.
        endif
        do 4060i=1,2
          call kus(Dlouha,k,Cislo)
          if(k.ge.128) go to 1000
4060    continue
        call StToReal(Dlouha,k,uhlyk,4,.false.,ich)
        theta=uhlyk(1)*.5
        if(KappaGeom) then
          snkp=sin(uhlyk(3)*torad/2.)
          cskp=cos(uhlyk(3)*torad/2.)
          chi=2.*atan2(snalfa*snkp,sqrt(csalfaq+snalfaq*cskp**2))/torad
          delta=atan2(csalfa*snkp,cskp)/torad
          fi=-uhlyk(4)-delta
          omega=uhlyk(2)+delta
        else
          omega=uhlyk(2)
          fi=uhlyk(4)
          chi=uhlyk(3)
        endif
      else if(DifCode.eq.IdKumaCCD) then
        call SetIntArrayTo(ihp(4),0,3)
        read(71,FormatInDatRed,end=9920,err=9930)
     1   (ihp(i),i=1,min(ndim,4)),ri,rs,((dircos(i,j),j=1,2),i=1,3)
        call Multmi(ihp,TrKuma,ih,1,ndim,ndim)
        if(SkipMain) then
          do 4072i=4,ndim
            if(ih(i).ne.0) go to 4075
4072      continue
          go to 1000
        endif
4075    if(ndim.gt.3) then
           do 4085i=1,nvt
           a=0.
           do 4080j=1,ndim
             a=a+vt6(j,i,1,1)*float(ih(j))
4080       continue
          if(abs(a-anint(a)).gt..0001) go to 1000
4085    continue
        endif
        ri=ri*10.
        rs=rs*10.
        noa=noa+1
        no=noa
        call RealVectorToOpposite(dircos(1,1),dircos(1,1),3)
        fi=0.
        chi=0.
        call FromIndSinthl(ih,h,sinthl,sinthlq,1,0)
        pomo=sinthl*LamAve(1)
        if(pomo.gt..99999) go to 9800
        omega=asin(pomo)/torad
        theta=omega
        expos=1.
      else if(DifCode.eq.IdKumaPD) then
        n=0
5000    if(n.ge.111) go to 5500
        read(71,FormA80,end=9920,err=9930) Radka
        call mala(Radka)
        k=1
5100    if(Radka(1:1).eq.'p') then
          call kus(Radka,k,Cislo)
          if(Cislo.eq.'scan') then
            call kus(Radka,k,Cislo)
            if(Cislo.ne.'parameters') go to 5000
            call kus(Radka,k,Cislo)
            if(Cislo.ne.'sc') go to 5000
            call kus(Radka,k,Cislo)
            if(Cislo.ne.'s') go to 5000
            call kus(Radka,k,Cislo)
            call posun(Cislo,1)
            read(Cislo,100,err=9930) ScanSpeed
            call kus(Radka,k,Cislo)
            if(Cislo.ne.'sc') go to 5000
            call kus(Radka,k,Cislo)
            if(Cislo.ne.'w') go to 5000
            call kus(Radka,k,Cislo)
            call posun(Cislo,1)
            read(Cislo,100,err=9930) doma
            call kus(Radka,k,Cislo)
            call posun(Cislo,1)
            read(Cislo,100,err=9930) domb
            call kus(Radka,k,Cislo)
            call posun(Cislo,1)
            read(Cislo,100,err=9930) domc
          else if(Cislo.eq.'mo') then
            call kus(Radka,k,Cislo)
            if(Cislo.ne.'b') go to 5000
            call kus(Radka,k,Cislo)
            call posun(Cislo,1)
            read(Cislo,100,err=9930) BckgFactor
          endif
        else if(Radka(1:1).eq.'#'.or.Radka(1:1).eq.'r') then
          if(ScanSpeed.lt.0..or.doma.lt.0..or.domb.lt.0..or.domc.lt.0.
     1                      .or.BckgFactor.lt.0.) then
            call FeChybne(-1.,-1.,'KUMA - basic information missing',
     1                    ' ',0,SeriousError)
            go to 9940
          endif
          n=1
          nprof=0
          call kus(Radka,k,Cislo)
          call posun(Cislo,0)
          read(Cislo,FormI15,err=9930) no
          call StToReal(Radka,k,h,3,.false.,ich)
          if(ich.ne.0) go to 9930
          PrijdeVen=.false.
          if(ndim.le.3) then
            do 5110i=1,3
              pom=anint(h(i))
              if(abs(pom-h(i)).gt..001) then
                PrijdeVen=.true.
                go to 5130
              endif
              ih(i)=nint(pom)
5110        continue
          else
            call chngind(h,ih,1,c,DRmmax,1,CheckExtRefYes)
            do 5120i=1,3
              if(abs(c(i)).gt.DRDiffSat(i)) then
                PrijdeVen=.true.
                go to 5130
              endif
5120        continue
          endif
5130      call kus(Radka,k,Cislo)
c          call posun(Cislo,1)
c          read(Cislo,100,err=9930) psi
          call kus(Radka,k,Flag)
          if(Radka(1:1).eq.'#') then
            call StToReal(Radka,k,c,3,.false.,ich)
            call kus(Radka,k,Cislo)
            call posun(Cislo,1)
            read(Cislo,100,err=9930) rych
            rych=rych*ScanSpeed*60.
            if(ich.ne.0) go to 9930
            B1=c(1)
            B2=c(3)
            P=c(2)
          else
            call StToReal(Radka,k,c,2,.false.,ich)
            if(ich.ne.0) go to 9930
            ri=c(2)
            rs=sqrt(c(2))
            rych=ScanSpeed*60.
          endif
          if(PrijdeVen) go to 9900
        else if(Radka(1:1).eq.'z'.and.n.eq.1) then
          n=n+10
          call StToReal(Radka,k,uhlyk,4,.false.,ich)
          if(ich.ne.0) go to 9930
        else if(Radka(1:1).eq.'s') then
          n=n+100
5150      k=1
5200      call kus(Radka,k,Cislo)
          call posun(Cislo,0)
          Nprof=Nprof+1
          read(Cislo,FormI15) Iprof(NProf,1)
          if(k.ge.80) then
            read(71,FormA80,end=9920,err=9930) Radka
            call mala(Radka)
            if(Radka(1:1).eq.'s') then
              go to 5150
            else
              NBckg=nint(.5*float(Nprof)*BckgFactor/(BckgFactor+1.))
              if(flag.eq.'ft'.or.flag.eq.'aft') rych=rych*AttFac
              go to 5000
            endif
          endif
          go to 5200
        else if(Radka(1:1).eq.'y') then
          k=1
          call StToInt(Radka,k,ia,3,.false.,ich)
          call StToInt(Radka,k,ia,4,.false.,ich)
          ScanTime=-float(ia(1))-float(ia(2))/60.
     1             -float(100*ia(3)+ia(4))/360000.
          call StToInt(Radka,k,ia,4,.false.,ich)
          ScanTime=ScanTime+float(ia(1))+float(ia(2))/60.
     1                     +float(100*ia(3)+ia(4))/360000.
          if(ScanTime.lt.0.) ScanTime=ScanTime+24.
        endif
        go to 5000
5500    call KumaToEuler(uhlyk,uhly)
        pom=theta*torad
        dt=(doma+domb*tan(pom))*.5
        pomo=sin(pom)*domc
        if(pomo.gt..99999) go to 9800
        pom=asin(pomo)/torad
        tmn=pom-dt
        tmx=pom+dt
        omn=pom-dt
        omx=pom+dt
        expos=expold+ScanTime*.5
        expold=expos+ScanTime*.5
      else if(difcode.eq.IdXDS) then
5600    read(71,FormA128,end=9920,err=9930) Dlouha
	if(Dlouha(1:12).eq.'!END_OF_DATA') goto 9920
        if(Dlouha(1:1).eq.'!') go to 5600
        k=0
        call StToReal(Dlouha,k,h,3,.false.,ich)
        if(ich.ne.0) go to 9930
        do 5620i=1,3
          if(ndim.le.3) ih(i)=nint(h(i))
5620    continue
        noa=noa+1
        expos=float(noa)*.01
        no=noa
        call kus(Dlouha,k,Cislo)
        call posun(Cislo,1)
        read(Cislo,101,err=9930) ri
        call kus(Dlouha,k,Cislo)
        call posun(Cislo,1)
        read(Cislo,101,err=9930) rs
        do 5660i=1,7
          call kus(Dlouha,k,Cislo)
5660    continue
        read(Cislo,100,err=9930) schwpsi
        chi=0.0
        call FromIndSinthl(ih,h,sinthl,sinthlq,1,1)
        pomo=sinthl*LamAve(1)
        if(pomo.gt..99999) go to 9800
        theta=asin(pomo)/torad
        omega=theta
      else
        read(71,format91,end=9920,err=9930)(ih(i),i=1,ndim),ri,
     1                                      rs
        if(ih(1).gt.900) go to 9920
        noa=noa+1
        no=noa
        fi=0.
        chi=0.
        call FromIndSinthl(ih,h,sinthl,sinthlq,1,0)
        pomo=sinthl*LamAve(1)
        if(pomo.gt..99999) go to 9800
        omega=asin(pomo)/torad
        theta=omega
        expos=1.
      endif
      if(Profil) KProf=1
      call uprav(fi)
      call uprav(chi)
      call uprav(omega)
      call uprav(theta)
      if(PocitatDirCos) then
        if(DirCosFromPsi) then
	  stejne=.true.
	  do 6005i=1,3
	    do 6000j=i,3
	      if(abs(h(i)-h(j)).gt..0001) stejne=.false.
6000        continue
6005      continue
	  if(stejne) then
	    q(1)= h(1)
	    q(2)=-h(1)
	    q(3)=0.
	  else
	    do 6010i=1,3
              j=mod(i,3)+1
	      k=mod(i+1,3)+1
	      q(i)=h(j)-h(k)
6010        continue
	  endif
          call CopyVek(h,tt(1,1),3)
          call multm(MetTensI(1,1,KPhase),tt(1,1),tt(1,3),3,3,1)
          call VecNor(tt(1,3),tt(1,1))
          call multm(MetTens(1,1,KPhase),q,tt(1,1),3,3,1)
          call VecNor(q,tt(1,1))
          call VecMul(tt(1,3),q,tt(1,1))
          call multm(MetTensI(1,1,KPhase),tt(1,1),fq,3,3,1)
          call VecNor(fq,tt(1,1))
          cspsi=cos(schwpsi*torad)
	  snpsi=sin(schwpsi*torad)
	  csth=cos(theta*torad)
	  snth=sin(theta*torad)
	  do 6060i=1,3
            sod(i)=(-q(i)*snpsi-fq(i)*cspsi)*csth-tt(i,3)*snth
	    sd(i) =(-q(i)*snpsi-fq(i)*cspsi)*csth+tt(i,3)*snth
6060      continue	  
	else
	  call UnitMat(Rot,3)
          do 7100i=3,1,-1
            if(i.eq.1.or.i.eq.3) then
              j=3
            else
              j=1
            endif
            call SetRotMatAboutAxis(uhly(i)*SenseOfAngle(i),j,Rt)
            call multm(Rot,Rt,tt,3,3,3)
            call CopyMat(tt,Rot,3)
7100      continue
          tt(1,1)=-1.
          tt(2,1)= 0.
          tt(3,1)= 0.
          pom=2.*theta*torad*SenseOfAngle(4)
          tt(1,2)=-cos(pom)
          tt(2,2)=-sin(pom)
          tt(3,2)=0.
          call multm(Rot,ub,rt,3,3,3)
          call multm(tt(1,1),rt,sod,1,3,3)
          call multm(tt(1,2),rt,sd ,1,3,3)
        endif
        do 7200i=1,3
          dircos(i,1)=sod(i)/rcp(i,1,KPhase)
          dircos(i,2)=sd(i)/rcp(i,1,KPhase)
7200    continue
      endif
      if(ik.ne.0) go to 9920
      return
9800  ich=1
9900  write(Radka,'(3f10.4)') h
      call ZdrcniCisla(Radka,3)
      j=idel(Radka)
      do 9901i=1,j
        if(Radka(i:i).eq.' ') Radka(i:i)=','
9901  continue
      if(ich.eq.0) then
        Radka='the reflection ('//Radka(:j)//
     1        ') couldn''t be transformed'
        write(Dlouha,'(i1)') ndim
        Dlouha='to '//Dlouha(1:1)//'d integer indices'
      else
        Radka='the reflection ('//Radka(:j)//
     1        ') has unreallistic indices'
        Dlouha=' '
      endif
      call FeChybne(-1.,-1.,Radka,Dlouha,0,WarningWithESC)
      if(ErrJana.ne.0) then
        go to 9940
      else
        go to 9950
      endif
9910  ich=1
      go to 9999
9920  ich=2
      go to 9999
9930  ich=3
      go to 9999
9940  ich=4
      go to 9999
9950  ich=5
9999  return
100   format(f15.0)
101   format(e15.0)
      end
      subroutine KumaToEuler(uk,u)
      include 'params.cmn'
      include 'basic.cmn'
      include 'datred.cmn'
      dimension uk(4),u(4),Rot(3,3),AM(3,3),BM(3,3)
      u(4)=uk(2)*.5
      call SetRotMatKuma(uk(1),BetaKuma,1,Rot)
      call SetRotMatKuma(uk(3),AlphaKuma,2,AM)
      call MultM(Rot,AM,BM,3,3,3)
      call SetRotMatKuma(uk(4),BetaKuma,2,AM)
      call MultM(BM,AM,Rot,3,3,3)
      if((abs(uk(3)).eq.0..or.abs(uk(3)).eq.pi).and.BetaKuma.eq.0.) then
        u(1)=uk(4)
        u(2)=0.
        u(3)=uk(1)
      else
        pom=atan2(sqrt(Rot(3,1)**2+Rot(3,2)**2),Rot(3,3))
        rsinc=1./sin(pom)
        u(1)=atan2(-Rot(3,1)*rsinc, Rot(3,2)*rsinc)/torad
        u(2)=pom/torad
        u(3)=atan2(-Rot(1,3)*rsinc,-Rot(2,3)*rsinc)/torad
        call uprav(u(3))
        if(abs(u(3)).gt.90.) then
          u(3)=u(3)+180.
          u(2)=-u(2)
          u(1)=u(1)+180.
          call uprav(u(3))
        endif
        call uprav(u(1))
        call uprav(u(2))
      endif
      return
      end
      subroutine SetRotMatKuma(Angle,Alpha,Axis,Rot)
      dimension Rot(3,3),AM(3,3),BM(3,3)
      integer Axis
      if(Axis.eq.1) then
        call SetRotMatAboutAxis(Angle,-3,Rot)
      else
        call SetRotMatAboutAxis( Alpha,-2,Rot)
        call SetRotMatAboutAxis( Angle,-3,AM)
        call MultM(Rot,AM,BM,3,3,3)
        call SetRotMatAboutAxis(-Alpha,-2,AM)
        call MultM(BM,AM,Rot,3,3,3)
      endif
      return
      end
      subroutine SetRotMatAboutAxis(fi,Axis,R)
      include 'const.cmn'
      dimension R(3,3)
      integer Axis
      pom=fi*ToRad
      if(Axis.lt.0) pom=-pom
      sinf=sin(pom)
      cosf=cos(pom)
      call UnitMat(R,3)
      i=iabs(Axis)
      if(i.eq.1) then
        j=3
      else if(i.eq.2) then
        j=1
      else if(i.eq.3) then
        j=2
      endif
      i=6-j-i
      R(i,i)= cosf
      R(j,j)= cosf
      R(i,j)=-sinf
      R(j,i)= sinf
      return
      end
      subroutine vetacad(veta,ktera,klic,*,*)
      include 'params.cmn'
      include 'basic.cmn'
      include 'datred.cmn'
      character*80 veta,VetaOld
      data VetaOld/' '/
      if(klic.eq.1) then
        rewind 71
        VetaOld= ' '
      endif
1000  if(VetaOld.eq.' ') then
        read(71,FormA80,err=3000,end=2000) veta
        if(ichar(Veta(1:1)).lt.32) Veta=Veta(2:)
        if(Veta.eq.' ') go to 1000
        if(idel(Veta).le.3) go to 2000
        if(veta(1:1).eq.'$') go to 2000
        if(jentri) veta=' '//veta
      else
        Veta=VetaOld
        VetaOld=' '
      endif
      k=0
      call kus(Veta(:4),k,Cislo)
      call posun(Cislo,0)
      read(Cislo,FormI15,err=3000) k
      if(k.eq.ktera) go to 1500
      if(ktera.eq.19.and.k.eq.1) then
        VetaOld=Veta
        Veta=' '
      else
        go to 1000
      endif
1500  return
2000  return 1
3000  return 2
      end
      subroutine uprav(uhel)
1000  if(uhel.gt.180.) then
        uhel=uhel-360.
        go to 1000
      endif
2000  if(uhel.le.-180.) then
        uhel=uhel+360.
        go to 2000
      endif
      return
      end
      subroutine KorStLp
      include 'params.cmn'
      include 'basic.cmn'
      include 'datred.cmn'
      include 'fepc.cmn'
      dimension ris(10000,10),xia(10000,10),yp(10000),nst(10),
     1          ri0(10),rid(10),risa(10),rismx(10),rismn(10),jp(10)
      character*80 t80
      character*18 men1(4)
      integer FeMenu
      logical eqiv,Vystraha,DelatPCorr,FeYesNo
      data men1/'%Linear decay',
     1          '%Exponential decay',
     2          '%Step-like decay',
     3          '%No decay'/
      data b,c/2*.5/
      Vystraha=.false.
      if(DifCode.eq.IdKumaPD) then
        DelatPCorr=.true.
c        DelatPCorr=FeYesNo(-1.,-1.,'Do you want to apply synchrotron '//
c     1                     'LP correction (0.96 Perpendicular)?',1)
      else
        DelatPCorr=.true.
      endif
      do 1000i=1,10
        nst(i)=0
        risa(i)=0.
        rismx(i)=0.
        rismn(i)=99999999.
1000  continue
      call OpenFile(95,fln(:ifln)//'.m95','formatted','old')
      if(ErrJana.ne.0) go to 9999
      nmod=max(nint(float(nref95)*.005),10)
      korst=FeMenu(-1.,-1.,men1,1,4,1,0)
      if(korst.lt.1) go to 9900
      ism=0
      call PrvniM95(ich)
      if(ich.ne.0) go to 9900
      call FeFlowChartOpen(-1.,-1.,nmod,nref95,
     1                     'Reading reflections from M95',' ',' ')
      iz=0
1100  call DRGetReflectionFromM95(95,iend,ich)
      if(ich.ne.0) go to 9100
      if(iend.ne.0) go to 2000
      call FeFlowChartEvent(iz,is)
      if(is.ne.0) then
        call FeBudeBreak
        if(ErrJana.ne.0) go to 9999
      endif
      if(iflg(1).lt.0) go to 1100
      if(no.lt.0) then
        do 1200is=1,ism
          if(eqiv(ih,ihs(1,is),ndim)) go to 1300
1200    continue
        if(ism.ge.10) then
          if(.not.Vystraha) then
            call FeChybne(-1.,-1.,'the maximum number of standard '//
     1                    'reflections exceeded',
     2                    'only first ten will be used',0,Warning)
            Vystraha=.true.
          endif
          go to 1100
        endif
        ism=ism+1
        is=ism
        do 1250i=1,ndim
          ihs(i,is)=ih(i)
1250    continue
1300    n=nst(is)+1
        ris(n,is)=ri
        xia(n,is)=expos
        nst(is)=n
        risa(is)=risa(is)+ri
        rismx(is)=max(rismx(is),ri)
        rismn(is)=min(rismn(is),ri)
      endif
      go to 1100
2000  call FeFlowChartRemove
      call CloseIfOpened(95)
      n=0
      do 2030i=1,ism
        if(nst(i).gt.1) then
          n=n+1
          if(i.gt.n) then
            do 2010j=1,ndim
              ihs(j,n)=ihs(j,i)
2010        continue
            nst(n)=nst(i)
            do 2020j=1,nst(n)
              ris(j,n)=ris(j,i)
              xia(j,n)=xia(j,i)
2020        continue
            risa(n)=risa(i)
            rismx(n)=rismx(i)
            rismn(n)=rismn(i)
          endif
        endif
2030  continue
      ism=n
      if(ism.le.0.and.korst.ne.4) then
        call FeChybne(-1.,-1.,'the number of standard reflections '//
     1                'isn''t sufficient',
     2                'no decay correction will be applied',0,Warning)
        korst=4
      endif
      call FeMakeAcWin(25.,10.,15.,14.)
      do 2300i=1,ism
        n=nst(i)
        risa(i)=risa(i)/float(n)
        t80='('
        k=2
        do 2050j=1,ndim
          write(t80(k:k+2),'(i3)') ihs(j,i)
          k=k+2
          if(j.ne.ndim) then
            t80=t80(1:k)//','
          else
            t80=t80(1:k)//')'
          endif
          k=k+2
2050    continue
        call zhusti(t80)
        call UnitMat(F2O,3)
        d=(xia(n,i)-xia(1,i))/float(n)
        xomn=xia(1,i)-d
        xomx=xia(n,i)+d
        sumxx=0.
        sumxy=0.
        sumx=0.
        sumy=0.
        yomx=0.
        yomn=1.e+20
        do 2100j=1,n
          x=xia(j,i)
          if(korst.eq.2) then
            y=log(ris(j,i))
          else
            y=ris(j,i)
          endif
          yomx=max(yomx,ris(j,i))
          yomn=min(yomn,ris(j,i))
          sumxx=sumxx+x**2
          sumxy=sumxy+x*y
          sumx=sumx+x
          sumy=sumy+y
2100    continue
        det=sumxx*float(n)-sumx**2
        ri0(i)=(sumxx*sumy-sumx*sumxy)/det
        rid(i)=(sumxy*float(n)-sumx*sumy)/det
        if(korst.eq.2) then
          ri0(i)=exp(ri0(i))
        else
          rid(i)=rid(i)/ri0(i)
        endif
        do 2150j=1,n
          x=xia(j,i)
          if(korst.eq.2) then
            yp(j)=ri0(i)*exp(x*rid(i))
          else
            yp(j)=ri0(i)*(1+x*rid(i))
          endif
2150    continue
        yomn=yomn*.8
        yomx=yomx*1.2
        reconfig=.true.
2200    if(reconfig) then
          call FeSetTransXo2X(xomn,xomx,yomn,yomx,.false.)
          reconfig=.false.
        endif
        t80='Standard reflection : '//t80(:idel(t80))
        call FeOutSt(0,XCenAcWin,(YMaxAcWin+YMaxGrWin)*.5,t80,'C',White)
        call FeMakeAcFrame
        call FeMakeAxisLabels(1,xomn,xomx,yomn,yomx,'t')
        call FeMakeAxisLabels(2,yomn,yomx,xomn,xomx,'I')
        t80='I(ave)='
        write(Cislo,'(i15)') nint(risa(i))
        call Zhusti(Cislo)
        t80=t80(:idel(t80))//Cislo(:idel(Cislo))//', I(min)='
        write(Cislo,'(i15)') nint(rismn(i))
        call Zhusti(Cislo)
        t80=t80(:idel(t80))//Cislo(:idel(Cislo))//', I(max)='
        write(Cislo,'(i15)') nint(rismx(i))
        call Zhusti(Cislo)
        t80=t80(:idel(t80))//Cislo(:idel(Cislo))
        call FeOutSt(0,XCenAcWin,YMaxGrWin-20.,t80,'C',White)
        if(korst.lt.3) then
          if(korst.eq.1) then
            write(t80,'(''I='',i8,''*(1 '',f10.6,''*t)'')')
     1            nint(ri0(i)),rid(i)
            if(rid(i).ge.0.) t80(14:14)='+'
          else
            write(t80,'(''I='',i8,''*exp('',f10.6,''*t)'')')
     1            nint(ri0(i)),rid(i)
          endif
          call zhusti(t80)
          call FeOutSt(0,XCenAcWin,YMaxGrWin-30.,t80,'C',White)
          call FeXYPlot(xia(1,i),yp,n,NormalLine,NormalPlotMode,Red)
        endif
        call FeXYPlot(xia(1,i),ris(1,i),n,NormalLine,NormalPlotMode,
     1                White)
        call FeBottomInfo('To continue press any key or mouse button')
2250    call FeEvent(0)
        if(EventType.eq.EventKey.or.EventType.eq.EventASCII.or.
     1     (EventType.eq.EventMouse.and.
     2      (EventNumber.eq.JeLeftDown.or.EventNumber.eq.JeRightDown)))
     3    then
          call FeClearGrWin
          call FeBottomInfo(' ')
        else
          go to 2250
        endif
2300  continue
      call FeFlowChartOpen(-1.,-1.,nmod,nref95,'Decay and LP correction'
     1                    ,' ',' ')
      call OpenFile(96,fln(:ifln)//'.l95','formatted','unknown')
      call OpenFile(95,fln(:ifln)//'.m95','formatted','unknown')
      iz=0
      do 2400i=1,ism
        jp(i)=1
2400  continue
      rip0=10000.*float(ism)
      ripa=0.
      ripmx=0.
      ripn=0.
      ripmn=1e33
      call PrvniM95(ich)
      if(ich.ne.0) go to 9900
3000  call DRGetReflectionFromM95(95,iend,ich)
      if(ich.ne.0) go to 9100
      if(iend.ne.0) go to 4000
      call FeFlowChartEvent(iz,is)
      if(is.ne.0) then
        call FeBudeBreak
        if(ErrJana.ne.0) go to 9999
      endif
      if(iflg(1).lt.0) go to 3000
      if(no.gt.0) then
        if(korst.ne.4) then
          rip=0.
          do 3100i=1,ism
            if(korst.eq.1) then
              pom=ri0(i)*(1.+rid(i)*expos)
              rip=rip+pom
            else if(korst.eq.2) then
              pom=ri0(i)*exp(rid(i)*expos)
              rip=rip+pom
            else if(korst.eq.3) then
              do 3050j=jp(i),nst(i)
                if(xia(j,i).gt.expos) go to 3060
3050          continue
              j=nst(i)
3060          np=j-1
              pom=ris(np,i)+(ris(np+1,i)-ris(np,i))*(expos-xia(np,i))/
     1                                        (xia(np+1,i)-xia(np,i))
              rip=rip+pom
              jp(i)=j
            endif
3100      continue
          ripa=ripa+rip
          ripn=ripn+1.
          ripmn=min(ripmn,rip)
          ripmx=max(ripmx,rip)
          corrf(1)=rip0/rip
        else
          corrf(1)=1.
        endif
        sn=sin(abs(theta*torad))
        cs2q=(1.-2.*sn**2)**2
        if(DelatPCorr) then
          if(DifCode.ne.IdSiemensP4) then
            t1=(1.-c)*((1.-b)*cs2mq+b*cs2q)/(b+(1.-b)*cs2mq)
            t2=c*(b*cs2m +(1.-b)*cs2q)/(b+(1.-b)*cs2m )
          else
            t1=(1.-c)*((1.-b)+b*cs2q*cs2mq)/(b+(1.-b)*cs2mq)
            t2=c*(b+(1.-b)*cs2q*cs2m)/(b+(1.-b)*cs2m )
          endif
          corrf(1)=corrf(1)*2.*sn*sqrt(1.-sn**2)/(t1+t2)
        else
          t1=.5*((1.+cs2q)+.96*(1.-cs2q))
          corrf(1)=corrf(1)*2.*sn*sqrt(1.-sn**2)/t1
        endif
      endif
      call DRPutReflectionToM95(96)
      go to 3000
4000  call CloseIfOpened(95)
      call CloseIfOpened(96)
      call MoveFile(fln(:ifln)//'.l95',fln(:ifln)//'.m95',.false.)
      call FeFlowChartRemove
      if(ripn.gt.0.) then
        ripa=ripa/ripn
        ripn=max(ripmx-ripa,ripa-ripmn)/ripa*100.
      else
        ism=0
        ripa=0.
        ripn=0.
      endif
      call OpenFile(89,fln(:ifln)//'_datred.tmp','formatted','old')
      if(ErrJana.ne.0) go to 4200
      do 4050i=1,4
        read(89,FormA80) t80
        TextInfo(i)=t80
4050  continue
      TextInfo(2)='standards:'
      write(TextInfo(2)(12:),'(i2,f6.1)') ism,ripn
      k=idel(TextInfo(2))+1
      l=2
      do 4100i=1,ism
        write(TextInfo(l)(k:),'(6i4)')(ihs(j,i),j=1,ndim)
        k=k+4*ndim
        if(k.gt.56) then
          l=l+1
          TextInfo(l)='standards:'
          k=idel(TextInfo(l))+1
        endif
4100  continue
      rewind 89
      do 4110i=1,4
        write(89,FormA1)(TextInfo(i)(j:j),j=1,idel(TextInfo(i)))
4110  continue
      write(89,'(''end'')')
4200  CorrLp=1
      call iom94(1)
      go to 9999
9100  call FeReadError(95)
9900  ErrJana=1
9999  call DeleteFile(fln(:ifln)//'.l95')
      call CloseIfOpened(95)
      call CloseIfOpened(89)
      return
      end
      subroutine simulace
      include 'params.cmn'
      include 'basic.cmn'
      include 'datred.cmn'
      include 'fepc.cmn'
      dimension nButt(6)
      character*80 t80
      character*8 jmena(6)
      equivalence (nButt(1),NButtQuit),(nButt(2),NButtPrint),
     1            (nButt(3),NButtSave),(nButt(4),NButtNext),
     2            (nButt(5),NButtBack),(nButt(6),NButtGoto)
      data jmena/'%Quit','%Print','%Save','%Next','%Back','%Go to'/
      data ix,iz/1,3/
      id=NextQuestId()
      call FeQuestCreate(id,-1.,-1.,140.,0,3,'View definition',0,
     1                   LightGray,0,0)
      xpom=100.
      do 1000i=1,3
        call FeQuestCrwMake(id,xpom,1,xpom-4.,2,indices(i),'C',CrwgXd,
     1                      CrwgYd,1,1)
        call FeQuestCrwOpen(i,i.eq.iz)
        xpom=xpom+14.
1000  continue
      xpom=100.
      do 1050i=1,3
        call FeQuestCrwMake(id,xpom,1,xpom-4.,3,' ','C',CrwgXd,CrwgYd,1,
     1                      2)
        if(i.ne.iz) call FeQuestCrwOpen(i+3,i.eq.ix)
        xpom=xpom+14.
1050  continue
      call FeQuestLabelMake(id,5.,2,'The layer direction','L')
      call FeQuestLabelMake(id,5.,3,'The horizontal direction','L')
1400  icont=0
1500  call FeQuestEvent(id,icont,ich)
      icont=1
      if(CheckType.eq.EventCrw) then
        if(CheckNumber.le.3) then
          if(iz.ne.CheckNumber) then
            call FeQuestCrwClose(CheckNumber+3)
            CrwLogic(CheckNumber+CrwFr+2)=.false.
            call FeQuestCrwOpen(iz+3,ix.eq.CheckNumber)
            if(ix.eq.CheckNumber) ix=iz
            iz=CheckNumber
          endif
        else if(CheckNumber.le.6) then
          ix=CheckNumber-3
        endif
        go to 1400
      else if(CheckType.ne.0) then
        call NebylOsetren
        go to 1500
      endif
      call FeQuestRemove(id)
      if(ich.ne.0) go to 9999
      if(.not.ExistM95) call SetBasicM94
      itr(1)=ix
      itr(3)=iz
      itr(2)=6-itr(1)-itr(3)
      a=rcp(itr(1),2,KPhase)
      b=rcp(itr(2),2,KPhase)
      csg=rcp(3+itr(3),2,KPhase)
      sng=sqrt(1.-csg**2)
      F2O(1)=a
      F2O(2)=0.
      F2O(3)=0.
      F2O(4)=b*csg
      F2O(5)=b*sng
      F2O(6)=0.
      F2O(7)=0.
      F2O(8)=0.
      F2O(9)=1.
      if(ExistM95) then
        call OpenFile(95,fln(:ifln)//'.m95','formatted','old')
        if(ErrJana.ne.0) go to 9999
        call PrvniM95(ich)
        if(ich.ne.0) go to 9999
        call FeFlowChartOpen(-1.,-1.,max(nint(float(nref95)*.005),10),
     1                       nref95,'Reading reflections from M95',' ',
     2                       ' ')
      else
        call OpenFile(80,fln(:ifln)//'.m80','formatted','old')
        if(ErrJana.ne.0) go to 9999
      endif
      rimax=0.
      call SetRealArrayTo(hmx,ndim,0.)
      if(.not.ExistM94) call CopyVek(qu,quDatRed(1,1,3),3*ndimi)
      izz=0
      izc=0
2300  izz=izz+1
2310  if(ExistM95) then
        call DRGetReflectionFromM95(95,iend,ich)
        if(ich.ne.0) go to 9100
        if(iend.ne.0) go to 2350
        call FeFlowChartEvent(izc,is)
        if(is.ne.0) then
          call FeBudeBreak
          if(ErrJana.ne.0) go to 9999
        endif
        if(no.le.0) go to 2310
        if(iflg(1).lt.0) go to 2310
        call indtr(ih,trmp,ihar(1,izz),ndim)
        if(ihar(1,izz).gt.900) go to 2310
        riar(izz)=ri*corrf(1)*corrf(2)
        rsar(izz)=rs*corrf(1)*corrf(2)
      else
        read(80,Format80,end=2350,err=9100)(ihar(i,izz),i=1,maxndim),
     1                                      KPh,riar(izz),rsar(izz)
        if(ihar(1,izz).gt.900) go to 2350
        do 2302i=1,ndim
          if(ihar(i,izz).ne.0) go to 2304
2302    continue
        go to 2310
2304    riar(izz)=riar(izz)**2
        rsar(izz)=riar(izz)/50.
        if(riar(izz).le.0.) go to 2310
      endif
      rimax=max(rimax,riar(izz))
      do 2320i=1,3
        pom=float(ihar(i,izz))+float(ihar(4,izz))*quDatRed(i,1,3)
        hmx(i)=max(hmx(i),anint(abs(pom)+.5))
2320  continue
      go to 2300
2350  izz=izz-1
      rimax=rimax
      if(ExistM95) call FeFlowChartRemove
      id=NextQuestId()
      call FeQuestAbsCreate(id,0.,0.,XMaxBasWin,YMaxBasWin,' ',0,0,-1,
     1                      -1)
      call FeMakeGrWin(0.,40.,0.,0.)
      call FeMakeAcWin(15.,2.,15.,15.)
      call FeSetTransXo2X(-hmx(itr(1)),hmx(itr(1)),-hmx(itr(2)),
     1                     hmx(itr(2)),.true.)
      il=0
      ilmax=nint(hmx(itr(3)))
      xpom=XMaxGrWin+4.
      dpom=XMaxBasWin-XMaxGrWin-8.
      ypom=YMaxGrWin-70.
      do 2400i=1,6
        call FeQuestAbsButtonMake(id,xpom,ypom,dpom,ButYd,Jmena(i))
        nButt(i)=ButtonLastMade
        call FeQuestButtonOpen(ButtonLastMade,ButtonOff)
        ypom=ypom-10.
2400  continue
3000  HardCopy=0
      if(il.gt.ilmax) il=ilmax
      if(il.lt.0) il=0
      if(il.ne.0) then
        call FeQuestButtonOff(nButtBack)
      else if(il.eq.0) then
        call FeQuestButtonDisable(nButtBack)
      endif
      if(il.ne.ilmax) then
        call FeQuestButtonOff(nButtNext)
      else if(il.eq.ilmax) then
        call FeQuestButtonDisable(nButtNext)
      endif
3050  call FeHardCopy(HardCopy,'open',ich)
      if(ich.ne.0) go to 3100
      write(t80,'(a1,''='',i5)') indices(itr(3)),il
      call zhusti(t80)
      call FeClearGrWin
      call FeReleaseOutput
      call FeDeferOutput
      call FeOutSt(0,XCenAcWin+30.,(YMaxAcWin+YMaxGrWin)*.5,t80,'C',
     1             White)
      call osnova(0)
      call sit(il,izz)
      call FeHardCopy(HardCopy,'close',ich)
3100  icont=0
      call FeQuestEvent(id,icont,ich)
      icont=1
      if(CheckType.eq.EventButton) then
        ib=CheckNumber
        if(CheckNumber.eq.nButtQuit) then
          call FeQuestButtonOff(ib)
          call FeQuestRemove(id)
          go to 9999
        else if(CheckNumber.eq.nButtPrint.or.CheckNumber.eq.nButtSave)
     1    then
          if(CheckNumber.eq.nButtPrint) then
            HardCopy=-PrintStyle
          else
            call FeSavePicture('layer',5)
            if(HardCopy.lt.0) then
              HardCopy=0
              call FeQuestButtonOff(ib)
              go to 3100
            endif
          endif
          call FeQuestButtonOff(ib)
          go to 3050
        else if(CheckNumber.eq.nButtNext) then
          il=il+1
          go to 4000
        else if(CheckNumber.eq.nButtBack) then
          il=il-1
          go to 4000
        else if(CheckNumber.eq.nButtGoTo) then
          call GoToL(il,0,ilmax,ich)
          if(ich.eq.0) go to 4000
        endif
      endif
      go to 3100
4000  call FeQuestButtonOff(ib)
      go to 3000
9100  call FeReadError(95)
      if(ExistM95) call FeFlowChartRemove
9999  call CloseIfOpened(95)
      return
      end
      subroutine osnova(Key)
      include 'params.cmn'
      include 'basic.cmn'
      include 'datred.cmn'
      include 'fepc.cmn'
      dimension xx(3),xf(3)
      integer Colour
      xf(3)=0.
      iym=nint(hmx(itr(2)))
      do 2100iy=-iym,iym
        if(Key.eq.0) then
          if(iy.eq.0) then
            Colour=White
          else
            Colour=Gray
          endif
        else
          Colour=Black
        endif
        xf(2)= iy
        xf(1)=-hmx(itr(1))
c        xf(1)=xf(1)*2.
c        xf(2)=xf(2)*2.
        call FeXf2X(xf,xx)
        xu(1)=xx(1)
        yu(1)=xx(2)
        if(iy.eq.-iym) then
          xp1=xx(1)
          yp1=xx(2)
        else if(iy.eq.-iym+1) then
          rdmax=sqrt((xu(1)-xp1)**2+(yu(1)-yp1)**2)
        endif
        xf(1)= hmx(itr(1))
        call FeXf2X(xf,xx)
        xu(2)=xx(1)
        yu(2)=xx(2)
        if(iy.eq.0) then
          call FeArrow(xu(1),yu(1),xu(2),yu(2),Colour,ArrowTo)
          call FeOutSt(0,xu(2)+5.,yu(2),indices(itr(1)),'L',White)
        else
          call FePolyLine(2,xu,yu,Colour)
        endif
2100  continue
      ixm=nint(hmx(itr(1)))
      do 2200ix=-ixm,ixm
        if(Key.eq.0) then
          if(ix.eq.0) then
            Colour=White
          else
            Colour=Gray
          endif
        else
          Colour=Black
        endif
        xf(1)= ix
        xf(2)=-hmx(itr(2))
        call FeXf2X(xf,xx)
        xu(1)=xx(1)
        yu(1)=xx(2)
        if(ix.eq.-ixm) then
          xp1=xu(1)
          yp1=yu(1)
        else if(ix.eq.-ixm+1) then
          rdmax=min(rdmax,sqrt((xu(1)-xp1)**2+(yu(1)-yp1)**2))
        endif
        xf(2)= hmx(itr(2))
        call FeXf2X(xf,xx)
        xu(2)=xx(1)
        yu(2)=xx(2)
        if(ix.eq.0) then
          call FeArrow(xu(1),yu(1),xu(2),yu(2),Colour,ArrowTo)
          call FeOutSt(0,xu(2),yu(2)+5.,indices(itr(2)),'L',White)
        else
          call FePolyLine(2,xu,yu,Colour)
        endif
2200  continue
      rdmax=rdmax/2.
      return
      end
      subroutine sit(il,n)
      include 'params.cmn'
      include 'basic.cmn'
      include 'datred.cmn'
      include 'fepc.cmn'
      dimension xx(3),xo(3)
      integer Colour
      xx(3)=0.
      do 5000i=1,n
        i1=ihar(itr(1),i)
        i2=ihar(itr(2),i)
        zn=1.
        if(iabs(ihar(itr(3),i)).ne.il) go to 5000
        if(ihar(itr(3),i).ne.il) then
          i1=-i1
          i2=-i2
          zn=-1.
        endif
        if(riar(i).gt.3.*rsar(i)) then
          r=sqrt(riar(i)/rimax)*rdmax
          Colour=Yellow
        else
          r=rdmax/16.
          Colour=White
        endif
        xx(1)=float(i1)
        xx(2)=float(i2)
        do 1100j=1,ndimi
          fm=ihar(j+3,i)
          do 1000k=1,2
            xx(k)=xx(k)+zn*fm*QuDatRed(itr(k),j,3)
1000      continue
1100    continue
        ii=0
2000    call FeXf2X(xx,xo)
        call FeCircle(xo(1),xo(2),r,Colour)
        if(il.eq.0.and.ii.eq.0) then
          xx(1)=-xx(1)
          xx(2)=-xx(2)
          ii=1
          go to 2000
        endif
5000  continue
      return
      end
      subroutine GoToL(L,Lmin,Lmax,ich)
      include 'params.cmn'
      include 'basic.cmn'
      include 'fepc.cmn'
      id=NextQuestId()
      call FeQuestCreate(id,-1.,-1.,90.,0,1,'Next section to be drawn',
     1                   0,LightGray,0,0)
      call FeQuestEudMake(id,0.,0,35.,1,' ','C',20.,EdwYd,0)
      call FeQuestIntEdwOpen(1,L,.false.)
      call FeQuestEudOpen(1,Lmin,Lmax,1,pom,pom,pom)
      icont=0
1500  call FeQuestEvent(id,icont,ich)
      icont=1
      if(CheckType.ne.0) then
        call NebylOsetren
        go to 1500
      endif
      if(ich.eq.0) call FeQuestIntFromEdw(1,L)
      call FeQuestRemove(id)
      return
      end
      subroutine abskvse
      include 'params.cmn'
      include 'basic.cmn'
      include 'datred.cmn'
      include 'fepc.cmn'
      character*80 Veta,FormulaOld,Label
      character*256 EdwStringQuest
      dimension xp(2),AtAbsCoeffOld(20),nmen1(0:3)
      integer CorrAbsNew,CrwStateQuest,EdwStateQuest,Exponent10
      logical FeYesNoHeader,Change,CrwLogicQuest,DefFormula
      call iom94(1)
      id=NextQuestId()
      xqd=270.
      if(CorrAbs.le.0) then
        il=9
        CorrAbsNew=3
        ip=2
      else
        il=10
        ip=1
        CorrAbsNew=CorrAbs
      endif
      FormulaOld=Formula
      call CopyVek(AtAbsCoeff(1,KPhase),AtAbsCoeffOld,NAtFormula)
      Change=.false.
      call FeQuestCreate(id,-1.,-1.,xqd,0,il,'Define absorption '//
     1                   'parameters',0,LightGray,0,0)
      il=0
      xpom=5.
      tpom=xpom+CrwgXd+3.
      xmx=0.
      do 1100i=1,4
        il=il+1
        if(i.eq.1) then
          Veta='%Remove absorption correction'
        else if(i.eq.2) then
          Veta='Correction for %spherical sample'
        else if(i.eq.3) then
          Veta='Correction for c%ylindrical sample'
        else if(i.eq.4) then
          Veta='%Gaussian integration method'
        endif
        xmx=max(xmx,tpom+FeTxLengthUnder(Veta)+10.)
        call FeQuestCrwMake(id,tpom,il,xpom,il,Veta,'L',CrwgXd,CrwgYd,1,
     1                      1)
        if(i.ge.ip) then
          call FeQuestCrwOpen(CrwLastMade,i.eq.CorrAbsNew+1)
        else
          il=il-1
        endif
        if(i.eq.1) then
          nCrwRemove=CrwLastMade
        else if(i.eq.2) then
          nCrwSphere=CrwLastMade
        else if(i.eq.3) then
          nCrwCylinder=CrwLastMade
        else if(i.eq.4) then
          nCrwGauss=CrwLastMade
        endif
1100  continue
      il=il-3
      xpom=xmx
      dpom=35.
      tpom=xpom+dpom+3.
      do 1110i=1,3
        il=il+1
        if(i.eq.1) then
          Veta='radius of the sp%here [mm]'
          ichk=0
        else if(i.eq.2) then
          Veta='radius of the %cylinder [mm]'
        else if(i.eq.3) then
          Veta='%integration grid'
          ichk=1
        endif
        call FeQuestEdwMake(id,tpom,il,xpom,il,Veta,'L',dpom,EdwYd,ichk)
        if(i.eq.1) then
          nEdwRadSphere=EdwLastMade
        else if(i.eq.2) then
          nEdwRadCylinder=EdwLastMade
        else if(i.eq.3) then
          nEdwGrid=EdwLastMade
        endif
1110  continue
      il=il+1
      xpom=5.
      Veta='Edit %faces'
      dpom=FeTxLengthUnder(Veta)+10.
      call FeQuestButtonMake(id,xpom,il,dpom,ButYd,Veta)
      nButtEditFaces=ButtonLastMade
      call FeQuestButtonOpen(ButtonLastMade,ButtonOff)
      xpom=xpom+dpom+5.
      write(Cislo,FormI15) nfaces
      call Zhusti(Cislo)
      Label='Crystal shape enclosed by '//Cislo(:idel(Cislo))//' faces'
      ill=il
      xpoml=xpom
      call FeQuestLabelMake(id,xpom,il,Label,'L')
      il=il+1
      call FeQuestLineMake(id,il)
      xpom=5.
      tpom=xpom+CrwgXd+3.
      DefFormula=.true.
      do 1150i=1,2
        il=il+1
        if(i.eq.1) then
          Veta='D%efine absorption coeffient'
          jk=1
          ichk=0
        else if(i.eq.2) then
          Veta='%Define formula'
          jk=2
          ichk=1
        endif
        call FeQuestCrwMake(id,tpom,il,xpom,il,Veta,'L',CrwgXd,CrwgYd,1,
     1                      2)
        tpome=tpom+FeTxLengthUnder(Veta)+3.
        Veta='=>'
        xpome=tpome+FeTxLengthUnder(Veta)+3.
        ilp=il
        do 1140j=1,jk
          tpo=tpome
          xpo=xpome
          if(j.eq.1) then
            if(i.eq.1) then
              dpom=45.
            else
              dpom=120.
            endif
          else
            dpom=35.
            xpo=xpome+120.-dpom
            Veta='Number of formula %units'
            tpo=xpo-FeTxLengthUnder(Veta)-3.
          endif
          call FeQuestEdwMake(id,tpo,ilp,xpo,ilp,Veta,'L',dpom,
     1                        EdwYd,ichk)
          if(j.eq.1) then
            if(i.eq.1) then
              nEdwAmi=EdwLastMade
            else
              nEdwFormula=EdwLastMade
            endif
          else
            nEdwZ=EdwLastMade
          endif
          ilp=ilp+1
1140    continue
        if(i.eq.1) then
          nCrwDefAmi=CrwLastMade
        else if(i.eq.2) then
          nCrwDefFormula=CrwLastMade
        endif
1150  continue
      Veta='C%alculate density'
      xpom=xpome+130.
      dpom=FeTxLengthUnder(Veta)+5.
      call FeQuestButtonMake(id,xpom,il,dpom,ButYd,Veta)
      nButtCalculateDensity=ButtonLastMade
      il=il+1
      Veta='Cr%oss sections'
      call FeQuestButtonMake(id,xpom,il,dpom,ButYd,Veta)
      nButtCross=ButtonLastMade
      call DRCalcDenAbs(wmol,dx,ich)
1400  if(CorrAbsNew.gt.0) then
        if(CrwStateQuest(nCrwDefFormula).eq.CrwClosed) then
          call FeQuestCrwOpen(nCrwDefFormula,.true.)
          call FeQuestCrwOpen(nCrwDefAmi,.false.)
          DefFormula=.true.
        endif
        if(DefFormula) then
          call FeQuestEdwClose(nEdwAmi)
          if(EdwStateQuest(nEdwFormula).ne.EdwOpened) then
            call FeQuestStringEdwOpen(nEdwFormula,Formula)
            call FeQuestIntEdwOpen(nEdwZ,nz,.false.)
            call FeQuestButtonOff(nButtCalculateDensity)
            call FeQuestButtonOff(nButtCross)
          endif
        else
          call FeQuestEdwClose(nEdwFormula)
          call FeQuestEdwClose(nEdwZ)
          call FeQuestButtonClose(nButtCalculateDensity)
          call FeQuestButtonClose(nButtCross)
          if(EdwStateQuest(nEdwAmi).ne.EdwOpened)
     1      call FeQuestRealEdwOpen(nEdwAmi,ami,.false.,.false.)
        endif
      else
        call FeQuestEdwClose(nEdwAmi)
        call FeQuestEdwClose(nEdwFormula)
        call FeQuestEdwClose(nEdwZ)
        call FeQuestCrwClose(nCrwDefFormula)
        call FeQuestCrwClose(nCrwDefAmi)
        call FeQuestButtonClose(nButtCalculateDensity)
        call FeQuestButtonClose(nButtCross)
      endif
      if(CorrAbsNew.ne.1) call FeQuestEdwClose(nEdwRadSphere)
      if(CorrAbsNew.ne.2) call FeQuestEdwClose(nEdwRadCylinder)
      if(CorrAbsNew.ne.3) then
        call FeQuestEdwClose(nEdwGrid)
        call FeQuestButtonClose(nButtEditFaces)
        call FeQuestLabelRemove(id,xpoml,ill,Label,'L')
      endif
      if(CorrAbsNew.eq.1) then
        if(EdwStateQuest(nEdwRadSphere).ne.EdwOpened)
     1     call FeQuestRealEdwOpen(nEdwRadSphere,radiusDatRed,.false.,
     2                             .false.)
      else if(CorrAbsNew.eq.2) then
        if(EdwStateQuest(nEdwRadCylinder).ne.EdwOpened)
     1    call FeQuestRealEdwOpen(nEdwRadCylinder,radiusDatRed,.false.,
     2                            .false.)
      else if(CorrAbsNew.eq.3) then
        if(EdwStateQuest(nEdwGrid).ne.EdwOpened) then
          call FeQuestIntAEdwOpen(nEdwGrid,igauss,3,.false.)
          call FeQuestButtonOff(nButtEditFaces)
          call FeQuestLabelMake(id,xpoml,ill,Label,'L')
        endif
      endif
1480  icont=0
1500  call FeQuestEvent(id,icont,ich)
      icont=1
      if(CheckType.eq.EventCrw.and.
     1   (CheckNumber.ge.nCrwRemove.and.CheckNumber.le.nCrwGauss)) then
        nCrw=nCrwRemove
        do 1520CorrAbsNew=0,3
          if(CrwLogicQuest(nCrw)) go to 1400
          nCrw=nCrw+1
1520    continue
        CorrAbsNew=3
        go to 1400
      else if(CheckType.eq.EventCrw.and.
     1        (CheckNumber.eq.nCrwDefFormula.or.
     2         CheckNumber.eq.nCrwDefAmi)) then
        DefFormula=CrwLogicQuest(nCrwDefFormula)
        go to 1400
      else if(CheckType.eq.EventEdw.and.CheckNumber.eq.nEdwFormula) then
        Formula=EdwStringQuest(nEdwFormula)
        call PitFor(ich)
        if(ich.eq.0) go to 1500
        EventType=EventEdw
        EventNumber=nEdwFormula
        go to 1500
      else if(CheckType.eq.EventEdw.and.CheckNumber.eq.nEdwZ) then
        call FeQuestIntFromEdw(nEdwZ,nz)
        go to 1500
      else if(CheckType.eq.EventEdw.and.CheckNumber.eq.nEdwGrid) then
        call FeQuestIntAFromEdw(nEdwGrid,igauss)
        i=igauss(1)*igauss(2)*igauss(3)
        if(i.gt.mxgrid) then
          Veta='number of grid points'
          write(Cislo,FormI15) i
          call Zhusti(Cislo)
          Veta=Veta(:idel(Veta)+1)//Cislo(:idel(Cislo))//
     1        ' exceeds the limit'
          write(Cislo,FormI15) mxgrid
          call Zhusti(Cislo)
          Veta=Veta(:idel(Veta)+1)//Cislo(:idel(Cislo))
          call FeChybne(-1.,-1.,Veta,' ',0,SeriousError)
          EventType=EventEdw
          EventNumber=nEdwGrid
        endif
        go to 1500
      else if(CheckType.eq.EventButton.and.
     1        CheckNumber.eq.nButtEditFaces) then
        call ReadFaces(1,i,ich)
        if(ich.eq.0) then
          call FeQuestLabelRemove(id,xpoml,ill,Label,'L')
          write(Cislo,FormI15) nfaces
          call Zhusti(Cislo)
          Label(27:)=Cislo(:idel(Cislo))//' faces'
          call FeQuestLabelMake(id,xpoml,ill,Label,'L')
        endif
        EventType=EventEdw
        EventNumber=nEdwGrid
        call FeQuestButtonOff(CheckNumber)
        go to 1500
      else if(CheckType.eq.EventButton) then
        call DRCalcDenAbs(wmol,dx,ich)
        if(CheckNumber.eq.nButtCalculateDensity) then
          write(TextInfo(1),'(''Molecular weight : '',f8.2)') wmol
          write(TextInfo(2),'(''Calculated density ='',f7.3,
     1                        '' g.cm**(-3)'')') dx
          TextInfo(3)='Absorption coefficient mi'
          if(Radiation(1).eq.XRayRadiation) then
            if(klam(1).gt.0) then
              write(Veta,'(''('',a2,''-Kalfa) ='',f9.3,'' mm**-1'')')
     1          LamTypeD(klam(1)),ami
            else
              write(Veta,'('' ='',f9.3,'' mm**-1'')') ami
            endif
          else if(Radiation(1).eq.NeutronRadiation) then
            write(Veta,'('' ='',f9.6,'' mm**-1'')') ami
          endif
          TextInfo(3)=TextInfo(3)(:idel(TextInfo(3)))//
     1                Veta(:idel(Veta))
          Ninfo=3
          call FeInfoOut(-1.,-1.,'INFORMATION')
        else if(CheckNumber.eq.nButtCross) then
          xdq=210.
          idp=NextQuestId()
          ild=(NAtFormula-1)/2+4
          call FeQuestCreate(idp,-1.,-1.,xdq,0,ild,'Define atomic '//
     1                       'cross sections',0,LightGray,0,0)
          tpom=5.
          xpom=tpom+FeTxLength('XX')+3.
          dpom=50.
          spom=xpom+dpom+10.
          il=1
          do 1540i=1,NAtFormula
            if(il.eq.1) then
              call FeQuestLabelMake(idp,xpom,il,'User defined','L')
              call FeQuestLabelMake(idp,spom,il,'Tabulated','L')
            endif
            il=il+1
            call FeQuestEdwMake(idp,tpom,il,xpom,il,AtFormula(i,1),'L',
     1                          dpom,EdwYd,0)
            if(i.eq.1) nEdwFirst=EdwLastMade
            call FeQuestRealEdwOpen(EdwLastMade,AtAbsCoeff(i,KPhase),
     1                              .false.,.false.)
            j=5-Exponent10(AtAbsCoeffTab(i))
            j=min(13,j)
            j=max(0,j)
            write(RealFormat(6:7),'(i2)') j
            write(Cislo,RealFormat) AtAbsCoeffTab(i)
            call ZdrcniCisla(Cislo,1)
            call FeQuestLabelMake(idp,spom,il,Cislo,'L')
            if(il.eq.(NAtFormula-1)/2+2) then
              il=1
              xpom=xpom+xdq*.5
              tpom=tpom+xdq*.5
              spom=spom+xdq*.5
            endif
1540      continue
          il=ild-1
          call FeQuestLabelMake(idp,xdq*.5,il,
     1                          'Reset to tabulated values','C')
          il=il+1
          Veta='%Individual'
          dpom=FeTxLengthUnder(Veta)+5.
          xpom=xdq*.5-dpom-5.
          call FeQuestButtonMake(idp,xpom,il,dpom,ButYd,Veta)
          nButtIndividual=ButtonLastMade
          call FeQuestButtonOpen(ButtonLastMade,ButtonOff)
          Veta='%All'
          xpom=xdq*.5+5.
          call FeQuestButtonMake(idp,xpom,il,dpom,ButYd,Veta)
          nButtAdd=ButtonLastMade
          call FeQuestButtonOpen(ButtonLastMade,ButtonOff)
          icont=0
1550      call FeQuestEvent(idp,icont,ich)
          icont=1
          if(CheckType.eq.EventButton) then
            if(CheckNumber.eq.nButtIndividual) then
              i1=EdwActive-EdwFr+1
              i2=i1
            else
              i1=1
              i2=NAtFormula
            endif
            do 1560i=i1,i2
              AtAbsCoeff(i,KPhase)=AtAbsCoeffTab(i)
              nEdw=nEdwFirst+i-1
              call FeQuestRealEdwOpen(nEdw,AtAbsCoeff(i,KPhase),.false.,
     1                                .false.)
1560        continue
            EventType=EventEdw
            EventNumber=nEdwFirst+i1-1
            call FeQuestButtonOff(CheckNumber)
            go to 1550
          else if(CheckType.ne.0) then
            call NebylOsetren
            go to 1550
          endif
          if(ich.eq.0) then
            nEdw=nEdwFirst
            AtAbsCoeffOwn(KPhase)=.false.
            do 1580i=1,NAtFormula
              call FeQuestRealFromEdw(nEdw,AtAbsCoeff(i,KPhase))
              if(AtAbsCoeff(i,KPhase).gt.0.) then
                if(abs((AtAbsCoeff(i,KPhase)-AtAbsCoeffOld(i))/
     1                  AtAbsCoeff(i,KPhase)).gt..00001) Change=.true.
              else
                if(abs(AtAbsCoeff(i,KPhase)-AtAbsCoeffOld(i)).gt.
     1             abs(AtAbsCoeff(i,KPhase)+AtAbsCoeffOld(i)))
     2            Change=.true.
              endif
              if(AtAbsCoeff(i,KPhase).gt.0.) then
                if(abs((AtAbsCoeff(i,KPhase)-AtAbsCoeffTab(i))/
     1                  AtAbsCoeff(i,KPhase)).gt..00001)
     2            AtAbsCoeffOwn(KPhase)=.true.
              else
                if(abs(AtAbsCoeff(i,KPhase)-AtAbsCoeffTab(i)).gt.
     1             abs(AtAbsCoeff(i,KPhase)+AtAbsCoeffTab(i)))
     2            AtAbsCoeffOwn(KPhase)=.true.
              endif
              nEdw=nEdw+1
1580        continue
          endif
          call FeQuestRemove(idp)
        endif
        call FeQuestButtonOff(CheckNumber)
        go to 1480
      else if(CheckType.ne.0) then
        call NebylOsetren
        go to 1500
      endif
      if(ich.eq.0) then
        if(.not.Change)
     1    call CopyVek(AtAbsCoeffOld,AtAbsCoeff(1,KPhase),NAtFormula)
        if(DefFormula) then
          call DRCalcDenAbs(wmol,dx,ich)
          if(ich.ne.0) then
            call FeChybne(-1.,-1.,'in calculation of the absorption '//
     1                    'coefficient.','Check your formula.',0,
     1                    SeriousError)
            go to 9900
          endif
        else
          call FeQuestRealFromEdw(nEdwAmi,ami)
        endif
        if(CorrAbsNew.eq.1.or.CorrAbsNew.eq.2) then
          if(CorrAbsNew.eq.1) then
            nEdw=nEdwRadSphere
          else
            nEdw=nEdwRadCylinder
          endif
          call FeQuestRealFromEdw(nEdw,radiusDatRed)
        endif
        call iom94(1)
      endif
      call FeQuestRemove(id)
      if(ich.ne.0) go to 9900
      call abskor(CorrAbsNew,ich)
      if(ich.ne.0) go to 9900
      CorrAbs=CorrAbsNew
      call iom94(1)
      call OpenFile(89,fln(:ifln)//'_datred.tmp','formatted','old')
      if(ErrJana.ne.0) go to 9999
      do 3000i=1,4
        read(89,FormA80) Veta
        TextInfo(i)=Veta
3000  continue
      TextInfo(4)='absorption:'
      if(abmin.le.0.or.abmax.le.0.) then
        abmin=1.
        abmax=1.
      endif
      write(TextInfo(4)(13:),'(i2,3f9.4)') CorrAbsNew,ami,abmin,abmax
      rewind 89
      do 4110i=1,4
        write(89,FormA1)(TextInfo(i)(j:j),j=1,idel(TextInfo(i)))
4110  continue
      write(89,'(''end'')')
      call CloseIfOpened(89)
      go to 9999
9900  ErrJana=1
9999  return
      end
      subroutine AbsKor(klic,ich)
      include 'params.cmn'
      include 'basic.cmn'
      include 'datred.cmn'
      include 'fepc.cmn'
      dimension ab(19)
      character*80 t80
      integer Exponent10
      if(klic.eq.0.and.CorrAbs.eq.0) go to 9999
      if(klic.eq.1.or.klic.eq.2) then
        Volg=1.333333*pi*radiusDatRed**3*1.e-3/CellVol(1,KPhase)
        rmi=ami*radiusDatRed
        if(klic.eq.1) then
          pom=rmi*10.+1.
          n=pom
          pom=pom-float(n)
          if(n.gt.100) then
            call FeChybne(-1.,-1.,'too high mi*r for spherical sample',
     1                    'data will not be corrected',0,SeriousError)
            go to 9999
          endif
          do 1010j=1,19
            ab(j)=abskou(j,n)+pom*(abskou(j,n+1)-abskou(j,n))
1010      continue
        endif
      else if(klic.eq.3) then
        if(nfaces.le.3) then
          call FeChybne(-1.,-1.,'number of faces is not sufficient '//
     1                  'to make the correction',' ',0,SeriousError)
          go to 9999
        endif
      endif
      if(klic.eq.0) then
        t80=' - none'
      else if(klic.eq.1) then
        t80=' - spherical sample'
      else if(klic.eq.2) then
        t80=' - cylindrical sample'
      else
        t80=' - general shape'
      endif
      t80='Absorption correction'//t80
      call OpenFile(95,fln(:ifln)//'.m95','formatted','old')
      if(ErrJana.ne.0) go to 9999
      call PrvniM95(ich)
      if(ich.ne.0) go to 9999
      call OpenFile(96,fln(:ifln)//'.l95','formatted','unknown')
      if(ErrJana.ne.0) go to 9999
      call FeFlowChartOpen(-1.,-1.,max(nint(float(nref95)*.005),10),
     1                     nref95,t80,' ',' ')
      if(klic.eq.3) then
        call grit
        pom=0.
        do 2180i=1,3000
          if(pom.lt.70.) then
            epoa(i)=exp(-pom)
          else
            epoa(i)=0.
          endif
          pom=pom+.1
2180    continue
        pom=0.
        do 2200i=1,1000
          epob(i)=exp(-pom)
          pom=pom+.0001
2200    continue
      endif
      abmax=-1.
      abmin=1.e20
      iz=0
3000  call DRGetReflectionFromM95(95,iend,ich)
      if(ich.ne.0) go to 9000
      if(iend.ne.0) go to 4000
      call FeFlowChartEvent(iz,is)
      if(is.ne.0) then
        call FeBudeBreak
        if(ErrJana.ne.0) go to 9999
      endif
      if(klic.ne.0) then
        sinchi=sin(chi*torad)
        sinom=sin((omega-theta)*torad)
      else
        Corrf(2)=1.
      endif
      if(klic.eq.1.or.klic.eq.2) then
        d1=.2*theta+1.
        j=d1
        d1=d1-float(j)
        if(klic.eq.1) then
          corrf(2)=ab(j)+d1*(ab(j+1)-ab(j))
        else if(klic.eq.2) then
          csni=sqrt(1.-(sinchi*sinom)**2)
          d2=ami*radiusDatRed*10./csni+1.
          i=d2
          d2=d2-float(i)
          corrf(2)=absval(j,i)+d1*(absval(j+1,i)-absval(j,i))+
     1                         d2*(absval(j,i+1)-absval(j,i))+
     2                         d1*d2*(absval(j+1,i+1)+absval(j,i)-
     3                                absval(j+1,i)-absval(j,i+1))
        endif
      else if(klic.eq.3) then
        do 3200i=1,3
          sod(i)=dircos(i,1)*rcp(i,1,KPhase)
          sd(i) =dircos(i,2)*rcp(i,1,KPhase)
3200    continue
        call length2
      endif
      abmin=min(abmin,1./corrf(2))
      abmax=max(abmax,1./corrf(2))
3500  call DRPutReflectionToM95(96)
      go to 3000
4000  call CloseIfOpened(95)
      call CloseIfOpened(96)
      call MoveFile(fln(:ifln)//'.l95',fln(:ifln)//'.m95',.false.)
      call FeFlowChartRemove
      write(TextInfo(1),'(''  T(min) : '',f7.4,''  T(max) : '',f7.4)')
     1      abmin,abmax
      if(Klic.eq.0) then
        NInfo=1
      else
        Ninfo=2
        pom=volg*1.e3*CellVol(1,KPhase)
        i=max(6-Exponent10(pom),0)
        write(t80,'(''(f10.'',i1,'')'')') min(i,8)
        write(TextInfo(2),t80) pom
        TextInfo(2)='   Crystal volume :'//TextInfo(2)(:10)//' mm**3'
      endif
      call FeInfoOut(-1.,-1.,'Transmission extremes')
      go to 9999
9000  call FeReadError(95)
9999  call DeleteFile(fln(:ifln)//'.l95')
      call CloseIfOpened(95)
      call CloseIfOpened(89)
      return
      end
      subroutine DRCalcDenAbs(wmol,dx,ich)
      include 'params.cmn'
      include 'basic.cmn'
      include 'datred.cmn'
      character*80 t80
      wmol=0.
      ami=0.
      ich=0
      do 1100i=1,NAtFormula
        call RealFromAtomFile(AtFormula(i,KPhase),'atweight',pomw,0,
     1                        ich)
        if(ich.ne.0) go to 9900
        call CrlReadAbsCoeff(AtFormula(i,KPhase),AtAbsCoeffTab(i),ich)
        if(ich.ne.0) go to 9900
        if(.not.AtAbsCoeffOwn(KPhase))
     1    AtAbsCoeff(i,KPhase)=AtAbsCoeffTab(i)
        wmol=wmol+pomw              * AtMult(i,KPhase)
        ami=ami+AtAbsCoeff(i,KPhase)* AtMult(i,KPhase)*.1
1100  continue
      dx=float(nz)*wmol*1.66/CellVol(1,KPhase)
      ami=ami*float(nz)/CellVol(1,KPhase)
      go to 9999
9900  ich=1
9999  return
      end
      subroutine ReadFaces(Klic,nfaceso,ich)
      include 'params.cmn'
      include 'basic.cmn'
      include 'datred.cmn'
      include 'fepc.cmn'
      dimension dfaceo(4,mxface),rmp(9),rmpi(9)
      character*256 EdwStringQuest,FileName
      character*80 t80,p80
      character*2 nty
      logical FeYesNo,eqrv,TextFile
      data FileName/' '/
      ich=0
      nfaceso=nfaces
      call CopyVek(dface,dfaceo,4*nfaces)
      il=13
      xqd =180.
      xqdp=xqd*.5
      id=NextQuestId()
      call FeQuestCreate(id,-1.,-1.,xqd,0,il,'Face specification',0,
     1                   LightGray,0,0)
      xpom=167.
      call FeQuestUpDownMake(id,xpom,10,UpDownXd,UpDownYd,'down')
      nDown=UpDownLastMade
      call FeQuestUpDownMake(id,xpom, 0,UpDownXd,UpDownYd,'up')
      nUp=UpDownLastMade
      il=1
      call FeQuestLabelMake(id, 55.,il,'Indices','L')
      call FeQuestLabelMake(id,130.,il,'d [mm]','L')
      tpom=5.
      xpom1= 50.
      xpom2=125.
      dpom1= 70.
      dpom2= 50.
      do 1100i=1,8
        il=il+1
        write(t80,100) i,nty(i)
        call FeQuestEdwMake(id,tpom,il,xpom1,il,t80,'L',dpom1,EdwYd,1)
        if(i.eq.1) nEdwFirst=EdwLastMade
        call FeQuestEdwMake(id,tpom,il,xpom2,il,' ','L',dpom2,EdwYd,1)
1100  continue
      il=il+2
      t80='Add %opposite'
      dpom=FeTxLengthUnder(t80)+10.
      p80='%Delete face'
      tpom=(FeTxLengthUnder(p80)+10.)*.5
      xpom=xqdp-dpom-tpom-10.
      call FeQuestButtonMake(id,xpom,il,dpom,ButYd,t80)
      nButtOpposite=ButtonLastMade
      call FeQuestButtonOpen(ButtonLastMade,ButtonOff)
      xpom=xqdp-tpom
      call FeQuestButtonMake(id,xpom,il,2*tpom,ButYd,p80)
      nButtDelete=ButtonLastMade
      call FeQuestButtonOpen(ButtonLastMade,ButtonOff)
      t80='Add %clone'
      xpom=xqdp+tpom+10.
      call FeQuestButtonMake(id,xpom,il,dpom,ButYd,t80)
      nButtClone=ButtonLastMade
      call FeQuestButtonOpen(ButtonLastMade,ButtonOff)
      il=il+1
      t80='%Transformation'
      dpom=FeTxLengthUnder('XXXXXXXXXXXXXXXXXX')+10.
      xpom=xqdp-dpom-5.
      call FeQuestButtonMake(id,xpom,il,dpom,ButYd,t80)
      nButtTransform=ButtonLastMade
      call FeQuestButtonOpen(ButtonLastMade,ButtonOff)
      t80='%Revert to original'
      xpom=xqdp+5.
      call FeQuestButtonMake(id,xpom,il,dpom,ButYd,t80)
      nButtOriginal=ButtonLastMade
      call FeQuestButtonOpen(ButtonLastMade,ButtonOff)
      il=il+1
      t80='Read from %file'
      xpom=xqdp-dpom*.5
      call FeQuestButtonMake(id,xpom,il,dpom,ButYd,t80)
      nButtReadFile=ButtonLastMade
      call FeQuestButtonOpen(ButtonLastMade,ButtonOff)
      ik=0
1200  icont=0
      iz=ik+1
      ik=min(ik+8,mxface)
1205  nEdw=nEdwFirst
      do 1210i=iz,ik
        call FeQuestRealAEdwOpen(nEdw,dface(1,i),3,i.gt.nfaces,.false.)
        nEdw=nEdw+1
        call FeQuestRealEdwOpen(nEdw,dface(4,i),i.gt.nfaces,.false.)
        nEdw=nEdw+1
1210  continue
1250  if(iz.gt.1) then
        call FeQuestUpDownOff(nUp)
      else
        call FeQuestUpDownDisable(nUp)
      endif
      if(nfaces.ge.ik.and.mxface.gt.ik) then
        call FeQuestUpDownOff(nDown)
      else
        call FeQuestUpDownDisable(nDown)
      endif
1300  call FeQuestEvent(id,icont,ich)
      icont=1
1310  if(CheckType.eq.EventEdw.and.CheckNumber.le.16) then
        nEdw=CheckNumber
        im=mod(nEdw,2)
        il=(nEdw-1)/2+iz
        if(EdwStringQuest(nEdw).eq.' ') then
          if(il.le.nfaces) then
            if(im.eq.1) then
              do 1330i=il+1,nfaces
                call CopyVek(dface(1,i),dface(1,i-1),4)
1330          continue
              nfaces=nfaces-1
            else
              call FeChybne(-1.,-1.,'to remove the face you have to'//
     1                      ' delete thier indices',' ',0,SeriousError)
              EventType=EventEdw
              EventNumber=nEdw-1
            endif
            go to 1205
          else
            go to 1300
          endif
        else
          call FeQuestRealAFromEdw(nEdw,dface(4-3*im,il))
          if(il.gt.nfaces) then
            nfaces=nfaces+1
            if(il.gt.nfaces)
     1        call FeQuestRealAEdwOpen(nEdw,dface(4-3*im,il),3,.true.,
     2                                 .false.)
            if(nfaces.ge.ik) go to 1250
          endif
        endif
        go to 1300
      endif
      if(CheckType.eq.EventButton) then
        call FeQuestButtonOff(CheckNumber)
        if(CheckNumber.eq.nButtOpposite.or.CheckNumber.eq.nButtClone)
     1    then
          call FeQuestButtonOff(CheckNumber)
          il=min((KurzorEdw-1)/2+iz,nfaces)
          nfaces=nfaces+1
          call CopyVek(dface(1,il),dface(1,nfaces),4)
          if(CheckNumber.eq.nButtOpposite) then
            do 1340i=1,3
              dface(i,nfaces)=-dface(i,nfaces)
1340        continue
          endif
          if(ik.ge.nfaces) go to 1550
          j=((nfaces-1)/8+1)*8-ik
          go to 1500
        else if(CheckNumber.eq.nButtDelete) then
          il=(KurzorEdw-1)/2+iz
          do 1350i=il+1,nfaces
            call CopyVek(dface(1,i),dface(1,i-1),4)
1350      continue
          nfaces=nfaces-1
          EventType=EventEdw
          EventNumber=KurzorEdw
          go to 1205
        else if(CheckNumber.eq.nButtOriginal) then
          NFaces=NFacesR
          call CopyVek(DFaceR,DFace,4*NFaces)
          call FeQuestButtonOff(nButtOriginal)
          ik=0
          go to 1200
        else if(CheckNumber.eq.nButtReadFile) then
          idp=NextQuestId()
          call FeQuestCreate(idp,-1.,-1.,170.,0,2,
     1                       'Read faces from file',0,LightGray,0,0)
          call FeQuestEdwMake(idp,5.,1,30.,1,'File:','L',100.,EdwYd,0)
          nEdwName=EdwLastMade
          call FeQuestStringEdwOpen(nEdwName,FileName)
          call FeQuestButtonMake(idp,135.,1,30.,ButYd,'%Browse')
          nButtBrowse=ButtonLastMade
          call FeQuestButtonOpen(ButtonLastMade,ButtonOff)
1400      icont=0
1410      call FeQuestEvent(idp,icont,ich)
          icont=1
          if(CheckType.eq.EventButton.and.CheckNumber.eq.nButtBrowse)
     1      then
            call FeQuestButtonOff(nButtBrowse)
            call FeMouseShape(3)
            call FeFileManager('Select file with bounding planes',
     1                         FileName,'*',0,.true.,ich)
            if(ich.le.0.and.idel(FileName).gt.0)
     1        call FeQuestStringEdwOpen(nEdwName,FileName)
            go to 1400
          else if(CheckType.ne.0) then
            call NebylOsetren
            go to 1410
          endif
          if(ich.eq.0) FileName=EdwStringQuest(nEdwName)
          call FeQuestRemove(idp)
          if(ich.ne.0.or.idel(FileName).le.0) go to 1460
          call CheckEOLOnFile(FileName,2)
          if(ErrJana.ne.0) go to 1460
          ln=NextLogicNumber()
          call OpenFile(ln,FileName,'formatted','old')
          if(ErrJana.ne.0) go to 1460
          Labeled=0
          TextFile=.false.
1420      read(ln,FormA80,end=1425) t80
          p80=t80
          call velka(p80)
          call mala(t80)
          if(p80.ne.t80) TextFile=.true.
          k=0
          call kus(t80,k,Cislo)
          if(Cislo.eq.'shape') then
            call kus(t80,k,Cislo)
            Labeled=1
          else
            Labeled=0
          endif
          if(Cislo.eq.'face') then
            Labeled=Labeled+1
            go to 1425
          else
            go to 1420
          endif
1425      nfaces=0
          rewind ln
          if(Labeled.eq.0.and.TextFile) then
            call FeChybne(-1.,-1.,'the file doesn''t contain any face',
     1                    ' ',0,Warning)
            go to 1450
          endif
1430      read(ln,FormA80,end=1440) t80
          if(idel(t80).le.0) go to 1430
          call mala(t80)
          k=0
          if(Labeled.ne.0) then
            call kus(t80,k,Cislo)
            if(Labeled.eq.2) then
              if(Cislo.ne.'shape') go to 1430
              call kus(t80,k,Cislo)
            endif
            if(Cislo.ne.'face') go to 1430
          endif
          if(nfaces.ge.mxface) then
            write(Cislo,'(i5)') mxface
            call zhusti(Cislo)
            t80='number of faces exceeds the limit'
            p80='Only first '//Cislo(:idel(Cislo))//' faces read in'
            call FeChybne(-1.,-1.,t80,p80,0,Warning)
            go to 1440
          endif
          nfaces=nfaces+1
          call StToReal(t80,k,dface(1,nfaces),4,.false.,ich)
          if(ich.ne.0) then
            go to 1450
          else
            do 1432i=1,3
              dface(i,nfaces)=anint(dface(i,nfaces)*1000.)/1000.
1432        continue
            dface(4,nfaces)=anint(dface(4,nfaces)*10000.)/10000.
            go to 1430
          endif
1440      call CloseIfOpened(ln)
          ik=0
          go to 1200
1450      call FeReadError(ln)
          nfaces=0
1460      icont=0
          go to 1300
        else if(CheckNumber.eq.nButtTransform) then
          call FeQuestButtonOff(CheckNumber)
          call UnitMat(rmp,3)
          call FeReadRealMat(-1.,-1.,'Transformation matrix',Indices,
     1                       IdAddPrime,rmp,rmpi,3,CheckSingYes,
     2                       CheckPosDefNo,ich)
          if(ich.eq.0) then
            do 1480i=1,nfaces
              call CopyVek(dface(1,i),rmpi,3)
              call Multm(rmpi,rmp,dface(1,i),1,3,3)
1480        continue
          endif
          go to 1550
        endif
      else if(CheckType.eq.EventUpDown) then
        if(CheckNumber.eq.nDown) then
          j= 8
        else
          j=-8
        endif
        call FeMouseShape(3)
        go to 1500
      else if(CheckType.ne.0) then
        call NebylOsetren
        go to 1300
      endif
      go to 1600
1500  nEdw=nEdwFirst
      do 1510i=iz,ik
        write(t80,100) i+j,nty(i+j)
        call FeQuestEdwLabelChange(id,nEdw,t80)
        nEdw=nEdw+2
1510  continue
      iz=iz+j
      ik=ik+j
1550  EventType=EventEdw
      EventNumber=max(2*min(nfaces-iz+1,8)-1,1)
      go to 1205
1600  call FeQuestRemove(id)
      if(ich.ne.0) then
        go to 9000
      else
        if(Klic.eq.1) then
          if(nfaces.ne.nfaceso) go to 7100
          do 7050i=1,nfaces
            if(.not.eqrv(dface(1,i),dfaceo(1,i),3,.001).or.
     1         abs(dface(4,i)-dfaceo(4,i)).gt..0001) go to 7100
7050      continue
          go to 9999
7100      if(FeYesNo(-1.,-1.,'Do you want to save faces?',0))
     1      then
            call iom94(1)
            go to 9999
          else
            ich=1
            go to 9000
          endif
        endif
        go to 9999
      endif
9000  nfaces=nfaceso
      call CopyVek(dfaceo,dface,4*nfaces)
9999  return
100   format(i2,a2,' face')
      end
      subroutine grit
      include 'params.cmn'
      include 'basic.cmn'
      include 'datred.cmn'
      dimension gu(3,3),sum(mxface),temp(3),xg(128,3),wg(128,3),xuz(3),
     1          xcz(3),abound(3,3),dist(3),bbound(2,2),di(2),xyz(3),
     2          cbound(3,3),dbound(2,2)
      logical inside
      xomi= 100.
      yomi= 100.
      zomi= 100.
      xoma=-100.
      yoma=-100.
      zoma=-100.
      call multm(ub,MetTens(1,1,KPhase),gu,3,3,3)
      do 1100i=1,nfaces
        call multm(MetTensI(1,1,KPhase),dface(1,i),temp,3,3,1)
        sum(i)=sqrt(scalmul(dface(1,i),temp))
        dface4(i)=dface(4,i)*sum(i)*.1
1100  continue
      do 1200i=1,3
        call gauleg(0.,1.,xg(1,i),wg(1,i),igauss(i))
1200  continue
      npoints=0
      volg=0.
      xmin= 999999.
      xmax=-999999.
      do 2200k=1,nfaces-2
        do 1300i=1,3
          abound(1,i)=dface(i,k)
1300    continue
        do 2100l=k+1,nfaces-1
          do 1400i=1,3
            abound(2,i)=dface(i,l)
1400      continue
          do 2000m=l+1,nfaces
            do 1500i=1,3
              abound(3,i)=dface(i,m)
1500        continue
            call matinv(abound,cbound,det,3)
            if(det.eq.0.) go to 2000
            dist(1)=dface4(k)
            dist(2)=dface4(l)
            dist(3)=dface4(m)
            call multm(cbound,dist,xyz,3,3,1)
            if(.not.inside(xyz,sum)) go to 2000
            call multm(gu,xyz,xuz,3,3,1)
            do 1600i=1,3
              xcz(i)=xyz(i)*CellDatRed(i,1)
1600        continue
            xomi=min(xcz(1),xomi)
            xoma=max(xcz(1),xoma)
            yomi=min(xcz(2),yomi)
            yoma=max(xcz(2),yoma)
            zomi=min(xcz(3),zomi)
            zoma=max(xcz(3),zoma)
            xx=xyz(1)
            xmin=min(xmin,xx)
            xmax=max(xmax,xx)
2000      continue
2100    continue
2200  continue
      nia=igauss(1)
      do 5200npaa=1,nia
        if(nia.gt.1) then
          xyz(1)=xmin+(xmax-xmin)*xg(npaa,1)
          r1=wg(npaa,1)*(xmax-xmin)
        endif
        ymin= 999999.
        ymax=-999999.
        do 3100k=1,nfaces-1
          bbound(1,1)=dface(2,k)
          bbound(1,2)=dface(3,k)
          di(1)=dface4(k)-dface(1,k)*xyz(1)
          do 3000l=k+1,nfaces
            bbound(2,1)=dface(2,l)
            bbound(2,2)=dface(3,l)
            call matinv(bbound,dbound,det,2)
            if(det.eq.0.) go to 3000
            di(2)=dface4(l)-dface(1,l)*xyz(1)
            xyz(2)=dbound(1,1)*di(1)+dbound(1,2)*di(2)
            xyz(3)=dbound(2,1)*di(1)+dbound(2,2)*di(2)
            if(inside(xyz,sum)) then
              xx=xyz(2)
              ymin=min(ymin,xx)
              ymax=max(ymax,xx)
            endif
3000      continue
3100    continue
        nib=igauss(2)
        do 5100npb=1,nib
          xyz(2)=ymin+(ymax-ymin)*xg(npb,2)
          r2=wg(npb,2)*r1*(ymax-ymin)
          zmin= 999999.
          zmax=-999999.
          do 4000i=1,nfaces
            if(dface(3,i).eq.0.) go to 4000
            xyz(3)=(dface4(i)-xyz(1)*dface(1,i)-xyz(2)*dface(2,i))/
     1               dface(3,i)
            if(inside(xyz,sum)) then
              xx=xyz(3)
              zmin=min(zmin,xx)
              zmax=max(zmax,xx)
            endif
4000      continue
          nic=igauss(3)
          deltaz=zmax-zmin
          do 5000npc=1,nic
            npoints=npoints+1
            gridp(1,npoints)=xyz(1)
            gridp(2,npoints)=xyz(2)
            gridp(3,npoints)=zmin+deltaz*xg(npc,3)
            gridp(4,npoints)=wg(npc,3)*r2*deltaz
            volg=volg+gridp(4,npoints)
5000      continue
5100    continue
5200  continue
      return
      end
      logical function inside(xyz,sum)
      include 'params.cmn'
      include 'basic.cmn'
      include 'datred.cmn'
      dimension xyz(3),sum(*),xp(3)
      inside=.true.
      if(xyz(1).eq.0..and.xyz(2).eq.0..and.xyz(3).eq.0.) go to 9999
      call multm(MetTens(1,1,KPhase),xyz,xp,3,3,1)
      r=sqrt(scalmul(xyz,xp))
      do 1200j=1,nfaces
c      to tam puvodne bylo a v pripade, ze bylo referencni bod na trech
c      plochach tak to zlobilo
c      if(dface4(j).eq.0.) go to 1200
        chck=scalmul(dface(1,j),xyz)
        cfi=chck/(sum(j)*r)
        if(cfi.le.0.) go to 1200
        if(dface4(j)-chck+0.000001.lt.0.) then
          inside=.false.
          go to 9999
        endif
1200  continue
9999  return
      end
      subroutine length2
      include 'params.cmn'
      include 'basic.cmn'
      include 'datred.cmn'
      dimension gg(50),hh(50),cosin(50),cosout(50)
      dimension nin(26),nout(26)
      double precision suma1,suma2
      mo=1
      lo=1
      suma1=0.
      suma2=0.
      do 1000k=1,nfaces
        cosin (mo)=scalmul(sod,dface(1,k))
        cosout(lo)=scalmul(sd, dface(1,k))
        if(cosin(mo).lt.0.) then
          nin(mo)=k
          mo=mo+1
        endif
        if(cosout(lo).gt.0) then
          nout(lo)=k
          lo=lo+1
        endif
1000  continue
      lo=lo-1
      mo=mo-1
      do 2000l=1,npoints
        do 1100k=1,mo
          gg(k)=-(dface4(nin(k))-scalmul(gridp(1,l),dface(1,nin(k))))/
     1            cosin(k)
1100    continue
        do 1200k=1,lo
          hh(k)= (dface4(nout(k))-scalmul(gridp(1,l),dface(1,nout(k))))/
     1            cosout(k)
1200    continue
        gk=gg(1)
        do 1300k=1,mo
          gk=min(gk,gg(k))
1300    continue
        gk=max(0.,gk)
        hk=hh(1)
        DO 1400k=1,lo
          hk=min(hk,hh(k))
1400    continue
        hk=max(0.,hk)
        eur=(gk+hk)*ami*100.
        mur=eur
        lur=nint((eur-float(mur))*1000.)
        if(lur.gt.999) then
          lur=lur-1000
          mur=mur+1
        endif
        a=epoa(mur+1)
        b=epob(lur+1)
        ab=a*b*gridp(4,l)
        suma1=suma1+ab*(gk+hk)
        suma2=suma2+ab
2000  continue
      tbar=suma1/suma2
      corrf(2)=volg/suma2
      return
      end
      subroutine DRExport(Key,flnp)
      include 'params.cmn'
      include 'basic.cmn'
      include 'datred.cmn'
      include 'fepc.cmn'
      character*(*) flnp
      character*80 OutFile,InFile,Text,OutFormat
      integer FeSelectOnePossibility
      logical FeYesNo,FeYesNoHeader,ExistFile,OnlyMain,First,FromM91
      equivalence (OutFile,OurFormat)
      if(flnp.eq.' ') then
        OutFile=fln(:ifln)//'.hkl'
      else
        OutFile=flnp(:idel(flnp))//'.hkl'
      endif
      FromM91=.false.
1000  if(Key.le.0) then
        Infile=fln(:ifln)//'.m95'
        Text='Exporting reflections for SHELX'
        if(Key.eq.0) then
          nrefp=nref95
          call FeFileManager('Select output SHELX reflection file',
     1                       OutFile,'*.hkl',0,.true.,ich)
          if(ich.ne.0) go to 9999
          if(ndimi.gt.0) then
            OnlyMain=FeYesNo(-1.,-1.,'Do you want to export only main '
     1                     //'reflections?',1)
          else
            OnlyMain=.true.
          endif
        else
          OnlyMain=.false.
          if(ExistM95) then
            NInfo=2
            TextInfo(1)='export from reflection file M9%5'
            TextInfo(2)='export from reflection file M9%1'
            idflt=1
            i=FeSelectOnePossibility(-1.,-1.,0,idflt)
            FromM91=i.ne.1
          else
            FromM91=.true.
          endif
          if(FromM91) then
            Infile=fln(:ifln)//'.m91'
            nrefp=nref91
          else
            call iom94(0)
            nrefp=nref95
          endif
        endif
      else
        OutFile=fln(:ifln)//'.psi'
        Infile=fln(:ifln)//'.m96'
        Text='Exporting "psi" file for X-shape'
        OnlyMain=.true.
        nrefp=nref96
      endif
      if(ExistFile(OutFile).and.Key.ge.0) then
        NInfo=1
        TextInfo(1)='File "'//OutFile(:idel(OutFile))//
     1              '" already exists'
        if(.not.FeYesNoHeader(-1.,-1.,'Do you want to rewrite it?',0))
     1    then
          if(Key.eq.0) then
            go to 1000
          else
            go to 9999
          endif
        endif
      endif
      call OpenFile(95,InFile,'formatted','old')
      if(Errjana.ne.0) go to 9999
      call OpenFile(90,OutFile,'formatted','unknown')
      if(Errjana.ne.0) go to 9999
      OutFormat=FormatShelx
      ndimp=ndim
      if(OnlyMain) then
        OutFormat(2:2)='3'
        ndimp=3
      endif
      scf=.1
      iq=1
1500  if(.not.FromM91) then
        call PrvniM95(ich)
        if(ich.ne.0) go to 9999
      endif
      call FeFlowChartOpen(-1.,-1.,max(nint(float(nrefp)*.005),10),
     1                     nrefp,Text,' ',' ')
      iz=0
      First=.true.
      sdircos=0.
      nn=0
2000  if(FromM91) then
        read(95,format91,end=3000,err=9000)(ih(i),i=1,ndim),ri,rs
        if(ih(1).gt.900) go to 3000
        ri=ri*scf
        rs=rs*scf
      else
        call DRGetReflectionFromM95(95,iend,ich)
        if(ich.ne.0) go to 9000
        if(iend.ne.0) go to 3000
        if(no.gt.0.and.(Key.ne.1.or.ri.gt.10.*rs)) then
          if(iflg(1).lt.0) go to 2000
          call indtr(ih,trmp,ihp,ndim)
          if(ihp(1).gt.900) go to 2000
          call CopyVekI(ihp,ih,ndim)
          if(Key.le.0) then
            pom=corrf(1)*corrf(2)*scf
          else
            pom=scf
          endif
          ri=ri*pom
          rs=rs*pom
        else
          go to 2000
        endif
        if(First) then
          First=.false.
          sdircos=0.
          do 2100i=1,3
            sdircos=sdircos+abs(dircos(i,1))
2100      continue
        endif
      endif
      if(ri.gt.99999.99) then
        rewind 95
        rewind 90
        call FeFlowChartRemove
        scf=scf*.1
        go to 1500
      endif
      call FeFlowChartEvent(iz,is)
      if(is.ne.0) then
        call FeBudeBreak
        if(ErrJana.ne.0) then
          close(90,status='delete')
          go to 9999
        endif
      endif
      if(OnlyMain) then
        do 2200i=4,ndim
          if(ihp(i).ne.0) go to 2000
2200    continue
      endif
      if(sdircos.gt..001) then
        write(90,OutFormat)(ih(i),i=1,ndimp),ri,rs,iq,
     1                     (-dircos(i,1),dircos(i,2),i=1,3)
      else
        write(90,OutFormat)(ih(i),i=1,ndimp),ri,rs,iq
      endif
      nn=nn+1
      go to 2000
3000  write(90,OutFormat)(0,i=1,ndimp),0.,0.,0
      call FeFlowChartRemove
      if(Key.eq.1) then
        write(TextInfo(1),'(''"psi" file contains'',i5,'' reflections''
     1                      )') nn
        Ninfo=1
        call FeInfoOut(-1.,-1.,'INFORMATION')
      endif
      go to 9999
9000  call FeFlowChartRemove
      call FeReadError(95)
9999  call CloseIfOpened(90)
      call CloseIfOpened(95)
      return
      end
      subroutine CellTr
      include 'params.cmn'
      include 'basic.cmn'
      include 'datred.cmn'
      include 'fepc.cmn'
      include 'atoms.cmn'
      include 'molec.cmn'
      include 'editm40.cmn'
      include 'powder.cmn'
      dimension TrMpA(36),CellA(6),TrMpS(36),CellS(6),
     1          TrMpO(36),CellO(6),
     2          xp(9),t(36),ti(36),trm6(36),trm6i(36),
     2          rmp(36),hp(3),h(6),hf(6),dif(3),trm3(3,3),trm3i(3,3),
     3          StPom(15)
      character*80 t80
      character*40 men1(0:5)
      integer FeMenu
      logical FeYesNo,eqrv,ExistFile
      equivalence (trm,trm6i)
      data men1/'%Exit from cell transformation routine',
     1          'Transformation by %matrix',
     2          'Transformation to %doubled cell',
     3          'Transformation to %reduced cell',
     4          'Return to the cell from data %collection',
     5          'One step %back'/
      if(ExistM94) then
        call iom94(0)
      else
        call UnitMat(TrMp,ndim)
      endif
      call CopyMat(TrMp,TrMpA,ndim)
      if(ExistM50) then
        call iom50(0,0)
        call CopyVek(CellPar(1,1,KPhase),CellA,6)
      else
        call CopyVek(CellDatRed(1,3),CellA,6)
      endif
      call kopcltr(TrMpA,TrMpS,CellA,CellS)
      imen1=4
      call CellInfo(CellA)
1100  i=FeMenu(-1.,-1.,men1,0,imen1,0,0)
      if(i.gt.0.and.i.lt.5) then
        call kopcltr(TrMpA,TrMpO,CellA,CellO)
        imen1=5
      endif
      if(i.eq.0) then
        if(.not.eqrv(CellA,CellS,6,.001).or.
     1     .not.eqrv(TrMpA,TrMpS,ndimq,.001)) then
          if(FeYesNo(-1.,-1.,'Do you want to accept transformed '//
     1               'parameters?',1)) then
            call MatInv(TrMpS,TrMpO,pom,ndim)
            call MultM(TrMpO,TrMpA,trm6,ndim,ndim,ndim)
            call matinv(trm6,trm6i,pom,ndim)
            call MatBlock3(trm6,trm3,ndim)
            call matinv(trm3,trm3i,VolRatio,3)
            call CopyMat(TrMpA,TrMp,ndim)
            if(ExistM94) then
              call UnitMat(t,ndim)
              call TrPar(trm3,CellDatRed(1,2),t)
              if(ExistM50) then
                call TrPar(trm3,CellDatRed(1,3),t)
              else
                call CopyVek(CellA,CellDatRed(1,3),6)
              endif
              do 1140j=2,3
                do 1130i=1,ndimi
                  call CopyVek(QuDatRed(1,i,j),xp,3)
                  call multm(xp,trm3,QuDatRed(1,i,j),1,3,3)
1130            continue
1140          continue
            endif
            if(ExistM50) then
              call CopyVek(Cella,CellPar(1,1,KPhase),6)
              if(isPowder) call CopyVek(Cella,CellPwd(1,KPhase),6)
              do 1150i=1,ndimi
                if(ndimi.eq.1) then
                  call CopyVek(Quir(1,i,KPhase),xp,3)
                  call multm(xp,trm3,Quir(1,i,KPhase),1,3,3)
                endif
                call CopyVek(Qui(1,i,KPhase),xp,3)
                call multm(xp,trm3,Qui(1,i,KPhase),1,3,3)
                call CopyVek(Qu(1,i,1,KPhase),xp,3)
                call multm(xp,trm3,Qu(1,i,1,KPhase),1,3,3)
                if(isPowder) then
                  call CopyVek(QuPwd(1,i,KPhase),xp,3)
                  call multm(xp,trm3,QuPwd(1,i,KPhase),1,3,3)
                endif
1150          continue
            endif
            if(ns.gt.0) then
              n=0
              do 1170i=1,ns
                call multm(trm6i,rm6(1,i,1,KPhase),rmp,ndim,ndim,ndim)
                call multm(rmp,trm6,rm6(1,i,1,KPhase),ndim,ndim,ndim)
                call multm(trm6i,s6(1,i,1,KPhase),rmp,ndim,ndim,1)
                do 1160j=1,ndimq
                  pom=rm6(j,i,1,KPhase)
                  if(abs(anint(pom)-pom).gt..0001) then
                    if(ExistM50) call iom50(0,0)
                    if(ExistM94) call iom94(0)
                    go to 9000
                  endif
1160            continue
                n=n+1
                call od0do1(rmp,s6(1,n,1,KPhase),ndim)
                call CopyMat(rm6(1,i,1,KPhase),rm6(1,n,1,KPhase),ndim)
1170          continue
              ns=n
              nvtt=0
              do 1190i=1,nvt
                call multm(trm6i,vt6(1,i,1,KPhase),rmp,ndim,ndim,1)
                call od0do1(rmp,h,ndim)
                do 1180j=1,nvtt
                  if(eqrv(h,vt6(1,j,1,KPhase),ndim,.001)) go to 1190
1180            continue
                nvtt=nvtt+1
                call CopyVek(h,vt6(1,nvtt,1,KPhase),ndim)
1190          continue
              if(VolRatio.gt.1.5) then
                i=nint(VolRatio)-1
                do 1230i3=-i,i
                  xp(3)=i3
                  do 1220i2=-i,i
                    xp(2)=i2
                    do 1210i1=-i,i
                      xp(1)=i1
                      call multm(trm3i,xp,rmp,3,3,1)
                      call od0do1(rmp,hp,3)
                      do 1200j=1,nvtt
                        if(eqrv(hp,vt6(1,j,1,KPhase),3,.001)) go to 1210
1200                  continue
                      nvtt=nvtt+1
                      call CopyVek(hp,vt6(1,nvtt,1,KPhase),3)
                      call SetRealArrayTo(vt6(4,nvtt,1,KPhase),ndimi,0.)
1210                continue
1220              continue
1230            continue
              endif
              call EM50CompleteCentr(0,vt6,nvtt,ich)
              RedSc=float(nvt)/float(nvtt)
              nvt=nvtt
              if(ExistM50) then
                do 1250i=1,itwin
                  call multm(trm3i,rtw(1,i),rmp,3,3,3)
                  call multm(rmp,trm3,rtw(1,i),3,3,3)
1250            continue
                do 1260i=1,mxscu
                  sc(i)=RedSc*sc(i)
1260            continue
                do 1270i=2,ncomp
                  call multm(zv(1,i,KPhase),trm6,rmp,ndim,ndim,ndim)
                  call CopyMat(rmp,zv(1,i,KPhase),ndim)
1270            continue
                if(kcommen.ne.0) then
                  do 1280i=1,3
                    xp(i)=ncommen(i,1,KPhase)
1280              continue
                  call multm(trm3i,xp,dif,3,3,1)
                  do 1290i=1,3
                    ncommen(i,1,KPhase)=nint(dif(i))
1290              continue
                endif
                call SetMet(0)
                call SetIgnoreWTo(.true.)
                call SetIgnoreETo(.true.)
                call FindSmbSg(Grupa,ChangeOrderYes,1)
                call ResetIgnoreW
                call ResetIgnoreE
                call iom50(1,0)
                call iom50(0,0)
              endif
              if(ExistM94) then
                call iom94(1)
                call iom94(0)
                call DRSetCell
                if(ExistM50) call iom50(0,0)
              endif
              if(.not.ExistM40) go to 2300
              call SetRealArrayTo(trv,6,0.)
              ntrans=1
              call EM40SetTr(.false.)
              call EM40TransAtFromTo(1,nacAll,ich)
              if(nmolc.gt.0) call EM40TransAtFromTo(mxa+1,mxa+nacbAll,
     1                                              ich)
              do 2200i=1,nmolc
                if(kswmol(i).ne.KPhase) go to 2200
                isw=iswmol(i)
                call CopyVek(xm(1,i),xp,3)
                call multm(trm3i,xp,xm(1,i),3,3,1)
                StRefPoint(i)=' '
                do 2190j=1,mam(i)
                  ji=j+(i-1)*mxp
                  if(VolRatio.lt..99) aimol(ji)=aimol(ji)*VolRatio
                  call CopyVek(Trans(1,ji),xp,3)
                  call multm(trm3i,xp,Trans(1,ji),3,3,1)
                  do 2085k=1,2
                    do 2080l=1,2
                      call CrlGetXFromAtString(LocMolSystSt(k,l,ji),i,
     1                                         hp,t80,ich)
                      call multm(trm3i,hp,xp,3,3,1)
                      pom=0.
                      do 2070m=1,3
                        pom=max(abs(xp(m)),pom)
2070                  continue
                      if(pom.gt..0001) then
                        do 2075m=1,3
                          pom=xp(m)/pom
2075                    continue
                      endif
                      write(LocMolSystSt(k,l,ji),'(3f9.6)')(xp(m),m=1,3)
2080                continue
2085              continue
                  LocMolSystType(ji)=1
                  do 2100k=1,kmodxm(ji)
                    call CopyVek(utx(1,k,ji),xp,3)
                    call multm(trm3i,xp,utx(1,k,ji),3,3,1)
                    call CopyVek(urx(1,k,ji),xp,3)
                    call multm(trm3i,xp,urx(1,k,ji),3,3,1)
                    if(kfxm(ji).eq.0.or.j.ne.kmodxm(ji)) then
                      call CopyVek(uty(1,k,ji),xp,3)
                      call multm(trm3i,xp,uty(1,k,ji),3,3,1)
                      call CopyVek(ury(1,k,ji),xp,3)
                      call multm(trm3i,xp,ury(1,k,ji),3,3,1)
                    endif
2100              continue
                  do 2110k=1,kmodbm(ji)
                    call CopyVek(ttx(1,k,ji),xp,6)
                    call multm(smpt,xp,ttx(1,k,ji),6,6,1)
                    call CopyVek(tty(1,k,ji),xp,6)
                    call multm(smpt,xp,tty(1,k,ji),6,6,1)
                    call CopyVek(tlx(1,k,ji),xp,6)
                    call multm(smpt,xp,tlx(1,k,ji),6,6,1)
                    call CopyVek(tly(1,k,ji),xp,6)
                    call multm(smpt,xp,tly(1,k,ji),6,6,1)
                    call CopyVek(tsx(1,k,ji),xp,9)
                    call multm(smps,xp,tsx(1,k,ji),9,9,1)
                    call CopyVek(tsy(1,k,ji),xp,9)
                    call multm(smps,xp,tsy(1,k,ji),9,9,1)
2110              continue
2190            continue
2200          continue
              if(VolRatio.lt..99) then
                do 2270i=1,NacAll
                  if(kswa(i).ne.KPhase) go to 2270
                  ai(i)=ai(i)*VolRatio
2270            continue
                call MergAt(1,ich)
                do 2280i=1,mxscu
                  sc(i)=sc(i)/VolRatio
2280            continue
              endif
              if(isPowder) then
                if(KStrain.eq.2) then
                  call multm(trc4,StPwd(1,KPhase),StPom,15,15,1)
                  call CopyVek(StPom,StPwd(1,KPhase),15)
                endif
              endif
              call iom40(1,0)
2300          if(isPowder) then
                if(ExistM91) then
                  call DeleteFile(fln(:ifln)//'.m91')
                  ExistM91=.false.
                endif
                t80=fln(:ifln)//'.prf'
                if(ExistFile(t80)) call DeleteFile(t80)
              endif
              if(ExistM91) then
                call OpenFile(91,fln(:ifln)//'.m91','formatted','old')
                if(ErrJana.ne.0) go to 9999
                call OpenFile(92,fln(:ifln)//'.l91','formatted',
     1                        'unknown')
                if(ErrJana.ne.0) go to 9999
                if(nref91.le.0) then
                  nref91=0
2340              read(91,format91,end=2345) i
                  if(i.le.900) then
                    nref91=nref91+1
                    go to 2340
                  endif
                endif
2345            rewind 91
                call FeFlowChartOpen(-1.,-1.,
     1                               max(nint(float(nref91)*.005),10),
     2                               nref91,'Transformation of the '//
     3                               'reflection file',' ',' ')
                n=0
2400            read(91,format91)(ih(i),i=1,ndim),ri,rs,iq,nxx,
     1                            itw,tbar
                if(ih(1).gt.900) go to 2500
                call FeFlowChartEvent(n,is)
                if(is.ne.0) then
                  call FeBudeBreak
                  if(ErrJana.ne.0) go to 9999
                endif
                do 2410i=1,ndim
                  hf(i)=ih(i)
2410            continue
                call multm(hf,trm6,h,1,ndim,ndim)
                if(itwin.gt.1) then
                  mmax=0
                  do 2420i=4,ndim
                    mmax=max(nint(abs(h(i))),mmax)
2420              continue
                  do 2430i=1,3
                    hf(i)=h(i)
                    do 2425j=1,ndimi
                      hf(i)=hf(i)+qu(i,j,1,KPhase)*h(j+3)
2425                continue
2430              continue
                  call multm(hf,rtwi(1,itw),hp,1,3,3)
                  do 2470itw=1,itwin
                    call multm(hp,rtw(1,itw),h,1,3,3)
                    if(ndim.gt.3) then
                      call ChngInd(h,ih,1,dif,mmax,1,CheckExtRefYes)
                      do 2450j=1,3
                        if(abs(dif(j)).gt..01) go to 2470
2450                  continue
                    else
                      do 2460i=1,3
                        ih(i)=nint(h(i))
                        if(abs(float(ih(i))-h(i)).gt..01) go to 2470
2460                  continue
                    endif
                    go to 2480
2470              continue
                  go to 2490
                else
                  do 2475i=1,ndim
                    ih(i)=nint(h(i))
                    if(abs(float(ih(i))-h(i)).gt..01) go to 2490
2475              continue
                endif
2480            write(92,format91)(ih(i),i=1,ndim),ri,rs,iq,nxx,
     1                             itw,tbar
                go to 2400
2490            nref91=nref91-1
                go to 2400
2500            call FeFlowChartRemove
                write(92,'('' 999'')')
                call CloseIfOpened(91)
                call CloseIfOpened(92)
                call MoveFile(fln(:ifln)//'.l91',fln(:ifln)//'.m91',
     1                    .false.)
                call iom50(1,0)
              endif
              if(ExistM94) call iom94(0)
            else
              if(ExistM50) then
                call iom50(1,0)
                call iom50(0,0)
              endif
              if(ExistM94) then
                call iom94(1)
                call iom94(0)
                call DRSetCell
                if(ExistM50) call iom50(0,0)
              endif
            endif
          endif
        endif
        go to 9999
      else if(i.eq.1) then
        call UnitMat(t,3)
        call FeReadRealMat(-1.,-1.,'Transformation matrix',SmbABC,
     1              IdAddPrime,t,ti,3,CheckSingYes,CheckPosDefYes,ich)
        if(ich.eq.0) call TrPar(t,CellA,TrMpA)
      else if(i.eq.2) then
        call DRDoubleCell(TrMpA,CellA,ktera)
      else if(i.eq.3) then
        call redukce(CellA,TrMpA)
      else if(i.eq.4) then
        call MatBlock3(TrMpA,t,ndim)
        call MatInv(t,ti,pom,3)
        call trpar(ti,CellA,TrMpA)
      else if(i.eq.5) then
        call kopcltr(TrMpo,TrMpA,CellO,CellA)
        imen1=4
      endif
      if(.not.eqrv(CellA,CellO,6,.001).or.
     1   .not.eqrv(TrMpA,TrMpO,ndimq,.001).or.i.eq.5)
     2  call CellInfoCont(CellA)
      go to 1100
9000  call FeChybne(-1.,-1.,'transformation leads to non-integer '//
     1              'symmetry matrices','it will not be performed',
     2              0,SeriousError)
9999  call CloseIfOpened(91)
      call CloseIfOpened(92)
      call DeleteFile(fln(:ifln)//'.l91')
      call FeLstRemove
      return
      end
      subroutine CellInfo(cella)
      include 'params.cmn'
      include 'basic.cmn'
      include 'fepc.cmn'
      dimension cella(6)
      character*80 CellText(2),t80
      equivalence (t80,CellText)
      save CellText
      t80='             Original cell parameters - Volume'
      call FeLstMake(-1.,YMaxGrWin-15.,60,5,t80)
      t80=' '
      call FeLstWriteLine(t80,3)
      t80='            Transformed cell parameters - Volume'
      call FeLstWriteLine(t80,4)
      ip=1
      go to 1000
      entry CellInfoCont(cella)
      ip=2
1000  do 2000i=ip,2
        csa=cos(Cella(4)*torad)
        csb=cos(Cella(5)*torad)
        csg=cos(Cella(6)*torad)
        Vol=Cella(1)*Cella(2)*Cella(3)*
     1    sqrt(1.-csa**2-csb**2-csg**2+2.*csa*csb*csg)
        write(CellText(i),'(3f8.4,3f8.3,f10.1)')(Cella(j),j=1,6),Vol
        if(i.eq.1) then
          j=2
        else
          j=5
        endif
        call FeLstWriteLine(CellText(i),j)
2000  continue
      CellText(1)=CellText(2)
      return
      end
      subroutine redukce(Cell,Trm)
      include 'params.cmn'
      include 'basic.cmn'
      dimension Cell(6),trm(*),t1(3,3),t2(3,3),tp(3,3),tt(36),
     1          pommat(3,3),Qi(3,3),Qr(3),xp(3),tt6(36)
      logical hotovo
      real ksi
      data t1/0,-1,0,-1,0,0,0,0,-1/,t2/-1,0,0,0,0,-1,0,-1,0/
      Key=0
      go to 500
      entry RedukceQ(Cell,Qi,Qr,trm)
      Key=1
500   aa=Cell(1)**2
      bb=Cell(2)**2
      cc=Cell(3)**2
      ksi=2.*Cell(2)*Cell(3)*cos(torad*Cell(4))
      eta=2.*Cell(1)*Cell(3)*cos(torad*Cell(5))
      dzeta=2.*Cell(1)*Cell(2)*cos(torad*Cell(6))
      call UnitMat(tt,3)
      m=0
      mold=-1
      n=0
1000  hotovo=.true.
      n=n+1
      if(mold.ne.m) then
        n=0
      else
        n=n+1
        if(n.gt.20) go to 1500
      endif
      mold=m
      if(aa.gt.bb.or.(aa.eq.bb.and.abs(ksi).gt.abs(eta))) then
        m=1
        pom=aa
        aa=bb
        bb=pom
        pom=eta
        eta=ksi
        ksi=pom
        call multm(tt,t1,tp,3,3,3)
        call CopyMat(tp,tt,3)
      endif
      if(bb.gt.cc.or.(bb.eq.cc.and.abs(eta).gt.abs(dzeta))) then
        m=2
        pom=bb
        bb=cc
        cc=pom
        pom=eta
        eta=dzeta
        dzeta=pom
        call multm(tt,t2,tp,3,3,3)
        call CopyMat(tp,tt,3)
        hotovo=.false.
      endif
      if(hotovo) then
        m=3
        call UnitMat(tp,3)
        if(ksi*eta*dzeta.gt.0.) then
          tp(1,1)=sign(1.,ksi)
          tp(2,2)=sign(1.,eta)
          tp(3,3)=sign(1.,dzeta)
          ksi=abs(ksi)
          eta=abs(eta)
          dzeta=abs(dzeta)
        else
          i=0
          if(ksi.eq.0.) then
            i=1
          else
            tp(1,1)=-sign(1.,ksi)
          endif
          if(eta.eq.0.) then
            i=2
          else
            tp(2,2)=-sign(1.,eta)
          endif
          if(dzeta.eq.0.) then
            i=3
          else
            tp(3,3)=-sign(1.,dzeta)
          endif
          if(i.ne.0.and.tp(1,1)*tp(2,2)*tp(3,3).lt.0..and.i.ne.0)
     1       tp(i,i)=-1.
          ksi=-abs(ksi)
          eta=-abs(eta)
          dzeta=-abs(dzeta)
        endif
        call multm(tt,tp,pommat,3,3,3)
        call CopyMat(pommat,tt,3)
      endif
      if(hotovo.and.(abs(ksi).gt.bb.or.(ksi.eq.bb.and.2.*eta.lt.dzeta).
     1                              or.(ksi.eq.-bb.and.dzeta.lt.0.)))
     2   then
        m=4
        call UnitMat(tp,3)
        pom1=-sign(1.,ksi)
        tp(2,3)=pom1
        cc=cc+bb+pom1*ksi
        eta=eta+dzeta*pom1
        ksi=ksi+2.*bb*pom1
        hotovo=.false.
        call multm(tt,tp,pommat,3,3,3)
        call CopyMat(pommat,tt,3)
      endif
      if(hotovo.and.(abs(eta).gt.aa.or.(eta.eq.aa.and.2.*ksi.lt.dzeta).
     1                              or.(eta.eq.-aa.and.dzeta.lt.0.)))
     2   then
        m=5
        call UnitMat(tp,3)
        pom1=-sign(1.,eta)
        tp(1,3)=pom1
        cc=cc+aa+pom1*eta
        ksi=ksi+dzeta*pom1
        eta=eta+2.*aa*pom1
        hotovo=.false.
        call multm(tt,tp,pommat,3,3,3)
        call CopyMat(pommat,tt,3)
      endif
      if(hotovo.and.(abs(dzeta).gt.aa.or.(dzeta.eq.aa.and.2.*ksi.lt.eta)
     1                               .or.(dzeta.eq.-aa.and.eta.lt.0.)))
     2   then
        m=6
        call UnitMat(tp,3)
        pom1=-sign(1.,dzeta)
        tp(1,2)=pom1
        bb=bb+aa+pom1*dzeta
        ksi=ksi+eta*pom1
        dzeta=dzeta+2.*aa*pom1
        hotovo=.false.
        call multm(tt,tp,pommat,3,3,3)
        call CopyMat(pommat,tt,3)
      endif
      if(hotovo) then
        m=7
        pom1=ksi+eta+dzeta+aa+bb
        if(pom1.lt.0..or.(pom1.eq.0..and.2.*(aa+eta)+dzeta.gt.0.)) then
          call UnitMat(tp,3)
          tp(1,3)=1.
          tp(2,3)=1.
          cc=cc+pom1
          ksi=2.*bb+ksi+dzeta
          eta=2.*aa+eta+dzeta
          hotovo=.false.
          call multm(tt,tp,pommat,3,3,3)
          call CopyMat(pommat,tt,3)
        endif
      endif
      if(.not.hotovo) go to 1000
1500  call MatFromBlock3(tt,tt6,ndim)
      call Multm(TrM,tt6,tt,ndim,ndim,ndim)
      call CopyMat(tt,TrM,ndim)
      Cell(1)=sqrt(aa)
      Cell(2)=sqrt(bb)
      Cell(3)=sqrt(cc)
      Cell(4)=acos(.5*ksi/(Cell(2)*Cell(3)))/torad
      Cell(5)=acos(.5*eta/(Cell(1)*Cell(3)))/torad
      Cell(6)=acos(.5*dzeta/(Cell(1)*Cell(2)))/torad
      if(Key.eq.0) go to 9999
      do 2000i=1,ndimi
        call Multm(Qi(1,i),tt,xp,1,3,3)
        call CopyVek(xp,Qi(1,i),3)
2000  continue
      if(ndimi.eq.1) then
        call Multm(Qr,tt,xp,1,3,3)
        call CopyVek(xp,Qr,3)
      endif
9999  return
      end
      subroutine DRDoubleCell(TrMpA,Cell,itr)
      include 'params.cmn'
      include 'basic.cmn'
      dimension t(36),td(3,3,8),Cellp(6),TrMpa(*),Cell(6)
      character*54 menc(0:7)
      integer FeMenu
      data td/1.,0.,0.,0.,1.,0.,0.,0.,1.,
     1        2.,0.,0.,0.,1.,0.,0.,0.,1.,
     2        1.,0.,0.,0.,2.,0.,0.,0.,1.,
     3        1.,1.,0.,0.,2.,0.,0.,0.,1.,
     4        1.,0.,0.,0.,1.,0.,0.,0.,2.,
     5        1.,0.,1.,0.,1.,0.,0.,0.,2.,
     6        1.,0.,0.,0.,1.,1.,0.,0.,2.,
     7        1.,0.,1.,0.,1.,1.,0.,0.,2./
      do 2000i=1,8
        call CopyVek(Cell,CellP,6)
        call UnitMat(t,ndim)
        call trpar(td(1,1,i),CellP,t)
        call redukce(CellP,t)
        write(menc(i-1),'(3f9.4,3f9.2)') Cellp
2000  continue
      menc(0)='     return without any doubling of cell parameters'
      itr=FeMenu(-1.,-1.,menc,0,7,0,0)
      if(itr.gt.0) then
        call CopyVek(Cell,CellP,6)
        call trpar(td(1,1,itr+1),Cell,TrMpA)
        call redukce(Cell,TrMpA)
      endif
      return
      end
      subroutine TrPar(t,Cell,TrM)
      include 'params.cmn'
      include 'basic.cmn'
      dimension t(3,3),tt(36),Cell(6),TrM(*),g(3,3),gp(3,3),
     1          Qi(3,3),Qr(3),xp(36)
      go to 2000
      entry TrParQ(t,Cell,Qi,Qr,TrM)
      do 1000i=1,ndimi
        call Multm(Qi(1,i),t,xp,1,3,3)
        call CopyVek(xp,Qi(1,i),3)
1000  continue
      if(ndimi.eq.1) then
        call Multm(Qr,t,xp,1,3,3)
        call CopyVek(xp,Qr,3)
      endif
2000  call cpnamt(Cell,g)
      call trmat(t,tt,3,3)
      call multm(tt,g,gp,3,3,3)
      call multm(gp,t,g,3,3,3)
      call mtnacp(g,Cell)
      call MatFromBlock3(t,tt,ndim)
      call multm(TrM,tt,xp,ndim,ndim,ndim)
      call CopyMat(xp,TrM,ndim)
      return
      end
      subroutine kopcltr(trin,trout,Cellin,Cellout)
      include 'params.cmn'
      include 'basic.cmn'
      dimension Cellin(6),Cellout(6),trin(*),trout(*)
      call CopyMat(trin,trout,ndim)
      call CopyVek(CellIn,CellOut,6)
      return
      end
      subroutine cpnamt(cl,gg)
      include 'const.cmn'
      dimension gg(3,3),cl(6)
      do 1000i=1,3
        gg(i,i)=cl(i)**2
1000  continue
      gg(1,2)=cl(1)*cl(2)*cos(torad*cl(6))
      gg(1,3)=cl(1)*cl(3)*cos(torad*cl(5))
      gg(2,3)=cl(2)*cl(3)*cos(torad*cl(4))
      gg(2,1)=gg(1,2)
      gg(3,1)=gg(1,3)
      gg(3,2)=gg(2,3)
      return
      end
      subroutine mtnacp(gg,cl)
      include 'const.cmn'
      dimension gg(3,3),cl(6)
      do 1000i=1,3
        cl(i)=sqrt(gg(i,i))
1000  continue
      cl(4)=acos(gg(2,3)/(cl(2)*cl(3)))/torad
      cl(5)=acos(gg(1,3)/(cl(1)*cl(3)))/torad
      cl(6)=acos(gg(1,2)/(cl(1)*cl(2)))/torad
      return
      end
      subroutine DRAverage(Key)
      include 'params.cmn'
      include 'basic.cmn'
      include 'datred.cmn'
      include 'fepc.cmn'
      dimension sj(3),soj(3),ihd(6),ihmx(6),ihpp(6)
      dimension dircosa(3,2,mxref)
      character*80 Text
      character*31 t31
      character*20 ShForm
      data robs,flim,MxNRef,CutOff/3.,50.,200,80./
      logical eqiv
      if(Key.ne.2) then
        call OpenFile(95,fln(:ifln)//'.m95','formatted','old')
        if(ErrJana.ne.0) go to 9999
      endif
      if(Key.eq.0) then
        Text='Averaging reflections from M95'
      else if(Key.eq.1) then
        Text='Creating "eqv" file for X-shape'
        ShForm=formatshelx
        ShForm(2:2)='3'
        id=NextQuestId()
        call FeQuestCreate(id,-1.,-1.,200.,0,3,
     1                     'Define selecion criteria for X-shape',0,
     2                     LightGray,0,0)
        xpom=FeTxLength('XXXXXXXXXXXXXX')+7.
        call FeQuestEdwMake(id,5.,1,xpom,1,'Reflections I%<','L',
     1                      20.,EdwYd,0)
        nEdwLim=EdwLastMade
        call FeQuestRealEdwOpen(nEdwLim,flim,.false.,.false.)
        call FeQuestLabelMake(id,xpom+22.,1,'*sig(I) will be skipped',
     1                        'L')
        xpom=FeTxLength('XXXXXXXXXXXXXXXXXXXXX')+7.
        call FeQuestEdwMake(id,5.,2,xpom,2,'Reflections having I%>',
     1                      'L',20.,EdwYd,0)
        nEdwCutOff=EdwLastMade
        call FeQuestRealEdwOpen(nEdwCutOff,CutOff,.false.,.false.)
        call FeQuestLabelMake(id,xpom+23.,2,'% of I(max) value will '//
     1                        'be skipped','L')
        xpom=FeTxLength('XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX')+7.
        call FeQuestEdwMake(id,5.,3,xpom,3,'Maximum %number of unique '
     1                    //'reflections','L',30.,EdwYd,0)
        nEdwMxNRef=EdwLastMade
        call FeQuestIntEdwOpen(nEdwMxNRef,MxNRef,.false.)
        icont=0
1500    call FeQuestEvent(id,icont,ich)
        if(CheckType.ne.0) then
          call NebylOsetren
          go to 1500
        endif
        if(ich.eq.0) then
          call FeQuestRealFromEdw(nEdwLim,flim)
          call FeQuestRealFromEdw(nEdwCutOff,CutOff)
          call FeQuestIntFromEdw(nEdwMxNRef,MxNRef)
        endif
        call FeQuestRemove(id)
        if(ich.ne.0) go to 9900
      endif
      do 1600i=1,ns
        call MatBlock3(rm6(1,i,1,KPhase),rm(1,i,1,KPhase),ndim)
        BratSym(i)=.true.
1600  continue
c      call TwinSym(ns,ncs,itwin,0)
      call SetIntArrayTo(ihmx,6,0)
      nall=0
      nobs=0
      if(Key.ne.2) then
        call FeFlowChartOpen(-1.,-1.,max(nint(float(nref95)*.01),10),
     1                       2*nref95,Text,' ',' ')
        iz=0
        call PrvniM95(ich)
        if(ich.ne.0) go to 9900
      endif
      rimax=0.
2010  nall=nall+1
      if(Key.ne.2) then
2011    call DRGetReflectionFromM95(95,iend,ich)
        if(ich.ne.0) go to 9000
        if(iend.ne.0) go to 2050
        call FeFlowChartEvent(iz,is)
        if(is.ne.0) then
          call FeBudeBreak
          if(ErrJana.ne.0) go to 9999
        endif
        if(no.le.0.or.iflg(1).lt.0) go to 2011
        call indtr(ih,trmp,ihp,ndim)
        if(ihp(1).gt.900) go to 2011
        if(Key.eq.1) then
          do 2015i=4,ndim
            if(ihp(i).ne.0) go to 2011
2015      continue
        endif
        call CopyVekI(ihp,ih,ndim)
        if(Key.eq.0) then
          ri=ri*corrf(1)*corrf(2)
          rs=rs*corrf(1)*corrf(2)
        endif
        riar(nall)=anint(ri*10.)*.1
        rsar(nall)=anint(rs*10.)*.1
      else
        if(nall.gt.NRefRead) go to 2050
        call indtr(ihar(1,nall),trmp,ih,ndim)
      endif
      rimax=max(rimax,riar(nall))
      if(riar(nall).gt.robs*rsar(nall)) nobs=nobs+1
      do 2030i=1,ns
        if(.not.BratSym(i)) go to 2030
        call IndTr(ih,rm6(1,i,1,KPhase),ihp,ndim)
        do 2020j=1,ndim
          ihmx(j)=max(iabs(ihp(j)),ihmx(j))
2020    continue
2030  continue
      go to 2010
2050  nall=nall-1
      nobs=nobs-1
      j=1
      do 2060i=1,ndim
        ihd(i)=2*ihmx(i)+1
        if(imax/j.lt.ihd(i)) go to 8000
        j=j*ihd(i)
2060  continue
      if(Key.ne.2) then
        rewind 95
        call PrvniM95(ich)
        if(ich.ne.0) go to 9900
      endif
      nall=0
2110  nall=nall+1
2111  if(Key.ne.2) then
        call DRGetReflectionFromM95(95,iend,ich)
        if(ich.ne.0) go to 9000
        if(iend.ne.0) go to 2150
        call FeFlowChartEvent(iz,is)
        if(is.ne.0) then
          call FeBudeBreak
          if(ErrJana.ne.0) go to 9999
        endif
        if(no.le.0.or.iflg(1).lt.0) go to 2111
        call indtr(ih,trmp,ihp,ndim)
        if(ihp(1).gt.900) go to 2111
        if(Key.eq.1) then
          do 2115i=4,ndim
            if(ihp(i).ne.0) go to 2111
2115      continue
        endif
        call CopyVekI(ihp,ih,ndim)
      else
        if(nall.gt.NRefRead) go to 2150
        call indtr(ihar(1,nall),trmp,ih,ndim)
      endif
      if(Key.eq.1) then
        do 2120j=1,2
          do 2112i=1,3
            dircosa(i,j,nall)=dircos(i,j)*rcp(i,1,KPhase)
2112      continue
          call multm(MetTens(1,1,KPhase),dircosa(1,j,nall),sj,3,3,1)
          pom=1./sqrt(scalmul(dircosa(1,j,nall),sj))
          do 2114i=1,3
            dircosa(i,j,nall)=dircosa(i,j,nall)*pom
2114      continue
2120    continue
      endif
      mx=0
      do 2140i=1,ns
        if(.not.BratSym(i)) go to 2140
        call IndTr(ih,rm6(1,i,1,KPhase),ihp,ndim)
        do 2135j=1,3-ncs
          if(j.eq.2) then
            do 2125k=1,ndim
              ihp(k)=-ihp(k)
2125        continue
          endif
          mxq=IndPack(ihp,ihd,ihmx,ndim)
          call IndUnPack(mxq,ihpp,ihd,ihmx,ndim)
          if(mxq.gt.mx) mx=mxq
2135    continue
2140  continue
      irecp(nall)=mx
      go to 2110
2150  nall=nall-1
      if(Key.eq.1) then
        pom=99999./rimax
        if(pom.lt.1.) then
          do 2160i=1,nall
            riar(i)=riar(i)*pom
            rsar(i)=rsar(i)*pom
2160      continue
          rimax=rimax*pom
        endif
      endif
      rimax=rimax*.01
      call indexx(nall,irecp,ipor)
      if(Key.ne.2) call FeFlowChartRemove
      if(Key.eq.1) then
        call OpenFile(90,fln(:ifln)//'.eqv','formatted','unknown')
        if(ErrJana.ne.0) go to 9999
      endif
      rnum=0.
      rden=0.
      rznum=0.
      rzden=0.
      nalla=0
      nobsa=0
      nuni=0
      incmax=0
      kk=0
      i=1
      kolik=1
3000  kp=kk+1
      if(kp.gt.nall.or.ipor(kp).le.0) go to 4000
      m=0
      if(Key.ne.1) then
        s1=0.
        s2=0.
        s4=0.
      endif
      j=ipor(kp)
      ippj=irecp(j)
3100  m=m+1
      if(Key.ne.1) then
        s1=s1+riar(j)
        s2=s2+1.
        s4=s4+rsar(j)**2
      endif
      if(kolik.lt.nall) then
        i=i+1
        kolik=kolik+1
        j=ipor(i)
        if(irecp(j).eq.ippj) go to 3100
      endif
      kk=kp+m-1
      if(Key.ne.1) then
        s1=s1/s2
        s4=sqrt(s4)/s2
        if(s1.gt.robs*s4) then
          nxx=0
        else
          nxx=1
        endif
        nalla=nalla+1
        if(nxx.eq.0) nobsa=nobsa+1
      endif
      if(m.gt.1) then
        if(Key.eq.1) then
          do 3200k=kp,kk
            j=ipor(k)
            if(riar(j).gt.CutOff*rimax.or.
     1         riar(j).le.flim*rsar(j)) go to 3000
3200      continue
        endif
        inc=0
        nuni=nuni+1
        do 3500k=kp,kk
          j=ipor(k)
          if(Key.ne.1) then
            call IndUnPack(irecp(j),ihpp,ihd,ihmx,ndim)
            pom=riar(j)
            apom=abs(pom-s1)
            rnum=rnum+apom
            rden=rden+pom
            if(nxx.eq.0) then
              rznum=rznum+apom
              rzden=rzden+pom
            endif
          else
            call IndUnPack(irecp(j),ih,ihd,ihmx,ndim)
            call multm(MetTens(1,1,KPhase),dircosa(1,1,j),soj,3,3,1)
            call multm(MetTens(1,1,KPhase),dircosa(1,2,j),sj ,3,3,1)
            do 3400l=kp,k-1
              m=ipor(l)
              if(scalmul(dircosa(1,1,m),soj).gt..999.and.
     1           scalmul(dircosa(1,2,m), sj).gt..999)
     2          go to 3500
3400        continue
            write(90,ShForm)(ih(l),l=1,3),riar(j),rsar(j),1,
     1                      (-dircosa(l,1,j)/rcp(l,1,KPhase),
     2                            dircosa(l,2,j)/rcp(l,1,KPhase),l=1,3)
            nobsa=nobsa+1
            inc=inc+1
          endif
3500    continue
        if(inc.eq.1) then
          nobsa=nobsa-1
          nuni=nuni-1
          backspace 90
        else
          inca(nuni)=inc
          incmax=max(inc,incmax)
        endif
      endif
      go to 3000
4000  if(rzden.gt.0.) then
        RIntObs=rznum/rzden*100.
      else
        RIntObs=0.
      endif
      if(rden.gt.0.) then
        RIntAll=rnum/rden*100.
      else
        RIntObs=0.
      endif
      if(Key.eq.0) then
        TextInfo(5)=' '
        TextInfo(6)=' '
        if(rzden.gt.0.) then
          write(Text,'(f6.2,''/'',f6.2)') RIntObs,RIntAll
          call Zhusti(Text)
          TextInfo(4)=' Rint(obs/all) = '//Text(:idel(Text))
          write(Text,100) nobsa,nalla
          call Zhusti(Text)
          i=idel(TextInfo(4))
          TextInfo(4)=TextInfo(4)(:i)//' for '//Text(:idel(Text))//
     1                ' reflections'
          write(Text,100) nobs,nall
          call Zhusti(Text)
          TextInfo(5)=TextInfo(5)(:i-9)//'averaged from '//
     1                Text(:idel(Text))//' reflections'
          write(Text,101) float(nall)/float(nalla)
          call ZdrcniCisla(Text,1)
          TextInfo(6)=' Redundancy = '//Text(:idel(Text))
        else
          write(TextInfo(4),'(''Rint (obs/all) = -----/-----'')')
        endif
        NInfo=6
      else if(Key.eq.2) then
        if(rzden.gt.0.) then
          write(Text,'(f6.2,''/'',f6.2)') RIntObs,RIntAll
          call Zhusti(Text)
          write(t31,100) nobsa,nalla
          call Zhusti(t31)
        else
          Text='-----/-----'
          t31=Text
        endif
        i=index(Text,'/')
        TextInfo(NInfo)(38-i:)=Text(:idel(Text))
        i=index(t31,'/')
        TextInfo(NInfo)(50-i:)=t31(:idel(t31))
        write(Text,101) float(nall)/float(nalla)
        call ZdrcniCisla(Text,1)
        i=index(Text,'.')
        TextInfo(NInfo)(61-i:)=Text(:idel(Text))
        write(Text,100) nobs,nall
        call Zhusti(Text)
        TextInfo(1)='Averages made from '//Text(:idel(Text))//
     1             ' reflections'
      else if(Key.eq.1) then
        if(nuni.gt.MxNRef) then
          ln=NextLogicNumber()
          open(ln,file=fln(:ifln)//'.l90')
          inc=incmax
          n=0
4050      i=0
4100      i=i+1
          if(inca(i).eq.inc) then
            inca(i)=-inca(i)
            n=n+1
            if(n.eq.MxNRef) go to 4200
          endif
          if(i.gt.nuni) then
            inc=inc-1
            go to 4050
          else
            go to 4100
          endif
4200      rewind 90
4300      nobsa=0
          do 4400i=1,nuni
            iz=inca(i)
            do 4320j=1,iabs(iz)
              read(90,ShForm,end=4500)(ih(l),l=1,3),riar(j),rsar(j),m,
     1                                 dircos
              if(iz.lt.0) then
                write(ln,ShForm)(ih(l),l=1,3),riar(j),rsar(j),m,dircos
                nobsa=nobsa+1
              endif
4320        continue
4400      continue
          nuni=MxNRef
4500      close(90)
          close(ln)
          call MoveFile(fln(:ifln)//'.l90',fln(:ifln)//'.eqv',.false.)
        endif
        call CloseIfOpened(90)
        write(TextInfo(1),'(i5,'' reflections,'',i5,'' unique ones'')')
     1    nobsa,nuni
        Ninfo=1
        call FeInfoOut(-1.,-1.,'"eqv" file contains :')
      else

      endif
      go to 9999
8000  call FeChybne(-1.,-1.,'diffraction indices are too large to be '//
     1              'averaged',' ',0,SeriousError)
      go to 9900
9000  call FeReadError(95)
9900  ErrJana=1
      if(Key.ne.2) call FeFlowChartRemove
9999  call CloseIfOpened(95)
      call CloseIfOpened(90)
      return
100   format(i15,'/'i15)
101   format(f10.3)
      end
      subroutine DRSGTest(Change)
      include 'params.cmn'
      include 'basic.cmn'
      include 'atoms.cmn'
      include 'fepc.cmn'
      include 'datred.cmn'
      dimension TrMPOrg(36),CellParOrg(6),QuOrg(3,3),VT6X(6,mxcen),
     1          xp(6),trm6(36),trm6i(36),trm3(3,3),trm3i(3,3),rmp(36),
     2          hp(6)
      character*80  t80
      character*60  GrupaOrg
      integer FeSelectOnePossibility,WhatToDo,WhatToDoMax
      logical EqRv,FeYesNoHeader,Change,CrwLogicQuest,StartLastCell,
     1        LookForSuperCell,MatRealEqUnitMat
      equivalence (trm6i,CellTrSel6)
      Change=.false.
      if(.not.ExistM95) then
        if(ExistM91) then
          call SetBasicM94
          call iom94(1)
          call OpenFile(91,fln(:ifln)//'.m91','formatted','old')
          call OpenFile(95,fln(:ifln)//'.m95','formatted','unknown')
          mmax=0
          KProf=0
          NProf=0
1010      read(91,Format91,end=1020)(ih(i),i=1,ndim),ri,rs
          if(ih(1).gt.900) go to 1020
          do 1015i=4,ndim
            mmax=max(mmax,iabs(ih(i)))
1015      continue
          nref91=nref91+1
          go to 1010
1020      write(95,FormA1)(ImportTextB(i:i),i=1,idel(ImportTextB))
          write(95,'(a)') fln(:ifln)//'.m91'
          write(95,'(5i5,l5,3i5,3f8.3,f10.5)')
     1      99,3,1,1,mmax,.false.,(1,i=1,3),(0.01,i=1,3),1.
          do 1025i=1,ndim
            write(95,'(6f10.6)')(TrMP(i+(j-1)*ndim),j=1,ndim)
1025      continue
          write(95,FormA1)(Format91(i:i),i=1,idel(Format91))
          write(95,'(i10)') nref91
          write(95,FormA1)(ImportTextE(i:i),i=1,idel(ImportTextE))
          call SetRealArrayTo(uhly,4,0.)
          call SetRealArrayTo(dircos,6,0.)
          call SetRealArrayTo(corrf,2,1.)
          no=0
          rewind 91
1050      read(91,Format91,end=1060)(ih(i),i=1,ndim),ri,rs,iq,j,itw,
     1                               tbar,DrLam,DirCos
          if(ih(1).gt.900) go to 1060
          no=no+1
          iflg(1)=iq
          iflg(2)=itw
          call DRPutReflectionToM95(95)
          go to 1050
1060      close(91)
          close(95)
          ExistM95=.true.
        else
          call FeChybne(-1.,-1.,'No reflection file accessible.',' ',0,
     1                  Warning)
        endif
      endif
      if(nacalc.gt.0) then
        TextInfo(1)='The procedure will help you to find a new space '//
     1              'group. But'
        TextInfo(2)='this can make your m40 file inconsistent with '//
     1              'the new'
        TextInfo(3)='choice. Note that for going to lower space group'//
     1               ' or for'
        TextInfo(4)='transforming of cell parameters exist special '//
     1              'tools.'
        NInfo=4
        if(.not.FeYesNoHeader(-1.,-1.,'Do you really want to continue?',
     1                        0)) go to 9999
      endif
      call iom94(0)
      ich=0
      id=NextQuestId()
      xqd=230.
      il=11
      call FeQuestCreate(id,-1.,-1.,xqd,0,il,' ',0,LightGray,0,0)
      il=1
      tpom=xqd*.5
      call FeQuestLabelMake(id,tpom,il,'Tolerances for crystal system'//
     1                      ' recognition:','C')
      tpom=5.
      t80='Maximal deviation for %cell lengths in [A]'
      xpom=tpom+FeTxLengthUnder(t80)+3.
      dpom=25.
      do 1210i=1,2
        il=il+1
        call FeQuestEdwMake(id,tpom,il,xpom,il,t80,'L',dpom,EdwYd,0)
        if(i.eq.1) then
          pom=DiffAxe
          t80='Maximal deviation for cell %angles in deg'
          nEwdDiffAxe=EdwLastMade
        else
          pom=DiffAngle
          nEwdDiffAngle=EdwLastMade
        endif
        call FeQuestRealEdwOpen(EdwLastMade,pom,.false.,.false.)
1210  continue
      il=il+1
      tpom=xqd*.5
      call FeQuestLabelMake(id,tpom,il,'Tolerances for space group '//
     1                      'recognition:','C')
      tpom=5.
      t80='Maximal ave(I/sig(I)) for cen%tering'
      xpom=tpom+FeTxLengthUnder(t80)+10.
      do 1220i=1,2
        il=il+1
        call FeQuestEdwMake(id,tpom,il,xpom,il,t80,'L',dpom,EdwYd,0)
        if(i.eq.1) then
          pom=SumaObsLimCentr
          t80='Maximal ave(I/sig(I)) for %extinctions'
          nEwdLimCentr=EdwLastMade
        else
          pom=SumaObsLimExtinct
          nEwdLimExtinct=EdwLastMade
        endif
        call FeQuestRealEdwOpen(EdwLastMade,pom,.false.,.false.)
1220  continue
      il=il+1
      tpom=xqd*.5
      call FeQuestLabelMake(id,tpom,il,'Start work with:','C')
      xpom=5.
      tpom=xpom+CrwgYd+5.
      t80='%Original cell parameters'
      idl=idel(t80)
      do 1230i=1,2
        il=il+1
        if(i.eq.1) then
          k=1
        else
          t80='    %Last cell parameters'
          k=3
        endif
        write(t80(idel(t80)+1:),'(3f7.3,3f7.2)')(CellDatRed(j,k),j=1,6)
        call FeQuestCrwMake(id,tpom,il,xpom,il,t80,'L',CrwgXd,CrwgYd,0,
     1                      1)
        if(i.eq.2) nCrwLastCell=CrwLastMade
        call FeQuestCrwOpen(CrwLastMade,i.eq.2)
1230  continue
      xpom=20.
      tpom=xpom+CrwXd+5.
      do 1240i=1,2
        il=il+1
        if(i.eq.1) then
          t80='%Reduce the selected cell (recommended)'
        else
          t80='Search for %higher symmetrical supercell (recommended)'
        endif
        call FeQuestCrwMake(id,tpom,il,xpom,il,t80,'L',CrwYd,CrwXd,0,0)
        if(i.eq.1) then
          nCrwReduceCell=CrwLastMade
        else
          nCrwLookForSuperCell=CrwLastMade
        endif
        call FeQuestCrwOpen(CrwLastMade,.true.)
1240  continue
      icont=0
1500  call FeQuestEvent(id,icont,ich)
      icont=1
      if(CheckType.ne.0) then
        call NebylOsetren
        go to 1500
      endif
      if(ich.eq.0) then
        StartLastCell=CrwLogicQuest(nCrwLastCell)
        ReduceCell=CrwLogicQuest(nCrwReduceCell)
        LookForSuperCell=CrwLogicQuest(nCrwLookForSuperCell)
        call FeQuestRealFromEdw(nEwdDiffAxe  ,DiffAxe  )
        call FeQuestRealFromEdw(nEwdDiffAngle,DiffAngle)
        call FeQuestRealFromEdw(nEwdLimExtinct,SumaObsLimExtinct)
        call FeQuestRealFromEdw(nEwdLimCentr  ,SumaObsLimCentr  )
      endif
      call FeQuestRemove(id)
      if(ich.ne.0) go to 9999
      call OpenFile(95,fln(:ifln)//'.m95','formatted','old')
      if(ErrJana.ne.0) go to 9999
      call PrvniM95(ich)
      if(ich.ne.0) go to 9999
      NRefRead=0
      NRefReadObs=0
      if(StartLastCell) then
        k=3
      else
        k=1
        call UnitMat(TrMp,ndim)
      endif
      call CopyMat(TrMP,TrMpOrg,ndim)
      call CopyVek(CellDatRed(1,k),CellParOrg,6)
      call CopyVek(QuDatRed(1,1,k),QuOrg,3*ndimi)
      GrupaOrg=Grupa
2100  call DRGetReflectionFromM95(95,iend,ich)
      if(iend.ne.0.or.ich.ne.0) go to 2200
      if(no.lt.0.or.iflg(1).lt.0) go to 2100
      if(iflg(2).lt.0) then
2150    call DRGetReflectionFromM95(95,iend,ich)
        if(iend.ne.0.or.ich.ne.0) go to 2200
        if(no.lt.0.or.iflg(1).lt.0) go to 2100
        if(iflg(2).lt.0) then
          go to 2150
        else
          go to 2100
        endif
      else
        if(iflg(2).ne.1) go to 2100
      endif
c      if(ih(2).eq.0.and.mod(iabs(ih(3)),2).eq.1.and.ri.gt.10.*rs) then
c        write(t80,'(3i4,2f10.2,2i4)')(ih(ii),ii=1,3),ri,rs,iflg
c        call FeWinMessage(t80,' ')
c      endif
      NRefRead=NRefRead+1
      call indtr(ih,trmp,ihar(1,NRefRead),ndim)
      if(ihar(1,NRefRead).gt.900) then
        NRefRead=NRefRead-1
        go to 2100
      endif
      riar(NRefRead)=anint(ri*corrf(1)*corrf(2)*10.)*.1
      rsar(NRefRead)=anint(rs*corrf(1)*corrf(2)*10.)*.1
      if(riar(NRefRead).gt.3.) NRefReadObs=NRefReadObs+1
      go to 2100
2200  call CloseIfOpened(95)
      call DRSGTestLaue(CellParOrg,QuOrg,LookForSuperCell,ich)
      if(ich.ne.0) go to 9999
      call DRSGTestCentr(ich)
      if(ich.ne.0) go to 9999
      call DRSGTestSGroup(Change,ich)
      if(ich.ne.0) go to 9999
      if(ndimi.eq.1) then
        call DRSGTestSSG4(ich)
        if(ich.ne.0) go to 9999
      endif
      if(GrupaSel.ne.GrupaOrg) go to 3020
      if(.not.eqrv(CellParOrg,CellParSel,3,DiffAxe)) go to 3020
      if(.not.eqrv(CellParOrg(4),CellParSel(4),3,DiffAngle)) go to 3020
      do 3010i=1,ndimi
        if(ndimi.eq.1) then
          call AddVek(QuIrrSel(1,i),QuRacSel,xp,3)
        else
          call CopyVek(QuIrrSel(1,i),xp,3)
        endif
        if(.not.eqrv(QuOrg(1,i),xp,3,.001)) go to 3020
3010  continue
      go to 5000
3020  Change=.true.
      TextInfo(1)='The final space group in the standard setting'
      if(ndimi.gt.0) then
        Cislo='Superspace'
      else
        Cislo='Space'
      endif
      TextInfo(2)=Cislo(:idel(Cislo))//' group    : '//
     1            GrupaSel(:idel(GrupaSel))
      write(t80,'(3f9.4,3f9.3)') CellParSel
      call ZdrcniCisla(t80,6)
      TextInfo(3)='Cell parameters: '//t80(:idel(t80))
      NInfo=3
      do 3030i=1,ndimi
        NInfo=NInfo+1
        if(ndimi.eq.1) then
          write(TextInfo(NInfo),'(''Modulation vector: '',3f8.3)')
     1                          (QuIrrSel(j,i)+QuRacSel(j),j=1,3)
        else
          write(TextInfo(NInfo),'(''Modulation vector #'',i1,'':'',
     1                            3f8.3)') i,(QuIrrSel(j,i),j=1,3)
        endif
3030  continue
      n=NInfo
      call Mala(Cislo)
      t80='Accept the '//Cislo(:idel(Cislo))//' group'
      NInfo=NInfo+1
      if(MatRealEqUnitMat(CellTrSel6,ndim,.001)) then
        TextInfo(NInfo)=t80
        WhatToDoMax=2
      else
        TextInfo(NInfo)=t80(:idel(t80))//' in the standard setting'
        NInfo=NInfo+1
        TextInfo(NInfo)=t80(:idel(t80))//
     1                  ', but transform it to the original cell'
        WhatToDoMax=3
      endif
      NInfo=NInfo+1
      TextInfo(NInfo)='Discard the changes'
      WhatToDo=FeSelectOnePossibility(-1.,-1.,n,1)
      if(WhatToDo.lt.WhatToDoMax) then
        if(WhatToDo.eq.1) then
          if(ExistM94) then
            Grupa=GrupaSel
            call CopyVek(CellParSel,CellDatRed(1,2),6)
            call CopyVek(CellParSel,CellDatRed(1,3),6)
            call multm(TrMPOrg,CellTrSel6,TrMP,ndim,ndim,ndim)
            if(ndimi.gt.0) then
              call CopyVek(QuIrrSel(1,1),QuDatRed(1,1,2),ndimi*3)
              call CopyVek(QuIrrSel(1,1),QuDatRed(1,1,3),ndimi*3)
              if(ndimi.eq.1) then
                call AddVek(QuDatRed(1,1,2),QuRacSel,QuDatRed(1,1,2),3)
                call AddVek(QuDatRed(1,1,3),QuRacSel,QuDatRed(1,1,3),3)
              endif
            endif
            call iom94(1)
          endif
        endif
        if(ExistM50) then
          if(GrupaSel(1:1).eq.'X') then
            do 3050i=1,nVT
              call CopyVek(vt6(1,i,1,KPhase),VT6X(1,i),ndim)
3050        continue
            nVTX=nVT
          endif
          call iom50(0,0)
          if(GrupaSel(1:1).eq.'X') then
            nVT=nVTX
            do 3060i=1,nVTX
              call CopyVek(VT6X(1,i),vt6(1,i,1,KPhase),ndim)
3060        continue
          endif
        endif
        NGrupa=iGSel
        CrSystem=mod(CrSystemSel,10)
        Monoclinic=CrSystemSel/10
        Grupa=GrupaSel
        call CopyVek(CellParSel,CellPar(1,1,1),6)
        if(ndimi.gt.0) then
          call CopyVek(QuIrrSel(1,1),Qu(1,1,1,KPhase),ndimi*3)
          if(ndimi.eq.1) then
            call CopyVek(QuRacSel,quir(1,1,KPhase),3)
            call AddVek(Qu(1,1,1,KPhase),QuRacSel,Qu(1,1,1,KPhase),3)
          endif
        endif
        call EM50GenSym(RunForFirstTimeNo,MakeCellTestNo,
     1                  AskForDeltaNo,ich)
        if(WhatToDo.ne.1) then
          call CopyVek(CellParOrg,CellPar(1,1,1),6)
          if(ndimi.gt.0)
     1      call CopyVek(QuOrg(1,1),Qu(1,1,1,KPhase),ndimi*3)
          call matinv(trm6I,trm6,VolRatio,ndim)
          call MatBlock3(trm6,trm3,ndim)
          call matinv(trm3,trm3i,VolRatio,3)
          do 4100i=1,ns
            call multm(trm6i,rm6(1,i,1,KPhase),rmp,ndim,ndim,ndim)
            call multm(rmp,trm6,rm6(1,i,1,KPhase),ndim,ndim,ndim)
            call multm(trm6i,s6(1,i,1,KPhase),rmp,ndim,ndim,1)
            call od0do1(rmp,s6(1,i,1,KPhase),ndim)
            call CopyMat(rm6(1,i,1,KPhase),rm6(1,i,1,KPhase),ndim)
4100      continue
          nvtt=0
          do 4140i=1,nvt
            call multm(trm6i,vt6(1,i,1,KPhase),rmp,ndim,ndim,1)
            call od0do1(rmp,xp,ndim)
            do 4120j=1,nvtt
              if(eqrv(xp,vt6(1,j,1,KPhase),ndim,.001)) go to 4140
4120        continue
            nvtt=nvtt+1
            call CopyVek(xp,vt6(1,nvtt,1,KPhase),ndim)
4140      continue
          if(VolRatio.gt.1.5) then
            i=nint(VolRatio)-1
            do 4230i3=-i,i
              xp(3)=i3
              do 4220i2=-i,i
                xp(2)=i2
                do 4210i1=-i,i
                  xp(1)=i1
                  call multm(trm3i,xp,rmp,3,3,1)
                  call od0do1(rmp,hp,3)
                  do 4200j=1,nvtt
                    if(eqrv(hp,vt6(1,j,1,KPhase),3,.001)) go to 4210
4200              continue
                  nvtt=nvtt+1
                  call CopyVek(hp,vt6(1,nvtt,1,KPhase),3)
                  call SetRealArrayTo(vt6(4,nvtt,1,KPhase),ndimi,0.)
4210            continue
4220          continue
4230        continue
          endif
          call EM50CompleteCentr(0,vt6,nvtt,ich)
          nvt=nvtt
          call FindSmbSg(Grupa,ChangeOrderNo,1)
          if(ExistM94) then
            call CopyMat(TrMPOrg,TrMP,ndim)
            call iom94(1)
          endif
        endif
        if(ExistM50) call iom50(1,0)
      else
        Change=.false.
      endif
5000  if(ExistM94) call iom94(0)
      call DeleteFile(PreviousM50)
9999  call CloseIfOpened(95)
100   format(i15,'/'i15)
101   format(f10.3)
104   format(5i5,l5,3i5,3f8.3,f10.5)
      end
      subroutine DRSGTestLaue(CellParOrg,QuOrg,LookForSuperCell,ich)
      include 'params.cmn'
      include 'basic.cmn'
      include 'fepc.cmn'
      include 'datred.cmn'
      dimension CellParArr(6,11),CellTrArr(36,11),TrPom(3,3),i90(3),
     1          ToOrtho(9),FromOrtho(9),QuPom(3,3),QuOrg(3,3),
     2          QuIrrArr(3,3,11),QuRacArr(3,11),CellParOrg(6)
      character*256 Radka
      character*80  CellText(15)
      character*22  CrSystemName(11)
      integer CrSystemFromCell,CrSystemReduced,CrSystemPure,CrSystemAxis
      logical CrwLogicQuest,LookForSuperCell
      data CrSystemName/'Triclinic',
     1                  'Monoclinic-setting "a"',
     2                  'Monoclinic-setting "b"',
     3                  'Monoclinic-setting "c"',
     4                  'Orthorhombic',
     5                  'Tetragonal-setting "a"',
     6                  'Tetragonal-setting "b"',
     7                  'Tetragonal-setting "c"',
     8                  'Trigonal',
     9                  'Hexagonal',
     a                  'Cubic'/
      do 1210i=1,11
        CellParArr(1,i)=-1.
1210  continue
      call CopyVek(CellParOrg,CellParArr,6)
      call UnitMat(CellTrArr,ndim)
      if(LookForSuperCell) call DRSGTestSuperCell(CellParArr,CellTrArr)
      if(ReduceCell) call Redukce(CellParArr,CellTrArr)
      CrSystemReduced=CrSystemFromCell(CellParArr,DiffAxe,DiffAngle)
      CrSystemPure=mod(iabs(CrSystemReduced),10)
      CrSystemAxis=iabs(CrSystemReduced)/10
      if(CrSystemPure.eq.CrSystemCubic) then
        call CopyVek(CellParArr(1,IdTriclinic),
     1               CellParArr(1,IdCubic),6)
        call CopyMat(CellTrArr(1,IdTriclinic),
     1               CellTrArr(1,IdCubic),ndim)
        call CopyVek(CellParArr(1,IdTriclinic),
     1               CellParArr(1,IdTetragonalC),6)
        call CopyMat(CellTrArr(1,IdTriclinic),
     1               celltrarr(1,IdTetragonalC),ndim)
        call CopyVek(CellParArr(1,IdTriclinic),
     1               CellParArr(1,IdTetragonalB),6)
        call CopyMat(CellTrArr(1,IdTriclinic),
     1               CellTrArr(1,IdTetragonalB),ndim)
        call SetPermutMat(TrPom,3,231,ich)
        call TrPar(TrPom,CellParArr(1,IdTetragonalB),
     1                   CellTrArr(1,IdTetragonalB))
        call CopyVek(CellParArr(1,IdTriclinic),
     1               CellParArr(1,IdTetragonalA),6)
        call CopyMat(CellTrArr(1,IdTriclinic),
     1               CellTrArr(1,IdTetragonalA),ndim)
        call SetPermutMat(TrPom,3,312,ich)
        call TrPar(TrPom,CellParArr(1,IdTetragonalA),
     1                   CellTrArr(1,IdTetragonalA))
        call CopyVek(CellParArr(1,IdTriclinic),
     1               CellParArr(1,IdOrthorhombic),6)
        call CopyMat(CellTrArr(1,IdTriclinic),
     1               CellTrArr(1,IdOrthorhombic),ndim)
        go to 1350
      else if(CrSystemPure.eq.CrSystemHexagonal) then
        call CopyVek(CellParArr(1,IdTriclinic),
     1               CellParArr(1,IdHexagonal),6)
        call CopyMat(CellTrArr(1,IdTriclinic),
     1               CellTrArr(1,IdHexagonal),ndim)
        if(CrSystemAxis.eq.3.or.CrSystemAxis.eq.0) then
          i=123
        else if(CrSystemAxis.eq.1) then
          i=312
        else if(CrSystemAxis.eq.2) then
          i=231
        endif
        call SetPermutMat(TrPom,3,i,ich)
        call TrPar(TrPom,CellParArr(1,IdHexagonal),
     1                   CellTrArr(1,IdHexagonal))
        if(CrSystemReduced.lt.0) then
          call UnitMat(TrPom,3)
          TrPom(2,2)=-1.
          TrPom(3,3)=-1.
          call TrPar(TrPom,CellParArr(1,IdHexagonal),
     1                     CellTrArr(1,IdHexagonal))
        endif
        call CopyVek(CellParArr(1,IdHexagonal),
     1               CellParArr(1,IdTrigonal ),6)
        call CopyMat(CellTrArr(1,IdHexagonal),
     1               CellTrArr(1,IdTrigonal ),ndim)
        call CopyVek(CellParArr(1,IdHexagonal),
     1               CellParArr(1,IdMonoclinicC),6)
        call CopyMat(CellTrArr(1,IdHexagonal),
     1               CellTrArr(1,IdMonoclinicC),ndim)
      else if(CrSystemPure.eq.CrSystemTrigonal) then
        call CopyVek(CellParArr(1,IdTriclinic),
     1               CellParArr(1,IdTrigonal),6)
        call CopyMat(CellTrArr(1,IdTriclinic),
     1               CellTrArr(1,IdTrigonal ),ndim)
        if(CrSystemReduced.eq.-CrSystemTrigonal) then
          call UnitMat(TrPom,3)
          TrPom(2,1)=-1.
          TrPom(3,2)=-1.
          TrPom(1,3)= 1.
          TrPom(2,3)= 1.
          call TrPar(TrPom,CellParArr(1,IdTrigonal),
     1                     CellTrArr(1,IdTrigonal))
        endif
        call CopyVek(CellParArr(1,IdTrigonal),
     1               CellParArr(1,IdMonoclinicC),6)
        call CopyMat(CellTrArr(1,IdTrigonal),
     1               CellTrArr(1,IdMonoclinicC),ndim)
      else if(CrSystemPure.eq.CrSystemTetragonal) then
        call CopyVek(CellParArr(1,IdTriclinic),
     1               CellParArr(1,IdTetragonalC),6)
        call CopyMat(CellTrArr(1,IdTriclinic),
     1               CellTrArr(1,IdTetraGonalC),ndim)
        if(CrSystemAxis.eq.3.or.CrSystemAxis.eq.0) then
          i=123
        else if(CrSystemAxis.eq.1) then
          i=312
        else if(CrSystemAxis.eq.2) then
          i=231
        endif
        call SetPermutMat(TrPom,3,i,ich)
        call TrPar(TrPom,CellParArr(1,IdTetragonalC),
     1                   CellTrArr(1,IdTetragonalC))
        call CopyVek(CellParArr(1,IdTriclinic),
     1               CellParArr(1,IdOrthorhombic),6)
        call CopyMat(CellTrArr(1,IdTriclinic),
     1               CellTrArr(1,IdOrthorhombic),ndim)
        go to 1350
      else if(CrSystemPure.eq.CrSystemOrthorhombic) then
        call CopyVek(CellParArr(1,IdTriclinic),
     1               CellParArr(1,IdOrthoRhombic),6)
        call CopyMat(CellTrArr(1,IdTriclinic),
     1               CellTrArr(1,IdOrthoRhombic),ndim)
        go to 1350
      else if(CrSystemPure.eq.CrSystemMonoclinic) then
        if(CrSystemAxis.eq.3.or.CrSystemAxis.eq.0) then
          i=123
        else if(CrSystemAxis.eq.1) then
          i=312
        else if(CrSystemAxis.eq.2) then
          i=231
        endif
        j=IdMonoclinicB
        call CopyVek(CellParArr(1,IdTriclinic),CellParArr(1,j),6)
        call CopyMat(CellTrArr(1,IdTriclinic),CellTrArr(1,j),ndim)
        call SetPermutMat(TrPom,3,i,ich)
        call TrPar(TrPom,CellParArr(1,j),CellTrArr(1,j))
      endif
      go to 1400
1350  call CopyVek(CellParArr(1,IdTriclinic),
     1             CellParArr(1,IdMonoclinicC),6)
      call CopyMat(CellTrArr(1,IdTriclinic),
     1             CellTrArr(1,IdMonoclinicC),ndim)
      call CopyVek(CellParArr(1,IdTriclinic),
     1             CellParArr(1,IdMonoclinicB),6)
      call CopyMat(CellTrArr(1,IdTriclinic),
     1             CellTrArr(1,IdMonoclinicB),ndim)
      call SetPermutMat(TrPom,3,231,ich)
      call TrPar(TrPom,CellParArr(1,IdMonoclinicB),
     1                 CellTrArr(1,IdMonoclinicB))
      call CopyVek(CellParArr(1,IdTriclinic),
     1             CellParArr(1,IdMonoclinicA),6)
      call CopyMat(CellTrArr(1,IdTriclinic),
     1             CellTrArr(1,IdMonoclinicA),ndim)
      call SetPermutMat(TrPom,3,312,ich)
      call TrPar(TrPom,CellParArr(1,IdMonoclinicA),
     1                 CellTrArr(1,IdMonoclinicA))
1400  ncs=2
      il=2
      do 1420i=1,11
        if(CellParArr(1,i).gt.0.) then
          il=il+1
          if(i.eq.IdCubic.or.i.eq.IdHexagonal.or.
     1       i.eq.IdTetragonalA.or.i.eq.IdTetragonalB.or.
     2       i.eq.IdTetragonalC) then
            il=il+1
          else if(i.eq.IdTrigonal) then
            il=il+2
          endif
        endif
1420  continue
      ich=0
      id=NextQuestId()
      xqd=240.
      call FeQuestCreate(id,-1.,-1.,xqd,0,il,'Select Laue symmetry',0,
     1                   LightGray,0,0)
      il=1
      CellText(1)=' '
      CellText(1)(29:)='Rint(obs/all)   #averaged   Redundancy'
      xpom=5.
      tpom=xpom+5.+CrwgXd
      call FeQuestLabelMake(id,tpom,il,CellText(1),'L')
      nCrwLowest=0
      RIntAllLowest=9999999.
      RIntAllLimit=10.
      nCrwOptimal=0
      NInfo=1
      do 1600i=1,11
        if(i.eq.IdTriclinic) then
          LaueGroup=0
          nLaueGroup=1
          CrSystem=CrSystemTriclinic
          Monoclinic=0
        else if(i.eq.IdMonoclinicA) then
          LaueGroup=1
          CrSystem=CrSystemMonoclinic
          Monoclinic=3
        else if(i.eq.IdOrthorhombic) then
          LaueGroup=2
          CrSystem=CrSystemOrthorhombic
          Monoclinic=0
        else if(i.eq.IdTetragonalA) then
          LaueGroup=3
          nLaueGroup=2
          CrSystem=CrSystemTetragonal
        else if(i.eq.IdTrigonal) then
          LaueGroup=5
          nLaueGroup=3
          CrSystem=CrSystemHexagonal
        else if(i.eq.IdHexagonal) then
          LaueGroup=9
          nLaueGroup=2
          CrSystem=CrSystemHexagonal
        else if(i.eq.IdCubic) then
          LaueGroup=11
          CrSystem=CrSystemCubic
        endif
        if(CellParArr(1,i).gt.0.) then
          call CopyMat(CellTrArr(1,i),trmp,ndim)
          if(i.eq.IdTriclinic) then
            call SetIntArrayTo(i90,3,0)
          else
            call SetIntArrayTo(i90,3,1)
            if(i.eq.IdMonoclinicA.or.i.eq.IdMonoclinicB.or.
     1         i.eq.IdMonoclinicC.or.i.eq.IdHexagonal.or.
     2         i.eq.IdTrigonal) i90(3)=0
          endif
          do 1500j=1,3
            if(i90(j).eq.1) CellParArr(j+3,i)=90.
1500      continue
          if(i.eq.IdTetragonalA.or.i.eq.IdTetragonalB.or.
     1       i.eq.IdTetragonalC.or.i.eq.IdHexagonal.or.
     2       i.eq.IdTrigonal) then
            pom=(CellParArr(1,i)+CellParArr(2,i))*.5
            CellParArr(1,i)=pom
            CellParArr(2,i)=pom
          else if(i.eq.IdCubic) then
            pom=(CellParArr(1,i)+CellParArr(2,i)+CellParArr(3,i))/3.
            CellParArr(1,i)=pom
            CellParArr(2,i)=pom
            CellParArr(3,i)=pom
          endif
          if(i.eq.IdHexagonal.or.i.eq.IdTrigonal) CellParArr(6,i)=120.
          csa=cos(torad*CellParArr(4,i))
          csb=cos(torad*CellParArr(5,i))
          csg=cos(torad*CellParArr(6,i))
          snb=sqrt(1.-csb**2)
          sng=sqrt(1.-csg**2)
          pom=(csa-csb*csg)/sng
          ToOrtho(1)=CellParArr(1,i)
          ToOrtho(2)=0.
          ToOrtho(3)=0.
          ToOrtho(4)=CellParArr(2,i)*csg
          ToOrtho(5)=CellParArr(2,i)*sng
          ToOrtho(6)=0.
          ToOrtho(7)=CellParArr(3,i)*csb
          ToOrtho(8)=CellParArr(3,i)*pom
          ToOrtho(9)=CellParArr(3,i)*snb*sqrt(1.-(pom/snb)**2)
          call matinv(ToOrtho,FromOrtho,pom,3)
          do 1550j=1,nLaueGroup
            il=il+1
            NInfo=NInfo+1
            Radka=CrSystemName(i)
            if((CrSystemPure.eq.CrSystemMonoclinic.and.
     1          i.eq.IdMonoclinicB).or.
     2         (CrSystemPure.eq.CrSystemTetragonal.and.
     3          i.eq.IdTetragonalC)) then
              k=index(Radka,'-')
              Radka(k:)=' '
            endif
            if(ndimi.gt.0) then
              call MatBlock3(CellTrArr(1,i),TrPom,ndim)
              do 1520k=1,ndimi
                call Multm(QuOrg(1,k),TrPom,QuPom(1,k),1,3,3)
1520          continue
            endif
            k=LaueGroupPointer(LaueGroup+j)
            call DRAverageForPointGroup(Radka,SmbPGI(k),QuPom,ToOrtho,
     1                    FromOrtho,QuIrrArr(1,1,i),QuRacArr(1,i),ich)
            CellText(il)=TextInfo(NInfo)
            call FeQuestCrwMake(id,tpom,il,xpom,il,CellText(il),'L',
     1                          CrwgXd,CrwgYd,0,1)
            if(ich.ne.0) then
              call FeQuestLabelMake(id,tpom,il,CellText(il),'L')
            else
              if(i.eq.1) nCrwFirst=CrwLastMade
              if(RIntAll.le.RIntAllLowest) then
                nCrwLowest=CrwLastMade
                RIntAllLowest=RIntAll
              endif
              if(RIntAll.lt.RIntAllLimit) nCrwOptimal=CrwLastMade
              call FeQuestCrwOpen(CrwLastMade,.false.)
            endif
            call FeReleaseOutput
            call FeDeferOutput
1550      continue
        endif
1600  continue
      nCrwLast=CrwLastMade
      if(nCrwOptimal.ne.0) then
        nCrw=nCrwOptimal
      else
        nCrw=nCrwLowest
      endif
      call FeQuestCrwOpen(nCrw,.true.)
      il=il+1
      CellText(il)=TextInfo(1)
      call FeQuestLabelMake(id,5.,il,CellText(il),'L')
      icont=0
1700  call FeQuestEvent(id,icont,ich)
      icont=1
      if(CheckType.ne.0) then
        call NebylOsetren
        go to 1700
      endif
      if(ich.eq.0) then
        nCrw=nCrwFirst
        do 1800i=1,11
          if(i.eq.IdTriclinic) then
            LaueGroup=0
            nLaueGroup=1
            CrSystem=CrSystemTriclinic
          else if(i.eq.IdMonoclinicA) then
            LaueGroup=1
            CrSystem=CrSystemMonoclinic
          else if(i.eq.IdOrthorhombic) then
            LaueGroup=2
            CrSystem=CrSystemOrthorhombic
          else if(i.eq.IdTetragonalA) then
            LaueGroup=3
            nLaueGroup=2
            CrSystem=CrSystemTetragonal
          else if(i.eq.IdTrigonal) then
            LaueGroup=5
            nLaueGroup=3
            CrSystem=CrSystemTrigonal
          else if(i.eq.IdHexagonal) then
            LaueGroup=9
            nLaueGroup=2
            CrSystem=CrSystemHexagonal
          else if(i.eq.IdCubic) then
            LaueGroup=11
            CrSystem=CrSystemCubic
          endif
          if(CellParArr(1,i).gt.0.) then
            do 1750j=1,NLaueGroup
              if(CrwLogicQuest(nCrw)) then
                call CopyVek(CellParArr(1,i),CellParSel,6)
                call CopyMat(CellTrArr(1,i),CellTrSel6,ndim)
                NCellSel=i
                LaueGroupSel=LaueGroup+j
                if(ndimi.gt.0) then
                  call CopyVek(QuIrrArr(1,1,i),QuIrrSel,3*ndimi)
                  if(ndimi.eq.1) call CopyVek(QuRacArr(1,i),QuRacSel,3)
                endif
                go to 1900
              endif
              nCrw=nCrw+1
1750        continue
          endif
1800    continue
      endif
1900  call FeQuestRemove(id)
      if(ich.ne.0) then
        go to 9999
      endif
      if(CrSystem.eq.CrSystemMonoclinic) then
        Monoclinic=2
        call SetPermutMat(TrPom,3,312,ich)
        call TrParQ(TrPom,CellParSel,QuIrrSel,QuRacSel,CellTrSel6)
      endif
9999  return
      end
      subroutine DRSGTestSuperCell(CellStart,CellTrStart)
      include 'params.cmn'
      include 'basic.cmn'
      include 'datred.cmn'
      include 'fepc.cmn'
      dimension CellPom(6),TrPom(3,3),CellStart(6),CellTrStart(36),
     1          Tr(36),CellFound(6,10),TrFound(36,10)
      character*80 t80
      integer CrSystemStart,CrSystemPom,CrSystemFromCell,
     1        CrSystemFound(10)
      logical SelwLogicQuest
      call SetRealArrayTo(TrPom,9,0.)
      CrSystemStart=mod(CrSystemFromCell(CellStart,DiffAxe,DiffAngle),
     1                  10)
      csa=cos(CellStart(4)*ToRad)
      csb=cos(CellStart(5)*ToRad)
      csg=cos(CellStart(6)*ToRad)
      VolStart=CellStart(1)*CellStart(2)*CellStart(3)*
     1         sqrt(1.-csa**2-csb**2-csg**2+2.*csa*csb*csg)
      n=0
      do 3000i=2,6
        if(i.eq.6) then
          jk=3
        else if(i.eq.4) then
          jk=2
        else
          jk=1
        endif
        do 2500j=1,jk
          if(j.eq.1) then
            IPom1=i
            IPom2=1
            IPom3=1
          else if(j.eq.2) then
            if(i.eq.4) then
              IPom1=1
              IPom2=2
              IPom3=2
            else if(i.eq.6) then
              IPom1=1
              IPom2=2
              IPom3=3
            endif
          else
            IPom1=1
            IPom2=3
            IPom3=2
          endif
          do 2000k=1,3
            do 1100l=1,3
              if(l.eq.k) then
                TrPom(l,l)=IPom1
              else if(l.eq.mod(k,3)+1) then
                TrPom(l,l)=IPom2
              else if(l.eq.mod(k+1,3)+1) then
                TrPom(l,l)=IPom3
              endif
1100        continue
            i21p=0
            i21k=nint(TrPom(2,2))-1
            i31p=0
            i31k=nint(TrPom(3,3))-1
            i32p=0
            i32k=nint(TrPom(3,3))-1
            do 1400i21=i21p,i21k
              TrPom(2,1)=i21
              do 1300i31=i31p,i31k
                TrPom(3,1)=i31
                do 1200i32=i32p,i32k
                  TrPom(3,2)=i32
                  call CopyVek(CellStart,CellPom,6)
                  call UnitMat(Tr,ndim)
                  call TrPar(TrPom,CellPom,Tr)
                  call Redukce(CellPom,Tr)
                  CrSystemPom=
     1              mod(CrSystemFromCell(CellPom,DiffAxe,DiffAngle),10)
                  if(CrSystemPom.gt.CrSystemStart.and.n.le.10) then
                    CrSystemPom=-(CrSystemPom+1)*10+i
                    if(n.lt.10) then
                      n=n+1
                    else
                      if(CrSystemPom.ge.CrSystemFound(n)) go to 1200
                    endif
                    call CopyVek(CellPom,CellFound(1,n),6)
                    call CopyMat(Tr,TrFound(1,n),ndim)
                    CrSystemFound(n)=CrSystemPom
                    if(n.eq.10) call indexx(10,CrSystemFound,ipor)
                  endif
1200            continue
1300          continue
1400        continue
2000      continue
2500    continue
3000  continue
      if(n.gt.0) then
        if(n.lt.10) call indexx(n,CrSystemFound,ipor)
        id=NextQuestId()
        xqd=200.
        il=n+2
        call FeQuestCreate(id,-1.,-1.,xqd,il,0,'Select supercell',0,
     1                     LightGray,0,0)
        il=1
        t80='                 Cell                            n*Volume'
        xpom=5.
        call FeQuestLabelMake(id,xpom,il,t80,'L')
        dpom=xqd-10.
        do 3100i=1,n
          il=il+1
          k=ipor(i)
          csa=cos(CellFound(4,k)*ToRad)
          csb=cos(CellFound(5,k)*ToRad)
          csg=cos(CellFound(6,k)*ToRad)
          Vol=CellFound(1,k)*CellFound(2,k)*CellFound(3,k)*
     1        sqrt(1.-csa**2-csb**2-csg**2+2.*csa*csb*csg)
          write(t80,'(i2,''*'',f10.2)') nint(Vol/VolStart),VolStart
          call Zhusti(t80)
          j=idel(t80)
          l=max(13-j,1)
          Cislo=' '
          Cislo(l:)=t80(:j)
          write(t80,'(3f7.3,3f7.2,'' | '',a)')
     1      (CellFound(j,k),j=1,6),Cislo(:idel(Cislo))
          call FeQuestSelwMake(id,xpom,il,t80,dpom,SelwYd,0,1)
          if(i.eq.1) nSelwFirst=SelwLastMade
          call FeQuestSelwOpen(SelwLastMade,.false.)
3100    continue
        t80='        continue with the basic cell'
        il=il+1
        call FeQuestSelwMake(id,xpom,il,t80,dpom,SelwYd,0,1)
        nSelwFirst=SelwLastMade
        call FeQuestSelwOpen(SelwLastMade,.true.)
        icont=0
3500    call FeQuestEvent(id,icont,ich)
        icont=1
        if(CheckType.ne.0) then
          call NebylOsetren
          go to 3500
        endif
        if(ich.eq.0) then
          nSelw=1
          do 3600i=1,n+1
            if(SelwLogicQuest(nSelw)) then
              if(i.le.n) then
                k=ipor(i)
                call CopyVek(CellFound(1,k),CellStart,6)
                call Multm(TrFound(1,k),CellTrStart,Tr,ndim,ndim,ndim)
                call CopyMat(Tr,CellTrStart,ndim)
              endif
              go to 4000
            endif
            nSelw=nSelw+1
3600      continue
        endif
4000    call FeQuestRemove(id)
      else
        NInfo=1
        TextInfo(1)='No supercell having a higher cell symmetry has '//
     1              'been found.'
        call FeInfoOut(-1.,-1.,'INFORMATION')
      endif
      return
      end
      subroutine DRAverageForPointGroup(CrSystemName,PointGroup,QuIn,
     1                       ToOrtho,FromOrtho,QuIrr,QuRac,ich)
      include 'params.cmn'
      include 'basic.cmn'
      include 'fepc.cmn'
      include 'datred.cmn'
      character*(*) PointGroup,CrSystemName
      dimension TrPom(9),ToOrtho(9),FromOrtho(9),QuIn(3,3),QuPom(3,3),
     1          pp(3),mpp(3),IIrr(3),pq(3),INul(3),QuRac(3),QuIrr(3,3)
      logical EqIgCase
      TextInfo(NInfo)=CrSystemName(1:22)//'  '//
     1                PointGroup(:idel(PointGroup))
      do 1000i=1,38
        if(EqIgCase(PointGroup,SmbPgI(i))) then
          IPointGroup=i
          go to 1050
        endif
1000  continue
      go to 9000
1050  if(ndimi.eq.1) then
        if(CrSystem.eq.CrSystemHexagonal.or.
     1     CrSystem.eq.CrSystemTrigonal) then
          Fact=3.
        else
          Fact=2.
        endif
        NIrr=0
        NNul=0
        do 1100i=1,3
          pom=abs(Fact*QuIn(i,1))
          if(abs(anint(pom)-pom).gt..01) then
            IIrr(i)=1
            NIrr=NIrr+1
          else
            IIrr(i)=0
          endif
          if(pom.gt..01) then
            INul(i)=0
          else
            NNul=NNul+1
            INul(i)=1
          endif
1100    continue
        if(CrSystem.eq.CrSystemTriclinic) then
          call SetIntArrayTo(IIrr,3,1)
        else if(CrSystem.eq.CrSystemMonoclinic) then
          if(NIrr.eq.0) then
            if(abs(QuIn(3,1)).gt.0.) then
              IIrr(3)=1
            else
              IIrr(1)=1
              IIrr(2)=1
            endif
          else if(NIrr.eq.1) then
            if(IIrr(3).ne.1) then
              IIrr(1)=1
              IIrr(2)=1
            endif
          else if(NIrr.eq.2) then
            if(IIrr(3).ne.0) go to 9000
          else if(NIrr.eq.3) then
            go to 9000
          endif
        else if(CrSystem.eq.CrSystemOrthorhombic) then
          if(NIrr.eq.0) then
            if(NNul.eq.3) then
              go to 9000
            else
              do 1120i=1,3
                if(INul(i).eq.0) then
                  IIrr(i)=1
                  NIrr=1
                  go to 1190
                endif
1120          continue
            endif
          else if(NIrr.gt.1) then
            go to 9000
          endif
        else
          if(NIrr.eq.0) then
            if(INul(3).eq.0) then
              IIrr(3)=1
            else
              go to 9000
            endif
          else if(NIrr.eq.1) then
            if(IIrr(3).eq.0) go to 9000
          else
            go to 9000
          endif
        endif
1190    do 1200i=1,3
          if(IIrr(i).eq.1) then
            if(QuIn(i,1).ge.0.) then
              zn= 1.
            else
              zn=-1.
            endif
            QuPom(i,1)=QuIn(i,1)+zn*sqrt(.02)
            QuIrr(i,1)=QuPom(i,1)
            QuRac(i)=0.
          else
            QuPom(i,1)=QuIn(i,1)
            QuIrr(i,1)=0.
            if(INul(i).eq.1) then
              QuRac(i)=0.
            else
              QuRac(i)=QuIn(i,1)
            endif
          endif
1200    continue
      else if(ndimi.gt.1) then
        call CopyVek(QuIn,QuPom,3*ndimi)
        call CopyVek(QuIn,QuIrr,3*ndimi)
      endif
      call GenPg(PointGroup,rm(1,1,1,KPhase),ns,ich)
      k1=0
      k2=0
      n1=0
      n2=0
      if(ndimi.gt.1) then
        k1=-1
        k2= 1
      endif
      if(ndimi.gt.2) then
        n1=-1
        n2= 1
      endif
      do 2000is=1,ns
        call Multm(FromOrtho,rm(1,is,1,KPhase),TrPom,3,3,3)
        call Multm(TrPom,ToOrtho,rm(1,is,1,KPhase),3,3,3)
        call SetRealArrayTo(rm6(1,is,1,KPhase),ndimq,0.)
        call SetRealArrayTo(s6(1,is,1,KPhase),ndim,0.)
        k=0
        do 1400i=1,3
          do 1350j=1,3
            k=k+1
            rm6(j+(i-1)*ndim,is,1,KPhase)=rm(k,is,1,KPhase)
1350      continue
1400    continue
        if(ndimi.le.0) go to 1550
        do 1500i=4,ndim
          do 1440j=1,3
            pom=0.
            do 1435k=1,3
              pom=pom+QuPom(k,i-3)*rm6(k+(j-1)*ndim,is,1,KPhase)
1435        continue
            pp(j)=pom
1440      continue
          do 1480n=n1,n2
            do 1470k=k1,k2
              do 1460j=-1,1
                do 1450l=1,3
                  pq(l)=float(j)*QuPom(l,1)-pp(l)
                  if(ndim.gt.4) pq(l)=pq(l)+float(k)*QuPom(l,2)
                  if(ndim.gt.5) pq(l)=pq(l)+float(n)*QuPom(l,3)
                  mpp(l)=nint(pq(l))
                  if(abs(pq(l)-float(mpp(l))).gt..0005) go to 1460
1450            continue
                do 1456l=1,3
                  rm6(i+ndim*(l-1),is,1,KPhase)=-mpp(l)
1456            continue
                rm6(i+ndim*3,is,1,KPhase)=j
                if(ndim.gt.4) rm6(i+ndim*4,is,1,KPhase)=k
                if(ndim.gt.5) rm6(i+ndim*5,is,1,KPhase)=n
                go to 1500
1460          continue
1470        continue
1480      continue
          go to 9000
1500    continue
1550    do 1600i=1,ndimq
          rm6(i,is,1,KPhase)=anint(rm6(i,is,1,KPhase))
1600    continue
2000  continue
      if(ndimi.eq.1) then
        do 2200i=1,3
          if(IIrr(i).eq.1) then
            if(QuIrr(i,1).ge.0.) then
              zn=-1.
            else
              zn= 1.
            endif
            QuIrr(i,1)=QuIrr(i,1)+zn*sqrt(.02)
          endif
2200    continue
      endif
      call DRAverage(2)
      go to 9999
9000  TextInfo(NInfo)=TextInfo(NInfo)(:31)//
     1                'inconsistent with modulation vector'
      ich=1
9999  return
      end
      subroutine DRSGTestCentr(ich)
      include 'params.cmn'
      include 'basic.cmn'
      include 'fepc.cmn'
      include 'datred.cmn'
      dimension NCenObs(728),NCenAll(728),BasCenVec(6,728),SCenAll(728),
     1          SCenObs(728),h(6),nx(6),ni(6),NSpec(8),VT6X(6,mxcen),
     2          NSelX(mxcen)
      character*256 Radka
      character*80  CenText(8),t80
      logical CrwLogicQuest,SelwLogicQuest,Observed,XCentr,lpom,
     1        BratVT6X(mxcen)
      if(NCellSel.eq.IdTrigonal) then
        nn=3
      else
        nn=2
      endif
      n=nn**ndim-1
      CentrStep=1./float(nn)
      call SetIntArrayTo(nx,ndim,nn)
      call SetIntArrayTo(NSpec,8,0)
      do 1100i=1,n
        call RecUnPack(i+1,ni,nx,ndim)
        do 1000j=1,ndim
          BasCenVec(j,i)=CentrStep*float(ni(j)-1)
1000    continue
        do 1020j=4,ndim
          if(ni(j).gt.1) go to 1100
1020    continue
        NNul=0
        KdeNul=0
        do 1030j=1,3
          if(ni(j).eq.1) then
            NNul=NNul+1
            KdeNul=j
          endif
1030    continue
        if(nn.eq.2) then
          if(NNul.eq.1) then
            NSpec(KdeNul+1)=i
          else if(NNul.eq.0) then
            NSpec(5)=i
          endif
        else
          if(NNul.eq.0) then
            if(ni(1).eq.2.and.ni(2).eq.3.and.ni(3).eq.3) then
              NSpec(6)=i+NSpec(6)
            else if(ni(1).eq.3.and.ni(2).eq.2.and.ni(3).eq.2) then
              NSpec(6)=i*1000+NSpec(6)
            else if(ni(1).eq.3.and.ni(2).eq.2.and.ni(3).eq.3) then
              NSpec(7)=i+NSpec(7)
            else if(ni(1).eq.2.and.ni(2).eq.3.and.ni(3).eq.2) then
              NSpec(7)=i*1000+NSpec(7)
            endif
          endif
        endif
1100  continue
      call SetIntArrayTo(NCenObs,n,0)
      call SetIntArrayTo(NCenAll,n,0)
      call SetRealArrayTo(SCenObs,n,0.)
      call SetRealArrayTo(SCenAll,n,0.)
      NCenObsF=0
      NCenAllF=0
      SCenObsF=0.
      SCenAllF=0.
      do 1400i=1,NRefRead
        call indtr(ihar(1,i),CellTrSel6,ih,ndim)
        do 1200j=1,ndim
          h(j)=ih(j)
1200    continue
        RelI=max(riar(i)/rsar(i),0.)
        Observed=RelI.gt.3.
        do 1300j=1,n
          pom=VecOrtScal(h,BasCenVec(1,j),ndim)
          if(abs(anint(pom)-pom).gt..0001) then
            SCenAll(j)=SCenAll(j)+RelI
            NCenAll(j)=NCenAll(j)+1
            if(Observed) then
              NCenObs(j)=NCenObs(j)+1
              SCenObs(j)=SCenObs(j)+RelI
            endif
          endif
1300    continue
        do 1350j=2,4
          k=NSpec(j)
          pom=VecOrtScal(h,BasCenVec(1,k),ndim)
          if(abs(anint(pom)-pom).gt..0001) then
            SCenAllF=SCenAllF+RelI
            NCenAllF=NCenAllF+1
            if(Observed) then
              SCenObsF=SCenObsF+RelI
              NCenObsF=NCenObsF+1
            endif
            go to 1400
          endif
1350    continue
1400  continue
      if(NCenAllF.gt.0) then
        SCenAllF=SCenAllF/float(NCenAllF)
      else
        SCenAllF=0.
      endif
      if(NCenObsF.gt.0) then
        SCenObsF=SCenObsF/float(NCenObsF)
      else
        SCenObsF=0.
      endif
      do 1410i=1,n
        if(NCenAll(i).gt.0) then
          SCenAll(i)=SCenAll(i)/float(NCenAll(i))
        else
          SCenAll(i)=0.
        endif
        if(NCenObs(i).gt.0) then
          SCenObs(i)=SCenObs(i)/float(NCenObs(i))
        else
          SCenObs(i)=0.
        endif
1410  continue
      FLim=SumaObsLimCentr
1420  call SetRealArrayTo(VT6X(1,1),ndim,0.)
      call SetLogicalArrayTo(BratVT6X,mxcen,.true.)
      nVTX=1
      XCentr=.false.
      do 1500i=1,n
        if(SCenObs(i).lt.Flim) then
          nVTX=nVTX+1
          call CopyVek(BasCenVec(1,i),VT6X(1,nVTX),ndim)
          NSelX(nVTX)=i
          if(.not.XCentr) then
            if(nn.eq.2) then
              do 1450j=2,5
                if(NSpec(j).eq.i) go to 1500
1450          continue
              XCentr=.true.
            else
              do 1460j=6,7
                if(mod(NSpec(j),1000).eq.i.or.NSpec(j)/1000.eq.i)
     1            go to 1500
1460          continue
              XCentr=.true.
            endif
          endif
        endif
1500  continue
      if(XCentr) then
        nVTXOld=nVTX
        call EM50CompleteCentr(1,VT6X,nVTX,ich)
        if(nVTX.ne.nVTXOld.or.ich.ne.0) then
          if(FLim.gt.0.) then
            Flim=Flim-.1
            go to 1420
          else
            XCentr=.false.
          endif
        endif
      endif
2000  ich=0
      id=NextQuestId()
      xqd=150.
      if(NCellSel.eq.IdTrigonal) then
        ilm=4
      else
        ilm=7
      endif
      if(XCentr) ilm=ilm+2
      call FeQuestCreate(id,-1.,-1.,xqd,0,ilm,'Select cell centering',0,
     1                   LightGray,0,0)
      il=1
      ic=0
      CenText(1)='Centering       obs/all       ave(I/sig(I))'
      xpom=5.
      tpom=xpom+5.+CrwgXd
      call FeQuestLabelMake(id,tpom,il,CenText(1),'L')
      if(XCentr) then
        NCenObsX=0
        NCenAllX=0
        SCenObsX=0.
        SCenAllX=0.
        do 1800i=1,NRefRead
          call indtr(ihar(1,i),CellTrSel6,ih,ndim)
          do 1600j=1,ndim
            h(j)=ih(j)
1600      continue
          RelI=max(riar(i)/rsar(i),0.)
          Observed=RelI.gt.3.
          do 1700j=2,nVTX
            pom=VecOrtScal(h,VT6X(1,j),ndim)
            if(abs(anint(pom)-pom).gt..0001) then
              SCenAllX=SCenAllX+RelI
              NCenAllX=NCenAllX+1
              if(Observed) then
                NCenObsX=NCenObsX+1
                SCenObsX=SCenObsX+RelI
              endif
              go to 1800
            endif
1700      continue
1800    continue
        if(NCenAllX.gt.0) then
          SCenAllX=SCenAllX/float(NCenAllX)
        else
          SCenAllX=0.
        endif
        if(NCenObsX.gt.0) then
          SCenObsX=SCenObsX/float(NCenObsX)
        else
          SCenObsX=0.
        endif
      endif
      do 2400i=1,9
        if(i.ne.IdCentrRRev) ic=ic+1
        if(ic.eq.6.and.NCellSel.ne.IdTrigonal) go to 2400
        if(NCellSel.eq.IdTrigonal.and.ic.ne.1.and.ic.ne.6) go to 2400
        if(i.eq.IdCentrX.and..not.XCentr) go to 2400
        il=il+1
        if(ic.eq.6) then
          if(i.eq.ic) then
            Cislo='-obverse'
          else
            Cislo='-reverse'
          endif
          CenText(il)=smbc(ic:ic)//Cislo(:idel(Cislo))
        else
          CenText(il)='    '//smbc(ic:ic)
        endif
        if(i.eq.IdCentrP) then
          nall=0
          nobs=0
          SumObs=0.
          SumAll=0.
        else if(i.le.IdCentrRRev) then
          if(i.eq.IdCentrA) then
            k=NSpec(2)
          else if(i.eq.IdCentrB) then
            k=NSpec(3)
          else if(i.eq.IdCentrC) then
            k=NSpec(4)
          else if(i.eq.IdCentrI) then
            k=NSpec(5)
          else if(i.eq.IdCentrRObv) then
            k=mod(NSpec(6),1000)
          else if(i.eq.IdCentrRRev) then
            k=mod(NSpec(7),1000)
          endif
          nobs=NCenObs(k)
          nall=NCenAll(k)
          SumObs=SCenObs(k)
          SumAll=SCenAll(k)
        else if(i.eq.IdCentrF) then
          nobs=NCenObsF
          nall=NCenAllF
          SumObs=SCenObsF
          SumAll=SCenAllF
        else if(i.eq.IdCentrX) then
          nobs=NCenObsX
          nall=NCenAllX
          SumObs=SCenObsX
          SumAll=SCenAllX
        endif
        write(Radka,100) nobs,nall
        call Zhusti(Radka)
        j=index(Radka,'/')
        CenText(il)(21-j:)=Radka(:idel(Radka))
        write(Radka,101) SumObs,SumAll
        call Zhusti(Radka)
        j=index(Radka,'/')
        CenText(il)(37-j:)=Radka(:idel(Radka))
        call FeQuestCrwMake(id,tpom,il,xpom,il,CenText(il),'L',
     1                      CrwgXd,CrwgYd,0,1)
        if(i.eq.1) nCrwFirst=CrwLastMade
        if(SumObs.lt.5.) nCrwOpt=CrwLastMade
        call FeQuestCrwOpen(CrwLastMade,.false.)
2400  continue
      call FeQuestCrwOn(nCrwOpt)
      if(XCentr) then
        il=il+1
        Radka='%Show/modify X centering'
        dpom=FeTxLengthUnder(Radka)+10.
        xpom=(xqd-dpom)*.5
        call FeQuestButtonMake(id,xpom,il,dpom,ButYd,Radka)
        nButtXCentr=ButtonLastMade
        call FeQuestButtonOpen(ButtonLastMade,ButtonOff)
      endif
2450  icont=0
2500  call FeQuestEvent(id,icont,ich)
      icont=1
      if(CheckType.eq.EventButton.and.CheckNumber.eq.nButtXCentr) then
        nmax=min(8,nVTX)
        idp=NextQuestId()
        xqdp=float(ndim*4+30)*SmallFontWidth+15.
        il=nmax+1
        call FeQuestCreate(idp,-1.,-1.,xqdp,il,1,'Select individual'//
     1                     ' centring vectors',0,LightGray,-1,0)
        if(nVTX.gt.8) then
          xpom=xqd-13.
          call FeQuestUpDownMake(idp,xpom,0,UpDownXd,UpDownYd,'up')
          nUp=UpDownLastMade
          call FeQuestUpDownMake(idp,xpom,nmax+1,UpDownXd,UpDownYd,
     1                           'down')
          nDown=UpDownLastMade
        endif
        xpom=xqdp*.5-50.
        call FeQuestButtonMake(idp,xpom,il+1,40.,ButYd,'%Refresh')
        nButtRefresh=ButtonLastMade
        call FeQuestButtonOpen(ButtonLastMade,ButtonOff)
        xpom=xpom+60.
        call FeQuestButtonMake(idp,xpom,il+1,40.,ButYd,'%Select all')
        call FeQuestButtonOpen(ButtonLastMade,ButtonOff)
        il=1
        t80=' Vector'
        xpom=5.
        t80(4*ndim+ 4:)='#reflections'
        t80(4*ndim+18:)='ave(I/sig(I))'
        call FeQuestLabelMake(idp,xpom,il,t80,'L')
        m=1
2600    n1=8*(m-1)+1
        n2=min(n1+7,nVTX)
        n=n1
        k=1
        xpom=5.
        dpom=xqdp-10.
        call FeQuestReset('SelwNumber')
        il=2
        do 2650i=1,nmax
          if(i.gt.nVTX) then
            call FeQuestSelwRemove(i)
          else
            Radka='('
            do 2610j=1,ndim
              call ToFract(vt6X(j,n),Cislo)
              Radka=Radka(:idel(Radka))//Cislo(:idel(Cislo))
              if(j.lt.ndim) then
                Cislo=','
              else
                Cislo=')'
              endif
              Radka=Radka(:idel(Radka))//Cislo(:idel(Cislo))
2610        continue
            k=4*ndim+2
            Radka(k:k)='|'
            if(n.ne.1) then
              l=NSelX(n)
              nobs=NCenObs(l)
              nall=NCenAll(l)
            else
              l=0
              nobs=0
              nall=0
            endif
            write(t80,100) nobs,nall
            call Zhusti(t80)
            Radka(k+8-index(t80,'/'):)=t80(:idel(t80))
            k=k+14
            Radka(k:k)='|'
            if(l.eq.0) then
              SumObs=0.
              SumAll=0.
            else
              SumObs=SCenObs(l)
              SumAll=SCenAll(l)
            endif
            write(t80,101) SumObs,SumAll
            call Zhusti(t80)
            Radka(k+9-index(t80,'/'):)=t80(:idel(t80))
            k=k+14
            Radka(k:k)='|'
            call FeQuestSelwMake(idp,xpom,il,Radka,dpom,SelwYd,0,0)
            if(i.eq.1) nSelwFirst=SelwLastMade
            call FeQuestSelwOpen(SelwLastMade,BratVT6X(i))
          endif
          n=n+1
          il=il+1
2650    continue
        if(nVTX.gt.8) then
          if(n2.lt.nVTX) then
            call FeQuestUpDownOff(nDown)
          else
            call FeQuestUpDownDisable(nDown)
          endif
          if(n1.gt.1) then
            call FeQuestUpDownOff(nUp)
          else
            call FeQuestUpDownDisable(nUp)
          endif
        endif
        icont=0
2700    call FeQuestEvent(idp,icont,ich)
        icont=1
        nSelw=nSelwFirst
        do 2710i=n1,n2
          BratVT6X(i)=SelwLogicQuest(nSelw)
          nSelw=nSelw+1
2710    continue
        if(CheckType.eq.EventButton) then
          lpom=CheckNumber.ne.nButtRefresh
          do 2720i=1,nVTX
            BratVT6X(i)=lpom
2720      continue
          call FeQuestButtonOff(CheckNumber)
          go to 2600
        else if(CheckType.eq.EventUpDown.and.(CheckNumber.eq.nDown.or.
     1                                        CheckNumber.eq.nUp)) then
          if(CheckNumber.eq.nDown) then
            m=m+1
          else
            m=m-1
          endif
          go to 2600
        else if(CheckType.ne.0) then
          call NebylOsetren
          go to 2700
        endif
        call FeQuestRemove(idp)
        call FeQuestButtonOff(nButtXCentr)
        go to 2450
      else if(CheckType.ne.0) then
        call NebylOsetren
        go to 2500
      endif
      if(ich.eq.0) then
        nCrw=nCrwFirst
        ic=0
        do 3000i=1,9
          if(i.ne.IdCentrRRev) ic=ic+1
          if(ic.eq.6.and.NCellSel.ne.IdTrigonal) go to 3000
          if(NCellSel.eq.IdTrigonal.and.ic.ne.IdCentrP.and.ic.ne.6)
     1      go to 3000
          if(i.eq.IdCentrX.and..not.XCentr) go to 3000
          if(CrwLogicQuest(nCrw)) then
            CentrSel=i
            go to 3100
          endif
          nCrw=nCrw+1
3000    continue
      endif
3100  call FeQuestRemove(id)
      if(CentrSel.eq.IdCentrX) then
        nVT=0
        do 3110i=1,nVTX
          if(BratVT6X(i)) then
            nVT=nVT+1
            call CopyVek(VT6X(1,i),VT6(1,nVT,1,KPhase),ndim)
          endif
3110    continue
        call EM50CompleteCentr(0,VT6,nVT,ich)
      endif
      return
100   format(i15,'/'i15)
101   format(f10.3,'/',f10.3)
      end
      subroutine DRSGTestSGroup(Change,ich)
      include 'params.cmn'
      include 'basic.cmn'
      include 'fepc.cmn'
      include 'datred.cmn'
      dimension TrPom(3,3),CellPom(6),NSumaObs(100),IPorSG(100)
      character*256 Radka
      character*80  SGText(100),t80,Grp,GrpList(100)
      character*40  itxt
      character*20  GrupaS
      character*8   GrupaR
      character*3   abc
      character*1   CentrChar
      integer CrSystemFromCell,CrwStateQuest
      logical SystExtRef,First,LastLetter1,EqIgCase,Change,Observed,
     1        FeYesNoHeader
      real MPom(36)
      data abc/'abc'/
      Monoclinic=0
      call UnitMat(TrPom,3)
      if(NCellSel.eq.IdTriclinic) then
        CrSystem=CrSystemTriclinic
        if(CentrSel.eq.IdCentrP) go to 2900
        if(CentrSel.eq.IdCentrA) then
          TrPom(2,2)=.5
          TrPom(3,2)=.5
        else if(CentrSel.eq.IdCentrB) then
          TrPom(1,1)=.5
          TrPom(3,1)=.5
        else if(CentrSel.eq.IdCentrC) then
          TrPom(1,1)=.5
          TrPom(2,1)=.5
        else if(CentrSel.eq.IdCentrI) then
          TrPom(1,1)=.5
          TrPom(2,1)=.5
          TrPom(3,1)=.5
        else if(CentrSel.eq.IdCentrF) then
          TrPom(1,1)=.5
          TrPom(2,1)=.5
          TrPom(2,2)=.5
          TrPom(3,2)=.5
        endif
        call TrParQ(TrPom,CellParSel,QuIrrSel,QuRacSel,CellTrSel6)
        call RedukceQ(CellParSel,QuIrrSel,QuRacSel,CellTrSel6)
      else if(NCellSel.eq.IdMonoclinicA.or.NCellSel.eq.IdMonoclinicB.or.
     1        NCellSel.eq.IdMonoclinicC) then
        MonoClinic=2
        CrSystem=CrSystemMonoclinic
        if(CentrSel.eq.IdCentrB) then
          call UnitMat(TrPom,3)
          TrPom(1,1)=0.5
          TrPom(3,1)=0.5
          call TrParQ(TrPom,CellParSel,QuIrrSel,QuRacSel,CellTrSel6)
          CentrSel=IdCentrP
          call RedukceQ(CellParSel,QuIrrSel,QuRacSel,CellTrSel6)
          i=iabs(CrSystemFromCell(CellParSel,DiffAxe,DiffAngle))/10
          if(i.eq.0.or.i.eq.3) then
            call SetPermutMat(TrPom,3,312,ich)
            call TrParQ(TrPom,CellParSel,QuIrrSel,QuRacSel,CellTrSel6)
          else if(i.eq.1) then
            call SetPermutMat(TrPom,3,231,ich)
            call TrParQ(TrPom,CellParSel,QuIrrSel,QuRacSel,CellTrSel6)
          endif
        else if(CentrSel.eq.IdCentrA) then
          call SetPermutMat(TrPom,3,321,ich)
          call TrParQ(TrPom,CellParSel,QuIrrSel,QuRacSel,CellTrSel6)
          CentrSel=IdCentrC
        else if(CentrSel.eq.IdCentrI) then
          TrPom(1,1)=1.
          TrPom(3,1)=1.
          call TrParQ(TrPom,CellParSel,QuIrrSel,QuRacSel,CellTrSel6)
          CentrSel=IdCentrC
        else if(CentrSel.eq.IdCentrF) then
          call UnitMat(TrPom,3)
          TrPom(1,1)=0.5
          TrPom(3,1)=0.5
          call TrParQ(TrPom,CellParSel,QuIrrSel,QuRacSel,CellTrSel6)
          CentrSel=IdCentrC
        endif
        go to 2800
      else if(NCellSel.eq.IdOrthorhombic) then
        CrSystem=CrSystemOrthorhombic
      else if(NCellSel.eq.IdTetragonalA.or.NCellSel.eq.IdTetragonalB.or.
     1        NCellSel.eq.IdTetragonalC) then
        if(CentrSel.eq.IdCentrI) then
          go to 2900
        else if(CentrSel.eq.IdCentrF) then
          call UnitMat(TrPom,3)
          TrPom(1,1)= .5
          TrPom(2,1)=-.5
          TrPom(1,2)= .5
          TrPom(2,2)= .5
          call TrParQ(TrPom,CellParSel,QuIrrSel,QuRacSel,CellTrSel6)
          CentrSel=IdCentrI
        else if(CentrSel.ne.IdCentrX) then
          CentrSel=IdCentrP
          CentrSel=IdCentrP
        endif
      else if(NCellSel.eq.IdTrigonal) then
        if(CentrSel.eq.IdCentrRObv) then
          go to 2900
        else if(CentrSel.eq.IdCentrRRev) then
          call UnitMat(TrPom,3)
          TrPom(1,1)=-1.
          TrPom(2,2)=-1.
          call TrParQ(TrPom,CellParSel,QuIrrSel,QuRacSel,CellTrSel6)
          CentrSel=IdCentrRObv
          Change=.true.
        else
          CentrSel=IdCentrP
        endif
      else if(NCellSel.eq.IdHexagonal) then
        CentrSel=IdCentrP
        CrSystem=CrSystemHexagonal
      else if(NCellSel.eq.IdCubic) then
        CrSystem=CrSystemCubic
        if(CentrSel.eq.IdCentrA.or.CentrSel.eq.IdCentrB.or.
     1     CentrSel.eq.IdCentrC) CentrSel=IdCentrP
      endif
      go to 2900
2800  call UnitMat(TrPom,3)
      AngleBest=9999.
      do 2820j=-3,3
        TrPom(3,1)=j
        if(CentrSel.eq.IdCentrC.and.mod(iabs(j),2).eq.1) go to 2820
        do 2810i=-3,3
          if(i*j.ne.0) go to 2810
          TrPom(1,3)=i
          call CopyVek(CellParSel,CellPom,6)
          call UnitMat(MPom,ndim)
          call TrPar(TrPom,CellPom,MPom)
          pom=abs(CellPom(5)-90.)
          if(pom.lt.AngleBest) then
            ibest=i
            jbest=j
            AngleBest=pom
          endif
2810    continue
2820  continue
      TrPom(3,1)=jbest
      TrPom(1,3)=ibest
      call TrParQ(TrPom,CellParSel,QuIrrSel,QuRacSel,CellTrSel6)
2900  if(NCellSel.eq.IdMonoclinicA.or.NCellSel.eq.IdMonoclinicB.or.
     1   NCellSel.eq.IdMonoclinicC) then
        if(CellParSel(5).lt.90.) then
          call UnitMat(TrPom,3)
          TrPom(2,2)=-1.
          TrPom(3,3)=-1.
          call TrParQ(TrPom,CellParSel,QuIrrSel,QuRacSel,CellTrSel6)
        endif
      endif
      ic=CentrSel
      if(ic.gt.IdCentrRRev) CentrSel=CentrSel-1
      CentrChar=smbc(CentrSel:CentrSel)
      call DRSGTestQPositive(TrPom)
      if(ndimi.gt.0) then
        call CopyVek(QuIrrSel,Qu(1,1,1,KPhase),ndimi*3)
        if(ndimi.eq.1) then
          call CrlGetSmbQ4dFromQ(QuIrrSel,QuRacSel,SmbQVSel,i)
          call AddVek(Qu(1,1,1,KPhase),QuRacSel,Qu(1,1,1,KPhase),3)
        endif
      endif
      if(LaueGroupSel.gt.1) then
        IPgFirst=LaueGroupPointer(LaueGroupSel-1)+1
      else
        IPgFirst=1
      endif
      IPgLast=LaueGroupPointer(LaueGroupSel)
      if(IPgFirst.eq.18) then
        LastLetter1=.true.
      else
        LastLetter1=.false.
      endif
      if(IPgFirst.gt.20) then
        IPgFirst=IPgFirst-3
        if(IPgFirst.gt.23) IPgFirst=IPgFirst-3
      endif
      if(IPgLast.gt.20) then
        IPgLast=IPgLast-3
        if(IPgLast.gt.23) IPgLast=IPgLast-3
      endif
      lni=NextLogicNumber()
      if(OpSystem.le.0) then
        t80=JanaDir(:idel(JanaDir))//'symmdat'//ObrLom//
     1      'spgroup.dat'
      else
        t80=JanaDir(:idel(JanaDir))//'source/data/spgroup.dat'
      endif
      call OpenFile(lni,t80,'formatted','old')
      lno=NextLogicNumber()
      call OpenFile(lno,fln(:ifln)//'_spgroups.tmp','formatted',
     1              'unknown')
      read(lni,FormA256) Radka
      if(Radka(1:1).ne.'#') rewind lni
      First=.true.
      m=0
      NSG=0
3000  read(lni,FormSG,end=3010) ig,ipg,idl,GrupaR,itxt,GrupaS
      if(ipg.lt.IPgFirst.or.ipg.gt.IPgLast) go to 3000
      if(ig.eq.39.or.ig.eq.41.or.ig.eq.64.or.ig.eq.67.or.ig.eq.68) then
        Cislo=GrupaR
        call mala(Cislo)
        if(index(Cislo,'e').le.0) go to 3000
      endif
      j=idel(GrupaR)
      if(ipg.ge.18.and.ipg.le.20.and.GrupaR(1:1).ne.'R') then
        j=idel(GrupaR)
        if((     LastLetter1.and.GrupaR(j:j).ne.'1').or.
     1     (.not.LastLetter1.and.GrupaR(j:j).eq.'1')) go to 3000
      endif
      if(First) then
        n=0
        First=.false.
      endif
      n=n+1
      if(ipg.ge.3.and.ipg.le.5.and.mod(n,3).ne.2) go to 3000
      if(EqIgCase(CentrChar,GrupaR(1:1)).or.
     1   (CentrChar.eq.'X'.and.EqIgCase(GrupaR(1:1),'P'))) then
        GrupaR(1:1)=CentrChar
        m=m+1
        write(lno,FormSG) ig,ipg,idl,GrupaR,itxt,GrupaS
      endif
      go to 3000
3010  close(lni)
      call SetRealArrayTo(ShSg(1,1),ndim,0.)
      call SetIgnoreWTo(.true.)
      call SetIgnoreETo(.true.)
      SumaObsLim=SumaObsLimExtinct
      SumaObsMin=99999.
      m=min(m+2,30)
3100  rewind lno
      Radka='Space group  obs/all       ave(I/sig(I))'
      call FeLstMake(-1.,-1.,idel(Radka),m,Radka)
      mg=1
3200  read(lno,FormSG,end=3400) ig,ipg,idl,Grupa,itxt,GrupaS
      if(ndimi.eq.1) then
        Grupa=Grupa(:idel(Grupa))//SmbQVSel(:idel(SmbQVSel))
        call DRGenSymFor4D(ipg,ich)
        if(ich.ne.0) go to 3200
      else
        call EM50GenSym(RunForFirstTimeNo,MakeCellTestNo,AskForDeltaNo,
     1                  ich)
      endif
      if(CentrChar.eq.'X') then
        call FindSmbSgOrgShiftNo(Grp,ChangeOrderNo,1)
        idl=index(Grp,'(')
        if(idl.le.0) then
          idl=idel(Grp)
        else
          idl=idl-1
        endif
        do 3220i=1,nGrpList
          if(EqIgCase(GrpList(i),Grp(:idl))) go to 3200
3220    continue
        if(nGrpList.lt.100) then
          nGrpList=nGrpList+1
          GrpList(nGrpList)=Grp(:idl)
        endif
        Grupa=Grp
      endif
      GrupaR=Grupa
      if(ndimi.eq.1) then
        i=index(GrupaR,'(')
        if(i.gt.0) GrupaR(i:)=' '
      endif
3205  mg=mg+1
      if(mg.eq.m) then
        call FeLstWriteLine('to continue press any key',-1)
3210    call FeEvent(0)
        if(EventType.eq.EventKey.or.EventType.eq.EventASCII.or.
     1     (EventType.eq.EventMouse.and.
     2      (EventNumber.eq.JeLeftDown.or.EventNumber.eq.JeRightDown)))
     3    then
          mg=1
          call FeLstBackSpace
        else
          go to 3210
        endif
      endif
      if(ich.eq.0) then
        NAll=0
        NObs=0
        SumaAll=0.
        SumaObs=0.
        do 3300i=1,NRefRead
          call indtr(ihar(1,i),CellTrSel6,ih,ndim)
          do 3250j=4,ndim
            if(ih(j).ne.0) go to 3300
3250      continue
          RelI=max(riar(i)/rsar(i),0.)
          Observed=RelI.gt.3.
          if(SystExtRef(ih,1)) then
            NAll=NAll+1
            SumaAll=SumaAll+RelI
            if(Observed) then
              NObs=NObs+1
              SumaObs=SumaObs+RelI
            endif
          endif
3300    continue
        if(NAll.gt.0) then
          SumaAll=SumaAll/float(NAll)
        else
          SumaAll=0.
        endif
        if(NObs.gt.0) then
          SumaObs=SumaObs/float(NObs)
        else
          SumaObs=0.
        endif
        Radka=GrupaR
        write(t80,100) NObs,NAll
        call Zhusti(t80)
        j=index(t80,'/')
        Radka(18-j:)=t80(:idel(t80))
        write(t80,101) SumaObs,SumaAll
        call Zhusti(t80)
        j=index(t80,'/')
        Radka(34-j:)=t80(:idel(t80))
        SumaObsMin=min(SumaObsMin,SumaObs)
        if(SumaObs.lt.SumaObsLim) then
          if(NSG.lt.100) then
            NSG=NSG+1
            i=NSG
          else
            i=IPorSG(100)
          endif
          SGText(i)=Radka
          NSumaObs(i)=nint(SumaObs*1000.)
          if(NSG.ge.100) call indexx(100,NSumaObs,IPorSG)
          Radka=Radka(:idel(Radka))//'<'
        endif
      else
        Radka=GrupaR
        if(ich.eq.-1) then
          i=index(Grp,'(')-1
          if(i.lt.0) i=idel(Grp)
          Radka(15:)='equivalent to '//Grp(:i)
        else
          Radka(15:)='not applicable'
        endif
      endif
      call FeLstWriteLine(Radka,-1)
      go to 3200
3400  call FeLstWriteLine('to continue press any key',m)
      call ResetIgnoreW
      call ResetIgnoreE
3410  call FeEvent(0)
      if(EventType.eq.EventKey.or.EventType.eq.EventASCII.or.
     1   (EventType.eq.EventMouse.and.
     2    (EventNumber.eq.JeLeftDown.or.EventNumber.eq.JeRightDown)))
     3  then
        mg=2
      else
        go to 3410
      endif
      call FeLstRemove
      if(NSG.le.0) then
        if(SumaObsMin.lt.90000.) then
          NInfo=1
          TextInfo(1)='No space group achieved better figure of merit.'
          if(FeYesNoHeader(-1.,-1.,'Do you want to use a higher limit?',
     1                     0)) then
            SumaObsLim=max(anint(SumaObsMin*1.05),1.)
            go to 3100
          else
            ich=1
            go to 9999
          endif
        else
          call FeUnforeseenError
          ich=1
          go to 9999
        endif
      endif
      if(NSG.lt.100) call indexx(NSG,NSumaObs,IPorSG)
      ilm=min(12,NSG)
      xqd=150.
      id=NextQuestId()
      call FeQuestCreate(id,-1.,-1.,xqd,0,ilm+1,'Select space group',0,
     1                   LightGray,0,0)
      xpom=5.
      tpom=xpom+5.+CrwgXd
      il=1
      Radka='Space group  obs/all       ave(I/sig(I))'
      call FeQuestLabelMake(id,tpom,il,Radka,'L')
      i=1
3420  if(i.ge.NSG) go to 3445
      n=0
      ip=i
      NSuma=NSumaObs(IPorSG(i))
3430  i=i+1
      n=n+1
      j=IPorSG(i)
3435  if(NSumaObs(j).eq.NSuma) then
        if(i.lt.NSG) go to 3430
      endif
      if(n.gt.1) then
        call IntVectorToOpposite(IPorSG(ip),IPorSG(ip),n)
        call IHeap(n,IPorSG(ip))
        call IntVectorToOpposite(IPorSG(ip),IPorSG(ip),n)
      endif
      go to 3420
3445  do 3450i=1,ilm
        il=il+1
        j=IPorSG(i)
        call FeQuestCrwMake(id,tpom,il,xpom,il,SGText(j),'L',
     1                      CrwgXd,CrwgYd,0,1)
        if(i.eq.1) nCrwFirst=CrwLastMade
        call FeQuestCrwOpen(CrwLastMade,i.eq.1)
3450  continue
      ioff=1
      if(NSG.gt.ilm) then
        xpom=xqd-UpDownXd-3.
        call FeQuestUpDownMake(id,xpom,il,UpDownXd,UpDownYd,'down')
        nDown=UpDownLastMade
        call FeQuestUpDownOpen(UpDownLastMade,UpDownOff)
        call FeQuestUpDownMake(id,xpom, 2,UpDownXd,UpDownYd,'up')
        call FeQuestUpDownOpen(UpDownLastMade,UpDownOff)
        nUp=UpDownLastMade
      else
        nDown=0
        nUp=0
      endif
3500  icont=0
      if(nUp.gt.0) then
        if(ioff.gt.1) then
          call FeQuestUpDownOff(nUp)
        else
          call FeQuestUpDownDisable(nUp)
        endif
        if(ioff+12.le.NSG) then
          call FeQuestUpDownOff(nDown)
        else
          call FeQuestUpDownDisable(nDown)
        endif
      endif
      call FeQuestEvent(id,icont,ich)
      icont=1
      if(CheckType.eq.EventUpDown) then
        if(CheckNumber.eq.nUp) then
          if(ioff.gt.1) then
            ioff=ioff-12
          else
            go to 3520
          endif
        else
          if(ioff+12.le.NSG) then
            ioff=ioff+12
          else
            go to 3520
          endif
        endif
        nCrw=nCrwFirst
        j=ioff
        do 3510i=1,12
          if(j.le.NSG) then
            k=IPorSG(j)
            call FeQuestCrwOpen(nCrw,i.eq.1)
            call FeQuestCrwLabelChange(id,nCrw,SGText(k))
          else
            call FeQuestCrwClose(nCrw)
          endif
          j=j+1
          nCrw=nCrw+1
3510    continue
3520    call FeQuestUpDownOff(CheckNumber)
        go to 3500
      else if(CheckType.ne.0) then
        call NebylOsetren
        go to 3500
      endif
      if(ich.eq.0) then
        nCrw=nCrwFirst
        do 3550i=1,12
          if(CrwStateQuest(nCrw).eq.CrwOn) then
            j=IPorSG(i-1+ioff)
            go to 3560
          endif
          nCrw=NCrw+1
3550    continue
3560    k=0
        call kus(SGText(j),k,GrupaSel)
        rewind lno
3570    read(lno,FormSG,end=3700) ig,ipg,idl,GrupaR,itxt,GrupaS
        if(.not.EqIgCase(GrupaR,GrupaSel)) go to 3570
        idl=index(GrupaS,'#')
        if(idl.le.0) go to 3700
        call SetRealArrayTo(TrPom,9,0.)
        i=0
        j=idl
        im=idel(GrupaS)
3580    izn=1
        i=i+1
        if(i.gt.3) then
          if(j.eq.im) then
            rewind lno
            go to 3590
          else
            go to 3700
          endif
        endif
3585    j=j+1
        if(j.gt.im) go to 3700
        k=index(abc,GrupaS(j:j))
        if(k.ge.1) then
          TrPom(i,k)=izn
          go to 3580
        else if(GrupaS(j:j).eq.'-') then
          izn=-1.
        else if(GrupaS(j:j).ne.',') then
          go to 3700
        endif
        go to 3585
3590    lni=NextLogicNumber()
        if(OpSystem.le.0) then
          t80=JanaDir(:idel(JanaDir))//'symmdat'//ObrLom//
     1        'spgroup.dat'
        else
          t80=JanaDir(:idel(JanaDir))//'source/data/spgroup.dat'
        endif
        call OpenFile(lni,t80,'formatted','old')
        read(lni,FormA256) Radka
        if(Radka(1:1).ne.'#') rewind lni
        if(GrupaSel(1:1).eq.'X') GrupaSel(1:1)='P'
3600    read(lni,FormSG) igp,ipg,idl,GrupaR,itxt,GrupaS
        if(ig.eq.39.or.ig.eq.41.or.ig.eq.64.or.ig.eq.67.or.ig.eq.68)
     1    then
          Cislo=GrupaR
          call mala(Cislo)
          if(index(Cislo,'e').le.0) go to 3600
        endif
        if(igp.ne.ig) go to 3600
        close(lni)
        if(.not.EqIgCase(GrupaR,GrupaSel)) then
          call TrParQ(TrPom,CellParSel,QuIrrSel,QuRacSel,CellTrSel6)
          GrupaSel=GrupaR
          call DRSGTestQPositive(TrPom)
        endif
        if(CentrChar.eq.'X') GrupaSel(1:1)='X'
      else
        go to 9000
      endif
3700  call CopyVek(QuIrrSel,Qu(1,1,1,KPhase),ndimi*3)
      if(ndimi.eq.1) then
        call CrlGetSmbQ4dFromQ(QuIrrSel,QuRacSel,SmbQVSel,i)
        call AddVek(Qu(1,1,1,KPhase),QuRacSel,Qu(1,1,1,KPhase),3)
        GrupaSel=GrupaSel(:idel(GrupaSel))//SmbQVSel(:idel(SmbQVSel))
      endif
      iGSel=ig
      iPGSel=ipg
      CrSystemSel=CrSystem
      if(Monoclinic.ne.0) CrSystemSel=Monoclinic*10+mod(CrSystemSel,10)
9000  call FeQuestRemove(id)
      close (lno,status='delete')
9999  return
100   format(i15,'/'i15)
101   format(f10.3,'/',f10.3)
      end
      subroutine DRSGTestSSG4(ich)
      include 'params.cmn'
      include 'basic.cmn'
      include 'fepc.cmn'
      include 'datred.cmn'
      dimension NCenObs(20),NCenAll(20),SCen(20),h(6),nx(4),ni(4)
      character*80 t80,SSG4Text(20)
      character*60 Grp
      character*4  GrX4
      logical EqIgCase,SystExtRef,Observed,CrwLogicQuest
      idl=index(GrupaSel,')')
      if( iPGSel.le.4.or.
     1   (iPGSel.ge. 9.and.iPgSel.le.10).or.
     2   (iPGSel.ge.16.and.iPgSel.le.17).or.
     3   (iPGSel.ge.21.and.iPgSel.le.22)) then
        nn=1
      else if( iPGSel.eq. 5.or.
     1         iPGSel.eq.11.or.
     2         iPGSel.eq.23.or.Grupa(1:1).eq.'R') then
        nn=2
      else if((iPGSel.ge. 6.and.iPgSel.le. 8).or.
     1        (iPGSel.ge.12.and.iPgSel.le.14).or.
     2        (iPGSel.ge.18.and.iPgSel.le.20).or.
     3        (iPGSel.ge.24.and.iPgSel.le.26)) then
        nn=3
      else
        nn=4
      endif
      if(iPGSel.le.15) then
        m=3
      else
        m=5
      endif
      call SetIntArrayTo(nx,nn,m)
      n=m**nn
      call SetIgnoreWTo(.true.)
      call SetIgnoreETo(.true.)
      ntx=1
      ntxopt=0
      do 2000i=1,n
        call RecUnPack(i,ni,nx,nn)
        GrX4=' '
        do 1100j=1,nn
          k=ni(j)
          GrX4(j:j)=SmbSymmT(k)
1100    continue
        Grupa=GrupaSel(:idl)//GrX4(:nn)
        call EM50GenSym(RunForFirstTimeNo,MakeCellTestNo,AskForDeltaNo,
     1                  ich)
        if(ich.ne.0) go to 2000
        call FindSmbSgOrgShiftNo(Grp,.false.,1)
        if(.not.EqIgCase(Grp,Grupa)) go to 2000
        NObs=0
        NAll=0
        SumaAll=0.
        SumaObs=0.
        do 1500j=1,NRefRead
          call indtr(ihar(1,j),CellTrSel6,ih,ndim)
          do 1420k=4,ndim
            if(ih(k).ne.0) go to 1440
1420      continue
          go to 1500
1440      RelI=max(riar(j)/rsar(j),0.)
          Observed=RelI.gt.3.
          if(SystExtRef(ih,1)) then
            NAll=NAll+1
            SumaAll=SumaAll+RelI
            if(Observed) then
              NObs=NObs+1
              SumaObs=SumaObs+RelI
            endif
          endif
1500    continue
        if(NAll.gt.0) then
          SumaAll=SumaAll/float(NAll)
        else
          SumaAll=0.
        endif
        if(NObs.gt.0) then
          SumaObs=SumaObs/float(NObs)
        else
          SumaObs=0.
        endif
        ntx=ntx+1
        SSG4Text(ntx)=Grupa
        write(t80,100) nobs,nall
        call Zhusti(t80)
        j=index(t80,'/')
        SSG4Text(ntx)(25-j:)=t80(:idel(t80))
        write(t80,101) SumaObs,SumaAll
        call Zhusti(t80)
        j=index(t80,'/')
        SSG4Text(ntx)(38-j:)=t80(:idel(t80))
        if(SumaObs.lt.SumaObsLimExtinct) ntxopt=ntx
2000  continue
      if(ntxopt.le.0) ntxopt=ntx
      call ResetIgnoreW
      call ResetIgnoreE
      if(ntx.le.0) then
        call FeUnforeseenError
        ich=1
        go to 9999
      endif
      id=NextQuestId()
      xqd=160.
      call FeQuestCreate(id,-1.,-1.,xqd,0,ntx,'Select superspace group',
     1                   0,LightGray,0,0)
      il=1
      SSG4Text(1)='Superspace group    obs/all    ave(I/sig(I))'
      xpom=5.
      tpom=xpom+5.+CrwgXd
      call FeQuestLabelMake(id,tpom,il,SSG4Text(1),'L')
      do 3000i=2,ntx
        il=il+1
        call FeQuestCrwMake(id,tpom,il,xpom,il,SSG4Text(i),'L',
     1                      CrwgXd,CrwgYd,0,1)
        call FeQuestCrwOpen(CrwLastMade,i.eq.ntxopt)
        if(i.eq.2) nCrwFirst=CrwLastMade
3000  continue
3500  icont=0
      call FeQuestEvent(id,icont,ich)
      icont=1
      if(CheckType.ne.0) then
        call NebylOsetren
        go to 3500
      endif
      if(ich.eq.0) then
        nCrw=nCrwFirst
        do 3550i=2,ntx
          if(CrwLogicQuest(nCrw)) then
            go to 3560
          endif
          nCrw=NCrw+1
3550    continue
        ich=1
        go to 3600
3560    k=0
        call kus(SSG4Text(i),k,GrupaSel)
      endif
3600  call FeQuestRemove(id)
9999  return
100   format(i15,'/'i15)
101   format(f10.3,'/',f10.3)
      end
      subroutine DRGenSymFor4D(ipg,ich)
      include 'params.cmn'
      include 'basic.cmn'
      include 'datred.cmn'
      dimension nx(4),ni(4)
      character*4  GrX4
      idl=index(Grupa,')')
      if( ipg.le.4.or.
     1   (ipg.ge. 9.and.ipg.le.10).or.
     2   (ipg.ge.16.and.ipg.le.17).or.
     3   (ipg.ge.21.and.ipg.le.22)) then
        nn=1
      else if( ipg.eq. 5.or.
     1         ipg.eq.11.or.
     2         ipg.eq.23.or.Grupa(1:1).eq.'R') then
        nn=2
      else if((ipg.ge. 6.and.ipg.le. 8).or.
     1        (ipg.ge.12.and.ipg.le.14).or.
     2        (ipg.ge.18.and.ipg.le.20).or.
     3        (ipg.ge.24.and.ipg.le.26)) then
        nn=3
      else
        nn=4
      endif
      if(ipg.le.15) then
        m=3
      else
        m=5
      endif
      call SetIntArrayTo(nx,nn,m)
      n=m**nn
      do 2000i=1,n
        call RecUnPack(i,ni,nx,nn)
        GrX4=' '
        do 1100j=1,nn
          k=ni(j)
          GrX4(j:j)=SmbSymmT(k)
1100    continue
        Grupa=Grupa(:idl)//GrX4(:nn)
        call EM50GenSym(RunForFirstTimeNo,MakeCellTestNo,AskForDeltaNo,
     1                  ich)
        if(ich.eq.0) go to 9999
2000  continue
9999  return
      end
      subroutine DRSGTestQPositive(TrPom)
      include 'params.cmn'
      include 'basic.cmn'
      include 'fepc.cmn'
      include 'datred.cmn'
      dimension TrPom6(36),TrPom6I(36),TrPom(3,3)
      call UnitMat(TrPom6,ndim)
      if(ndimi.eq.1) then
        do 1010i=1,3
          if(QuIrrSel(i,1).lt.-.00001) then
            TrPom6(16)=-1.
            call RealVectorToOpposite(QuIrrSel(1,1),
     1                                QuIrrSel(1,1),3)
            call RealVectorToOpposite(QuRacSel,QuRacSel,3)
            go to 1015
          else if(QuIrrSel(i,1).gt..00001) then
            go to 1015
          endif
1010    continue
1015    do 1020i=1,3
          if(QuRacSel(i).lt.-.00001) then
            QuRacSel(i)=1.+QuRacSel(i)
            TrPom6(4*i)=1.
          endif
1020    continue
        call Multm(CellTrSel6,TrPom6,TrPom6I,ndim,ndim,ndim)
        call CopyMat(TrPom6I,CellTrSel6,ndim)
      endif
      do 1040l=1,3
        do 1030k=1,3
          m=k+(l-1)*ndim
          TrPom6(m)=TrPom(k,l)
1030    continue
1040  continue
      call MatInv(TrPom6,TrPom6I,pom,ndim)
      do 1050i=1,nVT
        call CopyVek(vt6(1,i,1,KPhase),TrPom6,ndim)
        call Multm(TrPom6I,TrPom6,vt6(1,i,1,KPhase),ndim,ndim,1)
        call od0do1(vt6(1,i,1,KPhase),vt6(1,i,1,KPhase),ndim)
1050  continue
      return
      end
      subroutine DRChngModVec
      include 'params.cmn'
      include 'basic.cmn'
      include 'atoms.cmn'
      include 'molec.cmn'
      include 'editm40.cmn'
      include 'datred.cmn'
      include 'fepc.cmn'
      include 'powder.cmn'
      dimension ish(3,3),QuPom(3,3),QuPomT(3,3),rsh(3,3),xp(6),
     1          trmi(36),ihh(6),trp(36),xpp(6),hp(6),hpp(6),rsg(9),
     2          rsgi(9)
      real      MatPom(36)
      character*80 Radka,t80
      logical FeYesNoHeader,EqRV
      equivalence (ish,rsh)
      if(ExistM94) then
        call iom94(0)
        call CopyVek(QuDatRed(1,1,2),QuPom,3*ndimi)
      endif
      if(ExistM50) then
        call iom50(0,0)
        call CopyVek(Qu(1,1,1,KPhase),QuPom,3*ndimi)
      endif
      id=NextQuestId()
      dpom1=30.
      dpom2=30.
      xqd=13.+FeTxLength('XXXXXXX')+dpom1+
     1    ndimi*(9.+dpom2+FeTxLength('XXXXXXX'))
      call FeQuestCreate(id,-1.,-1.,xqd,0,2*ndimi+1,
     1                   'Old modulation vector(s)',0,LightGray,0,0)
      do 1020i=1,ndimi
        write(Radka,100) i,(QuPom(j,i),j=1,3)
        call FeQuestLabelMake(id,5.,i,Radka,'L')
1020  continue
      call FeQuestLabelMake(id,xqd*.5,ndimi+1,
     1                      'Change modulation vector(s)','C')
      il=ndimi+1
      call SetIntArrayTo(ish,9,0)
      call UnitMat(rsg,ndimi)
      k=0
      do 1100i=1,ndimi
        il=il+1
        write(Radka,'(''q''''('',i1,'') ='')') i
        tpom=5.
        xpom=tpom+FeTxLengthUnder(Radka)+3.
        call FeQuestEdwMake(id,tpom,il,xpom,il,Radka,'L',dpom1,EdwYd,0)
        call FeQuestIntAEdwOpen(EdwLastMade,ish(1,i),3,.false.)
        if(i.eq.1) nEdwFirst=EdwLastMade
        Radka='+'
        tpom=xpom+dpom1+3.
        do 1050j=1,ndimi
          k=k+1
          xpom=tpom+FeTxLengthUnder(Radka)+3.
          call FeQuestEdwMake(id,tpom,il,xpom,il,Radka,'L',dpom2,EdwYd,
     1                        0)
          call FeQuestRealEdwOpen(EdwLastMade,rsg(k),.false.,.false.)
          tpom=xpom+dpom2+3.
          write(t80,'(''* q('',i1,'')'')') j
          call FeQuestLabelMake(id,tpom,il,t80,'L')
          tpom=tpom+FeTxLengthUnder(t80)+3.
1050    continue
1100  continue
      icont=0
1500  call FeQuestEvent(id,icont,ich)
      icont=1
      if(ich.eq.0) then
        nEdw=nEdwFirst-1
        k=0
        do 2120i=1,ndimi
          nEdw=nEdw+1
          call FeQuestIntAFromEdw(nEdw,ish(1,i))
          do 2100j=1,3
            rsh(j,i)=ish(j,i)
2100      continue
          do 2110j=1,ndimi
            k=k+1
            nEdw=nEdw+1
            call FeQuestRealFromEdw(nEdw,rsg(k))
2110      continue
2120    continue
        call matinv(rsg,rsgi,pom,ndimi)
      endif
      call FeQuestRemove(id)
      if(ich.ne.0) go to 9999
      l=0
      call SetRealArrayTo(QuPomT,ndimi*3,0.)
      do 3100i=1,ndimi
        do 3050j=1,ndimi
          l=l+1
          pom=rsg(l)
          do 3000k=1,3
            QuPomT(k,i)=QuPomT(k,i)+pom*QuPom(k,j)
3000      continue
3050    continue
3100  continue
      call AddVek(QuPomT,rsh,QuPom,3*ndimi)
      Ninfo=ndimi
      do 3200i=1,Ninfo
        write(TextInfo(i),100) i,(QuPom(j,i),j=1,3)
3200  continue
      if(.not.FeYesNoHeader(-1.,-1.,'Do you want really to realize '//
     1                              'the change?',0)) go to 9999
      ntrans=1
      call SetRealArrayTo(trv,ndim,0.)
      call UnitMat(trm,ndim)
      do 3220i=1,ndimi
        do 3210j=1,3
          trm(i+3+(j-1)*ndim,1,1)=rsh(j,i)
3210    continue
3220  continue
      l=0
      do 3240j=4,ndim
        k=(j-1)*ndim+3
        do 3230i=4,ndim
          k=k+1
          l=l+1
          trm(k,1,1)=rsg(l)
3230    continue
3240  continue
      call MatInv(trm,trmi,pom,ndim)
      VolRatio=1./pom
      if(ExistM50) then
        call CopyVek(QuPom,Qu(1,1,1,KPhase),3*ndimi)
        if(ExistM94) then
          call SetRealArrayTo(QuPomT,ndimi*3,0.)
          l=0
          do 3360i=1,ndimi
            do 3340j=1,ndimi
              l=l+1
              pom=rsg(l)
              do 3320k=1,3
                QuPomT(k,i)=QuPomT(k,i)+pom*QuDatRed(k,j,2)
3320          continue
3340        continue
3360      continue
          call AddVek(QuPomT,rsh,QuDatRed(1,1,2),3*ndimi)
          call CopyVek(QuDatRed(1,1,2),QuDatRed(1,1,3),3*ndimi)
        endif
        if(ExistM41) then
          call SetRealArrayTo(QuPomT,ndimi*3,0.)
          l=0
          do 3460i=1,ndimi
            do 3440j=1,ndimi
              l=l+1
              pom=rsg(l)
              do 3420k=1,3
                QuPomT(k,i)=QuPomT(k,i)+pom*QuPwd(k,j,KPhase)
3420          continue
3440        continue
3460      continue
          call AddVek(QuPomT,rsh,QuPwd(1,1,KPhase),3*ndimi)
        endif
        nvtt=0
        do 3500i=1,nvt
          call multm(trm,vt6(1,i,1,KPhase),xp,ndim,ndim,1)
          call od0do1(xp,xpp,ndim)
          do 3450j=1,nvtt
            if(eqrv(xpp,vt6(1,j,1,KPhase),ndim,.001)) go to 3500
3450      continue
          nvtt=nvtt+1
          call CopyVek(xpp,vt6(1,nvtt,1,KPhase),ndim)
3500    continue
        i=nint(VolRatio)-1
        i1p=-i
        i1k= i
        if(ndim.gt.4) then
          i2p=-i
          i2k= i
          if(ndim.gt.5) then
            i3p=-i
            i3k= i
          else
            i3p=0
            i3k=0
          endif
          i2p=0
          i2k=0
        endif
        call SetRealArrayTo(xp,3,0.)
        do 3530i3=-i3p,i3k
          xp(6)=i3
          do 3520i2=-i2p,i2k
          xp(5)=i2
            do 3510i1=-i1p,i1k
              xp(4)=i1
              call multm(trm,xp,xpp,ndim,ndim,1)
              call od0do1(xpp,xpp,ndim)
              do 3505j=1,nvtt
                if(eqrv(xpp,vt6(1,j,1,KPhase),ndim,.001)) go to 3510
3505          continue
              nvtt=nvtt+1
              call CopyVek(xpp,vt6(1,nvtt,1,KPhase),ndim)
3510        continue
3520      continue
3530    continue
        call EM50CompleteCentr(0,vt6,nvtt,ich)
        nvt=nvtt
        do 3600i=1,ns
          call TrSymmOp(trm,rm6(1,i,1,KPhase),trmi,s6(1,i,1,KPhase),
     1                  ndim)
          call CodeSym(rm6(1,i,1,KPhase),s6(1,i,1,KPhase),
     1                 symmc(1,i,1,KPhase),0)
3600    continue
        do 3650i=1,ndimi
          do 3640j=1,3
            if(abs(qu(j,i,1,KPhase)).lt..0001.and.
     1         abs(quir(j,i,KPhase)).gt..0001) quir(j,i,KPhase)=0.
3640      continue
3650    continue
        call FindSmbSg(Grupa,ChangeOrderNo,1)
        if(KCommen.gt.0) then
          call SetRealArrayTo(xp,3,0.)
          call CopyVek(trez(1,1,KPhase),xp(4),ndimi)
          call Multm(trm,xp,xpp,ndim,ndim,1)
          call AddVek(xpp(4),trv(4,1,1),trez(1,1,KPhase),ndimi)
        endif
        do 3670i=2,ncomp
          call Multm(trm,zv(1,i,KPhase),MatPom, ndim,ndim,ndim)
          call Multm(MatPom,trmi,zv(1,i,KPhase),ndim,ndim,ndim)
3670    continue
        call iom50(1,0)
        if(ExistM40) then
c          call EM40SetTr(.true.)
          call EM40SetTr(.false.)
          call EM40TransAll(ich)
c          call EM40Tr(0,2,ich)
          call iom40(1,0)
        endif
        NInfo=0
        if(ExistM91) then
          lni=NextLogicNumber()
          call OpenFile(lni,fln(:ifln)//'.m91','formatted','old')
          if(ErrJana.ne.0) go to 9999
          lno=NextLogicNumber()
          call OpenFile(lno,fln(:ifln)//'.l91','formatted','unknown')
3700      read(lni,format91,err=9000,end=3800)(ih(i),i=1,ndim),ri,
     1      rs,iq,nxx,itwr,efpip
          if(ih(1).gt.900) go to 3800
          do 3720i=1,ndim
            hp(i)=ih(i)
3720      continue
          call MultM(hp,trmi,hpp,1,ndim,ndim)
          do 3740i=1,ndim
            ihh(i)=nint(hpp(i))
            if(abs(float(ihh(i))-hpp(i)).gt..1) then
              if(NInfo.lt.14) then
                NInfo=NInfo+1
                write(TextInfo(NInfo),format91)(ih(j),j=1,ndim),ri,rs
              else if(NInfo.eq.14) then
                NInfo=NInfo+1
                TextInfo(NInfo)=' ....  and more .... '
              endif
              go to 3700
            endif
3740      continue
          write(lno,format91)(ihh(i),i=1,ndim),ri,rs,iq,nxx,itwr,
     1      efpip
          go to 3700
3800      write(lno,'('' 999'')')
          call CloseIfOpened(lni)
          call CloseIfOpened(lno)
          call MoveFile(fln(:ifln)//'.l91',fln(:ifln)//'.m91',.false.)
        endif
        if(NInfo.gt.0)
     1    call FeInfoOut(-1.,-1.,'Some reflections couldn''t be '//
     2                           'transformed')
      else
        call CopyVek(QuPom,QuDatRed(1,1,2),3*ndimi)
        call CopyVek(QuDatRed(1,1,2),QuDatRed(1,1,3),3*ndimi)
      endif
      if(ExistM94) then
        call Multm(trmp,trmi,trp,ndim,ndim,ndim)
        call CopyMat(trp,trmp,ndim)
        call iom94(1)
      endif
      go to 9999
9000  call FeReadError(lni)
      call CloseIfOpened(lno)
9999  return
100   format('q(',i1,') : ',3f8.4)
      end
      subroutine CAD4
      include 'params.cmn'
      include 'basic.cmn'
      include 'fepc.cmn'
      include 'datred.cmn'
      dimension h(3)
      character*256 EdwStringQuest
      character*80 t80
      character*4  Vystraha
      integer hmin(3),hmax(3),hminp(3),hmaxp(3)
      logical ExistFile,Kolize
      real kappa
      data thmax,chimin/2*30./
      if(ifln.gt.0) then
        t80=fln(:ifln)//'.dat'
      else
        t80=' '
      endif
      id=NextQuestId()
      call FeQuestCreate(id,-1.,-1.,90.,0,1,'Type the file name',1,
     1                   LightGray,0,0)
      call FeQuestEdwMake(id,5.,1,5.,1,' ','L',80.,EdwYd,0)
      call FeQuestStringEdwOpen(1,t80)
      icont=0
1000  call FeQuestEvent(id,icont,ich)
      icont=1
      if(CheckType.eq.EventButton.and.CheckNumber.eq.2) then
        if(.not.ExistFile(EdwString(EdwFr))) then
          call FeChybne(-1.,-1.,'the file doesn''t exist',' ',0,
     1                  SeriousError)
          icont=0
          call FeQuestButtonOff(CheckNumber)
          go to 1000
        endif
        QuestCheck(id)=0
        go to 1000
      else if(CheckType.ne.0) then
        call NebylOsetren
        go to 1000
      endif
      if(ich.eq.0) t80=EdwString(EdwFr)
      call FeQuestRemove(id)
      if(ich.ne.0) go to 9000
      call OpenFile(71,t80,'formatted','old')
      if(ErrJana.ne.0) go to 9000
      ifln=index(t80,'.')-1
      if(ifln.lt.0) ifln=idel(t80)
      fln=t80(:ifln)
1010  read(71,FormA80) t80
1020  if(idel(t80).lt.4) go to 1010
      if(ichar(t80(1:1)).lt.32) then
        t80=t80(2:)
        go to 1020
      endif
      if(t80(1:4).eq.'    ') go to 1020
      jentri=t80(4:4).eq.' '
      rewind 71
      call CtiCad
      tnalfa=snalfa/csalfa
      call CloseIfOpened(71)
      if(ErrJana.ne.0) go to 9000
      xpom=0.
      ypom=100000.
      do 1030i=1,3
        if(CellDatRed(i,1).gt.xpom) then
          ix=i
          xpom=CellDatRed(i,1)
        endif
        if(CellDatRed(i,1).lt.ypom) then
          iz=i
          ypom=CellDatRed(i,1)
        endif
1030  continue
      id=NextQuestId()
      call FeQuestCreate(id,-1.,-1.,200.,0,8,'Definition of generation',
     1                   0,LightGray,0,0)
      xpom=120.
      do 1040i=1,3
        call FeQuestCrwMake(id,xpom,1,xpom-4.,2,indices(i),'C',CrwgXd,
     1                      CrwgYd,1,1)
        call FeQuestCrwOpen(i,i.eq.iz)
        xpom=xpom+14.
1040  continue
      xpom=120.
      do 1050i=1,3
        call FeQuestCrwMake(id,xpom,1,xpom-4.,3,' ','C',CrwgXd,CrwgYd,1,
     1                      2)
        if(i.ne.iz) call FeQuestCrwOpen(i+3,i.eq.ix)
        xpom=xpom+14.
1050  continue
      call FeQuestLabelMake(id,5.,2,'The slowest varying index','L')
      call FeQuestLabelMake(id,5.,3,'The fastest varying index','L')
      xpom=120.
      do 1060i=1,3
        t80='Generate negative %'//indices(i)
        call FeQuestCrwMake(id,5.,i+3,xpom-4.,i+3,t80,'L',CrwXd,CrwYd,0,
     1                      0)
        call FeQuestCrwOpen(i+6,.true.)
1060  continue
      call FeQuestEdwMake(id,5.,7,60.,7,'Maximal %theta','L',35.,EdwYd,
     1                    0)
      call FeQuestRealEdwOpen(1,thmax,.false.,.false.)
      call FeQuestEdwMake(id,105.,7,155.,7,'%Wave length','L',40.,EdwYd,
     1                    0)
      call FeQuestRealEdwOpen(2,LamAve(1),.false.,.false.)
      call FeQuestEdwMake(id,5.,8,60.,8,'Cell %centering','L',20.,EdwYd,
     1                    0)
      call FeQuestStringEdwOpen(3,Lattice)
      call FeQuestEdwMake(id,105.,8,155.,8,'Minimum ch%i','L',40.,EdwYd,
     1                    0)
      call FeQuestRealEdwOpen(4,chimin,.false.,.false.)
      icont=0
1500  call FeQuestEvent(id,icont,ich)
      icont=1
      if(CheckType.eq.EventCrw) then
        if(CheckNumber.le.3) then
          if(iz.ne.CheckNumber) then
            call FeQuestCrwClose(CheckNumber+3)
            CrwLogic(CheckNumber+CrwFr+2)=.false.
            call FeQuestCrwOpen(iz+3,ix.eq.CheckNumber)
            if(ix.eq.CheckNumber) ix=iz
            iz=CheckNumber
          endif
        else if(CheckNumber.le.6) then
          ix=CheckNumber-3
        endif
        icont=0
        go to 1500
      else if(CheckType.ne.0) then
        call NebylOsetren
        go to 1500
      endif
      if(ich.eq.0) then
        itr(1)=ix
        itr(3)=iz
        iy=6-ix-iz
        itr(2)=iy
        call FeQuestRealFromEdw(1,thmax)
        call FeQuestRealFromEdw(2,LamAve(1))
        Lattice=EdwStringQuest(3)
        call FeQuestRealFromEdw(4,chimin)
        call velka(Lattice)
        if(Lattice(1:1).eq.'X') then
          call EM50ReadCellCentr(ich)
          if(ich.ne.0) go to 9000
        else
          call ctilatt(0)
          if(ErrJana.ne.0) go to 9000
        endif
        dmax=2.*sin(thmax*torad)/LamAve(1)
        do 1530i=1,3
          hmax(i)=dmax*CellDatRed(i,1)
1530    continue
        dmax=dmax**2
        do 1600i=1,3
          if(CrwLogic(i+CrwFr+5)) then
            hmin(i)=-hmax(i)
          else
            hmin(i)=0
          endif
1600    continue
      endif
      call FeQuestRemove(id)
      if(ich.ne.0) go to 9000
      chimint=chimin*torad
      call OpenFile(72,fln(:ifln)//'.rfc','formatted','unknown')
      if(ErrJana.ne.0) go to 9000
      call OpenFile(73,fln(:ifln)//'.rfa','formatted','unknown')
      if(ErrJana.ne.0) go to 9000
      call OpenFile(74,fln(:ifln)//'.rfl','unformatted','unknown')
      if(ErrJana.ne.0) go to 9000
      do 1700i=1,3
        rcp(i,1,KPhase)=CellDatRed(i,1)
1700  continue
      do 1710i=4,6
        rcp(i,1,KPhase)=cos(CellDatRed(i,1)*torad)
1710  continue
      call recip(rcp(1,1,KPhase),rcp(1,1,KPhase),xpom)
      do 1720j=1,3
        prcp(j,1,KPhase)=.25*rcp(j,1,KPhase)**2
1720  continue
      prcp(4,1,KPhase)=.5*rcp(1,1,KPhase)*rcp(2,1,KPhase)*
     1                                    rcp(6,1,KPhase)
      prcp(5,1,KPhase)=.5*rcp(1,1,KPhase)*rcp(3,1,KPhase)*
     1                                    rcp(5,1,KPhase)
      prcp(6,1,KPhase)=.5*rcp(2,1,KPhase)*rcp(3,1,KPhase)*
     1                                    rcp(4,1,KPhase)
      nflmx=1
      do 1800i=1,3
        hminp(i)=0
        hmaxp(i)=0
        nflmx=nflmx*(hmax(i)-hmin(i)+1)
1800  continue
      i2s=1
      i3s=1
      nfl=0
      nref=0
      nbis=0
      ngen=0
      nodd=0
      call FeFlowChartOpen(-1.,-1.,max(nint(float(nflmx)*.01),10),
     1                     nflmx,'Generation of reflections',' ',' ')
      do 3000i1=hmin(iz),hmax(iz)
        ih(iz)=i1
        h(iz)=i1
        if(i2s.eq.1) then
          i2p=hmin(iy)
          i2k=hmax(iy)
        else
          i2k=hmin(iy)
          i2p=hmax(iy)
        endif
        n2=0
        do 2900i2=i2p,i2k,i2s
          ih(iy)=i2
          h(iy)=i2
          if(i3s.eq.1) then
            i3p=hmin(ix)
            i3k=hmax(ix)
          else
            i3k=hmin(ix)
            i3p=hmax(ix)
          endif
          n3=0
          do 2800i3=i3p,i3k,i3s
            if(i1.eq.0.and.i2.eq.0.and.i3.eq.0) go to 2800
            call FeFlowChartEvent(nfl,is)
            if(is.ne.0) then
              call FeBudeBreak
              if(ErrJana.ne.0) go to 9000
            endif
            ih(ix)=i3
            h(ix)=i3
            do 2010i=2,nvt
              a=0.
              do 2005j=1,3
                a=a+vt6(j,i,1,KPhase)*h(j)
2005          continue
              if(abs(a-anint(a)).gt..0001) go to 2800
2010        continue
            sinthlq=h(1)**2*prcp(1,1,KPhase)+h(2)**2*prcp(2,1,KPhase)+
     1              h(3)**2*prcp(3,1,KPhase)+h(1)*h(2)*prcp(4,1,KPhase)+
     2              h(1)*h(3)*prcp(5,1,KPhase)+
     3              h(2)*h(3)*prcp(6,1,KPhase)
            if(4.*sinthlq.gt.dmax) go to 2800
            n2=n2+1
            n3=n3+1
            do 2100i=1,3
              hminp(i)=min(hminp(i),ih(i))
              hmaxp(i)=max(hmaxp(i),ih(i))
2100        continue
            nref=nref+1
            Vystraha=' '
            call bisect(h,fib,chib,thb)
            psip=0.
            if(abs(chib).gt.chimint) go to 2300
            snchib=sin(chib)
            cschib=cos(chib)
            if(cschib*snchib.ne.0.) then
              znak=sign(1.,snchib*cschib)
            else
              znak=1.
            endif
            do 2200i=1,36
              psip=psip+5.
              psi=psip*torad
              do 2150j=1,2
                if(j.eq.2) psi=-psi
                snpsi=sin(psi)
                cspsi=cos(psi)
                chie=atan2(znak*sqrt((cspsi*snchib)**2+snpsi**2),
     1                      cspsi*cschib)
                if(abs(chie).gt.chimint) then
                  snchie=sin(chie)
                  eps=atan2(snpsi*cschib/snchie,snchib/snchie)
                  dfi=atan2(-snpsi/snchie,snchib*cspsi/snchie)
                  fie=uvnitr(fib+dfi)
                  ome=uvnitr(thb+eps)
                  schie2=sin(chie*.5)
                  cchie2=cos(chie*.5)
                  schie2q=schie2**2
                  tchie2=tan(chie*.5)
                  pom=snalfaq-schie2q
                  if(pom.lt.0.) go to 2800
                  pom=sqrt(pom)
                  kappa=2.*atan2(schie2/snalfa,sqrt(snalfaq-schie2q)/
     1                            snalfa)
                  delta=atan2(tchie2/tnalfa,sqrt(snalfaq-schie2q)/
     1                         (snalfa*cchie2))
                  fik=uvnitr(fie-delta)
                  omk=eps-delta+thb
                  if(.not.Kolize(kappa,omk,thb)) then
                    psip=psi/torad
                    go to 2300
                  endif
                endif
2150          continue
2200        continue
            nodd=nodd+1
            Vystraha='!!!!'
            psip=0.
2300        write(72,101) ih,fib/torad,chib/torad,thb/torad,thb/torad,
     1                    psip,Vystraha
            if(psip.gt..1) then
              ngen=ngen+1
              write(72,100) fie/torad,chie/torad,ome/torad,thb/torad
              write(72,100) fik/torad,kappa/torad,omk/torad,thb/torad
            else
              nbis=nbis+1
            endif
            write(73,'(3f8.3,f10.2)') h,psip
            write(74) h,psip
2800      continue
          if(n3.gt.0) i3s=-i3s
2900    continue
        if(n2.gt.0) i2s=-i2s
3000  continue
      call FeFlowChartRemove
      Ninfo=7
      do 3100i=1,3
        write(TextInfo(i),'(5x,a1,''(min) = '',i4,'','',a1,''(max) = ''
     1       ,i4)') indices(i),hminp(i),indices(i),hmaxp(i)
3100  continue
      write(TextInfo(4),'(''Number of generated reflections   :'',i5)')
     1      nref
      write(TextInfo(5),'(''Number of reflections with psi=0  :'',i5)')
     1      nbis
      write(TextInfo(6),'(''Number of reflections with psi<>0 :'',i5)')
     1      ngen
      write(TextInfo(7),'(''Number of failed reflections      :'',i5)')
     1      nodd
      call FeInfoOut(-1.,-1.,'Summary from generation of reflections')
9000  do 9010i=71,74
        call CloseIfOpened(i)
9010  continue
      return
100   format(12x,4f10.2)
101   format(3i4,5f10.2,2x,a4)
      end
      subroutine bisect(h,fib,chib,th)
      include 'params.cmn'
      include 'basic.cmn'
      dimension h(3),c(3)
      call multm(ub,h,c,3,3,1)
      tmp=sqrt(c(1)**2+c(2)**2+c(3)**2)
      chib=atan2(c(3),sqrt(c(1)**2+c(2)**2))
      if(c(1).ne.0..or.c(2).ne.0.) then
        fib=atan2(-c(1),c(2))
      else
        fib=0.
      endif
      th=asin(.5*LamAve(1)*tmp)
      return
      end
      function uvnitr(uhel)
      include 'params.cmn'
      include 'basic.cmn'
      uvnitr=uhel
1000  if(uvnitr.gt.-pi) go to 2000
      uvnitr=uvnitr+pi2
      go to 1000
2000  if(uvnitr.le.pi) return
      uvnitr=uvnitr-pi2
      go to 2000
      end
      logical function Kolize(kappa,omk,thk)
      include 'params.cmn'
      include 'basic.cmn'
      include 'datred.cmn'
      real kappa
      wsc=(doma+domb*tan(abs(thk)))*torad*.375
      iths=iangle(thk-wsc*frot)
      ithe=iangle(thk+wsc*frot)
      ioms=iangle(omk-wsc)
      iome=iangle(omk+wsc)
      kas=iangle(kappa)
      kae=kas
      call collis(iths,ithe,ioms,iome,kas,kae,Kolize)
      return
      end
      function iangle(ang)
      include 'params.cmn'
      include 'basic.cmn'
      iangle=nint(ang*262144./pi)
      return
      end
      subroutine Collis(th_start,th_end,om_start,om_end,ka_start,
     1                        ka_end,colst)
      integer th_start,th_end,om_start,om_end,step(3),domc,angle,angmax,
     1        angmin,delta_kappa,delta_omega,delta_original,delta_om2th,
     2        omega,omega_original,om2th,thmax,thmin,
     3        kabl(3)
      integer centre(26,7),width(26,7)
      logical colst
      data scl,scr/10,20/
      data kabl/118784, 98304, 77024/
      data step/  7168,  8192,  7120/
      data centre/
     1  176504,184456,191640,194832,197768,201520,205184,
     2  208888,212728,216720,220752,225000,229344,233040,
     3  238064,244392,249544,253792,257280,260640,262143,
     4  262143,262143,262143,262143,262143,
     5  171136,174592,177536,180352,183680,187904,191744,
     6  195968,200448,205184,209792,214784,219648,225408,
     7  230912,236928,242944,248832,255232,261632,262143,
     8  262143,262143,262143,262143,262143,
     9  162376,161648,162376,168208,170392,174032,177672,
     a  181312,184952,186408,190776,193688,198064,203888,
     1  208256,210440,214808,220632,223544,227184,232288,
     2  237384,243208,248304,253400,259224,
     3  162376,161648,162376,168208,170392,174032,177672,
     4  181312,184952,186408,190776,193688,198064,203888,
     5  208256,210440,214808,220632,223544,227184,232288,
     6  237384,243208,248304,253400,259224,
     7  156552,156552,159464,163840,167480,171120,174032,
     8  176216,178400,181312,184224,189320,195144,199520,
     9  203888,207528,211896,216264,221360,227184,232288,
     a  237384,243208,248304,253400,259224,
     1  162376,161648,162376,168208,170392,171120,173304,
     2  174760,176216,174760,177672,179128,182040,185680,
     3  187864,210440,214808,220632,223544,227184,232288,
     4  237384,243208,248304,253400,259224,
     5  156552,156552,159464,163840,167480,174032,178400,
     6  184224,186408,192232,196608,202432,210440,214808,
     7  222088,207528,211896,216264,221360,227184,232288,
     8  237384,243208,248304,253400,259224/
      data width/
     1    9424, 27112, 36696, 40272, 43128, 46136, 48048,
     2   49256, 49976, 50288, 50216, 49896, 49360, 47856,
     3   47456, 48120, 47472, 47656, 48384, 48864,262143,
     4  262143,262143,262143,262143,262143,
     5   20480, 30336, 37376, 42624, 46848, 50176, 52224,
     6   53888, 54784, 55680, 56192, 56448, 56192, 56192,
     7   56064, 55552, 54784, 53888, 53632, 53504,262143,
     8  262143,262143,262143,262143,262143,
     9   24024, 34952, 41504, 50240, 55336, 58976, 62616,
     a   66264, 69904, 68448, 69904, 69904, 71360, 72816,
     1   72816, 75000, 73544, 72088, 73544, 74272, 75000,
     2   74272, 74272, 73544, 74272, 74272,
     3   24024, 34952, 41504, 50240, 55336, 58976, 62616,
     4   66264, 69904, 68448, 69904, 69904, 71360, 72816,
     5   72816, 75000, 73544, 72088, 73544, 74272, 75000,
     6   74272, 74272, 73544, 74272, 74272,
     7   25480, 40048, 50240, 54608, 58248, 61888, 64800,
     8   66992, 69176, 70632, 73544, 72816, 72816, 72816,
     9   72816, 73544, 73544, 73544, 74272, 74272, 75000,
     a   74272, 74272, 73544, 74272, 74272,
     3   24024, 34952, 41504, 50240, 55336, 61888, 66992,
     4   72816, 78640, 80096, 83008, 84464, 87376, 91016,
     5   93200, 75000, 73544, 72088, 73544, 74272, 75000,
     6   74272, 74272, 73544, 74272, 74272,
     7   25480, 40048, 50240, 54608, 58248, 64800, 69176,
     8   75000, 77184, 81552, 85920, 85920, 88104, 88104,
     9   91016, 73544, 73544, 73544, 74272, 74272, 75000,
     a   74272, 74272, 73544, 74272, 74272/
      data kcryob,kcrym,kcryp,domc/
     1   88064,183616,204608, 90112/
c      data kabl/"350000,"300000,"226340/,step/"16000,"20000,"15720/
c      data centre/
c     1  "530570,"550210,"566230,"574420,"602210,"611460,"620600,
c     2  "627770,"637370,"647220,"657120,"667350,"677740,"707120,
c     3  "720760,"735250,"747310,"757540,"766400,"775040,"777777,
c     4  "777777,"777777,"777777,"777777,"777777,
c     5  "516200,"525000,"532600,"540200,"546600,"557000,"566400,
c     6  "576600,"607400,"620600,"631600,"643400,"655000,"670200,
c     7  "703000,"716600,"732400,"746000,"762400,"777000,"777777,
c     8  "777777,"777777,"777777,"777777,"777777,
c     9  "475110,"473560,"475110,"510420,"514630,"523720,"533010,
c     a  "542100,"551170,"554050,"564470,"572230,"602660,"616160,
c     1  "626600,"633010,"643430,"656730,"664470,"673560,"705540,
c     2  "717510,"733010,"744760,"756730,"772230,
c     3  "475110,"473560,"475110,"510420,"514630,"523720,"533010,
c     4  "542100,"551170,"554050,"564470,"572230,"602660,"616160,
c     5  "626600,"633010,"643430,"656730,"664470,"673560,"705540,
c     6  "717510,"733010,"744760,"756730,"772230,
c     7  "461610,"461610,"467350,"500000,"507070,"516160,"523720,
c     8  "530130,"534340,"542100,"547640,"561610,"575110,"605540,
c     9  "616160,"625250,"635670,"646310,"660260,"673560,"705540,
c     a  "717510,"733010,"744760,"756730,"772230,
c     1  "475110,"473560,"475110,"510420,"514630,"516160,"522370,
c     2  "525250,"530130,"525250,"533010,"535670,"543430,"552520,
c     3  "556730,"633010,"643430,"656730,"664470,"673560,"705540,
c     4  "717510,"733010,"744760,"756730,"772230,
c     5  "461610,"461610,"467350,"500000,"507070,"523720,"534340,
c     6  "547640,"554050,"567350,"600000,"613300,"633010,"643430,
c     7  "661610,"625250,"635670,"646310,"660260,"673560,"705540,
c     8  "717510,"733010,"744760,"756730,"772230/
c      DATA WIDTH/
c     1  "022320,"064750,"107530,"116520,"124170,"132070,"135660,
c     2  "140150,"141470,"142160,"142050,"141350,"140320,"135360,
c     3  "134540,"135770,"134560,"135050,"136400,"137340,"777777,
c     4  "777777,"777777,"777777,"777777,"777777,
c     5  "050000,"073200,"111000,"123200,"133400,"142000,"146000,
c     6  "151200,"153000,"154600,"155600,"156200,"155600,"155600,
c     7  "155400,"154400,"153000,"151200,"150600,"150400,"777777,
c     8  "777777,"777777,"777777,"777777,"777777,
c     9  "056730,"104210,"121040,"142100,"154050,"163140,"172230,
c     a  "201330,"210420,"205540,"210420,"210420,"213300,"216160,
c     1  "216160,"222370,"217510,"214630,"217510,"221040,"222370,
c     2  "221040,"221040,"217510,"221040,"221040,
c     3  "056730,"104210,"121040,"142100,"154050,"163140,"172230,
c     4  "201330,"210420,"205540,"210420,"210420,"213300,"216160,
c     5  "216160,"222370,"217510,"214630,"217510,"221040,"222370,
c     6  "221040,"221040,"217510,"221040,"221040,
c     7  "061610,"116160,"142100,"152520,"161610,"170700,"176440,
c     8  "202660,"207070,"211750,"217510,"216160,"216160,"216160,
c     9  "216160,"217510,"217510,"217510,"221040,"221040,"222370,
c     a  "221040,"221040,"217510,"221040,"221040,
c     3  "056730,"104210,"121040,"142100,"154050,"170700,"202660,
c     4  "216160,"231460,"234340,"242100,"244760,"252520,"261610,
c     5  "266020,"222370,"217510,"214630,"217510,"221040,"222370,
c     6  "221040,"221040,"217510,"221040,"221040,
c     7  "061610,"116160,"142100,"152520,"161610,"176440,"207070,
c     8  "222370,"226600,"237220,"247640,"247640,"254050,"254050,
c     9  "261610,"217510,"217510,"217510,"221040,"221040,"222370,
c     a  "221040,"221040,"217510,"221040,"221040/
c      data kcryob,kcrym,kcryp,domc/"254000,"546500,"617500,"260000/
      sflags=0
      kappa=ibetw(ka_end,262144)
      angle=ibetw(ka_start,262144)
      if(iabs(kappa).lt.iabs(angle)) then
        delta_kappa=kappa-angle
        kappa=angle
      else
        delta_kappa=angle-kappa
      endif
      omega=ibetw(om_end,262144)
      omega_original=omega
      delta_omega=om_start-om_end
      delta_original=delta_omega
      om2th=ibetw(om_end-2*th_end+262144,262144)
      delta_om2th=om_start-2*th_start-om_end+2*th_end
      if(kappa.lt.0) then
        kappa=-kappa
        omega=-omega
        om2th=-om2th
        if(th_start.gt.th_end) then
          thmin=-th_start
          thmax=-th_end
        else
          thmax=-th_start
          thmin=-th_end
        endif
        delta_kappa=-delta_kappa
        delta_omega=-delta_omega
        delta_om2th=-delta_om2th
      else
        if(th_start.gt.th_end) then
          thmax= th_start
          thmin= th_end
        else
          thmin= th_start
          thmax= th_end
        endif
      endif
      colst=.false.
      if(sflags.ne.0.and.scr.ne.0) then
        j=3
        if(Ibetw(om2th+domc,262144).gt.0)
     1                              om2th=ibetw(om2th+262144,262144)
        if((sflags.ne.0.and.scl.ne.0).or.kappa.le.kcryob) then
          angle=Omega_original+delta_original
          if(Omega_original.gt.0.or.angle.gt.0.or.angle.lt.-262144) then
            if(kappa.gt.kcrym) colst=.true.
          else
            if(kappa.gt.kcryp) colst=.true.
          endif
        else
          colst=.true.
        endif
      else
        if(sflags.ne.0.and.scl.ne.0) then
          j=2
        else
          j=1
        endif
      endif
      if(colst.or.kappa.lt.kabl(j)) return
      i=(kappa-kabl(j))/step(j)+1
      angmin=-centre(i,j)+width(i,j)
      angmax=524288-centre(i,j)-width(i,j)
      ii=(kappa+delta_kappa-kabl(j))/step(j)+1
      if(ii.lt.1) ii=1
      jj=-(kappa+delta_kappa+kabl(j))/step(j)+1
      if(ii.ne.i) then
        do i=i-1,ii,-1
          angle=-centre(i,j)+width(i,j)
          if(angle.gt.angmin) angmin=angle
          if(jj.gt.i.and.-angle.lt.angmax) angmax=-angle
          angle=524288-centre(i,j)-width(i,j)
          if(angle.lt.angmax) angmax=angle
          if(jj.gt.i.and.-angle.gt.angmin) angmin=-angle
        enddo
      endif
      if(om2th.lt.angmin) om2th=om2th+524288
      if(om2th.gt.angmax) then
        colst=.true.
      else
        angle=om2th+delta_om2th
        if(angle.lt.angmin.or.angle.gt.angmax) colst=.true.
      endif
      if(colst) return
      thmin=2.*thmin-262144+angmax
      thmax=2.*thmax+262144+angmin
      if(sflags.ne.0.and.scr.ne.0) then
        if(ibetw(omega+domc,262144).lt.0) then
          if(omega.eq.omega_original) then
            j=4
          else
            j=5
          endif
        else
          if(omega.eq.omega_original) then
            j=6
          else
            j=7
          endif
          omega=ibetw(omega+262144,262144)
        endif
      endif
      i=(kappa-kabl(j))/step(j)+1
      angmin=-centre(i,j)+width(i,j)
      angmax=524288-centre(i,j)-width(i,j)
      ii=(kappa+delta_kappa-kabl(j))/step(j)+1
      if(ii.lt.1) ii=1
      if(ii.ne.i) then
        jj=-(kappa+delta_kappa+kabl(j))/step(j)+1
        do i=i-1,ii,-1
          angle=-centre(i,j)+width(i,j)
          if(angle.gt.angmin) angmin=angle
          if(jj.gt.i.and.-angle.lt.angmax) angmax=-angle
          angle=524288-centre(i,j)-width(i,j)
          if(angle.lt.angmax) angmax=angle
          if(jj.gt.i.and.-angle.gt.angmin) angmin=-angle
        enddo
      endif
      if(omega.lt.angmin) omega=omega+524288
      if(omega.gt.angmax) then
        colst=.true.
      else
        angle=omega+delta_omega
        if(angle.lt.angmin.or.angle.gt.angmax) then
          colst=.true.
        else
          if((omega.gt.thmin.or.angle.gt.thmin).and.
     1       (omega.lt.thmax.or.angle.lt.thmax)) colst=.true.
        endif
      endif
      return
      end
      function ibetw(i,m)
      if(i.ne.-m) then
        n=(i+isign(m,i))/(2*m)
        ibetw=i-2*n*m
      else
        ibetw=i
      endif
      return
      end
      subroutine MorfCryst
      include 'params.cmn'
      include 'basic.cmn'
      include 'datred.cmn'
      include 'fepc.cmn'
      dimension DefVect(3),ViewDir(3),PomVek(3)
      character Char1,Char2
      character*20 t20
      dimension dfaceIn(4,mxface)
      integer CisBut,EventMode,ButtonStateQuest
      logical Recip,FacesNotOK,ctipl,FeYesNo,eqrv,CrwLogicQuest,
     1        Continuously
      parameter (strotuhel=1.)
      call CopyVek(dface,dfaceIn,4*nfaces)
1020  call ReadFaces(0,nfacesin,ich)
      if(ich.ne.0) go to 9999
1030  do 1050i=1,nfaces
        call CopyVek(dface(1,i),pomvek,3)
        call MorTransVec(.true.,pomvek)
        call CopyVek(pomvek,krov(1,i),3)
        krov(4,i)=dface(4,i)
1050  continue
      call MorFillArray(FacesNotOK,ctipl)
      if(FacesNotOK) then
        if(ctipl) then
          go to 3000
        else
          go to 1030
        endif
      endif
      call UnitMat(RotMat,3)
      HLFaceNr=0
      Recip=.false.
      scale=1.
      DefVect(1)=0.
      DefVect(2)=0.
      DefVect(3)=1.
      do 1100i=1,3
        ViewDir(i)=DefVect(i)
1100  continue
      id=NextQuestId()
      ichk=0
      call FeQuestAbsCreate(id,0.,0.,XMaxBasWin,YMaxBasWin,' ',0,0,-1,
     1                      -1)
      xdPruh=60.
      RozmerPlochy=XLenBasWin-2.*xdPruh
      ydPruh=(YLenBasWin-RozmerPlochy)*.5
      call FeMakeGrWin(xdPruh,xdPruh,ydPruh+10.,ydPruh-10.)
      call FeMakeAcWin(0.,0.,0.,0.)
      call FeBottomInfo('#prazdno#')
      call UnitMat(F2O,3)
      call FeSetTransXo2X(0.,40.,22.,0.,.false.)
      xCenPravyPruh=XMaxAcWin+xdPruh*.5
      ypom=YMaxAcWin-5.
      call FeQuestAbsLabelMake(id,xCenPravyPruh,ypom,'Change','C')
      ichk=ichk+1
      xpom=XMaxAcWin+5.
      tpom=xpom+CrwgXd+5.
      ypom=ypom-3.
      do 1120i=1,2
        ypom=ypom-12.
        if(i.eq.1) then
          t20='in steps'
        else
          t20='continuously'
        endif
        call FeQuestAbsCrwMake(id,tpom,ypom+.5*CrwgYd,xpom,ypom,t20,'L',
     1                         CrwgXd,CrwgYd,0,ichk)
        if(i.eq.1) then
          nCrwInSteps=CrwLastMade
        else
          nCrwContinuously=CrwLastMade
        endif
        call FeQuestCrwOpen(CrwLastMade,i.eq.1)
1120  continue
      nCrwSum1=nCrwInSteps+nCrwContinuously
      ypom=ypom-15.
      call FeQuestAbsLabelMake(id,xCenPravyPruh,ypom,'Around','C')
      ypom=ypom-3.
      ichk=ichk+1
      do 1130i=1,2
        ypom=ypom-12.
        if(i.eq.1) then
          t20='screen axes'
        else
          t20='crystal axes'
        endif
        call FeQuestAbsCrwMake(id,tpom,ypom+.5*CrwgYd,xpom,ypom,t20,'L',
     1                         CrwgXd,CrwgYd,0,ichk)
        if(i.eq.1) then
          nCrwScreenAxes=CrwLastMade
        else
          nCrwCrystalAxes=CrwLastMade
        endif
        call FeQuestCrwOpen(CrwLastMade,i.eq.2)
1130  continue
      nCrwSum2=nCrwScreenAxes+nCrwCrystalAxes
      ypom=ypom-15.
      call FeQuestAbsLabelMake(id,xCenPravyPruh,ypom,'Rotate','C')
      ypom=ypom-3.
      xpom1=xCenPravyPruh-5.5-ButYd
      xpom2=xCenPravyPruh+5.5
      ylabel=ypom
      do 1150i=1,3
        ypom=ypom-12.
        call FeQuestAbsButtonMake(id,xpom1,ypom,ButYd,ButYd,'-')
        call FeQuestButtonOpen(ButtonLastMade,ButtonOff)
        if(i.eq.1) nButtRotateFirst=ButtonLastMade
        call FeQuestAbsButtonMake(id,xpom2,ypom,ButYd,ButYd,'+')
        call FeQuestButtonOpen(ButtonLastMade,ButtonOff)
        call FeQuestAbsLabelMake(id,xCenPravyPruh,ypom+.5*ButYd,
     1                           SmbABC(i),'C')
        if(i.eq.3) nButtRotateLast=ButtonLastMade
1150  continue
      xCenLevyPruh=xdPruh*.5
      ypom=YMaxAcWin-25.
      do 1160i=1,3
        ypom=ypom-12.
        if(i.eq.3) ypom=ypom-40.
        if(i.eq.1) then
          t20='%View along'
        else if(i.eq.2) then
          t20='%Highlight face'
        else if(i.eq.3) then
          t20='%Default scale'
        endif
        dpom=FeTxLengthUnder(t20)+5.
        xpom=xCenLevyPruh-dpom*.5
        call FeQuestAbsButtonMake(id,xpom,ypom,dpom,ButYd,t20)
        if(i.eq.1) then
          nButtViewAlong=ButtonLastMade
        else if(i.eq.2) then
          nButtHighLight=ButtonLastMade
        else if(i.eq.3) then
          nButtDefaultScale=ButtonLastMade
        endif
        call FeQuestButtonOpen(ButtonLastMade,ButtonOff)
1160  continue
      ypom=ypom+27.
      call FeQuestAbsLabelMake(id,xCenLevyPruh,ypom,'Scale','C')
      ypom=ypom-15.
      xpom=xCenLevyPruh-5.5-ButYd
      call FeQuestAbsButtonMake(id,xpom,ypom,ButYd,ButYd,'-')
      call FeQuestButtonOpen(ButtonLastMade,ButtonOff)
      nButtScaleMinus=ButtonLastMade
      xpom=xCenLevyPruh+5.5
      call FeQuestAbsButtonMake(id,xpom,ypom,ButYd,ButYd,'+')
      call FeQuestButtonOpen(ButtonLastMade,ButtonOff)
      nButtScalePlus=ButtonLastMade
      t20='Sho%w axes'
      xpom=5.
      tpom=xpom+CrwXd+3.
      ypom=ypom-36.
      call FeQuestAbsCrwMake(id,tpom,ypom+.5*CrwYd,xpom,ypom,t20,'L',
     1                       CrwXd,CrwYd,0,0)
      nCrwShowAxes=CrwLastMade
      call FeQuestCrwOpen(CrwLastMade,.true.)
      ypom=YMinAcWin-12.
      dpom=FeTxLength('xxxxxxxxx')+10.*EdwIndSize
      xpom=XCenBasWin-dpom*.5
      call FeQuestAbsEdwMake(id,tpom,ypom,xpom,ypom,' ','L',dpom,EdwYd,
     1                       0)
      nEdwInfo=EdwLastMade
      call FeQuestStringEdwOpen(EdwLastMade,' ')
      ypom=ypom-12.
      t20='%Reset'
      dpom=FeTxLengthUnder(t20)+5.
      xpom=XCenBasWin-dpom-5.
      do 1170i=1,2
        if(i.eq.2) then
          t20='%Exit'
          xpom=XCenBasWin+5.
        endif
        call FeQuestAbsButtonMake(id,xpom,ypom,dpom,ButYd,t20)
        if(i.eq.1) then
          nButtReset=ButtonLastMade
        else
          nButtExit=ButtonLastMade
        endif
        call FeQuestButtonOpen(ButtonLastMade,ButtonOff)
1170  continue
      do 2050 i=1,nfaces
        call CopyVek(dface(1,i),krov(1,i),4)
        call MorTransVec(.true.,krov(1,i))
2050  continue
      call UnitMat(Axis,3)
      do 2060i=1,3
        call MorTransVec(.false.,Axis(1,i))
2060  continue
      call MorNatochkl(DefVect)
      call MorPrumety
      TakeMouseMove=.true.
      EventMode=0
      ActFace=0
      Continuously=.false.
2200  EventMode=0
      if(Continuously) then
        do 2201i=nButtRotateFirst,nButtRotateLast
          if(ButtonStateQuest(i).eq.ButtonOn) then
            EventMode=1
            go to 2202
          endif
2201    continue
      endif
2202  call FeMouseShape(0)
      AllowChangeMouse=.false.
      call FeReleaseOutput
      call FeEvent(EventMode)
      call FeDeferOutput
      call FeSync(.false.)
      if(EventType.eq.EventMouse) then
        if(EventNumber.eq.JeMove) then
          call MorShowFaceInd(nEdwInfo)
        else if(EventNumber.eq.JeLeftDown.and.ActFace.ne.0) then
          if(HlFaceNr.ne.0) then
            i=0
2205        i=i+1
            BodHr(RovHr1(HLFaceNr,i),RovHr2(HLFaceNr,i))=1
            if(rovhr1(hlfacenr,i+1).gt.0) goto 2205
            HlFaceNr=0
          endif
c          EventType=EventButton
c          EventNumber=nButtHighLight
        else if(EventNumber.eq.JeLeftUp.and.CrwLogicQuest(nCrwInSteps))
     1    then
          call MorVymackniButtony(nButtRotateFirst,nButtRotateLast,0)
          Continuously=.false.
        endif
        go to 2200
      endif
      if(EventType.eq.EventButton) then
        if(EventNumber.ge.nButtRotateFirst.and.
     1     EventNumber.le.nButtRotateLast) CisBut=EventNumber
      endif
      if(EventType.eq.EventCrw) then
        if(EventNumber.eq.nCrwInSteps.or.
     1     EventNumber.eq.nCrwContinuously) then
          call FeQuestCrwOn(EventNumber)
          call FeQuestCrwOff(nCrwSum1-EventNumber)
          Continuously=CrwLogicQuest(nCrwContinuously)
          CisBut=0
          call MorVymackniButtony(nButtRotateFirst,nButtRotateLast,0)
          go to 2200
        else if(EventNumber.eq.nCrwScreenAxes.or.
     1          EventNumber.eq.nCrwCrystalAxes) then
          call FeQuestCrwOn(EventNumber)
          call FeQuestCrwOff(nCrwSum2-EventNumber)
          ypom=ylabel+.5*ButYd
          do 2720i=1,3
            ypom=ypom-12.
            if(EventNumber.eq.nCrwScreenAxes) then
              Char1=Smbabc(i)
              Char2=SmbX(i)
            else
              Char2=Smbabc(i)
              Char1=SmbX(i)
            endif
            call FeQuestAbsLabelRemove(id,xCenPravyPruh,ypom,Char1,'C')
            call FeQuestAbsLabelMake  (id,xCenPravyPruh,ypom,Char2,'C')
2720      continue
        else if(EventNumber.eq.nCrwShowAxes) then
          if(CrwLogicQuest(nCrwShowAxes)) then
            call FeQuestCrwOff(nCrwShowAxes)
          else
            call FeQuestCrwOn(nCrwShowAxes)
          endif
          call MorPrumety
        endif
      endif
      if(EventType.eq.EventButton.or.Continuously) then
        if(Continuously.and.EventNumber.le.nButtRotateLast)
     1    EventNumber=CisBut
        if(EventNumber.ge.nButtRotateFirst.and.
     1     EventNumber.le.nButtRotateLast) then
          if(Continuously) then
            call MorVymackniButtony(nButtRotateFirst,nButtRotateLast,
     1                              EventNumber)
            call MorShowFaceInd(nEdwInfo)
          else
            call FeQuestButtonOn(EventNumber)
          endif
          i=(EventNumber-nButtRotateFirst)/2+1
          j=mod(EventNumber-nButtRotateFirst,2)
          if(j.eq.0) then
            pom=-1.
          else
            pom= 1.
          endif
          if(CrwLogicQuest(nCrwScreenAxes)) then
            call SetRealArrayTo(SmerRot,3,0.)
            SmerRot(i)=1.
          else
            call CopyVek(RAxis(1,i),SmerRot,3)
          endif
          call MorDelejRotmat(Pom*StRotUhel,SmerRot)
          call MorRotujKrystal
          call MorPrumety
          Continuously=.true.
          go to 2200
        endif
        ib=EventNumber
        call FeQuestButtonOn(ib)
        if(EventNumber.eq.nButtReset) then
          if(Continuously) then
            call MorVymackniButtony(nButtRotateFirst,nButtRotateLast,0)
            CisBut=0
          endif
          call MorNatochkl(DefVect)
          call MorPrumety
          scale=1.
        else if(EventNumber.eq.nButtViewAlong) then
          idp=NextQuestId()
          call FeQuestCreate(idp,-2.,-1.,120.,0,3,
     1                       'View along direction',0,LightGray,0,0)
          call FeQuestEdwMake(idp,5.,1,5.,1,' ','L',100.,EdwYd,1)
          nEdwViewDir=EdwLastMade
          if(HlFaceNr.ne.0) call CopyVek(dface(1,HlFaceNr),ViewDir,3)
          call FeQuestRealAEdwOpen(EdwLastMade,ViewDir,3,.false.,
     1                             .false.)
          call FeQuestCrwMake(idp,25.,2,10.,2,'direct space','L',CrwgXd,
     1                        CrwgYd,1,1)
          call FeQuestCrwOpen(CrwLastMade,.not.Recip)
          call FeQuestCrwMake(idp,25.,3,10.,3,'reciprocal space','L',
     1                        CrwgXd,CrwgYd,1,1)
          nCrwRecip=CrwLastMade
          call FeQuestCrwOpen(CrwLastMade,Recip)
2268      icont=0
2270      call FeQuestEvent(idp,icont,ich)
          icont=1
          if(CheckType.eq.EventEdw) then
            call FeQuestRealAFromEdw(nEdwViewDir,ViewDir)
            if(VecOrtLen(ViewDir,3).lt..001) then
              call FeChybne(-2.,-1.,'null vector, try again',' ',0,
     1                      SeriousError)
              go to 2268
            else
              go to 2270
            endif
          else if(CheckType.eq.EventCrw) then
            Recip=CrwLogicQuest(nCrwRecip)
            go to 2268
          else if(CheckType.ne.0) then
            call NebylOsetren
            go to 2270
          endif
          call FeQuestRemove(idp)
          call FeQuestStringEdwOpen(nEdwInfo,' ')
          call FeMouseShape(0)
          if(ich.eq.0) then
            call CopyVek(ViewDir,PomVek,3)
            call MorTransVec(Recip,PomVek)
            call MorNatochkl(PomVek)
            call MorPrumety
            call MorVymackniButtony(nButtRotateFirst,nButtRotateLast,0)
          endif
        else if(EventNumber.eq.nButtScaleMinus.or.
     1          EventNumber.eq.nButtScalePlus) then
          if(EventNumber.eq.nButtScaleMinus) then
            xpom1=-.01
          else
            xpom1= .01
          endif
          scale=scale+xpom1
          call MorPrumety
        else if(EventNumber.eq.nButtDefaultScale) then
          scale=1.
          call MorPrumety
        else if(EventNumber.eq.nButtExit) then
          go to 3000
        else if(EventNumber.eq.nButtHighLight) then
          if(HLFaceNr.eq.0) then
            if(ActFace.eq.0) then
              idp=NextQuestId()
              call FeQuestCreate(idp,-2.,-1.,205.,0,nfaces/5+1,
     1                           'Select face',0,LightGray,0,0)
              xpom=-35.
              j=0
              il=1
              do 2300i=1,nfaces
                xpom=xpom+40.
                write(t20,'(3f5.0)')(dface(k,i),k=1,3)
                call ZdrcniCisla(t20,3)
                call FeQuestSelwMake(idp,xpom,il,t20,35.,SelwYd,0,1)
                call FeQuestSelwOpen(SelwLastMade,i.eq.1)
                if(mod(i,5).eq.0) then
                  il=il+1
                  xpom=-35.
                endif
2300          continue
2368          icont=0
2370          call FeQuestEvent(idp,icont,ich)
              icont=1
              if(CheckType.ne.0) then
                call NebylOsetren
                go to 2370
              endif
              call FeQuestRemove(idp)
              call FeQuestStringEdwOpen(nEdwInfo,' ')
              if(ich.eq.0) then
                do 2500i=1,nfaces
                  if(selwlogic(i)) then
                    HLFaceNr=i
                    go to 2550
                  endif
2500            continue
              endif
            else
              HlFaceNr=ActFace
              ich=0
            endif
2550        i=0
2600        i=i+1
            BodHr(RovHr1(HLFaceNr,i),RovHr2(HLFaceNr,i))=2
            if(rovhr1(HLfaceNr,i+1).gt.0) goto 2600
            write(t20,'(3f5.0)')(dface(i,HLFaceNr),i=1,3)
            call ZdrcniCisla(t20,3)
            call FeQuestButtonLabelChange(nButtHighLight,'Clear '//
     1                                    t20(:idel(t20)))
            call MorPrumety
          else
            call FeQuestButtonLabelChange(nButtHighLight,
     1                                    '%Highlight face')
            i=0
2690        i=i+1
            bodhr(rovhr1(hlfacenr,i),rovhr2(hlfacenr,i))=1
            if(rovhr1(hlfacenr,i+1).gt.0) goto 2690
            HlFaceNr=0
            call MorPrumety
          endif
        endif
        call FeButtonOff(ib)
      endif
      go to 2200
3000  if(nfaces.eq.nfacesin) then
        do 3100i=1,nfaces
          if(.not.eqrv(dface(1,i),dfacein(1,i),3,.001).or.
     1       abs(dface(4,i)-dfacein(4,i)).gt..0001) go to 3200
3100    continue
        go to 9900
      endif
3200  if(FeYesNo(-1.,-1.,'Do you want to save faces to m94?',0)) then
        call iom94(1)
      else
        nfaces=nfacesin
        call CopyVek(dfaceIn,dface,4*nfacesin)
      endif
9900  call FeQuestRemove(id)
      TakeMouseMove=.false.
      AllowChangeMouse=.true.
9999  return
      end
      subroutine MorShowFaceInd(nEdwInfo)
      include 'params.cmn'
      include 'basic.cmn'
      include 'datred.cmn'
      include 'fepc.cmn'
      character*50 t50
      integer inface(100)
      do 500i=1,100
        inface(i)=0
500   continue
      do 1000i=1,nfaces
        if(rkrov(3,i).lt.0.0001) go to 1000
        j=0
1100    j=j+1
        x1=bodrx(rovhr1(i,j))
        y1=bodry(rovhr1(i,j))
        x2=bodrx(rovhr2(i,j))
        y2=bodry(rovhr2(i,j))
        if((ypos.gt.min(y1,y2)).and.(ypos.lt.max(y1,y2))) then
          xp=(x1*y2-x2*y1+ypos*(x2-x1))/(y2-y1)
          if(xp.gt.xpos) inface(i)=inface(i)+1
          if(xp.lt.xpos) inface(i)=inface(i)-1
          if(inface(i).eq.0) go to 1200
        endif
        if(rovhr1(i,j+1).ne.0) go to 1100
1000  continue
      i=0
1200  if(i.ne.ActFace) then
        if(i.ne.0) then
          write(t50,'(3i3)')(nint(dface(j,i)),j=1,3)
        else
          t50=' '
        endif
        call FeReDrTx(nEdwInfo+EdwFr-1,1,0,t50)
        if(DeferredOutput) then
          call FeReleaseOutput
          call FeDeferOutput
        endif
        ActFace=i
      endif
      return
      end
      subroutine MorPrumety
      include 'params.cmn'
      include 'basic.cmn'
      include 'datred.cmn'
      include 'fepc.cmn'
      integer Color
      real koef
      logical CrwLogicQuest
      do 1010i=1,nfaces
        j=0
1000    j=j+1
        if(rovHr1(i,j).ne.0) then
          if(bodHr(rovHr1(i,j),rovHr2(i,j)).lt.3) then
             bodHr(rovHr1(i,j),rovHr2(i,j))=
     1       bodHr(rovHr1(i,j),rovHr2(i,j))+2
          endif
          go to 1000
        endif
1010  continue
      do 1030i=1,nfaces
        if(rkrov(3,i).lt.-.0001) go to 1030
        j=0
1020    j=j+1
        if(rovHr1(i,j).ne.0) then
          if(bodHr(rovHr1(i,j),rovHr2(i,j)).gt.2) then
            bodHr(rovHr1(i,j),rovHr2(i,j))=
     1        bodHr(rovHr1(i,j),rovHr2(i,j))-2
          endif
          go to 1020
        endif
1030  continue
      rmax=0.
      do 1100i=1,PocetBodu
        rmax=max(VecOrtLen(Rbod(1,i),3),rmax)
1100  continue
      koef=(XLenAcWin*.5-10.)/rmax
1200  if(scale*koef*rmax.gt.XLenAcWin*.5) then
        scale=scale-0.005
        go to 1200
      endif
      pom=scale*koef
      do 1300i=1,PocetBodu
        BodRX(i)=RBod(1,i)*pom+XCenAcWin
        BodRY(i)=RBod(2,i)*pom+YCenAcWin
1300  continue
      call FeClearGrWin
      do 2310i=1, PocetBodu-1
        do 2300j=i+1,PocetBodu
          xu(1)=BodRX(i)
          xu(2)=BodRX(j)
          yu(1)=BodRY(i)
          yu(2)=BodRY(j)
          k=bodHr(i,j)
          if(k.le.2) then
            call FeLineType(NormalLine)
          else
            call FeLineType(DashedLine)
          endif
          if(k.eq.1) then
            Color=White
          else if(k.eq.2) then
            Color=Green
          else if(k.eq.3) then
            Color=LightGray
          else if(k.eq.4) then
            Color=Green
          else
            go to 2300
          endif
          call FePolyLine(2,xu,yu,Color)
2300    continue
2310  continue
      if(CrwLogicQuest(nCrwShowAxes)) then
        do 2380i=1,3
          call MorShowVect(RAxis(1,i),SmbABC(i),Yellow)
2380    continue
      endif
      call FeLineType(NormalLine)
      return
      end
      subroutine MorNatochkl(Vect)
      include 'params.cmn'
      include 'basic.cmn'
      include 'datred.cmn'
      dimension Vect(3),PomMat(3,3)
      call CopyVek(Vect,PomMat(1,3),3)
      call VecOrtNorm(PomMat(1,3),3)
      if(abs(PomMat(2,3)).lt..99) then
        pom=1.
        do 1500i=1,3
          if(i.eq.2) then
            PomMat(i,1)=0.
          else
            j=4-i
            PomMat(i,1)=pom*PomMat(j,3)
            pom=-1.
          endif
1500    continue
      else
        PomMat(1,1)=1.
        PomMat(2,1)=0.
        PomMat(3,1)=0.
      endif
      call VecOrtNorm(PomMat(1,1),3)
      call VecMul(PomMat(1,3),PomMat(1,1),PomMat(1,2))
      call TrMat(PomMat,RotMat,3,3)
      call MorRotujKrystal
      return
      end
      subroutine MorFillArray(FacesNotOK,ctipl)
      include 'params.cmn'
      include 'basic.cmn'
      include 'datred.cmn'
      include 'fepc.cmn'
      dimension rmp(3,3),rmi(3,3),xp(3),ps(3),NotOKList(15),
     1          plist(100,100)
      logical chyba,Novy,eqrv,FacesNotOK,ctipl,plist,CrwLogicQuest
      integer PocHr,NotOKList
      character*50 ErrSt,ErrMsg,pomchar
500   do 1010i=1,100
        do 1000j=1,100
          BodRov(i,j)=.false.
          plist(i,j)=.false.
1000    continue
1010  continue
      call SetIntArrayTo(BodHr,10000,0)
      PocetBodu=0
      FacesNotOK=.false.
      ctipl=.true.
      do 2000i=1,nfaces-2
        ps(1)=krov(4,i)
        do 1040m=1,3
          rmp(1,m)=krov(m,i)
1040    continue
        do 1900j=i+1,nfaces-1
          ps(2)=krov(4,j)
          do 1050m=1,3
            rmp(2,m)=krov(m,j)
1050      continue
          do 1800k=j+1,nfaces
            do 1060m=1,3
              rmp(3,m)=krov(m,k)
1060        continue
            call matinv(rmp,rmi,dets,3)
            if(abs(dets).gt..00001) then
              ps(3)=krov(4,k)
              call multm(rmi,ps,xp,3,3,1)
              chyba=.false.
              do 1200n=1,nfaces
                skals=ScalMul(krov(1,n),xp)
                if(abs(skals).gt..00001) then
                  t=krov(4,n)/skals
                else
                  t=0.
                endif
                if(t.lt.0.99999.and.t.gt..00001) then
                  chyba=.true.
                  go to 1210
                endif
1200          continue
1210          if(.not.chyba) then
                Novy=.true.
                do 1300l=1,PocetBodu
                  if(eqrv(xp,bod(1,l),3,.001*sqrt(ScalMul(xp,xp))))
     1             then
                    Novy=.false.
                    bodrov(l,i)=.true.
                    bodrov(l,j)=.true.
                    bodrov(l,k)=.true.
                    plist(i,l)=.true.
                    plist(j,l)=.true.
                    plist(k,l)=.true.
                  endif
1300            continue
                if(Novy) then
                  PocetBodu=PocetBodu+1
                  call CopyVek(xp,bod(1,PocetBodu),3)
                  bodrov(PocetBodu,i)=.true.
                  bodrov(PocetBodu,j)=.true.
                  bodrov(PocetBodu,k)=.true.
                  plist(i,PocetBodu)=.true.
                  plist(j,PocetBodu)=.true.
                  plist(k,PocetBodu)=.true.
                endif
              endif
            endif
1800      continue
1900    continue
2000  continue
      NotOKNr=0
      do 2100i=1,nfaces
        k=0
        do 2110j=1,PocetBodu
          if(plist(i,j)) k=k+1
2110    continue
        if(k.lt.3) then
          NotOKNr=NotOKNr+1
          NotOkList(NotOKNr)=i
          FacesNotOk=.true.
        endif
2100  continue
      if(FacesNotOK) then
        ErrSt='Too large d for the following face'
        if(notoknr.gt.1) then
          ErrSt=ErrSt(:31)//'s'
          ErrMsg='Please change their d''s or delete them'
        else
          ErrMsg='Please change its d or delete it'
        endif
        id=NextQuestId()
        call FeQuestCreate(id,-1.,-1.,140.,0,NotOKNr+2,ErrSt,0,
     1                     LightGray,0,0)
        il=1
        call FequestLabelMake(id,70.,il,ErrMsg,'C')
        il=il+1
        call FeQuestLabelMake(id,54.,il,'Delete face','C')
        call FeQuestLabelMake(id,100.,il,'Change d','C')
        do 2210iw=1,NotOKNr
          il=il+1
          write(pomchar,'(3f5.0)')(dface(i,notoklist(iw)),i=1,3)
          call ZdrcniCisla(pomchar,3)
          call FequestLabelMake(id,5.,il,pomchar,'L')
          call FeQuestCrwMake(id,50.,il,50.,il,' ','L',CrwXd,CrwYd,0,0)
          if(iw.eq.1) nCrwFirst=CrwLastMade
          call FeQuestCrwOpen(CrwLastMade,.false.)
          call FeQuestEdwMake(id,80.,il,95.,il,' ','L',40.,EdwYd,0)
          if(iw.eq.1) nEdwFirst=EdwLastMade
          call FeQuestRealEdwOpen(EdwLastMade,getmaxd(notoklist(iw)),
     1                            .false.,.false.)
2210    continue
        icont=0
2240    call FeQuestEvent(id,icont,ich)
        icont=1
        if(CheckType.ne.0) then
          call NebylOsetren
          go to 2240
        endif
2260    if(ich.eq.0) then
          ctipl=.false.
          nCrw=nCrwFirst
          nEdw=nEdwFirst
          do 2280iw=1,NotOKNr
            if(CrwLogicQuest(nCrw)) then
              if(NotOKList(nCrw).lt.nfaces) then
                do 2270i=NotOkList(nCrw)+1,nfaces
                  call CopyVek(dface(1,i),dface(1,i-1),4)
2270            continue
                do 2278i=iw,NotOkNr
                  NotOKList(i)=NotOkList(i)-1
2278            continue
              endif
              nfaces=nfaces-1
            else
              call FeQuestRealFromEdw(nEdw,dface(4,NotOKList(iw)))
            endif
            nCrw=nCrw+1
            nEdw=nEdw+1
2280      continue
        endif
        call FeQuestRemove(id)
      else
        PocetHran=0
        do 2500i=1,PocetBodu-1
          do 2400j=i+1,PocetBodu
            n=0
            BodHr(i,j)=0
            do 2300k=1,nfaces
              if(BodRov(i,k).and.BodRov(j,k)) then
                n=n+1
                if(n.gt.1) then
                  BodHr(i,j)=1
                  PocetHran=PocetHran+1
                  go to 2400
                endif
              endif
2300        continue
2400      continue
2500    continue
        do 3000i=1,nfaces
          PocHr=0
          do 2900j=1,PocetBodu-1
            if(BodRov(j,i)) then
              do 2800k=j+1,PocetBodu
                if(BodRov(k,i).and.BodHr(j,k).gt.0) then
                  PocHr=PocHr+1
                  RovHr1(i,PocHr)=j
                  RovHr2(i,PocHr)=k
                endif
2800          continue
            endif
2900      continue
          RovHr1(i,PocHr+1)=0
          RovHr2(i,PocHr+1)=0
3000    continue
        call MorUzavreny(FacesNotOK,ctipl)
      endif
      return
      end
      subroutine MorUzavreny(FacesNotOK,ctipl)
      include 'params.cmn'
      include 'basic.cmn'
      include 'datred.cmn'
      include 'fepc.cmn'
      logical FacesNotOK,ctipl
      character*50 t50
      if(nfaces+PocetBodu.ne.PocetHran+2) then
        write(t50,'(''Number of faces : '',i3,'', points : '',i3,
     1              '', edges'',i3 )') nfaces,PocetBodu,PocetHran
        call FeChybne(-1.,-1.,'wrong crystal shape',t50,0,SeriousError)
        FacesNotOK=.true.
        ctipl=.true.
      endif
      return
      end
      function GetMaxd(facenr)
      include 'params.cmn'
      include 'basic.cmn'
      include 'datred.cmn'
      include 'fepc.cmn'
      integer facenr
      dmin=999999999.
      do 1000i=1,PocetBodu
        dmin=min(dmin,abs(scalmul(krov(1,facenr),bod(1,i))+
     1           krov(4,facenr)))
1000  continue
      getmaxd=krov(4,facenr)*0.996-dmin
      return
      end
      subroutine MorDelejRotMat(uh,s)
      include 'params.cmn'
      include 'basic.cmn'
      include 'datred.cmn'
      include 'fepc.cmn'
      dimension protmat(3,3),protmat2(3,3),s(3)
      real jmcs
      csuh=cos(uh*torad)
      snuh=sin(uh*torad)
      jmcs=1.-csuh
      protmat(1,1)=csuh+jmcs*s(1)**2
      protmat(1,2)=-snuh*s(3)+jmcs*s(1)*s(2)
      protmat(1,3)=snuh*s(2)+jmcs*s(1)*s(3)
      protmat(2,1)=snuh*s(3)+jmcs*s(2)*s(1)
      protmat(2,2)=csuh+jmcs*s(2)**2
      protmat(2,3)=-snuh*s(1)+jmcs*s(2)*s(3)
      protmat(3,1)=-snuh*s(2)+jmcs*s(3)*s(1)
      protmat(3,2)=snuh*s(1)+jmcs*s(3)*s(2)
      protmat(3,3)=csuh+jmcs*s(3)**2
      call multm(protmat,rotmat,protmat2,3,3,3)
      do 1100i=1,3
        do 1000 j=1,3
          rotmat(i,j)=protmat2(i,j)
1000    continue
1100  continue
      return
      end
      subroutine MorShowVect(vect,popis,barva)
      include 'params.cmn'
      include 'basic.cmn'
      include 'datred.cmn'
      include 'fepc.cmn'
      dimension vect(3)
      character*(*) popis
      integer barva
      call FeLineType(DashedLine)
      xu(1)=XCenAcWin
      yu(1)=YCenAcWin
      berle=.5*(XLenAcWin*.5-7.)/VecOrtLen(vect,3)
      xu(2)=vect(1)*berle+XCenAcWin
      yu(2)=vect(2)*berle+YCenAcWin
      call FePolyLine(2,xu,yu,barva)
      soupopx=vect(1)*berle*1.05+XCenAcWin
      soupopy=vect(2)*berle*1.05+YCenAcWin
      if(popis.ne.' ') call FeOutSt(0,soupopx,soupopy,popis,'C',barva)
      call FeLineType(NormalLine)
      return
      end
      subroutine MorVymackniButtony(nButtFirst,nButtonLast,nButt)
      include 'const.cmn'
      include 'fepc.cmn'
      do 1000i=nButtFirst,nButtonLast
        if(i.eq.nButt) then
          call FeQuestButtonOn(i)
        else
          call FeQuestButtonOff(i)
        endif
1000  continue
      return
      end
      subroutine MorRotujKrystal
      include 'params.cmn'
      include 'basic.cmn'
      include 'datred.cmn'
      do 1000 i=1,PocetBodu
        call multm(RotMat,bod(1,i),rbod(1,i),3,3,1)
1000  continue
      do 1100i=1,nfaces
        call multm(RotMat,krov(1,i),rkrov(1,i),3,3,1)
1100  continue
      do 1200i=1,3
        call multm(RotMat,Axis(1,i),RAxis(1,i),3,3,1)
1200  continue
      return
      end
      subroutine MorTransVec(Recip,Vektor)
      include 'params.cmn'
      include 'basic.cmn'
      logical Recip
      dimension Vektor(3),pomv(3)
      if(Recip) then
        call multm(MetTensI(1,1,KPhase),Vektor,pomv,3,3,1)
      else
        call CopyVek(Vektor,pomv,3)
      endif
      call multm(TrToOrtho(1,1,KPhase),pomv,Vektor,3,3,1)
      call VecOrtNorm(Vektor,3)
      return
      end
      subroutine PrfShow
      include 'params.cmn'
      include 'basic.cmn'
      include 'fepc.cmn'
      include 'datred.cmn'
      include 'profil.cmn'
      character*8 jmena(11)
      data jmena/'%Quit','%Print','%Save','%Next','%Back','%Go to',
     1           '%Indices','Poin%ts','%Cut','%Reset','%Options'/
      StBPBo(1)=' '
      StBPBo(2)=' '
      NNew=0
      IntFromProfile=.true.
      id=NextQuestId()
      call FeQuestAbsCreate(id,0.,0.,XMaxBasWin,YMaxBasWin,' ',0,0,-1,
     1                      -1)
      call FeMakeGrWin(0.,40.,14.,0.)
      call FeBottomInfo('#prazdno#')
      call FeMakeAcWin(25.,10.,15.,14.)
      xbpb(1)=XMinAcWin
      xbpb(2)=XMaxAcWin
      xmsg=XCenAcWin
      ybpb=YBottomText
      call UnitMat(F2O,3)
      call OpenFile(95,fln(:ifln)//'.m95','formatted','old')
      if(ErrJana.ne.0) go to 9500
      xpom=XMaxGrWin+4.
      dpom=XMaxBasWin-XMaxGrWin-8.
      ypom=YMaxGrWin-30.
      do 1100i=1,11
        call FeQuestAbsButtonMake(id,xpom,ypom,dpom,ButYd,Jmena(i))
        call FeQuestButtonOpen(ButtonLastMade,ButtonOff)
        if(i.eq.3.or.i.eq.7.or.i.eq.10) then
          ypom=ypom-15.
        else
          ypom=ypom-10.
        endif
1100  continue
      call FeClearGrWin
      call PrfOptions
      nref=0
      ie=4
2000  ich=0
      nrefo=nref
      if(ie.eq.1) then
        call FeQuestButtonOff(1)
        call FeQuestRemove(id)
        go to 9000
      else if(ie.eq.4) then
        if(nref.ge.nref95) then
          ie=-1
          go to 3000
        endif
        nref=nref+1
      else if(ie.eq.5) then
        if(nref.le.1) then
          ie=-1
          go to 3000
        endif
        nref=nref-1
      else if(ie.eq.6) then
        call GoToRef(nref,1,nref95,ich)
      else if(ie.eq.7) then
        call GoToIndices(nref,ich)
      else if(ie.eq.11) then
        call PrfOptions
      endif
      if(ich.ne.0) then
        call FeQuestButtonOff(ie)
        nref=nrefo
        ie=4
      endif
      if(nref.ge.nref95) then
        call FeQuestButtonDisable(4)
      else
        call FeQuestButtonOff(4)
      endif
      if(nref.le.1) then
        call FeQuestButtonDisable(5)
      else
        call FeQuestButtonOff(5)
      endif
3000  call EditProfile(nref,ie)
      go to 2000
9000  pom=0.
      do 9100i=1,2
        if(StBPBo(i).eq.' ') go to 9100
        call FeRewriteString(0,xbpb(i),ybpb,StBPBo(i),' ','C',LightGray,
     1                       Black)
9100  continue
      ich=0
      go to 9999
9500  call FeChybne(-1.,-1.,'the file '//'"'//fln(:ifln)//'.m95'//'"',
     1              'cannot be open',0,SeriousError)
      ich=1
9999  call CloseIfOpened(95)
      if(ich.eq.0.and.NNew.gt.0) call DRUpdateM95
      return
      end
      subroutine EditProfile(nref,ie)
      include 'params.cmn'
      include 'basic.cmn'
      include 'fepc.cmn'
      include 'datred.cmn'
      include 'profil.cmn'
      dimension iprf(100),h(3),c(3)
      character*128 Veta,Message
      integer ButtonStateQuest
      if(ie.lt.0) go to 2500
      call IOProfil(nref,0)
      Message=' '
      do 2000i=1,nprof
        iprf(i)=nint(py(i,1))
2000  continue
      call indexx(nprof,iprf,ipor)
      ntrshld=nint(nprof*RatioBS)
      trshld=0.
      do 2010i=1,ntrshld
        trshld=trshld+py(ipor(i),1)
2010  continue
      trshld=trshld/float(ntrshld)
      j=0
      do 2020i=1,nprof
        if(py(i,1)-trshld.gt.strshld*sqrt(py(i,1))) then
          if(j.eq.0) then
            j=1
            k=1
          else if(j.eq.2) then
            j=3
            go to 2030
          else
            k=k+1
          endif
        else
          if(j.eq.1) j=2
        endif
2020  continue
2030  if(j.eq.3.and.CheckSplit) then
        Message='Split!!!'
        go to 2090
      endif
      if(k.gt.nint(float(nprof)*RatioPS).and.CheckBroad) then
        Message='Broad!!!'
        go to 2090
      endif
2090  continue
      odf=(omx-omn)/float(nprof)
      omp=omn
      omk=omx
      do 2110i=1,3
        h(i)=ih(i)
2110  continue
      call multm(ub,h,c,3,3,1)
      pom=c(1)**2+c(2)**2
      chip=atan2(c(3),sqrt(pom))/torad
      fip=atan2(-c(1),c(2))/torad
      pom=sqrt(pom+c(3)**2)
      thp=asin(.5*LamAve(1)*pom)/torad
      OmZnak(1)=thp+asin(-sin((fi-fip)*torad)*cos(chip*torad))/torad
     1          -omega+theta
      s1=0.
      s2=0.
      do 2100i=1,nprof
        px(i)=omp+odf*float(i-1)
        s1=s1+py(i,1)*px(i)
        s2=s2+py(i,1)
2100  continue
      xteziste=s1/s2
      if(abs(xteziste-OmZnak(1)).gt.DevLim.and.Message.eq.' '.and.
     1   CheckDeviated) Message='Deviated!!!'
      if(JenSpatne.and.(ie.eq.4.or.ie.eq.5).and.Message.eq.' ')
     1  go to 9999
      px(nprof)=omk
      write(Veta,'(6i4)')(ih(i),i=1,ndim)
      call ZdrcniCisla(Veta,ndim)
      do 2150i=1,idel(Veta)
        if(Veta(i:i).eq.' ') Veta(i:i)=','
2150  continue
      write(Cislo,'(''Ref.#'',i6)') nref
      call Zhusti(Cislo)
      Veta=Cislo(:idel(Cislo))//' ('//Veta(:idel(Veta))//')'
      yomn=0.
      yomx=0.
      do 2210j=1,2
        do 2200i=1,nprof
          yomx=amax1(yomx,py(i,j))
2200    continue
2210  continue
      xomn=omp
      xomx=omk
      call FeSetTransXo2X(xomn,xomx,yomn,yomx,.false.)
      call KresliProfil(Veta,xomn,xomx,yomn,yomx,Message)
      if(ButtonStateQuest(ie).ne.ButtonDisabled)
     1  call FeQuestButtonOff(ie)
      HardCopy=0
2500  call FeEvent(0)
      if(EventType.ne.1) go to 2500
      ie=EventNumber
      call FeQuestButtonOn(ie)
      if(ie.eq.2.or.ie.eq.3) then
        if(ie.eq.2) then
          HardCopy=-PrintStyle
        else
          call FeSavePicture('profile',4)
          if(HardCopy.lt.0) HardCopy=0
        endif
        if((HardCopy.ge.1.and.HardCopy.le.5).or.HardCopy.lt.0)
     1     call KresliProfil(Veta,xomn,xomx,yomn,yomx,Message)
        call FeQuestButtonOff(ie)
        go to 2500
      else if(ie.eq.8) then
        ipom=0
        call FeMouseShape(0)
        AllowChangeMouse=.false.
        TakeMouseMove=.true.
3000    call FeEvent(0)
        if(EventType.eq.EventMouse.and.EventNumber.eq.JeLeftDown) then
          if(ipom.ne.0) then
            call FePolyLine(m,xu(i1),yu(i1),Green)
            do 3001i=i1,i2
              call FeCircle(xu(i),yu(i),1.2,Green)
3001        continue
            if(ipom.ne.1) yu(1)=pyu(ipom-1,1)
            yu(2)=pyu(ipom,1)
            if(ipom.ne.nprof) yu(3)=pyu(ipom+1,1)
            call FePolyLine(m,xu(i1),yu(i1),White)
            do 3002i=i1,i2
              call FeCircle(xu(i),yu(i),1.2,White)
3002        continue
            ipom=0
          else
            do 3010ipom=1,nprof
              if(sqrt((pxu(ipom)-xpos)**2+(pyu(ipom,2)-ypos)**2).le.1.)
     1          then
                if(ipom.gt.1.and.ipom.lt.nprof) then
                  i1=1
                  i2=3
                  m=3
                else if(ipom.eq.1) then
                  i1=2
                  i2=3
                  m=2
                else if(ipom.eq.nprof) then
                  i1=1
                  i2=2
                  m=2
                endif
                if(ipom.ne.1) then
                  xu(1)=pxu(ipom-1)
                  yu(1)=pyu(ipom-1,2)
                endif
                xu(2)=pxu(ipom)
                yu(2)=pyu(ipom,2)
                if(ipom.ne.nprof) then
                  xu(3)=pxu(ipom+1)
                  yu(3)=pyu(ipom+1,2)
                endif
                call FeCircle(xu(2),yu(2),1.2,Black)
                call FePolyLine(m,xu(i1),yu(i1),Black)
                if(ipom.ne.1) yu(1)=pyu(ipom-1,1)
                yu(2)=pyu(ipom,1)
                if(ipom.ne.nprof) yu(3)=pyu(ipom+1,1)
                call FeCircle(xu(2),yu(2),1.2,White)
                call FePolyLine(m,xu(i1),yu(i1),White)
                if(ipom.ne.1) yu(1)=pyu(ipom-1,2)
                yu(2)=pyu(ipom,2)
                if(ipom.ne.nprof) yu(3)=pyu(ipom+1,2)
                call FePlotMode('E')
                call FeCircle(xu(2),yu(2),1.2,Green)
                call FePolyLine(m,xu(i1),yu(i1),Green)
                call FePlotMode('N')
                go to 3000
              endif
3010        continue
            ipom=0
          endif
        else if(EventType.eq.EventMouse.and.EventNumber.eq.JeMove.and.
     1          ipom.ne.0) then
          call FePlotMode('E')
          call FeCircle(xu(2),yu(2),1.2,Green)
          call FePolyLine(m,xu(i1),yu(i1),Green)
          if(abs(xu(2)-xpos).gt.1.) call FEMoveMouseTo(xu(2),ypos)
          yu(2)=ypos
          pyu(ipom,2)=yu(2)
          py(ipom,2)=FeY2Yo(yu(2))
          call FeCircle(xu(2),yu(2),1.2,Green)
          call FePolyLine(m,xu(i1),yu(i1),Green)
          call FePlotMode('N')
        else if(EventType.eq.EventMouse.and.EventNumber.eq.JeRightDown)
     1    then
          go to 4500
        endif
        go to 3000
      else if(ie.eq.9) then
        ipom=0
        call FeMouseShape(0)
        AllowChangeMouse=.false.
        TakeMouseMove=.true.
4000    call FeEvent(0)
        if(EventType.eq.EventMouse.and.EventNumber.eq.JeLeftDown) then
          if(ipom.lt.2) then
            do 4010i=1,nprof
              if(sqrt((pxu(i)-xpos)**2+(pyu(i,2)-ypos)**2).le.1.) then
                ipom=ipom+1
                if(ipom.eq.1) then
                  i1=i
                else
                  i2=i
                endif
                xu(ipom)=pxu(i)
                yu(ipom)=pyu(i,2)
                if(ipom.eq.2) call FePlotMode('E')
                call FeCircle(xu(ipom),yu(ipom),1.2,Green)
                if(ipom.eq.2) then
                  call FePolyLine(2,xu,yu,Green)
                  call FePlotMode('N')
                endif
              endif
4010        continue
          else
            call FeCircle(xu(1),yu(1),1.2,Green)
            call FeCircle(xu(2),yu(2),1.2,Green)
            call FePolyLine(2,xu,yu,Green)
            sklon=(yu(2)-yu(1))/(xu(2)-xu(1))
            yu1=yu(1)
            xu1=xu(1)
            if(i2.gt.i1) then
              j=1
            else
              j=-1
            endif
            do 4050i=i1,i2,j
              pyu(i,2)=yu1+sklon*(pxu(i)-xu1)
              call FeCircle(pxu(i),pyu(i,2),1.2,Green)
              py(i,2)=FeY2Yo(pyu(i,2))
4050        continue
            ipom=0
          endif
        else if(EventType.eq.EventMouse.and.EventNumber.eq.JeMove.and.
     1          ipom.eq.2) then
          call FePlotMode('E')
          call FeCircle(xu(2),yu(2),1.2,Green)
          call FePolyLine(2,xu,yu,Green)
          if(abs(xu(2)-xpos).gt.1.) call FEMoveMouseTo(xu(2),ypos)
          yu(2)=ypos
          call FeCircle(xu(2),yu(2),1.2,Green)
          call FePolyLine(2,xu,yu,Green)
          call FePlotMode('N')
        else if(EventType.eq.EventMouse.and.EventNumber.eq.JeRightDown)
     1    then
          go to 4500
        endif
        go to 4000
      else if(ie.eq.10) then
        call CopyVek(py(1,1),py(1,2),nprof)
        call KresliProfil(Veta,xomn,xomx,yomn,yomx,Message)
        call IOProfil(nref,1)
      else if(ie.eq.3) then
        call KresliProfil(Veta,xomn,xomx,yomn,yomx,Message)
      else
        EventType=EventButton
        EventNumber=ie
        call FeQuestButtonOn(ie)
        go to 9000
      endif
      go to 5000
4500  TakeMouseMove=.false.
      call bpb(rip(2),rsp(2),2,nbckg)
      write(StBPB(2),101) nint(rip(2)),nint(rsp(2))
      call Zhusti(StBPB(2))
      call FeRewriteString(0,xbpb(2),ybpb,StBPBo(2),StBPB(2),'C',
     1                     LightGray,Black)
      StBPBo(2)=StBPB(2)
      call IOProfil(nref,1)
5000  call FeQuestButtonOff(ie)
      go to 2500
9000  call FeOutSt(0,xmsg,ybpb,Message,'C',LightGray)
9999  return
101   format(i10,'(',i10,')')
      end
      subroutine KresliProfil(Text,xomn,xomx,yomn,yomx,Message)
      include 'params.cmn'
      include 'basic.cmn'
      include 'fepc.cmn'
      include 'profil.cmn'
      integer Color
      character*(*) Text,Message
      call FeClearGrWin
      call FeHardCopy(HardCopy,'open',ich)
      if(ich.ne.0) go to 9000
      call FeOutSt(0,XCenAcWin,(YMaxAcWin+YMaxGrWin)*.5,Text,'C',White)
      call FeMakeAcFrame
      call FeMakeAxisLabels(1,xomn,xomx,yomn,yomx,'Omega')
      call FeMakeAxisLabels(2,yomn,yomx,xomn,xomx,'I')
      call FeXYPlot(px,py(1,2),nprof,NormalLine,NormalPlotMode,Green)
      call FeXYPlot(px,py,nprof,NormalLine,NormalPlotMode,White)
      xu(1)=XMinAcWin
      yu(1)=FeYo2Y(trshld)
      xu(2)=XMaxAcWin
      yu(2)=yu(1)
      call FeLineType(DashedLine)
      if(yu(1).le.YMaxAcWin) call FePolyline(2,xu,yu,Red)
      yu(1)=YMinAcWin
      xu(1)=FeXo2X(xteziste)
      yu(2)=YMaxAcWin
      xu(2)=xu(1)
      call FePolyline(2,xu,yu,Red)
      call FeLineType(NormalLine)
      do 2250i=1,2
        call bpb(rip(i),rsp(i),i,NBckg)
        write(StBPB(i),101) nint(rip(i)),nint(rsp(i))
        call Zhusti(StBPB(i))
        call FeRewriteString(0,xbpb(i),ybpb,StBPBo(i),StBPB(i),'C',
     1                       LightGray,Black)
        StBPBo(i)=StBPB(i)
2250  continue
      call FeOutSt(0,xmsg,ybpb,Message,'C',Black)
      do 2300i=1,nprof
        pxu(i)=FeXo2X(px(i))
        pyu(i,1)=FeYo2Y(py(i,1))
        pyu(i,2)=FeYo2Y(py(i,2))
        call FeCircle(pxu(i),pyu(i,2),1.2,Green)
        call FeCircle(pxu(i),pyu(i,1),1.2,White)
2300  continue
      ypom=YMinAcWin-1.
      yu(1)=ypom
      yu(2)=ypom-3.
      yu(3)=ypom-3.
      do 2400i=1,2
        if(OmZnak(i).lt.px(1).or.OmZnak(i).gt.px(nprof)) go to 2400
        xpom=FeXo2X(OmZnak(i))
        xu(1)=xpom
        xu(2)=xpom-3.
        xu(3)=xpom+3.
        if(i.eq.2) then
          Color=Red
        else if(i.eq.4) then
          Color=Green
        else
          Color=Yellow
        endif
        call FeFillPolygon(xu,yu,3,4,0,0,Color)
2400  continue
      call FeHardCopy(HardCopy,'close',ich)
      HardCopy=0
9000  return
101   format(i10,'(',i10,')')
      end
      subroutine GoToIndices(nref,ich)
      include 'params.cmn'
      include 'basic.cmn'
      include 'datred.cmn'
      include 'fepc.cmn'
      include 'profil.cmn'
      dimension ihr(6)
      logical eqiv
      id=NextQuestId()
      call FeQuestCreate(id,-1.,-1.,120.,0,1,
     1                   'Indices of the reflection to be drawn',1,
     2                   LightGray,0,0)
      call FeQuestEdwMake(id,0.,0,30.,1,' ','C',60.,EdwYd,0)
      nEdw=EdwLastMade
      call FeQuestIntAEdwOpen(EdwLastMade,ih,ndim,.true.)
      icont=0
1500  call FeQuestEvent(id,icont,ich)
      icont=1
      if(CheckType.eq.EventButton.and.CheckNumberAbs.eq.ButtonOk) then
        call FeQuestIntAFromEdw(nEdw,ihr)
        rewind 95
        call PrvniM95(ich)
        do 2000i=1,nref95
          call DRGetReflectionFromM95(95,iend,ich)
          if(iend.ne.0) go to 2100
          if(eqiv(ih,ihr,ndim)) then
            nref=i
            QuestCheck(id)=0
            go to 1500
          endif
2000    continue
2100    call FeChybne(-1.,-1.,'Reflecion not found, try again',' ',0,
     1                SeriousError)
        call FeButtonOff(ButtonOk)
        EventType=EventEdw
        EventNumber=nEdw
        go to 1500
      else if(CheckType.ne.0) then
        call NebylOsetren
        go to 1500
      endif
      call FeQuestRemove(id)
      return
      end
      subroutine GoToRef(nr,nrmin,nrmax,ich)
      include 'params.cmn'
      include 'basic.cmn'
      include 'fepc.cmn'
      id=NextQuestId()
      call FeQuestCreate(id,-1.,-1.,110.,0,1,
     1                   'Next reflection to be drawn',0,LightGray,0,0)
      call FeQuestEudMake(id,0.,0,40.,1,' ','C',30.,EdwYd,0)
      nEdw=EdwLastMade
      call FeQuestIntEdwOpen(EdwLastMade,nr,.false.)
      call FeQuestEudOpen(EdwLastMade,nrmin,nrmax,1,pom,pom,pom)
      icont=0
1500  call FeQuestEvent(id,icont,ich)
      icont=1
      if(CheckType.ne.0) then
        call NebylOsetren
        go to 1500
      endif
      if(ich.eq.0) call FeQuestIntFromEdw(nEdw,nr)
      call FeQuestRemove(id)
      return
      end
      subroutine BPB(ri,rs,k,nb)
      include 'params.cmn'
      include 'basic.cmn'
      include 'profil.cmn'
      B=0.
      P=0.
      do 1000i=1,nprof
        if(i.le.nb.or.i.ge.nprof-nb+1) then
          B=B+py(i,k)
        else
          P=P+py(i,k)
        endif
1000  continue
      r=float((nprof-2*nb))/float((2*nb))
      ri=(P-B*r)*rych
      rs=sqrt(P+B*r**2)*rych
      return
      end
      subroutine IOProfil(nref,klic)
      include 'params.cmn'
      include 'basic.cmn'
      include 'datred.cmn'
      include 'profil.cmn'
      logical eqiv,Change
      rewind 95
      call PrvniM95(ich)
      do 1000i=1,nref
        call DRGetReflectionFromM95(95,iend,ich)
        if(iend.ne.0.or.ich.ne.0) go to 9999
1000  continue
      do 1050i=1,NNew
        if(NRefNew(i).eq.NRef) then
          call CopyVekI(IProfNew(1,i),IProf(1,2),NProf)
          go to 1060
        endif
1050  continue
1060  if(klic.eq.0) then
        hh1=ih(1)
        hh2=ih(2)
        hh3=ih(3)
        sinthl=sqrt(hh1**2*prcp(1,1,KPhase)+hh2**2*prcp(2,1,KPhase)+
     1              hh3**2*prcp(3,1,KPhase)+hh1*hh2*prcp(4,1,KPhase)+
     2              hh1*hh3*prcp(5,1,KPhase)+hh2*hh3*prcp(6,1,KPhase))
        thi=asin(sinthl*LamAve(1))/torad
        do 1100i=1,nprof
          py(i,1)=IProf(i,1)
          py(i,2)=IProf(i,2)
1100    continue
      else
        Change=.false.
        do 2100i=1,nprof
          j=IProf(i,2)
          IProf(i,2)=nint(py(i,2))
          Change=Change.or.j.ne.IProf(i,2)
2100    continue
        if(eqiv(IProf(1,1),IProf(1,2),NProf)) then
          if(KProf.eq.2) KProf=1
        else
          if(KProf.eq.1) KProf=2
        endif
2200    if(Change) then
          do 2210i=1,NNew
            if(NRefNew(i).eq.NRef) go to 2250
2210      continue
          NNew=NNew+1
          i=NNew
2250      call CopyVekI(IProf(1,2),IProfNew(1,i),NProf)
          NRefNew(i)=NRef
        endif
      endif
9999  return
      end
      subroutine DRUpdateM95
      include 'params.cmn'
      include 'basic.cmn'
      include 'datred.cmn'
      include 'profil.cmn'
      ich=0
      call OpenFile(95,fln(:ifln)//'.m95','formatted','old')
      if(ErrJana.ne.0) then
        ich=1
        go to 2000
      endif
      call OpenFile(96,fln(:ifln)//'.l95','formatted','unknown')
      NRef=0
1000  call DRGetReflectionFromM95(95,iend,ich)
      if(ich.ne.0.or.iend.ne.0) go to 2000
      NRef=NRef+1
      do 1100i=1,NNew
        if(NRefNew(i).eq.NRef) then
          call CopyVekI(IProfNew(1,i),IProf(1,2),NProf)
          go to 1200
        endif
1100  continue
1200  call DRPutReflectionToM95(96)
      go to 1000
2000  call CloseIfOpened(95)
      call CloseIfOpened(96)
      if(ich.ne.0) then
        call DeleteFile(fln(:ifln)//'.l95')
      else
        call MoveFile(fln(:ifln)//'.l95',fln(:ifln)//'.m95',.false.)
      endif
      return
      end
      subroutine PrfOptions
      include 'params.cmn'
      include 'basic.cmn'
      include 'profil.cmn'
      include 'fepc.cmn'
      logical CrwLogicQuest,LTrshld
      id=NextQuestId()
      call FeQuestCreate(id,-1.,-1.,180.,0,8,'Profile drawing option',0,
     1                   LightGray,0,0)
      il=1
      call FeQuestCrwMake(id,15.,il,5.,il,'check reflections for '//
     1                    '%splitting','L',CrwXd,CrwYd,1,0)
      nCrwSplit=CrwLastMade
      call FeQuestCrwOpen(nCrwSplit,CheckSplit)
      il=il+1
      call FeQuestCrwMake(id,15.,il,5.,il,'check reflections for '//
     1                    '%broadering','L',CrwXd,CrwYd,1,0)
      nCrwBroad=CrwLastMade
      call FeQuestCrwOpen(nCrwBroad,CheckBroad)
      il=il+1
      xEdw=15.
      tEdw=xEdw+40.
      call FeQuestEdwMake(id,tEdw,il,xEdw,il,'back%ground/scan length '
     1                  //'ratio','L',35.,EdwYd,0)
      nEdwRatioBS=EdwLastMade
      il=il+1
      call FeQuestEdwMake(id,tEdw,il,xEdw,il,'%peak/scan length ratio',
     1                    'L',35.,EdwYd,0)
      nEdwRatioPS=EdwLastMade
      il=il+1
      call FeQuestEdwMake(id,tEdw,il,xEdw,il,'s%ignificant level for '//
     1                    'peak','L',35.,EdwYd,0)
      nEdwSTrshld=EdwLastMade
      if(CheckBroad) call FeQuestRealEdwOpen(nEdwRatioPS,RatioPS,
     1                                       .false.,.true.)
      if(CheckSplit.or.CheckBroad) then
        call FeQuestRealEdwOpen(nEdwRatioBS,RatioBS,.false.,.true.)
        call FeQuestRealEdwOpen(nEdwSTrshld,strshld,.false.,.false.)
        LTrshld=.true.
      else
        LTrshld=.false.
      endif
      il=il+1
      call FeQuestCrwMake(id,15.,il,5.,il,'check reflections for '//
     1                    '%displacement','L',CrwXd,CrwYd,1,0)
      nCrwDeviated=CrwLastMade
      call FeQuestCrwOpen(nCrwDeviated,CheckDeviated)
      il=il+1
      call FeQuestEdwMake(id,tEdw,il,xEdw,il,'maximal %omega difference'
     1                   ,'L',35.,EdwYd,0)
      nEdwDeviated=EdwLastMade
      if(CheckDeviated) call FeQuestRealEdwOpen(nEdwDeviated,DevLim,
     1                                          .false.,.false.)
      il=il+1
      call FeQuestCrwMake(id,15.,il,5.,il,'Next/Back concerns only '//
     1                    '"s%uspect" reflections','L',CrwXd,CrwYd,0,0)
      nCrwSpatne=CrwLastMade
      call FeQuestCrwOpen(nCrwSpatne,JenSpatne)
1200  icont=0
1500  call FeQuestEvent(id,icont,ich)
      icont=1
      if(CheckType.eq.EventCrw.and.EventNumber.eq.nCrwDeviated) then
        if(CrwLogicQuest(nCrwDeviated)) then
          call FeQuestRealEdwOpen(nEdwDeviated,DevLim,.false.,.false.)
          EventType=EventEdw
          EventNumber=nEdwDeviated
          go to 1500
        else
          call FeQuestEdwClose(nEdwDeviated)
          go to 1200
        endif
      else if(CheckType.eq.EventCrw) then
        if(CrwLogicQuest(nCrwBroad).and.EventNumber.eq.nCrwBroad) then
          call FeQuestRealEdwOpen(nEdwRatioPS,RatioPS,.false.,.true.)
        else
          call FeQuestEdwClose(nEdwRatioPS)
        endif
        if(CrwLogicQuest(nCrwSplit).or.CrwLogicQuest(nCrwBroad)) then
          if(.not.LTrshld) then
            call FeQuestRealEdwOpen(nEdwRatioBS,RatioBS,.false.,.true.)
            call FeQuestRealEdwOpen(nEdwSTrshld,strshld,.false.,.false.)
            EventType=EventEdw
            EventNumber=nEdwRatioBS
            LTrshld=.true.
          endif
          EventType=EventEdw
          EventNumber=nEdwRatioBS
          go to 1500
        else
          if(LTrshld) then
            call FeQuestEdwClose(nEdwRatioBS)
            call FeQuestEdwClose(nEdwSTrshld)
            LTrshld=.false.
          endif
          go to 1200
        endif
      else if(CheckType.ne.0) then
        call NebylOsetren
        go to 1500
      endif
      if(ich.eq.0) then
        CheckSplit=CrwLogicQuest(nCrwSplit)
        CheckBroad=CrwLogicQuest(nCrwBroad)
        CheckDeviated=CrwLogicQuest(nCrwDeviated)
        JenSpatne=CrwLogicQuest(nCrwSpatne)
        if(LTrshld) then
          call FeQuestRealFromEdw(nEdwRatioBS,RatioBS)
          if(CheckBroad) call FeQuestRealFromEdw(nEdwRatioPS,RatioPS)
          call FeQuestRealFromEdw(nEdwSTrshld,strshld)
        endif
        if(CheckDeviated) call FeQuestRealFromEdw(nEdwDeviated,DevLim)
      endif
      call FeQuestRemove(id)
      return
      end
      subroutine SiemensUnCompress(String,k,ic)
      character*(*) String
      character*42 low
      character*52 high
      data low/'0123456789`~!@#$%^&*()-_=+||[{]};:''",<.>/?'/
      data high/'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz'/
      low(28:28)=char(92)
      ic=0
1000  i=index(high,String(k:k))-1
      if(i.ge.0) then
        ic=ic*52+i
        k=k+1
        go to 1000
      endif
      i=index(low,String(k:k))
      ic=ic*42+i-1
      k=k+1
      return
      end
      subroutine SiemensCompress(ic,String)
      character*(*) String
      character*42 low
      character*52 high
      data low/'0123456789`~!@#$%^&*()-_=+|\[{]};:''",<.>/?'/
      data high/'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz'/
      ip=iabs(ic)
      i=mod(ip,42)+1
      String=low(i:i)
      ip=(ip-i+1)/42
1000  if(ip.le.0) return
      i=mod(ip,52)+1
      String=high(i:i)//String
      ip=(ip-i+1)/52
      go to 1000
      end
      subroutine LukSimulace(klic)
      include 'params.cmn'
      include 'basic.cmn'
      include 'datred.cmn'
      include 'fepc.cmn'
      dimension p(6),pv(3)
      integer excode,bq,ButScMinus,ButScPlus,ButDef,ButFitAll,
     1        ButLevPlus,ButLevMinus,ButInt,ButChan,ButEx,
     2        EdwRef,EdwLev,CrwSat,EdwIntQuest
      logical CrwLogicQuest
      cdiam=.true.
      difcol=.true.
      shsat=.true.
      expanded=.false.
      expand=.false.
      ValRead=0
      iv(1)=1
      iv(2)=1
      iv(3)=1
      look=3
      col(1)=63
      col(2)=95
      conv=100.
      call ReadViewDefinition(klic,excode)
      if (excode.ne.0) goto 9999
      bq=NextQuestId()
      CheckMouse=.true.
      call FeQuestAbsCreate(bq,0.,0.,XMaxBasWin,YMaxBasWin,' ',
     1     0,0,-1,-1)
      call FeMakeGrWin(2.,50.,14.,2.)
      call FeFillRectangle(XMaxBasWin-50.,XmaXBasWin,YMinGrWin,
     1     YMaxGrWin,4,0,0,LightGray)

      call MakeBottomInfo
      call FeQuestAbsLabelMake(bq,XMaxBasWin-25.,YMinGrWin+62.,
     1     'base vectors','C')
      call FeQuestAbsLabelMake(bq,XMaxBasWin-25.,YMaxBasWin-39.,
     1     'scale','C')
      call FeQuestAbsButtonMake(bq,xmaxBasWin-43.,ymaxBasWin-42.,7.,
     1     ButYd,'-')
      ButScMinus=ButtonLastMade
      call FeQuestButtonOpen(ButScMinus,ButtonOff)
      call FeQuestAbsButtonMake(bq,xmaxBasWin-14.,YMaxBasWin-42.,7.,
     1     ButYd,'+')
      ButScPlus=ButtonLastMade
      call FeQuestButtonOpen(ButScPlus,ButtonOff)
      call FeQuestAbsButtonMake(bq,xmaxBasWin-40.,ymaxBasWin-30.,
     1     30.,8.,'%Default')
      ButDef=ButtonLastMade
      call FeQuestButtonOpen(ButDef,ButtonOff)
      call FeQuestAbsButtonMake(bq,xmaxBasWin-40.,ymaxBasWin-54.,
     1     30.,8.,'%Fit all')
      ButFitAll=ButtonLastMade
      call FeQuestButtonOpen(ButFitAll,ButtonOff)
      call FeQuestAbsLabelMake(bq,XMaxBasWin-25.,ymaxBasWin-63.,
     1     'level','C')
      call FeQuestAbsButtonMake(bq,xmaxBasWin-43.,ymaxBasWin-75.,7.,
     1     ButYd,'-')
      ButLevMinus=ButtonLastMade
      call FeQuestButtonOpen(ButLevMinus,ButtonOff)
      call FeQuestAbsButtonMake(bq,xmaxBasWin-14.,ymaxBasWin-75.,7.,
     1     ButYd,'+')
      ButLevPlus=ButtonLastMade
      call FeButtonOpen(ButLevPlus,ButtonOff)
      call FeQuestAbsEdwMake(bq,1.,1.,XMaxBasWin-34.,YMaxBasWin-75.,
     1     ' ','L',18.,EdwYd,1)
      EdwLev=EdwLastMade
      call FeQuestIntEdwOpen(EdwLev,lev,.false.)
      call FeQuestAbsEdwMake(bq,1.,1.,XMaxGrWin-75.,YMinBasWin+3.,
     1     ' ','L',75.,EdwYd,1)
      EdwRef=EdwLastMade
      call FeQuestStringEdwOpen(EdwRef,' ')
      call FeQuestAbsButtonMake(bq,XMaxBasWin-45.,YMaxBasWin-95.,40.,
     1     8.,'%Change view')
      ButChan=ButtonLastMade
      call FeQuestButtonOpen(ButChan,ButtonOff)
      call FeQuestAbsButtonMake(bq,XMaxBasWin-45.,YMaxBasWin-110.,40.,
     1     8.,'%Intensities')
      ButInt=ButtonLastMade
      call FeQuestButtonOpen(ButInt,ButtonOff)
      call FeQuestAbsButtonMake(bq,XMaxBasWin-37.5,YMinGrWin+10.,25.,
     1     8.,'%Exit')
      ButEx=ButtonLastMade
      call FeQuestButtonOpen(ButEx,ButtonOff)
      if (ndim.gt.3) then
        call FeQuestAbsCrwMake(bq,XMaxBasWin-37.,YMaxBasWin-121.,
     1       XMaxBasWin-45.,YMaxBasWin-123.,'Satelites','L',
     2       CrwXd,CrwYd,1,0)
        CrwSat=CrwLastMade
        call FeQuestCrwOpen(CrwSat,shsat)
      else
        shsat=.false.
      endif
      call LukOsnova
      call LukSit
      call ShowActIndices(EdwRef)
      call FeMouseShape(0)
3100  icont=0
3101  call FeQuestEvent(bq,icont,ich)
      icont=1
      if (CheckType.eq.EventMouse) then
        if(CheckNumber.eq.JeMove) then
          call ShowActIndices(EdwRef)
        endif
        goto 3100
      endif
      if (CheckType.eq.EventCrw) then
        shsat=CrwLogicQuest(CrwSat)
        call Drawlattice
        call Luksit
        go to 3100
      end if
      if (CheckType.eq.EventEdw) then
        lev=EdwIntQuest(1,EdwLev)
        if (abs(lev).gt.99) then
          call FeChybne(-1.,-1.,'Level specification too large'
     1                  ,' ',0,Warning)
          goto 3100
        else
          call MakeBottomInfo
          call DrawLattice
          call LukSit
          goto 3101
        end if
      end if
      if(CheckType.eq.EventButton) then
        if (CheckNumber.ge.ButScMinus.and.EventNumber.le.ButLevPlus)
     1      then
          call FeButtonOn(CheckNumber)
          if (EventNumber.eq.ButScMinus) then
            conv=conv*0.95
          else if(CheckNumber.eq.ButScPlus) then
            conv=conv*1.05
          else if(CheckNumber.eq.ButDef) then
            conv=100.
          else if(CheckNumber.eq.ButFitAll) then
            vlenmax=0.
            do 3200i=1,izz
              do 3500 k=1,3
                p(k)=ihar(k,i)
                if (ndimi.gt.0) then
                  do 3400 j=4,ndim
                    p(k)=p(k)+qu(k,j,1,KPhase)*ihar(j,i)
3400              continue
                endif
3500          continue
              call prumet(p,iv,pv)
              if (veclen(pv,.true.).gt.vlenmax)
     1            vlenmax=veclen(pv,.true.)
3200        continue
            conv=(YMaxGrWin-YCenGrWin-3)/vlenmax
          else if(Checknumber.eq.ButLevMinus.or.Checknumber.eq.
     1            ButLevPlus) then
            lev=lev+(CheckNumber*2-(ButLevMinus+ButLevPlus))
            if (abs(lev).gt.99) then
              call FeChybne(-1.,-1.,'Level specification too large'
     1                      ,' ',0,Warning)
              EventType=CheckType
              EventNumber=CheckNumber
              goto 3101
            else
              call MakeBottomInfo
              call FeQuestIntEdwOpen(EdwLev,lev,.false.)
            end if
          end if
          call DrawLattice
          call LukSit
          call FeQuestButtonOff(CheckNumber)
        else if (CheckNumber.eq.ButChan) then
          call FeQuestButtonOn(ButChan)
          call ReadViewDefinition(klic,excode)
          if (excode.eq.0) then
            call MakeBottomInfo
            call FeQuestIntEdwOpen(EdwLev,lev,.false.)
            call LukOsnova
            call LukSit
          end if
          call FeButtonOff(ButChan)
        else if (CheckNumber.eq.ButInt) then
          call FeButtonOn(ButInt)
          call QuestInt
          call FeQuestButtonOff(ButInt)
        else if (CheckNumber.eq.ButEx) then
          call FeQuestButtonOn(ButEx)
          call FeQuestRemove(bq)
          go to 9999
        endif
        go to 3100
      endif
      if (CheckType.ne.0) call NebylOsetren
      goto 3100
9999  return
      end
      subroutine QuestInt
      include 'params.cmn'
      include 'basic.cmn'
      include 'datred.cmn'
      include 'fepc.cmn'
      dimension xdr(2),ydr(2),zal(6),lzal(2)
      parameter (bdist=6.)
      character*20 pomtx1,pomtx2
      integer zal,cl
      logical lzal,CrwLogicQuest
      zal(1)=minrcir
      zal(2)=maxrcir
      zal(3)=minrcol
      zal(4)=maxrcol
      zal(5)=col(1)
      zal(6)=col(2)
      lzal(1)=cdiam
      lzal(2)=difcol
      iq=NextQuestId()
      call FeQuestCreate(iq,-1.,-1.,200.,0,15,'Intensities',0,
     1     LightGray,0,0)
      call FeQuestCrwMake(iq,30.,1,20.,1,'Use circle %diameters',
     1     'L',CrwYd,CrwYd,0,0)
      nCrwDiam=CrwLastMade
      call FeQuestCrwOpen(nCrwDiam,cdiam)
      call FeQuestEdwMake(iq,57.,2,30.,2,'and less','L',25.,8.,1)
      nEdwDMin=EdwLastMade
      call FeQuestIntEdwOpen(nEdwDMin,minrcir,.false.)
      call FeQuestEdwMake(iq,57.,11,30.,11,'and more','L',25.,8.,1)
      nEdwDMax=EdwLastMade
      call FeQuestIntEdwOpen(nEdwDMax,maxrcir,.false.)
      call FeQuestCrwMake(iq,120.,1,110.,1,'Use %colors',
     1     'L',CrwYd,CrwYd,0,0)
      nCrwCol=CrwLastMade
      call FeQuestCrwOpen(nCrwCol,difcol)
      call FeQuestEdwMake(iq,147.,2,120.,2,'and less','L',25.,8.,1)
      nEdwCMin=EdwLastMade
      call FeQuestIntEdwOpen(nEdwCMin,minrcol,.false.)
      call FeQuestEdwMake(iq,147.,11,120.,11,'and more','L',25.,8.,1)
      nEdwCMax=EdwLastMade
      call FeQuestIntEdwOpen(nEdwCMax,maxrcol,.false.)
      call FeQuestLineMake(iq,12)
      xdr(1)=(QuestXMax(iq)-QuestXMin(iq))/2-bdist-12.
      xdr(2)=(QuestXMax(iq)-QuestXMin(iq))/2+bdist
      call FeQuestButtonMake(iq,xdr(1),13,12.,ButYd,'prev')
      nButMainPrev=ButtonLastMade
      call FeQuestButtonOpen(nButMainPrev,ButtonOff)
      call FeQuestButtonMake(iq,xdr(2),13,12.,ButYd,'next')
      nButMainNext=ButtonLastMade
      call FeQuestButtonOpen(nButMainNext,ButtonOff)
      call FeQuestButtonMake(iq,xdr(1),14,12.,ButYd,'prev')
      nButSatPrev=ButtonLastMade
      call FeQuestButtonOpen(nButSatPrev,ButtonOff)
      call FeQuestButtonMake(iq,xdr(2),14,12.,ButYd,'next')
      nButSatNext=ButtonLastMade
      call FeQuestButtonOpen(nButSatNext,ButtonOff)
      call FeQuestLabelMake(iq,19.,13,'colors: reflections:','L')
      call FeQuestLabelMake(iq,50.,14,'satelites:','L')
      xdr(1)=(QuestXMax(iq)+QuestXMin(iq))/2-bdist+1.
      xdr(2)=(QuestXMax(iq)+QuestXMin(iq))/2+bdist-1.
      ydr(1)=QuestYMin(iq)+QuestYPosition(iq,13)
      call FeFillRectangle(xdr(1),xdr(2),ydr(1)-ButYd/2-1,
     1     ydr(1)+ButYd/2+1,4,0,0,col(1))
      ydr(1)=QuestYMin(iq)+QuestYPosition(iq,14)
      call FeFillRectangle(xdr(1),xdr(2),ydr(1)-ButYd/2-1,
     1     ydr(1)+ButYd/2+1,4,0,0,col(2))
      do 4100 i=1,10
        ydr(1)=QuestYPosition(iq,i+1)+QuestYMin(iq)
        call FeCircle(39.,ydr(1),float(i)*0.3+0.2,col(1))
4100  continue
      do 4300 i=0,7
        write(pomtx1,'(i6)') 1+minrcir+i*(maxrcir-minrcir)/8
        pomtx2=pomtx1(1:idel(pomtx1))//' - '
        write(pomtx2((idel(pomtx2)+1):),'(i6)')
     1       minrcir+(i+1)*(maxrcir-minrcir)/8
        call FeQuestLabelMake(iq,30.,3+i,pomtx2,'L')
4300  continue
      xdr(1)=125.
      xdr(2)=133.
      ydr(2)=QuestYposition(iq,2)+QuestYMin(iq)
      rpom=(QuestYPosition(iq,3)-QuestYposition(iq,12))/32.
      do 4350 i=1,32
        if (i.lt.17) then
          cl=col(1)+i
        else
          cl=col(1)-32+i
        endif
        ydr(1)=ydr(2)
        ydr(2)=ydr(1)-rpom
        call FeFillRectangle(xdr(1),xdr(2),ydr(1),ydr(2),4,0,0,cl)
4350  continue
      do 4400 i=1,8
        write(pomtx1,'(i6)') 1+minrcol+i*(maxrcol-minrcol)/9
        call FeQuestLabelMake(iq,120.,2+i,pomtx1,'L')
4400  continue
      icont=0
5000  call FeQuestEvent(iq,icont,ich)
      icont=1
      if (CheckType.eq.EventEdw) then
        if (CheckNumber.eq.nEdwDMin) then
          call FeQuestIntFromEdw(nEdwDMin,minrcir)
          goto 5050
        else if (CheckNumber.eq.nEdwDMax) then
          call FeQuestIntFromEdw(nEdwDMax,maxrcir)
          goto 5050
        else if (CheckNumber.eq.nEdwCMin) then
          call FeQuestIntFromEdw(nEdwCMin,minrcol)
          goto 5060
        else if (CheckNumber.eq.nEdwCMax) then
          call FeQuestIntFromEdw(nEdwCMax,maxrcol)
          goto 5060
        end if
5050    call FeFillRectangle(51.,103.,
     1       QuestYPosition(iq,10)+QuestYMin(iq)-2.,
     2       QuestYPosition(iq,3)+QuestYMin(iq)+2.,4,0,0,lightgray)
        do 5055 i=0,7
          write(pomtx1,'(i6)') 1+minrcir+i*(maxrcir-minrcir)/8
          pomtx2=pomtx1(1:idel(pomtx1))//' - '
          write(pomtx2((idel(pomtx2)+1):),'(i6)')
     1         minrcir+(i+1)*(maxrcir-minrcir)/8
          call FeQuestLabelMake(iq,30.,3+i,pomtx2,'L')
5055    continue
        goto 5000
5060    call FeFillRectangle(140.,167.,
     1       QuestYPosition(iq,10)+QuestYMin(iq)-2.,
     2       QuestYPosition(iq,3)+QuestYMin(iq)+2.,4,0,0,lightgray)
        do 5065 i=1,8
          write(pomtx1,'(i6)') 1+minrcol+i*(maxrcol-minrcol)/9
          call FeQuestLabelMake(iq,120.,2+i,pomtx1,'L')
5065    continue
        goto 5000
      else if (CheckType.eq.EventButton) then
        call FeQuestButtonOn(CheckNumber)
        if (CheckNumber-nButMainPrev.lt.2) then
          k=1
        else
          k=2
        end if
        if (mod(CheckNumber-nButMainPrev,2).eq.0) then
          if (col(k).gt.31) then
            col(k)=col(k)-32
          else
            col(k)=191
          end if
        else
          if (col(k).lt.191) then
            col(k)=col(k)+32
          else
            col(k)=31
          end if
        end if
        xdr(1)=(QuestXMax(iq)+QuestXMin(iq))/2-bdist+1.
        xdr(2)=(QuestXMax(iq)+QuestXMin(iq))/2+bdist-1.
        if (k.eq.1) then
          ydr(1)=QuestYMin(iq)+QuestYPosition(iq,13)
          call FeFillRectangle(xdr(1),xdr(2),ydr(1)-ButYd/2-1,
     1         ydr(1)+ButYd/2+1,4,0,0,col(1))
          xdr(1)=125.
          xdr(2)=133.
          ydr(2)=QuestYPosition(iq,2)+QuestYMin(iq)
          rpom=(QuestYPosition(iq,3)-QuestYposition(iq,12))/32.
          do 5100 i=1,32
            if (i.lt.17) then
              cl=col(1)+i
            else
              cl=col(1)-32+i
            endif
            ydr(1)=ydr(2)
            ydr(2)=ydr(1)-rpom
            call FeFillrectangle(xdr(1),xdr(2),ydr(1),ydr(2),4,0,0,cl)
5100      continue
          do 5200 i=1,10
            ydr(1)=QuestYPosition(iq,i+1)+QuestYMin(iq)
            call FeCircle(39.,ydr(1),float(i)*0.3+0.2,col(1))
5200      continue
        else
          ydr(1)=QuestYMin(iq)+QuestYPosition(iq,14)
          call FeFillRectangle(xdr(1),xdr(2),ydr(1)-ButYd/2-1,
     1         ydr(1)+ButYd/2+1,4,0,0,col(2))
        end if
        call FeQuestButtonOff(CheckNumber)
        EventType=0
        EventNumber=0
        goto 5000
      else if (CheckType.ne.0) then
        call NebylOsetren
        goto 5000
      end if
      cdiam=CrwLogicQuest(nCrwDiam)
      difcol=CrwLogicQuest(nCrwCol)
      call FeQuestRemove(iq)
      if (ich.eq.0) then
        call DrawLattice
        call LukSit
      else
        minrcir=zal(1)
        maxrcir=zal(2)
        minrcol=zal(3)
        maxrcol=zal(4)
        col(1)=zal(5)
        col(2)=zal(6)
        cdiam=lzal(1)
        difcol=lzal(2)
      end if
      return
      end
      subroutine MakeBottomInfo
      include 'params.cmn'
      include 'basic.cmn'
      include 'datred.cmn'
      include 'fepc.cmn'
      character*60 t60
      character*6 levtext,form
      character*15 ValReadTx
      write(t60,'(3i4)') (iv(j),j=1,3)
      call ZdrcniCisla(t60,3)
      if (lev.ge.0.and.lev.lt.10) then
        form='(i1)'
      else if ((lev.ge.10).or.(lev.lt.0.and.lev.gt.-10)) then
        form='(i2)'
      else
        form='(i3)'
      endif
      write(levtext,form) lev
      if (ValRead.le.1) then
        ValReadTx='I'
      else if (ValRead.eq.2) then
        ValReadTx='Fo'
      else if (ValRead.eq.3) then
        ValReadTx='Fc'
      else if (ValRead.eq.4) then
        ValReadTx='(Fo-Fc)/sig(Fo)'
      else if (ValRead.eq.5) then
        ValReadTx='100*(Fo-Fc)/Fc'
      end if
      t60='plane: '//t60(:idel(t60))//'  level:'//
     1         levtext(:idel(levtext))//'  value:'//ValReadTx
      call FeBottomInfo(t60)
      return
      end
      subroutine ShowActIndices(EdwRef)
      include 'params.cmn'
      include 'basic.cmn'
      include 'datred.cmn'
      include 'fepc.cmn'
      logical inwindow
      dimension indshown(3),cinbr(2),cinbi(2)
      character*50 t50
      integer indshown,cinbi,lp,EdwRef
      inwindow=(xpos.le.XMaxGrWin).and.(xpos.ge.XMinGrWin)
      inwindow=inwindow.and.(ypos.le.YMaxGrWin).and.(ypos.ge.YMinGrWin)
      if (inwindow) then
        cinbr(1)=(xpos-xcmov)/xstep-(ypos-ycmov)*
     1              cos(angles(1))/(xstep*sin(angles(1)))
        cinbr(2)=(ypos-ycmov)/(ystep*(sin(angles(1))))
        cinbi(1)=int(cinbr(1)+.5*sgn(cinbr(1)))
        cinbi(2)=int(cinbr(2)+.5*sgn(cinbr(2)))
        do 1000 lp=1,3
          indshown(lp)=bas(lp,1)*cinbi(1)+bas(lp,2)*cinbi(2)+beg(lp)
1000    continue
        if (expand) then
          lp=izzeq
        else
          lp=izz
        endif
        val=0.
        do 1100 i=1,lp
          if (indshown(1).eq.ihar(1,i)) then
            if (indshown(2).eq.ihar(2,i)) then
              if (indshown(3).eq.ihar(3,i)) then
                if (ihar(4,i).eq.0) then
                  val=riar(i)
                  goto 1200
                end if
              end if
            end if
          end if
1100    continue
1200    if (val.eq.0.) then
          write(t50,'(3i4,a3,a7)') (indshown(j),j=1,3),' / ','-------'
        else if (ValRead.eq.1) then
          write(t50,'(3i4,a3,f7.0)') (indshown(j),j=1,3),' / ',val
        else
          write(t50,'(3i4,a3,f7.3)') (indshown(j),j=1,3),' / ',val
        end if
        call FeQuestStringEdwOpen(EdwRef,t50)
      else
        call FeQuestStringEdwOpen(EdwRef,' ')
      endif
9999  return
      end
      subroutine ReadViewDefinition(klic,excode)
      include 'params.cmn'
      include 'basic.cmn'
      include 'datred.cmn'
      include 'fepc.cmn'
      parameter (clm1=9.,clm2=99.)
      character*80 t80
      real p(3),zalvv(3),zaliv(3)
      integer excode,divvv,bmin,rvq
      logical lpom,nacet,CrwLogicQuest
      TakeMouseMove=.false.
      ipom=1
      do 500i=1,3
        zalvv(i)=vv(i)
        vv(i)=0
        zaliv(i)=iv(i)
500   continue
      rvq=NextQuestId()
      call FeQuestCreate(rvq,-1.,-1.,180./klic,0,7+klic,
     1     'View definition',0,LightGray,0,0)
      call FeQuestLabelMake(rvq,clm1,1,'View along:','L')
      call FeQuestCrwMake(rvq,clm1+11.,2,clm1,2,'a','L',7.,7.,1,1)
      nCrwA=CrwLastMade
      call FeQuestCrwOpen(nCrwA,(look.eq.1))
      call FeQuestCrwMake(rvq,clm1+11.,3,clm1,3,'b','L',7.,7.,1,1)
      nCrwB=CrwLastMade
      call FeQuestCrwOpen(nCrwB,(look.eq.2))
      call FeQuestCrwMake(rvq,clm1+11.,4,clm1,4,'c','L',7.,7.,1,1)
      nCrwC=CrwLastMade
      call FeQuestCrwOpen(nCrwC,(look.eq.3))
      call FeQuestCrwMake(rvq,clm1+11.,5,clm1,5,'other:','L',7.,7.,1,1)
      nCrwOther=CrwLastMade
      call FeQuestCrwOpen(nCrwOther,(look.eq.4))
      rpom=clm1+10.+FeTxLength('Other:')
      call FeQuestEdwMake(rvq,rpom,5,rpom,5,' ','L',43.,8.,0)
      nEdwVD=EdwLastMade
      rpom=rpom+5.
      rpom2=rpom+FetxLength('level:x')
      call FeQuestEdwMake(rvq,rpom,3,rpom2,3,'level:','L',17.,8.,0)
      nEdwLev=EdwLastMade
      call FeQuestIntEdwOpen(nEdwLev,lev,.false.)
      if (klic.eq.1) then
        call FeQuestLabelMake(rvq,clm2,1,'Value:','L')
        call FeQuestCrwMake(rvq,clm2+11.,2,clm2,2,'I (M95)','L',7.,7.
     1       ,0,2)
        nCrwI=CrwLastMade
        call FeQuestCrwOpen(nCrwI,(ValRead.le.1))
        call FeQuestCrwMake(rvq,clm2+11.,3,clm2,3,'Fo (M83)','L',7.,7.,
     1       0,2)
        nCrwFo=CrwLastMade
        call FeQuestCrwOpen(nCrwFo,(ValRead.eq.2))
        call FeQuestCrwMake(rvq,clm2+11.,4,clm2,4,'Fc (M83)','L',7.,7.,
     1       0,2)
        nCrwFc=CrwLastMade
        call FeQuestCrwOpen(nCrwFc,(ValRead.eq.3))
        call FeQuestCrwMake(rvq,clm2+11.,5,clm2,5,'(Fo-Fc)/sig(Fo)','L',
     1       7.,7.,0,2)
        nCrwFockus=CrwLastMade
        call FeQuestCrwOpen(nCrwFockus,(ValRead.eq.4))
        call FeQuestCrwMake(rvq,clm2+11.,6,clm2,6,'(Fo-Fc)/Fc','L',
     1       7.,7.,0,2)
        nCrwFockuFc=CrwLastMade
        call FeQuestCrwOpen(nCrwFockuFc,(ValRead.eq.5))
      endif
      call FeQuestLineMake(rvq,7)
      call FeQuestCrwMake(rvq,clm1+9.5,8,clm1,8,
     1     'Equivalent reflections','L',CrwXd,CrwYd,0,0)
      nCrwEq=CrwLastMade
      call FeQuestCrwOpen(nCrwEq,expand)
      if (ndim.gt.3) then
        if (klic.eq.1) then
          call FeQuestCrwMake(rvq,clm2+9.5,8,clm2,8,'Show satelites',
     1         'L',CrwXd,CrwYd,0,0)
        else
          call FeQuestCrwMake(rvq,clm1+9.5,9,clm1,9,'Show satelites',
     1         'L',CrwXd,CrwYd,0,0)
        endif
        nCrwSat=CrwLastMade
        call FeQuestCrwOpen(nCrwSat,shsat)
      endif
800   if (CrwLogicQuest(nCrwOther)) then
        call FeQuestIntAEdwOpen(nEdwVD,iv,3,.false.)
      else
        call FeQuestEdwClose(nEdwVD)
      endif
1000  icont=0
1003  call FeQuestEvent(rvq,icont,ich)
      icont=1
      if(CheckType.eq.EventCrw) then
        goto 800
      else if(CheckType.eq.EventEdw) then
        goto 1003
      else if(CheckType.ne.0) then
        call NebylOsetren
        go to 1003
      endif
      if (ich.eq.0) then
        call FeQuestIntFromEdw(nEdwLev,lev)
        if (abs(lev).gt.99) then
          call FeChybne(-1.,-1.,'Level specification too large'
     1         ,' ',0,Warning)
          goto 1000
        end if
        if (.not.CrwLogicQuest(nCrwOther)) then
          do 1100 i=nCrwA,nCrwC
            if (CrwLogicQuest(i)) then
              look=i-nCrwA+1
              vv(i-nCrwA+1)=1
              iv(i-nCrwA+1)=1
            else
              vv(i-nCrwA+1)=0
              iv(i-nCrwA+1)=0
            end if
1100      continue
        else
          look=4
          call FeQuestIntAFromEdw(nEdwVD,iv)
          ipom=1
          lpom=.false.
          do 1200 i=1,3
            p(i)=float(iv(i))
            if (abs(iv(i)).gt.99) lpom=.true.
            if (iv(i).ne.0) ipom=ipom*iv(i)
1200      continue
          if(veclen(p,.true.).lt..001) then
            call FeChybne(-2.,-1.,'null vector, try again',' ',0,
     1                    SeriousError)
            go to 1000
          endif
          if (lpom) then
            t80='indices must be in the range <-99,99>'
            call FeChybne(-2.,-1.,t80,' ',0,SeriousError)
            go to 1000
          endif
          do 1300 i=1,3
            if (iv(i).ne.0) then
              vv(i)=ipom/iv(i)
            else
              vv(i)=0
            end if
1300      continue
          bmin=vv(1)+vv(2)+vv(3)
          do 1310 i=1,3
            if(vv(i).ne.0) bmin=min(bmin,abs(vv(i)))
1310      continue
          j=1
1320      j=j+1
            divvv=1
            lpom=.true.
            do 1330 i=1,3
              if (mod(vv(i),j).ne.0) lpom=.false.
1330        continue
            if (lpom) then
              divvv=j
              j=j-1
              do 1340 i=1,3
                vv(i)=int(vv(i)/divvv)
1340          continue
            end if
          if (j.lt.bmin) goto 1320
        end if
        if (klic.eq.1) then
          do 1350 i=nCrwI,nCrwFockuFc
            if (CrwLogicQuest(i).and.((i-nCrwI+1).ne.ValRead)) then
              ValRead=i-nCrwI+1
              call ReadValue(nacet)
              goto 1360
            endif
1350      continue
        else
          ValRead=1
          call ReadValue(nacet)
        endif
1360    if (.not.nacet) goto 1000
        if (CrwLogicQuest(nCrwEq)) then
          if (.not.expanded) then
            call GenerEqRef
          endif
          expand=.true.
        else
          expand=.false.
        endif
        if (ndim.gt.3) then
          shsat=CrwLogicQuest(nCrwSat)
          if (shsat) then
            call FeQuestCrwOn(nCrwSat)
          else
            call FeQuestCrwOff(nCrwSat)
          end if
        else
          shsat=.false.
        endif
      else
        do 1400 i=1,3
          vv(i)=zalvv(i)
          iv(i)=zaliv(i)
1400    continue
      endif
      excode=ich
      call FeQuestRemove(rvq)
      call FeMouseShape(0)
      TakeMouseMove=.true.
9999  return
      end
      subroutine ReadValue(nacet)
      include 'params.cmn'
      include 'basic.cmn'
      include 'datred.cmn'
      include 'fepc.cmn'
      character*16 format83
      logical ExistFile, nacet
      write(format83,'(a1,i1,a14)') '(',ndim,'i4,2f9.1,f7.1)'
      nacet=.true.
      expanded=.false.
      rimax=0.
      rimin=50000.
      if(ValRead.eq.1) then
        call iom94(0)
        open(95,file=fln(:ifln)//'.m95')
        call PrvniM95(ich)
        if(ich.ne.0) go to 9999
        call FeFlowChartOpen(-1.,-1.,max(nint(float(nref95)*.005),10),
     1        nref95,'Reading reflections from M95',' ',' ')
      else
        if(existFile(fln(:ifln)//'.m83')) then
          open(83,file=fln(:ifln)//'.m83')
         call FeFlowChartOpen(-1.,-1.,max(nint(float(nref91)*.005),10),
     1          nref91,'Reading reflections from M83',' ',' ')
        else
          call FeChybne(-1.,-1.,'The M83 file does not exist.',
     1         'Create it with REFINE first.',0,SeriousError)
          nacet=.false.
          goto 9999
        endif
      endif
      izz=0
      izc=0
2300  izz=izz+1
2310  continue
      if(ValRead.eq.1) then
        call DRGetReflectionFromM95(95,iend,ich)
        if(iend.ne.0) go to 2350
        if(no.le.0) go to 2310
      else
        read(83,format83,end=2350) (ih(i),i=1,ndim),fo,fc,sig
      endif
      call FeFlowChartEvent(izc,is)
      if(is.ne.0) then
        call FeBudeBreak
        if(ErrJana.ne.0) go to 9999
      endif
      call indtr(ih,trmp,ihar(1,izz),ndim)
      if(ihar(1,izz).gt.900) go to 2310
      if (ValRead.eq.1) then
        riar(izz)=riar(izz)*corrf(1)*corrf(2)
        rsar(izz)=rsar(izz)*corrf(1)*corrf(2)
      else if (Valread.eq.2) then
        riar(izz)=fo
        rsar(izz)=sig
      else if (Valread.eq.3) then
        riar(izz)=fc
        rsar(izz)=sig
      else if (Valread.eq.4) then
        riar(izz)=(fo-fc)/sig
        rsar(izz)=abs(riar(izz))/4
      else if (Valread.eq.5) then
        if (fc.gt.sig) then
          riar(izz)=100.*(fo-fc)/fc
        else
          riar(izz)=0.0
        end if
        rsar(izz)=abs(riar(izz))/4
      endif
      if (abs(riar(izz)).gt.rimax) rimax=abs(riar(izz))
      if ((abs(riar(izz)).lt.rimin).and.(abs(riar(izz)).gt..0005))
     1   rimin=abs(riar(izz))
      go to 2300
2350  izz=izz-1
      call FeFlowChartRemove
      minrcir=int(rimin+(rimax-rimin)/10)
      maxrcir=int(rimax-(rimax-rimin)/10)
      minrcol=minrcir
      maxrcol=maxrcir
      close(95)
      close(83)
9999  return
      end
      subroutine GenerEqRef
      include 'params.cmn'
      include 'basic.cmn'
      include 'datred.cmn'
      include 'fepc.cmn'
      integer ihmax(6),ihpom(6),ihr(6),flchcnt,csym
      expanded=.true.
      izzeq=izz
      if (ValRead.eq.1) then
        call FeFlowChartOpen(-1.,-1.,max(nint(float(nref95)*.005),10),
     1        nref95,'Generating equivalent reflections',' ',' ')
      else
        call FeFlowChartOpen(-1.,-1.,max(nint(float(nref91)*.005),10),
     1        nref91,'Generating equivalent reflections',' ',' ')
      end if
      flchcnt=0
      do 500 i=1,ndim
        ihmax(i)=0
500   continue
      do 600 i=1,izz
        do 700 j=1,ndim
          if (ihar(j,i).gt.ihmax(j)) ihmax(j)=ihar(j,i)
700     continue
600   continue
      do 800 i=1,ndim
        ihr(i)=2*ihmax(i)+1
800   continue
      do 900 i=1,izz
        irecp(i)=IndPack(ihar(1,i),ihr,ihmax,ndim)
900   continue
      do 1000i=1,izz
        call FeFlowChartEvent(flchcnt,is)
        if(is.ne.0) then
          call FeBudeBreak
          if(ErrJana.ne.0) then
            expanded=.false.
            expand=.false.
            go to 9999
          endif
        endif
        do 1100 j=1,ns
          call IndTr(ihar(1,i),rm6(1,j,1,KPhase),ihpom(1),ndim)
          do 1101 csym=1,2
            if (csym.eq.2) then
              do 1110 l=1,ndim
                ihpom(l)=-ihpom(l)
1110          continue
            endif
          ihpompack=IndPack(ihpom,ihr,ihmax,ndim)
          do 1200 k=1,izzeq
            if(ihpompack.eq.irecp(k)) goto 1101
1200      continue
          izzeq=izzeq+1
          do 1400 l=1,ndim
            ihar(l,izzeq)=ihpom(l)
1400      continue
          riar(izzeq)=riar(i)
          rsar(izzeq)=rsar(i)
          irecp(izzeq)=IndPack(ihar(1,i),ihr,ihmax,ndim)
1101    continue
1100    continue
1000  continue
      call FeFlowChartRemove
9999  return
      end
      subroutine LukOsnova
      include 'params.cmn'
      include 'basic.cmn'
      include 'datred.cmn'
      include 'fepc.cmn'
      dimension vvmat(3,3),pomv1(3),xdr(2),ydr(2)
      integer vvmat,par1,par2,divbas
      real koef
      character*20 t20
      logical lpom
      ipom=1
      do 300 k=1,3
        if (vv(k).ne.0) ipom=ipom*vv(k)
300   continue
      do 500 i=1,3
        do 600 j=1,3
          if (i.eq.j) then
              vvmat(i,j)=vv(i)
            else
              vvmat(i,j)=0
            end if
600     continue
500   continue
      nullcnt=0
      do 1000 i=1,3
        if (vv(i).eq.0) nullcnt=nullcnt+1
1000  continue
      if (nullcnt.eq.0) then
        do 1100 i=2,3
          do 1200 j=1,i-1
            do 1300 k=1,3
              if (i.ne.j) then
                bas(k,i+j-2)=float(vvmat(i,k)-vvmat(j,k))
              end if
1300        continue
1200      continue
1100    continue
      else if (nullcnt.eq.1) then
        ipom=1
        do 1400 i=1,3
          if (vv(i).ne.0) then
            do 1500 j=1,i-1
              if (vv(j).ne.0) then
                do 1600 k=1,3
                  bas(k,ipom)=float(vvmat(i,k)-vvmat(j,k))
1600            continue
                ipom=ipom+1
              end if
1500        continue
          else
            do 1700 k=1,3
              if (k.ne.i) then
                bas(k,ipom)=0
              else
                bas(k,ipom)=1
              end if
1700        continue
            ipom=ipom+1
          end if
1400    continue
        bas(1,3)=1000.
      else
        ipom=1
        do 1800 i=1,3
          if (vv(i).eq.0) then
            do 1900 k=1,3
              if (k.ne.i) then
                bas(k,ipom)=0
              else
                bas(k,ipom)=1
              end if
1900        continue
            ipom=ipom+1
          end if
1800    continue
        bas(1,3)=1000.
      end if
      if (bas(1,3).eq.1000.) then
        ipom=2
      else
        ipom=3
      endif
      do 1901 i=1,ipom
        bmin=abs(bas(1,i))+abs(bas(2,i))+abs(bas(3,i))
        do 1910 j=1,3
          if (bas(j,i).ne.0) bmin=min(bmin,abs(bas(j,i)))
1910    continue
        j=1
1920    j=j+1
        divbas=1
        lpom=.true.
        do 1930 k=1,3
          if (abs((int(bas(k,i)/j))-(bas(k,i)/j)).gt..0001)
     1    lpom=.false.
1930    continue
        if (lpom) then
          divbas=j
          j=j-1
        end if
        do 1940 k=1,3
          bas(k,i)=bas(k,i)/divbas
1940    continue
        if (j.lt.bmin) goto 1920
1901  continue
cccccc zajisteni pravotocivosti systemu a orientace bas(2) nahoru
      if (bas(3,2).lt.0) then
        do 2200 i=1,3
          bas(i,2)=-bas(i,2)
2200    continue
      endif
      i=0
2300  i=i+1
      if (vv(i).eq.0) goto 2300
      par1=1
      do 2400 j=1,3
        if (vv(j).ne.0) par1=par1*vv(j)
2400  continue
      par1=par1/vv(i)
      k=mod(i+1,3)
      if (k.eq.0) k=3
      l=mod(i+2,3)
      if (l.eq.0) l=3
      par2=bas(k,1)*bas(l,2)-bas(k,2)*bas(l,1)
      if (par2.eq.-par1) then
        do 2500 i=1,3
          bas(i,1)=-bas(i,1)
2500    continue
      end if
      if (bas(1,3).eq.1000.) then
        j=1
      else
        j=2
      endif
      do 2550 i=1,j
        angles(i)=acos(cosangle(bas(1,1),bas(1,i+1),.true.))
2550  continue
      call DrawLattice
ccccccccc vykresleni base vectors vpravo v menu
c      langle=cosangle(bas(1,1),bas(1,2),.true.)
      call FeFillRectangle(xmaxBasWin-48.,xmaxBasWin,yminGrWin+22.,
     1     yminGrWin+60.,4,0,0,lightgray)
      xwid=xstep-min(0.,abs(ystep)*cos(angles(1)))
      ywid=abs(ystep)*sin(angles(1))
ccc stred pole je XMaxBasWin-24, YMinGrWin+54,vel.48x42,vel obr. 24
      koef=22./max(xwid,ywid)
      xdr(1)=xmaxBasWin-24.-0.5*koef*xwid-koef*
     1       min(0.,abs(ystep)*cos(angles(1)))
      ydr(1)=yminGrWin+52.-koef*ywid
      xdr(2)=xdr(1)+koef*xstep
      ydr(2)=ydr(1)
      call FePolyline(2,xdr,ydr,black)
      xdr(2)=xdr(1)+koef*abs(ystep)*cos(angles(1))
      ydr(2)=ydr(1)+koef*ywid
      call FePolyline(2,xdr,ydr,black)
      write(t20,'(3f3.0)')(bas(i,1),i=1,3)
      call zdrcnicisla(t20,3)
      call FeOutSt(0,xmaxBasWin-24.,yminGrWin+49.-koef*ywid,
     1             t20,'C',Black)
      if (ystep.lt.0) then
        koef=2*cosangle(bas(1,1),bas(1,2),.true.)*
     1       veclen(bas(1,2),.true.)/veclen(bas(1,1),.true.)
        do 2600 i=1,3
          pomv1(i)=koef*bas(i,1)-bas(i,2)
2600    continue
      else
        do 2700 i=1,3
          pomv1(i)=bas(i,2)
2700    continue
      end if
      write(t20,'(3f3.0)')(pomv1(i),i=1,3)
      call zdrcnicisla(t20,3)
      call FeOutSt(0,xmaxBasWin-24.,yminGrWin+55.,t20,'C',Black)
      return
      end
      subroutine DrawLattice
      include 'params.cmn'
      include 'basic.cmn'
      include 'datred.cmn'
      include 'fepc.cmn'
      dimension xdr(2),ydr(2),movv(3)
      real movv
      integer rep,uprange,dnrange
      xmin=XMinGrWin
      xmax=XMaxGrWin
      xcnt=XCenGrWin
      ymin=YMinGrWin
      ymax=YMaxGrWin
      ycnt=YCenGrWin
      if (bas(1,3).eq.1000.) then
        rep=1
      else
        rep=2
      end if
1000  continue
        i=0
5010    i=i+1
          if (vv(i).eq.0) goto 5010
        do 5100 k=1,3
          if (k.eq.i) then
            beg(k)=vv(k)*lev
          else
            beg(k)=0
          end if
5100    continue
      if ((lev.ne.0).and.(nullcnt.ne.2)) then
        if (nullcnt.eq.0) then
cccccc stred site lezi v tezisti trojuhelnika pruseciku os a roviny
          do 5150 k=1,3
            movv(k)= -lev*(2*bas(k,1)+bas(k,3))/3
5150      continue
        else
c stred site lezi mezi obema pruseciky os s rovinou
          do 5200 k=1,3
            movv(k)= beg(k)-0.5*lev*vv(k)
5200      continue
        endif
c uhel jako arccos ma dve moznosti -> vyber te spravne podle dvou
c vektoru
        uh1=acos(cosangle(bas(1,1),movv,.true.))
        uh2=acos(cosangle(bas(1,2),movv,.true.))
        if (uh1.ne.(uh2+angles(1))) then
          uh2=-uh2
          if(uh1.ne.(uh2+angles(1))) then
            uh1=-uh1
          endif
        endif
        delka=veclen(movv,.true.)
        xcmov=xcnt+delka*cos(uh1)*conv
        ycmov=ycnt+delka*sin(uh1)*conv
      else
        xcmov=xcnt
        ycmov=ycnt
        do 5500 i=1,3
          movv(i)=0
5500    continue
      endif
      xstep=veclen(bas(1,1),.true.)*conv
      ystep=veclen(bas(1,2),.true.)*conv
      call FeFillRectangle(xmin,xmax,ymin,ymax,4,0,0,black)
      uprange=nint((ymax-ycmov)/(ystep*sin(angles(1))))
      dnrange=nint((ycmov-ymin)/(ystep*sin(angles(1))))
      do 2300 i=-dnrange,uprange
        xdr(1)=xmin
        xdr(2)=xmax
        ydr(1)=ycmov+i*ystep*sin(angles(1))
        ydr(2)=ydr(1)
        call FePolyLine(2,xdr,ydr,240)
2300  continue
      do 2350 j=1,rep
        if (angles(j).lt.1.5707) then
          tg=tan(angles(j))
          par1=(ycmov-ymin)/tg
          par2=(ymax-ycmov)/tg
        else if (angles(j).gt.1.5708) then
          tg=-tan(3.14159-angles(j))
          par2=(ymin-ycmov)/tg
          par1=(ycmov-ymax)/tg
        else
          tg=1000000.
          par1=0
          par2=0
        end if
        uprange=nint((xmax-xcmov+par1)/xstep)
        dnrange=nint((xcmov-xmin+par2)/xstep)
        do 2400 i=-dnrange,uprange
          ipom=1
          par=(ymax-ycmov)/tg+xcmov+i*xstep
          if ((par.gt.xmin).and.(par.lt.xmax)) then
            xdr(ipom)=par
            ydr(ipom)=ymax
            ipom=2
          endif
          par=(ymin-ycmov)/tg+xcmov+i*xstep
          if ((par.gt.xmin).and.(par.lt.xmax)) then
            xdr(ipom)=par
            ydr(ipom)=ymin
            ipom=2
          endif
          par=tg*(xmin-xcmov-i*xstep)+ycmov
          if ((par.gt.ymin).and.(par.lt.ymax)) then
            ydr(ipom)=par
            xdr(ipom)=xmin
            ipom=2
          endif
          par=tg*(xmax-xcmov-i*xstep)+ycmov
          if ((par.gt.ymin).and.(par.lt.ymax)) then
            ydr(ipom)=par
            xdr(ipom)=xmax
          endif
          call FePolyLine(2,xdr,ydr,240)
2400    continue
2350  continue
      return
      end
      subroutine LukSit
      include 'params.cmn'
      include 'basic.cmn'
      include 'datred.cmn'
      include 'fepc.cmn'
      dimension p(6),pv(3,3)
      integer Colour,tc
      logical sat
      rdmax=3.
      call FeDeferOutput
      xmin=XMinGrWin
      xmax=XMaxGrWin
      xcnt=XCenGrWin
      ymin=YMinGrWin
      ymax=YMaxGrWin
      ycnt=YCenGrWin
      if (shsat.and.(ndim.gt.3)) then
        do 4000 i=1,ndim-3
          call prumet(qu(1,i,1,KPhase),iv,pv(1,i))
4000    continue
      endif
      if (expand) then
        loop=izzeq
      else
        loop=izz
      endif
      do 5000i=1,loop
        sat=.false.
        do 5010 j=1,ndim
          p(j)=ihar(j,i)
5010    continue
        tc=1
        if (ndim.gt.3) then
          do 5020 j=4,ndim
            if (p(j).ne.0) then
              if (.not.shsat) goto 5000
              sat=.true.
              tc=2
            endif
5020      continue
        endif
        do 1010 j=1,3
          p(j)=ihar(j,i)-beg(j)
1010    continue
        q=0
        do 1050 j=1,3
          if (vv(j).ne.0) q=q+p(j)/vv(j)
1050    continue
        if(q.ne.0.) GO TO 5000
ccccccc zajistim prumet satelitu do zobrazovane roviny
        if (sat) then
          do 1120 k=1,3
            do 1130 l=4,ndim
              p(k)=p(k)+pv(k,l-3)*p(l)
1130        continue
1120      continue
        end if
        if(abs(riar(i)).gt.3.*rsar(i)) then
          r=sqrt(abs(riar(i))/rimax)*rdmax
          rpom=(abs(riar(i))-minrcol)/(maxrcol-minrcol)
          if (rpom.lt.0) then
            colour=col(tc)+1
          else if (rpom.gt.1) then
            colour=col(tc)
          else if (rpom.lt..5) then
            colour=col(tc)+2+30*rpom
          else
            colour=col(tc)+30*rpom-30
          end if
          rpom=(abs(riar(i))-minrcir)/(maxrcir-minrcir)
          if (rpom.gt.1) then
            r=3.2
          else
            r=0.5+0.3*8*rpom
          end if
          if (.not.cdiam) r=2.
          if (.not.difcol) colour=col(tc)
        else
          r=rdmax/16.
          Colour=White
        endif
c urcim koeficienty lin. zavislosti: vect.refl=c1*bas(1)+c2*bas(2)
        if (bas(3,2).lt.0) then
          pom=-1.
        else
          pom=1.
        end if
        do 1250 j=1,2
          do 1200 k=j+1,3
            rpom=bas(j,1)*bas(k,2)-bas(k,1)*bas(j,2)
            if (rpom.ne.0) goto 1300
1200      continue
1250    continue
1300	c1=(p(j)*bas(k,2)-p(k)*bas(j,2))/rpom
        c2=(p(k)*bas(j,1)-p(j)*bas(k,1))/rpom
        x1=xcmov+xstep*c1+ystep*pom*c2*cos(angles(1))
        y1=ycmov+ystep*c2*sin(angles(1))
        if (x1.lt.xmax.and.x1.gt.xmin.and.y1.lt.ymax.and.
     1    y1.gt.ymin) then
          if (riar(i).gt.0) then
            call FeCircle(x1,y1,r,Colour)
          else
            rpom=sqrt(3.1415*r*r)/2
            call FeFillRectangle(x1-rpom,x1+rpom,y1-rpom,y1+rpom,
     1                     4,0,0,Colour)
          end if
       endif
5000  continue
      call FeFillRectangle(xmin-rdmax,xmax+rdmax,ymax,ymax+rdmax,
     1                     4,0,0,lightgray)
      call FeFillRectangle(xmin-rdmax,xmax+rdmax,ymin,ymin-rdmax,
     1                     4,0,0,lightgray)
      call FeFillRectangle(xmin-rdmax,xmin-.3,ymax,ymin,4,0,0,lightgray)
      call FeFillRectangle(xmax+.3,xmax+rdmax,ymax,ymin,4,0,0,lightgray)
      call FeReleaseOutput
9999  return
      end
c
      function Sgn(realnum)
      real realnum
      integer s
      if (realnum.gt.0) then
        s=1
      else if (realnum.lt.0) then
        s=-1
      else
        s=0
      end if
      sgn=s
      return
      end
c
      subroutine Prumet(prvect,fii,res)
      include 'params.cmn'
      include 'basic.cmn'
      include 'fepc.cmn'
      dimension prvect(3),fii(3),fir(3),res(3),rsf(3)
      integer fii
      real prvect,fir,rsf,res,koef
      do 100 i=1,3
        fir(i)=float(fii(i))
100   continue
      call multm(fir,MetTens(1,1,KPhase),rsf,1,3,3)
      rpom=veclen(rsf,.true.)
      koef=scalmul(fir,prvect)/(rpom*rpom)
      do 1000 k=1,3
        res(k)=prvect(k)-koef*rsf(k)
1000  continue
      return
      end
      function CosAngle(vect1,vect2,recip)
      include 'params.cmn'
      include 'basic.cmn'
      include 'fepc.cmn'
      dimension vect1(3),vect2(3),pomv1(3)
      real vect1,pomv1,vect2,epom1,epom2,epom3
      logical recip
      if (recip) then
        call multm(vect1,MetTensI(1,1,KPhase),pomv1,1,3,3)
      else
        call multm(vect1,MetTens(1,1,KPhase),pomv1,1,3,3)
      endif
      epom1=scalmul(pomv1,vect2)
      epom2=veclen(vect1,recip)
      epom3=veclen(vect2,recip)
      if (abs(abs(epom1)-(epom2*epom3)).lt.0.00001) then
        cosangle=sgn(epom1)
      else
         cosangle=epom1/(epom2*epom3)
      endif
      return
      end
      function VecLen(vect, recip)
      include 'params.cmn'
      include 'basic.cmn'
      include 'fepc.cmn'
      dimension vect(3), pomv(3)
      real vect, pomv
      logical recip
      if (recip) then
        call multm(vect,MetTensI(1,1,KPhase),pomv,1,3,3)
      else
        call multm(vect,MetTens(1,1,KPhase),pomv,1,3,3)
      endif
      veclen=sqrt(scalmul(vect,pomv))
      return
      end
      subroutine KUMA
      include 'params.cmn'
      parameter (mxrefp=mxref/2)
      include 'basic.cmn'
      include 'fepc.cmn'
      include 'datred.cmn'
      dimension h(3),x(3),hh(3),Rot(3,3),Rko(3,3),ccc(3),DirNozzle(3),
     1          c(3),cc(3),uk(4),iuk(4),hA(3,mxrefp),uhlyk(4),
     2          PsiA(mxrefp),IUkA(mxrefp,4),DiffThA(mxrefp),
     3          DiffAngA(mxrefp),DirFi(3)
      character*80 FileName,Veta
      character*30 Men(5)
      equivalence (scrar,PsiA),(scrar(mxrefp+1),hA),
     1            (scrar(5*mxrefp+1),IUkA)
      integer FeMenu
      logical ExistFile,Append
      data men/'Generuj-psi=0','Generuj-psi optimal','Generuj-pro N2',
     1         'Indexation procedure','Cell refinement'/
      data DirNozzle/.5,.0,.8660254/,DirFi/0.,0.,1./
      call KUMAInit
      ln=0
      lno=0
200   klic=FeMenu(-1.,-1.,men,1,5,1,0)
      if(klic.le.0) go to 9999
      if(Klic.ne.4.and.klic.ne.5) then
        FileName='km4.hkl'
300     call FeReadFileName(FileName,'Define output hkl file','*.hkl',
     1                      ich)
        if(ich.ne.0) go to 9999
        if(ExistFile(FileName)) then
          id=NextQuestId()
          xqd=150.
          il=1
          call FeQuestAbsCreate(id,-1.,-1.,xqd,20.,'The file "'//
     1                          FileName(:idel(FileName))//
     2                          '" already exists.',0,LightGray,-1,-1)

          Veta='%Append'
          ypom=5.
          dpom=FeTxLength(Veta)+10.
          xpom=xqd*.5-dpom*1.5-10.
          do 400i=1,3
            call FeQuestAbsButtonMake(id,xpom,ypom,dpom,ButYd,Veta)
            if(i.eq.1) then
              Veta='%Rewrite'
              nButtAppend=ButtonLastMade
            else if(i.eq.2) then
              nButtRewrite=ButtonLastMade
              Veta='%Cancel'
            endif
            xpom=xpom+dpom+10.
            call FeQuestButtonOpen(ButtonLastMade,ButtonOff)
400       continue
          icont=0
500       call FeQuestEvent(id,icont,ich)
          icont=1
          if(CheckType.eq.EventButton) then
            if(CheckNumber.eq.nButtAppend) then
              Append=.true.
            else if(CheckNumber.eq.nButtRewrite) then
              Append=.false.
            else
              call FeQuestRemove(id)
              go to 300
            endif
            call FeQuestRemove(id)
          else if(CheckType.ne.0) then
            call NebylOsetren
            go to 500
          endif
        else
          Append=.false.
        endif
        lno=NextLogicNumber()
        call OpenFile(lno,FileName,'formatted','unknown')
        if(Append) then
          Veta=fln(:ifln)//'.l99'
          call CopyFile(FileName,Veta)
          ln=NextLogicNumber()
          call OpenFile(ln,Veta,'formatted','unknown')
600       read(ln,FormA80,end=610) Veta
          write(lno,FormA1)(Veta(i:i),i=1,idel(Veta))
          go to 600
610       close(ln,status='delete')
        endif
        ln=0
        call SetIntArrayTo(ih,6,0)
      else
        ln=0
        lno=0
      endif
      if(klic.eq.1) then
        if(ExistM50) then
          call iom50(0,0)
          call ComSym(0,0)
        else
          call FeChybne(-1.,-1.,'m50 not present',' ',0,SeriousError)
          go to 9999
        endif
        call GenerQuest(3,lno)
        if(ErrJana.ne.0) go to 9999
        ln=NextLogicNumber()
        call OpenFile(ln,fln(:ifln)//'.gen','formatted','old')
        if(ErrJana.ne.0) go to 9999
        nn=0
1000    read(ln,Format91,err=2000,end=2000)(ih(i),i=1,ndim)
        if(ih(1).gt.900) go to 2000
        nn=nn+1
        do 1200i=1,3
          h(i)=ih(i)
          do 1100j=1,ndimi
            h(i)=h(i)+qu(i,j,1,KPhase)*float(ih(j+3))
1100      continue
1200    continue
        write(lno,100) h
        go to 1000
2000    write(TextInfo(1),'(i5,'' reflections were generated'')') nn
        Ninfo=1
        call FeInfoOut(-1.,-1.,'INFORMATION')
      else if(klic.eq.2.or.klic.eq.3) then
        if(ExistM94) then
          call iom94(0)
          call iom50(0,0)
        else
          call FeChybne(-1.,-1.,'m94 not present',' ',0,SeriousError)
          go to 9999
        endif
        call GenerQuest(3,lno)
        if(ErrJana.ne.0) go to 9999
        ln=NextLogicNumber()
        call OpenFile(ln,fln(:ifln)//'.gen','formatted','old')
        if(ErrJana.ne.0) go to 9999
        nn=0
5000    read(ln,Format91,err=5600,end=5600)(ih(i),i=1,ndim)
        if(ih(1).gt.900) go to 5600
        do 5100i=1,3
          h(i)=ih(i)
          do 5050j=1,ndimi
            h(i)=h(i)+qu(i,j,1,KPhase)*float(ih(j+3))
5050      continue
5100    continue
        call Multm(ub,h ,c ,3,3,1)
        call AnglesFromHKL(h,0.,uk,Rko,ich)
        nmin=9999
        if(Klic.eq.2) then
          if(ih(4).ne.0.or.ih(5).ne.0) then
            fm=0.
          else
            fm=1.
          endif
          pom=0.
          do 5150i=1,3
            hh(i)=float(ih(i))+qu(i,1,1,KPhase)*fm
            pom=pom+abs(hh(i))
5150      continue
          if(pom.le..001) hh(1)=1.
          call Multm(ub,hh,cc,3,3,1)
          do 5160i=1,3
            ccc(i)=cc(i)-c(i)
5160      continue
          DiffAng=VecOrtScal(c,ccc,3)/(VecOrtLen(c,3)*VecOrtLen(ccc,3))
          if(abs(DiffAng).lt.1.) then
            DiffAng=acos(DiffAng)/ToRad
          else if(DiffAng.gt.0.) then
            DiffAng=0.
          else
            DiffAng=180.
          endif
          call FromIndSinthl(ihp,h ,sinthl1,pom,1,1)
          call FromIndSinthl(ihp,hh,sinthl2,pom,1,1)
          DiffTh=(asin(sinthl2*LamAve(1))-asin(sinthl1*LamAve(1)))/ToRad
          call SetRotKuma(uk(1)-uk(2),uk(3),uk(4),Rot)
          call MultM(Rot,cc,x,3,3,1)
          Psi0=-AngKuma(x(3),x(1))
          nkrat=9
        else
          Psi0=0.
          nkrat=36
          AngleWithNozzleMax =-99999.
          AngleWithNozzleMaxA=-99999.
        endif
        do 5350i=1,4
          if(i.eq.1.or.i.eq.3) then
            PsiD= 5.*ToRad
          else
            PsiD=-5.*ToRad
          endif
          if(i.le.2) then
            Psi=Psi0
          else
            Psi=Psi0+Pi
            if(Psi.gt.pi) Psi=Psi-Pi2
          endif
          n=0
5300      call AnglesFromRotation(uk,Rko,Psi,ich)
          if(ich.eq.0) call CheckProblems(uk,iuk,ich)
          if(Klic.eq.3.and.ich.eq.0) then
            call SetRotKuma(uk(1)-uk(2),uk(3),uk(4),Rot)
            call MultM(Rot,DirFi,x,3,3,1)
            pom=VecOrtScal(x,DirNozzle,3)
            pom=min(pom, .999999)
            pom=max(pom,-.999999)
            AngleWithNozzle=acos(pom)/ToRad
            AngleWithNozzleA=abs(AngleWithNozzle)
            if(AngleWithNozzleA.gt.70.) then
              AngleWithNozzleMaxA=AngleWithNozzleA
              AngleWithNozzleMax=AngleWithNozzle
              PsiOpt=Psi
              go to 5360
            else
              if(AngleWithNozzleA.gt.AngleWithNozzleMaxA) then
                AngleWithNozzleMaxA=AngleWithNozzleA
                AngleWithNozzleMax=AngleWithNozzle
                PsiOpt=Psi
              endif
              ich=1
            endif
          endif
          if(ich.ne.0) then
            if(n.ge.nkrat) go to 5350
            n=n+1
            Psi=Psi+PsiD
            go to 5300
          endif
          if(n.lt.nmin) then
            nmin=n
            PsiOpt=Psi
          endif
          if(nmin.eq.0) go to 5360
5350    continue
        if(Klic.eq.2) then
         if(nmin.ge.nkrat) then
            write(TextInfo(1),'(6i4)')(ih(i),i=1,ndim)
            call ZdrcniCisla(TextInfo(1),ndim)
            TextInfo(1)='Reflection : '//TextInfo(1)(:idel(TextInfo(1)))
     1                //' cannot be optimized'
            Ninfo=1
            call FeInfoOut(-1.,-1.,'WARNING')
            nn=nn-1
            go to 5000
          endif
        endif
5360    nn=nn+1
        PsiA(nn)=PsiOpt
        DiffThA(nn)=DiffTh
        DiffAngA(nn)=DiffAng
        call CopyVek(h,hA(1,nn),3)
        if(Klic.eq.2) then
          do 5370i=1,4
            IUkA(nn,i)=IUk(i)
5370      continue
        else
          IUkA(nn,2)=nint(AngleWithNozzleMax*10000.)
        endif
        go to 5000
5600    call indexx(nn,IUkA(1,2),ipor)
        if(Klic.eq.2) then
          j=ipor(1)
          ipr=1
5700      do 5710i=1,4
            IUk(i)=IUkA(j,i)
5710      continue
          write(lno,100)(hA(k,j),k=1,3),PsiA(j)/ToRad,DiffThA(j),
     1                   DiffAngA(j)
          mind=99999999
          j=0
          ipor(ipr)=0
          do 5800i=1,nn
            k=ipor(i)
            if(k.le.0) go to 5800
            id=0
            do 5720m=1,4
              id=max(iabs(IUkA(k,m)-IUk(m)),id)
              if(id.gt.mind) go to 5800
5720        continue
            mind=id
            j=k
            ipr=i
5800      continue
          if(j.gt.0) go to 5700
        else
          do 5820i=1,nn
            if(Klic.eq.3) then
              j=i
            else
              j=ipor(i)
            endif
            if(iabs(IUkA(j,2)).ge.700000)
     1        write(lno,100)(hA(k,j),k=1,3),PsiA(j)/ToRad,
     2                       float(IUkA(j,2))/10000.
5820      continue
          do 5830i=1,nn
            if(Klic.eq.3) then
              j=i
            else
              j=ipor(i)
            endif
            if(iabs(IUkA(j,2)).lt.700000)
     1        write(lno,100)(hA(k,j),k=1,3),PsiA(j)/ToRad,
     2                       float(IUkA(j,2))/10000.
5830      continue
        endif
        write(TextInfo(1),'(i5,'' reflections were generated'')') nn
        Ninfo=1
        call FeInfoOut(-1.,-1.,'INFORMATION')
      else if(Klic.eq.4) then
        call DRKUMAIndex(1)
      else if(Klic.eq.5) then
        call DRKUMARefine(1)
        go to 200
      endif
9999  call CloseIfOpened(ln)
      call CloseIfOpened(lno)
      return
100   format(6f10.4,4i10)
      end
      subroutine DRKumaIndex(KumaInput)
      parameter (mxi=2000)
      include 'params.cmn'
      include 'basic.cmn'
      include 'datred.cmn'
      include 'fepc.cmn'
      character*256 FileIn,StoreFile,t256
      character*100 Radka
      character*80 t80
      character*45  StoreLabel(10)
      character*8 Nazev
      character*1 ZnakI,ZnakS
      dimension Slozky(4,mxi),Int(mxi),ha(3,mxi),Uhel(mxi,mxi),
     1          Euler(4,mxi),U(3,3),Ui(3,3),hh(3),T(3,3),Tt(3,3),
     2          Ti(3,3),IU(4),ik(2),UStore(3,3),Delka(mxi),hp(3),
     3          xp(3),AM(3,3),AMinv(3,3),PS(3,3),SCellDatRed(6),
     4          SU(3,3),G(3,3),isel(2),UBFromFile(3,3),SG(3,3),
     5          h(3),hi(3),SlozkyP(4)
      integer FlagS(mxi),FlagI(mxi),BazVek(4,20),ZlomekZIndexu(3),
     1        FeMenu,FlagK(mxi),FlagKP,TakeUBFromFile,in(1)
      logical eqiv,SelwLogicQuest,BazVekFlag(20),MameMatici,EqIgCase,
     1        FeYesNoHeader,ExistFile,FeYesNo,StepBackPossible,eqrv,
     2        Indexace
      equivalence (u,ub),(ui,ubi),(AM,SU,T),(AMinv,Ti),(PS,Tt),
     1            (G,MetTens),(Radka,t80)
      data IntMin,IntMax/0,999999/,DiffMax/.1/,
     1     Method,VolMin,VolMax,VolAMin/2,10.,5000.,.2/
      data RelIMin,RelIMax/0.,1000000./,sinthlMin,sinthlMax/0.,1./
      FileIn=' '
      nStore=0
      MatrixFromFileOK=1
      call SetRealArrayTo(SG,9,0.)
      call SetRealArrayTo(SU,9,0.)
      ndim=3
      ndimi=0
      ndimq=9
      ln=NextLogicNumber()
      if(KumaInput.eq.1) then
        call FeFileManager('Select peak table file',FileIn,'*.ta*',0,
     1                     .true.,ich)
        if(ich.ne.0) go to 9999
        ln=NextLogicNumber()
        call OpenFile(ln,FileIn,'formatted','old')
        if(ErrJana.ne.0) go to 9999
        read(ln,FormA80) Radka
        k=0
        call StToInt(Radka,k,in,1,.false.,ich)
        if(ich.ne.0) go to 9999
        NRefMax=in(1)
        RelIMin=0.
        RelIMax=1000000.
1040    if(NRefMax.gt.999) then
          call DRKumaIndexLimits(KumaInput,sinthlMin,sinthlMax,RelIMin,
     1                           RelIMax,Indexace,ich)
          if(ich.ne.0) go to 9999
        else
          NRef=NRefMax
        endif
        NRef=0
        do 1060i=1,NRefMax
          read(ln,104) SlozkyP,IntP,FlagKP
          pom=IntP
          if(pom.lt.RelIMin.or.pom.gt.RelIMax) go to 1060
          do 1050j=1,4
            SlozkyP(j)=SlozkyP(j)/LamAveD(6)
1050      continue
          pom=.5*VecOrtLen(SlozkyP,3)
          if(pom.lt.sinthlMin.or.pom.gt.sinthlMax) go to 1060
          NRef=NRef+1
          if(NRef.gt.mxi) then
            write(Cislo,FormI15) mxi
            call Zhusti(Cislo)
            call FeChybne(-1.,-1.,'the maximal number of '//
     1        Cislo(:idel(Cislo))//' reflections exceeded',
     2        'Please change the limits',0,SeriousError)
            rewind ln
            read(ln,FormA1)
            go to 1040
          endif
          call CopyVek(SlozkyP,Slozky(1,NRef),4)
          Int(NRef)=IntP
          FlagS(NRef)=1
          FlagI(NRef)=0
1060    continue
        pom=0.
        do 1075i=1,3
          read(ln,104)(UBFromFile(i,j),j=1,3)
          read(ln,104)
          do 1070j=1,3
            UBFromFile(i,j)=UBFromFile(i,j)/LamAveD(6)
            pom=pom+abs(UBFromFile(i,j))
1070      continue
          if(pom.lt..0001) then
            MatrixFromFileOK=0
            go to 1280
          endif
1075    continue
      else if(KumaInput.eq.2) then
        call FeFileManager('Select p4p file',FileIn,'*.p4p',0,.true.,
     1                     ich)
        if(ich.ne.0) go to 9999
        ln=NextLogicNumber()
        call OpenFile(ln,FileIn,'formatted','old')
        if(ErrJana.ne.0) go to 9999
        NRef=0
1080    read(ln,FormA256,end=1280) t256
        call mala(t256)
        k=0
        call kus(t256,k,Nazev)
        if(Nazev(1:3).eq.'ort') then
          read(Nazev(4:4),'(i1)') i
          call StToReal(t256,k,xp,3,.false.,ich)
          if(ich.ne.0) go to 9999
          do 1090j=1,3
            UBFromFile(i,j)=xp(j)
1090      continue
        else if(Nazev.eq.'ref05'.or.Nazev.eq.'ref1k') then
          NRef=NRef+1
          if(NRef.gt.mxi) go to 1080
          call kus(t256,k,Nazev)
          call StToReal(t256,k,hh,3,.false.,ich)
          if(ich.ne.0) go to 9999
          call StToReal(t256,k,xp,3,.false.,ich)
          if(ich.ne.0) go to 9999
          call StToReal(t256,k,xp,3,.false.,ich)
          if(ich.ne.0) go to 9999
          call StToReal(t256,k,xp,2,.false.,ich)
          if(ich.ne.0) go to 9999
          int(NRef)=nint(xp(1))
          FlagS(NRef)=1
          FlagI(NRef)=0
          call StToReal(t256,k,Slozky(1,NRef),3,.false.,ich)
          if(ich.ne.0) go to 9999
        endif
        go to 1080
      else
        if(.not.ExistM50.or.(.not.ExistM95.and..not.ExistM91)) then
          call FeChybne(-1.,-1.,'the basic files necessary for '//
     1                  'don''t exist',' ',0,SeriousError)
          go to 9999
        endif
        RelIMin=6.
        RelIMax=10000.
1140    call DRKumaIndexLimits(KumaInput,sinthlMin,sinthlMax,RelIMin,
     1                         RelIMax,Indexace,ich)
        if(ich.eq.0) then
          if(ExistM95) then
            call OpenFile(95,fln(:ifln)//'.m95','formatted','old')
            call PrvniM95(ich)
            if(ich.ne.0) go to 1200
          else
            call OpenFile(95,fln(:ifln)//'.m91','formatted','old')
          endif
          if(.not.Indexace)
     1      call OpenFile(ln,'ven.tmp','formatted','unknown')
          NRef=0
1150      if(ExistM95) then
            call DRGetReflectionFromM95(95,iend,ich)
            if(ich.ne.0) go to 1200
            if(iend.ne.0) go to 1200
            if(no.lt.0.or.iflg(1).lt.0) go to 1150
          else
            read(95,Format91,err=1200,end=1200)(ih(i),i=1,ndim),ri,rs
            if(ih(1).gt.900) go to 1200
          endif
          pom=ri/rs
          call FromIndSinthl(ih,h,sinthl,sinthlq,1,0)
          if(pom.lt.RelIMin.or.pom.gt.RelIMax) go to 1150
          if(sinthl.lt.SinthlMin.or.sinthl.gt.SinthlMax) go to 1150
          if(Indexace) then
            call RealVectorToOpposite(h,hi,3)
            do 1160i=1,NRef
              if(eqrv(ha(1,i),hi,3,.001).or.eqrv(ha(1,i),h,3,.001))
     1          go to 1150
1160        continue
            NRef=NRef+1
            if(NRef.gt.mxi) then
              write(Cislo,FormI15) mxi
              call Zhusti(Cislo)
              call FeChybne(-1.,-1.,'the maximal number of '//
     1          Cislo(:idel(Cislo))//' reflections exceeded',
     2          'Please change the limits',0,SeriousError)
              close(95)
              close(ln)
              go to 1140
            endif
            call CopyVek(h,ha(1,NRef),3)
            FlagK(NRef)=0
            FlagS(NRef)=1
            FlagI(NRef)=0
            Int(NRef)=ri
            call Multm(h,TrToOrthoI,Slozky(1,NRef),1,3,3)
          else
            NRef=Nref+1
            call Multm(h,TrToOrthoI,hi,1,3,3)
            AA=VecOrtLen(hi,3)
            write(ln,104)(hi(i)*LamAveD(6),i=1,3),AA*LamAveD(6),
     1                    nint(ri),0
          endif
          go to 1150
1200      close(95)
          call SetRealArrayTo(UBFromFile,9,0.)
          MatrixFromFileOK=0
          if(.not.Indexace) then
            rewind ln
            lno=NextLogicNumber()
            call OpenFile(lno,fln(:ifln)//'.tab','formatted','unknown')
            write(Cislo,FormI15) NRef
            call Zhusti(Cislo)
            write(lno,FormA1)(Cislo(i:i),i=1,idel(Cislo))
1210        read(ln,FormA256,end=1220) t256
            write(lno,FormA1)(t256(i:i),i=1,idel(t256))
            go to 1210
1220        do 1222i=1,3
              write(lno,104)(0.,j=1,3)
              write(lno,104)(0.,j=1,3)
1222        continue
            do 1224i=1,3
              write(lno,104)(0.,j=1,3)
              write(lno,104)(0.,j=1,3)
1224        continue
            write(lno,'(2i10)') 0,1
            close(ln,status='delete')
            close(lno)
          endif
        endif
        if(ich.ne.0.or..not.Indexace) go to 9999
      endif
1280  call CloseIfOpened(ln)
      StoreFile='jsvf'
      call CreateTmpFile(StoreFile,i,0)
      call FeTmpFilesAdd(StoreFile)
      do 1290i=1,NRef
        AA=VecOrtLen(Slozky(1,i),3)
        Delka(i)=AA
        Euler(1,i)=asin(.5*AA*LamAveD(6))/ToRad
        Euler(2,i)=2.*Euler(1,i)
        Euler(3,i)=atan2(-Slozky(3,i),
     1                   sqrt(Slozky(1,i)**2+Slozky(2,i)**2))/ToRad
        if(Slozky(1,i).eq.0.and.Slozky(2,i).eq.0.) then
          Euler(4,i)=90.
        else
          Euler(4,i)=atan2(-Slozky(1,i),Slozky(2,i))/ToRad
        endif
        if(Euler(4,i).lt.0.) Euler(4,i)=360.+Euler(4,i)
        Uhel(i,i)=0.
        do 1285j=1,i-1
          pom=VecOrtScal(Slozky(1,i),Slozky(1,j),3)/
     1        (AA*VecOrtLen(Slozky(1,j),3))
          Uhel(i,j)=pom
          Uhel(j,i)=pom
1285    continue
1290  continue
      MameMatici=.false.
1300  NSelw=12
      nmax=min(NSelw,NRef)
      id=NextQuestId()
      StringL=SmallFontWidth*73.
      xqd =StringL+47.
      xqdp=xqd*.5
      LinesSel=nmax+1
      il=2
      call FeQuestCreate(id,-1.,-1.,xqd,LinesSel,il,'Select peaks '//
     1                   'for indexation',0,LightGray,0,0)
      if(NRef.gt.nmax) then
        xpom=5.
        call FeQuestUpDownMake(id,xpom,LinesSel+1,UpDownXd,UpDownYd,
     1                         'down')
        nDown=UpDownLastMade
        call FeQuestUpDownOpen(UpDownLastMade,UpDownOff)
        call FeQuestUpDownMake(id,xpom,   1,UpDownXd,UpDownYd,'up')
        call FeQuestUpDownOpen(UpDownLastMade,UpDownOff)
        nUp=UpDownLastMade
      endif
      xpom=5.
      Radka='              Indices         '//
     1      '                Angles           '//
     2      '     Int    Triplets'
      il=1
      call FeQuestLabelMake(id,xpom,il,Radka,'L')
      xpom=StringL+25.
      do 1320i=1,nmax
        il=il+1
        call FeQuestCrwMake(id,xpom,il,xpom,il,' ','L',CrwXd,CrwYd,1,0)
        if(i.eq.1) nCrwFirst=CrwLastMade
1320  continue
      il=LinesSel+1
      dpom=40.
      xpom=xqdp-2.5*dpom-14.
      call FeQuestButtonMake(id,xpom,il,dpom,ButYd,'%Indexed')
      nButtIndexed=ButtonLastMade
      if(MameMatici) then
        i=ButtonOff
      else
        i=ButtonDisabled
      endif
      call FeQuestButtonOpen(ButtonLastMade,i)
      xpom=xpom+dpom+7.
      call FeQuestButtonMake(id,xpom,il,dpom,ButYd,'%Refresh')
      nButtRefresh=ButtonLastMade
      call FeQuestButtonOpen(ButtonLastMade,ButtonOff)
      xpom=xpom+dpom+7.
      call FeQuestButtonMake(id,xpom,il,dpom,ButYd,'Select %all')
      nButtAll=ButtonLastMade
      call FeQuestButtonOpen(ButtonLastMade,ButtonOff)
      xpom=xpom+dpom+7.
      call FeQuestButtonMake(id,xpom,il,dpom,ButYd,'%Filter')
      nButtFilter=ButtonLastMade
      call FeQuestButtonOpen(ButtonLastMade,ButtonOff)
      xpom=xpom+dpom+7.
      call FeQuestButtonMake(id,xpom,il,dpom,ButYd,'Re%verse')
      nButtReverse=ButtonLastMade
      call FeQuestButtonOpen(ButtonLastMade,ButtonOff)
      il=il+1
      dpom=70.
      xpom=xqdp-1.5*dpom-7.
      call FeQuestButtonMake(id,xpom,il,dpom,ButYd,'%Optimal triplet')
      nButtOptimal=ButtonLastMade
      call FeQuestButtonOpen(ButtonLastMade,ButtonOff)
      xpom=xpom+dpom+7.
      call FeQuestButtonMake(id,xpom,il,dpom,ButYd,'%UB as read in')
      nButtUBFromFile=ButtonLastMade
      if(MatrixFromFileOK.gt.0) then
        i=ButtonOff
      else
        i=ButtonDisabled
      endif
      call FeQuestButtonOpen(ButtonLastMade,i)
      xpom=xpom+dpom+7.
      call FeQuestButtonMake(id,xpom,il,dpom,ButYd,'I%mport UB')
      nButtUBImport=ButtonLastMade
      call FeQuestButtonOpen(ButtonLastMade,ButtonOff)
      m=1
1400  n1=nmax*(m-1)+1
      n2=min(NRef,n1+nmax-1)
      call FeQuestReset('SelwNumber')
      n=n1
      il=2
      nCrw=nCrwFirst
      do 1500i=1,nmax
        if(n.le.NRef) then
          write(Radka,'(''#'',i3)') n
          k=5
          do 1450j=1,3
            if(MameMatici) then
              write(Radka(k:),'(f8.3)') ha(j,n)
            else
              Radka(k:)='   -----'
            endif
            k=k+8
1450      continue
          if(FlagI(n).eq.1) then
            Radka(k:k+2)=' X '
          else
            Radka(k:k+2)='   '
          endif
          k=k+3
          do 1460j=1,4
            write(Radka(k:),'(f8.3)') Euler(j,n)
            k=k+8
1460      continue
          write(Radka(k:),'(i9)') Int(n)
          call FeQuestSelwMake(id,5.,il,Radka,StringL,SelwYd,1,0)
          call FeQuestSelwOpen(SelwLastMade,FlagS(n).ne.0)
          if(FlagS(n).ne.0) then
            call FeQuestCrwOpen(nCrw,FlagS(n).gt.10)
          else
            call FeQuestCrwClose(nCrw)
          endif
        else
          call FeQuestSelwRemove(i)
          call FeQuestCrwClose(nCrw)
        endif
        n=n+1
        il=il+1
        nCrw=nCrw+1
1500  continue
      if(NRef.gt.nmax) then
        if(n2.lt.NRef) then
          call FeUpDownOff(nDown)
        else
          call FeUpDownDisable(nDown)
        endif
        if(n1.gt.1) then
          call FeUpDownOff(nUp)
        else
          call FeUpDownDisable(nUp)
        endif
      endif
      TakeUBFromFile=0
1550  icont=0
1600  call FeQuestEvent(id,icont,ich)
      icont=1
      if(CheckType.eq.EventUpDown.and.(CheckNumber.eq.nDown.or.
     1                                 CheckNumber.eq.nUp)) then
        if(CheckNumber.eq.nDown) then
          m=m+1
        else
          m=m-1
        endif
        go to 1400
      else if(CheckType.eq.EventButton) then
        ib=CheckNumber
        if(CheckNumber.eq.nButtRefresh) then
          i=0
          call SetIntArrayTo(FlagS,NRef,0)
        else if(CheckNumber.eq.nButtAll) then
          do 1610i=1,NRef
            FlagS(i)=(FlagS(i)/10)*10+1
1610      continue
        else if(CheckNumber.eq.nButtReverse) then
          do 1620i=1,NRef
            if(FlagS(i).eq.0) then
              FlagS(i)=1
            else
              FlagS(i)=0
            endif
1620      continue
        else if(CheckNumber.eq.nButtIndexed) then
          do 1630i=1,NRef
            if(FlagI(i).eq.0) FlagS(i)=0
1630      continue
        else if(CheckNumber.eq.nButtFilter) then
          idp=NextQuestId()
          call FeQuestCreate(idp,-1.,-1.,100.,0,2,' ',0,LightGray,0,0)
          il=1
          tpom=5.
          xpom=50.
          dpom=40.
          call FeQuestEdwMake(idp,tpom,il,xpom,il,'Int(min)','L',dpom,
     1                        EdwYd,0)
          nEdwIntMin=EdwLastMade
          call FeQuestIntEdwOpen(EdwLastMade,IntMin,.false.)
          il=il+1
          call FeQuestEdwMake(idp,tpom,il,xpom,il,'Int(max)','L',dpom,
     1                        EdwYd,0)
          nEdwIntMax=EdwLastMade
          call FeQuestIntEdwOpen(EdwLastMade,IntMax,.false.)
          icont=0
2000      call FeQuestEvent(idp,icont,ich)
          icont=1
          if(CheckType.ne.0) then
            call NebylOsetren
            go to 2000
          endif
          if(ich.eq.0) then
            call FeQuestIntFromEdw(nEdwIntMin,IntMin)
            call FeQuestIntFromEdw(nEdwIntMax,IntMax)
            do 2020i=1,NRef
              if(Int(i).lt.IntMin.or.Int(i).gt.IntMax) FlagS(i)=0
2020        continue
          endif
          call FeQuestRemove(idp)
        else if(CheckNumber.eq.nButtOptimal) then
          call DRKumaIndexDefOpt(Method,VolMin,VolMax,VolAMin,ich)
          if(ich.ne.0) go to 2100
          VMax=0.
          do 2050i=1,NRef-2
            if(flagS(i).eq.0) go to 2050
            do 2040j=i+1,NRef-1
              if(flagS(j).eq.0) go to 2040
              CosGama=Uhel(i,j)
              do 2030k=j+1,NRef
                if(flagS(k).eq.0) go to 2030
                CosAlfa=Uhel(i,k)
                CosBeta=Uhel(j,k)
                VolA=1.-CosAlfa**2-CosBeta**2-CosGama**2
     1                +2.*CosAlfa*CosBeta*CosGama
                Vol=VolA*Delka(i)*Delka(j)*Delka(k)
                if(Vol.lt.1./VolMax) go to 2030
                Vol=1./Vol
                if(Method.eq.1) then
                  if(VolA.lt.VolAMin) go to 2030
                else
                  if(Vol.lt.VolMin) go to 2030
                  Vol=VolA
                endif
                if(Vol.gt.VMax) then
                  iv1=i
                  iv2=j
                  iv3=k
                  VMax=Vol
                endif
2030          continue
2040        continue
2050      continue
          if(VMax.gt.0.) then
            do 2060i=1,NRef
              FlagS(i)=mod(FlagS(i),10)
2060        continue
            FlagS(iv1)=FlagS(iv1)+10
            FlagS(iv2)=FlagS(iv2)+10
            FlagS(iv3)=FlagS(iv3)+10
          endif
        else if(CheckNumber.eq.nButtUBFromFile) then
          TakeUBFromFile=1
          call CopyMat(UBFromFile,U,3)
          call FeQuestButtonOff(CheckNumber)
          EventType=EventButton
          EventAbsNumber=ButtonOK
          go to 1600
        else if(CheckNumber.eq.nButtUBImport) then
          TakeUBFromFile=2
          call FeFileManager('Select peak table file for UB import',
     1                       FileIn,'*.ta*',0,.true.,ich)
          if(ich.eq.0) then
            call OpenFile(ln,FileIn,'formatted','old')
            if(ErrJana.ne.0) go to 2100
            read(ln,FormA80) Radka
            k=0
            call StToInt(Radka,k,in,1,.false.,ich)
            if(ich.ne.0) go to 9999
            NRefP=in(1)
            do 2062i=1,NrefP
              read(ln,104) pom
2062        continue
            do 2070i=1,3
              read(ln,104)(U(i,j),j=1,3)
              read(ln,104)
              do 2065j=1,3
                U(i,j)=U(i,j)/LamAveD(6)
2065          continue
2070        continue
            call CloseIfOpened(ln)
            EventType=EventButton
            EventAbsNumber=ButtonOK
            go to 1600
          else
            go to 2100
          endif
        endif
2100    call FeQuestButtonOff(ib)
        go to 1400
      else if(CheckType.eq.EventCrw) then
        i=n1+CheckNumber-1
        if(FlagS(i).gt.10) then
          FlagS(i)=FlagS(i)-10
        else
          FlagS(i)=FlagS(i)+10
        endif
        go to 1550
      else if(CheckType.eq.EventSelw) then
        i=n1+CheckNumber-1
        nCrw=nCrwFirst+CheckNumber-1
        if(FlagS(i).eq.0) then
          FlagS(i)=1
          call FeQuestCrwOpen(nCrw,.false.)
        else
          FlagS(i)=0
          call FeQuestCrwClose(nCrw)
        endif
        go to 1550
      else if(CheckType.ne.0) then
        call NebylOsetren
        go to 1600
      endif
      if(ich.eq.0) then
        NRefForTriplets=0
        if(TakeUBFromFile.eq.0) then
          do 2200i=1,NRef
            if(FlagS(i).gt.10) NRefForTriplets=NRefForTriplets+1
2200      continue
          if(NRefForTriplets.lt.3) then
            NInfo=1
            TextInfo(1)='Warning - no triplet defined!'
            if(FeYesNoHeader(-1.,-1.,'Do you want to finish?',0)) then
              ich=1
              go to 2350
            else
              call FeButtonOff(ButtonOk)
              go to 1400
            endif
          endif
        endif
        NRefSel=0
        do 2210i=1,NRef
          if(FlagS(i).ne.0) NRefSel=NRefSel+1
2210    continue
        if(NRefSel.lt.3) then
          NInfo=1
          TextInfo(1)='Warning - too low number of selected reflection!'
          if(FeYesNoHeader(-1.,-1.,'Do you want to finish?',0)) then
            ich=1
            go to 2350
          else
            call FeButtonOff(ButtonOk)
            go to 1400
          endif
        endif
      endif
2350  call FeQuestRemove(id)
      if(ich.ne.0) go to 9999
      NRefOut=20
      nmax=min(NRefOut,NRef)
      do 5000iv1=1,NRef-2
        if(FlagS(iv1).lt.10.and.TakeUBFromFile.eq.0) go to 5000
        do 4900iv2=iv1+1,NRef-1
          if(FlagS(iv2).lt.10.and.TakeUBFromFile.eq.0) go to 4900
          do 4800iv3=iv2+1,NRef
            if(FlagS(iv3).lt.10.and.TakeUBFromFile.eq.0) go to 4800
            call SetRealArrayTo(SCellDatRed,6,0.)
            if(TakeUBFromFile.ne.0) then
              if(TakeUBFromFile.eq.1) call CopyVek(UBFromFile,U,9)
              Radka='Taken from file'
            else
              call CopyVek(Slozky(1,iv1),U(1,1),3)
              call CopyVek(Slozky(1,iv2),U(1,2),3)
              call CopyVek(Slozky(1,iv3),U(1,3),3)
              write(Radka,'(3i4)') iv1,iv2,iv3
              Radka='Triplet : '//Radka(:idel(Radka))
            endif
            call Matinv(U,Ui,Vol,3)
            if(abs(Vol).lt..0001) then
              call FeMsgOut(-1.,-1.,Radka(:idel(Radka))//' - skipped')
              go to 4800
            endif
            id=NextQuestId()
            xqd =260.
            xqdp=xqd*.5
            yqd=180.
            yRef=yqd-3.
            nl=19
            yButt=yRef-float(nl)*7.-14.
            StepBackPossible=.false.
            call FeQuestAbsCreate(id,-1.,-1.,xqd,yqd,Radka,0,LightGray,
     1                            -1,-1)
            if(NRef.gt.nmax) then
              xpom=xqd-13.
              ypom=QuestLength(id)-12.
              call FeQuestAbsUpDownMake(id,xpom,ypom,UpDownXd,UpDownYd,
     1                                  'up')
              nUp=UpDownLastMade
              call FeQuestUpDownOpen(UpDownLastMade,UpDownOff)
              ypom=ypom-64.
              call FeQuestAbsUpDownMake(id,xpom,ypom,UpDownXd,UpDownYd,
     1                                  'down')
              call FeQuestUpDownOpen(UpDownLastMade,UpDownOff)
              nDown=UpDownLastMade
            endif
            dpom=35.
            fnb=6.
            space=6.
            xpom=xqdp-fnb*dpom*.5-(fnb-1.)*space*.5
            ypom=ybutt
            call FeQuestAbsButtonMake(id,xpom,ypom,dpom,ButYd,'Red%uce')
            nButtReduce=ButtonLastMade
            call FeQuestButtonOpen(ButtonLastMade,ButtonOff)
            xpom=xpom+dpom+space
            call FeQuestAbsButtonMake(id,xpom,ypom,dpom,ButYd,
     1                                '%Supercell')
            nButtSuper=ButtonLastMade
            call FeQuestButtonOpen(ButtonLastMade,ButtonOff)
            xpom=xpom+dpom+space
            call FeQuestAbsButtonMake(id,xpom,ypom,dpom,ButYd,
     1                                '%Doublecell')
            nButtDouble=ButtonLastMade
            call FeQuestButtonOpen(ButtonLastMade,ButtonOff)
            xpom=xpom+dpom+space
            call FeQuestAbsButtonMake(id,xpom,ypom,dpom,ButYd,'%Matrix')
            nButtMatrix=ButtonLastMade
            call FeQuestButtonOpen(ButtonLastMade,ButtonOff)
            xpom=xpom+dpom+space
            call FeQuestAbsButtonMake(id,xpom,ypom,dpom,ButYd,
     1                                'Step ba%ck')
            nButtStepBack=ButtonLastMade
            call FeQuestButtonOpen(ButtonLastMade,ButtonDisabled)
            xpom=xpom+dpom+space
            call FeQuestAbsButtonMake(id,xpom,ypom,dpom,ButYd,'Re%fine')
            nButtRefine=ButtonLastMade
            call FeQuestButtonOpen(ButtonLastMade,ButtonOff)
            ypom=ypom-11.
            fnb=5.
            xpom=xqdp-fnb*dpom*.5-(fnb-1.)*space*.5
            call FeQuestAbsButtonMake(id,xpom,ypom,dpom,ButYd,
     1                                '%Options')
            nButtOptions=ButtonLastMade
            call FeQuestButtonOpen(ButtonLastMade,ButtonOff)
            xpom=xpom+dpom+space
            call FeQuestAbsButtonMake(id,xpom,ypom,dpom,ButYd,'S%tore')
            nButtStore=ButtonLastMade
            call FeQuestButtonOpen(ButtonLastMade,ButtonOff)
            xpom=xpom+dpom+space
            call FeQuestAbsButtonMake(id,xpom,ypom,dpom,ButYd,
     1                                '%Restore')
            nButtRestore=ButtonLastMade
            if(nStore.gt.0) then
              j=ButtonOff
            else
              j=ButtonDisabled
            endif
            call FeQuestButtonOpen(ButtonLastMade,j)
            xpom=xpom+dpom+space
            call FeQuestAbsButtonMake(id,xpom,ypom,dpom,ButYd,
     1                                'S%ave')
            nButtSave=ButtonLastMade
            call FeQuestButtonOpen(ButtonLastMade,ButtonOff)
            xpom=xpom+dpom+space
            call FeQuestAbsButtonMake(id,xpom,ypom,dpom,ButYd,
     1                                'Com%pare')
            nButtCompare=ButtonLastMade
            if(nStore.gt.1) then
              j=ButtonOff
            else
              j=ButtonDisabled
            endif
            call FeQuestButtonOpen(ButtonLastMade,j)
            ypom=ypom-11.
            xpom=xqdp-.5*dpom
            call FeQuestAbsButtonMake(id,xpom,ypom,dpom,ButYd,'%Quit')
            nButtQuit=ButtonLastMade
            call FeQuestButtonOpen(ButtonLastMade,ButtonOff)
            pom=dpom
            dpom=60.
            xpom=xqdp-dpom-pom*.5-10.
            call FeQuestAbsButtonMake(id,xpom,ypom,dpom,ButYd,
     1                                'Ne%xt triplet')
            nButtNextTriplet=ButtonLastMade
            if(NRefForTriplets.gt.3) then
              j=ButtonOff
            else
              j=ButtonDisabled
            endif
            call FeQuestButtonOpen(ButtonLastMade,j)
            xpom=xpom+dpom+pom+20.
            call FeQuestAbsButtonMake(id,xpom,ypom,dpom,ButYd,
     1                                'Ne%w select')
            nButtNewSelect=ButtonLastMade
            call FeQuestButtonOpen(ButtonLastMade,ButtonOff)
            m=1
            call SetStringArrayTo(TextInfo,18,' ')
2500        nBazVek=3
            do 2510i=1,3
              do 2505j=1,4
                if(i.eq.j.or.j.eq.4) then
                  BazVek(j,i)=1
                else
                  BazVek(j,i)=0
                endif
2505          continue
2510        continue
            call Matinv(U,Ui,Vol,3)
            if(Vol.lt.0.) then
              do 2520i=1,3
                do 2515j=1,3
                  U (i,j)=-U (i,j)
                  Ui(i,j)=-Ui(i,j)
2515            continue
2520          continue
              Vol=-Vol
            endif
            call CellFromUB
            n1=nmax*(m-1)+1
            n2=min(NRef,n1+nmax-1)
            xpom=5.
            ypom=yRef
            do 2530il=1,18
              ypom=ypom-7.
              call FeQuestAbsLabelRemove(id,xpom,ypom,TextInfo(il),'L')
              TextInfo(il)=' '
              if(il.eq.11) ypom=ypom-7.
2530        continue
            il=0
            kk=1
            IndexedAll=0
            IndexedSel=0
            NRefSel=0
            do 2600i=1,NRef
              if(FlagS(i).ne.0) then
                ZnakS='S'
                NRefSel=NRefSel+1
              else
                ZnakS=' '
              endif
              call multm(Ui,Slozky(1,i),ha(1,i),3,3,1)
              do 2531j=1,3
                hp(j)=anint(ha(j,i))-ha(j,i)
2531          continue
              call multm(U,hp,xp,3,3,1)
              if(asin(.5*VecOrtLen(xp,3)*LamAveD(6))/ToRad.lt.DiffMax)
     1            then
                FlagI(i)=1
                ZnakI='X'
                IndexedAll=IndexedAll+1
                if(FlagS(i).ne.0) IndexedSel=IndexedSel+1
              else
                FlagI(i)=0
                ZnakI=' '
              endif
              if(i.ge.n1.and.i.le.n2) then
                il=il+1
                write(TextInfo(il)(kk:),'(''#'',i3,3f8.3,2(1x,a1))')
     1            i,(ha(j,i),j=1,3),ZnakI,ZnakS
                if(i.eq.n1+9) then
                  il=0
                  kk=kk+40
                endif
              endif
              if(FlagS(i).eq.0) go to 2600
              do 2534k=1,10
                fk=k
                do 2532j=1,3
                  hp(j)=anint(ha(j,i)*fk)/fk-ha(j,i)
2532            continue
                call multm(U,hp,xp,3,3,1)
                if(asin(.5*VecOrtLen(xp,3)*LamAveD(6))/ToRad.lt.DiffMax)
     1            go to 2540
2534          continue
              go to 2600
2540          MinMult=k
              do 2550j=1,3
                ZlomekZIndexu(j)=nint(ha(j,i)*fk)
2550          continue
              do 2580j=1,MinMult-1
                do 2555k=1,3
                  IU(k)=ZlomekZIndexu(k)*j
2555            continue
                IU(4)=MinMult
                do 2560k=1,3
2556              if(IU(k).ge.MinMult) then
                    IU(k)=IU(k)-MinMult
                    go to 2556
                  endif
2558              if(IU(k).lt.0) then
                    IU(k)=IU(k)+MinMult
                    go to 2558
                  endif
2560            continue
                call MinMultMaxFract(IU,4,k,MaxFract)
                do 2562k=1,4
                  IU(k)=IU(k)/MaxFract
2562            continue
                call MinMultMaxFract(IU,3,k,MaxFract)
                do 2564k=1,3
                  IU(k)=IU(k)/MaxFract
2564            continue
                do 2570k=1,nBazVek
                  if(eqiv(IU,BazVek(1,k),3)) then
                    BazVek(4,k)=max(BazVek(4,k),IU(4))
                    go to 2580
                  endif
2570            continue
                if(nBazVek.lt.20) then
                  nBazVek=nBazVek+1
                  call CopyVekI(IU,BazVek(1,nBazVek),4)
                endif
2580          continue
2600        continue
            if(IndexedAll.le.3) then
              call FeQuestButtonDisable(nButtRefine)
            else
              call FeQuestButtonOff(nButtRefine)
            endif
            if(StepBackPossible) then
              call FeQuestButtonOff(nButtStepBack)
            else
              call FeQuestButtonDisable(nButtStepBack)
            endif
            if(nStore.gt.1) then
              call FeQuestButtonOff(nButtCompare)
            else
              call FeQuestButtonDisable(nButtCompare)
            endif
            if(nBazVek.le.3.and.BazVek(4,1).eq.1.and.BazVek(4,2).eq.1.
     1                     .and.BazVek(4,3).eq.1) then
              call FeQuestButtonDisable(nButtSuper)
            else
              call FeQuestButtonOff(nButtSuper)
            endif
            write(Radka,103) IndexedAll,NRef
            call Zhusti(Radka)
            write(Cislo,'(f5.1)') float(IndexedAll)/float(NRef)*100.
            call ZdrcniCisla(Cislo,1)
            il=11
            TextInfo(il)(11:)='Indexed :   all '//Radka(:idel(Radka))//
     1                       ' ~ '//Cislo(:idel(Cislo))//'%'
            write(Radka,103) IndexedSel,NRefSel
            call Zhusti(Radka)
            write(Cislo,'(f5.1)') float(IndexedSel)/float(NRefSel)*100.
            call ZdrcniCisla(Cislo,1)
            TextInfo(il)(idel(TextInfo(il))+3:)='selected '//
     1        Radka(:idel(Radka))//' ~ '//Cislo(:idel(Cislo))//'%'
            il=il+1
            TextInfo(il)(10:)='Orientation matrix'
            TextInfo(il)(57:)='Metric tensor'
            do 2610i=1,3
              il=il+1
              write(TextInfo(il)( 3:),'(3f10.6)')(U(i,j),j=1,3)
              write(TextInfo(il)(46:),'(3f10.3)')(G(i,j),j=1,3)
2610        continue
            il=il+1
            write(TextInfo(il)(35:),'(''Volume :'',f10.2)') 1./Vol
            do 2620i=1,2
              il=il+1
              if(i.eq.1) then
                write(TextInfo(il),100) 'Cell parameters:',
     1                                  (CellDatRed(j,1),j=1,6)
              else
                write(TextInfo(il),100) 'e.s.d.:         ',
     1                                  (SCellDatRed(j),j=1,6)
              endif
              Radka(7:7)='3'
              k=k+3
2620        continue
            ypom=yRef
            do 2700il=1,18
              ypom=ypom-7.
              call FeQuestAbsLabelMake(id,xpom,ypom,TextInfo(il),'L')
              if(il.eq.11) then
                ypom=ypom-7.
                call FeQuestAbsLineMake(id,ypom)
              endif
2700        continue
            if(NRef.gt.nmax) then
              if(n2.lt.NRef) then
                call FeUpDownOff(nDown)
              else
                call FeUpDownDisable(nDown)
              endif
              if(n1.gt.1) then
                call FeUpDownOff(nUp)
              else
                call FeUpDownDisable(nUp)
              endif
            endif
2900        icont=0
3000        call FeQuestEvent(id,icont,ich)
            icont=1
            if(CheckType.eq.EventButton.and.
     1         CheckNumber.eq.nButtStepBack) then
              call CopyMat(UStore,U,3)
              call FeQuestButtonOff(nButtStepBack)
              StepBackPossible=.false.
              go to 2500
            else
              call CopyMat(U,UStore,3)
            endif
            if((CheckType.eq.EventKey.and.CheckNumber.eq.JeEscape).or.
     1         (CheckType.eq.EventButton.and.CheckNumber.eq.nButtQuit))
     2        then
              ib=nButtQuit
              if(FeYesNo(-1.,-1.,'Do you really want to quit indexing'//
     1                   ' program?',0)) then
                call FeQuestRemove(id)
                go to 5100
              else
                call FeQuestButtonOff(ib)
                go to 2900
              endif
            else if(CheckType.eq.EventUpDown.and.
     1              (CheckNumber.eq.nDown.or.CheckNumber.eq.nUp)) then
              if(CheckNumber.eq.nDown) then
                m=m+1
              else
                m=m-1
              endif
              go to 2500
            else if(CheckType.eq.EventButton) then
              ib=CheckNumber
              if(CheckNumber.eq.nButtNextTriplet) then
                go to 4790
              else if(CheckNumber.eq.nButtOptions) then
                idp=NextQuestId()
                call FeQuestCreate(idp,-1.,-1.,100.,0,1,
     1                             'Define maximal difference',0,
     2                             LightGray,0,0)
                il=1
                tpom=5.
                xpom=50.
                dpom=40.
                call FeQuestEdwMake(idp,tpom,il,xpom,il,
     1                              '%Delta in degs','L',dpom,EdwYd,0)
                nEdwDelta=EdwLastMade
                call FeQuestRealEdwOpen(EdwLastMade,DiffMax,.false.,
     1                                  .false.)
                icont=0
3100            call FeQuestEvent(idp,icont,ich)
                icont=1
                if(CheckType.ne.0) then
                  call NebylOsetren
                  go to 3100
                endif
                if(ich.eq.0) then
                  call FeQuestRealFromEdw(nEdwDelta,DiffMax)
                endif
                call FeQuestRemove(idp)
                go to 4500
              else if(CheckNumber.eq.nButtStore) then
                if(nStore.ge.10) then
                  call FeChybne(-1.,-1.,'number of stored matrices '//
     1                          'limited to 10',' ',0,SeriousError)
                  go to 4500
                else if(nStore.eq.0) then
                  call FeQuestButtonOff(nButtReStore)
                endif
                nStore=nStore+1
                write(Radka,103) IndexedAll,NRef
                write(Cislo,'(f5.1)') float(IndexedAll)/float(NRef)*100.
                write(StoreLabel(nStore),'(''Volume : '',f6.1)') 1./Vol
                StoreLabel(nStore)=
     1            StoreLabel(nStore)(:idel(StoreLabel(nStore)))//
     2            ' indexed '//Radka(:idel(Radka))//' ~ '//
     3            Cislo(:idel(Cislo))//'%'
                ln=NextLogicNumber()
                call OpenFile(ln,StoreFile,'formatted','unknown')
                if(ErrJana.ne.0) go to 4500
3200            read(ln,FormA80,end=3205) t80
                go to 3200
3205            backspace ln
                write(ln,'(''begin'')')
                write(ln,101) NRef,IndexedAll,NRefSel,IndexedSel,1./Vol
                do 3210i=1,NRef
                  write(ln,102)(Slozky(j,i),j=1,3),FlagS(i),FlagI(i)
3210            continue
                do 3220i=1,3
                  write(ln,102)(U(i,j),j=1,3)
3220            continue
                write(ln,'(''end'')')
                call CloseIfOpened(ln)
c                call OpenFile(ln,'For_Trixie.dat','formatted','unknown')
c                write(ln,'(''cell    '',6f10.4)')(CellDatRed(j,1),j=1,6)
c                write(ln,'(''ort'',i1,3f10.6)')(i,(U(i,j),j=1,3),i=1,3)
c                call CloseIfOpened(ln)
                go to 4500
              else if(CheckNumber.eq.nButtRestore) then
                ln=NextLogicNumber()
                call OpenFile(ln,StoreFile,'formatted','old')
                if(ErrJana.ne.0) go to 4500
3305            i=FeMenu(-1.,-1.,StoreLabel,1,nStore,1,0)
                if(i.ge.1.and.i.le.nStore) then
                  rewind ln
                  n=0
3310              read(ln,FormA80,end=3390) t80
                  if(EqIgCase(t80,'begin')) then
                    n=n+1
                    if(n.ge.i) then
                      read(ln,101,err=3390,end=3390)
     1                  NRef,IndexedAll,NRefSel,IndexedSel,dpom
                      do 3320i=1,NRef
                        read(ln,102,err=3390,end=3390)
     1                    (Slozky(j,i),j=1,3),FlagS(i),FlagI(i)
3320                  continue
                      do 3330i=1,3
                        read(ln,102,err=3390,end=3390)(U(i,j),j=1,3)
3330                  continue
                      go to 3390
                    endif
                  endif
                  go to 3310
                endif
3390            call CloseIfOpened(ln)
                go to 4500
              else if(CheckNumber.eq.nButtCompare) then
                call SetStringArrayTo(TextInfo,3,' ')
                idp=NextQuestId()
                Radka='Relationship between stored lattices'
                StringL=SmallFontWidth*42.
                xqd =2.*StringL+15.
                xqdp=xqd*.5
                call FeQuestCreate(idp,-1.,-1.,xqd,NStore+1,3,Radka,0,
     1                             LightGray,-1,0)
                ypom=QuestLength(idp)-10.
                xpom=xpom+StringL*.5
                Radka='Lattice #1'
                call FeQuestAbsLabelMake(idp,xpom,ypom,Radka,'C')
                xpom=xpom+StringL+5.
                Radka='Lattice #2'
                call FeQuestAbsLabelMake(idp,xpom,ypom,Radka,'C')
                xpom=5.
                tpom=xpom+StringL+5.
                il=1
                do 3420i=1,NStore
                  il=il+1
                  call FeQuestSelwMake(idp,xpom,il,StoreLabel(i),
     1                                 StringL,SelwYd,1,1)
                  call FeQuestSelwOpen(SelwLastMade,i.eq.1)
                  if(i.eq.1) nSelwFirst=SelwLastMade
                  call FeQuestSelwMake(idp,tpom,il,StoreLabel(i),
     1                                 StringL,SelwYd,1,2)
                  call FeQuestSelwOpen(SelwLastMade,i.eq.1)
3420            continue
                call SetIntArrayTo(isel,2,1)
3450            call OpenFile(ln,StoreFile,'formatted','old')
                do 3480ii=1,2
                  rewind ln
                  k=0
3460              read(ln,FormA80,end=3480) t80
                  if(EqIgCase(t80,'begin')) then
                    k=k+1
                    if(k.ge.isel(ii)) then
                      read(ln,101,err=3480,end=3480)
     1                       NRef,IndexedAll,NRefSel,IndexedSel,dpom
                      do 3462i=1,NRef
                        read(ln,102,err=3480,end=3480)
     1                       (Slozky(j,i),j=1,3),FlagS(i),FlagI(i)
3462                  continue
                      do 3464i=1,3
                        read(ln,102,err=3480,end=3480)(Tt(i,j),j=1,3)
3464                  continue
                      if(ii.eq.1) then
                        call CopyVek(Tt,U,9)
                      else
                        call matinv(Tt,Ui,pom,3)
                      endif
                      go to 3480
                    endif
                  endif
                  go to 3460
3480            continue
                call CloseIfOpened(ln)
                call multm(Ui,U,Tt,3,3,3)
                call TrMat(Tt,T,3,3)
                ypom=QuestLength(idp)-float(NStore+1)*10.
                ypom=ypom-7.
                Radka='Twinning matrix #1 to #2'
                call FeQuestAbsLabelMake(idp,xqdp,ypom,Radka,'C')
                xpom=xqdp-12.*SmallFontWidth
                do 3482il=1,3
                  ypom=ypom-7.
                  call FeQuestAbsLabelRemove(idp,xpom,ypom,TextInfo(il),
     1                                       'L')
                  write(TextInfo(il),'(3f8.4)')(T(il,i),i=1,3)
                  call FeQuestAbsLabelMake(idp,xpom,ypom,TextInfo(il),
     1                                     'L')
3482            continue
                icont=0
3490            call FeQuestEvent(idp,icont,ich)
                icont=1
                if(CheckType.eq.EventSelw) then
                  i=CheckNumber-nSelwFirst+1
                  ii=mod(i-1,2)+1
                  i=(i-1)/2+1
                  isel(ii)=i
                  go to 3450
                else if(CheckType.ne.0) then
                  call NebylOsetren
                  go to 3490
                endif
                call FeQuestRemove(idp)
                go to 4500
              else if(CheckNumber.eq.nButtSave) then
                call FeFileManager('Select output peak table file',
     1                             FileIn,'*.ta*',0,.true.,ich)
                if(ich.eq.0) then
                  if(ExistFile(FileIn)) then
                    NInfo=1
                    TextInfo(1)='The file "'//FileIn(:idel(FileIn))//
     1                          '" already exists'
                    if(.not.FeYesNoHeader(-1.,-1.,
     1                 'Do you want to rewrite it?',0)) go to 4500
                  endif
                  ln=NextLogicNumber()
                  call OpenFile(ln,FileIn,'formatted','unknown')
                  if(ErrJana.ne.0) go to 3550
                  write(Cislo,FormI15) NRef
                  call Zhusti(Cislo)
                  write(ln,FormA1)(Cislo(i:i),i=1,idel(Cislo))
                  write(ln,104)((Slozky(j,i)*LamAveD(6),j=1,4),Int(i),
     1                          FlagK(i),i=1,NRef)
                  do 3510i=1,3
                    write(ln,104)( U(i,j)*LamAveD(6),j=1,3)
                    write(ln,104)(SU(i,j)*LamAveD(6),j=1,3)
3510              continue
                  do 3520i=1,3
                    write(ln,104)( G(i,j)*LamAveD(6)**2,j=1,3)
                    write(ln,104)(SG(i,j)*LamAveD(6)**2,j=1,3)
3520              continue
                  write(ln,'(2i10)') 0,1
3550              call CloseIfOpened(ln)
                endif
                go to 4500
              else if(CheckNumber.eq.nButtNewSelect) then
                call FeQuestRemove(id)
                MameMatici=.true.
                go to 1300
              else if(CheckNumber.eq.nButtReduce) then
                call UnitMat(T,3)
                call Redukce(CellDatRed,T)
                call TrMat(T,Tt,3,3)
                call matinv(Tt,T,det,3)
              else if(CheckNumber.eq.nButtMatrix) then
                call UnitMat(T,3)
                call FeReadRealMat(-1.,-1.,'Transformation matrix',
     1            SmbABC,IdAddPrime,t,ti,3,CheckSingYes,CheckPosDefYes,
     2            ich)
                if(ich.ne.0) go to 4500
                call TrMat(Ti,T,3,3)
              else if(CheckNumber.eq.nButtDouble) then
                call UnitMat(T,3)
                call DRDoubleCell(T,CellDatRed,k)
                call matinv(T,Ti,det,3)
                call TrMat(Ti,T,3,3)
              else if(CheckNumber.eq.nButtSuper) then
                idp=NextQuestId()
                xqd=155.
                dpom=70.
                xqdp=xqd*.5
                ilm=(nBazVek-1)/2+1
                call FeQuestCreate(idp,-1.,-1.,xqd,ilm,1,' ',0,
     1                             LightGray,0,0)
                il=0
                xpom=5.
                do 3650i=1,nBazVek
                  il=il+1
                  Radka='('
                  kk=2
                  do 3620j=1,3
                    ik(1)=BazVek(j,i)
                    ik(2)=BazVek(4,i)
                    call MinMultMaxFract(ik,2,k,MaxFract)
                    do 3610k=1,2
                      ik(k)=ik(k)/MaxFract
3610                continue
                    if(ik(1).eq.0) then
                      Radka(kk:kk+1)='0,'
                    else if(ik(1).eq.1.and.ik(2).eq.1) then
                      Radka(kk:kk+1)='1,'
                    else
                      write(Radka(kk:),'(i3,''/'',i3,'','')') ik
                    endif
                    call Zhusti(Radka)
                    kk=idel(Radka)
                    if(j.eq.3) then
                      Radka(kk:kk)=')'
                    else
                      kk=kk+1
                    endif
3620              continue
                  call FeQuestSelwMake(idp,xpom,il,Radka,dpom,SelwYd,0,
     1                                 0)
                  call FeQuestSelwOpen(SelwLastMade,.true.)
                  if(i.eq.1) nSelwFirst=SelwLastMade
                  if(il.eq.ilm) then
                    il=0
                    xpom=xpom+dpom+5.
                  endif
3650            continue
                il=ilm+1
                dpom=40.
                xpom=xqdp-dpom-5.
                call FeQuestButtonMake(idp,xpom,il,dpom,ButYd,
     1                                 '%Refresh')
                nButtRefresh=ButtonLastMade
                call FeQuestButtonOpen(ButtonLastMade,ButtonOff)
                xpom=xpom+dpom+10.
                call FeQuestButtonMake(idp,xpom,il,dpom,ButYd,
     1                                 'Select %all')
                nButtAll=ButtonLastMade
                call FeQuestButtonOpen(ButtonLastMade,ButtonOff)
3700            icont=0
3710            call FeQuestEvent(idp,icont,ich)
                icont=1
                if(CheckType.eq.EventButton) then
                  if(CheckNumber.eq.nButtRefresh) then
                    k=0
                  else if(CheckNumber.eq.nButtAll) then
                    k=1
                  endif
                  nSelw=nSelwFirst
                  do 3800i=1,nBazVek
                    call FeQuestSelwOpen(nSelw,k.eq.1)
                    nSelw=nSelw+1
3800              continue
                  call FeQuestButtonOff(CheckNumber)
                  go to 3700
                else if(CheckType.ne.0) then
                  call NebylOsetren
                  go to 3710
                endif
                if(ich.eq.0) then
                  nSelw=nSelwFirst
                  do 3820i=1,nBazVek
                    BazVekFlag(i)=SelwLogicQuest(nSelw)
                    nSelw=nSelw+1
3820              continue
                  IVolMax=0
                  do 3900i=1,nBazVek-2
                    if(.not.BazVekFlag(i)) go to 3900
                    do 3830n=1,3
                      Ti(n,1)=float(BazVek(n,i))/float(BazVek(4,i))
3830                continue
                    do 3890j=i+1,nBazVek-1
                      if(.not.BazVekFlag(j)) go to 3890
                      do 3832n=1,3
                        Ti(n,2)=float(BazVek(n,j))/float(BazVek(4,j))
3832                  continue
                      do 3880k=j+1,nBazVek
                        if(.not.BazVekFlag(k)) go to 3880
                        do 3834n=1,3
                          Ti(n,3)=float(BazVek(n,k))/float(BazVek(4,k))
3834                    continue
                        call matinv(Ti,Tt,Vol,3)
                        if(Vol.gt..0001) then
                          IVol=nint(1./Vol)
                          if(IVol.ge.IVolMax) then
                            call multm(UStore,Ti,U,3,3,3)
                            call CellFromUB
                            CosAlfa=cos(CellDatRed(4,1)*ToRad)
                            CosBeta=cos(CellDatRed(5,1)*ToRad)
                            CosGama=cos(CellDatRed(6,1)*ToRad)
                            Ang=sqrt(1.-CosAlfa**2-CosBeta**2-CosGama**2
     1                               +2.*CosAlfa*CosBeta*CosGama)
                            if(IVol.gt.IVolMax) AngMax=0.
                            if(Ang.gt.AngMax) then
                              call CopyMat(Ti,T,3)
                              IVolMax=IVol
                              AngMax=Ang
                            endif
                          endif
                        endif
3880                  continue
3890                continue
3900              continue
                endif
                call FeQuestRemove(idp)
                if(ich.ne.0) go to 4500
              else if(CheckNumber.eq.nButtRefine) then
                call SetRealArrayTo(am,9,0.)
                call SetRealArrayTo(ps,9,0.)
                do 4060i=1,NRef
                  if(FlagI(i).eq.0) go to 4060
                  do 4010j=1,3
                    hp(j)=anint(ha(j,i))
4010              continue
                  do 4030j=1,3
                    do 4020k=j,3
                      AM(j,k)=AM(j,k)+hp(j)*hp(k)
4020                continue
4030              continue
                  do 4050j=1,3
                    do 4040k=1,3
                      PS(j,k)=PS(j,k)+Slozky(j,i)*hp(k)
4040                continue
4050              continue
4060            continue
                am(2,1)=am(1,2)
                am(3,1)=am(1,3)
                am(3,2)=am(2,3)
                call matinv(AM,AMinv,det,3)
                call Multm(PS,AMinv,U,3,3,3)
                if(IndexedAll.le.3) go to 4500
                do 4100j=1,3
                  pom=0.
                  do 4080i=1,NRef
                    if(FlagI(i).eq.0) go to 4080
                    do 4070k=1,3
                      hp(k)=anint(ha(k,i))
4070                continue
                    pp=Slozky(j,i)
                    do 4075k=1,3
                      pp=pp-U(j,k)*hp(k)
4075                continue
                    pom=pom+pp**2
4080              continue
                  pom=sqrt(pom/float(IndexedAll-3))
                  do 4090k=1,3
                    SU(j,k)=pom*sqrt(AMinv(k,k))
4090              continue
4100            continue
                call DRSCellFromSUB(U,SU,SCellDatRed,Vol,SVol,G,SG)
                go to 4500
              endif
              StepBackPossible=.true.
              call multm(UStore,T,U,3,3,3)
4500          call FeQuestButtonOff(ib)
              go to 2500
            else if(CheckType.ne.0) then
              call NebylOsetren
              go to 3000
            endif
4790        call FeQuestRemove(id)
            if(TakeUBFromFile.ne.0) go to 5100
4800      continue
4900    continue
5000  continue
      NInfo=2
      TextInfo(1)='The last triplet has been used. Now you can either'//
     1            ' make'
      TextInfo(2)='another selection or quit the indexation program.'
      if(FeYesNoHeader(-1.,-1.,'Do you want to try another selection?',
     1                 0)) then

        MameMatici=.true.
        go to 1300
      endif
5100  if(NStore.le.1) go to 9999
9999  call CloseIfOpened(ln)
      call DeleteFile(PreviousM50)
      return
100   format(a16,3f9.4,3f8.3)
101   format(4i5,f10.1)
102   format(3f10.6,2i5)
103   format(i3,'/',i3)
104   format(4e21.11e4,i11,i6)
      end
      subroutine DRKumaIndexLimits(KumaInput,sinthlMin,sinthlMax,
     1                             RelIMin,RelIMax,Indexace,ich)
      include 'params.cmn'
      include 'basic.cmn'
      include 'datred.cmn'
      include 'fepc.cmn'
      character*80  t80
      logical Indexace,CrwLogicQuest
      id=NextQuestId()
      xqd=220.
      if(KumaInput.ne.1.and.KumaInput.ne.2) then
        il=4
      else
        il=2
      endif
      call FeQuestCreate(id,-1.,-1.,xqd,0,il,
     1  'Define subset of reflections to be used resp. exported',0,
     2  LightGray,0,0)
      il=1
      t80='Mi%n(sin(th)/lam)'
      tpom=5.
      xpom=tpom+FeTxLengthUnder(t80)+3.
      dpom=35.
      call FeQuestEdwMake(id,tpom,il,xpom,il,t80,'L',dpom,EdwYd,0)
      nEdwSinthlMin=EdwLastMade
      call FeQuestRealEdwOpen(EdwLastMade,sinthlMin,.false.,.false.)
      t80='Ma%x(sin(th)/lam)'
      tpom=tpom+100.
      xpom=xpom+100.
      call FeQuestEdwMake(id,tpom,il,xpom,il,t80,'L',dpom,EdwYd,0)
      nEdwSinthlMax=EdwLastMade
      call FeQuestRealEdwOpen(EdwLastMade,sinthlMax,.false.,.false.)
      il=il+1
      if(KumaInput.ne.1.and.KumaInput.ne.2) then
        t80='M%in(I/sig(I))'
      else
        t80='Im%in'
      endif
      tpom=tpom-100.
      xpom=xpom-100.
      call FeQuestEdwMake(id,tpom,il,xpom,il,t80,'L',dpom,EdwYd,0)
      nEdwIMin=EdwLastMade
      call FeQuestRealEdwOpen(EdwLastMade,RelIMin,.false.,.false.)
      if(KumaInput.ne.1.and.KumaInput.ne.2) then
        t80='M%ax(I/sig(I))'
      else
        t80='Im%ax'
      endif
      tpom=tpom+100.
      xpom=xpom+100.
      call FeQuestEdwMake(id,tpom,il,xpom,il,t80,'L',dpom,EdwYd,0)
      nEdwIMax=EdwLastMade
      call FeQuestRealEdwOpen(EdwLastMade,RelIMax,.false.,.false.)
      if(KumaInput.ne.1.and.KumaInput.ne.2) then
        il=il+1
        call FeQuestLineMake(id,il)
        il=il+1
        xpom=5.
        tpom=xpom+CrwgXd+3.
        do 1110i=1,2
          if(i.eq.1) then
            t80='Make %indexing'
          else
            t80='%Export reflection to KUMA tab file'
          endif
          call FeQuestCrwMake(id,tpom,il,xpom,il,t80,'L',CrwgXd,CrwgYd,
     1                        0,1)
          call FeQuestCrwOpen(CrwLastMade,i.eq.1)
          if(i.eq.1) nCrwIndex=CrwLastMade
          xpom=xpom+80.
          tpom=tpom+80.
1110    continue
      endif
      icont=0
1140  call FeQuestEvent(id,icont,ich)
      icont=1
      if(CheckType.ne.0) then
        call NebylOsetren
        go to 1140
      endif
      if(ich.eq.0) then
        if(KumaInput.ne.1.and.KumaInput.ne.2)
     1    Indexace=CrwLogicQuest(nCrwIndex)
        call FeQuestRealFromEdw(nEdwSinthlMin,sinthlMin)
        call FeQuestRealFromEdw(nEdwSinthlMax,sinthlMax)
        call FeQuestRealFromEdw(nEdwIMin,RelIMin)
        call FeQuestRealFromEdw(nEdwIMax,RelIMax)
      endif
      call FeQuestRemove(id)
      return
      end
      subroutine DRKumaIndexDefOpt(Method,VolMin,VolMax,VolAMin,ich)
      include 'params.cmn'
      include 'basic.cmn'
      include 'fepc.cmn'
      character*80 Radka
      logical CrwLogicQuest
      id=NextQuestId()
      xqd=210.
      il=3
      call FeQuestCreate(id,-1.,-1.,xqd,0,il,'Define parameters for '//
     1                   'indexation',0,LightGray,0,0)
      xpom=5.
      tpom=20.
      do 1000il=1,2
        if(il.eq.1) then
          Radka='prefer %larger volume'
        else if(il.eq.2) then
          Radka='prefer %angles closer 90 deg'
        endif
        call FeQuestCrwMake(id,tpom,il,xpom,il,Radka,'L',CrwgXd,CrwgYd,
     1                      1,1)
        call FeQuestCrwOpen(CrwLastMade,Method.eq.il)
        if(il.eq.1) then
          nCrwVolume=CrwLastMade
        else if(il.eq.2) then
          nCrwAngles=CrwLastMade
        endif
1000  continue
      xpom=tpom+FeTxLengthUnder(Radka)+15.
      dpom=40.
      tpom=xpom+dpom+5.
      do 1100il=1,3
        if(il.eq.1) then
          Radka='AngVolume(%min)'
          pom=VolAMin
        else if(il.eq.2) then
          Radka='Volume(mi%n)'
          pom=VolMin
        else if(il.eq.3) then
          Radka='Volume(ma%x)'
          pom=VolMax
        endif
        call FeQuestEdwMake(id,tpom,il,xpom,il,Radka,'L',dpom,
     1                      EdwYd,0)
        if(il.eq.3.or.il.eq.Method)
     1    call FeQuestRealEdwOpen(EdwLastMade,pom,.false.,.false.)
        if(il.eq.1) then
          nEdwMinAngVol=EdwLastMade
        else if(il.eq.2) then
          nEdwMinVol=EdwLastMade
        else if(il.eq.3) then
          nEdwMaxVol=EdwLastMade
        endif
1100  continue
1400  icont=0
1500  call FeQuestEvent(id,icont,ich)
      icont=1
      if(CheckType.eq.EventCrw) then
        if(CheckNumber.eq.nCrwVolume) then
          call FeQuestEdwClose(nEdwMinVol)
          call FeQuestRealEdwOpen(nEdwMinAngVol,VolAMin,.false.,.false.)
        else if(CheckNumber.eq.nCrwAngles) then
          call FeQuestEdwClose(nEdwMinAngVol)
          call FeQuestRealEdwOpen(nEdwMinVol,VolMin,.false.,.false.)
        endif
        go to 1400
      else if(CheckType.ne.0) then
        call NebylOsetren
        go to 1500
      endif
      if(ich.eq.0) then
        if(CrwLogicQuest(nCrwVolume)) then
          Method=1
          call FeQuestRealFromEdw(nEdwMinAngVol,VolAMin)
        else
          Method=2
          call FeQuestRealFromEdw(nEdwMinVol,VolMin)
        endif
        call FeQuestRealFromEdw(nEdwMaxVol,VolMax)
      endif
      call FeQuestRemove(id)
      return
      end
      subroutine DRKUMARefine(FileType)
      parameter (mxi=15000)
      include 'params.cmn'
      include 'basic.cmn'
      include 'datred.cmn'
      include 'fepc.cmn'
      dimension Slozky(4,mxi),Int(mxi),in(2),SlozkyP(4),UBFromFile(3,3),
     1          U(3,3),Ui(3,3),hp(6),c(3),xp(3),iha(6,mxi),
     2          AM(225),PS(18),Ugen(18),AMInv(225),SuGen(18),SU(3,3),
     3          G(3,3),SG(3,3),SCellDatRed(6),Uq(9),SUq(9),Uqp(9),
     4          SUqp(9),squ(3,3),BraggTh(mxi),h3(3),dtdgi(6),dtdrcp(6),
     5          dtdh3(3),der(15),sol(15),QuSave(3,3)
      character*256 FileIn,FileLst,t256
      character*100 Radka
      character*20  Men(2)
      character*8 Nazev
      character*1 znc
      integer FlagKP,FlagI(mxi),EdwStateQuest,FeMenu,FileType
      logical FeYesNoHeader,lpom
      equivalence (u,ub),(ui,ubi)
      data RelIMin,RelIMax/0.,1000000./,sinthlMin,sinthlMax/0.,1./,
     1     DiffMax/.1/,MMax/1/,QuSave/9*0./
      mmax=1
      FileIn=' '
      ln=0
      lni=0
      if(FileType.eq.1) then
        Radka='*.ta*'
      else if(FileType.eq.2) then
        Radka='*.p4p'
      else
        go to 9999
      endif
      call FeFileManager('Select peak table file',FileIn,Radka,0,
     1                   .true.,ich)
      if(ich.ne.0) go to 9999
      ln=NextLogicNumber()
      call OpenFile(ln,FileIn,'formatted','old')
      if(ErrJana.ne.0) go to 9999
      lno=NextLogicNumber()
      FileLst=FileIn
      i=idel(FileLst)
1020  if(FileLst(i:i).ne.'.') then
        i=i-1
        if(i.gt.1) then
          go to 1020
        else
          go to 1030
        endif
      endif
      FileLst(i+1:)=' '
1030  FileLst=FileLst(:i)//'lst'
      call OpenFile(lno,FileLst,'formatted','unknown')
      RelIMin=0.
      RelIMax=1000000.
1040  if(FileType.eq.1) then
        read(ln,FormA80) Radka
        k=0
        call StToInt(Radka,k,in,1,.false.,ich)
        if(ich.ne.0) go to 9999
        NRefMax=in(1)
        KumaInput=1
        NRef=0
        do 1060i=1,NRefMax
          read(ln,104) SlozkyP,IntP,FlagKP
          pom=IntP
          if(pom.lt.RelIMin.or.pom.gt.RelIMax) go to 1060
          do 1050j=1,4
            SlozkyP(j)=SlozkyP(j)/LamAveD(6)
1050      continue
          pom=.5*VecOrtLen(SlozkyP,3)
          if(pom.lt.sinthlMin.or.pom.gt.sinthlMax) go to 1060
          NRef=NRef+1
          if(NRef.gt.mxi) then
            go to 1060
          else
            call CopyVek(SlozkyP,Slozky(1,NRef),4)
            Int(NRef)=IntP
          endif
1060    continue
      else if(FileType.eq.2) then
        NRef=0
1080    read(ln,FormA256,end=1100) t256
        call mala(t256)
        k=0
        call kus(t256,k,Nazev)
        if(Nazev(1:3).eq.'ort') then
          read(Nazev(4:4),'(i1)') i
          call StToReal(t256,k,xp,3,.false.,ich)
          if(ich.ne.0) go to 9999
          do 1090j=1,3
            UBFromFile(i,j)=xp(j)
1090      continue
        else if(Nazev.eq.'ref05'.or.Nazev.eq.'ref1k') then
          NRef=NRef+1
          if(NRef.gt.mxi) go to 1080
          call kus(t256,k,Nazev)
          call StToReal(t256,k,hh,3,.false.,ich)
          if(ich.ne.0) go to 9999
          call StToReal(t256,k,xp,3,.false.,ich)
          if(ich.ne.0) go to 9999
          call StToReal(t256,k,xp,3,.false.,ich)
          if(ich.ne.0) go to 9999
          call StToReal(t256,k,xp,2,.false.,ich)
          if(ich.ne.0) go to 9999
          int(NRef)=nint(xp(1))
          FlagI(NRef)=0
          call StToReal(t256,k,Slozky(1,NRef),3,.false.,ich)
          if(ich.ne.0) go to 9999
        endif
        go to 1080
      endif
1100  if(NRef.gt.mxi) then
        write(Cislo,FormI15) NRef
        call Zhusti(Cislo)
        Radka=Cislo(:idel(Cislo))//' reflections read in exceeds the'//
     1       ' limit of'
        write(Cislo,FormI15) mxi
        call Zhusti(Cislo)
        Radka=Radka(:idel(Radka)+1)//Cislo(:idel(Cislo))//'.'
        call FeChybne(-1.,-1.,Radka,'Please change the limits.',0,
     1                SeriousError)
        call DRKumaIndexLimits(KumaInput,sinthlMin,sinthlMax,RelIMin,
     1                         RelIMax,Indexace,ich)
        if(ich.ne.0) go to 9999
        rewind ln
        go to 1040
      endif
      if(FileType.eq.1) then
        pom=0.
        do 1120i=1,3
          read(ln,104)(UBFromFile(i,j),j=1,3)
          read(ln,104)
          do 1110j=1,3
            UBFromFile(i,j)=UBFromFile(i,j)/LamAveD(6)
            pom=pom+abs(UBFromFile(i,j))
1110      continue
          if(pom.lt..0001) then
            call FeChybne(-1.,-1.,'Orientation matrix is singular',' ',
     1                    0,SeriousError)
            go to 9999
          endif
1120    continue
        close(ln)
      endif
      call CopyVek(UBFromFile,U,9)
      n=0
      id=NextQuestId()
      xqd=150.
      il=6
      Radka='Define modulation vectors'
      call FeQuestCreate(id,-1.,-1.,xqd,0,il,Radka,0,LightGray,-1,0)
      il=1
      tpom=5.
      Radka='%Number of modulation vectors'
      xpom=tpom+FeTxLengthUnder(Radka)+3.
      dpom=15.
      call FeQuestEudMake(id,tpom,il,xpom,il,Radka,'L',dpom,EdwYd,1)
      nEdwNDim=EdwLastMade
      call FeQuestIntEdwOpen(EdwLastMade,0,.false.)
      call FeQuestEudOpen(EdwLastMade,0,3,1,0.,0.,0.)
      xpom=tpom+FeTxLength('XXXX')+3.
      dpom=xqd-xpom-5.
      do 1180i=1,3
        il=il+1
        write(Radka,'(''q('',i1,'')'')') i
        call FeQuestEdwMake(id,tpom,il,xpom,il,Radka,'L',dpom,EdwYd,0)
        if(i.eq.1) nEdwFirstQ=EdwLastMade
1180  continue
      il=il+1
      tpom=5.
      dpom=40.
      Radka='%Maximal satellite index'
      xpom=tpom+FeTxLength(Radka)+3.
      call FeQuestEdwMake(id,tpom,il,xpom,il,Radka,'L',dpom,EdwYd,0)
      nEdwMMax=EdwLastMade
      il=il+1
      Radka='%Delta in degs'
      call FeQuestEdwMake(id,tpom,il,xpom,il,Radka,'L',dpom,EdwYd,0)
      nEdwDelta=EdwLastMade
      call FeQuestRealEdwOpen(EdwLastMade,DiffMax,.false.,.false.)
      icont=0
1190  nEdw=nEdwFirstQ
      do 1195i=1,3
        lpom=.false.
        do 1192j=1,3
          if(abs(QuSave(j,i)).gt..0001) go to 1194
1192    continue
        lpom=.true.
1194    if(i.le.n) then
          if(EdwStateQuest(nEdw).ne.EdwOpened)
     1      call FeQuestRealAEdwOpen(nEdw,QuSave(1,i),3,lpom,.false.)
        else
          call FeQuestEdwClose(nEdw)
        endif
        nEdw=nEdw+1
1195  continue
      if(n.gt.0) then
        if(EdwStateQuest(nEdwMMax).ne.EdwOpened)
     1    call FeQuestIntEdwOpen(nEdwMMax,mmax,.false.)
      else
        call FeQuestEdwClose(nEdwMMax)
      endif
1200  call FeQuestEvent(id,icont,ich)
      icont=1
      if(CheckType.eq.EventEdw.and.CheckNumber.eq.nEdwNDim) then
        call FeQuestIntFromEdw(nEdwNDim,n)
        go to 1190
      else if(CheckType.ne.0) then
        call NebylOsetren
        go to 1200
      endif
      nEdw=nEdwFirstQ
      do 1210i=1,n
        if(i.le.n) then
          call FeQuestRealAFromEdw(nEdw,QuSave(1,i))
        else
          call SetRealArrayTo(QuSave(1,i),3,0.)
        endif
        nEdw=nEdw+1
1210  continue
      call CopyVek(QuSave,Qu(1,1,1,KPhase),9)
      call FeQuestRealFromEdw(nEdwDelta,DiffMax)
      call FeQuestIntFromEdw(nEdwMMax,mmax)
      call FeQuestRemove(id)
c      if(.not.ExistM50) then
        ns=1
        nvt=1
c      endif
      ndim=n+3
      ndimi=n
      call Matinv(U,Ui,Vol,3)
1230  rewind lno
      Indexed=0
      IndexedSat=0
      il=ndim*4+30
      do 1240i=1,NRef
        call Multm(Ui,Slozky(1,i),hp,3,3,1)
        BraggTh(i)=asin(.5*VecOrtLen(Slozky(1,i),3)*LamAveD(6))
        call chngind(hp,iha(1,i),1,c,mmax,1,CheckExtRefNo)
        call multm(U,c,xp,3,3,1)
        znc=' '
        if(asin(.5*VecOrtLen(xp,3)*LamAveD(6))/ToRad.lt.DiffMax) then
          FlagI(i)=1
          Indexed=Indexed+1
          if(iha(4,i).ne.0.or.iha(5,i).ne.0) IndexedSat=IndexedSat+1
          do 1235k=2,nvt
            pom=0.
            do 1244j=1,ndim
              pom=pom+float(iha(j,i))*vt6(j,k,1,KPhase)
1244        continue
            if(abs(anint(pom)-pom).gt..1) then
              znc='*'
              go to 1236
            endif
1235      continue
1236      write(Radka,'(3f8.3,'' => '',6i4)')(hp(j),j=1,3),
     1                 (iha(j,i),j=1,ndim)
        else
          FlagI(i)=0
          write(Radka,'(3f8.3,'' => not indexed !!!'')')(hp(j),j=1,3)
        endif
        write(Radka(il:),'(i10)') Int(i)
        write(lno,FormA1)(Radka(j:j),j=1,idel(Radka)),' ',(znc,j=1,3)
1240  continue
      call SetRealArrayTo(am,ndim*ndim,0.)
      call SetRealArrayTo(ps,3*ndim,0.)
      do 1300i=1,NRef
        if(FlagI(i).eq.0) go to 1300
        do 1250j=1,ndim
          hp(j)=iha(j,i)
1250    continue
        m=0
        do 1270j=1,ndim
          do 1260k=1,ndim
            m=m+1
            AM(m)=AM(m)+hp(j)*hp(k)
1260      continue
1270    continue
        m=0
        do 1290k=1,ndim
          do 1280j=1,3
            m=m+1
            PS(m)=PS(m)+Slozky(j,i)*hp(k)
1280      continue
1290    continue
1300  continue
      call matinv(AM,AMinv,det,ndim)
      call Multm(PS,AMinv,Ugen,3,ndim,ndim)
      do 1400j=1,3
        pom=0.
        do 1380i=1,NRef
          if(FlagI(i).eq.0) go to 1380
          do 1370k=1,ndim
            hp(k)=iha(k,i)
1370      continue
          pp=Slozky(j,i)
          do 1375k=1,ndim
            pp=pp-Ugen(j+(k-1)*3)*hp(k)
1375      continue
          pom=pom+pp**2
1380    continue
        pom=sqrt(pom/float(Indexed-ndim))
        do 1390k=1,ndim
          SUgen(j+(k-1)*3)=pom*sqrt(AMinv(k+(k-1)*ndim))
          if(k.le.3) then
            U(j,k)=Ugen(j+(k-1)*3)
            SU(j,k)=SUgen(j+(k-1)*3)
          else
            Uq(j+(k-4)*3)=Ugen(j+(k-1)*3)
            SUq(j+(k-4)*3)=SUgen(j+(k-1)*3)
          endif
1390    continue
1400  continue
      call Matinv(U,Ui,Vol,3)
      call multm (Ui,Uq,Uqp,3,3,ndimi)
      call multmq(Ui,SUq,SUqp,3,3,ndimi)
      do 1500i=1,3
         quSave(i,1)= Uqp(i)
        squ(i,1)    =SUqp(i)
         quSave(i,2)= Uqp(i+3)
        squ(i,2)    =SUqp(i+3)
1500  continue
      call CellFromUB
      call DRSCellFromSUB(U,SU,SCellDatRed,Vol,SVol,G,SG)
      write(lno,FormA1)
      write(lno,'(''Calculated from refined orientation matrix'')')
      write(lno,'(''=========================================='')')
      write(lno,FormA1)
      if(ndimi.gt.0) then
        NInfo=8
      else
        NInfo=5
      endif
      TextInfo(1)='                     Cell parameters'//
     1            '                   Volume'
      write(Radka,100) 'Cell parameters:',(CellDatRed(j,1),j=1,6),Vol
      TextInfo(2)=Radka(17:)
      write(lno,FormA1)(Radka(i:i),i=1,idel(Radka))
      write(Radka,100) 's.u.:           ',(SCellDatRed(j),j=1,6),SVol
      TextInfo(3)=Radka(17:)
      n=3
      if(ndimi.gt.0) then
        write(lno,FormA1)(Radka(i:i),i=1,idel(Radka))
        write(lno,FormA1)
        Radka=' '
        j=12
        do 1520i=1,ndimi
          write(Radka(j:),'(''q('',i1,''):'')') i
          j=j+26
1520    continue
        TextInfo(4)=Radka
        write(lno,FormA1)(Radka(i:i),i=1,idel(Radka))
        j=1
        do 1540i=1,ndimi
          write(Radka(j:),'(3f8.4)')(QuSave(j,i),j=1,3)
          j=j+26
1540    continue
        write(lno,FormA1)(Radka(i:i),i=1,idel(Radka))
        TextInfo(5)=Radka
        j=1
        do 1560i=1,ndimi
          write(Radka(j:),'(3f8.4)')(squ(j,i),j=1,3)
          j=j+26
1560    continue
        write(lno,FormA1)(Radka(i:i),i=1,idel(Radka))
        TextInfo(6)=Radka
        n=6
      endif
      n=n+1
      write(TextInfo(n),'(i5,'' reflections of all '',i5,
     1                    '' were used'')') Indexed,NRef
      n=n+1
      write(TextInfo(n),'(i5,'' satellites were used'')')
     1      IndexedSat
      Radka='Do you want repeat the refine process?'
      if(FeYesNoHeader(-1.,-1.,Radka,1)) go to 1230
      go to 5000
      write(lno,FormA1)
      write(lno,FormA1)
      write(lno,FormA1)
      write(lno,FormA1)
2000  ncomp=1
      call CopyVek(CellDatRed,CellPar,6)
      ncykl=0
2100  call SetRealArrayTo(am,225,0.)
      call SetRealArrayTo(ps,15,0.)
      npar=6+ndimi*3
      SetMetAllowed=.true.
      call SetMet(0)
      wdy=0
      do 2400n=1,NRef
        if(FlagI(n).eq.0) go to 2400
        call FromIndSinthl(iha(1,n),hp,sinthl,sinthlq,1,0)
        BraggThCalc=asin(sinthl*LamAve(1))
        tth=tan(BraggThCalc)
        pom=tth/sinthlq*.25
        do 2200i=1,6
          call indext(i,k,l)
          dtdgi(i)=pom*hp(k)*hp(l)
2200    continue
        do 2220i=1,3
          dtdrcp(i)=dtdgi(i)*rcp(i,1,KPhase)
          do 2210j=1,3
            if(i.le.2) then
              k=j
            else
              k=j-1
            endif
            if(j.eq.4-i) go to 2210
            dtdrcp(i)=dtdrcp(i)+dtdgi(j+3)*rcp(7-j,1,KPhase)*
     1                                        rcp(k,1,KPhase)
2210      continue
          if(ndimi.gt.0) then
            call multm(MetTensI(1,1,KPhase),hp,dtdh3,3,3,1)
            do 2215j=1,3
              dtdh3(j)=dtdh3(j)*pom
2215        continue
          endif
2220    continue
        do 2230i=4,6
          call indext(i,k,l)
          dtdrcp(10-i)=dtdgi(i)*rcp(k,1,KPhase)*rcp(l,1,KPhase)
2230    continue
        j=1
        der(j)=-dtdrcp(1)*sina(KPhase)/
     1         (Vcos(KPhase)*CellPar(1,1,KPhase)**2)
        j=j+1
        der(j)=-dtdrcp(2)*sinb(KPhase)/
     1         (Vcos(KPhase)*CellPar(2,1,KPhase)**2)
        j=j+1
        der(j)=-dtdrcp(3)*sing(KPhase)/
     1         (Vcos(KPhase)*CellPar(3,1,KPhase)**2)
        j=j+1
        der(j)=
     1    ((dtdrcp(1)/CellPar(1,1,KPhase)*cotgbr(KPhase)*cotggr(KPhase)+
     2      dtdrcp(2)/CellPar(2,1,KPhase)*cotgar(KPhase)/singr(KPhase)+
     3      dtdrcp(3)/CellPar(3,1,KPhase)*cotgar(KPhase)/sinbr(KPhase))/
     4      Vcos(KPhase)+
     5      dtdrcp(4)*sina(KPhase)/(sinb(KPhase)*sing(KPhase))+
     6      dtdrcp(5)*cosgr(KPhase)*sinb(KPhase)/
     7      (sina(KPhase)*sing(KPhase))+
     8      dtdrcp(6)*cosbr(KPhase)*sing(KPhase)/
     9      (sina(KPhase)*sinb(KPhase)))*torad
        j=j+1
        der(j)=
     1    ((dtdrcp(2)/CellPar(2,1,KPhase)*cotggr(KPhase)*cotgar(KPhase)+
     2      dtdrcp(3)/CellPar(3,1,KPhase)*cotgbr(KPhase)/sinar(KPhase)+
     3      dtdrcp(1)/CellPar(1,1,KPhase)*cotgbr(KPhase)/singr(KPhase))/
     4      Vcos(KPhase)+
     5      dtdrcp(5)*sinb(KPhase)/(sina(KPhase)*sing(KPhase))+
     6      dtdrcp(4)*cosgr(KPhase)*sina(KPhase)/
     7      (sinb(KPhase)*sing(KPhase))+
     8      dtdrcp(6)*cosar(KPhase)*sing(KPhase)/
     9      (sinb(KPhase)*sina(KPhase)))*torad
        j=j+1
        der(j)=
     1    ((dtdrcp(3)/CellPar(3,1,KPhase)*cotgar(KPhase)*cotgbr(KPhase)+
     2      dtdrcp(1)/CellPar(1,1,KPhase)*cotggr(KPhase)/sinbr(KPhase)+
     3      dtdrcp(2)/CellPar(2,1,KPhase)*cotggr(KPhase)/sinar(KPhase))/
     4      Vcos(KPhase)+
     5      dtdrcp(6)*sing(KPhase)/(sina(KPhase)*sinb(KPhase))+
     6      dtdrcp(4)*cosbr(KPhase)*sina(KPhase)/
     7      (sing(KPhase)*sinb(KPhase))+
     8      dtdrcp(5)*cosar(KPhase)*sinb(KPhase)/
     9      (sing(KPhase)*sina(KPhase)))*torad
        if(ndimi.gt.0) then
          do 2310k=1,ndimi
            do 2300i=1,3
              j=j+1
              der(j)=float(iha(k+3,n))*dtdh3(i)
2300        continue
2310      continue
        endif
        dy=(BraggTh(n)-BraggThCalc)
        wdy=wdy+dy**2
        m=0
        do 2350j=1,npar
          do 2340k=1,npar
            m=m+1
            AM(m)=AM(m)+der(j)*der(k)
2340      continue
          PS(j)=PS(j)+der(j)*dy
2350    continue
2400  continue
      call matinv(AM,AMinv,det,npar)
      call Multm(AMinv,PS,Sol,npar,npar,1)
      wdy=sqrt(wdy/float(Indexed-npar))
      pom=0.
      ChngRel=-0.1
      do 2450i=1,npar
        pom=pom+abs(Sol(i))
        esd=wdy*sqrt(AMinv(i+(i-1)*npar))
        if(i.le.6) then
          CellPar(i,1,KPhase)=CellPar(i,1,KPhase)+Sol(i)
          SCellDatRed(i)=esd
        else if(i.le.9) then
          quSave(i-6,1)=quSave(i-6,1)+Sol(i)
          squ(i-6,1)=esd
        else if(i.le.12) then
          quSave(i-9,2)=quSave(i-9,2)+Sol(i)
          squ(i-9,2)=esd
        else if(i.le.15) then
          quSave(i-12,3)=quSave(i-12,3)+Sol(i)
          squ(i-12,3)=esd
        endif
        ChngRel=max(abs(Sol(i)/esd),ChngRel)
2450  continue
      ncykl=ncykl+1
      if(ncykl.lt.10.and.ChngRel.gt..01) go to 2100
      CosAlfa=cos(CellPar(4,1,KPhase)*ToRad)
      CosBeta=cos(CellPar(5,1,KPhase)*ToRad)
      CosGama=cos(CellPar(6,1,KPhase)*ToRad)
      SCosAlfa=sin(CellPar(4,1,KPhase)*ToRad)*ToRad*SCellDatRed(4)
      SCosBeta=sin(CellPar(5,1,KPhase)*ToRad)*ToRad*SCellDatRed(5)
      SCosGama=sin(CellPar(6,1,KPhase)*ToRad)*ToRad*SCellDatRed(6)
      PomQ=1.-CosAlfa**2-CosBeta**2-CosGama**2+
     1        2.*CosAlfa*CosBeta*CosGama
      SPomQ=2.*(CosAlfa*SCosAlfa+CosBeta*SCosBeta+
     1          CosGama*SCosGama+
     2          SCosAlfa* CosBeta* CosGama+
     3           CosAlfa*SCosBeta* CosGama+
     4           CosAlfa* CosBeta*SCosGama)
      Pom=sqrt(PomQ)
      SPom=.5/Pom*SPomQ
      AA=CellPar(1,1,KPhase)
      BB=CellPar(2,1,KPhase)
      CC=CellPar(3,1,KPhase)
      SAA=SCellDatRed(1)
      SBB=SCellDatRed(2)
      SCC=SCellDatRed(3)
      Vol=AA*BB*CC*Pom
      SVol=SAA*BB*CC*Pom+AA*SBB*CC*Pom+AA*BB*SCC*Pom+AA*BB*CC*SPom
      write(lno,'(''Calculated from refined theta positions'')')
      write(lno,'(''======================================='')')
      write(lno,FormA1)
      write(lno,100) 'Cell parameters:',(CellPar(j,1,KPhase),j=1,6),Vol
      write(lno,100) 's.u.:           ',(SCellDatRed(j),j=1,6),SVol
      write(lno,FormA1)
      Radka=' '
      j=12
      do 2520i=1,ndimi
        write(Radka(j:),'(''q('',i1,''):'')') i
        j=j+26
2520  continue
      write(lno,FormA1)(Radka(i:i),i=1,idel(Radka))
      j=1
      do 2540i=1,ndimi
        write(Radka(j:),'(3f8.4)')(quSave(j,i),j=1,3)
        j=j+26
2540  continue
      write(lno,FormA1)(Radka(i:i),i=1,idel(Radka))
      j=1
      do 2560i=1,ndimi
        write(Radka(j:),'(3f8.4)')(squ(j,i),j=1,3)
        j=j+26
2560  continue
      write(lno,FormA1)(Radka(i:i),i=1,idel(Radka))
      pom=(CellPar(1,1,KPhase)+CellPar(2,1,KPhase))*.5
      spom=(SCellDatRed(1)+SCellDatRed(2))*.5
      pomq=(quSave(1,1)+quSave(2,1)+
     1      quSave(1,2)-quSave(2,2))*.25
      spomq=(squ(1,1)+squ(2,1)+squ(1,2)+squ(2,2))*.25
      write(lno,FormA1)
      write(lno,'(''a:      '',2f8.4)') pom,spom
      write(lno,'(''c:      '',2f8.4)') CellPar(3,1,KPhase),
     1                                  SCellDatRed(3)
      write(lno,'(''Vol:    '',2f8.2)') Vol,Svol
      write(lno,'(''q(ave): '',2f8.4)') pomq,spomq
      write(lno,FormA1)
      write(lno,FormA1)
      write(lno,FormA1)
5000  write(lno,'(i5,'' reflections of all '',i5,'' were used'')')
     1      Indexed,NRef
      write(lno,'(i5,'' satellites were used'')') IndexedSat
      close(lno)
      call FeEdit(FileLst,0)
9999  call CloseIfOpened(ln)
      call CloseIfOpened(lno)
      return
100   format(a16,3f9.4,3f8.3,f10.2)
101   format(a16,6f8.4)
102   format(a16,6f8.2)
104   format(4e21.11e4,i11,i6)
      end
      subroutine DRSCellFromSUB(U,SU,SCell,Vol,SVol,G,SG)
      include 'const.cmn'
      dimension U(3,3),SU(3,3),SCell(6),AM(3,3),BM(3,3),CM(3,3),G(3,3),
     1          SG(3,3)
      call TrMat(U,AM,3,3)
      call multm(AM,U,G,3,3,3)
      do 1010i=1,3
        do 1000j=1,3
          AM(i,j)=U(i,j)**2
          BM(i,j)=SU(i,j)**2
1000    continue
1010  continue
      call TrMat(AM,CM,3,3)
      call multm(CM,BM,SG,3,3,3)
      call TrMat(BM,CM,3,3)
      call cultm(CM,AM,SG,3,3,3)
      do 1030i=1,3
        do 1020j=1,3
          SG(i,j)=sqrt(SG(i,j))
          if(i.eq.j) SG(i,i)=sqrt(2.)*SG(i,i)
1020    continue
1030  continue
      AR=sqrt(G(1,1))
      BR=sqrt(G(2,2))
      CR=sqrt(G(3,3))
      SA=SG(1,1)/(2.*AR)
      SB=SG(2,2)/(2.*BR)
      SC=SG(3,3)/(2.*CR)
      CosAlfaR=G(2,3)/(BR*CR)
      SCosAlfaR=abs(CosAlfaR)*sqrt((SG(2,3)/G(2,3))**2+(SB/BR)**2+
     1                             (SC/CR)**2)
      SinAlfaR=sqrt(1.-CosAlfaR**2)
      CosBetaR=G(1,3)/(AR*CR)
      SCosBetaR=abs(CosBetaR)*sqrt((SG(1,3)/G(1,3))**2+(SA/AR)**2+
     1                             (SC/CR)**2)
      SinBetaR=sqrt(1.-CosBetaR**2)
      CosGamaR=G(1,2)/(AR*BR)
      SCosGamaR=abs(CosGamaR)*sqrt((SG(1,2)/G(1,2))**2+(SA/AR)**2+
     1                             (SB/BR)**2)
      SinGamaR=sqrt(1.-CosGamaR**2)
      CosinyAR=CosBetaR*CosGamaR-CosAlfaR
      CosinyBR=CosAlfaR*CosGamaR-CosBetaR
      CosinyGR=CosAlfaR*CosBetaR-CosGamaR
      PomQ=1.-CosAlfaR**2-CosBetaR**2-CosGamaR**2
     1      +2.*CosAlfaR*CosBetaR*CosGamaR
      SPomQ=2.*(CosAlfaR*SCosAlfaR+CosBetaR*SCosBetaR+
     1          CosGamaR*SCosGamaR+
     2          SCosAlfaR* CosBetaR* CosGamaR+
     3           CosAlfaR*SCosBetaR* CosGamaR+
     4           CosAlfaR* CosBetaR*SCosGamaR)
      Pom=sqrt(PomQ)
      SPom=.5/Pom*SPomQ
      VolR=AR*BR*CR*Pom
      SVolR=SA*BR*CR*Pom+AR*SB*CR*Pom+AR*BR*SC*Pom+AR*BR*CR*SPom
      Vol=1./VolR
      SVol=1./VolR**2*SVolR
      A=SinAlfaR/(Pom*AR)
      B=SinBetaR/(Pom*BR)
      C=SinGamaR/(Pom*CR)
      SCell(1)=A*sqrt((SA/AR)**2+(CosinyBR*SCosBetaR/PomQ)**2
     1                          +(CosinyGR*SCosGamaR/PomQ)**2
     2                          +(CosinyBR*CosinyGR*SCosAlfaR/
     3                           (PomQ*SinAlfaR)**2)**2)
      SCell(2)=B*sqrt((SB/BR)**2+(CosinyAR*SCosAlfaR/PomQ)**2
     1                          +(CosinyGR*SCosGamaR/PomQ)**2
     2                          +(CosinyAR*CosinyGR*SCosBetaR/
     3                           (PomQ*SinBetaR**2))**2)
      SCell(3)=C*sqrt((SC/CR)**2+(CosinyAR*SCosAlfaR/PomQ)**2
     1                          +(CosinyBR*SCosBetaR/PomQ)**2
     2                          +(CosinyAR*CosinyBR*SCosGamaR/
     3                           (PomQ*SinGamaR**2))**2)
      CosAlfa=CosinyAR/(SinBetaR*SinGamaR)
      CosBeta=CosinyBR/(SinAlfaR*SinGamaR)
      CosGama=CosinyGR/(SinAlfaR*SinBetaR)
      SCosAlfa=sqrt((CosinyGR*SCosBetaR/SinBetaR)**2+
     1              (CosinyBR*SCosGamaR/SinGamaR)**2+
     2              SCosAlfaR**2)
      SCosBeta=sqrt((CosinyGR*SCosAlfaR/SinAlfaR)**2+
     1              (CosinyAR*SCosGamaR/SinGamaR)**2+
     2              SCosBetaR**2)
      SCosGama=sqrt((CosinyBR*SCosAlfaR/SinAlfaR)**2+
     1              (CosinyAR*SCosBetaR/SinBetaR)**2+
     2              SCosGamaR**2)
      SCell(4)=SCosAlfa/(ToRad*sqrt(1-CosAlfa**2))
      SCell(5)=SCosBeta/(ToRad*sqrt(1-CosBeta**2))
      SCell(6)=SCosGama/(ToRad*sqrt(1-CosGama**2))
      return
      end
      subroutine KUMAInit
      include 'params.cmn'
      include 'basic.cmn'
      include 'datred.cmn'
      AlphaKuma=50.385
      BetaKuma=0.05
      Comut=16.
      DegKuma(4)=Comut*100.
      DegKuma(3)=DegKuma(4)
      DegKuma(2)=2.*DegKuma(4)
      DegKuma(1)=DegKuma(2)
      do 1000i=1,4
        StepKuma(i)=DegKuma(i)/ToRad
        RangeOKuma(i)=nint(170.*DegKuma(i))
        OnePi(i)=nint(180.*DegKuma(i))
1000  continue
      StepKuma(2)=2.*StepKuma(2)
      RangeOKuma(2)=2*nint(180.*DegKuma(2))
      RangeOKuma(4)=RangeOKuma(2)
      LoLimKuma(1)=-800000
      LoLimKuma(2)=-322400
      LoLimKuma(3)=-312000
      LoLimKuma(4)= 0
      UpLimKuma(1)= 800000
      UpLimKuma(2)= 528000
      UpLimKuma(3)= 312000
      UpLimKuma(4)= 0
      SlopeKuma=-1.425
      ColimKuma(1)=-144000
      ColimKuma(2)=-288000
      ColimKuma(3)=-122400
      ColimKuma(4)=-493200
      ColimKuma(5)=-327600
      ColimKuma(6)=-82800
      pom=(AlphaKuma-BetaKuma)*ToRad
      sab=sin(pom)
      cab=cos(pom)
      pom=AlphaKuma*ToRad
      sa=sin(pom)
      ca=cos(pom)
      sa2=sa**2
      ca2=ca**2
      sc1=sa*sab/cab
      sc2=sc1**2-ca2
      sc1=sc1-ca
      pom=BetaKuma*ToRad
      sb=sin(pom)
      cb=cos(pom)
      PCorrKuma( 1)=0.
      PCorrKuma( 2)=9.995
      PCorrKuma( 3)=19.985
      PCorrKuma( 4)=29.97
      PCorrKuma( 5)=39.98
      PCorrKuma( 6)=49.96
      PCorrKuma( 7)=59.96
      PCorrKuma( 8)=69.96
      PCorrKuma( 9)=79.96
      PCorrKuma(10)=89.96
      PCorrKuma(11)=99.96
      PCorrKuma(12)=109.96
      PCorrKuma(13)=119.975
      PCorrKuma(14)=129.975
      PCorrKuma(15)=139.985
      PCorrKuma(16)=149.99
      PCorrKuma(17)=160.005
      PCorrKuma(18)=170.005
      PCorrKuma(19)=180.03
      PCorrKuma(20)=190.03
      PCorrKuma(21)=200.05
      PCorrKuma(22)=210.06
      PCorrKuma(23)=220.06
      PCorrKuma(24)=230.07
      PCorrKuma(25)=240.075
      PCorrKuma(26)=250.075
      PCorrKuma(27)=260.08
      PCorrKuma(28)=270.07
      PCorrKuma(29)=280.07
      PCorrKuma(30)=290.07
      PCorrKuma(31)=300.06
      PCorrKuma(32)=310.05
      PCorrKuma(33)=320.05
      PCorrKuma(34)=330.03
      PCorrKuma(35)=340.025
      PCorrKuma(36)=350.01
      PCorrKuma(37)=360.
      TransTheta=0.
      StepsKuma=60
      ModeKuma=1
      Width1=1.5
      Width2=0.35
      Width3=1.00201
      FractKuma=0.
      return
      end
      subroutine AnglesFromHKL(h,psi,A,Rko,ich)
      include 'params.cmn'
      include 'basic.cmn'
      dimension h(3),Rko(3,3),A(4),x(3)
      call multm(ub,h,x,3,3,1)
      call AnglesFromXYZ(x,psi,A,Rko,ich)
      return
      end
      subroutine AnglesFromXYZ(x,Psi,A,Rko,ich)
      dimension Rko(3,3),x(3),A(4)
      call AnglesXYZ(x,A,ich)
      if(Psi.ne.0.) then
        A(1)=A(1)-A(2)
        call AnglesFromRotation(A,Rko,Psi,ich)
      endif
      call RotationalMatrix(Rko,A(3),A(1)-A(2))
      return
      end
      subroutine AnglesXYZ(x,A,ich)
      include 'params.cmn'
      include 'basic.cmn'
      dimension x(3),A(4),Rko(3,3)
      real le
      le=VecOrtLen(x,3)
      if(le.lt.1.0e-7) then
        x(1)=0.
        x(2)=1.
        x(3)=0.
        A(2)=0.
      else
        x(1)=x(1)/le
        x(2)=x(2)/le
        x(3)=x(3)/le
        le=.5*le*LamAve(1)
        A(2)=asin(le)
        call Setting(x,A,Rko,ich)
        A(1)=A(1)+A(2)
      endif
      return
      end
      subroutine Setting(x,A,Rko,ich)
      include 'params.cmn'
      include 'basic.cmn'
      include 'datred.cmn'
      dimension x(3),A(4),Rko(3,3)
      z1=x(3)*cb-x(1)*sb
      if(abs(z1).ge.1.) z1=sign(1.,z1)
      som=z1*cab/sa
      com=Sqrt(1.-som**2)
      tom=som/com
      A(1)=AngKuma(som,com)
      xx=tom**2*sc2
      if(xx.gt.1.) then
        A(3)=-2.*AngKuma(com,sc1*som)
        ska=sin(A(3))
        cka=cos(A(3))
        sph=0.
        cph=1.
      else if(abs(A(1))*stepKuma(1).lt.0.5) then
        som=0.
        com=1.
        A(1)=som
        ska=som
        cka=1.
        A(3)=AngKuma(ska,cka)
        xx=1.
      else
        A(3)=2.0*atan((sqrt(1.-xx)-1.)/(tom*sc1))
        ska=sin(A(3))
        cka=cos(A(3))
        xx=(com*cka-ca*som*ska)
      endif
      x1=x(3)*sb+x(1)*cb
      if(Abs(x1).gt.Abs(xx)) then
        sph=sign(1.,-x1*xx)
        cph=0.
      else if(Abs(x(2)).gt.Abs(xx)) then
        cph=sign(1.,x(2)*xx)
        sph=0.
      else
        sph=-x1/xx
        cph=x(2)/xx
      endif
      A(4)=AngKuma(sph,cph)
      call CopyVek(A,Porig,4)
      psim=rPsi(A(1),A(3),A(4))
      Psi=0.
      call AnglesFromRotation(A,Rko,Psi,ich)
      A(1)=A(1)-A(2)
      return
      end
      function RPsi(oo,ok,op)
      include 'params.cmn'
      include 'basic.cmn'
      include 'datred.cmn'
c      p11= cab*(cos(op)*cb*(cos(oo)*cos(ok)*ca-sin(oo)*sin(ok))+
c     1          cos(oo)*sb*sa)
c      p12=-sab*(cos(oo)*(cos(ok)*sb*ca-cos(op)*cb*sa)
c     1          -sin(oo)*sin(ok)*sb)
c      p13=-sin(op)*cb*(cos(oo)*sin(ok)*ca+sin(oo)*cos(ok))
c      p21= cab*(cos(op)*cos(ok)*cb*sa-sb*ca)
c      p22=-sab*(cos(op)*cb*ca+cos(ok)*sb*sa)
c      p23=-sin(op)*sin(ok)*cb*sa
c      p1 =p11+p12+p13
c      p2 =p21+p22+p23
      f11=cos(oo)*cos(ok)*sb*cb*ca**2*(cos(op)-1)
      f=-sin(op)*cos(oo)*sin(ok)*sb
      h=sin(oo)*sin(ok)*sb*cb*(1-cos(op))
      f12=ca*(cos(oo)*sa*(cos(ok)-1)*(cb**2+cos(op)*sb**2)+h+f)
      f13=cos(oo)*sb*cb*sa**2*(cos(op)-1)
      f14=sin(oo)*sin(ok)*sa*(cb**2+cos(op)*sb**2)
      f15=sin(op)*sin(oo)*cos(ok)*sb
      f21=ca**2*(cb**2+cos(op)*sb**2)
      f22=sb*cb*sa*ca*(cos(op)-1)*(cos(ok)-1)
      f23=sa*(cos(ok)*sa*(cb**2+cos(op)*sb**2)-sin(op)*sin(ok)*sb)
      f1=f11+f12+f13-f14-f15
      f2=f21+f22+f23
      RPsi=AngKuma(f1,f2)
      return
      end
      subroutine RotationalMatrix(R,Kap,Om)
      include 'params.cmn'
      include 'basic.cmn'
      real Kap
      dimension Rk(3,3),Ro(3,3),R(3,3)
      call StoreMatrix(Ro,om,1)
      call StoreMatrix(Rk,kap,2)
      call MultM(Ro,Rk,R,3,3,3)
      return
      end
      subroutine StoreMatrix(R,eta,n)
      include 'params.cmn'
      include 'basic.cmn'
      include 'datred.cmn'
      dimension R(3,3)
      s=sin(eta)
      c=cos(eta)
      call UnitMat(R,3)
      if(n.eq.1) then
        R(1,1)= c
        R(1,2)= s
        R(2,1)=-s
        R(2,2)= c
      else if(n.eq.2) then
        R(1,1)= ca*cab*c+sa*sab
        R(1,2)= ca*s
        R(1,3)= ca*sab*c-sa*cab
        R(2,1)=-cab*s
        R(2,2)= c
        R(2,3)=-sab*s
        R(3,1)= sa*cab*c-ca*sab
        R(3,2)= sa*s
        R(3,3)= sa*sab*c+ca*cab
      else if(n.eq.3) then
        R(1,1)= cb*c
        R(1,2)= s
        R(1,3)= sb*c
        R(2,1)=-cb*s
        R(2,2)= c
        R(2,3)=-sb*s
        R(3,1)=-sb
        R(3,3)=cb
      else if(n.eq.4) then
        R(1,1)= c
        R(1,3)=-s
        R(3,1)= s
        R(3,3)= c
      else if(n.eq.5) then
        R(2,2)= c
        R(2,3)= s
        R(3,2)=-s
        R(3,3)= c
      endif
      return
      end
      subroutine AnglesFromRotation(ANew,X,Psi,ich)
      include 'params.cmn'
      include 'basic.cmn'
      include 'datred.cmn'
      dimension x(3,3),R(3,3),Re(3,3),ANew(4)
      ich=0
      eta=Psi+psim
      call CopyVek(Porig,ANew,4)
      call RotationalMatrix(X,ANew(3),ANew(1))
      if(eta.eq.0.) then
        ANew(1)=ANew(1)+ANew(2)
        go to 9999
      endif
      s=sin(eta)
      c=cos(eta)
      call StoreMatrix(Re,eta,4)
      call MultM(Re,X,R,3,3,3)
      c=(R(3,3)-ca*cab)/(sa*sab)
      if(Abs(c).gt.1.) then
        ich=2
      else
        s=sign(1.,ANew(3))
        s=s*Sqrt(1.-c*c)
        ANew(3)=AngKuma(s,c)
        a=(1.+ca*cab)*c+sa*sab
        b=(ca+cab)*s
        wy=a**2+b**2
        v1=R(1,1)+R(2,2)
        v2=R(1,2)-R(2,1)
        sum=AngKuma((a*v2-b*v1)/wy,(a*v1+b*v2)/wy)
        a=sa*cab*c-ca*sab
        b=sa*s
        wy=a**2+b**2
        v1=R(3,1)
        v2=R(3,2)
        dif=AngKuma((a*v2-b*v1)/wy,(a*v1+b*v2)/wy)
        ANew(1)=sum-dif
        ANew(4)=ANew(4)+dif
1000    if(ANew(4).gt.pi) then
          ANew(4)=ANew(4)-pi2
          go to 1000
        endif
1100    if(ANew(4).lt.-pi) then
          ANew(4)=ANew(4)+pi2
          go to 1100
        endif
        call RotationalMatrix(X,ANew(3),ANew(1))
        ANew(1)=ANew(1)+ANew(2)
      endif
9999  return
      end
      subroutine SetRotKuma(Om,Kappa,Phi,Rot)
      include 'params.cmn'
      include 'basic.cmn'
      include 'datred.cmn'
      dimension Rot(3,3),AM(3,3),BM(3,3)
      real Kappa
      call SetRotMatKuma(Om/ToRad,BetaKuma,1,Rot)
      call SetRotMatKuma(Kappa/ToRad,AlphaKuma,2,AM)
      call MultM(Rot,AM,BM,3,3,3)
      call SetRotMatKuma(Phi/ToRad,BetaKuma,2,AM)
      call MultM(BM,AM,Rot,3,3,3)
      return
      end
      subroutine CheckProblems(uk,iuk,ich)
      include 'params.cmn'
      include 'basic.cmn'
      include 'datred.cmn'
      dimension uk(4),iuk(4),ScW(2)
      integer FromAngle(4),ToAngle(4),a1,ao,ad1,ad2,a2,ac1,ac2
      call AngleInSteps(uk,iuk)
      if(width3.gt.1.) then
        sth=sin(uk(2))*width3
        if(sth.lt.1.) then
          ith=nint(asin(sth)*StepKuma(1))
          iuk(1)=iuk(1)-iuk(2)/2+ith
          iuk(2)=2*ith
        endif
      endif
      ScW(1)=(width1+width2*tan(uk(2)))*DegKuma(1)
      if(abs(uk(2)).gt.TransTheta.and.FractKuma.gt.0.) then
        ScW(2)=ScW(1)*FractKuma
      else
        ScW(2)=0
      endif
      FromAngle(3)=iuk(3)
      FromAngle(4)=iuk(4)
      if(ModeKuma.gt.0) then
        m=StepsKuma-1
        fm=float(m)
        w1=ScW(1)/fm
        FromAngle(1)=iuk(1)-nint(.5*w1*fm)
        w2=ScW(2)/fm
        FromAngle(2)=iuk(2)-nint(.5*w2*fm)
        if(ModeKuma.eq.2) then
          FromAngle(1)=FromAngle(1)+nint(.5*w1)
          FromAngle(2)=FromAngle(2)+nint(.5*w2)
        endif
        call CopyVekI(FromAngle,ToAngle,4)
        ToAngle(1)=FromAngle(1)+nint(w1)*m
        ToAngle(2)=FromAngle(2)+nint(w2)*m
      else
        FromAngle(1)=iuk(1)-ScW(1)*.5
        FromAngle(2)=iuk(2)-ScW(2)*.5
        call CopyVekI(FromAngle,ToAngle,4)
        ToAngle(1)=FromAngle(1)+ScW(1)
        ToAngle(2)=FromAngle(2)+ScW(2)
      endif
      call KOTArea(a1,ao,FromAngle)
      call KOTArea(a2,ao,  ToAngle)
      ich=0
      if(iabs(a1).le.2.and.iabs(a2).le.2.and.a1.eq.a2) then
        call CheckBeam(ad1,ac1,FromAngle,ich)
        call CheckBeam(ad2,ac2,  ToAngle,ich)
        if(ich.eq.0) then
          if(ad1.ne.ad2) then
            ich=4
          else if(ac1.ne.ac2) then
            ich=17
          endif
        endif
      else if(iabs(a1).eq.9.or.iabs(a2).eq.9) then
        ich=3
      else
        ich=5
      endif
      return
      end
      subroutine KOTArea(KO,KOv,A)
      include 'params.cmn'
      include 'basic.cmn'
      include 'datred.cmn'
      integer A(4)
      if(A(2).lt.LoLimKuma(2)) then
        KO=-8
      else if(A(2).gt.UpLimKuma(2)) then
        KO=-7
      else if(A(3).lt.LoLimKuma(3)) then
        KO=-4
      else if(A(3).gt.UpLimKuma(3)) then
        KO=-3
      else if(A(1).lt.LoLimKuma(1)) then
        KO=-6
      else if(A(1).gt.UpLimKuma(1)) then
        KO=-5
      else
        call KOArea(KO,KOv,A(3),A(1))
        if(abs(KO).gt.2) KOv=15
      endif
      return
      end
      subroutine KOArea(KO,KOv,KappaIn,OmIn)
      include 'params.cmn'
      include 'basic.cmn'
      include 'datred.cmn'
      integer OmIn,Om,x
      Kappa=KappaIn
      Om=OmIn
      if(kappa.gt.0) then
        kappa=-kappa
        om=-om
        is=-1
      else
        is= 1
      endif
      KO=0
      if(kappa.ge.ColimKuma(1)) then
        if(om.gt.RangeOKuma(1)) then
          KOv= 7
        else if(om.lt.-RangeOKuma(1)) then
          KOv=-7
        else
          KOv= 0
        endif
      else
        x=nint(-SlopeKuma*float(kappa)+float(om))
        if(x.le.ColimKuma(4)) then
          KO=-1
          if(kappa.lt.-RangeOKuma(3)) then
            if(om.lt.-RangeOKuma(1)) then
              KOv=-3
            else
              KOv=-4
            endif
          else
            if(om.lt.-RangeOKuma(1)) then
              KOv=-7
            else
              KOv=-1
            endif
          endif
        else
          if(x.gt.ColimKuma(5)) then
            KO=-2
            if(kappa.lt.-RangeOKuma(3)) then
              if(om.gt.RangeOKuma(1)) then
                KOv=-6
              else
                KOv=-5
              endif
            else
              if(om.gt.RangeOKuma(1)) then
                KOv= 7
              else
                KOv=-2
              endif
            endif
          else
            KO=-9
            KOv=15
          endif
        endif
      endif
      KO =is*KO
      KOv=is*KOv
      return
      end
      subroutine AngleInSteps(A,AS)
      include 'params.cmn'
      include 'basic.cmn'
      include 'datred.cmn'
      dimension A(4)
      integer AS(4)
      if(abs(A(1)).gt.pi) A(1)=A(1)-sign(pi2,A(1))
      if(A(4).lt.0..or.A(4).ge.pi2) A(4)=A(4)-sign(pi2,A(4))
      do 1000i=1,3
        AS(i)=nint(A(i)*StepKuma(i))
1000  continue
      AS(4)=InPhi(A(4)/ToRad)
      return
      end
      function InPhi(xin)
      include 'params.cmn'
      include 'basic.cmn'
      include 'datred.cmn'
      x=xin
      if(x.gt.360.) x=x-360.
      if(x.lt.  0.) x=x+360.
      n=x*0.1+1.
      InPhi=nint((PCorrKuma(n+1)-(float(n)-0.1*x)*
     1            (PCorrKuma(n+1)-PCorrKuma(n)))*DegKuma(4))
      return
      end
      subroutine CheckBeam(ad,ac,A,ich)
      include 'params.cmn'
      include 'basic.cmn'
      include 'datred.cmn'
      integer ad,ac,aov,A(4)
      i=A(1)-A(2)+OnePi(1)
      if(iabs(i).gt.OnePi(1)) i=i-isign(2*OnePi(1),i)
      call KOArea(ad,aov,A(3),i)
      if(abs(ad).gt.2) then
        ich=4
      else
        i=A(1)+OnePi(1)
        if(iabs(i).gt.OnePi(1)) i=i-isign(2*OnePi(1),i)
        call KOArea(ac,aov,A(3),i)
        if(iabs(ac).gt.2) ich=17
      endif
      return
      end
      function AngKuma(s,c)
      include 'params.cmn'
      include 'basic.cmn'
      include 'datred.cmn'
      ss=s
      cc=c
      if(abs(s*StepKuma(1)).lt..5) then
        ss=0.
        cc=sign(1.,cc)
      endif
      if(cc*StepKuma(1).gt..5) then
        AngKuma=atan(ss/cc)
      else if(cc*StepKuma(1).lt.-.5) then
        AngKuma=atan(ss/cc)+Pi*sign(1.,ss)
      else
        AngKuma=Pi*.5*sign(1.,ss)
      endif
      return
      end
      subroutine DRBruker
      include 'params.cmn'
      include 'basic.cmn'
      include 'fepc.cmn'
      integer FeMenu,WhatToDo
      character*30 Men(3)
      data men/'Indexation procedure',
     1         'Cell refinement',
     2         'Find reflection in *.mul'/
1100  WhatToDo=FeMenu(-1.,-1.,men,1,3,1,0)
      if(WhatToDo.eq.1) then
        call DRKumaIndex(2)
      else if(WhatToDo.eq.2) then
        call DRKumaRefine(2)
      else if(WhatToDo.eq.3) then
        call DRBrukerMul
      endif
      if(WhatToDo.le.0) go to 1100
      return
      end
      subroutine DRBrukerMul
      include 'params.cmn'
      include 'basic.cmn'
      include 'fepc.cmn'
      character*256 FileIn,FileLst,t256
      character*128 CurrentDirO,ActualDir
      character*80 flno,Label
      dimension ih(3),ihp(3),iho(3)
      integer FeChdir
      logical EqIV
      data FileIn,ActualDir/2*' '/,ih/3*0/
      CurrentDirO=CurrentDir
      flno=fln
      if(ActualDir.ne.' ') then
        i=FeChdir(ActualDir)
        call FeGetCurrentDir
      endif
      call FeFileManager('Select the *.mul file',FileIn,'*.mul',0,
     1                   .false.,ich)
      if(ich.ne.0) go to 9999
      ActualDir=CurrentDir
      ln=NextLogicNumber()
      call OpenFile(ln,FileIn,'formatted','old')
      if(ErrJana.ne.0) go to 9999
      IUnderScore=index(FileIn,'_')
      if(IUnderScore.le.0) IUnderScore=index(FileIn,'.')
      if(IUnderScore.le.0) IUnderScore=idel(FileIn)
      call OpenFile(lst,'mul.lst','formatted','unknown')
      id=NextQuestId()
      xqd=200.
      yqd=30.+9.*6.
      call FeQuestAbsCreate(id,-1.,-1.,xqd,yqd,' ',0,LightGray,0,-1)
      tpom=5.
      t256='%Select indices'
      xpom=tpom+FeTxLengthUnder(t256)+3.
      dpom=50.
      ypom=yqd-8.
      call FeQuestAbsEdwMake(id,tpom,ypom,xpom,ypom-3.,t256,'L',dpom,
     1                       EdwYd,0)
      nEdwInd=EdwLastMade
      call FeQuestIntAEdwOpen(EdwLastMade,ih,3,.true.)
      t256='%Find'
      dpom=40.
      xpom=xpom+dpom+40.
      call FeQuestAbsButtonMake(id,xpom,ypom-3.,dpom,ButYd,t256)
      nButtFind=ButtonLastMade
      call FeQuestButtonOpen(nButtFind,ButtonOff)
      ypom=ypom-8.
      call FeQuestAbsLineMake(id,ypom)
      ypomp=ypom
      do 1400i=1,6
        ypom=ypom-8.
        TextInfo(i)=' '
        call FeQuestAbsLabelMake(id,xpom,ypom,TextInfo(i),'L')
1400  continue
      ypom=ypom-10.
      xpom=5.
      icont=0
1500  call FeQuestEvent(id,icont,ich)
      icont=1
1550  if(CheckType.eq.EventButton.and.CheckNumber.eq.nButtFind) then
        call FeQuestIntAFromEdw(nEdwInd,ih)
        call FeQuestEdwClose(nEdwInd)
        write(Cislo,'(3i4)') ih
        Label='Indices to search for: '//Cislo(:idel(Cislo))
        ypom=yqd-8.
        call FeQuestAbsLabelMake(id,xpom,ypom,Label,'L')
        iho(1)=999
        rewind ln
2000    read(ln,FormA256,end=2200) t256
        if(t256(1:1).eq.'!') go to 2000
        read(t256,100) ihp,ri,rs,IBatch,xo,yo,zo,xp,yp,zp,swing,Ang1,
     1                 irt,Chi,Ang2,IComp
        if(.not.eqiv(ih,ihp,3)) then
          if(IComp.lt.0) then
            call CopyVekI(ihp,iho,3)
            rio=ri
            rso=rs
            ICompO=IComp
          else
            iho(1)=999
          endif
          go to 2000
        endif
        if(IComp.lt.0) then
          read(ln,100,end=2200) iho,rio,rso,i,(pom,i=1,8),i,pom,pom,
     1                          ICompO
        endif
        if(irt.eq.2) then
          Omega=Ang1
          Phi=Ang2
          Cislo='omega'
        else
          Omega=Ang2
          Phi=Ang1
          Cislo='phi'
        endif
        ypom=ypomp
        do 2120i=1,6
          ypom=ypom-8.
          call FeQuestAbsLabelRemove(id,xpom,ypom,TextInfo(i),'L')
2120    continue
        write(TextInfo(1),'(''Reflection:'',3i4,2f10.2,1x,a,i3)')
     1    ihp,ri,rs,Cislo(:idel(Cislo)),IComp
        if(iho(1).lt.900) then
          write(t256,'(3i4,2f10.2,1x,a,i3)')
     1      iho,rio,rso,Cislo(:idel(Cislo)),ICompO
          iho(1)=999
        else
          t256=' --- --- ---'
        endif
        write(TextInfo(2),'(''Ovelaped  :'',a)') t256(:idel(t256))
        write(TextInfo(3),'(''Angles    :'',4f9.3)')
     1    swing,Omega,Phi,Chi
        write(TextInfo(4),'(''Observed  :'',3f9.3,i4)') xo,yo,zo,ibatch
        write(TextInfo(5),'(''Predicted :'',3f9.3)') xp,yp,zp
        write(t256,'(''_'',i2,''_'',i4,''.sfrm'')') IBatch,nint(zo)
        do 2125i=1,idel(t256)
          if(t256(i:i).eq.' ') t256(i:i)='0'
2125    continue
        t256=FileIn(:IUnderScore-1)//t256(:idel(t256))
        write(TextInfo(6),'(''File      :'',a)') t256(:idel(t256))
        ypom=ypomp
        do 2130i=1,6
          ypom=ypom-8.
          call FeQuestAbsLabelMake(id,xpom,ypom,TextInfo(i),'L')
2130    continue
        call FeQuestButtonOff(nButtFind)
        call FeQuestButtonLabelChange(nButtFind,'%Find next')
        icont=0
2150    call FeQuestEvent(id,icont,ich)
        icont=1
        if(CheckType.eq.EventButton.and.CheckNumber.eq.nButtFind) then
          go to 2000
        else if(CheckNumber.ne.0) then
          go to 2150
        endif
        go to 2300
2200    icont=0
        call FeQuestButtonOff(nButtFind)
        call FeQuestButtonLabelChange(nButtFind,'%Find')
        ypom=yqd-8.
        call FeQuestAbsLabelRemove(id,xpom,ypom,Label,'L')
        call FeQuestIntAEdwOpen(nEdwInd,ih,3,.true.)
        go to 1500
      else if(CheckType.ne.0) then
        call NebylOsetren
        go to 1500
      endif
2300  call FeQuestRemove(id)
      i=FeChdir(CurrentDirO)
      call FeGetCurrentDir
      fln=flno
9999  call CloseIfOpened(ln)
      call CloseIfOpened(lst)
      return
100   format(3i4,2f8.0,i4,51x,2(2f7.2,f8.2),18x,2f7.2,i2,74x,2f8.3,i4)
      end
      subroutine DRTestDiffractometer
      include 'params.cmn'
      include 'basic.cmn'
      include 'datred.cmn'
      include 'fepc.cmn'
      dimension xp(4),TrXYZ(3,3),ior(3),h(3),xs(4)
      character*256 EdwStringQuest
      character*80 Veta,t80
      character*5  UhelLabel(4)
      character*2 nty
      integer EdwStateQuest
      logical OMFromFile,CrwLogicQuest,FeYesNo
      data ior/1,3,2/,UhelLabel/'Phi','Chi','Omega','Theta'/,
     1     xs/4*0./
      OMFromFile=.true.
      id=NextQuestId()
      xqd=260.
      call FeQuestCreate(id,-1.,-1.,xqd,0,11,'Interactive import',
     1                   0,LightGray,-1,0)
      il=0
      nCrwGroup=1
      Veta='Orientation matrix : from a %file'
      tpom=5.
      xpom=tpom+FeTxLengthUnder(Veta)+5.
      do 1000i=1,2
        il=il+1
        call FeQuestCrwMake(id,tpom,il,xpom,il,Veta,'L',CrwgXd,CrwgYd,
     1                      1,nCrwGroup)
        if(i.eq.1) then
          nCrwOMFromFile=CrwLastMade
        else
          nCrwOMExplicitely=CrwLastMade
        endif
        call FeQuestCrwOpen(CrwLastMade,i.eq.1.eqv.OMFromFile)
        Veta='                     %explicitely'
1000  continue
      il=il-1
      tpom=xpom+CrwgXd+5.
      tpoms=tpom
      Veta='=>'
      xpom=tpom+FeTxLengthUnder(Veta)+3.
      t80='%Browse'
      dpomb=FeTxLengthUnder(t80)+5.
      dpom=xqd-xpom-dpomb-10.
      call FeQuestEdwMake(id,tpom,il,xpom,il,Veta,'L',dpom,EdwYd,0)
      nEdwFile=EdwLastMade
      xpom=xpom+dpom+5.
      call FeQuestButtonMake(id,xpom,il,dpomb,ButYd,t80)
      nButtBrowse=ButtonLastMade
      xpom=tpoms+FeTxLengthUnder('XXXXXXXXXX')+5.
      dpom=xqd-xpom-5.
      il=il+1
      do 1100i=1,3
        write(Veta,'(''=> %'',i1,a2,'' row'')') i,nty(i)
        if(i.gt.1) Veta(1:2)=' '
        call FeQuestEdwMake(id,tpoms,il,xpom,il,Veta,'L',dpom,EdwYd,0)
        if(i.eq.1) nEdwFirstOM=EdwLastMade
        il=il+1
1100  continue
      xpom=0.
      ilp=il
      do 1200i=1,3
        il=il+1
        if(i.eq.1) then
          Veta='Direction towards primary beam'
        else if(i.eq.2) then
          Veta='Direction perpendicular to diffraction plane'
        else if(i.eq.3) then
          Veta='Coplementary direction'
        endif
        call FeQuestLabelMake(id,5.,il,Veta,'L')
        xpom=max(xpom,FeTxLengthUnder(Veta))
1200  continue
      xpom=xpom+15.
      il=ilp
      dpom=CrwgXd+5.
      call UnitMat(TrXYZ,3)
      do 1220i=1,4
        if(i.eq.1) then
          Veta='-'
          k=0
          xdp=CrwXd
          ydp=CrwYd
        else
          Veta=smbx(i-1)
          nCrwGroup=nCrwGroup+1
          k=nCrwGroup
          xdp=CrwgXd
          ydp=CrwgYd
        endif
        call FeQuestLabelMake(id,xpom+.5*xdp,ilp,Veta,'C')
        do 1210il=ilp+1,ilp+3
          call FeQuestCrwMake(id,tpom,il,xpom,il,' ','L',xdp,ydp,
     1                        1,k)
          if(il.eq.ilp+1) then
            if(i.eq.1) then
              nCrwSignFirst=CrwLastMade
            else if(i.eq.2) then
              nCrwXYZFirst=CrwLastMade
            endif
          endif
1210    continue
        xpom=xpom+dpom
1220  continue
      il=ilp+4
      Veta='Indicate angles having opposite sense :'
      call FeQuestLabelMake(id,5.,il,Veta,'L')
      tpom=FeTxLengthUnder(Veta)+10.
      xpom=tpom
      do 1300i=1,4
        xpom=tpom+FeTxLengthUnder(UhelLabel(i))+3.
        call FeQuestCrwMake(id,tpom,il,xpom,il,UhelLabel(i),'L',CrwXd,
     1                      CrwXd,0,0)
        call FeQuestCrwOpen(CrwLastMade,.false.)
        if(i.eq.1) nCrwSenseFirst=CrwLastMade
        tpom=tpom+30.
1300  continue
      il=il+1
      Veta='%Wave length'
      tpom=5.
      xpom=tpom+FeTxLengthUnder(Veta)+5.
      dpom=40.
      call FeQuestEdwMake(id,tpom,il,xpom,il,Veta,'L',dpom,EdwYd,0)
      nEdwWaveLength=EdwLastMade
      call FeQuestRealEdwOpen(EdwLastMade,LamAve(1),.false.,.false.)
      il=il+1
      Veta='(hkl)->Euler'
      dpom=FeTxLengthUnder(Veta)+10.
      call FeQuestButtonMake(id,xqd*.5-dpom-5.,il,dpom,ButYd,Veta)
      nButtHKLToEuler=ButtonLastMade
      call FeQuestButtonOpen(ButtonLastMade,ButtonOff)
      Veta='Euler->(hkl)'
      call FeQuestButtonMake(id,xqd*.5+5.,il,dpom,ButYd,Veta)
      nButtEulerToHKL=ButtonLastMade
      call FeQuestButtonOpen(ButtonLastMade,ButtonOff)
1500  nEdw=nEdwFirstOM
      if(OMFromFile) then
        if(EdwStateQuest(nEdwFile).ne.EdwOpened) then
          do 1510i=1,3
            call FeQuestEdwClose(nEdw)
            nEdw=nEdw+1
1510      continue
          call FeQuestStringEdwOpen(nEdwFile,' ')
          call FeQuestButtonOpen(nButtBrowse,ButtonOff)
        endif
      else
        if(EdwStateQuest(nEdwFile).eq.EdwOpened) then
          call FeQuestEdwClose(nEdwFile)
          call FeQuestButtonClose(nButtBrowse)
          do 1520i=1,3
            do 1515j=1,3
              xp(j)=ub(i,j,1)
1515        continue
            call FeQuestRealAEdwOpen(nEdw,xp,3,.false.,.false.)
            nEdw=nEdw+1
1520      continue
        endif
      endif
1600  nCrw=nCrwXYZFirst
      do 1650i=1,3
        k=0
        do 1640j=1,3
          if(k.eq.0) then
            call FeQuestCrwOpen(nCrw,abs(TrXYZ(ior(j),i)).gt..01)
            if(CrwLogicQuest(nCrw)) k=1
          else
            call FeQuestCrwClose(nCrw)
          endif
          nCrw=nCrw+1
1640    continue
1650  continue
1700  nCrw=nCrwSignFirst
      do 1750i=1,3
        do 1740j=1,3
          pom=TrXYZ(ior(i),j)
          if(abs(pom).gt..01) go to 1745
1740    continue
        go to 1750
1745    call FeQuestCrwOpen(nCrw,pom.lt.-.01)
        nCrw=nCrw+1
1750  continue
1990  icont=0
2000  call FeQuestEvent(id,icont,ich)
      icont=1
      if(CheckType.eq.EventCrw) then
        if(CheckNumber.eq.nCrwOMFromFile) then
          OMFromFile=.true.
        else if(CheckNumber.eq.nCrwOMExplicitely) then
          OMFromFile=.false.
        else if(CheckNumber.ge.nCrwXYZFirst.and.
     1          CheckNumber.le.nCrwXYZFirst+8) then
          k=CheckNumber-nCrwXYZFirst+1
          j=(k-1)/3+1
          i=ior(mod(k-1,3)+1)
          do 2100k=1,3
            if(abs(TrXYZ(k,j)).gt..01) go to 2110
2100      continue
2110      do 2120l=1,3
            if(abs(TrXYZ(i,l)).gt..01) go to 2130
2120      continue
2130      TrXYZ(k,j)=0.
          TrXYZ(i,j)=1.
          TrXYZ(i,l)=0.
          TrXYZ(k,l)=1.
          go to 1600
        else if(CheckNumber.ge.nCrwSignFirst.and.
     1          CheckNumber.le.nCrwSignFirst+2) then
          j=ior(mod(CheckNumber-nCrwSignFirst,3)+1)
          do 2150i=1,3
            TrXYZ(j,i)=-TrXYZ(j,i)
2150      continue
        endif
        go to 1500
      else if(CheckType.eq.EventButton) then
        ib=CheckNumber
        if(ib.eq.nButtHKLToEuler.or.ib.eq.nButtEulerToHKL) then
          call DRIntUpDate(OMFromFile,TrXYZ,nEdwFile,nEdwFirstOM,
     1                     nCrwSenseFirst,nEdwWaveLength)
          if(ErrJana.ne.0) then
            ErrJana=0
            go to 3100
          endif
          Veta=ButtonText(ib+ButtonFr-1)
          idn=NextQuestId()
          xqdp=180.
          call FeQuestCreate(idn,-1.,-1.,xqdp,0,10,Veta,0,LightGray,0,
     1                       -1)
          il=1
          Veta='Orientation matrix'
          call FeQuestLabelMake(idn,xqdp*.5,il,Veta,'C')
          do 3000i=1,3
            il=il+1
            write(Veta,'(3f10.6)')(ub(i,j,1),j=1,3)
            call FeQuestLabelMake(idn,xqdp*.5,il,Veta,'C')
3000      continue
          il=il+1
          Veta='Cell parameters'
          call FeQuestLabelMake(idn,xqdp*.5,il,Veta,'C')
          il=il+1
          write(t80,'(3f9.3,3f9.2)')(CellDatRed(i,1),i=1,6)
          call FeQuestLabelMake(idn,xqdp*.5,il,t80,'C')
          il=il+1
          tpom=5.
          if(ib.eq.nButtHKLToEuler) then
            Veta='%Indices'
            ik=4
          else
            Veta='%Angles'
            ik=3
          endif
          xpom=tpom+FeTxLengthUnder(Veta)+5.
          dpom=xqdp-xpom-5.
          call FeQuestEdwMake(idn,tpom,il,xpom,il,Veta,'L',dpom,EdwYd,0)
          nEdwIndices=EdwLastMade
          pom=0.
          do 3010i=1,7-ik
            pom=pom+abs(xs(i))
3010      continue
          if(pom.gt..001) then
            if(ib.eq.nButtHKLToEuler) then
              if(abs(xs(4)).gt..001) pom=0.
            else
              if(abs(xs(4)).lt..001) pom=0.
            endif
          endif
          call FeQuestRealAEdwOpen(EdwLastMade,xs,7-ik,pom.lt..001,
     1                             .false.)
          il=il+1
          call FeQuestButtonMake(idn,(xqdp-ButYd)*.5,il,ButYd,ButYd,'#')
          nButtCalc=ButtonLastMade
          call FeQuestButtonOpen(ButtonLastMade,ButtonOff)
          il=il+1
          tpom=5.
          do 3020i=1,ik
            Veta=' '
            if(ib.eq.nButtHKLToEuler) then
              Veta=Veta(:10-idel(UhelLabel(i)))//UhelLabel(i)
            else
              Veta(10:10)=indices(i)
            endif
            call FeQuestLabelMake(idn,tpom,il,Veta,'L')
            tpom=tpom+FeTxLengthUnder(Veta)
3020      continue
          ilv=il+1
          t80=' '
c          CheckKeyboard=.true.
3030      ic=0
          call FeQuestEvent(idn,ic,ich)
          ic=1
          if((CheckType.eq.EventButton.and.CheckNumber.eq.nButtCalc).or.
     1       (CheckType.eq.EventKey.and.CheckNumber.eq.JeReturn)) then
            call FeQuestRealAFromEdw(nEdwIndices,xs)
            call FeQuestLabelRemove(idn,5.,ilv,t80,'L')
            if(ib.eq.nButtHKLToEuler) then
              call CopyVek(xs,h,3)
              xs(4)=0.
              call DRHKLToAngles(h,xp)
              write(t80,100) xp
            else
              call DRAnglesToHKL(xs,h)
              write(t80,100) h
            endif
            call FeQuestLabelMake(idn,5.,ilv,t80,'L')
            if(CheckType.eq.EventButton)
     1        call FeQuestButtonOff(CheckNumber)
            go to 3030
          else if(CheckType.ne.0) then
            call NebylOsetren
            go to 3030
          endif
          call FeQuestRemove(idn)
        else if(ib.eq.nButtBrowse) then
          t80=EdwStringQuest(nEdwFile)
          call FeFileManager('Select file with orientation matrix',t80,
     1                       '*.*',0,.true.,ich)
          if(ich.eq.0) call FeQuestStringEdwOpen(nEdwFile,t80)
        endif
3100    call FeQuestButtonOff(ib)
        go to 1990
      else if(CheckType.ne.0) then
        call NebylOsetren
        go to 2000
      endif
      if(.not.FeYesNo(-1.,-1.,'Do you really want to close the testing',
     1   0)) then
        call FeButtonOff(ButtonOK)
        go to 1990
      endif
      call FeQuestRemove(id)
      return
100   format(4f10.3)
      end
      subroutine DRIntUpDate(OMFromFile,TrXYZ,nEdwFile,nEwdFirstOM,
     1                       nCrwSenseFirst,nEdwWaveLength)
      include 'params.cmn'
      include 'basic.cmn'
      include 'datred.cmn'
      include 'fepc.cmn'
      dimension UBPom(9),TrXYZ(3,3)
      character*80  t80
      character*256 EdwStringQuest
      logical CrwLogicQuest,OMFromFile
      call FeQuestRealFromEdw(nEdwWaveLength,LamAve(1))
      if(OMFromFile) then
        t80=EdwStringQuest(nEdwFile)
        ln=NextLogicNumber()
        call OpenFile(ln,t80,'formatted','old')
        if(ErrJana.ne.0) go to 9999
        read(ln,*,err=9000)((ub(i,j,1),j=1,3),i=1,3)
        call TrMat(ub,UBPom,3,3)
        close(ln)
      else
        nEdw=nEwdFirstOM
        j=1
        do 1000i=1,3
          call FeQuestRealAFromEdw(nEdw,UBPom(j))
          nEdw=nEdw+1
          j=j+3
1000    continue
      endif
c      do 1100i=1,9
c        UBPom(i)=UBPom(i)/pi2
c1100  continue
c      do 1100i=1,9
c        UBPom(i)=UBPom(i)/LamA1(1)
c1100  continue
      call TrMat(UBPom,ub,3,3)
      call CellFromUB
      call TrMat(UBPom,ub(1,1,2),3,3)
      call MatInv(TrXYZ,UBPom,pom,3)
      call Multm(UBPom,ub(1,1,2),ub,3,3,3)
      call MatInv(ub,ubi,pom,3)
      nCrw=nCrwSenseFirst
      do 2000i=1,4
        if(CrwLogicQuest(nCrw)) then
          SenseOfAngle(i)=-1.
        else
          SenseOfAngle(i)= 1.
        endif
        nCrw=nCrw+1
2000  continue
      go to 9999
9000  call FeReadError(ln)
      ErrJana=1
9999  return
      end
      subroutine DRAnglesToHKL(Angle,h)
      include 'params.cmn'
      include 'basic.cmn'
      include 'datred.cmn'
      dimension Angle(4),h(3),c(3)
      call DRHKLToCoor(Angle,c)
      call Multm(ubi,c,h,3,3,1)
      return
      end
      subroutine DRHKLToCoor(Angle,c)
      include 'params.cmn'
      include 'basic.cmn'
      include 'datred.cmn'
      dimension Angle(4),c(3),cosarr(4),sinarr(4)
      equivalence (CosFi   ,cosarr(1)),(SinFi   ,sinarr(1)),
     1            (CosChi  ,cosarr(2)),(SinChi  ,sinarr(2)),
     2            (CosOmega,cosarr(3)),(SinOmega,sinarr(3)),
     3            (CosTheta,cosarr(4)),(SinTheta,sinarr(4))
      do 1000i=1,4
        pom=Angle(i)*ToRad*SenseOfAngle(i)
        if(i.eq.3) pom=pom-Angle(4)*ToRad*SenseOfAngle(4)
        cosarr(i)=cos(pom)
        sinarr(i)=sin(pom)
1000  continue
      D=2.*SinTheta/LamAve(1)
      c(1)=-(CosOmega*CosChi*SinFi+SinOmega*CosFi)*D
      c(2)=-(CosOmega*CosChi*CosFi-SinOmega*SinFi)*D
      c(3)=  CosOmega*SinChi                      *D
      return
      end
      subroutine DRHKLToAngles(H,Angle)
      include 'params.cmn'
      include 'basic.cmn'
      include 'datred.cmn'
      dimension h(3),c(3),Angle(4)
      call multm(ub,h,c,3,3,1)
      tmp=sqrt(c(1)**2+c(2)**2+c(3)**2)
      Angle(2)=atan2(c(3),sqrt(c(1)**2+c(2)**2))/ToRad*SenseOfAngle(2)
      if(c(1).ne.0..or.c(2).ne.0.) then
        Angle(1)=atan2(-c(1),-c(2))/ToRad*SenseOfAngle(1)
      else
        Angle(1)=0.
      endif
      Angle(3)=asin(.5*LamAve(1)*tmp)/ToRad*SenseOfAngle(3)
      Angle(4)=Angle(3)
      if(Angle(3).lt.0.) then
        if(Angle(1).gt.0.) then
          Angle(1)=Angle(1)-180.
        else
          Angle(1)=Angle(1)+180.
        endif
        do 1000i=2,4
          Angle(i)=-Angle(i)
1000    continue
      endif
      return
      end
      subroutine DRReadContents(ich)
      include 'params.cmn'
      include 'basic.cmn'
      include 'fepc.cmn'
      character*256 EdwStringQuest
      character*72 formulao
      Formulao=Formula
      ich=0
      id=NextQuestId()
      call FeQuestCreate(id,-1.,-1.,160.,0,2,'Cell contents',0,
     1                   LightGray,0,0)
      call FeQuestEdwMake(id,5.,1,60.,1,'%Formula','L',95.,EdwYd,1)
      nEdwFormula=EdwLastMade
      call FeQuestStringEdwOpen(EdwLastMade,Formula)
      call FeQuestEdwMake(id,5.,2,60.,2,'Formula %units','L',20.,EdwYd,
     1                    0)
      nEdwZ=EdwLastMade
      call FeQuestIntEdwOpen(EdwLastMade,nz,.false.)
      icont=0
1500  call FeQuestEvent(id,icont,ich)
      icont=1
      if(CheckType.eq.EventEdw.and.CheckNumber.eq.nEdwFormula) then
        Formula=EdwStringQuest(nEdwFormula)
        call PitFor(ich)
        if(ich.eq.0) go to 1500
        EventType=EventEdw
        EventNumber=nEdwFormula
        go to 1500
      else if(CheckType.ne.0) then
        call NebylOsetren
        go to 1500
      endif
      if(ich.eq.0) call FeQuestIntFromEdw(nEdwZ,nz)
      call FeQuestRemove(id)
      if(ich.ne.0) Formula=Formulao
9900  return
      end
      subroutine DRGetReflectionFromM95(ln,iend,ich)
      include 'params.cmn'
      include 'basic.cmn'
      include 'datred.cmn'
      include 'profil.cmn'
      character*256 t256
      character*20  FormProf
      logical EqIgCase,eqiv
      data FormProf/'(''  prof1'',15i6)'/
      iend=0
      ich=0
      read(ln,format95,end=2000,err=3000) no,(ih(i),i=1,ndim),uhly,
     1  ri,rs,expos,iflg,corrf,tbar,dircos,DRLam
      read(ln,FormA256,end=1500,err=3000) t256
      k=0
      call kus(t256,k,Cislo)
      if(EqIgCase(Cislo(1:5),'prof0')) then
        read(t256,100) tmn,tmx,omn,omx,rych,NProf,NBckg,KProf
        do 1000k=1,KProf
          read(ln,101)(IProf(i,k),i=1,NProf)
1000    continue
        if(KProf.eq.1) call CopyVekI(IProf(1,1),IProf(1,2),NProf)
      else
        go to 1500
      endif
      go to 9999
1500  backspace ln
      go to 9999
      entry DRPutReflectionToM95(ln)
      if(NProf.gt.0) then
        if(eqiv(IProf(1,1),IProf(1,2),NProf)) then
          KProf=1
        else
          KProf=2
        endif
        if(IntFromProfile) then
          do 1550i=1,NProf
            py(i,KProf)=IProf(i,KProf)
1550      continue
          call BPB(ri,rs,KProf,NBckg)
        endif
      endif
      write(ln,format95) no,(ih(i),i=1,ndim),uhly,ri,rs,expos,iflg,
     1                   corrf,tbar,dircos,DRLam
      if(KProf.gt.0) then
        write(ln,102) tmn,tmx,omn,omx,rych,NProf,NBckg,KProf
        do 1600k=1,KProf
          write(FormProf(9:9),'(i1)') k
          write(ln,FormProf)(IProf(i,k),i=1,NProf)
1600    continue
      endif
      go to 9999
2000  iend=1
      go to 9999
3000  ich=1
9999  return
100   format(8x,5f7.2,3i5)
101   format(8x,15i6)
102   format('  prof0',5f7.2,3i5)
      return
      end

