      subroutine editm40
      include 'params.cmn'
      include 'basic.cmn'
      include 'atoms.cmn'
      include 'molec.cmn'
      include 'editm40.cmn'
      include 'fepc.cmn'
      dimension  nmen(19)
      character*52 men(19),Menp
      character*2 ext,nmp
      integer FeMenuNew
      logical FeYesNo
      data men/
     1'Editing of the file m%40',
     2'Rename atoms according to chemical t%ypes',
     3'%Transformation of atomic positions',
     4'%Expansion by symmetry operation(s)',
     5'%Merging of symmetry related atoms',
     6'%Replacing/inserting atoms',
     7'%Adding of hydrogen atoms',
     8'%Deleting of atoms',
     9'Change AD%P harmonic parameters',
     a'Adding or deleting a%nharmonic tensors',
     1'Setting or deleting modulation %waves',
     2'Setting or deleting of mult%ipoles',
     3'Setting of refinement %keys',
     4'%Creation of new molecular part',
     5'Mo%ve atoms from molecule to atomic part',
     6'Transformation of M40 and M%50 to various formats',
     7'Ortho%gonalized -> regular waves',
     8'De%fine orthogonalization parameters',
     9'%Undo/Do command'/
      equivalence (IdEdit     ,IdNumbers( 1)),
     2            (IdRename   ,IdNumbers( 2)),
     3            (IdTransform,IdNumbers( 3)),
     4            (IdExpand   ,IdNumbers( 4)),
     5            (IdMerge    ,IdNumbers( 5)),
     6            (IdNewAt    ,IdNumbers( 6)),
     7            (IdAddH     ,IdNumbers( 7)),
     8            (IdDelete   ,IdNumbers( 8)),
     9            (IdTemp     ,IdNumbers( 9)),
     a            (IdAnharm   ,IdNumbers(10)),
     1            (IdMod      ,IdNumbers(11)),
     2            (IdMultip   ,IdNumbers(12)),
     3            (IdRefKeys  ,IdNumbers(13)),
     4            (IdNewMol   ,IdNumbers(14)),
     5            (IdMolToAt  ,IdNumbers(15)),
     6            (IdM40M50   ,IdNumbers(16)),
     7            (IdOrtToNorm,IdNumbers(17)),
     9            (IdDefOrtho ,IdNumbers(18)),
     a            (IdUndo     ,IdNumbers(19))
      call PrelimEditm40
      if(ErrJana.ne.0) go to 9999
      call CopyFile(fln(:ifln)//'.m50',fln(:ifln)//'.l50')
      NM40=0
      open(43,file=fln(:ifln)//'.l99',access='direct',
     1     recl=13*RecLenFacForm,form='formatted')
      Menp='The original M40 file'
      write(43,100,rec=NM40+1) Menp
      if(ErrJana.ne.0) return
1000  call SetMolName
      n=0
      if(ndim.eq.4) then
        do 1100i=1,nacalc
          if(kfs(i).ne.0.or.kfx(i).ne.0) then
            n=1
            go to 1110
          endif
1100    continue
      endif
1110  do 1450j=1,19
        nmen(j)=0
        if(j.eq.IdAnharm) then
          if(nac.le.0) go to 1450
        else if(j.eq.IdMod.or.j.eq.IdDefOrtho) then
          if(ndimi.le.0.or.(j.eq.IdDefOrtho.and.n.le.0).or.
     1       (j.eq.IdMod.and.nac.le.0.and.nmolc.le.0)) go to 1450
        else if(j.eq.IdTransform.or.j.eq.IdExpand.or.j.eq.IdMerge.or.
     1          j.eq.IdAddH.or.j.eq.IdDelete.or.j.eq.IdTemp.or.
     2          j.eq.IdAnharm.or.j.eq.IdMultip.or.j.eq.IdRefKeys.or.
     3          j.eq.IdNewMol) then
          if((nac.le.0.and.nmolc.le.0).or.
     1       (j.eq.IdMultip.and..not.ChargeDensities)) go to 1450
        else if(j.eq.IdMolToAt) then
          if(nmolc.le.0) go to 1450
        else if(j.eq.IdOrtToNorm) then
          if(ndimi.ne.1.or.nor.le.0.or.(nac.le.0.and.nmolc.le.0))
     1      go to 1450
        else if(j.eq.IdUndo) then
          if(NM40.le.0) go to 1450
        endif
        nmen(j)=1
1450  continue
      j=FeMenuNew(-1.,-1.,men,nmen,1,19,1,0)
      ich=0
      if(j.eq.IdEdit) then
        call vypis(NM40,ich)
      else if(j.eq.IdRename) then
        if(nmolc.gt.0) then
          n=mxa+nacbAll
        else
          n=nacAll
        endif
        call RenameAtomsAccordingToAtomType(n)
      else if(j.eq.IdTransform) then
        call EM40Tr(0,ich)
      else if(j.eq.IdExpand) then
        call EM40Tr(1,ich)
      else if(j.eq.IdMerge) then
        call MergAt(0,ich)
      else if(j.eq.IdNewAt) then
        call NewAt(ich)
      else if(j.eq.IdAddH) then
        call EM40NewAtH(ich)
      else if(j.eq.IdDelete) then
        call ZmDel(ich)
      else if(j.eq.IdTemp) then
        call zmtf(ich)
      else if(j.eq.IdAnharm) then
        call ZmAnh(ich)
      else if(j.eq.IdMod) then
        call ZmVln(ich)
      else if(j.eq.IdMultip) then
        call ZmMultGroup(ich)
      else if(j.eq.IdRefKeys) then
        call ZmKi(ich)
      else if(j.eq.IdNewMol) then
        call newmol(ich)
      else if(j.eq.IdMolToAt) then
        call ZmAtM(ich)
      else if(j.eq.IdM40M50) then
        if(ndim.eq.3) then
          Menp=' '
          call TrM4050(0,Menp,' ',ich)
        else
          call GraphicOutput(0,' ',0,ich)
        endif
        ich=1
      else if(j.eq.IdOrtToNorm) then
        call ZmOrtho(ich)
      else if(j.eq.IdDefOrtho) then
        call DefOrtho(ich)
      else if(j.eq.IdUndo) then
        NM40old=NM40
        id=NextQuestId()
        call FeQuestCreate(id,-1.,-1.,180.,0,2,'The last made change :',
     1                     0,LightGray,0,0)
        if(NM40.gt.0) then
          k=ButtonOff
        else
          k=ButtonDisabled
        endif
        call FeQuestButtonMake(id,  5.,2,50.,ButYd,'Step %back')
        call FeQuestButtonOpen(3,k)
        if(NM40.lt.NM40old) then
          k=ButtonOff
        else
          k=ButtonDisabled
        endif
        call FeQuestButtonMake(id,125.,2,50.,ButYd,'Step %forward')
        call FeQuestButtonOpen(4,k)
2000    read(43,100,rec=NM40+1) Menp
        call DelChar(Menp,'%')
        write(nmp,101) NM40
        call zhusti(nmp)
        idn=idel(nmp)
        call FeQuestLabelMake(id,90.,1,'#'//nmp(1:idn)//' - '//Menp,
     1                        'C')
        call FeQuestEvent(id,0,ich)
        if(CheckType.eq.EventButton.and.CheckNumber.gt.2) then
          if(CheckNumber.eq.3) then
            NM40=max(NM40-1,0)
          else
            NM40=min(NM40+1,NM40old)
          endif
          call FeQuestLabelRemove(id,90.,1,'#'//nmp(1:idn)//' - '//
     1                            Menp,'C')
          if(NM40.ge.NM40old) then
            call FeQuestButtonDisable(4)
          else
            call FeQuestButtonOff(4)
          endif
          if(NM40.le.0) then
            call FeQuestButtonDisable(3)
          else
            call FeQuestButtonOff(3)
          endif
          go to 2000
        else if(CheckType.ne.0) then
          call NebylOsetren
          go to 2000
        endif
        call FeQuestRemove(id)
        if(ich.eq.0.and.ErrJana.eq.0) then
          if(NM40.gt.0) then
            write(ext,101) NM40-1
            if(ext(1:1).eq.' ') ext(1:1)='0'
            call OpenFile(m40,fln(:ifln)//'.l'//ext,'formatted','old')
            if(ErrJana.ne.0) go to 1000
          endif
          call iom40only(0,0)
          if(ErrJana.ne.0) go to 1000
          call CloseIfOpened(m40)
          do 2110k=NM40+1,NM40old
            write(ext,101) k-1
            if(ext(1:1).eq.' ') ext(1:1)='0'
            call DeleteFile(fln(:ifln)//'.l'//ext)
2110      continue
        else
          NM40=NM40old
        endif
      endif
      if(j.ne.0) then
        if(j.ne.IdUndo.and.ich.eq.0) then
          call SavePhase
          NM40old=NM40
          call AddM40(NM40)
          if(ErrJana.ne.0) go to 1000
          if(NM40.gt.NM40old) write(43,100,rec=NM40+1) Men(j)
        endif
        go to 1000
      endif
      if(StructureLocked) NM40=0
      if(NM40.gt.0) then
        if(FeYesNo(-1.,-1.,'Do you want to rewrite M40 file?',1))
     1    then
          go to 3200
        else
          if(.not.FeYesNo(-1.,-1.,
     1                    'Do you really want avoid the changes?',0))
     2      then
            go to 3200
          else
            call CopyFile(fln(:ifln)//'.l50',fln(:ifln)//'.m50')
          endif
        endif
      endif
      go to 3300
3200  call iom40only(1,0)
3300  do 3400j=1,NM40
        write(ext,101) j-1
        if(ext(1:1).eq.' ') ext(1:1)='0'
        call DeleteFile(fln(:ifln)//'.l'//ext)
3400  continue
      close(43,status='delete')
9999  return
100   format(a52)
101   format(i2)
      end
      subroutine AddM40(NM40)
      include 'params.cmn'
      include 'basic.cmn'
      include 'molec.cmn'
      character*80 File1,File2
      character*2 ext
      logical FileDiff
      write(ext,100) NM40
      if(ext(1:1).eq.' ') ext(1:1)='0'
      File1=fln(:ifln)//'.l'//ext
      call CopyFile(fln(:ifln)//'.m40',File1)
      call OpenFile(m40,File1,'formatted','unknown')
      if(ErrJana.ne.0) go to 9999
      call iom40only(1,0)
      if(ErrJana.ne.0) go to 9999
      call CloseIfOpened(m40)
      if(NM40.eq.0) then
        File2=fln(:ifln)//'.m40'
      else
        write(ext,100) NM40-1
        if(ext(1:1).eq.' ') ext(1:1)='0'
        File2=fln(:ifln)//'.l'//ext
      endif
      if(FileDiff(File1,File2)) then
        NM40=NM40+1
      else
        call DeleteFile(File1)
      endif
9999  return
100   format(i2)
      end
      subroutine PrelimEditm40
      include 'params.cmn'
      include 'basic.cmn'
      include 'atoms.cmn'
      include 'fepc.cmn'
      include 'editm40.cmn'
      do 1300i=1,3
        do 1200j=1,24
          call SetRealArrayTo(trm(1,j,i),36,0.)
          call SetRealArrayTo(trv(1,j,i),6,0.)
1200    continue
1300  continue
      call iom50(0,0)
      if(ErrJana.ne.0) go to 9999
      call iom40only(0,0)
9999  return
      end
      subroutine vypis(NM40,ich)
      include 'params.cmn'
      include 'basic.cmn'
      include 'atoms.cmn'
      include 'molec.cmn'
      include 'fepc.cmn'
      character*256 TmpFile
      character*80 File
      ich=0
      if(NM40.gt.0) then
        File=fln(1:ifln)//'.l'
        write(File(ifln+3:ifln+4),'(i2)') NM40-1
        if(File(ifln+3:ifln+3).eq.' ') File(ifln+3:ifln+3)='0'
      else
        File=fln(1:ifln)//'.m40'
      endif
      TmpFile=fln(:ifln)//'_editm40.tmp'
      call CopyFile(File,TmpFile)
      call FeEdit(TmpFile,-1)
      open(m40,file=TmpFile)
      call iom40only(0,0)
      close(m40,status='delete')
      return
      end
      subroutine ZmTF(ich)
      include 'params.cmn'
      include 'basic.cmn'
      include 'atoms.cmn'
      include 'molec.cmn'
      include 'editm40.cmn'
      dimension nmen(4)
      character*50 men(4)
      integer FeMenuNew
      logical Nulovat,FeYesNo
      data men/
     1'Isotropic ADP parameters to %harmonic ones',
     2'Harmonic ADP parameters to %isotropic ones',
     3'Introduce %TLS tensors',
     4'Transform TLS tensors to in%dividual'/
      ich=0
      call DefGroup(i1,i2,0)
      call SetIntArrayTo(nmen,4,1)
      if(i1.le.0) then
        ich=1
        return
      else
        if(i1.le.mxa) call SetIntArrayTo(nmen(3),2,0)
      endif
      pom1=0.
      pom2=0.
      do 1300i=i1,i2
        if((i.gt.nacAll.and.i.le.mxa).or..not.AtBrat(i)) go to 1300
        pom1=pom1+float(min(2,itf(i)))
        pom2=pom2+1.
1300  continue
      if(pom2.lt..1) return
      pom1=pom1/pom2
      if(pom1.gt.1.5) then
        mend=2
      else if(pom1.gt..5) then
        mend=1
      else
        mend=3
      endif
      itfn=FeMenuNew(-1.,-1.,men,nmen,1,4,mend,0)
      if(itfn.lt.1) then
        ich=1
        return
      endif
      if(itfn.eq.3) Nulovat=FeYesNo(-1.,-1.,'Do you want to supress '//
     1                              'individual ADP parameters',1)
      do 5000i=i1,i2
        if((i.gt.nacAll.and.i.le.mxa).or..not.AtBrat(i)) go to 5000
        if(itfn.eq.1) then
          if(itf(i).eq.1) call ZmTF12(i)
        else if(itfn.eq.2) then
          if(itf(i).eq.2) call ZmTF21(i)
        else if(itfn.eq.3) then
          if(itf(i).ne.0) call ZmTF20(i,Nulovat)
        else if(itfn.eq.4) then
          if(itf(i).eq.0) call ZmTF02(i)
        endif
5000  continue
      return
      end
      subroutine ZmTF12(i)
      include 'params.cmn'
      include 'basic.cmn'
      include 'atoms.cmn'
      integer PrvKi
      itf(i)=2
      pom=beta(1,i)
      spom=sbeta(1,i)
      PrvKi=PrvniKiAtomu(i)+4
      do 1000j=1,3
        beta(j,i)=pom*prcp(j,iswa(i),KPhase)
        sbeta(j,i)=spom*prcp(j,iswa(i),KPhase)
        ki(PrvKi)=1
        PrvKi=PrvKi+1
1000  continue
      pom=pom*.5
      do 1100j=4,6
        beta(j,i)=pom*prcp(j,iswa(i),KPhase)
        sbeta(j,i)=spom*prcp(j,iswa(i),KPhase)
        ki(PrvKi)=1
        PrvKi=PrvKi+1
1100  continue
      return
      end
      subroutine ZmTF21(i)
      include 'params.cmn'
      include 'basic.cmn'
      include 'atoms.cmn'
      integer PrvKi
      itf(i)=1
      call boueq(beta(1,i),sbeta(1,i),1,pom,spom,iswa(i))
      beta(1,i)=pom
      sbeta(1,i)=spom
      call SetRealArrayTo( beta(2,i),5,0.)
      call SetRealArrayTo(sbeta(2,i),5,0.)
      call SetIntArrayTo(ki(PrvniKiAtomu(i)+5),5,0)
      call ShiftKiAt(i,itf(i),ifr(i),lasmax(i),kmoda(i,1),kmoda(i,2),0,
     1               0,0,0,0,.false.)
      kmodb(i)=0
      return
      end
      subroutine ZmTF20(ia,Nulovat)
      include 'params.cmn'
      include 'basic.cmn'
      include 'atoms.cmn'
      include 'molec.cmn'
      integer PrvKi
      logical Nulovat
      l=(kmol(ia)-1)/mxp+1
      if(ktls(l).le.0) then
        do 3050k=kmol(ia),kmol(ia)+mam(l)-1
          call ShiftKiMol(k,1,kmodsm(k),kmodxm(k),kmodbm(k),.false.)
          PrvKi=PrvniKiMolekuly(k)
          if(Nulovat) then
            if(itf(ia).eq.1) call ZmTF12(ia)
            call CopyVek(beta(1,ia),tt(1,k),6)
          else
            call SetRealArrayTo(tt(1,k),6,0.)
          endif
          call SetRealArrayTo(tt(4,k),3,0.)
          call SetRealArrayTo(stt(1,k),6,0.)
          call SetRealArrayTo(tl(1,k),6,0.)
          call SetRealArrayTo(stl(1,k),6,0.)
          call SetRealArrayTo(ts(1,k),9,0.)
          call SetRealArrayTo(sts(1,k),9,0.)
          call SetIntArrayTo(ki(PrvKi+7),21,1)
3050    continue
        ktls(l)=1
      else
        ktls(l)=ktls(l)+1
      endif
      if(Nulovat) call SetRealArrayTo(beta(1,ia),6,0.)
      call SetRealArrayTo(sbeta(1,ia),6,0.)
      call ShiftKiAt(ia,itf(ia),ifr(ia),lasmax(ia),kmoda(ia,1),
     1               kmoda(ia,2),0,0,0,0,0,.false.)
      itf(ia)=0
      kmodb(ia)=0
      return
      end
      subroutine ZmTF02(i)
      include 'params.cmn'
      include 'basic.cmn'
      include 'atoms.cmn'
      include 'molec.cmn'
      k=kmol(i)
      l=(k-1)/mxp+1
      itf(i)=2
      do 3200j=1,6
        beta(j,i)=beta(j,i)+tt(j,k)
        sbeta(j,i)=0.
3200  continue
      call cultm(tztl(1,i-mxa),tl(1,k),beta(1,i),6,6,1)
      call cultm(tzts(1,i-mxa),ts(1,k),beta(1,i),6,9,1)
      if(ktls(l).eq.1) call ShiftKiMol(k,0,kmodsm(k),kmodxm(k),
     1                                 kmodbm(k),.false.)
      ktls(l)=ktls(l)-1
      return
      end
      subroutine MergAt(kdo,ich)
      include 'params.cmn'
      include 'basic.cmn'
      include 'editm40.cmn'
      include 'atoms.cmn'
      include 'molec.cmn'
      include 'fepc.cmn'
      dmez=.1
      if(kdo.eq.0) then
        id=NextQuestId()
        call FeQuestCreate(id,-1.,-1.,80.,0,1,'Merging distance [A]',0,
     1                     LightGray,0,0)
        call FeQuestEdwMake(id,5.,1,15.,1,' ','L',50.,EdwYd,0)
        call FeQuestRealEdwOpen(1,dmez,.false.,.false.)
        icont=0
1000    call FeQuestEvent(id,icont,ich)
        icont=1
        if(CheckType.ne.0) then
          call NebylOsetren
          go to 1000
        endif
        if(ich.eq.0) call FeQuestRealFromEdw(1,dmez)
        call FeQuestRemove(id)
        if(ich.ne.0) go to 9999
      endif
      ido=na(1)
      i=1
1100  j=i+1
      isw=iswa(i)
1500  j=koinc(x(1,i),x,j,ido,dmez,dst,isw)
      if(j.gt.0) then
        if(isf(i).eq.isf(j)) then
          ai(i)=ai(i)+ai(j)
          call delor(atom(j))
          if(j.lt.nac) call AtSun(j+1,nacAll,j)
          na(isw)=na(isw)-1
          nac=nac-1
          nacAll=nacAll-1
          ido=ido-1
        else
          j=j+1
        endif
        if(j.le.ido) go to 1500
      endif
      if(i.lt.ido) then
        i=i+1
        go to 1100
      endif
      if(i.eq.na(1).and.i.lt.nac) then
        ido=na(1)+na(2)
        i=i+1
        go to 1100
      endif
      if(i.eq.na(1).and.i.lt.nac) then
        ido=na(1)+na(2)+na(3)
        i=i+1
        go to 1100
      endif
      call SavePhase
9999  return
      end
      subroutine delor(jmeno)
      include 'params.cmn'
      include 'basic.cmn'
      include 'atoms.cmn'
      character*(*) jmeno
      k=ktat(ora,nor,jmeno)
      if(k.gt.0) then
        do 2000i=k+1,nor
          ora(i-1)=ora(i)
          orn(i-1)=orn(i)
          orx40(i-1)=orx40(i)
          ordel(i-1)=ordel(i)
          call CopyVekI(orsel(1,i),orsel(1,i-1),mxw21)
          orsels(i-1)=orsels(i)
2000    continue
        nor=nor-1
      endif
      return
      end
      subroutine ZmAnh(ich)
      include 'params.cmn'
      include 'basic.cmn'
      include 'atoms.cmn'
      include 'editm40.cmn'
      include 'fepc.cmn'
      character*2 nty
      character*1 t(5)
      logical CrwLogicQuest
      data t/'2','3','4','5','6'/
      ich=0
      call DefGroup(i1,i2,1)
      if(i1.eq.0) then
        ich=1
        return
      endif
      itfn=itf(i1)
      do 1000i=i1+1,i2
        if((i.gt.nacAll.and.i.le.mxa).or..not.AtBrat(i)) go to 1000
        if(itf(i).ne.itfn) itfn=0
1000  continue
      if(itfn.le.0) itfn=2
      id=NextQuestId()
      call FeQuestCreate(id,-1.,-1.,150.,0,2,'Select anharmonic tensors'
     1                 //' to be used',0,LightGray,0,0)
      xpom=35.
      do 1020i=1,5
        call FeQuestCrwMake(id,xpom,1,xpom-4.,2,'%'//t(i)//nty(i+1),'C',
     1                      CrwXd,CrwYd,1,0)
        call FeQuestCrwOpen(i,i+1.le.itfn)
        xpom=xpom+20.
1020  continue
      icont=0
1500  call FeQuestEvent(id,icont,ich)
      if(CheckType.eq.EventCrw) then
        do 1550i=1,5
          if(i.lt.CheckNumber) then
            call FeQuestCrwOn(i)
          else if(i.gt.CheckNumber) then
            call FeQuestCrwOff(i)
          endif
1550    continue
        go to 1500
      else if(CheckType.ne.0) then
        call NebylOsetren
        go to 1500
      endif
      if(ich.eq.0) then
        itfn=1
1600    if(CrwLogicQuest(itfn)) then
          itfn=itfn+1
          go to 1600
        endif
      endif
      call FeQuestRemove(id)
      if(ich.ne.0) go to 9999
      do 3000i=i1,i2
        if((i.gt.nacAll.and.i.le.mxa).or..not.AtBrat(i)) go to 3000
        call ZmAnhi(i,itfn)
3000  continue
9999  return
      end
      subroutine ZmAnhi(i,itfn)
      include 'params.cmn'
      include 'basic.cmn'
      include 'atoms.cmn'
      do 1000k=itfn+2,itf(i)+1
        kfa(i,k)=0
        kmoda(i,k)=0
1000  continue
      call ShiftKiAt(i,itfn,ifr(i),lasmax(i),kmods(i),kmodx(i),kmodb(i),
     1               kmodc3(i),kmodc4(i),kmodc5(i),kmodc6(i),.false.)
      m=PrvniKiAtomu(i)+TRankCumul(itf(i))-1
      do 1500k=itf(i)+1,itfn
        if(k.eq.2) then
          pom=beta(1,i)
          spom=sbeta(1,i)
        endif
        nrank=TRank(k)
        do 1200j=1,nrank
          if(k.eq.2) then
            beta(j,i)=pom*prcp(j,iswa(i),KPhase)
            sbeta(j,i)=spom*prcp(j,iswa(i),KPhase)
          else if(k.eq.3) then
            c3(j,i)=0.
            sc3(j,i)=0.
          else if(k.eq.4) then
            c4(j,i)=0.
            sc4(j,i)=0.
          else if(k.eq.5) then
            c5(j,i)=0.
            sc5(j,i)=0.
          else
            c6(j,i)=0.
            sc6(j,i)=0.
          endif
          m=m+1
          ki(m)=1
1200    continue
1500  continue
      if(itf(i).gt.1.and.itfn.eq.1) call ZmTF21(i)
      itf(i)=itfn
      return
      end
      subroutine DefGroup(i1,i2,klic)
      include 'params.cmn'
      include 'basic.cmn'
      include 'atoms.cmn'
      include 'molec.cmn'
      include 'editm40.cmn'
      i1=0
      i2=0
      if(nac.gt.0) then
        call SelAtoms('Select atoms from atomic part',Atom(nacOff+1),
     1                AtBrat(nacOff+1),isf(nacOff+1),nac,.true.,ich)
        if(ich.ne.0) then
          i1=0
          go to 1005
        endif
        do 1000i=1,nac
          ii=i+nacOff
          if(AtBrat(ii)) then
            if(i1.eq.0) i1=ii
            i2=ii
          endif
1000    continue
      endif
1005  if(klic.eq.1) return
      if(nacb.gt.0) then
        n=0
        iak=mxa
        do 1020i=1,nmolc
          iap=iak+1
          iak=iak+iam(i)
          do 1010ia=iap,iak
            n=n+1
            MolAt(n)=Atom(ia)
            MolAtisf(n)=isf(ia)
1010      continue
          iak=iak+iamn(i)-iam(i)
1020    continue
        call SelAtoms('Select atoms from molecular part',MolAt,
     1                MolAtBrat,MolAtisf,n,.true.,ich)
        if(ich.ne.0) then
          i1=0
          return
        endif
        n=0
        iak=mxa
        do 1050i=1,nmolc
          iap=iak+1
          iak=iak+iam(i)
          do 1030ia=iap,iak
            n=n+1
            AtBrat(ia)=MolAtBrat(n)
1030      continue
          iakn=iak+iamn(i)-iam(i)
          do 1040ia=iak+1,iakn
            AtBrat(ia)=.false.
1040      continue
          iak=iakn
1050    continue
        do 1060i=mxa+1,mxa+nacb
          if(AtBrat(i)) then
            if(i1.eq.0) i1=i
            i2=i
          endif
1060    continue
      endif
      return
      end
      subroutine DefMolGroup(BratMol,ich)
      include 'params.cmn'
      include 'basic.cmn'
      include 'molec.cmn'
      include 'editm40.cmn'
      logical BratMol(mxpm)
      dimension isfm(mxpm)
      data isfm/mxpm*0/
      call SetLogicalArrayTo(BratMol,mxpm,.false.)
      if(nmolc.gt.0)
     1  call SelAtoms('Select molecules',MolMenu,BratMol,isfm,MaxMolPos,
     2                .true.,ich)
      return
      end
      subroutine ZmVln(ich)
      include 'params.cmn'
      include 'basic.cmn'
      include 'atoms.cmn'
      include 'molec.cmn'
      include 'editm40.cmn'
      integer SelPart
      k=SelPart(0)
      ich=0
      if(k.ge.1) then
        call MolMod
      else if(k.eq.0) then
        call AtMod
      else
        ich=1
      endif
      return
      end
      subroutine AtMod
      include 'params.cmn'
      include 'basic.cmn'
      include 'atoms.cmn'
      include 'molec.cmn'
      include 'editm40.cmn'
      dimension kmodan(7),kmn(7),kmodap(7),kiold(mxdam)
      integer PrvKi,PrvKiOld
1000  call DefGroup(i1,i2,0)
      if(i1.eq.0) return
      do 1050i=1,7
        kmodan(i)=kmoda(i1,i)
1050  continue
      itfp=itf(i1)
      do 1200i=i1+1,i2
        if((i.gt.nacAll.and.i.le.mxa).or..not.AtBrat(i)) go to 1200
        do 1100j=1,7
          if(kmoda(i,j).ne.kmodan(j)) kmodan(j)=mxw+1
1100    continue
        itfp=min(itfp,itf(i))
1200  continue
      itfp=itfp+1
      if(itfp.eq.1) itfp=3
      call ReadMod(kmodan,itfp,ich)
      if(ich.ne.0) go to 9999
      go to 1250
      entry AtModi(ia,kmodap)
      i1=ia
      i2=ia
      AtBrat(ia)=.true.
      itfp=itf(ia)+1
      call CopyVekI(kmodap,kmodan,7)
1250  do 3000i=i1,i2
        if((i.gt.nacAll.and.i.le.mxa).or..not.AtBrat(i)) go to 3000
        k=max(TRankCumul(itf(i)),10)
        PrvKi=PrvniKiAtomu(i)+k
        PrvKiOld=1
        call CopyVekI(ki(PrvKi),kiold,DelkaKiAtomu(i)-k)
        do 1300j=1,7
          if(kmodan(j).le.mxw) then
            kmn(j)=kmodan(j)
          else
            kmn(j)=kmoda(i,j)
          endif
1300    continue
        call ShiftKiAt(i,itf(i),ifr(i),lasmax(i),kmn(1),kmn(2),kmn(3),
     1                 kmn(4),kmn(5),kmn(6),kmn(7),.false.)
        do 1400j=1,itfp
          if(kmoda(i,j).gt.0) go to 1450
1400    continue
        do 1420j=1,itfp
          if(kmn(j).gt.0) then
            phf(i)=0.
            sphf(i)=0.
            ki(PrvniKiAtomu(i)+DelkaKiAtomu(i)-1)=0
            go to 1450
          endif
1420    continue
1450    km=kmol(i)
        do 1460j=1,3
          if(km.gt.0) then
            kmn(j)=kmodam(km,j)
          else
            kmn(j)=0
          endif
1460    continue
        if(kmodan(1).gt.0.and.kmodan(1).le.mxw) then
          if(kmods(i).le.0) then
            call specpos(x(1,i),iswa(i),.05,n)
            pom=1./float(n)
            a0(i)=ai(i)/pom
            ai(i)=pom
            sa0(i)=0.
            ki(PrvKi)=0
            ki(PrvniKiAtomu(i))=0
          endif
        else if(kmodan(1).eq.0) then
          if(kmods(i).gt.0) then
            ai(i)=ai(i)*a0(i)
            ki(PrvniKiAtomu(i))=0
          endif
        endif
        do 2000n=1,itfp
          j1=max(kmoda(i,n),0)
          j2=kmodan(n)
          nrank=TRank(n-1)
          nrank2=2*nrank
          if(j2.gt.mxw) then
            j2=j1
          else if(j2.le.0) then
            go to 2000
          endif
          if(j1.eq.j2) go to 1800
          if(kfa(i,n).ne.0) then
            l1=PrvKiOld+nrank2*(j1-1)
            if(n.eq.1) l1=l1+1
            k1=PrvKi+nrank2*(j2-1)
            if(n.eq.1) k1=k1+1
            call CopyVekI(kiold(l1),ki(k1),nrank2)
            if(n.eq.1) then
              ax(j2,i)=ax(j1,i)
              ay(j2,i)=ay(j1,i)
              sax(j2,i)=sax(j1,i)
              say(j2,i)=say(j1,i)
            else if(n.eq.2) then
              call CopyVek(ux(1,j1,i),ux(1,j2,i),nrank)
              call CopyVek(uy(1,j1,i),uy(1,j2,i),nrank)
              call CopyVek(sux(1,j1,i),sux(1,j2,i),nrank)
              call CopyVek(suy(1,j1,i),suy(1,j2,i),nrank)
            else if(n.eq.3) then
              call CopyVek(bx(1,j1,i),bx(1,j2,i),nrank)
              call CopyVek(by(1,j1,i),by(1,j2,i),nrank)
              call CopyVek(sbx(1,j1,i),sbx(1,j2,i),nrank)
              call CopyVek(sby(1,j1,i),sby(1,j2,i),nrank)
            else if(n.eq.4) then
              call CopyVek(c3x(1,j1,i),c3x(1,j2,i),nrank)
              call CopyVek(c3y(1,j1,i),c3y(1,j2,i),nrank)
              call CopyVek(sc3x(1,j1,i),sc3x(1,j2,i),nrank)
              call CopyVek(sc3y(1,j1,i),sc3y(1,j2,i),nrank)
            else if(n.eq.5) then
              call CopyVek(c4x(1,j1,i),c4x(1,j2,i),nrank)
              call CopyVek(c4y(1,j1,i),c4y(1,j2,i),nrank)
              call CopyVek(sc4x(1,j1,i),sc4x(1,j2,i),nrank)
              call CopyVek(sc4y(1,j1,i),sc4y(1,j2,i),nrank)
            else if(n.eq.6) then
              call CopyVek(c5x(1,j1,i),c5x(1,j2,i),nrank)
              call CopyVek(c5y(1,j1,i),c5y(1,j2,i),nrank)
              call CopyVek(sc5x(1,j1,i),sc5x(1,j2,i),nrank)
              call CopyVek(sc5y(1,j1,i),sc5y(1,j2,i),nrank)
            else
              call CopyVek(c6x(1,j1,i),c6x(1,j2,i),nrank)
              call CopyVek(c6y(1,j1,i),c6y(1,j2,i),nrank)
              call CopyVek(sc6x(1,j1,i),sc6x(1,j2,i),nrank)
              call CopyVek(sc6y(1,j1,i),sc6y(1,j2,i),nrank)
            endif
            j1=j1-1
            j2=j2-1
          endif
          l1=PrvKi+nrank2*j1
          if(n.eq.1) l1=l1+1
          l2=l1+nrank
          do 1600j=j1+1,j2
            call SetIntArrayTo(ki(l1),nrank,1)
            call SetIntArrayTo(ki(l2),nrank,1)
            if(j.gt.kmn(n)) then
              if(n.eq.1) then
                pom=.01
              else if(n.eq.2) then
                pom=.001
              else if(n.eq.3) then
                pom=.0001
              else
                pom=.00001
              endif
            else
              pom=0.
            endif
            if(n.eq.1) then
              ax(j,i)=pom
              ay(j,i)=pom
              sax(j,i)=.0
              say(j,i)=.0
            else if(n.eq.2) then
              call SetRealArrayTo( ux(1,j,i),nrank,pom)
              call SetRealArrayTo( uy(1,j,i),nrank,pom)
              call SetRealArrayTo(sux(1,j,i),nrank,0.)
              call SetRealArrayTo(suy(1,j,i),nrank,0.)
            else if(n.eq.3) then
              call SetRealArrayTo( bx(1,j,i),nrank,pom)
              call SetRealArrayTo( by(1,j,i),nrank,pom)
              call SetRealArrayTo(sbx(1,j,i),nrank,0.)
              call SetRealArrayTo(sby(1,j,i),nrank,0.)
            else if(n.eq.4) then
              call SetRealArrayTo( c3x(1,j,i),nrank,pom)
              call SetRealArrayTo( c3y(1,j,i),nrank,pom)
              call SetRealArrayTo(sc3x(1,j,i),nrank,0.)
              call SetRealArrayTo(sc3y(1,j,i),nrank,0.)
            else if(n.eq.5) then
              call SetRealArrayTo( c4x(1,j,i),nrank,pom)
              call SetRealArrayTo( c4y(1,j,i),nrank,pom)
              call SetRealArrayTo(sc4x(1,j,i),nrank,0.)
              call SetRealArrayTo(sc4y(1,j,i),nrank,0.)
            else if(n.eq.6) then
              call SetRealArrayTo( c5x(1,j,i),nrank,pom)
              call SetRealArrayTo( c5y(1,j,i),nrank,pom)
              call SetRealArrayTo(sc5x(1,j,i),nrank,0.)
              call SetRealArrayTo(sc5y(1,j,i),nrank,0.)
            else
              call SetRealArrayTo( c6x(1,j,i),nrank,pom)
              call SetRealArrayTo( c6y(1,j,i),nrank,pom)
              call SetRealArrayTo(sc6x(1,j,i),nrank,0.)
              call SetRealArrayTo(sc6y(1,j,i),nrank,0.)
            endif
            l1=l1+nrank2
            l2=l2+nrank2
1600      continue
          if(kfa(i,n).ne.0.and.n.ne.1) j2=j2+1
1800      PrvKi   =PrvKi   +nrank2*j2
          PrvKiOld=PrvKiOld+nrank2*j2
          if(n.eq.1.and.j2.gt.0) then
            PrvKi   =PrvKi   +1
            PrvKiOld=PrvKiOld+1
          endif
2000    continue
        do 2500j=1,7
          if(kmodan(j).le.mxw) kmoda(i,j)=kmodan(j)
2500    continue
3000  continue
9999  return
      end
      subroutine MolMod
      include 'params.cmn'
      include 'basic.cmn'
      include 'atoms.cmn'
      include 'molec.cmn'
      include 'editm40.cmn'
      dimension kmodan(3),kmn(3),kmodani(*),kiold(mxdam),xp(3)
      integer PrvKi,PrvKiOld,PrvKiMod
      logical BratMol(mxpm)
      Klic=0
      call DefMolGroup(BratMol,ich)
      if(ich.ne.0) go to 9999
      i1=0
      do 1100i=1,MaxMolPos
        if(BratMol(i)) then
          ji=MolPosition(i)
          if(i1.le.0) then
            i1=i
            do 1010j=1,3
              kmodan(j)=kmodam(ji,j)
1010        continue
          endif
          do 1020j=1,3
            if(kmodam(ji,j).ne.kmodan(j)) kmodan(j)=mxw+1
1020      continue
          i2=i
        endif
1100  continue
      call ReadMod(kmodan,3,ich)
      if(ich.ne.0) go to 9999
      go to 1200
      entry MolModi(jii,imi,kmodani)
      Klic=1
      im=imi
      ji=jii
      i1=1
      i2=1
      call CopyVekI(kmodani,kmodan,3)
1200  do 5000i=i1,i2
        if(Klic.eq.0) then
          if(.not.BratMol(i)) go to 5000
          ji=MolPosition(i)
          im=(ji-1)/mxp+1
        endif
        PrvKi=PrvniKiMolekuly(ji)
        if(ktls(im).gt.0) then
          PrvKiMod=PrvKi+27
          k=27
        else
          PrvKiMod=PrvKi+6
          k=6
        endif
        PrvKiOld=1
        call CopyVekI(ki(PrvKiMod),kiold,DelkaKiMolekuly(ji)-k)
        do 1300j=1,3
          if(kmodan(j).le.mxw) then
            kmn(j)=kmodan(j)
          else
            kmn(j)=kmodam(ji,j)
          endif
1300    continue
        call ShiftKiMol(ji,ktls(im),kmn(1),kmn(2),kmn(3),.false.)
        do 1400j=1,3
          if(kmodam(ji,j).gt.0) go to 1450
1400    continue
        do 1420j=1,3
          if(kmn(j).gt.0) then
            phfm(ji)=0.
            sphfm(ji)=0.
            ki(PrvniKiMolekuly(ji)+DelkaKiMolekuly(ji)-1)=0
            go to 1450
          endif
1420    continue
1450    j1=kmodsm(ji)
        j2=kmn(1)
        if(j2.gt.0) then
          if(j1.eq.0) then
c            call AddVek(trans(1,ji),xm(1,im),xp,3)
c            call specpos(xp,iswa(i),.05,n)
c            pom=1./float(n)
c            a0m(ji)=aimol(ji)/pom
c            aimol(ji)=pom
            a0m(ji)=1.
            sa0m(ji)=0.
            ki(PrvKiMod+1)=0
            ki(PrvKi)=0
          endif
          l=PrvKiMod+2+2*j1
          do 2100j=j1+1,j2
            ki(l  )=1
            ki(l+1)=1
            axm(j,ji)=.01
            aym(j,ji)=.01
            saxm(j,ji)=.0
            saym(j,ji)=.0
            l=l+2
2100      continue
        endif
        if(kmn(2).ne.kmodxm(ji)) then
          j1=kmodxm(ji)
          j2=kmn(2)
          l=PrvKiMod
          lold=PrvKiOld
          if(kmn(1).gt.0) l=l+1+2*kmn(1)
          if(kmodsm(ji).gt.0) lold=lold+1+2*kmodsm(ji)
          if(kfxm(ji).ne.0) then
            l1=lold+6*(j1-1)+1
            l2=l+6*(j2-1)+1
            l3=l1+6*j1
            l4=l2+6*j2
            call CopyVekI(kiOld(l1),ki(l2),6)
            call CopyVekI(kiOld(l3),ki(l4),6)
            call CopyVek( utx(1,j1,ji), utx(1,j2,ji),3)
            call CopyVek( uty(1,j1,ji), uty(1,j2,ji),3)
            call CopyVek(sutx(1,j1,ji),sutx(1,j2,ji),3)
            call CopyVek(suty(1,j1,ji),suty(1,j2,ji),3)
            call CopyVek( urx(1,j1,ji), urx(1,j2,ji),3)
            call CopyVek( ury(1,j1,ji), ury(1,j2,ji),3)
            call CopyVek(surx(1,j1,ji),surx(1,j2,ji),3)
            call CopyVek(sury(1,j1,ji),sury(1,j2,ji),3)
            j2=j2-1
            j1=j1-1
          endif
          if(kmn(2).gt.kmodxm(ji)) then
            n=3*(j2-j1)
            call SetRealArrayTo( utx(1,j1+1,ji),n,.0001)
            call SetRealArrayTo( uty(1,j1+1,ji),n,.0001)
            call SetRealArrayTo(sutx(1,j1+1,ji),n,.0)
            call SetRealArrayTo(suty(1,j1+1,ji),n,.0)
            call SetRealArrayTo( urx(1,j1+1,ji),n,.0001)
            call SetRealArrayTo( ury(1,j1+1,ji),n,.0001)
            call SetRealArrayTo(surx(1,j1+1,ji),n,.0)
            call SetRealArrayTo(sury(1,j1+1,ji),n,.0)
            n=2*n
            l1=l+6*j1+1
            l3=l1+6*kmn(2)
            call SetIntArrayTo(ki(l1),n,1)
            call SetIntArrayTo(ki(l3),n,1)
          endif
        endif
2301    if(kmn(3).gt.kmodbm(ji)) then
          j1=kmodbm(ji)
          j2=kmn(3)
          l=PrvKiMod
          if(kmn(1).gt.0) l=l+1+2*kmn(1)
          l=l+12*kmn(2)
          if(kfbm(ji).ne.0) then
            l1=l+12*(j1-1)
            l2=l+12*(j2-1)
            l3=l1+12*j1
            l4=l2+12*j2
            do 2400m=1,6
              ki(l2+m  )=ki(l1+m  )
              ki(l2+m+3)=ki(l1+m+3)
              ki(l4+m  )=ki(l3+m  )
              ki(l4+m+3)=ki(l3+m+3)
              ttx(m,j2,ji)=ttx(m,j1,ji)
              tty(m,j2,ji)=tty(m,j1,ji)
              sttx(m,j2,ji)=sttx(m,j1,ji)
              stty(m,j2,ji)=stty(m,j1,ji)
              tlx(m,j2,ji)=tlx(m,j1,ji)
              tly(m,j2,ji)=tly(m,j1,ji)
              stlx(m,j2,ji)=stlx(m,j1,ji)
              stly(m,j2,ji)=stly(m,j1,ji)
2400        continue
            l1=l+24*j1+18*(j1-1)
            l2=l+24*j2+18*(j2-1)
            do 2500m=1,9
              ki(l2+m  )=ki(l1+m  )
              ki(l2+m+3)=ki(l1+m+3)
              tsx(m,j2,ji)=tsx(m,j1,ji)
              tsy(m,j2,ji)=tsy(m,j1,ji)
              stsx(m,j2,ji)=stsx(m,j1,ji)
              stsy(m,j2,ji)=stsy(m,j1,ji)
2500        continue
            j1=j1-1
            j2=j2-1
          endif
          l1=l+12*j1
          l2=l1+12*j2
          do 2600j=j1+1,j2
            do 2550m=1,6
              ki(l1+m  )=1
              ki(l1+m+6)=1
              ki(l2+m  )=1
              ki(l2+m+6)=1
              ttx(m,j,ji)=.00001
              tty(m,j,ji)=.00001
              sttx(m,j,ji)=.0
              stty(m,j,ji)=.0
              tlx(m,j,ji)=.00001
              tly(m,j,ji)=.00001
              stlx(m,j,ji)=.0
              stly(m,j,ji)=.0
2550        continue
            l1=l1+12
            l2=l2+12
2600      continue
          l1=l+24*kmn(3)+18*j1
          do 2700j=j1+1,j2
            do 2650m=1,9
              ki(l1+m  )=1
              ki(l1+m+9)=1
              tsx(m,j,ji)=.00001
              tsy(m,j,ji)=.00001
              stsx(m,j,ji)=.0
              stsy(m,j,ji)=.0
2650        continue
            l1=l1+18
2700      continue
        endif
        do 3000j=1,3
          kmodam(ji,j)=kmn(j)
3000    continue
5000  continue
9999  return
      end
      function MolPosition(n)
      include 'params.cmn'
      include 'basic.cmn'
      include 'molec.cmn'
      k=0
      do 1100i=1,nmolc
        do 1000j=1,mam(i)
          k=k+1
          if(k.eq.n) then
            MolPosition=j+mxp*(i-1)
            go to 9999
          endif
1000    continue
1100  continue
      MolPosition=-1
9999  return
      end
      subroutine ReadMod(kmodan,itf,ich)
      include 'params.cmn'
      include 'basic.cmn'
      include 'fepc.cmn'
      dimension kmodan(*)
      character*256 EdwStringQuest
      character*80 Veta
      character*2  nty
      id=NextQuestId()
      call FeQuestCreate(id,-1.,-1.,120.,0,itf,'Number of modulation '//
     1                   'waves',0,LightGray,0,0)
      do 1000i=1,itf
        if(i.eq.1) then
          Veta='%Occupational parameters'
        else if(i.eq.2) then
          Veta='%Positional parameters'
        else if(i.eq.3) then
          Veta='%ADP harmonic parameters'
        else
          write(Veta,'(i1,a2,'' order'')') i-1,nty(i-1)
        endif
        call FeQuestEdwMake(id,5.,i,95.,i,Veta,'L',20.,EdwYd,0)
        call FeQuestIntEdwOpen(i,kmodan(i),kmodan(i).gt.mxw)
1000  continue
      icont=0
1500  call FeQuestEvent(id,icont,ich)
      icont=1
      if(CheckType.ne.0) then
        call NebylOsetren
        go to 1500
      endif
      if(ich.eq.0) then
        do 1600i=1,itf
          if(EdwStringQuest(i).ne.' ')
     1      call FeQuestIntFromEdw(i,kmodan(i))
1600    continue
      endif
      call FeQuestRemove(id)
      return
      end
      subroutine Trm4050(Klic,flnp,Titulek,ich)
      include 'params.cmn'
      include 'basic.cmn'
      include 'atoms.cmn'
      character*(*) flnp,Titulek
      character*80 radka,t80,FileName
      character*15 isp(6)
      character*13 men(8)
      character*8  AtomNew(50000),AtomOld(50000)
      character*5  filtr(8)
      character*1  centry,syst
      dimension isfold(50000)
      integer FeMenu
      logical carka,Nenacitat,FeYesNo,ExistFile,StructureExists
      dimension rmp(9),ipp(1)
      equivalence (scrar,AtomNew),(scrar(100001),AtomOld),
     1            (scrar(200001),isfold)
      data men/'%XTAL format','C%Vis format','%CrystalMaker',
     1         '%MOLVIEW','%SHELX','%Jana','C%IF','%HRTEM'/
      data filtr/'*.xti','*.zt','*.cm','.m','*.ins',' ','*.cif',
     1           '*.cel'/
      ich=0
      inquire(m40,opened=Nenacitat)
      Nenacitat=.not.Nenacitat
      if(Klic.eq.0) then
        nfor=FeMenu(-1.,-1.,men,1,8,1,0)
      else
        nfor=iabs(Klic)
      endif
      if(nfor.lt.1.or.nfor.gt.8) go to 9000
      if(flnp.eq.' ') then
        FileName=' '
        if(ifln.gt.0.and.nfor.ne.6) FileName=fln(:ifln)//filtr(nfor)(2:)
        if(nfor.ne.6) then
          i=0
        else
          i=1
        endif
        call FeFileManager('Select the output file name',FileName,
     1                     Filtr(nfor),i,.true.,ich)
        flnp=FileName
        do 1000i=idel(FileName),1,-1
          if(FileName(i:i).eq.'.') then
            flnp=FileName(:i-1)
            go to 1010
          endif
1000    continue
      else
        FileName=flnp(:idel(flnp))//filtr(nfor)(2:)
      endif
1010  if(ich.gt.0.or.FileName.eq.' ') go to 9000
      if(nfor.eq.6) then
        if(StructureExists(flnp).and.GrOn) then
          t80='The strucure "'//flnp(:idel(flnp))//
     1        '" already exists, overwrite it?'
          if(.not.FeYesNo(-1.,-1.,t80,0)) go to 9000
        endif
      else
        if(ExistFile(FileName).and.GrOn) then
          if(.not.FeYesNo(-1.,-1.,'The file "'//
     1       FileName(:idel(FileName))//
     2       '" already exists, overwrite it?',0)) go to 9000
        endif
        call OpenFile(55,FileName,'formatted','unknown')
        if(ErrJana.ne.0) go to 9999
      endif
      if(Nenacitat) then
        call CopyVekI(isf,isfold,nacalc)
        do 1020i=1,nacalc
          AtomOld(i)=Atom(i)
1020    continue
      else
        rewind m40
        k=0
1050    read(m40,FormA80) radka
        kk=0
        call StToInt(radka,kk,ipp,1,.false.,ich)
        nacalc=ipp(1)
        read(m40,104) sc(1)
        do 1100i=1,3
          read(m40,104)
1100    continue
        if(k.ne.0) go to 1200
        do 1110i=1,nacalc
          read(m40,103) AtomOld(i),isfold(i)
          read(m40,104)
1110    continue
        rewind m40
        k=1
        go to 1050
      endif
1200  if(nfor.lt.3) then
        if(ncs.eq.1) then
          centry='c'
        else
          centry='n'
        endif
      endif
      if(nfor.eq.1) then
        write(55,'(''master yes'')')
        write(55,'(''startx'')')
        write(radka,'(3f10.4,3f10.2)')(CellPar(i,1,KPhase),i=1,6)
        k=0
        call WriteLabeledRecord(55,'cell',Radka,k)
        write(55,'(''latice   '',a1,3x,a1)') centry,lattice(1:1)
        do 1400i=1,ns
          call codesym(rm6(1,i,1,KPhase),s6(1,i,1,KPhase),isp,0)
          t80=isp(1)//isp(2)//isp(3)
          carka=.true.
          do 1300l=1,idel(t80)
            if(t80(l:l).eq.' ') then
              if(.not.carka) then
                t80(l:l)=','
                carka=.true.
              endif
            else
              carka=.false.
            endif
1300      continue
          call zhusti(t80)
          t80='symtry '//t80(:idel(t80))
          write(55,FormA1)(t80(l:l),l=1,idel(t80))
1400    continue
        nz=8
        write(55,'(''celmol '',i2)') nz
        do 1500i=1,NAtFormula
          write(55,'(''celcon '',a2,i6)') AtFormula(i,KPhase),
     1                                    nint(AtMult(i,KPhase)*nz)
1500    continue
        write(55,'(''addatm'')')
        do 1600i=1,nacalc
          if(Nenacitat) then
            if(kswa(i).ne.KPhase) go to 1600
            ii=i
          else
            ii=1
            read(m40,103) Atom(1),isf(1),itf(1),ai(1),(x(j,1),j=1,3)
            read(m40,104) (beta(j,1),j=1,6)
          endif
          call specpos(x(1,ii),1,.2,n)
          pom=1./float(n)
          write(55,'(''atom '',a5,3f9.5,'' $1'',f6.3,3f9.5,'' $1'',
     1               f6.3)') atom(ii)(1:5),(x(j,ii),j=1,3),ai(ii)/pom,
     2                       (sx(j,ii),j=1,3),sai(ii)/pom
          if(itf(ii).eq.1) then
            write(55,'(''u     '',a8,2f10.6)') atom(ii)(1:5),
     1        beta(1,i)/episq,sbeta(1,i)/episq
          else
            write(55,'(''uij   '',a8,6f10.6)') atom(ii)(1:5),
     1           (beta(j,ii)/urcp(j,1,KPhase),j=1,6)
            write(55,'(''suij  '',a8,6f10.6)') atom(ii)(1:5),
     1           (sbeta(j,ii)/urcp(j,1,KPhase),j=1,6)
          endif
1600    continue
        write(55,'(''atable''/''finish'')')
      else if(nfor.eq.2) then
        if(ngrupa.eq.0) then
          grupa(1:11)='NonStandard'
          syst(1:1)='?'
        endif
        if(ngrupa.ge.1.and.ngrupa.le.2) syst='1'
        if(ngrupa.ge.3.and.ngrupa.le.15) syst='2'
        if(ngrupa.ge.16.and.ngrupa.le.74) syst='3'
        if(ngrupa.ge.75.and.ngrupa.le.142) syst='4'
        if(ngrupa.ge.143.and.ngrupa.le.167) syst='5'
        if(ngrupa.ge.168.and.ngrupa.le.194) syst='6'
        if(ngrupa.ge.195.and.ngrupa.le.230) syst='7'
        write(55,'(''BEGIN'')')
        write(55,'(''TITLE '',80a1)')(fln(i:i),i=1,ifln)
        write(radka,'(3f10.4,3f10.2)')(CellPar(i,1,KPhase),i=1,6)
        k=0
        call WriteLabeledRecord(55,'cell',Radka,k)
        write(55,'(''SGROUP '',a11,i5,'' ? '',a1,1x,a1,1x,a1)')
     1        grupa,ngrupa,centry,syst,lattice(1:1)
        write(55,'(''SMAT  {'')')
        do 2000i=1,ns
          write(55,'(3(3i3,f10.6))')
     1      ((nint(rm6(k+(j-1)*3,i,1,KPhase)),j=1,3),
     1       s6(k,i,1,KPhase),k=1,3)
          if(ncs.eq.1)
     1    write(55,'(3(3i3,f10.6))')
     2      ((-nint(rm6(k+(j-1)*3,i,1,KPhase)),j=1,3),
     2       s6(k,i,1,KPhase),k=1,3)
2000    continue
        write(55,'(''}'')')
        write(55,'(''ATOMS {'')')
        do 2100i=1,nacalc
          if(Nenacitat) then
            if(kswa(i).ne.KPhase) go to 2100
            ii=i
          else
            ii=1
            read(m40,103) Atom(1),isf(1),itf(1),ai(1),(x(j,1),j=1,3)
            read(m40,104) (beta(j,1),j=1,6)
          endif
          write(55,'(a2,'' '''''',a8,'''''''',3f10.6,'' 1.000 2.000'')')
     1          AtType(isf(ii),KPhase),atom(ii),(x(j,ii),j=1,3)
2100    continue
        write(55,'(''}'')')
        write(55,'(''END'')')
      else if(nfor.eq.3) then
        write(55,'(''TITLE '',20a1)')(fln(i:i),i=1,ifln)
        write(radka,'(3f10.4,3f10.2)')(CellPar(i,1,KPhase),i=1,6)
        k=0
        call WriteLabeledRecord(55,'cell',Radka,k)
        do 3200i=1,ns
          do 3100j=1,2*ncs-3,-2
            pom=j
            do 3000k=1,9
              rmp(k)=rm6(k,i,1,KPhase)*pom
3000        continue
            call codesym(rmp,s6(1,i,1,KPhase),isp,0)
            t80='SYMM '//isp(1)(:idel(isp(1)))//' '//
     1                   isp(2)(:idel(isp(2)))//' '//
     2                   isp(3)(:idel(isp(3)))
            write(55,FormA1)(t80(l:l),l=1,idel(t80))
3100      continue
3200    continue
        write(55,'(''LATC '',a1)') lattice(1:1)
        write(55,'(''VIEW 0 0 1'')')
        write(55,'(''XYZR 0.0 1.0 0.0 1.0 0.0 1.0'')')
        write(55,'(''END'')')
        do 3500i=1,nacalc
          if(Nenacitat) then
            if(kswa(i).ne.KPhase) go to 3500
            ii=i
          else
            ii=1
            read(m40,103) Atom(1),isf(1),itf(1),ai(1),(x(j,1),j=1,3)
            read(m40,104) (beta(j,1),j=1,6)
          endif
          write(55,'(a2,3x,a8,3x,3f10.5)')
     1      AtType(isf(ii),KPhase),atom(ii),(x(j,ii),j=1,3)
3500    continue
        close(55)
      else if(nfor.eq.4) then
        write(radka,'(3f10.4,3f10.2)')(CellPar(i,1,KPhase),i=1,6)
        k=0
        call WriteLabeledRecord(55,'Cell',Radka,k)
        write(55,'(''Localize''/''Showcell''/''Nobond'')')
        do 4000i=1,nf
          write(55,'(''Define  '',A2,''  1.5  0.0  Red'')')
     1      AtType(i,KPhase)
4000    continue
        do 4100i=1,nacalc
          if(Nenacitat) then
            if(kswa(i).ne.KPhase) go to 4100
            ii=i
          else
            ii=1
            read(m40,103) Atom(1),isf(1),itf(1),ai(1),(x(j,1),j=1,3)
            read(m40,104) (beta(j,1),j=1,6)
          endif
          write(55,'(''Atom  '',i4,3x,a8,3f10.5)') i,atom(ii),
     1              (x(j,ii),j=1,3)
4100    continue
        write(55,'(''Spacegroup '',i3,''   = '',a11)') ngrupa,grupa
        write(55,'(''=Duplicate 2 2 2''/''=Translate -1 -1 -1'')')
      else if(nfor.eq.5) then
        write(55,'(''TITL '',20a1)')(fln(i:i),i=1,ifln)
        write(radka,'(f9.6,3f10.4,3f10.2)') LamAve(1),
     1                                      (CellPar(i,1,KPhase),i=1,6)
        k=0
        call WriteLabeledRecord(55,'CELL',Radka,k)
        latt=index(smbc,lattice(1:1))
        if(latt.eq.1) then
          i=1
        else if(latt.ge.2.and.latt.le.4) then
          i=latt+3
        else
          i=latt-3
        endif
        if(ncs.eq.2) i=-i
        write(radka,'(i2)') i
        k=0
        call WriteLabeledRecord(55,'LATT',Radka,k)
        do 5100i=2,ns
          call codesym(rm6(1,i,1,KPhase),s6(1,i,1,KPhase),isp,0)
          t80=isp(1)//isp(2)//isp(3)
          carka=.true.
          do 5000l=1,idel(t80)
            if(t80(l:l).eq.' ') then
              if(.not.carka) then
                t80(l:l)=','
                carka=.true.
              endif
            else
              carka=.false.
            endif
5000      continue
          call zhusti(t80)
          t80='SYMM '//t80
          write(55,FormA1)(t80(l:l),l=1,idel(t80))
5100    continue
        radka='SFAC'
        k=6
        i=0
5150    i=i+1
        radka=radka(:k)//AtType(i,KPhase)
        if(i.lt.nf) then
          k=idel(radka)+1
          go to 5150
        endif
        write(55,FormA1)(radka(i:i),i=1,idel(radka))
        write(radka,'(15i5)')
     1    (nint(AtMult(i,KPhase)*float(nz)),i=1,NAtFormula)
        k=0
        call WriteLabeledRecord(55,'UNIT',Radka,k)
        write(radka,'(f9.6)') sc(1)
        k=0
        call WriteLabeledRecord(55,'FVAR',Radka,k)
        call TestAtomNames(AtomOld,AtomNew,isfold,nacalc,iflag)
        if(iflag.gt.0) then
          write(55,'(''REM ***************************************'')')
          write(55,'(''REM **   JANA98 vers. SHELX atom names   **'')')
          write(55,'(''REM ***************************************'')')
          ik=0
          do 5160j=1,(nacalc-1)/4+1
            ip=ik+1
            ik=min(ik+4,nacalc)
            t80='REM '
            k=5
            do 5155i=ip,ik
              t80(k:)=atomold(i)(:idel(atomold(i)))//'='//
     1                atomnew(i)(:min(idel(atomnew(i)),4))
              k=k+16
5155        continue
            write(55,FormA1)(t80(k:k),k=1,idel(t80))
5160      continue
        else if(iflag.lt.0) then
          close(55,status='delete')
          go to 9999
        endif
        do 5200i=1,nacalc
          if(Nenacitat) then
            if(kswa(i).ne.KPhase) go to 5200
            ii=i
          else
            ii=1
            read(m40,103) Atom(1),isf(1),itf(1),ai(1),(x(j,1),j=1,3)
            read(m40,104) (beta(j,1),j=1,6)
          endif
          if(itf(ii).eq.1) then
            write(55,100) AtomNew(i),isfold(i),(x(j,ii),j=1,3),
     1                    ai(ii)+10.,beta(1,ii)/episq
          else
            write(55,100) AtomNew(i),isfold(i),(x(j,ii),j=1,3),
     1                    ai(ii)+10.,(beta(j,ii)/urcp(j,1,KPhase),j=1,2)
            write(55,101) beta(3,ii)/urcp(3,1,KPhase),
     1                   (beta(j,ii)/urcp(j,1,KPhase),j=6,4,-1)
          endif
5200    continue
        write(55,'(''END'')')
      else if(nfor.eq.6) then
        i=idel(FileName)
        call MoveFile('#tmp#.m40',FileName(:i)//'.m40',.false.)
        call MoveFile('#tmp#.m50',FileName(:i)//'.m50',.false.)
        go to 9999
      else if(nfor.eq.7) then
        if(Nenacitat) then
          i=0
        else
          i=1
        endif
        call MakeBasicCIF(i)
      else
        write(55,FormA1)(Titulek(i:i),i=1,idel(Titulek))
        if(CellPar(1,1,KPhase).gt.CellPar(2,1,KPhase)) then
          i1=1
          i2=2
        else
          i1=2
          i2=1
        endif
        write(55,'(1x,i2,6f8.4)') 10,
     1    CellPar(i1,1,KPhase)*.1,CellPar(i2,1,KPhase)*.1,
     2    CellPar(3,1,KPhase)*.1,CellPar(3+i1,1,KPhase),
     3    CellPar(3+i2,1,KPhase),CellPar(6,1,KPhase)
        do 6000i=1,nacalc
          if(Nenacitat) then
            if(kswa(i).ne.KPhase) go to 6000
            ii=i
          else
            ii=1
            read(m40,103) Atom(1),isf(1),itf(1),ai(1),(x(j,1),j=1,3)
            read(m40,104) (beta(j,1),j=1,6)
          endif
          if(itf(ii).gt.1) then
            call boueq(beta(1,ii),sbeta(1,ii),1,pom,spom,iswa(ii))
          else
            pom=beta(1,ii)
          endif
          j=isf(ii)
          write(55,'(1x,a2,8f8.4)') AtType(j,KPhase),x(i1,ii),x(i2,ii),
     1                              x(3,ii),ai(ii),pom/episq
6000    continue
      endif
      call CloseIfOpened(m40)
      call CloseIfOpened(55)
      go to 9999
9000  ich=1
9999  return
100   format(a4,i4,f10.5,f10.5,f10.5,f10.5,f10.5,f10.5,' =')
101   format(f14.5,f10.5,f10.5,f10.5)
103   format(a8,2i3,4x,4f9.6)
104   format(6f9.6)
      end
      subroutine TestAtomNames(AtomOld,AtomNew,isfold,nacalc,iflag)
      include 'params.cmn'
      include 'basic.cmn'
      include 'fepc.cmn'
      dimension natp(15),isfold(*)
      character*8 AtomNew(*),AtomOld(*)
      character*80 t80
      character*256 TmpName
      logical CrwLogicQuest
      k=0
      do 1000i=1,nacalc
        AtomNew(i)=AtomOld(i)
        if(idel(AtomOld(i)).gt.4) k=k+1
1000  continue
      if(k.le.0) then
        iflag=0
        go to 9999
      endif
1200  id=NextQuestId()
      call FeQuestCreate(id,-1.,-1.,160.,0,3,'Atom names are longer '//
     1                   'than 4 characters',0,LightGray,0,0)
      call FeQuestLabelMake(id,80.,1,'What to do to make the export :',
     1                      'C')
      xpom=40.
      do 1400i=1,3
        if(i.eq.1) then
          t80='Use %edit'
        else if(i.eq.2) then
          t80='%Truncate'
        else
          t80='%Rename'
        endif
        call FeQuestCrwMake(id,xpom,2,xpom-4.,3,t80,'C',8.,8.,0,1)
        call FeQuestCrwOpen(i,i.eq.3)
        xpom=xpom+40.
1400  continue
      icont=0
1500  call FeQuestEvent(id,icont,ich)
      icont=1
      if(CheckType.ne.0) then
        call NebylOsetren
        go to 1500
      endif
      if(ich.eq.0) then
        if(CrwLogicQuest(1)) then
          ln=NextLogicNumber()
          TmpName=fln(:ifln)//'_names.tmp'
          open(ln,file=TmpName)
          write(ln,'(8(a8,1x))')(AtomNew(i),i=1,nacalc)
          close(ln)
          if(OpSystem.eq.0) call FeGrQuit
          call FeEdit(TmpName,-1)
          if(OpSystem.eq.0) then
            call OpenWorkSpace
            call FeMakeGrWin(0.,0.,14.,0.)
            GrOn=.true.
            call FeExposeEvent
          endif
          open(ln,file=TmpName)
2000      read(ln,FormA80,end=2200) t80
          k=0
          i=1
2100      call kus(t80,k,AtomNew(i))
          j=idel(AtomNew(i))
          if(j.gt.4) then
            call FeChybne(-1.,-1.,AtomNew(i)(:j)//'" has still '//
     1                    'more than 4 characters',' ',0,Warning)
            close(ln,status='Delete')
            go to 1200
          endif
          if(k.lt.80) then
            i=i+1
            go to 2100
          else
            go to 2000
          endif
2200      close(ln,status='Delete')
          iflag=1
        else if(CrwLogicQuest(2)) then
          iflag=2
        else
          iflag=3
          do 2300i=1,nf
            natp(i)=0
2300      continue
          do 2310i=1,nacalc
            j=isfold(i)
            natp(j)=natp(j)+1
c            if((natp(j).ge.100 .and.idel(nat(j)).eq.2).or.
c     1         (natp(j).ge.1000.and.idel(nat(j)).eq.1)) natp(j)=0
            write(AtomNew(i),'(i3)') natp(j)
            AtomNew(i)=AtType(j,KPhase)//AtomNew(i)(1:3)
            call zhusti(AtomNew(i))
2310      continue
        endif
      endif
      call FeQuestRemove(id)
      if(ich.ne.0) iflag=-1
9999  return
      end
      subroutine TrSuper
      include 'params.cmn'
      include 'basic.cmn'
      include 'atoms.cmn'
      include 'molec.cmn'
      include 'fepc.cmn'
      include 'refine.cmn'
      include 'dist.cmn'
      include 'powder.cmn'
      character*256 Veta,EdwStringQuest,FlnNew
      character*8 atoms
      character*4 t4
      logical FeYesNo,StructureExists,ExistFile
      dimension fc(3),rc(3),xpp(6),xs(6),betas(6),snwp(mxw),cswp(mxw),
     1          ih(6),h(3),ihp(3),c3s(10),c4s(15),c5s(21),c6s(28),ia(6),
     2          x4center(3),delta(3),trp(3,3),trpi(3,3),PomMat(28),
     3          src2(36,2),src3(100,2),src4(225,2),src5(441,2),
     4          src6(784,2)
500   id=NextQuestId()
      call FeQuestCreate(id,-1.,-1.,150.,0,1,'Type name of the super-'
     1                 //'structure',0,LightGray,0,0)
      Veta='%Browse'
      xpom=5.
      tpom=5.
      dpom=150.-FeTxLengthUnder(Veta)-25.
      call FeQuestEdwMake(id,tpom,1,xpom,1,' ','L',dpom,EdwYd,0)
      nEdwName=EdwLastMade
      call FeQuestStringEdwOpen(EdwLastMade,' ')
      xpom=tpom+dpom+5.
      dpom=FeTxLengthUnder(Veta)+10.
      call FeQuestButtonMake(id,xpom,1,dpom,ButYd,Veta)
      nButtBrowse=ButtonLastMade
      call FeQuestButtonOpen(ButtonLastMade,ButtonOff)
1000  icont=0
      call FeQuestEvent(id,icont,ich)
      icont=1
      if(CheckType.eq.EventButton.and.CheckNumber.eq.nButtBrowse) then
        Veta=EdwStringQuest(nEdwName)
        call FeFileManager('Select output structure',Veta,'*',1,.true.,
     1                      ich)
        if(ich.eq.0) call FeQuestStringEdwOpen(nEdwName,Veta)
        call FeQuestButtonOff(nButtBrowse)
        go to 1000
      else if(CheckType.ne.0) then
        call NebylOsetren
        go to 1000
      endif
      if(ich.eq.0) then
        FlnNew=EdwStringQuest(nEdwName)
        IFlnNew=idel(FlnNew)
        if(StructureExists(FlnNew)) then
          if(.not.FeYesNo(-1.,-1.,'The structure "'//
     1                    FlnNew(:IFlnNew)//
     2                    '" already exists, rewrite it?',0)) go to 9200
        else if(FlnNew.eq.' ') then
          call FeChybne(-1.,-1.,'The empty string isn''t acceptable, '//
     1                  'try again',' ',0,SeriousError)
          go to 500
        endif
      endif
      call FeQuestRemove(id)
      if(ich.ne.0) go to 9999
      call OpenFile(44,fln(:ifln)//'_m40.tmp','formatted','unknown')
      if(ErrJana.ne.0) go to 9200
      i=0
      do 1050j=1,ncomp
        i=max(ncommen(1,j,KPhase)*ncommen(2,j,KPhase)*
     1                            ncommen(3,j,KPhase),i)
        if(j.eq.1) scsupp=1./float(i)
1050  continue
      n=1
1052  if(i.ge.10) then
        n=n+1
        i=i/10
        go to 1052
      endif
      do 1055j=1,3
        rc(j)=1./float(ncommen(j,1,KPhase))
1055  continue
      if(ncomp.gt.1) then
        do 1060i=2,ncomp
          call srotb(zsigi(1,i,KPhase),zsigi(1,i,KPhase),src2(1,i-1))
          if(itfmax.gt.2) then
            call srotc(zsigi(1,i,KPhase),3,src3(1,i-1))
            if(itfmax.gt.3) then
              call srotc(zsigi(1,i,KPhase),4,src4(1,i-1))
              if(itfmax.gt.4) then
                call srotc(zsigi(1,i,KPhase),5,src5(1,i-1))
                if(itfmax.gt.5) then
                  call srotc(zsigi(1,i,KPhase),6,src6(1,i-1))
                endif
              endif
            endif
          endif
1060    continue
      endif
      call trortho(0)
      call comsym(KPhase,0)
      call comexp(sngc,csgc)
      if(ErrJana.ne.0) go to 9200
      idm=0
      do 1070i=1,nacalc
        if(kswa(i).eq.KPhase) idm=max(idm,idel(atom(i)))
1070  continue
      idm=min(idm,8-n)
      mc=0
      do 1430i=1,nacalc
        if(ai(i).eq.0..or.kswa(i).ne.KPhase) go to 1430
        isw=iswa(i)
        itfi=itf(i)
        kmodxi=kmodx(i)
        kmodsi=kmods(i)
        if(kfs(i).ne.0.and.kmodsi.ne.0) then
          kfsi=kfs(i)
        else
          kfsi=0
        endif
        if(kfx(i).ne.0.and.kmodxi.ne.0) then
          kfxi=kfx(i)
        else
          kfxi=0
        endif
        mxmod=0
        do 1072j=1,itfi+1
          mxmod=max(mxmod,kmoda(i,j))
1072    continue
        ic=0
        if(kfsi.ne.0) then
          k=kmodsi-ndimi
          do 1080j=1,ndimi
            k=k+1
            x4center(j)=ax(k,i)
            if(ndimi.gt.1) then
              delta(j)=ay(k,i)*.5
            else
              delta(j)=a0(i)*.5
            endif
1080      continue
        else if(kfxi.ne.0) then
          x4center(1)=uy(1,kmodxi,i)
          delta(1)=uy(2,kmodxi,i)*.5
        endif
        do 1420ic3=0,ncommen(3,isw,KPhase)-1
          fc(3)=ic3
          do 1410ic2=0,ncommen(2,isw,KPhase)-1
            fc(2)=ic2
            do 1400ic1=0,ncommen(1,isw,KPhase)-1
              mc=mc+1
              ic=ic+1
              fc(1)=ic1
              do 1105j=1,3
                xs(j)=x(j,i)+fc(j)
1105          continue
              call qbyx(fc,xs(4),isw)
              call AddVek(qcnt(1,i),xs(4),xs(4),ndimi)
              call AddVek(xs(4),trez(1,isw,KPhase),xs(4),ndimi)
              do 1130k=1,mxmod
                arg=0.
                do 1120n=1,ndimi
                  arg=arg+float(kw(n,k,KPhase))*xs(n+3)
1120            continue
                arg=arg*pi2
                snwp(k)=sin(arg)
                cswp(k)=cos(arg)
1130          continue
              occx=1.
              do 1170k=1,kmodxi
                if(kfxi.gt.0.and.k.eq.kmodxi) then
                  pom=xs(4)-x4center(1)
                  j=pom
                  if(pom.lt.0.) j=j-1
                  pom=pom-float(j)
                  if(pom.gt..5) pom=pom-1.
                  if(kfxi.eq.1) then
                    znak=pom/delta(1)
                    if(pom.ge.-delta(1).and.pom.le.delta(1)) then
                      occx=1.
                    else
                      occx=0.
                    endif
                  else
                    if(pom.ge.-delta(1).and.pom.le.delta(1)) then
                      znak=1.
                    else
                      znak=-1.
                    endif
                  endif
                  do 1140j=1,3
                    xs(j)=xs(j)+ux(j,k,i)*znak
1140              continue
                else
                  sn=snwp(k)
                  cs=cswp(k)
                  do 1150j=1,3
                    xs(j)=xs(j)+ux(j,k,i)*sn+uy(j,k,i)*cs
1150              continue
                endif
1170          continue
              occo=0.
              if(kmodsi.gt.0) then
                if(kfsi.eq.0.and.kfxi.eq.0) occo=a0(i)-occx
                kk=0
                do 1200k=1,kmodsi
                  if(kfsi.ne.0.and.k.gt.kmodsi-ndimi) then
                    kk=kk+1
                    pom=xs(kk+3)-x4center(kk)
                    j=pom
                    if(pom.lt.0.) j=j-1
                    pom=pom-float(j)
                    if(pom.gt..5) pom=pom-1.
                    if(pom.ge.-delta(kk)-.0001.and.
     1                 pom.le. delta(kk)+.0001) then
                      occx=1.
                    else
                      occx=0.
                      go to 1210
                    endif
                  else
                    sn=snwp(k)
                    cs=cswp(k)
                    occo=occo+ax(k,i)*sn+ay(k,i)*cs
                  endif
1200            continue
              endif
1210          if(occx.gt.0.) then
                ais=ai(i)*(occx+occo)
              else
                ais=0.
                go to 1400
              endif
              do 1300n=2,itfi
                nrank=TRank(n)
                if(n.eq.2) then
                  call CopyVek(beta(1,i),betas,nrank)
                else if(n.eq.3) then
                  call CopyVek(c3(1,i),c3s,nrank)
                else if(n.eq.4) then
                  call CopyVek(c4(1,i),c4s,nrank)
                else if(n.eq.5) then
                  call CopyVek(c5(1,i),c5s,nrank)
                else
                  call CopyVek(c6(1,i),c6s,nrank)
                endif
                do 1240k=1,kmoda(i,n+1)
                  sn=snwp(k)
                  cs=cswp(k)
                  do 1220j=1,nrank
                    if(n.eq.2) then
                      betas(j)=betas(j)+bx(j,k,i)*sn+by(j,k,i)*cs
                    else if(n.eq.3) then
                      c3s(j)=c3s(j)+c3x(j,k,i)*sn+c3y(j,k,i)*cs
                    else if(n.eq.4) then
                      c4s(j)=c4s(j)+c4x(j,k,i)*sn+c4y(j,k,i)*cs
                    else if(n.eq.5) then
                      c5s(j)=c5s(j)+c5x(j,k,i)*sn+c5y(j,k,i)*cs
                    else
                      c6s(j)=c6s(j)+c6x(j,k,i)*sn+c6y(j,k,i)*cs
                    endif
1220              continue
1240            continue
1300          continue
              if(itfi.le.1) betas(1)=beta(1,i)
              if(isw.eq.1) then
                do 1330j=1,3
                  xpp(j)=xs(j)*rc(j)
1330            continue
              else
                call qbyx(xs,xs(4),isw)
                do 1350k=4,ndim
                  xs(k)=xs(k)+trez(k-3,isw,KPhase)
1350            continue
                call multm(zvi(1,isw,KPhase),xs,xpp,ndim,ndim,1)
                do 1370j=1,3
                  xpp(j)=xpp(j)*rc(j)
1370            continue
              endif
              do 1390n=2,itfi
                nrank=TRank(n)
                if(isw.ne.1) then
                  if(n.eq.2) then
                    call multm(src2(1,isw-1),betas,PomMat,nrank,nrank,1)
                    call CopyVek(PomMat,betas,nrank)
                  else if(n.eq.3) then
                    call multm(src3(1,isw-1),c3s,PomMat,nrank,nrank,1)
                    call CopyVek(PomMat,c3s,nrank)
                  else if(n.eq.4) then
                    call multm(src4(1,isw-1),c4s,PomMat,nrank,nrank,1)
                    call CopyVek(PomMat,c4s,nrank)
                  else if(n.eq.5) then
                    call multm(src5(1,isw-1),c5s,PomMat,nrank,nrank,1)
                    call CopyVek(PomMat,c5s,nrank)
                  else if(n.eq.6) then
                    call multm(src6(1,isw-1),c6s,PomMat,nrank,nrank,1)
                    call CopyVek(PomMat,c6s,nrank)
                  endif
                endif
                do 1384j=1,nrank
                  if(n.eq.2) then
                    call indext(j,ia(1),ia(2))
                  else
                    call indexc(j,n,ia)
                  endif
                  k=1
                  do 1382l=1,n
                    k=k*ncommen(ia(l),1,KPhase)
1382              continue
                  if(n.eq.2) then
                    betas(j)=betas(j)/float(k)
                  else if(n.eq.3) then
                    c3s(j)=c3s(j)/float(k)
                  else if(n.eq.4) then
                    c4s(j)=c4s(j)/float(k)
                  else if(n.eq.5) then
                    c5s(j)=c5s(j)/float(k)
                  else
                    c6s(j)=c6s(j)/float(k)
                  endif
1384            continue
1390          continue
              write(t4,'(''-'',i3)') ic
              call zhusti(t4)
              atoms=atom(i)(:min(idel(atom(i)),idm))//t4(:idel(t4))
              write(44,100) atoms,isf(i),itfi,ais,(xpp(j),j=1,3),betas
              if(itfi.gt.2) then
                write(44,102) c3s
                if(itfi.gt.3) then
                  write(44,102) c4s
                  if(itfi.gt.4) then
                    write(44,102) c5s
                    if(itfi.gt.5) write(44,102) c6s
                  endif
                endif
              endif
1400        continue
1410      continue
1420    continue
1430  continue
      if(nmolc.gt.0) then
        call FeChybne(-1.,-1.,'atoms of molecule(s) will be first',
     1                'transformed to atomic part',0,Warning)
        call SetIntArrayTo(iamn,nmolc,0)
        call SetIntArrayTo(iam ,nmolc,0)
        call SetIntArrayTo(mam ,nmolc,0)
        call SetIntArrayTo(nmol,3,0)
        j=nmolcOff
        do 1450i=nmolcOff+nmolc+1,nmolcAll
          j=j+1
          iamn(j)=iamn(i)
          iam (j)=iam (i)
          mam (j)=mam (i)
1450    continue
        call AtSun(nacbOff+nacb+1,mxa+nacbAll,nacbOff+1)
        nacbAll=nacbAll-nacb
        nacb=0
        nmolcAll=nmolcAll-nmolc
        nmolc=0
      endif
      if(isPowder) then
        if(ExistM92) call CopyFile(fln(:ifln)//'.m92',
     1                             FlnNew(:IFlnNew)//'.m92')
        if(KStrain.eq.2) then
          m4=0
          do 1530i1=1,3
            pom1=float(ncommen(i1,1,KPhase))
            do 1520i2=i1,3
              pom2=pom1*float(ncommen(i2,1,KPhase))
              do 1510i3=i2,3
                pom3=pom2*float(ncommen(i3,1,KPhase))
                do 1500i4=i3,3
                  pom4=pom3*float(ncommen(i4,1,KPhase))
                  m4=m4+1
                  StPwd(m4,KPhase)=StPwd(m4,KPhase)/pom4
1500            continue
1510          continue
1520        continue
1530      continue
        endif
      else
        if(.not.ExistM91) go to 2000
        call OpenFile(91,fln(:ifln)//'.m91','formatted','old')
        if(ErrJana.ne.0) then
          ErrJana=0
          go to 2000
        endif
        call OpenFile(99,FlnNew(:IFlnNew)//'.m91','formatted','unknown')
        if(ErrJana.ne.0) go to 9200
        NInfo=0
1600    read(91,format91,end=1700)(ih(i),i=1,ndim),f,sf,iq,nxx,itw,tbar
        if(ih(1).ge.900) go to 1700
        do 1605j=1,3
          h(j)=ih(j)
1605    continue
        do 1620i=1,ndimi
          do 1610j=1,3
            h(j)=h(j)+qu(j,i,1,KPhase)*float(ih(i+3))
1610      continue
1620    continue
        do 1625j=1,3
          pom=h(j)*float(ncommen(j,1,KPhase))
          ihp(j)=nint(pom)
          if(abs(pom-float(ihp(j))).gt..001) then
            if(NInfo.lt.10) then
              Ninfo=Ninfo+1
              TextInfo(Ninfo)='Rounding error for reflection : '
              write(TextInfo(Ninfo)(idel(TextInfo(Ninfo))+2:),'(6i4)')
     1                             (ih(i),i=1,ndim)
            else if(Ninfo.eq.10) then
              Ninfo=11
              TextInfo(Ninfo)='                   ... and more ... '
            endif
            go to 1600
          endif
1625    continue
        write(99,'(3i4,2f9.1,3i2,f8.4)') ihp,f,sf,iq,nxx,itw,tbar
        go to 1600
1700    write(99,'('' 999'')')
        call CloseIfOpened(91)
        call CloseIfOpened(99)
        if(NInfo.gt.0)
     1    call FeInfoOut(-1.,-1.,'Some reflections couldn''t be '//
     2                           'transformed')
      endif
2000  call SuperSGToSuperCellSG(ich)
      if(ich.ne.0) go to 9100
      do 2320i=1,3
        pom=float(ncommen(i,1,KPhase))
        CellPar(i,1,KPhase)=CellPar(i,1,KPhase)*pom
        if(isPowder) CellPwd(i,KPhase)=CellPwd(i,KPhase)*pom
2320  continue
      ndim=3
      ndimq=9
      ndimi=0
      kcommen=0
      ncomp=1
      call FindSmbSg(Grupa,ChangeOrderYes,1)
      do 2450i=1,3
        nz=nz*float(ncommen(i,1,KPhase))
2450  continue
      if(ITwin.gt.1) then
        call UnitMat(trp,3)
        do 2500i=1,3
          trp (i,i)=rc(i)
          trpi(i,i)=1./rc(i)
2500    continue
        do 2550i=1,ITwin
          call MultM(trp,rtw(1,i),PomMat,3,3,3)
          call MultM(PomMat,trpi,rtw(1,i),3,3,3)
2550    continue
      endif
      call CopyFile(fln(:ifln)//'.l51',FlnNew(:IFlnNew)//'.l51')
      call OpenFile(m50,FlnNew(:IFlnNew)//'.m50','formatted','unknown')
      call iom50(1,0)
      call iom50(0,0)
      call CloseIfOpened(m50)
      rewind 44
      do 3000i=1,mxscu
        sc(i)=sc(i)*scsupp
3000  continue
      n=nacOff
      if(n.gt.0) then
        PrvniKi=PrvniKiAtomu(n)+DelkaKiAtomu(n)+1
      else
        PrvniKi=1
      endif
      call AtSun(nacOff+nac+1,NacAll,nacOff+1)
      NacAll=NacAll-nac
3100  read(44,100,end=3200) atoms,isfn,itfn,ais,(xs(i),i=1,3),betas
      ais=ais*ScCentrGC
      i=1
3170  i=koinc(xs,x,i,n,.1,dist,1)
      if(i.gt.0) then
        if(isf(i).ne.isfn) then
          if(i.lt.n) then
            i=i+1
            go to 3170
          else
            i=0
          endif
        endif
      endif
      if(i.gt.0) then
        ai(i)=ai(i)+ais
        if(itfn.gt.2) then
          read(44,102)(c3(i,n),i=1,10)
          if(itfn.gt.3) then
            read(44,102)(c4(i,n),i=1,15)
            if(itfn.gt.4) then
              read(44,102)(c5(i,n),i=1,21)
              if(itfn.gt.5) then
                read(44,102)(c6(i,n),i=1,28)
              endif
            endif
          endif
        endif
        go to 3100
      else
        n=n+1
        call AtSun(nacOff+n,NacAll,nacOff+n+1)
        NacAll=NacAll+1
        if(n.gt.mxa) then
          NInfo=3
          TextInfo(1)='The number of atoms in the supercell structure '
     1              //'exceeds the maximal'
          write(Cislo,FormI15) mxa
          call Zhusti(Cislo)
          TextInfo(2)='number of '//Cislo(:idel(Cislo))//' atoms. The '
     1              //'file m40 will not be created but all atomic '
          TextInfo(3)='parameters are recorded to file "#tmp#.m40".'
          call FeInfoOut(-1.,-1.,'ERROR')
          ln=NextLogicNumber()
          call OpenFile(ln,'#tmp#.m40','formatted','unknown')
          write(ln,'(4i5)') mc,0,lite,0
          write(ln,102)(sc(i),i=1,mxscu)
          write(ln,102) 0.
          write(ln,102)(0.,i=1,12)
          rewind 44
3180      read(44,FormA80,end=3185) Veta
          write(ln,FormA1)(Veta(i:i),i=1,idel(Veta))
          go to 3180
3185      close(ln)
          n=0
          go to 3200
        endif
        PrvniKiAtomu(n)=PrvniKi
        DelkaKiAtomu(n)=max(TRankCumul(itfn),10)
        PrvniKi=PrvniKi+DelkaKiAtomu(n)
        write(t4,'(''-'',i3)') ic
        call zhusti(t4)
        atom(n)=atoms
        isf(n)=isfn
        itf(n)=itfn
        iswa(n)=1
        kswa(n)=KPhase
        do 3190i=1,7
          kfa(n,i)=0
          kmoda(n,i)=0
3190    continue
        ai(n)=ais
        sai(n)=0.
        call CopyVek(xs,x(1,n),3)
        call specpos(x(1,n),iswa(n),.01,i)
        call SetRealArrayTo(sx(1,n),3,0.)
        call CopyVek(betas,beta(1,n),6)
        call SetRealArrayTo(sbeta(1,n),6,0.)
        if(itfn.gt.2) then
          read(44,102)(c3(i,n),i=1,10)
          call SetRealArrayTo(sc3,10,0.)
          if(itfn.gt.3) then
            read(44,102)(c4(i,n),i=1,15)
            call SetRealArrayTo(sc4,15,0.)
            if(itfn.gt.4) then
              read(44,102)(c5(i,n),i=1,21)
              call SetRealArrayTo(sc5,21,0.)
              if(itfn.gt.5) then
                read(44,102)(c6(i,n),i=1,28)
                call SetRealArrayTo(sc6,28,0.)
              endif
            endif
          endif
        endif
        go to 3100
      endif
3200  close(44,status='delete')
      if(n.gt.0) then
        call SetIntArrayTo(ki,PrvniKi,0)
        na(1)=n
        na(2)=0
        na(3)=0
        nac=n
        nor=0
        call OpenFile(m40,FlnNew(:IFlnNew)//'.m40','formatted',
     1                'unknown')
        call iom40(1,0)
        call CloseIfOpened(m40)
      else
        call DeleteFile(FlnNew(:IFlnNew)//'.m40')
      endif
      Veta=Fln
      Fln=FlnNew
      ifln=idel(Fln)
      if(ExistFile(fln(:ifln)//'.m40')) then
        call OpenCommandsRefine
        j=NactiInt+NactiReal+21
        do 3600i=j,j+8
          call DeleteFile(FlnNew(:IFlnNew)//'_'//
     1                    NactiKeywords(i)(:idel(NactiKeywords(i)))//
     2                    '.tmp')
3600    continue
        NacetlInt(nCmdkim)=DefIntRefine(nCmdkim)
        NacetlInt(nCmdkic)=DefIntRefine(nCmdkic)
        NacetlInt(nCmdmetoda)=DefIntRefine(nCmdmetoda)
        NacetlInt(nCmdngrid)=DefIntRefine(nCmdngrid)
        NacetlInt(nCmdiover)=DefIntRefine(nCmdiover)
        NacetlReal(nCmdDifBess)=DefRealRefine(nCmdDifBess)
        NacetlReal(nCmdOverDif)=DefRealRefine(nCmdOverDif)
        call RewriteCommandsRefine(1)
        call OpenCommandsDist
        if(ErrJana.ne.0) go to 9999
        do 3700i=nCmdTorsion,nCmdbondval
          call DeleteFile(FlnNew(:IFlnNew)//'_'//
     1                    NactiKeywords(i)(:idel(NactiKeywords(i)))//
     2                    '.tmp')
3700    continue
        call SetLogicalArrayTo(BratPrvni,mxa,.true.)
        call SetLogicalArrayTo(BratDruhyATreti,mxa,.true.)
        call RewriteCommandsDist(1)
      endif
      Fln=Veta
      ifln=idel(Fln)
      call ContinueWithNewStructure(FlnNew)
      go to 9999
9100  call DeleteFile(fln(:ifln)//'.m40')
      call DeleteFile(fln(:ifln)//'.m50')
      call DeleteFile(fln(:ifln)//'.m91')
9200  call DeleteFile(PreviousM40)
      call DeleteFile(PreviousM50)
9999  call DeleteFile(fln(:ifln)//'_m40.tmp')
      ErrJana=0
      return
100   format(a8,2i3,4x,4f9.6/6f9.6)
102   format(6f9.6)
      end
      subroutine EM40Tr(klicin,ich)
      include 'params.cmn'
      include 'basic.cmn'
      include 'atoms.cmn'
      include 'molec.cmn'
      include 'editm40.cmn'
      dimension kuda(3),GammaIntP(9),GammaIntPI(9),kwz(3),kwp(3)
      integer SelPart,GammaInt(9,24)
      logical eqiv,BratMol(mxpm),SwitchedToHarmIn
      ich=0
      kdo=0
      klic=klicin
      call ReadTr(klic,ich)
      if(ich.ne.0) go to 9999
      i=SelPart(1)
      if(i.eq.0) then
        call DefGroup(i1,i2,0)
        if(i1.le.0) go to 9999
        call SetLogicalArrayTo(BratMol,MaxMolPos,.false.)
        go to 1100
      else if(i.eq.1) then
        call DefMolGroup(BratMol,ich)
        if(ich.ne.0) go to 9999
        i1=1
        i2=0
        go to 2100
      else if(i.lt.0) then
        ich=1
        go to 9999
      else
        i1=nacOff+1
        i2=nacOff+nac
        call SetLogicalArrayTo(AtBrat(nacOff+1),nac,.true.)
        call SetLogicalArrayTo(BratMol,MaxMolPos,.true.)
      endif
      kdo=0
      go to 1100
      entry EM40TransAtFromTo(ifrom,ito,ich)
      klic=0
      go to 1020
      entry EM40ExpandAtFromTo(ifrom,ito,ich)
      klic=1
1020  ich=0
      i1=ifrom
      i2=ito
      kdo=1
      call SetLogicalArrayTo(BratMol,mxpm,.false.)
      go to 1050
      entry EM40TransAll(ich)
      klic=0
      go to 1030
      entry EM40ExpandAll(ich)
      klic=1
1030  ich=0
      i1=1
      i2=nacAll
      call SetLogicalArrayTo(BratMol,mxp*mxm,.true.)
      n=0
      do 1040i=1,nmolcAll
        do 1035j=1,mam(i)
          n=n+1
          BratMol(n)=kswmol(i).eq.KPhase
1035    continue
1040  continue
1050  do 1060i=i1,i2
        AtBrat(i)=kswa(i).eq.KPhase
1060  continue
1100  SwitchedToHarmIn=SwitchedToHarm
      if(.not.SwitchedToHarmIn) call TrOrtho(0)
      kuda(1)=na(1)+nacOff+1
      kuda(2)=kuda(1)+na(2)
      kuda(3)=kuda(2)+na(3)
      iswo=-1
      kmodxp=1
      do 2000i=i2,i1,-1
        if((i.gt.nacalc.and.i.le.mxa).or..not.AtBrat(i)) go to 2000
        isw=iswa(i)
        if(isw.ne.iswo) then
          do 1140ntr=1,ntrans
            do 1120j=4,ndim
              do 1110k=4,ndim
                GammaIntP(k-3+(j-4)*ndimi)=trm(k+(j-1)*ndim,ntr,isw)
1110          continue
1120        continue
            call Matinv(GammaIntP,GammaIntPI,pom,ndimi)
            do 1130j=1,ndimi*ndimi
              GammaInt(j,ntr)=nint(GammaIntPI(j))
1130        continue
            iswo=isw
1140      continue
          kmodxp=1
        endif
        kmodmx=0
        do 1150k=1,7
          kmodmx=max(kmodmx,kmoda(i,k))
1150    continue
        do 1300ntr=1,ntrans
          do 1200j=kmodxp,kmodmx
            call multmi(kw(1,j,KPhase),GammaInt(1,ntr),kwp,1,ndimi,
     1                  ndimi)
            do 1160k=1,ndimi
              kwz(k)=-kwp(k)
1160        continue
            do 1170k=1,mxw
              if(eqiv(kw(1,k,KPhase),kwp,ndimi)) then
                KwSymP(j,ntr)= k
                go to 1200
              else if(eqiv(kw(1,k,KPhase),kwz,ndimi)) then
                KwSymP(j,ntr)=-k
                go to 1200
              endif
1170        continue
            if(kdo.eq.2) then
              call FeChybne(-1.,-1.,'some of modulation waves are not'//
     1                      'defined','The transformation of atoms '//
     2                      'cannot be performed',0,Warning)
            else
              call FeChybne(-1.,-1.,'some of modulation waves are not'//
     1                      ' defined','The transformation cannot be '//
     2                      'performed',0,SeriousError)
              ErrJana=1
            endif
            go to 9900
1200      continue
1300    continue
        kmodxp=kmodmx+1
        if(klic.eq.0) then
          call EM40TrAt(i,i,isw,1)
        else
          do 1800ntr=ntrans,1,-1
            if(i.lt.nacAll) call AtSun(i+1,nacAll,i+2)
            DelkaKiAtomu(i+1)=0
            if(i.eq.nacAll)
     1        PrvniKiAtomu(i+1)=PrvniKiAtomu(i)+DelkaKiAtomu(i)
            na(isw)=na(isw)+1
            nac=nac+1
            nacAll=nacAll+1
            nacalc=nacalc+1
            call EM40TrAt(i,i+1,isw,ntr)
1800      continue
        endif
2000  continue
2100  n=0
      iswo=-1
      kmodxp=1
      do 4000i=1,nmolcAll
        if(kswmol(i).ne.KPhase) go to 4000
        mami=mam(i)
        jip=mami+mxp*(i-1)
        isw=iswmol(i)
        if(isw.ne.iswo) then
          do 2140ntr=1,ntrans
            do 2120j=4,ndim
              do 2110k=4,ndim
                GammaIntP(k-3+(j-4)*ndimi)=trm(k+(j-1)*ndim,ntr,isw)
2110          continue
2120        continue
            call Matinv(GammaIntP,GammaIntPI,pom,ndimi)
            do 2130j=1,ndimi*ndimi
              GammaInt(j,ntr)=nint(GammaIntPI(j))
2130        continue
            iswo=isw
2140      continue
          kmodxp=1
        endif
        do 2150ip=1,mami
          ji=ip+mxp*(i-1)
          kmodmx=max(kmodam(ji,1),kmodam(ji,2),kmodam(ji,3))
2150    continue
        do 2300ntr=1,ntrans
          do 2200j=kmodxp,kmodmx
            call multmi(kw(1,j,KPhase),GammaInt(1,ntr),kwp,1,ndimi,
     1                  ndimi)
            do 2160k=1,ndimi
              kwz(k)=-kwp(k)
2160        continue
            do 2170k=1,mxw
              if(eqiv(kw(1,k,KPhase),kwp,ndimi)) then
                KwSymP(j,ntr)= k
                go to 2200
              else if(eqiv(kw(1,k,KPhase),kwz,ndimi)) then
                KwSymP(j,ntr)=-k
                go to 2200
              endif
2170        continue
            if(kdo.eq.2) then
              call FeChybne(-1.,-1.,'some of modulation waves are not'//
     1                      'defined','The transformation of molecules'
     2                    //'cannot be performed',0,Warning)
            else
              call FeChybne(-1.,-1.,'some of modulation waves are not'//
     1                      ' defined','The transformation cannot be '//
     2                      'performed',0,SeriousError)
              ErrJana=1
            endif
            go to 9900
2200      continue
2300    continue
        kmodxp=kmodmx+1
        do 3500ip=1,mami
          n=n+1
          if(.not.BratMol(n)) go to 3500
          ji=ip+mxp*(i-1)
          if(klic.eq.0) then
            call EM40TrMol(ji,ji,isw,1)
          else
            do 2800ntr=1,ntrans
              jip=jip+1
              DelkaKiMolekuly(jip)=0
              PrvniKiMolekuly(jip)=PrvniKiMolekuly(jip-1)+
     1                             DelkaKiMolekuly(jip-1)
              call EM40TrMol(ji,jip,isw,ntr)
              mam(i)=mam(i)+1
2800        continue
          endif
3500    continue
4000  continue
4100  call SavePhase
9900  if(.not.SwitchedToHarmIn) call TrOrtho(1)
9999  return
      end
      subroutine EM40TrAt(ii,io,isw,ntr)
      include 'params.cmn'
      include 'basic.cmn'
      include 'atoms.cmn'
      include 'editm40.cmn'
      integer PrvKi
      character*80 t80
      dimension xp(6),xpp(6),snm(mxw),csm(mxw),px(28),py(28),spx(28),
     1          spy(28),phi(3),eps(mxw),pxa(28*mxw),pya(28*mxw),
     2          spxa(28*mxw),spya(28*mxw),xps(6,2)
      if(io.ne.ii) then
        i=min(7,idel(atom(ii)))
        if(ntr.le.1) then
          atom(ii)=atom(ii)(1:i)//'a'
          if(ndim.gt.3) then
            j=kator(ii)
            if(j.gt.0) ora(j)=atom(ii)
          endif
        endif
        atom(io)=atom(ii)(1:i)//char(ichar('a')+ntr)
        kmol(io)=kmol(ii)
        iswa(io)=iswa(ii)
        kswa(io)=kswa(ii)
        isf(io)=isf(ii)
        itf(io)=itf(ii)
        ifr(io)=ifr(ii)
        lasmax(io)=lasmax(ii)
        do 1000i=1,7
          kfa(io,i)=kfa(ii,i)
          kmoda(io,i)=kmoda(ii,i)
1000    continue
        phf(io)=phf(ii)
        call ShiftKiAt(io,itf(io),ifr(io),lasmax(io),kmods(io),kmodx(io)
     1                ,kmodb(io),kmodc3(io),kmodc4(io),kmodc5(io),
     2                 kmodc6(io),.true.)
        PrvKi=PrvniKiAtomu(io)
        call SetIntArrayTo(ki(PrvKi),DelkaKiAtomu(io),0)
      endif
      call CopyVek(x(1,ii),xp,3)
      call SetRealArrayTo(xp(4),ndimi,0.)
      call multm(trm(1,ntr,isw),xp,xpp,ndim,ndim,1)
      do 1220j=1,ndim
        xp(j)=xpp(j)+trv(j,ntr,isw)
        if(j.lt.4) then
          x(j,io)=xp(j)
        else
          phi(j-3)=-xp(j)*pi2
        endif
1220  continue
      if(ndimi.gt.0) then
        kmodmx=max(kmods(ii),kmodx(ii),kmodb(ii))
        do 1250k=1,kmodmx
          eps(k)=isign(1,KwSymP(k,ntr))
          l=iabs(KwSymP(k,ntr))
          pom=0.
          do 1240m=1,ndimi
            pom=pom+float(kw(m,l,KPhase))*phi(m)
1240      continue
          snp=sin(pom)
          csp=cos(pom)
          if(abs(snp).lt..001) snp=0.
          if(abs(csp).lt..001) csp=0.
          if(abs(abs(snp)-1.).lt..001) snp=sign(1.,snp)
          if(abs(abs(csp)-1.).lt..001) csp=sign(1.,csp)
          snm(k)=snp
          csm(k)=csp
1250    continue
      endif
      if(itf(ii).le.1) then
        beta(1,io)=beta(1,ii)
        sbeta(1,io)=sbeta(1,ii)
      endif
      do 3000n=0,itf(ii)
        nrank=TRank(n)
        if(n.eq.0) then
          ai(io)=ai(ii)
          a0(io)=a0(ii)
        else if(n.eq.1) then
          do 2000j=1,nrank
            spx(j)=sx(j,ii)
2000      continue
          call multmq(smp(1,ntr,isw),spx,sx(1,io),nrank,nrank,1)
        else if(n.eq.2) then
          do 2020j=1,nrank
            px(j)= beta(j,ii)
            spx(j)=sbeta(j,ii)
2020      continue
          call multm (smpt(1,ntr,isw), px, beta(1,io),nrank,nrank,1)
          call multmq(smpt(1,ntr,isw),spx,sbeta(1,io),nrank,nrank,1)
        else if(n.eq.3) then
          do 2040j=1,nrank
            px(j)=c3(j,ii)
            spx(j)=sc3(j,ii)
2040      continue
          call multm (trc3(1,ntr,isw), px, c3(1,io),nrank,nrank,1)
          call multmq(trc3(1,ntr,isw),spx,sc3(1,io),nrank,nrank,1)
        else if(n.eq.4) then
          do 2060j=1,nrank
            px(j)=c4(j,ii)
            spx(j)=sc4(j,ii)
2060      continue
          call multm (trc4(1,ntr,isw), px, c4(1,io),nrank,nrank,1)
          call multmq(trc4(1,ntr,isw),spx,sc4(1,io),nrank,nrank,1)
        else if(n.eq.5) then
          do 2080j=1,nrank
            px(j)=c5(j,ii)
            spx(j)=sc5(j,ii)
2080      continue
          call multm (trc5(1,ntr,isw), px, c5(1,io),nrank,nrank,1)
          call multmq(trc5(1,ntr,isw),spx,sc5(1,io),nrank,nrank,1)
        else
          do 2100j=1,nrank
            px(j)=c6(j,ii)
            spx(j)=sc6(j,ii)
2100      continue
          call multm (trc6(1,ntr,isw), px, c6(1,io),nrank,nrank,1)
          call multmq(trc6(1,ntr,isw),spx,sc6(1,io),nrank,nrank,1)
        endif
        kfap=kfa(ii,n+1)
        kmodp=kmoda(ii,n+1)
        nn=kmodp*nrank
        if(kfap.ne.0) then
          if(n.eq.0) then
            ndimip=ndimi
          else
            ndimip=1
          endif
        else
          ndimip=0
        endif
        if(n.eq.0) then
          call CopyVek( ax(1,ii), pxa,nn)
          call CopyVek( ay(1,ii), pya,nn)
          call CopyVek(sax(1,ii),spxa,nn)
          call CopyVek(say(1,ii),spya,nn)
        else if(n.eq.1) then
          call CopyVek( ux(1,1,ii), pxa,nn)
          call CopyVek( uy(1,1,ii), pya,nn)
          call CopyVek(sux(1,1,ii),spxa,nn)
          call CopyVek(suy(1,1,ii),spya,nn)
        else if(n.eq.2) then
          call CopyVek( bx(1,1,ii), pxa,nn)
          call CopyVek( by(1,1,ii), pya,nn)
          call CopyVek(sbx(1,1,ii),spxa,nn)
          call CopyVek(sby(1,1,ii),spya,nn)
        else if(n.eq.3) then
          call CopyVek( c3x(1,1,ii), pxa,nn)
          call CopyVek( c3y(1,1,ii), pya,nn)
          call CopyVek(sc3x(1,1,ii),spxa,nn)
          call CopyVek(sc3y(1,1,ii),spya,nn)
        else if(n.eq.4) then
          call CopyVek( c4x(1,1,ii), pxa,nn)
          call CopyVek( c4y(1,1,ii), pya,nn)
          call CopyVek(sc4x(1,1,ii),spxa,nn)
          call CopyVek(sc4y(1,1,ii),spya,nn)
        else if(n.eq.5) then
          call CopyVek( c5x(1,1,ii), pxa,nn)
          call CopyVek( c5y(1,1,ii), pya,nn)
          call CopyVek(sc5x(1,1,ii),spxa,nn)
          call CopyVek(sc5y(1,1,ii),spya,nn)
        else if(n.eq.6) then
          call CopyVek( c6x(1,1,ii), pxa,nn)
          call CopyVek( c6y(1,1,ii), pya,nn)
          call CopyVek(sc6x(1,1,ii),spxa,nn)
          call CopyVek(sc6y(1,1,ii),spya,nn)
        endif
        nn=1
        do 2800k=1,kmodp
          iw=iabs(KwSymP(k,ntr))
          snp=snm(k)
          csp=csm(k)
          epsp=eps(k)
          if(n.eq.0) then
            px(1)=pxa(nn)
            py(1)=pya(nn)
            spx(1)=spxa(nn)
            spy(1)=spya(nn)
          else if(n.eq.1) then
            call multm (smp(1,ntr,isw), pxa(nn), px,nrank,nrank,1)
            call multmq(smp(1,ntr,isw),spxa(nn),spx,nrank,nrank,1)
            if(kfap.ne.1.or.k.ne.kmodp) then
              call multm (smp(1,ntr,isw), pya(nn), py,nrank,nrank,1)
              call multmq(smp(1,ntr,isw),spya(nn),spy,nrank,nrank,1)
            endif
          else if(n.eq.2) then
            call multm (smpt(1,ntr,isw), pxa(nn), px,nrank,nrank,1)
            call multmq(smpt(1,ntr,isw),spxa(nn),spx,nrank,nrank,1)
            if(kfap.ne.1.or.k.ne.kmodp) then
              call multm (smpt(1,ntr,isw), pya(nn), py,nrank,nrank,1)
              call multmq(smpt(1,ntr,isw),spya(nn),spy,nrank,nrank,1)
            endif
          else if(n.eq.3) then
            call multm (trc3(1,ntr,isw), pxa(nn), px,nrank,nrank,1)
            call multmq(trc3(1,ntr,isw),spxa(nn),spx,nrank,nrank,1)
            call multm (trc3(1,ntr,isw), pya(nn), py,nrank,nrank,1)
            call multmq(trc3(1,ntr,isw),spya(nn),spy,nrank,nrank,1)
          else if(n.eq.4) then
            call multm (trc4(1,ntr,isw), pxa(nn), px,nrank,nrank,1)
            call multmq(trc4(1,ntr,isw),spxa(nn),spx,nrank,nrank,1)
            call multm (trc4(1,ntr,isw), pya(nn), py,nrank,nrank,1)
            call multmq(trc4(1,ntr,isw),spya(nn),spy,nrank,nrank,1)
          else if(n.eq.5) then
            call multm (trc5(1,ntr,isw), pxa(nn), px,nrank,nrank,1)
            call multmq(trc5(1,ntr,isw),spxa(nn),spx,nrank,nrank,1)
            call multm (trc5(1,ntr,isw), pya(nn), py,nrank,nrank,1)
            call multmq(trc5(1,ntr,isw),spya(nn),spy,nrank,nrank,1)
          else
            call multm (trc6(1,ntr,isw), pxa(nn), px,nrank,nrank,1)
            call multmq(trc6(1,ntr,isw),spxa(nn),spx,nrank,nrank,1)
            call multm (trc6(1,ntr,isw), pya(nn), py,nrank,nrank,1)
            call multmq(trc6(1,ntr,isw),spya(nn),spy,nrank,nrank,1)
          endif
          if(kfap.eq.0.or.k.le.kmodp-ndimip) then
            do 2200j=1,nrank
              ppx=epsp*csp*px(j)-snp*py(j)
              ppy=epsp*snp*px(j)+csp*py(j)
              sppx=abs(epsp*csp*spx(j)-snp*spy(j))
              sppy=abs(epsp*snp*spx(j)+csp*spy(j))
              if(n.eq.0) then
                ax(iw,io)=ppx
                ay(iw,io)=ppy
                sax(iw,io)=sppx
                say(iw,io)=sppy
              else if(n.eq.1) then
                ux(j,iw,io)=ppx
                uy(j,iw,io)=ppy
                sux(j,iw,io)=sppx
                suy(j,iw,io)=sppy
              else if(n.eq.2) then
                bx(j,iw,io)=ppx
                by(j,iw,io)=ppy
                sbx(j,iw,io)=sppx
                sby(j,iw,io)=sppy
              else if(n.eq.3) then
                c3x(j,iw,io)=ppx
                c3y(j,iw,io)=ppy
                sc3x(j,iw,io)=sppx
                sc3y(j,iw,io)=sppy
              else if(n.eq.4) then
                c4x(j,iw,io)=ppx
                c4y(j,iw,io)=ppy
                sc4x(j,iw,io)=sppx
                sc4y(j,iw,io)=sppy
              else if(n.eq.5) then
                c5x(j,iw,io)=ppx
                c5y(j,iw,io)=ppy
                sc5x(j,iw,io)=sppx
                sc5y(j,iw,io)=sppy
              else
                c6x(j,iw,io)=ppx
                c6y(j,iw,io)=ppy
                sc6x(j,iw,io)=sppx
                sc6y(j,iw,io)=sppy
              endif
2200        continue
          else
            kk=k-kmodp+ndimi
            epsp=eps(kk)
            if(n.eq.0) then
              call CopyVek(x(1,ii),xp,3)
              if(ndimi.eq.1) then
                delta=a0(ii)*.5
              else
                delta=py(1)*.5
              endif
              call SetRealArrayTo(xp(4),ndimi,0.)
              do 2250j=1,2
                if(j.eq.1) then
                  xp(kk+3)=px(1)-delta
                else
                  xp(kk+3)=px(1)+delta
                endif
                call multm(trm(1,ntr,isw),xp,xps(1,j),ndim,ndim,1)
                call AddVek(xps(1,j),trv(1,ntr,isw),xps(1,j),ndim)
2250          continue
              do 2260j=4,ndim
                delta=abs(xps(j,2)-xps(j,1))
                if(delta.gt..00001) then
                  jj=j+kmodp-ndimi-3
                  go to 2270
                endif
2260          continue
2270          pom=(xps(j,2)+xps(j,1))*.5
              j=pom
              if(pom.lt.0.) j=j-1
              ax(jj,io)=pom-float(j)
              sax(jj,io)=sax(k,ii)
              if(ndimi.gt.1) then
                ay(jj,io)=delta
                say(jj,io)=say(kk,ii)
              else
                ay(jj,io)=0.
                say(jj,io)=0.
              endif
            else if(n.eq.1) then
              call multm (smp(1,ntr,isw), ux(1,k,ii), px,3,3,1)
              call multmq(smp(1,ntr,isw),sux(1,k,ii),spx,3,3,1)
              do 2300j=1,3
                 ux(j,k,io)=epsp* px(j)
                sux(j,k,io)=abs(spx(j))
2300          continue
              call CopyVek(x(1,ii),xp,3)
              xp(4)=uy(1,k,ii)
              call multm(trm(1,ntr,isw),xp,xpp,ndim,ndim,1)
              call AddVek(xpp,trv(1,ntr,isw),xp,ndim)
              pom=xp(4)
              j=pom
              if(pom.lt.0.) j=j-1
              uy(1,k,io)=pom-float(j)
              uy(2,k,io)=uy(2,k,ii)
              suy(1,k,io)=suy(1,k,ii)
              suy(2,k,io)=suy(2,k,ii)
            else if(n.eq.2) then
              call multm (smpt(1,ntr,isw), bx(1,k,ii), px,6,6,1)
              call multmq(smpt(1,ntr,isw),sbx(1,k,ii),spx,6,6,1)
              do 2400j=1,3
                bx(j,k,io)=epsp*px(j)
                sbx(j,k,io)=abs(spx(j))
2400          continue
              pom=epsp*by(1,k,ii)+xp(4)
              j=pom
              if(pom.lt.0.) j=j-1
              by(1,k,io)=pom-float(j)
              by(2,k,io)=by(2,k,ii)
              sby(1,k,io)=sby(1,k,ii)
              sby(2,k,io)=sby(2,k,ii)
            endif
          endif
          nn=nn+nrank
2800    continue
3000  continue
      if(ndim.le.3) then
        if(ChargeDensities) then
          kapa1(io)=kapa1(ii)
          kapa2(io)=kapa2(ii)
          popc(io)=popc(ii)
          popv(io)=popv(ii)
          call CopyVek(popas(1,ii),popas(1,io),lasmax(n)**2)
        endif
        go to 9999
      endif
      i=kator(ii)
      if(i.ne.0) then
        if(kmol(io).ne.0) then
          kator(io)=i
          go to 9999
        else
          if(ii.ne.io) then
            nor=nor+1
            j=nor
            kator(io)=j
          else
            j=i
            kator(io)=i
          endif
        endif
        ora(j)=atom(io)
        ordel(j)=ordel(i)
        xp(4)=orx40(i)
        call multm(trm(1,ntr,isw),xp,xpp,ndim,ndim,1)
        call AddVek(xpp,trv(1,ntr,isw),xp,ndim)
        pom=xp(4)
        l=pom
        if(pom.lt.0.) l=l-1
        orx40(j)=pom-float(l)
        call CopyVekI(orsel(1,i),orsel(1,j),mxw21)
        orsels(j)=orsels(i)
        call mator(orx40(j),ordel(j),orsel(1,j),ord(j),orm(1,j),
     1             ormi(1,j),io)
        itfp=itf(io)
        if(itfp.eq.1) itfp=2
        if(kfs(io).ne.0) then
          x40=ax(kmods(io),io)
          delta=a0(io)
        else
          x40=uy(1,kmodx(io),io)
          delta=uy(2,kmodx(io),io)
        endif
        ia=kator(io)
        do 4100i=1,itfp
          kmod=kmoda(io,i+1)
          kmodo=kmodao(io,i+1)
          if(i.eq.1) then
            call EM40RecalcOrtho(x40,delta,
     1        x(1,io),ux(1,1,io),uy(1,1,io),TRank(i),
     2        kmod,kmodo,kfa(io,i+1),orsel(1,ia),ich)
          else if(i.eq.2) then
            call EM40RecalcOrtho(x40,delta,
     1        beta(1,io),bx(1,1,io),by(1,1,io),TRank(i),
     2        kmod,kmodo,kfa(io,i+1),orsel(1,ia),ich)
          else if(i.eq.3) then
            call EM40RecalcOrtho(x40,delta,
     1        c3(1,io),c3x(1,1,io),c3y(1,1,io),TRank(i),
     2        kmod,kmodo,kfa(io,i+1),orsel(1,ia),ich)
          else if(i.eq.4) then
            call EM40RecalcOrtho(x40,delta,
     1        c4(1,io),c4x(1,1,io),c4y(1,1,io),TRank(i),
     2        kmod,kmodo,kfa(io,i+1),orsel(1,ia),ich)
          else if(i.eq.5) then
            call EM40RecalcOrtho(x40,delta,
     1        c5(1,io),c5x(1,1,io),c5y(1,1,io),TRank(i),
     2        kmod,kmodo,kfa(io,i+1),orsel(1,ia),ich)
          else if(i.eq.6) then
            call EM40RecalcOrtho(x40,delta,
     1        c6(1,io),c6x(1,1,io),c6y(1,1,io),TRank(i),
     2        kmod,kmodo,kfa(io,i+1),orsel(1,ia),ich)
          endif
4100    continue
      endif
9999  return
      end
      subroutine EM40TrMol(ii,io,isw,ntr)
      include 'params.cmn'
      include 'basic.cmn'
      include 'atoms.cmn'
      include 'molec.cmn'
      include 'editm40.cmn'
      dimension px(9),py(9),xp(6),xpp(6),snm(mxw),csm(mxw),eps(3),
     1          phi(3),xps(6,2),pxa(9*mxw),pya(9*mxw),spxa(9*mxw),
     2          spya(9*mxw)
      integer PrvKi
      im=(io-1)/mxp+1
      iak=mxa
      do 1000i=1,im
        iap=iak+1
        iak=iak+iam(i)
1000  continue
      if(io.ne.ii) then
        aimol(io)=aimol(ii)
        saimol(io)=saimol(ii)
        LocMolSystType(io)=LocMolSystType(ii)
        do 1010i=1,LocMolSystType(io)
          LocMolSystAx(i,io)=LocMolSystAx(i,io)
          do 1005j=1,2
            LocMolSystSt(j,i,io)=LocMolSystSt(j,i,ii)
1005      continue
1010    continue
        call CopyVek(TrMol(1,ii),TrMol(1,io),9)
        call CopyVek(TriMol(1,ii),TriMol(1,io),9)
        atr(io)=' '
        kfsm(io)=kfsm(ii)
        kfxm(io)=kfxm(ii)
        kfbm(io)=kfbm(ii)
        kmodsm(io)=kmodsm(ii)
        kmodxm(io)=kmodxm(ii)
        kmodbm(io)=kmodbm(ii)
        aimol(io)=aimol(ii)
        phfm(io)=phfm(ii)
        sphfm(io)=sphfm(ii)
        if(ktls(im).ne.0) then
          call CopyVek(tt(1,ii),tt(1,io),6)
          call CopyVek(tl(1,ii),tl(1,io),6)
          call CopyVek(ts(1,ii),ts(1,io),9)
        endif
      endif
      call ShiftKiMol(io,ktls(im),kmodsm(io),kmodxm(io),kmodbm(io),
     1                .false.)
      PrvKi=PrvniKiMolekuly(io)
      call SetIntArrayTo(ki(PrvKi),DelkaKiMolekuly(io),0)
      RotSign(io)=nint(znsmp(ntr))*RotSign(ii)
      call AddVek(xm(1,im),trans(1,ii),xp,3)
      call SetRealArrayTo(xp(4),ndimi,0.)
      call multm(trm(1,ntr,isw),xp,xpp,ndim,ndim,1)
      do 1220j=1,ndim
        xpp(j)=xpp(j)+trv(j,ntr,isw)
        if(j.ge.4) phi(j-3)=-xpp(j)*pi2
1220  continue
      if(ndimi.gt.0) then
        kmodmx=max(kmodsm(ii),kmodxm(ii),kmodbm(ii))
        do 1230i=iap,iak
          kmodmx=max(kmodmx,kmods(i),kmodx(i),kmodb(i))
1230    continue
        do 1250k=1,kmodmx
          eps(k)=isign(1,KwSymP(k,ntr))
          l=iabs(KwSymP(k,ntr))
          pom=0.
          do 1240m=1,ndimi
            pom=pom+float(kw(m,l,KPhase))*phi(m)
1240      continue
          snp=sin(pom)
          csp=cos(pom)
          if(abs(snp).lt..001) snp=0.
          if(abs(csp).lt..001) csp=0.
          if(abs(abs(snp)-1.).lt..001) snp=sign(1.,snp)
          if(abs(abs(csp)-1.).lt..001) csp=sign(1.,csp)
          snm(k)=snp
          csm(k)=csp
1250    continue
      endif
      do 2060i=1,3
        trans(i,io)=xpp(i)-xm(i,im)
2060  continue
      call multm(smp(1,ntr,isw),RotMol(1,ii),px,3,3,3)
      call CopyVek(px,RotMol(1,io),9)
      call multm(TrMol(1,io),RotMol(1,io),px,3,3,3)
      call multm(px,TriMol(1,io),py,3,3,3)
      call EM40GetAngles(py,irot,euler(1,io))
      if(ndimi.le.0) go to 9999
      do 3000n=0,2
        kmodp=kmodam(ii,n+1)
        if(kmodp.le.0) go to 3000
        kfap=kfam(ii,n+1)
        if(n.eq.0) then
          mk=1
        else if(n.eq.1) then
          mk=2
        else if(n.eq.2) then
          mk=3
        endif
        nrank=TRank(n)
        if(kfap.ne.0) then
          if(n.eq.0) then
            ndimip=ndimi
          else
            ndimip=1
          endif
        endif
        do 2990m=1,mk
          if(n.eq.2.and.mk.eq.3) nrank=9
          nn=kmodp*nrank
          if(n.eq.0) then
            a0m(io)=a0m(ii)
            call CopyVek( axm(1,ii), pxa,nn)
            call CopyVek( aym(1,ii), pya,nn)
            call CopyVek(saxm(1,ii),spxa,nn)
            call CopyVek(saym(1,ii),spya,nn)
          else if(n.eq.1) then
            if(m.eq.1) then
              call CopyVek( utx(1,1,ii), pxa,nn)
              call CopyVek( uty(1,1,ii), pya,nn)
              call CopyVek(sutx(1,1,ii),spxa,nn)
              call CopyVek(suty(1,1,ii),spya,nn)
            else
              call CopyVek( urx(1,1,ii), pxa,nn)
              call CopyVek( ury(1,1,ii), pya,nn)
              call CopyVek(surx(1,1,ii),spxa,nn)
              call CopyVek(sury(1,1,ii),spya,nn)
            endif
          else if(n.eq.2) then
            if(m.eq.1) then
              call CopyVek( ttx(1,1,ii), pxa,nn)
              call CopyVek( tty(1,1,ii), pya,nn)
              call CopyVek(sttx(1,1,ii),spxa,nn)
              call CopyVek(stty(1,1,ii),spya,nn)
            else if(m.eq.2) then
              call CopyVek( tlx(1,1,ii), pxa,nn)
              call CopyVek( tly(1,1,ii), pya,nn)
              call CopyVek(stlx(1,1,ii),spxa,nn)
              call CopyVek(stly(1,1,ii),spya,nn)
            else
              call CopyVek( tsx(1,1,ii), pxa,nn)
              call CopyVek( tsy(1,1,ii), pya,nn)
              call CopyVek(stsx(1,1,ii),spxa,nn)
              call CopyVek(stsy(1,1,ii),spya,nn)
            endif
          endif
          nn=0
          do 2800k=1,kmodp
            iw=iabs(KwSymP(k,ntr))
            snp=snm(k)
            csp=csm(k)
            epsp=eps(k)
            if(kfap.eq.0.or.k.le.kmodp-ndimip) then
              do 2200j=1,nrank
                jj=nn+j
                ppx=epsp*csp*pxa(jj)-snp*pya(jj)
                ppy=epsp*snp*pxa(jj)+csp*pya(jj)
                sppx=abs(epsp*csp*spxa(jj)-snp*spya(jj))
                sppy=abs(epsp*snp*spxa(jj)+csp*spya(jj))
                if(n.eq.0) then
                  axm(iw,io)=ppx
                  aym(iw,io)=ppy
                  saxm(iw,io)=sppx
                  saym(iw,io)=sppy
                else if(n.eq.1) then
                  if(m.eq.1) then
                     utx(j,iw,io)= ppx
                     uty(j,iw,io)= ppy
                    sutx(j,iw,io)=sppx
                    suty(j,iw,io)=sppy
                  else
                     urx(j,iw,io)= ppx
                     ury(j,iw,io)= ppy
                    surx(j,iw,io)=sppx
                    sury(j,iw,io)=sppy
                  endif
                else if(n.eq.2) then
                  if(m.eq.1) then
                     ttx(j,iw,io)= ppx
                     tty(j,iw,io)= ppy
                    sttx(j,iw,io)=sppx
                    stty(j,iw,io)=sppy
                  else if(m.eq.2) then
                     tlx(j,iw,io)= ppx
                     tly(j,iw,io)= ppy
                    stlx(j,iw,io)=sppx
                    stly(j,iw,io)=sppy
                  else
                     tsx(j,iw,io)= ppx
                     tsy(j,iw,io)= ppy
                    stsx(j,iw,io)=sppx
                    stsy(j,iw,io)=sppy
                  endif
                endif
2200          continue
            else
              kk=k-kmodp+ndimi
              epsp=eps(kk)
              if(n.eq.0) then
                if(ndimi.eq.1) then
                  delta=a0m(ii)*.5
                else
                  delta=pya(nn+1)*.5
                endif
                call SetRealArrayTo(xp(4),ndimi,0.)
                do 2250j=1,2
                  if(j.eq.1) then
                    xp(kk+3)=pxa(nn+1)-delta
                  else
                    xp(kk+3)=pxa(nn+1)+delta
                  endif
                  call multm(trm(1,ntr,isw),xp,xps(1,j),ndim,ndim,1)
                  call AddVek(xps(1,j),trv(1,ntr,isw),xps(1,j),ndim)
2250            continue
                do 2260j=4,ndim
                  delta=abs(xps(j,2)-xps(j,1))
                  if(delta.gt..00001) then
                    jj=j+kmodp-ndimi-3
                    go to 2270
                  endif
2260            continue
2270            pom=(xps(j,2)+xps(j,1))*.5
                j=pom
                if(pom.lt.0.) j=j-1
                axm(jj,io)=pom-float(j)
                saxm(jj,io)=spxa(nn+1)
                if(ndimi.gt.1) then
                  aym(jj,io)=delta
                  saym(jj,io)=spxa(nn+1)
                else
                  aym(jj,io)=0.
                  saym(jj,io)=0.
                endif
              else if(n.eq.1) then
                if(m.eq.1) then
                  xp(4)=pya(nn+1)
                  call multm(trm(1,ntr,isw),xp,xpp,ndim,ndim,1)
                  call AddVek(xpp,trv(1,ntr,isw),xpp,ndim)
                  pom=xpp(4)
                  j=pom
                  if(pom.lt.0.) j=j-1
                  uty(1,k,io)=pom-float(j)
                  uty(2,k,io)=pya(nn+2)
                  uty(3,k,io)=0.
                  call CopyVek(spya(nn+1),suty(1,k,io),3)
                  do 2300j=1,3
                    jj=nn+j
                    utx(j,k,io)=epsp*pxa(jj)
2300              continue
                  call CopyVek(spxa(nn+1),sutx(1,k,io),3)
                else
                  call SetRealArrayTo( urx(1,k,io),3,0.)
                  call SetRealArrayTo( ury(1,k,io),3,0.)
                  call SetRealArrayTo(surx(1,k,io),3,0.)
                  call SetRealArrayTo(sury(1,k,io),3,0.)
                endif
              endif
            endif
            nn=nn+nrank
2800      continue
2990    continue
3000  continue
      do 4000i=iap,iak
        do 3900n=0,2
          kmodp=kmoda(i,n+1)
          if(kmodp.le.0) go to 3900
          kfap=kfa(i,n+1)
          nrank=TRank(n)
          if(kfap.ne.0) then
            if(n.eq.0) then
              ndimip=ndimi
            else
              ndimip=1
            endif
          endif
          nn=kmodp*nrank
          if(n.eq.0) then
            a0(io)=a0(ii)
            call CopyVek( ax(1,i), pxa,nn)
            call CopyVek( ay(1,i), pya,nn)
            call CopyVek(sax(1,i),spxa,nn)
            call CopyVek(say(1,i),spya,nn)
          else if(n.eq.1) then
            call CopyVek( ux(1,1,i), pxa,nn)
            call CopyVek( uy(1,1,i), pya,nn)
            call CopyVek(sux(1,1,i),spxa,nn)
            call CopyVek(suy(1,1,i),spya,nn)
          else if(n.eq.2) then
            call CopyVek( bx(1,1,ii), pxa,nn)
            call CopyVek( by(1,1,ii), pya,nn)
            call CopyVek(sbx(1,1,ii),spxa,nn)
            call CopyVek(sby(1,1,ii),spya,nn)
          endif
          nn=0
          do 3800k=1,kmodp
            iw=iabs(KwSymP(k,ntr))
            snp=snm(k)
            csp=csm(k)
            epsp=eps(k)
            if(kfap.eq.0.or.k.le.kmodp-ndimip) then
              do 3200j=1,nrank
                jj=nn+j
                ppx=epsp*csp*pxa(jj)-snp*pya(jj)
                ppy=epsp*snp*pxa(jj)+csp*pya(jj)
                sppx=abs(epsp*csp*spxa(jj)-snp*spya(jj))
                sppy=abs(epsp*snp*spxa(jj)+csp*spya(jj))
                if(n.eq.0) then
                  ax(iw,i)=ppx
                  ay(iw,i)=ppy
                  sax(iw,i)=sppx
                  say(iw,i)=sppy
                else if(n.eq.1) then
                  ux(j,iw,i)= ppx
                  uy(j,iw,i)= ppy
                  sux(j,iw,i)=sppx
                  suy(j,iw,i)=sppy
                else if(n.eq.2) then
                  bx(j,iw,i)= ppx
                  by(j,iw,i)= ppy
                  bx(j,iw,i)=sppx
                  by(j,iw,i)=sppy
                endif
3200          continue
            else
              kk=k-kmodp+ndimi
              epsp=eps(kk)
              if(n.eq.0) then
                if(ndimi.eq.1) then
                  delta=a0(i)*.5
                else
                  delta=pya(nn+1)*.5
                endif
                call SetRealArrayTo(xp(4),ndimi,0.)
                do 3250j=1,2
                  if(j.eq.1) then
                    xp(kk+3)=pxa(nn+1)-delta
                  else
                    xp(kk+3)=pxa(nn+1)+delta
                  endif
                  call multm(trm(1,ntr,isw),xp,xps(1,j),ndim,ndim,1)
                  call AddVek(xps(1,j),trv(1,ntr,isw),xps(1,j),ndim)
3250            continue
                do 3260j=4,ndim
                  delta=abs(xps(j,2)-xps(j,1))
                  if(delta.gt..00001) then
                    jj=j+kmodp-ndimi-3
                    go to 3270
                  endif
3260            continue
3270            pom=(xps(j,2)+xps(j,1))*.5
                j=pom
                if(pom.lt.0.) j=j-1
                ax(jj,i)=pom-float(j)
                sax(jj,i)=spxa(nn+1)
                if(ndimi.gt.1) then
                  ay(jj,i)=delta
                  say(jj,i)=spxa(nn+1)
                else
                  ay(jj,i)=0.
                  say(jj,i)=0.
                endif
              else if(n.eq.1) then
                xp(4)=pya(nn+1)
                call multm(trm(1,ntr,isw),xp,xpp,ndim,ndim,1)
                call AddVek(xpp,trv(1,ntr,isw),xpp,ndim)
                pom=xpp(4)
                j=pom
                if(pom.lt.0.) j=j-1
                uy(1,k,i)=pom-float(j)
                uy(2,k,i)=pya(nn+2)
                uy(3,k,i)=0.
                call CopyVek(spya(nn+1),suy(1,k,i),3)
                do 3300j=1,3
                  jj=nn+j
                  utx(j,k,io)=epsp*pxa(jj)
3300            continue
                call CopyVek(spya(nn+1),sux(1,k,i),3)
              endif
            endif
3800      continue
          nn=nn+nrank
3900    continue
4000  continue
      i=kmor(ii)
      if(i.ne.0) then
        if(ii.ne.io) then
          nor=nor+1
          j=nor
        else
          j=i
        endif
        write(Cislo,'(''#'',i5)') mod(io-1,mxp)+1
        call Zhusti(Cislo)
        ora(j)=molname(im)(:idel(molname(im)))//Cislo(:idel(Cislo))
        ordel(j)=ordel(i)
        orsels(j)=orsels(i)
        call CopyVekI(orsel(1,i),orsel(1,j),mxw21)
        xp(4)=orx40(i)
        call multm(trm(1,ntr,isw),xp,xpp,ndim,ndim,1)
        call AddVek(xpp,trv(1,ntr,isw),xp,ndim)
        pom=xp(4)
        l=pom
        if(pom.lt.0.) l=l-1
        orx40(j)=pom-float(l)
      endif
9999  return
      end
      subroutine SetMolName
      include 'params.cmn'
      include 'basic.cmn'
      include 'molec.cmn'
      include 'editm40.cmn'
      MaxMolPos=0
      do 1100i=1,nmolc
        do 1050j=1,mam(i)
          MaxMolPos=MaxMolPos+1
          if(mam(i).gt.1) then
            write(MolMenu(MaxMolPos),'(a8,''#'',i2)') molname(i),j
            call zhusti(MolMenu(MaxMolPos))
          else
            MolMenu(MaxMolPos)=molname(i)
          endif
1050    continue
1100  continue
      return
      end
      integer function SelPart(klic)
      include 'params.cmn'
      include 'basic.cmn'
      include 'atoms.cmn'
      include 'molec.cmn'
      include 'editm40.cmn'
      character*20 AtMol(0:2)
      integer FeMenu
      data AtMol/'Atomic parameters','Molecular parameters',' '/
      if(nmolc.gt.0) then
        k=1
        if(klic.eq.1) then
          k=k+1
          AtMol(k)='Whole structure'
        endif
        if(nac+nacb.gt.0) then
          i=0
        else
          i=1
        endif
        SelPart=FeMenu(-1.,-1.,AtMol(i),i,k,0,0)
        if(SelPart.lt.0.or.SelPart.gt.k) SelPart=-1
      else
        SelPart=0
      endif
      return
      end
      subroutine ReadTr(klic,ich)
      include 'params.cmn'
      include 'basic.cmn'
      include 'atoms.cmn'
      include 'editm40.cmn'
      include 'fepc.cmn'
      dimension trp(36)
      character*80 mens(mxsym),Veta,menp(0:13)
      character*21 Hlavicka
      character*2 nty
      integer FeMenu,FeLengthTx,EdwStateQuest
      logical change,KeepOldW,KeepOldWIn
      ntrans=1-klic
      call OpenFile(m50,fln(:ifln)//'.m50','formatted','old')
      if(ErrJana.ne.0) go to 9999
      read(m50,FormA80)
1000  read(m50,FormA80) mens(1)
      call mala(mens(1))
      if(ndim.gt.3) then
        if(index(mens(1),'x1').le.0.or.index(mens(1),'x2').le.0.or.
     1     index(mens(1),'x3').le.0.or.index(mens(1),'x4').le.0)
     2     go to 1000
      else
        if(index(mens(1),'x').le.0.or.index(mens(1),'y').le.0.or.
     1     index(mens(1),'z').le.0) go to 1000
      endif
      mens(1)=mens(1)(9:)
      j=FeLengthTx(80.)
      do 1010i=2,ns
        read(m50,FormA80) mens(i)
        mens(i)=mens(i)(9:)
        j=max(j,idel(mens(i)))
1010  continue
      menp( 0)='---Back---'
      menp(13)='---Next---'
      do 1011i=1,j/2-5
        menp( 0)=' '//menp( 0)
        menp(13)=' '//menp(13)
1011  continue
      call CloseIfOpened(m50)
      if(klic.eq.1) then
        i=ndim+5
      else
        i=ndim+4
      endif
      id=NextQuestId()
      xqd=160.
      call FeQuestCreate(id,-1.,-1.,xqd,0,i,'Choice',1,LightGray,0,0)
      change=klic.ne.1
      call FeQuestButtonMake(id,  5.,1,40.,ButYd,'%Symmetry')
      nButtSymmetryP=ButtonLastMade
      call FeQuestButtonMake(id, 60.,1,40.,ButYd,'%Explicit')
      call FeQuestButtonMake(id,115.,1,40.,ButYd,'%-1*Symmetry')
      nButtSymmetryN=ButtonLastMade
      if(change) then
        k=ButtonOff
      else
        k=ButtonDisabled
      endif
      do 1015j=nButtSymmetryP,nButtSymmetryN
        call FeQuestButtonOpen(j,k)
1015  continue
      if(.not.Change) then
        call FeQuestButtonMake(id,55.,i,50.,ButYd,'%Next matrix')
        nButtNext=ButtonLastMade
        call FeQuestButtonOpen(nButtNext,ButtonOff)
      else
        nButtNext=0
      endif
      if(klic.eq.0) then
        Hlavicka='Transformation matrix'
        call FeQuestLabelMake(id,xqd*.5,2,Hlavicka,'C')
      else
        Hlavicka='Expansion matrix # 1'
      endif
      do 1020i=1,ndim
        write(Veta,'(''%'',i1,a2,'' row'')') i,nty(i)
        call FeQuestEdwMake(id,15.,i+2,65.,i+2,Veta,'L',80.,EdwYd,0)
        if(i.eq.1) nEdwMatrixFirst=EdwLastMade
1020  continue
      call FeQuestEdwMake(id,xqd*.5,ndim+3,65.,ndim+4,
     1                    'T%ranslation vector','C',80.,EdwYd,0)
      nEdwShift=EdwLastMade
1100  icont=0
1200  call FeQuestEvent(id,icont,ich)
      icont=1
      if(CheckType.eq.EventButton.and.
     1   (CheckNumberAbs.eq.ButtonOk.or.CheckNumber.eq.nButtNext)) then
        if(EdwStateQuest(nEdwMatrixFirst).eq.EdwOpened) then
          nEdw=nEdwMatrixFirst
          do 1220j=1,ndim
            call FeQuestRealAFromEdw(nEdw,trp)
            do 1210i=1,ndim
              trm(j+(i-1)*ndim,ntrans,1)=trp(i)
1210        continue
            nEdw=nEdw+1
1220      continue
          call FeQuestRealAFromEdw(nEdwShift,trv(1,ntrans,1))
          call matinv(trm(1,ntrans,1),trp,pom,ndim)
          if(abs(pom).lt..0001) then
            call FeChybne(-1.,-1.,'The transformation matrix is '//
     1                    'singular','try again',0,SeriousError)
            EventType=EventEdw
            EventNumber=nEdwMatrixFirst
            call FeButtonOff(ButtonOk)
            go to 1200
          endif
          if(abs(abs(pom)-1.).gt..0001.and.lite.eq.0) then
            call FeMsgOut(-1.,-1.,'U were changed for Beta as the '//
     1                    'transformation is not orthogonal')
            lite=1
          endif
        endif
        if(CheckNumber.eq.nButtNext) then
          ButtonFlash=.false.
          do 1270i=nButtSymmetryP,nButtNext
            call FeQuestButtonOff(i)
1270      continue
          ButtonFlash=.true.
          ntrans=ntrans+1
          call FeQuestLabelRemove(id,80.,2,Hlavicka,'C')
          write(Hlavicka(19:20),'(i2)') ntrans
          call FeQuestLabelMake(id,80.,2,Hlavicka,'C')
          go to 1500
        else
          go to 1515
        endif
      else if(CheckType.eq.EventButton.and.
     1        (CheckNumber.ge.nButtSymmetryP.and.
     2         CheckNumber.le.nButtSymmetryN)) then
        if(EventNumber.eq.nButtSymmetryP.or.
     1     EventNumber.eq.nButtSymmetryN) then
          n=1
1310      i1=1+12*(n-1)
          i2=min(i1+11,ns)
          j=0
          do 1320i=i1,i2
            j=j+1
            menp(j)=mens(i)
1320      continue
          if(i1.ne.1) then
            n1=0
          else
            n1=1
          endif
          if(i2.ne.ns) then
            n2=13
          else
            n2=i2-i1+1
          endif
          DelejTestIn=.false.
          i=FeMenu(-1.,-1.,menp(n1),n1,n2,n1,1)
          DelejTestIn=.true.
          if(i.lt.n1) then
            do 1325i=nButtSymmetryP,nButtSymmetryN
              call FeQuestButtonOff(i)
1325        continue
            go to 1100
          endif
          if(i.ne.0.and.i.ne.13) then
            i=i+i1-1
            call CopyVek(s6(1,i,1,KPhase),trv(1,ntrans,1),ndim)
            call CopyMat(rm6(1,i,1,KPhase),trm(1,ntrans,1),ndim)
            if(CheckNumber.eq.nButtSymmetryN) then
              do 1330j=1,ndimq
                trm(j,ntrans,1)=-trm(j,ntrans,1)
1330          continue
            endif
          else
            if(i1.eq.1) then
              n=n+1
            else
              n=n-1
            endif
            go to 1310
          endif
        else
          call UnitMat(trm(1,ntrans,1),ndim)
          call SetRealArrayTo(trv(1,ntrans,1),ndim,0.)
        endif
        nedw=nEdwMatrixFirst
        do 1360i=1,ndim
          do 1355j=1,ndim
            trp(j)=trm(i+(j-1)*ndim,ntrans,1)
1355      continue
          call FeQuestRealAEdwOpen(nEdw,trp,ndim,.false.,.true.)
          nEdw=nEdw+1
1360    continue
        call FeQuestRealAEdwOpen(i,trv(1,ntrans,1),ndim,.false.,.true.)
        call FeQuestButtonOff(CheckNumber)
        go to 1100
      else if(CheckType.ne.0) then
        call NebylOsetren
        go to 1200
      endif
      call FeQuestRemove(id)
      go to 1520
1500  if(klic.eq.1.and.ich.eq.0) then
        if(EdwStateQuest(nEdwMatrixFirst).eq.EdwOpened) then
          do 1510j=nEdwMatrixFirst,nEdwShift
            call FeQuestEdwClose(j)
1510      continue
        endif
        go to 1100
      endif
1515  icont=1
      QuestCheck(id)=0
      go to 1200
1520  if(ich.ne.0.or.ntrans.le.0) go to 9999
      KeepOldW=.true.
      go to 1600
      entry EM40SetTr(KeepOldWIn)
      KeepOldW=KeepOldWIn
1600  do 5000it=1,ntrans
        do 2000i=2,ncomp
          if(KeepOldW) then
            call multm(zv(1,i,KPhase),trm(1,it,1),trp,ndim,ndim,ndim)
            call multm(trp,zvi(1,i,KPhase),trm(1,it,i),ndim,ndim,ndim)
            call multm(zv(1,i,KPhase),trv(1,it,1),trv(1,it,i),ndim,ndim,
     1                 1)
          else
            call CopyMat(trm(1,it,1),trm(1,it,i),ndimq)
            call CopyVek(trv(1,it,1),trv(1,it,i),ndim )
          endif
2000    continue
        do 3000i=1,ncomp
          call MatBlock3(trm(1,it,i),smp(1,it,i),ndim)
          if(i.eq.1) then
            call matinv(smp(1,it,1),trp,pom,3)
            if(pom.lt.0.) then
              znsmp(it)=-1.
            else
              znsmp(it)= 1.
            endif
          endif
          call CopyVek(smp(1,it,i),trp,9)
          call srotb(trp,trp,smpt(1,it,i))
          call srotss(trp,trp,smps(1,it,i))
          call srotc(trp,3,trc3(1,it,i))
          call srotc(trp,4,trc4(1,it,i))
          call srotc(trp,5,trc5(1,it,i))
          call srotc(trp,6,trc6(1,it,i))
3000    continue
5000  continue
9999  return
      end
      subroutine EM40GetAngles(rot,irot,euler)
      include 'params.cmn'
      include 'basic.cmn'
      dimension rot(9),euler(3),rotp(9)
      call matinv(rot,rotp,pom,3)
      if(pom.ge.0.) then
        zn=1.
      else
        zn=-1.
      endif
      if(irot.eq.0) then
        if(abs(zn*rot(9)).gt..99995) then
          euler(2)=90.-sign(90.,zn*rot(9))
          euler(3)=0.
          ps=zn*rot(2)
          pc=zn*rot(1)
        else
          euler(2)=acos(zn*rot(9))/torad
          euler(3)=atan2(zn*rot(3),zn*rot(6))/torad
          ps= zn*rot(7)
          pc=-zn*rot(8)
        endif
      else
        if(abs(zn*rot(3)).gt..99995) then
          euler(2)=-sign(90.,zn*rot(3))
          euler(3)=0.
          ps=-zn*rot(4)
          pc= zn*rot(5)
        else
          euler(2)=-asin(zn*rot(3))/torad
          euler(3)=atan2(zn*rot(6),zn*rot(9))/torad
          ps=zn*rot(2)
          pc=zn*rot(1)
        endif
      endif
      euler(1)=atan2(ps,pc)/torad
      return
      end
      subroutine ZmDel(ich)
      include 'params.cmn'
      include 'basic.cmn'
      include 'atoms.cmn'
      include 'molec.cmn'
      include 'editm40.cmn'
      call DefGroup(i1,i2,0)
      if(i1.le.0) then
        ich=1
        return
      else
        ich=0
      endif
      id=0
      do 1000i=i1,i2
        if(i.gt.nacAll.and.i.le.mxa) go to 1000
        if(.not.AtBrat(i)) go to 1000
        if(id.ne.3) call FeYesNoAll(-1.,-1.,'Do you want to delete '//
     1                              'atom '//atom(i)(1:idel(atom(i)))//
     2                              '?',2,id)
        if(id.eq.4) then
          go to 1100
        else if(id.eq.2) then
          go to 1000
        else
          isf(i)=0
          call delor(atom(i))
        endif
1000  continue
1100  j=i1-1
      if(nmolc.ne.0) then
        n=mxa+nacb
      else
        n=nacAll
      endif
      imx=nacAll
      do 2000i=i1,n
        if(i.gt.imx.and.i.le.mxa) go to 2000
        isw=iswa(i)
        if(i.eq.mxa+1) j=i-1
        if(isf(i).ne.0) then
          j=j+1
          if(i.ne.j) call AtSun(i,i,j)
        else
          if(i.le.mxa) then
            na(isw)=na(isw)-1
            nacAll=nacAll-1
            nac=nac-1
          else
            im=(kmol(i)-1)/mxp+1
            iam(im)=iam(im)-1
            iamn(im)=iamn(im)-1
          endif
        endif
2000  continue
      call delmol
      nacb=0
      do 4000i=1,nmolc
        nacb=nacb+iam(i)
4000  continue
      return
      end
      subroutine DelMol
      include 'params.cmn'
      include 'molec.cmn'
      character*11 jmeno
      i=1
1000  if(i.gt.nmolcAll) return
      if(iam(i).le.0) then
        isw=iswmol(i)
        do 1100j=1,mam(i)
          jmeno=molname(i)
          if(mam(i).gt.1) then
            write(jmeno(9:11),'(''#'',i2)') j
            call zhusti(jmeno)
          endif
          call delor(jmeno)
1100    continue
        call molsun(i+1,nmolcAll,i)
        nmolc=nmolc-1
        nmolcAll=nmolcAll-1
        nmol(isw)=nmol(isw)-1
      else
        i=i+1
      endif
      go to 1000
      end
      subroutine MolSun(iod,ido,jod)
      include 'params.cmn'
      include 'atoms.cmn'
      include 'molec.cmn'
      if(jod.le.iod) then
        i1=iod
        i2=ido
        id=1
      else
        i1=ido
        i2=iod
        id=-1
      endif
      do 4000i=i1,i2,id
        k=i+jod-iod
        molname(k)=molname(i)
        iswmol(k)=iswmol(i)
        kswmol(k)=kswmol(i)
        StRefPoint(k)=StRefPoint(i)
        iam(k)=iam(i)
        iamn(k)=iamn(i)
        mam(k)=mam(i)
        npoint(k)=npoint(i)
        kpoint(k)=kpoint(i)
        SmbPGMol(k)=SmbPGMol(i)
        do 1200j=1,npoint(i)
          call CopyVek(rpoint(1,j,i),rpoint(1,j,k),9)
          call CopyVek(tpoint(1,j,i),rpoint(1,j,k),36)
          ipoint(j,k)=ipoint(j,i)
1200    continue
        call CopyVek(xm(1,i),xm(1,k),3)
        jk=(k-1)*mxp
        ji=(i-1)*mxp
        do 3900j=1,mam(k)
          ji=ji+1
          jk=jk+1
          aimol(jk)=aimol(ji)
          kmor(jk)=kmor(ji)
          kfsm(jk)=kfsm(ji)
          kfxm(jk)=kfxm(ji)
          kfbm(jk)=kfbm(ji)
          kmodsm(jk)=kmodsm(ji)
          kmodxm(jk)=kmodxm(ji)
          kmodbm(jk)=kmodbm(ji)
          RotSign(jk)=RotSign(ji)
          atr(jk)=atr(ji)
          call CopyVek( trans(1,ji), trans(1,jk),3)
          call CopyVek(strans(1,ji),strans(1,jk),3)
          call CopyVek( euler(1,ji), euler(1,jk),3)
          call CopyVek(seuler(1,ji),seuler(1,jk),3)
          LocMolSystType(jk)=LocMolSystType(ji)
          do 2100k=1,LocMolSystType(ji)
            LocMolSystAx(k,jk)=LocMolSystAx(k,ji)
            do 2050l=1,2
              LocMolSystSt(l,k,jk)=LocMolSystSt(l,k,ji)
2050        continue
2100      continue
          if(ktls(i).ne.0) then
            call CopyVek( tt(1,ji), tt(1,jk),6)
            call CopyVek(stt(1,ji),stt(1,jk),6)
            call CopyVek( tl(1,ji), tl(1,jk),6)
            call CopyVek(stl(1,ji),stl(1,jk),6)
            call CopyVek( ts(1,ji), ts(1,jk),9)
            call CopyVek(sts(1,ji),sts(1,jk),9)
          endif
          if(kmodsm(jk).gt.0) then
            a0m(jk)=a0m(ji)
            k=kmodsm(jk)
            call CopyVek( axm(1,ji), axm(1,jk),k)
            call CopyVek(saxm(1,ji),saxm(1,jk),k)
            call CopyVek( aym(1,ji), aym(1,jk),k)
            call CopyVek(saym(1,ji),saym(1,jk),k)
          endif
          k=3*kmodxm(jk)
          if(k.gt.0) then
            call CopyVek( utx(1,1,ji), utx(1,1,jk),k)
            call CopyVek(sutx(1,1,ji),sutx(1,1,jk),k)
            call CopyVek( uty(1,1,ji), uty(1,1,jk),k)
            call CopyVek(suty(1,1,ji),suty(1,1,jk),k)
            call CopyVek( urx(1,1,ji), urx(1,1,jk),k)
            call CopyVek(surx(1,1,ji),surx(1,1,jk),k)
            call CopyVek( ury(1,1,ji), ury(1,1,jk),k)
            call CopyVek(sury(1,1,ji),sury(1,1,jk),k)
          endif
          k=6*kmodbm(jk)
          if(k.gt.0) then
            call CopyVek( ttx(1,1,ji), ttx(1,1,jk),k)
            call CopyVek(sttx(1,1,ji),sttx(1,1,jk),k)
            call CopyVek( tty(1,1,ji), tty(1,1,jk),k)
            call CopyVek(stty(1,1,ji),stty(1,1,jk),k)
            call CopyVek( tlx(1,1,ji), tlx(1,1,jk),k)
            call CopyVek(stlx(1,1,ji),stlx(1,1,jk),k)
            call CopyVek( tly(1,1,ji), tly(1,1,jk),k)
            call CopyVek(stly(1,1,ji),stly(1,1,jk),k)
            k=9*kmodbm(jk)
            call CopyVek( tsx(1,1,ji), tsx(1,1,jk),k)
            call CopyVek(stsx(1,1,ji),stsx(1,1,jk),k)
            call CopyVek( tsy(1,1,ji), tsy(1,1,jk),k)
            call CopyVek(stsy(1,1,ji),stsy(1,1,jk),k)
          endif
          if(kmodsm(jk).gt.0.or.kmodxm(jk).gt.0.or.kmodbm(jk).gt.0) then
            phfm(jk)=phfm(ji)
            sphfm(jk)=sphfm(ji)
          endif
          PrvniKiMolekuly(jk)=PrvniKiMolekuly(ji)
          DelkaKiMolekuly(jk)=DelkaKiMolekuly(ji)
3900    continue
4000  continue
      return
      end
      subroutine NewAt(ich)
      include 'params.cmn'
      include 'basic.cmn'
      include 'atoms.cmn'
      include 'molec.cmn'
      include 'editm40.cmn'
      include 'fepc.cmn'
      dimension kmodxn(mxa),xn(3,mxa),uxn(3,mxw,mxa),uyn(3,mxw,mxa),
     1          xp(3),uxp(3,mxw),uyp(3,mxw),iporp(11),Rho(mxa)
      character*256 EdwStringQuest
      character*80 Veta
      character*12 menp(0:mxm*mxp)
      character*8 at
      character*8 atomn(mxa)
      integer FeMenu,PrvKi
      logical l48,Prvne,Novy,FeYesNo,FeYesNoHeader,SelwLogicQuest,
     1        CrwLogicQuest
      data menp(0)/'Atomic part'/
      data biso,dmez,smez/2*3.,.5/
      ich=0
      iz=0
      l48=.false.
      call OpenFile(m40,fln(:ifln)//'.m40','formatted','old')
      if(ErrJana.ne.0) go to 1010
1000  read(m40,FormA80,end=1010) Veta
      if(index(Veta,'**********').le.0) go to 1000
      read(m40,'(i5)',end=1010) isw
      read(m40,FormA80,end=1010) Veta
      call mala(Veta)
      l48=index(Veta,'max').gt.0
      backspace m40
1010  if(l48) then
        i=4
      else
        i=2
        call CloseIfOpened(m40)
      endif
      if(ncomp.gt.1) i=i+1
      id=NextQuestId()
      call FeQuestCreate(id,-1.,-1.,150.,0,i,'Inserting/replacing of '//
     1                   'atoms',0,LightGray,0,0)
      il=0
      tpom=5.
      xpom=135.
      if(ncomp.gt.1) then
        i=1
      else
        i=0
      endif
      if(l48) then
        il=il+1
        call FeQuestCrwMake(id,tpom,il,xpom,il,
     1                      'Peaks from the last Fourier calculation',
     2                      'L',CrwgXd,CrwgYd,i,1)
        nCrwFromFourier=CrwLastMade
        call FeQuestCrwOpen(CrwLastMade,.true.)
        il=il+1
        call FeQuestCrwMake(id,tpom,il,xpom,il,'Coordinates from '//
     1                      '%keyboard','L',CrwgXd,CrwgYd,i,1)
        call FeQuestCrwOpen(CrwLastMade,.false.)
      endif
      xpom=115.
      dpom=30.
      il=il+1
      call FeQuestEdwMake(id,tpom,il,xpom,il,'Offer %skip distance','L',
     1                    dpom,EdwYd,0)
      nEdwSkipDistance=EdwLastMade
      call FeQuestRealEdwOpen(EdwLastMade,smez,.false.,.false.)
      il=il+1
      call FeQuestEdwMake(id,tpom,il,xpom,il,'%Maximum distance','L',
     1                    dpom,EdwYd,0)
      nEdwMaxDistance=EdwLastMade
      call FeQuestRealEdwOpen(EdwLastMade,dmez,.false.,.false.)
      if(ncomp.gt.1) then
        il=il+1
        call FeQuestEdwMake(id,tpom,il,xpom,il,'%Composite part','L',
     1                      dpom,EdwYd,0)
        nEdwIsw=EdwLastMade
        if(.not.l48) call FeQuestIntEdwOpen(EdwLastMade,1,.false.)
      else
        isw=1
      endif
1020  icont=0
1030  call FeQuestEvent(id,icont,ich)
      icont=1
      if(CheckType.eq.EventCrw) then
        if(CheckNumber.eq.nCrwFromFourier) then
          call FeQuestEdwClose(nEdwIsw)
        else
          call FeQuestIntEdwOpen(nEdwIsw,1,.false.)
        endif
        go to 1020
      else if(CheckType.ne.0) then
        call NebylOsetren
        go to 1030
      endif
      if(ich.eq.0) then
        if(l48) l48=CrwLogicQuest(nCrwFromFourier)
        call FeQuestRealFromEdw(nEdwSkipDistance,smez)
        call FeQuestRealFromEdw(nEdwMaxDistance,dmez)
        if(.not.l48.and.ncomp.gt.1) call FeQuestIntFromEdw(nEdwIsw,isw)
      endif
      call FeQuestRemove(id)
      if(ich.ne.0) go to 9000
      if(l48) then
        i=0
1040    i=i+1
        read(m40,FormA80,end=1060) Veta
        if(index(Veta,'**********').gt.0) go to 1060
        read(Veta,'(a8,19x,3f9.6,12x,i3)')
     1                               atomn(i),(xn(j,i),j=1,3),kmodxn(i)
        isfn(i)=0
        read(m40,'(f9.6)',end=1060) Rho(i)
        call zhusti(atomn(i))
        call uprat(atomn(i))
        do 1050j=1,kmodxn(i)
          read(m40,'(6f9.6)',end=1060)
     1                             (uxn(k,j,i),k=1,3),(uyn(k,j,i),k=1,3)
1050    continue
        if(kmodxn(i).gt.0) read(m40,100,end=1060)
        go to 1040
1060    nan=i-1
        call CloseIfOpened(m40)
      endif
      iaka=na(1)
      do 1110i=1,isw-1
        iaka=iaka+na(i+1)
1110  continue
      do 1112i=1,MaxMolPos
        menp(i)=MolMenu(i)
1112  continue
      isfp=1
      biso=3.
      ipart=0
1200  if(l48) then
        call SelAtoms('Select peaks',Atomn,AtBrat,isfn,nan,.true.,ich)
        if(ich.ne.0) go to 9000
        i1=1
        i2=nan
      else
        i1=1
        i2=1
      endif
      ina=0
      do 5000i=i1,i2
        if(l48) then
          if(.not.AtBrat(i)) go to 5000
          ina=ina+1
          kmodxi=kmodxn(i)
        else
          id=NextQuestId()
          call FeQuestCreate(id,-1.,-1.,100.,0,1,'Coordinates of new '//
     1                       'atom',0,LightGray,0,0)
          call FeQuestEdwMake(id,5.,1,5.,1,' ','L',90.,EdwYd,0)
          nEdwXYZAtom=EdwLastMade
          call FeQuestRealAEdwOpen(EdwLastMade,xn,3,.true.,.false.)
          icont=0
2000      call FeQuestEvent(id,icont,ich)
          icont=1
          if(CheckType.ne.0) then
            call NebylOsetren
            go to 2000
          endif
          if(ich.eq.0)
     1      call FeQuestRealAFromEdw(nEdwXYZAtom,xn)
          call FeQuestRemove(id)
          if(ich.ne.0.or.idel(EdwStringQuest(nEdwXYZAtom)).le.0) then
            ich=0
            go to 9000
          endif
          kmodxi=0
          ina=1
        endif
        call SpecPos(xn(1,i),isw,.2,nocc)
        nacalc=nacalc+1
        call CopyVek(xn(1,i),x(1,nacalc),3)
        do 2100k=1,kmodxi
          call CopyVek(uxn(1,k,i),ux(1,k,nacalc),3)
          call CopyVek(uyn(1,k,i),uy(1,k,nacalc),3)
2100    continue
        ai(nacalc)=1.
        kmodx(nacalc)=kmodxi
        iswa(nacalc)=isw
        kswa(nacalc)=KPhase
        atom(nacalc)='Itself'
        call specat
        call DistForOneAtom(nacalc,dmez,isw,0)
        nacalc=nacalc-1
        n=1
        iporp(n)=0
        write(TextInfo(n),101)(xn(m,i),m=1,3)
        if(l48) then
          TextInfo(n)(28:)=' - as read in'
        else
          TextInfo(n)(28:)=' - as typed in'
        endif
        dmin=999.
        do 3100j=1,ndist
          k=ipord(j)
          if(adist(k).eq.'Itself') go to 3100
          if(dmin.gt.900.) dmin=ddist(k)
          n=n+1
          iporp(n)=k
          write(TextInfo(n),101)(xdist(m,k),m=1,3),ddist(k),adist(k)
3100    continue
        n=n+1
        if(l48) then
          TextInfo(n)='           --- Skip this peak ---'
          write(Cislo,'(f15.3)') Rho(i)
          call Zhusti(Cislo)
          Veta='Peak : '//Atomn(i)(:idel(Atomn(i)))//'    Rho : '//
     1         Cislo(:idel(Cislo))
        else
          TextInfo(n)='         --- Skip this position ---'
          Veta=' '
        endif
        id=NextQuestId()
        call FeQuestCreate(id,-1.,-1.,180.,n+1,0,Veta,0,LightGray,0,0)
        call FeQuestLabelMake(id,7.,1,'   Equivalent coordinates  '//
     1                        '  Distance  Atom','L')
        if(dmin.lt.smez) then
          ivyber=n
        else if(n.gt.2) then
          ivyber=2
        else
          ivyber=1
        endif
        do 3105j=1,n
          call FeQuestSelwMake(id,5.,j+1,TextInfo(j),170.,SelwYd,0,1)
          call FeQuestSelwOpen(SelwLastMade,j.eq.ivyber)
3105    continue
3110    call FeQuestEvent(id,0,ich)
        if(CheckType.ne.0) then
          call NebylOsetren
          go to 3110
        endif
        At=' '
        if(ich.eq.0) then
          if(SelwLogicQuest(n)) then
            AtBrat(i)=.false.
            call FeQuestRemove(id)
            go to 5000
          else
            do 3120iv=1,n-1
              if(SelwLogicQuest(iv)) then
                ivyber=iporp(iv)
                call FeQuestRemove(id)
                go to 3150
              endif
3120        continue
          endif
        else
          ich=1
          call SetLogicalArrayTo(AtBrat(i),i2-i+1,.false.)
          call FeQuestRemove(id)
          go to 5002
        endif
3150    if(MaxMolPos.gt.0) then
          iw=5
        else
          iw=4
        endif
        id=NextQuestId()
        call FeQuestCreate(id,-1.,-1.,140.,0,iw,'Complete information'//
     1                     ' for the new atom',0,LightGray,0,0)
        il=1
        tpom=5.
        dpom=40.
        xpom=95.
        call FeQuestEdwMake(id,tpom,il,xpom,il,'%Name of the atom','L',
     1                      dpom,EdwYd,1)
        nEdwAtName=EdwLastMade
        call FeQuestStringEdwOpen(EdwLastMade,At)
        if(lite.eq.0) then
          Veta='Uiso'
          Biso=Biso/episq
        else
          Veta='Biso'
        endif
        il=il+1
        call FeQuestEdwMake(id,tpom,il,xpom,il,'%'//Veta,'L',dpom,EdwYd,
     1                      0)
        nEdwUiso=EdwLastMade
        call FeQuestRealEdwOpen(EdwLastMade,Biso,.false.,.false.)
        if(Lite.eq.0) Biso=Biso*episq
        Veta='Occupancy 1/'
        write(Veta(13:15),'(i3)') nocc
        call Zhusti(Veta(13:15))
        Veta=Veta(:15)//'   %Reduction'
        xpom=xpom+15.
        dpom=dpom-15.
        il=il+1
        call FeQuestEdwMake(id,tpom,il,xpom,il,Veta,'L',dpom,EdwYd,0)
        Reduction=1.
        nEdwReduction=EdwLastMade
        call FeQuestRealEdwOpen(EdwLastMade,Reduction,.false.,.false.)
        il=il+1
        xpom=xpom+5.
        dpom=dpom-5.
        call FeQuestEdwMake(id,tpom,il,xpom,il,'Atomic %type','L',dpom,
     1                      EdwYd,1)
        nEdwAtType=EdwLastMade
        call FeQuestStringEdwOpen(EdwLastMade,AtTypeFull(isfp,KPhase))
        xpom1=FeXPixRound(xpom)-5.*PixelX-FeXPixRound(UpDownXd)
        call FeQuestUpDownMake(id,xpom1,il,UpDownXd,UpDownYd,'up')
        nUpDownAtType=UpDownLastMade
        call FeQuestUpDownOpen(UpDownLastMade,UpDownOff)
        if(MaxMolPos.gt.0) then
          il=il+1
          xpom=90.
          dpom=45.
          call FeQuestEdwMake(id,tpom,il,xpom,il,'%Part of structure',
     1                        'L',dpom,EdwYd,1)
          nEdwPart=EdwLastMade
          call FeQuestStringEdwOpen(nEdwPart,menp(ipart))
          xpom1=FeXPixRound(xpom)-5.*PixelX-FeXPixRound(UpDownXd)
          call FeQuestUpDownMake(id,xpom1,il,UpDownXd,UpDownYd,'up')
          nUpDownPart=UpDownLastMade
          call FeQuestUpDownOpen(UpDownLastMade,UpDownOff)
        endif
        icont=0
3200    call FeQuestEvent(id,icont,ich)
        icont=1
        if(CheckType.eq.EventEdw) then
          if(CheckNumber.eq.nEdwAtName) then
            Veta=EdwStringQuest(nEdwAtName)
            call zhusti(Veta)
            call uprat(Veta)
            call FeQuestStringEdwOpen(nEdwAtName,Veta)
            call AtCheck(Veta,ichp,j)
            if(ichp.eq.1.or.Veta.eq.' ') then
              call FeChybne(-1.,30.,'Unacceptable symbol in the name,'
     1                    //' try again',' ',0,SeriousError)
              EventType=EventEdw
              EventNumber=nEdwAtName
              go to 3200
            endif
            n=0
            do 3222j=1,nf
              k=idel(AtType(j,KPhase))
              if(k.eq.0) go to 3222
              k=index(Veta,AtType(j,KPhase)(:k))
              if(k.ne.1) then
                go to 3222
              else
                n=j
                if(idel(AtType(j,KPhase)).eq.2) go to 3223
              endif
3222        continue
            if(n.eq.0) go to 3200
3223        isfp=n
            call FeQuestStringEdwOpen(nEdwAtType,AtType(isfp,KPhase))
            go to 3200
          else if(CheckNumber.eq.nEdwAtType) then
            Veta=EdwStringQuest(nEdwAtType)
            call uprat(Veta)
            call FeQuestStringEdwOpen(nEdwAtType,Veta)
            do 3230n=1,nf
              if(Veta.eq.AtType(n,KPhase)) then
                isfp=n
                go to 3200
              endif
3230        continue
            call FeChybne(-1.,30.,'Atomic type not present on M50 file',
     1                    ' ',0,SeriousError)
            EventType=EventEdw
            EventNumber=nEdwAtType
            go to 3200
          else if(CheckNumber.eq.nEdwPart) then
            Veta=EdwStringQuest(nEdwPart)
            call uprat(Veta)
            call FeQuestStringEdwOpen(nEdwPart,Veta)
            do 3240n=0,MaxMolPos
              if(Veta.eq.menp(n)) then
                ipart=n
                go to 3200
              endif
3240        continue
            call FeChybne(-1.,30.,'Part of structure not present',
     1                    ' ',0,SeriousError)
            EventType=EventEdw
            EventNumber=nEdwPart
            go to 3200
          endif
        else if(CheckType.eq.EventUpDown.and.
     1          CheckNumber.eq.nUpDownAtType) then
          n=FeMenu(EdwXminQuest(nEdwAtType),EdwYminQuest(nEdwAtType),
     1             AtTypeFull(1,KPhase),1,nf,1,1)
          if(n.gt.0) isfp=n
          call FeQuestStringEdwOpen(nEdwAtType,AtType(isfp,KPhase))
          call FeQuestUpDownOff(nUpDownAtType)
          EventType=EventEdw
          EventNumber=nEdwAtType
          go to 3200
        else if(CheckType.eq.EventUpDown.and.
     1          CheckNumber.eq.nUpDownPart) then
          n=FeMenu(EdwXminQuest(nEdwPart),EdwYminQuest(nEdwPart),menp,0,
     1             MaxMolPos,0,1)
          if(n.ge.0) ipart=n
          call FeQuestStringEdwOpen(nEdwPart,menp(ipart))
          call FeQuestUpDownOff(nUpDownPart)
          EventType=EventEdw
          EventNumber=nEdwPart
          go to 3200
        else if(CheckType.ne.0) then
          call NebylOsetren
          go to 3200
        endif
        if(ich.eq.0) then
          At=EdwStringQuest(nEdwAtName)
          call FeQuestRealFromEdw(nEdwUiso,Biso)
          if(Lite.eq.0) Biso=Biso*episq
          call FeQuestRealFromEdw(nEdwReduction,reduction)
        endif
        call FeQuestRemove(id)
        if(ich.ne.0) then
          AtBrat(i)=.false.
          ich=0
          go to 5000
        endif
        if(ipart.gt.0) then
          ji=-ktatmol(menp(ipart))
          im=(ji-1)/mxp+1
          iak=mxa
          do 3300j=1,im-1
            iak=iak+iamn(j)
3300      continue
          iak=iak+iam(im)
        else
          ji=0
          im=0
          iak=iaka
        endif
        if(ivyber.ne.0) then
          call CopyVek(xdist(1,ivyber),xn(1,i),3)
          do 3330j=1,kmodxi
            call CopyVek(uxdist(1,j,ivyber),uxn(1,j,i),3)
            call CopyVek(uydist(1,j,ivyber),uyn(1,j,i),3)
3330      continue
        endif
        if(im.gt.0) then
          do 3350j=1,3
            xn(j,i)=xn(j,i)-trans(j,ji)-xm(j,im)
3350      continue
          call multm(RotiMol(1,ji),xn(1,i),xp,3,3,1)
          call AddVek(xp,xm(1,im),xn(1,i),3)
          do 3370j=1,kmodxi
            call multm(RotiMol(1,ji),uxn(1,j,i),xp,3,3,1)
            call CopyVek(xp,uxn(1,j,i),3)
            call multm(RotiMol(1,ji),uyn(1,j,i),xp,3,3,1)
            call CopyVek(xp,uyn(1,j,i),3)
3370      continue
        endif
        kam=ktatmol(at)
        if(kam.le.0) then
          kam=iak+1+nacoff
          if(im.eq.0) then
            na(isw)=na(isw)+1
            nac=nac+1
            nacAll=nacAll+1
            nacalc=nacalc+1
            iaka=iaka+1
            nn=nacalc
            if(nacalc.eq.1) then
              PrvniKiAtomu(nn)=ndoff
            else
              PrvniKiAtomu(nn)=PrvniKiAtomu(nn-1)
            endif
          else
            iam(im)=iam(im)+1
            iamn(im)=iamn(im)+npoint(im)
            nn=mxa+nacbAll
            nacbAll=nacbAll+npoint(im)
            if(nacbAll.eq.1) then
              PrvniKiAtomu(nn)=ndoff
            else
              PrvniKiAtomu(nn)=PrvniKiAtomu(nn-1)
            endif
          endif
          call SavePhase
          if(kam.eq.1.or.(kam.eq.mxa+1.and.nacalc.eq.0)) then
            PrvniKiAtomu(kam)=ndoff
          else
            PrvniKiAtomu(kam)=PrvniKiAtomu(kam-1)+DelkaKiAtomu(kam-1)
          endif
          DelkaKiAtomu(kam)=0
          if(im.gt.0) then
            k=kam
            do 3400j=1,npoint(im)
              call AtSun(k,nn,k+1)
              k=k+iam(im)-1
              nn=nn+1
3400        continue
            nacalc=nacAll
            call SetMol(0,0)
          else
            call AtSun(kam,nn-1,kam+1)
          endif
          Novy=.true.
        else
          if(.not.FeYesNo(-1.,-1.,'Do you really want to '//
     1      'modify/replace the atom '//at(1:idel(at))//'?',1)) then
            AtBrat(i)=.false.
            go to 3150
          endif
          Novy=.false.
        endif
        iz=iz+1
        ai(kam)=Reduction/float(nocc)
        sai(kam)=0.
        call CopyVek(xn(1,i),x(1,kam),3)
        do 4300j=1,kmodxi
          call CopyVek(uxn(1,j,i),ux(1,j,kam),3)
          call CopyVek(uyn(1,j,i),uy(1,j,kam),3)
4300    continue
        kmodx(kam)=kmodxi
        kfx(kam)=0
        if(Novy) then
          atom(kam)=at
          iswa(kam)=isw
          kswa(kam)=KPhase
          kmol(kam)=ji
          isf(kam)=isfp
          ifr(kam)=0
          itf(kam)=1
          lasmax(kam)=0
          do 4400j=1,7
            if(j.ne.2) then
              kfa(kam,j)=0
              kmoda(kam,j)=0
            endif
4400      continue
          call SetRealArrayTo(sx,3,0.)
          call ShiftKiAt(kam,itf(kam),ifr(kam),lasmax(kam),kmods(kam),
     1                   kmodx(kam),kmodb(kam),kmodc3(kam),kmodc4(kam),
     2                   kmodc5(kam),kmodc6(kam),.true.)
          PrvKi=PrvniKiAtomu(kam)
          call SetIntArrayTo(ki(PrvKi),DelkaKiAtomu(kam),0)
          beta(1,kam)=biso
          call SetRealArrayTo( beta(2,kam),5,0.)
          call SetRealArrayTo(sbeta(1,kam),6,0.)
        endif
        if(itf(kam).eq.2.and.kmodxi.gt.0) then
          do 4850j=1,3
            xp(j)=sqrt(ux(j,1,kam)**2+uy(j,1,kam)**2)*pi
4850      continue
          do 4900j=1,6
            call indext(j,k,l)
            beta(j,kam)=beta(j,kam)-xp(k)*xp(l)
4900      continue
        endif
        nacalc=nacAll
        call setmol(0,0)
5000  continue
      if(ina.le.0) go to 9000
5002  if(l48) then
        j=0
        do 5100i=1,nan
          if(.not.AtBrat(i)) then
            j=j+1
            if(j.ne.i) then
              atomn(j)=atomn(i)
              kmodxn(j)=kmodxn(i)
              call CopyVek(xn(1,i),xn(1,j),3)
              do 5010l=1,kmodxn(j)
                call CopyVek(uxn(1,l,i),uxn(1,l,j),3)
                call CopyVek(uyn(1,l,i),uyn(1,l,j),3)
5010          continue
            endif
          endif
5100    continue
        nan=j
        if(nan.eq.0) go to 9000
      endif
      go to 1200
9000  if(iz.gt.0) then
        NInfo=1
        Veta='Do you want to accept'
        if(iz.ne.1) then
          write(TextInfo(1),'(i5)') iz
          call zhusti(TextInfo(1))
          TextInfo(1)=TextInfo(1)(:idel(TextInfo(1))+1)//
     1                'new atoms have been inserted'
          Veta=Veta(:idel(Veta))//' them?'
        else
          TextInfo(1)='One new atom has been inserted'
          Veta=Veta(:idel(Veta))//' it?'
        endif
        if(FeYesNoHeader(-1.,-1.,Veta,1)) then
          ich=0
        else
          call OneStepBack
          ich=1
        endif
      endif
      return
100   format(f8.4)
101   format(3f9.6,f8.2,4x,a8)
      end
      subroutine EM40NewAtH(ich)
      include 'params.cmn'
      include 'basic.cmn'
      include 'atoms.cmn'
      include 'molec.cmn'
      include 'refine.cmn'
      include 'editm40.cmn'
      include 'fepc.cmn'
      common/KeepQuest/ nEdwList,nEdwCentr,nEdwHDist,nEdwNNeigh,
     1           nEdwNeighFirst,nEdwNeighLast,nEdwHFirst,nEdwHLast,
     2           nEdwAnchor,nEdwTorsAngle,nCrwUseAnchor,nButtSelect,
     3           AtomToBeFilled,nEdwNH,nEdwARiding
      character*256 EdwStringQuest,Command(1),t256,p256
      character*128 CurrentDirO
      character*80 Veta,AtFill(5)
      character*8  at
      character*2 nty
      logical SaveKeepCommands,CrwLogicQuest,EqIgCase,FeYesNo,
     1        MapAlreadyUsed,Recalculate
      integer FeMenu,AtomToBeFilled,EdwStateQuest,FeChdir
      external RefKeepUpdateQuest,FeVoid
      real KeepDistHOld
      data SaveKeepCommands/.true./,BlowUpFactor/1.2/
      save /KeepQuest/
      ich=0
      do 1000i=1,nf
        if(EqIgCase(AtTypeFull(i,KPhase),'h').or.
     1     (EqIgCase(AtTypeFull(i,KPhase),'d').and.
     2      Radiation(1).eq.NeutronRadiation)) then
          isfh=i
          go to 1030
        endif
1000  continue
      pom=100000.
      do 1020i=1,nf
        if(ffbasic(1,i,KPhase).lt.pom) then
          pom=ffbasic(1,i,KPhase)
          isfh=i
        endif
1020  continue
1030  id=NextQuestId()
      il=2
      call FeQuestCreate(id,-1.,-1.,150.,0,il,'Adding of "hydrogen" '//
     1                   'atoms',0,LightGray,0,0)
      il=1
      Veta='"Hydrogen" atomic %type'
      xpom=5.
      dpom=20.
      xpomp=FeXPixRound(xpom)+FeXPixRound(dpom)+5.*PixelX
      tpom=xpomp+3.+FeXPixRound(UpDownXd)
      call FeQuestEdwMake(id,tpom,il,xpom,il,Veta,'L',dpom,EdwYd,1)
      nEdwHType=EdwLastMade
      call FeQuestStringEdwOpen(EdwLastMade,AtTypeFull(isfh,KPhase))
      call FeQuestUpDownMake(id,xpomp,il,UpDownXd,UpDownYd,'up')
      nUpHType=UpDownLastMade
      call FeQuestUpDownOpen(UpDownLastMade,UpDownOff)
      il=il+1
      tpom=xpom+10.
      Veta='%generate the "keep" commands for REFINE'
      call FeQuestCrwMake(id,tpom,il,xpom,il,Veta,'L',CrwXd,CrwYd,0,0)
      nCrwSaveKeep=CrwLastMade
      call FeQuestCrwOpen(CrwLastMade,SaveKeepCommands)
      icont=0
1100  call FeQuestEvent(id,icont,ich)
      icont=1
      if(CheckType.eq.EventEdw.and.CheckNumber.eq.nEdwHType) then
        Veta=EdwStringQuest(nEdwHType)
        call mala(Veta)
        if(ktat(AtTypeFull(1,KPhase),nf,Veta).le.0) then
          call UprAt(Veta)
          Veta='The atom type "'//Veta(:idel(Veta))//
     1         '" not defined, try again.'
          call FeChybne(-1.,-1.,Veta,' ',0, SeriousError)
          EventType=EventEdw
          EventNumber=nEdwHType
        endif
        go to 1100
      else if(CheckType.eq.EventUpDown.and.CheckNumber.eq.nUpHType) then
        n=FeMenu(EdwXminQuest(nEdwHType),EdwYminQuest(nEdwHType),
     1           AtTypeFull(1,KPhase),1,nf,1,1)
        if(n.gt.0) then
          isfh=n
          call FeQuestStringEdwOpen(nEdwHType,AtTypeFull(n,KPhase))
        endif
        EventType=EventEdw
        EventNumber=nEdwHType
        call FeQuestUpDownOff(nUpHType)
        go to 1100
      else if(CheckType.ne.0) then
        call NebylOsetren
        go to 1100
      endif
      if(ich.eq.0) SaveKeepCommands=CrwLogicQuest(nCrwSaveKeep)
      call FeQuestRemove(id)
      if(ich.ne.0) go to 9999
      call DefGroup(i1,i2,0)
      if(i1.le.0) go to 9999
      call CopyFile(fln(:ifln)//'.m40',fln(:ifln)//'.z40')
      call CopyFile(fln(:ifln)//'.m50',fln(:ifln)//'.z50')
      call iom40(1,0)
      xdq=270.
      id=NextQuestId()
      if(SaveKeepCommands) then
        IgnoreW=.true.
        call OpenCommandsRefine
        IgnoreW=.false.
      endif
      nEdwCentr=0
      KeepNNeigh(1)=3
      NNeigh=3
      KeepNH(1)=1
      KeepDistH(1)=1.
      UseAnchor=.false.
      KeepType(1)=11
      napp=0
      MapAlreadyUsed=.false.
      iaw=0
      do 1200ia=i1,i2
        if(AtBrat(ia)) iaw=iaw+1
1200  continue
      iaa=0
      do 4000ia=i1,i2
        KeepAngleH(1)=180.
        if((ia.gt.nacAll.and.ia.le.mxa).or..not.AtBrat(ia)) go to 4000
        iaa=iaa+1
        isw=iswa(ia)
        if(ia.le.mxa) then
          im=0
          iap=1
          do 2010i=1,isw-1
            iap=iap+na(i)
2010      continue
          iak=iap+na(isw)-1
        else
          im=(kmol(ia)-1)/mxp+1
          iap=mxa+1
          do 2020i=1,im-1
            iap=iap+iamn(i)
2020      continue
          iak=iap+iam(im)-1
        endif
        il=7
        Veta='Adding "hydrogen" atoms for "'//atom(ia)(:idel(atom(ia)))
     1       //'"'
        call FeQuestCreate(id,-1.,-1.,xdq,0,il,Veta,0,LightGray,-1,-1)
        il=0
        xpom=5.
        tpom=xpom+3.+CrwgXd
        Veta='T%etraedric'
        xpom1=tpom+FeTxLengthUnder(Veta)+30.
        nTypeHydro=3
        do 2110i=1,nTypeHydro
          il=il+1
          call FeQuestCrwMake(id,tpom,il,xpom,il,Veta,'L',CrwgXd,CrwgYd,
     1                        1,1)
          if(i.eq.1) then
            Veta='T%rigonal'
            nCrwTetra=CrwLastMade
          else if(i.eq.2) then
            Veta='A%pical'
            nCrwTriangl=CrwLastMade
          else if(i.eq.3) then
            nCrwApical=CrwLastMade
          endif
2110    continue
        il=1
        dpom=50.
        xpom=xpom1
        tpom=xpom+dpom+3.
        Veta='H di%st.'
        do 2150i=1,2
          call FeQuestEdwMake(id,tpom,il,xpom,il,Veta,'L',dpom,EdwYd,1)
          if(i.eq.1) then
            nEdwHDist=EdwLastMade
            xpom=tpom+FeTxLengthUnder(Veta)+10.
            Veta='%ADP ext. factor'
            tpom=xpom+dpom+3.
            xpom2=xpom
          else if(i.eq.2) then
            nEdwFactor=EdwLastMade
          endif
2150    continue
        il=il+1
        Veta='%Neighbor(s)'
        xpom=xpom1
        dpom1=12.
        tpom=xpom+dpom1+8.
        call FeQuestEudMake(id,tpom,il,xpom,il,Veta,'L',dpom1,EdwYd,1)
        nEdwNNeigh=EdwLastMade
        ilh=il
        xpomh=xpom2+dpom*.5
        call FeQuestLabelMake(id,xpomh,il,'Hydrogen(s)','C')
        xpom=xpom1
        ilp=il
        do 2170j=1,2
          tpom=xpom+dpom+3.
          do 2160i=1,5
            il=il+1
            write(Veta,'(i1,a2)') i,nty(i)
            call FeQuestEdwMake(id,tpom,il,xpom,il,Veta,'L',dpom,EdwYd,
     1                          1)
            if(j.eq.1) then
              if(i.eq.1) nEdwNeighFirst=EdwLastMade
            else
              if(i.eq.1) nEdwHFirst=EdwLastMade
            endif
2160      continue
          if(j.eq.1) then
            nEdwNeighLast=EdwLastMade
            il=ilp
            xpom=xpom2
          else
            nEdwHLast=EdwLastMade
          endif
2170    continue
        il=il-1
        Veta='%Use anchoring  =>'
        xpom=5.
        tpom=xpom+3.+CrwXd
        call FeQuestCrwMake(id,tpom,il,xpom,il,Veta,'L',CrwXd,CrwYd,1,0)
        nCrwUseAnchor=CrwLastMade
        Veta='Anch%or'
        xpom=xpom1
        do 2180i=1,2
          tpom=xpom+dpom+3.
          if(i.eq.1) then
            j=1
          else
            j=0
          endif
          call FeQuestEdwMake(id,tpom,il,xpom,il,Veta,'L',dpom,EdwYd,j)
          if(i.eq.1) then
            nEdwAnchor=EdwLastMade
            Veta='Tors.an%gle'
            xpom=xpom2
          else if(i.eq.2) then
            nEdwTorsAngle=EdwLastMade
          endif
2180    continue
        il=il+1
        xpom=xpom1
        Veta='Lo%cate position in map'
        dpom=FeTxLengthUnder(Veta)+5.
        call FeQuestButtonMake(id,xpom,il,dpom,ButYd,Veta)
        nButtLocate=ButtonLastMade
        xpom=xpom2
        Veta='Se%lect neighbors'
        dpom=FeTxLengthUnder(Veta)+5.
        call FeQuestButtonMake(id,xpom,il,dpom,ButYd,Veta)
        nButtSelect=ButtonLastMade
        il=il+1
        Veta='Avoi%d'
        if(ia.ne.i2) Veta=Veta(:idel(Veta))//'->Go to next'
        dpoma=FeTxLengthUnder(Veta)+10.
        dpomb=FeTxLengthUnder('XXXX')+10.
        xpom=xdq*.5-dpoma-dpomb*.5-10.
        dpom=dpoma
        do 2200i=1,3
          call FeQuestButtonMake(id,xpom,il,dpom,ButYd,Veta)
          if(i.eq.1) then
            Veta='%Quit'
            nButtAvoid=ButtonLastMade
          else if(i.eq.2) then
            Veta='Appl%y'
            if(ia.ne.i2) Veta=Veta(:idel(Veta))//'->Go to next'
            nButtQuit=ButtonLastMade
          else if(i.eq.3) then
            nButtApply=ButtonLastMade
          endif
          call FeQuestButtonOpen(ButtonLastMade,ButtonOff)
          xpom=xpom+dpom+10.
          if(i.eq.1) then
            dpom=dpomb
          else
            dpom=dpoma
          endif
2200    continue
        do 2310i=1,mxkp
          KeepAt(1,i)=' '
2310    continue
        KeepAtCentr(1)=atom(ia)
        KeepNAtCentr(1)=ia
2350    KeepTypeOld=0
2400    KeepTypeMain=KeepType(1)/10
        KeepTypeAdd=mod(KeepType(1)-1,10)+1
        KeepTypeMainOld=KeepTypeOld/10
        KeepTypeAddOld=mod(KeepTypeOld-1,10)+1
        if(KeepType(1).ne.KeepTypeOld) then
          nCrw=nCrwTetra
          do 2450i=1,nTypeHydro
            call FeQuestCrwOpen(nCrw,i.eq.KeepTypeAdd)
            nCrw=nCrw+1
2450      continue
        endif
        if(KeepType(1).eq.IdKeepHApical) then
          NAtMax=6
          KeepNH(1)=1
          UseAnchor=.false.
        else if(KeepType(1).eq.IdKeepHTetraHed) then
          NAtMax=4
          if(KeepTypeOld.eq.IdKeepHTriangl) then
            NNeigh=NNeigh+1
          else if(KeepTypeOld.eq.IdKeepHApical) then
            NNeigh=min(NNeigh,NAtMax-1)
          endif
        else if(KeepType(1).eq.IdKeepHTriangl) then
          NAtMax=3
          if(KeepTypeOld.eq.IdKeepHTetraHed) then
            if(NNeigh.eq.1) then
              KeepNH(1)=KeepNH(1)-1
            else
              NNeigh=NNeigh-1
            endif
          else if(KeepTypeOld.eq.IdKeepHApical) then
            NNeigh=min(NNeigh,NAtMax-1)
          endif
        endif
        KeepNNeigh(1)=NNeigh
        if(UseAnchor) KeepNNeigh(1)=KeepNNeigh(1)+1
        icont=0
2500    if(KeepNH(1).ne.NAtMax-1) then
          call FeQuestCrwClose(nCrwUseAnchor)
          call FeQuestButtonClose(nButtLocate)
          UseAnchor=.false.
        else if(im.gt.0) then
          call FeQuestButtonClose(nButtLocate)
        endif
        if(.not.UseAnchor) then
          call FeQuestEdwClose(nEdwAnchor)
          call FeQuestEdwClose(nEdwTorsAngle)
          KeepAtAnchor(1)=' '
        endif
        call FeQuestIntEdwOpen(nEdwNNeigh,NNeigh,.false.)
        call FeQuestEudOpen(nEdwNNeigh,1,NAtMax-1,1,0.,0.,0.)
        call FeQuestRealEdwOpen(nEdwHDist,KeepDistH(1),.false.,
     1                          .false.)
        call FeQuestRealEdwOpen(nEdwFactor,BlowUpFactor,.false.,
     1                          .false.)
        do 2520j=1,2
          if(j.eq.1) then
            nEdw=nEdwNeighFirst
            NMaxP=NNeigh
          else
            nEdw=nEdwHFirst
            NMaxP=KeepNH(1)
          endif
          do 2510i=1,5
            if(i.le.NMaxP) then
              if(j.eq.1) then
                Veta=KeepAtNeigh(1,i)
              else
                Veta=KeepAtH(1,i)
              endif
              call FeQuestStringEdwOpen(nEdw,Veta)
            else
              call FeQuestEdwClose(nEdw)
            endif
            nEdw=nEdw+1
2510      continue
2520    continue
        if(KeepNH(1).eq.NAtMax-1) then
          UseAnchor=NAtMax.lt.KeepNNeigh(1)+KeepNH(1)
          call FeQuestCrwOpen(nCrwUseAnchor,UseAnchor)
          if(im.eq.0) call FeQuestButtonOpen(nButtLocate,ButtonOff)
        endif
        if(UseAnchor) then
          call FeQuestStringEdwOpen(nEdwAnchor,KeepAtAnchor(1))
          call FeQuestRealEdwOpen(nEdwTorsAngle,KeepAngleH(1),.false.,
     1                            .false.)
        endif
        call FeQuestButtonOpen(nButtSelect,ButtonOff)
        KeepTypeOld=KeepType(1)
        KeepNHOld=KeepNH(1)
        KeepNNeighOld=KeepNNeigh(1)
3000    MakeExternalCheck=1
        call FeQuestEventWithCheck(id,icont,ich,RefKeepUpdateQuest,
     1                             FeVoid)
        icont=1
        if(CheckType.eq.EventCrw) then
          if(CheckNumber.eq.nCrwTetra) then
            KeepType(1)=IdKeepHTetraHed
          else if(CheckNumber.eq.nCrwTriangl) then
            KeepType(1)=IdKeepHTriangl
          else if(CheckNumber.eq.nCrwApical) then
            KeepType(1)=IdKeepHApical
          else if(CheckNumber.eq.nCrwUseAnchor) then
            UseAnchor=CrwLogicQuest(nCrwUseAnchor)
            if(UseAnchor) then
              KeepNNeigh(1)=NNeigh+1
              KeepAtAnchor(1)=' '
            else
              KeepNNeigh(1)=NNeigh
            endif
            EventType=EventEdw
            EventNumber=nEdwAnchor
            go to 2500
          endif
          go to 2400
        else if(CheckType.eq.EventEdw) then
          if(CheckNumber.eq.nEdwNNeigh) then
            call FeQuestIntFromEdw(nEdwNNeigh,NNeigh)
            if(KeepType(1).eq.IdKeepHTetraHed.or.
     1         KeepType(1).eq.IdKeepHTriangl) then
              KeepNH(1)=NAtMax-NNeigh
              KeepNNeigh(1)=NNeigh
              if(UseAnchor.and.KeepNNeigh(1).eq.1)
     1          KeepNNeigh(1)=KeepNNeigh(1)+1
            else if(KeepType(1).eq.IdKeepHApical) then
              KeepNNeigh(1)=NNeigh
            endif
            if(KeepNH(1).ne.KeepNHOld.or.KeepNNeigh(1).ne.KeepNNeighOld)
     1        then
              EventType=EventEdw
              EventNumber=nEdwNNeigh
              go to 2500
            endif
          else if(CheckNumber.ge.nEdwNeighFirst.and.
     1            CheckNumber.le.nEdwNeighLast) then
            i=CheckNumber-nEdwNeighFirst+1
            KeepAtNeigh(1,i)=EdwStringQuest(CheckNumber)
          else if(CheckNumber.ge.nEdwHFirst.and.
     1            CheckNumber.le.nEdwHLast) then
            i=CheckNumber-nEdwHFirst+1
            KeepAtH(1,i)=EdwStringQuest(CheckNumber)
          else if(CheckNumber.eq.nEdwAnchor) then
            KeepAtAnchor(1)=EdwStringQuest(CheckNumber)
          else if(CheckNumber.eq.nEdwHDist) then
            call FequestRealFromEdw(nEdwHDist,KeepDistH(1))
          else if(CheckNumber.eq.nEdw) then
            call FequestRealFromEdw(nEdwFactor,BlowUpFactor)
          endif
          go to 3000
        else if(CheckType.eq.EventButton.and.CheckNumber.eq.nButtSelect)
     1    then
          EventType=EventEdw
          if(AtomToBeFilled.eq.SelectedAnchor) then
            EventNumber=nEdwAnchor
            Veta=EdwStringQuest(nEdwNeighFirst)
            if(Veta.ne.' ') then
              call SelNeighborAtoms('Select the anchor atom',3.,Veta,
     1                              AtFill,1,n,isw,ich)
              if(ich.ne.0) go to 3200
            else
              call FeChybne(-1.,-1.,'first you have to define the '//
     1                     'neighbor atom',' ',0,SeriousError)
              EventNumber=nEdwNeighFirst
              go to 3200
            endif
            KeepAtAnchor(1)=AtFill(1)
          else
            if(AtomToBeFilled.eq.SelectedNeigh) then
              EventNumber=nEdwNeighFirst
              nmax=NNeigh
              Veta='Select the neighbor atoms'
            else if(AtomToBeFilled.eq.SelectedHydro) then
              EventNumber=nEdwHFirst
              nmax=KeepNH(1)
              Veta='Select the hydrogen atom'
              if(KeepNH(1).gt.1) Veta=Veta(:idel(Veta))//'s'
            endif
            call SelNeighborAtoms(Veta,3.,KeepAtCentr(1),AtFill,nmax,n,
     1                            isw,ich)
            if(ich.ne.0) go to 3200
            if(AtomToBeFilled.eq.SelectedNeigh) then
              do 3100i=1,NNeigh
                if(i.le.n) then
                  KeepAtNeigh(1,i)=AtFill(i)
                else
                  KeepAtNeigh(1,i)=' '
                endif
3100          continue
            else if(AtomToBeFilled.eq.SelectedHydro) then
              do 3120i=1,KeepNH(1)
                if(i.le.n) then
                  KeepAtH(1,i)=AtFill(i)
                else
                  KeepAtH(1,i)=' '
                endif
3120          continue
            endif
          endif
          call FeQuestButtonOff(NButtSelect)
          go to 2500
3200      call FeQuestButtonOff(NButtSelect)
          go to 3000
        else if(CheckType.eq.EventButton.and.CheckNumber.eq.nButtQuit)
     1    then
          Veta=' '
          if(napp.gt.0) then
            write(Veta,'(i5)') napp
            call zhusti(Veta)
            Veta='Do you really want to discard '//Veta(:idel(Veta))//
     1           ' new hydrogen atom'
            if(napp.gt.1) Veta=Veta(:idel(Veta))//'s'
          else
            Veta='Do you really want quit the procedure for this'
            if(iaa.lt.iaw) then
              write(Cislo,'(i5)') iaw-iaa+1
              call zhusti(Cislo)
              Veta=Veta(:idel(Veta))//' and remaining '//
     1             Cislo(:idel(Cislo))//' atom'
              if(ia.lt.i2-1) Veta=Veta(:idel(Veta))//'s'
            else
              Veta=Veta(:idel(Veta))//' atom'
            endif
          endif
          if(Veta.ne.' ') then
            Veta=Veta(:idel(Veta))//'?'
            if(.not.FeYesNo(-1.,-1.,Veta,0)) then
              icont=0
              call FeQuestButtonOff(nButtQuit)
              go to 3000
            endif
          endif
          ich=1
          go to 3900
        else if(CheckType.eq.EventButton.and.CheckNumber.eq.nButtAvoid)
     1    then
          ich=0
          go to 3900
        else if(CheckType.eq.EventButton.and.
     1          (CheckNumber.eq.nButtApply.or.
     2           CheckNumber.eq.nButtLocate)) then
          if(CheckNumber.eq.nButtLocate) then
            if(SaveKeepCommands) call RewriteCommandsRefine(1)
            call iom40(1,0)
          endif
          nEdw=nEdwNeighFirst
          do 3300i=1,NNeigh
            Veta=EdwStringQuest(nEdw)
            call UprAt(Veta)
            if(Veta.eq.' ') then
              if(NNeigh.eq.1) then
                Veta='the neighbor atom'
              else
                Veta='some of neighbor atoms'
              endif
              go to 3820
            endif
            j=index(Veta,'#')-1
            if(j.lt.0) j=idel(Veta)
            at=Veta(:j)
            call AtCheck(at,ichp,j)
            if(ichp.eq.1) go to 3810
            j=ktat(atom(iap),iak-iap+1,at)
            if(j.le.0) go to 3800
            KeepAtNeigh(1,i)=Veta
            nEdw=nEdw+1
3300      continue
          nEdw=nEdwHFirst
          do 3302i=1,KeepNH(1)
            Veta=EdwStringQuest(nEdw)
            call UprAt(Veta)
            if(Veta.eq.' ') then
              if(KeepNH(1).eq.1) then
                Veta='the hydrogen atom'
              else
                Veta='some of hydrogen atoms'
              endif
              go to 3820
            endif
            call AtCheck(Veta,ichp,j)
            if(ichp.eq.1) go to 3810
            j=index(Veta,'#')
            if(j.gt.0) Veta=Veta(:j-1)
            KeepAtH(1,i)=Veta
            nEdw=nEdw+1
3302      continue
          if(UseAnchor) then
            Veta=EdwStringQuest(nEdwAnchor)
            call UprAt(Veta)
            if(Veta.eq.' ') then
              Veta='the anchor atom'
              go to 3820
            endif
            j=index(Veta,'#')-1
            if(j.lt.0) j=idel(Veta)
            at=Veta(:j)
            call AtCheck(at,ichp,j)
            if(ichp.eq.1) go to 3810
            j=ktat(atom(iap),iak-iap+1,at)
            if(j.le.0) go to 3800
            KeepAtAnchor(1)=Veta
          endif
          call FequestRealFromEdw(nEdwHDist,KeepDistH(1))
          if(EdwStateQuest(nEdwTorsAngle).eq.EdwOpened) then
            call FeQuestRealFromEdw(nEdwTorsAngle,KeepAngleH(1))
          else
            if(KeepAtAnchor(1).eq.' ') then
              KeepAtAnchor(1)='#unknown#'
              KeepAngleH(1)=-999.
            endif
          endif
          call FequestRealFromEdw(nEdwFactor,BlowUpFactor)
          call SpecPos(x(1,ia),isw,.1,nocc)
          Reduction=ai(ia)*float(nocc)
          Recalculate=.false.
          iako=iak
          do 3350i=1,KeepNH(1)
            kam=ktatmol(KeepAtH(1,i))
            if(kam.le.0) then
              kam=iak+1+nacoff
              if(im.eq.0) then
                na(isw)=na(isw)+1
                nac=nac+1
                nacAll=nacAll+1
                nacalc=nacalc+1
                nn=nacalc
              else
                iam(im)=iam(im)+1
                iamn(im)=iamn(im)+npoint(im)
                nn=mxa+nacbAll
                nacbAll=nacbAll+npoint(im)
                PrvniKiAtomu(nn)=PrvniKiAtomu(nn-1)
              endif
              iak=iak+1
              call SavePhase
              PrvniKiAtomu(kam)=PrvniKiAtomu(kam-1)+DelkaKiAtomu(kam-1)
            else
              Recalculate=Recalculate.or.ai(kam).gt.0.
            endif
            DelkaKiAtomu(kam)=0
            if(im.gt.0) then
              k=kam
              do 3310j=1,npoint(im)
                call AtSun(k,nn,k+1)
                k=k+iam(im)-1
                nn=nn+1
3310          continue
              nacalc=nacAll
              call SetMol(0,0)
            endif
            KeepNAtH(1,i)=kam
            call ShiftKiAt(kam,itf(ia),ifr(ia),lasmax(ia),kmods(ia),
     1                     kmodx(ia),kmodb(ia),kmodc3(ia),kmodc4(ia),
     2                     kmodc5(ia),kmodc6(ia),.false.)
            call AtCopy(ia,kam)
            isf(kam)=isfh
            atom(kam)=KeepAtH(1,i)
            call SetIntArrayTo(ki(PrvniKiAtomu(kam)),DelkaKiAtomu(kam),
     1                         0)
            nacalc=nacAll
            call setmol(0,0)
3350      continue
          call EM40SetNewH(1)
          do 3370i=1,KeepNH(1)
            iah=KeepNAtH(1,i)
            call SpecPos(x(1,iah),isw,.1,nocc)
            if(CheckNumber.eq.nButtLocate) then
              ai(iah)=0.
            else
              ai(iah)=Reduction/float(nocc)
            endif
            sai(iah)=0.
            call SetRealArrayTo(sbeta(1,iah),6,0.)
            if(itf(iah).ge.2) then
              call boueq(beta(1,iah),sbeta(1,iah),1,bizo,sbizo,isw)
              itf(iah)=1
            else
              bizo=beta(1,iah)
            endif
            call SetRealArrayTo(beta(1,iah),6,0.)
            beta(1,iah)=bizo*BlowUpFactor
            do 3360j=3,7
              kfa(iah,j)=0
              kmoda(iah,j)=0
3360        continue
            call ShiftKiAt(iah,itf(iah),ifr(iah),lasmax(iah),
     1                     kmods(iah),kmodx(iah),kmodb(iah),
     2                     kmodc3(iah),kmodc4(iah),kmodc5(iah),
     3                     kmodc6(iah),.false.)
3370      continue
          if(SaveKeepCommands.and.CheckNumber.eq.nButtApply) then
            do 3390m=1,2
              call EM40KeepWriteCommand(Command(1),ich)
              if(ich.ne.0) go to 3850
              ln=NextLogicNumber()
              call OpenFile(ln,fln(:ifln)//'_keep.tmp','formatted',
     1                      'unknown')
              j=0
3375          read(ln,FormA256,end=3380) t256
              call mala(t256)
              j=j+1
              k=0
              call kus(t256,k,Cislo)
              if(.not.EqIgCase(Cislo,'keep').and.
     1           .not.EqIgCase(Cislo,'!keep')) go to 3375
              call kus(t256,k,Cislo)
              if(m.eq.1) then
                ii=IdKeepHydro
              else
                ii=IdKeepADP
              endif
              if(.not.EqIgCase(Cislo,CKeepType(ii))) go to 3375
              call kus(t256,k,Cislo)
              call kus(t256,k,Cislo)
              call UprAt(Cislo)
              if(.not.EqIgCase(Cislo,KeepAtCentr(1))) go to 3375
              call CloseIfOpened(ln)
              call RewriteLinesOnFile(fln(:ifln)//'_keep.tmp',j,j,
     1                                Command,1)
              go to 3382
3380          call CloseIfOpened(ln)
              call AppendFile(fln(:ifln)//'_keep.tmp',Command,1)
3382          if(m.eq.1) then
                KeepDistHOld=KeepDistH(1)
                KeepADPExtFac(1)=BlowUpFactor
                KeepType(1)=IdKeepARiding
              else
                KeepType(1)=KeepTypeOld
                KeepDistH(1)=KeepDistHOld
              endif
3390        continue
            napp=napp+KeepNH(1)
          else if(CheckNumber.eq.nButtLocate) then
            call EM40KeepWriteCommand(Command(1),ich)
            t256=fln(:ifln)//'.m40'
            j=idel(t256)-2
            p256=TmpDir(:idel(TmpDir))//fln(:ifln)//'.m40'
            k=idel(p256)-2
            do 3500i=1,3
              call CopyFile(t256,p256)
              if(i.eq.1) then
                t256(j:)='m50'
                p256(k:)='m50'
              else if(i.eq.2) then
                t256(j:)='m91'
                p256(k:)='m91'
              endif
3500        continue
            p256=TmpDir(:idel(TmpDir))//fln(:ifln)//'*.*'
            call FeTmpFilesAdd(p256)
            CurrentDirO=CurrentDir
            i=FeChdir(TmpDir)
            call FeGetCurrentDir
            call iom40(1,0)
            IgnoreW=.true.
            Veta=KeepAtAnchor(1)
            call OpenCommandsRefine
            IgnoreW=.false.
            call DeleteFile(fln(:ifln)//'_keep.tmp')
            call RewriteCommandsRefine(1)
            call RefKeepReadCommand(Command(1),ich)
            KeepAtAnchor(1)=Veta
            if(.not.MapAlreadyUsed.or.Recalculate) then
              call EM40SetCommandsRefine
              call EM40SetCommandsFourier
              ShowInfoOnScreen=.false.
              call refine(0)
              MapAlreadyUsed=.true.
            endif
            call EM40SetCommandsContour
            if(ErrJana.ne.0) go to 3520
            call EM40RunContour(TorsAngle,ich)
3520        i=FeChdir(CurrentDirO)
            call FeGetCurrentDir
            if(EdwStateQuest(nEdwTorsAngle).eq.EdwOpened.and.ich.eq.0)
     1         call FeQuestRealEdwOpen(nEdwTorsAngle,TorsAngle,.false.,
     2                                 .false.)
            if(SaveKeepCommands) then
              IgnoreW=.true.
              call OpenCommandsRefine
              IgnoreW=.false.
            endif
            call iom40(0,0)
            iak=iako
            KeepAtCentr(1)=atom(ia)
            KeepNAtCentr(1)=ia
            KeepNH(1)=KeepNHOld
            KeepNNeigh(1)=KeepNNeighOld
            KeepAngleH(1)=TorsAngle
            KeepType(1)=KeepTypeOld
            go to 3850
          endif
          go to 3900
3800      Veta='atom "'//Veta(:idel(Veta))//'" not present'
          call FeChybne(-1.,-1.,Veta,' ',0,SeriousError)
          go to 3860
3810      call FeChybne(-1.,-1.,'the atom name "'//Veta(:idel(Veta))//
     1                  '" contains unacceptable symbol',' ',0,
     2                  SeriousError)
          go to 3860
3820      call FeChybne(-1.,-1.,Veta(:idel(Veta))//' has not been '//
     1                  'specified',' ',0,SeriousError)
          go to 3860
3850      icont=0
          go to 3870
3860      EventType=EventEdw
          EventNumber=nEdw
3870      call FeQuestButtonOff(CheckNumber)
          go to 3000
        else if(CheckType.eq.EventButton.and.CheckNumber.eq.nButtLocate)
     1    then
        else if(CheckType.ne.0) then
          call NebylOsetren
          go to 3000
        endif
3900    call FeQuestRemove(id)
        if(ich.ne.0) then
          call CopyFile(fln(:ifln)//'.z40',fln(:ifln)//'.m40')
          call CopyFile(fln(:ifln)//'.z50',fln(:ifln)//'.m50')
          call iom50(0,0)
          call iom40(0,0)
          go to 9999
        endif
4000  continue
      if(SaveKeepCommands) call RewriteCommandsRefine(1)
9999  call FeMakeGrWin(0.,0.,14.,0.)
      if(MapAlreadyUsed) then
        t256=TmpDir(:idel(TmpDir))//fln(:ifln)//'*.*'
        call DeleteAllFiles(t256)
        call FeTmpFilesClear(t256)
      endif
      call DeleteFile(fln(:ifln)//'.z40')
      call DeleteFile(fln(:ifln)//'.z50')
      return
      end
      subroutine EM40SetCommandsRefine
      include 'params.cmn'
      include 'basic.cmn'
      include 'refine.cmn'
      call OpenCommandsRefine
      NacetlInt(nCmdncykl)=0
      NacetlInt(nCmdCallFour)=1
      NacetlInt(nCmdkim)=0
      NKeep=0
      call RewriteCommandsRefine(1)
      return
      end
      subroutine EM40SetCommandsFourier
      include 'params.cmn'
      include 'basic.cmn'
      include 'fourier.cmn'
      call DefaultFourier
      its=1
      call RewriteCommandsFourier(1,its)
      call OpenCommandsFourier(its)
      NacetlInt(nCmdUseWeight)=1
      NacetlInt(nCmdmapa)=6
      NacetlInt(nCmdlpeaks)=0
      NacetlReal(nCmdptstep)=0.1
      NacetlReal(nCmdsnlmx)=0.5
      if(ndimi.gt.0) then
        do 1000i=4,ndim
          xrmn(i)=0.
          xrmx(i)=0.
          dd(i)=.1
1000    continue
      endif
      its=1
      call RewriteCommandsFourier(1,its)
      return
      end
      subroutine EM40SetCommandsContour
      include 'params.cmn'
      include 'basic.cmn'
      include 'atoms.cmn'
      include 'refine.cmn'
      include 'contour.cmn'
      include 'fepc.cmn'
      character*256 t256
      character*80  Veta
      integer ColorOrder
      logical EqIgCase,Pis
      dimension xb(3),xc(3),u(3),ug(3),v(3),vg(3),trp(9),trpi(9)
      equivalence (t80,t256)
      call ConPrelim
      DrawAtN=KeepNH(1)+1
      DrawAtName(1)=KeepAtCentr(1)
      DrawAtColor(1)=ColorOrder('Red')
      call SetRealArrayTo(DrawAtBondLim,4,1.2)
      call SetLogicalArrayTo(DrawAtSkip,4,.false.)
      call SetIntArrayTo(DrawAtColor(2),3,ColorOrder('Green'))
      do 1030i=1,KeepNH(1)
        DrawAtName(i+1)=KeepAtH(1,i)
1030  continue
      call SetRealArrayTo(XPlane(1,1),3,0.)
      do 1040i=1,KeepNH(1)
        call AddVek(x(1,KeepNAtH(1,i)),XPlane(1,1),XPlane(1,1),3)
1040  continue
      pom=1./float(KeepNH(1))
      do 1050i=1,3
        XPlane(i,1)=XPlane(i,1)*pom
1050  continue
      call CopyVek(x(1,KeepNAtCentr(1)),xb,3)
      call atsym(KeepAtNeigh(1,1),i,xc,v,vg,ISym,ich)
      if(ich.ne.0) then
        call FeChybne(-1.,-1.,'the neighbour atom "'//
     1                KeepAtNeigh(1,1)(:idel(KeepAtNeigh(1,1)))//
     2                '" isn''t present on M40',' ',0,SeriousError)
        ErrJana=1
        go to 9999
      endif
      isw=iswa(i)
      do 1100i=1,3
        u(i)=xb(i)-xc(i)
1100  continue
      call multm(MetTens(1,isw,KPhase),u,ug,3,3,1)
      uu=scalmul(u,ug)
      pomm=2.
      do 1110i=1,3
        call SetRealArrayTo(v,3,0.)
        v(i)=1.
        call multm(MetTens(1,isw,KPhase),v,vg,3,3,1)
        uv=scalmul(u,vg)
        vv=scalmul(v,vg)
        pom=abs(uv/sqrt(uu*vv))
        if(pom.lt.pomm) then
          pomm=pom
          call CopyVek(v,xc,3)
        endif
1110  continue
      call RefMakeTrMat(u,xc,3,1,trp,trpi)
      if(KeepType(1).eq.IdKeepHTetraHed) then
        pom1=0.3333333
        pom2=0.9428090
      else
        pom1=0.5
        pom2=0.8660254
      endif
      DAngle=90.
      v(3)=pom1
      pom= pom2
      Angle=0.
      do 1150i=2,3
        v(1)=pom*cos(Angle*ToRad)
        v(2)=pom*sin(Angle*ToRad)
        call CopyVek(xb,XPlane(1,i),3)
        call cultm(trpi,v,XPlane(1,i),3,3,1)
        Angle=Angle+DAngle
1150  continue
      DeltaPlane=0.1
      ScopePlane(1)=3.
      ScopePlane(2)=3.
      ScopePlane(3)=0.
      ShiftPlane(1)=1.5
      ShiftPlane(2)=1.5
      ShiftPlane(3)=0.
9999  return
      end
      subroutine EM40RunContour(TorsAngle,ich)
      include 'params.cmn'
      include 'basic.cmn'
      include 'refine.cmn'
      include 'contour.cmn'
      include 'fepc.cmn'
      character*12 jmena(6)
      character*80 SaveFile,Veta
      dimension xdo(3),xp(3),xpo(3),xfract(3)
      integer FeGetSystemTime,TimeQuestEvent
      logical Drzi
      data jmena/'%Escape','%Apply','R%+','R%-','%Step','%Optimal'/
      ich=0
      TorsAngle=KeepAngleH(1)
      ContourQuest=NextQuestId()
      call FeQuestAbsCreate(ContourQuest,0.,0.,XMaxBasWin,YMaxBasWin,
     1                      ' ',0,0,-1,-1)
      CheckMouse=.true.
      QuestGetEdwActive(ContourQuest)=.false.
      call FeMakeGrWin(0.,40.,14.,14.)
      call FeMakeAcWin(20.,10.,10.,10.)
      pom=FeYPixRound(YMaxGrWin)
      dpom=FeYPixRound(ButYd+6.*PixelY)
      ypom=FeYPixRound(pom-dpom-2.*PixelY)
      wpom=34.
      xpom=(XMaxBasWin+XMaxGrWin-wpom)*.5
      call FeTwoPixLineHoriz(XMaxGrWin+PixelX,XMaxBasWin,pom,Gray,White)
      do 1100i=1,6
        call FeQuestAbsButtonMake(ContourQuest,xpom,ypom,
     1                            wpom,ButYd,Jmena(i))
        if(i.eq.1) then
          nButtEsc=ButtonLastMade
        else if(i.eq.2) then
          nButtApply=ButtonLastMade
          wpom=wpom/2.-2.5
        else if(i.eq.3) then
          nButtRotPlus=ButtonLastMade
          xpom=xpom+wpom+5.
          ypom=FeYPixRound(ypom+dpom)
        else if(i.eq.4) then
          nButtRotMinus=ButtonLastMade
          wpom=34.
          xpom=(XMaxBasWin+XMaxGrWin-wpom)*.5
        else if(i.eq.5) then
          nButtDefStep=ButtonLastMade
        else if(i.eq.6) then
          nButtOptimal=ButtonLastMade
        endif
        call FeQuestButtonOpen(ButtonLastMade,ButtonOff)
        if(i.eq.2) then
          ypom=FeYPixRound(ypom-6.*PixelY)
          call FeTwoPixLineHoriz(XMaxGrWin+PixelX,XMaxBasWin,ypom,
     1                           Gray,White)
          ypom=FeYPixRound(ypom-1.*PixelY)
        endif
        ypom=FeYPixRound(ypom-dpom)
1100  continue
      nButtBasTo=ButtonLastMade
      ypom=FeYPixRound(ypom+dpom-6.*PixelY)
      call FeTwoPixLineHoriz(XMaxGrWin+PixelX,XMaxBasWin,ypom,
     1                       Gray,White)
      TakeMouseMove=.true.
      call FeClearGrWin
      kpdf=1
      obecny=kpdf.gt.0
      DrawPDF=kpdf.gt.1
      isoucet=0
      smapy=.false.
      tmapy=.false.
      AtomsOn=.false.
      call NactiM81
      if(ErrJana.ne.0) go to 9000
c      call ConDefGenSection(' ',0,ich)
      call ConMakeGenSection
      if(ErrJana.ne.0) go to 9000
      call ConCalcGeneral
      if(ErrJana.ne.0) go to 9000
      do 1400i=3,6
        nxdraw(i-2)=1
        nxfrom(i-2)=1
        nxto(i-2)=nx(i)
1400  continue
      nxdraw(1)=0
      irec=-1
      irecold=-1
      reconfig=.true.
      if(xyzmap) call TrPor
      call SetTr
      call KresliMapu(0)
      call FeHeaderInfo(' ')
      do 1410i=1,2
        if(i.eq.1) then
          Veta='Density'
          xpom=XMinBasWin+5.
          ypom=YmaxBasWin-11.
          ypomt=YMaxBasWin-7.
          dpom=30.
          xpomt=xpom+dpom+3.
        else if(i.eq.2) then
          Veta='Torsion angle'
          xpom=xpom+200.
          xpomt=xpom-FeTxLength(Veta)-3.
        endif
        call FeQuestAbsLabelMake(ContourQuest,xpomt,ypomt,Veta,'L')
        call FeWinfMake(i,0,xpom,ypom,dpom,2.5*SmallFontWidth)
1410  continue
      call FeMakeAcWin(30.,10.,10.,10.)
      AngStep=.1
      do 1420i=1,2
        if(i.eq.1) then
          write(Veta,100) EM40HDensity()
        else if(i.eq.2) then
          write(Veta,101) KeepAngleH(1)
        endif
        call Zhusti(Veta)
        call FeWInfWrite(i,Veta)
1420  continue
      SaveFile='jcnt'
      if(OpSystem.le.0) call CreateTmpFile(SaveFile,i,1)
      call FeSaveImage(XMinGrWin,XMaxGrWin,YMinGrWin,YMaxGrWin,SaveFile)
2000  call FeClearGrWin
      call FeLoadImage(XMinGrWin,XMaxGrWin,YMinGrWin,YMaxGrWin,SaveFile,
     1                 2)
      call ConDrawAtoms(zmap)
      do 1600i=1,2
        if(i.eq.1) then
          write(Veta,100) EM40HDensity()
        else if(i.eq.2) then
          write(Veta,101) KeepAngleH(1)
        endif
        call Zhusti(Veta)
        call FeWInfWrite(i,Veta)
1600  continue
2500  icont=0
      call FeQuestEvent(ContourQuest,icont,ich)
      TimeQuestEvent=FeGetSystemTime()
      Drzi=.false.
      if(CheckType.eq.EventButton) then
        if(CheckNumber.eq.nButtESC.or.CheckNumber.eq.nButtApply) then
          call Del8
          call FeMakeGrWin(0.,0.,14.,0.)
          call CloseIfOpened(m8)
          if(CheckNumber.eq.nButtESC) then
            ich=1
          else
            ich=0
            TorsAngle=KeepAngleH(1)
          endif
          call FeQuestRemove(ContourQuest)
        else if(CheckNumber.eq.nButtRotPlus.or.
     1          CheckNumber.eq.nButtRotMinus) then
2600      if(CheckNumber.eq.nButtRotPlus) then
            KeepAngleH(1)=KeepAngleH(1)+AngStep
          else
            KeepAngleH(1)=KeepAngleH(1)-AngStep
          endif
2605      if(KeepAngleH(1).gt.180.) then
            KeepAngleH(1)=KeepAngleH(1)-360.
            go to 2605
          endif
2610      if(KeepAngleH(1).le.-180.) then
            KeepAngleH(1)=KeepAngleH(1)+360.
            go to 2610
          endif
          call EM40SetNewH(1)
          call FeClearGrWin
          call FeLoadImage(XMinGrWin,XMaxGrWin,YMinGrWin,YMaxGrWin,
     1                     SaveFile,2)
          call ConDrawAtoms(zmap)
          do 2620i=1,2
            if(i.eq.1) then
              write(Veta,100) EM40HDensity()
            else if(i.eq.2) then
              write(Veta,101) KeepAngleH(1)
            endif
            call Zhusti(Veta)
            call FeWInfWrite(i,Veta)
2620      continue
          call FeReleaseOutput
          call FeDeferOutput
2700      call FeEvent(1)
          i=CheckNumber+ButtonFr-1
          if(EventType.eq.0) then
            if(FeGetSystemTime()-TimeQuestEvent.lt.500) then
              go to 2700
            else
              Drzi=.true.
              go to 2600
            endif
          endif
          Drzi=.false.
          call FeQuestButtonOff(CheckNumber)
          go to 2500
        else if(CheckNumber.eq.nButtDefStep) then
          idp=NextQuestId()
          xqd=80.
          il=1
          call FeQuestCreate(idp,-1.,-1.,xqd,0,il,' ',0,LightGray,0,0)
          Veta='Angle step'
          tpom=5.
          xpom=tpom+FeTxLengthUnder(Veta)+3.
          dpom=25.
          call FeQuestEudMake(idp,tpom,1,xpom,1,Veta,'L',dpom,EdwYd,0)
          nEdwAngStep=EdwLastMade
          call FeQuestRealEdwOpen(EdwLastMade,AngStep,.false.,.false.)
          call FeQuestEudOpen(EdwLastMade,0,0,0,.1,180.,.1)
          icontp=0
3000      call FeQuestEvent(idp,icontp,ich)
          icontp=1
          if(CheckType.ne.0) then
            call NebylOsetren
            go to 3000
          endif
          if(ich.eq.0) call FeQuestRealFromEdw(nEdwAngStep,AngStep)
          call FeQuestRemove(idp)
          call FeReleaseOutput
          call FeQuestButtonOff(CheckNumber)
          go to 2000
        else if(CheckNumber.eq.nButtOptimal) then
          if(KeepType(1).eq.IdKeepHTetraHed) then
            n=1200
            KeepAngleH(1)=KeepAngleH(1)-60.
          else
            n=1800
            KeepAngleH(1)=KeepAngleH(1)-90.
          endif
          pom=-99999.
          do 3200i=1,n
            KeepAngleH(1)=KeepAngleH(1)+.1
            call EM40SetNewH(1)
            Density=EM40HDensity()
            if(Density.gt.pom) then
              pom =Density
              poma=KeepAngleH(1)
            endif
3200      continue
3205      if(poma.gt.180.) then
            poma=poma-360.
            go to 3205
          endif
3210      if(poma.le.-180.) then
            poma=poma+360.
            go to 3210
          endif
          KeepAngleH(1)=poma
          call EM40SetNewH(1)
          call FeQuestButtonOff(CheckNumber)
          go to 2000
        endif
      else if(CheckType.eq.EventMouse) then
        call GetCoord(xdo,xpo,xfract)
        AngOld=atan2(xpo(2),xpo(1))/ToRad
        if(CheckNumber.eq.JeLeftDown) then
          TakeMouseMove=.true.
3250      call FeEvent(1)
          if(EventType.eq.EventMouse) then
            if(EventNumber.eq.JeMove) then
              call GetCoord(xdo,xp,xfract)
              if(xp(1).ne.xpo(1).or.xp(2).ne.xpo(2)) then
                Ang=atan2(xp(2),xp(1))/ToRad
                call CopyVek(xp,xpo,3)
                if(Ang.ne.AngOld) then
                  KeepAngleH(1)=KeepAngleH(1)+Ang-AngOld
3255              if(KeepAngleH(1).gt.180.) then
                    KeepAngleH(1)=KeepAngleH(1)-360.
                    go to 3255
                  endif
3260              if(KeepAngleH(1).le.-180.) then
                    KeepAngleH(1)=KeepAngleH(1)+360.
                    go to 3260
                  endif
                  AngOld=Ang
                  call EM40SetNewH(1)
                  call FeClearGrWin
                  call FeLoadImage(XMinGrWin,XMaxGrWin,YMinGrWin,
     1                             YMaxGrWin,SaveFile,2)
                  call ConDrawAtoms(zmap)
                  do 3270i=1,2
                    if(i.eq.1) then
                      write(Veta,100) EM40HDensity()
                    else if(i.eq.2) then
                      write(Veta,101) KeepAngleH(1)
                    endif
                    call Zhusti(Veta)
                    call FeWInfWrite(i,Veta)
3270              continue
                  call FeReleaseOutput
                  call FeDeferOutput
                endif
                go to 3250
              endif
            else if(EventNumber.eq.JeLeftUp) then
              TakeMouseMove=.false.
              go to 2500
            endif
          else
            go to 3250
          endif
        endif
        TakeMouseMove=.false.
        go to 2500
      else if(CheckType.ne.0) then
        call NebylOsetren
        go to 2500
      endif
      go to 9999
9000  call FeQuestRemove(ContourQuest)
      ErrJana=0
      ich=1
9999  return
100   format(f8.3)
101   format(f8.1)
      end
      function EM40HDensity()
      include 'params.cmn'
      include 'basic.cmn'
      include 'atoms.cmn'
      include 'refine.cmn'
      include 'contour.cmn'
      dimension xp(3)
      EM40HDensity=0.
      do 2000i=1,KeepNH(1)
        ia=KeepNAtH(1,i)
        call prevod(0,x(1,ia),xp)
        EM40HDensity=EM40HDensity+ExtMap(xp(1),xp(2),table)
2000  continue
      return
      end
      subroutine EM40SetNewH(n)
      include 'params.cmn'
      include 'basic.cmn'
      include 'atoms.cmn'
      include 'refine.cmn'
      include 'editm40.cmn'
      dimension u(3),ug(3),v(3),vg(3),dt(3),nd(3),nt(3),tt(3),xp(3),
     1          x4(3),
     2          xb(3),uxb(3,mxw),uyb(3,mxw),x40b(3),RMiib(9),xbm(3),
     3          xh(3,3),uxh(3,mxw,3),uyh(3,mxw,3),
     4          xc(3,0:5),uxc(3,mxw,0:5),uyc(3,mxw,0:5),x40c(3,0:5),
     5          xcm(3,0:5),
     6          RMiic(9,0:5),ic(0:5),
     7          rx((mxw+1)*(2*mxw+1)),px(2*mxw+1,3,3),dr(2*mxw+1),
     8          tt0(3)
      logical EqIgCase
      equivalence (xb,xc(1,0)),(uxb,uxc(1,1,0)),(uyb,uyc(1,1,0)),
     1            (x40b,x40c(1,0)),(RMiib,RMiic(1,0)),(ib,ic(0)),
     2            (xbm,xcm(1,0))
      KPhaseIn=KPhase
      call EM40GetXFromAtName(KeepAtCentr(n),ib,xb,uxb,uyb,x40b,RMiib,
     1                        ich)
      if(ich.ne.0) go to 9999
      ksw=kswa(ib)
      call RestorePhase(ksw)
      isw=iswa(ib)
      if(KeepType(n).eq.IdKeepHTetraHed) then
        NAtMax=4
      else if(KeepType(n).eq.IdKeepHTriangl) then
        NAtMax=3
      else if(KeepType(n).eq.IdKeepHApical) then
        NAtMax=6
      endif
      if((KeepType(n).eq.IdKeepHTetraHed.and.KeepNH(n).eq.3).or.
     1   (KeepType(n).eq.IdKeepHTriangl .and.KeepNH(n).eq.2)) then
        call EM40GetXFromAtName(KeepAtNeigh(n,1),ic(1),xc(1,1),
     1               uxc(1,1,1),uyc(1,1,1),x40c(1,1),RMiic(1,1),ich)
        if(ich.ne.0) go to 9999
        if(KeepNNeigh(n)+KeepNH(n).gt.NAtMax) then
          call EM40GetXFromAtName(KeepAtAnchor(n),ic(2),xc(1,2),
     1                  uxc(1,1,2),uyc(1,1,2),x40c(1,2),RMiic(1,2),ich)
          if(ich.ne.0) go to 9999
          natc=2
        else
          if(EqIgCase(KeepAtAnchor(n),'#unknown#')) then
            dpom=2.
1100        call DistFromAtom(KeepAtNeigh(n,1),dpom,isw)
            do 1110i=1,NDist
              k=ipord(i)
              if(.not.EqIgCase(adist(k),KeepAtCentr(n))) then
                j=idel(SymCodeJanaDist(k))
                KeepAtAnchor(n)=adist(k)
                if(j.gt.0)
     1            KeepAtAnchor(n)=
     2              KeepAtAnchor(n)(:idel(KeepAtAnchor(n)))//'#'//
     3              SymCodeJanaDist(k)(:idel(SymCodeJanaDist(k)))
                call EM40GetXFromAtName(KeepAtAnchor(n),ic(2),xc(1,2),
     1                  uxc(1,1,2),uyc(1,1,2),x40c(1,2),RMiic(1,2),ich)
                if(ich.ne.0) go to 9999
                if(isf(ic(2)).eq.isfh) go to 1110
                natc=2
                KeepAngleH(n)=180.
                go to 1130
              endif
1110        continue
            if(dpom.lt.3.) then
              dpom=dpom+.2
              go to 1100
            endif
            do 1115i=1,3
              u(i)=xc(i,1)-xb(i)
1115        continue
            call multm(MetTens(1,isw,KPhase),u,ug,3,3,1)
            uu=scalmul(u,ug)
            pomm=2.
            do 1120i=1,3
              call SetRealArrayTo(v,3,0.)
              v(i)=1.
              call multm(MetTens(1,isw,KPhase),v,vg,3,3,1)
              uv=scalmul(u,vg)
              vv=scalmul(v,vg)
              pom=abs(uv/sqrt(uu*vv))
              if(pom.lt.pomm) then
                pomm=pom
                call AddVek(v,xc(1,1),xc(1,2),3)
                KeepAtAnchor(n)='#000#'
                KeepAtAnchor(n)(i+1:i+1)='1'
              endif
1120        continue
            natc=2
            go to 1130
          else
            if(KeepAtAnchor(n).eq.'#asitis') then
              KeepAngleH(n)=0.
              call EM40GetXFromAtName(KeepAtH(n,1),ic(3),xc(1,3),
     1                  uxc(1,1,3),uyc(1,1,3),x40c(1,3),RMiic(1,3),ich)
              if(ich.ne.0) go to 9999
              do 1122i=1,3
                xc(i,2)=xc(i,3)-xb(i)+xc(i,1)
1122          continue
              ic(2)=0
              natc=3
            else if(KeepAtAnchor(n)(1:1).eq.'#') then
              j=2
              do 1125i=2,4
                if(KeepAtAnchor(n)(i:i).eq.'0') then
                  v(i-1)=0.
                else
                  v(i-1)=1.
                endif
1125          continue
              call AddVek(v,xc(1,1),xc(1,2),3)
              go to 1130
            else
              call EM40GetXFromAtName(KeepAtAnchor(n),ic(2),xc(1,2),
     1                uxc(1,1,2),uyc(1,1,2),x40c(1,2),RMiic(1,2),ich)
              if(ich.ne.0) go to 9999
            endif
          endif
        endif
1130    if(ndimi.le.0) then
          call EM40AllButOneH(xb,xc(1,1),xh,KeepNH(n),KeepDistH(n),
     1                        KeepAngleH(n),isw)
          do 1400j=1,KeepNH(n)
            call CopyVek(xh(1,j),x(1,KeepNAtH(n,j)),3)
1400      continue
        endif
      else if((KeepType(n).eq.IdKeepHTetraHed.and.KeepNH(n).eq.1).or.
     1        (KeepType(n).eq.IdKeepHTriangl .and.KeepNH(n).eq.1).or.
     2        (KeepType(n).eq.IdKeepHApical)) then
        do 2200j=1,KeepNNeigh(n)
          call EM40GetXFromAtName(KeepAtNeigh(n,j),ic(j),xc(1,j),
     1                  uxc(1,1,j),uyc(1,1,j),x40c(1,j),RMiic(1,j),ich)
          if(ich.ne.0) go to 9999
2200    continue
        call EM40AddApicalH(xb,xc(1,1),KeepNNeigh(n),x(1,KeepNAtH(n,1)),
     1                      KeepDistH(n),isw)
        natc=KeepNNeigh(n)
      else if(KeepType(n).eq.IdKeepHTetraHed.and.KeepNH(n).eq.2) then
        do 2400j=1,2
          call EM40GetXFromAtName(KeepAtNeigh(n,j),ic(j),xc(1,j),
     1                  uxc(1,1,j),uyc(1,1,j),x40c(1,j),RMiic(1,j),ich)
          if(ich.ne.0) go to 9999
2400    continue
        call EM40TetraAdd2H(xb,xc(1,1),xh,KeepDistH(n),isw)
        do 2500j=1,2
          call CopyVek(xh(1,j),x(1,KeepNAtH(n,j)),3)
2500    continue
        natc=2
      endif
      if(ndimi.le.0) go to 9000
      kmodmn=kmodx(ic(0))
      do 3010i=1,natc
        if(ic(i).ne.0) kmodmn=min(kmodx(ic(i)),kmodmn)
3010  continue
      ntmx=1
      do 3020i=1,3
        if(i.le.ndimi) then
          if(kcommen.le.0) then
            nt(i)=(6*kmodmx+3)*10
          else
            nt(i)=(ngc+1)*NCommenProduct(isw,KPhase)
          endif
          dt(i)=1./float(nt(i))
        else
          nt(i)=1
          dt(i)=0
        endif
        ntmx=ntmx*nt(i)
3020  continue
      nx=2*kmodmn+1
      if(KCommen.gt.0) nx=min(nx,ntmx)
      call SetRealArrayTo(rx,(nx*(nx+1))/2,0.)
      call SetRealArrayTo(px,(2*mxw+1)*9,0.)
      if(KCommen.gt.0) then
        call CopyVek(trez(1,1,KPhase),tt0,ndimi)
      else
        call SetRealArrayto(tt0,ndimi,0.)
      endif
      do 4000it=1,ntmx
        call RecUnpack(it,nd,nt,ndimi)
        do 3060i=1,ndimi
          tt(i)=(nd(i)-1)*dt(i)+tt0(i)
3060    continue
        do 3300j=0,natc
          ia=ic(j)
          call CopyVek(xc(1,j),xcm(1,j),3)
          if(ia.le.0) go to 3300
          call CopyVek(x40c(1,j),x4,ndimi)
          call cultm(Rmiic(1,j),tt,x4,ndimi,ndimi,1)
          if(kmods(ia).gt.0) then
            if(kfs(ia).eq.0) then
              occ=a0(ia)
              do 3100kk=1,kmods(ia)
                arg=0.
                do 3080i=1,ndimi
                  arg=arg+x4(i)*float(kw(i,kk,ksw))
3080            continue
                arg=pi2*arg
                occ=occ+ax(kk,ia)*sin(arg)+ay(kk,ia)*cos(arg)
3100          continue
            else
              kk=kmods(ia)-ndimi
              do 3150k=1,ndimi
                kk=kk+1
                x4p=x4(k)-ax(kk,ia)
                ix4p=x4p
                if(x4p.lt.0.) ix4p=ix4p-1
                x4p=x4p-float(ix4p)
                if(x4p.gt..5) x4p=x4p-1.
                if(ndimi.eq.1) then
                  delta=a0(ia)*.5
                else
                  delta=ay(kk,ia)
                endif
                if(x4p.ge.-delta.and.x4p.le.delta) then
                  occ=1.
                else
                  occ=0.
                  go to 4000
                endif
3150          continue
            endif
            if(occ.lt..01) go to 4000
          endif
          if(j.eq.0) dr(1)=1.
          k=1
          do 3260kk=1,kmodx(ia)
            if(kk.lt.kmodx(ia).or.kfx(ia).eq.0) then
              arg=0.
              do 3250i=1,ndimi
                arg=arg+x4(i)*float(kw(i,kk,ksw))
3250          continue
              arg=pi2*arg
              sna=sin(arg)
              csa=cos(arg)
              do 3255i=1,3
                xcm(i,j)=xcm(i,j)+Uxc(i,kk,j)*sna+Uyc(i,kk,j)*csa
3255          continue
              if(j.eq.0) then
                k=k+1
                dr(k)=sna
                k=k+1
                dr(k)=csa
              endif
            else
              x4p=x4(1)-Uyc(1,kk,j)
              ix4p=x4p
              if(x4p.lt.0.) ix4p=ix4p-1
              x4p=x4p-float(ix4p)
              if(x4p.gt..5) x4p=x4p-1.
              znak=2.*x4p/Uyc(2,kk,j)
              do 3258i=1,3
                xcm(i,j)=xcm(i,j)+znak*Uxc(i,kk,j)
3258          continue
c              SinArgN(kk,j)=znak
c              CosArgN(kk,j)=0.
            endif
3260      continue
3300    continue
        if((KeepType(n).eq.IdKeepHTetraHed.and.KeepNH(n).eq.3).or.
     1     (KeepType(n).eq.IdKeepHTriangl .and.KeepNH(n).eq.2)) then
          if(KeepNNeigh(n)+KeepNH(n).le.NAtMax) then
            if(EqIgCase(KeepAtAnchor(n),'#unknown#')) then
              go to 9999
            else
              if(KeepAtAnchor(n).eq.'#asitis') then
                do 3400i=1,3
                  xcm(i,2)=xcm(i,3)-xbm(i)+xcm(i,1)
3400            continue
              else if(KeepAtAnchor(n)(1:1).eq.'#') then
              else
              endif
            endif
          endif
          call EM40AllButOneH(xbm,xcm(1,1),xh,KeepNH(n),KeepDistH(n),
     1                        KeepAngleH(n),isw)
        else if(KeepType(n).eq.IdKeepHTetraHed.and.KeepNH(n).eq.2) then
          call EM40TetraAdd2H(xbm,xcm(1,1),xh,KeepDistH(n),isw)
        else if((KeepType(n).eq.IdKeepHTetraHed.and.KeepNH(n).eq.1).or.
     1          (KeepType(n).eq.IdKeepHTriangl .and.KeepNH(n).eq.1).or.
     2          (KeepType(n).eq.IdKeepHApical)) then
          call EM40AddApicalH(xbm,xcm(1,1),KeepNNeigh(n),xh,
     1                        KeepDistH(n),isw)
        endif
        l=0
        do 3530i=1,nx
          do 3510k=1,KeepNH(n)
            do 3500j=1,3
              px(i,j,k)=px(i,j,k)+xh(j,k)*dr(i)
3500        continue
3510      continue
          do 3520j=1,i
            l=l+1
            rx(l)=rx(l)+dr(i)*dr(j)
3520      continue
3530    continue
4000  continue
      call smi(rx,dr,nx,ising)
      if(ising.eq.0) then
        do 4100k=1,KeepNH(n)
          nh=KeepNAtH(n,k)
          do 4050j=1,3
            call nasob(rx,px(1,j,k),dr,nx)
            x(j,nh)=dr(1)
            l=1
            do 4030kk=1,kmodx(nh)
              l=l+1
              ux(j,kk,nh)=dr(l)
              l=l+1
              if(l.le.nx) then
                uy(j,kk,nh)=dr(l)
              else
                uy(j,kk,nh)=0.
              endif
4030        continue
4050      continue
          call qbyx(x(1,nh),xp,isw)
          do 4060kk=1,kmodx(nh)
            if(kk.eq.kmodx(nh).and.kfx(nh).ne.0) then
              uy(1,kk,nh)=uy(1,kk,nh)+xp(1)-qcnt(1,ib)
            else
              fik=0.
              do 4052m=1,ndimi
                fik=fik+(xp(m)-qcnt(m,ib))*float(kw(m,kk,KPhase))
4052          continue
              sinfik=sin(pi2*fik)
              cosfik=cos(pi2*fik)
              do 4055l=1,3
                xpom=ux(l,kk,nh)
                ypom=uy(l,kk,nh)
                ux(l,kk,nh)= xpom*cosfik+ypom*sinfik
                uy(l,kk,nh)=-xpom*sinfik+ypom*cosfik
4055          continue
            endif
4060      continue
4100    continue
      else
        go to 9000
      endif
9000  call RestorePhase(KPhaseIn)
9999  return
      end
      subroutine EM40AllButOneH(xb,xc,xh,n,DistH,AngleH,isw)
      include 'params.cmn'
      include 'basic.cmn'
      dimension xb(3),xc(3,*),xh(3,*),trp(3,3),trpi(9)
      dimension u(3),ug(3),v(3),vg(3),w(3),wg(3)
      do 1100i=1,3
        u(i)=xb(i)-xc(i,1)
1100  continue
      do 1140i=1,3
        v(i)=xc(i,2)-xc(i,1)
1140  continue
1150  call RefMakeTrMat(u,v,3,1,trp,trpi)
      if(n.eq.3) then
        pom1=0.3333333
        pom2=0.9428090
        DAngle=120.
      else
        pom1=0.5
        pom2=0.8660254
        DAngle=180.
      endif
      w(3)= pom1*DistH
      pom=  pom2*DistH
      Angle=AngleH
      do 1200i=1,n
        w(1)=pom*cos(Angle*ToRad)
        w(2)=pom*sin(Angle*ToRad)
        call CopyVek(xb,xh(1,i),3)
        call cultm(trpi,w,xh(1,i),3,3,1)
        Angle=Angle+DAngle
1200  continue
      go to 9999
      entry EM40AddApicalH(xb,xc,n,xh,DistH,isw)
      call SetRealArrayTo(u,3,0.)
      do 2100j=1,n
        do 2000i=1,3
          v(i)=xb(i)-xc(i,j)
2000    continue
        call multm(MetTens(1,isw,KPhase),v,vg,3,3,1)
        call vecnor(v,vg)
        call AddVek(u,v,u,3)
2100  continue
      call multm(MetTens(1,isw,KPhase),u,ug,3,3,1)
      call vecnor(u,ug)
      do 2300i=1,3
        xh(i,1)=xb(i)+u(i)*DistH
2300  continue
      go to 9999
      entry EM40TetraAdd2H(xb,xc,xh,DistH,isw)
      do 3000i=1,3
        u(i)=xc(i,1)-xb(i)
        v(i)=xc(i,2)-xb(i)
3000  continue
      call multm(MetTens(1,isw,KPhase),u,ug,3,3,1)
      call vecnor(u,ug)
      call multm(MetTens(1,isw,KPhase),v,vg,3,3,1)
      call vecnor(v,vg)
      call VecMul(u,v,wg)
      call multm(MetTensI(1,isw,KPhase),wg,w,3,3,1)
      call vecnor(w,wg)
      do 3100i=1,3
        v(i)=-v(i)-u(i)
3100  continue
      call multm(MetTens(1,isw,KPhase),v,vg,3,3,1)
      call vecnor(v,vg)
      pom1=-1./(3.*scalmul(u,vg))
      pom2=sqrt(1.-pom1**2)
      do 3200j=1,2
        do 3150i=1,3
          xh(i,j)=xb(i)+(v(i)*pom1+w(i)*pom2)*DistH
3150    continue
        call RealVectorToOpposite(w,w,3)
3200  continue
9999  return
      end
      subroutine EM40GetXFromAtName(AtName,ia,XAt,UxAt,UyAt,x40,RmiiAt,
     1                              ich)
      include 'params.cmn'
      include 'basic.cmn'
      include 'atoms.cmn'
      include 'molec.cmn'
      dimension XAt(3),dsym(6),xp(6),RmAt(9),Rm6At(36),RMiiAt(9),ic(3),
     1          xpp(6),x40(3),UxAt(3,*),UyAt(3,*)
      character*(*) AtName
      if(ndimi.gt.0) then
        call AtomSymCode(AtName,ia,ISym,ICentr,dsym,ic,ich)
        if(ich.eq.0) then
          call SetRealArrayTo(UxAt,kmodx(ia)*3,0.)
          call SetRealArrayTo(UyAt,kmodx(ia)*3,0.)
          call SetRealArrayTo(x40,ndimi,0.)
          call UnitMat(RMiiAt,ndimi)
        endif
      else
        call atsym(AtName,ia,XAt,dsym,xp,ISym,ich)
      endif
      if(ich.eq.0) then
        ksw=kswa(ia)
        isw=iswa(ia)
      endif
      if(ich.ne.0) then
        if(nmolc.gt.0) then
          ia=ktat(atom(mxa+1),nacb,AtName)
          if(ia.gt.0) then
            ia=mxa+ia
            call CopyVek(x(1,ia),XAt,3)
            call CopyVek(ux(1,1,ia),UxAt,3*kmodx(ia))
            call CopyVek(uy(1,1,ia),UyAt,3*kmodx(ia))
            call CopyVek(qcnt(1,ia),x40,ndimi)
            call UnitMat(RMiiAt,ndimi)
            ich=0
          else
            go to 9999
          endif
        else
          go to 9999
        endif
      else if(ndimi.gt.0) then
        j=iabs(ISym)
        call CopyMat(rm(1,j,isw,ksw),RmAt,3)
        call CopyMat(rm6(1,j,isw,ksw),Rm6At,ndim)
        if(ISym.lt.0) then
          call RealMatrixToOpposite(RmAt,RmAt,3)
          call RealMatrixToOpposite(Rm6At,Rm6At,ndim)
        endif
        if(ndimi.gt.0) call GetGammaIntInv(isym,isw,ksw,RmiiAt)
        call CopyVek(x(1,ia),xp,3)
        call SetRealArrayTo(xp(4),ndimi,0.)
        call multm(Rm6At,xp,xpp,ndim,ndim,1)
        call AddVek(xpp,dsym,xp,ndim)
        call CopyVek(xp,XAt,3)
        call qbyx(dsym,xp,isw)
        do 2030j=1,ndimi
          xp(j)=xp(j)-dsym(j+3)
2030    continue
        call CopyVek(qcnt(1,ia),x40,ndimi)
        call cultm(RMiiAt,xp,x40,ndimi,ndimi,1)
        do 2040j=1,kmodx(ia)
          call multm(RmAt,ux(1,j,ia),UxAt(1,j),3,3,1)
          call multm(RmAt,uy(1,j,ia),UyAt(1,j),3,3,1)
2040    continue
      endif
9999  return
      end
      subroutine ZmKi(ich)
      include 'params.cmn'
      include 'basic.cmn'
      include 'atoms.cmn'
      include 'molec.cmn'
      include 'editm40.cmn'
      dimension kmodai(7),nmen(3)
      character*80 t80,t80p
      character*35 men(3)
      character*2 nty
      character*1 t1
      integer FeMenuNew,PrvKi,DlkKi
      data men/'%Scale(s) and extinction parameters',
     1         '%Atomic parameters',
     2         '%Molecular (rigid-body) parameters'/
      ich=0
      call SetIntArrayTo(nmen,3,1)
      if(nmolc.le.0) nmen(3)=0
      kam=FeMenuNew(-1.,-1.,men,nmen,1,3,2,0)
      if(kam.eq.1) then
        write(t80p,FormA1)('c',j=1,mxscutw)
        call kist(kis,mxscutw,t80p,'scale(s)',*9000)
        call kist(kie(1,1,1),6,'eeeeee','rho/lambda',*9000)
        call kist(kie(1,2,1),6,'eeeeee','g',*9000)
      else if(kam.eq.2) then
1000    call DefGroup(i1,i2,0)
        if(i1.le.0) then
          ich=1
          return
        endif
        itfi=itf(i1)
        do 1020i=1,7
          kmodai(i)=kmoda(i1,i)
1020    continue
        kmodxi=kmodx(i1)
        kmodbi=kmodb(i1)
        do 1100i=i1+1,i2
          if((i.gt.nacAll.and.i.le.mxa).or..not.AtBrat(i)) go to 1100
          if(itfi.ne.itf(i)) go to 1050
          do 1030j=1,itfi+1
            if(kmodai(j).ne.kmoda(i,j)) go to 1050
1030      continue
          go to 1100
1050      call FeChybne(-1.,-1.,'group of atoms has different set of '
     1                   //'parameters','try again',0,SeriousError)
          go to 1000
1100    continue
        PrvKi=PrvniKiAtomu(i1)
        call kist(ki(PrvKi),10,'oxyztttttt','Basic parameters',*9000)
        t80='Anharmonic tensor ... order'
        l=PrvKi+10
        t1='B'
        do 1200i=3,itfi
          t1=char(ichar(t1)+1)
          nrank=TRank(i)
          write(t80(18:21),100) i,nty(i)
          write(t80p,FormA1)(t1,j=1,nrank)
          call kist(ki(l),nrank,t80p,t80,*9000)
          l=l+nrank
1200    continue
        if(kmodai(1).gt.0) then
          call kist(ki(l),1,'o','Occupational modulation '//
     1              'absolute term',*9000)
          t80='.... harmonics - occupational modulation'
          l=l+1
          do 1210j=1,kmodai(1)
            write(t80(1:4),100) j,nty(j)
            call kist(ki(l),2,'sc',t80,*9000)
            l=l+2
1210      continue
        endif
        t80='.... harmonics - positional modulation'
        do 1300j=1,kmodai(2)
          write(t80(1:4),100) j,nty(j)
          call kist(ki(l),6,'sssccc',t80,*9000)
          l=l+6
1300    continue
        t80='.... harmonics - modulation of'
        do 2000i=2,itfi
          nrank=TRank(i)
          if(i.eq.2) then
            t80(32:)='ADP harmonic parameters'
          else
            write(t80(32:),'(i1,a2,'' order ADP'')') i,nty(i)
          endif
          do 1500j=1,kmodai(i+1)
            write(t80(:4),'(i2,a2)') j,nty(j)
            write(t80p,FormA1)('s',k=1,nrank)
            call kist(ki(l),nrank,t80p,t80,*9000)
            l=l+nrank
            write(t80p,FormA1)('c',k=1,nrank)
            call kist(ki(l),nrank,t80p,t80,*9000)
            l=l+nrank
1500      continue
2000    continue
        do 2100i=1,itfi+1
          if(kmodai(i).gt.0) then
            call kist(ki(l),1,'p','Phason',*9000)
            go to 2200
          endif
2100    continue
2200    DlkKi=DelkaKiAtomu(i1)-1
        do 4000i=i1+1,i2
          if(i.gt.nacAll.and.i.le.mxa) go to 4000
          if(.not.AtBrat(i)) go to 4000
          l=PrvniKiAtomu(i)
          do 3500j=PrvKi,PrvKi+DlkKi
            ki(l)=ki(j)
            l=l+1
3500      continue
4000    continue
      else if(kam.eq.3) then
        do 6010i=1,MaxMolPos
          isfn(i)=0
6010    continue
6020    call SelAtoms('Select molecule',MolMenu,AtBrat,isfn,MaxMolPos,
     1                .true.,ich)
        if(ich.ne.0) return
        k=0
        i1=0
        do 6100i=1,nmolc
          do 6050j=1,mam(i)
            k=k+1
            if(.not.AtBrat(k)) go to 6050
            ji=j+(i-1)*mxp
            if(i1.eq.0) then
              i1=ji
              kmodsi=kmodsm(ji)
              kmodxi=kmodxm(ji)
              kmodbi=kmodbm(ji)
              ktlsi=ktls(i)
            else
              if((ktlsi.le.0.and.ktls(i).gt.0).or.
     1          (ktlsi.gt.0.and.ktls(i).le.0).or.
     2          kmodsi.ne.kmodsm(ji).or.kmodxi.ne.kmodxm(ji).or.
     3          kmodbi.ne.kmodbm(i)) then
                call FeChybne(-1.,-1.,'group of molecules has different'
     1                      //' set of parameters','try again',0,
     2                        SeriousError)
                go to 6020
              endif
            endif
6050      continue
6100    continue
        PrvKi=PrvniKiMolekuly(i1)
        l=PrvKi
        call kist(ki(l),7,'opcpxyz','Molecular parameters',*9000)
        l=l+7
        if(ktlsi.ne.0) then
          call kist(ki(l),6,'TTTTTT','Tensor T',*9000)
          l=l+6
          call kist(ki(l),6,'LLLLLL','Tensor L',*9000)
          l=l+6
          call kist(ki(l),9,'SSSSSSSSS','Tensor S',*9000)
          l=l+9
        endif
        if(kmodsi.gt.0) then
          call kist(ki(l),1,'o','the absolute term of the '//
     1              'occupational modulation',*9000)
          t80='.... harmonics - occupational modulation'
          l=l+1
          do 6200j=1,kmodsi
            write(t80(1:4),100) j,nty(j)
            call kist(ki(l),2,'sc',t80,*9000)
            l=l+2
6200      continue
        endif
        t80='.... harmonics - translation'
        do 6300j=1,kmodxi
          write(t80(1:4),100) j,nty(j)
          call kist(ki(l),6,'sssccc',t80,*9000)
          l=l+6
6300    continue
        t80='.... harmonics - rotation'
        do 6400j=1,kmodxi
          write(t80(1:4),100) j,nty(j)
          call kist(ki(l),6,'sssccc',t80,*9000)
          l=l+6
6400    continue
        t80='.... harmonics - T tensor'
        do 6500j=1,kmodbi
          write(t80(1:4),100) j,nty(j)
          call kist(ki(l),6,'ssssss',t80,*9000)
          l=l+6
          call kist(ki(l),6,'cccccc',t80,*9000)
          l=l+6
6500    continue
        t80='.... harmonics - L tensor'
        do 6600j=1,kmodbi
          write(t80(1:4),100) j,nty(j)
          call kist(ki(l),6,'ssssss',t80,*9000)
          l=l+6
          call kist(ki(l),6,'cccccc',t80,*9000)
          l=l+6
6600    continue
        t80='.... harmonics - S tensor'
        do 6700j=1,kmodbi
          write(t80(1:4),100) j,nty(j)
          call kist(ki(l),9,'sssssssss',t80,*9000)
          l=l+9
          call kist(ki(l),9,'ccccccccc',t80,*9000)
          l=l+9
6700    continue
        if(kmodsi.gt.0.or.kmodxi.gt.0.or.kmodbi.gt.0) then
          call kist(ki(l),1,'p','Phason',*9000)
        endif
        k=0
        DlkKi=DelkaKiMolekuly(i1)-1
        do 8000i=1,nmolc
          do 7500ip=1,mam(i)
            k=k+1
            if(.not.AtBrat(k)) go to 7500
            ji=ip+mxp*(i-1)
            l=PrvniKiMolekuly(ji)
            do 7000j=PrvKi,PrvKi+DlkKi
              ki(l)=ki(j)
              l=l+1
7000        continue
7500      continue
8000    continue
      endif
      go to 9999
9000  ich=1
9999  return
100   format(i2,a2)
      end
      subroutine kist(ki,n,text1,text2,*)
      include 'params.cmn'
      include 'basic.cmn'
      include 'fepc.cmn'
      dimension ki(n)
      character*(*) text1,text2
      xd=FeTxLength(Text2)+10.
      xpom=FeTxLength(Text1)+18.
      xd=max(xd,xpom,80.)
      id=NextQuestId()
      call FeQuestCreate(id,-1.,-1.,xd,0,2,Text2,0,LightGray,0,0)
      call FeQuestEdwMake(id,9.+(xd-xpom)*.5,1,5.+(xd-xpom)*.5,2,Text1,
     1                    'L',xpom-10.,EdwYd,1)
      write(EdwString(EdwFr),100)(ki(i),i=1,n)
      call FeQuestStringEdwOpen(1,EdwString(EdwFr))
      icont=0
1500  call FeQuestEvent(id,icont,ich)
      icont=1
      if(CheckType.eq.EventEdw.or.CheckNumber.eq.1) then
        read(EdwString(EdwFr),100,err=1530)(ki(i),i=1,n)
        go to 1500
1530    call FeChybne(-1.,30.,'incorrect integer string, try again',' ',
     1                0,SeriousError)
        EventType=EventEdw
        EventNumber=1
        go to 1500
      else if(CheckType.ne.0) then
        call NebylOsetren
        go to 1500
      endif
      call FeQuestRemove(id)
      if(ich.eq.0) then
        return
      else
        return1
      endif
100   format(50i1)
      end
      subroutine ZmAtM(ich)
      include 'params.cmn'
      include 'basic.cmn'
      include 'editm40.cmn'
      include 'atoms.cmn'
      include 'molec.cmn'
      dimension qrat(3)
      logical MolBrat(mxm)
      data MolBrat/mxm*.true./
      if(nmolc.gt.1) then
        call SetIntArrayTo(isfn,nmolc,0)
        call SelAtoms('Select molecule',Molname,MolBrat,isfn,nmolc,
     1                .true.,ich)
        if(ich.ne.0) go to 9999
      else
        MolBrat(1)=.true.
      endif
      ibp=mxa+1
      iap=nacAll+1
      call trortho(0)
      i=0
      do 3000im=1,nmolc
        if(.not.MolBrat(im)) go to 2900
        call SelAtoms('Select atoms from molecular part '//molname(im),
     1                Atom(ibp),AtBrat(ibp),isf(ibp),iam(im),.true.,ich)
        if(ich.ne.0) go to 9999
        do 2000id=0,iam(im)-1
          ia=iap+id
          ib=ibp+id
          if(.not.AtBrat(ib)) go to 2000
          do 1900j=1,kpoint(im)
            isf(ib)=0
            do 1800ji=1,mam(im)
              kmol(ia)=0
              kator(ia)=0
              call qbyx(x(1,ia),qrat,iswa(ia))
              kk=0
              do 1500k=1,kmods(ia)
                if(k.gt.kmods(ia)-ndimi.and.kfs(ia).ne.0) then
                  kk=kk+1
                  ax(k,ia)=ax(k,ia)+qrat(kk)-qcnt(kk,ia)
                else
                  fik=0.
                  do 1100m=1,ndimi
                    fik=fik+(qrat(m)-qcnt(m,ia))*float(kw(m,k,KPhase))
1100              continue
                  sinfik=sin(pi2*fik)
                  cosfik=cos(pi2*fik)
                  xp=ax(k,ia)
                  yp=ay(k,ia)
                  ax(k,ia)= xp*cosfik+yp*sinfik
                  ay(k,ia)=-xp*sinfik+yp*cosfik
                  sxp=sax(k,ia)**2
                  syp=say(k,ia)**2
                  sax(k,ia)=sqrt(sxp*cosfik**2+syp*sinfik**2)
                  say(k,ia)=sqrt(sxp*sinfik**2+syp*cosfik**2)
                endif
1500          continue
              do 1600k=1,kmodx(ia)
                if(k.eq.kmodx(ia).and.kfx(ia).ne.0) then
                  uy(1,k,ia)=uy(1,k,ia)+qrat(1)-qcnt(1,ia)
                else
                  fik=0.
                  do 1510m=1,ndimi
                    fik=fik+(qrat(m)-qcnt(m,ia))*float(kw(m,k,KPhase))
1510              continue
                  sinfik=sin(pi2*fik)
                  cosfik=cos(pi2*fik)
                  do 1550l=1,3
                    xp=ux(l,k,ia)
                    yp=uy(l,k,ia)
                    ux(l,k,ia)= xp*cosfik+yp*sinfik
                    uy(l,k,ia)=-xp*sinfik+yp*cosfik
                    sxp=sux(l,k,ia)**2
                    syp=suy(l,k,ia)**2
                    sux(l,k,ia)=sqrt(sxp*cosfik**2+syp*sinfik**2)
                    suy(l,k,ia)=sqrt(sxp*sinfik**2+syp*cosfik**2)
1550              continue
                endif
1600          continue
              do 1700k=1,kmodb(ia)
                fik=0.
                do 1610m=1,ndimi
                  fik=fik+(qrat(m)-qcnt(m,ia))*float(kw(m,k,KPhase))
1610            continue
                sinfik=sin(pi2*fik)
                cosfik=cos(pi2*fik)
                do 1650l=1,6
                  xp=bx(l,k,ia)
                  yp=by(l,k,ia)
                  bx(l,k,ia)= xp*cosfik+yp*sinfik
                  by(l,k,ia)=-xp*sinfik+yp*cosfik
                  sxp=sbx(l,k,ia)**2
                  syp=sby(l,k,ia)**2
                  sbx(l,k,ia)=sqrt(sxp*cosfik**2+syp*sinfik**2)
                  sby(l,k,ia)=sqrt(sxp*sinfik**2+syp*cosfik**2)
1650            continue
1700          continue
              ia=ia+iam(im)
1800        continue
            ib=ib+iam(im)
1900      continue
2000    continue
2900    iap=iap+iamn(im)*mam(im)
        ibp=ibp+iamn(im)
3000  continue
      do 3100i=nacAll+1,nacalc
        if(kswa(i).ne.KPhase) go to 3100
        isw=iswa(i)
        kam=na(1)+1+nacOff
        if(isw.gt.1) kam=kam+na(2)
        if(isw.gt.2) kam=kam+na(3)
        if(kmol(i).eq.0) then
          call atsave(i,0)
          call atsun(kam,i-1,kam+1)
          call atsave(kam,1)
          na(isw)=na(isw)+1
          nac=nac+1
          nacAll=nacAll+1
        endif
3100  continue
      i=mxa+1
3200  if(i.gt.mxa+nacb) go to 4000
      ji=kmol(i)
      if(ji.ne.0) im=(ji-1)/mxp+1
      if(isf(i).le.0) then
        call atsun(i+1,mxa+nacbAll,i)
        nacb=nacb-1
        nacbAll=nacbAll-1
        iamn(im)=iamn(im)-1
      else
        i=i+1
      endif
      go to 3200
4000  do 4100im=1,nmolc
        iam(im)=iamn(im)/kpoint(im)
4100  continue
      call delmol
      call SavePhase
      call trortho(1)
      call MergAt(1,ich)
      call setor(0,0)
9999  return
      end
      subroutine AtSave(n,klic)
      include 'params.cmn'
      include 'basic.cmn'
      include 'atoms.cmn'
      character*8 atoms
      integer DelkaKiAtomuS
      dimension kfas(7),kmodas(7),axs(mxw),ays(mxw),
     1          xs(3),uxs(3,mxw),uys(3,mxw),
     2          betas(6),bxs(6,mxw),bys(6,mxw),
     3          c3s(10),c3xs(10,mxw),c3ys(10,mxw),
     4          c4s(15),c4xs(15,mxw),c4ys(15,mxw),
     5          c5s(21),c5xs(21,mxw),c5ys(21,mxw),
     6          c6s(28),c6xs(28,mxw),c6ys(28,mxw),
     7          saxs(mxw),says(mxw),sxs(3),suxs(3,mxw),suys(3,mxw),
     8          sbetas(6),sbxs(6,mxw),sbys(6,mxw),
     9          sc3s(10),sc3xs(10,mxw),sc3ys(10,mxw),
     a          sc4s(15),sc4xs(15,mxw),sc4ys(15,mxw),
     1          sc5s(21),sc5xs(21,mxw),sc5ys(21,mxw),
     2          sc6s(28),sc6xs(28,mxw),sc6ys(28,mxw),
     3          kias(mxdam),
     4          popass(64)
      equivalence (scrar(1),xs),(scrar(4),betas),(scrar(10),c3s),
     1            (scrar(20),c4s),(scrar(35),c5s),(scrar(56),c6s),
     2            (scrar(101),sxs),(scrar(104),sbetas),(scrar(110),sc3s)
     3           ,(scrar(120),sc4s),(scrar(135),sc5s),(scrar(156),sc6s),
     4            (scrar(201),isfs),(scrar(202),itfs),(scrar(203),iswas)
     5           ,(scrar(204),kmols),(scrar(205),kators),
     6            (scrar(206),kfas),(scrar(213),kmodas),
     7            (scrar(220),ais),(scrar(221),sais),
     8            (scrar(222),popcs,a0s),(scrar(223),spopcs,sa0s),
     9            (scrar(224),popvs,phfs),(scrar(225),spopvs,sphfs),
     a            (scrar(226),DelkaKiAtomuS),(scrar(227),ifrs),
     1            (scrar(227),lasmaxs),(scrar(228),atoms),
     1            (scrar(301),kapa1s,axs),(scrar(301+mxw),kapa2s,ays),
     2            (scrar(301+2*mxw),uxs),
     2            (scrar(301+5*mxw),uys),
     3            (scrar(301+8*mxw),bxs),(scrar(301+14*mxw),bys),
     4            (scrar(301+20*mxw),c3xs),(scrar(301+30*mxw),c3ys),
     5            (scrar(301+40*mxw),c4xs),(scrar(301+55*mxw),c4ys),
     6            (scrar(301+70*mxw),c5xs),(scrar(301+91*mxw),c5ys),
     7            (scrar(301+112*mxw),popass,c6xs),
     7            (scrar(301+140*mxw),c6ys),
     8            (scrar(301+200*mxw),skapa1s,saxs),
     9            (scrar(301+201*mxw),skapa2s,says),
     9            (scrar(301+200*mxw),suxs),(scrar(301+200*mxw),suys),
     a            (scrar(301+200*mxw),sbxs),(scrar(301+200*mxw),sbys),
     1            (scrar(301+200*mxw),sc3xs),(scrar(301+200*mxw),sc3ys),
     2            (scrar(301+200*mxw),sc4xs),(scrar(301+200*mxw),sc4ys),
     3            (scrar(301+200*mxw),sc5xs),(scrar(301+200*mxw),sc5ys),
     4            (scrar(301+200*mxw),spopass,sc6xs),
     5            (scrar(301+200*mxw),sc6ys),
     5            (scrar(301+300*mxw),kias)
      if(klic.eq.0) then
        atoms=atom(n)
        isfs=isf(n)
        itfs=itf(n)
        ifrs=ifr(n)
        iswas=iswa(n)
        kmols=kmol(n)
        kators=kator(n)
        lasmaxs=lasmax(n)
        do 1000i=1,7
          kfas(i)=kfa(n,i)
          kmodas(i)=kmoda(n,i)
1000    continue
        ais=ai(n)
        if(kmodas(1).gt.0) then
          a0s=a0(n)
          sa0s=sa0(n)
          i=kmodas(1)
          if(i.gt.0) then
            call CopyVek(ax(1,n),axs,i)
            call CopyVek(ay(1,n),ays,i)
            call CopyVek(sax(1,n),saxs,i)
            call CopyVek(say(1,n),says,i)
          endif
        endif
        i=3
        call CopyVek(x(1,n),xs,i)
        call CopyVek(sx(1,n),sxs,i)
        i=kmodas(2)*i
        if(i.gt.0) then
          call CopyVek(ux(1,1,n),uxs,i)
          call CopyVek(uy(1,1,n),uys,i)
          call CopyVek(sux(1,1,n),suxs,i)
          call CopyVek(suy(1,1,n),suys,i)
        endif
        i=6
        call CopyVek(beta(1,n),betas,i)
        call CopyVek(sbeta(1,n),sbetas,i)
        i=kmodas(2)*i
        if(i.gt.0) then
          call CopyVek(bx(1,1,n),bxs,i)
          call CopyVek(by(1,1,n),bys,i)
          call CopyVek(sbx(1,1,n),sbxs,i)
          call CopyVek(sby(1,1,n),sbys,i)
        endif
        if(itfs.gt.2) then
          i=10
          call CopyVek(c3(1,n),c3s,i)
          call CopyVek(sc3(1,n),sc3s,i)
          i=kmodas(2)*i
          if(i.gt.0) then
            call CopyVek(c3x(1,1,n),c3xs,i)
            call CopyVek(c3y(1,1,n),c3ys,i)
            call CopyVek(sc3x(1,1,n),sc3xs,i)
            call CopyVek(sc3y(1,1,n),sc3ys,i)
          endif
          if(itfs.gt.3) then
            i=15
            call CopyVek(c4(1,n),c4s,i)
            call CopyVek(sc4(1,n),sc4s,i)
            i=kmodas(2)*i
            if(i.gt.0) then
              call CopyVek(c4x(1,1,n),c4xs,i)
              call CopyVek(c4y(1,1,n),c4ys,i)
              call CopyVek(sc4x(1,1,n),sc4xs,i)
              call CopyVek(sc4y(1,1,n),sc4ys,i)
            endif
            if(itfs.gt.4) then
              i=21
              call CopyVek(c5(1,n),c5s,i)
              call CopyVek(sc5(1,n),sc5s,i)
              i=kmodas(2)*i
              if(i.gt.0) then
                call CopyVek(c5x(1,1,n),c5xs,i)
                call CopyVek(c5y(1,1,n),c5ys,i)
                call CopyVek(sc5x(1,1,n),sc5xs,i)
                call CopyVek(sc5y(1,1,n),sc5ys,i)
              endif
              if(itfs.gt.5) then
                i=28
                call CopyVek(c6(1,n),c6s,i)
                call CopyVek(sc6(1,n),sc6s,i)
                i=kmodas(2)*i
                if(i.gt.0) then
                  call CopyVek(c6x(1,1,n),c6xs,i)
                  call CopyVek(c6y(1,1,n),c6ys,i)
                  call CopyVek(sc6x(1,1,n),sc6xs,i)
                  call CopyVek(sc6y(1,1,n),sc6ys,i)
                endif
              endif
            endif
          endif
          do 1700i=1,7
            if(kmodas(i).gt.0) then
              phfs=phf(n)
              sphfs=sphf(n)
              go to 1750
            endif
1700      continue
        endif
        if(ChargeDensities) then
          kapa1s=kapa1(n)
          kapa2s=kapa2(n)
          popcs=popc(n)
          popvs=popv(n)
          call CopyVek(popas(1,n),popass,lasmax(n)**2)
        endif
1750    DelkaKiAtomuS=DelkaKiAtomu(n)
        l=PrvniKiAtomu(n)
        do 1800k=1,DelkaKiAtomuS
          kias(k)=ki(l)
          l=l+1
1800    continue
      else
        atom(n)=atoms
        isf(n)=isfs
        itf(n)=itfs
        iswa(n)=iswas
        kmol(n)=kmols
        kator(n)=kators
        lasmax(n)=lasmaxs
        do 2000i=1,7
          kfa(n,i)=kfas(i)
          kmoda(n,i)=kmodas(i)
2000    continue
        ai(n)=ais
        if(kmodas(1).gt.0) then
          a0(n)=a0s
          sa0(n)=sa0s
          i=kmodas(1)
          if(i.gt.0) then
            call CopyVek(axs,ax(1,n),i)
            call CopyVek(ays,ay(1,n),i)
            call CopyVek(saxs,sax(1,n),i)
            call CopyVek(says,say(1,n),i)
          endif
        endif
        i=3
        call CopyVek(xs,x(1,n),i)
        call CopyVek(sxs,sx(1,n),i)
        i=kmodas(2)*i
        if(i.gt.0) then
          call CopyVek(uxs,ux(1,1,n),i)
          call CopyVek(uys,uy(1,1,n),i)
          call CopyVek(suxs,sux(1,1,n),i)
          call CopyVek(suys,suy(1,1,n),i)
        endif
        i=6
        call CopyVek(betas,beta(1,n),i)
        call CopyVek(sbetas,sbeta(1,n),i)
        i=kmodas(2)*i
        if(i.gt.0) then
          call CopyVek(bxs,bx(1,1,n),i)
          call CopyVek(bys,by(1,1,n),i)
          call CopyVek(sbxs,sbx(1,1,n),i)
          call CopyVek(sbys,sby(1,1,n),i)
        endif
        if(itfs.gt.2) then
          i=10
          call CopyVek(c3s,c3(1,n),i)
          call CopyVek(sc3s,sc3(1,n),i)
          i=kmodas(2)*i
          if(i.gt.0) then
            call CopyVek(c3xs,c3x(1,1,n),i)
            call CopyVek(c3ys,c3y(1,1,n),i)
            call CopyVek(sc3xs,sc3x(1,1,n),i)
            call CopyVek(sc3ys,sc3y(1,1,n),i)
          endif
          if(itfs.gt.3) then
            i=15
            call CopyVek(c4s,c4(1,n),i)
            call CopyVek(sc4s,sc4(1,n),i)
            i=kmodas(2)*i
            if(i.gt.0) then
              call CopyVek(c4xs,c4x(1,1,n),i)
              call CopyVek(c4ys,c4y(1,1,n),i)
              call CopyVek(sc4xs,sc4x(1,1,n),i)
              call CopyVek(sc4ys,sc4y(1,1,n),i)
            endif
            if(itfs.gt.4) then
              i=21
              call CopyVek(c5s,c5(1,n),i)
              call CopyVek(sc5s,sc5(1,n),i)
              i=kmodas(2)*i
              if(i.gt.0) then
                call CopyVek(c5xs,c5x(1,1,n),i)
                call CopyVek(c5ys,c5y(1,1,n),i)
                call CopyVek(sc5xs,sc5x(1,1,n),i)
                call CopyVek(sc5ys,sc5y(1,1,n),i)
              endif
              if(itfs.gt.5) then
                i=28
                call CopyVek(c6s,c6(1,n),i)
                call CopyVek(sc6s,sc6(1,n),i)
                i=kmodas(2)*i
                if(i.gt.0) then
                  call CopyVek(c6xs,c6x(1,1,n),i)
                  call CopyVek(c6ys,c6y(1,1,n),i)
                  call CopyVek(sc6xs,sc6x(1,1,n),i)
                  call CopyVek(sc6ys,sc6y(1,1,n),i)
                endif
              endif
            endif
          endif
          do 2700i=1,7
            if(kmodas(i).gt.0) then
              phf(n)=phfs
              sphf(n)=sphfs
              go to 2750
            endif
2700     continue
        endif
2750    call ShiftKiAt(n,itfs,ifrs,lasmaxs,kmodas(1),kmodas(2),
     1                 kmodas(3),kmodas(4),kmodas(5),kmodas(6),
     2                 kmodas(7),.false.)
        l=PrvniKiAtomu(n)
        do 2800k=1,DelkaKiAtomuS
          ki(l)=kias(k)
          l=l+1
2800    continue
      endif
      return
      end
      subroutine NewMol(ich)
      include 'params.cmn'
      include 'basic.cmn'
      include 'editm40.cmn'
      include 'atoms.cmn'
      include 'molec.cmn'
      include 'fepc.cmn'
      character*256 EdwStringQuest,FileNameM45
      character*80 Veta,atp(3),StRefPointP
      character*8 atm(3),NewMolName
      character*2 nty
      integer FeMenu,PrvKi,EdwStateQuest
      logical FeYesNo,ExistFile,FeYesNoHeader,CrwLogicQuest,k45,
     1        NewMolecule
      dimension par(6),pa(9),pb(9),pc(9),trl(9),xx(3,3),xo(3,3),
     1          xxo(3,3),paa(3),pbb(3),paav(3),pbbv(3),trp(9),xp(3,mxa),
     2          model(3),qcmol(3)
      data dco/0.3/
      if(nmolc.le.0) irot=1
      isw=1
      k45=nac.le.0
      il=6
      if(nmolc.gt.0) il=il+2
      if(.not.k45) il=il+3
      if(ncomp.gt.1) il=il+1
      FileNameM45=fln(:ifln)//'.m45'
      id=NextQuestId()
      call FeQuestCreate(id,-1.,-1.,200.,0,il,' ',1,LightGray,0,0)
      il=0
      if(nmolc.gt.0) then
        il=il+1
        tpom=55.
        xpom=51.
        do 1010i=1,2
          if(i.eq.1) then
            Veta='New %molecule'
          else
            Veta='New %position'
          endif
          call FeQuestCrwMake(id,tpom,il,xpom,il+1,Veta,'C',CrwgXd,
     1                        CrwgYd,1,1)
          if(i.eq.1) then
            nCrwNewMolecule=CrwLastMade
          else
            nCrwNewPosition=CrwLastMade
          endif
          call FeQuestCrwOpen(CrwLastMade,i.eq.1)
          xpom=xpom+90.
          tpom=tpom+90.
1010    continue
        tpom=5.
        xpom=80.
        dpom=20.
        do 1012i=1,nmolc
          dpom=max(dpom,FeTxLengthUnder(MolName(i))+10.*EdwIndSize)
1012    continue
        il=il+2
        call FeQuestEdwMake(id,tpom,il,xpom,il,
     1                      '%Name of the molecule','L',dpom,EdwYd,0)
        nEdwOldMolecule=EdwLastMade
        xpom=FeXPixRound(xpom)+FeXPixRound(dpom)+5.*PixelX
        call FeQuestUpDownMake(id,xpom,il,UpDownXd,UpDownYd,'down')
        nDownOldMolecule=UpDownLastMade
        il=il+1
        xpom=100.
        dpom=40.
        call FeQuestEdwMake(id,tpom,il,xpom,il,'Maximum coincidence '//
     1                      '%distance','L',dpom,EdwYd,0)
        nEdwMaxCoincPom=EdwLastMade
        il=il-2
      else
        nCrwNewMolecule=0
        nCrwNewPosition=0
        nEdwOldMolecule=0
        nDownOldMolecule=0
        nEdwMaxCoincPom=0
      endif
      NewMolecule=.true.
      if(nac.gt.0) then
        il=il+1
        ilK45=il
        tpom=55.
        xpom=51.
        il=il+1
        do 1020i=1,2
          if(i.eq.1) then
            Veta='Model %file'
          else
            Veta='%Atomic part'
          endif
          call FeQuestCrwMake(id,tpom,il,xpom,il+1,Veta,'C',CrwgXd,
     1                        CrwgYd,1,2)
          if(i.eq.1) then
            nCrwFromM45=CrwLastMade
          else
            nCrwFromM40=CrwLastMade
          endif
          xpom=xpom+90.
          tpom=tpom+90.
1020    continue
        il=il+1
      else
        nCrwFromM45=0
        nCrwFromM40=0
      endif
      tpom=5.
      xpom=100.
      dpom=55.
      il=il+1
      call FeQuestEdwMake(id,tpom,il,xpom,il,'%Name of the molecule',
     1                    'L',dpom,EdwYd,0)
      nEdwName=EdwLastMade
      il=il+1
      Veta='Model %filename'
      pom=tpom+FeTxLengthUnder(Veta)+5.
      dpom=xpom+dpom-pom
      call FeQuestEdwMake(id,tpom,il,pom,il,Veta,'L',dpom,EdwYd,0)
      nEdwFileNameM45=EdwLastMade
      Veta='%Browse'
      pom=pom+dpom+5.
      dpom=FeTxLengthUnder(Veta)+10.
      call FeQuestButtonMake(id,pom,il,dpom,ButYd,Veta)
      nButtBrowse=ButtonLastMade
      dpom=40.
      call FeQuestEdwMake(id,tpom,il,xpom,il,'Maximum coincidence '//
     1                    '%distance','L',dpom,EdwYd,0)
      nEdwMaxCoinc=EdwLastMade
      il=il+1
      ilRefP=il
      il=il+1
      xpom=31.
      tpom=31.+CrwgXd*.5
      do 1000i=1,3
        if(i.eq.1) then
          Veta='%Explicit'
        else if(i.eq.2) then
          Veta='%Gravity center'
        else
          Veta='Ge%om. center'
        endif
        call FeQuestCrwMake(id,tpom,il,xpom,il+1,Veta,'C',CrwgXd,CrwgYd,
     1                      1,3)
        if(i.eq.1) then
          nCrwCenterFirst=CrwLastMade
        else if(i.eq.3) then
          nCrwCenterLast=CrwLastMade
        endif
        xpom=xpom+65.
        tpom=tpom+65.
1000  continue
      il=il+2
      call FeQuestEdwMake(id,5.,il,85.,il,'%Reference point','L',80.,
     1                    EdwYd,0)
      nEdwRef=EdwLastMade
      if(ncomp.gt.1) then
        il=il+1
        call FeQuestEdwMake(id,5.,il,85.,il,'%Composite part','L',30.,
     1                      EdwYd,0)
        nEdwComp=EdwLastMade
      endif
1050  if(NewMolecule) then
        call FeQuestEdwClose(nEdwOldMolecule)
        call FeQuestUpDownClose(nDownOldMolecule)
        call FeQuestEdwClose(nEdwMaxCoincPom)
        call FeQuestStringEdwOpen(nEdwName,' ')
        if(k45) then
          call FeQuestStringEdwOpen(nEdwFileNameM45,FileNameM45)
          call FeQuestButtonOpen(nButtBrowse,ButtonOff)
        else
          call FeQuestRealEdwOpen(nEdwMaxCoinc,dco,.false.,.false.)
        endif
        call FeQuestLabelMake(id,100.,ilRefp,'Reference point','C')
        call FeQuestStringEdwOpen(nEdwRef,' ')
        nCrw=nCrwCenterFirst
        do 1052i=1,3
          call FeQuestCrwOpen(nCrw,i.eq.1)
          nCrw=nCrw+1
1052    continue
        if(nac.gt.0) then
          call FeQuestLabelMake(id,100.,ilK45,'Atoms will be read from',
     1                          'C')
        endif
        if(ncomp.gt.1) call FeQuestIntEdwOpen(nEdwComp,1,.false.)
        if(nac.gt.0) then
          do 1054i=1,2
            if(i.eq.1) then
              nCrw=nCrwFromM45
            else
              nCrw=nCrwFromM40
            endif
            call FeQuestCrwOpen(nCrw,i.eq.1.eqv.k45)
1054      continue
        endif
      else
        call FeQuestEdwClose(nEdwName)
        if(k45) then
          call FeQuestEdwClose(nEdwFileNameM45)
          call FeQuestButtonClose(nButtBrowse)
        else
          call FeQuestEdwClose(nEdwMaxCoinc)
        endif
        call FeQuestLabelRemove(id,100.,ilRefp,'Reference point','C')
        call FeQuestEdwClose(nEdwRef)
        nCrw=nCrwCenterFirst
        do 1062i=1,3
          call FeQuestCrwClose(nCrw)
          nCrw=nCrw+1
1062    continue
        if(nac.gt.0) then
          call FeQuestLabelRemove(id,100.,ilK45,
     1                            'Atoms will be read from','C')
        endif
        if(ncomp.gt.1) call FeQuestEdwClose(nEdwComp)
        do 1064i=1,2
          if(i.eq.1) then
            nCrw=nCrwFromM45
          else
            nCrw=nCrwFromM40
          endif
          call FeQuestCrwClose(nCrw)
1064    continue
        im=1
        call FeQuestStringEdwOpen(nEdwOldMolecule,MolName(im))
        call FeQuestUpDownOpen(nDownOldMolecule,UpDownOff)
        call FeQuestRealEdwOpen(nEdwMaxCoincPom,dco,.false.,.false.)
      endif
      icont=0
1100  call FeQuestEvent(id,icont,ich)
      icont=1
      if(CheckType.eq.EventButton.and.CheckNumberAbs.eq.ButtonOk) then
        if(NewMolecule) then
          NewMolName=EdwStringQuest(nEdwName)
          call zhusti(NewMolName)
          call uprat(NewMolName)
          call atcheck(NewMolName,ichp,i)
          if(ichp.ne.0.or.NewMolName.eq.' ') then
            if(ichp.eq.1.or.NewMolName.eq.' ') then
              Veta='Unacceptable symbol in the name "'//
     1             NewMolName(:idel(NewMolName))//'"'
            else if(ichp.eq.2) then
              Veta='The name "'//NewMolName(:idel(NewMolName))//
     1             '" already exists'
            endif
            call FeChybne(-1.,25.,Veta(:idel(Veta))//', try again',
     1                    ' ',0,SeriousError)
            go to 1150
          endif
          if(nac.gt.0) k45=CrwLogicQuest(nCrwFromM45)
          if(k45) then
            FileNameM45=EdwStringQuest(nEdwFileNameM45)
            if(.not.ExistFile(FileNameM45)) then
              Veta='The model file "'//FileNameM45(:idel(FileNameM45))//
     1             '" doesn''t exist, try again'
              call FeChybne(-1.,25.,Veta(:idel(Veta)),' ',0,
     1                      SeriousError)
              go to 1150
            endif
          endif
        endif
        QuestCheck(id)=0
        go to 1100
1150    EventType=EventEdw
        EventNumber=nEdwName
        call FeButtonOff(ButtonOk)
        go to 1100
      else if(CheckType.eq.EventCrw.and.
     1        CheckNumber.ge.nCrwCenterFirst.and.
     2        CheckNumber.le.nCrwCenterLast) then
        EventType=EventEdw
        i=EdwStateQuest(nEdwRef)
        if(i.ne.EdwOpened.and.CheckNumber.eq.nCrwCenterFirst) then
          call FeQuestStringEdwOpen(nEdwRef,' ')
          EventNumber=nEdwRef
        else if(CheckNumber.ne.nCrwCenterFirst) then
          call FeQuestEdwClose(nEdwRef)
          EventNumber=nEdwName
        endif
        go to 1100
      else if(CheckType.eq.EventCrw.and.
     1       (CheckNumber.eq.nCrwFromM45.or.CheckNumber.eq.nCrwFromM40))
     2  then
        EventType=EventEdw
        if(EdwStateQuest(nEdwMaxCoinc).ne.EdwOpened.and.
     1     CheckNumber.eq.nCrwFromM40) then
          call FeQuestEdwClose(nEdwFileNameM45)
          call FeQuestButtonClose(nButtBrowse)
          call FeQuestRealEdwOpen(nEdwMaxCoinc,.3,.false.,.false.)
          EventNumber=nEdwMaxCoinc
        else
          call FeQuestEdwClose(nEdwMaxCoinc)
          call FeQuestStringEdwOpen(nEdwFileNameM45,FileNameM45)
          call FeQuestButtonOpen(nButtBrowse,ButtonOff)
          EventNumber=nEdwName
        endif
        go to 1100
      else if(CheckType.eq.EventCrw.and.
     1       (CheckNumber.eq.nCrwNewMolecule.or.
     2        CheckNumber.eq.nCrwNewPosition)) then
        NewMolecule=CrwLogicQuest(nCrwNewMolecule)
        go to 1050
      else if(CheckType.eq.EventButton.and.CheckNumber.eq.nButtBrowse)
     1  then
        i=nButtBrowse
        call FeFileManager('Select model file',FileNameM45,'*.m45',0,
     1                     .true.,ich)
        if(ich.eq.0)
     1    call FeQuestStringEdwOpen(nEdwFileNameM45,FileNameM45)
        EventType=EventEdw
        EventNumber=nEdwFileNameM45
        call FeQuestButtonOff(i)
        go to 1100
      else if(CheckType.eq.EventUpDown.and.
     1        CheckNumber.eq.nDownOldMolecule) then
        imo=im
        im=FeMenu(EdwXminQuest(nEdwOldMolecule),
     1            EdwYmaxQuest(nEdwOldMolecule)-
     2            (float(nmolc)*MenuLineWidth),MolName(1),1,nmolc,1,1)
        if(im.le.0) im=imo
        call FeQuestStringEdwOpen(nEdwOldMolecule,MolName(im))
        EventType=EventEdw
        EventNumber=nEdwOldMolecule
        call FeQuestUpDownOpen(nDownOldMolecule,UpDownOff)
        go to 1100
      else if(CheckType.ne.0) then
        call NebylOsetren
        go to 1100
      endif
      if(ich.eq.0) then
        if(NewMolecule) then
          nm=1
          nk=mxa
          do 1210i=1,isw
            nm=nm+nmol(i)
            do 1205j=1,nmol(i)
              nk=nk+iamn(j)
1205        continue
1210      continue
          ktls(nm)=0
          SmbPGMol(nm)='1'
          npoint(nm)=1
          kpoint(nm)=1
          UsePGSyst(nm)=.false.
          LocPGSystAx(nm)='xy'
          LocPGSystSt(1,nm)=' 1.000000 0.000000 0.000000'
          LocPGSystSt(2,nm)=' 0.000000 1.000000 0.000000'
          np=nk+1
          do 1220i=nCrwCenterFirst,nCrwCenterLast
            if(CrwLogicQuest(i)) then
              RefPoint(nm)=i-nCrwCenterFirst
              go to 1225
            endif
1220      continue
1225      StRefPointP=EdwStringQuest(nEdwRef)
          if(ncomp.gt.1) call FeQuestIntFromEdw(nEdwComp,isw)
        else
          Veta=EdwStringQuest(nEdwOldMolecule)
          nm=ktat(MolName,nmolc,Veta)
          if(nm.lt.0.or.nm.gt.nmolc) then
            Veta='The molecule "'//Veta(:idel(Veta))//
     1           '" doesn''t exist.'
            call FeChybne(-1.,-1.,Veta,' ',0,SeriousError)
            ich=1
          else
            isw=iswmol(nm)
            mamp=mam(nm)
            iamp=iamn(nm)
            np=mxa+1
            do 1230i=1,nm-1
              np=np+iamn(i)
1230        continue
            nk=np+iamp-1
          endif
        endif
        if(.not.k45) then
          if(NewMolecule) then
            k=nEdwMaxCoinc
          else
            k=nEdwMaxCoincPom
          endif
          call FeQuestRealFromEdw(k,dco)
        endif
      endif
      call FeQuestRemove(id)
      if(ich.ne.0) go to 9999
      nap=nacoff+1
      do 1240i=1,isw-1
        nap=nap+na(i)
1240  continue
      nak=nap+na(isw)-1
      if(.not.NewMolecule) go to 4750
      call molsun(nm,nmolcAll,nm+1)
      nmol(isw)=nmol(isw)+1
      nmolc=nmolc+1
      nmolcAll=nmolcAll+1
1250  iamp=0
      if(k45) then
        isfmx=0
        call OpenFile(45,FileNameM45,'formatted','old')
        if(ErrJana.ne.0) go to 9999
        read(45,*,err=9100,end=9200) par
        do 1300i=4,6
          par(i)=cos(par(i)*torad)
1300    continue
        sng=sqrt(1.-par(6)**2)
        volume=sqrt(1.-par(4)**2-par(5)**2-par(6)**2
     1              +2.*par(4)*par(5)*par(6))
        pa(1)=par(1)
        pa(2)=0.
        pa(3)=0.
        pa(4)=par(2)*par(6)
        pa(5)=par(2)*sng
        pa(6)=0.
        pa(7)=par(3)*par(5)
        pa(8)=par(3)*(par(4)-par(5)*par(6))/sng
        pa(9)=par(3)*volume/sng
        call matinv(TrToOrtho(1,isw,KPhase),pb,pom,3)
        call multm(pb,pa,trl,3,3,3)
2000    read(45,FormA80,end=3000,err=9100) Veta
        if(Veta.eq.' ') go to 2000
        read(Veta,'(a8,i3,7x,4f9.6)') atm(1),isfp,aip,paa
2010    call zhusti(atm(1))
        call uprat(atm(1))
        call atcheck(atm(1),ich,i)
        if(ich.ne.0) then
          if(ich.eq.1) then
            Title='Unacceptable symbol - M45 atom'
          else if(ich.eq.2) then
            Title='Duplicate occurrence - M45 atom'
          endif
          id=NextQuestId()
          call FeQuestCreate(id,-1.,-1.,120.,0,1,Title,0,LightGray,0,0)
          call FeQuestEdwMake(id,5.,1,5.,1,' ','L',110.,EdwYd,0)
          call FeQuestStringEdwOpen(1,atm(1))
          icont=0
2011      call FeQuestEvent(id,icont,ich)
          icont=1
          if(CheckType.ne.0) then
            call NebylOsetren
            go to 2011
          endif
          if(ich.eq.0) atm(1)=EdwString(EdwFr)
          call FeQuestRemove(id)
          if(ich.ne.0) then
            close(45)
            go to 9900
          endif
        endif
        iamp=iamp+1
        nk=nk+1
        call atsun(nk,nacbAll,nk+1)
        nacbAll=nacbAll+1
        nacb=nacb+1
        atom(nk)=atm(1)
        isf(nk)=-isfp
        isfmx=max(isfmx,isfp)
        iswa(nk)=isw
        kswa(nk)=KPhase
        do 2015k=1,3
          kmoda(nk,k)=0
          kfa(nk,k)=0
2015    continue
        ai(nk)=aip
        sai(nk)=0.
        qcnt(1,nk)=0.
        kmol(nk)=nmolc
        call multm(trl,paa,x(1,nk),3,3,1)
        call SetRealArrayTo(sx(1,nk),3,0.)
        call SetRealArrayTo( beta(1,nk),6,0.)
        call SetRealArrayTo(sbeta(1,nk),6,0.)
        itf(nk)=1
        ifr(nk)=0
        beta(1,nk)=3.
        if(nk.eq.mxa+1) then
          if(nacalc.eq.0) then
            PrvniKiAtomu(nk)=ndoff
          else
            PrvniKiAtomu(nk)=PrvniKiAtomu(nacalc)+DelkaKiAtomu(nacalc)
          endif
        else
          PrvniKiAtomu(nk)=PrvniKiAtomu(nk-1)+DelkaKiAtomu(nk-1)
        endif
        DelkaKiAtomu(nk)=0
        call ShiftKiAt(nk,itf(nk),ifr(nk),lasmax(nk),kmods(nk),kmodx(nk)
     1                ,kmodb(nk),kmodc3(nk),kmodc4(nk),kmodc5(nk),
     2                 kmodc6(nk),.true.)
        PrvKi=PrvniKiAtomu(nk)
        call SetIntArrayTo(ki(PrvKi),DelkaKiAtomu(nk),0)
        go to 2000
3000    if(np.gt.nk) go to 9200
        do 3500i=1,isfmx
          Veta=' '
          k=1
          do 3100j=np,nk
            if(isf(j).eq.-i) then
              Veta(k:)=atom(j)
              k=idel(Veta)+2
              if(k.gt.50) then
                Veta(k:)=' ... '
                go to 3110
              endif
            endif
3100      continue
3110      if(k.le.1) go to 3500
          xpom=max(FeTxLength(Veta),
     1               FeTxLength('Specify atomic type for :'))+10.
          ypom=24.
          call FeCrLbl(1,-1.,YMaxBasWin-70.,xpom,ypom)
          call FeOutSt(-1,xpom*.5,ypom-5.,'Specify atomic type for :',
     1                 'C',Black)
          call FeOutSt(-1,xpom*.5,ypom-17.,Veta,'C',Black)
          isfp=FeMenu(-1.,YMaxBasWin-80.-float(nf)*8.,
     1                AtTypeFull(1,KPhase),1,nf,i,0)
          call FeAcLbl(1,'remove')
          do 3300j=np,nk
            if(isf(j).eq.-i) isf(j)=isfp
3300      continue
3500    continue
        call CloseIfOpened(45)
      else
        call SelAtoms('Select atoms for the molecule',Atom(nap),
     1                AtBrat(nap),isf(nap),nak-nap+1,.true.,ich)
        if(ich.ne.0) go to 9900
        do 4200i=nap,nak
          if(isf(i).le.0.or..not.AtBrat(i)) go to 4200
          iamp=iamp+1
          nk=nk+1
          call atsun(nk,nacbAll,nk+1)
          nacb=nacb+1
          nacbAll=nacbAll+1
          atom(nk)=atom(i)
          iswa(nk)=isw
          kswa(nk)=KPhase
          kmol(nk)=nmolc
          isf(nk)=isf(i)
          isf(i)=-isf(i)
          itf(nk)=itf(i)
          ifr(nk)=ifr(i)
          if(kmods(i).gt.0) then
            kmods(nk)=kmods(i)
          else
            kmods(nk)=0
          endif
          if(kmodx(i).gt.0) then
            kmodx(nk)=kmodx(i)
          else
            kmodx(nk)=0
          endif
          if(kmodb(i).gt.0) then
            kmodb(nk)=kmodb(i)
          else
            kmodb(nk)=0
          endif
          do 4005k=1,3
            kfa(nk,k)=kfa(i,k)
4005      continue
          qcnt(1,nk)=qcnt(1,i)
          ai(nk)=ai(i)
          sai(nk)=0.
          call CopyVek(x(1,i),x(1,nk),3)
          call SetRealArrayTo(sx(1,nk),3,0.)
          call CopyVek(beta(1,i),beta(1,nk),6)
          call SetRealArrayTo(sbeta(1,nk),6,0.)
          k=kmods(i)
          if(k.gt.0) then
            a0(nk)=a0(i)
            sa0(nk)=0.
            call CopyVek(ax(1,i),ax(1,nk),k)
            call CopyVek(ay(1,i),ay(1,nk),k)
            call SetRealArrayTo(sax(1,nk),k,0.)
            call SetRealArrayTo(say(1,nk),k,0.)
          endif
          k=3*kmodx(i)
          call CopyVek(ux(1,1,i),ux(1,1,nk),k)
          call CopyVek(uy(1,1,i),uy(1,1,nk),k)
          call SetRealArrayTo(sux(1,1,nk),k,0.)
          call SetRealArrayTo(suy(1,1,nk),k,0.)
          k=6*kmodx(i)
          call CopyVek(bx(1,1,i),bx(1,1,nk),k)
          call CopyVek(by(1,1,i),by(1,1,nk),k)
          call SetRealArrayTo(sbx(1,1,nk),k,0.)
          call SetRealArrayTo(sby(1,1,nk),k,0.)
          if(kmods(i).ne.0.or.kmodx(i).gt.0.or.kmodb(i).gt.0) then
            phf(nk)=phf(i)
            sphf(nk)=sphf(i)
          endif
          if(nk.eq.mxa+1) then
            if(nacalc.eq.0) then
              PrvniKiAtomu(nk)=ndoff
            else
              PrvniKiAtomu(nk)=PrvniKiAtomu(nacalc)+DelkaKiAtomu(nacalc)
            endif
          else
            PrvniKiAtomu(nk)=PrvniKiAtomu(nk-1)+DelkaKiAtomu(nk-1)
          endif
          DelkaKiAtomu(nk)=0
          call ShiftKiAt(nk,itf(nk),ifr(nk),lasmax(nk),kmods(nk),
     1                   kmodx(nk),kmodb(nk),kmodc3(nk),kmodc4(nk),
     2                   kmodc5(nk),kmodc6(nk),.true.)
          call SetIntArrayTo(ki(PrvniKiAtomu(nk)),DelkaKiAtomu(nk),0)
4200    continue
      endif
      if(iamp.le.0) then
        NInfo=1
        TextInfo(1)='Warning - no atom selected for the molecule'
        if(FeYesNoHeader(-1.,-1.,'Do you want to define molecule once '
     1                 //'more?',1)) then
          go to 1250
        else
          go to 9900
        endif
      endif
      iam (nmolc)=iamp
      iamn(nmolc)=iamp
      call SetRealArrayTo(xm(1,nm),3,0.)
      StRefPoint(nm)=' '
      if(RefPoint(nm).eq.0) then
        k=0
        call StToReal(StRefPointP,k,xm(1,nm),3,.false.,ich)
        if(ich.ne.0) then
4512      call zhusti(StRefPointP)
          call uprat(StRefPointP)
          k=ktat(atom(np),iamp,StRefPointP)
          if(k.le.0) then
            id=NextQuestId()
            call FeQuestCreate(id,-1.,-1.,150.,0,4,' ',0,LightGray,0,0)
            call FeQuestLabelMake(id,75.,1,'Atom defining the reference'
     1                            //' point','C')
            call FeQuestLabelMake(id,75.,2,'must be part of the '//
     1                            'molecule !!!','C')
            call FeQuestEdwMake(id,75.,3,30.,4,'Please correct it','C',
     1                          90.,EdwYd,0)
            call FeQuestStringEdwOpen(1,StRefPointP)
            icont=0
4515        call FeQuestEvent(id,icont,ich)
            icont=1
            if(CheckType.ne.0) then
              call NebylOsetren
              go to 4515
            endif
            call FeQuestRemove(id)
            if(ich.eq.0) then
              StRefPointP=EdwString(EdwFr)
              go to 4512
            endif
            go to 9900
          else
            k=k+np-1
            do 4517i=1,3
              xm(i,nm)=x(i,k)
4517        continue
            StRefPoint(nm)=StRefPointP
          endif
        endif
      else
        suma=0.
        do 4530i=np,nk
          if(RefPoint(nm).eq.1) then
            pom=AtWeight(isf(i),KPhase)
          else
            pom=1.
          endif
          do 4520j=1,3
            xm(j,nm)=xm(j,nm)+pom*x(j,i)
4520      continue
          suma=suma+pom
4530    continue
        do 4550i=1,3
          xm(i,nm)=xm(i,nm)/suma
4550    continue
      endif
      molname(nm)=NewMolName
      iswmol(nm)=isw
      kpoint(nm)=1
      if(ndimi.gt.0) then
        call qbyx(xm,qcmol,isw)
        do 4700i=np,nk
          kk=0
          do 4620k=1,kmods(i)
            if(k.gt.kmods(i)-ndimi.and.kfs(i).ne.0) then
              kk=kk+1
              ax(k,i)=ax(k,i)+qcmol(kk)-qcnt(kk,i)
            else
              fik=0.
              do 4610m=1,ndimi
                fik=fik+(qcmol(m)-qcnt(m,i))*float(kw(m,k,KPhase))
4610          continue
              sinfik=sin(pi2*fik)
              cosfik=cos(pi2*fik)
              xpp=ax(k,i)
              ypp=ay(k,i)
              ax(k,i)= xpp*cosfik+ypp*sinfik
              ay(k,i)=-xpp*sinfik+ypp*cosfik
            endif
4620      continue
          do 4640k=1,kmodx(i)
            if(k.eq.kmodx(i).and.kfx(i).ne.0) then
              uy(1,k,i)=uy(1,k,i)+qcmol(1)-qcnt(1,i)
            else
              fik=0.
              do 4625m=1,ndimi
                fik=fik+(qcmol(m)-qcnt(m,i))*float(kw(m,k,KPhase))
4625          continue
              sinfik=sin(pi2*fik)
              cosfik=cos(pi2*fik)
              do 4630l=1,3
                xpp=ux(l,k,i)
                ypp=uy(l,k,i)
                ux(l,k,i)= xpp*cosfik+ypp*sinfik
                uy(l,k,i)=-xpp*sinfik+ypp*cosfik
4630          continue
            endif
4640      continue
          do 4660k=1,kmodb(i)
            fik=0.
            do 4645m=1,ndimi
              fik=fik+(qcmol(m)-qcnt(m,i))*float(kw(m,k,KPhase))
4645        continue
            sinfik=sin(pi2*fik)
            cosfik=cos(pi2*fik)
            do 4650l=1,6
              xpp=bx(l,k,i)
              ypp=by(l,k,i)
              bx(l,k,i)= xpp*cosfik+ypp*sinfik
              by(l,k,i)=-xpp*sinfik+ypp*cosfik
4650        continue
4660      continue
4700    continue
      endif
      mamp=0
4750  ji=mxp*(nm-1)+mamp
      mampp=mamp+1
4800  mamp=mamp+1
      if(mamp.eq.mampp) then
        call SetStringArrayTo(atm,3,' ')
        call SetStringArrayTo(atp,3,' ')
      endif
      ji=ji+1
      RotSign(ji)=1
      aimol(ji)=1.
      saimol(ji)=0.
      LocMolSystType(ji)=0
      call SetStringArrayTo(LocMolSystAx(1,ji),2,' ')
      call SetStringArrayTo(LocMolSystSt(1,1,ji),4,' ')
      atr(ji)=' '
      call CopyMat(TrToOrtho(1,isw,KPhase),TrMol(1,ji),3)
      call CopyMat(TrToOrtho(1,isw,KPhase),trp,3)
      call matinv(trp,TriMol(1,ji),pom,3)
      if(mamp.ge.mxp) then
        write(Veta,'('' Maximum number of '',i2,'' different '',
     1               ''molecular positions reached'')') mxp
        call FeChybne(-1.,-1.,Veta,' ',0,SeriousError)
        go to 7100
      endif
5000  write(Title,'(''Molecular position #'',i2)') mamp
      if(mamp.eq.1.and..not.k45) go to 6700
      id=NextQuestId()
      call FeQuestCreate(id,-1.,-1.,200.,0,5,Title,1,LightGray,0,0)
      call FeQuestEdwMake(id,5.,1,45.,1,'%Occupancy','L',45.,EdwYd,0)
      call FeQuestRealEdwOpen(1,aimol(ji),.false.,.false.)
      call FeQuestCrwMake(id,115.,1,185.,1,'Apply %inversion','L',CrwXd,
     1                    CrwYd,0,0)
      call FeQuestCrwOpen(1,RotSign(ji).ne.1)
      call FeQuestLabelMake(id,65.,2,'Model atom','C')
      call FeQuestLabelMake(id,145.,2,'Actual position/atom','C')
      iw=1
      do 5010i=1,3
        write(Veta,'(i1,a2,'' point'')') i,nty(i)
        call FeQuestEdwMake(id,5.,i+2,40.,i+2,Veta,'L',50.,EdwYd,1)
        iw=iw+1
        call FeQuestStringEdwOpen(iw,atm(i))
        call FeQuestEdwMake(id,5.,i+2,95.,i+2,' ','L',100.,EdwYd,1)
        iw=iw+1
        call FeQuestStringEdwOpen(iw,atp(i))
5010  continue
      icont=0
5100  call FeQuestEvent(id,icont,ich)
      icont=1
      if(CheckType.eq.EventButton.and.CheckNumberAbs.eq.ButtonOk) then
        do 5112i=2,7
          if(EdwStringQuest(i).eq.' ') then
            call FeChybne(-1.,-1.,'Information isn''t complete',' ',0,
     1                    SeriousError)
            EventType=EventEdw
            EventNumber=i
            call FeButtonOff(ButtonOk)
            go to 5100
          endif
5112    continue
        QuestCheck(id)=0
        go to 5100
      else if(CheckType.eq.EventEdw) then
        iw=CheckNumber
        iwp=iw/2
        iwm=mod(iw,2)
        if(iwm.le.0) then
          atm(iwp)=EdwStringQuest(iw)
          if(atm(iwp).eq.' ') go to 5100
          call zhusti(atm(iwp))
          call uprat(atm(iwp))
          model(iwp)=ktat(atom(np),iamp,atm(iwp))
          ich=0
          if(model(iwp).le.0) then
            call FeChybne(-1.,-1.,'Atom "'//atm(iwp)(:idel(atm(iwp)))//
     1           '" doesn''t exist in the molecule','try again',0,
     2           SeriousError)
            ich=1
          endif
        else
          atp(iwp)=EdwStringQuest(iw)
          if(atp(iwp).eq.' ') go to 5100
          i=nacalc
          nacalc=nacAll
          call ctiat(atp(iwp),xx(1,iwp),ich)
          nacalc=i
          if(ich.lt.0) ich=0
        endif
        if(ich.ne.0) then
          EventType=EventEdw
          EventNumber=iw
        endif
        go to 5100
      else if(CheckType.ne.0) then
        call NebylOsetren
        go to 5100
      endif
      if(ich.eq.0) then
        if(CrwLogicQuest(1)) then
          RotSign(ji)=-1
        else
          RotSign(ji)= 1
        endif
        call FeQuestRealFromEdw(1,aimol(ji))
      endif
      call FeQuestRemove(id)
      if(ich.ne.0) then
        mamp=mamp-1
        go to 7100
      endif
      do 6000i=1,3
        k=model(i)
        if(i.eq.1) it=k
        call multm(TrMol(1,ji),x(1,k+np-1),xo(1,i),3,3,1)
        if(RotSign(ji).lt.0)
     1    call RealVectorToOpposite(xo(1,i),xo(1,i),3)
        call multm(trp,xx(1,i),xxo(1,i),3,3,1)
6000  continue
      do 6100i=1,3
        paa(i)=xxo(i,2)-xxo(i,1)
        pbb(i)=xxo(i,3)-xxo(i,1)
        paav(i)=xo(i,2)-xo(i,1)
        pbbv(i)=xo(i,3)-xo(i,1)
6100  continue
      call vecnoro(paa)
      call vecnoro(paav)
      do 6200i=1,3
        pa(i)=paa(i)
        pb(i)=paav(i)
6200  continue
      fs=-scalmul(paa,pbb)
      fsv=-scalmul(paav,pbbv)
      do 6300i=1,3
        pbb(i)=pbb(i)+fs*paa(i)
        pbbv(i)=pbbv(i)+fsv*paav(i)
6300  continue
      call vecnoro(pbb)
      call vecnoro(pbbv)
      do 6400i=1,3
        pa(i+3)=pbb(i)
        pb(i+3)=pbbv(i)
6400  continue
      call vecmul(paa,pbb,pa(7))
      call vecnoro(pa(7))
      call vecmul(paav,pbbv,pb(7))
      call vecnoro(pb(7))
      call matinv(pb,pc,pom,3)
      call multm(pa,pc,RotMol(1,ji),3,3,3)
      call vecnoro(RotMol(1,ji))
      call vecnoro(RotMol(4,ji))
      call vecnoro(RotMol(7,ji))
      call EM40GetAngles(RotMol(1,ji),irot,euler(1,ji))
      k=0
      do 6500i=np,nk
        k=k+1
        do 6420j=1,3
          pbb(j)=x(j,i)-xm(j,nm)
6420    continue
        call multm(TrMol(1,ji),pbb,paa,3,3,1)
        call multm(RotMol(1,ji),paa,pbb,3,3,1)
        call multm(TriMol(1,ji),pbb,paa,3,3,1)
        do 6440j=1,3
          if(RotSign(ji).lt.0) paa(j)=-paa(j)
          xp(j,k)=paa(j)+xm(j,nm)
6440    continue
6500  continue
      do 6550i=1,3
        trans(i,ji)=xx(i,1)-xp(i,it)
6550  continue
      go to 6800
6700  call SetRealArrayTo(euler(1,ji),3,0.)
      call SetRealArrayTo(trans(1,ji),3,0.)
6800  call SetRealArrayTo(seuler(1,ji),3,0.)
      call SetRealArrayTo(strans(1,ji),3,0.)
      write(TextInfo(1),'(''Phi ='',f8.2,'' Chi ='',f8.2,'' Psi ='',
     1                    f8.2,'' determinant ='',i2)')
     2                    (euler(i,ji),i=1,3),RotSign(ji)
      write(TextInfo(2),'(''Translation vector : '',3f10.6)')
     1     (trans(i,ji),i=1,3)
      Ninfo=2
      call FeInfoOut(-1.,-1.,Title)
      if(.not.k45.and.mamp.eq.1) go to 7000
      k=0
      Ninfo=1
      TextInfo(1)='           Individual atomic positions'
      if(mamp.ne.1.and..not.k45) TextInfo(1)(41:)='coincides with'
      ncoin=0
      do 6900i=np,nk
        k=k+1
        do 6850j=1,3
          xp(j,k)=xp(j,k)+trans(j,ji)
6850    continue
        Ninfo=Ninfo+1
        write(TextInfo(Ninfo),'(a8,3f10.6)') atom(i),(xp(j,k),j=1,3)
        if(mamp.ne.1.and..not.k45) then
          j=koinc(xp(1,k),x,nap,nak,dco,dst,isw)
6870      if(j.ne.0) then
            write(TextInfo(Ninfo)(39:),'(1x,f8.3,'' to '',a8)')
     1            dst,atom(j)
            if(isf(j).gt.0) then
              isf(j)=-isf(j)-100
            else
              if(j.lt.nak) then
                j=koinc(xp(1,k),x,j+1,nak,dco,dst,isw)
                go to 6870
              endif
            endif
            ncoin=ncoin+1
          else
            TextInfo(Ninfo)(43:)='------------'
          endif
        endif
        if(Ninfo.ge.15) then
          call FeInfoOut(-1.,-1.,Title)
          Ninfo=1
        endif
6900  continue
      if(Ninfo.gt.1) call FeInfoOut(-1.,-1.,Title)
7000  if(FeYesNo(-1.,-1.,'Accept this position?',1)) then
        kmodsm(ji)=0
        kmodxm(ji)=0
        kmodbm(ji)=0
        if(ji.eq.1) then
          PrvniKiMolekuly(ji)=npmp
        else
          if(mod(ji,mxp).eq.1) then
            jim=ji-mxp+mam(nm-1)-1
          else
            jim=ji-1
          endif
          PrvniKiMolekuly(ji)=PrvniKiMolekuly(jim)+DelkaKiMolekuly(jim)
        endif
        DelkaKiMolekuly(ji)=0
        call ShiftKiMol(ji,ktls(nm),kmodsm(ji),kmodxm(ji),kmodbm(ji),
     1                  .true.)
        PrvKi=PrvniKiMolekuly(ji)
        call SetIntArrayTo(ki,DelkaKiMolekuly(ji),0)
        if(mamp.ne.1.and..not.k45.and.ncoin.gt.0) then
          if(FeYesNo(-1.,-1.,'Remove coinciding atoms from the atomic'//
     1                    ' part?',1)) then
            j= 1
          else
            j=-1
          endif
          do 7050i=nap,nak
            if(isf(i).lt.-100) isf(i)=j*(isf(i)+100)
7050      continue
        endif
        if(FeYesNo(-1.,-1.,'Add another position?',1)) go to 4800
      else
        do 7060i=nap,nak
          if(isf(i).lt.-100) isf(i)=-isf(i)-100
7060    continue
        go to 5000
      endif
7100  if(mamp.le.0) go to 9900
      mam(nm)=mamp
      if(.not.k45) then
        k=0
        do 8000i=nak,nap,-1
          if(isf(i).lt.0) then
            atm(1)=atom(i)
            do 7200ji=1,mam(nm)
              if(atr(ji).eq.atm(1)) atr(ji)=' '
7200        continue
            call atsun(i+1,nacAll-k,i)
            k=k+1
          endif
8000    continue
        na(isw)=na(isw)-k
        nac=nac-k
        nacAll=nacAll-k
      endif
      ich=0
      go to 9999
9100  backspace 45
      read(45,FormA80) Veta
      call FeChybne(-1.,-1.,'the wrong record on M45 file',Veta,0,
     1              SeriousError)
      go to 9800
9200  call FeChybne(-1.,-1.,'the file M45 doesn''t contain any atom',
     1              ' ',0,SeriousError)
9800  call CloseIfOpened(45)
9900  call OneStepBack
      ich=1
9999  return
100   format(i2)
101   format(f9.6)
      end
      subroutine ZmOrtho(ich)
      include 'params.cmn'
      include 'basic.cmn'
      include 'atoms.cmn'
      include 'fepc.cmn'
      ich=0
      call trorthoS(0)
      nor=0
      call OpenFile(m40,fln(:ifln)//'.m49','formatted','unknown')
      if(ErrJana.ne.0) go to 9999
      call iom40only(1,0)
      if(ErrJana.ne.0) go to 9999
      call CloseIfOpened(m40)
      call iom40only(0,0)
      if(ErrJana.ne.0) go to 9999
      Ninfo=2
      TextInfo(1)='The new file : '//fln(:ifln)//'.m49 created which '
     1          //'contains the regular'
      TextInfo(2)='harmonic waves instead of the orthogonalized ones'
      call FeInfoOut(-1.,-1.,'Information')
9999  return
      end
      subroutine EM40DefWaves(ich)
      include 'params.cmn'
      include 'basic.cmn'
      include 'fepc.cmn'
      dimension kwo(3,mxw),kw0(3),GammaIntP(9),GammaIntPI(9),kwp(3)
      character*80 Veta
      character*3 qc(3)
      character*2 nty
      integer GammaInt(9,mxsym)
      logical Prvne,eqiv
      equivalence (kwo,scrar)
      data qc/'*q1','*q2','*q3'/,kw0/3*0/
      Prvne=.true.
      call CopyVekI(kw(1,1,KPhase),kwo,3*mxw)
      xqd=50.+40.*ndimi
      n1=1
      n2=min(mxw,8)
      id=NextQuestId()
      il=n2-n1+2
      call FeQuestCreate(id,-1.,-1.,xqd,0,il,'Modulation waves',0,
     1                   LightGray,0,0)
      if(mxw.gt.8) then
        xpom=xqd-9.5
        call FeQuestUpDownMake(id,xpom,n2-n1+2,UpDownXd,UpDownYd,'down')
        nDown=UpDownLastMade
        call FeQuestUpDownMake(id,xpom,0,UpDownXd,UpDownYd,'up')
        nUp=UpDownLastMade
      endif
      if(ndimi.gt.1) then
        Veta='%Complete the set'
        dpom=FeTxLengthUnder(Veta)+5.
        xpom=(xqd-dpom)*.5
        call FeQuestButtonMake(id,xpom,il,dpom,ButYd,Veta)
        nButtComplete=ButtonLastMade
        call FeQuestButtonOpen(nButtComplete,ButtonOff)
        do 1150is=1,ns
          do 1110j=4,ndim
            do 1100i=4,ndim
              GammaIntP(i-3+(j-4)*ndimi)=
     1          rm6(i+(j-1)*ndim,is,1,KPhase)
1100        continue
1110      continue
          call Matinv(GammaIntP,GammaIntPI,pom,ndimi)
          do 1120j=1,ndimi*ndimi
            GammaInt(j,is)=nint(GammaIntPI(j))
1120      continue
1150    continue
      endif
1500  n=n2-n1+1
      if(mxw.gt.8) then
        if(n2.lt.mxw) then
          call FeUpDownOff(nDown)
        else
          call FeUpDownDisable(nDown)
        endif
        if(n1.gt.1) then
          call FeUpDownOff(nUp)
        else
          call FeUpDownDisable(nUp)
        endif
      endif
      j=n1
      iw=0
      do 1600i=1,n
        write(Veta,100) j,nty(j)
        call FeQuestLabelMake(id,5.,i,Veta,'L')
        xpom=55.
        do 1550k=1,ndimi
          iw=iw+1
          if(Prvne) call FeQuestEdwMake(id,5.,i,xpom,i,' ','L',20.,
     1                                  EdwYd,0)
          if(j.gt.ndimi) then
            call FeQuestIntEdwOpen(iw,kw(k,j,KPhase),.false.)
          else
            write(Veta,'(i5)') kw(k,j,KPhase)
            call Zhusti(Veta)
            call FeQuestLabelMake(id,xpom+3.5,i,Veta,'L')
          endif
          if(Prvne) call FeQuestLabelMake(id,xpom+22.,i,
     1                                    qc(k)(:min(ndimi+1,3)),'L')
          xpom=xpom+40.
1550    continue
        j=j+1
1600  continue
      Prvne=.false.
      icont=0
2000  call FeQuestEvent(id,icont,ich)
      icont=1
      iw=0
      j=n1
      do 2100i=1,n
        write(Veta,100) j,nty(j)
        call FeQuestLabelRemove(id,5.,i,Veta,'L')
        do 2050k=1,ndimi
          iw=iw+1
          if(j.gt.ndimi) then
            call FeQuestIntFromEdw(iw,kw(k,j,KPhase))
            call FeQuestEdwClose(iw)
          endif
2050    continue
        j=j+1
2100  continue
      if(CheckType.eq.EventUpDown) then
        if(CheckNumber.eq.nDown) then
          n1=n1+8
          n2=min(n2+8,mxw)
        else
          n1=max(n1-8,1)
          n2=n2-8
        endif
        go to 1500
      else if(CheckType.eq.EventButton.and.CheckNumber.eq.nButtComplete)
     1  then
       ib=nButtComplete
        do 2200i=1,mxw
          if(eqiv(kw(1,i,KPhase),kw0,ndimi)) go to 2210
2200    continue
        i=mxw+1
2210    NwLast=i-1
        NwLastOld=NwLast
        i=0
2220    i=i+1
        if(i.gt.NwLast) go to 2500
        do 2300is=1,ns
          call multmi(kw(1,i,KPhase),GammaInt(1,is),kwp,1,ndimi,ndimi)
          do 2240iz=1,2
            do 2230j=1,NwLast
              if(eqiv(kwp,kw(1,j,KPhase),ndimi)) go to 2300
2230        continue
            call IntVectorToOpposite(kwp,kwp,ndimi)
2240      continue
          if(NwLast.lt.mxw) then
            NwLast=NwLast+1
            do 2250i=1,ndimi
              if(kwp(i).lt.0) then
                call IntVectorToOpposite(kwp,kwp,ndimi)
                go to 2260
              else if(kwp(i).gt.0) then
                go to 2260
              endif
2250        continue
2260        call CopyVek(kwp,kw(1,NwLast,KPhase),ndimi)
          else
            write(Veta,FormI15) mxw
            call Zhusti(Veta)
            Veta='number of generated waves exceeds the limit of '//
     1           Veta(:idel(Veta))//' waves'
            call FeChybne(-1.,-1.,Veta,' ',0,SeriousError)
            call SetIntArrayTo(kw(1,NwLastOld+1,KPhase),
     1                         3*(mxw-NwLastOld),0)
            go to 2500
          endif
2300    continue
        go to 2220
2500    call FeQuestButtonOff(ib)
        go to 1500
      else if(CheckType.ne.0) then
        call NebylOsetren
        go to 2000
      endif
      call FeQuestRemove(id)
      if(ich.ne.0) call CopyVekI(kwo,kw(1,1,KPhase),3*mxw)
      return
100   format(i2,a2,' wave')
      end
      subroutine OneStepBack
      include 'params.cmn'
      include 'basic.cmn'
      include 'editm40.cmn'
      character*2 ext
      if(NM40.gt.0) then
        write(ext,'(i2)') NM40-1
        if(ext(1:1).eq.' ') ext(1:1)='0'
        call OpenFile(m40,fln(:ifln)//'.l'//ext,'formatted','old')
        if(ErrJana.ne.0) go to 9999
      endif
      call iom40only(0,0)
      if(ErrJana.ne.0) go to 9999
      if(NM40.gt.0) call CloseIfOpened(m40)
9999  return
      end
      subroutine atcheck(at,ich,iatm)
      include 'params.cmn'
      include 'basic.cmn'
      include 'editm40.cmn'
      include 'atoms.cmn'
      include 'molec.cmn'
      character*(*) at
      ich=0
      iatm=0
      if(index(at,'#').ne.0.or.index(at,'*').ne.0.or.
     1   index(at,'?').ne.0.or.index(at,'[').ne.0.or.index(at,']').ne.0)
     2      ich=1
      iatm=ktatmol(at)
      if(iatm.ne.0) ich=2
      return
      end
      subroutine vecnoro(a)
      dimension a(3)
      pom=1./sqrt(a(1)**2+a(2)**2+a(3)**2)
      do 1000i=1,3
        a(i)=a(i)*pom
1000  continue
      return
      end
      subroutine GraphicOutput(Klic,FileNameIn,MenitNazvy,ich)
      parameter (mxap=200000)
      include 'params.cmn'
      include 'basic.cmn'
      include 'atoms.cmn'
      include 'fepc.cmn'
      dimension xmez(2,3,3),FacPar(3),x0(6),x1(6),x2(6),x3(6),x4(6),
     1          xd(6),xf(6),nmez(2,3,3),uxi(3,mxw),uyi(3,mxw),xt(6),
     2          smt(36),bxi(6,mxw),byi(6,mxw),bd(6),bp(6),smtc(36,3),
     3          bf(6),GammaIntInv(9),x40(3),x4p(3),nx4(3),dx4(3),oi(1),
     4          natp(20),xyz(3,mxap),isfp(mxap),sh(3),ish(3),shc(3),
     5          ishc(3),xg(3)
      character*(*) FileNameIn
      character*256 t256,NameOfCorrFile,EdwStringQuest,FileName
      character*80 Radka,t80,Label
      character*40 t40
      character*9 ch9
      character*8 ch8
      character*2 ch2
      logical EqIgCase,BratAtom(mxa),IdenticalAtoms,eqrv,KeepNames,
     1        CrwLogicQuest,SaveFile,ExistFile,FeYesNo,CheckBorders
      equivalence (xyz,scrar(mxap+1)),(isfp,scrar)
      data olim/.5/,nx4/3*1/,dx4/3*0./,NameOfCorrFile/' '/,Dmin/1./,
     1     CheckBorders/.false./
      data Label/'The following positions discarded to avoid short dista
     1nces:'/
      data ((xmez(i,j,1),i=1,2),j=1,3)/0.,1.,0.,1.,0.,1./
      ich=0
      if(nor.gt.0) then
        call setor(0,0)
        call trortho(0)
      endif
      if(GrOn) then
        id=NextQuestId()
        xqd=170.
        if(kcommen.ne.0) then
          il=10
        else
          il=13
        endif
        call FeQuestCreate(id,-1.,-1.,xqd,0,il,'Limits of the figure ',
     1                     1,LightGray,0,0)
        il=0
        tpom=5.
        xpom=tpom+FeTxLengthUnder('XXXXXXXX')
        dpom=25.
        spom=xpom+dpom+3.
        do 1000i=1,3
          il=il+1
          call FeQuestEudMake(id,tpom,il,xpom,il,smbx(i)//' from','L',
     1                        dpom,EdwYd,1)
          if(i.eq.1) nEdwLimitFirst=EdwLastMade
          call FeQuestRealEdwOpen(EdwLastMade,xmez(1,i,1),.false.,
     1                            .false.)
          call FeQuestEudOpen(EdwLastMade,0,0,0,-100.,xmez(2,i,1),1.)
          call FeQuestEudMake(id,tpom+spom+3.,il,xpom+spom-10.,il,'to',
     1                        'L',dpom,EdwYd,1)
          call FeQuestRealEdwOpen(EdwLastMade,xmez(2,i,1),.false.,
     1                            .false.)
          if(i.eq.3) nEdwLimitLast=EdwLastMade
          call FeQuestEudOpen(EdwLastMade,0,0,0,xmez(1,i,1),100.,1.)
1000    continue
        call FeReleaseOutput
        xpom=xpom+dpom+spom+8.
        tpom=xpom+5.+CrwXd
        ilp=il
        il=0
        do 1020i=1,2
          il=il+1
          if(i.eq.1) then
            t80='step 0%.1'
          else
            t80='step %1'
          endif
          call FeQuestCrwMake(id,tpom,il,xpom,il,t80,'L',CrwgXd,CrwgYd,
     1                        1,1)
          if(i.eq.1) then
            nCrwSmallStep=CrwLastMade
          else
            nCrwLargeStep=CrwLastMade
          endif
          call FeQuestCrwOpen(CrwLastMade,i.eq.2)
1020    continue
        il=ilp+1
        t80='%Cutoff occupancy'
        tpom=5.
        xpom=FeTxLengthUnder(t80)+8.
        dpom=30.
        call FeQuestEdwMake(id,tpom,il,xpom,il,t80,'L',dpom,EdwYd,0)
        nEdwCutOcc=EdwLastMade
        call FeQuestRealEdwOpen(EdwLastMade,olim,.false.,.false.)
        if(kcommen.le.0) then
          il=il+1
          t80='%tzero'
          call FeQuestEdwMake(id,tpom,il,xpom,il,t80,'L',dpom,EdwYd,0)
          nEdwTzero=EdwLastMade
          call FeQuestRealAEdwOpen(EdwLastMade,trez(1,1,KPhase),ndimi,
     1                             .false.,.false.)
          il=il+1
          xpomp=5.
          tpomp=xpomp+5.+CrwXd
          t80='C%heck short distances in the approximant'
          call FeQuestCrwMake(id,tpomp,il,xpomp,il,t80,'L',CrwXd,CrwXd,
     1                        1,0)
          nCrwCheckBorders=CrwLastMade
          call FeQuestCrwOpen(CrwLastMade,CheckBorders)
          il=il+1
          t80='Min. %distance'
          call FeQuestEdwMake(id,tpom,il,xpom,il,t80,'L',dpom,EdwYd,0)
          nEdwDmin=EdwLastMade
          if(CheckBorders)
     1      call FeQuestRealEdwOpen(EdwLastMade,Dmin,.false.,.false.)
        else
          nEdwTzero=0
          nEdwDmin=0
          nCrwCheckBorders=0
        endif
        il=il+1
        call FeQuestLineMake(id,il)
        xpom=5.
        tpom=xpom+5.+CrwXd
        do 1030i=1,2
          il=il+1
          if(i.eq.1) then
            t80='%Keep atom names'
          else
            t80='Chan%ge atom names to "atom_type"+number'
          endif
          call FeQuestCrwMake(id,tpom,il,xpom,il,t80,'L',CrwgXd,CrwgYd,
     1                        0,2)
          if(i.eq.1) then
            nCrwKeepNames=CrwLastMade
          else
            nCrwChangeNames=CrwLastMade
          endif
          call FeQuestCrwOpen(CrwLastMade,i.eq.1)
1030    continue
        il=il+1
        call FeQuestLineMake(id,il)
        il=il+1
        t80='%Save correspondance file'
        call FeQuestCrwMake(id,tpom,il,xpom,il,t80,'L',CrwXd,CrwXd,1,0)
        nCrwSaveFile=CrwLastMade
        call FeQuestCrwOpen(CrwLastMade,.false.)
        il=il+1
        t80='%File name'
        Radka='%Browse'
        tpom=5.
        xpom=FeTxLengthUnder(t80)+8.
        dpom=xqd-xpom-15.-FeTxLengthUnder(Radka)
        call FeQuestEdwMake(id,5.,il,xpom,il,t80,'L',dpom,EdwYd,0)
        nEdwFileName=EdwLastMade
        if(NameOfCorrFile.eq.' ') NameOfCorrFile=fln(:ifln)//'.atc'
        xpom=xpom+dpom+4.
        dpom=FeTxLengthUnder(Radka)+6.
        call FeQuestButtonMake(id,xpom,il,dpom,ButYd,Radka)
        nButtBrowse=ButtonLastMade
1090    icont=0
1100    call FeQuestEvent(id,icont,ich)
        icont=1
        if(CheckType.eq.EventButton.and.CheckNumberAbs.eq.ButtonOk) then
          SaveFile=CrwLogicQuest(nCrwSaveFile)
          if(SaveFile) then
            NameOfCorrFile=EdwStringQuest(nEdwFileName)
            if(ExistFile(NameOfCorrFile)) then
              if(.not.FeYesNo(-1.,-1.,'The file "'//
     1                        NameOfCorrFile(:idel(NameOfCorrFile))//
     2                        '" already exists, overwrite it?',0)) then
                call FeQuestButtonOff(ButtonOK)
                go to 1090
              endif
            endif
          endif
          QuestCheck(id)=0
          go to 1100
        else if(CheckType.eq.EventEdw.and.CheckNumber.le.nEdwLimitLast)
     1    then
          i=mod(CheckNumber-nEdwLimitFirst+1,2)
          if(i.eq.1) then
            j=CheckNumber+1
            if(EdwRealQuest(2,j).ne.EdwRealQuest(1,CheckNumber)) then
              call FeQuestEudOpen(j,0,0,0,EdwRealQuest(1,CheckNumber),
     1                            EdwRealQuest(3,j),EdwRealQuest(4,j))
              if(EdwRealQuest(1,j).lt.
     2           EdwRealQuest(2,j)+EdwRealQuest(4,j)*.5.or.
     3           EdwRealQuest(1,j).lt.pom+EdwRealQuest(4,j)*.5) then
                call FeCheckEud(CheckNumber,0)
              endif
            endif
          else if(i.eq.0) then
            j=CheckNumber-1
            if(EdwRealQuest(3,j).ne.EdwRealQuest(1,CheckNumber)) then
              call FeQuestEudOpen(j,0,0,0,EdwRealQuest(2,j),
     1                                    EdwRealQuest(1,CheckNumber),
     2                                    EdwRealQuest(4,j))
              if(EdwRealQuest(1,j).gt.
     1           EdwRealQuest(3,j)-EdwRealQuest(4,j)*.5.or.
     2           EdwRealQuest(1,j).gt.pom-EdwRealQuest(4,j)*.5) then
                call FeCheckEud(CheckNumber,0)
              endif
            endif
          endif
          go to 1100
        else if(CheckType.eq.EventCrw.and.
     1          (CheckNumber.eq.nCrwLargeStep.or.
     2           CheckNumber.eq.nCrwSmallStep)) then
          if(CheckNumber.eq.nCrwLargeStep) then
            pom=1.
          else
            pom=.1
          endif
          nEdw=nEdwLimitFirst
          do 1120i=1,3
            do 1110j=1,2
              call FeQuestEudOpen(nEdw,0,0,0,EdwRealQuest(2,nEdw),
     1                                       EdwRealQuest(3,nEdw),
     2                                       pom)
              nEdw=nEdw+1
1110        continue
1120      continue
          call FeReleaseOutput
          call FeDeferOutput
          EventType=EventEdw
          EventNumber=EdwActive
          go to 1100
        else if(CheckType.eq.EventCrw.and.CheckNumber.eq.nCrwSaveFile)
     1    then
          if(CrwLogicQuest(CheckNumber)) then
            call FeQuestStringEdwOpen(nEdwFileName,NameOfCorrFile)
            call FeQuestButtonOpen(nButtBrowse,ButtonOff)
          else
            call FeQuestEdwClose(nEdwFileName)
            call FeQuestButtonClose(nButtBrowse)
          endif
          go to 1090
        else if(CheckType.eq.EventCrw.and.
     1          CheckNumber.eq.nCrwCheckBorders) then
          CheckBorders=CrwLogicQuest(CheckNumber)
          if(CheckBorders) then
            call FeQuestRealEdwOpen(nEdwDmin,Dmin,.false.,.false.)
          else
            call FeQuestEdwClose(nEdwDmin)
          endif
          go to 1090
        else if(CheckType.eq.EventButton.and.CheckNumber.eq.nButtBrowse)
     1    then
          t80=EdwStringQuest(nEdwFileName)
          call FeFileManager('Select correspondance file',t80,'*.atc',1,
     1                       .true.,ich)
          if(ich.eq.0) call FeQuestStringEdwOpen(nEdwFileName,t80)
          call FeQuestButtonOff(nButtBrowse)
          EventType=EventEdw
          EventNumber=nEdwFileName
          go to 1100
        else if(CheckType.ne.0) then
          call NebylOsetren
          go to 1100
        endif
        if(ich.eq.0) then
          nEdw=nEdwLimitFirst
          do 1200i=1,3
            do 1150j=1,2
              call FeQuestRealFromEdw(nEdw,xmez(j,i,1))
              nEdw=nEdw+1
1150        continue
1200      continue
          call FeQuestRealFromEdw(nEdwCutOcc,olim)
          KeepNames=CrwLogicQuest(nCrwKeepNames)
          if(nEdwTzero.ne.0) then
            call FeQuestRealAFromEdw(nEdwTzero,trez(1,1,KPhase))
            call FeQuestRealFromEdw(nEdwDmin,Dmin)
          endif
        endif
        call FeQuestRemove(id)
        if(ich.ne.0) go to 9000
      else
        KeepNames=.true.
        SaveFile=.false.
        do 1210i=1,3
          xmez(1,i,1)=0.
          xmez(2,i,1)=1.
1210    continue
        olim=.5
1220    read(BatchLN,FormA80,err=1250,end=1250) Radka
        k=0
        call kus(Radka,k,Cislo)
        if(EqIgCase(Cislo(2:),'lim')) then
          do 1230i=1,3
            if(EqIgCase(Cislo(1:1),smbx(i))) then
              call StToReal(Radka,k,xmez(1,i,1),2,.false.,ich)
              go to 1230
            endif
1230      continue
        else if(EqIgCase(Cislo,'ocutoff')) then
          call StToReal(Radka,k,x1,1,.false.,ich)
          olim=x1(1)
        else
          if(Cislo.ne.'end') backspace BatchLN
          go to 1250
        endif
        go to 1220
      endif
1250  do 1290i=1,3
        nmez(1,i,1)=xmez(1,i,1)-.95
        nmez(2,i,1)=xmez(2,i,1)+.95
        FacPar(i)=xmez(2,i,1)-xmez(1,i,1)
1290  continue
      do 1500i=2,ncomp
        do 1300j=1,3
          xmez(1,j,i)= 9999.
          xmez(2,j,i)=-9999.
1300    continue
        do 1330k1=1,2
          x0(1)=xmez(k1,1,1)
          do 1320k2=1,2
            x0(2)=xmez(k2,2,1)
            do 1310k3=1,2
              x0(3)=xmez(k3,3,1)
              call qbyx(x0,x0(4),1)
              call multm(zv(1,i,KPhase),x0,x1,ndim,ndim,1)
              do 1305j=1,3
                xmez(1,j,i)=min(x1(j),xmez(1,j,i))
                xmez(2,j,i)=max(x1(j),xmez(2,j,i))
1305          continue
1310        continue
1320      continue
1330    continue
        do 1340k=1,3
          nmez(1,k,i)=xmez(1,k,i)-.95
          nmez(2,k,i)=xmez(2,k,i)+.95
1340    continue
        call srotb(zsigi(1,i,KPhase),zsigi(1,i,KPhase),smtc(1,i))
1500  continue
      call SetLogicalArrayTo(BratAtom,nacalc,.true.)
      do 1600i=1,nacalc-1
        if(kswa(i).ne.KPhase.or..not.BratAtom(i)) go to 1600
        do 1550j=i+1,nacalc
          if(kswa(j).ne.KPhase) go to 1550
          if(IdenticalAtoms(i,j,.001)) BratAtom(j)=.false.
1550    continue
1600  continue
      ln=NextLogicNumber()
      call OpenFile(ln,fln(:ifln)//'_m40.tmp','formatted','unknown')
      if(ErrJana.ne.0) go to 9999
      nac=0
      call SetIntArrayTo(natp,nf,0)
      if(SaveFile) then
        lni=NextLogicNumber()
        call OpenFile(lni,NameOfCorrFile,'formatted','unknown')
        if(ErrJana.ne.0) go to 9999
      endif
      NInfo=0
      do 4000i=1,nacalc
        if(kswa(i).ne.KPhase.or..not.BratAtom(i)) go to 4000
        isw=iswa(i)
        itfi=min(itf(i),2)
        if(itfi.le.1) then
          bf(1)=beta(1,i)
          call SetRealArrayTo(bf(2),5,0.)
        endif
        isfi=isf(i)
        call CopyVek(x(1,i),x0,3)
        call SetRealArrayTo(x0(4),ndimi,0.)
        js=0
        ch2=' '
        ch2(2:2)=char(ichar('a')-1)
        do 3900isym=1,ns
          call GetGammaIntInv(isym,isw,KPhase,GammaIntInv)
          call multm(rm6(1,isym,isw,KPhase),x0,x1,ndim,ndim,1)
          do 2050j=1,kmodx(i)
            call multm(rm(1,isym,isw,KPhase),ux(1,j,i),uxi(1,j),3,3,1)
            if(kfx(i).eq.0.or.j.ne.kmodx(i)) then
              call multm(rm(1,isym,isw,KPhase),uy(1,j,i),uyi(1,j),3,3,1)
            else
              call CopyVek(uy(1,j,i),uyi(1,j),3)
            endif
2050      continue
          call srotb(rm(1,isym,isw,KPhase),rm(1,isym,isw,KPhase),smt)
          if(itfi.ge.2) then
            call multm(smt,beta(1,i),bp,6,6,1)
            do 2055j=1,kmodb(i)
              call multm(smt,bx(1,j,i),bxi(1,j),6,6,1)
              call multm(smt,by(1,j,i),byi(1,j),6,6,1)
2055        continue
          endif
          do 3800icntrsm=1,3-ncs
            if(icntrsm.eq.1) then
              iznk= 1
            else
              iznk=-1
            endif
            js=js+1
            if(isa(js,i).le.0) go to 3800
            if(iznk.eq.-1) then
              do 2070j=1,kmodx(i)
                call RealVectorToOpposite(uxi(1,j),uxi(1,j),3)
                if(kfx(i).eq.0.or.j.ne.kmodx(i))
     1            call RealVectorToOpposite(uyi(1,j),uyi(1,j),3)
2070          continue
              call RealMatrixToOpposite(GammaIntInv,GammaIntInv,ndimi)
            endif
            zn=iznk
            do 2075j=1,ndim
              x2(j)=x1(j)*zn+s6(j,isym,isw,KPhase)
2075        continue
            do 3700ivt=1,nvt
              do 2080jvt=1,ivt-1
                if(eqrv(vt6(1,ivt,isw,KPhase),vt6(1,jvt,isw,KPhase),3,
     1                  .0001)) go to 3700
2080          continue
              ch2(2:2)=char(ichar(ch2(2:2))+1)
              if(ch2(2:2).eq.'[') then
                ch2(2:2)='a'
                if(ch2(1:1).eq.' ') then
                  ch2(1:1)='a'
                else
                  ch2(1:1)=char(ichar(ch2(1:1))+1)
                endif
              endif
              call AddVek(x2,vt6(1,ivt,isw,KPhase),x3,ndim)
              call AddVek(s6(1,isym,isw,KPhase),vt6(1,ivt,isw,KPhase),
     1                    sh,3)
              call od0do1(x3,x4,3)
              do 2090j=1,3
                sh(j)=sh(j)+x4(j)-x3(j)
                ish(j)=nint(x4(j)-x3(j))
2090          continue
              call qbyx(sh,xt(4),isw)
              do 2092j=4,ndim
                xt(j)=xt(j)-x3(j)
2092          continue
              call CopyVek(qcnt(1,i),x40,ndimi)
              call Cultm(GammaIntInv,xt(4),x40,ndimi,ndimi,1)
              ip=0
              nacp=nac+1
              do 3600ix=nmez(1,1,isw)-1,nmez(2,1,isw)+1
                xt(1)=ix
                ishc(1)=ish(1)+ix
                do 3500iy=nmez(1,2,isw)-1,nmez(2,2,isw)+1
                  xt(2)=iy
                  ishc(2)=ish(2)+iy
                  do 3400iz=nmez(1,3,isw)-1,nmez(2,3,isw)+1
                    xt(3)=iz
                    ishc(3)=ish(3)+iz
                    call AddVek(sh,xt,shc,3)
                    call qbyx(xt,xt(4),isw)
                    call AddVek(xt(4),trez(1,isw,KPhase),xt(4),ndimi)
                    call Multm(GammaIntInv,xt(4),x4p,ndimi,ndimi,1)
                    call MakeOccMod(oi,x40,x4p,nx4,dx4,a0(i),ax(1,i),
     1                ay(1,i),kmods(i),kfs(i),GammaIntInv)
                    if(kfx(i).gt.0.and.kmodx(i).gt.0)
     1                call MakeOccModSawTooth(oi,x40,x4p,nx4,dx4,
     2                  uyi(1,kmodx(i)),uyi(2,kmodx(i)),kfx(i),
     3                  GammaIntInv)
                    if(oi(1).lt.olim) go to 3400
                    call MakePosMod(xd,x40,x4p,nx4,dx4,uxi,uyi,kmodx(i),
     1                              kfx(i),GammaIntInv)
                    do 2200j=1,3
                      xd(j)=x4(j)+xt(j)+xd(j)
2200                continue
                    if(itfi.ge.2) then
                      call MakeBetaMod(bd,x40,x4p,nx4,dx4,bxi,byi,
     1                                 kmodb(i),kfb(i),GammaIntInv)
                      call AddVek(bd,bp,bd,6)
                    endif
                    if(isw.eq.1) then
                      call CopyVek(xd,xf,3)
                      if(itfi.ge.2) call CopyVek(bd,bf,6)
                    else
                      call qbyx(xd,xd(4),isw)
                      call multm(zvi(1,isw,KPhase),xd,xf,ndim,ndim,1)
                      if(itfi.ge.2) call multm(smtc(1,isw),bd,bf,6,6,1)
                    endif
                    do 2400j=1,3
                      xd(j)=(xf(j)-xmez(1,j,1))/FacPar(j)
                      if(xd(j).lt.0..or.xd(j).ge.1.) go to 3400
2400                continue
                    if(itfi.ge.2) then
                      do 2500j=1,6
                        call indext(j,k,l)
                        bf(j)=bf(j)/(FacPar(k)*FacPar(l))
2500                  continue
                    endif
                    ip=ip+1
                    if(MenitNazvy.le.0) then
                      write(Radka,'(a2,i4)') ch2,ip
                      call zhusti(Radka)
                      Radka=Atom(i)(:idel(Atom(i)))//Radka(:idel(Radka))
                    else
                      if(KeepNames) then
                        Radka=atom(i)
                      else
                        natp(isfi)=natp(isfi)+1
                        write(Radka,'(a2,i4)') AtType(isfi,KPhase),
     1                                         natp(isfi)
                        call zhusti(Radka)
                      endif
                    endif
                    call scode(isym,icntrsm,ivt,shc,ishc,isw,t80,t40)
                    do 3000j=nacp,min(nac,mxap)
                      if(eqrv(xd,xyz(1,j),3,.0001)) go to 3400
                      if(CheckBorders) then
                        do 2930k=1,3
                          xf(k)=xd(k)-xyz(k,j)
2910                      if(xf(k).gt..5) then
                            xf(k)=xf(k)-1.
                            go to 2910
                          endif
2920                      if(xf(k).le.-.5) then
                            xf(k)=xf(k)+1.
                            go to 2920
                          endif
                          xf(k)=xf(k)*FacPar(k)
2930                    continue
                        call multm(MetTens(1,1,KPhase),xf,xg,3,3,1)
                        if(sqrt(scalmul(xf,xg)).lt.Dmin) then
                          NInfo=NInfo+1
                          TextInfo(NInfo)=atom(i)
                          if(t40.ne.' ')
     1                      TextInfo(NInfo)=
     2                        TextInfo(NInfo)(:idel(TextInfo(NInfo)))//
     3                        '#'//t40(:idel(t40))
                          if(NInfo.ge.15) then
                            call FeInfoOut(-1.,-1.,Label)
                            NInfo=0
                          endif
                          go to 3400
                        endif
                      endif
3000                continue
                    nac=nac+1
                    if(nac.le.mxap) then
                      isfp(j)=isf(i)
                      call CopyVek(xd,xyz(1,nac),3)
                    else
                      write(Cislo,FormI15) mxap
                      call Zhusti(Cislo)
                      call FeChybne(-1.,-1.,'the number of generated '//
     1                  'atoms exceeded the limit of '//
     2                  Cislo(:idel(Cislo))//' atoms',
     3                  'The generated file can be used but is not '//
     4                  'complete',0,SeriourError)
                      nac=nac-1
                      go to 4010
                    endif
                    write(ln,'(a8,2i3,4x,4f9.6/6f9.6)') radka(:8),
     1                isf(i),itfi,oi(1),(xd(j),j=1,3),bf
                    if(SaveFile) then
                      if(iznk.eq.1) then
                        j=1
                      else
                        j=2
                      endif
                      t256=radka(:8)//' => '//atom(i)(:idel(atom(i)))
                      if(t40.ne.' ')
     1                  t256=t256(:idel(t256))//'#'//t40(:idel(t40))
                      t256(41:)=t80
                      write(t256(61:),'(4f8.5)') oi(1),(xd(j),j=1,3)
                      write(lni,FormA1)(t256(j:j),j=1,idel(t256))
                    endif
3400              continue
3500            continue
3600          continue
3700        continue
3800      continue
3900    continue
4000  continue
4010  if(NInfo.gt.0) call FeInfoOut(-1.,-1.,Label)
      if(SaveFile) close(lni)
      rewind(ln)
      grupa='P1'
      ngrupa=1
      CrSystem=1
      Lattice='P'
      ncs=2
      ns=1
      ndim=3
      ndimq=3
      ndimi=0
      ncomp=1
      itwin=1
      call UnitMat(rm6(1,1,1,KPhase),3)
      call SetRealArrayTo(s6(1,1,1,KPhase),ndim,0.)
      call CodeSym(rm6(1,1,1,KPhase),s6(1,1,1,KPhase),
     1             symmc(1,1,1,KPhase),0)
      do 4040i=1,3
        CellPar(i,1,KPhase)=CellPar(i,1,KPhase)*FacPar(i)
4040  continue
      call OpenFile(m50,'#tmp#.m50','formatted','unknown')
      call iom50(1,0)
      call iom50(0,0)
      call OpenFile(m40,'#tmp#.m40','formatted','unknown')
      if(ErrJana.ne.0) go to 9999
      if(nac.ge.100000) then
        write(m40,'(i6,3i5)') nac,0,1,1
      else
        write(m40,'(4i5)') nac,0,1,1
      endif
      pom=1.
      do 4050i=1,4
        write(m40,'(f9.6)') pom
        pom=0.
4050  continue
4100  read(ln,FormA80,end=4200) Radka
      write(m40,FormA1)(radka(i:i),i=1,idel(radka))
      go to 4100
4200  close(ln,status='delete')
      na(1)=nac
      nacalc=nac
      write(Radka,'(3f10.3)')  FacPar
      call ZdrcniCisla(Radka,3)
      do 4300i=1,idel(Radka)
        if(Radka(i:i).eq.' ') Radka(i:i)='x'
4300  continue
      Radka=Radka(:idel(Radka))//' supercell'
      call FeDateAndTime(ch9,ch8)
      Radka=Radka(:idel(Radka))//' '//ch9
      if(Name.ne.' ') Radka=Name(:idel(Name))//' : '//
     1                      Radka(:idel(Radka))
      FileName=FileNameIn
      call TrM4050(Klic,FileName,Radka,ich)
      call DeleteFile('#tmp#.m40')
      call DeleteFile('#tmp#.m50')
      call DeleteFile('#tmp#.l51')
      call iom50(0,0)
      if(ErrJana.ne.0) go to 9999
      call iom40only(0,0)
      go to 9999
9000  if(nor.gt.0) call trortho(1)
9999  return
      end
      subroutine DefOrtho(ich)
      include 'params.cmn'
      include 'basic.cmn'
      include 'atoms.cmn'
      include 'molec.cmn'
      include 'fepc.cmn'
      logical Change,CrwLogicQuest
      character*256 EdwStringQuest
      character*80  t80
      character*12  At,Names(mxo)
      character*2   nty
      logical SelwLogicQuest
      dimension isel(mxw21),hh(1)
      ich=0
      Change=.false.
      call trortho(0)
      xd=FeTxLength('XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX')
     1   +10.
1000  nn=0
      do 1010i=1,nacAll
       if((kfs(i).eq.1.and.kmods(i).gt.0).or.
     1    (kfx(i).eq.1.and.kmodx(i).gt.0)) then
          if(ktat(ora,nor,Atom(i)).le.0) then
            nn=nn+1
            Names(nn)=Atom(i)
          endif
        endif
1010  continue
      kk=1
      do 1100i=mxa+1,mxa+nacbAll
       if((kfs(i).eq.1.and.kmods(i).gt.0).or.
     1    (kfx(i).eq.1.and.kmodx(i).gt.0)) then
          if(ktat(ora,nor,Atom(i)).le.0) then
            nn=nn+1
            Names(nn)=Atom(i)
          endif
        endif
1100  continue
      do 1200i=1,nmolcAll
        do 1150j=1,mam(i)
          k=j+mxp*(i-1)
          if((kfsm(k).eq.1.and.kmodsm(k).gt.0).or.
     1       (kfxm(k).eq.1.and.kmodxm(k).gt.0)) then
            nn=nn+1
            write(Cislo,FormI15) j
            call Zhusti(Cislo)
            Names(nn)=Molname(i)(:idel(Molname(i)))//'#'//
     1                Cislo(:idel(Cislo))

            if(ktat(ora,nor,Names(nn)).gt.0) nn=nn-1
          endif
1150    continue
1200  continue
      m=1
2000  id=NextQuestId()
      nmax=min(12,nor)
      call FeQuestCreate(id,-1.,-1.,xd,nmax+2,1,'Orthogonalization'//
     1                   ' parameters',0,LightGray,0,0)
      dpom=40.
      xmez=5.
      xpom=(xd-2.*dpom-xmez)*.5
      il=2
      do 2040i=1,2
        if(i.eq.1) then
          t80='%Update'
        else if(i.eq.2) then
          t80='Update %all'
        endif
        call FeQuestButtonMake(id,xpom,nmax+il,dpom,ButYd,t80)
        if(i.eq.1) then
          nButtUpdate=ButtonLastMade
        else
          nButtUpdateAll=ButtonLastMade
        endif
        call FeQuestButtonOpen(ButtonLastMade,ButtonOff)
        xpom=xpom+dpom+xmez
2040  continue
      xpom=(xd-3.*dpom-2.*xmez)*.5
      il=il+1
      do 2050i=1,3
        if(i.eq.1) then
          t80='%Edit'
        else if(i.eq.2) then
          t80='%Delete'
        else
          t80='%New'
        endif
        call FeQuestButtonMake(id,xpom,nmax+il,dpom,ButYd,t80)
        if(i.eq.1) then
          nButtEdit=ButtonLastMade
        else if(i.eq.2) then
          nButtDelete=ButtonLastMade
        else
          nButtNew=ButtonLastMade
        endif
        call FeQuestButtonOpen(ButtonLastMade,ButtonOff)
        xpom=xpom+dpom+xmez
2050  continue
      if(nor.gt.12) then
        xpom=xd-13.
        call FeQuestUpDownMake(id,xpom,1,UpDownXd,UpDownYd,'up')
        nUp=UpDownLastMade
        call FeQuestUpDownMake(id,xpom,nmax+2,UpDownXd,UpDownYd,'down')
        nDown=UpDownLastMade
      endif
      xpom=7.
      t80='Atom/Molecule'
      call FeQuestLabelMake(id,xpom,1,t80,'L')
      xpom=xpom+FeTxLength(t80)+FeTxLength('XXXXXXXXXXXXXXX')
      call FeQuestLabelMake(id,xpom,1,'delta         x40','L')
2100  n1=12*(m-1)+1
      n2=min(n1+11,nor)
      call FeQuestReset('SelwNumber')
      if(nor.gt.0) then
        xpom=5.
        j=n1
        if(kk.lt.n1.or.kk.gt.n2) kk=n1
        do 2120i=1,nmax
          if(j.gt.nor) then
            call FeQuestSelwRemove(i)
          else
            t80=ora(j)
            write(t80(23:),'(2('' | '',f10.6))') ordel(j),orx40(j)
            call FeQuestSelwMake(id,xpom,i+1,t80,xd-10.,SelwYd,0,1)
            call FeQuestSelwOpen(SelwLastMade,j.eq.kk)
          endif
          j=j+1
2120    continue
      else
        call FeQuestButtonDisable(nButtEdit)
        call FeQuestButtonDisable(nButtDelete)
      endif
      if(nn.gt.0) then
        call FeQuestButtonOff(nButtNew)
      else
        call FeQuestButtonDisable(nButtNew)
      endif
      if(nor.gt.12) then
        if(n2.lt.nor) then
          call FeQuestUpDownOff(nDown)
        else
          call FeQuestUpDownDisable(nDown)
        endif
        if(n1.gt.1) then
          call FeQuestUpDownOff(nUp)
        else
          call FeQuestUpDownDisable(nUp)
        endif
      endif
2200  icont=0
      ib=0
2250  call FeQuestEvent(id,icont,ich)
      icont=1
      if(CheckType.eq.EventButton.and.
     1   (CheckNumber.eq.nButtEdit.or.CheckNumber.eq.nButtDelete.or.
     2    CheckNumber.eq.nButtNew)) then
        call FeQuestButtonOff(CheckNumber)
        ib=CheckNumber
        EventType=EventButton
        EventNumber=ButtonOK
        go to 2250
      else if(CheckType.eq.EventButton.and.(CheckNumber.eq.nButtUpdate
     1          .or.CheckNumber.eq.nButtUpdateAll)) then
        j=1
        do 2260i=n1,n2
          if(SelwLogicQuest(j)) then
            kp=i
            kk=i
          endif
          j=j+1
2260    continue
        kko=kk
        if(CheckNumber.eq.nButtUpdateAll) then
          kp=1
          kk=nor
        endif
        do 2270k=kp,kk
          ia=ktatmol(ora(k))
          if(ia.eq.0) then
            go to 2270
          else if(ia.gt.0) then
            if((kfs(ia).ne.1.or.kmods(ia).lt.1).and.
     1         (kfx(ia).ne.1.or.kmodx(ia).lt.1)) then
              go to 2270
            else if(kfs(ia).eq.1) then
              ordel(k)=a0(ia)
              orx40(k)=ax(1,ia)
            else if(kfx(ia).eq.1) then
              ordel(k)=uy(2,kmodx(ia),ia)
              orx40(k)=uy(1,kmodx(ia),ia)
            endif
          else
            ia=-ia
            if((kfsm(ia).ne.1.or.kmodsm(ia).lt.1).and.
     1         (kfxm(ia).ne.1.or.kmodxm(ia).lt.1)) then
              go to 2270
            else if(kfsm(ia).eq.1) then
              ordel(k)=a0m(ia)
              orx40(k)=axm(1,ia)
            else if(kfxm(ia).eq.1) then
              ordel(k)=uty(2,kmodxm(ia),ia)
              orx40(k)=uty(1,kmodxm(ia),ia)
            endif
          endif
          if(oreps(k).lt.0.) oreps(k)=.95
          call EM40UpdateOrtho(ora(k),orx40(k),ordel(k),oreps(k),
     1                         orsel(1,k))
2270    continue
        call FeQuestButtonOff(CheckNumber)
        kk=kko
        go to 2100
      else if(CheckType.eq.EventUpDown.and.(CheckNumber.eq.nDown.or.
     1                                      CheckNumber.eq.nUp)) then
        if(CheckNumber.eq.nDown) then
          m=m+1
        else
          m=m-1
        endif
        go to 2100
      else if(CheckType.ne.0) then
        call NebylOsetren
        go to 2250
      endif
2290  if(ich.eq.0) then
        if(ib.eq.0) then
          go to 2400
        else if(ib.eq.nButtEdit.or.ib.eq.nButtDelete) then
          j=1
          do 2300i=n1,n2
            if(SelwLogicQuest(j)) then
              kk=i
              if(ib.eq.nButtEdit) then
                go to 2800
              else
                call FeQuestRemove(id)
                go to 2500
              endif
            endif
            j=j+1
2300      continue
        else if(ib.eq.nButtNew) then
          k=nor+1
          ia=1
          call SelOneAtom('Select atom/molecule',Names,ia,nn,ich)
          ora(k)=Names(ia)
          ia=ktatmol(ora(k))
          if(ia.eq.0) then
            go to 2100
          else if(ia.gt.0) then
            if((kfs(ia).ne.1.or.kmods(ia).lt.1).and.
     1         (kfx(ia).ne.1.or.kmodx(ia).lt.1)) then
              go to 2100
            else if(kfs(ia).eq.1) then
              ordel(k)=a0(ia)
              orx40(k)=ax(1,ia)
            else if(kfx(ia).eq.1) then
              ordel(k)=uy(2,kmodx(ia),ia)
              orx40(k)=uy(1,kmodx(ia),ia)
            endif
          else
            ia=-ia
            if((kfsm(ia).ne.1.or.kmodsm(ia).lt.1).and.
     1         (kfxm(ia).ne.1.or.kmodxm(ia).lt.1)) then
              go to 2100
            else if(kfsm(ia).eq.1) then
              ordel(k)=a0m(ia)
              orx40(k)=axm(1,ia)
            else if(kfxm(ia).eq.1) then
              ordel(k)=uty(2,kmodxm(ia),ia)
              orx40(k)=uty(1,kmodxm(ia),ia)
            endif
          endif
          oreps(k)=.95
          call EM40UpdateOrtho(ora(k),orx40(k),ordel(k),oreps(k),
     1                         orsel(1,k))
          nor=k
          call FeQuestRemove(id)
          go to 1000
        endif
      endif
2400  call FeQuestRemove(id)
      go to 5000
2500  ia=ktatmol(ora(i))
      if(ia.gt.0) then
        kator(ia)=0
      else if(ia.lt.0) then
        kmor(-ia)=0
      endif
      do 2600i=kk+1,nor
        ora(i-1)=ora(i)
        ordel(i-1)=ordel(i)
        orx40(i-1)=orx40(i)
        call CopyVekI(orsel(1,i),orsel(1,i-1),mxw21)
        orsels(i-1)=orsels(i)
2600  continue
      kk=1
      nor=nor-1
      Change=.true.
      go to 1000
2800  call FeQuestRemove(id)
2805  if(kk.gt.nor) then
        ora(kk)=' '
        ordel(kk)=1.
        orx40(kk)=0.
        call SetIntArrayTo(orsel(1,kk),mxw21,1)
        orsels(kk)=mxw21
        oreps(kk)=.95
      endif
      i=(min(mxw,32)-1)/4+6
      id=NextQuestId()
      xdq=210.
      call FeQuestCreate(id,-1.,-1.,xdq,0,i,'Define/Edit '//
     1                   'orthogonalization parameters',0,LightGray,0,0)
      xpom=5.
      il=1
      do 2820i=1,4
        if(i.eq.1) then
          t80='%name'
        else if(i.eq.2) then
          xpom=xpom+70.
          t80='%delta'
        else if(i.eq.3) then
          t80='%x40'
        else
          tpom=50.
          dpom=65.
          t80='%take from M40'
        endif
        if(i.lt.4) then
          call FeQuestEdwMake(id,xpom+20.,il,xpom,il+1,t80,'C',40.,
     1                        EdwYd,0)
        else
          call FeQuestButtonMake(id,tpom,il+1,dpom,ButYd,t80)
          nButtTake=ButtonLastMade
          call FeQuestButtonOpen(ButtonLastMade,ButtonOff)
        endif
        if(i.eq.1) then
          nEdwName=EdwLastMade
          call FeQuestStringEdwOpen(EdwLastMade,ora(kk))
        else if(i.eq.2) then
          nEdwDelta=EdwLastMade
          call FeQuestRealEdwOpen(EdwLastMade,ordel(kk),.false.,.false.)
        else if(i.eq.3) then
          nEdwX40=EdwLastMade
          call FeQuestRealEdwOpen(EdwLastMade,orx40(kk),.false.,.false.)
        endif
        xpom=xpom+45.
2820  continue
      il=il+2
      call FeQuestLabelMake(id,xdq*.5,il,'Define/edit waves to be used '
     1                    //'in orthogonalization','C')
      il=il+1
      tpom=5.
      xpom=tpom+55.
      call FeQuestEdwMake(id,tpom,il,xpom,il,'%Maximal epsilon','L',40.,
     1                    EdwYd,0)
      nEdwMaxEps=EdwLastMade
      call FeQuestRealEdwOpen(EdwLastMade,min(oreps(kk),1.),
     1                        oreps(kk).lt.0.,.false.)
      xpom=120.
      call FeQuestButtonMake(id,xpom,il,65.,ButYd,'%Calculate')
      nButtCalc=ButtonLastMade
      call FeQuestButtonOpen(nButtCalc,ButtonOff)
      j=1
      il=il+1
      do 2830i=1,min(mxw,32)
        if(mod(i,4).eq.1) then
          xpom=2.5
          il=il+1
        else
          xpom=xpom+50.
        endif
        if(il.eq.6) then
          call FeQuestLabelMake(id,xpom+24.,5,'sin','C')
          call FeQuestLabelMake(id,xpom+39.,5,'cos','C')
        endif
        write(t80,'(i2,a2)') i,nty(i)
        call FeQuestCrwMake(id,xpom+2.,il,xpom+20.,il,t80,'L',CrwXd,
     1                      CrwYd,0,0)
        if(i.eq.1) nCrwFirst=CrwLastMade
        j=j+1
        call FeQuestCrwOpen(CrwLastMade,orsel(j,kk).eq.1)
        call FeQuestCrwMake(id,xpom+2.,il,xpom+35.,il,' ','L',CrwXd,
     1                      CrwYd,0,0)
        j=j+1
        call FeQuestCrwOpen(CrwLastMade,orsel(j,kk).eq.1)
2830  continue
2900  icont=0
3000  call FeQuestEvent(id,icont,ich)
      icont=1
      if(CheckType.eq.EventButton.and.CheckNumber.eq.nButtTake)
     1  then
        At=EdwStringQuest(nEdwName)
        if(At.eq.' ') then
          ia=1
          call SelOneAtom('Select atom/molecule',Names,ia,nn,ich)
          call FeQuestStringEdwOpen(nEdwName,Names(ia))
          At=Names(ia)
        endif
        call FeQuestButtonOff(nButtTake)
        t80=' '
        if(At.eq.' ') then
          t80='the atom/molecule wasn''t specified'
        else
          ia=ktatmol(At)
          if(ia.eq.0) then
            t80='the atom/molecule "'//At(:idel(At))//
     2          '" doesn''t exists'
          else if(ia.gt.0) then
            if((kfs(ia).ne.1.or.kmods(ia).lt.1).and.
     1         (kfx(ia).ne.1.or.kmodx(ia).lt.1)) then
              t80='specified atom have neither Crenel nor sawtooth'
            else if(kfs(ia).eq.1) then
              xpom=a0(ia)
              ypom=ax(1,ia)
            else if(kfx(ia).eq.1) then
              xpom=uy(2,kmodx(ia),ia)
              ypom=uy(1,kmodx(ia),ia)
            endif
          else
            ia=-ia
            if((kfsm(ia).ne.1.or.kmodsm(ia).lt.1).and.
     1         (kfxm(ia).ne.1.or.kmodxm(ia).lt.1)) then
              t80='specified position have neither Crenel nor sawtooth'
            else if(kfsm(ia).eq.1) then
              xpom=a0m(ia)
              ypom=axm(1,ia)
            else if(kfxm(ia).eq.1) then
              xpom=uty(2,kmodxm(ia),ia)
              ypom=uty(1,kmodxm(ia),ia)
            endif
          endif
        endif
        if(t80.ne.' ') then
          call FeChybne(-1.,30.,t80,' ',0,SeriousError)
          go to 2900
        else
          call FeQuestRealEdwOpen(nEdwDelta,xpom,.false.,.false.)
          call FeQuestRealEdwOpen(nEdwX40  ,ypom,.false.,.false.)
          EventType=EventEdw
          EventNumber=nEdwDelta
          go to 3000
        endif
      else if(CheckType.eq.EventButton.and.CheckNumber.eq.nButtCalc)
     1  then
        call FeQuestRealFromEdw(nEdwDelta,xpom)
        call FeQuestRealFromEdw(nEdwX40  ,ypom)
        call FeQuestRealFromEdw(nEdwMaxEps,oreps(kk))
        if(oreps(kk).le.0.) then
          oreps(kk)=.95
          call FeQuestRealEdwOpen(EdwLastMade,oreps(kk),.false.,.false.)
        endif
        At=EdwStringQuest(nEdwName)
        call EM40UpdateOrtho(At,ypom,xpom,oreps(kk),OrSel(1,kk))
        do 3500i=2,mxw21
          if(i.le.65) then
            if(OrSel(i,kk).eq.1) then
              call FeQuestCrwOn(i-1)
            else
              call FeQuestCrwOff(i-1)
            endif
          endif
3500    continue
        call FeQuestButtonOff(nButtCalc)
        go to 2900
      else if(CheckType.ne.0) then
        call NebylOsetren
        go to 3000
      endif
      if(ich.eq.0) then
        orsels(kk)=1
        nCrw=nCrwFirst
        do 4000i=1,min(mxw21-1,64)
          if(CrwLogicQuest(nCrw)) then
            orsel(i+1,kk)=1
            orsels(kk)=orsels(kk)+1
          else
            orsel(i+1,kk)=0
          endif
          nCrw=nCrw+1
4000    continue
        ora(kk)=EdwString(EdwFr)
        call FeQuestRealFromEdw(nEdwDelta ,ordel(kk))
        call FeQuestRealFromEdw(nEdwX40   ,orx40(kk))
        call FeQuestRealFromEdw(nEdwMaxEps,oreps(kk))
        if(kk.gt.nor) then
          if(ia.gt.0) then
            kator(ia)=kk
            do 4100j=2,itf(ia)+1
              kmodao(ia,j)=kmoda(ia,j)
4100        continue
          else
            kmor(-ia)=kk
          endif
          nor=kk
        endif
        Change=.true.
      endif
      call FeQuestRemove(id)
      go to 2000
5000  if(Change) then
        if(ich.eq.0) then
          call RecalcOrthoPar
        else
          ich=1
          call OneStepBack
        endif
      else
        call trortho(1)
      endif
      return
      end
      subroutine EM40UpdateOrtho(At,x40,delta,eps,isel)
      include 'params.cmn'
      include 'basic.cmn'
      include 'atoms.cmn'
      include 'molec.cmn'
      character*(*) At
      dimension Gor(mxw21,mxw21),p(mxw21),pp(mxw21),isel(*),
     1          iselo(mxw21),Gd(mxw21*(mxw21+1)),hh(1)
      if(eps.lt..999) then
        call CopyVekI(ISel,ISelO,mxw21)
        ISelO(1)=1
        call uprat(At)
        ia=ktatmol(At)
        call SetOrM(x40,delta,Gor,ia)
        do 3100i=1,mxw21
          p(i)=sqrt(Gor(i,i))
3100    continue
        do 3120i=1,mxw21
          do 3110j=1,mxw21
            Gor(i,j)=Gor(i,j)/(p(i)*p(j))
3110      continue
3120    continue
        call SetIntArrayTo(isel,mxw21,0)
        gd(1)=1.
        ngd=1
        isel(1)=1
        i=1
        do 3400j=2,mxw21
          n=0
          do 3300k=1,i
            if(isel(k).eq.0) go to 3300
            n=n+1
            p(n)=Gor(j,k)
3300      continue
          call nasob(gd,p,pp,ngd)
          call multm(pp,p,hh,1,ngd,1)
          det=sqrt(hh(1))
          if(det.le.eps) then
            isel(j)=1
            ngd=ngd+1
            n=0
            i=j
            do 3350ii=1,i
              if(isel(ii).eq.0) go to 3350
              do 3340jj=1,ii
                if(isel(jj).eq.0) go to 3340
                n=n+1
                gd(n)=Gor(ii,jj)
3340          continue
3350        continue
            call smi(gd,p,ngd,ising)
          endif
3400    continue
        ISelDif=0
        do 4000i=1,mxw21
          if(ISel(i).ne.ISelO(i)) then
            ISelDif=i
            go to 4050
          endif
4000    continue
        go to 9999
4050    if(ia.gt.0) then
          kmodmx=0
          itfp=itf(ia)
          if(itfp.eq.1) itfp=2
          do 4100i=1,itfp
            kmod=kmoda(ia,i+1)
            kmodo=kmodao(ia,i+1)
            if(2*kmod+1.ge.ISelDif) then
              if(i.eq.1) then
                call EM40RecalcOrtho(x40,delta,
     1                           x(1,ia),ux(1,1,ia),uy(1,1,ia),TRank(i),
     2                           kmod,kmodo,kfa(ia,i+1),isel,ich)
              else if(i.eq.2) then
                call EM40RecalcOrtho(x40,delta,
     1                        beta(1,ia),bx(1,1,ia),by(1,1,ia),TRank(i),
     2                        kmod,kmodo,kfa(ia,i+1),isel,ich)
              else if(i.eq.3) then
                call EM40RecalcOrtho(x40,delta,
     1                        c3(1,ia),c3x(1,1,ia),c3y(1,1,ia),TRank(i),
     2                        kmod,kmodo,kfa(ia,i+1),isel,ich)
              else if(i.eq.4) then
                call EM40RecalcOrtho(x40,delta,
     1                        c4(1,ia),c4x(1,1,ia),c4y(1,1,ia),TRank(i),
     2                        kmod,kmodo,kfa(ia,i+1),isel,ich)
              else if(i.eq.5) then
                call EM40RecalcOrtho(x40,delta,
     1                        c5(1,ia),c5x(1,1,ia),c5y(1,1,ia),TRank(i),
     2                        kmod,kmodo,kfa(ia,i+1),isel,ich)
              else if(i.eq.6) then
                call EM40RecalcOrtho(x40,delta,
     1                        c6(1,ia),c6x(1,1,ia),c6y(1,1,ia),TRank(i),
     2                        kmod,kmodo,kfa(ia,i+1),isel,ich)
              endif
            endif
            kmoda(ia,i+1)=kmod
4100      continue
        endif
      else
        call SetIntArrayTo(isel,mxw21,1)
      endif
9999  return
      end
      subroutine EM40RecalcOrtho(x40,delta,x,ux,uy,n,kmod,kmodo,kf,
     1                           iseln,ich)
      include 'params.cmn'
      include 'basic.cmn'
      dimension iseln(*),x(n),ux(n,*),uy(n,*),der(mxw21),
     1          am((mxw21*(mxw21+1))/2),yc(36),ps(mxw21,36),sol(mxw21)
      ich=0
      kmodp=kmod
      if(kf.ne.0) kmodp=kmodp-1
      nw=2*kmodp+1
      kmodop=kmodo
      if(kf.ne.0) kmodop=kmodop-1
      nwo=2*kmodop+1
      k=0
      do 1000i=1,mxw21
        if(iseln(i).ne.0) then
          k=k+1
          if(k.ge.nwo) then
            nwn=i
            go to 1050
          endif
        endif
1000  continue
      ich=1
      go to 9999
1050  kmodnp=nwn/2
      kmod=kmodnp
      if(kf.ne.0) then
        kmod=kmod+1
        call CopyVek(ux(1,kmodp+1),ux(1,kmod),n)
        call CopyVek(uy(1,kmodp+1),uy(1,kmod),n)
      endif
      call SetRealArrayTo(sol,mxw21,0.)
      call SetRealArrayTo(am,(nwo*(nwo+1))/2,0.)
      call SetRealArrayTo(ps,36*mxw21,0.)
      x4=x40-delta*.5
      dx4=.01*delta
      do 1200i=1,100
        k=0
        do 1100j=1,nwn
          if(j.gt.1) arg=pi2*float(kw(1,j/2,KPhase))*x4
          if(iseln(j).ne.0) then
            k=k+1
            if(j.eq.1) then
              der(k)=1.
            else if(mod(j,2).eq.0) then
              der(k)=sin(arg)
            else
              der(k)=cos(arg)
            endif
          endif
1100    continue
        call CopyVek(x,yc,n)
        do 1120j=1,kmodp
          arg=pi2*float(kw(1,j,KPhase))*x4
          sn=sin(arg)
          cs=cos(arg)
          do 1115k=1,n
            yc(k)=yc(k)+ux(k,j)*sn+uy(k,j)*cs
1115      continue
1120    continue
        m=0
        do 1150j=1,nwo
          derj=der(j)
          do 1130k=1,j
            m=m+1
            am(m)=am(m)+derj*der(k)
1130      continue
          do 1140k=1,n
            ps(j,k)=ps(j,k)+derj*yc(k)
1140      continue
1150    continue
        x4=x4+dx4
1200  continue
      call znorm(am,der,nwo)
      call smi(am,sol,nwo,ising)
      if(ising.gt.0) go to 9999
      call znorm(am,der,nwo)
      do 1300l=1,n
        call nasob(am,ps(1,l),sol,nwo)
        k=0
        do 1250j=1,nwn
          iw=j/2
          if(iseln(j).eq.0) then
            pom=0.
          else
            k=k+1
            pom=sol(k)
          endif
          if(j.eq.1) then
            x(l)=pom
          else if(mod(j,2).eq.0) then
            ux(l,iw)=pom
          else
            uy(l,iw)=pom
          endif
1250    continue
1300  continue
9999  return
      end
      subroutine SetOrM(x40,delta,gor,natp)
      include 'params.cmn'
      dimension gor(*)
      x1=x40-.5*delta
      x2=x40+.5*delta
      jip=1
      do 2000i=1,mxw21
        if(i.eq.1) then
          ii=1
        else
          ni=mod(i,2)
          nj=i/2
          ii=nj*2+ni
        endif
        ij=i
        ji=jip
        do 1000j=1,i
          if(j.eq.1) then
            jj=1
          else
            ni=mod(j,2)
            nj=j/2
            jj=nj*2+ni
          endif
          pom=csprod(ii,jj,x1,x2,natp)/delta
          if(i.ne.j) gor(ij)=pom
          gor(ji)=pom
          ji=ji+1
          ij=ij+mxw21
1000    continue
        jip=jip+mxw21
2000  continue
      return
      end
      subroutine RecalcOrthoPar
      include 'params.cmn'
      include 'basic.cmn'
      include 'atoms.cmn'
      include 'molec.cmn'
      dimension orp(mxw21*mxw21),gor(mxw21*mxw21),tror(mxw21*mxw21)
      do 5000ia=1,nacAll
        i=kator(ia)
        if(i.le.0) go to 5000
        itfi=itf(ia)
        ko=0
        do 1000j=2,itfi+1
          ko=max(ko,kmodao(ia,j))
1000    continue
        k=0
        do 1010j=1,mxw21
          k=k+orsel(j,i)
1010    continue
        ko=min(k,ko)
        do 1020j=2,itfi+1
          kmodao(ia,j)=min(ko,kmodao(ia,j))
1020    continue
        ko=2*ko+1
        call mator(orx40(i),ordel(i),orsel(1,i),ko,orm(1,i),ormi(1,i),
     1             ia)
        m=0
        n=0
        do 1050k=1,mxw21
          do 1040j=1,ko
            n=n+1
            if(orsel(k,i).gt.0) then
              m=m+1
              orp(n)=orm(m,i)
            else
              orp(n)=0.
            endif
1040      continue
1050    continue
        call SetOrM(orx40(i),ordel(i),gor,ia)
        call multm(orp,gor,tror,ko,mxw21,mxw21)
        do 2000n=2,itfi+1
          nrank=TRank(n-1)
          kmodm=kmodao(ia,n)
          if(kmodm.le.0) kmodm=kmoda(ia,n)
          if(n.eq.2) then
            call TrDoOrM(x(1,ia),ux(1,1,ia),uy(1,1,ia),nrank,
     1                   kfa(ia,n),kmoda(ia,n),kmodm,tror,ko)
          else if(n.eq.3) then
            call TrDoOrM(beta(1,ia),bx(1,1,ia),by(1,1,ia),nrank,
     1                   kfa(ia,n),kmoda(ia,n),kmodm,tror,ko)
          else if(n.eq.4) then
            call TrDoOrM(c3(1,ia),c3x(1,1,ia),c3y(1,1,ia),nrank,
     1                   kfa(ia,n),kmoda(ia,n),kmodm,tror,ko)
          else if(n.eq.5) then
            call TrDoOrM(c4(1,ia),c4x(1,1,ia),c4y(1,1,ia),nrank,
     1                   kfa(ia,n),kmoda(ia,n),kmodm,tror,ko)
          else if(n.eq.6) then
            call TrDoOrM(c5(1,ia),c5x(1,1,ia),c5y(1,1,ia),nrank,
     1                   kfa(ia,n),kmoda(ia,n),kmodm,tror,ko)
          else
            call TrDoOrM(c6(1,ia),c6x(1,1,ia),c6y(1,1,ia),nrank,
     1                   kfa(ia,n),kmoda(ia,n),kmodm,tror,ko)
          endif
2000    continue
5000  continue
      return
      end
      subroutine TrDoOrM(x,ux,uy,n,kfx,kmodx,kmodxo,tror,ord)
      include 'params.cmn'
      include 'basic.cmn'
      integer ord
      dimension x(n),ux(n,mxw),uy(n,mxw),tror(ord,mxw21),orx(2*mxw+1)
      if(kfx.eq.0) then
        jk=mxw21
        jko=2*kmodxo+1
        kmodxp=kmodx
      else
        jk=mxw21-2
        jko=2*kmodxo-1
        kmodxp=kmodx-1
      endif
      if(kmodxp.le.0) then
        kmodxo=kmodx
        go to 9999
      endif
      do 1040i=1,n
        orx(1)=x(i)
        m=1
        do 1020j=1,kmodxp
          m=m+1
          orx(m)=ux(i,j)
          m=m+1
          orx(m)=uy(i,j)
1020    continue
        do 1022j=m+1,jk
          orx(j)=0.
1022    continue
        if(kfx.ne.0) then
          m=m+1
          orx(m)=ux(i,kmodx)
          m=m+1
          orx(m)=uy(i,kmodx)
        endif
        pom=0.
        do 1025j=1,jk
          pom=pom+tror(1,j)*orx(j)
1025    continue
        x(i)=pom
        do 1030j=2,jko
          pom=0.
          do 1028k=j,jk
            pom=pom+tror(j,k)*orx(k)
1028      continue
          jj=j/2
          if(mod(j,2).eq.0) then
            ux(i,jj)=pom
          else
            uy(i,jj)=pom
          endif
1030    continue
        if(kfx.ne.0) then
          jj=jko/2+1
          ux(i,jj)=orx(jko+1)
          uy(i,jj)=orx(jko+2)
        endif
1040  continue
      kmodx=kmodxo
9999  return
      end
      subroutine EM40EditParameters(ParType,ParBlock)
      include 'params.cmn'
      include 'basic.cmn'
      include 'atoms.cmn'
      include 'molec.cmn'
      include 'powder.cmn'
      include 'main.cmn'
      integer ParType,ParBlock
      logical FileDiff,FeYesNo
      if(ParType.eq.IdParamExt.or.ParType.eq.IdParamAnom)
     1   call OpenCommandsRefine
      call SetSymmWaves
      ich=0
      if(ParType.eq.IdParamOptions) then
        call EM40ParamOptions(ich)
      else if(ParType.eq.IdParamScale) then
        call EM40EditScales(ich)
      else if(ParType.eq.IdParamTwin) then
        call EM40EditTwVols(ich)
      else if(ParType.eq.IdParamExt) then
        call EM40Extinction(ich)
      else if(ParType.eq.IdParamAnom) then
        call EM40EditAnom(ich)
      else if(ParType.eq.IdParamPowder) then
        call PwdOptions(ich)
      else if(ParType.eq.IdParamAtoms) then
        if(ParBlock.le.1) then
          iap=nacOff+1
          iak=nacOff+nac
        else
          iakp=mxa
          do 1020i=1,ParBlock-1
            iap=iakp+1
            iak=iakp+iam(i)
            iakp=iakp+iamn(i)
1020      continue
        endif
        call EM40EditAtoms(iap,iak,ich)
      else if(ParType.eq.IdParamMolec) then
        call EM40EditMolecules(ich)
      endif
      if(ich.ne.0) then
        call DeleteFile(PreviousM40)
        call DeleteFile(PreviousM50)
        if(ParType.eq.IdParamPowder) then
          call DeleteFile(fln(:ifln)//'.l41')
          call DeleteFile(fln(:ifln)//'_skipfrto.tmp')
        endif
        go to 5000
      endif
      if(ParType.eq.IdParamExt.or.ParType.eq.IdParamAnom) then
        call iom50(1,0)
        call RewriteCommandsRefine(1)
      else if(ParType.eq.IdParamPowder) then
        call QuestionRewriteFile(41)
        go to 5000
      endif
      call iom40(1,0)
      if(FileDiff(fln(:ifln)//'.m40',PreviousM40).or.
     1   FileDiff(fln(:ifln)//'.m50',PreviousM50)) then
        if(.not.FeYesNo(-1.,-1.,'Do you want to rewrite changed files?',
     1     1)) then
          call CopyFile(PreviousM40,fln(:ifln)//'.m40')
          call CopyFile(PreviousM50,fln(:ifln)//'.m50')
          call DeleteFile(PreviousM40)
          call DeleteFile(PreviousM50)
        endif
      endif
5000  UseM41KeyWordFiles=.false.
      return
      end
      subroutine EM40ParamOptions(ich)
      include 'params.cmn'
      include 'basic.cmn'
      include 'fepc.cmn'
      include 'molec.cmn'
      include 'atoms.cmn'
      character*80 Veta
      logical CrwLogicQuest
      dimension px(9),py(9),pz(9)
      id=NextQuestId()
      xqd=220.
      il=3
      if(ndimi.gt.0) il=il+2
      call FeQuestCreate(id,-1.,-1.,xqd,0,il,'Options',0,LightGray,
     1                   0,OKForBasicFiles)
      il=1
      xpom=5.
      Veta='Atomic displacemt parameters:'
      call FeQuestLabelMake(id,xpom,il,Veta,'L')
      tpom=xpom+CrwgXd+3
      do 1100i=1,2
        il=il+1
        if(i.eq.1) then
          Veta='use %U'
        else
          Veta='use %beta'
        endif
        call FeQuestCrwMake(id,tpom,il,xpom,il,Veta,'L',CrwgXd,CrwgYd,0,
     1                      1)
        if(i.eq.1) nCrwUseU=CrwLastMade
        call FeQuestCrwOpen(CrwLastMade,i-1.eq.lite)
1100  continue
      il=1
      xpom=xpom+xqd*.5
      Veta='Rotation angles for molecules:'
      call FeQuestLabelMake(id,xpom,il,Veta,'L')
      tpom=xpom+CrwgXd+3
      do 1200i=1,2
        il=il+1
        if(i.eq.1) then
          Veta='use %axial angles'
        else
          Veta='use %Eulerian angles'
        endif
        call FeQuestCrwMake(id,tpom,il,xpom,il,Veta,'L',CrwgXd,CrwgYd,0,
     1                      3)
        if(i.eq.1) nCrwAxial=CrwLastMade
        call FeQuestCrwOpen(CrwLastMade,i.eq.2-irot)
1200  continue
      if(ndimi.gt.0) then
        il=il+1
        call FeQuestLineMake(id,il)
        il=il+1
        Veta='De%fine wave vectors'
        dpom=FeTxLengthUnder(Veta)+10.
        xpom=(xqd-dpom)*.5
        call FeQuestButtonMake(id,xpom,il,dpom,ButYd,Veta)
        nButtDefWaves=ButtonLastMade
        call FeQuestButtonOpen(ButtonLastMade,ButtonOff)
      endif
1400  icont=0
1500  call FeQuestEvent(id,icont,ich)
      icont=1
      if(CheckType.eq.EventButton.and.CheckNumber.eq.nButtDefWaves) then
        ib=nButtDefWaves
        call EM40DefWaves(ich)
        call FeQuestButtonOff(ib)
        go to 1400
      else if(CheckType.ne.0) then
        call NebylOsetren
        go to 1500
      endif
      if(ich.eq.0) then
        iroto=irot
        if(CrwLogicQuest(nCrwAxial)) then
          irot=1
        else
          irot=0
        endif
        if(iroto.ne.irot) then
          do 3000i=1,nmolc
            do 2500j=1,mam(i)
              ji=j+(i-1)*mxp
              call matinv(TriMol(1,ji),py,pom,3)
              call matinv(TrMol(1,ji),pz,pom,3)
              call multm(py,RotMol(1,ji),px,3,3,3)
              call multm(px,pz,py,3,3,3)
              if(RotSign(ji).lt.0) call RealMatrixToOpposite(py,py,3)
              call EM40GetAngles(py,irot,euler(1,ji))
2500        continue
3000      continue
        endif
        if(CrwLogicQuest(nCrwUseU)) then
          lite=0
        else
          lite=1
        endif
      endif
      call FeQuestRemove(id)
9999  return
      end
      subroutine EM40EditScales(ich)
      include 'params.cmn'
      include 'basic.cmn'
      include 'atoms.cmn'
      include 'fepc.cmn'
      dimension tpoma(3),xpoma(3)
      character*80 t80
      character*12 at,pn
      xdq=230.
      mxscs=36
      il=3+(mxscs-1)/3
      tpoma(1)=5.
      pom=(xdq-3.*37.-10.)/3.
      pom=(xdq-5.-37.-pom)/2.
      do 1010i=2,3
        tpoma(i)=tpoma(i-1)+pom
1010  continue
      xpoma(3)=xdq-42.-CrwXd
      do 1020i=2,1,-1
        xpoma(i)=xpoma(i+1)-pom
1020  continue
      mxscuold=mxscu
      id=NextQuestId()
      call FeQuestCreate(id,-1.,-1.,xdq,0,il,'Edit scale parameters',0,
     1                   LightGray,0,OKForBasicFiles)
      il=1
      t80='%Max.number of scales'
      xpom=xdq*.5-7.5
      tpom=xpom-FeTxLength(t80)-5.-EdwYd
      call FeQuestEudMake(id,tpom,il,xpom,il,t80,'L',15.,EdwYd,1)
      nEdwNumber=EdwLastMade
      call FeQuestIntEdwOpen(EdwLastMade,mxscu,.false.)
      call FeQuestEudOpen(EdwLastMade,7-itwph,mxsc-itwph,1,0.,0.,0.)
      xpom=xdq-10.
      call FeQuestUpDownMake(id,xpom,il,UpDownXd,UpDownYd,'up')
      nUp=UpDownLastMade
      il=il+1
      j=1
      do 1100i=1,mxscs
        k=0
        call FeMakeParEdwCrw(id,tpoma(j),xpoma(j),il,' ',pom,k,.false.,
     1                       nEdw,nCrw)
        call FeQuestEdwClose(nEdw)
        call FeQuestCrwClose(nCrw)
        if(i.eq.1) then
          nEdwPrv=nEdw
          nCrwPrv=nCrw
        endif
        if(mod(j,3).eq.0) then
          j=1
          il=il+1
        else
          j=j+1
        endif
1100  continue
      call FeQuestUpDownMake(id,xpom,il,UpDownXd,UpDownYd,'down')
      nDown=UpDownLastMade
      dpom=50.
      pom=10.
      xpom=(xdq-2.*dpom-pom)*.5
      do 1200i=1,2
        if(i.eq.1) then
          at='%Refine all'
        else if(i.eq.2) then
          at='%Fix all'
        endif
        call FeQuestButtonMake(id,xpom,il,50.,ButYd,at)
        if(i.eq.1) then
          nButtRefineAll=ButtonLastMade
        else if(i.eq.2) then
          nButtFixAll=ButtonLastMade
        endif
        call FeQuestButtonOpen(ButtonLastMade,ButtonOff)
        xpom=xpom+dpom+pom
1200  continue
      mp=1
1250  kip=mp
      nEdw=nEdwPrv
      nCrw=nCrwPrv
      do 1300i=1,mxscs
        call kdoco(kip,at,pn,1,pom,spom)
        if(i.le.mxscu) then
          k=ki(kip)
        else
          k=0
        endif
        if(kip.le.mxscu) then
          call FeOpenParEdwCrw(id,nEdw,nCrw,pn,pom,k,.false.)
        else
          call FeQuestEdwClose(nEdw)
          call FeQuestCrwClose(nCrw)
        endif
        nEdw=nEdw+1
        nCrw=nCrw+1
        kip=kip+1
1300  continue
1450  icont=0
1470  if(mxscu.gt.mxscs) then
        call FeQuestUpDownOpen(nUp  ,UpDownOff)
        call FeQuestUpDownOpen(nDown,UpDownOff)
      else
        call FeQuestUpDownClose(nUp)
        call FeQuestUpDownClose(nDown)
      endif
1500  call FeQuestEvent(id,icont,ich)
      icont=1
      if(CheckType.eq.EventEdw.and.CheckNumber.eq.nEdwNumber) then
        call FeQuestIntFromEdw(nEdwNumber,mxscu)
        mxscutw=mxscu+itwph-1
        nEdw=nEdwPrv
        nCrw=nCrwPrv
        kip=mp
        do 2100i=1,mxscs
          if(kip.gt.mxscuold.and.kip.le.mxscu) then
            call kdoco(kip,at,pn,1,pom,spom)
            k=ki(kip)
            call FeOpenParEdwCrw(id,nEdw,nCrw,pn,pom,k,.false.)
          else if(kip.gt.mxscu) then
            call FeQuestEdwClose(nEdw)
            call FeQuestCrwClose(nCrw)
          endif
          nEdw=nEdw+1
          nCrw=nCrw+1
          kip=kip+1
2100    continue
        mxscuold=mxscu
        go to 1470
      else if(CheckType.eq.EventButton.and.
     1        (CheckNumber.eq.nButtRefineAll.or.
     2         CheckNumber.eq.nButtFixAll)) then
        if(CheckNumber.eq.nButtRefineAll) then
          k=1
        else
          k=0
        endif
        call SetIntArrayTo(kis,mxscu,k)
        nCrw=nCrwPrv
        kip=mp
        do 2200i=1,36
          if(kip.le.mxscu) then
            call FeQuestCrwOpen(nCrw,k.eq.1)
          else
            go to 2210
          endif
          nCrw=nCrw+1
          kip=kip+1
2200    continue
2210    call FeQuestButtonoff(CheckNumber)
        go to 1450
      else if(CheckType.eq.EventUpDown) then
        call FeQuestUpDownOff(CheckNumber)
        nEdw=nEdwPrv
        nCrw=nCrwPrv
        call FeUpdateParamAndKeys(nEdw,nCrw,sc(mp),Ki(mp),mp+mxscs)
        if(CheckNumber.eq.nUp) then
           i=mp-mxscs
           if(i.gt.0) then
             mp=i
           else
             EventType=0
             go to 1500
           endif
        else if(CheckNumber.eq.nDown) then
           i=mp+mxscs
           if(i.lt.mxscu) then
             mp=i
           else
             EventType=0
             go to 1500
           endif
        endif
        go to 1250
      else if(CheckType.ne.0) then
        call NebylOsetren
        go to 1500
      endif
      if(ich.eq.0) then
        nEdw=nEdwPrv
        nCrw=nCrwPrv
        call FeUpdateParamAndKeys(nEdw,nCrw,sc(mp),Ki(mp),mp+mxscs)
        call iom40(1,0)
      endif
      call FeQuestRemove(id)
      return
      end
      subroutine EM40EditTwVols(ich)
      include 'params.cmn'
      include 'basic.cmn'
      include 'atoms.cmn'
      include 'fepc.cmn'
      dimension tpoma(3),xpoma(3)
      character*80 t80
      character*12 at,pn
      logical lpom
      xdq=230.
      il=3+(itwph-2)/3
      tpoma(1)=5.
      pom=(xdq-3.*37.-10.)/3.
      pom=(xdq-5.-37.-pom)/2.
      do 1010i=2,3
        tpoma(i)=tpoma(i-1)+pom
1010  continue
      xpoma(3)=xdq-42.-CrwXd
      do 1020i=2,1,-1
        xpoma(i)=xpoma(i+1)-pom
1020  continue
      id=NextQuestId()
      if(isPowder) then
        t80='Edit twin parameters'
      else
        t80='Edit phase fractions'
      endif
      call FeQuestCreate(id,-1.,-1.,xdq,0,il,t80,0,LightGray,0,
     1                   OKForBasicFiles)
      il=1
      kip=mxscu+1
      j=1
      do 1120i=2,itwph
        call kdoco(kip,at,pn,1,pom,spom)
        call FeMakeParEdwCrw(id,tpoma(j),xpoma(j),il,pn,pom,ki(kip),
     1                       .false.,nEdw,nCrw)
        if(i.eq.2) then
          nEdwPrv=nEdw
          nCrwPrv=nCrw
        endif
        if(mod(j,3).eq.0) then
          j=1
          if(i.ne.itwph) il=il+1
        else
          j=j+1
        endif
        kip=kip+1
1120  continue
      il=il+1
      dpom=50.
      pom=10.
      xpom=(xdq-3.*dpom-2.*pom)*.5
      do 1300i=1,3
        if(i.eq.1) then
          at='%Refine all'
        else if(i.eq.2) then
          at='%Fix all'
        else if(i.eq.3) then
          at='Re%set'
        endif
        call FeQuestButtonMake(id,xpom,il,50.,ButYd,at)
        if(i.eq.1) then
          nButtRefineAll=ButtonLastMade
        else if(i.eq.2) then
          nButtFixAll=ButtonLastMade
        else if(i.eq.3) then
          nButtReset=ButtonLastMade
        endif
        call FeQuestButtonOpen(ButtonLastMade,ButtonOff)
        xpom=xpom+dpom+pom
1300  continue
1450  icont=0
1500  call FeQuestEvent(id,icont,ich)
      icont=1
      if(CheckType.eq.EventButton.and.
     1        (CheckNumber.eq.nButtRefineAll.or.
     2         CheckNumber.eq.nButtFixAll)) then
        if(CheckNumber.eq.nButtRefineAll) then
          lpom=.true.
        else
          lpom=.false.
        endif
        nCrw=nCrwPrv
        do 2210i=2,itwph
          call FeQuestCrwOpen(nCrw,lpom)
          nCrw=nCrw+1
2210    continue
        call FeQuestButtonoff(CheckNumber)
        go to 1450
      else if(CheckType.eq.EventButton.and.CheckNumber.eq.nButtReset)
     1  then
        nEdw=nEdwPrv
        dpom=1./float(itwph)
        do 2300i=2,itwph
          call FeQuestRealEdwOpen(nEdw,dpom,.false.,.false.)
          nEdw=nEdw+1
2300    continue
        call FeQuestButtonoff(CheckNumber)
        go to 1450
      else if(CheckType.ne.0) then
        call NebylOsetren
        go to 1500
      endif
      if(ich.eq.0) then
        nEdw=nEdwPrv
        nCrw=nCrwPrv
        kip=mxscu+1
        call FeUpdateParamAndKeys(nEdw,nCrw,sctw(2),Ki(kip),itwph-1)
        call iom40(1,0)
      endif
      call FeQuestRemove(id)
      return
      end
      subroutine EM40Extinction(ich)
      include 'params.cmn'
      include 'basic.cmn'
      include 'refine.cmn'
      include 'atoms.cmn'
      include 'fepc.cmn'
      dimension tpoma(3),xpoma(3)
      character*12 at,pn
      character*80 t80
      integer ExtType,ExtTensor,ExtTensorOld,ExtDistr
      logical CrwLogicQuest,lpom
      equivalence (NacetlInt(6),ExtTensor),(NacetlInt(7),ExtType),
     1            (NacetlInt(8),ExtDistr)
      xdq=230.
      tpoma(1)=10.
      pom=(xdq-3.*37.-10.)/3.
      pom=(xdq-5.-37.-pom)/2.
      do 1000i=2,3
        tpoma(i)=tpoma(i-1)+pom
1000  continue
      xpoma(3)=xdq-42.-CrwXd
      do 1010i=2,1,-1
        xpoma(i)=xpoma(i+1)-pom
1010  continue
      il=6
      id=NextQuestId()
      call FeQuestCreate(id,-1.,-1.,xdq,0,il,
     1                   'Edit extinction parameters',
     2                   0,LightGray,0,OKForBasicFiles)
      xpom=10.+FeTxLength('XXXXXXXXXXX')
      do 1050i=1,3
        if(i.eq.1) then
          t80='%None'
        else if(i.eq.2) then
          t80='%Isotropic'
        else
          t80='%Anisotropic'
        endif
        call FeQuestCrwMake(id,5.,i,xpom,i,t80,'L',CrwgXd,CrwgYd,1,1)
        if(i.eq.1) nCrwExtFirst=CrwLastMade
1050  continue
      nCrwExtLast=CrwLastMade
      tpom=xpom+30.
      xpom=tpom+FeTxLength('XXXXXX')+5.
      do 1100i=1,3
        if(i.eq.1) then
          t80='Type %1'
        else if(i.eq.2) then
          t80='Type %2'
        else
          t80='%Mixed'
        endif
        call FeQuestCrwMake(id,tpom,i,xpom,i,t80,'L',CrwgXd,CrwgYd,1,
     1                      2)
        if(i.eq.1) nCrwTypeFirst=CrwLastMade
1100  continue
      nCrwTypeLast=CrwLastMade
      tpom=xpom+30.
      xpom=tpom+FeTxLength('XXXXXXXXXX')+5.
      do 1200i=1,2
        if(i.eq.1) then
          t80='%Gaussian'
        else
          t80='%Lorentzian'
        endif
        call FeQuestCrwMake(id,tpom,i,xpom,i,t80,'L',CrwgXd,CrwgYd,0,
     1                      3)
        if(i.eq.1) then
          nCrwGauss=CrwLastMade
        else if(i.eq.2) then
          nCrwLorentz=CrwLastMade
        endif
1200  continue
      il=3
      if(.not.TBarPresent) then
        call FeQuestEdwMake(id,tpom,il,xpom,il,'Ra%dius [mm]','L',40.,
     1                      EdwYd,0)
        nEdwRadius=EdwLastMade
        call FeQuestRealEdwOpen(EdwLastMade,NacetlReal(NactiInt+9),
     1                          .false.,.false.)
      endif
      il=il+1
      kip=mxsc+1
      j=1
      do 1300i=1,6
        call kdoco(kip,at,pn,1,pom,spom)
        call FeMakeParEdwCrw(id,tpoma(j),xpoma(j),il,pn,pom,ki(kip),
     1                       .false.,nEdw,nCrw)
        if(i.eq.1) then
          nEdwPrv=nEdw
          nCrwPrv=nCrw
        endif
        call FeQuestEdwClose(nEdw)
        call FeQuestCrwClose(nCrw)
        if(mod(j,3).eq.0) then
          j=1
          if(i.ne.6) il=il+1
        else
          j=j+1
        endif
        kip=kip+1
1300  continue
      il=il+1
      dpom=50.
      pom=10.
      xpom=(xdq-3.*dpom-2.*pom)*.5
      do 1350i=1,3
        if(i.eq.1) then
          at='%Refine all'
        else if(i.eq.2) then
          at='%Fix all'
        else if(i.eq.3) then
          at='Re%set'
        endif
        call FeQuestButtonMake(id,xpom,il,50.,ButYd,at)
        if(i.eq.1) then
          nButtRefineAll=ButtonLastMade
        else if(i.eq.2) then
          nButtFixAll=ButtonLastMade
        else if(i.eq.3) then
          nButtReset=ButtonLastMade
        endif
        call FeQuestButtonOpen(ButtonLastMade,ButtonOff)
        xpom=xpom+dpom+pom
1350  continue
1500  nCrw=nCrwExtFirst
      do 1510i=1,3
        if(ExtType.eq.3.and.i.eq.3) then
          call FeQuestCrwClose(nCrw)
        else
          call FeQuestCrwOpen(nCrw,i-1.eq.ExtTensor)
        endif
        nCrw=nCrw+1
1510  continue
      if(ExtType.eq.1) then
        ikie=2
        iec=7
      else
        ikie=1
        iec=1
      endif
      nCrw=nCrwTypeFirst
      do 1520i=1,3
        if(ExtTensor.eq.0.or.(ExtTensor.eq.2.and.i.eq.3)) then
          call FeQuestCrwClose(nCrw)
        else
          call FeQuestCrwOpen(nCrw,i.eq.ExtType)
        endif
        nCrw=nCrw+1
1520  continue
1600  if((ExtType.eq.1.or.ExtType.eq.3).and.
     1    .not.CrwLogicQuest(nCrwExtFirst)) then
        nCrw=nCrwGauss
        do 1620i=1,2
          call FeQuestCrwOpen(nCrw,i.eq.ExtDistr)
          nCrw=nCrw+1
1620    continue
      else
        do 1640i=nCrwGauss,nCrwLorentz
          call FeQuestCrwClose(i)
1640    continue
        ExtDistr=1
      endif
      if(ExtType.eq.2) then
        kip=mxsc+1
      else
        kip=mxsc+7
      endif
      if(ExtTensor.eq.0) then
        imx=0
        iext=1
      else if(ExtTensor.eq.1) then
        imx=1
        iext=1
      else if(ExtTensor.eq.2) then
        imx=6
        iext=2
      endif
      if(ExtType.eq.3) imx=2
      nEdw=nEdwPrv
      nCrw=nCrwPrv
      do 1700i=1,6
        if(i.le.imx) then
          call kdoco(kip,at,pn,1,pom,spom)
          call FeQuestEdwLabelChange(id,nEdw,pn)
          call FeQuestRealEdwOpen(nEdw,pom,.false.,.false.)
          call FeQuestCrwOpen(nCrw,ki(kip).ne.0)
          if(imx.ne.2) then
            kip=kip+1
          else
            kip=kip-6
          endif
        else
          call FeQuestEdwClose(nEdw)
          call FeQuestCrwClose(nCrw)
        endif
        nEdw=nEdw+1
        nCrw=nCrw+1
1700  continue
2000  icont=0
2500  call FeQuestEvent(id,icont,ich)
      icont=1
      if(CheckType.eq.EventCrw.and.CheckNumber.le.nCrwExtLast) then
        ExtTensorOld=ExtTensor
        do 2510i=nCrwExtFirst,nCrwExtLast
          if(CrwLogicQuest(i)) then
            ExtTensor=i-nCrwExtFirst
            go to 2515
          endif
2510    continue
2515    if(ExtTensor.eq.0) then
          call SetRealArrayTo(ec,12,0.)
          call SetIntArrayTo(kie,12,0)
          ExtType=1
          ExtDistr=1
          iec=7
          ikie=2
        else
          if(ExtTensor.eq.1) then
            if(ExtTensorOld.eq.0) then
              ec(iec,1)=0.01
            else if(ExtTensorOld.eq.2) then
              pom=(ec(iec,1)+ec(iec+1,1)+ec(iec+2,1))*.333333
              if(pom.gt.0.) then
                ec(iec,1)=sqrt(pom)
                if(ExtType.eq.2) ec(iec,1)=1./ec(iec,1)
              else
                ec(iec,1)=.01
              endif
            endif
            call SetRealArrayTo(ec(iec+1,1),5,0.)
            call SetIntArrayTo(kie,12,0)
            kie(1,ikie,1)=1
          else if(ExtTensor.eq.2) then
            if(ExtTensorOld.eq.0) then
              pom=0.01
            else if(ExtTensorOld.eq.1) then
              pom=max(ec(iec,1),0.01)**2
            endif
            if(ExtType.eq.2) pom=1./pom
            call SetRealArrayTo(ec(iec,1),3,pom)
            call SetRealArrayTo(ec(iec+3,1),3,0.)
            call SetIntArrayTo(kie(1,ikie,1),6,1)
          endif
        endif
        go to 1500
      else if(CheckType.eq.EventCrw.and.CheckNumber.le.nCrwTypeLast)
     1  then
        do 2520i=nCrwTypeFirst,nCrwTypeLast
          if(CrwLogicQuest(i)) then
            ExtType=i-nCrwTypeFirst+1
            go to 2525
          endif
2520    continue
2525    if(ExtType.eq.1) then
          ikie=2
          iec=7
        else if(ExtType.eq.2) then
          ikie=1
          iec=1
        else if(ExtType.eq.3) then
          ikie=3-ikie
          iec=8-iec
        endif
        if(ExtType.ne.3) then
          call SetRealArrayTo(ec,12,0.)
          call SetIntArrayTo(kie,12,0)
        endif
        if(ExtTensor.eq.1) then
          ec(iec,1)=0.01
          kie(1,ikie,1)=1
        else if(ExtTensor.eq.2) then
          pom=0.01
          if(ExtType.eq.2) pom=1./pom
          call SetRealArrayTo(ec(iec,1),3,pom)
          call SetRealArrayTo(ec(iec+3,1),3,0.)
          call SetIntArrayTo(kie(1,ikie,1),6,1)
        endif
        go to 1500
      else if(CheckType.eq.EventButton.and.
     1        (CheckNumber.eq.nButtRefineAll.or.
     2         CheckNumber.eq.nButtFixAll)) then
        if(CheckNumber.eq.nButtRefineAll) then
          lpom=.true.
        else
          lpom=.false.
        endif
        nCrw=nCrwPrv
        do 2600i=1,imx
          call FeQuestCrwOpen(nCrw,lpom)
          nCrw=nCrw+1
2600    continue
        call FeQuestButtonoff(CheckNumber)
        go to 2000
      else if(CheckType.eq.EventButton.and.CheckNumber.eq.nButtReset)
     1  then
        call SetRealArrayTo(ec,12,0.)
        if(ExtTensor.eq.1) then
          ec(iec,1)=0.01
          if(ExtType.eq.3) ec(8-iec,1)=.01
        else if(ExtTensor.eq.2) then
          pom=0.0001
          if(ExtType.eq.2) pom=1./pom
          call SetRealArrayTo(ec(iec,1),3,pom)
          call SetRealArrayTo(ec(iec+3,1),3,0.)
        endif
        call FeQuestButtonoff(CheckNumber)
        go to 1500
      else if(CheckType.ne.0) then
        call NebylOsetren
        go to 2500
      endif
      if(ich.eq.0) then
        do 3200i=nCrwGauss,nCrwLorentz
          if(CrwLogicQuest(i)) then
            ExtDistr=i-nCrwGauss+1
            go to 3250
          endif
3200    continue
3250    if(.not.TBarPresent)
     1    call FeQuestRealFromEdw(nEdwRadius,NacetlReal(NactiInt+9))
        call FeUpdateParamAndKeys(nEdwPrv,nCrwPrv,ec(iec,1),
     1                            Kie(1,ikie,1),imx)
        if(ExtType.eq.3) then
          i=3-ikie
          j=8-iec
          ec(j,1)=ec(iec+1,1)
          ec(iec+1,1)=0.
          Kie(1,i,1)=Kie(2,ikie,1)
          Kie(2,ikie,1)=0
        endif
      endif
9999  call FeQuestRemove(id)
      return
      end
      subroutine EM40EditAnom(ich)
      include 'params.cmn'
      include 'basic.cmn'
      include 'atoms.cmn'
      include 'fepc.cmn'
      character*12 at
      logical lpom
      if(kanref.eq.0) then
        call CopyVek(ffr(1,KPhase),ffra(1,1,KPhase),nf)
        call CopyVek(ffi(1,KPhase),ffia(1,1,KPhase),nf)
        call SetIntArrayTo(kif(1,1,1),nf,0)
        call SetIntArrayTo(kif(1,2,1),nf,0)
      endif
      id=NextQuestId()
      xdq=230.
      call FeQuestCreate(id,-1.,-1.,230.,0,nf/2+4,' ',0,LightGray,0,
     1                   OKForBasicFiles)
      xpom=(xdq-FeTxLength('XXXXXXXXXXXXXXXXXXXXXX'))*.5-CrwXd-4.
      il=1
      call FeQuestCrwMake(id,115.,il,xpom,il,'%Allow f'',f" refinement',
     1                    'C',CrwXd,CrwYd,1,0)
      nCrwAllow=CrwLastMade
      call FeQuestCrwOpen(nCrwAllow,kanref.ne.0)
      il=il+1
      do 1100i=1,nf
        if(mod(i,2).eq.1) then
          tpom=5.
          il=il+1
        else
          tpom=120.
        endif
        xpom=tpom+10.
        call FeMakeParEdwCrw(id,tpom,xpom,il,AtTypeFull(i,KPhase),
     1                       ffra(i,1,KPhase),kif(i,1,1),.false.,nEdw,
     2                       nCrw)
        if(i.eq.1) then
          nCrwPrv=nCrw
          nEdwPrv=nEdw
        endif
        xpom=xpom+50.
        call FeMakeParEdwCrw(id,tpom,xpom,il,' ',ffia(i,1,KPhase),
     1                       kif(i,2,1),.false.,nEdw,nCrw)
1100  continue
      il=il+1
      dpom=50.
      pom=10.
      xpom=(xdq-3.*dpom-2.*pom)*.5
      do 1150i=1,3
        if(i.eq.1) then
          at='%Refine all'
        else if(i.eq.2) then
          at='%Fix all'
        else if(i.eq.3) then
          at='Re%set'
        endif
        call FeQuestButtonMake(id,xpom,il,50.,ButYd,at)
        if(i.eq.1) then
          nButtRefineAll=ButtonLastMade
        else if(i.eq.2) then
          nButtFixAll=ButtonLastMade
        else if(i.eq.3) then
          nButtReset=ButtonLastMade
        endif
        call FeQuestButtonOpen(ButtonLastMade,ButtonOff)
        xpom=xpom+dpom+pom
1150  continue
1200  xpom=32.5
      il=2
      do 1205i=1,2
        if(kanref.eq.1) then
          call FeQuestLabelMake(id,xpom,il,'f''','C')
        else
          call FeQuestLabelRemove(id,xpom,il,'f''','C')
        endif
        xpom=xpom+50.
        if(kanref.eq.1) then
          call FeQuestLabelMake(id,xpom,il,'f"','C')
        else
          call FeQuestLabelRemove(id,xpom,il,'f"','C')
        endif
        xpom=147.5
1205  continue
      nedw=nEdwPrv
      ncrw=nCrwPrv
      j=0
      do 1210i=1,2*nf
        if(kanref.eq.1) then
          if(mod(i,2).eq.0) then
            pom=ffia(j,1,KPhase)
            k=2
          else
            j=j+1
            pom=ffra(j,1,KPhase)
            k=1
          endif
          call FeQuestRealEdwOpen(nedw,pom,.false.,.false.)
          call FeQuestCrwOpen(ncrw,kif(j,k,1).ne.0)
        else
          call FeQuestEdwClose(nedw)
          call FeQuestCrwClose(ncrw)
        endif
        nedw=nedw+1
        ncrw=ncrw+1
1210  continue
1400  icont=0
1500  call FeQuestEvent(id,icont,ich)
      icont=1
      if(CheckType.eq.EventCrw.and.CheckNumber.eq.1) then
        kanref=1-kanref
        go to 1200
      else if(CheckType.eq.EventButton.and.
     1        (CheckNumber.eq.nButtRefineAll.or.
     2         CheckNumber.eq.nButtFixAll)) then
        if(CheckNumber.eq.nButtRefineAll) then
          lpom=.true.
        else
          lpom=.false.
        endif
        nCrw=nCrwPrv
        do 1600i=1,2*nf
          call FeQuestCrwOpen(nCrw,lpom)
          nCrw=nCrw+1
1600    continue
        call FeQuestButtonoff(CheckNumber)
        go to 1400
      else if(CheckType.eq.EventButton.and.CheckNumber.eq.nButtReset)
     1  then
        call CopyVek(ffr(1,KPhase),ffra(1,1,KPhase),nf)
        call CopyVek(ffi(1,KPhase),ffia(1,1,KPhase),nf)
        call FeQuestButtonoff(CheckNumber)
        go to 1200
      else if(CheckType.ne.0) then
        call NebylOsetren
        go to 1500
      endif
      if(ich.eq.0) then
        nedw=nEdwPrv
        ncrw=nCrwPrv
        if(kanref.eq.1) then
          do 2010i=1,2*nf
            j=(i+1)/2
            k=mod(i-1,2)+1
            call FeUpdateParamAndKeys(nEdw,nCrw,pom,kip,1)
            if(k.eq.1) then
              ffra(j,1,KPhase)=pom
            else
              ffia(j,1,KPhase)=pom
            endif
            kif(j,k,1)=kip
            nedw=nedw+1
            ncrw=ncrw+1
2010      continue
        endif
      endif
      call FeQuestRemove(id)
9999  return
      end
      subroutine EM40EditAtoms(iap,iak,ich)
      include 'params.cmn'
      include 'basic.cmn'
      include 'editm40.cmn'
      include 'atoms.cmn'
      include 'molec.cmn'
      include 'fepc.cmn'
      integer FeMenu,PocDer
      dimension kmodan(7),tpoma(4),xpoma(4),nEdwLocAtSystAx(2),
     1          nDownLocAtSystAx(2),nEdwLocAtSystSt(2),xx(6),px(3)
      character*256 EdwStringQuest
      character*80 Veta,ErrSt
      character*27 Label(5)
      character*12 at,pn
      character*8  AtName,AtTypeName
      character*2  Sipka,nty
      integer PrvKi
      logical Konec,CrwLogicQuest,lpom,EqIgCase
      data Sipka/'->'/
      data Label/'ADP parameter(s):','Multipole parameter(s):',
     1           'Modulation waves:','Edit special parameters:',
     2           'Edit modulation parameters:'/
      equivalence (at,Veta)
      if(iap.gt.iak) go to 9999
      if(lite.eq.0) call EM40SwitchBetaU(0,0)
      ich=0
      ia=iap
      iao=0
      if(kmol(iap).gt.0) then
        ji=kmol(iap)
        im=(ji-1)/mxp+1
        nap=nac
        do 1000i=1,im-1
          nap=nap+iamn(i)*mam(i)
1000    continue
      else
        ji=0
        im=0
        nap=0
      endif
      Konec=.false.
      id=NextQuestId()
      xdq=270.
      xdqp=xdq*.5
      if(ndimi.eq.0) then
        il=11
      else
        il=11
      endif
      call FeQuestCreate(id,-1.,-1.,xdq,0,il,'Atom edit',0,LightGray,0,
     1                   OKForBasicFiles)
      yqmin=QuestYMin(id)
      il=1
      Veta='De%fine mode'
      tpom=xdqp-FeTxLengthUnder(Veta)-25.
      xpom=tpom-15.
      call FeQuestCrwMake(id,tpom,il,xpom,il,Veta,'L',CrwgXd,CrwgYd,1,1)
      nCrwDefMode=CrwLastMade
      call FeQuestCrwOpen(CrwLastMade,.true.)
      Veta='%Edit mode'
      xpom=xdqp+25.
      tpom=xpom+15
      call FeQuestCrwMake(id,tpom,il,xpom,il,Veta,'L',CrwgXd,CrwgYd,1,1)
      nCrwEditMode=CrwLastMade
      call FeQuestCrwOpen(CrwLastMade,.false.)
      Mode=0
      ModeOld=-1
      il=il+1
      call FeQuestLineMake(id,il)
      il=il+1
      Veta='%#'
      tpom=5.
      xpom=tpom+FeTxLengthUnder(Veta)+2.+EdwYd
      call FeQuestEudMake(id,tpom,il,xpom,il,Veta,'L',18.,EdwYd,1)
      nEdwNo=EdwLastMade
      call FeQuestIntEdwOpen(nEdwNo,ia-iap+1,.false.)
      call FeQuestEudOpen(nEdwNo,1,iak-iap+1,1,0.,0.,0.)
      Veta='%List'
      dpom=FeTxLengthUnder(Veta)+5.
      xpom=xpom+20.+2.*EdwYd
      call FeQuestButtonMake(id,xpom,il,dpom,ButYd,Veta)
      nButtAtomList=ButtonLastMade
      call FeQuestButtonOpen(ButtonLastMade,ButtonOff)
      Veta='%Name'
      tpom=xpom+dpom+15.
      xpom=tpom+FeTxLengthUnder(Veta)+2.
      dpom=FeTxLengthUnder('XXXXXXXX')+5.
      call FeQuestEdwMake(id,tpom,il,xpom,il,Veta,'L',dpom,EdwYd,1)
      nEdwAtomName=EdwLastMade
      xAtName=EdwXminQuest(nEdwAtomName)+5.*EdwIndSize
      yAtName=(EdwYminQuest(nEdwAtomName)+EdwYmaxQuest(nEdwAtomName))*.5
      Veta='%Type'
      tpom=xpom+dpom+5.
      xpom=tpom+FeTxLengthUnder(Veta)+3.
      dpom=20.
      do 1050i=1,nf
        dpom=max(FeTxLength(AtTypeFull(i,KPhase)),20.)
1050  continue
      call FeQuestEdwMake(id,tpom,il,xpom,il,Veta,'L',dpom,EdwYd,1)
      nEdwAtomType=EdwLastMade
      xAtType=EdwXminQuest(nEdwAtomType)+5.*EdwIndSize
      yAtType=(EdwYminQuest(nEdwAtomType)+EdwYmaxQuest(nEdwAtomType))*.5
      xp=FeXPixRound(xpom)+FeXPixRound(dpom)+5.*PixelX
      call FeQuestUpDownMake(id,xp,il,UpDownXd,UpDownYd,'down')
      nDownAtomType=UpDownLastMade
      Veta='Appl%y site symmetry'
      dpom=FeTxLengthUnder(Veta)+5.
      xpom=xdq-dpom-5.
      call FeQuestButtonMake(id,xpom,il,dpom,ButYd,Veta)
      nButtSymmetry=ButtonLastMade
      call FeQuestButtonOpen(ButtonLastMade,ButtonOff)
      il=il+1
      ilp=il
      if(ndimi.gt.0.or.ChargeDensities) then
        xtempf=5.
      else
        xtempf=(xdq-FeTxLengthUnder(Label(1)))*.5
      endif
      xpom=xtempf
      tpom=xpom+12.
      do 1100i=1,3
        if(i.eq.1) then
          Veta='%isotropic'
        else if(i.eq.2) then
          Veta='%harmonic'
        else
          if(im.eq.0) then
            Veta='%anharmonic'
          else
            Veta='%Use TLS'
          endif
        endif
        il=il+1
        call FeQuestCrwMake(id,tpom,il,xpom,il,Veta,'L',CrwgXd,CrwgYd,1,
     1                      2)
        if(i.eq.1) then
          nCrwIso=CrwLastMade
        else if(i.eq.2) then
          nCrwAniso=CrwLastMade
        else if(i.eq.3) then
          if(im.eq.0) then
            nCrwTLS=0
            nCrwADP=CrwLastMade
          else
            nCrwTLS=CrwLastMade
            nCrwADP=0
          endif
        endif
1100  continue
      tpom=tpom+FeTxLength('Anharmonic')+3.
      xpom=tpom+FeTxLength(Sipka)+3.
      call FeQuestEudMake(id,tpom,il,xpom,il,Sipka,'L',15.,EdwYd,1)
      nEdwADP=EdwLastMade
      il=il+1
      if(ndim.le.3) then
        if(ChargeDensities) then
          il=ilp
          xpom=90.
          tpom=xpom+12.
          do 1110i=1,3
            il=il+1
            if(i.eq.1) then
              Veta='n%one'
            else if(i.eq.2) then
              Veta='%kappa'
            else
              Veta='o%rder'
            endif
            call FeQuestCrwMake(id,tpom,il,xpom,il,Veta,'L',CrwgXd,
     1                          CrwgYd,1,3)
            if(i.eq.1) then
              nCrwMultNone=CrwLastMade
            else if(i.eq.2) then
              nCrwMultKappa=CrwLastMade
            else
              nCrwMultOrder=CrwLastMade
            endif
1110      continue
          tpom=tpom+FeTxLength('XXXXX')+3.
          xpom=tpom+FeTxLength(Sipka)+3.
          call FeQuestEudMake(id,tpom,il,xpom,il,Sipka,'L',15.,EdwYd,0)
          nEdwMult=EdwLastMade
          xlocal=xpom+45.
          il=ilp
          tpom=xlocal
          Veta='Local coordinate system:'
          xpom=xlocal
          dpom=12.
          xp=FeXPixRound(xpom)+FeXPixRound(dpom)+5.*PixelX
          xpp=xp+EdwYd+5.
          dpp=xdq-xpp-5.
          do 1115i=1,2
            il=il+1
            call FeQuestEdwMake(id,tpom,ilp,xpom,il,Veta,'L',dpom,EdwYd,
     1                          1)
            Veta=' '
            nEdwLocAtSystAx(i)=EdwLastMade
            call FeQuestUpDownMake(id,xp,il,UpDownXd,UpDownYd,'down')
            nDownLocAtSystAx(i)=UpDownLastMade
            call FeQuestEdwMake(id,tpom,il,xpp,il,' ','L',dpp,EdwYd,1)
            nEdwLocAtSystSt(i)=EdwLastMade
1115      continue
          il=il+1
          Veta='Ri%ght handed system'
          xpom=tpom+CrwXd+3.
          call FeQuestCrwMake(id,xpom,il,tpom,il,Veta,'L',CrwXd,
     1                          CrwYd,1,0)
          nCrwRightHanded=CrwLastMade
          il=il+1
          Veta='%Point group:'
          dpom=40.
          call FeQuestEdwMake(id,tpom,il,tpom,il+1,Veta,'L',dpom,EdwYd,
     1                        1)
          il=il+2
          nEdwPointGroup=EdwLastMade
          Veta='Her%mann-Mauguin short'
          dpom=FeTxLengthUnder(Veta)+5.
          call FeQuestButtonMake(id,tpom,il,dpom,ButYd,Veta)
          nButtPGInter=ButtonLastMade
          il=il+1
          Veta='S%choenflies'
          dpom=FeTxLengthUnder(Veta)+5.
          call FeQuestButtonMake(id,tpom,il,dpom,ButYd,Veta)
          nButtPGSchoen=ButtonLastMade
        endif
      else
        il=ilp
        tpom=90.
        xpom=tpom+FeTxLength('ADP parameters')+EdwYd+5.
        xp=xpom+30.+EdwYd
        tp=xp+CrwXd+2.
        do 1120i=1,7
          il=il+1
          if(i.eq.1) then
            Veta='%Occupancy'
          else if(i.eq.2) then
            Veta='%Position'
          else
            write(Veta,100) i-1,nty(i-1)
          endif
          call FeQuestEudMake(id,tpom,il,xpom,il,Veta,'L',15.,EdwYd,0)
          if(i.eq.1) then
            nEdwModOcc=EdwLastMade
            call FeQuestCrwMake(id,tp,il,xp,il,'Use %crenel','L',CrwXd,
     1                          CrwYd,1,0)
            nCrwCrenel=CrwLastMade
          else if(i.eq.2) then
            nEdwModPos=EdwLastMade
            call FeQuestCrwMake(id,tp,il,xp,il,'Use %saw-tooth','L',
     1                          CrwXd,CrwYd,1,0)
            nCrwSawTooth=CrwLastMade
          endif
1120    continue
      endif
      il=ilp
      tpoma(1)=5.
      pom=(xdq-4.*37.-10.)/4.
      pom=(xdq-5.-37.-pom)/3.
      do 1125i=2,4
        tpoma(i)=tpoma(i-1)+pom
1125  continue
      xpoma(4)=xdq-42.-CrwXd
      do 1130i=3,1,-1
        xpoma(i)=xpoma(i+1)-pom
1130  continue
      PrvKi=PrvniKiAtomu(ia)
      kip=PrvKi
      j=0
      do 1150i=1,10
        call kdoco(kip,at,pn,1,pom,spom)
        j=j+1
        call FeMakeParEdwCrw(id,tpoma(j),xpoma(j),il,pn,pom,
     1                       ki(kip),.false.,nEdw,nCrw)
        kip=kip+1
        if(i.eq.1) then
          nEdwPrvPar=nEdw
          nCrwPrvPar=nCrw
        endif
        call FeQuestEdwClose(nEdw)
        call FeQuestCrwClose(nCrw)
        if(mod(i,4).eq.0) then
          il=il+1
          j=0
        endif
1150  continue
      il=il+1
      if(ChargeDensities) then
        pom=0.
      else
        pom=(tpoma(2)-tpoma(1))*.5
      endif
      dpom=50.
      pom=10.
      xpom=(xdq-3.*dpom-2.*pom)*.5
      do 1160i=1,3
        if(i.eq.1) then
          at='%Refine all'
        else if(i.eq.2) then
          at='Fi%x all'
        else if(i.eq.3) then
          at='Re%set'
        endif
        call FeQuestButtonMake(id,xpom,il,dpom,ButYd,at)
        if(i.eq.1) then
          nButtRefineAll=ButtonLastMade
        else if(i.eq.2) then
          nButtFixAll=ButtonLastMade
        else if(i.eq.3) then
          nButtReset=ButtonLastMade
        endif
        xpom=xpom+dpom+pom
1160  continue
      ill=il+1
      il=ill+1
      if(ndimi.eq.0) then
        if(ChargeDensities) then
          iek=2
        else
          iek=1
        endif
      else
        if(im.eq.0) then
          iek=8
        else
          iek=4
        endif
      endif
      xpom0=FeTxLengthUnder(Label(4))
      if(ndimi.gt.0) xpom0=max(xpom0,FeTxLengthUnder(Label(5)))
      xpom0=xpom0+10.
      xpom=xpom0
      do 1170i=1,iek
        if(i.eq.1) then
          Veta='A%DP'
        else if(i.eq.2) then
          if(ndimi.eq.0) then
            if(.not.ChargeDensities)
     1        go to 1190
            Veta='%Multipole(s)'
          else
            Veta='%Occupancy'
          endif
        else if(i.eq.3) then
          Veta='%Position'
        else if(i.eq.4) then
          Veta='ADP para%meters'
        else
          j=i-2
          write(Veta,100) j,nty(j)
        endif
        dpom=FeTxLengthUnder(Veta)+10.
        call FeQuestButtonMake(id,xpom,il,dpom,ButYd,Veta)
        if(i.eq.1) then
          nButtEditADP=ButtonLastMade
        else if(i.eq.2) then
          if(ndimi.eq.0) then
            nButtEditMult=ButtonLastMade
            nButtEditModFirst=0
            nButtEditModLast=0
          else
            nButtEditMult=0
            nButtEditModFirst=ButtonLastMade
          endif
        endif
        if((i.eq.1.or.i.eq.4).and.ndimi.gt.0) then
          il=il+1
          xpom=xpom0
        else
          xpom=xpom+dpom+pom
        endif
1170  continue
      if(ndimi.gt.0) nButtEditModLast=ButtonLastMade
1190  icont=0
1200  ButtonFlash=.false.
      if(Mode.eq.0) then
        if(Mode.ne.ModeOld) then
          nButt=nButtRefineAll
          do 1202i=1,3+iek
            if(ndimi.eq.0.and.i.eq.5.and..not.ChargeDensities)
     1        go to 1202
            call FeQuestButtonClose(nButt)
            nButt=nButt+1
1202      continue
          nEdw=nEdwPrvPar
          nCrw=nCrwPrvPar
          do 1205i=1,10
            call FeQuestEdwClose(nEdw)
            call FeQuestCrwClose(nCrw)
            nEdw=nEdw+1
            nCrw=nCrw+1
1205      continue
          call FeQuestLineRemove(id,ill)
          call FeQuestLabelRemove(id,5.,ill+1,Label(4),'L')
          if(ndimi.gt.0) call FeQuestLabelRemove(id,5.,ill+2,Label(5),
     1                                           'L')
          call FeQuestLabelMake(id,xtempf,ilp,Label(1),'L')
          if(ndim.le.3) then
            if(ChargeDensities) then
              call FeQuestLabelMake(id,90.,ilp,Label(2),'L')
            endif
          else
            call FeQuestLabelMake(id,105.,ilp,Label(3),'L')
          endif
          iao=0
        endif
        if(ia.ne.iao) then
          call EM40UpDateAtom(ia,AtName,itfa,isfa,kmodan,lasmaxa,PrvKi,
     1                        npar)
          call FeQuestStringEdwOpen(nEdwAtomName,AtName)
          itfo=-1
          isfo=0
          lasmaxo=0
          if(ndimi.gt.0) then
            call FeQuestCrwOpen(nCrwCrenel,kfs(ia).ne.0)
            call FeQuestCrwOpen(nCrwSawTooth,kfx(ia).ne.0)
          endif
        endif
        if(itfa.ne.itfo) then
          if(itfo.lt.0) then
            nCrw=nCrwIso
            j=min(itfa,3)
            if(im.ne.0.and.j.eq.0) j=3
            do 1210i=1,3
              call FeQuestCrwOpen(nCrw,i.eq.j)
              nCrw=nCrw+1
1210        continue
          else
            if(itfo.ne.itfa) then
              if(lite.eq.0) call EM40SwitchBetaU(1,ia)
              if(itfa.eq.1) then
                if(itfo.eq.0) call ZmTF02(ia)
                if(itfo.ne.1) call ZmTF21(ia)
              else if(itfa.eq.2) then
                if(itfo.eq.1) then
                  call ZmTF12(ia)
                else if(itfo.eq.0) then
                  call ZmTF02(ia)
                endif
              else if(itfa.eq.0) then
                if(itfo.eq.1) call ZmTF12(ia)
                if(itfo.ne.0) call ZmTF20(ia,.false.)
              endif
              if(lite.eq.0) call EM40SwitchBetaU(0,ia)
            endif
          endif
          if(ndimi.gt.0) then
            nEdw=nEdwModOcc
            j=itfa+1
            if(im.gt.0.and.j.eq.1) j=3
            do 1220i=1,7
              if(i.le.2.or.i.le.j) then
                call FeQuestIntEdwOpen(nEdw,kmodan(i),.false.)
                call FeQuestEudOpen(nEdw,0,mxw,1,0.,0.,0.)
              else
                call FeQuestEdwClose(nEdw)
                kmodan(i)=0
              endif
              nEdw=nEdw+1
1220        continue
          endif
        endif
        if(itfa.ge.3) then
          call FeQuestIntEdwOpen(nEdwADP,itfa,.false.)
          call FeQuestEudOpen(nEdwADP,3,6,1,0.,0.,0.)
        else
          call FeQuestEdwClose(nEdwADP)
        endif
        if(ndim.le.3.and.ChargeDensities.and.lasmaxa.ne.lasmaxo) then
          nCrw=nCrwMultNone
          do 1225i=1,3
            call FeQuestCrwOpen(nCrw,i.eq.min(lasmaxa,3))
            nCrw=nCrw+1
1225      continue
          if(lasmaxa.ge.3) then
            call FeQuestIntEdwOpen(nEdwMult,lasmaxa-3,.false.)
            call FeQuestEudOpen(nEdwMult,0,7,1,0.,0.,0.)
            do 1230i=1,2
              call FeQuestStringEdwOpen(nEdwLocAtSystAx(i),
     1                                   LocAtSystAx(ia)(i:i))
              call FeQuestUpDownOpen(nDownLocAtSystAx(i),UpDownOff)
              Veta=LocAtSystSt(i,ia)
              if(Veta(1:1).eq.' ') Veta=Veta(2:)
              k=0
              call StToReal(Veta,k,xx,3,.false.,ich)
              if(ich.eq.0) then
                write(Veta,'(3f12.6)')(xx(j),j=1,3)
                call ZdrcniCisla(Veta,3)
              endif
              call FeQuestStringEdwOpen(nEdwLocAtSystSt(i),Veta)
1230        continue
            call FeQuestCrwOpen(nCrwRightHanded,
     1                          .not.LocAtSense(ia).eq.'-')
            call FeQuestStringEdwOpen(nEdwPointGroup,SmbPGAt(ia))
            call FeQuestButtonOpen(nButtPGInter,ButtonOff)
            call FeQuestButtonOpen(nButtPGSchoen,ButtonOff)
          else
            call FeQuestEdwClose(nEdwMult)
            do 1240i=1,2
              call FeQuestEdwClose(nEdwLocAtSystAx(i))
              call FeQuestUpDownClose(nDownLocAtSystAx(i))
              call FeQuestEdwClose(nEdwLocAtSystSt(i))
1240        continue
            call FeQuestCrwClose(nCrwRightHanded)
            call FeQuestEdwClose(nEdwPointGroup)
            call FeQuestButtonClose(nButtPGInter)
            call FeQuestButtonClose(nButtPGSchoen)
          endif
          lasmaxo=lasmaxa
        endif
        if(isfa.ne.isfo) then
          AtTypeName=AtTypeFull(isfa,KPhase)
          call FeQuestStringEdwOpen(nEdwAtomType,AtTypeName)
          call FeQuestUpDownOpen(nDownAtomType,UpDownOff)
          isfo=isfa
        endif
      else
        if(Mode.ne.ModeOld) then
          call FeQuestEdwClose(nEdwAtomName)
          call FeQuestAbsLabelMake(id,EdwLabelXQuest(nEdwAtomName),
     1                                EdwLabelYQuest(nEdwAtomName),
     2                             'Name','L')
          call FeQuestEdwClose(nEdwAtomType)
          call FeQuestAbsLabelMake(id,EdwLabelXQuest(nEdwAtomType),
     1                                EdwLabelYQuest(nEdwAtomType),
     2                             'Type','L')
          call FeQuestUpDownClose(nDownAtomType)
          call FeQuestLabelRemove(id,xtempf,ilp,Label(1),'L')
          if(ndim.le.3) then
            if(ChargeDensities) then
              call FeQuestLabelRemove(id,90.,ilp,Label(2),'L')
              if(lasmaxa.ge.3) then
                do 1300i=1,2
                  call FeQuestEdwClose(nEdwLocAtSystAx(i))
                  call FeQuestUpDownClose(nDownLocAtSystAx(i))
                  call FeQuestEdwClose(nEdwLocAtSystSt(i))
1300            continue
                call FeQuestCrwClose(nCrwRightHanded)
                call FeQuestEdwClose(nEdwPointGroup)
                call FeQuestButtonClose(nButtPGInter)
                call FeQuestButtonClose(nButtPGSchoen)
              endif
            endif
          else
            call FeQuestLabelRemove(id,105.,ilp,Label(3),'L')
          endif
          if(ndimi.gt.0) then
            call FeQuestCrwClose(nCrwCrenel)
            call FeQuestCrwClose(nCrwSawTooth)
          endif
          nCrw=nCrwIso
          do 1310i=1,3
            call FeQuestCrwClose(nCrw)
            nCrw=nCrw+1
1310      continue
          if(ndimi.gt.0) then
            nEdw=nEdwModOcc
            do 1320i=1,max(itfa+1,2)
              call FeQuestEdwClose(nEdw)
              nEdw=nEdw+1
1320        continue
          endif
          if(itfa.ge.3) call FeQuestEdwClose(nEdwADP)
          if(ndim.le.3.and.ChargeDensities)
     1      then
            nCrw=nCrwMultNone
            do 1325i=1,3
              call FeQuestCrwClose(nCrw)
              nCrw=nCrw+1
1325        continue
            if(lasmaxa.ge.3) then
              call FeQuestIntFromEdw(nEdwMult,lasmaxa)
              lasmaxa=lasmaxa+3
              call FeQuestEdwClose(nEdwMult)
            endif
            call ZmMult(ia,lasmaxa-1)
          endif
          call FeQuestLineMake(id,ill)
          call FeQuestLabelMake(id,5.,ill+1,Label(4),'L')
          if(ndimi.gt.0) call FeQuestLabelMake(id,5.,ill+2,Label(5),'L')
          nButt=nButtRefineAll
          do 1330i=1,5
            if(i.eq.5.and..not.ChargeDensities) go to 1330
            call FeQuestButtonOpen(nButt,ButtonOff)
            nButt=nButt+1
1330      continue
          iao=0
          isfo=0
        endif
        if(ia.ne.iao) then
          if(iao.ne.0) call FeQuestAbsLabelRemove(0,xAtName,yAtName,
     1                                            AtName,'L')
          call EM40UpDateAtom(ia,AtName,itfa,isfa,kmodan,lasmaxa,PrvKi,
     1                        npar)
          call FeQuestAbsLabelMake(0,xAtName,yAtName,AtName,'L')
          if(itfa.le.2) then
            call FeQuestButtonDisable(nButtEditADP)
          else
            call FeQuestButtonOff(nButtEditADP)
          endif
          if(ndimi.eq.0) then
            if(ChargeDensities) then
              if(lasmaxa.le.1) then
                call FeQuestButtonDisable(nButtEditMult)
              else
                call FeQuestButtonOff(nButtEditMult)
              endif
            endif
          else
            nButt=nButtEditModFirst
            do 1340i=1,7
              if(kmodan(i).gt.0) then
                call FeQuestButtonOff(nButt)
              else
                call FeQuestButtonDisable(nButt)
              endif
              nButt=nButt+1
1340        continue
          endif
          nEdw=nEdwPrvPar
          nCrw=nCrwPrvPar
          kip=PrvKi
          do 1350i=1,10
            if(i.le.npar) then
              call kdoco(kip,at,pn,1,pom,spom)
              call FeQuestRealEdwOpen(nEdw,pom,.false.,.false.)
              call FeQuestCrwOpen(nCrw,Ki(kip).ne.0)
              call FeQuestEdwLabelChange(id,nEdw,pn)
              kip=kip+1
            else
              call FeQuestEdwClose(nEdw)
              call FeQuestCrwClose(nCrw)
            endif
            nEdw=nEdw+1
            nCrw=nCrw+1
1350      continue
        endif
        if(isfa.ne.isfo) then
          if(isfo.ne.0) call FeQuestAbsLabelRemove(0,xAtType,yAtType,
     1                                             AtTypeName,'L')
          AtTypeName=AtTypeFull(isfa,KPhase)
          call FeQuestAbsLabelMake(0,xAtType,yAtType,AtTypeName,'L')
        endif
      endif
      iao=ia
      isfo=isfa
      itfo=itfa
      ModeOld=Mode
      ButtonFlash=.true.
1500  call FeQuestEvent(id,icont,ich)
      icont=1
      if(CheckType.eq.EventEdw.and.CheckNumber.eq.nEdwNo) then
        call FeQuestIntFromEdw(nEdwNo,ia)
        ia=ia+iap-1
        if(ia.ne.iao) then
          go to 2000
        else
          go to 1500
        endif
      else if(CheckType.eq.EventCrw.and.CheckNumber.eq.nCrwDefMode)
     1  then
        Mode=0
        go to 1900
      else if(CheckType.eq.EventCrw.and.CheckNumber.eq.nCrwEditMode)
     1  then
        Mode=1
        go to 1900
      else if(CheckType.eq.EventEdw.and.CheckNumber.eq.nEdwAtomName)
     1  then
        AtName=EdwStringQuest(nEdwAtomName)
        call UprAt(AtName)
        call AtCheck(AtName,i,j)
        if(i.ne.0) then
          if(i.eq.1) then
            Veta='Unacceptable symbol in the atom name'
          else if(i.eq.2) then
            if(j.ne.ia) then
              Veta='The atom name already exists'
            else
              go to 1600
            endif
          endif
          call FeChybne(-1.,-1.,Veta,' ',0,SeriousError)
          EventType=EventEdw
          EventNumber=nEdwAtomName
          go to 1500
        endif
1600    call FeQuestStringEdwOpen(nEdwAtomName,AtName)
        go to 1500
      else if(CheckType.eq.EventButton.and.CheckNumber.eq.nButtAtomList)
     1  then
        call SelOneAtom('Select next atom',Atom(iap),ia,iak-iap+1,ich)
        ia=ia+iap-1
        call FeQuestButtonoff(nButtAtomList)
        icont=0
        if(ia.ne.iao.and.ich.eq.0) then
          go to 2000
        else
          ia=iao
          go to 1500
        endif
      else if(CheckType.eq.EventEdw.and.CheckNumber.eq.nEdwAtomType)
     1  then
        AtTypeName=EdwStringQuest(nEdwAtomType)
        call uprat(AtTypeName)
        isfa=ktat(AtTypeFull(1,KPhase),nf,AtTypeName)
        if(isfa.le.0) then
          call FeChybne(-1.,-1.,'Atomic type not present on M50 file',
     1                  ' ',0,SeriousError)
          isfa=isfo
          EventType=EventEdw
          EventNumber=nEdwAtomType
        endif
        go to 1200
      else if(CheckType.eq.EventUpDown.and.CheckNumber.eq.nDownAtomType)
     1  then
        isfa=FeMenu(EdwXminQuest(nEdwAtomType),
     1              EdwYmaxQuest(nEdwAtomType)-(float(nf)*MenuLineWidth)
     2             ,AtTypeFull(1,KPhase),1,nf,1,1)
        if(isfa.le.0) isfa=isfo
        EventType=EventEdw
        EventNumber=nEdwAtomType
        call FeQuestUpDownOpen(nDownAtomType,UpDownOff)
        go to 1200
      else if(CheckType.eq.EventEdw.and.CheckNumber.eq.nEdwADP) then
        call FeQuestIntFromEdw(nEdwADP,itfa)
        go to 1200
      else if(CheckType.eq.EventCrw.and.CheckNumber.ge.nCrwIso.and.
     1        (CheckNumber.le.nCrwADP.or.CheckNumber.le.nCrwTLS)) then
        if(CheckNumber.eq.nCrwIso) then
          itfa=1
        else if(CheckNumber.eq.nCrwAniso) then
          itfa=2
        else
          if(im.le.0) then
            itfa=3
          else
            itfa=0
          endif
        endif
        icont=0
        go to 1200
      else if(CheckType.eq.EventCrw.and.CheckNumber.eq.nCrwCrenel) then
        call FeQuestIntFromEdw(nEdwModOcc,n)
        if(CrwLogicQuest(nCrwCrenel)) then
          if(CrwLogicQuest(nCrwSawTooth))
     1      call FeQuestCrwOff(nCrwSawTooth)
          n=n+1
        else
          n=n-1
        endif
        call FeQuestIntEdwOpen(nEdwModOcc,n,.false.)
        call FeQuestEudOpen(nEdwModOcc,0,mxw,1,0.,0.,0.)
        EventType=EventEdw
        EventNumber=nEdwModOcc
        go to 1500
      else if(CheckType.eq.EventCrw.and.CheckNumber.eq.nCrwSawTooth)
     1  then
        call FeQuestIntFromEdw(nEdwModPos,n)
        if(CrwLogicQuest(nCrwSawTooth)) then
          if(CrwLogicQuest(nCrwCrenel)) call FeQuestCrwOff(nCrwCrenel)
          n=n+1
        else
          n=n-1
        endif
        call FeQuestIntEdwOpen(nEdwModPos,n,.false.)
        call FeQuestEudOpen(nEdwModPos,0,mxw,1,0.,0.,0.)
        EventType=EventEdw
        EventNumber=nEdwModPos
        go to 1500
      else if(CheckType.eq.EventCrw.and.CheckNumber.ge.nCrwMultNone.and.
     1        CheckNumber.le.nCrwMultOrder) then
        if(CheckNumber.eq.nCrwMultNone) then
          lasmaxa=1
          icont=0
        else if(CheckNumber.eq.nCrwMultKappa) then
          lasmaxa=2
          icont=0
        else if(CheckNumber.eq.nCrwMultOrder) then
          lasmaxa=3
          call ZmMult(ia,lasmaxa)
          EventType=EventEdw
          EventNumber=nEdwMult
        endif
        go to 1200
      else if(CheckType.eq.EventCrw.and.CheckNumber.ge.nCrwRightHanded)
     1  then
        if(CrwLogicQuest(nCrwRightHanded)) then
          LocAtSense(ia)=' '
        else
          LocAtSense(ia)='-'
        endif
        EventType=EventEdw
        EventNumber=nEdwLocAtSystSt(1)
        go to 1500
      else if(CheckType.eq.EventUpDown.and.
     1        (CheckNumber.eq.nDownLocAtSystAx(1).or.
     2         CheckNumber.eq.nDownLocAtSystAx(2))) then
        if(CheckNumber.eq.nDownLocAtSystAx(1)) then
          j=1
        else
          j=2
        endif
        i=nEdwLocAtSystAx(j)
        k=FeMenu(EdwXminQuest(i),EdwYmaxQuest(i)-3.*MenuLineWidth,Smbx,
     1           1,3,1,1)
        if(k.ge.1.and.k.le.3) then
          call FeQuestStringEdwOpen(i,Smbx(k))
          LocAtSystAx(ia)(j:j)=Smbx(k)
        endif
        EventType=EventEdw
        EventNumber=i
        call FeQuestUpDownOpen(CheckNumber,UpDownOff)
        go to 1500
      else if(CheckType.eq.EventEdw.and.
     1        (CheckNumber.eq.nEdwLocAtSystAx(1).or.
     2         CheckNumber.eq.nEdwLocAtSystAx(2))) then
        if(CheckNumber.eq.nEdwLocAtSystAx(1)) then
          j=1
        else
          j=2
        endif
        i=nEdwLocAtSystAx(j)
        Veta=EdwStringQuest(i)
        call mala(Veta)
        do 1610k=1,3
          if(Veta.eq.smbx(k)) then
            call FeQuestStringEdwOpen(i,Veta)
            LocAtSystAx(ia)(j:j)=Veta
            go to 1500
          endif
1610    continue
        call FeChybne(-1.,-1.,'the axis symbol is incorrect',' ',0,
     1                SeriousError)
        EventType=EventEdw
        EventNumber=i
        go to 1500
      else if(CheckType.eq.EventEdw.and.
     1        (CheckNumber.eq.nEdwLocAtSystSt(1).or.
     2         CheckNumber.eq.nEdwLocAtSystSt(2))) then
        if(CheckNumber.eq.nEdwLocAtSystSt(1)) then
          j=1
        else
          j=2
        endif
        i=nEdwLocAtSystSt(j)
        Veta=EdwStringQuest(i)
        if(Veta.eq.' ') go to 1500
        call CrlGetXFromAtString(Veta,0,px,ErrSt,ich)
        if(ich.gt.0) then
          call FeChybne(-1.,-1.,'in the definition of local '//
     1                  'coordinate system',ErrSt,0,SeriousError)
          EventType=EventEdw
          EventNumber=i
        else
          LocAtSystSt(j,ia)=Veta
          ich=0
        endif
        go to 1500
      else if(CheckType.eq.EventEdw.and.CheckNumber.eq.nEdwPointGroup)
     1  then
        Veta=EdwStringQuest(CheckNumber)
        do 1750i=1,32
          if(EqIgCase(Veta,SmbPGI(i))) then
            Veta=SmbPGI(i)
            go to 1760
          endif
1750    continue
        do 1752i=1,32
          if(EqIgCase(Veta,SmbPGO(i))) then
            Veta=SmbPGO(i)
            go to 1760
          endif
1752    continue
        call FeChybne(-1.,-1.,'wrong point group symbol',' ',0,
     1                SeriousError)
        EventType=EventEdw
        EventNumber=CheckNumber
        go to 1500
1760    call FeQuestStringEdwOpen(nEdwPointGroup,Veta)
        SmbPGAt(ia)=Veta
        go to 1500
      else if(CheckType.eq.EventButton.and.CheckNumber.eq.nButtSymmetry)
     1  then
        call EM40AtomNewBasic(iao,PrvKi,nEdwPrvPar,nCrwPrvPar,npar)
        call EM40UpdateAtomSpecial(iao,im,AtName,PrvKi,isfa,itfa,
     1                             lasmaxa,kmodan)
        neq=0
        neqs=0
        if(im.gt.0) then
          i=iao-iap+1+nap
        else
          i=0
        endif
        call OpenFile(lst,fln(:ifln)//'_pom.tmp','formatted','unknown')
        call atspec(iao,iao,ji,im,i)
        do 1764i=1,neq
          lnp(i)=lnp(i)+pocder(ktatmol(lat(i)))
          ki(lnp(i))=0
          do 1762j=1,npa(i)
            pnp(j,i)=pnp(j,i)+pocder(ktatmol(pat(j,i)))
1762      continue
1764    continue
        call apeq(0,0,0)
        close(lst,status='delete')
        call FeQuestButtonoff(nButtSymmetry)
        iao=0
        go to 1190
      else if(CheckType.eq.EventButton.and.
     1        (CheckNumber.eq.nButtRefineAll.or.
     2         CheckNumber.eq.nButtFixAll)) then
        if(CheckNumber.eq.nButtRefineAll) then
          lpom=.true.
        else
          lpom=.false.
        endif
        nCrw=nCrwPrvPar+1
        do 1770i=2,npar
          call FeQuestCrwOpen(nCrw,lpom)
          nCrw=nCrw+1
1770    continue
        call FeQuestButtonoff(CheckNumber)
        icont=0
        go to 1500
      else if(CheckType.eq.EventButton.and.CheckNumber.eq.nButtReset)
     1  then
        if(lite.eq.0) call EM40SwitchBetaU(1,ia)
        pom=2.5
        isw=iswa(ia)
        if(itfa.ge.2) then
          do 1780i=1,6
            beta(i,ia)=pom*prcp(i,isw,KPhase)
            if(i.eq.3) pom=pom*.5
1780      continue
        endif
        if(lite.eq.0) call EM40SwitchBetaU(0,ia)
        nEdw=nEdwPrvPar+4
        do 1790i=1,npar-4
          call FeQuestRealEdwOpen(nEdw,beta(i,ia),.false.,.false.)
          nEdw=nEdw+1
1790    continue
        call FeQuestButtonoff(CheckNumber)
        icont=0
        go to 1500
      else if(CheckType.eq.EventButton.and.CheckNumber.eq.nButtEditMult)
     1  then
        call EM40EditMultipole(ia,lasmaxa,PrvKi,yqmin)
        i=nButtEditMult
        go to 1800
      else if(CheckType.eq.EventButton.and.CheckNumber.eq.nButtEditADP)
     1  then
        call EM40EditADP(ia,itfa,PrvKi,yqmin)
        i=nButtEditADP
        go to 1800
      else if(CheckType.eq.EventButton.and.
     1        CheckNumber.ge.nButtEditModFirst.and.
     2        CheckNumber.le.nButtEditModLast) then
        i=CheckNumber
        n=CheckNumber-nButtEditModFirst+1
        if(n.eq.1) then
          call EM40EditModPar(ia,PrvKi,n,ax(1,ia),ay(1,ia),TRank(n-1),0)
        else if(n.eq.2) then
          call EM40EditModPar(ia,PrvKi,n,ux(1,1,ia),uy(1,1,ia),
     1                        TRank(n-1),0)
        else if(n.eq.3) then
          call EM40EditModPar(ia,PrvKi,n,bx(1,1,ia),by(1,1,ia),
     1                        TRank(n-1),0)
        else if(n.eq.4) then
          call EM40EditModPar(ia,PrvKi,n,c3x(1,1,ia),c3y(1,1,ia),
     1                        TRank(n-1),0)
        else if(n.eq.5) then
          call EM40EditModPar(ia,PrvKi,n,c4x(1,1,ia),c4y(1,1,ia),
     1                        TRank(n-1),0)
        else if(n.eq.6) then
          call EM40EditModPar(ia,PrvKi,n,c5x(1,1,ia),c5y(1,1,ia),
     1                        TRank(n-1),0)
        else if(n.eq.7) then
          call EM40EditModPar(ia,PrvKi,n,c6x(1,1,ia),c6y(1,1,ia),
     1                        TRank(n-1),0)
        endif
        go to 1800
      else if(CheckType.eq.EventButton.and.
     1        (CheckNumber.eq.nButtPGInter.or.
     2         CheckNumber.eq.nButtPGSchoen)) then
        i=CheckNumber
        ipg=LocateInStringArray(SmbPGI,nSmbPG,SmbPGAt(ia),.true.)
        if(ipg.le.0)
     1      ipg=LocateInStringArray(SmbPGO,nSmbPG,SmbPGAt(ia),.true.)
        if(CheckNumber.eq.nButtPGInter) then
          call SelOneAtom('Select point group',SmbPGI,ipg,nSmbPG,ich)
        else
          call SelOneAtom('Select point group',SmbPGO,ipg,nSmbPG,ich)
        endif
        if(ich.eq.0) then
          if(i.eq.nButtPGInter) then
            SmbPGAt(ia)=SmbPGI(ipg)
          else
            SmbPGAt(ia)=SmbPGO(ipg)
          endif
          call FeQuestStringEdwOpen(nEdwPointGroup,SmbPGAt(ia))
        endif
        go to 1800
      else if(CheckType.ne.0) then
        call NebylOsetren
        go to 1500
      endif
      go to 1890
1800  call FeQuestButtonOff(i)
      icont=0
      go to 1500
1890  Konec=.true.
      go to 2000
1900  icont=0
2000  if(iao.ne.0) then
        if(ModeOld.eq.0) then
          call EM40UpdateAtomSpecial(iao,im,AtName,PrvKi,isfa,itfa,
     1                               lasmaxa,kmodan)
          Mode=iabs(Mode)
        else
          call EM40AtomNewBasic(iao,PrvKi,nEdwPrvPar,nCrwPrvPar,npar)
        endif
        call FeQuestIntEdwOpen(nEdwNo,ia-iap+1,.false.)
      endif
      if(.not.Konec) go to 1200
      if(ich.eq.0) then
        ChargeDensities=.false.
        do 2200i=1,nac
          if(lasmax(i).gt.0) then
            ChargeDensities=.true.
            go to 2300
          endif
2200    continue
      endif
2300  call FeQuestRemove(id)
      if(lite.eq.0) call EM40SwitchBetaU(1,0)
9999  return
100   format('ADP %',i1,a2)
      end
      subroutine EM40UpdateAtomSpecial(iao,im,AtName,PrvKi,isfa,itfa,
     1                                 lasmaxa,kmodan)
      include 'params.cmn'
      include 'basic.cmn'
      include 'atoms.cmn'
      include 'editm40.cmn'
      include 'molec.cmn'
      include 'fepc.cmn'
      dimension kmodan(7)
      character*(*) AtName
      integer PrvKi,CrwStateQuest,EdwStateQuest
      logical CrwLogicQuest
      Atom(iao)=AtName
      isf(iao)=isfa
      call ZmAnhi(iao,itfa)
      itf(iao)=itfa
      if(ndim.le.3) then
        if(ChargeDensities) then
          if(lasmaxa.ge.3) then
            if(EdwStateQuest(nEdwMult).eq.EdwOpened) then
              call FeQuestIntFromEdw(nEdwMult,lasmaxa)
              lasmaxa=lasmaxa+3
            endif
          endif
          call ZmMult(iao,lasmaxa-1)
        endif
      else
        nEdw=nEdwModOcc
        j=itfa+1
        if(im.gt.0.and.j.eq.1) j=3
        do 3000i=1,7
          if(i.le.j) then
            if(EdwStateQuest(nEdw).eq.EdwOpened) then
              call FeQuestIntFromEdw(nEdw,kmodan(i))
            else
              kmodan(i)=kmoda(iao,i)
            endif
            nEdw=nEdw+1
          else
            kmodan(i)=0
          endif
3000    continue
        kfso=kfs(iao)
        if(CrwStateQuest(nCrwCrenel).ne.CrwClosed) then
          if(CrwLogicQuest(nCrwCrenel)) then
            kfsn=1
          else
            kfsn=0
          endif
          kfs(iao)=min(kfso,kfsn)
        else
          kfsn=kfso
        endif
        kfxo=kfx(iao)
        if(CrwStateQuest(nCrwSawTooth).ne.CrwClosed) then
          if(CrwLogicQuest(nCrwSawTooth)) then
            kfxn=1
          else
            kfxn=0
          endif
          kfx(iao)=min(kfxo,kfxn)
        else
          kfxn=kfxo
        endif
        call AtModi(iao,kmodan)
        kfs(iao)=kfsn
        kfx(iao)=kfxn
        kip=PrvKi+max(TRankCumul(itfa),10)
        k=kmods(iao)-ndimi
        if(k.ge.0) then
          if(kfsn.ne.kfso.and.kfsn.ne.0) then
            if(ndimi.eq.1) then
              pom=0.
            else
              if(a0(iao).gt.0.) then
                pom=a0(iao)**(1./float(ndimi))
              else
                pom=0.
              endif
            endif
            do 1100i=1,ndimi
              k=k+1
              ax(k,iao)=0.
              ay(k,iao)=pom
              j=kip+(k-1)*2+1
              ki(kip)=0
              ki(j    )=0
              ki(j+1  )=0
1100        continue
          endif
        endif
        if(k.gt.0) kip=kip+2*k+1
        i=kmodx(iao)
        if(i.gt.0) then
          if(kfxn.ne.kfxo.and.kfxn.eq.1) then
            j=kip+(i-1)*6
            call SetRealArrayTo(ux(1,i,iao),3,.001)
            call SetRealArrayTo(uy(1,i,iao),3,0.)
            uy(2,i,iao)=1.
            call SetIntArrayTo(ki(j),6,0)
          endif
        endif
      endif
      return
      end
      subroutine EM40UpDateAtom(ia,AtName,itfa,isfa,kmodan,lasmaxa,
     1                          PrvKi,npar)
      include 'params.cmn'
      include 'basic.cmn'
      include 'atoms.cmn'
      dimension kmodan(7)
      character*8  AtName
      integer PrvKi
      AtName=Atom(ia)
      itfa=itf(ia)
      isfa=isf(ia)
      do 1000i=1,7
        kmodan(i)=kmoda(ia,i)
1000  continue
      lasmaxa=lasmax(ia)+1
      PrvKi=PrvniKiAtomu(ia)
      if(itfa.eq.1) then
        npar=5
      else
        npar=10
      endif
      return
      end
      subroutine EM40AtomNewBasic(iao,PrvKi,nEdwPrvPar,nCrwPrvPar,npar)
      include 'params.cmn'
      include 'basic.cmn'
      include 'atoms.cmn'
      integer PrvKi
      if(iao.gt.0) then
        nEdw=nEdwPrvPar
        nCrw=nCrwPrvPar
        kip=PrvKi
        call FeUpdateParamAndKeys(nEdw,nCrw,Ai(iao),Ki(kip),1)
        nEdw=nEdw+1
        nCrw=nCrw+1
        kip=kip+1
        call FeUpdateParamAndKeys(nEdw,nCrw,x(1,iao),Ki(kip),3)
        nEdw=nEdw+3
        nCrw=nCrw+3
        kip=kip+3
        call FeUpdateParamAndKeys(nEdw,nCrw,beta(1,iao),Ki(kip),npar-4)
      endif
      return
      end
      subroutine EM40EditModPar(ia,PrvKi,Rank,px,py,Order,Klic)
      include 'params.cmn'
      include 'basic.cmn'
      include 'atoms.cmn'
      include 'molec.cmn'
      include 'fepc.cmn'
      integer PrvKi,PrvKiMod,Order,Harm,HarmOld,Rank,HarmMax
      dimension tpoma(4),xpoma(4),px(Order,mxw),py(Order,mxw),
     1          pxOld(28*mxw),pyOld(28*mxw)
      character*12 at,pn
      logical lpom
      if(Order.eq.1) then
        if(Klic.eq.0) then
          a0Old=a0(ia)
        else
          a0Old=a0m(ia)
        endif
      endif
      if(Klic.eq.0) then
        HarmMax=kmoda(ia,Rank)
      else
        HarmMax=kmodam(ia,Rank)
      endif
      call CopyVek(px,pxOld,HarmMax*Order)
      call CopyVek(py,pyOld,HarmMax*Order)
      if(Rank.le.4) then
        nn=2
      else
        nn=1
      endif
      no=nn*Order
      if(Rank.eq.1) then
        il=3
      else
        il=nn*((Order-1)/3+2)+1
      endif
      if(Rank.eq.1.or.Rank.eq.2) then
        at='xsin11'
      else if(Rank.eq.3) then
        at='U11sin11'
      else if(Rank.eq.4) then
        at='C111sin11'
      else if(Rank.eq.5) then
        at='D1111sin11'
      else if(Rank.eq.6) then
        at='E11111sin11'
      else
        at='F111111sin11'
      endif
      if(Klic.ne.0) at=at(:idel(at))//'m'
      xdq=270.+3.*(FeTxLength(at)-FeTxLength('F111111sin11'))
      xdqp=xdq*.5
      pom=(xdq-3.*37.-10.)/3.
      pom=(xdq-5.-37.-pom)/2.
      xpoma(3)=xdq-42.-CrwXd
      do 1010i=2,1,-1
        xpoma(i)=xpoma(i+1)-pom
1010  continue
      pom=FeTxLengthUnder(at)+1.
      do 1020i=1,3
        tpoma(i)=xpoma(i)-pom
1020  continue
      id=NextQuestId()
      call FeQuestCreate(id,-1.,-1.,xdq,0,il,
     1                   'Edit modulation amplitudes',
     2                   0,LightGray,0,OKForBasicFiles)
      il=1
      if(Rank.le.4) then
        at='%Harmonic'
      else
        at='%Wave'
      endif
      xpom=xdqp
      tpom=xpom-FeTxLength(at)-5.
      call FeQuestEudMake(id,tpom,il,xpom,il,at,'L',15.,EdwYd,1)
      nEdwHarm=EdwLastMade
      call FeQuestIntEdwOpen(EdwLastMade,1,.false.)
      call FeQuestEudOpen(EdwLastMade,1,(2*HarmMax)/nn,1,0.,0.,0.)
      if(Klic.eq.0) then
        PrvKiMod=PrvKi+max(TRankCumul(itf(ia)),10)
        do 1030i=1,Rank-1
          if(kmoda(ia,i).gt.0) then
            PrvKiMod=PrvKiMod+2*TRank(i-1)*kmoda(ia,i)
            if(i.eq.1) PrvKiMod=PrvKiMod+1
          endif
1030    continue
      else
        PrvKiMod=PrvKi+7
        if(ktls((ia-1)/mxp+1).gt.0) PrvKiMod=PrvKiMod+21
        if(Klic.gt.1.and.kmodam(ia,1).gt.0)
     1    PrvKiMod=PrvKiMod+1+2*kmodam(ia,1)
        if(Klic.gt.2) PrvKiMod=PrvKiMod+6*kmodam(ia,2)
        if(Klic.gt.3) PrvKiMod=PrvKiMod+6*kmodam(ia,2)
        if(Klic.gt.4) PrvKiMod=PrvKiMod+12*kmodam(ia,3)
        if(Klic.gt.5) PrvKiMod=PrvKiMod+12*kmodam(ia,3)
      endif
      il=il+1
      j=1
      kip=PrvKiMod
      if(Rank.eq.1) then
        ip=0
      else
        ip=1
      endif
      do 1050i=ip,no
        if(i.eq.Order+1.and.Rank.gt.1) then
          if(j.ne.1) il=il+1
          call FeQuestLineMake(id,il)
          il=il+1
          j=1
        endif
        call kdoco(kip,at,pn,1,pom,spom)
        call FeMakeParEdwCrw(id,tpoma(j),xpoma(j),il,pn,pom,ki(kip),
     1                       .false.,nEdw,nCrw)
        if(i.eq.1) then
          nEdwPrv=nEdw
          nCrwPrv=nCrw
          PrvKiMod=kip
        else if(i.eq.no) then
          go to 1060
        endif
        if(j.eq.3) then
          j=1
          il=il+1
        else
          j=j+1
        endif
        kip=kip+1
1050  continue
1060  Harm=1
      HarmOld=1
      kipOld=PrvKiMod
      il=il+1
      dpom=50.
      pom=10.
      xpom=(xdq-3.*dpom-2.*pom)*.5
      do 1300i=1,3
        if(i.eq.1) then
          at='%Refine all'
        else if(i.eq.2) then
          at='%Fix all'
        else if(i.eq.3) then
          at='Re%set'
        endif
        call FeQuestButtonMake(id,xpom,il,50.,ButYd,at)
        if(i.eq.1) then
          nButtRefineAll=ButtonLastMade
        else if(i.eq.2) then
          nButtFixAll=ButtonLastMade
        else if(i.eq.3) then
          nButtReset=ButtonLastMade
        endif
        call FeQuestButtonOpen(ButtonLastMade,ButtonOff)
        xpom=xpom+dpom+pom
1300  continue
1450  icont=0
1500  call FeQuestEvent(id,icont,ich)
      icont=1
      if(CheckType.eq.EventEdw.and.CheckNumber.eq.nEdwHarm) then
        call FeQuestIntFromEdw(nEdwHarm,Harm)
        if(Harm.ne.HarmOld) then
          if(nn.eq.2) then
            i=HarmOld
          else
            i=(HarmOld-1)/2+1
          endif
          call EM40ReadNewMod(px(1,i),py(1,i),kipOld,nEdwPrv,nCrwPrv,
     1                        Order,HarmOld,nn)
          nEdw=nEdwPrv
          nCrw=nCrwPrv
          kip=PrvKiMod+nn*(Harm-1)*Order
          kipOld=kip
          do 1550i=1,no
            call kdoco(kip,at,pn,1,pom,spom)
            call FeQuestRealEdwOpen(nEdw,pom,.false.,.false.)
            call FeQuestEdwLabelChange(id,nEdw,pn)
            call FeQuestCrwOpen(nCrw,ki(kip).ne.0)
            nEdw=nEdw+1
            nCrw=nCrw+1
            kip=kip+1
1550      continue
          HarmOld=Harm
        endif
        go to 1500
      else if(CheckType.eq.EventButton.and.
     1        (CheckNumber.eq.nButtRefineAll.or.
     2         CheckNumber.eq.nButtFixAll)) then
        if(CheckNumber.eq.nButtRefineAll) then
          lpom=.true.
        else
          lpom=.false.
        endif
        nCrw=nCrwPrv
        do 2200i=1,no
          call FeQuestCrwOpen(nCrw,lpom)
          nCrw=nCrw+1
2200    continue
        call FeQuestButtonoff(CheckNumber)
        go to 1450
      else if(CheckType.eq.EventButton.and.CheckNumber.eq.nButtReset)
     1  then
        nEdw=nEdwPrv
        if(Rank.eq.1) then
          pom=.01
        else if(Rank.eq.2) then
          pom=.001
        else if(Rank.eq.3) then
          pom=.0001
        else
          pom=.00001
        endif
        do 2300i=1,no
          call FeQuestRealEdwOpen(nEdw,pom,.false.,.false.)
          nEdw=nEdw+1
2300    continue
        call FeQuestButtonoff(CheckNumber)
        go to 1450
      else if(CheckType.ne.0) then
        call NebylOsetren
        go to 1500
      endif
      if(ich.eq.0) then
        if(Rank.eq.1) then
          call FeUpdateParamAndKeys(nEdwPrv-1,nCrwPrv-1,pom,
     1                              Ki(kipOld-1),1)
          if(Klic.eq.0) then
            a0(ia)=pom
          else
            a0m(ia)=pom
          endif
        endif
        if(nn.eq.2) then
          i=HarmOld
        else
          i=(HarmOld-1)/2+1
        endif
        call EM40ReadNewMod(px(1,i),py(1,i),kipOld,nEdwPrv,nCrwPrv,
     1                      Order,HarmOld,nn)
      else
        if(Order.eq.1) a0(ia)=a0Old
        call CopyVek(pxOld,px,HarmMax*Order)
        call CopyVek(pyOld,py,HarmMax*Order)
      endif
      call FeQuestRemove(id)
      return
      end
      subroutine EM40ReadNewMod(px,py,PrvKi,nEdw,nCrw,Order,Harm,nn)
      include 'params.cmn'
      include 'basic.cmn'
      include 'atoms.cmn'
      include 'fepc.cmn'
      integer Order,PrvKi,Harm
      dimension px(*),py(*)
      if(nn.eq.2) then
        call FeUpdateParamAndKeys(nEdw,nCrw,px,Ki(PrvKi),Order)
        call FeUpdateParamAndKeys(nEdw+Order,nCrw+Order,py,
     1                            Ki(PrvKi+Order),Order)
      else
        if(mod(Harm,2).eq.1) then
          call FeUpdateParamAndKeys(nEdw,nCrw,px,Ki(PrvKi),Order)
        else
          call FeUpdateParamAndKeys(nEdw,nCrw,py,Ki(PrvKi),Order)
        endif
      endif
      return
      end
      subroutine EM40EditMultipole(ia,lasmaxa,PrvKi,yq)
      include 'params.cmn'
      include 'basic.cmn'
      include 'atoms.cmn'
      include 'fepc.cmn'
      dimension tpoma(4),xpoma(4),popasa(64),kipom(64)
      character*12 at,pn
      integer PrvKi,Order,OrderOld
      logical lpom
      id=NextQuestId()
      xdq=270.
      nlasmax=2*lasmaxa-5
      if(nlasmax.gt.0) then
        il=5+(nlasmax-1)/4
      else
        il=1
      endif
      tpoma(1)=3.
      pom=(xdq-4.*37.-10.)/4.
      pom=(xdq-5.-37.-pom)/3.
      do 1000i=2,4
        tpoma(i)=tpoma(i-1)+pom
1000  continue
      xpoma(4)=xdq-42.-CrwXd
      do 1010i=3,1,-1
        xpoma(i)=xpoma(i+1)-pom
1010  continue
      call FeQuestCreate(id,-1.,yq+5.,xdq,0,il,
     1                   'Edit multipole parameters',
     2                   0,LightGray,0,OKForBasicFiles)
      if(lasmaxa.lt.3) then
        ib=3
      else
        ib=4
      endif
      il=1
      kip=PrvKi+max(TRankCumul(itf(ia)),10)
      kipb=kip
      do 1100i=1,ib
        call kdoco(kip,at,pn,1,pom,spom)
        call FeMakeParEdwCrw(id,tpoma(i),xpoma(i),il,pn,pom,ki(kip),
     1                       .false.,nEdw,nCrw)
        if(i.eq.1) then
          nEdwBasic=nEdw
          nCrwBasic=nCrw
        endif
        kip=kip+1
1100  continue
      if(ib.eq.3) kip=kip+1
      kippop=kip
      nall=(lasmaxa-2)**2
      call CopyVek(popas(1,ia),popasa,nall)
      call CopyVekI(Ki(kip),Kipom,nall)
      if(lasmaxa.ge.3) then
        il=il+1
        call FeQuestLineMake(id,il)
        il=il+1
        at='%Order'
        xpom=xdq*.5-7.5
        tpom=xpom-FeTxLength(at)-5.-EdwYd
        call FeQuestEudMake(id,tpom,il,xpom,il,at,'L',15.,EdwYd,1)
        nEdwMult=EdwLastMade
        call FeQuestIntEdwOpen(EdwLastMade,0,.false.)
        call FeQuestEudOpen(EdwLastMade,0,lasmaxa-3,1,0.,0.,0.)
        il=il+1
        j=1
        call kdoco(kip,at,pn,1,pom,spom)
        pom=popas(1,ia)
        do 1200i=1,nlasmax
          call FeMakeParEdwCrw(id,tpoma(j),xpoma(j),il,pn,pom,ki(kip),
     1                         .false.,nEdw,nCrw)
          if(i.eq.1) then
            nEdwPop=nEdw
            nCrwPop=nCrw
          else
            call FeQuestEdwClose(nEdw)
            call FeQuestCrwClose(nCrw)
          endif
          if(j.eq.4) then
            j=1
            il=il+1
          else
            j=j+1
          endif
1200    continue
        Order=0
        OrderOld=0
        NOrder=Order*2+1
        NOrderOld=NOrder
        il=il+1
        dpom=50.
        pom=10.
        xpom=(xdq-3.*dpom-2.*pom)*.5
        do 1300i=1,3
          if(i.eq.1) then
            at='%Refine all'
          else if(i.eq.2) then
            at='%Fix all'
          else if(i.eq.3) then
            at='Re%set'
          endif
          call FeQuestButtonMake(id,xpom,il,dpom,ButYd,at)
          if(i.eq.1) then
            nButtRefineAll=ButtonLastMade
          else if(i.eq.2) then
            nButtFixAll=ButtonLastMade
          else if(i.eq.3) then
            nButtReset=ButtonLastMade
          endif
          call FeQuestButtonOpen(ButtonLastMade,ButtonOff)
          xpom=xpom+dpom+pom
1300    continue
      endif
1450  icont=0
1500  call FeQuestEvent(id,icont,ich)
      icont=1
      if(CheckType.eq.EventEdw.and.CheckNumber.eq.nEdwMult) then
        call FeQuestIntFromEdw(nEdwMult,Order)
        NOrder=Order*2+1
        if(Order.ne.OrderOld) then
          iskip=OrderOld**2
          kip=kippop+iskip
          call FeUpdateParamAndKeys(nEdwPop,nCrwPop,popas(iskip+1,ia),
     1                              Ki(kip),NOrderOld)
          nEdw=nEdwPop
          nCrw=nCrwPop
          k=Order**2
          kip=kippop+k
          do 2100i=1,max(NOrder,NOrderOld)
            if(i.le.NOrder) then
              call kdoco(kip,at,pn,1,pom,spom)
              call FeQuestEdwLabelChange(id,nEdw,pn)
              k=k+1
              call FeQuestRealEdwOpen(nEdw,pom,.false.,.false.)
              call FeQuestCrwOpen(nCrw,ki(kip).ne.0)
              kip=kip+1
            else
              call FeQuestEdwClose(nEdw)
              call FeQuestCrwClose(nCrw)
            endif
            nEdw=nEdw+1
            nCrw=nCrw+1
2100      continue
        endif
        OrderOld=Order
        NOrderOld=NOrder
        go to 1500
      else if(CheckType.eq.EventButton.and.
     1        (CheckNumber.eq.nButtRefineAll.or.
     2         CheckNumber.eq.nButtFixAll)) then
        if(CheckNumber.eq.nButtRefineAll) then
          lpom=.true.
        else
          lpom=.false.
        endif
        nCrw=nCrwPop
        do 2200i=1,NOrder
          call FeQuestCrwOpen(nCrw,lpom)
          nCrw=nCrw+1
2200    continue
        call FeQuestButtonoff(CheckNumber)
        go to 1450
      else if(CheckType.eq.EventButton.and.CheckNumber.eq.nButtReset)
     1  then
        nEdw=nEdwPop
        do 2300i=1,NOrder
          call FeQuestRealEdwOpen(nEdw,0.,.false.,.false.)
          nEdw=nEdw+1
2300    continue
        call FeQuestButtonoff(CheckNumber)
        go to 1450
      else if(CheckType.ne.0) then
        call NebylOsetren
        go to 1500
      endif
      if(ich.eq.0) then
        nEdw=nEdwBasic
        nCrw=nCrwBasic
        kip=kipb
        do 3000i=1,ib
          call FeUpdateParamAndKeys(nEdw,nCrw,pom,Ki(kip),1)
          if(i.eq.1) then
            popc(ia)=pom
          else if(i.eq.2) then
            popv(ia)=pom
          else if(i.eq.3) then
            kapa1(ia)=pom
          else
            kapa2(ia)=pom
          endif
          kip=kip+1
          nEdw=nEdw+1
          nCrw=nCrw+1
3000    continue
        nEdw=nEdwPop
        nCrw=nCrwPop
        j=Order*2+1
        iskip=Order**2
        kip=kippop+iskip
        call FeUpdateParamAndKeys(nEdw,nCrw,popas(iskip+1,ia),Ki(kip),j)
      else
        call CopyVek(popasa,popas(1,ia),nall)
        call CopyVekI(Kipom,Ki(kip),nall)
      endif
      call FeQuestRemove(id)
      return
      end
      subroutine EM40EditADP(ia,itfa,PrvKi,yq)
      include 'params.cmn'
      include 'basic.cmn'
      include 'atoms.cmn'
      include 'fepc.cmn'
      dimension tpoma(4),xpoma(4),cpom(74),kipom(74)
      character*12 at,pn
      integer PrvKi,Order,OrderOld,PrvKiAnh
      logical lpom
      j=1
      do 1000i=3,itfa
        n=TRank(i)
        if(i.eq.3) then
          call CopyVek(c3(1,ia),cpom(j),n)
        else if(i.eq.4) then
          call CopyVek(c4(1,ia),cpom(j),n)
        else if(i.eq.5) then
          call CopyVek(c5(1,ia),cpom(j),n)
        else
          call CopyVek(c6(1,ia),cpom(j),n)
        endif
        j=j+n
1000  continue
      n=j-1
      PrvKiAnh=PrvKi+10
      call CopyVekI(ki(PrvKiAnh),kipom,n)
      id=NextQuestId()
      xdq=270.
      NParMax=TRank(itfa)
      il=3+(nParMax-1)/4
      tpoma(1)=3.
      pom=(xdq-4.*37.-10.)/4.
      pom=(xdq-5.-37.-pom)/3.
      do 1010i=2,4
        tpoma(i)=tpoma(i-1)+pom
1010  continue
      xpoma(4)=xdq-42.-CrwXd
      do 1020i=3,1,-1
        xpoma(i)=xpoma(i+1)-pom
1020  continue
      call FeQuestCreate(id,-1.,yq+5.,xdq,0,il,
     1                   'Edit ADP parameters',0,LightGray,0,
     2                   OKForBasicFiles)
      il=1
      at='%Order'
      xpom=xdq*.5-7.5
      tpom=xpom-FeTxLength(at)-5.-EdwYd
      call FeQuestEudMake(id,tpom,il,xpom,il,at,'L',15.,EdwYd,1)
      nEdwOrder=EdwLastMade
      call FeQuestIntEdwOpen(EdwLastMade,3,.false.)
      call FeQuestEudOpen(EdwLastMade,3,itfa,1,0.,0.,0.)
      il=il+1
      j=1
      kip=PrvKiAnh
      do 1100i=1,NParMax
        call kdoco(kip,at,pn,1,pom,spom)
        call FeMakeParEdwCrw(id,tpoma(j),xpoma(j),il,pn,pom,ki(kip),
     1                       .false.,nEdw,nCrw)
        if(i.eq.1) then
          nEdwPrv=nEdw
          nCrwPrv=nCrw
        else if(i.gt.10) then
          call FeQuestEdwClose(nEdw)
          call FeQuestCrwClose(nCrw)
        endif
        if(j.eq.4) then
          j=1
          il=il+1
        else
          j=j+1
        endif
        kip=kip+1
1100  continue
      il=il+1
      dpom=50.
      pom=10.
      xpom=(xdq-3.*dpom-2.*pom)*.5
      do 1300i=1,3
        if(i.eq.1) then
          at='%Refine all'
        else if(i.eq.2) then
          at='%Fix all'
        else if(i.eq.3) then
          at='Re%set'
        endif
        call FeQuestButtonMake(id,xpom,il,50.,ButYd,at)
        if(i.eq.1) then
          nButtRefineAll=ButtonLastMade
        else if(i.eq.2) then
          nButtFixAll=ButtonLastMade
        else if(i.eq.3) then
          nButtReset=ButtonLastMade
        endif
        call FeQuestButtonOpen(ButtonLastMade,ButtonOff)
        xpom=xpom+dpom+pom
1300  continue
      Order=3
      OrderOld=3
      NOrder=10
      NOrderOld=10
1450  icont=0
1500  call FeQuestEvent(id,icont,ich)
      icont=1
      if(CheckType.eq.EventEdw.and.CheckNumber.eq.nEdwOrder) then
        call FeQuestIntFromEdw(nEdwOrder,Order)
        NOrder=TRank(Order)
        if(Order.ne.OrderOld) then
          call EM40ReadNewADP(ia,PrvKi,nEdwPrv,nCrwPrv,OrderOld,
     1                        NOrderOld)
          nEdw=nEdwPrv
          nCrw=nCrwPrv
          kip=PrvKi+TRankCumul(Order-1)
          do 2100i=1,max(NOrder,NOrderOld)
            if(i.le.NOrder) then
              call kdoco(kip,at,pn,1,pom,spom)
              call FeQuestEdwLabelChange(id,nEdw,pn)
              call FeQuestRealEdwOpen(nEdw,pom,.false.,.false.)
              call FeQuestCrwOpen(nCrw,ki(kip).ne.0)
              kip=kip+1
            else
              call FeQuestEdwClose(nEdw)
              call FeQuestCrwClose(nCrw)
            endif
            nEdw=nEdw+1
            nCrw=nCrw+1
2100      continue
        endif
        OrderOld=Order
        NOrderOld=NOrder
        go to 1500
      else if(CheckType.eq.EventButton.and.
     1        (CheckNumber.eq.nButtRefineAll.or.
     2         CheckNumber.eq.nButtFixAll)) then
        if(CheckNumber.eq.nButtRefineAll) then
          lpom=.true.
        else
          lpom=.false.
        endif
        nCrw=nCrwPrv
        do 2200i=1,NOrder
          call FeQuestCrwOpen(nCrw,lpom)
          nCrw=nCrw+1
2200    continue
        call FeQuestButtonoff(CheckNumber)
        go to 1450
      else if(CheckType.eq.EventButton.and.CheckNumber.eq.nButtReset)
     1  then
        nEdw=nEdwPrv
        do 2300i=1,NOrder
          call FeQuestRealEdwOpen(nEdw,0.,.false.,.false.)
          nEdw=nEdw+1
2300    continue
        call FeQuestButtonoff(CheckNumber)
        go to 1450
      else if(CheckType.ne.0) then
        call NebylOsetren
        go to 1500
      endif
      if(ich.eq.0) then
          call EM40ReadNewADP(ia,PrvKi,nEdwPrv,nCrwPrv,Order,NOrder)
      else
        j=1
        do 5000i=3,itfa
          n=TRank(i)
          if(i.eq.3) then
            call CopyVek(cpom(j),c3(1,ia),n)
          else if(i.eq.4) then
            call CopyVek(cpom(j),c4(1,ia),n)
          else if(i.eq.5) then
            call CopyVek(cpom(j),c5(1,ia),n)
          else
            call CopyVek(cpom(j),c6(1,ia),n)
          endif
          j=j+n
5000    continue
        n=j-1
        call CopyVekI(kipom,ki(PrvKi+10),n)
      endif
      call FeQuestRemove(id)
      return
      end
      subroutine EM40ReadNewADP(ia,PrvKi,nEdw,nCrw,Order,NOrder)
      include 'params.cmn'
      include 'basic.cmn'
      include 'atoms.cmn'
      include 'fepc.cmn'
      integer Order,PrvKi
      kip=PrvKi+TRankCumul(Order-1)
      if(Order.eq.3) then
        call FeUpdateParamAndKeys(nEdw,nCrw,c3(1,ia),Ki(kip),NOrder)
      else if(Order.eq.4) then
        call FeUpdateParamAndKeys(nEdw,nCrw,c4(1,ia),Ki(kip),NOrder)
      else if(Order.eq.5) then
        call FeUpdateParamAndKeys(nEdw,nCrw,c5(1,ia),Ki(kip),NOrder)
      else
        call FeUpdateParamAndKeys(nEdw,nCrw,c6(1,ia),Ki(kip),NOrder)
      endif
      return
      end
      subroutine EM40SwitchBetaU(Klic,n)
      include 'params.cmn'
      include 'basic.cmn'
      include 'atoms.cmn'
      dimension poma(6,3)
      if(Klic.eq.0) then
        pom=1./episq
        do 1100isw=1,ncomp
          do 1000j=1,6
            poma(j,isw)=1./urcp(j,isw,KPhase)
1000      continue
1100    continue
      else
        pom=episq
        call CopyVek(urcp(1,1,KPhase),poma,6*ncomp)
      endif
      if(n.le.0) then
        ip=1
        ik=nacAll
        if(nacbAll.gt.0) ik=mxa+nacb
      else
        ip=nacOff+n
        ik=ip
      endif
      do 2000i=ip,ik
        if(i.gt.nacAll.and.i.le.mxa) go to 2000
        if(kswa(i).ne.KPhase) go to 2000
        isw=iswa(i)
        if(itf(i).eq.1) then
          beta(1,i)=beta(1,i)*pom
        else
          do 1500j=1,6
            beta(j,i)=beta(j,i)*poma(j,isw)
1500      continue
        endif
2000  continue
      return
      end
      subroutine ZmMultGroup(ich)
      include 'params.cmn'
      include 'basic.cmn'
      include 'atoms.cmn'
      include 'fepc.cmn'
      include 'editm40.cmn'
      character*80 Veta
      character*2  Sipka
      logical CrwLogicQuest
      data Sipka/'->'/
      call DefGroup(i1,i2,0)
      if(i1.le.0) then
        ich=1
        go to 9999
      endif
      lasmaxa=0
      do 1000i=1,nac
        if(AtBrat(i)) lasmaxa=max(lasmaxa,lasmax(i))
1000  continue
      lasmaxa=lasmaxa+1
      id=NextQuestId()
      xdq=110.
      il=3
      call FeQuestCreate(id,-1.,-1.,xdq,0,il,'Multipole parameters',0,
     1                   LightGray,0,OKForBasicFiles)
      il=0
      xpom=5.
      tpom=xpom+12.
      do 1110i=1,3
        il=il+1
        if(i.eq.1) then
          Veta='n%one'
        else if(i.eq.2) then
          Veta='%kappa'
        else
          Veta='o%rder'
        endif
        call FeQuestCrwMake(id,tpom,il,xpom,il,Veta,'L',CrwgXd,
     1                      CrwgYd,1,3)
        if(i.eq.1) then
          nCrwMultNone=CrwLastMade
        else if(i.eq.2) then
          nCrwMultKappa=CrwLastMade
        else
          nCrwMultOrder=CrwLastMade
        endif
1110  continue
      tpom=tpom+FeTxLength('XXXXX')+3.
      xpom=tpom+FeTxLength(Sipka)+3.
      call FeQuestEudMake(id,tpom,il,xpom,il,Sipka,'L',15.,EdwYd,0)
      nEdwMult=EdwLastMade
      nCrw=nCrwMultNone
      do 1300i=1,3
        call FeQuestCrwOpen(nCrw,i.eq.min(lasmaxa,3))
        nCrw=nCrw+1
1300  continue
1400  if(lasmaxa.ge.3) then
        call FeQuestIntEdwOpen(nEdwMult,lasmaxa-3,.false.)
        call FeQuestEudOpen(nEdwMult,0,7,1,0.,0.,0.)
      else
        call FeQuestEdwClose(nEdwMult)
      endif
      icont=0
1500  call FeQuestEvent(id,icont,ich)
      icont=1
      if(CheckType.eq.EventCrw) then
        if(CheckNumber.eq.nCrwMultNone) then
          lasmaxa=1
        else if(CheckNumber.eq.nCrwMultKappa) then
          lasmaxa=2
        else
          lasmaxa=3
        endif
        go to 1400
      else if(CheckType.ne.0) then
        call NebylOsetren
        go to 1500
      endif
      if(ich.le.0) then
        if(CrwLogicQuest(nCrwMultOrder)) then
          call FeQuestIntFromEdw(nEdwMult,lasmaxa)
          lasmaxa=lasmaxa+3
        endif
        do 2000i=i1,i2
          if(AtBrat(i)) call ZmMult(i,lasmaxa-1)
2000    continue
      endif
      call FeQuestRemove(id)
9999  return
      end
      subroutine ZmMult(ia,lasmaxn)
      include 'params.cmn'
      include 'basic.cmn'
      include 'atoms.cmn'
      include 'fepc.cmn'
      call ShiftKiAt(ia,itf(ia),ifr(ia),lasmaxn,kmods(ia),kmodx(ia),
     1               kmodb(ia),kmodc3(ia),kmodc4(ia),kmodc5(ia),
     2               kmodc6(ia),.false.)
      kip=PrvniKiAtomu(ia)+max(TRankCumul(itf(ia)),10)
      n=nint(ffatn(isf(ia),KPhase))
      if(lasmax(ia).le.0.and.lasmaxn.gt.0) then
        if(n.lt.2) then
          pom=0.
        else if(n.lt.10) then
          pom=2.
        else if(n.lt.18) then
          pom=10.
        else if(n.lt.29) then
          pom=18.
        else if(n.lt.36) then
          pom=28.
        else if(n.lt.47) then
          pom=36.
        else if(n.lt.54) then
          pom=46.
        else if(n.lt.71) then
          pom=54.
        else if(n.lt.79) then
          pom=68.
        else if(n.lt.86) then
          pom=78.
        else
          pom=86.
        endif
        popc(ia)=pom
        popv(ia)=float(n)-popc(ia)
        kapa1(ia)=1.
        ki(kip)=0
        ki(kip+1)=0
        ki(kip+2)=1
      endif
      if(lasmax(ia).le.1.and.lasmaxn.gt.1) then
        kapa2(ia)=1.
        ki(kip+3)=1
        SmbPGAt(ia)='1'
        LocAtSystSt(1,ia)='1 0 0'
        LocAtSystSt(2,ia)='0 1 0'
        LocAtSystAx(ia)='xy'
      endif
      if(lasmaxn.gt.1.and.lasmax(ia).lt.lasmaxn) then
        if(lasmax(ia).gt.1) then
          j=(lasmax(ia)-1)**2+1
        else
          j=2
        endif
        n=(lasmaxn-1)**2-j+1
        call SetRealArrayTo(popas(j,ia),n,0.)
        kip=kip+3+j
        call SetIntArrayTo(ki(kip),n,1)
      endif
      lasmax(ia)=lasmaxn
9999  return
      end
      subroutine EM40EditMolecules(ich)
      include 'params.cmn'
      include 'basic.cmn'
      include 'atoms.cmn'
      include 'molec.cmn'
      include 'fepc.cmn'
      dimension tpoma(4),xpoma(4),poma(1),kmodamn(3),Ktera(6),Rot(9),
     1          XCentr(3),trp(9),trpi(9),Rotp(9)
      character*256 EdwStringQuest
      character*80 Veta,ErrSt
      character*12 men(6),menp(6)
      character*12 at,pn
      integer PrvKi,FeMenu,pocder,EdwStateQuest
      logical Konec,lpom,CrwLogicQuest
      equivalence (pom,poma)
      data men/'Occupancy','Translation','Rotation','Tensor T',
     1         'Tensor L','Tensor S'/
      ich=0
      im=1
      imo=0
      ip=1
      ipo=0
      imp=1
      impo=0
      Konec=.false.
      id=NextQuestId()
      xdq=270.
      xdqp=xdq*.5
      if(ndimi.eq.0) then
        il=10
      else
        il=14
      endif
      call FeQuestCreate(id,-1.,-1.,xdq,0,il,'Molecule edit',0,
     1                   LightGray,0,OKForBasicFiles)
      il=1
      Veta='%Molecule #'
      tpom=5.
      xpom=tpom+FeTxLengthUnder(Veta)+2.+EdwYd
      dpom=18.
      call FeQuestEudMake(id,tpom,il,xpom,il,Veta,'L',dpom,EdwYd,1)
      nEdwMolNo=EdwLastMade
      call FeQuestIntEdwOpen(nEdwMolNo,im,.false.)
      call FeQuestEudOpen(nEdwMolNo,1,nmolc,1,0.,0.,0.)
      Veta='%List'
      dpom=FeTxLengthUnder(Veta)+5.
      xpom=xpom+dpom+2.+2.*EdwYd
      call FeQuestButtonMake(id,xpom,il,dpom,ButYd,Veta)
      nButtMolList=ButtonLastMade
      if(nmolc.gt.1) then
        i=ButtonOff
      else
        i=ButtonDisabled
      endif
      call FeQuestButtonOpen(ButtonLastMade,i)
      Veta='%Name'
      tpom=xpom+dpom+15.
      xpom=tpom+FeTxLengthUnder(Veta)+2.
      dpom=FeTxLengthUnder('XXXXXXXX')+5.
      call FeQuestEdwMake(id,tpom,il,xpom,il,Veta,'L',dpom,EdwYd,1)
      nEdwMolName=EdwLastMade
      Veta='%Position #'
      tpom=xpom+dpom+10.
      xpom=tpom+FeTxLengthUnder(Veta)+2.
      dpom=18.
      call FeQuestEudMake(id,tpom,il,xpom,il,Veta,'L',dpom,EdwYd,1)
      nEdwPosNo=EdwLastMade
      call FeQuestIntEdwOpen(nEdwPosNo,ip,.false.)
      il=il+1
      call FeQuestLabelMake(id,30.,il,'Reference point:','L')
      tpom=5.
      xpom=tpom+FeTxLength('XXXXXXXXXXXXXX')+5.
      ilp=il
      do 1000i=1,3
        il=il+1
        if(i.eq.1) then
          Veta='%Explicitly'
        else if(i.eq.2) then
          Veta='%Gravity center'
        else
          Veta='Ge%om. center'
        endif
        call FeQuestCrwMake(id,tpom,il,xpom,il,Veta,'L',CrwgXd,CrwgYd,
     1                      1,2)
        if(i.eq.1) then
          nCrwCenterFirst=CrwLastMade
          tp=xpom+CrwgXd+5.
          xp=tp+FeTxLength('XX')+5.
          dpom=80.
          call FeQuestEdwMake(id,tp,il,xp,il,' ','L',90.,EdwYd,1)
          nEdwRef=EdwLastMade
        else if(i.eq.3) then
          nCrwCenterLast=CrwLastMade
        endif
        call FeQuestCrwOpen(CrwLastMade,i.eq.1)
1000  continue
      il=ilp
      Veta='Point group'
      tpom=(xdq+xp+dpom)*.5
      dpom=40.
      xpom=tpom-dpom*.5
      call FeQuestEdwMake(id,tpom,il,xpom,il+1,Veta,'C',dpom,EdwYd,1)
      nEdwPG=EdwLastMade
      il=il+2
      Veta='%Hermann-Mauguin short'
      dpom=FeTxLengthUnder(Veta)+5.
      xpom=tpom-dpom*.5
      call FeQuestButtonMake(id,xpom,il,dpom,ButYd,Veta)
      nButtPGInter=ButtonLastMade
      call FeQuestButtonOpen(ButtonLastMade,ButtonOff)
      il=il+1
      Veta='Schoen%flies'
      dpom=FeTxLengthUnder(Veta)+5.
      xpom=tpom-dpom*.5
      call FeQuestButtonMake(id,xpom,il,dpom,ButYd,Veta)
      nButtPGSchoen=ButtonLastMade
      call FeQuestButtonOpen(ButtonLastMade,ButtonOff)
      il=il+1
      Veta='Define coordin%ate system'
      dpom=FeTxLengthUnder(Veta)+5.
      xpom=tpom-dpom*.5
      call FeQuestButtonMake(id,xpom,il,dpom,ButYd,Veta)
      nButtDefPGSyst=ButtonLastMade
      call FeQuestButtonOpen(ButtonLastMade,ButtonOff)
      il=ilp+5
      call FeQuestLineMake(id,il)
      il=il+1
      Veta='Imp%roper rotation'
      xpom=5.
      tpom=xpom+CrwXd+5.
      call FeQuestCrwMake(id,tpom,il,xpom,il,Veta,'L',CrwXd,CrwYd,1,0)
      nCrwImprop=CrwLastMade
      tpom=tpom+FeTxLengthUnder(Veta)+10.
      Veta='%Define local coordinate system'
      dpom=FeTxLengthUnder(Veta)+5.
      call FeQuestButtonMake(id,tpom,il,dpom,ButYd,Veta)
      nButtDefLocSyst=ButtonLastMade
      call FeQuestButtonOpen(ButtonLastMade,ButtonOff)
      tpom=tpom+dpom+10.
      Veta='Appl%y site symmetry'
      dpom=FeTxLengthUnder(Veta)+5.
      call FeQuestButtonMake(id,tpom,il,dpom,ButYd,Veta)
      nButtSymmetry=ButtonLastMade
      call FeQuestButtonOpen(ButtonLastMade,ButtonOff)
      pom=(xdq-4.*37.-10.)/4.
      pom=(xdq-5.-37.-pom)/3.
      tpoma(1)=3.
      do 1125i=2,4
        tpoma(i)=tpoma(i-1)+pom
1125  continue
      xpoma(4)=xdq-42.-CrwXd
      do 1130i=3,1,-1
        xpoma(i)=xpoma(i+1)-pom
1130  continue
      il=il+1
      PrvKi=PrvniKiMolekuly(imp)
      kip=PrvKi
      j=0
      do 1150i=1,7
        call kdoco(kip,at,pn,1,pom,spom)
        k=idel(pn)
        if(k.eq.3) then
          pn='   '//pn(:k)
        else if(k.eq.5) then
          pn=' '//pn(:k)
        endif
        j=j+1
        if(i.eq.5) j=j+1
        call FeMakeParEdwCrw(id,tpoma(j),xpoma(j),il,pn,pom,
     1                       ki(kip),.false.,nEdw,nCrw)
        kip=kip+1
        if(i.eq.1) then
          nEdwPrvPar=nEdw
          nCrwPrvPar=nCrw
        endif
        if(mod(i,4).eq.0) then
          il=il+1
          j=0
        endif
1150  continue
      Veta='Edit TLS'
      dpom=FeTxLengthUnder(Veta)+5.
      call FeQuestButtonMake(id,xpoma(1),il,dpom,ButYd,Veta)
      nButtEditTLS=ButtonLastMade
      if(ndimi.gt.0) then
        il=il+1
        tpom=5.
        Veta='MODULATIONS:'
        call FeQuestLabelMake(id,xdqp,il,Veta,'C')
        xpom=tpom+5.+FeTxLengthUnder('%TLS parameters')
        xp=xpom+25.+EdwYd
        tp=xp+CrwXd+2.
        do 1170i=1,3
          il=il+1
          if(i.eq.1) then
            Veta='Occ%upancy'
          else if(i.eq.2) then
            Veta='Po%sition'
          else if(i.eq.3) then
            Veta='%TLS parameters'
          endif
          call FeQuestEudMake(id,tpom,il,xpom,il,Veta,'L',15.,EdwYd,1)
          call FeQuestIntEdwOpen(EdwLastMade,kmodam(imp,i),.false.)
          call FeQuestEudOpen(EdwLastMade,0,mxw,1,0.,0.,0.)
          if(i.eq.1) then
            nEdwModOcc=EdwLastMade
            call FeQuestCrwMake(id,tp,il,xp,il,'Use %crenel','L',CrwXd,
     1                          CrwYd,1,0)
            nCrwCrenel=CrwLastMade
          else if(i.eq.2) then
            nEdwModPos=EdwLastMade
            call FeQuestCrwMake(id,tp,il,xp,il,'Use sa%w-tooth','L',
     1                          CrwXd,CrwYd,1,0)
            nCrwSawTooth=CrwLastMade
          else if(i.eq.3) then
            nEdwModTLS=EdwLastMade
          endif
1170    continue
        xpom=tp+FeTxLength('XXXXXXXXXXXXX')+10.
        Veta='Ed%it modulation parameters'
        dpom=FeTxLengthUnder(Veta)+5.
        call FeQuestButtonMake(id,xpom,il,dpom,ButYd,Veta)
        nButtEditMod=ButtonLastMade
      else
        nEdwModOcc=0
        nEdwModPos=0
        nEdwModTLS=0
        nCrwCrenel=0
        nCrwSawTooth=0
        nButtEditMod=0
      endif
      icont=0
      ipg=LocateInStringArray(SmbPGI,nSmbPG,SmbPGMol(im),.true.)
      if(ipg.le.0)
     1  ipg=LocateInStringArray(SmbPGO,nSmbPG,SmbPGMol(im),.true.)
      if(ipg.le.0) then
        SmbPGMol(im)='1'
        ipg=1
      endif
1200  if(im.ne.imo) then
        nap=mxa+1
        do 1210i=1,im-1
          nap=nap+iam(i)*mam(i)
1210    continue
        call FeQuestIntEdwOpen(nEdwMolNo,im,.false.)
        call FeQuestEudOpen(nEdwPosNo,1,mam(im),1,0.,0.,0.)
        call FeQuestStringEdwOpen(nEdwMolName,MolName(im))
        do 1220i=nCrwCenterFirst,nCrwCenterLast
          lpom=RefPoint(im).eq.i-nCrwCenterFirst
          call FeQuestCrwOpen(i,lpom)
          if(i.eq.nCrwCenterFirst) then
            if(lpom.or.ipg.gt.1) then
              Veta=StRefPoint(im)
              if(Veta.eq.' ') then
                write(Veta,100)(xm(j,im),j=1,3)
                call ZdrcniCisla(Veta,3)
              endif
              call FeQuestStringEdwOpen(nEdwRef,Veta)
            else
              call FeQuestEdwClose(nEdwRef)
            endif
          endif
1220    continue
1230    call FeQuestStringEdwOpen(nEdwPG,SmbPGMol(im))
        if(ktls(im).gt.0) then
          i=ButtonOff
        else
          i=ButtonDisabled
        endif
        call FeQuestButtonOpen(nButtEditTLS,i)
      endif
      imp=(im-1)*mxp+ip
      PrvKi=PrvniKiMolekuly(imp)
      if(imp.ne.impo) then
        nEdw=nEdwPrvPar
        nCrw=nCrwPrvPar
        kip=PrvKi
        do 1350i=1,7
          call kdoco(kip,at,pn,1,pom,spom)
          call FeQuestRealEdwOpen(nEdw,pom,.false.,.false.)
          call FeQuestCrwOpen(nCrw,Ki(kip).ne.0)
          kip=kip+1
          nEdw=nEdw+1
          nCrw=nCrw+1
1350    continue
        call FeQuestCrwOpen(nCrwImprop,RotSign(imp).lt.0)
        if(ndimi.gt.0) then
          nEdw=nEdwModOcc
          do 1400i=1,3
            kmodamn(i)=kmodam(imp,i)
            call FeQuestIntEdwOpen(nEdw,kmodamn(i),.false.)
            nEdw=nEdw+1
1400      continue
          call FeQuestCrwOpen(nCrwCrenel,kfsm(imp).ne.0)
          call FeQuestCrwOpen(nCrwSawTooth,kfxm(imp).ne.0)
        endif
      endif
      imo=im
      ipo=ip
      impo=imp
      isw=iswmol(im)
      if(ndimi.gt.0) then
        if(kmodsm(impo).gt.0.or.kmodxm(impo).gt.0.or.kmodbm(impo).gt.0)
     1    then
          i=ButtonOff
        else
          i=ButtonDisabled
        endif
        call FeQuestButtonOpen(nButtEditMod,i)
      endif
1500  call FeQuestEvent(id,icont,ich)
      icont=1
      if(CheckType.eq.EventEdw.and.CheckNumber.eq.nEdwMolNo) then
        call FeQuestIntFromEdw(nEdwMolNo,im)
        if(im.ne.imo) then
          ip=1
          impo=0
          go to 2000
        else
          go to 1500
        endif
      else if(CheckType.eq.EventEdw.and.CheckNumber.eq.nEdwMolName)
     1  then
        Veta=EdwStringQuest(nEdwMolName)
        call UprAt(Veta)
        call AtCheck(Veta,i,j)
        if(i.ne.0) then
          if(i.eq.1) then
            Veta='Unacceptable symbol in the molecule name'
          else if(i.eq.2) then
            if(j.ne.-im) then
              Veta='The name already exists'
            else
              go to 1600
            endif
          endif
          call FeChybne(-1.,-1.,Veta,' ',0,SeriousError)
          EventType=EventEdw
          EventNumber=nEdwMolName
          go to 1500
        else
          MolName(im)=Veta
        endif
1600    call FeQuestStringEdwOpen(nEdwMolName,MolName(im))
        go to 1500
      else if(CheckType.eq.EventEdw.and.CheckNumber.eq.nEdwPosNo) then
        call FeQuestIntFromEdw(nEdwPosNo,ip)
        if(ip.ne.ipo) then
          go to 2000
        else
          go to 1500
        endif
      else if(CheckType.eq.EventEdw.and.(CheckNumber.eq.nEdwModOcc.or.
     1        CheckNumber.eq.nEdwModPos.or.CheckNumber.eq.nEdwModTLS))
     2  then
        call EM40MolNewBasic(imo,impo,PrvKi,nEdwPrvPar,nCrwPrvPar,
     1                       kmodamn,nEdwModOcc,nCrwCrenel,nCrwSawTooth)
        go to 1200
      else if(CheckType.eq.EventButton.and.CheckNumber.eq.nButtMolList)
     1  then
        call SelOneAtom('Select next molecule',MolName,im,nmolc,ich)
        call FeQuestButtonOff(nButtMolList)
        icont=0
        if(im.ne.imo.and.ich.eq.0) then
          ip=1
          impo=0
          go to 2000
        else
          im=imo
          go to 1500
        endif
      else if((CheckType.eq.EventCrw.and.CheckNumber.ge.nCrwCenterFirst
     1                              .and.CheckNumber.le.nCrwCenterLast)
     2         .or.CheckType.eq.EventEdw.and.CheckNumber.eq.nEdwRef)
     3  then
        call EM40MolNewBasic(imo,impo,PrvKi,nEdwPrvPar,nCrwPrvPar,
     1                       kmodamn,nEdwModOcc,nCrwCrenel,nCrwSawTooth)
        call CrlSetRotMat(imp)
        ic=CheckType
        if(ic.eq.EventCrw) then
          i=CheckNumber-nCrwCenterFirst
          if(i.ne.RefPoint(im)) RefPoint(im)=i
        endif
        if(EdwStateQuest(nEdwRef).eq.EdwOpened) then
          Veta=EdwStringQuest(nEdwRef)
        else
          Veta=' '
        endif
        call CrlDefMolRefPoint(im,Veta,ich)
        if(ich.gt.0) then
          if(EdwStateQuest(nEdwRef).eq.EdwOpened) then
            EventType=EventEdw
            EventNumber=nEdwRef
            go to 1500
          endif
        else if(ich.eq.0) then
          StRefPoint(im)=Veta
        else if(ich.eq.-1) then
          StRefPoint(im)=' '
        endif
        imo=0
        impo=0
        if(ic.eq.EventCrw) icont=0
        go to 1200
      else if(CheckType.eq.EventButton.and.
     1        CheckNumber.eq.nButtDefPGSyst) then
        call EM40DefPGSyst(im,ich)
        icont=0
        call FeQuestButtonOff(CheckNumber)
        go to 1500
      else if(CheckType.eq.EventButton.and.
     1        CheckNumber.eq.nButtDefLocSyst) then
        call EM40MolNewBasic(imo,impo,PrvKi,nEdwPrvPar,nCrwPrvPar,
     1                       kmodamn,nEdwModOcc,nCrwCrenel,nCrwSawTooth)
        call CrlSetRotMat(imp)
        call EM40DefMolLocSyst(imp,ich)
        if(ich.eq.0) then
          call CopyMat(RotMol(1,imp),Rot,3)
          call CopyVek(TrToOrtho(1,isw,KPhase),TrMol(1,imp),9)
          call CopyVek(TrToOrthoI(1,isw,KPhase),TriMol(1,imp),9)
          do 1700l=1,2
            if(l.eq.1) then
              call CopyVek(xm(1,im),XCentr,3)
            else
              call AddVek(XCentr,trans(1,imp),XCentr,3)
            endif
            if(LocMolSystType(imp).ge.l) then
              if(l.eq.1) then
                ii=im
              else
                ii=0
              endif
              Veta=molname(im)(:idel(molname(im)))
              write(Cislo,'(i2)') imp
              call zhusti(Cislo)
              Veta=Veta(:idel(Veta))//'#'//Cislo(:idel(Cislo))
              call CrlMakeTrMatToLocal(XCentr,Veta,LocMolSystAx(l,imp),
     1                    LocMolSystSt(1,l,imp),' ',trp,trpi,ii,ich)
              if(ich.ne.0) go to 1810
              if(l.eq.1) then
                call CopyMat(trp,TrMol(1,imp),3)
                call CopyMat(trpi,TriMol(1,imp),3)
              else
                call CopyMat(trpi,TriMol(1,imp),3)
              endif
            endif
1700      continue
          call MatInv(TrMol(1,imp),trpi,pom,3)
          call MatInv(TriMol(1,imp),trp,pom,3)
          call multm(rot,trpi,rotp,3,3,3)
          call multm(trp,rotp,rot,3,3,3)
          call EM40GetAngles(rot,irot,euler(1,imp))
          do 1710l=1,3
            euler(l,imp)=anint(euler(l,imp)*1000.)*.001
1710      continue
          call CrlSetRotMat(imp)
          go to 1800
        else
          go to 1810
        endif
      else if(CheckType.eq.EventButton.and.CheckNumber.eq.nButtPGInter)
     1  then
        call SelOneAtom('Select point group',SmbPGI,ipg,nSmbPG,ich)
        if(ich.eq.0) then
          SmbPGMol(im)=SmbPGI(ipg)
          go to 1800
        else
          go to 1810
        endif
      else if(CheckType.eq.EventButton.and.CheckNumber.eq.nButtPGSchoen)
     1  then
        call SelOneAtom('Select point group',SmbPGO,ipg,nSmbPG,ich)
        if(ich.eq.0) then
          SmbPGMol(im)=SmbPGO(ipg)
          go to 1800
        else
          go to 1810
        endif
      else if(CheckType.eq.EventEdw.and.CheckNumber.eq.nEdwPG) then
        Veta=EdwStringQuest(nEdwPG)
        ipg=LocateInStringArray(SmbPGI,nSmbPG,Veta,.true.)
        if(ipg.le.0) then
          ipg=LocateInStringArray(SmbPGO,nSmbPG,Veta,.true.)
          if(ipg.gt.0) Veta=SmbPGO(ipg)
        else
          Veta=SmbPGI(ipg)
        endif
        if(ipg.le.0) then
          call FeChybne(-1.,-1.,'the point group isn''t on the list',
     1                  ' ',0,SeriousError)
          EventType=EventEdw
          EventNumber=nEdwPG
          ipg=1
        else
          SmbPGMol(im)=Veta
          call FeQuestStringEdwOpen(nEdwPG,Veta)
        endif
        go to 1500
      else if(CheckType.eq.EventCrw.and.CheckNumber.eq.nCrwImprop) then
        if(CrwLogicQuest(nCrwImprop)) then
          RotSign(imp)=-1
        else
          RotSign(imp)= 1
        endif
        icont=0
        go to 1500
      else if(CheckType.eq.EventButton.and.CheckNumber.eq.nButtEditTLS)
     1  then
        call EM40EditTLS(imp)
        call FeQuestButtonOff(nButtEditTLS)
        icont=0
        go to 1500
      else if(CheckType.eq.EventButton.and.CheckNumber.eq.nButtSymmetry)
     1  then
        call EM40MolNewBasic(imo,impo,PrvKi,nEdwPrvPar,nCrwPrvPar,
     1                       kmodamn,nEdwModOcc,nCrwCrenel,nCrwSawTooth)
        neq=0
        neqs=0
        call MolSpec(imo,imo)
        do 1764i=1,neq
          lnp(i)=lnp(i)+pocder(ktatmol(lat(i)))
          ki(lnp(i))=0
          do 1762j=1,npa(i)
            pnp(j,i)=pnp(j,i)+pocder(ktatmol(pat(j,i)))
1762      continue
1764    continue
        call apeq(0,0,0)
        call FeQuestButtonoff(CheckNumber)
        imo=0
        impo=0
        icont=0
        go to 1200
      else if(CheckType.eq.EventCrw.and.CheckNumber.eq.nCrwCrenel) then
        call FeQuestIntFromEdw(nEdwModOcc,n)
        if(CrwLogicQuest(nCrwCrenel)) then
          if(CrwLogicQuest(nCrwSawTooth))
     1      call FeQuestCrwOff(nCrwSawTooth)
          n=n+1
        else
          n=n-1
        endif
        call FeQuestIntEdwOpen(nEdwModOcc,n,.false.)
        call FeQuestEudOpen(nEdwModOcc,0,mxw,1,0.,0.,0.)
        EventType=EventEdw
        EventNumber=nEdwModOcc
        go to 1500
      else if(CheckType.eq.EventCrw.and.CheckNumber.eq.nCrwSawTooth)
     1  then
        call FeQuestIntFromEdw(nEdwModPos,n)
        if(CrwLogicQuest(nCrwSawTooth)) then
          if(CrwLogicQuest(nCrwCrenel)) call FeQuestCrwOff(nCrwCrenel)
          n=n+1
        else
          n=n-1
        endif
        call FeQuestIntEdwOpen(nEdwModPos,n,.false.)
        call FeQuestEudOpen(nEdwModPos,0,mxw,1,0.,0.,0.)
        EventType=EventEdw
        EventNumber=nEdwModPos
        go to 1500
      else if(CheckType.eq.EventButton.and.CheckNumber.eq.nButtEditMod)
     1  then
        call EM40MolNewBasic(imo,impo,PrvKi,nEdwPrvPar,nCrwPrvPar,
     1                       kmodamn,nEdwModOcc,nCrwCrenel,nCrwSawTooth)
        j=0
        do 1770i=1,6
          if(i.eq.1) then
            if(kmodsm(impo).le.0) go to 1770
          else if(i.eq.2.or.i.eq.3) then
            if(kmodxm(impo).le.0) go to 1770
          else
            if(kmodbm(impo).le.0) go to 1770
          endif
          j=j+1
          menp(j)=men(i)
          Ktera(j)=i
1770    continue
        i=ButtonFr+nButtEditMod-1
        i=FeMenu(ButtonXMax(i),ButtonYMax(i),menp,1,j,1,1)
        if(i.ne.0) i=Ktera(i)
        if(i.eq.1.and.kmodsm(impo).gt.0) then
          call EM40EditModPar(impo,PrvKi,1,axm(1,impo),aym(1,impo),1,i)
        else if(i.eq.2.and.kmodxm(impo).gt.0) then
          call EM40EditModPar(impo,PrvKi,2,utx(1,1,impo),uty(1,1,impo),
     1                        3,i)
        else if(i.eq.3.and.kmodxm(impo).gt.0) then
          call EM40EditModPar(impo,PrvKi,2,urx(1,1,impo),ury(1,1,impo),
     1                        3,i)
        else if(i.eq.4.and.kmodbm(impo).gt.0) then
          call EM40EditModPar(impo,PrvKi,3,ttx(1,1,impo),tty(1,1,impo),
     1                        6,i)
        else if(i.eq.5.and.kmodbm(impo).gt.0) then
          call EM40EditModPar(impo,PrvKi,3,tlx(1,1,impo),tly(1,1,impo),
     1                        6,i)
        else if(i.eq.6.and.kmodbm(impo).gt.0) then
          call EM40EditModPar(impo,PrvKi,3,tsx(1,1,impo),tsy(1,1,impo),
     1                        9,i)
        endif
        call FeQuestButtonOff(nButtEditMod)
        icont=0
        go to 1500
      else if(CheckType.ne.0) then
        call NebylOsetren
        go to 1500
      endif
      go to 1890
1800  imo=0
      impo=0
1810  EventType=EventEdw
      EventNumber=nEdwRef
      call FeQuestButtonOff(CheckNumber)
      go to 1200
1890  Konec=.true.
2000  if(impo.gt.0) then
        call EM40MolNewBasic(imo,impo,PrvKi,nEdwPrvPar,nCrwPrvPar,
     1                       kmodamn,nEdwModOcc,nCrwCrenel,nCrwSawTooth)
      endif
      if(.not.Konec) go to 1200
      call FeQuestRemove(id)
      return
100   format(3f10.6)
      end
      subroutine EM40MolNewBasic(im,imp,PrvKi,nEdwPrvPar,nCrwPrvPar,
     1                           kmodamn,nEdwModOcc,nCrwCrenel,
     2                           nCrwSawTooth)
      include 'params.cmn'
      include 'basic.cmn'
      include 'atoms.cmn'
      include 'molec.cmn'
      include 'fepc.cmn'
      dimension kmodamn(3)
      integer PrvKi,CrwStateQuest
      logical CrwLogicQuest
      if(imp.gt.0) then
        nEdw=nEdwPrvPar
        nCrw=nCrwPrvPar
        kip=PrvKi
        call FeUpdateParamAndKeys(nEdw,nCrw,aimol(imp),Ki(kip),1)
        nEdw=nEdw+1
        nCrw=nCrw+1
        kip=kip+1
        call FeUpdateParamAndKeys(nEdw,nCrw,Euler(1,imp),Ki(kip),3)
        nEdw=nEdw+3
        nCrw=nCrw+3
        kip=kip+3
        call FeUpdateParamAndKeys(nEdw,nCrw,trans(1,imp),Ki(kip),3)
        if(ndimi.gt.0) then
          nEdw=nEdwModOcc
          do 1000i=1,3
            call FeQuestIntFromEdw(nEdw,kmodamn(i))
            nEdw=nEdw+1
1000      continue
          kfso=kfsm(imp)
          if(CrwStateQuest(nCrwCrenel).ne.CrwClosed) then
            if(CrwLogicQuest(nCrwCrenel)) then
              kfsn=1
            else
              kfsn=0
            endif
            kfsm(imp)=min(kfso,kfsn)
          else
            kfsn=kfso
          endif
          kfxo=kfxm(imp)
          if(CrwStateQuest(nCrwSawTooth).ne.CrwClosed) then
            if(CrwLogicQuest(nCrwSawTooth)) then
              kfxn=1
            else
              kfxn=0
            endif
            kfxm(imp)=min(kfxo,kfxn)
          else
            kfxn=kfxo
          endif
          call MolModi(imp,im,kmodamn)
          kfsm(imp)=kfsn
          kfxm(imp)=kfxn
          if(ktls(im).gt.0) then
            kip=kip+24
          else
            kip=kip+3
          endif
          k=kmodsm(imp)-ndimi
          if(k.ge.0) then
            if(kfsn.ne.kfso.and.kfsn.ne.0) then
              if(ndimi.eq.1) then
                pom=0.
              else
                if(a0(imp).gt.0.) then
                  pom=a0m(imp)**(1./float(ndimi))
                else
                  pom=0.
                endif
              endif
              do 1100i=1,ndimi
                k=k+1
                axm(k,imp)=0.
                aym(k,imp)=pom
                j=kip+(k-1)*2+1
                ki(kip)=0
                ki(j    )=0
                ki(j+1  )=0
1100          continue
            endif
          endif
          if(k.gt.0) kip=kip+2*k+1
          i=kmodxm(imp)
          if(i.gt.0) then
            if(kfxn.ne.kfxo.and.kfxn.eq.1) then
              j=kip+(i-1)*6
              call SetRealArrayTo(utx(1,i,imp),3,.001)
              call SetRealArrayTo(uty(1,i,imp),3,0.)
              uty(2,i,imp)=1.
              call SetIntArrayTo(ki(j),6,0)
              j=j+i*6
              call SetRealArrayTo(urx(1,i,imp),3,0.)
              call SetRealArrayTo(ury(1,i,imp),3,0.)
              call SetIntArrayTo(ki(j),6,0)
            endif
          endif
        endif
      endif
      return
      end
      subroutine EM40EditTLS(imp)
      include 'params.cmn'
      include 'basic.cmn'
      include 'atoms.cmn'
      include 'molec.cmn'
      include 'fepc.cmn'
      dimension tpoma(3),xpoma(3)
      character*12 at,pn
      integer PrvKi
      logical lpom
      xdq=230.
      il=8
      tpoma(1)=8.
      pom=(xdq-3.*37.-10.)/3.
      pom=(xdq-5.-37.-pom)/2.
      do 1010i=2,3
        tpoma(i)=tpoma(i-1)+pom
1010  continue
      xpoma(3)=xdq-42.-CrwXd
      do 1020i=2,1,-1
        xpoma(i)=xpoma(i+1)-pom
1020  continue
      id=NextQuestId()
      call FeQuestCreate(id,-1.,-1.,xdq,0,il,'Edit TLS tensors',0,
     1                   LightGray,0,OKForBasicFiles)
      il=1
      j=1
      PrvKi=PrvniKiMolekuly(imp)+7
      kip=PrvKi
      do 1100i=1,21
        call kdoco(kip,at,pn,1,pom,spom)
        call FeMakeParEdwCrw(id,tpoma(j),xpoma(j),il,pn,pom,ki(kip),
     1                       .false.,nEdw,nCrw)
        if(i.eq.1) then
          nEdwPrv=nEdw
          nCrwPrv=nCrw
        endif
        if(mod(j,3).eq.0) then
          j=1
          il=il+1
        else
          j=j+1
        endif
        kip=kip+1
1100  continue
      dpom=50.
      pom=10.
      xpom=(xdq-3.*dpom-2.*pom)*.5
      do 1300i=1,3
        if(i.eq.1) then
          at='%Refine all'
        else if(i.eq.2) then
          at='%Fix all'
        else if(i.eq.3) then
          at='Re%set'
        endif
        call FeQuestButtonMake(id,xpom,il,50.,ButYd,at)
        if(i.eq.1) then
          nButtRefineAll=ButtonLastMade
        else if(i.eq.2) then
          nButtFixAll=ButtonLastMade
        else if(i.eq.3) then
          nButtReset=ButtonLastMade
        endif
        call FeQuestButtonOpen(ButtonLastMade,ButtonOff)
        xpom=xpom+dpom+pom
1300  continue
1450  icont=0
1500  call FeQuestEvent(id,icont,ich)
      icont=1
      if(CheckType.eq.EventButton.and.
     1        (CheckNumber.eq.nButtRefineAll.or.
     2         CheckNumber.eq.nButtFixAll)) then
        if(CheckNumber.eq.nButtRefineAll) then
          lpom=.true.
        else
          lpom=.false.
        endif
        nCrw=nCrwPrv
        kip=PrvKi
        do 2200i=1,21
          call FeQuestCrwOpen(nCrw,lpom)
          nCrw=nCrw+1
          kip=kip+1
2200    continue
        call FeQuestButtonoff(CheckNumber)
        go to 1450
      else if(CheckType.eq.EventButton.and.CheckNumber.eq.nButtReset)
     1  then
        nEdw=nEdwPrv
        pom=.001
        do 2300i=1,21
          if(i.eq.4) pom=0.
          call FeQuestRealEdwOpen(nEdw,pom,.false.,.false.)
          nEdw=nEdw+1
2300    continue
        call FeQuestButtonoff(CheckNumber)
        go to 1450
      else if(CheckType.ne.0) then
        call NebylOsetren
        go to 1500
      endif
      if(ich.eq.0) then
        nEdw=nEdwPrv
        nCrw=nCrwPrv
        kip=PrvKi
        call FeUpdateParamAndKeys(nEdw,nCrw,tT(1,imp),Ki(kip),6)
        nEdw=nEdw+6
        nCrw=nCrw+6
        kip=kip+6
        call FeUpdateParamAndKeys(nEdw,nCrw,tL(1,imp),Ki(kip),6)
        nEdw=nEdw+6
        nCrw=nCrw+6
        kip=kip+6
        call FeUpdateParamAndKeys(nEdw,nCrw,tS(1,imp),Ki(kip),9)
      endif
      call FeQuestRemove(id)
      return
      end
      subroutine EM40DefPGSyst(imol,ich)
      include 'params.cmn'
      include 'basic.cmn'
      include 'molec.cmn'
      include 'fepc.cmn'
      character*256 EdwStringQuest
      character*80 Veta,ErrSt
      character*27 LocPGSystStO(2)
      character*2 LocPGSystAxO
      integer FeMenu
      logical CrwLogicQuest
      dimension nEdwSystAx(2),nEdwSystSt(2),nDownSystAx(2),px(3)
      do 1000j=1,2
        LocPGSystAxO(j:j)=LocPGSystAx(imol)(j:j)
        LocPGSystStO(j)=LocPGSystSt(j,imol)
1000  continue
      id=NextQuestId()
      xdq=200.
      xdqp=xdq*.5
      il=2
      call FeQuestCreate(id,-1.,-1.,xdq,0,il,'Define PG coordinate'//
     1                   ' system',0,LightGray,0,OKForBasicFiles)
      il=1
      Veta='%Use local system'
      tpom=5.
      xpom=tpom+FeTxLengthUnder(Veta)+3.
      call FeQuestCrwMake(id,tpom,il,xpom,il,Veta,'L',CrwXd,CrwYd,1,0)
      nCrwLocSyst=CrwLastMade
      call FeQuestCrwOpen(CrwLastMade,UsePGSyst(imol))
      xpom=xpom+CrwXd+15.
      dpom=12.
      xp=FeXPixRound(xpom)+FeXPixRound(dpom)+5.*PixelX
      xpp=xp+EdwYd+5.
      dpp=xdq-xpp-5.
      do 1100j=1,2
        call FeQuestEdwMake(id,tpom,il,xpom,il,' ','L',dpom,EdwYd,0)
        nEdwSystAx(j)=EdwLastMade
        call FeQuestUpDownMake(id,xp,il,UpDownXd,UpDownYd,'down')
        nDownSystAx(j)=UpDownLastMade
        call FeQuestEdwMake(id,tpom,il,xpp,il,' ','L',dpp,EdwYd,1)
        nEdwSystSt(j)=EdwLastMade
        il=il+1
1100  continue
1400  if(UsePGSyst(imol)) then
        do 1410i=1,2
          call FeQuestStringEdwOpen(nEdwSystAx(i),
     1                              LocPGSystAx(imol)(i:i))
          call FeQuestUpDownOpen(nDownSystAx(i),UpDownOff)
          Veta=LocPGSystSt(i,imol)
          if(Veta(1:1).eq.' ') Veta=Veta(2:)
          k=0
          call StToReal(Veta,k,px,3,.false.,ich)
          if(ich.eq.0) then
            write(Veta,'(3f12.6)') px
            call ZdrcniCisla(Veta,3)
          endif
          call FeQuestStringEdwOpen(nEdwSystSt(i),Veta)
1410    continue
      else
        do 1420i=1,2
          call FeQuestEdwClose(nEdwSystAx(i))
          call FeQuestUpDownClose(nDownSystAx(i))
          call FeQuestEdwClose(nEdwSystSt(i))
1420    continue
      endif
      icont=0
1500  call FeQuestEvent(id,icont,ich)
      icont=1
      if(CheckType.eq.EventCrw.and.CheckNumber.eq.nCrwLocSyst) then
        UsePGSyst(imol)=CrwLogicQuest(nCrwLocSyst)
        go to 1400
      else if(CheckType.eq.EventUpDown.and.
     1        (CheckNumber.eq.nDownSystAx(1).or.
     2         CheckNumber.eq.nDownSystAx(2))) then
        if(CheckNumber.eq.nDownSystAx(1)) then
          j=1
        else
          j=2
        endif
        i=nEdwSystAx(j)
        k=FeMenu(EdwXminQuest(i),EdwYmaxQuest(i)-3.*MenuLineWidth,Smbx,
     1           1,3,1,1)
        if(k.ge.1.and.k.le.3) then
          call FeQuestStringEdwOpen(i,Smbx(k))
          LocPGSystAx(imol)(j:j)=Smbx(k)
        endif
        EventType=EventEdw
        EventNumber=i
        call FeQuestUpDownOpen(CheckNumber,UpDownOff)
        go to 1500
      else if(CheckType.eq.EventEdw.and.
     1        (CheckNumber.eq.nEdwSystSt(1).or.
     2         CheckNumber.eq.nEdwSystSt(2))) then
        Veta=EdwStringQuest(CheckNumber)
        call CrlGetXFromAtString(Veta,imol,px,ErrSt,ich)
        if(ich.gt.0) then
          call FeChybne(-1.,-1.,'in the definition of local '//
     1                  'coordinate system',ErrSt,0,SeriousError)
          EventType=EventEdw
          EventNumber=i
        else
          ich=0
        endif
        go to 1500
      else if(CheckType.ne.0) then
        call NebylOsetren
        go to 1500
      endif
      if(ich.eq.0) then
        if(UsePGSyst(imol)) then
          do 2000i=1,2
            LocPGSystAx(imol)(i:i)=
     1        EdwStringQuest(nEdwSystAx(i))
            Veta=EdwStringQuest(nEdwSystSt(i))
            if(Veta(1:1).ne.'-') Veta=' '//Veta(:idel(Veta))
            LocPGSystSt(i,imol)=Veta
2000      continue
        endif
      endif
      call FeQuestRemove(id)
      if(ich.ne.0) then
        do 2400j=1,2
          LocPGSystAx(imol)(j:j)=LocPGSystAxO(j:j)
          LocPGSystSt(j,imol)=LocPGSystStO(j)
2400    continue
      endif
9999  return
      end
      subroutine EM40DefMolLocSyst(imp,ich)
      include 'params.cmn'
      include 'basic.cmn'
      include 'molec.cmn'
      include 'fepc.cmn'
      character*256 EdwStringQuest
      character*80 Veta,ErrSt
      character*27 LocMolSystStO(2,2)
      character*2 LocMolSystAxO(2)
      integer FeMenu,CrwStateQuest
      logical CrwLogicQuest
      dimension nEdwModelSystAx(2),nEdwActualSystAx(2),
     1          nEdwModelSystSt(2),nEdwActualSystSt(2),
     2          nDownModelSystAx(2),nDownActualSystAx(2),px(3)
      LocMolSystTypeO=LocMolSystType(imp)
      do 1010i=1,2
        do 1000j=1,2
          LocMolSystAxO(i)(j:j)=LocMolSystAx(i,imp)(j:j)
          LocMolSystStO(j,i)=LocMolSystSt(j,i,imp)
1000    continue
1010  continue
      id=NextQuestId()
      xdq=200.
      xdqp=xdq*.5
      il=6
      call FeQuestCreate(id,-1.,-1.,xdq,0,il,'Define local coordinate'//
     1                   ' system',0,LightGray,0,OKForBasicFiles)
      il=0
      do 1200i=1,2
        il=il+1
        if(i.eq.1) then
          Veta='%Model  molecule'
        else
          Veta='%Actual molecule'
        endif
        tpom=5.
        xpom=tpom+FeTxLengthUnder(Veta)+3.
        call FeQuestCrwMake(id,tpom,il,xpom,il,Veta,'L',CrwXd,CrwYd,1,0)
        if(i.eq.1) then
          nCrwLocForModel=CrwLastMade
          call FeQuestCrwOpen(CrwLastMade,LocMolSystType(imp).gt.0)
        else
          nCrwLocForActual=CrwLastMade
        endif
        xpom=xpom+CrwXd+15.
        dpom=12.
        xp=FeXPixRound(xpom)+FeXPixRound(dpom)+5.*PixelX
        xpp=xp+EdwYd+5.
        dpp=xdq-xpp-5.
        do 1100j=1,2
          call FeQuestEdwMake(id,tpom,il,xpom,il,' ','L',dpom,EdwYd,0)
          if(i.eq.1) then
            nEdwModelSystAx(j)=EdwLastMade
          else
            nEdwActualSystAx(j)=EdwLastMade
          endif
          call FeQuestUpDownMake(id,xp,il,UpDownXd,UpDownYd,'down')
          if(i.eq.1) then
            nDownModelSystAx(j)=UpDownLastMade
          else
            nDownActualSystAx(j)=UpDownLastMade
          endif
          call FeQuestEdwMake(id,tpom,il,xpp,il,' ','L',dpp,EdwYd,1)
          if(i.eq.1) then
            nEdwModelSystSt(j)=EdwLastMade
          else
            nEdwActualSystSt(j)=EdwLastMade
          endif
          il=il+1
1100    continue
1200  continue
1400  if(LocMolSystType(imp).gt.0) then
        if(CrwStateQuest(nCrwLocForActual).eq.CrwClosed) then
          call FeQuestCrwOpen(nCrwLocForActual,LocMolSystType(imp).gt.1)
          do 1410i=1,2
            call FeQuestStringEdwOpen(nEdwModelSystAx(i),
     1                                LocMolSystAx(1,imp)(i:i))
            call FeQuestUpDownOpen(nDownModelSystAx(i),UpDownOff)
            Veta=LocMolSystSt(i,1,imp)
            if(Veta(1:1).eq.' ') Veta=Veta(2:)
            k=0
            call StToReal(Veta,k,px,3,.false.,ich)
            if(ich.eq.0) then
              write(Veta,'(3f12.6)') px
              call ZdrcniCisla(Veta,3)
            endif
            call FeQuestStringEdwOpen(nEdwModelSystSt(i),Veta)
1410      continue
        endif
      else
        call FeQuestCrwClose(nCrwLocForActual)
        do 1420i=1,2
          call FeQuestEdwClose(nEdwModelSystAx(i))
          call FeQuestUpDownClose(nDownModelSystAx(i))
          call FeQuestEdwClose(nEdwModelSystSt(i))
1420    continue
      endif
      if(LocMolSystType(imp).gt.1) then
        do 1430i=1,2
          call FeQuestStringEdwOpen(nEdwActualSystAx(i),
     1                              LocMolSystAx(2,imp)(i:i))
          call FeQuestUpDownOpen(nDownActualSystAx(i),UpDownOff)
          Veta=LocMolSystSt(i,2,imp)
          if(Veta(1:1).eq.' ') Veta=Veta(2:)
          k=0
          call StToReal(Veta,k,px,3,.false.,ich)
          if(ich.eq.0) then
            write(Veta,'(3f12.6)') px
            call ZdrcniCisla(Veta,3)
          endif
          call FeQuestStringEdwOpen(nEdwActualSystSt(i),Veta)
1430    continue
      else
        do 1440i=1,2
          call FeQuestEdwClose(nEdwActualSystAx(i))
          call FeQuestUpDownClose(nDownActualSystAx(i))
          call FeQuestEdwClose(nEdwActualSystSt(i))
1440    continue
      endif
      icont=0
1500  call FeQuestEvent(id,icont,ich)
      icont=1
      if(CheckType.eq.EventCrw.and.CheckNumber.eq.nCrwLocForModel) then
        if(CrwLogicQuest(nCrwLocForModel)) then
          LocMolSystType(imp)=max(LocMolSystType(imp),1)
        else
          LocMolSystType(imp)=min(LocMolSystType(imp),0)
        endif
        go to 1400
      else if(CheckType.eq.EventCrw.and.
     1        CheckNumber.eq.nCrwLocForActual) then
        if(CrwLogicQuest(nCrwLocForActual)) then
          LocMolSystType(imp)=2
        else
          LocMolSystType(imp)=1
        endif
        go to 1400
      else if(CheckType.eq.EventUpDown.and.
     1        (CheckNumber.eq.nDownModelSystAx(1).or.
     2         CheckNumber.eq.nDownModelSystAx(2))) then
        if(CheckNumber.eq.nDownModelSystAx(1)) then
          j=1
        else
          j=2
        endif
        i=nEdwModelSystAx(j)
        k=FeMenu(EdwXminQuest(i),EdwYmaxQuest(i)-3.*MenuLineWidth,Smbx,
     1           1,3,1,1)
        if(k.ge.1.and.k.le.3) then
          call FeQuestStringEdwOpen(i,Smbx(k))
          LocMolSystAx(1,imp)(j:j)=Smbx(k)
        endif
        EventType=EventEdw
        EventNumber=i
        call FeQuestUpDownOpen(CheckNumber,UpDownOff)
        go to 1500
      else if(CheckType.eq.EventUpDown.and.
     1        (CheckNumber.eq.nDownActualSystAx(1).or.
     2         CheckNumber.eq.nDownActualSystAx(2))) then
        if(CheckNumber.eq.nDownActualSystAx(1)) then
          j=1
        else
          j=2
        endif
        i=nEdwActualSystAx(j)
        k=FeMenu(EdwXminQuest(i),EdwYmaxQuest(i)-3.*MenuLineWidth,Smbx,
     1           1,3,1,1)
        if(k.ge.1.and.k.le.3) then
          call FeQuestStringEdwOpen(i,Smbx(k))
          LocMolSystAx(2,imp)(j:j)=Smbx(k)
        endif
        EventType=EventEdw
        EventNumber=i
        call FeQuestUpDownOpen(CheckNumber,UpDownOff)
        go to 1500
      else if(CheckType.eq.EventEdw.and.
     1        (CheckNumber.eq.nEdwModelSystSt(1).or.
     2         CheckNumber.eq.nEdwModelSystSt(2).or.
     1         CheckNumber.eq.nEdwActualSystSt(1).or.
     2         CheckNumber.eq.nEdwActualSystSt(2))) then
        if(CheckNumber.eq.nEdwModelSystSt(1).or.
     1     CheckNumber.eq.nEdwModelSystSt(2)) then
          imol=(imp-1)/mxp+1
        else
          imol=0
        endif
        Veta=EdwStringQuest(CheckNumber)
        call CrlGetXFromAtString(Veta,imol,px,ErrSt,ich)
        if(ich.gt.0) then
          call FeChybne(-1.,-1.,'in the definition of local '//
     1                  'coordinate system',ErrSt,0,SeriousError)
          EventType=EventEdw
          EventNumber=CheckNumber
        else
c          call FeQuestStringEdwOpen(i,Veta)
          ich=0
        endif
        go to 1500
      else if(CheckType.ne.0) then
        call NebylOsetren
        go to 1500
      endif
      if(ich.eq.0) then
        if(LocMolSystType(imp).gt.0) then
          do 2000i=1,2
            LocMolSystAx(1,imp)(i:i)=
     1        EdwStringQuest(nEdwModelSystAx(i))
            Veta=EdwStringQuest(nEdwModelSystSt(i))
            if(Veta(1:1).ne.'-') Veta=' '//Veta(:idel(Veta))
            LocMolSystSt(i,1,imp)=Veta
2000      continue
        endif
        if(LocMolSystType(imp).gt.1) then
          do 2100i=1,2
            LocMolSystAx(2,imp)(i:i)=
     1        EdwStringQuest(nEdwActualSystAx(i))
            Veta=EdwStringQuest(nEdwActualSystSt(i))
            if(Veta(1:1).ne.'-') Veta=' '//Veta(:idel(Veta))
            LocMolSystSt(i,2,imp)=Veta
2100      continue
        endif
      endif
      call FeQuestRemove(id)
      if(ich.ne.0) then
        LocMolSystType(imp)=LocMolSystTypeO
        do 2500i=1,2
          do 2400j=1,2
            LocMolSystAx(i,imp)(j:j)=LocMolSystAxO(i)(j:j)
            LocMolSystSt(j,i,imp)=LocMolSystStO(j,i)
2400      continue
2500    continue
      endif
9999  return
      end
