      subroutine EditM50
      include 'params.cmn'
      include 'basic.cmn'
      include 'fepc.cmn'
      include 'editm50.cmn'
      include 'atoms.cmn'
      include 'molec.cmn'
      include 'datred.cmn'
      include 'powder.cmn'
      logical eqrv,ExistFile,FeYesNo,M50JesteNeexistovala,FeYesNoHeader
      external EM50UpdateListek
      dimension rm6o(36,mxsym),s6o(6,mxsym),vt6o(6,mxsym),rmo(36),
     1          ExtRefGroupO(36,500),ExtRefCondO(7,500)
      data pgraf/6.7079/
      M50JesteNeexistovala=.not.ExistM50
      ndimio=ndimi
      KPhaseIn=KPhase
      nso=ns
      nvto=nvt
      ncso=ncs
      call CrlGetReflectionConditions
      NExtRefCondO=NExtRefCond
      do 1010i=1,nvt
        call CopyVek(vt6(1,i,1,KPhase),vt6o(1,i),ndim)
1010  continue
      do 1020i=1,ns
        call CopyMat(rm6(1,i,1,KPhase),rm6o(1,i),ndim)
        call CopyVek(s6(1,i,1,KPhase),s6o(1,i),ndim)
1020  continue
      do 1030i=1,NExtRefCond
        call CopyMat(ExtRefGroup(1,i),ExtRefGroupO(1,i),ndim)
        call CopyVek(ExtRefCond(1,i),ExtRefCondo(1,i),ndim+1)
1030  continue
      if(ExistM94) call iom94(0)
      if(StatusM50.ge.100.and.ExistM94.and.KPhase.eq.1) then
        if(StatusM50.ge.1000) then
          if(StatusM50.ge.10000) then
            nlam=1
            if(DifCode.ne.IdNoName.and.DifCode.ne.IdD9ILL.and.
     1         DifCode.ne.IdHasyLabF1) then
              uhmon(1)=asin(LamAve(1)/pgraf)/torad
            else
              uhmon(1)=0.
            endif
            call CopyVek(CellDatRed(1,3),CellPar(1,1,KPhase),6)
            StatusM50=StatusM50-10000
            do 1100i=1,ndimi
              call CopyVek(QuDatRed(1,i,3),Qu(1,i,1,KPhase),3)
              call CopyVek(QuDatRed(1,i,3),Qui(1,i,KPhase),3)
              call SetRealArrayTo(Quir(1,i,KPhase),3,0.)
1100        continue
          endif
          if(Grupa.ne.' '.and.index(Grupa,'?').le.0) then
            call EM50GenSym(RunForFirstTimeYes,MakeCellTestNo,
     1                      AskForDeltaNo,ich)
            StatusM50=StatusM50-1000
          else
            ns=1
            nvt=1
            call UnitMat(rm6(1,1,1,KPhase),ndim)
            call SetRealArrayTo(s6(1,1,1,KPhase),ndim,0.)
            call SetRealArrayTo(vt6(1,1,1,KPhase),ndim,0.)
            call CodeSym(rm6(1,1,1,KPhase),s6(1,1,1,KPhase),
     1                   symmc(1,1,1,KPhase),0)
            Grupa='???'
            call FindSmbSg(Grupa,.true.,1)
          endif
        endif
        call iom50(1,0)
      endif
      if(StatusM50.lt.11100) then
        call iom50(0,0)
        call RestorePhase(KPhaseIn)
      endif
      xdq=270.
      call FeKartCreate(-1.,-1.,xdq,13,'Edit M50 file',0,
     1                  OKForBasicFiles)
      xdqp=xdq-2.*KartSidePruh
      call FeCreateListek('Cell',1)
      KartIdCell=KartLastId
      call EM50CellMake(KartIdCell)
      call FeCreateListek('Symmetry',1)
      KartIdSymmetry=KartLastId
      call EM50SymmetryMake(KartIdSymmetry)
      call EM50SymmetryRefresh
      call FeCreateListek('Radiation',1)
      KartIdRadiation=KartLastId
      call EM50RadiationMake(KartIdRadiation)
      call EM50RadiationRefresh
      call FeCreateListek('Atom form factors',1)
      KartIdFormFactors=KartLastId
      call EM50FormFactorsMake(KartIdFormFactors)
      call EM50FormFactorsRefresh(1)
      call FeCompleteKart(1)
2000  icontEM50=0
2500  ErrJana=0
3000  call FeQuestEventWithKartUpdate(KartId,icontEM50,ich,
     1                                EM50UpdateListek)
      icontEM50=1
      if(CheckType.eq.EventButton.and.CheckNumberAbs.eq.ButtonOk) then
        call FeButtonOff(ButtonOk)
        if(ncomp.gt.ncompold) then
          call FeChybne(-1.,-1.,'new composite matrices were not yet'//
     1                  ' defined',' ',0,SeriousError)
          call FePrepniListek(KartIdCell-1)
          EventType=EventButton
          EventNumber=nButtCompMat
          go to 3000
        endif
        if(itwin.gt.itwinold) then
          call FeChybne(-1.,-1.,'new twinning matrices were not yet'//
     1                  ' defined',' ',0,SeriousError)
          call FePrepniListek(KartIdCell-1)
          EventType=EventButton
          EventNumber=nButtTwMat
          go to 3000
        endif
        if(KartId.eq.KartIdCell) then
          call EM50CellUpdate(ich)
          if(ich.ne.0) go to 3000
        else if(KartId.eq.KartIdSymmetry) then
          call EM50SymmetryComplete
        else if(KartId.eq.KartIdRadiation) then
          call EM50RadiationUpDate
        endif
        do 3100i=1,ns
          call trmat(rm6(1,i,1,KPhase),rmp,ndim,ndim)
          call multm(rm6(1,i,1,KPhase),MetTens6(1,KPhase),gpp,ndim,ndim,
     1               ndim)
          call multm(gpp,rmp,gps,ndim,ndim,ndim)
          if(.not.eqrv(MetTens6(1,KPhase),gps,ndimq,1.0e-7)) then
            call FeChybne(-1.,-1.,'Cell parameters and/or modulation '//
     1                    'vectors are not','consistent with symmetry'//
     2                    ', please make corrections',0,SeriousError)
            EventType=EventKartSw
            EventNumber=KartIdCell+1-KartFirstId
            go to 3000
          endif
3100    continue
        do 3200i=KartFirstId,NKart+KartFirstId-1
          QuestCheck(i)=0
3200    continue
        go to 3000
      else if(CheckType.eq.EventKartSw) then
        if(KartId.eq.KartIdCell) then
          call EM50CellCheck
          call EM50CellUpdate(ich)
          if(ich.ne.0) QuestCheck(KartId)=1
        else if(KartId.eq.KartIdSymmetry) then
          call EM50SymmetryComplete
        else if(KartId.eq.KartIdRadiation) then
          call EM50RadiationUpDate
        else if(KartId.eq.KartIdFormFactors) then
          call EM50FormFactorsUpDate
        endif
        go to 3000
      else if(CheckType.ne.0) then
        if(KartId.eq.KartIdCell) then
          call EM50CellCheck
        else if(KartId.eq.KartIdSymmetry) then
          call EM50SymmetryCheck
          if(ErrJana.eq.0) then
            call EM50SymmetryRefresh
          else
            icontEM50=1
            go to 2500
          endif
        else if(KartId.eq.KartIdRadiation) then
          call EM50RadiationCheck
        else if(KartId.eq.KartIdFormFactors) then
          call EM50FormFactorsCheck
        endif
        go to 3000
      endif
      if(ich.eq.0) then
        call EM50FormFactorsUpDate
        call SavePhase
        call QuestionRewriteFile(50)
        call iom50(0,0)
        if(ExistM94) call iom94(1)
        call RestorePhase(KPhaseIn)
        if(isPowder.and.ExistFile(fln(:ifln)//'.m41')) then
          call CopyVek(CellPar(1,1,KPhase),CellPwd(1,KPhase),6)
          call CopyVek(Qu(1,1,1,KPhase),QuPwd(1,1,KPhase),3*ndimi)
        endif
        if(.not.ExistM40) call SetBasicM40(.false.)
        if(ndimi.ne.ndimio.or.m50JesteNeexistovala) then
          if(ndimi.gt.0) then
            do 4010i=1,mxw
              call SetIntArrayTo(kw(1,i,KPhase),3,0)
              if(i.le.ndimi.or.ndimi.eq.1)
     1          kw(mod(i-1,ndimi)+1,i,KPhase)=(i-1)/ndimi+1
4010        continue
          else
            call SetIntArrayTo(kmoda,14*mxa,0)
            call SetIntArrayTo(kfa,14*mxa,0)
            call SetIntArrayTo(kmodam,3*mxpm,0)
            call SetIntArrayTo(kfam,3*mxpm,0)
            ncomp=1
            na(2)=0
            na(3)=0
            nmol(2)=0
            nmol(3)=0
          endif
        endif
        if(itwinin.ne.itwin) then
          j=mxscutw-itwinin+2
          call SetRealArrayTo(sc(j),itwinin-1,0.)
          call SetIntArrayTo(ki(j),itwinin-1,0)
          pom=1./float(itwin)
          call SetRealArrayTo(sctw,itwin,pom)
        endif
        call iom40(1,0)
      else
        call iom50(0,0)
      endif
      call FeDestroyKart
      call RestorePhase(KPhaseBasic)
      if(StatusM50.le.100.and.ich.eq.0.and.
     1   (.not.ExistM91.and.ExistM95)) then
        if(FeYesNo(-1.,-1.,'Do you want to create refinement '//
     1             'reflection file (m91)?',1)) call ExportM91
        go to 9999
      endif
      if(isPowder.or..not.ExistM95.or.ich.ne.0) go to 9999
      if(nvto.ne.nvt) go to 5000
      if(nso.ne.ns) then
        if(nso.eq.2*ns) then
          if(ncso.ne.2.or.ncs.ne.1) go to 5000
        else if(ns.eq.2*nso) then
          if(ncs.ne.2.or.ncso.ne.1) go to 5000
        else
          go to 5000
        endif
      else
        if(ncso.ne.ncs) go to 5000
      endif
      do 4500i=1,ns
        call CopyMat(rm6(1,i,1,KPhase),rmp,ndim)
        do 4450icntsm=1,3-ncs
          if(icntsm.eq.2) call RealMatrixToOpposite(rmp,rmp,ndim)
          do 4400j=1,nso
            call CopyMat(rm6o(1,j),rmo,ndim)
            do 4350jcntsm=1,3-ncso
              if(jcntsm.eq.2) call RealMatrixToOpposite(rmo,rmo,ndim)
              if(eqrv(rmp,rmo,ndimq,.0001)) go to 4450
4350        continue
4400      continue
          go to 5000
4450    continue
4500  continue
      call CrlGetReflectionConditions
      if(NExtRefCond.ne.NExtRefCondO) go to 5000
      do 4600i=1,NExtRefCond
        do 4550j=1,NExtRefCondO
          if(eqrv(ExtRefGroup(1,i),ExtRefGroupO(1,j),ndimq,.0001).and.
     1       eqrv(ExtRefCond (1,i),ExtRefCondO (1,j),ndim+1,.0001))
     2      go to 4600
4550    continue
        go to 5000
4600  continue
      go to 9999
5000  NInfo=2
      TextInfo(1)='The program has detected a change of the symmetry '//
     1            'which call for'
      TextInfo(2)='re-creation of the reflection file.'
      if(FeYesNoHeader(-1.,-1.,'Do you want to re-create refinement '//
     1                 'reflection file just now?',1)) call ExportM91
9999  return
      end
      subroutine EM50Cell
      include 'params.cmn'
      include 'basic.cmn'
      include 'fepc.cmn'
      include 'editm50.cmn'
      dimension tzero(3),rm6p(36),pp(6),pq(3),mpp(3)
      character*256 EdwStringQuest
      character*80 Veta
      character*2 nty
      integer EdwStateQuest,CrwStateQuest,ButtonStateQuest,EdwIntQuest
      logical CrwLogicQuest,AlreadyAppled
      save nCrwTwin,nEdwTwin,nEdwDim,nEdwComp,nCrwCommen,nButtShowSG,
     1     nButtSelectSG,nButtOriginSG,nEdw,ndims
      data AlreadyAppled/.true./
      entry EM50CellMake(id)
      xqd=(QuestXMax(id)-QuestXMin(id))
      ncompold=ncomp
      itwinold=itwin
      itwinin=itwin
      il=1
      call FeQuestEdwMake(id,5.,il,65.,il,'%Title','L',xqd-70.,EdwYd,0)
      nEdwName=EdwLastMade
      call FeQuestStringEdwOpen(nEdwName,Name)
      if(NPhase.gt.1) then
        il=il+1
        call FeQuestEdwMake(id,5.,il,65.,il,'P%hase label','L',40.,
     1                      EdwYd,0)
        nEdwPhase=EdwLastMade
        call FeQuestStringEdwOpen(nEdwPhase,PhaseName(KPhase))
      else
        nEdwPhase=0
      endif
      il=il+1
      call FeQuestEdwMake(id,5.,il,65.,il,'Cell %parameters','L',
     1                    xqd-70.,EdwYd,0)
      nEdwCell=EdwLastMade
      call FeQuestRealAEdwOpen(nEdwCell,CellPar(1,1,KPhase),6,
     1                         StatusM50.ge.10000,.false.)
      il=il+1
      call FeQuestEdwMake(id,5.,il,65.,il,'%E.s.d.''s','L',xqd-70.,
     1                    EdwYd,0)
      nEdwEsd=EdwLastMade
      call FeQuestRealAEdwOpen(nEdwEsd,CellParSU(1,1,KPhase),6,
     1                         StatusM50.ge.10000,.false.)
      if(.not.IsPowder) then
        il=il+1
        call FeQuestCrwMake(id,5.,il,65.,il,'T%winning','L',CrwXd,CrwYd,
     1                      1,0)
        nCrwTwin=CrwLastMade
        call FeQuestCrwOpen(nCrwTwin,itwin.gt.1)
      else
        nCrwTwin=0
      endif
      Veta='#%composite parts'
      tpom=95.+EdwYd
      xpom=tpom+FeTxLengthUnder(Veta)+5.+EdwYd
      if(.not.IsPowder) then
        call FeQuestEudMake(id,tpom,il,xpom,il,'#tw%in domains','L',15.,
     1                      EdwYd,1)
        nEdwTwin=EdwLastMade
      else
        nEdwTwin=0
      endif
      il=il+1
      call FeQuestEudMake(id,tpom,il,xpom,il,Veta,'L',15.,EdwYd,1)
      nEdwComp=EdwLastMade
      tpom=xpom+20.+2.*EdwYd
      xpom=xqd-5.-tpom
      if(.not.IsPowder) then
        call FeQuestButtonMake(id,tpom,il-1,xpom,ButYd,'%Matrices')
        nButtTwMat=ButtonLastMade
      else
        nButtTwMat=0
      endif
      call FeQuestButtonMake(id,tpom,il,xpom,ButYd,'M%atrices')
      nButtCompMat=ButtonLastMade
      if(itwin.gt.1) then
        call FeQuestIntEdwOpen(nEdwTwin,itwin,.false.)
        call FeQuestEudOpen(nEdwTwin,1,mxscutw,1,0.,0.,0.)
        call FeQuestButtonOpen(nButtTwMat,ButtonOff)
      endif
      if(ndim.gt.3) then
        call FeQuestIntEdwOpen(nEdwComp,ncomp,.false.)
        call FeQuestEudOpen(nEdwComp,1,3,1,0.,0.,0.)
        if(ncomp.gt.1) call FeQuestButtonOpen(nButtCompMat,ButtonOff)
      endif
      if(isPowder.or.(.not.ExistM91.and..not.ExistM95)) then
        call FeQuestEudMake(id,5.,il,65.,il,'%Dimension','L',15.,EdwYd,
     1                      1)
        nEdwDim=EdwLastMade
        call FeQuestIntEdwOpen(nEdwDim,ndim,.false.)
        call FeQuestEudOpen(nEdwDim,3,6,1,0.,0.,0.)
      else
        nEdwDim=0
        write(Veta,'(i1)') ndim
        Veta='Dimension = '//Veta(1:1)
        call FeQuestLabelMake(id,5.,il,Veta,'L')
      endif
      do 1000i=1,3
        il=il+1
        write(Veta,'(''%'',i1,a2,'' modulation vector'')') i,nty(i)
        call FeQuestEdwMake(id,5.,il,100.,il,Veta,'L',xqd-105.,EdwYd,0)
        if(i.eq.1) nEdwModVek=EdwLastMade
        if(i.le.ndimi)
     1    call FeQuestRealAEdwOpen(nEdwModVek+i-1,qu(1,i,1,KPhase),3,
     2                             StatusM50.ge.10000,.true.)
1000  continue
      il=il+1
      tpom=5.
      Veta='Commens%urate case'
      xpom=tpom+FeTxLengthUnder(Veta)+3.
      call FeQuestCrwMake(id,tpom,il,xpom,il,Veta,'L',CrwXd,CrwYd,1,0)
      nCrwCommen=CrwLastMade
      if(ndimi.gt.0) call FeQuestCrwOpen(nCrwCommen,kcommen.ne.0)
      tpom=xpom+CrwXd+8.
      Veta='%Supercell'
      xpom=tpom+FeTxLengthUnder(Veta)+3.
      dpom=55.
      call FeQuestEdwMake(id,tpom,il,xpom,il,Veta,'L',dpom,EdwYd,0)
      nEdwSupCell=EdwLastMade
      il=il+1
      call FeQuestEdwMake(id,tpom,il,xpom,il,'T%zero','L',dpom,EdwYd,0)
      nEdwTzero=EdwLastMade
      il=il-1
      Veta='Show supercell %group'
      tpom=(xdqp+xpom+dpom)*.5
      xpom=FeTxLengthUnder(Veta)+10.
      tpom=tpom-xpom*.5
      call FeQuestButtonMake(id,tpom,il,xpom,ButYd,Veta)
      nButtShowSG=ButtonLastMade
      il=il+1
      Veta='Se%lect supercell group'
      call FeQuestButtonMake(id,tpom,il,xpom,ButYd,Veta)
      nButtSelectSG=ButtonLastMade
      il=il+1
      Veta='Select its %origin'
      call FeQuestButtonMake(id,tpom,il,xpom,ButYd,Veta)
      nButtOriginSG=ButtonLastMade
      if(kcommen.ne.0) then
        call FeQuestIntAEdwOpen(nEdwSupCell,ncommen(1,1,KPhase),3,
     1                          .false.)
        call FeQuestRealAEdwOpen(nEdwTzero,trez(1,1,KPhase),ndimi,
     1                           .false.,.true.)
        if(ns.gt.0) then
          i=ButtonOff
        else
          i=ButtonDisabled
        endif
        call FeQuestButtonOpen(nButtShowSG,i)
        if(ndimi.lt.2) then
          call FeQuestButtonOpen(nButtSelectSG,i)
          call FeQuestButtonOpen(nButtOriginSG,i)
        endif
      endif
      go to 9999
      entry EM50CellCheck
      if(nEdwDim.gt.0) then
        ndimo=ndim
        call FeQuestIntFromEdw(nEdwDim,ndim)
        ndimi=ndim-3
        ndimq=ndim*ndim
      endif
      if(CheckType.eq.EventEdw.and.CheckNumber.eq.nEdwDim) then
        nEdw=nEdwModVek-1
        do 1100i=1,3
          nEdw=nEdw+1
          if(i.le.ndimi) then
            if(EdwStateQuest(nEdw).eq.EdwOpened) then
              go to 1100
            else
              call FeQuestRealAEdwOpen(nEdw,qu(1,i,1,KPhase),3,.true.,
     1                                 .false.)
            endif
          else
            call FeQuestEdwClose(nEdw)
          endif
1100    continue
        if(ndimi.gt.0) then
          if(EdwStateQuest(nEdwComp).ne.EdwOpened) then
            ncomp=1
            call FeQuestIntEdwOpen(nEdwComp,ncomp,.false.)
            call FeQuestEudOpen(nEdwComp,1,3,1,0.,0.,0.)
          endif
          if(CrwStateQuest(nCrwCommen).eq.CrwClosed) then
            kcommen=0
            call FeQuestCrwOpen(nCrwCommen,.false.)
          endif
        else
          call FeQuestEdwClose(nEdwComp)
          call FeQuestCrwClose(nCrwCommen)
          call FeQuestEdwClose(nEdwSupCell)
          call FeQuestEdwClose(nEdwTzero)
          call FeQuestButtonClose(nButtShowSG)
          call FeQuestButtonClose(nButtSelectSG)
          call FeQuestButtonClose(nButtOriginSG)
          EventType=0
        endif
      else if(CheckType.eq.EventEdw.and.CheckNumber.eq.nEdwComp) then
        call FeQuestIntFromEdw(nEdwComp,ncomp)
        do 1400i=ncompOld+1,ncomp
          call UnitMat(zv(1,i,KPhase),ndim)
1400    continue
        if(ncomp.gt.1) then
          if(ButtonStateQuest(nButtCompMat).eq.ButtonClosed)
     1      call FeQuestButtonOpen(nButtCompMat,ButtonOff)
        else
          call FeQuestButtonClose(nButtCompMat)
        endif
      else if(CheckType.eq.EventEdw.and.CheckNumber.eq.nEdwTwin) then
        call FeQuestIntFromEdw(nEdwTwin,itwin)
        mxscu=mxscutw-itwin+1
        if(itwin.le.1) then
          call FeQuestEdwClose(nEdwTwin)
          call FeQuestButtonClose(nButtTwMat)
          call FeQuestCrwOff(nCrwTwin)
          EventType=0
        else
          do 1500i=itwinold+1,itwin
            call UnitMat(rtw(1,i),3)
1500      continue
        endif
      else if(CheckType.eq.EventCrw.and.CheckNumber.eq.nCrwTwin) then
        if(CrwLogicQuest(nCrwTwin)) then
          if(EdwState(nEdwTwin).eq.EdwClosed) then
            itwin=2
            mxscu=mxscutw-itwin+1
            call FeQuestIntEdwOpen(nEdwTwin,itwin,.false.)
            call FeQuestEudOpen(nEdwTwin,1,mxscutw,1,0.,0.,0.)
            call FeQuestButtonOpen(nButtTwMat,ButtonOff)
          endif
          EventType=EventEdw
          EventNumber=nEdwTwin
        else
          itwin=1
          mxscu=mxscutw-itwin+1
          call FeQuestEdwClose(nEdwTwin)
          call FeQuestButtonClose(nButtTwMat)
          EventType=0
        endif
      else if(CheckType.eq.EventCrw.and.CheckNumber.eq.nCrwCommen) then
        if(CrwLogicQuest(nCrwCommen)) then
          call FeQuestIntAEdwOpen(nEdwSupCell,ncommen(1,1,KPhase),3,
     1                            .false.)
          call SetRealArrayTo(trez(1,1,KPhase),ndimi,0.)
          call FeQuestRealAEdwOpen(nEdwTzero,trez(1,1,KPhase),ndimi,
     1                             .false.,.true.)
        if(ns.gt.0) then
            i=ButtonOff
          else
            i=ButtonDisabled
          endif
          call FeQuestButtonOpen(nButtShowSG,i)
          if(ndimi.lt.2) then
            call FeQuestButtonOpen(nButtSelectSG,i)
            call FeQuestButtonOpen(nButtOriginSG,i)
          endif
          EventType=EventEdw
          EventNumber=nEdwSupCell
          kcommen=1
          call FeQuestButtonOpen(nButtCompMat,ButtonOff)
        else
          call FeQuestEdwClose(nEdwSupCell)
          call FeQuestEdwClose(nEdwTzero)
          call FeQuestButtonClose(nButtShowSG)
          call FeQuestButtonClose(nButtSelectSG)
          call FeQuestButtonClose(nButtOriginSG)
          EventType=0
          kcommen=0
        endif
      else if(CheckType.eq.EventButton) then
        i=CheckNumber
        call EM50CellUpdate(ich)
        if(CheckNumber.eq.nButtTwMat) then
          call ReadTw(Rtw,Rtwi,itwin,CellPar(1,1,KPhase),ich)
          if(ich.eq.0) itwinold=itwin
        else if(CheckNumber.eq.nButtCompMat) then
          call EM50ReadCompMat(ich)
          if(ich.eq.0) ncompold=ncomp
        else if(CheckNumber.eq.nButtShowSG) then
          if(ich.eq.0) call EM50ShowSuperSG(0)
        else if(CheckNumber.eq.nButtSelectSG.or.
     1          CheckNumber.eq.nButtOriginSG) then
          if(ich.eq.0) then
            if(CheckNumber.eq.nButtSelectSG) then
              Key=0
            else
              Key=1
            endif
            call CopyVek(trez(1,1,KPhase),tzero,3)
            call EM50SelectSuperSG(Key,tzero)
            call FeQuestRealAEdwOpen(nEdwTzero,tzero,ndimi,.false.,
     1                               .true.)
          endif
        endif
        EventType=0
        EventNumber=0
        call FeQuestButtonOff(i)
      endif
      if(nEdwDim.eq.0) go to 9999
      if(ndim.ne.ndimo.or..not.AlreadyAppled) then
        if(.not.AlreadyAppled) ndimo=ndims
        AlreadyAppled=.false.
        if(ndim.gt.3) then
          nEdw=nEdwModVek
          do 2020i=1,ndimi
            if(EdwStringQuest(nEdw).ne.' ') then
              call FeQuestRealAFromEdw(nEdw,qu(1,i,1,KPhase))
            else
              ndims=ndimo
              go to 9999
            endif
            nEdw=nEdw+1
2020      continue
        endif
2025    nso=ns
        ns=0
        do 2080i=1,nso
          call UnitMat(rm6p,ndim)
          call SetRealArrayTo(s6(ndimo+1,i,1,KPhase),ndim-ndimo,0.)
          m=0
          do 2035j=1,ndimo
            do 2030k=1,ndimo
              m=m+1
              rm6p(k+(j-1)*ndim)=rm6(m,i,1,KPhase)
2030        continue
2035      continue
          do 2070j=4,ndim
            do 2045k=1,3
              pom=0.
              do 2040l=1,3
                pom=pom+qu(l,j-3,1,KPhase)*rm6p(l+(k-1)*ndim)
2040          continue
              pp(k)=pom
2045        continue
            do 2064k=-1,1
              do 2062l=-1,1
                do 2060m=-1,1
                  do 2050n=1,3
                    pq(n)=float(m)*qu(n,1,1,KPhase)-pp(n)
                    if(ndim.gt.4) pq(n)=pq(n)+float(l)*qu(n,2,1,KPhase)
                    if(ndim.gt.5) pq(n)=pq(n)+float(k)*qu(n,2,1,KPhase)
                    mpp(n)=nint(pq(n))
                    if(abs(pq(n)-float(mpp(n))).gt..0005) go to 2060
2050              continue
                  do 2052n=1,nvt
                    pom=ScalMul(vt6(1,n,1,KPhase),pq)
                    if(abs(pom-anint(pom)).gt..0005) go to 2060
2052              continue
                  do 2056n=1,3
                    rm6p(j+ndim*(n-1))=-mpp(n)
2056              continue
                  rm6p(j+ndim*3)=m
                  if(ndim.gt.4) rm6p(j+ndim*4)=l
                  if(ndim.gt.5) rm6p(j+ndim*5)=k
                  go to 2075
2060            continue
2062          continue
2064        continue
2070      continue
          if(ndim.gt.3) go to 2080
2075      ns=ns+1
          call CopyMat(rm6p,rm6(1,ns,1,KPhase),ndim)
          call CodeSym(rm6(1,ns,1,KPhase),s6(1,ns,1,KPhase),
     1                 symmc(1,ns,1,KPhase),0)
2080    continue
        AlreadyAppled=.true.
        Veta='???'
        call FindSmbSg(Veta,.true.,1)
        Grupa=Veta
      endif
9999  return
      end
      subroutine EM50ShowSuperSG(Key)
      include 'params.cmn'
      include 'basic.cmn'
      include 'fepc.cmn'
      dimension rm6s(36,mxsym),s6s(6,mxsym),vt6s(6,mxcen),ShSgS(6)
      character*8 Grupp
      character*4 LatticeS
      integer CrSystemSave,MonoclinicSave
      nss =ns
      ncss=ncs
      nvts=nvt
      LatticeS=Lattice
      ndims=ndim
      CrSystemSave=CrSystem
      MonoclinicSave=Monoclinic
      do 1010i=1,ns
        call CopyMat(rm6(1,i,1,KPhase),rm6s(1,i),ndim)
        call CopyVek(s6(1,i,1,KPhase),s6s(1,i),ndim)
1010  continue
      do 1020i=1,nvt
        call CopyVek(vt6(1,i,1,KPhase),vt6s(1,i),ndim)
1020  continue
      call CopyVek(ShSg(1,KPhase),ShSgS,ndim)
      call comsym(KPhase,0)
      call SuperSGToSuperCellSG(ich)
      if(ich.eq.0) then
        ndim=3
        ndimq=9
        ndimi=0
        CrSystem=CrSystemSave
        Monoclinic=MonoclinicSave
        call SetIgnoreWTo(.true.)
        call SetIgnoreETo(.true.)
        call FindSmbSg(Grupp,ChangeOrderYes,1)
        call ResetIgnoreW
        call ResetIgnoreE
        NInfo=2
        TextInfo(1)='Space group symbol : '//Grupp
        write(TextInfo(2),'(3f10.5)')(ShSg(i,KPhase),i=1,3)
        call ZdrcniCisla(TextInfo(2),3)
        TextInfo(2)='Origin shifted by    '//
     1              TextInfo(2)(:idel(TextInfo(2)))
        if(Key.eq.0) call FeInfoOut(-1.,-1.,'INFORMATION')
      else
        if(Key.eq.0) call FeUnforeseenError
      endif
      ndim=ndims
      ndimq=ndim**2
      ndimi=ndim-3
      ns =nss
      ncs=ncss
      nvt=nvts
      Lattice=LatticeS
      do 5010i=1,ns
        call CopyMat(rm6s(1,i),rm6(1,i,1,KPhase),ndim)
        call CopyVek(s6s(1,i),s6(1,i,1,KPhase),ndim)
        call CodeSym(rm6(1,i,1,KPhase),s6(1,i,1,KPhase),
     1               symmc(1,i,1,KPhase),0)
5010  continue
      do 5020i=1,nvt
        call CopyVek(vt6s(1,i),vt6(1,i,1,KPhase),ndim)
5020  continue
      call CopyVek(ShSgS,ShSg(1,KPhase),ndim)
      ngc=0
      kcommen=1
      call SavePhase
      CrSystem=CrSystemSave
      Monoclinic=MonoclinicSave
      return
      end
      subroutine EM50SelectSuperSG(Key,tzero)
      include 'params.cmn'
      include 'basic.cmn'
      include 'fepc.cmn'
      dimension ta(100),tzero(*)
      character*60 tlist(100),ch60
      logical SelwLogicQuest
      integer CrSystemSave,MonoclinicSave
      nlim=NCommQ(1,1,KPhase)
      tlim=1./float(nlim)
      tlist(1)='  Return without changing'
      if(key.eq.1) tlist(1)='       '//tlist(1)
      ta(1)=tzero(1)
      CrSystemSave=CrSystem
      MonoclinicSave=Monoclinic
      if(Key.eq.0) then
        itgrid=24
        nt=2
        ta(nt)=1./sqrt(2.)*tlim
        trez(1,1,KPhase)=ta(nt)
        call EM50ShowSuperSG(1)
        tlist(nt)='General            '//TextInfo(1)(22:)
      else
        nt=1
        itgrid=nlim
      endif
      do 1600j=0,itgrid-1
        CrSystem=CrSystemSave
        Monoclinic=MonoclinicSave
        if(Key.eq.0) then
          do 1530k=j,1,-1
            if(mod(itgrid*nlim,k).eq.0.and.mod(j,k).eq.0) then
              iz=(itgrid*nlim)/k
              jz=j/k
              go to 1540
            endif
1530      continue
          iz=itgrid*nlim
          jz=j
1540      trez(1,1,KPhase)=float(jz)/float(iz)
        else
          pom=tzero(1)+float(j)*tlim
1550      if(pom.gt..9999) then
            pom=pom-1.
            go to 1550
          endif
          do 1560k=1,24
            fk=k
            jz=nint(pom*fk)
            if(abs(pom-float(jz)/fk).lt..0001) then
              iz=k
              go to 1570
            endif
1560      continue
          iz=0
          jz=0
1570      trez(1,1,KPhase)=pom
        endif
        call EM50ShowSuperSG(1)
        if(iz.gt.0) then
          if(jz.gt.0) then
            write(Cislo,'(i4,''/'',i4)') jz,iz
            call zhusti(Cislo)
            ch60=Cislo
          else
            ch60='0'
          endif
          if(Key.eq.0)  then
            write(Cislo,'(i4)') nlim
            call zhusti(Cislo)
            ch60=ch60(:idel(ch60))//' + n/'//Cislo(:idel(Cislo))
          endif
        else
          write(ch60,'(f10.4)') pom
        endif
        if(Key.eq.0) then
          ch60(17:)='   '//TextInfo(1)(22:31)
          if(tlist(2)(20:27).eq.ch60(20:27)) go to 1600
        else
          ch60(10:)='   '//TextInfo(1)(22:31)
          ch60(22:)='   '//TextInfo(2)(22:idel(TextInfo(2)))
        endif
        nt=nt+1
        if(nt.le.100) then
          tlist(nt)=ch60
          ta(nt)=trez(1,1,KPhase)
        endif
1600  continue
1650  if(nt.gt.100) then
        call FeMsgOut(-1.,-1.,
     1              'Warning: Not enough space to complete the table')
      endif
      CrSystem=CrSystemSave
      Monoclinic=MonoclinicSave
      id=NextQuestId()
      if(Key.eq.0) then
        xqd=100.
      else
        xqd=150.
      endif
      nmax=min(nt,15)
      ch60='Select supercell spacegroup'
      call FeQuestCreate(id,-1.,-1.,xqd,nmax+1,1,ch60,0,LightGray,0,0)
      if(nt.gt.15) then
        xpom=xqd-13.
        call FeQuestUpDownMake(id,xpom,0,UpDownXd,UpDownYd,'up')
        nUp=UpDownLastMade
        call FeQuestUpDownMake(id,xpom,nmax+1,UpDownXd,UpDownYd,'down')
        nDown=UpDownLastMade
      endif
      xpom=xqd*.5-50.
      il=1
      if(Key.eq.0) then
        ch60='Tzero              Space group'
      else
        ch60='Tzero       Space group   Origin shift'
      endif
      call FeQuestLabelMake(id,5.,il,ch60,'L')
      m=1
3100  n1=15*(m-1)+1
      n2=min(n1+14,nt)
      j=n1
      k=1
      xpom=5.
      call FeQuestReset('SelwNumber')
      il=2
      do 3150i=1,nmax
        if(j.gt.nt) then
          call FeQuestSelwRemove(i)
        else
          call FeQuestSelwMake(id,5.,il,tlist(i),xqd-10.,SelwYd,0,1)
          if(i.eq.1) nSelwFirst=SelwLastMade
          call FeQuestSelwOpen(SelwLastMade,i.eq.1)
        endif
        j=j+1
        il=il+1
3150  continue
      if(nt.gt.15) then
        if(n2.lt.nt) then
          call FeQuestUpDownOff(nDown)
        else
          call FeQuestUpDownDisable(nDown)
        endif
        if(n1.gt.1) then
          call FeQuestUpDownOff(nUp)
        else
          call FeQuestUpDownDisable(nUp)
        endif
      endif
      icont=0
3500  call FeQuestEvent(id,icont,ich)
      icont=1
      if(CheckType.eq.EventUpDown.and.(CheckNumber.eq.nDown.or.
     1                                      CheckNumber.eq.nUp)) then
        if(CheckNumber.eq.nDown) then
          m=m+1
        else
          m=m-1
        endif
        go to 3100
      else if(CheckType.ne.0) then
        call NebylOsetren
        go to 3500
      endif
      if(ich.eq.0) then
        j=nSelwFirst
        do 5100i=1,nt
          if(SelwLogicQuest(i)) then
            tzero(1)=ta(i)
            go to 5200
          endif
5100    continue
      endif
5200  call FeQuestRemove(id)
      return
      end
      subroutine EM50CellUpdate(ich)
      include 'params.cmn'
      include 'basic.cmn'
      include 'fepc.cmn'
      include 'editm50.cmn'
      character*256 EdwStringQuest
      logical CrSystemDiff
      ich=0
      Name=EdwStringQuest(nEdwName)
      if(nEdwPhase.gt.0) PhaseName(KPhase)=EdwStringQuest(nEdwPhase)
      if(EdwStringQuest(nEdwCell).ne.' ') then
        call FeQuestRealAFromEdw(nEdwCell,CellPar(1,1,KPhase))
        if(CellPar(1,1,KPhase).le.0..or.CellPar(2,1,KPhase).le.0..or.
     1     CellPar(3,1,KPhase).le.0.) then
          call FeChybne(-1.,-1.,'negative volume - try again',' ',0,
     1                  SeriousError)
          go to 1200
        endif
        csa=cos(CellPar(4,1,KPhase)*torad)
        csb=cos(CellPar(5,1,KPhase)*torad)
        csg=cos(CellPar(6,1,KPhase)*torad)
        pom=1.-csa**2-csb**2-csg**2+2.*csa*csb*csg
        if(pom.le.0.) then
          call FeChybne(-1.,-1.,'angles are incompatible - try '//
     1                  'again',' ',0,SeriousError)
          go to 1200
        endif
        CellVol(1,KPhase)=CellPar(1,1,KPhase)*CellPar(2,1,KPhase)*
     1                    CellPar(3,1,KPhase)*sqrt(pom)
        call CheckSystem(CellPar(1,1,KPhase),i,j)
        if(CrSystemDiff(j,CrSystem)) then
          Monoclinic=i
          CrSystem=j
        endif
      else
        call FeChybne(-1.,-1.,'you must first define cell parameters',
     1                ' ',0,SeriousError)
        go to 1200
      endif
      go to 1300
1200  EventType=EventEdw
      EventNumber=nEdwCell
      go to 9000
1300  call FeQuestRealAFromEdw(nEdwEsd,CellParSU(1,1,KPhase))
      nEdw=nEdwModVek-1
      do 2000i=1,ndimi
        nEdw=nEdw+1
        if(EdwStringQuest(nEdw).ne.' ') then
          call FeQuestRealAFromEdw(nEdw,qu(1,i,1,KPhase))
          pom=0.
          do 1400j=1,3
            pom=pom+abs(qu(j,i,1,KPhase))
1400      continue
          if(pom.lt..0001) go to 1500
        else
          go to 1600
        endif
        go to 2000
1500    call FeChybne(-1.,-1.,'the modulation vector cannot be a zero'//
     1                ' vector',' ',0,SeriousError)
        go to 1900
1600    call FeChybne(-1.,-1.,'you must first define modulation '//
     1                'vector(s)',' ',0,SeriousError)
1900    EventType=EventEdw
        EventNumber=nEdwModVek
        go to 9000
2000  continue
      if(kcommen.ne.0) then
        if(EdwStringQuest(nEdwSupCell).ne.' ') then
          call FeQuestIntAFromEdw(nEdwSupCell,ncommen(1,1,KPhase))
        else
          go to 9999
        endif
        if(EdwStringQuest(nEdwTzero).ne.' ') then
          call FeQuestRealAFromEdw(nEdwTzero,trez(1,1,KPhase))
        else
          go to 9999
        endif
      endif
      call SetMet(0)
      call SavePhase
      go to 9999
9000  ich=1
9999  return
      end
      subroutine EM50Symmetry
      include 'params.cmn'
      include 'basic.cmn'
      include 'editm50.cmn'
      include 'fepc.cmn'
      dimension sp(6),rmm(36)
      character*256 EdwStringQuest
      character*80 Veta
      character*60 GrupaOld,GrupaNew
      character*43 Text1,Text2
      character*2 nty
      character*1 SmbL(8)
      integer ZeSymbolu,EdwStateQuest,FeMenu,Zvenku
      logical eqrv,eqiv,NicTamNeni,CrwLogicQuest,FirstTime,EqIgCase,
     1        MakeCellTest,AskForDelta,FeYesNoHeader
      save nCrwInvCentr,nEdwGrupa,nEdwShift,nEdwCellCentr,
     1     nUpDownCellCentr,nButtComplete,nUpDownPgUp,nEdwOperator,
     2     nUpDownPgDown,iz,ik,ZeSymbolu,ilt,xtxt
      data SmbL/'P','A','B','C','I','R','F','X'/,
     1     Text1/'The operators derived from the group symbol'/,
     2     Text2/'The group symbol derived from the operators'/,
     3     GrupaOld/' '/
      entry EM50SymmetryMake(id)
      GrupaOld=Grupa
      if(ndim.ne.4) then
        Veta='Space %group'
      else
        Veta='Superspace %group'
      endif
      il=1
      xtxt=125.
      call FeQuestEdwMake(id,5.,il,60.,il,Veta,'L',75.,EdwYd,1)
      nEdwGrupa=EdwLastMade
      NicTamNeni=index(Grupa,'?').gt.0
      call FeQuestEdwMake(id,140.,il,185.,il,'%Origin shift','L',70.,
     1                    EdwYd,1)
      nEdwShift=EdwLastMade
      n=ndim
      if(n.gt.4) n=3
      call FeQuestRealAEdwOpen(nEdwShift,shsg(1,KPhase),n,NicTamNeni,
     1                         .true.)
      il=il+1
      call FeQuestLineMake(id,il)
      il=il+1
      ilt=il
      if(NicTamNeni) then
        ZeSymbolu=0
        call FeQuestStringEdwOpen(nEdwGrupa,' ')
      else
        call FeQuestStringEdwOpen(nEdwGrupa,Grupa)
        if(Grupa.eq.' ') then
          ZeSymbolu=0
        else
          call FeQuestLabelMake(id,xtxt,il,Text1,'C')
          ZeSymbolu=1
        endif
      endif
      call FeQuestUpDownMake(id,247.,il,UpDownXd,UpDownYd,'up')
      nUpDownPgDown=UpDownLastMade
      iz=1
      ik=min(16,mxsym)
      xpom=5.
      il=il+1
      iw=1
      do 1000i=iz,ik
        write(cislo,100) i,nty(i)
        call FeQuestEdwMake(id,xpom,il,xpom+20.,il,Cislo,'L',100.,EdwYd,
     1                      1)
        if(i.eq.iz) nEdwOperator=EdwLastMade
        if(iw.eq.8) then
          xpom=xpom+130.
          il=ilt
        endif
        iw=iw+1
        il=il+1
1000  continue
      call FeQuestCrwMake(id,5.,il,65.,il,'%Inversion center','L',CrwXd,
     1                    CrwYd,1,0)
      nCrwInvCentr=CrwLastMade
      call FeQuestCrwOpen(nCrwInvCentr,ncs.eq.1)
      call FeQuestEdwMake(id,82.,il,110.,il,'Ce%ll','L',20.,EdwYd,1)
      nEdwCellCentr=EdwLastMade
      call FeQuestStringEdwOpen(nEdwCellCentr,Lattice)
      call FeQuestUpDownMake(id,FeXPixRound(110.)-UpDownXd-5.*PixelX,
     1                       il,UpDownXd,UpDownYd,'up')
      nUpDownCellCentr=UpDownLastMade
      call FeQuestUpDownOpen(nUpDownCellCentr,UpDownOff)
      call FeQuestButtonMake(id,150.,il,60.,ButYd,'%Complete the set')
      nButtComplete=ButtonLastMade
      call FeQuestButtonOpen(nButtComplete,ButtonOff)
      call FeQuestUpDownMake(id,247.,il,UpDownXd,UpDownYd,'down')
      nUpDownPgUp=UpDownLastMade
      go to 9999
      entry EM50SymmetryRefresh
      nEdw=nEdwOperator
      do 1100i=iz,ik
        if(i.le.ns) then
          call MakeSymmSt(Veta,symmc(1,i,1,KPhase))
        else
          Veta=' '
        endif
        if(EdwStringQuest(nEdw).ne.Veta.or.
     1     EdwStateQuest(nEdw).ne.EdwOpened)
     2     call FeQuestStringEdwOpen(nEdw,Veta)
        nEdw=nEdw+1
1100  continue
      if(EdwStringQuest(nEdwCellCentr).ne.Lattice.or.
     1   EdwStateQuest(nEdwCellCentr).ne.EdwOpened)
     2   call FeQuestStringEdwOpen(nEdwCellCentr,Lattice)
      if(ncs.eq.1) then
        call FeQuestCrwOn(nCrwInvCentr)
      else
        call FeQuestCrwOff(nCrwInvCentr)
      endif
      if(iz.gt.1) then
        call FeQuestUpDownOpen(nUpDownPgDown,UpDownOff)
      else
        call FeQuestUpDownDisable(nUpDownPgDown)
      endif
      if(ns.ge.ik.and.mxsym.gt.ik) then
        call FeQuestUpDownOpen(nUpDownPgUp,UpDownOff)
      else
        call FeQuestUpDownDisable(nUpDownPgUp)
      endif
      if(Grupa.eq.' '.or.index(Grupa,'?').gt.0) then
        call FeQuestStringEdwOpen(nEdwGrupa,' ')
      else
        call FeQuestStringEdwOpen(nEdwGrupa,Grupa)
      endif
      go to 9999
      entry EM50SymmetryCheck
      if(CheckType.eq.EventEdw.and.
     1        (CheckNumber.eq.nEdwGrupa.or.CheckNumber.eq.nEdwShift))
     2  then
        Grupa=EdwStringQuest(nEdwGrupa)
        if(Grupa.eq.' ') go to 3250
        AskForDelta=CheckNumber.eq.nEdwGrupa
        if(EdwStringQuest(nEdwShift).eq.' ') then
          call SetRealArrayTo(shsg(1,KPhase),ndim,0.)
          n=ndim
          if(n.gt.4) n=3
          call FeQuestRealAEdwOpen(nEdwShift,shsg(1,KPhase),n,.false.,
     1                             .true.)
        endif
        call FeQuestRealAFromEdw(nEdwShift,shsg(1,KPhase))
        StdSg(KPhase)=1
        do 2010i=1,ndim
          if(abs(shsg(i,KPhase)).gt..0001) then
            StdSg(KPhase)=0
            go to 2015
          endif
2010    continue
2015    Grupa=EdwStringQuest(nEdwGrupa)
        FirstTime=.not.EqIgCase(Grupa,GrupaOld)
        MakeCellTest=.true.
        if(EventType.eq.EventKartSw.and.
     1     EventNumber.eq.KartIdCell+1-KartFirstId)
     2    QuestCheck(KartId)=-1
        GrupaOld=Grupa
        call EM50GenSym(FirstTime,MakeCellTest,AskForDelta,ich)
        if(ich.eq.0) then
          if(ZeSymbolu.eq.-1)
     1      call FeQuestLabelRemove(KartId,xtxt,ilt,Text2,'C')
          if(Grupa.ne.' '.and.ZeSymbolu.ne.1) then
            ZeSymbolu=1
            call FeQuestLabelMake(KartId,xtxt,ilt,Text1,'C')
          endif
        else
          EdwLastCheck=1
          if(QuestCheck(KartId).ne.-1) then
            if(CheckType.eq.EventEdw.and.
     1        (CheckNumber.eq.nEdwGrupa.or.CheckNumber.eq.nEdwShift))
     2        then
              EventType=EventEdw
              EventNumber=nEdwGrupa
            endif
            ErrJana=1
          endif
          GrupaOld=' '
        endif
      else if(CheckType.eq.EventEdw.and.CheckNumber.ge.nEdwOperator
     1                             .and.CheckNumber.le.nEdwOperator+15)
     2  then
        il=CheckNumber-nEdwOperator+iz
        Veta=EdwStringQuest(CheckNumber)
        if(Veta.eq.' ') then
          if(il.le.ns) then
            do 2100i=il+1,ns
              call CopySymmOperator(i,i-1,1)
2100        continue
            ns=ns-1
            go to 3250
          endif
        else
          if(il.gt.ns) il=ns+1
          call mala(Veta)
          call CopyMat(rm6(1,il,1,KPhase),rmp,ndim)
          call CopyVek(s6(1,il,1,KPhase),sp,ndim)
          call CtiSym(Veta,rm6(1,il,1,KPhase),s6(1,il,1,KPhase),
     1                symmc(1,il,1,KPhase),0)
          if(ErrJana.ne.0) go to 2550
          call trmat(rm6(1,il,1,KPhase),rmm,ndim,ndim)
          call multm(rm6(1,il,1,KPhase),MetTens6(1,KPhase),gpp ,ndim,
     1               ndim,ndim)
          call multm(gpp,rmm,gps,ndim,ndim,ndim)
          if(.not.eqrv(MetTens6(1,KPhase),gps,ndimq,1.e-7)) go to 2510
          call NormCentr(s6(1,il,1,KPhase))
          do 2150i=1,ns
            if(i.ne.il.and.
     1         eqrv(s6(1,il,1,KPhase),s6(1,i,1,KPhase),ndim,.0001).and.
     2         eqrv(rm6(1,il,1,KPhase),rm6(1,i,1,KPhase),ndimq,.001))
     3         go to 2500
            if(ncs.eq.1) then
              call RealMatrixToOpposite(rm6(1,il,1,KPhase),rmm,ndim)
              if(i.ne.il.and.
     1           eqrv(s6(1,il,1,KPhase),s6(1,i,1,KPhase),ndim,.0001)
     2           .and.eqrv(rmm,rm6(1,i,1,KPhase),ndimq,.001)) go to 2500
            endif
2150      continue
          if(il.gt.ns) then
            ns=ns+1
            go to 3250
          else
            if(.not.eqrv(s6(1,il,1,KPhase),sp,ndim,.0001).or.
     1         .not.eqrv(rm6(1,il,1,KPhase),rmp,ndimq,.001)) go to 3250
          endif
        endif
        go to 9999
2500    call FeChybne(-1.,-1.,'the symmetry operator already present',
     1                'try again',0,SeriousError)
        go to 2550
2510    if(EventType.eq.EventKartSw.and.
     1     EventNumber.eq.KartIdCell+1-KartFirstId) then
          QuestCheck(KartId)=-1
          go to 9999
        else
          call FeChybne(-1.,-1.,'the symmetry operator is not '//
     1                  'consistent','with cell parameters',0,
     2                  SeriousError)
        endif
2550    EventType=EventEdw
        EventNumber=CheckNumber
      else if(CheckType.eq.EventEdw.and.CheckNumber.eq.nEdwCellCentr)
     1  then
        Veta=EdwStringQuest(nEdwCellCentr)
        call Velka(Veta)
        n=index(smbc,Veta(1:1))
        if(n.le.0) then
          call FeChybne(-1.,-1.,'the centring symbol isn''t implemented'
     1                 ,'try again',0,SeriousError)
          EventNumber=nEdwCellCentr
          EventType=EventEdw
        else
          go to 3100
        endif
      else if(CheckType.eq.EventButton) then
        if(CheckNumber.eq.nButtComplete) then
          call FeQuestButtonOff(nButtComplete)
          Zvenku=0
          go to 3000
        endif
      else if(CheckType.eq.EventCrw) then
        if(CrwLogicQuest(nCrwInvCentr)) then
          call SetLogicalArrayTo(BratSym,ns,.true.)
          do 2630i=1,ns-1
            if(.not.BratSym(i)) go to 2630
            do 2620j=i+1,ns
              if(.not.BratSym(j)) go to 2620
              call RealMatrixToOpposite(rm6(1,j,1,KPhase),rmm,ndim)
              if(eqrv(s6(1,i,1,KPhase),s6(1,j,1,KPhase),ndim,.0001).and.
     1           eqrv(rm6(1,i,1,KPhase),rmm,ndimq,.001)) then
                BratSym(j)=.false.
                go to 2630
              endif
2620        continue
2630      continue
          nss=0
          do 2640i=1,ns
            if(BratSym(i)) then
              nss=nss+1
              call CopySymmOperator(i,nss,1)
            endif
2640      continue
          ns=nss
          ncs=1
        else
          ncs=2
        endif
        go to 3200
      else if(CheckType.eq.EventUpDown) then
        if(CheckNumber.eq.nUpDownCellCentr) then
          n=max(1,index(smbc,Lattice(1:1)))
          n=FeMenu(EdwXminQuest(nEdwCellCentr),
     1             EdwYminQuest(nEdwCellCentr),SmbL,1,8,n,1)
          call FeQuestUpDownOff(nUpDownCellCentr)
          if(n.ge.1.and.n.le.8) then
            go to 3100
          else
            EventType=0
            EventNumber=0
            go to 9999
          endif
        else if(CheckNumber.eq.nUpDownPgUp) then
          j= 16
        else if(CheckNumber.eq.nUpDownPgDown) then
          j=-16
        endif
        xpom=5.
        il=4
        nEdw=nEdwOperator
        do 2800i=iz,ik
          write(cislo,100) i+j,nty(i+j)
          call FeQuestEdwLabelChange(KartId,nEdw,Cislo)
          il=il+1
          nEdw=nEdw+1
2800    continue
        iz=iz+j
        ik=ik+j
        EventType=EventEdw
        EventNumber=nEdwOperator+min(ns-iz,15)
      else if(CheckType.ne.0) then
        call NebylOsetren
      endif
      go to 9999
      entry EM50SymmetryComplete
      if(ZeSymbolu.eq.1.and.Grupa.ne.' ') go to 9999
      Zvenku=1
3000  call CompleteSym(0,ich)
      if(ich.eq.0) then
        go to 3010
      else
        go to 3050
      endif
3010  GrupaNew='???'
      call FindSmbSg(GrupaNew,ChangeOrderYes,1)
      if(index(GrupaNew,'?').gt.0) go to 3040
      if(Zvenku.eq.0.and..not.EqIgCase(GrupaNew,Grupa).and.Grupa.ne.' ')
     1  then
        NInfo=2
        TextInfo(1)=Grupa(:idel(Grupa))//'->'//GrupaNew(:idel(GrupaNew))
        TextInfo(2)='The program is offering you the standard space '//
     1              'group symbol'
        if(FeYesNoHeader(-1.,-1.,
     1                   'Do you want to accept the new symbol?',0))
     2    then
          Grupa=GrupaNew
        else
          go to 3040
        endif
      else
        Grupa=GrupaNew
      endif
      if(ZeSymbolu.eq.1)
     1  call FeQuestLabelRemove(KartId,xtxt,ilt,Text1,'C')
      if(Grupa.eq.' '.or.index(Grupa,'?').gt.0) then
        call FeQuestStringEdwOpen(nEdwGrupa,' ')
      else
        call FeQuestStringEdwOpen(nEdwGrupa,Grupa)
      endif
      n=ndim
      if(n.gt.4) n=3
      call FeQuestRealAEdwOpen(nEdwShift,shsg(1,KPhase),n,.false.,
     1                         .true.)
      if(ZeSymbolu.ne.-1) then
        ZeSymbolu=-1
        call FeQuestLabelMake(KartId,xtxt,ilt,Text2,'C')
      endif
3040  if(Zvenku.eq.1) go to 9999
3050  EventType=EventEdw
      EventNumber=nEdwOperator+min(ns-iz,15)
      go to 9999
3100  if(Lattice.ne.SmbL(n).or.Lattice.eq.'X') then
        call EM50GenVecCentr(n,.true.,ich)
        Lattice=SmbL(n)
        do 3120i=1,ns
          call CopyVek(s6(1,i,1,KPhase),sp,ndim)
          call NormCentr(s6(1,i,1,KPhase))
          if(.not.eqrv(s6(1,i,1,KPhase),sp,ndim,.0001))
     1      call CodeSym(rm6(1,i,1,KPhase),s6(1,i,1,KPhase),
     2                   symmc(1,i,1,KPhase),0)
3120    continue
        go to 3200
      else
        EventType=0
        EventNumber=0
        go to 9999
      endif
3200  EventType=EventEdw
      EventNumber=nEdwOperator+min(ns-iz,15)
3250  if(EdwStringQuest(nEdwGrupa).ne.' ') then
        if(ZeSymbolu.eq.1) then
          call FeQuestLabelRemove(KartId,xtxt,ilt,Text1,'C')
        else if(ZeSymbolu.eq.-1) then
          call FeQuestLabelRemove(KartId,xtxt,ilt,Text2,'C')
        endif
        ZeSymbolu=0
        Grupa=' '
        call FeQuestStringEdwOpen(nEdwGrupa,Grupa)
      endif
      if(EdwStringQuest(nEdwShift).ne.' ') then
        n=ndim
        if(n.gt.4) n=3
        call FeQuestRealAEdwOpen(nEdwShift,shsg(1,KPhase),n,.true.,
     1                           .true.)
      endif
      ich=1
      go to 9999
9999  return
100   format(i2,a2)
      end
      subroutine EM50GenSym(FirstTime,MakeCellTest,AskForDelta,ich)
      include 'params.cmn'
      include 'basic.cmn'
      include 'editm50.cmn'
      include 'fepc.cmn'
      dimension ieps(4),tau(4),ie(4),tp(4),rp(36),trm(36),trmi(36),
     1          ipor(4),xsh(6)
      character*256 Veta
      character*80 t80
      character*40 itxt,itxti,GrupaPom
      character*11 iqs
      character*8 GrupaI
      character*6 smbtau
      character*5 smbq(3)
      character*2 nty
      logical StdSmb,SmbNew,SearchForPrimitive,FirstTime,BylaNeni,
     1        MakeCellTest,AskForDelta
      integer EM50IrrType
      data iqs/'PABCLMNUVWR'/,smbtau/'01stqh'/,
     1     smbq/'alfa','beta','gamma'/
      if(FirstTime.and.(Monoclinic.lt.1.or.Monoclinic.gt.3)) then
        MonoclinicDef=Monoclinic
        if(MonoclinicDef.lt.1.or.MonoclinicDef.gt.3) MonoclinicDef=2
        call CheckSystem(CellPar(1,1,KPhase),Monoclinic,CrSystem)
      endif
      call Zhusti(Grupa)
      id=idel(Grupa)
      if(ndim.eq.4) then
        i1=index(Grupa,':')
        if(i1.gt.0.and.i1.lt.id) then
          i2=index(Grupa(i1+1:),':')+i1
          SmbNew=.false.
        else
          i1=index(Grupa,'(')
          if(i1.gt.0.and.i1.lt.id) then
            i2=index(Grupa(i1+1:),')')+i1
            SmbNew=.true.
          else
            i2=0
          endif
        endif
        if(i1.le.0.or.i2.le.i1) go to 8150
        if(SmbNew) then
          GrupaPom=Grupa(1:i1-1)
          t80=Grupa(i1+1:i2-1)
          call mala(t80)
          do 1020i=1,3
            if(idel(t80).le.0) go to 8160
            k=1
1010        if(t80(k:k).eq.smbq(i)(k:k)) then
              k=k+1
              go to 1010
            endif
            k=k-1
            if(k.eq.0) then
              j=index(t80,'/')
              if(j.le.0.or.j.gt.3.or.(j.eq.3.and.t80(1:1).ne.'-')) then
                k=1
              else
                k=j+1
              endif
              tp(i)=0.
              quir(i,1,KPhase)=fract(t80(1:k),ich)
              if(ich.ne.0) go to 8160
            else
              tp(i)=123.45
              quir(i,1,KPhase)=0.
            endif
            t80=t80(k+1:)
1020      continue
          n=0
          ic=0
          in=0
          do 1030i=1,3
            if(abs(quir(i,1,KPhase)).lt..0001) then
              n=n+1
              if(in.eq.0) in=i
            else if(ic.eq.0) then
              ic=i
            endif
1030      continue
          nq=0
          if(n.eq.3) then
            nq=1
          else if(n.eq.2) then
            if(abs(quir(ic,1,KPhase)-.5).lt..0001) then
              nq=ic+1
            else if(abs(quir(ic,1,KPhase)-1.).lt..0001) then
              nq=ic+4
            endif
          else if(n.eq.1) then
            if(abs(quir(1,1,KPhase)-.333333).lt..0001.and.
     1         abs(quir(2,1,KPhase)-.333333).lt..0001) then
              nq=11
            else if(abs(quir(ic,1,KPhase)-.5).lt..0001.and.
     1              abs(quir(6-ic-in,1,KPhase)-.5).lt..0001) then
              nq=7+in
            else if(abs(quir(ic,1,KPhase)-1.).lt..0001.and.
     1              abs(quir(6-ic-in,1,KPhase)-1.).lt..0001) then
              nq=11+in
            endif
          endif
          if(nq.le.0) go to 8160
        else
          GrupaPom=Grupa(i1+1:i2-1)
          call velka(Grupa(1:1))
          nq=index(iqs,Grupa(1:1))
          if(i1.gt.2.or.nq.eq.0) go to 8160
          if(nq.lt.8) then
            do 1040j=1,3
              quir(j,1,KPhase)=0.
1040        continue
            if(nq.ne.1) then
              if(nq.le.4) then
                i=nq-1
                p=.5
              else
                i=nq-4
                p=1.
              endif
              quir(i,1,KPhase)=p
            endif
          else if(nq.lt.11) then
            do 1050j=1,3
              quir(j,1,KPhase)=.5
1050        continue
            quir(nq-7,1,KPhase)=0.
          else
            quir(1,1,KPhase)=.333333
            quir(2,1,KPhase)=.333333
            quir(3,1,KPhase)=0.
          endif
        endif
        do 1060i=1,3
          if(abs(quir(i,1,KPhase)).gt..1) then
            qui(i,1,KPhase)=0.
            if(abs(qu(i,1,1,KPhase)).gt..001.and.
     1         abs(quir(i,1,KPhase)-qu(i,1,1,KPhase)).gt..001)
     2           go to 8160
          else
            qui(i,1,KPhase)=qu(i,1,1,KPhase)
          endif
1060    continue
        iqv=EM50IrrType(qui(1,1,KPhase))
        if(iqv.eq.0) go to 8160
        pom=0.
        if(SmbNew) then
          do 1082i=1,3
            pom=pom+abs(tp(i)*qui(i,1,KPhase))
1082      continue
          if(pom.lt..0001) go to 8160
          iqvp=EM50IrrType(tp)
          if(iqvp.eq.0) go to 8160
        else
          iqvp=iqv
        endif
      else
        do 1090i=1,ndimi
          do 1085j=1,3
            qui(j,i,KPhase)=qu(j,i,1,KPhase)
            quir(j,i,KPhase)=0.
1085      continue
1090    continue
        GrupaPom=Grupa
        iqv=0
        iqvp=0
      endif
1100  if(GrupaPom(1:1).eq.'-') then
        call Uprat(GrupaPom(2:))
      else
        call Uprat(GrupaPom)
      endif
      i=index(GrupaPom,';')
      j=index(GrupaPom(2:),'x')
      k=index(GrupaPom,'y')
      l=index(GrupaPom,'z')
      if(i.le.0.and.j.le.0.and.k.le.0.and.l.le.0.and.grupa(1:1).ne.'-')
     1   then
        StdSmb=.true.
        Lattice=GrupaPom(1:1)
        if(Lattice.eq.'X') GrupaPom(1:1)='P'
        SearchForPrimitive=.false.
1200    imd=0
        BylaNeni=.false.
        ln=NextLogicNumber()
        if(OpSystem.le.0) then
          Veta=JanaDir(:idel(JanaDir))//'symmdat'//ObrLom//'spgroup.dat'
        else
          Veta=JanaDir(:idel(JanaDir))//'source/data/spgroup.dat'
        endif
        call OpenFile(ln,Veta,'formatted','old')
        if(ErrJana.ne.0) go to 8700
        read(ln,FormA256) Veta
        if(Veta(1:1).ne.'#') rewind ln
2000    read(ln,FormSG,err=8610,end=2010) igi,ipgi,idli,GrupaI,itxti
        if(imd.ne.0) imd=imd+1
        if((GrupaI.eq.'P2'.and.imd.eq.0).or.
     1      GrupaI.eq.'Pmm2') imd=1
        if(GrupaPom.eq.GrupaI.or.
     1     (Lattice.eq.'X'.and.GrupaPom(2:).eq.GrupaI(2:))) then
          if(ipgi.ge.3.and.ipgi.le.5) then
            if(Monoclinic.eq.0.and.
     1         (CrSystem.eq.3.or.CrSystem.eq.4.or.CrSystem.eq.7)) then
               Monoclinic=MonoclinicDef
               call EM50ReadMonoclinic(Monoclinic)
            endif
            if(mod(imd-1,3)+1.ne.Monoclinic) then
              BylaNeni=.true.
              go to 2000
            endif
          endif
          go to 2100
        endif
        go to 2000
2010    call CloseIfOpened(ln)
        if(BylaNeni) then
          go to 8000
        else
         if(SearchForPrimitive.or.GrupaPom(1:1).eq.'P') then
           go to 8170
         else
           SearchForPrimitive=.true.
           GrupaPom(1:1)='P'
           go to 1200
         endif
        endif
2100    call CloseIfOpened(ln)
        k=index(itxti,'#')
        if(k.gt.0) then
          itxt=itxti(1:k-1)
          Veta=itxti(k+1:idel(itxti))
          do 2105j=1,idel(Veta)
            if(Veta(j:j).eq.',') Veta(j:j)=' '
2105      continue
          k=0
          call StToReal(Veta,k,ShiftSg,3,.false.,ich)
          call SetRealArrayTo(ShiftSg(4),ndimi,0.)
        else
          itxt=itxti
          call SetRealArrayTo(ShiftSg,ndim,0.)
        endif
        ipg=ipgi
        if(Lattice.eq.'X'.or.SearchForPrimitive) then
          ngrupa=0
        else
          ngrupa=igi
        endif
        idl=idli
        Poradi=.true.
        if(ipg.le.2) then
          CrSystem=1
          if(ndim.eq.4.and.SmbNew.and.iqvp.ne.4.and.MakeCellTest)
     1      go to 8160
        else if(ipg.ge.3.and.ipg.le.5) then
          imd=mod(imd-1,3)+1
          if(MakeCellTest.and.ndim.eq.4.and.
     1       ((Monoclinic.ne.iabs(iqv).and.
     2         abs(qui(Monoclinic,1,KPhase)).gt.0.)
     3         .or.Monoclinic.ne.iabs(iqvp))) go to 8160
          CrSystem=2+Monoclinic*10
        else if(ipg.ge.6.and.ipg.le.8) then
          Poradi=.false.
          imd=mod(imd+1,3)+1
          if(MakeCellTest.and.ndim.eq.4.and.
     1       (iqv.lt.1.or.iqvp.lt.1.or.iqv.gt.3.or.iqvp.gt.3))
     2      go to 8160
          CrSystem=3
        else if(ipg.ge.9.and.ipg.le.15) then
          if(MakeCellTest.and.ndim.eq.4.and.
     1       (iqv.ne.3.or.iqvp.ne.3)) go to 8160
          CrSystem=4
        else if(ipg.ge.16.and.ipg.le.27) then
          if(MakeCellTest.and.ndim.eq.4.and.
     1       (iqv.ne.3.or.iqvp.ne.3)) go to 8160
          if(ipg.le.20) then
            CrSystem=5
          else
            CrSystem=6
          endif
        else if(ipg.ge.28.and.ipg.le.32) then
          CrSystem=7
        endif
        if(mod(CrSystem,10).ne.2) Monoclinic=0
        GrupaPom(1:1)=Lattice
        if(itxt(1:1).eq.'-') then
          itxt(2:2)=Lattice
        else
          itxt(1:1)=Lattice
        endif
      else
        StdSmb=.false.
        itxt=GrupaPom
        idl=1
        do 2150i=1,idel(GrupaPom)
          if(GrupaPom(i:i).eq.';') idl=idl+1
2150    continue
        call SetRealArrayTo(ShiftSg,ndim,0.)
      endif
      if(ndim.eq.4) then
        Veta=Grupa(i2+1:)
        call mala(Veta)
        i=0
        n=0
        id=idel(Veta)
2200    i=i+1
        if(i.gt.id) go to 2300
        if(Veta(i:i).eq.'-') then
          if(SmbNew) go to 8100
          i=i+1
          if(Veta(i:i).eq.'1') then
            n=n+1
            ieps(n)=-1
            tau(n)=0
            go to 2200
          else
            go to 8100
          endif
        else
          j=index(smbtau,Veta(i:i))
          if(j.le.0) go to 8100
          if(SmbNew) then
            if(j.eq.1) then
              n=n+1
              ieps(n)=0
              tau(n)=0.
              go to 2200
            else if(j.eq.2) then
              go to 8100
            endif
          else
            if(j.eq.1) go to 8100
          endif
          if(j.ne.6) j=j-1
          n=n+1
          ieps(n)=1
          if(j.ne.1) then
            tau(n)=1./float(j)
          else
            tau(n)=0.
          endif
          go to 2200
        endif
2300    if(n.ne.idl) then
          if(n.gt.idl) then
            Veta=Veta(1:id)//' too long'
          else
            if(SmbNew) then
              do 2320i=n+1,idl
                ieps(i)=0
                tau(i)=0.
2320          continue
              go to 2400
            else
              Veta=Veta(1:id)//' too short'
            endif
          endif
          id=idel(Veta)
          go to 8170
        endif
2400    if(StdSmb) then
          call EM50SetEps(ie,ipor,ieps,tau,idl,ipg,ngrupa,imd,itxt,
     1                    *8130)
          do 2500i=1,idl
            if(ie(i).eq.ieps(i)) then
              go to 2500
            else
              if(ieps(i).eq.0.and.SmbNew) then
                ieps(i)=ie(i)
              else
                go to 8120
              endif
            endif
2500      continue
        endif
      endif
      call EM50GenCentr(itxt,nc,FirstTime,*8110,*9900)
      call EM50GenSymOp(itxt,tau,idl,AskForDelta,*9900)
      if(ndim.eq.4.and.nq.ne.1.and.Lattice.ne.'X') then
        call UnitMat(trm,4)
        do 2600i=1,3
          if(abs(qui(i,1,KPhase)-qu(i,1,1,KPhase)).gt..0001) go to 5000
2600    continue
        if(nq.le.4) then
          trm(1+(nq-2)*5)=2.
          trm(4+(nq-2)*4)=1.
          do 2720i=1,3
            if(i.eq.nq-1) then
              tp(i)=.5
            else
              tp(i)=0.
            endif
2720      continue
          tp(4)=.5
          do 2750i=1,nvt
            do 2740j=1,4
              vt6(j,i+nvt,1,KPhase)=vt6(j,i,1,KPhase)+tp(j)
2740        continue
2750      continue
          nvt=nvt*2
          nc=8
          Lattice='X'
        else if(nq.le.7) then
          trm(4+(nq-5)*4)=1.
          nc=8
          Lattice='X'
        else if(nq.le.10) then
          if(tetra) then
            trm(2)= 1.
            trm(5)=-1.
            trm(4)=1.
            vt6(1,2,1,KPhase)=.5
            vt6(2,2,1,KPhase)=.5
            vt6(3,2,1,KPhase)=0.
            vt6(4,2,1,KPhase)=.5
            nvt=2
            nc=8
            Lattice='X'
          else
            do 2800i=1,3
              tp(i)=0.
              rp(i)=0.
2800        continue
            j=0
            do 2850i=1,3
              if(i.eq.nq-7) go to 2850
              trm(1+(i-1)*5)=2.
              trm(4+(i-1)*4)=1.
              if(j.eq.0) then
                tp(i)=.5
                j=1
              else
                rp(i)=.5
              endif
2850        continue
            tp(4)=.5
            rp(4)=.5
            do 2870i=1,nvt
              do 2860j=1,4
                vt6(j,i+nvt,1,KPhase)  =vt6(j,i,1,KPhase)+tp(j)
                vt6(j,i+2*nvt,1,KPhase)=vt6(j,i,1,KPhase)+rp(j)
                vt6(j,i+3*nvt,1,KPhase)=vt6(j,i,1,KPhase)+tp(j)+rp(j)
2860          continue
2870        continue
            nvt=nvt*4
            vt6(4,nvt,1,KPhase)=0.
            nc=8
            Lattice='X'
          endif
        else if(nq.eq.11) then
          trm(1)=2.
          trm(2)=1.
          trm(5)=-1.
          trm(4)=1.
          vt6(1,2,1,KPhase)=.333333333
          vt6(2,2,1,KPhase)=.666666667
          vt6(3,2,1,KPhase)=.0
          vt6(4,2,1,KPhase)=.666666667
          vt6(1,3,1,KPhase)=.666666667
          vt6(2,3,1,KPhase)=.333333333
          vt6(3,3,1,KPhase)=.0
          vt6(4,3,1,KPhase)=.333333333
          nvt=3
          nc=8
          Lattice='X'
        else
          do 2880i=12,14
            if(i.ne.nq) trm((i-11)*4)=1.
2880      continue
          nc=8
          Lattice='X'
        endif
        call matinv(trm,trmi,pom,4)
        do 3100i=2,ns
          call multm(trmi,s6(1,i,1,KPhase),tp,4,4,1)
          call od0do1(tp,s6(1,i,1,KPhase),4)
          call multm(trmi,rm6(1,i,1,KPhase),rp,4,4,4)
          call multm(rp,trm,rm6(1,i,1,KPhase),4,4,4)
3100    continue
        if((nq.gt.4.and.nq.le.7).or.nq.gt.11) then
          do 3250i=2,nvt
            call multm(trmi,vt6(1,i,1,KPhase),tp,4,4,1)
            call od0do1(tp,vt6(1,i,1,KPhase),4)
3250      continue
        else
          do 3260i=2,nvt
            call od0do1(vt6(1,i,1,KPhase),vt6(1,i,1,KPhase),4)
3260      continue
        endif
        do 3300i=1,3
          quir(i,1,KPhase)=0.
3300    continue
        nq=1
      endif
c5000  if(StdSg(KPhase).ne.1) call EM50OriginShift(ShSg(1,KPhase))
5000  call AddVek(ShSg(1,KPhase),ShiftSg,xsh,ndim)
      call EM50OriginShift(xsh)
      do 5400i=1,ns
        call CodeSym(rm6(1,i,1,KPhase),s6(1,i,1,KPhase),
     1               symmc(1,i,1,KPhase),0)
        do 5300j=1,ndim
          if(index(symmc(j,i,1,KPhase),'?').gt.0) then
            ns=0
            go to 8140
          endif
5300    continue
5400  continue
      ich=0
      go to 9999
8000  if(EventType.ne.EventKartSw.or.
     1   EventNumber.ne.KartIdCell+1-KartFirstId) then
        call FeChybne(-1.,-1.,'cell parameters are not consistent with '
     1              //'space group','try another space group or '//
     2                'change cell parameters',0,SeriousError)
      endif
      ich=2
      go to 9999
8100  write(t80,'(''incorrect additional symbol of the '',i1,a2,
     1            '' generator'')') n+1,nty(n+1)
      go to 8500
8110  t80='the cell centring symbol is not correct'
      go to 8500
8120  write(t80,'(''opposite sign of additional symbol of the '',i1,a2,
     1            '' generator'')') ipor(i),nty(ipor(i))
      go to 8500
8130  t80='the additional symbols are not consistent'
      go to 8500
8140  t80='origin shift is not acceptable'
      go to 8500
8150  t80='neither colon nor parenthesis section found'
      go to 8500
8160  t80='the modulation vector or its symbol is incorrrect'
      go to 8500
8170  t80='the symbol "'//Grupa(:idel(Grupa))//
     1    '" wasn''t found on the list'
8500  if(ndim.eq.4) then
        Veta='incorrect superspace group symbol'
      else
        Veta='incorrect space group symbol'
      endif
      go to 9000
8610  call FeReadError(ln)
      call CloseIfOpened(ln)
8700  call FeGrQuit
      call DeletePomFiles
      call FeTmpFilesDelete
      stop
9000  call FeChybne(-1.,-1.,Veta,t80,0,SeriousError)
9900  ich=1
9999  return
      end
      subroutine EM50GenCentr(itxt,nc,FirstTime,*,*)
      include 'params.cmn'
      include 'basic.cmn'
      character*(*) itxt
      logical FirstTime
      if(itxt(1:1).eq.'-') then
        ncs=1
        itxt=itxt(2:)
      else if(itxt(1:1).eq.'+') then
        ncs=2
        itxt=itxt(2:)
      else
        ncs=2
      endif
      nc=index(smbc,itxt(1:1))
      if(nc.gt.0.and.nc.le.8) then
        call EM50GenVecCentr(nc,FirstTime,ich)
        if(ich.ne.0) return2
      else
        return1
      endif
      Lattice=itxt(1:1)
      itxt=itxt(2:)
      return
      end
      subroutine EM50GenSymOp(itxt,tau,idl,AskForDelta,*)
      include 'params.cmn'
      include 'basic.cmn'
      include 'editm50.cmn'
      include 'fepc.cmn'
      dimension tau(idl),vtp(6),tv(3,8),tvo(3,6),pp(6),pq(3),mpp(3),
     1          sp(6),spp(6)
      character*(*) itxt
      character*2 nty
      character*5 ir
      character*20 ito
      character*80 t80,errtxt
      real NulVek(6)
      logical AskForDelta,eqrv,eqrvm
      data ir/'12346'/,ito/'xyz"''*12345abcnuvwd;'/
      data tv/.5,.0,.0,.0,.5,.0,.0,.0,.5,.5,.5,.5,.25,.0,.0,
     1        .0,.25,.0,.0,.0,.25,.25,.25,.25/
      data tvo/1.,0.,0.,0.,1.,0.,0.,0.,1.,1.,1.,0.,1.,-1.,0.,1.,1.,1./
      data NulVek/6*0./
      Tetra=.false.
      if(ndimi.gt.1) NSymmOld=ns
      ns=1
      call UnitMat(rm6(1,1,1,KPhase),ndim)
      call UnitMat(rm(1,1,1,KPhase),3)
      call SetRealArrayTo(s6(1,1,1,KPhase),ndim,0.)
      call CodeSym(rm6(1,1,1,KPhase),s6(1,1,1,KPhase),
     1             symmc(1,1,1,KPhase),0)
      id=idel(itxt)
1000  if(id.le.0) go to 9999
      if(itxt(1:1).eq.'-') then
        iz=-1
        itxt=itxt(2:)
        id=id-1
      else if(itxt(1:1).eq.'+') then
        iz= 1
        itxt=itxt(2:)
        id=id-1
      else
        iz= 1
      endif
      if(id.le.0) then
        errtxt='rotational information is missing'
        go to 8000
      endif
      nr=index(ir,itxt(1:1))
      itxt=itxt(2:)
      if(nr.le.0) then
        errtxt='incorrect rotational part'
        go to 8000
      else if(nr.eq.1) then
        if(idel(itxt).gt.0) then
          errtxt='incorrect rotational part'
          go to 8000
        else
          go to 5000
        endif
      endif
      Tetra=Tetra.or.nr.eq.4
      ior=-1
      call SetRealArrayTo(vtp,ndim,0.)
      pom=0.
1100  if(idel(itxt).gt.0) then
        i=index(ito,itxt(1:1))
        if(i.gt.0) then
          itxt=itxt(2:)
        else
          errtxt='incorrect orientation or translation part'
          go to 8000
        endif
      else
        i=20
      endif
      if(i.le.6) then
        if(ior.eq.-1) then
          ior=i
          go to 1100
        else
          errtxt='orientation is doubled'
          go to 8000
        endif
      else if(i.le.19) then
        nt=i-6
        if(nt.le.5) then
          p=nr
          if(nr.eq.5) then
            p=6.
          else if(nr.eq.6.or.nr.eq.7) then
            p=2.
          else if(nr.eq.8) then
            p=3.
          endif
          pom=pom+float(nt)/p
        else
          do 1200i=1,3
            vtp(i)=vtp(i)+tv(i,nt-5)
1200      continue
        endif
      else if(i.eq.20) then
        if(ior.lt.0) then
          if(ns.eq.1) then
            ior=3
          else if(ns.eq.2.or.ns.eq.3) then
            if(nr.eq.2.and.(nrold.eq.2.or.nrold.eq.4)) ior=1
            if(nr.eq.2.and.(nrold.eq.3.or.nrold.eq.5)) ior=5
            if(nr.eq.3) ior=6
          endif
        endif
        if(ior.lt.0) then
          errtxt='orientation is not defined'
          go to 8000
        endif
        if(ior.eq.6) then
          if(nr.eq.3) then
            nr=8
            ior=1
          else
            errtxt='operator cannot have this orientation'
            go to 8000
          endif
        else if(ior.eq.4.or.ior.eq.5) then
          if(nr.eq.2) then
            nr=ior+2
            if(ns.ne.1) then
              ior=iorold
            else
              ior=3
            endif
          else
            errtxt='operator cannot have this orientation'
            go to 8000
          endif
        endif
        call EM50SetGen(rmp,nr-1,ior,ndim)
        if(iz.eq.-1) call realMatrixToOpposite(rmp,rmp,ndim)
        do 1400i=1,3
          sp(i)=vtp(i)+pom*tvo(i,ior)
1400    continue
        if(ndim.gt.3) then
          k1=0
          k2=0
          n1=0
          n2=0
          if(ndim.gt.4) then
            k1=-1
            k2= 1
            if(ndim.gt.5) then
              n1=-1
              n2= 1
            endif
          endif
        endif
        if(ndim.eq.4) then
           do 1505j=1,3
            if(abs(qui(j,1,KPhase)).gt..00001)
     1        qui(j,1,KPhase)=qui(j,1,KPhase)+
     1                                sign(sqrt(.02),qui(j,1,KPhase))
1505      continue
        endif
        do 1600i=4,ndim
          do 1540j=1,3
            pom=0.
            do 1535k=1,3
              pom=pom+(qui(k,i-3,KPhase)+quir(k,i-3,KPhase))*
     1                rmp(k+(j-1)*ndim)
1535        continue
            pp(j)=pom
1540      continue
          do 1580n=n1,n2
            do 1570k=k1,k2
              do 1560j=-1,1
                do 1550l=1,3
                  pq(l)=float(j)*(qui(l,1,KPhase)+quir(l,1,KPhase))-
     1                            pp(l)
                  if(ndim.gt.4) pq(l)=pq(l)+float(k)*
     1                                (qui(l,2,KPhase)+quir(l,2,KPhase))
                  if(ndim.gt.5) pq(l)=pq(l)+float(n)*
     1                                (qui(l,3,KPhase)+quir(l,3,KPhase))
                  mpp(l)=nint(pq(l))
                  if(abs(pq(l)-float(mpp(l))).gt..0005) go to 1560
1550            continue
                do 1552ivt=1,nvt
                  pom=ScalMul(vt6(1,ivt,1,KPhase),pq)
                  if(abs(pom-anint(pom)).gt..0005) go to 1560
1552            continue
                do 1556l=1,3
                  rmp(i+ndim*(l-1))=-mpp(l)
1556            continue
                rmp(i+ndim*3)=j
                if(ndim.gt.4)
     1            rmp(i+ndim*4)=k
                if(ndim.gt.5)
     1            rmp(i+ndim*5)=n
                go to 1600
1560          continue
1570        continue
1580      continue
          errtxt='generator inconsistent with the modulation vector'
          go to 8000
1600    continue
        if(ndim.eq.4) then
          do 1605j=1,3
            if(abs(qui(j,1,KPhase)).gt..00001)
     1        qui(j,1,KPhase)=qui(j,1,KPhase)-
     1                                sign(sqrt(.02),qui(j,1,KPhase))
1605      continue
        endif
        call SetRealArrayTo(sp(4),ndimi,0.)
        if(ndimi.gt.1) then
          call NormCentr(sp)
          do 2100i=1,NSymmOld
            if(eqrv(rmp,rm6(1,i,1,KPhase),NDimQ,.001))
     1        go to 2050
            if(ncs.eq.1) then
              if(eqrvm(rmp,rm6(1,i,1,KPhase),NDimQ,.001))
     1          go to 2050
            endif
            go to 2100
2050        call CopyVek(s6(1,i,1,KPhase),spp,ndim)
            call NormCentr(spp)
            call CopyVek(spp(4),sp(4),ndimi)
            go to 2200
2100      continue
        endif
2200    ns=ns+1
        call CopyMat(rmp,rm6(1,ns,1,KPhase),ndim)
        call CopyVek(sp,s6(1,ns,1,KPhase),ndim)
        call MatBlock3(rm6(1,ns,1,KPhase),rm(1,ns,1,KPhase),
     1                 ndim)
        call CodeSym(rm6(1,ns,1,KPhase),s6(1,ns,1,KPhase),
     1               symmc(1,ns,1,KPhase),0)
        if(ndim.gt.3) then
          if(ndim.eq.4) then
            if(Poradi) then
              j=ns-1
            else
              j=mod(ior-1,3)+1
            endif
            s6(4,ns,1,KPhase)=tau(j)+
     1        scalmul(quir(1,1,KPhase),s6(1,ns,1,KPhase))
          else
            if(AskForDelta)
     1        call EM50ReadDelta(rm6(1,ns,1,KPhase),
     2                           s6(1,ns,1,KPhase),
     2                           symmc(1,ns,1,KPhase))
          endif
        endif
        call NormCentr(s6(1,ns,1,KPhase))
        iorold=ior
        nrold=nr
        if(idel(itxt).gt.0) then
          go to 1000
        else
          go to 5000
        endif
      endif
      go to 1100
5000  call CompleteSym(0,ich)
      if(ich.ne.0) go to 8100
      do 5100k=1,ns
        call MatBlock3(rm6(1,k,1,KPhase),rm(1,k,1,KPhase),ndim)
5100  continue
      go to 9999
8000  write(t80,'(''error in the '',i1,a2,'' Hall''''s generator'')')
     1      ns-1,nty(ns-1)
      call FeChybne(-1.,-1.,t80,errtxt(1:idel(errtxt)),0,SeriousError)
8100  return 1
9999  return
      end
      integer function EM50IrrType(q)
      dimension q(3)
      EM50IrrType=0
      do 1000i=1,3
        if(abs(q(i)).gt..0001) EM50IrrType=EM50IrrType+1
1000  continue
      if(EM50IrrType.eq.1) then
        do 1010EM50IrrType=1,3
          if(abs(q(EM50IrrType)).gt..00001) go to 9999
1010    continue
      else if(EM50IrrType.eq.2) then
        do 1020i=1,3
          if(abs(q(i)).le..00001) then
            EM50IrrType=-i
            go to 9999
          endif
1020    continue
      else if(EM50IrrType.eq.3) then
        EM50IrrType=4
      endif
9999  return
      end
      subroutine EM50GenVecCentr(nc,FirstTime,ich)
      include 'params.cmn'
      include 'basic.cmn'
      logical FirstTime
      ich=0
      if(nc.lt.8) then
        nvt=1
        call SetRealArrayTo(vt6(1,1,1,KPhase),mxcen*6,0.)
      endif
      if(nc.gt.1.and.nc.le.5) then
        do 1021i=1,3
          vt6(i,2,1,KPhase)=.5
1021    continue
        if(nc.ne.5) vt6(nc-1,2,1,KPhase)=0.
        nvt=2
      else if(nc.eq.6) then
        nvt=3
        vt6(1,2,1,KPhase)=.666666667
        vt6(2,2,1,KPhase)=.333333333
        vt6(3,2,1,KPhase)=.333333333
        vt6(1,3,1,KPhase)=.333333333
        vt6(2,3,1,KPhase)=.666666667
        vt6(3,3,1,KPhase)=.666666667
      else if(nc.eq.7) then
        nvt=4
        do 1042j=2,4
          do 1041i=1,3
            if(i.ne.j-1) then
              vt6(i,j,1,KPhase)=.5
            else
              vt6(i,j,1,KPhase)=0.
            endif
1041      continue
1042    continue
      else if(nc.eq.8) then
        if(FirstTime) call EM50ReadCellCentr(ich)
      endif
      return
      end
      subroutine EM50SetGen(rm,nr,md,ndim)
      dimension irm(9,7),rm(*)
      data irm/-1,0,0,0,-1,0,0,0,1,0,1,0,-1,-1,0,0,0,1,0,1,0,-1,0,0,
     1         0,0,1,1,1,0,-1,0,0,0,0,1,0,1,0,1,0,0,0,0,-1,0,-1,0,-1,0,0
     2        ,0,0,-1,0,1,0,0,0,1,1,0,0/
      id=md*3
      i1=-3
      mdd=md-1
      call SetRealArrayTo(rm,ndim*ndim,0.)
      do 2000i=1,3
        i1=i1+3
        i1p=mod(i1+id,9)+1
        do 1500j=1,3
          ij=i1+j
          ijp=i1p+mod(j+mdd,3)
          im=(ijp-1)/3+1
          jm=mod(ijp-1,3)+1
          rm(jm+(im-1)*ndim)=irm(ij,nr)
1500    continue
2000  continue
      return
      end
      subroutine EM50SetEps(ie,ipr,ieps,tau,idl,ipg,ig,imd,itxt,*)
      include 'params.cmn'
      include 'basic.cmn'
      include 'editm50.cmn'
      dimension ie(4),ieps(4),tau(4),ipr(4)
      character*(*) itxt
      character*8 t8(3)
      do 500i=1,4
        ipr(i)=i
500   continue
      if(ipg.eq.1.or.ipg.eq.9.or.ipg.eq.21) then
        ie(1)=1
      else if(ipg.eq.2.or.ipg.eq.10.or.ipg.eq.22) then
        ie(1)=-1
      else if(ipg.eq.3.or.ipg.eq.4) then
        iz=7-2*ipg
        if(Monoclinic.eq.iqv) then
          ie(1)= iz
        else
          ie(1)=-iz
        endif
      else if(ipg.eq.5) then
        if(Monoclinic.eq.iqv) then
          ie(1)= 1
          ie(2)=-1
          tau(2)=tau(1)
        else
          ie(1)=-1
          tau(1)=tau(2)
          ie(2)= 1
        endif
      else if(ipg.ge.6.and.ipg.le.8) then
        iz=7-ipg
        if(iz.eq.0) iz=-1
        do 1000i=1,3
          if(i.eq.iqv) then
            ie(i)= iz
          else
            ie(i)=-iz
          endif
1000    continue
        if(ipg.eq.7) ie(imd)=-ie(imd)
        i1=0
        i2=0
        i3=0
        do 1100i=1,3
          if(ie(i).eq.-1) go to 1100
          if(i1.eq.0) then
            i1=i
          else if(i2.eq.0) then
            i2=i
          else if(i3.eq.0) then
            i3=i
          endif
1100    continue
        if(itxt(1:1).eq.'-') then
          kp=2
        else
          kp=1
        endif
        k=kp
        do 1110i=1,idel(itxt)
          if(itxt(i:i).eq.';') itxt(i:i)=' '
1110    continue
        do 1120i=1,3
          call kus(itxt,k,t8(i))
1120    continue
        if(i2.eq.0) then
          i2=i1+1
          if(i2.gt.3) i2=1
        endif
        itxt=itxt(1:kp)//t8(i1)(:idel(t8(i1)))//';'//
     1                   t8(i2)(:idel(t8(i2)))
      else if(ipg.eq.11.or.ipg.eq.23) then
        ie(1)=1
        ie(2)=-1
        tau(2)=tau(1)
      else if(ipg.eq.12.or.ipg.eq.24) then
        ie(1)=1
        ie(2)=-1
        ie(3)=-1
        tau(3)=tau(2)+tau(1)
        if(ig.ge.177) call EM50ChngOrder(ie,ieps,tau,ipr,2,3)
      else if(ipg.eq.13.or.ipg.eq.25) then
        ie(1)=1
        ie(2)=1
        ie(3)=1
        if(abs(tau(1)-.25).lt..0001.and.abs(tau(2)-.25).lt..0001) then
          if(ig.eq.102) then
            if(abs(tau(3)-.5).lt..0001) tau(2)=-.25
          else
            if(abs(tau(3))   .lt..0001) tau(2)=-.25
          endif
        endif
        if(ig.ge.183) call EM50ChngOrder(ie,ieps,tau,ipr,2,3)
      else if(ipg.eq.14.or.ipg.eq.26) then
        ie(1)=-1
        if((ig.ge.115.and.ig.le.120).or.ig.eq.187.or.ig.eq.188) then
          ie(2)=1
          ie(3)=-1
          tau(3)=tau(2)
        else
          ie(2)=-1
          ie(3)=1
          tau(2)=tau(3)
        endif
        if(ig.ge.187) call EM50ChngOrder(ie,ieps,tau,ipr,2,3)
      else if(ipg.eq.15.or.ipg.eq.27) then
        ie(1)=1
        ie(2)=-1
        ie(3)=1
        ie(4)=1
        if(abs(tau(1)-.25).lt..0001.and.abs(tau(3)-.25).lt..0001) then
          if(ig.eq.133.or.ig.eq.134) then
            if(abs(tau(4))   .lt..0001) tau(3)=-.25
          else
            if(abs(tau(4)-.5).lt..0001) tau(3)=-.25
          endif
        endif
        if(ig.ge.191) then
          j=4
        else
          j=3
        endif
        call EM50ChngOrder(ie,ieps,tau,ipr,2,j)
      else if(ipg.eq.16) then
        ie(1)=1
        ieps(1)=1
      else if(ipg.eq.17) then
        ie(1)=1
        ieps(1)=-ieps(1)
        if(ig.eq.162.or.ig.eq.163) call EM50ChngOrder(ie,ieps,tau,ipr,
     1                                                2,3)
      else if(ipg.eq.18) then
        ie(1)=1
        ie(2)=-1
        if(idl.ne.2) ie(3)=1
        if(ig.eq.149.or.ig.eq.151.or.ig.eq.153)
     1    call EM50ChngOrder(ie,ieps,tau,ipr,2,3)
      else if(ipg.eq.19) then
        do 2000i=1,idl
          ie(i)=1
2000    continue
        if(ig.eq.157.or.ig.eq.159)
     1    call EM50ChngOrder(ie,ieps,tau,ipr,2,3)
      else if(ipg.eq.20) then
        do 2100i=1,idl
          ie(i)=1
2100    continue
        ieps(1)=-ieps(1)
        if(ig.eq.162.or.ig.eq.163)
     1    call EM50ChngOrder(ie,ieps,tau,ipr,2,3)
      endif
      return
      end
      subroutine EM50ChngOrder(ie,ieps,tau,ipor,i1,i2)
      dimension ie(4),ieps(4),tau(4),ipor(4)
      ipor(i1)=i2
      ipor(i2)=i1
      i=ieps(i1)
      ieps(i1)=ieps(i2)
      ieps(i2)=i
      i=ie(i1)
      ie(i1)=ie(i2)
      ie(i2)=i
      p=tau(i1)
      tau(i1)=tau(i2)
      tau(i2)=p
      return
      end
      subroutine EM50ReadDelta(rmp,s,SymmString)
      include 'params.cmn'
      include 'basic.cmn'
      include 'fepc.cmn'
      dimension rmp(ndim,ndim),s(ndim)
      character*(*) SymmString(6)
      character*80 Veta,Radka
      Veta=' '
      Veta(ndim*3-1:ndim*3-1)='1'
      Radka='Complete translational part for the operator :'
      xd=max(FeTxLength(Veta)+50.,FeTxLength(Radka)+10.)
      id=NextQuestId()
      call FeQuestCreate(id,-1.,-1.,xd,0,ndim+1,Radka,0,LightGray,-1,0)
      tpom=(xd-FeTxLength(Veta)-30.)*.5
      xpom=tpom+FeTxLength(Veta)+10.
      il=1
      call CodeSym(rmp,s,SymmString,0)
      call MakeSymmSt(Radka,SymmString)
      call FeQuestLabelMake(id,xd*.5,il,Radka,'C')
      il=il+1
      do 1200i=1,ndim
        write(Veta,'(6i3)')(nint(rmp(i,j)),j=1,ndim)
        if(i.le.3) then
          call FeQuestLabelMake(id,tpom,il,Veta,'L')
          call ToFract(s(i),Cislo)
          call FeQuestLabelMake(id,xpom,il,Cislo,'L')
        else
          call FeQuestEdwMake(id,tpom,il,xpom,il,Veta,'L',20.,EdwYd,0)
          if(i.eq.4) nEdwFirst=EdwLastMade
          call FeQuestRealEdwOpen(EdwLastMade,s(i),.false.,.true.)
        endif
        il=il+1
1200  continue
      icont=0
      call FeQuestEvent(id,icont,ich)
      if(ich.eq.0) then
        nEdw=nEdwFirst
        do 1300i=4,ndim
          call FeQuestRealFromEdw(nEdw,s(i))
          nEdw=nEdw+1
1300    continue
      endif
      call FeQuestRemove(id)
      return
      end
      subroutine EM50OriginShift(Shift)
      include 'params.cmn'
      include 'basic.cmn'
      dimension xp(6),Shift(*),Shift2(6)
      logical eqrv
      do 1000i=1,ndim
        Shift2(i)=Shift(i)*2.
1000  continue
      call od0do1(Shift2,Shift2,ndim)
      do 1050i=1,nvt
        if(eqrv(vt6(1,i,1,KPhase),Shift2,ndim,.0001)) go to 1500
1050  continue
      if(ncs.eq.1) then
        do 1400i=1,ns
          call RealMatrixToOpposite(rm6(1,i,1,KPhase),
     1                              rm6(1,i+ns,1,KPhase),ndim)
          call CopyVek(s6(1,i,1,KPhase),s6(1,i+ns,1,KPhase),ndim)
1400    continue
        ns=ns+ns
        ncs=2
      endif
1500  do 2000i=1,ns
        call multm(rm6(1,i,1,KPhase),Shift,xp,ndim,ndim,1)
        do 1900j=1,ndim
          s6(j,i,1,KPhase)=s6(j,i,1,KPhase)-Shift(j)+xp(j)
1900    continue
        call NormCentr(s6(1,i,1,KPhase))
2000  continue
9999  return
      end
      subroutine EM50ReadMonoclinic(MonoclinicDef)
      include 'params.cmn'
      include 'basic.cmn'
      include 'fepc.cmn'
      logical CrwLogicQuest
      id=NextQuestId()
      call FeQuestCreate(id,-1.,-1.,120.,0,2,'Specify the monoclinic '//
     1                   'angle',0,LightGray,0,0)
      call FeQuestCrwMake(id,30.,1,26.,2,'%Alpha','C',CrwgXd,CrwgYd,0,1)
      call FeQuestCrwMake(id,60.,1,56.,2,'%Beta' ,'C',CrwgXd,CrwgYd,0,1)
      call FeQuestCrwMake(id,90.,1,86.,2,'%Gamma','C',CrwgXd,CrwgYd,0,1)
      do 1000i=1,3
        call FeQuestCrwOpen(i,MonoclinicDef.eq.i)
1000  continue
      Monoclinic=MonoclinicDef
      icont=0
      call FeQuestEvent(id,icont,ich)
      if(ich.eq.0) then
        do 1100i=1,3
          if(CrwLogicQuest(i)) then
            Monoclinic=i
            go to 9999
          endif
1100    continue
      endif
9999  call FeQuestRemove(id)
      return
      end
      subroutine EM50ReadCompMat(ich)
      include 'params.cmn'
      include 'basic.cmn'
      character*2 nty
      character*20 Veta
      do 1000i=2,ncomp
        write(Veta,'(i1,a2,'' composite matrix'')') i,nty(i)
        call FeReadRealMat(-1.,-1.,Veta,Indices,IdChangeCase,
     1    zv(1,i,KPhase),zvi(1,i,KPhase),ndim,CheckSingYes,
     2    CheckPosDefNo,ich)
        if(ich.ne.0) go to 9999
1000  continue
9999  return
      end
      subroutine EM50Radiation
      include 'params.cmn'
      include 'basic.cmn'
      include 'fepc.cmn'
      include 'editm50.cmn'
      include 'atoms.cmn'
      dimension fmult(20),xp(2)
      character*256 EdwStringQuest
      character*80 Veta,FormulaNew
      character*2 atp
      integer EdwStateQuest,CrwStateQuest,FeMenu
      logical CrwLogicQuest,FeYesNo,eqrv
      save nCrwRad,nCrwMonSet,nCrwDouble,nButtTarg,nEdwMonAngle,nEdwWL1,
     1     nEdwWL2,nEdwRat,nEdwFormula,nEdwZ,nEdwT,nButtFillFormFactors,
     2     nButtCalculateDensity,nButtCalculateFormula
      entry EM50RadiationMake(id)
      ilp=1
      il=ilp
      tpom=FeTxLengthUnder('%Electrons')+10.
      do 1000i=1,2
        if(i.eq.XRayRadiation) then
          Veta='%X-rays'
        else if(i.eq.NeutronRadiation) then
          Veta='%Neutrons'
        else if(i.eq.ElectronRadiation) then
          Veta='%Electrons'
        endif
        call FeQuestCrwMake(id,5.,il,tpom,il,Veta,'L',CrwgXd,CrwgYd,1,1)
        if(i.eq.1) nCrwRad=CrwLastMade
        call FeQuestCrwOpen(nCrwRad+i-1,Radiation(1).eq.i)
        il=il+1
1000  continue
      tpom=tpom+20.
      xpom=tpom+FeTxLengthUnder('P%erpendicular setting')+5.
      il=ilp
      do 1100i=1,3
        if(i.eq.1) then
          Veta='Pe%rpendicular setting'
        else if(i.eq.2) then
          Veta='%Parallel setting'
        else
          Veta='P%olarized beam'
        endif
        call FeQuestCrwMake(id,tpom,il,xpom,il,Veta,'L',CrwgXd,CrwgYd,
     1                      1,2)
        if(i.eq.1) nCrwMonSet=CrwLastMade
        il=il+1
1100  continue
      Veta='alpha1/alpha2 %doublet'
      call FeQuestCrwMake(id,5.,il,FeTxLengthUnder(Veta)+10.,
     1                    il,Veta,'L',CrwXd,CrwYd,1,0)
      nCrwDouble=CrwLastMade
      if(Radiation(1).eq.XRayRadiation.and.LpFactor(1).lt.3)
     1  call FeQuestCrwOpen(nCrwDouble,NAlfa(1).gt.1)
      xpom=FeTxLengthUnder('%Targets')+10.
      il=il+1
      call FeQuestButtonMake(id,5.,il,xpom,ButYd,'%Targets')
      nButtTarg=ButtonLastMade
      xpom=xdqp-55.
      tpom=xpom+25.
      il=ilp
      call FeQuestEdwMake(id,tpom,il,xpom,il+1,
     1                    'Monochomator an%gle','C',50.,EdwYd,0)
      nEdwMonAngle=EdwLastMade
      tpom=xpom-FeTxLengthUnder('%I(alpha1)/I(alpha2)')-5.
      il=il+3
      call FeQuestEdwMake(id,tpom,il,xpom,il,'Wave length #%1',
     1                    'L',50.,EdwYd,0)
      nEdwWL1=EdwLastMade
      call FeQuestRealEdwOpen(nEdwWL1,LamA1(1),.false.,.false.)
      il=il+1
      call FeQuestEdwMake(id,tpom,il,xpom,il,'Wave length #%2',
     1                    'L',50.,EdwYd,0)
      nEdwWL2=EdwLastMade
      il=il+1
      call FeQuestEdwMake(id,tpom,il,xpom,il,
     1                    '%I(alpha2)/I(alpha1)','L',50.,EdwYd,0)
      nEdwRat=EdwLastMade
      if(CrwLogicQuest(nCrwDouble)) then
        call FeQuestRealEdwOpen(nEdwWL2,LamA2(1),.false.,.false.)
        call FeQuestRealEdwOpen(nEdwRat,LamRat(1),.false.,.false.)
      endif
      il=il+1
      call FeQuestEdwMake(id,tpom,il,xpom,il,'Datcoll t%emperature',
     1                    'L',50.,EdwYd,0)
      nEdwT=EdwLastMade
      call FeQuestRealEdwOpen(nEdwT,DatCollTemp,.false.,.false.)
      il=il+1
      call FeQuestLineMake(id,il)
      il=il+1
      dpom=xdqp-65.
      call FeQuestEdwMake(id,5.,il,60.,il,'%Formula','L',dpom,EdwYd,1)
      nEdwFormula=EdwLastMade
      call FeQuestStringEdwOpen(nEdwFormula,Formula)
      il=il+1
      call FeQuestEdwMake(id,5.,il,60.,il,'Formula %units','L',20.,
     1                    EdwYd,0)
      nEdwZ=EdwLastMade
      if(nz.le.0) then
        if(ns.gt.0.and.nvt.gt.0) then
          nz=nvt*ns*(3-ncs)
        else
          nz=1
        endif
      endif
      call FeQuestIntEdwOpen(nEdwZ,nz,.false.)
      Veta='Fi%ll form factors'
      xpom=FeTxLengthUnder(Veta)+10.
      call FeQuestButtonMake(id,100.,il,xpom,ButYd,Veta)
      nButtFillFormFactors=ButtonLastMade
      if(Formula.eq.' ') then
        i=ButtonDisabled
      else
        i=ButtonOff
      endif
      call FeQuestButtonOpen(nButtFillFormFactors,i)
      il=il+1
      Veta='For%mula from M40'
      call FeQuestButtonMake(id,100.,il,xpom,ButYd,Veta)
      nButtCalculateFormula=ButtonLastMade
      il=il+1
      Veta='%Calculate density'
      call FeQuestButtonMake(id,100.,il,xpom,ButYd,Veta)
      nButtCalculateDensity=ButtonLastMade
      go to 9999
      entry EM50RadiationCheck
      if(CheckType.eq.EventCrw) then
        if(CheckNumber.lt.nCrwMonSet) then
          do 2000i=nCrwRad,nCrwRad+2
            if(CrwLogicQuest(i)) then
              Radiation(1)=i-nCrwRad+1
              if(Radiation(1).ne.XRayRadiation)
     1          call FeQuestCrwClose(nCrwDouble)
              go to 2500
            endif
2000      continue
        else if(CheckNumber.lt.nCrwDouble) then
          do 2010i=nCrwMonSet,nCrwMonSet+2
            if(CrwLogicQuest(i)) then
              LpFactor(1)=i-nCrwMonSet+1
              if(LpFactor(1).eq.3) then
                call FeQuestCrwClose(nCrwDouble)
              else
                if(CrwStateQuest(nCrwDouble).eq.CrwClosed)
     1            call FeQuestCrwOpen(nCrwDouble,.false.)
              endif
              go to 2500
            endif
2010      continue
        else if(CheckNumber.eq.nCrwDouble) then
          go to 2500
        endif
      else if(CheckType.eq.EventEdw) then
        if(CheckNumber.eq.nEdwFormula) then
          Formula=EdwStringQuest(nEdwFormula)
          if(Formula.ne.' ') then
            call PitFor(ich)
            if(ich.ne.0) go to 2100
            call FeQuestButtonOff(nButtFillFormFactors)
            call FeQuestButtonOff(nButtCalculateDensity)
            if(nacalc.gt.0) call FeQuestButtonOff(nButtCalculateFormula)
            go to 9999
2100        EventType=EventEdw
            EventNumber=nEdwFormula
          endif
        endif
      else if(CheckType.eq.EventButton) then
        ib=CheckNumber
        if(CheckNumber.eq.nButtTarg) then
          i=nButtTarg+ButtonFr-1
          klam(1)=FeMenu(ButtonXMax(i)+3.,ButtonYMax(i),LamTypeD,1,7,5,
     1                   1)
          if(klam(1).ge.1.and.klam(1).le.7) then
            if(EdwRealQuest(1,nEdwWL1).ne.LamA1D(klam(1))) then
              call FeQuestrealEdwOpen(nEdwWL1,LamA1D(klam(1)),.false.,
     1                                .false.)
              if(CrwLogicQuest(nCrwDouble)) then
                call FeQuestRealEdwOpen(nEdwWL2,LamA2D(klam(1)),.false.,
     1                                  .false.)
                call FeQuestRealEdwOpen(nEdwRat,LamRatD(klam(1)),.false.
     1                                 ,.false.)
              endif
            endif
            call FeReleaseOutput
            EventType=EventEdw
            EventNumber=nEdwWL1
          else
            icontEM50=0
          endif
        else if(CheckNumber.eq.nButtFillFormFactors) then
          if(nf.gt.0) then
            if(.not.FeYesNo(-1.,-1.,'Do you really want to overwrite '//
     1                      'the old form factor tables?',0)) go to 2320
          endif
          Formula=EdwStringQuest(nEdwFormula)
          if(Formula.ne.' ') then
            call PitFor(ich)
            if(ich.eq.0) go to 2250
          endif
2250      do 2300i=1,NAtFormula
            AtType(i,KPhase)=AtFormula(i,KPhase)
            AtTypeFull(i,KPhase)=AtFormula(i,KPhase)
2300      continue
          nf=NAtFormula
          call EM50ReadAllFormFactors
          LastAtom=1
2320      icontEM50=0
        else if(CheckNumber.eq.nButtCalculateDensity.or.
     1          CheckNumber.eq.nButtCalculateFormula) then
          call FeQuestIntFromEdw(nEdwZ,nz)
          if(CheckNumber.eq.nButtCalculateDensity) then
            Formula=EdwStringQuest(nEdwFormula)
            if(Formula.ne.' ') call PitFor(ich)
            iv=0
            n=NAtFormula
          else
            pom=float(nvt*ns*(3-ncs))/float(nz)
            call SetRealArrayTo(fmult,nf,0.)
            do 2330i=1,nacalc
              if(kswa(i).ne.KPhase) go to 2330
              j=isf(i)
              pomm=ai(i)*pom*CellVol(1,KPhase)/CellVol(iswa(i),KPhase)
              if(kmods(i).gt.0) then
                pomm=pomm*a0(i)
              else if(kfx(i).gt.0) then
                pomm=pomm*uy(2,kmodx(i),i)
              endif
              fmult(j)=fmult(j)+pomm
2330        continue
            do 2340i=1,nf
              if(i.eq.1) then
                FormulaNew=AtType(i,KPhase)
              else
                FormulaNew=FormulaNew(:idel(FormulaNew)+1)//
     1               AtType(i,KPhase)(:idel(AtType(i,KPhase)))
              endif
              if(abs(fmult(i)-1.).lt..0001) go to 2340
              write(Cislo,'(f15.3)') fmult(i)
              call ZdrcniCisla(Cislo,1)
              FormulaNew=FormulaNew(:idel(FormulaNew))//
     1                   Cislo(:idel(Cislo))
2340        continue
            write(TextInfo(1),'(''Formula from M40 : '',a)')
     1        FormulaNew(:idel(FormulaNew))
            iv=1
            n=nf
          endif
          wmol=0.
          ami=0.
          if(ExistM94) then
            nzp=nz
            ncompp=ncomp
            pom=CellVol(1,KPhase)
            call iom94(0)
            CellVol(1,KPhase)=pom
            nz=nzp
            ncomp=ncompp
          else
            call SetRealArrayTo(AtAbsCoeff(1,KPhase),20,0.)
            AtAbsCoeffOwn(KPhase)=.false.
          endif
          do 2350i=1,n
            if(CheckNumber.eq.nButtCalculateDensity) then
              call RealFromAtomFile(AtFormula(i,KPhase),'atweight',pomw,
     1                              0,ich)
              atp=AtFormula(i,KPhase)
              pomm=AtMult(i,KPhase)
            else
              pomw=AtWeight(i,KPhase)
              pomm=fmult(i)
              atp=AtType(i,KPhase)
            endif
            if(.not.AtAbsCoeffOwn(KPhase))
     1        call CrlReadAbsCoeff(Atp,AtAbsCoeff(i,KPhase),ich)
            wmol=wmol+pomw*pomm
            ami=ami+AtAbsCoeff(i,KPhase)*pomm*.1
2350      continue
          iv=iv+1
          write(TextInfo(iv),'(''Molecular weight : '',f8.2)') wmol
          dx=float(nz)*wmol*1.66/CellVol(1,KPhase)
          iv=iv+1
          write(TextInfo(iv),'(''Calculated density ='',f8.4,
     1                         '' g.cm**(-3)'')') dx
          ami=ami*float(nz)/CellVol(1,KPhase)
          iv=iv+1
          TextInfo(iv)='Absorption coefficient mi'
          if(Radiation(1).eq.XRayRadiation) then
            if(klam(1).gt.0) then
              write(Veta,'(''('',a2,''-Kalfa) ='',f9.3,'' mm**-1'')')
     1          LamTypeD(klam(1)),ami
            else
              write(Veta,'('' ='',f9.3,'' mm**-1'')') ami
            endif
          else if(Radiation(1).eq.NeutronRadiation) then
            write(Veta,'('' ='',f9.6,'' mm**-1'')') ami
          endif
          TextInfo(iv)=TextInfo(iv)(:idel(TextInfo(iv)))//
     1                 Veta(:idel(Veta))
          Ninfo=iv
          call FeInfoOut(-1.,-1.,'INFORMATION')
          if(CheckNumber.eq.nButtCalculateFormula.and.
     1       .not.eqrv(AtMult(1,KPhase),fmult,nf,.001)) then
            if(FeYesNo(-1.,-1.,'Do you want to update the formula '//
     1                      'correspondingly?',0)) then
              call CopyVek(fmult,AtMult(1,KPhase),nf)
              Formula=FormulaNew
              call FeQuestStringEdwOpen(nEdwFormula,Formula)
            endif
          endif
          icontEM50=0
        else
          icontEM50=0
        endif
        call FeQuestButtonOpen(ib,ButtonOff)
      else if(CheckType.ne.0.and.CheckNumber.ne.0) then
        call NebylOsetren
      endif
      go to 9999
      entry EM50RadiationRefresh
2500  if(Radiation(1).eq.XRayRadiation) then
        do 2510i=nCrwMonSet,nCrwMonSet+2
          call FeQuestCrwOpen(i,i-nCrwMonSet+1.eq.LpFactor(1))
2510    continue
      else if(Radiation(1).eq.NeutronRadiation) then
        do 2520i=nCrwMonSet,nCrwMonSet+2
          call FeQuestCrwClose(i)
2520    continue
        LpFactor(1)=3
      endif
      if(Radiation(1).eq.XRayRadiation.and.
     1  .not.CrwLogicQuest(nCrwMonSet+2)) then
        if(EdwStateQuest(nEdwMonAngle).ne.EdwOpened)
     1    call FeQuestRealEdwOpen(nEdwMonAngle,UhMon(1),.false.,
     2                            .false.)
        call FeQuestButtonOpen(nButtTarg,ButtonOff)
      else
        call FeQuestEdwClose(nEdwMonAngle)
        call FeQuestButtonClose(nButtTarg)
      endif
      if(CrwStateQuest(nCrwDouble).ne.CrwClosed) then
        klam(1)=LocateInArray(EdwRealQuest(1,nEdwWL1),LamA1D,7,.0001)
        if(CrwLogicQuest(nCrwDouble)) then
          if(EdwStateQuest(nEdwWL2).ne.EdwOpened) then
            if(klam(1).gt.0) then
              call FeQuestRealEdwOpen(nEdwWL2,LamA2D(klam(1)),.false.,
     1                                .false.)
              call FeQuestRealEdwOpen(nEdwRat,LamRatD(klam(1)),
     1                                .false.,.false.)
            else
              call FeQuestRealEdwOpen(nEdwWL2,EdwRealQuest(1,nEdwWL1),
     1                                .false.,.false.)
              call FeQuestRealEdwOpen(nEdwRat,.5,.false.,.false.)
            endif
            EventType=EventEdw
            EventNumber=nEdwWL2
          else
            icontEM50=0
          endif
        else
          call FeQuestEdwClose(nEdwWL2)
          call FeQuestEdwClose(nEdwRat)
          icontEM50=0
          klam(1)=0
        endif
      else
        call FeQuestEdwClose(nEdwWL2)
        call FeQuestEdwClose(nEdwRat)
        icontEM50=0
        klam(1)=0
      endif
      if(Formula.eq.' ') then
        i=ButtonDisabled
      else
        i=ButtonOff
      endif
      call FeQuestButtonOpen(nButtCalculateDensity,i)
      if(i.eq.ButtonOff.and.nacalc.le.0) i=ButtonDisabled
      call FeQuestButtonOpen(nButtCalculateFormula,i)
      go to 9999
      entry EM50RadiationUpdate
      if(CrwLogicQuest(nCrwDouble)) then
        NAlfa(1)=2
      else
        NAlfa(1)=1
      endif
      if(EdwStateQuest(nEdwMonAngle).eq.EdwOpened)
     1  call FeQuestRealFromEdw(nEdwMonAngle,UhMon(1))
      call FeQuestRealFromEdw(nEdwWL1,LamA1(1))
      LamAve(1)=LamA1(1)
      if(NAlfa(1).gt.1) then
        call FeQuestRealFromEdw(nEdwWL2,LamA2(1))
        call FeQuestRealFromEdw(nEdwRat,LamRat(1))
        LamAve(1)=(LamAve(1)+LamRat(1)*LamA2(1))/(1.+LamRat(1))
        klam(1)=LocateInArray(LamAve(1),LamAveD,7,.0001)
      else
        klam(1)=LocateInArray(LamA1(1),LamA1D,7,.0001)
      endif
      if(nlam.le.0) nlam=1
      call FeQuestRealFromEdw(nEdwT,DatCollTemp)
      Formula=EdwStringQuest(nEdwFormula)
      call FeQuestIntFromEdw(nEdwZ,nz)
9999  return
      end
      subroutine EM50FormFactors
      include 'params.cmn'
      include 'basic.cmn'
      include 'fepc.cmn'
      include 'editm50.cmn'
      dimension ff(62),tlabel(2),popc(6),popv(6)
      character*256 EdwStringQuest
      character*80 Veta
      character*16 MenuWF(2)
      character*7  Label(2),AtTypePom
      integer CrwStateQuest,EdwStateQuest,FeMenu,RadiationLast
      logical EqIgCase,Novy,CrwLogicQuest,MameVodik,ExistWaveF
      save xqc,nButtDefault,nButtInsert,nButtDelete,nButtMore,
     1     RadiationLast,ntp,nCrwFFp40,nCrwFFm9,nCrwFFm62,
     2     nCrwMultipole,nCrwSDS,nCrwClementi,tlabel,ilp,
     3     nDownWaveFile,nUpDownColor
      data Label/'CORE','VALENCE'/
      data MenuWF/'wavefc.dat','wavef.dat'/
      entry EM50FormFactorsMake(id)
      xqd=(QuestXMax(id)-QuestXMin(id))
      if(ntab.eq.0.and.nf.eq.0) ntab=-62
      do 1000i=nf+1,20
        AtTypeFull(i,KPhase)=' '
1000  continue
      xqc=(QuestXMax(id)-QuestXMin(id))*.5
      il=1
      Veta='%Multipole refinement'
      xpom=5.
      tpom=xpom+CrwXd+3.
      call FeQuestCrwMake(id,tpom,il,xpom,il,Veta,'L',CrwXd,CrwYd,1,0)
      nCrwMultipole=CrwLastMade
      xpom=tpom+FeTxLengthUnder(Veta)+5.
      tpom=xpom+CrwXd+3.
      Veta='%Use cvf file'
      call FeQuestCrwMake(id,tpom,il,xpom,il,Veta,'L',CrwXd,CrwYd,1,0)
      nCrwFromFile=CrwLastMade
      dpom=20.
      do 1050i=1,2
        dpom=max(dpom,FeTxLengthUnder(MenuWF(i))+10.*EdwIndSize)
1050  continue
      xpom=tpom+FeTxLengthUnder(Veta)+5.
      Veta='%Wave file'
      pom=FeXPixRound(xpom)+FeXPixRound(dpom)+5.*PixelX
      tpom=pom+UpDownXd+5.
      call FeQuestEdwMake(id,tpom,il,xpom,il,Veta,'L',dpom,EdwYd,0)
      nEdwWaveFile=EdwLastMade
      call FeQuestUpDownMake(id,pom,il,UpDownXd,UpDownYd,'down')
      nDownWaveFile=UpDownLastMade
      il=il+1
      tpom=5.
      Veta='%#'
      xpom=tpom+FeTxLengthUnder(Veta)+5.+EdwYd
      call FeQuestEudMake(id,tpom,il,xpom,il,Veta,'L',15.,EdwYd,1)
      nEdwNo=EdwLastMade
      call FeQuestIntEdwOpen(nEdwNo,1,.false.)
      call FeQuestEudOpen(nEdwNo,1,nf,1,0.,0.,0.)
      Veta='%Type'
      tpom=xpom+20.+2.*EdwYd
      xpom=tpom+FeTxLengthUnder(Veta)+2.
      xpom1=xpom
      dpom=35.
      call FeQuestEdwMake(id,tpom,il,xpom,il,Veta,'L',dpom,EdwYd,1)
      nEdwType=EdwLastMade
      Veta='%Weight'
      tpom=xpom+40.
      xpom=tpom+FeTxLengthUnder(Veta)+2.
      xpom2=xpom
      call FeQuestEdwMake(id,tpom,il,xpom,il,Veta,'L',dpom,EdwYd,0)
      nEdwWeight=EdwLastMade
      Veta='%Radius'
      tpom=xpom+40.
      xpom=tpom+FeTxLengthUnder(Veta)+2.
      xpom3=xpom
      call FeQuestEdwMake(id,tpom,il,xpom,il,Veta,'L',dpom,EdwYd,0)
      nEdwRadius=EdwLastMade
      il=il+1
      Veta='f%'''
      tpom=xpom1-FeTxLengthUnder(Veta)-2.
      call FeQuestEdwMake(id,tpom,il,xpom1,il,Veta,'L',dpom,EdwYd,0)
      nEdwPrime=EdwLastMade
      Veta='f%"'
      tpom=xpom2-FeTxLengthUnder(Veta)-2.
      call FeQuestEdwMake(id,tpom,il,xpom2,il,Veta,'L',dpom,EdwYd,0)
      nEdwDoublePrime=EdwLastMade
      Veta='b%coh'
      tpom=xpom1-FeTxLengthUnder(Veta)-2.
      call FeQuestEdwMake(id,tpom,il,xpom1,il,Veta,'L',dpom,EdwYd,0)
      nEdwBCoh=EdwLastMade
      Veta='b%incoh'
      tpom=xpom2-FeTxLengthUnder(Veta)-2.
      call FeQuestEdwMake(id,tpom,il,xpom2,il,Veta,'L',dpom,EdwYd,0)
      nEdwBIncoh=EdwLastMade
      Veta='%Color'
      tpom=xpom3-FeTxLengthUnder(Veta)-2.
      call FeQuestEdwMake(id,tpom,il,xpom3,il,Veta,'L',dpom,EdwYd,0)
      nEdwColor=EdwLastMade
      xpom=FeXPixRound(xpom)+FeXPixRound(dpom)+5.*PixelX
      call FeQuestUpDownMake(id,xpom,il,UpDownXd,UpDownYd,'down')
      nUpDownColor=UpDownLastMade
      call FeQuestUpDownOpen(UpDownLastMade,UpDownOff)
      tpom=20.
      ilp=il+1
      if(ntab.eq.-62) then
        ntp=1
      else if(ntab.eq.-9) then
        ntp=3
      else
        ntp=2
      endif
      do 1100i=1,3
        il=il+1
        if(i.eq.1) then
          Veta='from IT Vol.C 6.1.1.%1-6.1.1.3'
        else if(i.eq.2) then
          Veta='from IT Vol.C 6.1.1.1-6.1.1.3 - equidistant step 0.05'
        else if(i.eq.3) then
          Veta='from IT Vol.C 6.1.1.%4 - analytical form'
        endif
        call FeQuestCrwMake(id,tpom,il,5.,il,Veta,'L',CrwgXd,CrwgYd,1,1)
        if(i.eq.1) then
          nCrwFFm62=CrwLastMade
        else if(i.eq.2) then
          nCrwFFp121=CrwLastMade
        else if(i.eq.3) then
          nCrwFFm9=CrwLastMade
        endif
1100  continue
      il=ilp
      xpom=5.
      do 1120i=1,3
        tpom=xpom+CrwXd+5.
        if(i.eq.1) then
          Veta='%SDS form factor'
        else if(i.eq.2) then
          Veta='S%later form factor'
          xpom0=xpom
        else
          Veta='%Clementi function'
        endif
        call FeQuestCrwMake(id,tpom,il,xpom,il,Veta,'L',CrwgXd,CrwgYd,1,
     1                      2)
        if(i.eq.1) then
          nCrwSDS=CrwLastMade
        else if(i.eq.3) then
          nCrwClementi=CrwLastMade
        endif
        xpom=xpom+xdq*.333333
1120  continue
      il=il+1
      dpom=40.
      xpom=xpom0
      tpom=xpom+45.
      do 1130i=1,2
        if(i.eq.1) then
          Veta='%H-N'
        else
          Veta='H-Dz%eta'
        endif
        call FeQuestEdwMake(id,tpom,il,xpom,il,Veta,'L',40.,EdwYd,0)
        if(i.eq.1) then
          nEdwHN=EdwLastMade
        else
          nEdwHDzeta=EdwLastMade
        endif
        il=il+1
1130  continue
      nEdwPopFirst=EdwLastMade+1
      tpom=3.
      xpom=13.
      tpom0=3.
      xpom0=13.
      do 1250i=1,2
        il=ilp
        tlabel(i)=xqd*(.25+float(i-1)*.5)
        il=il+1
        if(ChargeDensities) then
          call FeQuestLabelMake(id,tlabel(i),il,Label(i),'C')
        endif
        if(i.eq.1) then
          call FeQuestButtonMake(id,xdq*.5-15.,il,30.,ButYd,'%More')
          nButtMore=ButtonLastMade
        endif
        do 1200j=1,4
          il=ilp+1
          do 1150k=1,j
            il=il+1
            write(Veta,'(i1,a1)') j,OrbitName(k)
            call FeQuestEdwMake(id,tpom,il,xpom,il,Veta,'L',14.,
     1                          EdwYd,0)
1150      continue
          tpom=tpom+29.
          xpom=xpom+29.
1200    continue
        if(i.eq.2) go to 1250
        tpom=tpom0+xqd*.5
        xpom=xpom0+xqd*.5
1250  continue
      il=il+1
      Veta='%Dzeta-Slater'
      tpom=5.
      xpom=tpom+FeTxLengthUnder(Veta)+2.
      dpom=160.
      call FeQuestEdwMake(id,tpom,il,xpom,il,Veta,'L',dpom,EdwYd,0)
      nEdwDzeta=EdwLastMade
      il=il+1
      Veta='%N-Slater'
      call FeQuestEdwMake(id,tpom,il,xpom,il,Veta,'L',dpom,EdwYd,0)
      nEdwNSlater=EdwLastMade
      il=12
      xpom=xqc-100.
      call FeQuestButtonMake(id,xpom,il,60.,ButYd,'In%sert new')
      nButtInsert=ButtonLastMade
      call FeQuestButtonOpen(nButtInsert,ButtonOff)
      xpom=xpom+70.
      call FeQuestButtonMake(id,xpom,il,60.,ButYd,'%Delete')
      nButtDelete=ButtonLastMade
      call FeQuestButtonOpen(nButtDelete,ButtonOff)
      xpom=xpom+70.
      call FeQuestButtonMake(id,xpom,il,60.,ButYd,'Set %to default')
      nButtDefault=ButtonLastMade
      call FeQuestButtonOpen(nButtDefault,ButtonOff)
      LastAtom=1
      KartId=id
      RadiationLast=Radiation(1)
      go to 2000
      entry EM50FormFactorsRefresh(n)
      call FeQuestIntEdwOpen(nEdwNo,n,.false.)
      call FeQuestEudOpen(nEdwNo,1,nf,1,0.,0.,0.)
      LastAtom=n
2000  Novy=AtTypeFull(LastAtom,KPhase).eq.' '
      if(Radiation(1).ne.RadiationLast) then
        do 2010i=1,nf,1
          call EM50FormFactorsFromFile(AtTypeFull(i,KPhase),i,1)
2010    continue
      endif
      call FeQuestStringEdwOpen(nEdwType,AtTypeFull(LastAtom,KPhase))
      call FeQuestRealEdwOpen(nEdwWeight,AtWeight(LastAtom,KPhase),
     1                        Novy,.false.)
      call FeQuestRealEdwOpen(nEdwRadius,AtRadius(LastAtom,KPhase),
     1                        Novy,.false.)
      call FeQuestStringEdwOpen(nEdwColor,AtColor(LastAtom,KPhase))
      if(Radiation(1).eq.XRayRadiation) then
        if(RadiationLast.eq.NeutronRadiation) then
          call FeQuestEdwClose(nEdwBCoh)
          call FeQuestEdwClose(nEdwBIncoh)
        endif
        call FeQuestRealEdwOpen(nEdwPrime,ffr(LastAtom,KPhase),Novy,
     1                          .false.)
        call FeQuestRealEdwOpen(nEdwDoublePrime,ffi(LastAtom,KPhase),
     1                          Novy,.false.)
        if(ndimi.le.0) call FeQuestCrwOpen(nCrwMultipole,
     1                                     ChargeDensities)
        MameVodik=EqIgCase(AtType(LastAtom,KPhase),'H')
        TypVodiku=3
        if(ChargeDensities) then
          if(MameVodik) then
            if(PopVal(1,LastAtom,KPhase).eq.-1) then
              TypVodiku=1
            else if(PopVal(1,LastAtom,KPhase).eq.-2) then
              TypVodiku=2
            else
              TypVodiku=3
            endif
          endif
          if(CrwStateQuest(nCrwFromFile).eq.CrwClosed)
     1      call FeQuestCrwOpen(nCrwFromFile,AllowToReadCVF)
          if(EdwStateQuest(nEdwWaveFile).eq.EdwClosed) then
            call FeQuestStringEdwOpen(nEdwWaveFile,NameOfWaveFile)
            call FeQuestUpDownOpen(nDownWaveFile,UpDownOff)
          endif
          call FeQuestIntAEdwOpen(nEdwNSlater,
     1                            NSlater(1,LastAtom,KPhase),8,.false.)
          call FeQuestRealAEdwOpen(nEdwDzeta,
     1                             DzSlater(1,LastAtom,KPhase),8,
     2                             .false.,.false.)
          do 2020i=nCrwFFm62,nCrwFFm9
            call FeQuestCrwClose(i)
2020      continue
        else
          call FeQuestCrwClose(nCrwFromFile)
          call FeQuestEdwClose(nEdwNSlater)
          call FeQuestEdwClose(nEdwDzeta)
          call FeQuestEdwClose(nEdwWaveFile)
          call FeQuestUpDownClose(nDownWaveFile)
        endif
        if(TypVodiku.ne.2) then
          call FeQuestEdwClose(nEdwHN)
          call FeQuestEdwClose(nEdwHDzeta)
        endif
        nEdw=nEdwPopFirst
        do 2050i=1,2
          if(.not.ChargeDensities.or.TypVodiku.ne.3) then
            call FeQuestLabelRemove(KartId,tlabel(i),ilp+1,Label(i),'C')
            call FeQuestButtonClose(nButtMore)
          else
            call FeQuestLabelMake(KartId,tlabel(i),ilp+1,Label(i),'C')
            call FeQuestButtonOpen(nButtMore,ButtonOff)
          endif
          nn=0
          do 2040j=1,4
            do 2030k=1,j
              nn=nn+1
              if(.not.ChargeDensities.or.TypVodiku.ne.3) then
                call FeQuestEdwClose(nEdw)
              else
                call FeQuestIntEdwOpen(nEdw,
     1                         PopAll(nn,LastAtom,KPhase,i),Novy)
              endif
              nEdw=nEdw+1
2030        continue
2040      continue
2050    continue
        nCrw=nCrwSDS
        do 2055i=1,3
          if(MameVodik.and.ChargeDensities) then
            call FeQuestCrwOpen(nCrw,TypVodiku.eq.i)
          else
            call FeQuestCrwClose(nCrw)
          endif
          nCrw=nCrw+1
2055    continue
        if(MameVodik) then
          if(TypVodiku.eq.2) then
            call FeQuestIntEdwOpen(nEdwHN,HNSlater(LastAtom,KPhase),
     1                             .false.)
            call FeQuestRealEdwOpen(nEdwHDzeta,
     1                              HDzSlater(LastAtom,KPhase),.false.,
     2                              .false.)
          endif
        endif
        if(.not.ChargeDensities) then
          nCrw=nCrwFFm62
          do 2070i=1,3
            call FeQuestCrwOpen(nCrw,i.eq.ntp)
            nCrw=nCrw+1
2070      continue
        endif
      else if(Radiation(1).eq.NeutronRadiation) then
        if(RadiationLast.eq.XRayRadiation) then
          call FeQuestEdwClose(nEdwPrime)
          call FeQuestEdwClose(nEdwDoublePrime)
          do 2080i=nCrwFFm62,nCrwFFm9
            call FeQuestCrwClose(i)
2080      continue
          call FeQuestCrwClose(nCrwMultipole)
          if(ChargeDensities) then
            call FeQuestCrwClose(nCrwFromFile)
            call FeQuestEdwClose(nEdwNSlater)
            call FeQuestEdwClose(nEdwDzeta)
            call FeQuestEdwClose(nEdwWaveFile)
            call FeQuestUpDownClose(nDownWaveFile)
            call FeQuestEdwClose(nEdwHN)
            call FeQuestEdwClose(nEdwHDzeta)
            nCrw=nCrwSDS
            do 2081i=1,3
              call FeQuestCrwClose(nCrw)
              nCrw=nCrw+1
2081        continue
            nEdw=nEdwPopFirst
            do 2085i=1,2
              call FeQuestLabelRemove(KartId,tlabel(i),ilp+1,Label(i),
     1                                'C')
              do 2084j=1,4
                do 2083k=1,j
                  call FeQuestEdwClose(nEdw)
                  nEdw=nEdw+1
2083            continue
2084          continue
2085        continue
            call FeQuestButtonClose(nButtMore)
            ChargeDensities=.false.
          endif
        endif
        call FeQuestRealEdwOpen(nEdwBCoh,ffn(LastAtom,KPhase),Novy,
     1                          .false.)
        call FeQuestRealEdwOpen(nEdwBIncoh,ffni(LastAtom,KPhase),Novy,
     1                          .false.)
      endif
      RadiationLast=Radiation(1)
      go to 9999
      entry EM50FormFactorsCheck
      if((CheckType.eq.EventEdw.and.CheckNumber.eq.nEdwNo).or.
     1    CheckType.eq.EventKartSw) then
        call EM50FormFactorsReadEdw
        call FeQuestIntFromEdw(nEdwNo,LastAtom)
        go to 2000
      else if(CheckType.eq.EventButton.and.CheckNumber.eq.nButtMore)
     1  then
        call EM50FormFactorsReadEdw
        call EM50PopOrbMore
        EventType=EventEdw
        EventNumber=nEdwType
        call FeQuestButtonOff(nButtMore)
        go to 2000
      else if(CheckType.eq.EventButton.and.CheckNumber.eq.nButtDelete)
     1  then
        do 2100i=LastAtom,nf-1
          call CopyAtomFormFactors(i+1,i)
2100    continue
        nf=nf-1
        LastAtom=min(LastAtom,nf)
        call FeQuestIntEdwOpen(nEdwNo,LastAtom,.false.)
        call FeQuestEudOpen(nEdwNo,1,nf,1,0.,0.,0.)
        EventType=EventEdw
        EventNumber=nEdwType
        call FeQuestButtonOff(CheckNumber)
        go to 2000
      else if(CheckType.eq.EventCrw.and.CheckNumber.eq.nCrwMultipole)
     1  then
        ChargeDensities=CrwLogicQuest(nCrwMultipole)
        if(ChargeDensities) then
          ntab=121
          ntp=2
        else
          ntab=-62
          ntp=1
        endif
        call EM50ReadAllFormFactors
        EventType=EventEdw
        EventNumber=nEdwType
        go to 2000
      else if(CheckType.eq.EventCrw.and.CheckNumber.eq.nCrwFFp121) then
        ntab=121
        ntp=2
        EventType=EventEdw
        EventNumber=nEdwType
      else if(CheckType.eq.EventCrw.and.CheckNumber.eq.nCrwFFm9) then
        ntab=-9
        ntp=3
        EventType=EventEdw
        EventNumber=nEdwType
      else if(CheckType.eq.EventCrw.and.CheckNumber.eq.nCrwFFm62) then
        ntab=-62
        ntp=1
        EventType=EventEdw
        EventNumber=nEdwType
      else if(CheckType.eq.EventCrw.and.CheckNumber.ge.nCrwSDS.and.
     1        CheckNumber.le.nCrwClementi) then
        nCrw=nCrwSDS
        do 2200i=1,3
          if(CrwLogicQuest(nCrw)) then
            if(i.le.2) then
              PopVal(1,LastAtom,KPhase)=-i
              if(i.eq.2) then
                HNSlater(LastAtom,KPhase)=0
                HDzSlater(LastAtom,KPhase)=2.3
              endif
            else
              call SetIntArrayTo(PopCore(1,LastAtom,KPhase),28,0)
              call SetIntArrayTo(PopVal(1,LastAtom,KPhase),28,0)
              PopVal(1,LastAtom,KPhase)=1
            endif
            go to 2210
          endif
          nCrw=nCrw+1
2200    continue
2210    EventType=EventEdw
        EventNumber=nEdwType
        go to 2000
      else if(CheckType.eq.EventButton.and.CheckNumber.eq.nButtInsert)
     1  then
        do 2500i=nf,LastAtom+1,-1
          call CopyAtomFormFactors(i,i+1)
2500    continue
        LastAtom=LastAtom+1
        nf=nf+1
        call ClearAtomFormFactor(LastAtom)
        call FeQuestIntEdwOpen(nEdwNo,LastAtom,.false.)
        call FeQuestEudOpen(nEdwNo,1,nf,1,0.,0.,0.)
        EventType=EventEdw
        EventNumber=nEdwType
        call FeQuestButtonOff(CheckNumber)
        go to 2000
      else if((CheckType.eq.EventEdw.and.CheckNumber.eq.nEdwType).or.
     1        (CheckType.eq.EventButton.and.CheckNumber.eq.nButtDefault)
     2        ) then
        AtTypePom=EdwStringQuest(nEdwType)
        call UprAt(AtTypePom)
        if(.not.EqIgCase(AtTypePom,AtTypeFull(LastAtom,KPhase)).or.
     1     CheckType.eq.EventButton) then
          call EM50FormFactorsFromFile(AtTypePom,LastAtom,0)
          if(LastAtom.gt.nf) then
            nf=nf+1
            call FeQuestEudOpen(nEdwNo,1,nf,1,0.,0.,0.)
          endif
        endif
        AtTypeFull(LastAtom,KPhase)=AtTypePom
        call GetPureAtType(AtTypePom,AtType(LastAtom,KPhase))
        call FeQuestStringEdwOpen(nEdwType,AtTypePom)
        if(CheckType.eq.EventButton) then
          EventType=EventEdw
          EventNumber=nEdwType
          call FeQuestButtonOff(CheckNumber)
        endif
        go to 2000
      else if(CheckType.eq.EventCrw.and.CheckNumber.eq.nCrwFromFile)
     1  then
        AllowToReadCVF=.not.AllowToReadCVF
        EventType=EventEdw
        EventNumber=nEdwType
        go to 2000
      else if(CheckType.eq.EventUpDown.and.
     1        CheckNumber.eq.nDownWaveFile) then
        i=FeMenu(EdwXMinQuest(nEdwWaveFile),EdwYMinQuest(nEdwWaveFile),
     1           MenuWF,1,2,1,1)
        if(i.gt.0) then
          NameOfWaveFile=MenuWF(i)
          call FeQuestStringEdwOpen(nEdwWaveFile,NameOfWaveFile)
        endif
        call FeQuestUpDownOff(nDownWaveFile)
        EventType=EventEdw
        EventNumber=nEdwWaveFile
      else if(CheckType.eq.EventUpDown.and.CheckNumber.eq.nUpDownColor)
     1  then
        ypom=EdwYMinQuest(nEdwColor)-float(PocetBarev-1)*MenuLineWidth
        icolor=FeMenu(EdwXminQuest(nEdwColor)+2.5,ypom,ColorNames,1,
     1                PocetBarev,icolor,1)
        call FeQuestUpDownOff(nUpDownColor)
        if(icolor.le.0) icolor=ColorOrder('White')
        EventType=EventEdw
        EventNumber=nEdwColor
        AtColor(LastAtom,KPhase)=ColorNames(icolor)
        go to 2000
      else if(CheckType.ne.0) then
        call NebylOsetren
      endif
      go to 9999
      entry EM50FormFactorsUpDate
      if(KartId.eq.KartIdFormFactors) call EM50FormFactorsReadEdw
      if(Radiation(1).eq.XRayRadiation) then
        if(ntab.gt.0.or.ntab.eq.-62.or.ntab.eq.-56) then
          Veta='Xray_form_factor_in_steps'
          nt=62
        else if(ntab.eq.-9) then
          Veta='Xray_form_factor_analytical'
          nt=9
        endif
        ExistWaveF=.true.
        do 5000i=1,nf
          call RealAFromAtomFile(AtTypeFull(i,KPhase),Veta,ff,nt,ich)
          if(ich.ne.0) then
            call FeReleaseOutput
            call FeDeferOutput
            go to 9999
          endif
          if(ntab.gt.0) then
            call TableFFToEquidistant(ff,FFAllR(1,i,KPhase,1),
     1                                AtTypeFull(i,KPhase))
          else if(ntab.eq.-9) then
            call CopyVek(ff,FFAllR(2,i,KPhase,1),nt)
          else if(ntab.eq.-62) then
            call CopyVek(ff,FFAllR(1,i,KPhase,1),nt)
          else
            call CopyVek(ff,FFAllR(1,i,KPhase,1),nt)
          endif
          if(ChargeDensities.and.ExistWaveF) then
            ntab=121
            if(EqIgCase(AtType(i,KPhase),'H')) then
              if(PopVal(1,i,KPhase).eq.-1) then
                call RealAFromAtomFile(AtType(i,KPhase),Veta,ff,62,ich)
                call TableFFToEquidistant(ff,FFAllR(1,i,KPhase,3),
     1                                    AtType(i,KPhase))
                go to 5000
              else if(PopVal(1,i,KPhase).eq.-2) then
                s=0.
                pomk=HDzSlater(i,KPhase)/.52918
                do 3000j=1,121
                  FFAllR(j,i,KPhase,3)=
     1              SlaterFB(HNSlater(i,KPhase),0,s,pomk,pom,pom,ich)/
     2              pi4
                  s=s+.05
3000            continue
                go to 5000
              endif
            endif
            kp=0
            call SetRealArrayTo(FFAllR(1,i,KPhase,2),121,0.)
            call SetRealArrayTo(FFAllR(1,i,KPhase,3),121,0.)
            fnormv=0.
            do 4000l=1,6
              kp=kp+l
              k=kp
              call SetRealArrayTo(popc,6,0.)
              call SetRealArrayTo(popv,6,0.)
              spopc=0.
              spopv=0.
              do 3500j=l,6
                jp=j-l+1
                popc(jp)=PopCore(k,i,KPhase)
                spopc=spopc+popc(jp)
                popv(jp)=PopVal(k,i,KPhase)
                spopv=spopv+popv(jp)
                fnormv=fnormv+popv(jp)
                k=k+j
3500          continue
              if(spopc.gt.0.) then
                call ReadWaveF(AtType(i,KPhase),OrbitName(l),popc,
     1                             FFAllR(1,i,KPhase,2),0,ich)
                if(ich.eq.1) then
                  ExistWaveF=.false.
                  go to 5000
                endif
              endif
              if(spopv.gt.0.) then
                call ReadWaveF(AtType(i,KPhase),OrbitName(l),popv,
     1                         FFAllR(1,i,KPhase,3),0,ich)
              endif
              if(ich.ne.0) then
                if(AllowToReadCVF) then
                  ln=NextLogicNumber()
                  call OpenFile(ln,fln(:ifln)//'.cvf','formatted','old')
                  if(ErrJana.ne.0) go to 3700
                  nn=0
3600              read(ln,FormA80,end=3650) Veta
                  call mala(Veta)
                  k=0
                  call kus(Veta,k,Cislo)
                  if(EqIgCase(Cislo,AtType(i,KPhase))) then
                    call Kus(Veta,k,Cislo)
                    if(EqIgCase(Cislo,'core')) then
                      nn=nn+1
                    else if(EqIgCase(Cislo,'valence')) then
                      nn=nn+10
                    endif
                  endif
                  go to 3600
3650              call CloseIfOpened(ln)
                endif
3700            if(nn.ne.11) then
                  if(nn.eq.0) then
                    Veta='core and valence form factors'
                  else if(nn.eq.10) then
                    Veta='core form factor'
                  else
                    Veta='valence form factor'
                  endif
                  Veta='Please add '//Veta(:idel(Veta))//
     1                 ' to "cvf" file'
                  call FeChybne(-1.,-1.,'the Clementi form factor for "'
     1                     //AtType(i,KPhase)(:idel(AtType(i,KPhase)))//
     2                     '" is not on the file',Veta,0,Warning)
                endif
                call SetRealArrayTo(FFAllR(1,i,KPhase,3),121,0.)
                go to 5000
              endif
4000        continue
            do 4400j=1,121
              FFAllR(j,i,KPhase,1)=FFAllR(j,i,KPhase,2)+
     1                             FFAllR(j,i,KPhase,3)
4400        continue
            if(fnormv.gt.0.) then
              fnormv=1./fnormv
              do 4500j=1,121
                FFAllR(j,i,KPhase,3)=FFAllR(j,i,KPhase,3)*fnormv
4500          continue
            endif
          endif
5000    continue
      endif
9999  return
      end
      subroutine EM50FormFactorsFromFile(AtTypePom,n,Klic)
      include 'params.cmn'
      include 'basic.cmn'
      include 'fepc.cmn'
      include 'editm50.cmn'
      dimension xp(2)
      character*(*) AtTypePom
      character*2 AtTypeShort
      character*256 EdwStringQuest
      logical CrwLogicQuest
      call GetPureAtType(AtTypePom,AtTypeShort)
      if(ChargeDensities) NameOfWaveFile=EdwStringQuest(nEdwWaveFile)
      call RealFromAtomFile(AtTypePom,'atweight',AtWeight(n,KPhase),0,
     1                      ich)
      if(Klic.eq.0)
     1  call FeQuestRealEdwOpen(nEdwWeight,AtWeight(n,KPhase),ich.ne.0,
     2                          .false.)
      call RealFromAtomFile(AtTypePom,'atradius',AtRadius(n,KPhase),0,
     1                      ich)
      if(Klic.eq.0)
     1  call FeQuestRealEdwOpen(nEdwRadius,AtRadius(n,KPhase),ich.ne.0,
     2                          .false.)
      call StringFromAtomFile(AtTypePom,'color',AtColor(n,KPhase),0,ich)
      if(ich.ne.0) AtColor(n,KPhase)=' '
      if(Klic.eq.0)
     1  call FeQuestStringEdwOpen(nEdwColor,AtColor(n,KPhase))
      if(Radiation(1).eq.XRayRadiation) then
        if(klam(1).gt.0) then
          call RealFromAtomFile(AtTypePom,'Xray_f''',ffr(n,KPhase),
     1                          klam(1),ich)
          call RealFromAtomFile(AtTypePom,'Xray_f"',ffi(n,KPhase),
     1                          klam(1),ich)
        else
          call EM50ReadAnom(AtTypeShort,ffr(n,KPhase),ffi(n,KPhase))
        endif
        if(Klic.eq.0) then
          call FeQuestRealEdwOpen(nEdwPrime,ffr(n,KPhase),
     1                                          ich.ne.0,.false.)
          call FeQuestRealEdwOpen(nEdwDoublePrime,ffi(n,KPhase),
     2                            ich.ne.0,.false.)
        endif
        if(ChargeDensities) then
          call RealAFromAtomFile(AtTypePom,'DzSlater',
     1                           DzSlater(1,n,KPhase),8,ich)
          if(Klic.eq.0)
     1      call FeQuestRealAEdwOpen(nEdwDzeta,DzSlater(1,n,KPhase),5,
     2                               .false.,.false.)
          call IntAFromAtomFile(AtTypePom,'NSlater',NSlater(1,n,KPhase),
     1                          8,ich)
          if(Klic.eq.0)
     1      call FeQuestIntAEdwOpen(nEdwNSlater,NSlater(1,n,KPhase),5,
     2                              .false.)
          call IntAFromAtomFile(AtTypePom,'PopCore',PopCore(1,n,KPhase),
     1                          28,ich)
          call IntAFromAtomFile(AtTypePom,'PopVal',PopVal(1,n,KPhase),
     1                          28,ich)
        endif
      else if(Radiation(1).eq.NeutronRadiation) then
        call RealAFromAtomFile(AtTypePom,
     1                         'Neutron_scattering_length_real',xp,
     2                         2,ich)
        ffn(n,KPhase)=xp(2)
        if(Klic.eq.0) call FeQuestRealEdwOpen(nEdwBCoh,ffn(n,KPhase),
     1                                        ich.ne.0,.false.)
        call RealAFromAtomFile(AtTypePom,
     1                         'Neutron_scattering_length_imaginary',xp,
     2                         2,ich)
        ffni(n,KPhase)=xp(2)
        if(Klic.eq.0) call FeQuestRealEdwOpen(nEdwBIncoh,ffni(n,KPhase),
     1                                        ich.ne.0,.false.)
      endif
      return
      end
      subroutine EM50ReadAllFormFactors
      include 'params.cmn'
      include 'basic.cmn'
      dimension xp(2)
      do 1000i=1,nf
        call RealFromAtomFile(AtType(i,KPhase),'atweight',
     1                        AtWeight(i,KPhase),0,ich)
        call RealFromAtomFile(AtType(i,KPhase),'atradius',
     1                        AtRadius(i,KPhase),0,ich)
        call StringFromAtomFile(AtType(i,KPhase),'color',
     1                          AtColor(i,KPhase),0,ich)
        if(Radiation(1).eq.XRayRadiation) then
          if(klam(1).gt.0) then
            call RealFromAtomFile(AtType(i,KPhase),'Xray_f''',
     1                            ffr(i,KPhase),klam(1),ich)
            call RealFromAtomFile(AtType(i,KPhase),'Xray_f"',
     1                            ffi(i,KPhase),klam(1),ich)
          else
            call EM50ReadAnom(AtType(i,KPhase),ffr(i,KPhase),
     1                        ffi(i,KPhase))
          endif
          if(ChargeDensities) then
            call RealAFromAtomFile(AtType(i,KPhase),'DzSlater',
     1                             DzSlater(1,i,KPhase),8,ich)
            call IntAFromAtomFile(AtType(i,KPhase),'NSlater',
     1                            NSlater(1,i,KPhase),8,ich)
            call IntAFromAtomFile(AtType(i,KPhase),'PopCore',
     1                            PopCore(1,i,KPhase),28,ich)
            call IntAFromAtomFile(AtType(i,KPhase),'PopVal',
     1                            PopVal(1,i,KPhase),28,ich)
          endif
        else if(Radiation(1).eq.NeutronRadiation) then
          call RealAFromAtomFile(AtType(i,KPhase),
     1                           'Neutron_scattering_length_real',xp,
     2                           2,ich)
          ffn(i,KPhase)=xp(2)
          call RealAFromAtomFile(AtType(i,KPhase),
     1                           'Neutron_scattering_length_imaginary',
     2                           xp,2,ich)
          ffni(i,KPhase)=xp(2)
        endif
1000  continue
      return
      end
      subroutine EM50ReadAnom(At,ffrOut,ffiOut)
      include 'params.cmn'
      include 'basic.cmn'
      include 'fepc.cmn'
      character*(*) at
      character*256 t256
      character*80  Radka
      logical ExistFile,EqIgCase
      dimension xx(4),ff(4,2),xp(3)
      equivalence (t256,t80)
      ffrOut=0.
      ffiOut=0.
      Energy=ToKeV/LamAve(1)
      if(OpSystem.le.0) then
        t256=JanaDir(:idel(JanaDir))//'formfac'//ObrLom//
     1              'anom.dat'
      else
        t256=JanaDir(:idel(JanaDir))//'source/data/anom.dat'
      endif
      if(.not.ExistFile(t256)) go to 9999
      ln=NextLogicNumber()
      call OpenFile(ln,t256,'formatted','old')
      if(ErrJana.ne.0) go to 9999
      read(ln,FormA80) Radka
      if(Radka(1:1).ne.'#') rewind ln
2100  read(ln,FormA80) Radka
      k=0
      call kus(Radka,k,Cislo)
      if(.not.EqIgCase(Cislo,at)) go to 2100
2200  read(ln,FormA80) Radka
      j=1
2300  read(ln,*,err=9999,end=9999) xp
      jo=j
      if(xp(1).gt.Energy.or.j.lt.2) j=j+1
      if(jo.eq.j) then
        ff(j-1,1)=ff(j,1)
        ff(j-1,2)=ff(j,2)
        xx(j-1)  =xx(j)
      endif
      xx(j)  =xp(1)
      ff(j,1)=xp(2)
      ff(j,2)=xp(3)
      if(j.ge.4) then
        ffrOut=anint(Finter4(ff(1,1),xx,Energy)*10000.)*.0001
        ffiOut=anint(Finter4(ff(1,2),xx,Energy)*10000.)*.0001
        go to 9999
      else
        go to 2300
      endif
9999  call CloseIfOpened(ln)
      return
      end
      function EM50ReadAbsor(At)
      include 'params.cmn'
      include 'basic.cmn'
      include 'fepc.cmn'
      character*(*) at
      character*256 t256
      character*80  Radka
      logical ExistFile,EqIgCase
      dimension xx(4),ff(4),xp(2)
      equivalence (t256,t80)
      EM50ReadAbsor=0.
      Energy=ToKeV/LamAve(1)
      if(OpSystem.le.0) then
        t256=JanaDir(:idel(JanaDir))//'formfac'//ObrLom//
     1              'absor.dat'
      else
        t256=JanaDir(:idel(JanaDir))//'source/data/absor.dat'
      endif
      if(.not.ExistFile(t256)) go to 9999
      ln=NextLogicNumber()
      call OpenFile(ln,t256,'formatted','old')
      read(ln,FormA80) Radka
      if(Radka(1:1).ne.'#') rewind ln
      if(ErrJana.ne.0) go to 9999
2100  read(ln,FormA80) Radka
      k=0
      call kus(Radka,k,Cislo)
      if(.not.EqIgCase(Cislo,at)) go to 2100
2200  read(ln,FormA80) Radka
      j=1
2300  read(ln,*,err=9999,end=9999) xp
      jo=j
      if(xp(1).gt.Energy.or.j.lt.2) j=j+1
      if(jo.eq.j) then
        ff(j-1)=ff(j)
        xx(j-1)=xx(j)
      endif
      xx(j)=xp(1)
      ff(j)=xp(2)
      if(j.ge.4) then
        EM50ReadAbsor=anint(Finter4(ff,xx,Energy))
        go to 9999
      else
        go to 2300
      endif
9999  call CloseIfOpened(ln)
      return
      end
      subroutine EM50UpdateListek(KartIdOld)
      include 'params.cmn'
      include 'basic.cmn'
      include 'fepc.cmn'
      include 'editm50.cmn'
      if(KartId.eq.KartIdSymmetry) then
        call Em50SymmetryRefresh
      else if(KartId.eq.KartIdRadiation) then
        call EM50RadiationRefresh
      else if(KartId.eq.KartIdFormFactors) then
        call EM50FormFactorsRefresh(LastAtom)
      endif
      return
      end
      subroutine CopyAtomFormFactors(From,To)
      include 'params.cmn'
      include 'basic.cmn'
      integer From,To
      AtTypeFull(To,KPhase)=AtTypeFull(From,KPhase)
      AtType(To,KPhase)=AtType(From,KPhase)
      AtWeight(To,KPhase)=AtWeight(From,KPhase)
      AtRadius(To,KPhase)=AtRadius(From,KPhase)
      HNSlater(To,KPhase)=HNSlater(From,KPhase)
      HDzSlater(To,KPhase)=HDzSlater(From,KPhase)
      if(Radiation(1).eq.NeutronRadiation) then
        ffn(To,KPhase)=ffn(From,KPhase)
      else if(Radiation(1).eq.XRayRadiation) then
        ffr(To,KPhase)=ffr(From,KPhase)
        ffi(To,KPhase)=ffi(From,KPhase)
        if(ntab.gt.0) then
          n=ntab
        else if(ntab.eq.-9) then
          n=-iabs(ntab)+1
        endif
        call CopyVek(ffBasic(1,From,KPhase),ffBasic(1,To,KPhase),n)
        if(ChargeDensities) then
          call CopyVek(ffCore(1,From,KPhase),ffCore(1,To,KPhase),n)
          call CopyVek(ffVal(1,From,KPhase),ffVal(1,To,KPhase),n)
          call CopyVekI(PopCore(1,From,KPhase),PopCore(1,To,KPhase),28)
          call CopyVekI(PopVal(1,From,KPhase),PopVal(1,To,KPhase),28)
          call CopyVek(DzSlater(1,From,KPhase),DzSlater(1,To,KPhase),5)
          call CopyVekI(NSlater(1,From,KPhase),NSlater(1,To,KPhase),5)
        endif
      endif
      return
      end
      subroutine ClearAtomFormFactor(k)
      include 'params.cmn'
      include 'basic.cmn'
      AtTypeFull(k,KPhase)=' '
      AtType(k,KPhase)=' '
      AtWeight(k,KPhase)=0.
      AtRadius(k,KPhase)=0.
      AtColor(k,KPhase)=' '
      HNSlater(k,KPhase)=0
      HDzSlater(k,KPhase)=0.
      if(Radiation(1).eq.NeutronRadiation) then
        ffn(k,KPhase)=0.
      else if(Radiation(1).eq.XRayRadiation) then
        ffr(k,KPhase)=0.
        ffi(k,KPhase)=0.
        if(ntab.gt.0) then
          n=ntab
        else if(ntab.eq.-9) then
          n=-iabs(ntab)+1
        endif
        call SetRealArrayTo(ffBasic(1,k,KPhase),n,0.)
        if(ChargeDensities) then
          call SetRealArrayTo(ffCore(1,k,KPhase),n,0.)
          call SetRealArrayTo(ffVal(1,k,KPhase),n,0.)
          call SetIntArrayTo(PopCore(1,k,KPhase),28,0)
          call SetIntArrayTo(PopVal(1,k,KPhase),28,0)
          call SetRealArrayTo(DzSlater(1,k,KPhase),5,0.)
          call SetIntArrayTo(NSlater(1,k,KPhase),5,0)
        endif
      endif
      return
      end
      subroutine TRANSO(nn,l1,z,s,ff)
      dimension ff(9),a(28)
      data a(1)/0.0/
      d=s**2+z**2
      a(2)=1./d
      n=nn-1
      tz=z+z
      ts=s+s
      do 2000ll=1,l1
        l=ll-1
        if(ll.eq.1) go to 1000
        a(ll+1)=a(ll)*ts*float(l)/d
        a(ll)=0.0
1000    do 1500nx=ll,n
          i1=nx
          i2=nx+1
          i3=i2+1
          a(i3)=(tz*float(nx)*a(i2)-float((nx+l)*(nx-ll))*a(i1))/d
1500    continue
        ff(ll)=a(i3)
2000  continue
      return
      end
      subroutine EM50FormFactorsReadEdw
      include 'params.cmn'
      include 'basic.cmn'
      include 'fepc.cmn'
      include 'editm50.cmn'
      character*256 EdwStringQuest
      call FeQuestRealFromEdw(nEdwRadius,AtRadius(LastAtom,KPhase))
      AtColor(LastAtom,KPhase)=EdwStringQuest(nEdwColor)
      call FeQuestRealFromEdw(nEdwWeight,AtWeight(LastAtom,KPhase))
      if(Radiation(1).eq.XRayRadiation) then
        call FeQuestRealFromEdw(nEdwPrime,ffr(LastAtom,KPhase))
        call FeQuestRealFromEdw(nEdwDoublePrime,ffi(LastAtom,KPhase))
        ffn(LastAtom,KPhase)=0.
        if(ChargeDensities) then
          if(TypVodiku.eq.2) then
            call FeQuestIntFromEdw(nEdwHN,HNSlater(LastAtom,KPhase))
            call FeQuestRealFromEdw(nEdwHDzeta,
     1                              HDzSlater(LastAtom,KPhase))
          else if(TypVodiku.eq.3) then
            nEdw=nEdwPopFirst
            do 2065i=1,2
              nn=0
              do 2060j=1,4
                do 2055k=j,4
                  nn=nn+1
                  call FeQuestIntFromEdw(nEdw,
     1                                   PopAll(nn,LastAtom,KPhase,i))
                  nEdw=nEdw+1
2055            continue
2060          continue
2065        continue
          endif
          call FeQuestRealAFromEdw(nEdwDzeta,
     1                             DzSlater(1,LastAtom,KPhase))
          call FeQuestIntAFromEdw(nEdwNSlater,
     1                            NSlater(1,LastAtom,KPhase))
        endif
      else if(Radiation(1).eq.NeutronRadiation) then
        call FeQuestRealFromEdw(nEdwBCoh,ffn(LastAtom,KPhase))
        call FeQuestRealFromEdw(nEdwBIncoh,ffni(LastAtom,KPhase))
        ffr(LastAtom,KPhase)=0.
        ffi(LastAtom,KPhase)=0.
      endif
      return
      end
      subroutine TableFFToEquidistant(FFIn,FFOut,AtTypeIn)
      include 'params.cmn'
      include 'basic.cmn'
      dimension FFIn(*),FFOut(*)
      character*(*) AtTypeIn
      dimension am(4,4),ami(4,4),b(4),AFFIn(4,62)
      n=62
      do 2000i=1,n
        if(i.eq.1) then
          jp=0
        else if(i.gt.n-2) then
          jp=n-4
        else
          jp=i-2
        endif
        if(AtTypeIn.eq.'H') then
          pom=1./(ffxh(jp+1)-ffxh(jp+2))
        else
          pom=1./(ffx(jp+1)-ffx(jp+2))
        endif
        do 1200j=1,4
          b(j)=FFIn(jp+j)-FFIn(jp+2)
          if(AtTypeIn.eq.'H') then
            xp=(ffxh(jp+j)-ffxh(jp+2))*pom
          else
            xp=(ffx(jp+j)-ffx(jp+2))*pom
          endif
          xs=1.
          do 1100k=1,4
            am(j,k)=xs
            xs=xs*xp
1100      continue
1200    continue
        call matinv(am,ami,xp,4)
        call multm(ami,b,AFFIn(1,i),4,4,1)
        AFFIn(1,i)=AFFIn(1,i)+FFIn(jp+2)
2000  continue
      sinthl=0.
      do 5000i=1,121
        do 4000j=1,n
          if(AtTypeIn.eq.'H') then
            ffxj=ffxh(j)
          else
            ffxj=ffx(j)
          endif
          if(sinthl.lt.ffxj.or.j.eq.n) then
            jp=min(j,n-2)
            pom=AFFIn(4,jp)
            if(AtTypeIn.eq.'H') then
              xp=(sinthl-ffxh(jp))/(ffxh(jp-1)-ffxh(jp))
            else
              xp=(sinthl-ffx(jp))/(ffx(jp-1)-ffx(jp))
            endif
            do 3100k=3,1,-1
              pom=pom*xp+AFFIn(k,jp)
3100        continue
            go to 4500
          endif
4000    continue
4500    FFOut(i)=pom
        sinthl=sinthl+.05
5000  continue
      return
      end
      subroutine EM50PopOrbMore
      include 'params.cmn'
      include 'basic.cmn'
      include 'fepc.cmn'
      include 'editm50.cmn'
      dimension tlabel(2)
      character*8 Veta
      character*7  Label(2)
      data Label/'CORE','VALENCE'/
      id=NextQuestId()
      xdqq=150.
      call FeQuestCreate(id,-1.,-1.,xdqq,0,7,
     1                   'Define additional orbital populations',0,
     2                   LightGray,0,0)
      tpom=3.
      xpom=13.
      tpom0=3.
      xpom0=13.
      ilp=0
      do 1250i=1,2
        nn=10
        il=ilp
        tlabel(i)=xdqq*(.25+float(i-1)*.5)
        il=il+1
        call FeQuestLabelMake(id,tlabel(i),il,Label(i),'C')
        do 1200j=5,6
          il=ilp+1
          do 1150k=1,j
            nn=nn+1
            il=il+1
            write(Veta,'(i1,a1)') j,OrbitName(k)
            call FeQuestEdwMake(id,tpom,il,xpom,il,Veta,'L',14.,
     1                          EdwYd,0)
            call FeQuestIntEdwOpen(EdwLastMade,
     1                             PopAll(nn,LastAtom,KPhase,i),.false.)
            if(nn.eq.11.and.i.eq.1) nEdwFirst=EdwLastMade
1150      continue
          tpom=tpom+29.
          xpom=xpom+29.
1200    continue
        if(i.eq.2) go to 1250
        tpom=tpom0+xdqq*.5
        xpom=xpom0+xdqq*.5
1250  continue
      icont=0
      call FeQuestEvent(id,icont,ich)
      icont=1
      if(CheckType.ne.0) then
        call NebylOsetren
      endif
      if(ich.eq.0) then
        nEdw=nEdwFirst
        do 2250i=1,2
          nn=10
          do 2200j=5,6
            do 2150k=1,j
              nn=nn+1
              call FeQuestIntFromEdw(nEdw,PopAll(nn,LastAtom,KPhase,i))
              nEdw=nEdw+1
2150        continue
2200      continue
2250    continue
      endif
      call FeQuestRemove(id)
      return
      end
      subroutine EM50ReadCellCentr(ich)
      include 'params.cmn'
      include 'basic.cmn'
      include 'fepc.cmn'
      include 'datred.cmn'
      dimension vt6p(6,mxcen),xp(6)
      character*256 EdwStringQuest
      character*80 t80
      character*2 nty
      logical eqrv
      nvtp=nvt
      if(nvtp.le.0) then
        nvtp=1
        call SetRealArrayTo(vt6p,ndim,0.)
      else
        do 1000i=1,nvtp
          call CopyVek(vt6(1,i,1,KPhase),vt6p(1,i),ndim)
1000    continue
      endif
      ik=0
      id=NextQuestId()
      call FeQuestCreate(id,-1.,-1.,220.,0,9,'Centring vectors',1,
     1                   LightGray,0,0)
      call FeQuestButtonMake(id,80.,9,60.,ButYd,'%Complete the set')
      nButtComplete=ButtonLastMade
      call FeQuestButtonOpen(ButtonLastMade,ButtonOff)
      call FeQuestUpDownMake(id,205.,9,UpDownXd,UpDownYd,'down')
      nDown=UpDownLastMade
      call FeQuestUpDownMake(id,205.,0,UpDownXd,UpDownYd,'up')
      nUp=UpDownLastMade
      xpom=5.
      il=1
      do 1120i=1,16
        write(cislo,100) i,nty(i)
        call FeQuestEdwMake(id,xpom,il,xpom+20.,il,Cislo,'L',80.,EdwYd,
     1                      1)
        if(i.eq.1) nEdwCentrFirst=EdwLastMade
        if(mod(il,8).eq.0) then
          xpom=xpom+110.
          il=0
        endif
        il=il+1
1120  continue
      m=1
1150  icont=0
1200  n1=(m-1)*16+1
      n2=min(n1+15,nvtp)
      nEdw=nEdwCentrFirst
      do 1220i=n1,n1+15
        write(cislo,100) i,nty(i)
        if(i.ne.1) then
          call FeQuestRealAEdwOpen(nEdw,vt6p(1,i),ndim,i.gt.nvtp,.true.)
          write(cislo,100) i,nty(i)
          call FeQuestEdwLabelChange(Id,nEdw,Cislo)
        else
          call FeQuestEdwClose(nEdw)
          call FeQuestLabelMake(id,5.,1,Cislo,'L')
          t80='0 0 0'
          if(ndim.gt.3) t80=t80(1:5)//' 0'
          if(ndim.gt.4) t80=t80(1:7)//' 0'
          if(ndim.gt.5) t80=t80(1:9)//' 0'
          call FeQuestLabelMake(id,25.+5.*EdwIndSize,1,t80,'L')
        endif
        nEdw=nEdw+1
1220  continue
1500  if(nvtp.gt.16) then
        if(n2.lt.nvtp) then
          call FeUpDownOff(nDown)
        else
          call FeUpDownDisable(nDown)
        endif
        if(n1.gt.1) then
          call FeUpDownOff(nUp)
        else
          call FeUpDownDisable(nUp)
        endif
      endif
      call FeQuestEvent(id,icont,ich)
      icont=1
      if(CheckType.eq.EventButton.and.CheckNumberAbs.eq.ButtonOK) then
        call EM50CompleteCentr(1,vt6p,nvtp,ich)
        if(ich.eq.0) then
          QuestCheck(id)=0
        else
          call FeChybne(-1.,-1.,'the set of vectors isn''t complete',
     1                  ' ',0,SeriousError)
          call FeButtonOff(ButtonOK)
          EventType=EventEdw
          EventNumber=min(nvtp-n1+2,16)
        endif
        go to 1500
      else if(CheckType.eq.EventEdw) then
        nEdw=CheckNumber
        il=nEdw+n1-1
        if(EdwStringQuest(nEdw).eq.' ') then
          if(il.le.nvtp) then
            do 1510i=il+1,nvtp
              call CopyVek(vt6p(1,i),vt6p(1,i-1),ndim)
1510        continue
            ipp=il
            nvtp=nvtp-1
            go to 1200
          else
            go to 1500
          endif
        endif
        do 1520i=1,nvtp
          call FeQuestRealAFromEdw(nEdw,xp)
          if(i.ne.il.and.eqrv(xp,vt6p(1,i),ndim,.0001)) then
            call FeChybne(-1.,-1.,'the centring vector already present',
     1                    'try again',0,SeriousError)
            EventType=EventEdw
            EventNumber=nEdw
            go to 1500
          endif
1520    continue
        if(il.gt.nvtp) nvtp=nvtp+1
        call FeQuestRealAFromEdw(nEdw,vt6p(1,il))
        call FeQuestRealAEdwOpen(nEdw,vt6p(1,il),ndim,.false.,.true.)
        go to 1500
      else if(CheckType.eq.EventButton) then
        call EM50CompleteCentr(0,vt6p,nvtp,ich)
        call FeQuestButtonOff(nButtComplete)
        go to 1150
      else if(CheckType.eq.EventUpDown) then
        if(CheckNumber.eq.nDown) then
          m=m+1
        else
          m=m-1
        endif
        go to 1150
      else if(CheckType.ne.0) then
        call NebylOsetren
        go to 1500
      endif
      if(ich.eq.0) then
        nvt=nvtp
        do 1910i=1,nvtp
          call CopyVek(vt6p(1,i),vt6(1,i,1,KPhase),ndim)
1910    continue
      endif
      call FeQuestRemove(id)
9999  return
100   format(i2,a2)
      end
      subroutine EM50CompleteCentr(klic,vt6p,nvtp,ich)
      include 'params.cmn'
      include 'basic.cmn'
      dimension vt6p(6,mxcen)
      dimension xp(6)
      logical eqrv
      ich=0
      nvp=nvtp
      i=1
1600  i=i+1
      if(i.gt.nvtp) go to 9999
      j=1
1620  j=j+1
      if(j.gt.nvtp) go to 1600
      do 1630k=1,ndim
        xp(k)=vt6p(k,i)+vt6p(k,j)
1630  continue
      call od0do1(xp,xp,ndim)
      do 1640k=1,nvtp
        if(eqrv(xp,vt6p(1,k),ndim,.0001)) go to 1620
1640  continue
      if(klic.eq.0) then
        nvtp=nvtp+1
        if(nvtp.gt.mxcen) then
          nvtp=nvp
          write(Cislo,'(i3)') mxcen
          call zhusti(Cislo)
          call FeChybne(-1.,-1.,'maximun number of '//
     1                  Cislo(:idel(Cislo))//
     2                  ' centring vectors exceeded',' ',0,SeriousError)
          go to 9000
        endif
      else
        go to 9000
      endif
      call copyvek(xp,vt6p(1,nvtp),ndim)
      go to 1620
9000  ich=1
9999  return
      end

