      subroutine ExportM91
      include 'params.cmn'
      include 'basic.cmn'
      include 'fepc.cmn'
      include 'editm9.cmn'
      include 'datred.cmn'
      dimension h(3),fp(mxref),sp(mxref),hp(6),ntwq(-mxsc:mxsc),difi(3),
     1          ihi(6),mlim(3,MxPhases),mlimp(3,MxPhases),iht(6,500),
     2          hft(3,500),iport(500),ihtw(6,6),itwa(6)
      character*256 t256
      character*128 Ven(4)
      character*80 t80,p80
      character*2 nty
      logical FeYesNo,VicSkal,RedukceDolu,m89opened,ExistFile,HKLF5,
     1        FeYesNoHeader,Nulova,EqIgCase,SystExtRef
      integer FeSelectOnePossibility,AcceptM91,riat(500),rsat(500)
      equivalence (fia,fp),(sigfia,sp),(t256,ven)
      data difi/3*.01/
      if(.not.ExistFile(fln(:ifln)//'.m95')) then
        call FeChybne(-1.,-1.,'M91 file cannot be created as file',
     1                fln(:ifln)//'.m95 doesn''t exist',0,SeriousError)
        go to 9900
      endif
      call NewPg(1)
      Name=' '
      Title=' '
      uloha='Creating of the JANA reflection file'
      call OpenFile(lst,fln(:ifln)//'.rre','formatted','unknown')
      if(ErrJana.ne.0) go to 9900
      LstOpened=.true.
      call iom94(0)
      if(ErrJana.ne.0) go to 9900
      call iom50(0,1)
      if(ErrJana.ne.0) go to 9900
      if(StatusM50.gt.100) then
        call FeChybne(-1.,-1.,'M50 doesn''t contain either parameters '
     1              //'or symmetry information',' ',0,SeriousError)
        go to 9900
      endif
      call OpenFile(90,fln(:ifln)//'.l90','formatted','unknown')
      if(ErrJana.ne.0) go to 9900
      if(CorrLp.le.0) then
        call FeChybne(-1.,-1.,'LP correction has not been applied',' ',
     1                0,SeriousError)
        go to 9999
      endif
      scf=1.
      call OpenFile(95,fln(:ifln)//'.m95','formatted','old')
      if(ErrJana.ne.0) go to 9900
1100  call FeGetILevel('Observability level used by the export routine',
     1                 'Reflections I<',
     2                 '*sig(I) will be sorted as unobserved',
     3                 'Note: this number is not interpreted by REFINE',
     4                 EM9ObsLim,ich)
      if(ich.ne.0) go to 9900
      call OpenFile(89,fln(:ifln)//'_makem91.tmp','formatted','unknown')
      m89opened=ErrJana.eq.0
      if(m89opened) then
        write(89,'(''makem91'')')
        write(Cislo,'(f8.3)') EM9ObsLim
        call ZdrcniCisla(Cislo,1)
        write(89,'(''siglevp: '',15a1)')(Cislo(i:i),i=1,idel(Cislo))
      endif
      RedukceDolu=.false.
      if(nref95.le.0) nref95=10000
      call FeFlowChartOpen(-1.,-1.,max(nint(float(nref95)*.005),10),
     1                     nref95,'Creating refinement reflection file',
     2                     ' ',' ')
2005  iz=0
      call SetIntArrayTo(ihmin,ndim, 9999)
      call SetIntArrayTo(ihmax,ndim,-9999)
      call SetIntArrayTo(mlim,MxPhases*ndimi,0)
      thmin= 9999.
      thmax=-9999.
      NExt=0
      NExtObs=0
      NExt500=0
      NVyh=0
      NVyhObs=0
      NVyh500=0
      avis=0.
      avist=0.
      rcc=0.
      rjc=0.
      rcn=0.
      rjn=0.
      NRef90=0
      NRef90Obs=0
      NRead=0
      NReadObs=0
      rimax=0.
      rimaxt=0.
      fomax=0.
      do 2040i=-mxsc,mxsc
        ntwq(i)=0
2040  continue
      nq=0
      itwmax=0
      itwmin=1
      ntw=0
      if(kcommen.ne.0) call comsym(0,1)
      read(95,FormA80) t80
      if(EqIgCase(t80,ImportTextB)) then
        read(95,FormA80) t80
        read(95,FormA80) t80
        k=0
        call StToInt(t80,k,ih,1,.false.,ich)
        HKLF5=ih(1).eq.IdImportHKLF5
      else
        HKLF5=.false.
      endif
      rewind 95
      call PrvniM95(ich)
      if(ich.ne.0) go to 9200
2100  call DRGetReflectionFromM95(95,iend,ich)
      if(ich.ne.0) go to 9000
      if(iend.ne.0) go to 5000
      iq=iflg(1)
      itw=iflg(2)
      ReadLam=DRLam
      call CopyVekI(ih,ihi,ndim)
      if(itw.eq.0) itw=1
      iatw=iabs(itw)
      call RestorePhase(KPhaseTwin(iatw))
      if(ReadLam.gt.0.) LamAve(1)=ReadLam
      if(iatw.gt.itwin.and..not.HKLF5) then
        write(t80,format91)(ihi(i),i=1,ndim),ri,rs,iq,0,itw
        call FeChybne(-1.,-1.,'disagreement between twin flag and '//
     1                'number of twin domains','for reflection : '//
     2                t80(:idel(t80)),0,SeriousError)
        go to 9100
      endif
      call FeFlowChartEvent(iz,ie)
      if(ie.ne.0) then
        call FeBudeBreak
        if(ErrJana.ne.0) go to 9100
      endif
      if(iq.lt.0) go to 2100
      if(no.gt.0) then
        pom1=corrf(1)*corrf(2)*scf
        ri=ri*pom1
        rs=rs*pom1
        if(rs.le.0.05) then
          if(.not.RedukceDolu.and.rs.gt.0.) then
2200        if(rs.le..05) then
              scf=scf*10.
              rs=rs*10.
              go to 2200
            endif
            rewind 95
            rewind 90
            call FeFlowChartRefresh
            go to 2005
          endif
          rs=0.1
        endif
      else
        go to 2100
      endif
      NRead=NRead+1
      Nulova=.true.
      if(anint(ri*10.).gt.EM9ObsLim*anint(rs*10.)) then
        Nulova=.false.
        NReadObs=NReadObs+1
      endif
      call indtr(ihi,trmp,ih,ndim)
      if(ih(1).gt.900) then
        call CopyVekI(ih,ihp,ndim)
        write(t80,101)(ihi(i),i=1,ndim)
        write(t80(ndim*4+1:),102) ri,rs,ri/rs
        call EM9NejdouPotvory(ihi,hp,ri,rs,ndim,avist,NVyh,NVyhObs,
     1    NVyh500,iht,hft,iport,riat,rsat,rimaxt,EM9ObsLim,.false.)
        go to 2100
      endif
      mmax=0
      call SetIntArrayTo(mlimp,3*Mxphases,9999)
      do 2215isw=1,ncomp
        call IndTr(ih,zvi(1,isw,KPhase),ihp,ndim)
        do 2210i=4,ndim
          j=iabs(ihp(i))
          mmax=max(j,mmax)
          mlimp(i-3,1)=min(mlimp(i-3,1),j)
          if(isw.eq.1) hp(i)=0.
2210    continue
2215  continue
      do 2218i=1,ndimi
        mlim(i,1)=max(mlim(i,1),mlimp(i,1))
2218  continue
      if(HKLF5) then
        if(SystExtRef(ih,1)) then
          if(itw.lt.0) then
            go to 2100
          else
            if(ntw.le.0) then
              iswp=0
            else
              itwa(ntw)=iabs(itwa(ntw))
              iswp=1
            endif
          endif
        else
          ntw=ntw+1
          call CopyVekI(ih,ihtw(1,ntw),ndim)
          itwa(ntw)=itw
          if(itw.lt.0) go to 2100
          iswp=1
        endif
      else
        do 2230i=1,3
          h(i)=ih(i)
          do 2220j=1,ndimi
            h(i)=h(i)+qu(i,j,1,KPhase)*float(ih(j+3))
2220      continue
2230    continue
        call multm(h,rtwi(1,iatw),hp,1,3,3)
        call IndFromIndReal(hp,mmax,difi,ihp,itwp,iswp,-1.,
     1                      CheckExtRefYes)
      endif
      if(iswp.le.0) then
        write(t80,101)(ih(i),i=1,ndim)
        write(t80(ndim*4+1:),102) ri,rs,ri/rs
        call EM9NejdouPotvory(ih,hp,ri,rs,ndim,avis,NExt,NExtObs,
     1    NExt500,iha,hfa,ipor,ria,rsa,rimax,EM9ObsLim,.false.)
        go to 2100
      endif
      call RestorePhase(KPhaseTwin(iatw))
      call FromIndSinthl(ih,h,sinthl,sinthlq,1,0)
      pom1=sinthl*LamAve(1)
      if(abs(pom1).gt..999999) then
        NInfo=2
        write(t80,'(''('',6(i5,'',''))')(ihi(i),i=1,ndim)
        call zhusti(t80)
        i=idel(t80)
        if(t80(i:i).eq.',') i=i-1
        TextInfo(1)='The reflection '//t80(:i)//
     1              ') has unrealistic indices'
        TextInfo(2)='It gives sin(theta)>1 and it will be skipped'
        call FeMouseShape(0)
        if(FeYesNoHeader(-1.,30.,'Do you want to stop?',1)) then
          go to 9100
        else
          call FeMouseShape(3)
          go to 2100
        endif
      endif
      pom1=asin(sinthl*LamAve(1))/torad
      thmin=min(thmin,pom1)
      thmax=max(thmax,pom1)
      fomax=max(fomax,ri)
      if(fomax.gt.999999.9) then
        RedukceDolu=.true.
2300    if(fomax.gt.999999.9) then
          scf=scf*.1
          fomax=fomax*.1
          go to 2300
        endif
        rewind 95
        rewind 90
        call FeFlowChartRefresh
        go to 2005
      endif
      do 2920i=1,6
        ihmax(i)=max(ihmax(i),ih(i))
        ihmin(i)=min(ihmin(i),ih(i))
2920  continue
      rcc=rcc+rs
      rjc=rjc+ri
      NRef90=NRef90+1
      if(.not.Nulova) then
        rcn=rcn+rs
        rjn=rjn+ri
        NRef90Obs=NRef90Obs+1
        sp(NRef90Obs)=sinthl
        fp(NRef90Obs)=ri
      endif
      if(iq.eq.0) iq=1
      ntwq(itw)=max(ntwq(itw),iq)
      itwmin=min(itwmin,itw)
      itwmax=max(itwmax,itw)
      nq=max(nq,iq)
      nxx=0
      if(HKLF5) then
c        write(6,'('' ntw: '',i2)') ntw
c        pause
        do 3000j=1,ntw
          write(90,format91)(ihtw(i,j),i=1,ndim),ri,rs,iq,nxx,itwa(j),
     1                      tbar,ReadLam,DirCos
3000    continue
        ntw=0
      else
        write(90,format91)(ih(i),i=1,ndim),ri,rs,iq,nxx,itw,tbar,
     1                    ReadLam,DirCos
      endif
      go to 2100
5000  write(90,'('' 999'')')
      call FeFlowChartRemove
      call NewPg(0)
      NInfo=2
      write(t80,100) NReadObs,NRead
      call Zhusti(t80)
      i=idel(t80)
      j=index(t80,'/')
      TextInfo(1)=t80(:i)//' reflections read from input file'
      write(t80,100) NRef90Obs,NRef90
      call Zhusti(t80)
      k=j-index(t80,'/')+1
      l=i-k+1
      TextInfo(2)=' '
      TextInfo(2)(k:)=t80(:l)//' reflections written to output file'
      if(Nvyh.gt.0) then
        write(t80,100) NVyhObs,NVyh
        call Zhusti(t80)
        k=j-index(t80,'/')+1
        l=i-k+1
        NInfo=NInfo+1
        TextInfo(NInfo)=' '
        TextInfo(NInfo)(k:)=t80(:l)//
     1    ' reflections could not be transformed to integer indices'
      endif
      NInfo=NInfo+1
      if(NExt.gt.0) then
        write(t80,100) NExtObs,NExt
        call Zhusti(t80)
        k=j-index(t80,'/')+1
        l=i-k+1
        TextInfo(NInfo)=' '
        TextInfo(NInfo)(k:)=t80(:l)//
     1    ' reflections rejected as systematically extint'
      else
        TextInfo(NInfo)='There were no rejections due to systematic '//
     1                  'extintions'
      endif
      call FeInfoOut(-1.,-1.,'Import statistics - obs/all')
      call TitulekVRamecku('Summary of reflections before averaging')
      call CrlGetReflectionConditions
      if(NExtRefCond.gt.0) then
        call Newln(2)
        write(lst,'(''The following reflection conditions will be '',
     1              ''applied''/)')
        do 5010i=1,NExtRefCond
          call Newln(1)
          k=ExtRefPor(i)
          call CrlMakeExtString(ExtRefGroup(1,k),ExtRefCond(1,k),t80,
     1                          p80)
          if(ExtRefFlag(k).ne.0) then
            t256=' <= also follows from above conditions'
          else
            t256=' '
          endif
          write(lst,FormA1) ' ',(t80(j:j),j=1,idel(t80)),' ',':',' ',
     1                          (p80(j:j),j=1,idel(p80)),
     2                          (t256(j:j),j=1,idel(t256))
5010    continue
      else
        call Newln(2)
        write(lst,'(''No reflection conditions will be applied''/)')
      endif
      k=0
      do 5020i=1,ndim
        do 5015j=1,ndim
          k=k+1
          if(i.eq.j) then
            if(abs(trmp(k)-1.).gt..0001) go to 5025
          else
            if(abs(trmp(k)).gt..0001) go to 5025
          endif
5015    continue
5020  continue
      go to 5050
5025  call Newln(ndim+3)
      write(lst,'(/''The following transformation will be applied to '',
     1             ''the indices from the data collection''/)')
      do 5030i=1,ndim
        write(lst,'(1x,6f8.4)')(trmp(i+(j-1)*ndim),j=1,ndim)
5030  continue
5050  call Newln(3)
      write(lst,'(/''Reflections with I<'',f5.2,''*sig(I) will be '',
     1             ''classified as unobserved''/)') EM9ObsLim
      if(abs(scf-1.).gt..5) then
        call newln(1)
        if(scf.gt.1.) then
          write(Cislo,'(f15.0)') scf
        else
          write(Cislo,'(f15.5)') scf
        endif
        call ZdrcniCisla(Cislo,1)
        write(lst,'(''Intesities from M95 were rescaled by the factor ''
     1              ,a)') Cislo(:idel(Cislo))
        call newln(1)
        write(lst,FormA1)
      endif
      do 5100i=1,NInfo
        call newln(1)
        write(lst,FormA1)(TextInfo(i)(j:j),j=1,idel(TextInfo(i)))
5100  continue
      call Newln(ndim+1)
      write(lst,FormA1)
      Ninfo=ndim+3
      write(lst,105)(indices(i),ihmin(i),indices(i),ihmax(i),i=1,ndim)
      rn=rcn/rjn*100.
      rc=rcc/rjc*100.
      call Newln(2)
      write(lst,FormA1)
      write(lst,104) rn,rc
      if(m89opened) then
        write(89,'(''limits90:'',12i4)')(ihmin(i),ihmax(i),i=1,ndim)
        write(89,'(''number90:'',i6)') NRef90
        write(89,'(''thmin/max:'',2f8.2)') thmin,thmax
      endif
      call EM9OutputOfRejected(2,NVyh,NVyh500,NVyhObs,avist,iht,riat,
     1                         rsat,iport)
      call EM9OutputOfRejected(1,NExt,NExt500,NExtObs,avis,iha,ria,rsa,
     1                         ipor)
      call heap(NRef90Obs,sp)
      call heap(NRef90Obs,fp)
      sinmez(8)=sp(NRef90Obs)+.000001
      fmez(8)=fp(NRef90Obs)+.1
      d=0.
      dd=float(NRef90Obs)*.125
      do 5500i=1,7
        d=d+dd
        j=d
        sinmez(i)=(sp(j)+sp(j+1))*.5
        fmez(i)=(fp(j)+fp(j+1))*.5
5500  continue
      call CloseIfOpened(95)
      call CloseIfOpened(90)
      if(nq.gt.6.or.HKLF5) go to 6900
      VicSkal=nq.gt.1
      nrefav=0
      nrefsc=NRef90*(nq+2)
      do 5505i=itwmin,itwmax
        nrefav=nrefav+2*ntwq(i)*NRef90
5505  continue
      do 5510i=1,ns
        call MatBlock3(rm6(1,i,1,KPhase),rm(1,i,1,KPhase),ndim)
5510  continue
      if(.not.VicSkal) go to 5550
      if(FeYesNo(-1.,-1.,'Do you want transform data to common scale?',
     1           1)) then
        callOpenFile(90,fln(:ifln)//'.l90','formatted','unknown')
        if(ErrJana.ne.0) go to 9200
        call OpenFile(91,fln(:ifln)//'.l91','formatted','unknown')
        if(ErrJana.ne.0) go to 9200
        call EM9MakeScales(0,0,ich)
        if(ich.ne.0) go to 5520
        call FeFlowChartOpen(-1.,-1.,max(nint(float(nrefsc)*.005),10),
     1                       nrefsc,
     2                       'Transformation to common scale',' ',
     3                       ' ')
        call EM9MakeScales(1,1,ich)
        if(ich.ne.0) go to 5520
        do 5516j=2,nq
          call EM9MakeScales(j,2,ich)
          if(ich.ne.0) go to 5520
5516    continue
        call EM9MakeScales(j,3,ich)
5520    call FeFlowChartRemove
        call CloseIfOpened(90)
        call CloseIfOpened(91)
        if(ich.eq.1) then
          go to 5550
        else if(ich.eq.2) then
          go to 8000
        endif
        Ninfo=nq+1
        TextInfo(1)='Set     No of all  No of common  Scale'
        sckor(1)=1.
        sccom(1)=0
        do 5525j=1,nq
          write(TextInfo(j+1),'(i2,3x,i10,2x,i10,4x,f8.4)') j,
     1      scref(j),sccom(j),sckor(j)
          if(j.gt.1) then
            write(t80,'(''('',i15,'')'')') nint(sckors(j)*10000.)
            call zhusti(t80)
            TextInfo(j+1)=TextInfo(j+1)(:39)//t80(:idel(t80))
          else
            TextInfo(j+1)(25:27)='---'
          endif
5525    continue
        t80='Summary from transformation to the common scale'
        call FeInfoOut(-1.,-1.,t80)
        call TitulekVRamecku(t80)
        call NewLn(Ninfo)
        do 5526i=1,NInfo
          write(lst,FormA1)(TextInfo(i)(j:j),j=1,idel(TextInfo(i)))
5526    continue
        do 5527i=itwmin,itwmax
          ntwq(i)=1
5527    continue
        nrefav=2*(itwmax-itwmin+1)*NRef90
        call MoveFile(fln(:ifln)//'.l91',fln(:ifln)//'.l90',.false.)
        iqmax=1
      endif
5550  if(FEYesNo(-1.,-1.,'Do you want to average reflections?',1)) then
        call OpenFile(90,fln(:ifln)//'.l90','formatted','unknown')
        if(ErrJana.ne.0) go to 9200
        call OpenFile(91,fln(:ifln)//'.l91','formatted','unknown')
        if(ErrJana.ne.0) go to 9200
        NRef91=0
        Prumer=.false.
        call SetRealArrayTo(rnum ,11,0.)
        call SetRealArrayTo(rden ,11,0.)
        call SetRealArrayTo(ronum,11,0.)
        call SetRealArrayTo(roden,11,0.)
        call SetRealArrayTo(resdnum ,11,0.)
        call SetRealArrayTo(resdden ,11,0.)
        call SetRealArrayTo(roesdnum,11,0.)
        call SetRealArrayTo(roesdden,11,0.)
        call SetIntArrayTo(nrefi ,11,0)
        call SetIntArrayTo(norefi,11,0)
        call SetIntArrayTo(nrefa ,11,0)
        call SetIntArrayTo(norefa,11,0)
        mmMax=0
        call NewPg(0)
        call TitulekVRamecku('Report from averaging reflections')
        call EM9Average(0,0,0,ich)
        if(ich.ne.0) then
          call CloseIfOpened(90)
          call CloseIfOpened(91)
          go to 6900
        endif
        call FeFlowChartOpen(-1.,-1.,max(nint(float(nrefav)*.005),10),
     1                       nrefav,'Averaging reflections from M95',
     2                       ' ',' ')
        do 5620i=itwmin,itwmax
          if(i.eq.0) go to 5620
          do 5610j=1,ntwq(i)
            if(line.gt.40) then
              call NewPg(0)
            endif
            if(itwmax.gt.itwmin.or.ntwq(i).gt.1) then
              call newln(3)
              if(itwmax.gt.itwmin) then
                if(ntwq(i).le.1) then
                  write(lst,'(/''Averaging from '',i2,a2,
     1                         '' domain fraction''/)') i,nty(i)
                else
                  write(lst,'(/''Averaging of '',i2,a2,
     1                         '' domain fraction, scale #'',i2/)')
     2              i,nty(i),j
                endif
              else
                write(lst,'(/''Averaging date with scale #'',i2/)') j
              endif
            endif
            call EM9Average(i,j,1,ich)
            if(ich.ne.0) go to 9100
5610      continue
5620    continue
        call FeFlowChartRemove
        write(91,'('' 999'')')
        close(90,status='delete')
        call NewPg(0)
        call TitulekVRamecku('Summary of reflections after averaging')
        i=ndim+6
        if(ncull.gt.0) i=i+1
        call Newln(i)
        do 5630i=1,ndim
          ihmin(i)= 9999
          ihmax(i)=-9999
5630    continue
        rcc=0.
        rjc=0.
        rcn=0.
        rjn=0.
        NRef91Obs=0
        rewind 91
5700    read(91,format91)(ih(k),k=1,ndim),ri,rs,iq,nxx,itw,tbar
        if(ih(1).gt.900) go to 5800
c        iatw=iabs(itw)
        do 5710i=1,6
          ihmax(i)=max(ihmax(i),ih(i))
          ihmin(i)=min(ihmin(i),ih(i))
5710    continue
        call FromIndSinthl(ih,h,sinthl,sinthlq,1,0)
        rcc=rcc+rs
        rjc=rjc+ri
        NRef91=NRef91+1
        if(anint(ri*10.).gt.EM9ObsLim*anint(rs*10.)) then
          rcn=rcn+rs
          rjn=rjn+ri
          NRef91Obs=NRef91Obs+1
          sp(NRef91Obs)=sinthl
          fp(NRef91Obs)=ri
        endif
        go to 5700
5800    Ninfo=ndim+4
        if(ncull.ge.0) Ninfo=Ninfo+1
        if(prumer) then
          rave=rnum(1)/rden(1)
          if(roden(1).gt.0.) then
            write(t80,'(f6.2,''/'',f6.2)') ronum(1)/roden(1)*100.,
     1                                     rave*100.
          else
            if(rden(1).gt.0.) then
              write(t80,'(''-----/'',f6.2)') rnum(1)/rden(1)*100.
            else
              write(t80,'(''-----/-----'')')
            endif
          endif
        else
          write(t80,'(''-----/-----'')')
        endif
        call Zhusti(t80)
        TextInfo(1)='Rint(obs/all) = '//t80(:idel(t80))
        write(t80,100) NRef91Obs,NRef91
        call Zhusti(t80)
        j=idel(TextInfo(1))
        TextInfo(1)=TextInfo(1)(:j)//' for '//t80(:idel(t80))//
     1              ' reflections'
        write(t80,100) NRef90Obs,NRef90
        call Zhusti(t80)
        TextInfo(2)=' '
        TextInfo(2)=TextInfo(2)(:j-9)//'averaged from '//t80(:idel(t80))
     1            //' reflections'
        write(t80,'(f10.3)') float(NRef90)/float(NRef91)
        call ZdrcniCisla(t80,1)
        TextInfo(3)='Redundancy = '//t80(:idel(t80))
        do 5815k=1,3
          write(lst,FormA1)(TextInfo(k)(j:j),j=1,idel(TextInfo(k)))
5815    continue
        write(lst,FormA1)
        do 5820i=1,ndim
          write(TextInfo(i+3),105) indices(i),ihmin(i),
     1                             indices(i),ihmax(i)
          write(lst,FormA1)(TextInfo(i+3)(j:j),j=1,idel(TextInfo(i+3)))
5820    continue
        rn=rcn/rjn*100.
        rc=rcc/rjc*100.
        write(lst,FormA1)
        i=ndim+4
        write(TextInfo(i),104) rn,rc
        write(lst,FormA1)(TextInfo(i)(j:j),j=1,idel(TextInfo(i)))
        if(ncull.ge.0) then
          if(ncull.gt.0) then
            write(t80,FormI15) ncull
            call zhusti(t80)
            t80=t80(:idel(t80))//' reflections were culled'
          else
            t80='no reflection was culled'
          endif
          i=i+1
          TextInfo(i)='Information from culling : '//t80(:idel(t80))
          write(lst,FormA1)(TextInfo(i)(j:j),j=1,idel(TextInfo(i)))
        endif
        call FeInfoOut(-1.,-1.,'Summary of reflections after averaging')
        if(ndimi.gt.0) then
          call Newln(14)
          write(lst,'(/''Rint and other characteritics as a function '',
     1                ''of satellite index''/)')
          ven(1)='Satelite index'
          l=20
          do 5900i=2,mmMax
            write(Cislo,'(6x,''+-('',i1,'')'')') i-2
            if(i.eq.2) Cislo(7:8)='  '
            ven(1)(l:)=Cislo(:11)
            l=l+11
5900      continue
          write(lst,FormA1)(ven(1)(l:l),l=1,idel(Ven(1)))
          write(lst,FormA80)
          ven(1)='Obs  Resd'
          ven(2)='     Rint'
          ven(3)='     Number'
          ven(4)='     Averaged from'
          l=20
          do 5905i=2,mmMax
            if(roesdden(i).gt.0.) then
              write(ven(1)(l:),'(f11.2)') roesdnum(i)/roesdden(i)*100.
            else
              ven(1)(l:)='     ------'
            endif
            if(roden(i).gt.0.) then
              write(ven(2)(l:),'(f11.2)') ronum(i)/roden(i)*100.
            else
              ven(2)(l:)='     ------'
            endif
            write(ven(3)(l:),'(i11)') norefa(i)
            write(ven(4)(l:),'(i11)') norefi(i)
            l=l+11
5905      continue
          do 5906i=1,4
            write(lst,FormA1)(ven(i)(l:l),l=1,idel(Ven(i)))
5906      continue
          write(lst,FormA80)
          ven(1)='All  Resd'
          l=20
          do 5910i=2,mmMax
            if(resdden(i).gt.0.) then
              write(ven(1)(l:),'(f11.2)') resdnum(i)/resdden(i)*100.
            else
              ven(1)(l:)='     ------'
            endif
            if(rden(i).gt.0.) then
              write(ven(2)(l:),'(f11.2)') rnum(i)/rden(i)*100.
            else
              ven(2)(l:)='     ------'
            endif
            write(ven(3)(l:),'(i11)') nrefa(i)
            write(ven(4)(l:),'(i11)') nrefi(i)
            l=l+11
5910      continue
          do 5911i=1,4
            write(lst,FormA1)(ven(i)(l:l),l=1,idel(Ven(i)))
5911      continue
        endif
        if(kcommen.ne.0) then
          k=NRef91
          call iom50(0,0)
          NRef91=k
        endif
        if(NRef91Obs.gt.7) then
          call heap(NRef91Obs,sp)
          call heap(NRef91Obs,fp)
          sinmez(8)=sp(NRef91Obs)+.000001
          fmez(8)=fp(NRef91Obs)+.1
          d=0.
          dd=float(NRef91Obs)*.125
          do 6100i=1,7
            d=d+dd
            j=d
            sinmez(i)=(sp(j)+sp(j+1))*.5
            fmez(i)=(fp(j)+fp(j+1))*.5
6100      continue
        endif
        if(m89opened) then
          if(Prumer) then
            write(89,108) rave,rc*.01
          else
            write(89,108) 0.,rc*.01
          endif
        endif
        go to 7000
      endif
6900  call MoveFile(fln(:ifln)//'.l90 ',fln(:ifln)//'.l91',.false.)
      NRef91=NRef90
      if(m89opened) write(89,108) 0.,rc*.01
      call CloseIfOpened(91)
7000  do 7100i=1,6
        ihmax(i)=max(iabs(ihmin(i)),iabs(ihmax(i)))
7100  continue
8000  NInfo=3
      TextInfo(1)='Accept the new M91 and calculate coverage'
      TextInfo(2)='Accept the new M91'
      TextInfo(3)='Do not accept the new M91'
      AcceptM91=FeSelectOnePossibility(-1.,-1.,0,1)
      if(AcceptM91.ne.3) then
        call MoveFile(fln(:ifln)//'.l91',fln(:ifln)//'.m91',.false.)
        call iom50(1,0)
        if(AcceptM91.eq.1) call EM9CheckCompleteness(ThMax,mlim)
        M91Changed=.true.
        if(m89opened) then
          if(PerLimit.lt.101.) then
            write(89,'(''thfull:'',2f8.2)') ThFull,PerLimit*.01
          else
            write(89,'(''thfull: ?'')')
          endif
        endif
        if(m89opened) write(89,'(''end'')')
        call CloseIfOpened(89)
      else
        call DeleteFile(PreviousM50)
        call DeleteFile(fln(:ifln)//'.l91')
        close(89,status='delete')
      endif
      go to 9900
9000  call FeReadError(95)
9100  call FeFlowChartRemove
9200  close(89,status='delete')
9900  call CloseListing
      do 9910i=89,91
        call CloseIfOpened(i)
9910  continue
      call CloseIfOpened(95)
      t256=fln(:ifln)//'_makem91.tmp'
      if(ExistFile(t256).and.ErrJana.eq.0) call UpdateSummary('makem91')
9999  return
100   format(i15,'/'i15)
101   format(6i4)
102   format(1x,3f9.1)
103   format('Exported ',i6,' reflections, ',i6,' observed ones')
104   format('R(obs/all) from e.s.d. of I : ',f5.2,'/',f5.2)
105   format(17x,a1,'(min) = ',i4, ', ',a1,'(max) = ',i4)
108   format('Rave:',2f8.4)
      end
      subroutine EM9OutputOfRejected(Key,N,N500,NObs,avis,ihap,riap,
     1                               rsap,ipor)
      include 'params.cmn'
      include 'basic.cmn'
      include 'editm9.cmn'
      include 'fepc.cmn'
      integer riap(*),rsap(*),ipor(*),ihap(6,*)
      character*80 t80,p80,ta80(2),Veta
      equivalence (t80,ta80(1)),(p80,ta80(2))
      if(N.gt.0) then
        if(Key.eq.1) then
          t80='Summary of reflections absent due to systematic '//
     1        'extinctions'
        else
          t80='Summary of reflections which could not be transformed '//
     1        'to integer indices'
        endif
        call TitulekVRamecku(t80)
        avis=avis/float(N)
        write(t80,'(''Overall           n(all) :'',i5,'', n(obs) :'',
     1              i5)') N,NObs
        call newln(1)
        write(lst,FormA1)(t80(i:i),i=1,idel(t80))
        NInfo=1
        TextInfo(NInfo)=t80
        write(t80,'(18x,''Average(I/Sig(I)) : '',f5.2)') avis
        call newln(1)
        write(lst,FormA1)(t80(i:i),i=1,idel(t80))
        NInfo=NInfo+1
        TextInfo(NInfo)=t80
        call newln(1)
        write(lst,FormA1)
        NInfo=NInfo+1
        if(N500.le.0) then
          if(Key.eq.1) then
            t80='All absent'
          else
            t80='All rejected'
          endif
          t80=t80(:idel(t80))//' reflections classified as unobserved'
          TextInfo(NInfo)=t80
          call NewLn(1)
          write(lst,FormA1)(t80(i:i),i=1,idel(t80))
        else
          if(N500.ne.500) call Indexx(N500,riap,ipor)
          if(Line.gt.50) call NewPg(0)
          if(Key.eq.1) then
            p80='List of the strongest absent reflections'
          else
            p80='List of the strongest rejected reflections'
          endif
          call NewLn(1)
          write(lst,FormA1)(p80(i:i),i=1,idel(p80))
          if(Key.eq.2) then
            Veta='Indices are related to the original cell !!!'
            call NewLn(1)
            write(lst,FormA1)(Veta(i:i),i=1,idel(p80))
          endif
          call NewLn(1)
          write(lst,FormA1)
          write(t80,EM9Form1)(indices(i),i=1,ndim)
          idl=idel(t80)+1
          t80(idl:)='       I      sig(I)  I/sig(I)'
          idlp=idel(t80)
          call newln(1)
          write(lst,FormA1)(t80(i:i),i=1,idlp),(' ',i=1,10),
     1                     (t80(i:i),i=1,idlp)
          TextInfo(NInfo)=' '
          j=idlp
          do 5230i=1,Ninfo-1
            j=max(j,idel(TextInfo(i)))
5230      continue
          i=idel(p80)
          j=(j-i)/2
          TextInfo(NInfo)(j:)=p80(:i)
          if(Key.eq.2) then
            NInfo=NInfo+1
            TextInfo(NInfo)=Veta
          endif
          NInfo=NInfo+1
          TextInfo(NInfo)=t80
          do 5235i=1,min(18-NInfo,N500)
            Ninfo=Ninfo+1
            kk=ipor(i)
            write(TextInfo(NInfo),EM9Form2)(ihap(j,kk),j=1,ndim)
            pom1=-float(riap(kk))*.0001
            pom2= float(rsap(kk))*.01
            write(TextInfo(NInfo)(idl:),100) pom1*pom2,pom2,pom1
5235      continue
          m=min(2*(mxline-Line),N500)
          ks=0
5240      k=ks
          if(mod(m,2).eq.1) m=m+1
          do 5250i=1,m
            ip=mod(i-1,2)+1
            ks=ks+1
            if(ks.gt.N500) go to 5245
            if(ip.eq.1) then
              k=k+1
              kk=ipor(k)
            else
              kk=ipor(k+m/2)
            endif
            write(ta80(ip),EM9Form2)(ihap(j,kk),j=1,ndim)
            pom1=-float(riap(kk))*.0001
            pom2= float(rsap(kk))*.01
            write(ta80(ip)(idl:),100) pom1*pom2,pom2,pom1
5245        if(ip.eq.2) then
              call newln(1)
              write(lst,FormA1)(ta80(1)(j:j),j=1,idlp),(' ',j=1,10),
     1                         (ta80(2)(j:j),j=1,idlp)

              ta80(2)=' '
            endif
5250      continue
          if(ks.lt.N500) then
            m=min(2*(mxline-3),N500-ks)
            go to 5240
          endif
        endif
        if(Key.eq.1) then
          t80='Summary of systematic extinctions'
        else
          t80='Summary of rejected reflections'
        endif
        call FeInfoOut(-1.,-1.,t80)
      endif
9999  return
100   format(1x,2f9.1,f9.1)
      end
      subroutine EM9Average(kitw,kiq,klic,ich)
      parameter (mxgrav=500)
      include 'params.cmn'
      include 'basic.cmn'
      include 'fepc.cmn'
      include 'editm9.cmn'
      include 'datred.cmn'
      dimension ihmaxp(6),maxi(6),maxip(6),tp(mxref),icull(mxgrav),
     1          mp(36),kpor(mxgrav)
      character*80 t80
      character*20 FormRefAve
      character*42 iven(mxl4)
      character*4  iven1
      integer EM9SortIndex
      logical tisk,lcull,Psal,CrwLogicQuest
      equivalence (tp,riar)
      save mxl34,ncsp,flimp,fcullp,izp,Psal,FormRefAve
      data flim,fcull/5.,-1./,iven,isigm/mxl4*' ',1/,ix,iz/1,3/
      data MultUse/1/
      rewind 90
      if(klic.eq.0) then
        if(ndim.gt.3) then
          mxl34=3*(mxline-5)
        else
          mxl34=4*(mxline-5)
        endif
        FormRefAve='(3i4,f 9.1,f 6.1,a4)'
        if(ndim.gt.3) then
          n=20-2*ndim
          write(FormRefAve(2:2),102) ndim
          write(FormRefAve(7:8),106) n
          write(FormRefAve(13:14),106) n-2
          FormLabAve='(3(''   h   k   l'
          if(ndim.gt.3) FormLabAve=FormLabAve(:idel(FormLabAve))//'   m'
          if(ndim.gt.4) FormLabAve=FormLabAve(:idel(FormLabAve))//'   n'
          if(ndim.gt.5) FormLabAve=FormLabAve(:idel(FormLabAve))//'   p'
          t80=''',  x,''I '',  x,''sig(I)'',3x)/)'
          write(t80(3:4),106) n-2
          write(t80(12:13),106) n-7
          FormLabAve=FormLabAve(:idel(FormLabAve))//t80(:idel(t80))
        else
          FormLabAve='(4(''   h   k   l      I    sig(I)   '')/)'
        endif
        flimo=flim
        fcullo=fcull
        id=NextQuestId()
        il=12
        xdq=215.
        call FeQuestCreate(id,-1.,-1.,xdq,0,il,'Averaging parameters',
     1                     0,LightGray,0,0)
        xpom=124.
        il=1
        do 1000i=1,3
          call FeQuestCrwMake(id,xpom,il,xpom-4.,il+1,indices(i),'C',
     1                        CrwgXd,CrwgYd,1,1)
          if(i.eq.1) then
            nCrwSlowFrom=CrwLastMade
          else if(i.eq.3) then
            nCrwSlowTo=CrwLastMade
          endif
          call FeQuestCrwOpen(CrwLastMade,i.eq.iz)
          xpom=xpom+14.
1000    continue
        il=il+1
        call FeQuestLabelMake(id,5.,il,'The slowest varying index','L')
        il=il+1
        call FeQuestLabelMake(id,5.,3,'The fastest varying index','L')
        xpom=124.
        do 1050i=1,3
          call FeQuestCrwMake(id,xpom,il,xpom-4.,il,' ','C',CrwgXd,
     1                        CrwgYd,1,2)
          if(i.eq.1) then
            nCrwFastFrom=CrwLastMade
          else if(i.eq.3) then
            nCrwFastTo=CrwLastMade
          endif
          if(i.ne.iz) call FeQuestCrwOpen(CrwLastMade,i.eq.ix)
          xpom=xpom+14.
1050    continue
        il=il+1
        call FeQuestLineMake(id,il)
        il=il+1
        call FeQuestCrwMake(id,5.,il,43.,il,'%Full print','L',CrwXd,
     1                      CrwYd,1,0)
        nCrwPrint=CrwLastMade
        call FeQuestCrwOpen(CrwLastMade,flim.lt.0.)
        call FeQuestCrwMake(id,59.,il,108.,il,'Apply c%ulling','L',
     1                      CrwXd,CrwYd,1,0)
        nCrwCull=CrwLastMade
        call FeQuestCrwOpen(CrwLastMade,fcull.gt.0.)
        ncsp=1
        do 1100i=1,NPhase
          ncsp=max(ncsp,ncsArr(i))
1100    continue
        if(ncsp.ne.1) then
          call FeQuestCrwMake(id,122.,il,202.,il,
     1                        'Add ce%nter of symmetry','L',CrwXd,CrwYd,
     2                        0,0)
          nCrwCSym=CrwLastMade
          call FeQuestCrwOpen(CrwLastMade,.false.)
        endif
        il=il+1
        t80='Reflections |I-I(ave)|>'
        call FeQuestLabelMake(id,5.,il,t80,'L')
        xpom=FeTxLength(t80)+7.
        call FeQuestEdwMake(id,xpom+22.,il,xpom,il,
     1                      '*sig(I(ave)) will be %printed','L',20.,
     2                      EdwYd,0)
        nEdwPrint=EdwLastMade
        if(flim.ge.0.) then
          call FeQuestRealEdwOpen(1,flim,.false.,.false.)
        else
          flimp=5.
        endif
        il=il+1
        t80='Reflections |I-I(ave)|>'
        call FeQuestLabelMake(id,5.,il,t80,'L')
        xpom=FeTxLength(t80)+7.
        call FeQuestEdwMake(id,xpom+22.,il,xpom,il,
     1                      '*sig(I(ave)) will be %culled','L',20.,
     2                      EdwYd,0)
        nEdwCull=EdwLastMade
        if(fcull.ge.0.) then
          call FeQuestRealEdwOpen(2,fcull,.false.,.false.)
        else
          fcullp=20.
        endif
        il=il+1
        call FeQuestLineMake(id,il)
        il=il+1
        tpom=5.
        call FeQuestLabelMake(id,tpom,il,'Sigma(I(ave)) from:','L')
        ilp=il
        xpom=tpom+60.
        do 1200i=1,3
          il=il+1
          if(i.eq.1) then
            t80='P%oisson'
          else if(i.eq.2) then
            t80='%Equivalents'
          else
            t80='%Maximum'
          endif
          call FeQuestCrwMake(id,tpom,il,xpom,il,t80,'L',CrwgXd,CrwgYd,
     1                        0,3)
          if(i.eq.1) then
            nCrwPoisson=CrwLastMade
          else if(i.eq.2) then
            nCrwEquivalent=CrwLastMade
          else
            nCrwMaximum=CrwLastMade
          endif
          call FeQuestCrwOpen(CrwLastMade,i.eq.isigm)
1200    continue
        if(DifCode.eq.IdKumaPD) then
          tpom=tpom+xdq*.5
          xpom=xpom+xdq*.5
          t80='Multiply measured reflections:'
          il=ilp
          call FeQuestLabelMake(id,tpom,il,t80,'L')
          do 1300i=1,3
            il=il+1
            if(i.eq.1) then
              t80='use %all'
            else if(i.eq.2) then
              t80='use f%irst'
            else
              t80='use %last'
            endif
            call FeQuestCrwMake(id,tpom,il,xpom,il,t80,'L',CrwgXd,
     1                          CrwgYd,0,4)
            if(i.eq.1) then
              nCrwUseAll=CrwLastMade
            else if(i.eq.2) then
              nCrwUseFirst=CrwLastMade
            else
              nCrwUseLast=CrwLastMade
            endif
            call FeQuestCrwOpen(CrwLastMade,i.eq.MultUse)
1300      continue
        endif
        icont=0
1500    call FeQuestEvent(id,icont,ich)
        icont=1
        if(CheckType.eq.EventCrw) then
          if(CheckNumber.ge.nCrwSlowFrom.and.
     1       CheckNumber.le.nCrwSlowTo)  then
            if(iz.ne.CheckNumber) then
              izn=CheckNumber-nCrwSlowFrom+1
              call FeQuestCrwClose(izn+nCrwFastFrom-1)
              call FeQuestCrwOpen(iz-nCrwSlowFrom+nCrwFastFrom,
     1                            ix.eq.izn)
              if(ix.eq.izn) ix=iz
              iz=izn
            endif
          else if(CheckNumber.ge.nCrwFastFrom.and.
     1            CheckNumber.le.nCrwFastTo)  then
            ix=CheckNumber-nCrwFastFrom+1
          else if(CheckNumber.eq.nCrwPrint) then
            if(CrwLogicQuest(CheckNumber)) then
              call FeQuestRealFromEdw(nEdwPrint,flimp)
              call FeQuestEdwClose(nEdwPrint)
              flim=-1.
            else
              flim=flimp
              call FeQuestRealEdwOpen(nEdwPrint,flim,.false.,.false.)
            endif
          else if(CheckNumber.eq.nCrwCull) then
            if(CrwLogicQuest(CheckNumber)) then
              fcull=fcullp
              call FeQuestRealEdwOpen(nEdwCull,fcull,.false.,.false.)
            else
              call FeQuestRealFromEdw(nEdwCull,fcullp)
              call FeQuestEdwClose(nEdwCull)
              fcull=-1.
            endif
          endif
          EventType=EventEdw
          EventNumber=1
          go to 1500
        else if(CheckType.ne.0) then
          call NebylOsetren
          go to 1500
        endif
        if(ich.eq.0) then
          if(flim .ge.0.) call FeQuestRealFromEdw(nEdwPrint,flim)
          if(fcull.ge.0.) call FeQuestRealFromEdw(nEdwCull,fcull)
          if(CrwLogicQuest(nCrwPoisson)) then
            isigm=1
          else if(CrwLogicQuest(nCrwEquivalent)) then
            isigm=2
          else if(CrwLogicQuest(nCrwMaximum)) then
            isigm=3
          endif
          if(DifCode.eq.IdKumaPD) then
            if(CrwLogicQuest(nCrwUseAll)) then
              MultUse=1
            else if(CrwLogicQuest(nCrwUseFirst)) then
              MultUse=2
            else if(CrwLogicQuest(nCrwUseLast)) then
              MultUse=3
            endif
          endif
          if(ncsp.ne.1) then
            if(CrwLogicQuest(nCrwCSym)) ncsp=1
          endif
        endif
        call FeQuestRemove(id)
        if(ich.ne.0) then
          flim=flimo
          fcull=fcullo
          go to 9999
        endif
        itr(3)=ix
        itr(1)=iz
        itr(2)=6-itr(1)-itr(3)
        do 2000i=4,ndim
          itr(i)=i
2000    continue
c        do 2400KPh=1,NPhase
c          call RestorePhase(KPh)
c          do 2300i=1,ns
c            do 2200j=1,ndim
c              do 2100k=1,ndim
c                mp(k+ndim*(j-1))=mr6(k+ndim*(itr(j)-1),i,1,KPh)
c2100          continue
c2200        continue
c            call CopyMatI(mp,mr6(1,i,1,KPh),ndim)
c2300      continue
c2400    continue
        izp=0
        if(ncsp.ne.ncs) then
          call NewLn(2)
          write(lst,'(''Center of symmetry will be applied even if '',
     1                ''the space group is acentric'')')
          write(lst,FormA1)
        endif
        call NewLn(2)
        if(flim.ne.0.) then
          if(flim.gt.0.) then
            write(lst,'(''Only reflections |I-I(ave)|>'',f5.1,
     1                  ''*sig(I(ave)) will be printed'')') flim
            write(lst,FormA1)
          else
            write(lst,'(''Full print averaged reflections'')')
            write(lst,FormA1)
          endif
          call newln(5)
          write(lst,'(''Symbol *    means that for this reflection '',
     1                '' 3*sig<|I(i)-I(ave)|< 5*sig(I(ave))''/
     2                ''Symbol **   means that for this reflection '',
     3                '' 5*sig<|I(k)-I(ave)|<10*sig(I(ave))''/
     4                ''Symbol ***  means that for this reflection '',
     5                ''10*sig<|I(k)-I(ave)|<20*sig(I(ave))''/
     6                ''Symbol **** means that for this reflection '',
     7                ''20*sig(I(ave))<|I(k)-I(ave)|'')')
          write(lst,FormA1)
        else
          write(lst,'(''Print averaged reflections suppressed'')')
          write(lst,FormA1)
        endif
        if(fcull.gt.0.) then
          call NewLn(2)
          write(lst,'(''Reflections |I-I(ave)|>'',f5.1,
     1                ''*sig(I(ave)) will be culled'')') fcull
          write(lst,FormA1)
        endif
        if(fcull.gt.0.) then
          ncull=0
        else
          ncull=-1
        endif
        return
      endif
      n=0
      call SetIntArrayTo(ihmax ,6,0)
      call SetIntArrayTo(ihmaxp,6,0)
      rewind 90
      call RestorePhase(1)
3000  read(90,format91)(ih(i),i=1,ndim),ri,rs,iq,nxx,itw,tbar
      if(ih(1).gt.900) go to 3200
      call FeFlowChartEvent(izp,ie)
      if(ie.ne.0) then
        call FeBudeBreak
        if(ErrJana.ne.0) go to 9000
      endif
      if(iq.ne.kiq.or.itw.ne.kitw) go to 3000
      n=n+1
      if(n.gt.mxref) go to 8100
      do 3030i=1,ndim
        ihmax(i)=max(ihmax(i),iabs(ih(i)))
3030  continue
      fia(n)=ri
      sigfia(n)=rs
      tp(n)=tbar
      do 3100i=1,ns
        call GetSymIndRespectTwin(ih,ihp,itr,kitw,i,ncsp,ichp)
        if(ichp.ne.0) go to 3100
        do 3050j=1,ndim
          ihmaxp(j)=max(ihmaxp(j),iabs(ihp(j)))
3050    continue
3100  continue
      go to 3000
3200  if(n.le.0) return
      rewind 90
      n=0
      maxi(6)=1
      do 3220i=5,1,-1
        maxi(i)=maxi(i+1)*(2*ihmax(i+1)+1)
        if(imax/maxi(i).lt.2*ihmax(i)+1) go to 8000
3220  continue
      maxip(6)=1
      do 3240i=5,1,-1
        maxip(i)=maxip(i+1)*(2*ihmaxp(i+1)+1)
        if(imax/maxip(i).lt.2*ihmaxp(i)+1) go to 8000
3240  continue
3300  read(90,format91)(ih(i),i=1,ndim),ri,rs,iq,nxx,itw,tbar
      if(ih(1).gt.900) go to 3500
      call FeFlowChartEvent(izp,ie)
      if(ie.ne.0) then
        call FeBudeBreak
        if(ErrJana.ne.0) go to 9000
      endif
      if(iq.ne.kiq.or.itw.ne.kitw) go to 3300
      n=n+1
      mx=0
      do 3330i=1,ndim
        mx=mx+(ih(i)+ihmax(i))*maxi(i)
3330  continue
      irec(n)=mx
      mx=0
      do 3400i=1,ns
        do 3360j=1,3-min(ncs,ncsp)
          if(j.eq.1) then
            call GetSymIndRespectTwin(ih,ihp,itr,kitw,i,ncsp,ichp)
            if(ichp.ne.0) go to 3360
          else
            call GetSymIndRespectTwin(ih,ihp,itr,kitw,-i,ncsp,ichp)
            if(ichp.ne.0) go to 3360
          endif
          mxq=0
          do 3350k=1,ndim
            mxq=mxq+(ihp(k)+ihmaxp(k))*maxip(k)
3350      continue
          if(mxq.gt.mx) mx=mxq
3360    continue
3400  continue
      irecp(n)=mx
      go to 3300
3500  call indexx(n,irecp,ipor)
      lines=line
      if(ndim.eq.3) then
        mxln=mxl34-(line-3)*4
      else
        mxln=mxl34-(line-3)*3
      endif
      Psal=.false.
      line=0
      kolik=1
      kk=0
4000  call SetIntArrayTo(icull,mxgrav,0)
      call SetIntArrayTo(kpor ,mxgrav,0)
      lcull=.false.
      kp=kk+1
      if(kp.gt.n.or.ipor(kp).le.0) go to 5000
      kn=0
      j=ipor(kp)
      irecpHledany=irecp(j)
      do 4020ii=1,ndim
        k=itr(ii)
        if(ii.eq.1) then
          ihp(k)=irecpHledany/maxip(ii)-ihmaxp(ii)
        else
          ihp(k)=mod(irecpHledany,maxip(ii-1))/maxip(ii)-ihmaxp(ii)
        endif
4020  continue
4030  kk=kk+1
      if(kk.gt.n.or.ipor(kk).le.0) go to 5000
      j=ipor(kk)
      if(irecp(j).eq.irecpHledany) then
        kn=kn+1
        kpor(kn)=ipor(kk)
        if(kk.lt.n) go to 4030
      else
        kk=kk-1
      endif
      if(MultUse.gt.1) then
        do 4040i=1,kn-1
          ki=kpor(i)
          if(ki.le.0) go to 4040
          do 4035j=i+1,kn
            kj=kpor(j)
            if(kj.le.0) go to 4035
            if(irec(ki).eq.irec(kj)) then
              if(MultUse.eq.2) then
                kpor(j)=-kj
              else
                kpor(i)=-ki
                go to 4040
              endif
            endif
4035      continue
4040    continue
      endif
4060  s1=0.
      s2=0.
      s4=0.
      s5=0.
      do 4100i=1,kn
        if(icull(i).eq.0) then
          j=kpor(i)
          if(j.gt.0) then
            if(s2.le.0.) jprv=j
            s1=s1+fia(j)
            s2=s2+1.
            s4=s4+sigfia(j)**2
            s5=s5+tp(j)
          endif
        endif
4100  continue
      if(s2.gt.1.5) then
        s1=s1/s2
        s4=sqrt(s4)/s2
        s5=s5/s2
        s3=0.
        prumer=.true.
        do 4200i=1,kn
          if(icull(i).ne.0) go to 4200
          j=kpor(i)
          if(j.gt.0) then
            dif=abs(fia(j)-s1)
            s3=s3+dif**2
          endif
4200    continue
        pom=sqrt(s3/(s2*(s2-1.)))
        if(isigm.eq.1) then
          s3=s4
        else if(isigm.eq.2) then
          s4=s4*.5
          if(pom.lt.s4) then
            s3=s4
          else
            s3=pom
          endif
        else
          s3=max(pom,s4)
        endif
        tisk=.false.
        difmax=0.
        do 4220i=1,kn
          if(icull(i).ne.0) go to 4220
          j=kpor(i)
          if(j.gt.0) then
            dif=abs(fia(j)-s1)
            tisk=tisk.or.(dif.gt.flim*s3)
            dif=dif/s3
            if(dif.gt.difmax) then
              difmax=max(difmax,dif)
              kmax=i
            endif
          else
            Tisk=.true.
          endif
4220    continue
        if(fcull.gt.0..and.difmax.gt.fcull.and.s2.gt.2.5) then
          icull(kmax)=1
          lcull=.true.
          ncull=ncull+1
          go to 4060
        endif
        if(tisk.or.lcull.or.flim.lt.0.) then
          line=line+1
          write(iven(line),FormRefAve)(ihp(k),k=1,ndim),s1,s3,'    '
          do 4230k=1,4
            if(iven(line)(k:k).eq.' ') iven(line)(k:k)='>'
4230      continue
          if(line.eq.mxln) then
            call EM9OutSta(iven)
            call newpg(0)
            line=0
            Psal=.true.
            mxln=mxl34
          endif
          do 4250i=1,kn
            j=kpor(i)
            ja=iabs(j)
            pom=abs(fia(ja)-s1)/s3
            if(j.le.0) then
              iven1='Skip'
            else if(icull(i).ne.0) then
              iven1='Cull'
            else if(pom.le.3.) then
              iven1=' '
            else if(pom.le.5.) then
              iven1='*'
            else if(pom.le.10.) then
              iven1='**'
            else if(pom.le.20.) then
              iven1='***'
            else
              iven1='****'
            endif
            l=irec(ja)
            if(l.le.0) go to 4250
            do 4240ii=1,ndim
              if(ii.eq.1) then
                ih(ii)=l/maxi(ii)-ihmax(ii)
              else
                ih(ii)=mod(l,maxi(ii-1))/maxi(ii)-ihmax(ii)
              endif
4240        continue
            line=line+1
            write(iven(line),FormRefAve)(ih(l),l=1,ndim),fia(ja),
     1                                   sigfia(ja),iven1
            if(line.eq.mxln) then
              Psal=.true.
              call EM9OutSta(iven)
              call newpg(0)
              line=0
              mxln=mxl34
            endif
4250      continue
          line=line+1
          iven(line)=' '
          if(line.eq.mxln) then
            Psal=.true.
            call EM9OutSta(iven)
            call newpg(0)
            line=0
            mxln=mxl34
          endif
        endif
      else
        s1=fia(jprv)
        s3=sigfia(jprv)
        s5=tp(jprv)
      endif
      mm=EM9SortIndex(ihp)
      if(s2.gt.1.5) then
        do 4500i=1,kn
          j=kpor(i)
          if(j.le.0.or.icull(i).ne.0) go to 4500
          pom=fia(j)
          nrefi(mm)=nrefi(mm)+1
          if(anint(pom*10.).gt.EM9ObsLim*anint(sigfia(j)*10.))
     1       norefi(mm)=norefi(mm)+1
          apom=abs(pom-s1)
          rnum(1)=rnum(1)+apom
          rden(1)=rden(1)+pom
          if(anint(s1*10.).gt.EM9ObsLim*anint(s3*10.)) then
            ronum(1)=ronum(1)+apom
            roden(1)=roden(1)+pom
          endif
          if(ndimi.gt.0) then
            mmp=min(mm,10)
            mmMax=max(mmp,mmMax)
            rnum(mmp)=rnum(mmp)+apom
            rden(mmp)=rden(mmp)+pom
            if(i.eq.1) nrefa(mmp)=nrefa(mmp)+1
            if(anint(s1*10.).gt.EM9ObsLim*anint(s3*10.)) then
              ronum(mmp)=ronum(mmp)+apom
              roden(mmp)=roden(mmp)+pom
              if(i.eq.1) norefa(mmp)=norefa(mmp)+1
            endif
          endif
4500    continue
      else
        if(ndimi.gt.0) then
          mmp=min(mm,10)
          mmMax=max(mmp,mmMax)
          nrefa(mmp)=nrefa(mmp)+1
          nrefi(mmp)=nrefi(mmp)+1
          if(anint(s1*10.).gt.EM9ObsLim*anint(s3*10.)) then
            norefa(mmp)=norefa(mmp)+1
            norefi(mmp)=norefi(mmp)+1
          endif
        endif
      endif
      if(ndimi.gt.0) then
        resdnum(mm)=resdnum(mm)+s3
        resdden(mm)=resdden(mm)+s1
        if(anint(s1*10.).gt.EM9ObsLim*anint(s3*10.)) then
          roesdnum(mm)=roesdnum(mm)+s3
          roesdden(mm)=roesdden(mm)+s1
        endif
      endif
      write(91,format91)(ihp(k),k=1,ndim),s1,s3,kiq,nxx,kitw,s5
      go to 4000
5000  if(line.gt.0) then
        i=line
        call EM9OutSta(iven)
        if(ndim.eq.3) then
          if(mxln.eq.mxl34) then
            line=(i-1)/4+6
          else
            line=lines+(i-1)/4+3
          endif
        else
          if(mxln.eq.mxl34) then
            line=(i-1)/3+6
          else
            line=lines+(i-1)/3+3
          endif
        endif
      else
        if(Psal) then
          line=3
        else
          line=lines
        endif
      endif
      return
8000  call FeChybne(-1.,-1.,'diffraction indices are too large to be '//
     1              'sorted and averaged',' ',0,SeriousError)
      go to 9000
8100  write(Cislo,FormI15) mxref
      call Zhusti(Cislo)
      call FeChybne(-1.,-1.,'the number of reflections exceeds the '//
     1              'limit '//Cislo,' ',0,SeriousError)
      go to 9000
9000  ich=1
      ErrJana=0
9999  return
102   format(i1)
106   format(i2)
      end
      subroutine EM9OutStA(iven)
      include 'params.cmn'
      include 'basic.cmn'
      include 'editm9.cmn'
      character*42 iven(*)
      if(line.gt.0) then
        write(lst,FormLabAve)
        if(ndim.gt.3) then
          n=(line-1)/3+1
        else
          n=(line-1)/4+1
        endif
        do 1000i=1,n
          if(ndim.gt.3) then
            write(lst,'(3a42)')(iven(i+(j-1)*n),j=1,3)
          else
            write(lst,'(4a32)')(iven(i+(j-1)*n)(1:32),j=1,4)
          endif
1000    continue
        do 2000i=1,line
          iven(line)=' '
2000    continue
        line=mxline
      endif
      return
      end
      subroutine EM9MakeScales(kiq,klic,ich)
      include 'params.cmn'
      include 'basic.cmn'
      include 'fepc.cmn'
      include 'editm9.cmn'
      include 'datred.cmn'
      dimension maxi(6),fp(mxref)
      character*80 t80
      equivalence (fia,fp)
      save iz,nn
      data flim/10./
      ich=0
      if(Klic.eq.0) then
        call FeGetILevel('Determination of the common scale(s)',
     1                   'Reflections I>',
     2                   '*sig(I) will be used in the process',' ',
     3                   flim,ich)
        if(ich.ne.0) go to 9999
        do 1000i=1,6
          itr(i)=i
1000    continue
        call TwinSym(ns,ncs,itwin,0)
        iz=0
      else if(klic.eq.1) then
        nn=0
        m=0
        do 2810i=1,6
          ihmax(i)=0
2810    continue
        rewind 90
3000    read(90,format91)(ih(i),i=1,ndim),ri,rs,iq,nxx,itw,tbar
        if(ih(1).gt.900) go to 3200
        iatw=iabs(itw)
        call FeFlowChartEvent(iz,ie)
        if(ie.ne.0) then
          call FeBudeBreak
          if(ErrJana.ne.0) go to 9000
        endif
        do 3100i=1,ns
          if(.not.BratSym(i)) go to 3100
          call IndTr(ih,rm6(1,i,1,KPhase),ihp,ndim)
          do 3050j=1,ndim
            ihmax(j)=max(ihmax(j),iabs(ihp(j)))
3050      continue
3100    continue
        if(iq.ne.1) go to 3000
        m=m+1
        if(ri.lt.flim*rs) go to 3000
        nn=nn+1
        fia(nn)=ri
        sigfia(nn)=rs
        irecp(nn)=iatw
        go to 3000
3200    rewind 90
        scref(1)=m
        if(nn.lt.5) then
          t80='It concerns the data set #1'
          call FeChybne(-1.,-1.,'the number of common reflections '//
     1                          'less than 5',t80,0,SeriousError)
          ich=1
          go to 9999
        endif
        maxi(6)=1
        do 3220i=5,1,-1
          maxi(i)=maxi(i+1)*(2*ihmax(i+1)+1)
          if(imax/maxi(i).lt.2*ihmax(i)+1) go to 8000
3220    continue
        n=0
3300    read(90,format91)(ih(i),i=1,ndim),ri,rs,iq,nxx,itw,tbar
        if(ih(1).gt.900) go to 9999
        iatw=iabs(itw)
        call FeFlowChartEvent(iz,ie)
        if(ie.ne.0) then
          call FeBudeBreak
          if(ErrJana.ne.0) go to 9000
        endif
        if(iq.ne.1.or.ri.lt.flim*rs) go to 3300
        n=n+1
        mx=0
        do 3330i=1,ndim
          mx=mx+(ih(i)+ihmax(i))*maxi(i)
3330    continue
        irec(n)=mx
        go to 3300
      else if(Klic.eq.2) then
        rewind 90
        n=0
        m=0
        swt=0.
        srel=0.
        srelq=0.
4000    read(90,format91)(ih(i),i=1,ndim),ri,rs,iq,nxx,itw,tbar
        if(ih(1).gt.900) then
          if(m.lt.5) then
            t80='It concerns the data set #'
            write(t80(27:28),'(i2)') kiq
            if(kiq.lt.10) t80(27:)=t80(28:)
            call FeChybne(-1.,-1.,'the number of common reflections '//
     1                            'less than 5',t80,0,SeriousError)
            ich=1
          else
            sckor(kiq)=srel/swt
            sckors(kiq)=sqrt((srelq-srel**2/swt)/(float(m-1)*swt))
            sccom(kiq)=m
            scref(kiq)=n
          endif
          go to 9999
        endif
        iatw=iabs(itw)
        call FeFlowChartEvent(iz,ie)
        if(ie.ne.0) then
          call FeBudeBreak
          if(ErrJana.ne.0) go to 9000
        endif
        if(iq.ne.kiq) go to 4000
        n=n+1
        if(ri.lt.flim*rs) go to 4000
        do 4100i=1,ns
          if(.not.BratSym(i)) go to 4100
          call IndTr(ih,rm6(1,i,1,KPhase),ihp,ndim)
          mx=0
          do 4030j=1,ndim
            mx=mx+(ihp(j)+ihmax(j))*maxi(j)
4030      continue
          do 4040j=1,nn
            if(mx.eq.irec(j).and.iatw.eq.irecp(j)) then
              m=m+1
              rel=fia(j)/ri
              wt=1./(rel**2*((sigfia(j)/fia(j))**2+(rs/ri)**2))
              srel=srel+wt*rel
              srelq=srelq+wt*rel**2
              swt=swt+wt
              go to 4000
            endif
4040      continue
4100    continue
        go to 4000
      else if(Klic.eq.3) then
        rewind 90
        in=0
5000    read(90,format91)(ih(i),i=1,ndim),ri,rs,iq,nxx,itw,tbar,ReadLam,
     1                  DirCos
        if(ih(1).gt.900) then
          write(91,'('' 999'')')
          call heap(in,fp)
          fmez(8)=fp(in)+.1
          d=0.
          dd=float(in)*.125
          do 5500i=1,7
            d=d+dd
            j=d
            fmez(i)=(fp(j)+fp(j+1))*.5
5500      continue
          go to 9999
        endif
        iatw=iabs(itw)
        call FeFlowChartEvent(iz,ie)
        if(ie.ne.0) then
          call FeBudeBreak
          if(ErrJana.ne.0) go to 9000
        endif
        if(iq.ne.1) then
          ri=ri*sckor(iq)
          rs=rs*sckor(iq)
          iq=1
        endif
        if(anint(ri*10.).gt.EM9ObsLim*anint(rs*10.)) then
          in=in+1
          fp(in)=ri
        endif
        write(91,format91)(ih(i),i=1,ndim),ri,rs,iq,nxx,itw,tbar,
     1                    ReadLam,DirCos
        go to 5000
      endif
      go to 9999
8000  call FeChybne(-1.,-1.,'diffraction indices are too large to be '//
     1              'sorted',' ',0,SeriousError)
      ich=2
      go to 9999
9000  ich=1
      ErrJana=0
9999  return
      end
      subroutine ImportReflections
      parameter (MaxImp=10)
      include 'params.cmn'
      include 'basic.cmn'
      include 'editm9.cmn'
      include 'datred.cmn'
      include 'fepc.cmn'
      dimension TrmIn(36,MaxImp),TrmInk(36),ndim95(MaxImp),nsupk(3),
     1          nsup(3,MaxImp),iq(MaxImp),TypeIn(MaxImp),ln(MaxImp),
     2          itw(MaxImp),mmax(MaxImp),nrefp(MaxImp),nrefk(MaxImp),
     3          nrefd(MaxImp),difi(3,MaxImp),difik(3),qp(3),
     4          RscFak(MaxImp)
      character*256 FileIn(MaxImp),FileIn94(MaxImp),FileInk,FileIn94k,
     1              t256
      character*128 t128
      character*80 FormatIn(MaxImp),FormatInk,t80,p80
      integer TypeIn,TypeInk
      logical TrInd(MaxImp),TrIndk,FeYesNo,Change,eqrv,SelwLogicQuest,
     1        ExistFile
      if(ExistM94.and.ExistM95) then
        call iom94(0)
        call iom50(0,0)
      else
        call SetBasicM94
      endif
      nopened=0
      if(itwin.le.1) then
        TwType=0
      else
        TwType=1
      endif
      do 1090it=2,itwin
        do 1050i=1,9
          pom=rtw(i,it)
          if(abs(pom-anint(pom)).lt..001) then
            go to 1050
          else
            TwType=2
            den=2.
1040        pomt=pom*den
            if(abs(pomt-anint(pomt)).lt..001) go to 1050
            den=den+1.
            if(den.lt.9.99) go to 1040
            TwType=3
            go to 1100
          endif
1050    continue
        do 1060i=1,ndimi
          call multm(qu(1,i,1,KPhase),rtw(1,it),qp,1,3,3)
          call od0do1(qp,qp,3)
          if(.not.eqrv(qu(1,i,1,KPhase),qp,3,.0001)) then
            TwType=3
            go to 1100
          endif
1060    continue
1090  continue
1100  Change=.false.
      n=0
      t80=fln(:ifln)//'.m95'
      if(.not.ExistFile(t80)) then
        k=1
        ib=0
        go to 2600
      endif
      call OpenFile(95,t80,'formatted','old')
      if(ErrJana.ne.0) go to 9500
      call PrvniM95(ich)
      if(ich.ne.0) go to 9500
      rewind 95
      read(95,FormA80,err=9300) p80
      t80=p80
      call Mala(t80)
      if(t80.eq.ImportTextB) then
1200    read(95,FormA80,err=9300) t256
        t80=t256
        call mala(t80)
        if(t80.eq.ImportTextE) go to 1400
        n=n+1
        if(n.eq.1) then
          nrefp(1)=1
        else
          nrefp(n)=nrefk(n-1)+1
        endif
        FileIn(n)=t256
        FileIn94(n)=' '
1210    read(95,FormA80,err=9300) t256
        if(t256.eq.' ') go to 1210
        read(t256,102,err=1220) TypeIn(n),ndim95(n),iq(n),itw(n),
     1                          mmax(n),TrInd(n),(nsup(i,n),i=1,3),
     2                          (difi(i,n),i=1,3),RscFak(n)
        go to 1230
1220    FileIn94(n)=t256
        go to 1210
1230    if(RscFak(n).le.0.) RscFak(n)=1.
        pom=0.
        do 1250i=1,3
          pom=pom+abs(difi(i,n))
1250    continue
        if(pom.lt..001) call SetRealArrayTo(difi(1,n),3,.01)
        if(nsup(1,n).le.0) then
          ndimp=ndim
        else
          ndimp=ndim95(n)
        endif
        do 1300i=1,ndim95(n)
          read(95,101,err=9300)(TrmIn(i+(j-1)*ndim95(n),n),j=1,ndimp)
1300    continue
        read(95,FormA80,err=9300) FormatIn(n)
        if(TypeIn(n).eq.5) FormatIn(n)=FormatIn(n)(:5)//Format95(6:)
        read(95,103,err=9300) nrefd(n)
        nrefk(n)=nrefp(n)+nrefd(n)-1
        go to 1200
1400    nn=2*nrefk(n)
        call FeFlowChartOpen(-1.,-1.,max(nint(float(nn)*.005),10),nn,
     1                       'Preparing temporary files',' ',' ')
        iz=0
        do 1500i=1,n
          call EM9NewImpFile(ln(i))
          if(ErrJana.ne.0) go to 9200
          nopened=i
          do 1450j=1,2*nrefd(i)
            read(95,FormA128,err=9300) t128
            write(ln(i),FormA1)(t128(k:k),k=1,idel(t128))
            call FeFlowChartEvent(iz,ie)
            if(ie.ne.0) then
              call FeBudeBreak
              if(ErrJana.ne.0) go to 9200
            endif
1450      continue
1500    continue
        call FeFlowChartRemove
        call CloseIfOpened(95)
      endif
      k=1
2000  id=NextQuestId()
      ib=0
      call FeQuestCreate(id,-1.,-1.,210.,n+1,1,'Import file',0,
     1                   LightGray,0,0)
      xpom=25.
      do 2050i=1,3
        if(i.eq.1) then
          t80='%Re-import'
        else if(i.eq.2) then
          t80='%Delete'
        else
          t80='%New file'
        endif
        call FeQuestButtonMake(id,xpom,n+2,40.,ButYd,t80)
        call FeQuestButtonOpen(i+2,ButtonOff)
        xpom=xpom+60.
2050  continue
      if(n.gt.0) then
        xpom=7.5+SmallFontWidth*18.
        call FeQuestLabelMake(id,xpom,1,'file','C')
        xpom=xpom+SmallFontWidth*24.
        call FeQuestLabelMake(id,xpom,1,'from','C')
        xpom=xpom+SmallFontWidth*9.
        call FeQuestLabelMake(id,xpom,1,'to','C')
        do 2100i=1,n
          j=idel(FileIn(i))
          if(j.gt.34) then
            t80='...'//FileIn(i)(j-30:j)
          else
            t80=FileIn(i)
          endif
          write(t80(37:),'('' | '',i6,'' | '',i6,'' | '')') nrefp(i),
     1                                                      nrefk(i)
          call FeQuestSelwMake(id,5.,i+1,t80,200.,SelwYd,0,1)
          call FeQuestSelwOpen(SelwTo-SelwFr+1,i.eq.k)
2100    continue
      else
        call FeQuestButtonDisable(3)
        call FeQuestButtonDisable(4)
      endif
2200  icont=0
2250  call FeQuestEvent(id,icont,ich)
      icont=1
      if(CheckType.eq.EventButton.and.CheckNumber.le.5) then
        ib=CheckNumber-2
        EventType=EventButton
        EventNumber=2
        go to 2250
      else if(CheckType.ne.0) then
        call NebylOsetren
        go to 2250
      endif
      if(ich.eq.0) then
        if(ib.eq.0) then
          go to 2340
        else if(ib.le.2) then
          do 2300i=1,n
            if(SelwLogicQuest(i)) then
              k=i
              call FeQuestRemove(id)
              if(ib.eq.1) then
                go to 3000
              else
                go to 2350
              endif
            endif
2300      continue
        else
          k=n+1
          call FeQuestRemove(id)
          go to 2600
        endif
      endif
2340  call FeQuestRemove(id)
      go to 9000
2350  close(ln(k),status='delete')
      do 2400i=k+1,n
        ln(i-1)=ln(i)
        if(i.eq.2) then
          nrefp(i-1)=1
        else
          nrefp(i-1)=nrefk(i-2)+1
        endif
        iq(i-1)=iq(i)
        itw(i-1)=itw(i)
        mmax(i-1)=mmax(i)
        FileIn(i-1)=FileIn(i)
        FileIn94(i-1)=FileIn94(i)
        FormatIn(i-1)=FormatIn(i)
        TypeIn(i-1)=TypeIn(i)
        ndim95(i-1)=ndim95(i)
        RscFak(i-1)=RscFak(i)
        call CopyVekI(nsup(1,i),nsup(1,i-1),3)
        call CopyVek(difi(1,i),difi(1,i-1),3)
        TrInd(i-1)=TrInd(i)
        if(nsup(1,i).le.0) then
          ndimp=ndim
        else
          ndimp=ndim95(i)
        endif
        call CopyVek(TrmIn(1,i),TrmIn(1,i-1),ndim95(i)*ndimp)
        nrefd(i-1)=nrefd(i)
        nrefk(i-1)=nrefp(i-1)+nrefd(i-1)-1
2400  continue
      n=n-1
      Change=.true.
      go to 2000
2600  if(k.eq.1) then
        iq(1)=1
        itw(1)=1
        mmax(1)=4
        TypeIn(1)=5
        ndim95(1)=3
        RscFak(1)=1.
        call SetIntArrayTo(nsup,3,1)
        call SetRealArrayTo(difi,3,.01)
        TrInd(1)=.false.
        FileIn(1)='.m95'
        FileIn94(1)=' '
        FormatIn(1)='(3i4,2f10.2)'
        call unitmat(TrmIn,ndim95(1))
      else if(k.le.MaxImp) then
        iq(k)=iqmax+1
        itw(k)=itw(k-1)
        mmax(k)=mmax(k-1)
        TypeIn(k)=TypeIn(k-1)
        ndim95(k)=ndim95(k-1)
        RscFak(k)=1.
        call CopyVekI(nsup(1,k-1),nsup(1,k),3)
        call CopyVek(difi(1,k-1),difi(1,k),3)
        TrInd(k)=TrInd(k-1)
        if(nsup(1,k).le.0) then
          ndimp=ndim
        else
          ndimp=ndim95(k)
        endif
        call CopyVek(TrmIn(1,k-1),TrmIn(1,k),ndim95(k)*ndimp)
        i=idel(FileIn(k-1))
        FileIn(k)='.'//FileIn(k-1)(i-2:i)
        FileIn94(k)=' '
        FormatIn(k)=FormatIn(k-1)
      else
        write(t80,'(i2)') MaxImp
        call FeChybne(-1.,-1.,'the maximun number of imported files '//
     1                t80(:2)//' reached',' ',0,SeriousError)
        go to 2000
      endif
      call EM9NewImpFile(ln(k))
      if(ErrJana.ne.0) go to 9200
3000  nref=0
      lnk=ln(k)
      FileInk=FileIn(k)
      FileIn94k=FileIn94(k)
      FormatInk=FormatIn(k)
      TypeInk=TypeIn(k)
      ndim95k=ndim95(k)
      iqk=iq(k)
      itwk=itw(k)
      mmaxk=mmax(k)
      RscFakk=RscFak(k)
      call CopyVekI(nsup(1,k),nsupk,3)
      call CopyVek(difi(1,k),difik,3)
      TrIndk=TrInd(k)
      if(nsupk(1).le.0) then
        ndimp=ndim
      else
        ndimp=ndim95(k)
      endif
      call CopyVek(TrmIn(1,k),TrmInk,ndim95k*ndimp)
      call EM9ImportFile(lnk,FileInk,FileIn94k,FormatInk,TypeInk,
     1                   ndim95k,iqk,itwk,mmaxk,nsupk,difik,RscFakk,
     2                   TrIndk,TrmInk,nref,ich)
      if(ich.eq.0) then
        Change=.true.
        ln(k)=lnk
        FileIn(k)=FileInk
        FileIn94(k)=FileIn94k
        FormatIn(k)=FormatInk
        TypeIn(k)=TypeInk
        ndim95(k)=ndim95k
        iq(k)=iqk
        itw(k)=itwk
        mmax(k)=mmaxk
        RscFak(k)=RscFakk
        call CopyVekI(nsupk,nsup(1,k),3)
        call CopyVek(difik,difi(1,k),3)
        TrInd(k)=TrIndk
        if(nsupk(1).le.0) then
          ndimp=ndim
        else
          ndimp=ndim95(k)
        endif
        call CopyVek(TrmInk,TrmIn(1,k),ndim95k*ndimp)
        nrefd(k)=nref
        if(k.gt.n) n=k
        do 3100i=1,n
          if(i.eq.1) then
            nrefp(1)=1
          else
            nrefp(i)=nrefk(i-1)+1
          endif
          nrefk(i)=nrefp(i)+nrefd(i)-1
3100    continue
        nopened=max(nopened,k)
      else
        if(ib.eq.3) close(ln(k),status='delete')
        if(n.eq.0) go to 9999
        k=n
      endif
      go to 2000
9000  if(Change) then
        if(ich.eq.0) then
          if(FeYesNo(-1.,-1.,'Do you want to accept the made changes?',
     1               1)) then
            go to 9100
          else
            go to 9200
          endif
        else
          if(FeYesNo(-1.,-1.,'Do you want to avoid the made changes?',
     1               1)) then
            go to 9200
          else
            go to 9100
          endif
        endif
      endif
      go to 9200
9100  call OpenFile(95,fln(:ifln)//'.m95','formatted','unknown')
      if(ErrJana.ne.0) go to 9500
      if(n.gt.0) then
        write(95,FormA1)(ImportTextB(i:i),i=1,idel(ImportTextB))
        do 9140k=1,n
          write(95,FormA1)(FileIn(k)(i:i),i=1,idel(FileIn(k)))
          if(TypeIn(k).eq.5)
     1      write(95,FormA1)(FileIn94(k)(i:i),i=1,idel(FileIn94(k)))
          write(95,102) TypeIn(k),ndim95(k),iq(k),itw(k),mmax(k),
     1                  TrInd(k),(nsup(i,k),i=1,3),(difi(i,k),i=1,3),
     2                  RscFak(k)
          if(nsup(1,k).le.0) then
            ndimp=ndim
          else
            ndimp=ndim95(k)
          endif
          do 9120i=1,ndim95(k)
            write(95,101)(TrmIn(i+(j-1)*ndim95(k),k),j=1,ndimp)
9120      continue
          write(95,FormA1)(FormatIn(k)(i:i),i=1,idel(FormatIn(k)))
          write(95,103) nrefd(k)
9140    continue
        write(95,FormA1)(ImportTextE(i:i),i=1,idel(ImportTextE))
        nn=2*nrefk(n)
        call FeFlowChartOpen(-1.,-1.,max(nint(float(nn)*.005),10),nn,
     1                       'Merging temporary files',' ',' ')
        iz=0
        do 9180i=1,n
          rewind ln(i)
          do 9160j=1,2*nrefd(i)
            read(ln(i),FormA128) t128
            write(95,FormA1)(t128(k:k),k=1,idel(t128))
            call FeFlowChartEvent(iz,ie)
            if(ie.ne.0)
     1        call FeMsgOut(-1.,30.,'The action cannot be canceled!')
9160      continue
9180    continue
        call FeFlowChartRemove
        call CloseIfOpened(95)
        nref95=nrefk(n)
      else
        nref95=0
        close(95,status='delete')
      endif
      call iom94(1)
      if(FeYesNo(-1.,-1.,'Do you want to create refinement reflection'//
     1           ' file (m91)?',1)) call ExportM91
      mxscutw=max(iqmax+itwin-1,6)
      mxscu=mxscutw-itwin+1
      do 9190i=1,iqmax
        if(sc(i).le.0.) sc(i)=1.
9190  continue
      call iom40(1,0)
9200  do 9220i=1,nopened
        close(ln(i),status='delete')
9220  continue
      go to 9500
9300  call FeReadError(95)
9500  call CloseIfOpened(95)
9999  return
101   format(6f10.6)
102   format(5i5,l5,3i5,3f8.3,f10.5)
103   format(i10)
      end
      subroutine EM9ImportFile(ln,FileIn,FileIn94,FormatIn,TypeIn,
     1                         ndim95,iq,itwi,mmax,nsup,difi,RscFak,
     2                         TransformIndices,TrmIn,nrefp,ich)
      include 'params.cmn'
      include 'basic.cmn'
      include 'fepc.cmn'
      include 'editm9.cmn'
      include 'datred.cmn'
      dimension h(6),hf(6),ihf(3),trm(36),trmi(36),trp(36),quit(3,3),
     1          quo(3,3),TrmIn(36),nsup(3),difi(3),UBSXD(3,3),
     2          UBiSXD(3,3),AnglesSXD(3),Rot(3,3),Rt(3,3),Tt(3,3)
      character*(*) FileIn,FileIn94,FormatIn
      character*256 EdwStringQuest,t256
      character*80  t80,p80
      character*18  men(10)
      character*2   nty
      integer TypeIn,EdwStateQuest,TypeInList(10),EdwIntQuest,
     1        BratMensiItw
      logical Fractional,TransformIndices,EqIgCase,RealIndices,
     1        NicTamNeni,FreeFormat,CrwLogicQuest,FeYesNoHeader
      real Longitude,Latitude
      data men/'%JANA93/94',
     1         'S%HELX on F',
     2         '%SHELX on I',
     3         'SHELX HKLF%5',
     4         'IPDS ST%OE',
     5         'CCD Bru%ker',
     6         '%DATRED',
     7         'S%XD source',
     8         'General file on %F',
     9         'General file on %I'/
      TypeInList( 1)=IdImportJanaOld
      TypeInList( 2)=IdImportSHELXF
      TypeInList( 3)=IdImportSHELXI
      TypeInList( 4)=IdImportHKLF5
      TypeInList( 5)=IdImportIPDS
      TypeInList( 6)=IdImportCCDBruker
      TypeInList( 7)=IdImportDatRed
      TypeInList( 8)=IdImportSXD
      TypeInList( 9)=IdImportGeneralF
      TypeInList(10)=IdImportGeneralI
      call SetRealArrayTo(quit,9,0.)
      ich=0
      id=NextQuestId()
      call FeQuestCreate(id,-1.,-1.,220.,0,15,'Specify input reflection'
     1                 //' file',1,LightGray,0,0)
      il=2
      do 1010i=2,10
        il=il+1
        call FeQuestCrwMake(id,140.,il,207.,il,men(i),'L',CrwgXd,CrwgYd,
     1                      1,1)
        nCrwTypeTo=CrwLastMade
        if(i.eq.2) nCrwTypeFr=nCrwTypeTo
        call FeQuestCrwOpen(nCrwTypeTo,TypeInList(i).eq.TypeIn)
1010  continue
      ilp=il+1
      il=1
      t80='%Reflection file'
      tpom=5.
      xpom=tpom+FeTxLength(t80)+5.
      dpom=175.-xpom
      call FeQuestEdwMake(id,tpom,il,xpom,il,t80,'L',dpom,EdwYd,1)
      nEdwRefFile=EdwLastMade
      call FeQuestButtonMake(id,180.,il,35.,ButYd,'%Browse')
      nButtRefBrowse=ButtonLastMade
      call FeQuestButtonOpen(ButtonLastMade,ButtonOff)
      il=il+1
      call FeQuestEdwMake(id,tpom,il,xpom,il,'Fi%le format','L',dpom,
     1                    EdwYd,0)
      nEdwFormat=EdwLastMade
      if(TypeIn.eq.IdImportGeneralF.or.TypeIn.eq.IdImportGeneralI)
     1  call FeQuestStringEdwOpen(nEdwFormat,FormatIn)
      t80='Asso%ciated file'
      call FeQuestEdwMake(id,tpom,il,xpom,il,t80,'L',dpom,EdwYd,0)
      nEdwAssFile=EdwLastMade
      call FeQuestButtonMake(id,180.,il,35.,ButYd,'Bro%wse')
      nButtAssBrowse=ButtonLastMade
      il=il+1
      call FeQuestEudMake(id,5.,il,105.,il,'N%umber of indices','L',
     1                    15.,EdwYd,1)
      nEdwNdim=EdwLastMade
      call FeQuestIntEdwOpen(nEdwNdim,ndim95,.false.)
      call FeQuestEudOpen(nEdwNdim,3,6,1,0.,0.,0.)
      t80='Scal%e#'
      xpom=8.+FeTxLengthUnder(t80)
      il=il+1
      call FeQuestEudMake(id,5.,il,xpom,il,t80,'L',15.,EdwYd,0)
      nEdwScale=EdwLastMade
      call FeQuestIntEdwOpen(nEdwScale,iq,.false.)
      call FeQuestEudOpen(nEdwScale,0,mxsc,1,0.,0.,0.)
      t80='%Twin#'
      tpom=102.-FeTxLengthUnder(t80)
      call FeQuestEudMake(id,tpom,il,105.,il,t80,'L',15.,EdwYd,0)
      nEdwTwin=EdwLastMade
c      t80='O%verlap'
c      il=il+1
c      xpom=120.-CrwXd
c      call FeQuestCrwMake(id,tpom,il,xpom,il,t80,'L',CrwXd,CrwYd,0,0)
c      nCrwOverlap=CrwLastMade
      if(TwType.ge.1) then
        call FeQuestIntEdwOpen(nEdwTwin,iabs(itwi),.false.)
        call FeQuestEudOpen(nEdwTwin,1,itwin,1,0.,0.,0.)
c        call FeQuestCrwOpen(nCrwOverlap,itwi.gt.0)
      endif
      il=il+1
      call FeQuestEdwMake(id,5.,il,90.,il,'Su%percell','L',30.,EdwYd,0)
      nEdwScell=EdwLastMade
      il=il+1
      call FeQuestEudMake(id,5.,il,105.,il,'%Maximal satellite index',
     1                    'L',15.,EdwYd,0)
      nEdwMxSat=EdwLastMade
      il=il+1
      call FeQuestEdwMake(id,5.,il,55.,il,'%Accuracy','L',65.,EdwYd,0)
      nEdwAcc=EdwLastMade
      if(ndim.gt.ndim95) then
        call FeQuestIntAEdwOpen(nEdwScell,nsup,3,.false.)
        call FeQuestIntEdwOpen(nEdwMxSat,mmax,.false.)
        call FeQuestEudOpen(nEdwMxSat,0,99,1,0.,0.,0.)
        call FeQuestRealAEdwOpen(nEdwAcc,difi,3,.false.,.false.)
      endif
      il=il+1
      call FeQuestCrwMake(id,5.,il,70.,il,'Tra%nsform indices','L',
     1                    CrwXd,CrwYd,1,0)
      nCrwTrInd=CrwLastMade
      call FeQuestCrwOpen(nCrwTrInd,TransformIndices)
      call FeQuestLabelMake(id,85.,il,'by matrix','L')
      t80='Multipl%y input I/F by'
      xpom=185.-FeTxLengthUnder(t80)
      call FeQuestEdwMake(id,xpom,ilp,190.,ilp,t80,'L',25.,EdwYd,0)
      nEdwRsc=EdwLastMade
      call FeQuestRealEdwOpen(nEdwRsc,RscFak,.false.,.false.)
      il=il+1
      call TrMat(TrmIn,Trm,ndim95,ndim95)
      k=1
      do 1015i=1,6
        write(t80,'(''%'',i1,a2,'' row'')') i,nty(i)
        call FeQuestEdwMake(id,5.,il,35.,il,t80,'L',65.,EdwYd,0)
        nEdw=EdwLastMade
        if(TransformIndices.and.i.le.ndim95)
     1    call FeQuestRealAEdwOpen(nEdw,Trm(k),ndim95,.false.,.true.)
        if(i.eq.1) nEdwTrMat=nEdw
        k=k+ndim95
        il=il+1
1015  continue
      if(TypeIn.eq.IdImportDatRed) t256=FileIn94
1017  icont=0
1018  if(FileIn.eq.' ') then
        if(TypeIn.eq.IdImportJanaOld) then
          FileIn=fln(:ifln)//'.m90'
        else if(TypeIn.eq.IdImportDatRed) then
          FileIn='.m95'
        else if(TypeIn.eq.IdImportCCDBruker.and.ndimi.gt.0) then
          FileIn=fln(:ifln)//'.hk6'
        else if(TypeIn.eq.IdImportSXD) then
          FileIn=fln(:ifln)//'.int'
        else if(TypeIn.eq.IdImportHKLF5) then
          FileIn=fln(:ifln)//'.hk5'
        else
          FileIn=fln(:ifln)//'.hkl'
        endif
      endif
      call FeQuestStringEdwOpen(nEdwRefFile,FileIn)
      if(TypeIn.eq.IdImportDatRed) then
        if(FileIn94.eq.' '.or.FileIn94.eq.'.m94') then
          if(FileIn.eq.'.m95') then
            FileIn94='.m94'
          else
            i=index(FileIn,'.m95')
            if(i.le.0) then
              FileIn94=t256
            else
              FileIn94=FileIn
              if(i.gt.0) FileIn94(i:i+3)='.m94'
            endif
          endif
        endif
        call FeQuestButtonOpen(ButtonLastMade,ButtonOff)
        call FeQuestStringEdwOpen(nEdwAssFile,FileIn94)
      endif
1020  call FeQuestEvent(id,icont,ich)
      FileIn=EdwString(nEdwRefFile)
      if(TypeIn.eq.IdImportDatRed) then
        FileIn94=EdwString(nEdwAssFile)
        t256=FileIn94
      endif
      icont=1
      if(CheckType.eq.EventButton.and.CheckNumberAbs.eq.ButtonOK) then
        if(FileIn.ne.' ') then
          call EM9CheckFileIn(FileIn,FileIn94,TypeIn,ich)
          if(ich.ne.0) go to 1025
        endif
        if(CrwLogicQuest(nCrwTrInd)) then
          j=1
          do 1021i=1,ndim95
            call FeQuestRealAFromEdw(nEdwTrMat+i-1,Trm(j))
            j=j+ndim95
1021      continue
          call matinv(Trm,trmi,pom,ndim95)
          if(abs(pom).le..00001) then
            call FeChybne(-1.,-1.,'the matrix is singular',' ',0,
     1                    SeriousError)
            go to 1025
          else if(pom.lt.0.) then
            call FeChybne(-1.,-1.,'the matrix is non-positive '//
     1                    'definite',' ',0,SeriousError)
            go to 1025
          endif
        endif
1024    QuestCheck(id)=0
        go to 1020
1025    icont=0
        call FeButtonOff(ButtonOK)
        go to 1020
      else if(CheckType.eq.EventCrw.and.
     1        (CheckNumber.ge.nCrwTypeFr.and.CheckNumber.le.nCrwTypeTo))
     2  then
        if(TypeIn.eq.IdImportJanaOld) then
          t256=fln(:ifln)//'.m90'
        else if(TypeIn.eq.IdImportDatRed) then
          t256='.m95'
        else if(TypeIn.eq.IdImportCCDBruker.and.ndimi.gt.0) then
          t256=fln(:ifln)//'.hk6'
        else if(TypeIn.eq.IdImportSXD) then
          t256=fln(:ifln)//'.int'
        else if(TypeIn.eq.IdImportHKLF5) then
          t256=fln(:ifln)//'.hk5'
        else
          t256=fln(:ifln)//'.hkl'
        endif
        TypeIn=TypeInList(CheckNumber-nCrwTypeFr+2)
        if(EqIgCase(t256,EdwStringQuest(nEdwRefFile))) then
          if(TypeIn.eq.IdImportJanaOld) then
            t256=fln(:ifln)//'.m90'
          else if(TypeIn.eq.IdImportDatRed) then
            t256='.m95'
          else if(TypeIn.eq.IdImportCCDBruker.and.ndimi.gt.0) then
            t256=fln(:ifln)//'.hk6'
          else if(TypeIn.eq.IdImportSXD) then
            t256=fln(:ifln)//'.int'
          else if(TypeIn.eq.IdImportHKLF5) then
            t256=fln(:ifln)//'.hk5'
          else
            t256=fln(:ifln)//'.hkl'
          endif
          call FeQuestStringEdwOpen(nEdwRefFile,t256)
        endif
        if(TypeIn.eq.IdImportGeneralF.or.TypeIn.eq.IdImportGeneralI)
     1    then
          call FeQuestEdwClose(nEdwAssFile)
          if(EdwStateQuest(nEdwFormat).eq.EdwClosed)
     1      call FeQuestStringEdwOpen(nEdwFormat,FormatIn)
        else
          call FeQuestEdwClose(nEdwFormat)
        endif
        if(TypeIn.eq.IdImportDatRed) then
          if(EdwStateQuest(nEdwAssFile).eq.EdwClosed) then
            call FeQuestStringEdwOpen(nEdwAssFile,FileIn94)
            call FeQuestButtonOpen(nButtAssBrowse,ButtonOff)
          endif
        else
          call FeQuestEdwClose(nEdwAssFile)
          call FeQuestButtonClose(nButtAssBrowse)
        endif
        icont=0
        go to 1020
      else if(CheckType.eq.EventCrw.and.CheckNumber.eq.nCrwTrInd) then
        if(EdwStateQuest(nEdwTrMat).eq.EdwClosed) then
          j=1
          do 1028i=1,ndim95
            call FeQuestRealAEdwOpen(nEdwTrMat+i-1,Trm(j),ndim95,
     1                               .false.,.false.)
            j=j+ndim95
1028      continue
        else
          do 1029i=nEdwTrMat,nEdwTrMat+ndim95-1
            call FeQuestEdwClose(i)
1029      continue
        endif
        icont=0
        go to 1020
      else if(CheckType.eq.EventEdw.and.CheckNumber.eq.nEdwNdim) then
        i=EdwIntQuest(1,nEdwNdim)
        if(ndim.gt.i) then
          if(EdwStateQuest(nEdwSCell).eq.EdwClosed) then
            do 1030j=1,3
              nsup(j)=1
1030        continue
            call FeQuestIntAEdwOpen(nEdwSCell,nsup,3,.false.)
            call FeQuestIntEdwOpen(nEdwMxSat,mmax,.false.)
            call FeQuestRealAEdwOpen(nEdwAcc,difi,3,.false.,.false.)
          endif
        else
          call FeQuestEdwClose(nEdwSCell)
          call FeQuestEdwClose(nEdwMxSat)
          call FeQuestEdwClose(nEdwAcc)
        endif
        if(ndim95.ne.i) then
          ndim95=i
          call UnitMat(Trm,ndim95)
          if(CrwLogicQuest(nCrwTrInd)) then
            j=1
            do 1032i=1,6
              k=nEdwTrMat+i-1
              if(i.le.ndim95) then
                call FeQuestRealAEdwOpen(k,Trm(j),ndim95,.false.,
     1                                   .false.)
                j=j+ndim95
              else
                call FeQuestEdwClose(k)
              endif
1032        continue
          endif
        endif
        go to 1020
      else if(CheckType.eq.EventButton.and.
     1        CheckNumber.eq.nButtRefBrowse) then
        if(TypeIn.eq.IdImportJanaOld) then
          t80='*.m90'
        else if(TypeIn.eq.IdImportDatRed) then
          i=index(FileIn,'.m95')
          if(idel(FileIn).eq.i+3) then
            t80='*.m95'
          else
            t80='*.*'
          endif
        else if(TypeIn.eq.IdImportCCDBruker.and.ndimi.gt.0) then
          t80='*.hk6'
        else if(TypeIn.eq.IdImportSXD) then
          t80='*.int'
        else
          t80='*.hkl'
        endif
        if(TypeIn.eq.IdImportDatRed)
     1    call EM9ResetAssFile(FileIn,FileIn94)
        call FeFileManager('Select reflection file',FileIn,t80,0,.true.,
     1                     ich)
        call FeQuestButtonOff(nButtRefBrowse)
        if(ich.ne.0) FileIn94=t256
        go to 1017
      else if(CheckType.eq.EventButton.and.
     1        CheckNumber.eq.nButtAssBrowse) then
        i=index(FileIn94,'.m94')
        if(idel(FileIn94).eq.i+3) then
          t80='*.m94'
        else
          t80='*.*'
        endif
        call FeFileManager('Select associated file',FileIn94,t80,0,
     1                     .true.,ich)
        call FeQuestButtonOff(nButtAssBrowse)
        go to 1017
      else if(CheckType.eq.EventEdw.and.CheckNumber.eq.nEdwRefFile) then
        if(TypeIn.eq.IdImportDatRed)
     1    call EM9ResetAssFile(FileIn,FileIn94)
        go to 1018
      else if(CheckType.ne.0) then
        call NebylOsetren
        go to 1020
      endif
      if(ich.eq.0) then
        if(TypeIn.eq.IdImportGeneralF.or.TypeIn.eq.IdImportGeneralI)
     1    FormatIn=EdwStringQuest(nEdwFormat)
        call FeQuestIntFromEdw(nEdwNdim,ndim95)
        call FeQuestIntFromEdw(nEdwScale,iq)
        call FeQuestRealFromEdw(nEdwRsc,RscFak)
        if(TwType.ge.1) then
          call FeQuestIntFromEdw(nEdwTwin,itwi)
c          if(.not.CrwLogicQuest(nCrwOverlap)) itwi=-itwi
        else
          itwi=1
        endif
        iatw=iabs(itwi)
        if(ndim.gt.ndim95) then
          call FeQuestIntAFromEdw(nEdwScell,nsup)
          call FeQuestIntFromEdw(nEdwMxSat,mmax)
          call FeQuestRealAFromEdw(nEdwAcc,difi)
        else
          do 1045i=1,3
            difi(i)=.001
1045      continue
        endif
        TransformIndices=CrwLogicQuest(nCrwTrInd)
        if(TransformIndices) then
          call TrMat(Trm,TrmIn,ndim95,ndim95)
        else
          call UnitMat(TrmIn,ndim95)
        endif
      endif
      call FeQuestRemove(id)
      if(ich.ne.0) go to 9999
      nsups=nsup(1)+nsup(2)+nsup(3)
      Fractional=.false.
      tbar=0.
      iqm=0
      call SetRealArrayTo(uhly,4,0.)
      call SetRealArrayTo(dircos,6,0.)
      call SetRealArrayTo(corrf,2,1.)
      if(TypeIn.eq.IdImportSXD) then
        format91(14:14)='5'
        format95(30:30)='5'
      endif
      if(ndim.gt.ndim95) then
        if(nsups.gt.3) then
          do 1162j=1,ndimi
            do 1160i=1,3
              quo(i,j)=qu(i,j,1,KPhase)
              pom=float(nsup(i))
              qu(i,j,1,KPhase)=anint(qu(i,j,1,KPhase)*pom)/pom
              qui(i,j,KPhase)=qu(i,j,1,KPhase)-quir(i,j,KPhase)
1160        continue
1162      continue
        endif
        if(ncomp.gt.1) call setmet(0)
        if(kcommen.ne.0) call ComSym(0,0)
      else if(ndim.lt.ndim95) then
        if(itwin.le.1) then
          write(t80,FormI15) ndim
          t80='more than '//t80(1:1)//' indices indicates that '
          call FeChybne(-1.,-1.,t80,'the structure has to be twin',0,
     1                  SeriousError)
          go to 9100
        endif
        iwc=ndim95-ndim
        id=NextQuestId()
        call FeQuestCreate(id,-1.,-1.,180.,0,iwc,'Non-lattice '//
     1                     'reciprocal vectors induced by twinning',0,
     2                     LightGray,0,0)
        do 1200i=1,iwc
          write(t80,'(''%'',i1,a2,'' vector'')') i,nty(i)
          call FeQuestEdwMake(id,5.,i,60.,i,t80,'L',115.,EdwYd,0)
          NicTamNeni=abs(quit(1,i))+abs(quit(2,i))+abs(quit(3,i)).le.0.
          call FeQuestRealAEdwOpen(i,quit(1,i),3,NicTamNeni,.false.)
1200    continue
        icont=0
        call FeQuestEvent(id,icont,ich)
        icont=1
        if(ich.eq.0) then
          do 1210i=1,iwc
            call FeQuestRealAFromEdw(i,quit(1,i))
1210      continue
        endif
        call FeQuestRemove(id)
        if(ich.ne.0) go to 9999
      else
        if(itwin.gt.1) then
          if(TwType.eq.2) then
            call CheckEOLOnFile(FileIn,2)
            if(ErrJana.ne.0) go to 9100
            call OpenFile(96,FileIn,'formatted','old')
            if(ErrJana.ne.0) go to 9100
            read(96,FormA80) t80
            call CloseIfOpened(96)
            call mala(t80)
            k=0
            call kus(t80,k,Cislo)
            if(Cislo.eq.'fract') then
              Fractional=.true.
              do 1330i=1,ndim
                call kus(t80,k,Cislo)
                call posun(Cislo,0)
                read(Cislo,FormI15) ihf(i)
1330          continue
            endif
          endif
        endif
      endif
      if(ndim95.eq.3.or.
     1   (TypeIn.ne.IdImportIPDS.and.TypeIn.ne.IdImportCCDBruker)) then
        ndim95i=ndim95
      else
        ndim95i=6
      endif
      RealIndices=.false.
      FreeFormat=.false.
      if(TypeIn.ne.IdImportGeneralF.and.TypeIn.ne.IdImportGeneralI) then
        FormatIn='(.i4,'
        write(FormatIn(2:2),100) ndim95i
        if(TypeIn.eq.IdImportJanaOld) then
          FormatIn=FormatIn(1:5)//'f9.1,f9.4)'
        else if(TypeIn.eq.IdImportDatRed) then
          FormatIn=Format95
          write(FormatIn(5:5),100) ndim95i
          call CheckEOLOnFile(FileIn94,2)
          if(ErrJana.ne.0) go to 9100
          call OpenFile(97,FileIn94,'formatted','old')
          if(ErrJana.ne.0) go to 9100
          call UnitMat(trp,ndim95)
1440      read(97,FormA80,end=1450,err=1450) t80
          call mala(t80)
          if(index(t80,'trmat').eq.1) then
            do 1444i=1,ndim95
              read(97,FormA80,end=1450,err=1450) t80
              k=0
              call StToReal(t80,k,h,ndim95,.false.,ich)
              k=i
              do 1442j=1,ndim95
                trp(k)=h(j)
                k=k+ndim95
1442          continue
1444        continue
            go to 1460
          else
            go to 1440
          endif
          go to 1460
1450      rewind 97
          do 1451i=1,4
            read(97,'(a)')
1451      continue
          do 1452i=1,ndim95
            read(97,'(6f12.6)')(trp(i+(j-1)*ndim95),j=1,ndim95)
1452      continue
1460      call CloseIfOpened(97)
          call CheckEOLOnFile(FileIn,2)
          if(ErrJana.ne.0) go to 9100
          call OpenFile(95,FileIn,'formatted','old')
          if(ErrJana.ne.0) go to 9100
          i=ndim
          if(ndim95.ne.ndim) then
            t80(1:1)=Format95(5:5)
            Format95(5:5)   =FormatIn(5:5)
            Format95old(5:5)=FormatIn(5:5)
            ndim=ndim95
          endif
          call PrvniM95(ich)
          call CloseIfOpened(95)
          if(ndim95.ne.i) then
            Format95(5:5)   =t80(1:1)
            Format95old(5:5)=t80(1:1)
            ndim=i
          endif
        else
          if(TypeIn.eq.IdImportHKLF5) then
            FormatIn=FormatIn(1:5)//'2f8.2,i4)'
          else
            FormatIn=FormatIn(1:5)//'2f8.2)'
          endif
        endif
      else
        call Zhusti(FormatIn)
        call mala(FormatIn)
        if(FormatIn.eq.'*'.or.FormatIn.eq.'(*)') then
          FreeFormat=.true.
        else
          i=index(FormatIn,'i')
          j=max(index(FormatIn,'f'),index(FormatIn,'e'))
          if(i.le.0.or.i.gt.j) then
            RealIndices=.true.
            call SetRealArrayTo(hf(4),ndimi,0)
          endif
        endif
      endif
      rewind(ln)
      if(ich.ne.0) go to 9999
      call CheckEOLOnFile(FileIn,2)
      if(ErrJana.ne.0) go to 9100
      call OpenFile(96,FileIn,'formatted','old')
      if(ErrJana.ne.0) go to 9100
      if(Fractional.or.FreeFormat) then
        read(96,FormA80) t80
        call mala(t80)
        k=0
        if(Fractional) then
          call kus(t80,k,Cislo)
          if(Cislo.ne.'fract') rewind 96
        else
          itecka=0
          call RozdelMezerou(t80,'-')
          call RozdelMezerou(t80,'+')
          do 1600i=1,3
            call kus(t80,k,Cislo)
            if(index(Cislo,'.').gt.0) then
              RealIndices=.true.
              itecka=1
              go to 1620
            endif
1600      continue
1620      rewind 96
        endif
      endif
      if(TypeIn.eq.IdImportDatRed) then
        read(96,FormA80,err=9000,end=3000) t80
        if(EqIgCase(t80,'import_report_begin')) then
          call FeChybne(-1.,-1.,'only m95 prepared by DATRED can be '//
     1                  'imported',' ',0,SeriousError)
          go to 9100
        endif
        rewind 96
      else if(TypeIn.eq.IdImportSXD) then
        m=0
        p80='phi, chi, omega'
        idl=idel(p80)
1700    if(m.gt.10) go to 1720
        read(96,FormA80,err=9000,end=9000) t80
        call mala(t80)
        i=index(t80,p80(:idl))
        if(i.gt.0) then
          k=i+idl
          call StToReal(t80,k,AnglesSXD,3,.false.,ich)
          if(ich.ne.0) go to 1700
          SenseOfAngle(1)=1.
          SenseOfAngle(2)=1.
          SenseOfAngle(3)=1.
          m=m+1
        else if(index(t80,'ub and abc matrix').gt.0) then
          do 1710i=1,3
            if(i.eq.1) then
              j=2
            else if(i.eq.2) then
              j=1
            else
              j=3
            endif
            read(96,FormA80,err=9000,end=9000) t80
            k=1
            call StToReal(t80,k,h,6,.false.,ich)
            if(ich.ne.0) go to 1700
            if(i.ne.3) call RealVectorToOpposite(h(4),h(4),3)
            call CopyVek(h(4),UBiSXD(1,j),3)
1710      continue
          call MatInv(UBiSXD,UBSXD,pom,3)
          m=m+10
        endif
        go to 1700
1720    rewind 96
      endif
      t80='     0 reflections already imported'
      write(t80(1:6),103) nrefp
      call FeTxOut(-1.,-1.,t80)
      nvyh=0
      nvyh500=0
      nall=0
      avis=0.
      nobs=0
      rimax=0.
      ReadLam=0.
      BratMensiItw=-1
1800  iqo=iq
      if(TypeIn.eq.IdImportDatRed) then
        t256=Format95
        Format95=FormatIn
        i=ndim
        ndim=ndim95
        call DRGetReflectionFromM95(96,iend,ich)
        Format95=t256
        ndim=i
        if(iend.ne.0) go to 3000
        if(ich .ne.0) go to 9000
        if(no.gt.0) then
          pom=corrf(1)*corrf(2)
          ri=ri*pom
          rs=rs*pom
          corrf(1)=1.
          corrf(2)=1.
        else
          go to 1800
        endif
        call indtr(ih,trp,ihp,ndim95)
        if(ihp(1).gt.900) go to 1800
      else if(TypeIn.eq.IdImportSXD) then
        read(96,FormA256,err=9000,end=3000) t256
        call mala(t256)
        if(t256(1:1).eq.'#'.or.t256(1:1).eq.'('.or.
     1    index(t256,'unobserved').gt.0) go to 1800
        read(t256,'(3i4,2f10.2,i5,7f10.4)',err=9000,end=3000)
     1    (ihp(i),i=1,ndim95),ri,rs,iflg(1),ReadLam,pom,corrf(1),tbar,
     2    pom,Longitude,Latitude
        iqo=iflg(1)+iq-1
        pom=corrf(1)
        ri=ri*pom
        rs=rs*pom
        corrf(1)=1.
        corrf(2)=1.
c        do 1820i=1,3
c          h(i)=ihp(i)
c1820    continue
c        call multm(UBSXD,h,hf,3,3,1)
c        write(6,'(3f8.3)')(h(i),i=1,3)
c        arg=AnglesSXD(3)*torad
c        cs=cos(arg)
c        sn=sin(arg)
c        h(1)= cs*hf(1)+sn*hf(2)
c        h(2)=-sn*hf(1)+cs*hf(2)
c        h(3)=hf(3)
c        write(6,'(3f10.5)')(h(i),i=1,3)
c        h(1)= cs*hf(1)-sn*hf(2)
c        h(2)= sn*hf(1)+cs*hf(2)
c        h(3)=hf(3)
c        write(6,'(3f10.5)')(h(i),i=1,3)
        call UnitMat(Rot,3)
        do 1840i=3,1,-1
          if(i.eq.1.or.i.eq.3) then
            j=3
          else
            j=1
          endif
          call SetRotMatAboutAxis(AnglesSXD(i)*SenseOfAngle(i),j,Rt)
          call multm(Rot,Rt,tt,3,3,3)
          call CopyMat(tt,Rot,3)
1840    continue
c        call multm(Rot,hf,h,3,3,1)
c        write(6,'(3f10.5)')(h(i),i=1,3)
        Longitude=(180.+Longitude)*ToRad
        Latitude=Latitude*ToRad
        csa=cos(Longitude)
        sna=sin(Longitude)
        csb=cos(Latitude)
        snb=sin(Latitude)
        tt(1,1)=-1.
        tt(2,1)= 0.
        tt(3,1)= 0.
        tt(1,2)=csa*csb
        tt(2,2)=sna*csb
        tt(3,2)=snb
        call multm(Rot,UBSXD,rt,3,3,3)
        call multm(tt(1,1),rt,sod,1,3,3)
        call multm(tt(1,2),rt,sd ,1,3,3)
        do 1860i=1,3
          dircos(i,1)=sod(i)/rcp(i,1,KPhase)
          dircos(i,2)=sd(i)/rcp(i,1,KPhase)
1860    continue
c        h(1)=csa*csb+1.
c        h(2)=sna*csb
c        h(3)=snb
c        write(6,'(3f10.5)')(h(i)/ReadLam,i=1,3)
c        write(6,'(3f10.5)') dircos
c        pause
      else
        if(FreeFormat) then
          read(96,FormA80,err=9000,end=3000) p80
          if(p80.eq.' ') go to 1800
          call RozdelMezerou(p80,'-')
          call RozdelMezerou(p80,'+')
          k=0
          do 1910i=1,ndim95i
            call kus(p80,k,Cislo)
            call posun(Cislo,itecka)
            if(RealIndices) then
              read(Cislo,101) h(i)
            else
              read(Cislo,FormI15) ihp(i)
            endif
1910      continue
          call kus(p80,k,Cislo)
          call posun(Cislo,1)
          read(Cislo,101) ri
          call kus(p80,k,Cislo)
          call posun(Cislo,1)
          read(Cislo,101) rs
        else
          if(RealIndices) then
            read(96,FormatIn,err=9000,end=3000)(h(i),i=1,3),ri,rs
          else
            if(TypeIn.eq.IdImportHKLF5) then
              read(96,FormatIn,err=9000,end=3000)(ihp(i),i=1,ndim95i),
     1          ri,rs,itw
                do 1920i=1,ndim95i
                  if(ihp(i).ne.0) go to 1930
1920            continue
                go to 3000
1930            ri=10.*ri
                rs=10.*rs
                call IndTr(ihp,TrmIn,ih,ndim)
                go to 2600
            else
              read(96,FormatIn,err=9000,end=3000)(ihp(i),i=1,ndim95i),
     1          ri,rs
            endif
            if(TypeIn.eq.IdImportSHELXF.or.TypeIn.eq.IdImportSHELXI.or.
     1         TypeIn.eq.IdImportCCDBruker) then
              ri=10.*ri
              rs=10.*rs
            endif
          endif
        endif
        if(RealIndices) then
          do 2005i=1,3
            if(abs(h(i)).gt..0001) go to 2040
2005      continue
        else
          if(ihp(1).gt.900) go to 3000
          do 2006i=1,ndim95
            if(ihp(i).ne.0) go to 2040
2006      continue
          go to 3000
        endif
      endif
2040  if(TypeIn.eq.IdImportSHELXF.or.TypeIn.eq.IdImportJanaOld.or.
     1   TypeIn.eq.IdImportGeneralF) then
        if(ri.gt.rs) then
          rs=2.*rs*ri
        else
          rs=2.*rs**2
        endif
        ri=ri**2
      endif
      if(RealIndices) then
        call multm(h,TrmIn,hf,1,ndim95,ndim95)
        if(ndim.eq.ndim95) then
          do 2042i=1,ndim
            ih(i)=nint(hf(i))
            if(abs(hf(i)-float(ih(i))).gt.difi(i)) go to 2900
2042      continue
        endif
      else
        do 2043j=1,ndim95
          h(j)=ihp(j)
2043    continue
        call multm(h,TrmIn,hf,1,ndim95,ndim95)
      endif
      if(ndim.gt.ndim95) then
        if(.not.RealIndices) then
          do 2045j=1,ndim
            if(j.le.ndim95) then
              hf(j)=hf(j)/float(nsup(j))
            else
              hf(j)=0.
            endif
2045      continue
        endif
        call CopyVek(hf,h,3)
        call multm(h,rtwi(1,iatw),hf,1,3,3)
      else if(ndim.eq.ndim95) then
        if(Fractional) then
          do 2200i=1,3
            hf(i)=hf(i)/float(ihf(i))
2200      continue
        else if(itwin.gt.1.and.itwi.gt.0) then
          mmax=0
          do 2210i=4,ndim
            mmax=max(iabs(nint(hf(i))),mmax)
2210      continue
          do 2230i=1,3
            h(i)=hf(i)
            do 2220j=1,ndimi
              h(i)=h(i)+qu(i,j,1,KPhase)*hf(j+3)
2220        continue
2230      continue
          call multm(h,rtwi(1,iatw),hf,1,3,3)
        else
          do 2240i=1,ndim95
            ih(i)=nint(hf(i))
            if(abs(float(ih(i))-hf(i)).gt..01) go to 2900
            if(i.le.3) then
              do 2235j=1,ndimi
                hf(i)=hf(i)+qu(i,j,1,KPhase)*hf(j+3)
2235          continue
            endif
2240      continue
        endif
      else
        mmax=0
        do 2300i=4,ndim95
          mmax=max(iabs(nint(hf(i))),mmax)
2300    continue
        do 2330i=1,3
          do 2310j=1,ndimi
            hf(i)=hf(i)+qu(i,j,1,KPhase)*hf(j+3)
2310      continue
          do 2320j=1,ndim95-ndim
            hf(i)=hf(i)+quit(i,j)*hf(j+ndim)
2320      continue
2330    continue
      endif
      call RestorePhase(1)
      if(itwi.gt.0) then
        call IndFromIndReal(hf,mmax,difi,ih,itw,isw,-1.,CheckExtRefNo)
        if(isw.le.0) go to 2900
        if(itw.lt.itwi) then
          if(BratMensiItw.lt.0) then
            NInfo=4
            TextInfo(1)='Some indices from the current data set can '//
     1                  'be transformed'
            TextInfo(2)='to already existing domains with lower '//
     1                  'sequence number.'
            TextInfo(3)='This can duplicate occurence of the same '//
     1                  'reflection and'
            TextInfo(4)='may bias the weighting scheme.'
            if(FeYesNoHeader(-1.,-1.,'Do you want to suppress possibly '
     1                       //'duplicate reflections?',1)) then
              BratMensiItw=0
            else
              BratMensiItw=1
            endif
          endif
          if(BratMensiItw.eq.0) go to 1800
        endif
      else
        isw=1
        itw=itwi
      endif
2600  nrefp=nrefp+1
      if(mod(nrefp,100).eq.0) then
        write(t80(1:6),103) nrefp
        call FeTxOutCont(t80)
      endif
      expos=float(nrefp)*.1
      ri=ri*RscFak
      rs=rs*RscFak
      call FromIndSinthl(ih,h,sinthl,sinthlq,1,0)
      pom=sinthl*LamAve(1)
      if(pom.lt.1.) then
        uhly(3)=asin(pom)/ToRad
      else
        uhly(3)=89.
      endif
      uhly(4)=uhly(3)
      write(ln,format95) nrefp,(ih(i),i=1,ndim),uhly,ri,rs,expos,iqo,
     1                   itw,corrf,tbar,dircos,ReadLam
      iqm=max(iqo,iqm)
      go to 1800
2900  call EM9NejdouPotvory(ihp,hf,ri,rs,ndim95,avis,nall,nobs,
     1                      nvyh500,iha,hfa,ipor,ria,rsa,rimax,3.,
     2                      RealIndices)
      go to 1800
3000  write(t80(1:6),103) nrefp
      call FeTxOutCont(t80)
      call FeTxOutEnd
      call UnitMat(trmp,ndim)
      call iom94(1)
      if(ndim.gt.ndim95) then
        if(nsups.gt.3) then
          do 3015j=1,ndimi
            do 3010i=1,3
              qu(i,j,1,KPhase)=quo(i,j)
              qui(i,j,KPhase)=qu(i,j,1,KPhase)-quir(i,j,KPhase)
3010        continue
3015      continue
        endif
        if(ncomp.gt.1) call setmet(0)
      endif
      if(kcommen.ne.0) call iom50(0,0)
      if(nvyh500.eq.0) then
        call FeMsgOut(-1.,-1.,'All observed reflections were '//
     1                'successfully imported')
      else
        if(nall.ne.0) then
          avis=avis/float(nall)
        else
          avis=0.
        endif
        write(TextInfo(1),'(''Overall           n(all) :'',i6,
     1                      '' n(obs) :'',i6)') nall,nobs
        write(TextInfo(2),'(18x,''Average(I/Sig(I)) : '',f5.2)')
     1        avis
        if(nvyh500.ne.500) call Indexx(nvyh500,ria,ipor)
        TextInfo(3)='            List of the strongest ones'
        NInfo=4
        if(TransformIndices) then
          TextInfo(NInfo)='Indices are related to the original cell !!!'
          NInfo=NInfo+1
        endif
        if(RealIndices) then
          write(TextInfo(NInfo),'(3(4x,a1,3x))')(indices(i),i=1,3)
          idl=25
        else
          write(TextInfo(NInfo),EM9Form1)(indices(i),i=1,ndim95)
          idl=idel(TextInfo(NInfo))+1
        endif
        TextInfo(NInfo)(idl:)='       I      sig(I)  I/sig(I)'
        do 5250i=1,min(nvyh500,15)
          NInfo=NInfo+1
          k=ipor(i)
          if(RealIndices) then
            write(TextInfo(NInfo),'(3f8.3)')(hfa(j,k),j=1,ndim95)
          else
            write(TextInfo(NInfo),EM9Form2)(iha(j,k),j=1,ndim95)
          endif
          pom1=-float(ria(k))*.0001
          pom2= float(rsa(k))*.01
          write(TextInfo(NInfo)(idl:),'(1x,2f9.1,f9.2)') pom1*pom2,pom2,
     1                                                   pom1
5250    continue
        call FeInfoOut(-1.,-1.,'Summary of reflections which couldn''t '
     1                //'be imported')
      endif
      go to 9999
9000  call FeTxOutEnd
      call FeReadError(96)
9100  ich=1
9999  call CloseIfOpened(96)
      iqmax=iqm
      return
100   format(i1)
101   format(f15.0)
103   format(i6)
      end
      subroutine EM9ImportFileOpenTrm(nEdwTrMat,Trm,ndimp,ndim95)
      dimension Trm(*)
      nEdw=nEdwTrMat
      k=1
      do 1000i=1,6
        if(i.le.ndim95) then
          call FeQuestRealAEdwOpen(nEdw,Trm(k),ndimp,.false.,.false.)
          k=k+ndimp
        else
          call FeQuestEdwClose(nEdw)
        endif
        nEdw=nEdw+1
1000  continue
      return
      end
      subroutine EM9ImportFileReadTrm(nEdwTrMat,Trm,ndimp,ndim95)
      dimension Trm(*)
      nEdw=nEdwTrMat
      k=1
      do 1000i=1,ndim95
        call FeQuestRealAFromEdw(nEdw,Trm(k))
        k=k+ndimp
        nEdw=nEdw+1
1000  continue
      return
      end
      subroutine EM9CheckFileIn(FileIn,FileIn94,in,ich)
      include 'params.cmn'
      include 'basic.cmn'
      include 'editm9.cmn'
      include 'fepc.cmn'
      character*(*) FileIn,FileIn94
      character*80  t80
      logical ExistFile
      ich=0
      if(ExistFile(FileIn)) then
        if(in.eq.IdImportDatRed) then
          if(FileIn.eq.fln(:ifln)//'.m95') then
            t80='the file : '//FileIn(:idel(FileIn))//' must be handled'
            call FeChybne(-1.,-1.,t80,
     1                    'directly and not imported',0,SeriousError)
            go to 9000
          endif
          if(.not.ExistFile(FileIn94)) then
            t80='the file "'//FileIn94(:idel(FileIn94))//
     1          '"doesn''t exist'
            call FeChybne(-1.,-1.,t80,'Try again',0,SeriousError)
            go to 9000
          endif
        endif
      else
        t80='the file "'//FileIn(:idel(FileIn))//'"doesn''t exist'
        call FeChybne(-1.,-1.,t80,'Try again',0,SeriousError)
        go to 9000
      endif
      go to 9999
9000  ich=1
9999  return
      end
      subroutine EM9ResetAssFile(FileIn,FileIn94)
      character*(*) FileIn,FileIn94
      j=idel(FileIn)
      if(j.eq.idel(FileIn94)) then
        i=index(FileIn,'.m95')
        if(i.gt.0) then
          if(FileIn94(i:i+3).eq.'.m94') FileIn94='.m94'
        endif
      endif
      return
      end
      subroutine EM9NewImpFile(lnk)
      include 'params.cmn'
      include 'basic.cmn'
      character*4  ext
      lnk=NextLogicNumber()
      write(ext,'(''.l'',i2)') lnk
      if(ext(3:3).eq.' ') ext(3:3)='0'
      call OpenFile(lnk,fln(:ifln)//ext,'formatted','unknown')
      return
      end
      subroutine EM9NejdouPotvory(ih,hf,ri,rs,ndim,avis,NExt,NExtObs,
     1                            NExt500,iha,hfa,ipor,ria,rsa,rimax,
     2                            EM9ObsLim,RealIndices)
      dimension ih(6),iha(6,500),ipor(500),hfa(3,500),hf(3)
      integer   ria(500),rsa(500)
      logical RealIndices
      pom=ri/rs
      avis=avis+ri/rs
      NExt=NExt+1
      if(pom.gt.EM9ObsLim) then
        NExtObs=NExtObs+1
        if(pom.gt.rimax) then
          if(NExt500.lt.500) then
            NExt500=NExt500+1
            k=NExt500
          else
            k=ipor(500)
          endif
          ria(k)=-nint(pom*10000.)
          rsa(k)= nint( rs*100.)
          if(RealIndices) then
            call CopyVek(hf,hfa(1,k),3)
          else
            call CopyVekI(ih,iha(1,k),ndim)
          endif
          if(NExt500.ge.500) then
            call Indexx(500,ria,ipor)
            rimax=-float(ria(ipor(500)))*.0001
          endif
        endif
      endif
      return
      end
      integer function EM9SortIndex(ihref)
      include 'params.cmn'
      include 'basic.cmn'
      dimension ihref(6),hh(6),hhp(6)
      EM9SortIndex=9
      do 1200i=1,ncomp
        do 1000j=1,ndim
          hh(j)=ihref(j)
1000    continue
        call multm(hh,zvi(1,i,KPhase),hhp,1,ndim,ndim)
        mm=0
        do 1100j=1,ndim
          n=nint(hhp(j))
          if(abs(float(n)-hhp(j)).gt..0001) go to 1200
          if(j.ge.4) mm=mm+iabs(n)
1100    continue
        EM9SortIndex=min(mm,EM9SortIndex)
1200  continue
      EM9SortIndex=EM9SortIndex+2
      return
      end
      subroutine EM9CheckCompleteness(ThMax,mmax)
      include 'params.cmn'
      include 'basic.cmn'
      include 'fepc.cmn'
      include 'editm9.cmn'
      include 'datred.cmn'
      dimension sp(mxref),h(3),ihn(6),NGen(8),NMer(8),PerArr(8),
     1          mmax(3,*)
      character*80 Format91Gen
      integer flag(mxref)
      logical eqiv
      equivalence (ria,sp),(rsa,fp)
      KPhaseIn=KPhase
      call RestorePhase(1)
      KPhase=1
      call iom50(0,0)
      if(kcommen.ne.0) call comsym(0,1)
      call OpenFile(91,fln(:ifln)//'.l91','formatted','unknown')
      if(ErrJana.ne.0) go to 9999
      snthlmx=sin(ThMax*ToRad)/LamAve(1)
      call GenerRef('Calculating coverage statistics',snthlmx,mmax,
     1              .true.,0)
      if(ErrJana.ne.0) go to 9999
      rewind 91
      if(NPhase.gt.1) then
        Format91Gen=Format91Pow
        NInd=6
      else
        Format91Gen=Format91
        NInd=ndim
      endif
      call RestorePhase(1)
      KPhase=1
      nref=0
1100  read(91,Format91Gen,end=2000)(ih(i),i=1,NInd),f,f,i,i,KPh,s
      if(ih(1).gt.900) go to 2000
      if(NPhase.gt.1.and.KPh.ne.KPhase) go to 1100
      nref=nref+1
      call CopyVekI(ih,ihar(1,nref),ndim)
      Flag(nref)=0
      call FromIndSinthl(ih,h,sp(nref),sinthlq,1,0)
      go to 1100
2000  close(91,status='delete')
      call OpenFile(91,fln(:ifln)//'.m91','formatted','unknown')
      if(ErrJana.ne.0) go to 9999
2100  read(91,Format91,end=3000)(ih(i),i=1,ndim)
      if(ih(1).gt.900) go to 3000
      call FromIndSinthl(ih,h,s,sinthlq,1,0)
      ip=1
      ik=NRef
2150  if(ik.le.ip+1) go to 2200
      ipul=(ik+ip)/2
      if(s.lt.sp(ipul)) then
        ik=ipul
        go to 2150
      else if(s.gt.sp(ipul)) then
        ip=ipul
        go to 2150
      else
        ip=ipul
        ik=ipul
        go to 2200
      endif
2200  ip=max(ip-10,1)
      ik=min(ik+10,NRef)
      do 2400j=1,ns
        call IndTr(ih,rm6(1,j,1,KPhase),ihp,ndim)
        call IntVectorToOpposite(ihp,ihn,ndim)
        do 2300i=ip,ik
          if(eqiv(ihp,ihar(1,i),ndim).or.eqiv(ihn,ihar(1,i),ndim)) then
            flag(i)=1
            go to 2100
          endif
2300    continue
2400  continue
      go to 2100
3000  close(91)
      call SetIntArrayTo(NMer,8,0)
      call SetIntArrayTo(NGen,8,0)
      do 3200i=1,NRef
        do 3100j=1,8
          if(sp(i).le.sinmez(j)) then
            if(Flag(i).gt.0) NMer(j)=NMer(j)+1
            NGen(j)=NGen(j)+1
          endif
3100    continue
3200  continue
      call TitulekVRamecku('Coverage statistics')
      call newln(2)
      write(lst,'(''sin(theta)/lambda '',8f10.6)') sinmez
      do 3220i=1,8
        PerArr(i)=float(NMer(i))/float(NGen(i))*100.
3220  continue
      write(lst,'(''Coverage in  %    '',8f10.2)') PerArr
      PerLimit=95.
      do 3230i=8,1,-1
        if(PerArr(i).gt.PerLimit) go to 3240
3230  continue
      go to 3500
3240  if(i.eq.8) then
        ThFull=ThMax
        PerLimit=PerArr(8)
        go to 3300
      endif
      SThP=sinmez(i)
      SThK=sinmez(i+1)
3250  SThPul=(SThK+SThP)*.5
      if(SThK-SthP.le..00001) then
        ThFull=asin(SThPul*LamAve(1))/ToRad
        go to 3300
      endif
      NMerP=0
      NGenP=0
      do 3270i=1,NRef
        if(sp(i).le.SThPul) then
          if(Flag(i).gt.0) NMerP=NMerP+1
          NGenP=NGenP+1
        endif
3270  continue
      pom=float(NMerP)/float(NGenP)*100.
      if(pom.gt.PerLimit) then
        SThP=SThPul
      else if(pom.lt.PerLimit) then
        SThK=SThPul
      else
        SThP=SThPul
        SThK=SThPul
      endif
      go to 3250
3300  call newln(2)
      write(lst,'(/''Coverage of '',f6.2,''% achieved at theta = '',
     1            f5.2,'' deg'')') PerLimit,ThFull
      go to 9999
3500  call newln(2)
      write(lst,'(/''Coverage lower than '',f6.2,''% in full data '',
     1             ''range'')') PerLimit
      PerLimit=111.
9999  if(kcommen.ne.0) call iom50(0,0)
      KPhase=KPhaseIn
      call RestorePhase(KPhase)
      return
      end

