      subroutine Fourier
      include 'params.cmn'
      include 'basic.cmn'
      include 'fourier.cmn'
      include 'fepc.cmn'
      call FouPrelim
      if(ErrJana.ne.0) go to 9999
      if(lcalc.eq.1) then
        call FourierSum
        if(ErrJana.ne.0) go to 9999
      endif
      if(lpeaks.eq.1) then
        call peaks(0,81)
        if(ErrJana.ne.0) go to 9999
      endif
      call CloseIfOpened(81)
9999  call CloseListing
      if(.not.RefineCallFourier.and.ErrJana.eq.0)
     1  call FeShowListing(-1.,-1.,'FOURIER program','fou',10000)
      if(Patterson) then
        call DeleteFile(PreviousM40)
        call DeleteFile(PreviousM50)
      endif
      return
      end
      subroutine FouPrelim
      include 'params.cmn'
      include 'basic.cmn'
      include 'fourier.cmn'
      include 'atoms.cmn'
      include 'fepc.cmn'
      character*80 t80
      character*30 Format80F
      logical ExistM80,eqiv,EqIgCase,konec,FeYesNoHeader,ExistFile
      dimension ih(6),ihp(6),ihpp(6),mxh(6),mxd(6),hh(6),hhp(6)
      call DeleteFile(fln(:ifln)//'_fourier.tmp')
      call OpenFile(lst,fln(:ifln)//'.fou','formatted','unknown')
      if(ErrJana.ne.0) go to 9999
      LstOpened=.true.
      uloha='Program for n-dimensional Fourier synthesis'
      noo=-333
      call SetRealArrayTo(xrmn,ndim,-333.)
      ptstep=-1.0
      call iom40(0,0)
      if(ErrJana.eq.-1) then
        call CrlbCorrectAtomNames(ich)
        if(ich.ne.0) then
          ErrJana=1
          go to 9999
        endif
      else if(ErrJana.ne.0) then
        go to 9999
      endif
      call DefaultFourier
      call NactiFourier
      if(ErrJana.ne.0) go to 9999
      if(RefineCallFourier) then
        YMinFlowChart=20.
      else
        YMinFlowChart=-1.
      endif
      if(ndim.le.3) then
        nsubs=1
      else
        nsubs=min(nsubs,ncomp)
      endif
      Patterson=mapa.le.3
      call iom50(0,1)
      call comsym(0,1)
      if(ErrJana.ne.0) go to 9999
      ExistM80=ExistFile(fln(:ifln)//'.m80')
      if(.not.ExistM80.and.mapa.ne.1) then
        if(lcalc.eq.1.or..not.ExistFile(fln(:ifln)//'.m81')) then
          call FeChybne(-1.,-1.,'the M80 file doesn''t exist, first you'
     1              //' have to','run REFINE to get phases and/or Fcalc'
     2               ,0,SeriousError)
          ErrJana=1
          go to 9999
        endif
      endif
      if(ptstep.lt.0.) ptstep=.25
      call deflim
      if(lcalc.eq.1) then
        if(ExistM80) then
          call OpenFile(80,fln(:ifln)//'.m80','formatted','old')
          if(ErrJana.ne.0) go to 9999
          read(80,FormA80,end=8000,err=8000) t80
          read(80,FormA80,end=8000,err=8000) t80
          call mala(t80)
          if(index(t80,'e').le.0) then
            Format80F=Format80(1:8)//'11f9.3)'
          else
            Format80F=Format80
          endif
          rewind 80
        else
          call OpenFile(91,fln(:ifln)//'.m91','formatted','old')
          if(ErrJana.ne.0) go to 9999
        endif
        FileM82='jm82'
        call CreateTmpFile(FileM82,i,0)
        call FeTmpFilesAdd(FileM82)
        call OpenFile(82,FileM82,'unformatted','unknown')
        if(ErrJana.ne.0) go to 9000
      endif
      twov=2./CellVol(nsubs,1)
      pom=TOverAll
      if(mapa.eq.9.and.ChargeDensities) then
        call OpenFile(86,RefM80,'formatted','old')
        if(ErrJana.ne.0) go to 9000
      endif
      TOverAll=pom
1015  if(lcalc.eq.1) then
        if(Patterson) then
          srnat=0.
          if(Radiation(1).eq.XRayRadiation) then
            do 1020i=1,NAtFormula
              srnat=srnat+AtMult(i,KPhase)
1020        continue
          endif
          if(srnat.gt.0.) then
            if(ntab.gt.0) then
              do 1022i=1,nf
                fx(i)=fx(i)+ffbasic(1,i,KPhase)+ffr(i,KPhase)
1022          continue
            else
              do 1032i=1,nf
                fx(i)=ffbasic(10,i,KPhase)+ffr(i,KPhase)
                j=0
                do 1030k=2,8,2
                  fx(i)=fx(i)+ffbasic(k,i,KPhase)
1030            continue
1032          continue
            endif
            pom0=0.
            do 1035i=1,NAtFormula
              pom0=pom0+
     1             AtMult(i,KPhase)*sqrt((fx(i)**2+ffi(i,KPhase)**2))
1035        continue
          else
            pom0=1.
          endif
        endif
        if(lite.eq.1) then
          rhom=1.
        else
          rhom=episq
        endif
        if(ptname.ne.'[nic]') then
          ncollar=0
          if(ptname.ne.'[neco]') then
            kk=0
            call SetRealArrayTo(ptx,3,0.)
            pom=0.
1050        call Kus(ptname,kk,t80)
            call atsym(t80,i,hhp,hh,hh(4),j,k)
            if(i.le.0) then
              call FeChybne(-1.,-1.,'atom '//t80(:idel(t80))//
     1                      ' isn''t on the '//'file M40',
     2                      'The part of the volume to be mapped '//
     3                      'isn''t defined',1,SeriousError)
              ErrJana=1
            endif
            if(k.eq.3) then
              call FeChybne(-1.,-1.,'atom '//t80(:idel(t80))//
     1                      ' isn''t correct',
     2                      'The part of the volume to be mapped '//
     3                      'isn''t defined',1,SeriousError)
              ErrJana=1
            endif
            if(ErrJana.ne.0) go to 9000
            pom=pom+1.
            call AddVek(ptx,hhp,ptx,3)
            if(kk.lt.idel(ptname)) go to 1050
            do 1060i=1,3
              ptx(i)=ptx(i)/pom
1060        continue
          endif
          do 1100j=1,3
            nd=nint(.5*pts(j)/ptstep)
            if(nd.ne.0) then
              dd(j)=ptstep/CellPar(j,nsubs,KPhase)
            else
              dd(j)=1.
            endif
            xrmn(j)=ptx(j)-dd(j)*float(nd)
            xrmx(j)=ptx(j)+dd(j)*float(nd)
1100      continue
        endif
        if(noo.eq.-333) noo=nop(nsubs)
        norien=noo
        n=norien
        i=10**(ndim-1)
        do 1220j=1,ndim-1
          iorien(j)=n/i
          n=mod(n,i)
          i=i/10
1220    continue
        iorien(ndim)=n
        do 1250j=1,6
          if(j.le.ndim) then
            if(xrmn(j).lt.-330.) then
              xrmn(j)=fourmn(j,nsubs)
              xrmx(j)=fourmx(j,nsubs)
              if(j.le.3) then
                n=max(nint((xrmx(j)-xrmn(j))*
     1                CellPar(j,nsubs,KPhase)/ptstep),1)
                dd(j)=(xrmx(j)-xrmn(j))/float(n)
              else
                dd(j)=.1
              endif
            else
              if(j.le.3) ncollar=0
            endif
          else
            xrmn(j)=0.
            xrmx(j)=0.
            dd(j)=1.
          endif
1250    continue
        do 1400i=1,ndim
          n=iorien(i)
          if(n.lt.1.or.n.gt.ndim) go to 1500
          do 1350j=i+1,ndim
            if(n.eq.iorien(j)) go to 1500
1350      continue
1400    continue
        go to 1550
1500    t80='wrong orientation'
        i=idel(t80)+1
        write(t80(i:i+6),'(i7)') norien
        call FeChybne(-1.,-1.,t80,' ',1,SeriousError)
        ErrJana=1
        go to 9000
1550    do 1600i=1,6
          if(i.le.ndim) then
            j=iorien(i)
            if(ncollar.eq.1.and.j.le.3) then
              xrmn(j)=xrmn(j)-dd(j)
              xrmx(j)=xrmx(j)+dd(j)
            endif
            xfmn(i)=xrmn(j)
            xfmx(i)=xrmx(j)
            xdf(i)=dd(j)
          else
            xfmn(i)=0.
            xfmx(i)=0.
            xdf(i)=1.
          endif
1600    continue
        do 1610i=1,6
          pom=xfmx(i)-xfmn(i)
          nx(i)=nint(pom/xdf(i))+1
          if(i.le.ndim) then
            if(nx(i).gt.1) then
              dpom=pom/float(nx(i)-1)
              if(abs(xdf(i)-dpom).gt..00001) xdf(i)=dpom
            endif
            if(pom.lt.0.or.xdf(i).lt.0.) then
              write(t80,'(3f8.3)') xfmn(i),xfmx(i),xdf(i)
              call ZdrcniCisla(t80,3)
              j=idel(t80)
              if(ndim.eq.3) then
                t80='Incorrect limits for '//smbx(i)//' : '//t80(:j)
              else
                t80='Incorrect limits for '//smbx6(i)//' : '//t80(:j)
              endif
              call FeChybne(-1.,-1.,t80,' ',0,SeriousError)
              ErrJana=1
              go to 9000
            endif
          endif
1610    continue
        nxny=nx(1)*nx(2)
        nmap=nx(3)*nx(4)*nx(5)*nx(6)
      else
        call OpenMaps(81,fln(:ifln)//'.m81',nxny,0)
        if(ErrJana.ne.0) go to 9000
        read(81,rec=1,err=1620) nx,nxny,nmap,(xfmn(i),xfmx(i),i=1,6),
     1                          xdf,iorien,mapa,nsubs,mmax
        nsubs=mod(nsubs,10)
        Patterson=mapa.le.3
        go to 1630
1620    lcalc=1
        go to 1015
      endif
      if(nxny.lt.50) then
        write(t80,'(i5,''x'',i5)') nx(1),nx(2)
        call Zhusti(t80)
        t80='2d sections would contain only '//t80(:idel(t80))//
     1      ' points.'
        call FeChybne(-1.,-1.,t80,'Please enlarge the scope of maps.',0,
     1                SeriousError)
        ErrJana=1
        go to 9000
      endif
1630  if(Patterson) then
        ncs=1
        do 1650i=1,ns
          call SetRealArrayTo(s6(1,i,1,KPhase),ndim,0.)
1650    continue
      endif
      do 1700i=1,6
        if(i.le.ndim) then
          cx(i)=smbx6(iorien(i))
        else
          cx(i)=' '
        endif
1700  continue
      if(lpeaks.eq.1) then
        if(npeaks(1).lt.0) then
          fa=0.
          fah=0.
          do 1800i=1,nacalc
            if(ffbasic(1,isf(i),KPhase).lt.2.) then
              fah=fah+ai(i)
            else
              fa=fa+ai(i)
            endif
1800      continue
          pom=0.
          pomh=0.
          do 1850i=1,NAtFormula
            if(EqIgCase(AtFormula(i,KPhase),'H')) then
              pomh=pomh+AtMult(i,KPhase)
            else
              pom=pom+AtMult(i,KPhase)
            endif
1850      continue
          pom=pom*float(nz)/float(nvt*ns*(3-ncs))
          nacp=nint(pom)
          pomh=pomh*float(nz)/float(nvt*ns*(3-ncs))
          nacp=nint(pom)
          nachp=nint(pomh)
          if(Patterson) then
            npeaks(1)=50
          else if(mapa.eq.4.or.mapa.eq.5) then
            npeaks(1)=nacp+10
          else
            npeaks(1)=max(nacp-nint(fa)+nachp-nint(fah)+10,10)
          endif
        endif
        if(npeaks(2).lt.0) npeaks(2)=10
        do 1900i=1,2
          npeaks(i)=min(npeaks(i),mxa)
1900    continue
      endif
2000  t80='Type of map : '
      if(mapa.eq.1) then
        t80(15:)='F(obs)**2 - Patterson'
      else if(mapa.eq.2) then
        t80(15:)='F(calc)**2 - checking Patterson'
      else if(mapa.eq.3) then
        t80(15:)='F(obs)**2-F(calc)**2 - difference Patterson'
      else if(mapa.eq.4) then
        t80(15:)='F(obs) - Fourier'
      else if(mapa.eq.5) then
        t80(15:)='F(calc) - checking Fourier'
      else if(mapa.eq.6) then
        t80(15:)='F(obs)-F(cal) - difference Fourier'
      else if(mapa.eq.7) then
        t80(15:)='dynamic multipole deformation map'
      else if(mapa.eq.8) then
        t80(15:)='static multipole deformation map'
      else if(mapa.eq.9) then
        t80(15:)='general deformation map'
      else if(mapa.eq.15) then
        t80(15:)='1/0 - shape function'
      else
        call FeChybne(-1.,-1.,'wrong map type',' ',1,SeriousError)
        ErrJana=1
        go to 9000
      endif
      call newln(2)
      write(lst,FormA1) ' '
      write(lst,FormA1)(t80(i:i),i=1,idel(t80))
      if(vyber.gt.0.) then
        call newln(2)
        write(lst,'(/''Reflections with  |Fo| > '',f10.2,'' * |Fc| '',
     1               ''will not be used in the synthesis'')') vyber
      endif
      call newln(2)
      if(UseWeight.gt.0) then
        write(lst,'(/''Weighting of reflection based on chi-square '',
     1               ''will be applied'')')
      else
        write(lst,'(/''No weighting of reflections will be applied'')')
      endif
      call newln(2)
      if(CheckForEq.eq.0) then
        NInfo=3
        TextInfo(1)='The set of reflections will not be checked for '//
     1              'presence'
        TextInfo(2)='of eqiuvalent or identical reflections. You have'//
     1              ' be sure'
        TextInfo(3)='that only Laue independent set of reflection is '//
     1              'used.'
        WaitTime=10000
        if(.not.FeYesNoHeader(-1.,-1.,'Do you really want to continue?',
     1                        1)) then
          ErrJana=1
          go to 9999
        endif
        write(lst,'(/''The set of reflections will not be checked '',
     1               ''for presence of eqiuvalent or identical '',
     2               ''reflections'')')
      else
        write(lst,'(/''Relevant coefficients of equivalent and '',
     1               ''identical reflections will be averaged '',
     2               ''before Fourier summation'')')
      endif
      if(snlmx.le.0.0) snlmx=10.0
      call newln(2)
      write(lst,'(/''Limits of sin(th)/lambda for acceptance are : '',
     1            2f10.6)') snlmn,snlmx
      if(ncomp.gt.1) then
        call newln(2)
        write(lst,'(/''Fourier for subsystem #'',i1,'' will be '',
     1               ''calculated'')') nsubs
      endif
      call newln(ndim+2)
      write(lst,FormA1) ' '
      write(lst,'(''Scope of the map :'')')
      do 2050i=1,ndim
        if(nx(i).gt.1) then
          write(lst,'(a2,'' from'',f8.4,'' to'',f8.4,'' step'',f7.4)')
     1          cx(i),xfmn(i),xfmx(i),xdf(i)
        else
          xfmn(i)=(xfmn(i)+xfmx(i))*.5
          xfmx(i)=xfmn(i)
          write(lst,'(a2,'' fixed to'',f8.4)') cx(i),xfmn(i)
        endif
2050  continue
      call newln(2)
      write(lst,FormA1) ' '
      write(t80,'(''Orientation : '',6i1)')(iorien(i),i=1,ndim)
      write(lst,FormA1)(t80(i:i),i=1,idel(t80))
      if(lcalc.eq.1) then
        pom=0.
        do 2100i=1,1000
          trgtbl(i)=cos(pom)
          pom=pom+pi2*.001
2100    continue
        trgtbl(1)   = 1.0
        trgtbl(251) = 0.0
        trgtbl(501) =-1.0
        trgtbl(751) = 0.0
        trgtbl(1001)= 1.0
        rewind 82
        call FeMouseShape(3)
        call SetIntArrayTo(mxh,6,0)
        nref=0
3000    if(ExistM80) then
          read(80,Format80F,end=3100,err=8000)(ih(i),i=1,maxndim),KPh,
     1                                         fo1,fc
        else
          read(91,format91,end=3100,err=8100)(ih(i),i=1,ndim),fo1,fo2
          KPh=KPhase
        endif
        if(ih(1).gt.900) go to 3100
        if(KPh.ne.KPhase) go to 3000
        if(nsubs.gt.1) then
          do 3010i=1,ndim
            hh(i)=ih(i)
3010      continue
          call multm(hh,zvi(1,nsubs,KPhase),hhp,1,ndim,ndim)
          do 3020i=1,ndim
            ih(i)=nint(hhp(i))
3020      continue
        endif
        do 3060i=1,ns
          call IndTr(ih,rm6(1,i,nsubs,KPhase),ihpp,ndim)
          do 3050j=1,ndim
            mxh(j)=max(mxh(j),iabs(ihpp(iorien(j))))
3050      continue
3060    continue
        nref=nref+1
        go to 3000
3100    iz=0
        call FeFlowChartOpen(-1.,YMinFlowChart,
     1                       max(nint(float(nref)*.005),10),
     2                       nref,'Expanding of reflections',' ',' ')
        do 3200i=1,ndim
          mxd(i)=2*mxh(i)+1
3200    continue
        if(ExistM80) then
          rewind 80
        else
          rewind 91
        endif
        kmin= 999999
        kmax=-999999
        hmin= 999999
        hmax=-999999
        mmax=0
        kolik=0
        konec=.false.
        sigfo1=0.
        sigfo2=0.
3500    if(ExistM80) then
          read(80,Format80F,err=8000,end=5000)
     1      (ih(i),i=1,Maxndim),KPh,fo1,fo2,fc,ac,bc,acfree,bcfree,acst,
     2      bcst,acfreest,bcfreest,sigfo1,sigfo2
          if(ih(1).gt.900) go to 5000
          if(KPh.ne.KPhase) go to 3500
          if(mapa.eq.9) then
            read(86,Format80F,err=3600)(ihp(i),i=1,ndim),fo1,fo2,pom,
     1                                 acfree,bcfree
            if(.not.eqiv(ih,ihp,ndim)) then
              call FeChybne(-1.,-1.,'incompatible reference M80 file',
     1                      'the defomation map cannot be calculated',
     2                       1,SeriousError)
              go to 3700
            endif
            go to 4000
3600        call FeChybne(-1.,-1.,'incorrect reference M80 file',
     1                    'the defomation map cannot be calculated',
     2                    1,SeriousError)
3700        ErrJana=1
            go to 9000
          endif
        else
          if(isPowder) then
            read(91,format91Pow,err=8100,end=5000) ih,fo1,fo2,i,i,KPh
            if(KPh.ne.KPhase) go to 3500
          else
            read(91,format91,err=8100,end=5000)(ih(i),i=1,ndim),fo1,fo2
          endif
          fc=0.
          if(ih(1).lt.900) then
            if(fo1.gt.0.) then
              fo1=sqrt(fo1)
            else
              fo1=0.
            endif
            fo2=fo1
          else
            go to 5000
          endif
        endif
4000    call FromIndSinthl(ih,hh,sinthl,sinthlq,1,0)
        call FeFlowChartEvent(iz,ie)
        if(ie.ne.0) then
          call BudeBreak
          if(ErrJana.ne.0) go to 9000
        endif
        if(metoda.eq.1) then
          fo=fo1
          sigfo=sigfo1
        else
          fo=fo2
          sigfo=sigfo2
        endif
        if(vyber.gt.0.and.abs(fo).gt.vyber*abs(fc)) go to 3500
        if(sinthl.gt.snlmx.or.sinthl.lt.snlmn) go to 3500
        if(fc.ne.0.) then
          cosaq=ac/fc
          sinaq=bc/fc
        else
          cosaq=0.
          sinaq=0.
        endif
        if(ndim.gt.3.and.nsubs.gt.1) then
          do 4005i=1,ndim
            hh(i)=ih(i)
4005      continue
          call multm(hh,zvi(1,nsubs,KPhase),hhp,1,ndim,ndim)
          do 4008i=1,ndim
            ih(i)=nint(hhp(i))
4008      continue
        endif
c        w=1.
        if(mapa.eq.1) then
          frp=fo**2
          fip=0.
          SigCoef=2.*fo*sigfo
          Coef=frp
        else if(mapa.eq.2) then
          frp=fc**2
          fip=0.
          SigCoef=2.*fo*sigfo
          Coef=frp
        else if(mapa.eq.3) then
          frp=fo**2-fc**2
          fip=0.
          SigCoef=2.*fo*sigfo
          Coef=frp
        else if(mapa.eq.4) then
          frp=fo*cosaq
          fip=fo*sinaq
          SigCoef=sigfo
          Coef=fo
        else if(mapa.eq.5) then
          frp=fc*cosaq
          fip=fc*sinaq
          SigCoef=sigfo
          Coef=fc
        else if(mapa.eq.6) then
          pom=fo-fc
          frp=pom*cosaq
          fip=pom*sinaq
          SigCoef=sigfo
          Coef=pom
        else if(mapa.eq.7.or.mapa.eq.9) then
          frp=ac-acfree
          fip=bc-bcfree
          SigCoef=0.
          Coef=frp
        else if(mapa.eq.8) then
          frp=acst-acfreest
          fip=bcst-bcfreest
          SigCoef=0.
          Coef=frp
        else if(mapa.eq.15) then
          frp=1.
          fip=0.
          SigCoef=0.
          Coef=frp
        endif
        if(SigCoef.gt.1.e-30.and.UseWeight.eq.1) then
          if(abs(Coef).gt.1.e-30) then
            pom=max(1.-(SigCoef/Coef)**2,0.)
          else
            pom=0.
          endif
          frp=pom*frp
          fip=pom*fip
        endif
        if(ih(1).eq.0.and.ih(2).eq.0.and.ih(3).eq.0) then
          frp=frp/2.
          fip=fip/2.
        endif
        if(Patterson) then
          rho=sinthl**2*rhom
          if(srnat.gt.0.) then
            if(ntab.gt.0) then
              pt=sinthl/.05+1.
              ipt=ifix(pt)-1
              do 4010i=1,nf
                fx(i)=ffr(i,KPhase)
4010          continue
              do 4050k=1,4
                pom=1.
                do 4030l=1,4
                if(k.ne.l) pom=pom*(pt-float(ipt+l))/float(k-l)
4030            continue
                do 4040i=1,nf
                  l=k+ipt
                  if(l.gt.0) then
                    if(l.le.ntab) then
                      ffp=ffbasic(l,i,KPhase)
                    else
                      ffp=ffbasic(ntab,i,KPhase)
                    endif
                  else
                    ffp=ffbasic(1,i,KPhase)
                  endif
                  fx(i)=fx(i)+pom*ffp
4040            continue
4050          continue
            else
              do 4070i=1,nf
                fx(i)=ffbasic(10,i,KPhase)+ffr(i,KPhase)
                j=0
                do 4060k=2,8,2
                  arg=-sinthl**2*ffbasic(k+1,i,KPhase)
                  if(arg.lt.-60.) go to 4060
                  fx(i)=fx(i)+ffbasic(k,i,KPhase)*exp(arg)
4060            continue
4070          continue
            endif
            pom=0.
            do 4077i=1,NAtFormula
              pom=pom+AtMult(i,KPhase)*sqrt(fx(i)**2+ffi(i,KPhase)**2)
4077        continue
          else
            pom=1.
          endif
          pom=pom*exp(-TOverAll*rho)
          frp=frp*(pom0/pom)**2
        endif
        if(CheckForEq.eq.0) kolik=0
        do 4200i=1,ns
          call IndTr(ih,rm6(1,i,nsubs,KPhase),ihpp,ndim)
          arg=0.
          do 4110j=1,ndim
            arg=arg-float(ih(j))*s6(j,i,nsubs,KPhase)
4110      continue
          arg=arg*pi2
          cs=cos(arg)
          sn=sin(arg)
          pom1=twov*(frp*cs-fip*sn)
          pom2=twov*(frp*sn+fip*cs)
          do 4116j=1,ndim
            if(ihpp(iorien(j)).lt.0) then
              pom2=-pom2
              do 4115k=1,ndim
                ihpp(k)=-ihpp(k)
4115          continue
              go to 4118
            else if(ihpp(iorien(j)).gt.0) then
              go to 4118
            endif
4116      continue
4118      indp=0
          do 4120j=ndim,1,-1
            indp=indp*mxd(j)+ihpp(iorien(j))+mxh(j)
4120      continue
          do 4130j=1,kolik
            if(indp.eq.ind(j)) then
              fr(j)=fr(j)+pom1
              fi(j)=fi(j)+pom2
              mlt(j)=mlt(j)+1
              go to 4200
            endif
4130      continue
          kolik=kolik+1
          fr(kolik)=pom1
          fi(kolik)=pom2
          mlt(kolik)=1
          ind(kolik)=indp
4200    continue
        go to 5005
5000    if(CheckForEq.eq.0) go to 5500
        konec=.true.
        CheckForEq=0
5005    if(CheckForEq.eq.0) then
          call SetIntArrayTo(ihp,6,0)
          do 5200i=1,kolik
            indp=ind(i)
            do 5020j=1,ndim
              ihp(j)=mod(indp,mxd(j))-mxh(j)
              indp=indp/mxd(j)
              if(j.gt.3) mmax=max(mmax,iabs(ihp(j)))
5020        continue
            hmax=max(hmax,ihp(1))
            hmin=min(hmin,ihp(1))
            kmax=max(kmax,ihp(2))
            kmin=min(kmin,ihp(2))
            if(mlt(i).ne.1) then
              pom=1./float(mlt(i))
              fr(i)=fr(i)*pom
              fi(i)=fi(i)*pom
            endif
            write(82) ihp,fr(i),fi(i)
5200      continue
          if(.not.konec) go to 3500
        else
          go to 3500
        endif
5500    rewind 82
      endif
      call FeFlowChartRemove
      MameSatelity=mmax.gt.0
      if(.not.MameSatelity) then
        do 6000i=1,3
          if(iorien(i).gt.3) go to 9000
6000    continue
        call SetIntArrayTo(nx(4),ndimi,1)
        call SetRealArrayTo(xfmn(4),ndimi,0.)
        call SetRealArrayTo(xfmx(4),ndimi,0.)
        call SetRealArrayTo(xdf(4),ndimi,0.1)
        nmap=nx(3)
      endif
      go to 9999
8000  call FeReadError(80)
      go to 8900
8100  call FeReadError(91)
8900  ErrJana=1
      call FeFlowChartRemove
9000  call DeleteFile(fln(:ifln)//'.m81')
      call DeleteFile(FileM82)
      call FeTmpFilesClear(FileM82)
9999  return
      end
      subroutine BudeBreak
      include 'params.cmn'
      include 'basic.cmn'
      include 'fepc.cmn'
      include 'fourier.cmn'
      logical FeYesNo
      if(FeYesNo(-1.,30.,'Do you really want to cancel the '//
     1           'Fourier summation?',0)) then
        call DeleteFile(fln(:ifln)//'.m81')
        call DeleteFile(FileM82)
        call FeTmpFilesClear(FileM82)
        call FeFlowChartRemove
        ErrJana=1
        go to 9999
      endif
9999  return
      end
      subroutine DefaultFourier
      include 'params.cmn'
      include 'basic.cmn'
      include 'atoms.cmn'
      include 'fourier.cmn'
      NactiInt=20
      NactiReal=20
      NactiComposed=13
      NactiKeys=NactiInt+NactiReal+NactiComposed
      call CopyVekI(DefIntFour,NacetlInt   ,NactiInt)
      call CopyVekI(DefIntFour,DefaultInt  ,NactiInt)
      call CopyVekI(DefIntFour,CmdIntFour,NactiInt)
      i=NactiInt+1
      call CopyVek(DefRealFour(i),NacetlReal(i) ,NactiReal)
      call CopyVek(DefRealFour(i),DefaultReal(i),NactiReal)
      call CopyVek(DefRealFour(i),CmdRealFour, NactiReal)
      do 1200i=1,NactiKeys
        NactiKeywords(i)=IdFour(i)
1200  continue
      ptname='[nic]'
      ptx(1)=0.
      ptx(2)=0.
      ptx(3)=0.
      pts(1)=.5
      pts(2)=.5
      pts(3)=.5
      RefM80=' '
      return
      end
      subroutine NactiFourier
      include 'params.cmn'
      include 'basic.cmn'
      include 'fourier.cmn'
      include 'atoms.cmn'
      dimension xp(3)
      call OpenFile(m50,fln(:ifln)//'.l51','formatted','old')
      if(ErrJana.ne.0) go to 9999
      call Najdi('fourier',i)
      if(i.ne.1) go to 9999
      call SetIntArrayTo(NactiRepeat,NactiKeys,0)
      PreskocVykricnik=.true.
1100  call NactiCommon(M50,izpet)
      if(ErrJana.ne.0) go to 9999
      if(izpet.eq.0) then
        call CopyVekI(NacetlInt ,CmdIntFour ,NactiInt)
        call CopyVek (NacetlReal(NactiInt+1),CmdRealFour,NactiReal)
        go to 9999
      else if(izpet.ge.nCmdxlim.and.izpet.le.nCmdx6lim) then
        if(izpet.le.nCmdzlim) then
          j=izpet-nCmdxlim+1
        else
          j=izpet-nCmdx1lim+1
        endif
        call StToReal(NactiVeta,PosledniPozice,xp,3,.false.,ich)
        if(ich.ne.0) go to 9000
        xrmn(j)=xp(1)
        xrmx(j)=xp(2)
        if(xp(3).le.0.) xp(3)=1.
        dd(j)=xp(3)
      else if(izpet.eq.nCmdcenter) then
        call StToReal(NactiVeta,PosledniPozice,ptx,3,.false.,ich)
        if(ich.eq.0) then
          ptname='[neco]'
          go to 1100
        endif
        ptname=NactiVeta(PosledniPozice+1:)
        call UprAt(ptname)
      else if(izpet.eq.nCmdscope) then
        call StToReal(NactiVeta,PosledniPozice,pts,3,.false.,ich)
        if(ich.ne.0) go to 9000
      else if(izpet.eq.nCmdrefm80) then
        call kus(NactiVeta,PosledniPozice,RefM80)
      endif
      if(lite.eq.0) then
        TOverAll=NacetlReal(nCmdUOverAll)
      else
        TOverAll=NacetlReal(nCmdBOverAll)
      endif
      if(izpet.ne.0) go to 1100
9000  call ChybaNacteni(izpet)
      go to 1100
9999  call CloseIfOpened(m50)
      return
102   format(f15.5)
      end
      subroutine FourierSum
      include 'params.cmn'
      include 'basic.cmn'
      include 'fourier.cmn'
      character*80 t80
      dimension ihp(6)
      call OpenMaps(81,fln(:ifln)//'.m81',nxny,1)
      if(ErrJana.ne.0) go to 9999
      write(81,rec=1) nx,nxny,nmap,(xfmn(i),xfmx(i),i=1,6),xdf,iorien,
     1                mapa,nsubs+(KPhase-1)*10,MameSatelity,nonModulated
      kdel=kmax-kmin+1
      nc=(hmax+1)*kdel
      ncd=nc*2
      nef=(hmax+1)*nx(2)*2
      ncdef=ncd+nef
      if(ncdef+nxny.gt.mxtbl) then
        call FeChybne(-1.,YMinFlowChart,'size of the array "table" '//
     1                'isn''t sufficient','to perform Fourier summation'
     2               ,1,SeriousError)
        ErrJana=1
        go to 9999
      endif
      rmax=0.
      rmin=0.
      v=xfmn(6)
      call FeFlowChartOpen(-1.,YMinFlowChart,1,nx(3)*nx(4)*nx(5)*nx(6),
     1                     'Fourier summation',' ',' ')
      nn=0
      irec=1
      do 6000iv=1,nx(6)
        u=xfmn(5)
        do 5000iu=1,nx(5)
          t=xfmn(4)
          do 4000it=1,nx(4)
            z=xfmn(3)
            do 3000iz=1,nx(3)
              call FeFlowChartEvent(nn,ie)
              if(ie.ne.0) then
                call BudeBreak
                if(ErrJana.ne.0) go to 9999
              endif
              call SetRealArrayTo(table,ncdef+nxny,0.)
2030          read(82,end=2080) ihp,ai,bi
              locc=ihp(1)*kdel+(ihp(2)-kmin)+1
              locd=locc+nc
              xlz=float(ihp(3))*z
              if(ndim.gt.3) xlz=xlz+float(ihp(4))*t
              if(ndim.gt.4) xlz=xlz+float(ihp(5))*u
              if(ndim.gt.5) xlz=xlz+float(ihp(6))*v
              call sncs(xlz,sinlz,coslz)
              table(locc)=table(locc)+ai*coslz+bi*sinlz
              table(locd)=table(locd)-ai*sinlz+bi*coslz
              go to 2030
2080          rewind 82
              ne=nx(2)*(hmax+1)
              locei=ncd+1
              locc=1
              locd=locc+nc
              rkyip=kmin
              rkdyp=rkyip*xdf(2)
              rkyip=rkyip*xfmn(2)
              do 2150n=1,hmax+1
                rkdy=rkdyp
                rkyi=rkyip
                do 2140m=1,kdel
                  loce=locei
                  rky=rkyi
                  locf=loce+ne
                  chy=table(locc)
                  dhy=table(locd)
                  do 2130i=1,nx(2)
                    call sncs(rky,sinky,cosky)
                    table(loce)=table(loce)+chy*cosky+dhy*sinky
                    table(locf)=table(locf)-chy*sinky+dhy*cosky
                    loce=loce+(hmax+1)
                    locf=loce+ne
                    rky=rky+rkdy
2130              continue
                  rkyi=rkyi+xfmn(2)
                  rkdy=rkdy+xdf(2)
                  locc=locc+1
                  locd=locc+nc
2140            continue
                locei=locei+1
2150          continue
              loce=ncd+1
              locf=loce+ne
              nrn=ncdef
              nstart=ncdef+1
              inter=0
              do 2240i=1,nx(2)
                hdx=0.
                hxi=0.
                do 2210m=1,hmax+1
                  e=table(loce)
                  f=table(locf)
                  hx=hxi
                  do 2200n=1,nx(1)
                    inter=inter+1
                    if(mod(inter,1000).eq.1) then
                      nn=nn-1
                      call FeFlowChartEvent(nn,ie)
                      if(ie.ne.0) then
                        call BudeBreak
                        if(ErrJana.ne.0) go to 9999
                      endif
                    endif
                    loc=nrn+n
                    call sncs(hx,sinhx,coshx)
                    table(loc)=table(loc)+e*coshx+f*sinhx
                    hx=hx+hdx
2200              continue
                  hdx=hdx+xdf(1)
                  hxi=hxi+xfmn(1)
                  loce=loce+1
                  locf=loce+ne
2210            continue
                nrn=loc
2240          continue
              do 2242n=nstart,nrn
                rmax=max(rmax,table(n))
                rmin=min(rmin,table(n))
2242          continue
              irec=irec+1
              write(81,rec=irec)(table(i),i=nstart,nrn)
              z=z+xdf(3)
3000        continue
            t=t+xdf(4)
4000      continue
          u=u+xdf(5)
5000    continue
        v=v+xdf(6)
6000  continue
      irec=irec+1
      write(81,rec=irec) rmax,rmin
      call newln(1)
      write(Cislo,'(f15.2)') rmax
      call ZdrcniCisla(Cislo,1)
      t80='Maximal density : '//Cislo(:idel(Cislo))
      write(Cislo,'(f15.2)') rmin
      call ZdrcniCisla(Cislo,1)
      t80=t80(:idel(t80))//', minimal density : '//Cislo(:idel(Cislo))
      write(lst,FormA1)(t80(i:i),i=1,idel(t80))
      if(mapa.eq.6) then
        call OpenFile(89,fln(:ifln)//'_fourier.tmp','formatted',
     1                'unknown')
        if(ErrJana.ne.0) go to 9999
        write(89,'(''fourier'')')
        write(89,'(''rhomax/min:'',2f8.2)') rmax,rmin
        write(89,'(''end'')')
        call CloseIfOpened(89)
      endif
      call FeFlowChartRemove
9999  call DeleteFile(FileM82)
      call FeTmpFilesClear(FileM82)
      return
      end
      subroutine sncs(arg,sinarg,cosarg)
      include 'params.cmn'
      include 'basic.cmn'
      include 'fourier.cmn'
      arg=arg-float(ifix(arg))
      if(arg.lt.0.) arg=arg+1.
      narg1=nint(arg*1000.)+1
      narg2=narg1+250
      if(narg2.gt.1001) narg2=narg2-1000
      sinarg=-trgtbl(narg2)
      cosarg=trgtbl(narg1)
      return
      end
      subroutine cteni(kam,kzap,irec,iz,m81)
      include 'params.cmn'
      include 'basic.cmn'
      include 'fourier.cmn'
      iz=iz+1
      irec=irec+1
      read(m81,rec=irec)(tbl(j,kam),j=1,nxny)
      if(kzap.lt.0) then
        do 1100j=1,nxny
          tbl(j,kam)=-tbl(j,kam)
1100    continue
      endif
      return
      end
      subroutine zarad(u,roave,x,n,npik,klic)
      include 'params.cmn'
      include 'basic.cmn'
      include 'fourier.cmn'
      dimension u(3),x(3,*)
      integer roave
      if(klic.eq.0) then
        l=koinc(u,x,1,n,eq48,pom,nsubs)
      else
        l=0
      endif
      if(l.ne.0) then
        if(roave.ge.ro(l)) go to 9999
        ro(l)=roave
        call CopyVek(u,x(1,l),3)
        if(n.eq.npik) call indexx(n,ro,nro)
      else
        if(n.lt.npik) then
          n=n+1
          nro(n)=n
          kam=n
          ro(kam)=roave
          if(n.eq.npik) call indexx(n,ro,nro)
        else
          do 1100katy=1,n
            l=nro(katy)
            if(roave.lt.ro(l)) go to 1200
1100      continue
          call FeChybne(-1.,-1.,'what are you doing here ?!',' ',1,
     1                 Warning)
          go to 9999
1200      kam=nro(n)
          ro(kam)=roave
          do 1250i=n,katy+1,-1
            nro(i)=nro(i-1)
1250      continue
          nro(katy)=kam
        endif
        call CopyVek(u,x(1,kam),3)
      endif
      if(n.eq.npik) romez=ro(nro(npik))
9999  return
      end
      subroutine trmod(l,x)
      include 'params.cmn'
      include 'basic.cmn'
      include 'fourier.cmn'
      dimension x(3)
      i=mod(l-1,nx(4))
      n=l/nx(4)
      j=mod(n-1,nx(5))+1
      k=n/nx(5)-1
      x(1)=xfmn(4)+float(i)*xdf(4)
      x(2)=xfmn(5)+float(j)*xdf(5)
      x(3)=xfmn(6)+float(k)*xdf(6)
      return
      end
      subroutine SumaPeaks(der,x,am,ps,n)
      include 'params.cmn'
      dimension der(n),x(3),am(*),ps(mxw21,3)
      im=0
      do 2000i=1,n
        deri=der(i)
        if(deri.eq.0.) then
          im=im+i
          go to 2000
        endif
        do 1000j=1,i
          im=im+1
          derj=der(j)
          if(derj.eq.0) go to 1000
          am(im)=am(im)+deri*derj
1000    continue
        do 1500j=1,3
          ps(i,j)=ps(i,j)+deri*x(j)
1500    continue
2000  continue
      return
      end
      subroutine deflim
      include 'params.cmn'
      include 'basic.cmn'
      include 'fourier.cmn'
      dimension ias(3,mxsym),bs(3,mxsym)
      logical eqiv,eqrv
      do 2000isw=1,ncomp
        n=1
        do 1300i=1,ns
          k=0
          do 1200j=1,3
            j2=j+3*mod(j,3)
            j3=j+3*mod(j+1,3)
            if(rm(k+j,i,isw,KPhase).eq.0..or.
     1         abs(rm(j2,i,isw,KPhase)).gt..01.or.
     1         abs(rm(j3,i,isw,KPhase)).gt..01) go to 1300
            ias(j,n)=nint(rm(k+j,i,isw,KPhase))
            bs(j,n)=s6(j,i,isw,KPhase)
            k=k+3
1200      continue
          do 1250j=1,n-1
            if(eqiv(ias(1,n),ias(1,j),3).and.
     1         eqrv(bs(1,n),bs(1,j),3,.0001)) go to 1300
1250      continue
          n=n+1
1300    continue
        n=n-1
        if(Patterson) then
          call SetRealArrayTo(bs,3*n,0.)
          k=2
        else
          k=1
        endif
        if(ncs.eq.1.or.Patterson) call nascs(ias,bs,n)
        call nascen(ias,bs,isw,n,m)
        call setlim(ias,bs,m,isw,k)
2000  continue
      return
      end
      subroutine nascs(ias,bs,n)
      include 'params.cmn'
      include 'basic.cmn'
      dimension ias(3,mxsym),bs(3,mxsym),p(6)
      logical eqiv,eqrv
      data p/6*0./
      m=n+1
      do 2000i=1,n
        do 1000j=1,3
          ias(j,m)=-ias(j,i)
          p(j)=1.-bs(j,i)
1000    continue
        call od0do1(p,p,3)
        do 1500j=1,m-1
          if(eqiv(ias(1,m),ias(1,j),3).and.
     1       eqrv(p,bs(1,j),3,.0001)) go to 2000
1500    continue
        do 1600j=1,3
          bs(j,m)=p(j)
1600    continue
        m=m+1
2000  continue
      n=m-1
      return
      end
      subroutine nascen(ias,bs,isw,n,m)
      include 'params.cmn'
      include 'basic.cmn'
      dimension ias(3,mxsym),bs(3,mxsym),p(6)
      logical eqiv,eqrv
      data p/6*0./
      m=n+1
      do 3000i=2,nvt
        do 2000j=1,n
          do 1000k=1,3
            ias(k,m)=ias(k,j)
            p(k)=bs(k,j)+vt6(k,i,isw,KPhase)
1000      continue
          call od0do1(p,p,3)
          do 1500k=1,m-1
            if(eqiv(ias(1,m),ias(1,k),3).and.
     1         eqrv(p,bs(1,k),3,.0001)) go to 2000
1500      continue
          do 1600k=1,3
            bs(k,m)=p(k)
1600      continue
          m=m+1
2000    continue
3000  continue
      m=m-1
      return
      end
      subroutine setlim(ias,bs,m,isw,klic)
      include 'params.cmn'
      include 'basic.cmn'
      include 'fourier.cmn'
      dimension ias(3,mxsym),bs(3,mxsym),idal(mxsym)
      do 1000i=1,m
        idal(i)=0
1000  continue
      dx=9999.
      do 3000i=1,3
        n1=0
        do 2000j=1,m
          if(iabs(ias(i,j)).ne.1.or.bs(i,j).ne.0.) go to 2000
          n1=n1+1
2000    continue
        pom=float(n1)*CellPar(i,isw,KPhase)/(float(m)*ptstep)
        if(pom.lt.dx) then
          dx=pom
          ismer=i
        endif
3000  continue
      nop(isw)=231
      if(ismer.eq.2) nop(isw)=312
      if(ismer.eq.3) nop(isw)=123
      if(ndim.gt.3) then
        nd=ndimi
        i=10**nd
        nop(isw)=nop(isw)*i+ifix(float(i)*.456)
        do 3500i=4,ndim
          fourmn(i,isw)=0.
          fourmx(i,isw)=1.
3500    continue
      endif
      do 5000i=ismer,ismer+2
        k=mod(i-1,3)+1
        n1=0
        n2=0
        bsmin=9999.
        do 4300j=1,m
          if(idal(j).ne.0) go to 4300
          n2=n2+1
          if(ias(k,j).ne.1) go to 4100
          if(bs(k,j).ne.0.) go to 4200
          n1=n1+1
          go to 4300
4100      bsmin=min(bsmin,bs(k,j))
4200      idal(j)=1
4300    continue
        if(bsmin.gt.10.) bsmin=0.
        fourmn(k,isw)=bsmin*.5
        fourmx(k,isw)=fourmn(k,isw)+float(n1)/float(n2)
5000  continue
      return
      end
      subroutine Peaks(Klic,m81)
      include 'params.cmn'
      include 'basic.cmn'
      include 'fourier.cmn'
      include 'atoms.cmn'
      include 'fepc.cmn'
      parameter (mxtuv=50,mxwm=mxw21*(mxw+1))
      dimension x456(3),xp(6),stred(3),y1(6),y2(6),y3(6),vu(3),vv(3),
     1          vug(3),xold(6),am(mxwm),ps(mxw21,3),der(mxw21),
     2          waven(mxw21,3),waveo(mxw21,3),kmod(2*mxa,mxtuv),
     3          romod(2*mxa,mxtuv),x48(3,2*mxa),nmod(mxtuv),nroi(2*mxa),
     4          xmd(6,mxtuv),xmod(3,2*mxa,mxtuv),ux48(3,mxw,2*mxa),
     5          uy48(3,mxw,2*mxa)
      character*128 ven,vent
      character*80 t80
      character*27 format2
      character*24 format1
      character*8 znak
      integer roave
      logical mameji,ExistFile
      call OpenFile(m40,fln(:ifln)//'.m40','formatted','old')
      if(ErrJana.ne.0) go to 9999
      ln=NextLogicNumber()
      call OpenFile(ln,fln(:ifln)//'_peaks.tmp','formatted','unknown')
      if(ErrJana.ne.0) go to 9999
1010  read(m40,FormA80,end=1011) t80
      if(t80(1:10).ne.'**********'.and.t80.ne.' ') then
        write(ln,FormA1)(t80(i:i),i=1,idel(t80))
        go to 1010
      endif
1011  call CloseIfOpened(m40)
      read(m81,rec=1,err=9200) nx,nxny,nmap,(xfmn(i),xfmx(i),i=1,6),xdf,
     1                         iorien,mapa,nsubs,MameSatelity,
     2                         nonModulated
      nsubs=mod(nsubs,10)
      ntu =nx(4)*nx(5)
      ntuv=ntu*nx(6)
      do 1020i=1,3
        if(iorien(i).gt.3) then
          ErrJana=1
          go to 9999
        endif
1020  continue
      if(ntuv.gt.mxtuv) then
        t80='the maximum number '
        write(t80(idel(t80)+1:),'(i3)') mxtuv
        t80=t80(:idel(t80))//' sections for peak search exceeded'
        call FeChybne(-1.,-1.,t80,'the step will be skipped',1,Warning)
        go to 9999
      endif
      read(m81,rec=nmap+2,err=9200) rmax,rmin
      rmax=max(rmax,-rmin)
      format1='(i3,''.'',3f10.6,f12.2,i5)'
      if(rmax.gt.99900000.00) format1(16:20)='e12.5'
      format2='(i3,''/'',i3,3f8.4,f10.2,''|'')'
      if(rmax.gt.999000.00) format2(18:22)='e10.3'
      pom=rmax*33.33/float(imax)
      redukce=1.
1025  if(pom.gt.1.) then
        redukce=redukce*.1
        pom=pom*.1
        go to 1025
      endif
      rmax=rmax*redukce
      eq48=0.
      if(Klic.eq.0) then
        do 1030i=1,3
          if(xfmx(i)-xfmn(i).gt.xdf(i))
     1      eq48=max(eq48,xdf(i)*CellPar(iorien(i),nsubs,KPhase))
1030    continue
        eq48=max(.1,eq48)
      else
        do 1031i=1,3
          if(xfmx(i)-xfmn(i).gt.xdf(i))
     1      eq48=max(eq48,xdf(i))
1031    continue
      endif
      call OpenFile(46,fln(:ifln)//'.m46','formatted','unknown')
      if(ErrJana.ne.0) go to 9999
      nflmx=0
      if(npeaks(1).ge.1) nflmx=nmap
      if(npeaks(2).ge.1) nflmx=nflmx+nmap
      if(nflmx.le.0) go to 9999
      call FeFlowChartOpen(-1.,YMinFlowChart,1,nflmx,
     1                     'Peak searching procedure',' ',' ')
      nfl=0
      do 9000kzap=1,-1,-2
        if(kzap.gt.0) then
          npik=npeaks(1)
          znak='positive'
          if(Patterson.or.ndim.gt.4) kharm=0
        else
          npik=npeaks(2)
          znak='negative'
          kharm=0
        endif
        if(npik.le.0) go to 9000
        call newln(2)
        write(lst,'(/''Searching for '',a8,'' peaks - maximum number '',
     1              ''of peaks to be found : '',i3)') znak,npik
        if(redukce.lt..9) then
          call newln(2)
          write(lst,'(/''Scaling factor '',f12.8,'' will be applied'')')
     1      redukce
        endif
        rewind 46
        read(m81,rec=1,err=9200) nx,nxny,nmap,(xfmn(i),xfmx(i),i=1,6),
     1                           xdf,iorien,mapa,nsubs,MameSatelity,
     2                           nonModulated
        nsubs=mod(nsubs,10)
        rzap=kzap
        do 1100i=1,3
          x456(i)=xfmn(i+3)
1100    continue
        irec=1
        do 2120iv=1,nx(6)
          do 2110iu=1,nx(5)
            do 2100it=1,nx(4)
              romez=0
              iz=0
              ipik=0
1600          call cteni(1,kzap,irec,iz,m81)
              call FeFlowChartEvent(nfl,ie)
              if(ie.ne.0) go to 9100
              lstr=1
              rez=xfmn(3)
              if(nx(3).le.2) go to 1710
              call cteni(2,kzap,irec,iz,m81)
              call FeFlowChartEvent(nfl,ie)
              if(ie.ne.0) go to 9100
              lpod=3
              lnad=2
1700          i=lnad
              lnad=lpod
              lpod=lstr
              lstr=i
              call cteni(lnad,kzap,irec,iz,m81)
              rez=rez+xdf(3)
              call FeFlowChartEvent(nfl,ie)
              if(ie.ne.0) go to 9100
1710          ipct=nx(1)
              do 1900i=2,nx(2)-1
                i10=ipct+1
                t110=tbl(i10,lstr)
                do 1890j=2,nx(1)-1
                  i11=i10+1
                  i12=i11+1
                  i01=i11-nx(1)
                  i00=i01-1
                  i02=i01+1
                  i21=i11+nx(1)
                  i20=i21-1
                  i22=i21+1
                  t121=tbl(i21,lstr)
                  t101=tbl(i01,lstr)
                  t111=tbl(i11,lstr)
                  t111=t111
                  t112=tbl(i12,lstr)
                  if(t111.lt.t110) go to 1880
                  if(t111.le.t112) go to 1880
                  if(t111.lt.t101) go to 1880
                  if(t111.le.t121) go to 1880
                  if(t111.lt.tbl(i00,lstr)) go to 1880
                  if(t111.le.tbl(i20,lstr)) go to 1880
                  if(t111.lt.tbl(i02,lstr)) go to 1880
                  if(t111.le.tbl(i22,lstr)) go to 1880
                  t011=t111
                  t211=t111
                  if(nx(3).le.2) go to 1740
                  t011=tbl(i11,lpod)
                  t211=tbl(i11,lnad)
                  if(t111.lt.t011) go to 1880
                  if(t111.le.t211) go to 1880
                  if(t111.lt.tbl(i00,lpod)) go to 1880
                  if(t111.le.tbl(i00,lnad)) go to 1880
                  if(t111.lt.tbl(i01,lpod)) go to 1880
                  if(t111.le.tbl(i01,lnad)) go to 1880
                  if(t111.lt.tbl(i02,lpod)) go to 1880
                  if(t111.le.tbl(i02,lnad)) go to 1880
                  if(t111.lt.tbl(i10,lpod)) go to 1880
                  if(t111.le.tbl(i10,lnad)) go to 1880
                  if(t111.lt.tbl(i12,lpod)) go to 1880
                  if(t111.le.tbl(i12,lnad)) go to 1880
                  if(t111.lt.tbl(i20,lpod)) go to 1880
                  if(t111.le.tbl(i20,lnad)) go to 1880
                  if(t111.lt.tbl(i21,lpod)) go to 1880
                  if(t111.le.tbl(i21,lnad)) go to 1880
                  if(t111.lt.tbl(i22,lpod)) go to 1880
                  if(t111.le.tbl(i22,lnad)) go to 1880
1740              k=iorien(1)
                  t111=t111
                  call vrchol(xfmn(1)+float(j-1)*xdf(1),xdf(1),t110,t111
     1                       ,t112,xp(k),r)
                  k=iorien(2)
                  call vrchol(xfmn(2)+float(i-1)*xdf(2),xdf(2),t101,t111
     1                       ,t121,xp(k),s)
                  k=iorien(3)
                  call vrchol(rez,xdf(3),t011,t111,t211,xp(k),t)
                  do 1750k=1,3
                    l=iorien(k)
                    if(xp(l).lt.xfmn(k).or.xp(l).gt.xfmx(k)) go to 1880
1750              continue
                  pom=(r+s+t)*redukce
                  roave=nint(-33.3333*pom)
                  if(roave.lt.romez) call zarad(xp,roave,x48,ipik,npik,
     1                                          klic)
1880              t110=t111
                  i10=i11
1890            continue
                ipct=ipct+nx(1)
1900          continue
              if(iz.lt.nx(3)) then
                if(nx(3).gt.2) then
                  go to 1700
                else
                  go to 1600
                endif
              endif
              if(ipik.lt.npik.and.ipik.gt.0) call indexx(ipik,ro,nro)
              write(46,101) ipik,x456
              na48=ipik
              do 2090n=1,ipik
                j=nro(n)
                write(46,102)(x48(i,j),i=1,3),-float(ro(j))/100.*rzap
2090          continue
              x456(1)=x456(1)+xdf(4)
2100        continue
            x456(2)=x456(2)+xdf(5)
2110      continue
          x456(3)=x456(3)+xdf(6)
2120    continue
        if(ntuv.eq.1) then
          kharm=0
          go to 5000
        endif
        rewind 46
        mxnmod=0
        do 2420k=1,ntuv
          read(46,101) nmod(k)
          mxnmod=max(mxnmod,nmod(k))
          do 2410j=1,nmod(k)
            read(46,102)(xmod(i,j,k),i=1,3),romod(j,k)
2410      continue
          call SetIntArrayTo(kmod(1,k),nmod(k),0)
2420    continue
        if(ndim.gt.4.or.kzap.eq.-1.or.Patterson) go to 4900
        dmq=dmax**2
        nlsq=2*kharm+1
        nam=nlsq*(kharm+1)
        der(1)=1.
        nm=0
        na48=0
        jp=1
        kp=1
2500    do 2520k=kp,ntuv
          do 2510j=jp,nmod(k)
            if(kmod(j,k).eq.0) go to 2530
2510      continue
          jp=1
2520    continue
        go to 4800
2530    jp=j
        kp=k
        n=1
        nm=nm+1
        call SetRealArrayTo(waveo,3*mxw21,0.)
        call CopyVek(xmod(1,jp,kp),xmd(1,n),3)
        call CopyVek(xmd(1,n),stred(1),3)
        call trmod(kp,xmd(4,n))
        call od0do1(xmd(1,n),xmd(1,n),ndim)
        call CopyVek(xmd(1,n),xold,ndim)
        kmod(jp,kp)=-1
        rop=romod(jp,kp)
        romin=rop*.5
        do 3900k=kp+1,ntuv
          do 3890j=1,nmod(k)
            if(kmod(j,k).ne.0.or.romod(j,k).lt.romin) go to 3890
            mameji=.false.
            call CopyVek(xmod(1,j,k),xp,3)
            call trmod(k,xp(4))
            do 3700jsym=1,ns
              call multm(rm6(1,jsym,nsubs,KPhase),xp,y1,ndim,ndim,1)
              do 3600jcntrsm=1,3-ncs
                zn=3-2*jcntrsm
                do 3120i=1,ndim
                  y2(i)=y1(i)*zn+s6(i,jsym,nsubs,KPhase)
3120            continue
                do 3500ivt=1,nvt
                  do 3190i=1,ndim
                    y3(i)=y2(i)+vt6(i,ivt,nsubs,KPhase)
3190              continue
                  call od0do1(y3,y3,ndim)
                  do 3200i=1,3
                    vv(i)=y3(i)-xold(i)
3200              continue
                  do 3400i1=1,3
                    w1=i1-2
                    u1=vv(1)+w1
                    vu(1)=u1
                    do 3300i2=1,3
                      w2=i2-2
                      u2=vv(2)+w2
                      vu(2)=u2
                      do 3290i3=1,3
                        w3=i3-2
                        u3=vv(3)+w3
                        vu(3)=u3
                        call multm(MetTens(1,nsubs,KPhase),vu,vug,3,3,1)
                        uu=scalmul(vu,vug)
                        if(uu.gt.dmq) go to 3290
                        mameji=.true.
                        n=n+1
                        call AddVek(vu,xold,xmd(1,n),3)
                        call AddVek(stred,xmd(1,n),stred,3)
                        call CopyVek(xmd(1,n),xold,3)
                        call CopyVek(y3(4),xmd(4,n),ndimi)
                        rop=max(rop,romod(j,k))
                        go to 3710
3290                  continue
3300                continue
3400              continue
3500            continue
3600          continue
3700        continue
3710        if(mameji) then
              kmod(j,k)=-1
              go to 3900
            endif
3890      continue
3900    continue
        kmodmx=-2
        iter=0
        u=1./float(n)
c        rop=rop*u
        do 3910i=1,3
          stred(i)=stred(i)*u
3910    continue
3999    iter=iter+1
        call SetRealArrayTo(ps,3*mxw21,0.)
        call SetRealArrayTo(am,nam,0.)
        do 4100k=1,n
          arg=pi2*(xmd(4,k)-qu(1,1,1,KPhase)*(xmd(1,k)-stred(1))
     1                     -qu(2,1,1,KPhase)*(xmd(2,k)-stred(2))
     2                     -qu(3,1,1,KPhase)*(xmd(3,k)-stred(3)))
          j=0
          do 4050i=1,kharm
            pom=float(i)*arg
            j=j+2
            der(j)=sin(pom)
            der(j+1)=cos(pom)
4050      continue
          call SumaPeaks(der,xmd(1,k),am,ps,nlsq)
4100    continue
        call smi(am,der,nlsq,ising)
        if(ising.eq.1.or.n*2.lt.ntuv) then
          do 4150i=1,3
            waven(1,i)=stred(i)
4150      continue
          iter=0
          go to 4600
        endif
        do 4200i=1,3
          call nasob(am,ps(1,i),waven(1,i),nlsq)
4200    continue
        do 4300i=1,3
          stred(i)=waven(1,i)
4300    continue
        pom=0.
        do 4500i=1,3
          do 4450j=1,nlsq
            pom=pom+abs(waven(j,i)-waveo(j,i))
            waveo(j,i)=waven(j,i)
4450      continue
4500    continue
        if(pom.gt..001.and.iter.le.5) go to 3999
4600    if(iter.le.5.and.iter.gt.0) then
          na48=na48+1
          do 4700i=1,3
            k=2
            do 4650j=1,kharm
              ux48(i,j,na48)=waven(k  ,i)
              uy48(i,j,na48)=waven(k+1,i)
              k=k+2
4650        continue
            x48(i,na48)=waven(1,i)
4700      continue
          ro(na48)=nint(-rop*100.)
          kmodmx=na48
        endif
        do 4720k=1,ntuv
          do 4710j=1,nmod(k)
            if(kmod(j,k).eq.-1) kmod(j,k)=kmodmx
4710      continue
4720    continue
        go to 2500
4800    if(na48.gt.1) then
          call indexx(na48,ro,nro)
        else
          nro(1)=1
        endif
        call SetIntArrayTo(nroi,2*mxa,0)
        do 4820i=1,na48
          nroi(nro(i))=i
4820    continue
4900    iz=1
        m=(nx(4)-1)/3+1
        kk=mod(nx(4)-1,3)+1
        if(kzap.eq.-1.or.Patterson) then
          romez=0
          ipik=0
        endif
        x456(3)=xfmn(6)
        do 4990iv=1,nx(6)
          x456(2)=xfmn(5)
          do 4980iu=1,nx(5)
            x456(1)=xfmn(4)
            do 4970it=1,m
              if(it.ne.m) then
                n=2
              else
                n=kk-1
              endif
              if(line.gt.mxline-10) call newpg(0)
              call newln(3)
              write(lst,FormA128)
              if(ndim.eq.4) then
                write(ven,104) cx(4),x456(1)
              else if(ndim.eq.5) then
                write(ven,105) cx(4),x456(1),cx(5),x456(2)
              else
               write(ven,106) cx(4),x456(1),cx(5),x456(2),cx(6),x456(3)
              endif
              if(n.gt.0) then
                if(ndim.eq.4) then
                  write(ven(43:),104) cx(4),x456(1)+xdf(4)
                else if(ndim.eq.5) then
                  write(ven(43:),105) cx(4),x456(1)+xdf(4),cx(5),
     1                  x456(2)+xdf(5)
                else
                  write(ven(43:),106) cx(4),x456(1)+xdf(4),cx(5),
     1                  x456(2)+xdf(5),cx(6),x456(3)+xdf(6)
                endif
                if(n.gt.1) then
                  if(ndim.eq.4) then
                    write(ven(85:),104) cx(4),x456(1)+2.*xdf(4)
                  else if(ndim.eq.5) then
                    write(ven(85:),105) cx(4),x456(1)+2.*xdf(4),cx(5)
     1                   ,x456(2)+2.*xdf(5)
                  else
                    write(ven(85:),106) cx(4),x456(1)+2.*xdf(4),cx(5)
     1                   ,x456(2)+2.*xdf(5),cx(6),x456(3)+2.*xdf(6)
                  endif
                endif
              endif
              write(lst,FormA128) ven
              write(ven,108)
              if(n.gt.0) write(ven(43:),108)
              if(n.gt.1) write(ven(85:),108)
              write(lst,FormA128) ven
              do 4950j=1,mxnmod
                call newln(1)
                ven=' '
                ii=1
                do 4945k=iz,iz+n
                  if(j.gt.nmod(k)) go to 4940
                  if(ndim.eq.4.and.kzap.eq.1.and..not.Patterson) then
                    if(kmod(j,k).le.0) then
                      i1=0
                    else
                      i1=nroi(kmod(j,k))
                    endif
                  else
                    i1=0
                    if(kzap.eq.-1.or.Patterson) then
                      ip=kzap*nint(-romod(j,k)*100.)
                      if(ip.lt.romez) call zarad(xmod(1,j,k),ip,x48,
     1                                           ipik,npik,klic)
                    endif
                  endif
                  write(ven(ii:),format2) j,i1,(xmod(i,j,k),i=1,3),
     1                                    romod(j,k)
4940              ii=ii+42
4945            continue
                write(lst,FormA128) ven
4950          continue
              iz=iz+n+1
              x456(1)=x456(1)+3.*xdf(4)
4970        continue
            x456(2)=x456(2)+3.*xdf(5)
4980      continue
          x456(3)=x456(3)+xdf(6)
4990    continue
5000    call newln(3)
        write(lst,'(/''The list of '',a8,'' peaks written to the m40 '',
     1              '' file''/)') znak
        if(ndim.gt.3) then
          if(kzap.eq.1.and..not.Patterson) then
            if(kharm.ne.0) then
              call newln(1)
              write(lst,'(''These peaks were successfully interpreted''
     1                   ,'' with '',i1,'' harmonic wave(s)'')') kharm
            endif
          else
            if(ipik.lt.npik) call indexx(ipik,ro,nro)
          endif
        endif
        vent='         x         y         z            rho   rel'
        if(Patterson) then
          vent=vent(1:51)//'  to origin'
          na(1)=2
          nacalc=2
          Atom(1)='Origin'
          Atom(2)='Itself'
          call SetIntArrayTo(itf,2,1)
          call SetIntArrayTo(isf,2,1)
          call SetIntArrayTo(iswa,2,1)
          call SetIntArrayTo(kswa,2,1)
          call SetRealArrayTo(ai,2,1.)
          call SetRealArrayTo(x,3,0.)
          call specat
        endif
        vent=vent(1:65)//vent(1:65)
        n2=0
        if(line.gt.mxline-12) call newpg(0)
5100    n1=n2+1
        n2=min(n2+2*(mxline-line-2),na48)
        n=n2-n1+1
        nn=(n-1)/2+1
        call newln(nn+2)
        write(lst,FormA128) vent
        write(lst,FormA128)
        if(Patterson) call SetRealArrayTo(x,3,0.)
        do 5300ip=0,nn-1
          ven=' '
          l=1
          ll=n1+ip
          do 5250j=1,2
            if(ll.gt.n2) go to 5250
            inp=nro(ll)
            h=float(-ro(inp)*kzap)*.01
            if(klic.eq.0) then
              if(Patterson) then
                call CopyVek(x48(1,inp),x(1,2),3)
                call DistForOneAtom(2,20.,1,0)
                do 5212i=1,ndist
                  m=ipord(i)
                  if(adist(m).ne.'Itself') go to 5214
5212            continue
                Znak=' >20'
                go to 5220
C5214            call CopyVek(xdist(1,m),x48(1,inp),3)
5214            write(Znak,'(f8.3)') ddist(m)
              else
                i=KoincM40(x48(1,inp),eq48,pom,nsubs)
              endif
            else
              i=0
            endif
5220        write(ven(l:),format1) ll,(x48(m,inp),m=1,3),h,
     1                                 nint(h*999./rmax)
            if(Patterson) then
              ven=ven(1:idel(ven))//'   '//Znak
            else
              if(i.gt.0) ven=ven(1:idel(ven))//' ='//atom(i)
            endif
            l=l+65
            ll=ll+nn
5250      continue
          write(lst,FormA128) ven
5300    continue
        if(n2.lt.na48) then
          call newpg(0)
          go to 5100
        endif
        write(ln,109)
        write(ln,'(2i5)') nsubs,KPhase
        do 5400i=1,na48
          if(kzap.eq.1) then
            znak='max'
          else
            znak='min'
          endif
          write(znak(4:6),'(i3)') i
          call zhusti(znak)
          ii=nro(i)
          write(ln,'(a8,2i3,4x,4f9.6,6x,3i1,3i3)') znak,1,1,1.,
     1         (x48(j,ii),j=1,3),0,0,0,0,kharm,0
          h=-float(ro(ii))*.01
          if(h.gt.999000.00) then
            t80='(e9.3)'
          else
            t80='(f9.2)'
          endif
          write(ln,t80) -float(ro(ii))*.01
          do 5350j=1,kharm
            write(ln,103)(ux48(k,j,ii),k=1,3),(uy48(k,j,ii),k=1,3)
5350      continue
          if(kharm.gt.0) write(ln,103) 0.
5400    continue
9000  continue
9100  call FeFlowChartRemove
      write(ln,109)
      call CloseIfOpened(ln)
      call MoveFile(fln(:ifln)//'_peaks.tmp',fln(:ifln)//'.m40',.false.)
      go to 9999
9200  call FeReadError(m81)
      ErrJana=1
9999  call CloseIfOpened(ln)
      call CloseIfOpened(46)
      return
101   format(i5,3f9.6)
102   format(3f9.6,e15.6)
103   format(6f9.6)
104   format(16x,a2,'=',f6.3,17x)
105   format(11x,2(a2,'=',f6.3,1x),11x)
106   format( 6x,3(a2,'=',f6.3,1x), 6x)
108   format('peak/atom    x       y       z       rho |')
109   format(79('*'))
      end
      subroutine SetCommandsFourier
      include 'params.cmn'
      include 'basic.cmn'
      include 'atoms.cmn'
      include 'fourier.cmn'
      include 'fepc.cmn'
      character*17 Men(4)
      integer FeMenu
      data Men/'%Basic commands','%Type of the map','%Scope of the map',
     1         '%Peaks commands'/
      call RewriteTitle('Fourier-commands')
      call OpenCommandsFourier(its)
      if(ErrJana.ne.0) go to 9999
1200  i=FeMenu(-1.,-1.,men,1,4,1,0)
      if(i.eq.1) then
       call BasicCommandsF
      else if(i.eq.2) then
        call ReadMapType
      else if(i.eq.3) then
        call ReadScope(0,its,ich)
      else if(i.eq.4) then
        call PeaksCommands
      endif
      if(i.ge.1.and.i.le.5) go to 1200
      call RewriteCommandsFourier(0,its)
9999  return
      end
      subroutine OpenCommandsFourier(its)
      include 'params.cmn'
      include 'basic.cmn'
      include 'atoms.cmn'
      include 'fourier.cmn'
      include 'fepc.cmn'
      call iom50(0,0)
      if(ErrJana.ne.0) return
      call iom40(0,0)
      if(ErrJana.eq.-1) then
        call CrlbCorrectAtomNames(ich)
        if(ich.ne.0) then
          ErrJana=1
          go to 9999
        endif
      else if(ErrJana.ne.0) then
        go to 9999
      endif
      call DefaultFourier
      noo=-333
      call SetRealArrayTo(xrmn,6,-333.)
      call NactiFourier
      if(ptname.eq.'[neco]') then
        write(ptname,101) ptx
        call ZdrcniCisla(ptname,3)
      endif
      call MakeIts(its)
9999  return
101   format(3f10.6)
      end
      subroutine RewriteCommandsFourier(Klic,its)
      include 'params.cmn'
      include 'basic.cmn'
      include 'atoms.cmn'
      include 'fourier.cmn'
      include 'fepc.cmn'
      character*80 t80
      call WriteKeys('fourier')
      if(its.eq.1.or.its.eq.3) then
        ip=4
      else
        ip=1
      endif
      do 2000i=ip,ndim
        if(xrmn(i).gt.-300.) then
          write(t80,101) xrmn(i),xrmx(i),dd(i)
          call ZdrcniCisla(t80,3)
        else
          t80='0 1 0.1'
        endif
        if(i.gt.3.and.t80.eq.'0 1 0.1') go to 2000
        if(ndim.eq.3) then
          t80=NactiKeywords(nCmdxlim+i-1)(1:4)//' '//t80(:idel(t80))
        else
          t80=NactiKeywords(nCmdx1lim+i-1)(1:5)//' '//t80(:idel(t80))
        endif
        write(55,FormA1)(t80(j:j),j=1,idel(t80))
2000  continue
      if(its.eq.3) then
        t80=NactiKeyWords(nCmdcenter)(:idel(NactiKeyWords(nCmdcenter)))
     1    //' '//ptname(:idel(ptname))
        write(55,FormA1)(t80(j:j),j=1,idel(t80))
        write(t80,101) pts
        call ZdrcniCisla(t80,3)
        t80=NactiKeywords(nCmdscope)(:idel(NactiKeyWords(nCmdscope)))//
     1      ' '//t80(:idel(t80))
        write(55,FormA1)(t80(j:j),j=1,idel(t80))
      endif
      if(RefM80.ne.' ') then
        t80=NactiKeyWords(nCmdrefm80)(:idel(NactiKeyWords(nCmdrefm80)))
     1    //' '//RefM80(:idel(RefM80))
        write(55,FormA1)(t80(j:j),j=1,idel(t80))
      endif
      write(55,'(''end'')')
      call DopisKeys(Klic)
      call RewriteTitle(' ')
      return
101   format(3f10.6)
      end
      subroutine BasicCommandsF
      include 'params.cmn'
      include 'basic.cmn'
      include 'fourier.cmn'
      include 'fepc.cmn'
      character*256 EdwStringQuest
      character*24  Label
      logical CrwLogicQuest
      data Label/'*F(calc) will be omitted'/
      i=9
      if(itwin.gt.1) i=i+3
      if(ncomp.gt.1) i=i+2
      id=NextQuestId()
      call FeQuestCreate(id,-1.,-1.,220.,0,i,'Basic commands',0,
     1                   LightGray,0,0)
      il=1
      call FeQuestEdwMake(id,5.,il,30.,il,'%Title','L',185.,EdwYd,0)
      nEdwTitle=EdwLastMade
      call FeQuestStringEdwOpen(nEdwTitle,Title)
      il=il+1
      call FeQuestLabelMake(id,110.,il,'Perform','C')
      il=il+1
      call FeQuestCrwMake(id,20.,il,5.,il,'%Fourier summation','L',
     1                    CrwXd,CrwYd,0,0)
      nCrwSuma=CrwLastMade
      call FeQuestCrwOpen(nCrwSuma,NacetlInt(nCmdlcalc).eq.1)
      call FeQuestCrwMake(id,130.,il,115.,il,'%Peak interpretation','L',
     1                    CrwXd,CrwYd,0,0)
      nCrwPeak=CrwLastMade
      call FeQuestCrwOpen(nCrwPeak,NacetlInt(nCmdlpeaks).eq.1)
      il=il+1
      call FeQuestLineMake(id,il)
      il=il+1
      call FeQuestLabelMake(id,5.,il,'sin(th)/lambda','L')
      call FeQuestEdwMake(id,70.,il,85.,il,'mi%n.','L',50.,EdwYd,0)
      nEdwMin=EdwLastMade
      call FeQuestRealEdwOpen(nEdwMin,NacetlReal(nCmdsnlmn),.false.,
     1                        .false.)
      call FeQuestEdwMake(id,150.,il,165.,il,'ma%x.','L',50.,EdwYd,0)
      nEdwMax=EdwLastMade
      call FeQuestRealEdwOpen(nEdwMax,NacetlReal(nCmdsnlmx),.false.,
     1                        .false.)
      il=il+1
      call FeQuestCrwMake(id,5.,il,112.,il,'%Check for presence of '//
     1                    'equivalents','L',CrwXd,CrwYd,0,0)
      nCrwCheckForEq=CrwLastMade
      call FeQuestCrwOpen(CrwLastMade,NacetlInt(nCmdCheckEq).gt.0)
      il=il+1
      call FeQuestCrwMake(id,5.,il,112.,il,'%Omit not-matching '//
     1                    'reflections','L',CrwXd,CrwYd,1,0)
      nCrwOmit=CrwLastMade
      call FeQuestCrwOpen(nCrwOmit,NacetlReal(nCmdvyber).gt.0.)
      il=il+1
      ilo=il
      call FeQuestEdwMake(id,5.,il,90.,il,'%Reflections with F(obs)>',
     1                    'L',30.,EdwYd,0)
      nEdwOmit=EdwLastMade
      if(CrwLogicQuest(nCrwOmit)) then
        call FeQuestRealEdwOpen(nEdwOmit,NacetlReal(nCmdvyber),.false.,
     1                          .false.)
        call FeQuestLabelMake(id,125.,il,Label,'L')
      endif
      il=il+1
      call FeQuestCrwMake(id,5.,il,112.,il,'%Use weighting of '//
     1                    'reflections','L',CrwXd,CrwYd,0,0)
      nCrwUseWeight=CrwLastMade
      call FeQuestCrwOpen(CrwLastMade,NacetlInt(nCmdUseWeight).gt.0)
      if(itwin.gt.1) then
        il=il+1
        call FeQuestLineMake(id,il)
        il=il+1
        call FeQuestLabelMake(id,110.,il,'Correction of F(obs) for '//
     1                        'twinning','C')
        il=il+1
        call FeQuestCrwMake(id, 20.,il,  5.,il,'%Difference','L',CrwgXd,
     1                      CrwgYd,0,1)
        nCrwDiff=CrwLastMade
        call FeQuestCrwMake(id,130.,il,115.,il,'Fr%action','L',CrwgXd,
     1                      CrwgYd,0,1)
        nCrwFract=CrwLastMade
        call FeQuestCrwOpen(nCrwDiff ,NacetlInt(nCmdmetoda).eq.0)
        call FeQuestCrwOpen(nCrwFract,NacetlInt(nCmdmetoda).ne.0)
      endif
      if(ncomp.gt.1) then
        il=il+1
        call FeQuestLineMake(id,il)
        il=il+1
        call FeQuestEdwMake(id,5.,il,90.,il,'Co%mposite part no.','L',
     1                      30.,EdwYd,0)
        nEdwComp=EdwLastMade
        call FeQuestIntEdwOpen(nEdwComp,NacetlInt(nCmdnsubs),.false.)
      endif
      icont=0
2500  call FeQuestEvent(id,icont,ich)
      icont=1
      if(CheckType.eq.EventCrw.and.CheckNumber.eq.nCrwOmit) then
        EventType=EventEdw
        if(CrwLogicQuest(nCrwOmit)) then
          call FeQuestRealEdwOpen(nEdwOmit,NacetlReal(nCmdvyber),
     1                            .false.,.false.)
          call FeQuestLabelMake(id,125.,ilo,Label,'L')
          EventNumber=nEdwOmit
        else
          call FeQuestEdwClose(nEdwOmit)
          call FeQuestLabelRemove(id,125.,ilo,Label,'L')
          EventNumber=1
        endif
        go to 2500
      else if(CheckType.ne.0) then
        call NebylOsetren
        go to 2500
      endif
      if(ich.eq.0) then
        if(CrwLogicQuest(nCrwSuma)) then
          NacetlInt(nCmdlcalc)=1
        else
          NacetlInt(nCmdlcalc)=0
        endif
        if(CrwLogicQuest(nCrwPeak)) then
          NacetlInt(nCmdlpeaks)=1
        else
          NacetlInt(nCmdlpeaks)=0
        endif
        if(CrwLogicQuest(nCrwCheckForEq)) then
          NacetlInt(nCmdCheckEq)=1
        else
          NacetlInt(nCmdCheckEq)=0
        endif
        if(CrwLogicQuest(nCrwUseWeight)) then
          NacetlInt(nCmdUseWeight)=1
        else
          NacetlInt(nCmdUseWeight)=0
        endif
        Title=EdwStringQuest(nEdwTitle)
        call FeQuestRealFromEdw(nEdwMin,NacetlReal(nCmdsnlmn))
        call FeQuestRealFromEdw(nEdwMax,NacetlReal(nCmdsnlmx))
        if(CrwLogicQuest(nCrwOmit)) then
          call FeQuestRealFromEdw(nEdwOmit,NacetlReal(nCmdvyber))
        else
          NacetlReal(nCmdvyber)=0
        endif
        if(itwin.gt.1) then
          if(CrwLogicQuest(nCrwDiff)) then
            NacetlInt(nCmdmetoda)=0
          else
            NacetlInt(nCmdmetoda)=1
          endif
        endif
        if(ncomp.gt.1) then
          call FeQuestIntFromEdw(nEdwComp,NacetlInt(nCmdnsubs))
        else
          NacetlInt(nCmdnsubs)=1
        endif
      endif
      call FeQuestRemove(id)
      return
      end
      subroutine ReadMapType
      include 'params.cmn'
      include 'basic.cmn'
      include 'atoms.cmn'
      include 'fourier.cmn'
      include 'fepc.cmn'
      character*44  MapType(15)
      character*80 t80
      character*256 EdwStringQuest,t256
      logical CrwLogicQuest
      integer EdwStateQuest
      data MapType/'F(obs)**2 - %Patterson',
     1             'F(calc)**2 - checking P%atterson',
     2             'F(obs)**2-F(calc)**2 - difference Pa%tterson',
     3             'F(obs) - %Fourier',
     4             'F(calc) - %checking Fourier',
     5             'F(obs)-F(calc) - %difference Fourier',
     6             'd%ynamic multipole deformation map',
     7             '%static multipole deformation map',
     8             '%general deformation map',5*' ',
     9             '0/1 - s%hape function'/
      if(ChargeDensities) then
        il=12
      else
        il=9
      endif
      nCrwMax=15
      nMapType=NacetlInt(nCmdmapa)
      id=NextQuestId()
      call FeQuestCreate(id,-1.,-1.,180.,0,il,'Type of the map',0,
     1                   LightGray,0,0)
      il=1
      do 1000i=1,nCrwMax
        call FeQuestCrwMake(id,20.,il,5.,il,MapType(i),'L',CrwgXd,
     1                      CrwgYd,1,1)
        if(MapType(i).eq.' ') go to 1000
        if(ChargeDensities.or.i.lt.7.or.i.gt.9) then
          call FeQuestCrwOpen(CrwLastMade,CrwLastMade.eq.nMapType)
          il=il+1
        endif
1000  continue
      call FeQuestLineMake(id,il)
      il=il+1
      if(lite.eq.0) then
        t80='U(iso)'
        niso=nCmdUOverAll
      else
        t80='B(iso)'
        niso=nCmdBOverAll
      endif
      Uiso=NacetlReal(niso)
      call FeQuestEdwMake(id,5.,il,30.,il,t80,'L',30.,EdwYd,0)
      nEdwUiso=EdwLastMade
      t80='Reference m80'
      xpom=FeTxLength(t80)+8.
      call FeQuestEdwMake(id,5.,il,xpom,il,t80,'L',135.-xpom,EdwYd,0)
      nEdwRefM80=EdwLastMade
      call FeQuestButtonMake(id,140.,il,35.,ButYd,'%Browse')
      nButtRefM80=ButtonLastMade
      if(nMapType.eq.9.and.ChargeDensities) then
        call FeQuestStringEdwOpen(nEdwRefM80,RefM80)
        call FeQuestButtonOpen(nButtRefM80,ButtonOff)
      else if(nMapType.le.3) then
        call FeQuestRealEdwOpen(nEdwUiso,Uiso,.false.,.false.)
        call FeQuestLabelMake(id,65.,il,'will be used to sharpen maps',
     1                        'L')
      endif
      icont=0
1500  call FeQuestEvent(id,icont,ich)
      icont=1
      if(CheckType.eq.EventCrw) then
        if(CheckNumber.le.3) then
          if(EdwStateQuest(nEdwRefM80).eq.EdwOpened) then
            call FeQuestEdwClose(nEdwRefM80)
            call FeQuestButtonClose(nButtRefM80)
          endif
          if(EdwStateQuest(nEdwUiso).ne.EdwOpened) then
            call FeQuestRealEdwOpen(nEdwUiso,Uiso,.false.,.false.)
            call FeQuestLabelMake(id,65.,il,'will be used to sharpen '//
     1                            'maps','L')
          endif
          EventType=EventEdw
          EventNumber=nEdwUiso
        else
          if(EdwStateQuest(nEdwUiso).eq.EdwOpened) then
            call FeQuestEdwClose(nEdwUiso)
            call FeQuestLabelRemove(id,65.,il,'will be used to sharpen '
     1                            //'maps','L')
          endif
        endif
        if(CheckNumber.eq.9.and.ChargeDensities) then
          if(EdwStateQuest(nEdwRefM80).ne.EdwOpened) then
            call FeQuestStringEdwOpen(nEdwRefM80,RefM80)
            call FeQuestButtonOpen(nButtRefM80,ButtonOff)
          endif
          EventType=EventEdw
          EventNumber=nEdwRefM80
        else
          call FeQuestEdwClose(nEdwRefM80)
          call FeQuestButtonClose(nButtRefM80)
        endif
        icont=0
        go to 1500
      else if(CheckType.eq.EventButton.and.CheckNumber.eq.nButtRefM80)
     1  then
        t256=EdwStringQuest(nEdwRefM80)
        call FeFileManager('Select output file',t256,'*.m80',0,.true.,
     1                     ich)
        if(ich.eq.0) call FeQuestStringEdwOpen(nEdwRefM80,t256)
        EventType=EventEdw
        EventNumber=nEdwRefM80
        call FeQuestButtonOff(nButtRefM80)
        go to 1500
      else if(CheckType.ne.0) then
        call NebylOsetren
        go to 1500
      endif
      if(ich.eq.0) then
        do 1600i=1,nCrwMax
          if(CrwLogicQuest(i)) then
            go to 1610
          endif
1600    continue
        i=1
1610    NacetlInt(nCmdmapa)=i
        if(EdwStateQuest(nEdwRefM80).eq.EdwOpened) then
          RefM80=EdwStringQuest(nEdwRefM80)
        else
          RefM80=' '
        endif
        if(EdwStateQuest(nEdwUiso).eq.EdwOpened) then
          call FeQuestRealFromEdw(nEdwUiso,NacetlReal(niso))
        else
          NacetlReal(niso)=DefRealFour(niso)
        endif
      endif
9999  call FeQuestRemove(id)
      return
      end
      subroutine ReadScope(Klic,its,ich)
      include 'params.cmn'
      include 'basic.cmn'
      include 'fourier.cmn'
      include 'fepc.cmn'
      dimension ip(6),prefr(3),xp(3)
      character*256 EdwStringQuest,t256
      character*80 t80
      character*7 Label(3)
      character*2 nty
      integer EdwStateQuest,CrwStateQuest
      logical CrwLogicQuest
      equivalence (t256,t80)
      data Label/'minimum','maximum','step'/
      if(NacetlInt(nCmdnoo).lt.0) then
        call SetIntArrayTo(ip,6,-1)
      else
        write(t80,101) NacetlInt(nCmdnoo)
        call zhusti(t80)
        read(t80,100) ip
      endif
      call MakeIts(its)
      xqd=215.
      id=NextQuestId()
      il=ndim+7
      if(Klic.eq.1) il=il-1
      call FeQuestCreate(id,-1.,-1.,215.,0,il,'Scope of the map',0,
     1                   LightGray,0,0)
      il=1
      xpom=35.833
      do 1000i=1,3
        if(i.eq.1) then
          t80='%Independent'
        else if(i.eq.2) then
          t80='%Explicitely'
        else
          t80='Central %point'
        endif
        call FeQuestCrwMake(id,xpom,il,xpom-4.,il+1,t80,'C',CrwgXd,
     1                      CrwgYd,1,1)
        if(i.eq.1) then
          nCrwIndependent=CrwLastMade
        else if(i.eq.3) then
          nCrwPoint=CrwLastMade
        endif
        call FeQuestCrwOpen(CrwLastMade,i.eq.its)
        xpom=xpom+71.667
1000  continue
      il=il+2
      xpom=18.+(15.*(ndim-1)+CrwgXd)*.5
      call FeQuestLabelMake(id,xpom,il,'Map axes','C')
      if(Klic.eq.0) then
        il=il+1
        t80='Use %default'
        tpom=xpom
        xpom=tpom-FeTxLengthUnder(t80)*.5-CrwXd-3.
        call FeQuestCrwMake(id,tpom,il,xpom,il,t80,'C',CrwXd,CrwYd,1,0)
        nCrwDefaultOrient=CrwLastMade
        call FeQuestCrwOpen(CrwLastMade,ip(1).lt.0)
      endif
      il=il+1
      ilp=il
      if(Klic.eq.0) then
        xpomp=xqd-105.
      else
        xpomp=18.
      endif
      do 1040i=1,ndim
        il=il+1
        if(ndim.eq.3) then
          call FeQuestLabelMake(id,5.,il,smbx(i),'L')
        else
          call FeQuestLabelMake(id,5.,il,smbx6(i),'L')
        endif
        xpom=xpomp
        do 1020j=1,3
          if(i.eq.1) call FeQuestLabelMake(id,xpom+15.,ilp,Label(j),'C')
          call FeQuestEdwMake(id,xpom,il,xpom,il,' ','C',30.,EdwYd,0)
          if(i.eq.1.and.j.eq.1) nEdwIntervalFirst=EdwLastMade
          xpom=xpom+35.
1020    continue
1040  continue
      if(Klic.eq.0) then
        xpom=18.
        do 1100i=1,ndim
          il=ilp
          write(t80,'(i1,a2)') i,nty(i)
          call FeQuestLabelMake(id,xpom+4.,il,t80,'C')
          do 1050j=1,ndim
            il=il+1
            call FeQuestCrwMake(id,xpom,il,xpom,il,' ','C',CrwgXd,
     1                          CrwgYd,1,i+1)
            if(i.eq.1.and.j.eq.1) nCrwOrientFirst=CrwLastMade
1050      continue
          xpom=xpom+15.
1100    continue
        nCrwOrientLast=CrwLastMade
      else
        nCrwOrientFirst=0
        nCrwOrientLast=0
      endif
      il=il+1
      call FeQuestEdwMake(id,5.,il,35.,il,'%Center','L',70.,EdwYd,1)
      nEdwCenter=EdwLastMade
      call FeQuestEdwMake(id,117.,il,155.,il,'Sc%ope [A]','L',55.,
     1                    EdwYd,0)
      nEdwScope=EdwLastMade
      il=il+1
      call FeQuestCrwMake(id,5.,il,55.,il,'%Add border','L',CrwXd,CrwYd,
     1                    0,0)
      nCrwBorder=CrwLastMade
      call FeQuestCrwMake(id,5.,il,55.,il,'%Refresh scope','L',CrwXd,
     1                    CrwYd,0,0)
      nCrwRefreshScope=CrwLastMade
      call FeQuestEdwMake(id,120.,il,155.,il,'%Step [A]','L',55.,EdwYd,
     1                    0)
      nEdwStep=EdwLastMade
      icont=0
1200  nEdw=nEdwIntervalFirst
      do 1260i=1,ndim
        do 1250j=1,3
          if((its.eq.2.or.i.gt.3).and.EdwStateQuest(nEdw).ne.EdwOpened)
     1      then
            if(j.eq.1) then
              if(xrmn(i).lt.-330.) then
                pom=0.
              else
                pom=xrmn(i)
              endif
            else if(j.eq.2) then
              if(xrmn(i).lt.-330.) then
                pom=1.
              else
                pom=xrmx(i)
              endif
            else
              if(xrmn(i).lt.-330.) then
                if(i.le.3) then
                  if(CellPar(i,1,KPhase).gt.20.) then
                    pom=0.01
                  else if(CellPar(i,1,KPhase).gt.10.) then
                    pom=0.02
                  else
                    pom=0.05
                  endif
                else
                   pom=0.1
                endif
              else
                pom=dd(i)
              endif
            endif
            call FeQuestRealEdwOpen(nEdw,pom,.false.,.false.)
          else if(its.ne.2.and.EdwStateQuest(nEdw).eq.EdwOpened.and.
     1            i.le.3) then
            if(j.eq.1) xrmn(i)=-333.
            call FeQuestEdwClose(nEdw)
          endif
          nEdw=nEdw+1
1250    continue
1260  continue
      if(its.eq.3.and.EdwStateQuest(nEdwCenter).ne.EdwOpened) then
        if(ptname.eq.'[nic]') then
          t80=' '
        else
          t80=ptname
        endif
        call FeQuestStringEdwOpen(nEdwCenter,t80)
        call FeQuestRealAEdwOpen(nEdwScope,pts,3,.false.,.false.)
      else if(its.ne.3.and.EdwStateQuest(nEdwCenter).eq.EdwOpened) then
        ptname='[nic]'
        call SetRealArrayTo(ptx,3,0.)
        call SetRealArrayTo(pts,3,.5)
        call FeQuestEdwClose(nEdwCenter)
        call FeQuestEdwClose(nEdwScope)
        call FeQuestCrwClose(nCrwRefreshScope)
      endif
      if((its.eq.1.or.its.eq.3).and.
     1   EdwStateQuest(nEdwStep).ne.EdwOpened) then
        call FeQuestRealEdwOpen(nEdwStep,NacetlReal(nCmdptstep),.false.,
     1                          .false.)
      else if(its.eq.2) then
        NacetlReal(nCmdptstep)=DefaultReal(nCmdptstep)
        call FeQuestEdwClose(nEdwStep)
      endif
      if(its.eq.1) then
        call FeQuestCrwOpen(nCrwBorder,NacetlInt(nCmdncollar).eq.1)
      else if(its.ne.1) then
        NacetlInt(nCmdncollar)=DefaultInt(nCmdncollar)
        call FeQuestCrwClose(nCrwBorder)
      endif
1300  if(Klic.eq.0) then
        nCrw=nCrwOrientFirst-1
        do 1330i=1,ndim
          do 1320j=1,ndim
            nCrw=nCrw+1
            do 1310k=1,i-1
              if(ip(k).eq.j) then
                call FeQuestCrwClose(nCrw)
                go to 1320
              endif
1310        continue
            if(ip(1).gt.0) call FeQuestCrwOpen(nCrw,j.eq.ip(i))
1320      continue
1330    continue
      endif
      if(its.eq.3.and.ip(1).le.3.and.ip(2).gt.3) then
        if(CrwStateQuest(nCrwRefreshScope).eq.CrwClosed)
     1    call FeQuestCrwOpen(nCrwRefreshScope,.true.)
      else
        call FeQuestCrwClose(nCrwRefreshScope)
      endif
1500  call FeQuestEvent(id,icont,ich)
      icont=1
      if(CheckType.eq.EventCrw.and.
     1   CheckNumber.ge.nCrwIndependent.and.CheckNumber.le.nCrwPoint)
     2  then
        its=CheckNumber-nCrwIndependent+1
        EventType=0
        go to 1200
      else if(CheckType.eq.EventCrw.and.
     1        CheckNumber.eq.nCrwDefaultOrient) then
        if(CrwLogicQuest(nCrwDefaultOrient)) then
          do 1502i=nCrwOrientFirst,nCrwOrientLast
            call FeQuestCrwClose(i)
1502      continue
          ip(1)=-1
        else
          do 1505i=1,ndim
            ip(i)=i
1505      continue
        endif
        icont=0
        go to 1300
      else if(CheckType.eq.EventCrw.and.
     1        CheckNumber.ge.nCrwOrientFirst.and.
     2        CheckNumber.le.nCrwOrientLast) then
        irefr=ip(1)
        j=CheckNumber-nCrwOrientFirst
        i=j/ndim+1
        j=mod(j,ndim)+1
        ipp=ip(i)
        ip(i)=j
        do 1510k=i+1,ndim
          if(ip(k).eq.j) then
            ip(k)=ipp
            go to 1512
          endif
1510    continue
1512    icont=0
        if(CrwLogicQuest(nCrwRefreshScope)) then
          call FeQuestRealAFromEdw(nEdwScope,prefr)
          if(ip(1).ne.irefr.and.ip(1).le.3) then
            i=mod(irefr,3)+1
            j=6-i-irefr
            pom=prefr(irefr)
            prefr(irefr)=prefr(ip(1))
            prefr(ip(1))=pom
            call FeQuestRealAEdwOpen(nEdwScope,prefr,3,.false.,.false.)
          endif
        endif
        go to 1300
      else if(CheckType.eq.EventEdw.and.CheckNumber.eq.nEdwCenter) then
        if(EventType.eq.EventCrw.and.EventNumber.le.nCrwPoint)
     1    go to 1500
        t256=EdwStringQuest(nEdwCenter)
        k=0
        call StToReal(t256,k,xp,3,.false.,ich)
        call TestAtomString(t256,IdWildNo,IdAtMolYes,IdMolNo,IdSymmYes,
     1                      t80)
        if(t80.ne.' ') then
          call FeChybne(-1.,-1.,ErrString,0,SeriousError)
          ich=1
          go to 1520
        endif
        go to 1500
1520    EventType=EventEdw
        EventNumber=nEdwCenter
        go to 1500
      else if(CheckType.ne.0) then
        call NebylOsetren
        go to 1500
      endif
      if(ich.eq.0) then
        if(CrwLogicQuest(nCrwBorder).and.its.eq.1) then
          NacetlInt(nCmdncollar)=1
        else
          NacetlInt(nCmdncollar)=0
        endif
        if(its.eq.1.or.its.eq.3) then
          i1=4
        else
          i1=1
        endif
        nEdw=nEdwIntervalFirst+(i1-1)*3
        do 1600i=i1,ndim
          do 1590j=1,3
            call FeQuestRealFromEdw(nEdw,pom)
            if(j.eq.1) then
              xrmn(i)=pom
            else if(j.eq.2) then
              xrmx(i)=pom
            else
              dd(i)=pom
            endif
            nEdw=nEdw+1
1590      continue
1600    continue
        if(its.eq.3) then
          ptname=EdwStringQuest(nEdwCenter)
          call FeQuestRealAFromEdw(nEdwScope,pts)
        else
          ptname='[nic]'
        endif
        if(its.ne.2)
     1    call FeQuestRealFromEdw(nEdwStep,NacetlReal(nCmdptstep))
        if(ip(1).le.0) then
          j=-333
        else
          j=ip(1)
          do 1700i=2,ndim
            j=j*10+ip(i)
1700      continue
        endif
        NacetlInt(nCmdnoo)=j
      endif
      call FeQuestRemove(id)
      return
100   format(6i1)
101   format(i6)
      end
      subroutine MakeIts(its)
      include 'params.cmn'
      include 'basic.cmn'
      include 'fourier.cmn'
      if(ptname.ne.'[nic]') then
        its=3
      else
        its=2
        do 3600i=1,3
          if(xrmn(i).lt.-330.) then
            its=1
            go to 3610
          endif
3600    continue
      endif
3610  return
      end
      subroutine PeaksCommands
      include 'params.cmn'
      include 'basic.cmn'
      include 'fourier.cmn'
      include 'fepc.cmn'
      logical CrwLogicQuest
      i=4
      if(ndim.gt.3) i=i+4
      id=NextQuestId()
      call FeQuestCreate(id,-1.,-1.,160.,0,i,'Peaks commands',0,
     1                   LightGray,0,0)
      il=1
      call FeQuestLabelMake(id,75.,il,'Maximum number of peaks','C')
      il=2
      call FeQuestCrwMake(id, 40.,il, 36.,il+1,'%Default','C',CrwgXd,
     1                    CrwgYd,1,1)
      nCrwDefault=CrwLastMade
      call FeQuestCrwOpen(CrwLastMade,NacetlInt(nCmdppeaks).lt.0.and.
     1                                NacetlInt(nCmdnpeaks).lt.0)
      call FeQuestCrwMake(id,120.,il,116.,il+1,'%Explicitely','C',
     1                    CrwgXd,CrwgYd,1,1)
      nCrwExplicitely=CrwLastMade
      call FeQuestCrwOpen(CrwLastMade,NacetlInt(nCmdppeaks).ge.0.or.
     1                                NacetlInt(nCmdnpeaks).ge.0)
      il=il+2
      call FeQuestEdwMake(id, 5.,il, 40.,il,'%Positive','L',35.,EdwYd,0)
      nEdwPositive=EdwLastMade
      call FeQuestEdwMake(id,85.,il,120.,il,'%Negative','L',35.,EdwYd,0)
      nEdwNegative=EdwLastMade
      if(ndim.gt.3) then
        il=il+1
        call FeQuestLineMake(id,il)
        il=il+1
        call FeQuestLabelMake(id,75.,il,'Interpretation of diplacement'
     1                      //' waves','C')
        il=il+1
        call FeQuestEdwMake(id,5.,il,80.,il,'No. of %harmonics','L',25.,
     1                      EdwYd,0)
        nEdwNoOfHarm=EdwLastMade
        call FeQuestIntEdwOpen(EdwLastMade,NacetlInt(nCmdkharm),.false.)
        il=il+1
        call FeQuestEdwMake(id,5.,il,80.,il,'Maximal displacement','L',
     1                      35.,EdwYd,0)
        nEdwDMax=EdwLastMade
        call FeQuestRealEdwOpen(EdwLastMade,NacetlReal(nCmddmax),
     1                          .false.,.false.)
      endif
      if(NacetlInt(nCmdppeaks).ge.0.or.NacetlInt(nCmdnpeaks).ge.0) then
        k=nCmdppeaks
        nEdw=nEdwPositive
        do 1400i=1,2
          if(NacetlInt(k).gt.0) then
            j=NacetlInt(k)
          else
            if(i.eq.1) then
              j=50
            else
              j=5
            endif
            NacetlInt(k)=j
          endif
          call FeQuestIntEdwOpen(nEdw,j,.false.)
          k=k+1
          nEdw=nEdw+1
1400    continue
      endif
1450  icont=0
1500  call FeQuestEvent(id,icont,ich)
      icont=1
      if(CheckType.eq.EventCrw) then
        if(CrwLogic(CrwFr+1)) then
          call FeQuestIntEdwOpen(nEdwPositive,50,.false.)
          call FeQuestIntEdwOpen(nEdwNegative, 5,.false.)
          EventType=EventEdw
          EventNumber=nEdwPositive
        else
          call FeQuestEdwClose(nEdwPositive)
          call FeQuestEdwClose(nEdwNegative)
          go to 1450
        endif
        go to 1500
      else if(CheckType.ne.0) then
        call NebylOsetren
        go to 1500
      endif
      if(ich.eq.0) then
        if(CrwLogicQuest(nCrwDefault)) then
          NacetlInt(nCmdppeaks)=-333
          NacetlInt(nCmdnpeaks)=-333
        else
          call FeQuestIntFromEdw(nEdwPositive,NacetlInt(nCmdppeaks))
          call FeQuestIntFromEdw(nEdwNegative,NacetlInt(nCmdnpeaks))
        endif
        if(ndim.gt.3) then
          call FeQuestIntFromEdw(nEdwNoOfHarm,NacetlInt(nCmdkharm))
          call FeQuestRealFromEdw(nEdwDMax,NacetlReal(nCmddmax))
        endif
      endif
      call FeQuestRemove(id)
      return
      end

