!     Last change:  VP   19 Sep 2007    3:13 pm
      program Jana2000
      include 'params.cmn'
      include 'basic.cmn'
      include 'main.cmn'
      include 'atoms.cmn'
      include 'molec.cmn'
      include 'fepc.cmn'
      include 'editm50.cmn'
      include 'powder.cmn'
      integer FeChdir,FeMenu
      dimension MFile(9)
      logical FeYesNo,ExistFile,Change,StructureExists,CrwLogicQuest,
     1        Ukoncit,Focus,FeYesNoHeader,StructureOpened,
     2        GetStructureLocked
      character*256 Veta1,Veta2,HistoryFileTmp,t256
      character*240 FePrikaz
      character*128 CurrentDirO
      character*80  flno
      character*4   Ext
      NPhase=1
      KPhase=1
      KPhaseBasic=1
      TimeOfFlight=.false.
      isBeta=.false.
      VersionString='               Version : 08/11/2007'
      i=FeEtime()
      ObrLom=char(92)
      call getfln
      AllowChangeMouse=.true.
      PlivejVyrez=0
      PripravVyrez=0
      call OpenWorkSpace
      call SetConstants
      call FeGetCurrentDir
      if(VasekDebug.ne.0)
     1  write(44,'(''CURRENT DIR : '',a)') CurrentDir(:idel(CurrentDir))
      call FeMakeGrWin(0.,0.,14.,0.)
      call FeExposeEvent
      call TestDataFiles(Ukoncit)
      if(Ukoncit) go to 9000
      if(VasekDebug.ne.0) then
        close(44)
        VasekDebug=0
      endif
      if(ifln.eq.0) then
        if(ExistFile(HistoryFile)) then
          lni=NextLogicNumber()
          call OpenFile(lni,HistoryFile,'formatted','unknown')
800       read(lni,FormA256,end=900) Veta1
          read(lni,FormA256,end=900) Veta2
          i=FeChdir(Veta1)
          fln=Veta2
          ifln=idel(fln)
          if(StructureOpened(fln)) then
            ifln=0
            go to 800
          endif
          call FeBottomInfo(' ')
          call FeGetCurrentDir
900       close(lni)
        endif
      else
        if(StructureOpened(fln)) then
          NInfo=1
          TextInfo(1)='The structure is probably opened by another '//
     1                 'user or task.'
          if(.not.FeYesNoHeader(-1.,-1.,
     1                          'Do you want to continue anyhow?',0))
     2      then
            fln=' '
            ifln=0
          endif
        endif
      endif
1000  call FeEvent(1)
      if(EventType.ne.0) go to 1000
      call FeZacatek
      write(Veta1,100) mxscr
      call Zhusti(Veta1)
      Veta1='the scratch array "scrar" length='//
     1      Veta1(:idel(Veta1))
      i=matice+7*mxder+mxsup*(16+2*mxw)
      if(mxscr.lt.i) then
        write(Veta2,100) i
        call Zhusti(Veta2)
        Veta2='is too short for matice+..='//Veta2(:idel(Veta2))
        call FeChybne(-1.,-1.,Veta1,Veta2,0,FatalError)
        go to 9000
      else if(mxscr.lt.12*mxref) then
        write(Veta2,100) 12*mxref
        call Zhusti(Veta2)
        Veta2='is too short for 13*mxref='//Veta2(:idel(Veta2))
        call FeChybne(-1.,-1.,Veta1,Veta2,0,FatalError)
        go to 9000
      else if(mxscr.lt.14*mxtbl) then
        write(Veta2,100) 14*mxtbl
        call Zhusti(Veta2)
        Veta2='is too short for 6*mxtbl='//Veta2(:idel(Veta2))
        call FeChybne(-1.,-1.,Veta1,Veta2,0,FatalError)
        go to 9000
      endif
      PreviousM40='jm40'
      call CreateTmpFile(PreviousM40,i,0)
      PreviousM41='jm41'
      call CreateTmpFile(PreviousM41,i,0)
      PreviousM50='jm50'
      call CreateTmpFile(PreviousM50,i,0)
      call DeletePomFiles
      if(ifln.gt.0) call ChangeUSDFile(fln,'opened','*')
      CurrentDirO=' '
      OKForBasicFiles=0
1100  call FeExceptionInfo
      ShowInfoOnScreen=.true.
      StructureLocked=GetStructureLocked(fln)
      if(StructureLocked) then
        if(CurrentDir.ne.CurrentDirO.or.fln.ne.flno) then
          NInfo=3
          TextInfo(1)='The selected structure is locked. All changes '//
     1                'of the basic'
          TextInfo(2)='structure files will be ignored. If necessary '//
     1                'you can unlock'
          TextInfo(3)='the structure by "File->Structure->Unlock".'
        else if(OKForBasicFiles.eq.0) then
          NInfo=1
          TextInfo(1)='The structure has been locked.'
        endif
        if(NInfo.gt.0) call FeInfoOut(-1.,-1.,'WARNING')
        OKForBasicFiles=-1
      else
        OKForBasicFiles= 0
      endif
      CurrentDirO=CurrentDir
      flno=fln
      if(CurrentDir.ne.' '.and.CurrentDir.ne.TmpDir.and.
     1   fln.ne.' '.and.(fln(1:1).ne.'#'.or.fln(ifln:ifln).ne.'#')) then
        HistoryFileTmp='jhst'
        call CreateTmpFile(HistoryFileTmp,i,0)
        lno=NextLogicNumber()
        call OpenFile(lno,HistoryFileTmp,'formatted','unknown')
        write(lno,FormA1)(CurrentDir(i:i),i=1,idel(CurrentDir))
        write(lno,FormA1)(fln(i:i),i=1,ifln)
        if(ExistFile(HistoryFile)) then
          n=1
          lni=NextLogicNumber()
          call OpenFile(lni,HistoryFile,'formatted','unknown')
1110      read(lni,FormA256,end=1120) Veta1
          read(lni,FormA256,end=1120) Veta2
          if(Veta1.ne.CurrentDir.or.Veta2.ne.fln) then
            n=n+1
            write(lno,FormA1)(Veta1(i:i),i=1,idel(Veta1))
            write(lno,FormA1)(Veta2(i:i),i=1,idel(Veta2))
          endif
          if(n.lt.mxhst) go to 1110
1120      close(lni)
        endif
        close(lno)
        call CopyFile(HistoryFileTmp,HistoryFile)
        call DeleteFile(HistoryFileTmp)
      endif
      if(KPhaseBasic.ne.KPhase) then
        if(VasekTest.eq.1)
     1    call FeChybne(-1.,-1.,'KPhase<>KPhaseBasic',' ',0,
     2                  SeriousError)
        KPhase=KPhaseBasic
      endif
      call CoDal(i,j,k)
      if(ifln.le.0) then
        if((i.eq.1.and.(j.eq.2.or.j.eq.3)).or.
     1     (i.eq.2.and.j.gt.1).or.
     2     (i.eq.3.and.j.ne.13).or.
     3     (i.eq.4.and.j.lt.4)) then
          call FeChybne(-1.,-1.,'blank filename of the structure',' ',0,
     1                  SeriousError)
          i=1
          j=4
          k=1
        endif
      endif
1122  RunningProgram=' '
      if(i.eq.IdFile) then
        if(j.eq.IdFileDOS) then
          call FeShell
        else if(j.eq.IdFileImport) then
          if(k.eq.IdFileImportShelx) then
            call ZShelxe(0)
          else if(k.eq.IdFileImportCif) then
            call ReadCIF(0)
          else if(k.eq.IdFileImportDupals) then
            call ZDupals
          else if(k.eq.IdFileImportXD) then
            call ZXD
          endif
        else if(j.eq.IdFileExport) then
          if(k.eq.IdFileExportShelx) then
            if(ExistM50) then
              Veta1=' '
              call Trm4050(5,Veta1,' ',ich)
              if(ich.ne.0) go to 1100
            else
              Veta1=fln
            endif
            if(ExistM91.or.ExistM95) call DRExport(-1,Veta1)
          else if(k.eq.IdFileExportCif) then
            call MakeFinalCIF
          else if(k.eq.IdFileExportHRTEM) then
            call Refine(1)
            call DeleteFile(fln(:ifln)//'.ref')
            call DeleteFile(fln(:ifln)//'.s40')
            call GraphicOutput(-8,fln,0,ich)
          endif
        else if(j.eq.IdFileStruct) then
1130      Veta1='Select name of the structure'
c          call DeletePomFiles
          Focus=.false.
          if(k.eq.IdFileStructOpen.or.k.eq.0) then
            Veta1='Open : '//Veta1(:idel(Veta1))
            Veta2=' '
            Change=.true.
            call DeletePomFiles
          else if(k.eq.IdFileStructHistory) then
            call FeHistory(Veta2,Focus)
            if(ErrJana.eq.0) then
              go to 1150
            else
              i=FeChDir(CurrentDirO)
              go to 1100
            endif
          else if(k.eq.IdFileStructSaveAs) then
            Veta1='Save as : '//Veta1(:idel(Veta1))
            Veta2=' '
            Change=.false.
          else if(k.eq.IdFileStructCopyIn) then
            Veta1='Copy in : '//Veta1(:idel(Veta1))
            Veta2=' '
            Change=.false.
          else if(k.eq.IdFileStructClose) then
            Veta2=' '
            call DeletePomFiles
            go to 1150
          else if(k.eq.IdFileStructLock) then
            if(StructureLocked) then
              Veta2='unlocked'
            else
              Veta2='locked'
            endif
            call ChangeUSDFile(fln,'*',Veta2)
            go to 1100
          endif
          call FeFileManager(Veta1,Veta2,' ',1,.not.Change,ich)
          if(Veta2.eq.' '.or.ich.ne.0) then
            if(ifln.gt.0) call ChangeUSDFile(fln,'opened','*')
            go to 1100
          endif
          if(k.eq.IdFileStructSaveAs.or.k.eq.IdFileStructCopyIn) then
            if(k.eq.IdFileStructSaveAs) then
              idv2=idel(Veta2)
              if(StructureExists(Veta2)) then
                call ExtractFileName(Veta2,Veta1)
                if(.not.FeYesNo(-1.,-1.,'The structure "'//
     1             Veta2(:idv2)//'" already exists, rewrite it?',0))
     2             go to 1100
              endif
              do 1131ii=1,9
                if(ExistMFile(ii))
     1            call CopyFile(fln(:ifln)//
     2                      ExtMFile(ii)(:idel(ExtMFile(ii))),
     3                      Veta2(:idv2)//
     4                      ExtMFile(ii)(:idel(ExtMFile(ii))))
1131          continue
              if(FeYesNo(-1.,-1.,'Do you want to continue with the new '
     1                 //'structure?',0)) then
                call ExtractDirectory(Veta2,Veta1)
                call ExtractFileName(Veta2,Veta2)
                call DeletePomFiles
                i=FeChdir(Veta1)
                call FeGetCurrentDir
                go to 1150
              endif
            else
              if(StructureExists(Veta2)) then
                NInfo=0
                idv2=idel(Veta2)
                do 1132ii=1,9
                  NInfo=NInfo+1
                  TextInfo(NInfo)=ExtMFile(ii)(2:4)
                  n=0
                  t256=Veta2(:idv2)//ExtMFile(ii)
                  if(ExistFile(t256)) then
                    TextInfo(NInfo)(10:)='exists'
                    n=n+10
                  else
                    TextInfo(NInfo)(10:)='empty'
                  endif
                  if(ExistMFile(ii)) then
                    TextInfo(NInfo)(20:)='exists'
                    n=n+1
                  else
                    TextInfo(NInfo)(20:)='empty'
                  endif
                  if(n.eq.1) then
                    TextInfo(NInfo)(30:)='Delete it?'
                  else
                    TextInfo(NInfo)(30:)='Overwrite it?'
                  endif
                  MFile(NInfo)=ii
                  if(n.eq.0) then
                    NInfo=NInfo-1
                  else if(n.eq.1.or.n.eq.10) then
                    MFile(NInfo)=MFile(NInfo)+10*n
                  endif
1132            continue
                id=NextQuestId()
                xdq=FeTxLengthUnder(TextInfo(1))+15.+CrwXd
                ydq=float(NInfo)*10.+43.
                call FeQuestAbsCreate(id,-1.,-1.,xdq,ydq,' ',0,
     1                                LightGray,0,0)
                tpom=5.
                xpom=tpom+FeTxLengthUnder(TextInfo(1))+5.
                t256='File'
                t256(10:)='Source =>'
                t256(20:)='Target'
                ypom=ydq-6.
                call FeQuestAbsLabelMake(id,tpom,ypom,t256,'L')
                ypom=ypom-6.
                call FeQuestAbsLineMake(id,ypom)
                ypom=ypom-10.
                do 1134ii=1,NInfo
                  call FeQuestAbsCrwMake(id,tpom,ypom,xpom,ypom-2.,
     1              TextInfo(ii),'L',CrwXd,CrwYd,0,0)
                  if(ii.eq.1) nCrwFirst=CrwLastMade
                  call FeQuestCrwOpen(CrwLastMade,
     1                                mod(MFile(ii),10).le.3)
                  ypom=ypom-10.
1134            continue
                ypom=ypom-3.
                t256='%All files'
                wpom=FeTxLengthUnder(t256)+10.
                xpom=(xdq-wpom)*.5
                call FeQuestAbsButtonMake(id,xpom,ypom,wpom,ButYd,t256)
                nButtAll=ButtonLastMade
                call FeQuestButtonOpen(ButtonLastMade,ButtonOff)
1135            icont=0
                call FeQuestEvent(id,icont,ich)
                icont=1
                if(CheckType.eq.EventButton.and.CheckNumber.eq.nButtAll)
     1            then
                  nCrw=nCrwFirst
                  do 1136i=1,NInfo
                    call FeQuestCrwOn(nCrw)
                    nCrw=nCrw+1
1136              continue
                  call FeQuestButtonOff(nButtAll)
                  go to 1135
                else if(CheckType.ne.0) then
                  call NebylOsetren
                  go to 1135
                endif
                if(ich.eq.0) then
                  nCrw=nCrwFirst
                  idp=idel(Veta2)
                  do 1137ii=1,NInfo
                    if(CrwLogicQuest(nCrw)) then
                      Ext=ExtMFile(mod(MFile(ii),10))
                      if(MFile(ii)/10.eq.1) then
                        call DeleteFile(fln(:ifln)//Ext)
                      else
                        call CopyFile(Veta2(:idp)//Ext,fln(:ifln)//Ext)
                      endif
                    endif
                    nCrw=nCrw+1
1137              continue
                endif
                call FeQuestRemove(id)
              else
                call ExtractFileName(Veta2,Veta1)
                call FeChybne(-1.,-1.,'The structure "'//
     1                        Veta1(:idel(Veta1))//'" doesn''t exist',
     2                        ' ',0,SeriousError)
              endif
            endif
            go to 1100
          endif
1150      if(StructureOpened(Veta2)) then
            NInfo=1
            TextInfo(1)='The structure is probably opened by another '//
     1                  'user or task.'
            if(.not.FeYesNoHeader(-1.,-1.,
     1                            'Do you want to continue anyhow?',0))
     2        then
              i=FeChDir(CurrentDirO)
              call FeGetCurrentDir
              go to 1100
            endif
          endif
          fln=Veta2
          ifln=idel(fln)
          call FeBottomInfo(' ')
          call DeletePomFiles
          KPhase=1
          KPhaseBasic=1
          if(Focus) then
            k=IdFileStructOpen
            go to 1130
          else
            if(ifln.gt.0) call ChangeUSDFile(fln,'opened','*')
            go to 1100
          endif
        else if(j.eq.IdFileRefl) then
          if(k.eq.IdFileReflImport) then
            if(ExistM92) then
              isPowder=.true.
            else if(ExistM91.or.ExistM95) then
              isPowder=.false.
            else
              id=NextQuestId()
              call FeQuestCreate(id,-1.,-1.,150.,0,2,
     1          'What kind of data do you want to import?',0,LightGray,
     2          0,0)
              tpom=CrwgXd+10.
              xpom=5.
              do 1160i=1,2
                if(i.eq.1) then
                  Veta1='%Single crystal data'
                else
                  Veta1='%Powder diffraction data'
                endif
                call FeQuestCrwMake(id,tpom,i,xpom,i,Veta1,'L',CrwgXd,
     1                              CrwgYd,0,1)
                call FeQuestCrwOpen(CrwLastMade,(isPowder.and.i.eq.2)
     1                              .or.(.not.isPowder.and.i.eq.1))
1160          continue
              nCrw=CrwLastMade
              icont=0
1170          call FeQuestEvent(id,icont,ich)
              icont=1
              if(CheckType.ne.0) then
                call NebylOsetren
                go to 1170
              endif
              if(ich.eq.0) then
                isPowder=CrwLogicQuest(nCrw)
                call iom50(1,0)
              endif
              call FeQuestRemove(id)
              if(ich.ne.0) go to 1100
            endif
            if(isPowder) then
              call PwdImport
            else
              call ImportReflections
            endif
          else if(k.eq.IdFileReflExcl) then
            call CrlExclRefl
          else if(k.eq.IdFileReflSGTest) then
            call DRSGTest(Change)
            if(Change) then
              if(ExistM50.and.StatusM50.le.100) then
                if(FeYesNo(-1.,-1.,'Do you want to create refinement '//
     1                     'reflection file (m91)?',1)) call ExportM91
              else
                if(FeYesNo(-1.,-1.,'Do you want to create or complete'//
     1                     ' basic data file (m50)?',1)) call Editm50
              endif
            endif
          else if(k.eq.IdFileReflCreate) then
            call RewriteTitle('ExportM91')
            call ExportM91
          endif
        else if(j.eq.IdFileExit) then
          if(FeYesNo(-1.,-1.,'Do you really want to quit Jana2000?',0))
     1      then
            go to 9000
          else
            go to 1100
          endif
        endif
      else if(i.eq.IdEdit) then
        if(j.lt.IdEditRef) then
1200      if(j.eq.IdEditFile) then
            Veta1=' '
            call FeFileManager('Select file to be edited',Veta1,'*.*',0,
     1                         .true.,ich)
            if(ich.gt.0.or.Veta1.eq.' ') then
              go to 1100
            else if(ich.lt.0) then
              call FeChybne(-1.,-1.,'permission denied, you cannot '//
     1                     'edit','the selected file - view mode '//
     2                     'activated',0,SeriousError)
            endif
          else if(j.eq.IdEditM40) then
            Veta1='.m40'
          else if(j.eq.IdEditM41) then
            Veta1='.m41'
          else if(j.eq.IdEditM50) then
            Veta1='.m50'
          else if(j.eq.IdEditM91) then
            if(isPowder) then
              Veta1='.m92'
            else
              Veta1='.m91'
            endif
          endif
          if(j.ne.IdEditFile) Veta1=fln(:ifln)//Veta1(1:4)
          call FeEdit(Veta1,0)
          if(j.eq.IdEditFile) go to 1200
        else
          if(j.eq.IdEditRef) then
            Veta1=fln(:ifln)//'.ref'
          else if(j.eq.IdEditFour) then
            Veta1=fln(:ifln)//'.fou'
          else if(j.eq.IdEditDist) then
            Veta1=fln(:ifln)//'.dis'
          else if(j.eq.IdEditRefRep) then
            Veta1=fln(:ifln)//'.rre'
          else if(j.eq.IdEditCP) then
            Veta1=fln(:ifln)//'.cp'
          else if(j.eq.IdEditInb) then
            Veta1=fln(:ifln)//'.inb'
          endif
          if(BuildInViewer) then
            call FeListView(Veta1)
          else
            if(OpSystem.le.0) then
              call FeEdit(Veta1,0)
            else
              call FeSystem(FePrikaz(Veta1,3))
            endif
          endif
        endif
      else if(i.eq.IdRun) then
        if(j.gt.IdRunEditM50.and.j.ne.10.and.j.lt.15.and..not.existM50)
     1    go to 8000
        if(j.gt.IdRunEditM50.and.j.ne.IdRunRefine.and.j.ne.IdRunFourier
     1                      .and.j.lt.15.and.StatusM50.gt.0) go to 8100
        call NewPg(1)
        if(j.eq.IdRunDatred) then
          call RewriteTitle('Datred')
          call DatRed
          if(ExistFile(fln(:ifln)//'_datred.tmp').and.ErrJana.eq.0.and.
     1       .not.StructureLocked) call UpdateSummary('datred')
        else if(j.eq.IdRunEditM50) then
          call RewriteTitle('Editm50')
          call Editm50
        else if(j.eq.IdRunEditM40) then
          call RewriteTitle('Editm40')
          call Editm40
        else if(j.eq.IdRunRefine) then
          if((nacalc.gt.0.and.StatusM50.gt.0).or.StatusM50.gt.10)
     1      go to 8100
          call RewriteTitle('Refine')
          call Refine(0)
          if(ExistFile(fln(:ifln)//'_refine.tmp').and.ErrJana.eq.0.and.
     1       .not.StructureLocked) call UpdateSummary('refine')
        else if(j.eq.IdRunFourier) then
          call RewriteTitle('Fourier')
          call Fourier
          if(ExistFile(fln(:ifln)//'_fourier.tmp').and.ErrJana.eq.0.and.
     1       .not.StructureLocked) call UpdateSummary('fourier')
        else if(j.eq.IdRunContour) then
          call RewriteTitle('Contour')
          call Contour
        else if(j.eq.IdRunDist) then
          call RewriteTitle('Dist')
          call Dist
          if(ExistFile(fln(:ifln)//'_dist.tmp').and.ErrJana.eq.0.and.
     1       .not.StructureLocked) call UpdateSummary('dist')
        else if(j.eq.IdRunGrapht) then
          call RewriteTitle('Grapht')
          call Grapht
        else if(j.eq.IdRunSetCmd) then
          call SetCommands(k)
          if(StartProgram) then
            if(k.eq.1) then
              j=IdRunRefine
            else if(k.eq.2) then
              j=IdRunFourier
            else if(k.eq.3) then
              j=IdRunDist
            endif
            if(k.ge.1.and.k.le.3) then
              k=0
              go to 1122
            endif
          endif
        else if(j.eq.IdRunExpo.or.j.eq.IdRunSIR97) then
          if(isPowder) then
            call RunSir(DirExpo,CallExpo)
          else
            call RunSir(DirSIR97,CallSIR97)
          endif
        else if(j.eq.IdRunSIR2002.or.j.eq.IdRunExpo2004) then
          if(isPowder) then
            call RunSir(DirExpo2004,CallExpo2004)
          else
            call RunSir(DirSIR2002,CallSIR2002)
          endif
        endif
      else if(i.eq.IdParam) then
        call EM40EditParameters(j,k)
      else if(i.eq.IdTools) then
        if(j.eq.IdToolsRecover) then
          Veta1='Do you really want to recover the parameter file'
          j=idel(Veta1)
          if(isPowder) then
            Veta1=Veta1(:j)//'s?'
          else
            Veta1=Veta1(:j)//'?'
          endif
          if(FeYesNo(-1.,-1.,Veta1,0)) then
            call CopyFile(fln(:ifln)//'.s40',fln(:ifln)//'.m40')
            if(IsPowder) then
              call CopyFile(fln(:ifln)//'.s41',fln(:ifln)//'.m41')
              call iom40(0,0)
              call CopyVek(CellPwd(1,KPhase),CellPar(1,1,KPhase),6)
              call CopyVek(QuPwd(1,1,KPhase),Qu(1,1,1,KPhase),3*ndimi)
              call iom50(1,0)
            endif
          endif
        else if(j.eq.IdToolsTrans) then
          if(k.eq.IdToolsTransCell) then
            call CellTr
          else if(k.eq.IdToolsTransShift) then
            call OriginShift
          else if(k.eq.IdToolsTransSubGr) then
            call GoToSubgroup
          else if(k.eq.IdToolsTransModVec) then
            call DRChngModVec
          else if(k.eq.IdToolsTransGoToSup) then
            call TrSuper
          else if(k.eq.IdToolsTransGoTo3d) then
            call GoTo3d
          endif
        else if(j.eq.IdToolsSpecial) then
          if(k.eq.IdToolsSpecialTLS) then
            call TransTLS
          else if(k.eq.IdToolsSpecialTables) then
            call MakeTables
          else if(k.eq.IdToolsSpecial2dDisp) then
            call GraphMapa
          else if(k.eq.IdToolsSpecialPowSim) then
            call PwdSimulation
          else if(k.eq.IdToolsSpecialSimStr) then
            call CrlMakeSimStr
          endif
        else if(j.eq.IdToolsPowder) then
          if(k.eq.IdToolsPowderPlot) then
            call PwdPrf(0)
          else if(k.eq.IdToolsPowderLeBail) then
            if(kcommen.gt.0) then
              call iom50(0,0)
              call RestorePhase(KPhaseBasic)
              call ComSym(KPhase,0)
            endif
            call PwdLeBail(0)
            if(ErrJana.eq.0) then
              if(FeYesNo(-1.,-1.,
     1                   'Do you want to start "Profile viewer"?',0))
     2          call PwdPrf(0)
            endif
          else if(k.eq.IdToolsPowderSaveBkg) then
            call PwdSaveBackground
          else if(k.eq.IdToolsPowderResetPar) then
            call PwdResetPowderPar
          endif
        else if(j.eq.IdToolsPhases) then
          if(k.eq.IdToolsPhasesNew) then
            call CreateNewPhase
          else if(k.eq.IdToolsPhasesDelete) then
            call DeletePhase
          else if(k.eq.IdToolsPhasesSwitch) then
            i=FeMenu(-1.,-1.,PhaseName,1,NPhase,1,0)
            if(i.gt.0) then
              call RestorePhase(i)
              KPhaseBasic=i
            endif
          endif
        else if(j.eq.IdToolsTplg) then
          if(k.eq.IdToolsTplgCP) then
            call TPCriticalPoints
          else if(k.eq.IdToolsTplgBasint) then
            call TPIntegration
          endif
        else if(j.eq.IdToolsGraphW) then
          if(ndimi.le.0) then
            call CheckAtomNames(MenitNazvy)
          else
            MenitNazvy=1
          endif
          if(MenitNazvy.ge.0) then
            call CopyFile(fln(:ifln)//'.m40',fln(:ifln)//'.l40')
            Veta1=fln(:ifln)//'_tmp'
            MakeCIFForGraphicViewer=.true.
            if(ndim.eq.3) then
              call IncludePeaks
              call StrToStandSetting
              call TrM4050(7,Veta1,' ',ich)
            else
              call GraphicOutput(-7,Veta1,MenitNazvy,ich)
            endif
            MakeCIFForGraphicViewer=.false.
            if(ich.eq.0)
     1        call FeGraphicViewer('"'//CurrentDir(:idel(CurrentDir))//
     2                             Veta1(:idel(Veta1))//'.cif"')
            call CopyFile(fln(:ifln)//'.l40',fln(:ifln)//'.m40')
            call DeleteFile(Veta1(:idel(Veta1))//'.cif')
            call DeleteFile(PreviousM40)
            call DeleteFile(PreviousM50)
          endif
        else if(j.eq.IdToolsRecipW) then
          if(ExistM94.and.ExistM95) then
            call iom94(0)
            call Simulace
          else if(ExistFile(fln(:ifln)//'.m80')) then
            call Simulace
          else
            call FeChybne(-1.,-1.,'the reflection file m95 doesn''t '//
     1                    'exist',' ',0,SeriousError)
          endif
        else if(j.eq.IdToolsMEM) then
          Veta1=' '
7000      call MEMExport(Veta1)
          if(Veta1.ne.' ') go to 7000
        else if(j.eq.IdToolsPref) then
          call FePreferences
        else if(j.eq.IdToolsSetting) then
          call FeSettings
        else if(j.eq.IdToolsAbout) then
          call AboutJana
        else if(j.eq.IdToolsNase) then
          if(k.eq.IdToolsNaseKuma) then
            call RewriteTitle('KUMA')
            call KUMA
          else if(k.eq.IdToolsNaseCAD4) then
            call RewriteTitle('CAD4')
            call CAD4
          else if(k.eq.IdToolsNaseSimulace) then
            call RewriteTitle('Simulace')
            call LukSimulace(1)
          else if(k.eq.IdToolsNaseHonza) then
            call RewriteTitle('Honza')
            call Honza
          else if(k.eq.IdToolsNaseTestDiff) then
            call DRTestDiffractometer
          else if(k.eq.IdToolsNaseIndexM95) then
            call DRKumaIndex(0)
          else if(k.eq.IdToolsNaseBruker) then
            call DRBruker
          else if(k.eq.IdToolsNaseAdHoc) then
c            call RewriteTitle('Make graph')
c            call MakeGraph
c            call Pomucky(0)
c            call TestGrup
c            call DRSGTest(Change)
c            call TestBarev
c            call TestDirCos
          else if(k.eq.IdToolsNaseSummary) then
            call RefSummary
          else if(k.eq.IdToolsNaseUpdateCifFile) then
            call UpDateCifFile
          endif
        endif
      endif
      if(.not.GrOn) then
        call OpenWorkSpace
        call FeMakeGrWin(0.,0.,14.,0.)
        call FeExposeEvent
        CurrentDir=CurrentDirO
        j=FeChdir(CurrentDir(:idel(CurrentDir)))
      endif
      call CloseAllFiles
      call FeDeferOutput
      call FeMakeGrWin(0.,0.,14.,0.)
      go to 1100
8000  call FeChybne(-1.,-1.,'the M50 file doesn''t exist',' ',0,
     1              SeriousError)
      go to 1100
8100  call FeChybne(-1.,-1.,'the M50 file doesn''t contain full '//
     1              'information','to run this program ',0,SeriousError)
      go to 1100
9000  call FeGrQuit
      call DeletePomFiles
      call FeTmpFilesDelete
      stop
100   format(i10)
      end
      subroutine TestUzavreni
      include 'params.cmn'
      include 'basic.cmn'
      include 'fepc.cmn'
      character*80 Veta
      do 1000i=1,mxquest
        if(QuestState(i).ne.0) then
          if(VasekTest.eq.1) then
            write(Veta,'(''Quest '',i2,'' zustal otevren'')') i
            call FeChybne(-1.,-1.,Veta,' ',0,SeriousError)
          endif
          QuestState(i)=0
        endif
1000  continue
      do 1010i=1,mxbut
        if(ButtonState(i).ne.0) then
          if(VasekTest.eq.1) then
            write(Veta,'(''Button '',i2,'' zustal otevren'')') i
            call FeChybne(-1.,-1.,Veta,' ',0,SeriousError)
          endif
          ButtonState(i)=0
        endif
1010  continue
      do 1020i=1,mxcrw
        if(CrwState(i).ne.0) then
          if(VasekTest.eq.1) then
            write(Veta,'(''Crw '',i2,'' zustal otevren'')') i
            call FeChybne(-1.,-1.,Veta,' ',0,SeriousError)
          endif
          CrwState(i)=0
        endif
1020  continue
      do 1030i=1,mxedw
        if(EdwState(i).ne.0) then
          if(VasekTest.eq.1) then
            write(Veta,'(''Edw '',i2,'' zustal otevren'')') i
            call FeChybne(-1.,-1.,Veta,' ',0,SeriousError)
          endif
          EdwState(i)=0
        endif
1030  continue
      do 1040i=1,mxikon
        if(IkonState(i).ne.0) then
          if(VasekTest.eq.1) then
            write(Veta,'(''Ikon '',i2,'' zustal otevren'')') i
            call FeChybne(-1.,-1.,Veta,' ',0,SeriousError)
          endif
          IkonState(i)=0
        endif
1040  continue
      do 1050i=1,mxlbl
        if(LblState(i).ne.0) then
          if(VasekTest.eq.1) then
            write(Veta,'(''Lbl '',i2,'' zustal otevren'')') i
            call FeChybne(-1.,-1.,Veta,' ',0,SeriousError)
          endif
          LblState(i)=0
        endif
1050  continue
      do 1060i=1,mxlwin
        if(LwinState(i).ne.0) then
          if(VasekTest.eq.1) then
            write(Veta,'(''Lwin '',i2,'' zustal otevren'')') i
            call FeChybne(-1.,-1.,Veta,' ',0,SeriousError)
          endif
          LwinState(i)=0
        endif
1060  continue
      do 1070i=1,mxselw
        if(SelwState(i).ne.0) then
          if(VasekTest.eq.1) then
            write(Veta,'(''Selw '',i2,'' zustal otevren'')') i
            call FeChybne(-1.,-1.,Veta,' ',0,SeriousError)
          endif
          SelwState(i)=0
        endif
1070  continue
      return
      end
      subroutine JanaReset
      include 'params.cmn'
      include 'basic.cmn'
      include 'atoms.cmn'
      include 'molec.cmn'
      include 'fepc.cmn'
      include 'datred.cmn'
      include 'profil.cmn'
      character*256 t256
      character*80 ZalozniSoubor,PuvodniSoubor,Veta
      logical ExistFile,FeYesNoHeader,EqIgCase,FileDiff,eqiv
      equivalence (Veta,ZalozniSoubor)
      SetMetAllowed=.true.
1000  if(ifln.gt.0) then
        do 1100i=1,9
          ExistMFile(i)=ExistFile(fln(:ifln)//ExtMFile(i))
1100    continue
      else
        call SetLogicalArrayTo(ExistMFile,8,.false.)
      endif
      j=1
      do 1200i=1,9
        if(ExistMFile(i)) then
          t256=fln(:ifln)//ExtMFile(i)
          call CheckFileIfNotReadOnly(t256,1)
          if(ErrJana.ne.0) go to 1150
          call CheckEOLOnFile(t256,j)
          j=0
          if(ErrJana.eq.0) go to 1200
1150      fln=' '
          ifln=0
          go to 1000
        endif
1200  continue
      if(ExistM50) then
        call CrlTestJana2006
        if(fln.eq.' ') go to 9999
      endif
      if(ExistM41) then
        if(ExistM94) call DeleteFile(fln(:ifln)//'.m94')
        if(ExistM95) call DeleteFile(fln(:ifln)//'.m95')
        ExistM94=.false.
        ExistM95=.false.
      endif
      if(ExistM94) then
        PuvodniSoubor=fln(:ifln)//'.m94'
        open(94,file=PuvodniSoubor)
        read(94,'(i5)',err=1250) i
        call CloseIfOpened(94)
        call ioz94(0,0)
        ZalozniSoubor=fln(:ifln)//'.r94'
        Ninfo=4
        TextInfo(1)=PuvodniSoubor
        TextInfo(2)='The program has detected the Jana98 format for '//
     1              'this m94 file.'
        TextInfo(3)='The file will be transformed into the new format'//
     1              ' and the old'
        TextInfo(4)='one can be saved on request.'
        if(FeYesNoHeader(-1.,-1.,'Do you want to save the old file?',0))
     1    then
          call FeFileManager('Select file name for the old m94 file',
     1                       ZalozniSoubor,'*.*',0,.true.,ich)
          call CopyFile(PuvodniSoubor,ZalozniSoubor)
        endif
        call iom94(1)
1250    call CloseIfOpened(94)
        call iom94(0)
        if(ExistM50) call iom50(0,0)
      endif
      if(ExistM91.or.ExistM95) then
        if(ExistM95) then
          call OpenFile(95,fln(:ifln)//'.m95','formatted','old')
          call PrvniM95(ich)
          i=ndim*4+75
        else if(ExistM91) then
          call OpenFile(95,fln(:ifln)//'.m91','formatted','old')
          i=ndim*4+19
        endif
        read(95,FormA256,end=1320) t256
        close(95)
        if(t256.eq.' '.or.(ExistM95.and.EqIgCase(t256,ImportTextB)))
     1    go to 1320
        Veta=t256(i:)
        i=1
1300    if(Veta(i:i).eq.' '.and.i.lt.80) then
          i=i+1
          go to 1300
        endif
1310    if(index(Cifry(1:10),Veta(i:i)).gt.0.and.i.lt.80) then
          i=i+1
          go to 1310
        endif
        write(format95(30:30),100) i-1
        write(format91(14:14),100) i-1
      endif
1320  PuvodniSoubor=fln(:ifln)//'.m50'
      if(ExistM50) then
        if(FileDiff(PuvodniSoubor,PreviousM50)) then
          call iom50(0,0)
          WrongM50=ErrJana.ne.0
          call CopyFile(PuvodniSoubor,PreviousM50)
        endif
      else
        title=' '
        name=' '
        call SetBasicM50
      endif
      if(.not.ExistM40) then
        call SetBasicM40(.true.)
        call SetBasicM41
        if(ExistM50) then
          if(ExistM41) then
            call iom40Only(1,0)
          else
            call iom40(1,0)
          endif
          ExistM40=.true.
          ExistM41=isPowder
          WrongM40=.false.
          WrongM41=.false.
        else
          go to 1400
        endif
      endif
      PuvodniSoubor=fln(:ifln)//'.m40'
      if(FileDiff(PuvodniSoubor,PreviousM40)) go to 1330
      if(IsPowder) then
        if(FileDiff(fln(:ifln)//'.m41',PreviousM41)) go to 1330
      endif
      go to 1350
1330  WrongM40=.false.
      WrongM41=.false.
      call iom40(0,0)
      if(ErrJana.eq.-1) then
        call CrlbCorrectAtomNames(ich)
      else if(ErrJana.ne.0) then
        if(ErrJana.eq.2) then
          WrongM41=.true.
        else
          WrongM40=.true.
        endif
      endif
      call CopyFile(PuvodniSoubor,PreviousM40)
      if(IsPowder) call CopyFile(fln(:ifln)//'.m41',PreviousM41)
1350  if(ExistFile(fln(:ifln)//'.m47').or.ExistFile(fln(:ifln)//'.m48'))
     1  then
        call OpenForAppend(m40,fln(:ifln)//'.m40')
        if(ErrJana.ne.0) go to 1400
1355    backspace m40
        read(m40,FormA80) Veta
        if(Veta(1:1).eq.'*'.or.Veta.eq.' ') then
          backspace m40
          go to 1355
        endif
        write(m40,FormA1)('*',i=1,79)
        ln=NextLogicNumber()
        do 1380i=1,2
          Veta=fln(:ifln)//'.m48'
          if(i.eq.2) then
            j=idel(Veta)
            Veta(j:j)='7'
          endif
          if(ExistFile(Veta)) then
            call OpenFile(ln,Veta,'formatted','old')
            if(ErrJana.ne.0) go to 1375
            read(ln,101)(k,j=1,4),nsubs,KPh
            write(m40,101) nsubs,KPh
            do 1360j=1,4
              read(ln,FormA80)
1360        continue
1365        read(ln,FormA80,end=1370) Veta
            write(m40,FormA1)(Veta(j:j),j=1,idel(Veta))
            go to 1365
          endif
1370      close(ln,status='delete')
1375      write(m40,FormA1)('*',j=1,79)
1380    continue
        close(m40)
      endif
1400  if(ExistM95) then
        call OpenFile(95,fln(:ifln)//'.m95','formatted','old')
        read(95,FormA80) Veta
        M95Imported=EqIgCase(Veta,ImportTextB)
        Veta=fln(:ifln)//'.m97'
        ln=0
        if(ExistFile(Veta)) then
          open(97,file=Veta,form='unformatted',status='unknown',
     1         access='direct',recl=120*RecLenFacUnform,err=1450)
          nrec=1
          read(97,rec=nrec)
          rewind 95
          ln=NextLogicNumber()
          call OpenFile(ln,fln(:ifln)//'.l95','formatted','unknown')
          if(M95Imported) then
1410        read(95,FormA256) t256
            write(ln,FormA1)(t256(i:i),i=1,idel(t256))
            if(EqIgCase(t256,ImportTextE)) then
              go to 1420
            else
              go to 1410
            endif
          endif
1420      call DRGetReflectionFromM95(95,iend,ich)
          if(ich.ne.0) go to 1450
          if(iend.ne.0) go to 1440
          nrec=nrec+1
          read(97,rec=nrec,err=1450)(ihprof(i),i=1,ndim),uhly,rych,
     1      NProf,tmn,tmx,omn,omx,ri,ri,rs,rs,(iprof(i,1),i=1,100)
          isc=NProf/1000+1
          NProf=mod(NProf,1000)
          NBckg=NProf/6
          if(NProf.lt.10.or.NProf.gt.100) go to 1450
          do 1422i=1,NProf
            j=IProf(i,1)
            IProf(i,1)=mod(j,IZdvih)*isc
            IProf(i,2)=j/IZdvih*isc
1422      continue
          call DRPutReflectionToM95(ln)
          go to 1420
1440      call CloseIfOpened(95)
          call CloseIfOpened(ln)
          call MoveFile(fln(:ifln)//'.l95',fln(:ifln)//'.m95',.false.)
1450      call DeleteFile(Veta)
        endif
        call CloseIfOpened(95)
        call CloseIfOpened(ln)
      else
        M95Imported=.false.
      endif
      if(.not.isPowder) then
        if(ExistM91.and.ExistM50) then
          n=0
          HKLF5File=.false.
          pom=0.
          call OpenFile(91,fln(:ifln)//'.m91','formatted','old')
          if(ErrJana.ne.0) go to 1500
1470      read(91,Format91,err=1500,end=1500)(i,j=1,ndim),pomi,poms,
     1                                        i,i,i,pom
          n=n+1
          if(i.lt.0) then
            read(91,Format91,err=1500,end=1500)(i,m=1,ndim),pomn,poms,
     1                                          i,i,i,pom
            if(abs(pomn-pomi).lt..1) HKLF5File=.true.
          else
            if(n.lt.50) go to 1470
          endif
1500      call CloseIfOpened(91)
          TBarPresent=pom.gt..00001
        endif
      endif
      ErrJana=0
      IgnoreE=.false.
      IgnoreW=.false.
      LstOpened=.false.
      MakeCIFForGraphicViewer=.false.
9999  call RewriteTitle(' ')
      call FeBottomInfo(' ')
      return
100   format(i1)
101   format(6i5)
      end
      subroutine SetConstants
      include 'params.cmn'
      include 'basic.cmn'
      include 'fepc.cmn'
      include 'powder.cmn'
      CumulAt(1)=84
      CumulAt(2)=CumulAt(1)+68
      do 1000i=3,9
        j=i-1
        CumulAt(i)=CumulAt(j)+2*TRank(j-2)*mxw
        if(i.eq.3) CumulAt(i)=CumulAt(i)+1
1000  continue
      CumulAt(10)=CumulAt(9)+1
      CumulMol(1)=28
      CumulMol(2)=CumulMol(1)+1+2*mxw
      CumulMol(3)=CumulMol(2)+ 6*mxw
      CumulMol(4)=CumulMol(3)+ 6*mxw
      CumulMol(5)=CumulMol(4)+12*mxw
      CumulMol(6)=CumulMol(5)+12*mxw
      CumulMol(7)=CumulMol(6)+18*mxw
      CumulMol(8)=CumulMol(7)+1
      HistoryFile=RootDir(:idel(RootDir))//'jana2000.hst'
      do 2000i=-500,500
        IdNumbers(i)=i
2000  continue
      IShiftPwd=1
      IBackgPwd=IShiftPwd+3
      IRoughPwd=IBackgPwd+MxBackg
      ICellPwd=IRoughPwd+2
      IQuPwd=ICellPwd+6
      IGaussPwd=IQuPwd+9
      ILorentzPwd=IGaussPwd+4
      IStPwd=ILorentzPwd+5
      IAsymPwd=IStPwd+15
      IPrefPwd=IAsymPwd+12
      IcYes=.true.
      IcNo=.false.
      factorial(0)=1.
      do 3000i=1,20
        factorial(i)=factorial(i-1)*float(i)
3000  continue
      if(GrOn) then
        CrwgXd=FeXPixRound(CrwgXd)
        CrwgYd=FeYPixRound(CrwgYd)
        CrwXd=FeXPixRound(CrwXd)
        CrwYd=FeYPixRound(CrwYd)
        EdwYd=FeYPixRound(EdwYd)
        ButYd=FeYPixRound(ButYd)
        UpDownXd=FeXPixRound(UpDownXd)
        UpDownYd=FeYPixRound(UpDownYd)
        SelwYd=FeYPixRound(SelwYd)
        EdwIndSize=2.*PixelX
        MenuLineWidth=FeYPixRound(MenuLineWidth)
        FrameWidth=3.*PixelX
      endif
      call FeLineType(NormalLine)
      return
      end
      subroutine CoDal(Item,WhatToDo1,WhatToDo2)
      include 'params.cmn'
      include 'basic.cmn'
      include 'main.cmn'
      include 'atoms.cmn'
      include 'molec.cmn'
      include 'fepc.cmn'
      common/subrol/ SubState,xsub,ysub,xdsub,ydsub
      dimension ToolBarX(6)
      character*1  Znak
      character*4  ext(10)
      character*5  ToolBarZ
      character*12 MenuToolBar(5)
      character*14 RolZ(5),SubZ(14,5)
      character*50 RolM(14,5),SubM(14,14,5),t50,p50
      character*80 Veta
      integer WhatToDo1,WhatToDo1P,WhatToDo2,SubState,RolN(5),SubN(14,5)
     1       ,StateToolBarButton(5),Time,FeGetSystemTime,TimeNew
      logical HuraNaTo,RoletaOn,ExistFile,RolA(14,5),SubA(14,14,5),
     1        FeTestIn,NatahniRoletu,MysZaToMuze,EqIgProcenta
      real KartPhaseXMin(5),KartPhaseXMax(5),KartPhaseYMin,KartPhaseYMax
      data MenuToolBar/'%File','%Edit/View','%Run','%Parameters',
     1                 '%Tools'/,StateToolBarButton/5*0/
      data RoletaOn/.false./
      data (RolM(j,1),j=1,14)/'Start s%hell',
     1                        '%Import structure from',
     2                        '%Export structure to',
     3                        '%Structure',
     4                        '%Reflection file',
     6                        'E%xit',
     7                        8*' '/
      data SubM/980*' '/
      data (RolM(j,2),j=1,14)/'Editing of f%ile',
     1                        'Editing of m%40 file',
     2                        'Editing of m4%1 file',
     3                        'Editing of m%50 file',
     4                        'Editing of m%91 file',
     5                        'View of %Refine',
     6                        'View of %Fourier',
     7                        'View of %Dist',
     8                        'View of R%eflection report',
     9                        'View of %CP report',
     a                        'View of In%b report',3*' '/
      data (RolM(j,3),j=1,14)/'D%atRed       CtrlA',
     1                        'Edi%tM50      CtrlT',
     2                        '%EditM40      CtrlE',
     3                        '%Refine       CtrlR',
     4                        '%Fourier      CtrlF',
     5                        '%Contour      CtrlC',
     6                        '%Dist         CtrlD',
     7                        '%Grapht       CtrlG',
     8                        '%SetCommands  CtrlS',
     9                        'S%olution SIR97',4*' '/
      data (RolM(j,4),j=1,14)/'%Options','%Scale','%Twin fractions',
     1                        '%Extinction','%f'',f"','%Powder',
     2                        '%Atoms','%Molecules',6*' '/
      data (RolM(j,5),j=1,14)/'R%ecover files',
     1                        '%Transformations',
     2                        '%Special tools',
     3                        'Po%wder',
     4                        'P%hases',
     5                        'T%opological analysis',
     6                        '%Graphic viewer',
     7                        '%Reciprocal space viewer',
     8                        '%Baymem/Superflip files',
     9                        'Pre%ferences',
     a                        'Sett%ings',
     1                        '%About Jana2000',2*' '/
      data ext/'.m40','.m41','.m50','.m91','.ref','.fou','.dis','.rre',
     1         '.cp','.inb'/
      SubState=0
      call TestUzavreni
      call JanaReset
      if(isPowder) then
        RolM(IdRunExpo,IdRun)='S%olution Expo'
        RolM(IdRunSIR2002,IdRun)='Solution Expo200%4'
        RolM(IdEditM91,IdEdit)='Editing of m%92 file'
        RolM(IdParamTwin,IdParam)='P%hase fractions'
        ext(4)='.m92'
      else
        RolM(IdRunSIR97  ,IdRun)='Solution SIR9%7'
        RolM(IdRunSIR2002,IdRun)='Solution SIR200%2'
        RolM(IdEditM91,IdEdit)='Editing of m%91 file'
        RolM(IdParamTwin,IdParam)='%Twin fractions'
        ext(4)='.m91'
      endif
      SubM(IdFileImportShelx ,IdFileImport,IdFile)=
     1  '%SHELX'
      SubM(IdFileImportCif   ,IdFileImport,IdFile)=
     1  '%CIF'
      SubM(IdFileImportDupals,IdFileImport,IdFile)=
     1  '%DUPALS'
      SubM(IdFileImportXD,IdFileImport,IdFile)=
     1  '%XD'
      SubM(IdFileExportShelx,IdFileExport,IdFile)=
     1  '%SHELX'
      SubM(IdFileExportCif  ,IdFileExport,IdFile)=
     1  '%CIF'
      SubM(IdFileExportHRTEM,IdFileExport,IdFile)=
     1  '%HRTEM'
      SubM(IdFileStructOpen   ,IdFileStruct,IdFile)=
     1  '%Open'
      SubM(IdFileStructHistory,IdFileStruct,IdFile)=
     1  '%History'
      SubM(IdFileStructSaveAs ,IdFileStruct,IdFile)=
     1  '%Save as'
      SubM(IdFileStructCopyIn ,IdFileStruct,IdFile)=
     1  '%Copy in'
      SubM(IdFileStructClose  ,IdFileStruct,IdFile)=
     1  'C%lose'
      if(StructureLocked) then
        SubM(IdFileStructLock   ,IdFileStruct,IdFile)=
     1    'Un%lock'
      else
        SubM(IdFileStructLock   ,IdFileStruct,IdFile)=
     1    '%Lock'
      endif
      SubM(IdFileReflImport   ,IdFileRefl,IdFile)=
     1  'I%mport file(s) from various sources'
      SubM(IdFileReflExcl     ,IdFileRefl,IdFile)=
     1  '%Exclude reflections from m95'
      SubM(IdFileReflSGTest  ,IdFileRefl,IdFile)=
     1  '%Make space group test'
      SubM(IdFileReflCreate   ,IdFileRefl,IdFile)=
     1  '%Create refinement file m91'
      SubM(IdToolsTransCell   ,IdToolsTrans,IdTools)=
     1  '%Cell transformation'
      SubM(IdToolsTransModVec ,IdToolsTrans,IdTools)=
     1  'Change %modulation vector'
      SubM(IdToolsTransShift  ,IdToolsTrans,IdTools)=
     1  '%Origin shift transform'
      SubM(IdToolsTransSubGr  ,IdToolsTrans,IdTools)=
     1  '%Go to subgroup structure'
      SubM(IdToolsTransGoToSup,IdToolsTrans,IdTools)=
     1  'Go to %supercell structure'
      SubM(IdToolsTransGoTo3d ,IdToolsTrans,IdTools)=
     1  'Go to basic-%3d structure'
      SubM(IdToolsSpecialTLS   ,IdToolsSpecial,IdTools)=
     1  'Transform %TLS'
      SubM(IdToolsSpecialTables,IdToolsSpecial,IdTools)=
     1  'T%ables for publication'
      SubM(IdToolsSpecial2dDisp,IdToolsSpecial,IdTools)=
     1  '%2d displacement map'
      if(PowSimOn) then
        SubM(IdToolsSpecialPowSim,IdToolsSpecial,IdTools)=
     1    '%Powder simulation -> OFF'
      else
        SubM(IdToolsSpecialPowSim,IdToolsSpecial,IdTools)=
     1    '%Powder simulation -> ON'
      endif
      SubM(IdToolsSpecialSimStr,IdToolsSpecial,IdTools)=
     1    '%Make simulated structure'
      SubM(IdToolsPhasesNew   ,IdToolsPhases,IdTools)=
     1  '%New phase'
      SubM(IdToolsPhasesDelete,IdToolsPhases,IdTools)=
     1  '%Delete phase'
      SubM(IdToolsPhasesSwitch,IdToolsPhases,IdTools)=
     1  '%Switch phase'
      SubM(IdToolsPowderPlot,IdToolsPowder,IdTools)=
     1  '%Profile viewer'
      SubM(IdToolsPowderLeBail,IdToolsPowder,IdTools)=
     1  'Make Le%Bail'
      SubM(IdToolsPowderSaveBkg,IdToolsPowder,IdTools)=
     1  '%Save background'
      SubM(IdToolsPowderResetPar,IdToolsPowder,IdTools)=
     1  'Reset powder %parameters'
      SubM(IdToolsTplgCP,IdToolsTplg,IdTools)='%Find critical points'
      SubM(IdToolsTplgBasint,IdToolsTplg,IdTools)='%Basin integration'
      if(VasekTest.ne.0) then
        RolM(IdToolsNase,IdTools)='O%ur specialities'
        SubM(IdToolsNaseKuma,IdToolsNase,IdTools)=
     1    '%KUMA procedures'
        SubM(IdToolsNaseBruker,IdToolsNase,IdTools)=
     1    '%Bruker procedures'
        SubM(IdToolsNaseCAD4,IdToolsNase,IdTools)=
     1    '%CAD4 procedures'
        SubM(IdToolsNaseSimulace,IdToolsNase,IdTools)=
     1    '%Lukas''s simulation'
        SubM(IdToolsNaseHonza,IdToolsNase,IdTools)=
     1    'CIF for Jan %Fabry'
        SubM(IdToolsNaseIndexM95,IdToolsNase,IdTools)=
     1    '%Index M9 file'
        SubM(IdToolsNaseTestDiff,IdToolsNase,IdTools)=
     1    '%Test of diffractometer'
        SubM(IdToolsNaseAdHoc,IdToolsNase,IdTools)=
     1    '%Ad-hoc'
        SubM(IdToolsNaseSummary,IdToolsNase,IdTools)=
     1    'S%ummary for Juerg'
        SubM(IdToolsNaseUpDateCifFile,IdToolsNase,IdTools)=
     1    '%Up date of CIF dictionary'
      endif
      if(nmolc.gt.0) then
        do 1100i=1,14
          if(i.gt.nmolc+1) then
            SubM(i,IdParamAtoms,IdParam)=' '
          else
            if(i.eq.1) then
              SubM(i,IdParamAtoms,IdParam)='Atomic part'
            else
              SubM(i,IdParamAtoms,IdParam)=MolName(i-1)
            endif
          endif
1100    continue
      else
        call SetStringArrayTo(SubM(1,IdParamAtoms,IdParam),14,' ')
      endif
      KPhaseOld=-1
      if(.not.GrOn) go to 6000
      if(OpSystem.le.0) then
        DelayForSubMenu=.15
      else
        DelayForSubMenu=.05
      endif
1150  HuraNaTo=.false.
      xpom=210.
      ypom=160.
      do 1400i=1,5
        l=0
        do 1300j=1,14
          call SetLogicalArrayTo(SubA(1,j,i),14,.false.)
          if(RolM(j,i).eq.' ') then
            RolN(i)=l
            go to 1400
          endif
          l=l+1
          RolA(j,i)=.false.
          if(i.eq.IdFile) then
            if((j.eq.IdFileDOS).or.
     1         (j.eq.IdFileImport.and..not.StructureLocked).or.
     2         (j.eq.IdFileExport.and.
     3           (ExistM50.or.ExistM91.or.ExistM95)).or.
     4         (j.eq.IdFileStruct).or.
     5         (j.eq.IdFileRefl.and..not.StructureLocked).or.
     6         (j.eq.IdFileExit)) then
              go to 1270
            else
              go to 1275
            endif
          else if(i.eq.IdEdit) then
            if(j.eq.IdEditFile) then
              go to 1270
            else
              if(.not.ExistFile(fln(:ifln)//ext(j-1)).or.
     1           (j.le.5.and.StructureLocked)) go to 1275
            endif
          else if(i.eq.IdRun) then
            if(j.eq.IdRunDatred) then
              if(isPowder.or.M95Imported.or.
     1           (ExistM91.and..not.ExistM95)) go to 1275
            else if(j.eq.IdRunGrapht) then
              if(ndimi.le.0) go to 1275
            else if(j.eq.IdRunExpo.or.j.eq.IdRunSIR97) then
              if(isPowder) then
                if(CallExpo.eq.' '.or.
     1             .not.ExistFile(DirExpo(:idel(DirExpo))//
     2                            CallExpo(:idel(CallExpo)))) go to 1275
              else
                if(CallSIR97.eq.' '.or.
     1             .not.ExistFile(DirSIR97(:idel(DirSIR97))//
     2                            CallSIR97(:idel(CallSIR97))))
     3            go to 1275
              endif
            else if(j.eq.IdRunSIR2002) then
              if(isPowder) then
                if(CallExpo2004.eq.' '.or.
     1             .not.ExistFile(DirExpo2004(:idel(DirExpo2004))//
     2                            CallExpo2004(:idel(CallExpo2004))))
     3            go to 1275
              else
                if(CallSIR2002.eq.' '.or.
     1             .not.ExistFile(DirSIR2002(:idel(DirSIR2002))//
     2                            CallSIR2002(:idel(CallSIR2002))))
     3            go to 1275
              endif
            endif
          else if(i.eq.IdParam) then
            if((j.eq.IdParamTwin.and.(itwin.le.1.and.NPhase.le.1)).or.
     1         (j.eq.IdParamPowder.and..not.IsPowder).or.
     2         (j.eq.IdParamAtoms.and.nacalc.le.0).or.
     3         (j.eq.IdParamMolec.and.nmolc.le.0)) go to 1275
          else if(i.eq.IdTools) then
            if(j.eq.IdToolsRecover) then
              if(.not.ExistFile(fln(:ifln)//'.s40').or.
     1           StructureLocked) go to 1275
            else if(j.eq.IdToolsPowder) then
              if(.not.isPowder) go to 1275
            else if(j.eq.IdToolsPhases) then
              if(StructureLocked) go to 1275
            else if(j.eq.IdToolsTplg) then
              if(.not.ChargeDensities) go to 1275
            else if(j.eq.IdToolsRecipW) then
              if(isPowder) go to 1275
            else if(j.eq.IdToolsGraphW) then
              if(CallGraphic.eq.' '.or.nacalc.le.0) go to 1275
            endif
          endif
1270      RolA(j,i)=.true.
1275      n=0
          do 1280k=1,14
            if(SubM(k,j,i).eq.' ') then
              SubN(j,i)=n
              go to 1300
            endif
            n=n+1
            if(.not.RolA(j,i)) go to 1280
            if(i.eq.IdFile) then
              if(j.eq.IdFileImport) then
                if(k.eq.IdFileImportShelx.and.ndimi.gt.0) go to 1280
              else if(j.eq.IdFileExport) then
                if((k.eq.IdFileExportShelx.and.ndimi.gt.0).or.
     1             (k.eq.IdFileExportCIF.and..not.ExistM50).or.
     2             (k.eq.IdFileExportHRTEM.and..not.ExistM50))
     3          go to 1280
              else if(j.eq.IdFileStruct) then
                if((k.eq.IdFileStructHistory.and.
     1              .not.ExistFile(HistoryFile)).or.
     2             (k.eq.IdFileStructSaveAs.and..not.ExistM50.and.
     3                                     .not.ExistM94).or.
     4             (k.eq.IdFileStructCopyIn.and.StructureLocked))
     5          go to 1280
              else if(j.eq.IdFileRefl) then
                if(StructureLocked) go to 1280
                if((k.eq.IdFileReflImport.and.
     1              ((.not.M95Imported.and.ExistM95).or.
     2                .not.ExistM50)).or.
     3             (k.eq.IdFileReflSGTest.and.isPowder).or.
     4             (k.eq.IdFileReflExcl.and..not.ExistM95).or.
     5             (k.eq.IdFileReflCreate.and.(.not.ExistM95.or.
     6              .not.ExistM50))) go to 1280
              endif
            else if(i.eq.IdTools) then
              if(j.eq.IdToolsTrans) then
                if(.not.ExistM50.or.
     1             (k.eq.IdToolsTransGoToSup.and.kcommen.le.0).or.
     2             ((k.eq.IdToolsTransModVec.or.
     3               k.eq.IdToolsTransGoTo3d).and.ndimi.le.0).or.
     4             ((k.eq.IdToolsTransModVec.or.
     5               k.eq.IdToolsTransCell).and.StructureLocked))
     6            go to 1280
              else if(j.eq.IdToolsSpecial) then
                if(k.eq.IdToolsSpecialTLS) then
                  do 1250m=1,nmolc
                    if(ktls(m).gt.0) go to 1278
1250              continue
                  go to 1280
                else if(k.eq.IdToolsSpecial2dDisp) then
                  if(ndimi.ne.1) go to 1280
                else if(k.eq.IdToolsSpecialSimStr) then
                  if(.not.ExistM40.or..not.ExistM50) go to 1280
                else if(k.eq.IdToolsSpecialPowSim) then
                  if(isPowder.neqv.PowSimOn) go to 1280
                endif
              else if(j.eq.IdToolsPowder) then
                if(.not.isPowder) go to 1280
                if((k.eq.IdToolsPowderResetPar.and.NPhase.le.1)) then
                  go to 1280
                endif
              else if(j.eq.IdToolsPhases) then
                if(((k.eq.IdToolsPhasesDelete.or.
     1              k.eq.IdToolsPhasesSwitch).and.NPhase.le.1).or.
     2             StructureLocked) go to 1280
              endif
            endif
1278        SubA(k,j,i)=.true.
1280      continue
          SubN(j,i)=14
1300    continue
        RolN(i)=14
1400  continue
      do 3020i=1,9
        j=0
        call kus(RolM(i,3),j,t50)
        call FeIkonOpen(i,xpom,ypom,IkonXLength,IkonYLength,t50)
        if((i.eq.8.and.ndimi.le.0).or.
     1     (i.eq.1.and.(isPowder.or.M95Imported.or.
     2      (ExistM91.and..not.ExistM95)))) call FeIkonDisable(i)
        ypom=ypom-40.
        if(i.eq.4) then
          yp=ypom+40.
          xpom=xpom+40.
          ypom=160.
        else if(i.eq.8) then
          ypom=ypom+40.
          xpom=20.
        endif
3020  continue
      RolZ(3)=' '
      do 3030i=1,9
        if(i.eq.8.and.ndimi.eq.0) go to 3030
        j=index(RolM(i,3),'%')
        if(j.ne.0) RolZ(3)(i:i)=RolM(i,3)(j+1:j+1)
3030  continue
      call mala(RolZ(3))
      xpom=FeXPixRound(5.)
      xp=FeXPixRound(FeTxLength('XXXXXXXX')+5.)
      KartPhaseYMin=YMinGrWin
      KartPhaseYMax=FeYPixRound(YMinGrWin+8.)
      do 3040i=1,NPhase
        KartPhaseXMin(i)=xpom
        xpom=FeXPixRound(xpom+xp)
        KartPhaseXMax(i)=FeXPixRound(xpom-PixelX)
3040  continue
      TriPixely=3.*PixelX
      yd=FeYPixRound(8.)
      call FeFillRectangle(XMinBasWin,XMaxBasWin,YMaxBasWin,
     1                     YMaxBasWin-yd,4,0,0,LightGray)
      yp=FeYPixRound(YMaxBasWin-yd)
      ypd=FeYPixRound(YMaxBasWin)
      xp=FeXPixRound(XMinBasWin+3.)
      ypom=FeYPixRound((yp+ypd)*.5)
      xpom=xp
      do 3050i=1,5
        ToolBarX(i)=xpom
        xpom=xpom+3.
        call FeWrMenuItem(xpom,ypom,-1.,MenuToolBar(i),ToolBarZ(i:i),
     1                    Black,0)
        xpom=xpom+FeXPixRound(FeTxLengthUnder(MenuToolBar(i))+3.)
3050  continue
      ToolBarX(6)=xpom
3070  DoubleClickAllowed=.true.
      AllowChangeMouse=.false.
      TakeMouseMove=.true.
      call FeMouseShape(0)
      Item=0
      WhatToDo1=0
      WhatToDo1P=0
      WhatToDo2=0
      ItemNew=0
      NatahniRoletu=.false.
      MysZaToMuze=.false.
3100  VolaToCoDal=.true.
3105  if(KPhase.ne.KPhaseOld.and.NPhase.gt.1) then
        call FeDeferOutput
        call FeFillRectangle(KartPhaseXMin(1)-TriPixely,
     1                       KartPhaseXMax(NPhase)+TriPixely,
     2                       KartPhaseYMin,
     3                       KartPhaseYMax+TriPixely,4,0,0,Black)
        do 3108i=1,NPhase
          if(i.eq.KPhase) go to 3108
          call FeDrawSwitch(KartPhaseXMin(i),KartPhaseXMax(i),
     1                      KartPhaseYMin,KartPhaseYMax,2)
          call FeOutSt(0,
     1      KartPhaseXMin(i)+.5*(KartPhaseXMax(i)-KartPhaseXMin(i)),
     2      KartPhaseYMin+.5*(KartPhaseYMax-KartPhaseYMin),
     3      PhaseName(i),'C',Gray)
3108    continue
        call FeDrawSwitch(KartPhaseXMin(KPhase)-TriPixely,
     1                    KartPhaseXMax(KPhase)+TriPixely,
     2                    KartPhaseYMin,KartPhaseYMax+TriPixely,2)
        call FeOutSt(0,KartPhaseXMin(KPhase)+
     1               .5*(KartPhaseXMax(KPhase)-KartPhaseXMin(KPhase)),
     2               KartPhaseYMin+.5*(KartPhaseYMax-KartPhaseYMin)+
     3               2.*PixelX,PhaseName(KPhase),'C',Black)
        KPhaseOld=KPhase
        go to 1150
      endif
3110  call FeEvent(0)
3120  if(DelejResize) then
        if(.not.DockalSeConf) go to 3105
        call FeDelejResize
        if(Resized) then
          Resized=.false.
          go to 1150
        endif
        go to 3100
      endif
      VolaToCoDal=.false.
      if(EventType.eq.EventIkon.and..not.RoletaOn) then
        call FeIkonOn(EventNumber)
        if(WhatToDo1P.ne.EventNumber.and.WhatToDo1P.gt.0)
     1    call FeIkonOff(WhatToDo1P)
        WhatToDo1P=EventNumber
        ItemNew=0
        go to 4010
      else if(EventType.eq.EventMouse.and.EventNumber.eq.JeRightDown)
     1  then
        WhatToDo2=0
        if(FeTestIn()) then
          if(EventType.eq.EventIkon) then
            if(EventNumber.eq.4) then
              WhatToDo2=1
            else if(EventNumber.eq.5) then
              WhatToDo2=2
            else if(EventNumber.eq.7) then
              WhatToDo2=3
            else
              go to 3100
            endif
          endif
        endif
        if(WhatToDo2.eq.0) then
          Item=IdRun
          WhatToDo1=IdRunEditm40
        else
          WhatToDo1=9
          Item=3
        endif
        HuraNaTo=.true.
      else if(EventType.eq.EventMouse.and.(EventNumber.eq.JeLeftDown.or.
     1        EventNumber.eq.JeLeftUp.or.EventNumber.eq.JeMove)) then
        if(EventNumber.eq.JeMove.and.
     1    SubState.ne.0.and.WhatToDo2.eq.0) then
          Time=FeGetSystemTime()
3130      call FeEvent(1)
          if(EventType.eq.0.or.
     1      (EventType.eq.EventMouse.and.EventNumber.eq.JeMove)) then
            TimeNew=FeGetSystemTime()
            if(float(TimeNew-Time)/1000..lt.DelayForSubMenu)
     1        then
              call Roleta(xp,yp,
     1                    i,RolM(1,Item),RolZ(Item),RolA(1,Item),
     2                    RolN(Item),
     3                    j,SubM(1,1,Item),SubZ(1,Item),SubA(1,1,Item),
     4                    SubN(1,Item),'check')
              if(i.eq.WhatToDo1) Time=TimeNew
              go to 3130
            else
              EventType=EventMouse
              EventNumber=JeMove
            endif
          else
            go to 3120
          endif
        endif
        if(EventNumber.eq.JeLeftDown.and.WhatToDo1P.ne.0) then
          call FeIkonOff(WhatToDo1P)
          WhatToDo1P=0
        endif
        if(EventNumber.eq.JeLeftDown.or.EventNumber.eq.JeLeftUp)
     1    ItemNew=0
        if(Ypos.ge.yp.and.Ypos.le.yp+yd.and.Xpos.ge.ToolBarX(1).and.
     1     Xpos.le.ToolBarX(6)) then
          do 3200ItemNew=1,5
            if(Xpos.lt.ToolBarX(ItemNew+1)) then
              MysZaToMuze=.true.
              if(WhatToDo1P.ne.0) then
                call FeIkonOff(WhatToDo1P)
                WhatToDo1P=0
              endif
              if(EventNumber.eq.JeLeftUp.and.RoletaOn) then
                NatahniRoletu=nLeftDown.eq.0
                nLeftDown=nLeftDown+1
              else if(EventNumber.eq.JeLeftDown) then
                NatahniRoletu=.true.
                if(.not.RoletaOn) nLeftDown=0
              else if(EventNumber.eq.JeMove) then
                if(ItemNew.eq.Item) then
                  go to 3100
                else
                  if(Item.ne.0) then
                    if(StateToolBarButton(Item).eq.1) then
                      go to 4000
                    else if(StateToolBarButton(Item).eq.-1) then
                      xp1=ToolBarX(Item)
                      xp2=ToolBarX(Item+1)
                      call FeToolBarButton(xp1,xp2,yp,ypd,
     1                                     MenuToolBar(Item),
     2                                     StateToolBarButton(Item),0)
                    endif
                  endif
                  xp1=ToolBarX(ItemNew)
                  xp2=ToolBarX(ItemNew+1)
                  call FeToolBarButton(xp1,xp2,yp,ypd,
     1                                 MenuToolBar(ItemNew),
     2                                 StateToolBarButton(ItemNew),-1)
                  Item=ItemNew
                  go to 3100
                endif
              endif
              go to 4000
            endif
3200      continue
        else if(Item.ne.0) then
          if(RoletaOn) then
            call Roleta(xp,yp,
     1                  WhatToDo1,RolM(1,Item),RolZ(Item),RolA(1,Item),
     2                  RolN(Item),
     3                  WhatToDo2,SubM(1,1,Item),SubZ(1,Item),
     4                  SubA(1,1,Item), SubN(1,Item),
     5                  'test')
            HuraNaTo=ItemNew.eq.0.and.WhatToDo1.ne.0
            if(HuraNaTo) then
              HuraNaTo=RolA(WhatToDo1,Item)
              if(HuraNaTo) then
                if(SubN(WhatToDo1,Item).gt.0) then
                   HuraNaTo=WhatToDo2.gt.0
                   if(HuraNaTo) HuraNaTo=SubA(WhatToDo2,WhatToDo1,Item)
                endif
              endif
            endif
            if(.not.HuraNaTo.and.(EventNumber.eq.JeLeftUp.or.
     1                            EventNumber.eq.JeLeftDown).and.
     2                            WhatToDo1.gt.0.and.
     3                            WhatToDo2.ge.0) then
              ItemNew=Item
              DoubleClickCount=0
              go to 3100
            endif
          else
            if(MysZaToMuze) then
              ItemNew=0
              NatahniRoletu=.false.
            else
              go to 3100
            endif
          endif
        else
3300      if(EventNumber.eq.JeLeftDown.and.
     1       YPos.ge.KartPhaseYMin.and.YPos.le.KartPhaseYMax.and.
     2       XPos.ge.KartPhaseXMin(1).and.XPos.le.KartPhaseXMax(NPhase))
     3      then
            do 3310KPh=1,NPhase
              if(XPos.lt.KartPhaseXMax(KPh)) go to 3340
3310        continue
            KPh=NPhase
3340        call RestorePhase(KPh)
          endif
          KPhaseBasic=KPhase
          go to 3100
        endif
      else if(EventType.eq.EventKey.and.(EventNumber.eq.JeUp.or.
     1                                   EventNumber.eq.JeDown)) then
        if(Item.ne.0) then
          if(WhatToDo2.eq.0) then
            if(.not.RoletaOn) then
              if(EventNumber.eq.JeUp) then
                WhatToDo1=RolN(Item)
              else
                WhatToDo1=1
              endif
              ItemNew=Item
              NatahniRoletu=.true.
              go to 4000
            endif
            if(EventNumber.eq.JeUp) then
              WhatToDo1=mod(WhatToDo1-2+RolN(Item),
     1                      RolN(Item))+1
            else
              WhatToDo1=mod(WhatToDo1,RolN(Item))+1
            endif
          else
            if(EventNumber.eq.JeUp) then
              WhatToDo2=mod(WhatToDo2-2+SubN(WhatToDo1,Item),
     1                      SubN(WhatToDo2,Item))+1
            else
              WhatToDo2=mod(WhatToDo2,SubN(WhatToDo1,Item))+1
            endif
          endif
          call Roleta(ToolBarX(Item),yp-2.*PixelY,
     1                WhatToDo1,RolM(1,Item),RolZ(Item),RolA(1,Item),
     2                RolN(Item),
     3                WhatToDo2,SubM(1,1,Item),SubZ(1,Item),
     4                SubA(1,1,Item), SubN(1,Item),
     5                'switch')
        else if(WhatToDo1P.ne.0) then
          if(EventNumber.eq.JeUp.and.WhatToDo1P.ne.1) then
            i=WhatToDo1P-1
          else if(EventNumber.eq.JeDown.and.WhatToDo1P.ne.8) then
            i=WhatToDo1P+1
          else
            i=0
          endif
          if(i.ne.0) then
            call FeIkonOff(WhatToDo1P)
            WhatToDo1P=i
            call FeIkonOn(WhatToDo1P)
            go to 3100
          endif
        endif
      else if(EventType.eq.EventMouse.and.EventNumber.eq.JeDoubleClick)
     1  then
        if(WhatToDo1P.gt.0) then
          if(xpos.ge.IkonXmin(WhatToDo1P).and.
     1       xpos.le.IkonXmax(WhatToDo1P).and.
     2       ypos.ge.IkonYmin(WhatToDo1P).and.
     3       ypos.le.IkonYmax(WhatToDo1P)) then
            call FeWait(.1)
            Item=3
            WhatToDo1=WhatToDo1P
            HuraNaTo=.true.
          else
            go to 3100
          endif
        else
          go to 3100
        endif
      else if(EventType.eq.EventKey.and.EventNumber.eq.JeReturn) then
        if(Item.ne.0.and.WhatToDo1.ne.0) then
          if(RolA(WhatToDo1,Item)) then
            HuraNaTo=.true.
            ItemNew=0
          endif
        else
          if(WhatToDo1P.ne.0) then
            Item=3
            WhatToDo1=WhatToDo1P
            HuraNaTo=.true.
          endif
        endif
      else if(EventType.eq.EventKey.and.EventNumber.eq.JeEscape) then
        if(ItemNew.ne.0) then
          if(StateToolBarButton(ItemNew).eq.1) then
            NatahniRoletu=.false.
          else
            ItemNew=0
          endif
        endif
      else if(EventType.eq.EventKey.and.EventNumber.eq.JeLeft) then
        if(Item.ne.0) then
          if(SubState.ne.0.and.WhatToDo2.ne.0) then
            WhatToDo2=0
            call Roleta(ToolBarX(Item),yp-2.*PixelY,
     1                  WhatToDo1,RolM(1,Item),RolZ(Item),RolA(1,Item),
     2                  RolN(Item),
     3                  WhatToDo2,SubM(1,1,Item),SubZ(1,Item),
     4                  SubA(1,1,Item), SubN(1,Item),
     5                  'switch')
          else
            ItemNew=mod(Item+3,5)+1
            WhatToDo1=1
          endif
        endif
      else if(EventType.eq.EventKey.and.EventNumber.eq.JeRight) then
        if(Item.gt.0) then
          if(SubState.ne.0.and.WhatToDo2.eq.0) then
            WhatToDo2=1
            call Roleta(ToolBarX(Item),yp-2.*PixelY,
     1                  WhatToDo1,RolM(1,Item),RolZ(Item),RolA(1,Item),
     2                  RolN(Item),
     3                  WhatToDo2,SubM(1,1,Item),SubZ(1,Item),
     4                  SubA(1,1,Item), SubN(1,Item),
     5                  'switch')
          else
            ItemNew=mod(Item,5)+1
            WhatToDo1=1
          endif
        endif
      else if(EventType.eq.EventASCII) then
        if(Item.ne.0) then
          Znak=char(EventNumber)
          call mala(Znak)
          if(SubState.eq.0) then
            i=index(RolZ(Item),Znak)
            if(i.ne.0) then
              if(SubN(i,Item).le.0) then
                if(RolA(i,item)) then
                  WhatToDo1=i
                  HuraNaTo=.true.
                  ItemNew=0
                endif
              else
                WhatToDo1=i
                WhatToDo2=1
                call Roleta(ToolBarX(Item),yp-2.*PixelY,
     1                      WhatToDo1,RolM(1,Item),RolZ(Item),
     2                      RolA(1,Item),RolN(Item),
     3                      WhatToDo2,SubM(1,1,Item),SubZ(1,Item),
     4                      SubA(1,1,Item), SubN(1,Item),
     5                      'switch')
              endif
            endif
          else
            i=index(SubZ(WhatToDo1,Item),Znak)
            if(i.ne.0) then
              if(SubA(i,WhatToDo1,Item)) then
                WhatToDo2=i
                HuraNaTo=.true.
                ItemNew=0
              endif
            endif
          endif
        else
          go to 3100
        endif
      else if(EventType.eq.EventAlt) then
        MysZaToMuze=.false.
        Znak=char(EventNumber)
        call mala(Znak)
        i=index(ToolBarZ,Znak)
        if(i.ne.0) ItemNew=i
        WhatToDo1=1
        NatahniRoletu=.true.
      else if(EventType.eq.EventCtrl) then
        Znak=char(EventNumber)
        call mala(Znak)
        i=index(RolZ(3),Znak)
c        if(i.le.0) then
c          if(Znak.eq.'k') then
c            i=15
c          else if(Znak.eq.'b') then
c            i=16
c          else if(Znak.eq.'z') then
c            i=17
c          else if(Znak.eq.'l') then
c            i=18
c          else if(Znak.eq.'u') then
c            i=19
c          else if(Znak.eq.'o') then
c            i=20
c          else if(Znak.eq.'v') then
c            i=21
c          endif
c        endif
        if(i.ne.0) then
          ItemNew=0
          Item=3
          WhatToDo1=i
          HuraNaTo=.true.
        else
          go to 3100
        endif
      else if(EventType.eq.EventResize) then
        go to 3100
      else
        go to 3100
      endif
4000  DoubleClickCount=0
4010  if(Item.ne.0.and.(ItemNew.ne.Item.or..not.NatahniRoletu)) then
        xp1=ToolBarX(Item)
        xp2=ToolBarX(Item+1)
        if(RoletaOn) then
          i=WhatToDo1
          j=WhatToDo2
          call Roleta(xp1,yp-2.*PixelY,
     1                WhatToDo1,RolM(1,Item),RolZ(Item),RolA(1,Item),
     2                RolN(Item),
     3                WhatToDo2,SubM(1,1,Item),SubZ(1,Item),
     4                SubA(1,1,Item), SubN(1,Item),
     5                'remove')
          if(HuraNaTo) then
            WhatToDo1=i
            WhatToDo2=j
          endif
          RoletaOn=.false.
        endif
        call FeToolBarButton(xp1,xp2,yp,ypd,MenuToolBar(Item),
     1                       StateToolBarButton(Item),0)
      endif
      if(HuraNaTo) go to 5000
      if(ItemNew.ne.0) then
        xp1=ToolBarX(ItemNew)
        xp2=ToolBarX(ItemNew+1)
        if(NatahniRoletu) then
          if(.not.RoletaOn.or.ItemNew.ne.Item) then
            call Roleta(xp1,yp-2.*PixelY,
     1                  WhatToDo1,RolM(1,ItemNew),RolZ(ItemNew),
     2                  RolA(1,ItemNew),RolN(ItemNew),WhatToDo2,
     3                  SubM(1,1,ItemNew),SubZ(1,ItemNew),
     3                  SubA(1,1,ItemNew),SubN(1,ItemNew),'create')
            RoletaOn=.true.
          endif
          k=1
        else
          RoletaOn=.false.
          k=-1
        endif
        call FeToolBarButton(xp1,xp2,yp,ypd,MenuToolBar(ItemNew),
     1                       StateToolBarButton(ItemNew),k)
      endif
      Item=ItemNew
      if(Item.le.0) WhatToDo1=0
      go to 3100
5000  call JanaReset
      call FeDeferOutput
      if(WrongM40.or.WrongM41.or.WrongM50) then
        if(Item.ne.IdFile.and.Item.ne.IdEdit.and.
     1     (Item.ne.IdTools.or.
     2      (WhatToDo1.ne.IdToolsRecover.and.
     3       WhatToDo1.ne.IdToolsAbout.and.
     4       WhatToDo1.ne.IdToolsPref))) then
          NInfo=3
          if(WrongM40) then
            Veta='M40'
          else if(WrongM41) then
            Veta='M41'
          else
            Veta='M50'
          endif
          TextInfo(1)='Due to the previous error which has occured '//
     1                'during reading '//Veta(1:3)
          TextInfo(2)='only "File", "Edit" or  "Tools->Recover" '//
     1                'commands can be used'
          TextInfo(3)='to correct error(s) or change the structure.'
          call FeInfoOut(-1.,-1.,'WARNING')
          do 5010i=1,9
            call FeIkonOff(i)
5010      continue
          HuraNaTo=.false.
          go to 3070
        endif
      endif
      do 5100i=1,9
        call FeIkonRemove(i)
5100  continue
      call FeMakeGrWin(0.,0.,14.,0.)
      call FeReleaseOutput
      call FeDeferOutput
      TakeMouseMove=.false.
      DoubleClickAllowed=.false.
      AllowChangeMouse=.true.
      go to 8000
6000  read(BatchLN,FormA80,err=6500,end=6500) Veta
      i=index(Veta,'->')
      if(i.ne.0) then
        do 6010Item=1,5
          if(EqIgProcenta(Veta(:i-1),MenuToolBar(Item))) go to 6020
6010    continue
      else
        go to 6000
      endif
6020  Veta=Veta(i+2:)
      i=index(Veta,'->')
      if(i.gt.0) then
        t50=Veta(:i-1)
        Veta=Veta(i+2:)
      else
        t50=Veta
        Veta=' '
      endif
      do 6100WhatToDo1=1,14
        if(Item.eq.IdRun) then
          k=0
          call Kus(RolM(WhatToDo1,Item),k,p50)
        else
          p50=RolM(WhatToDo1,Item)
        endif
        if(p50.eq.' ') go to 6100
        if(EqIgProcenta(t50,p50)) go to 6200
6100  continue
      go to 6000
6200  WhatToDo2=0
      if(Veta.ne.' ') then
        t50=Veta
        do 6300WhatToDo2=1,14
          p50=SubM(WhatToDo2,WhatToDo1,Item)
          if(p50.eq.' ') go to 6300
          if(EqIgProcenta(p50,t50)) go to 8000
6300    continue
      else
        go to 8000
      endif
      go to 6000
6500  call DeletePomFiles
      stop
8000  if(.not.ChargeDensities.and.lasmaxm.gt.0) then
        call FeChybne(-1.,-1.,'the inconsistency of M40 and m50',
     1                'M40 for charge densities, but M50 not',0,
     2                SeriousError)
        if(Item.ge.3) then
          if(GrOn) then
            go to 1150
          else
            go to 6000
          endif
        endif
      endif
      return
      end
      subroutine Roleta(x,y,
     1                  RolI,RolM,RolZ,RolA,RolN,
     2                  SubI,SubM,SubZ,SubA,SubN,
     3                  Action)
      include 'params.cmn'
      include 'basic.cmn'
      include 'fepc.cmn'
      integer RolN,SubN(14),RolI,RolIo,SubI,SubIo,Color1,Color2
      character*(*) RolM(RolN),action,RolZ,SubM(14,RolN),SubZ(14)
      logical RolA(RolN),SubA(14,RolN)
      common/subrol/ SubState,xsub,ysub,xdsub,ydsub
      integer SubState
      save xrol,xdrol,yrol,ydrol,RolIo,SubIo
      data RolIo/0/
      if(Action.eq.'create') then
        call FeDeferOutput
        xrol=x+2.*PixelX
        yrol=y-2.*PixelY
        ydrol=FeYPixRound(float(RolN)*MenuLineWidth)
        xdrol=0.
        xpom=5.
        do 1000i=1,RolN
          if(SubN(i).gt.0) xpom=10.
          xdrol=max(FeTxLengthUnder(RolM(i)),xdrol)
1000    continue
        xdrol=FeXPixRound(xdrol+xpom)
        call FeSaveImage(xrol-2.*PixelX,xrol+xdrol+2.*PixelX,
     1                   yrol-ydrol-2.*PixelY,yrol+2.*PixelY,
     2                   'roleta.bmp')
        call FeDrawFrame(xrol,yrol-ydrol,xdrol,ydrol,2.*PixelX,Gray,
     1                   White,Black,.false.)
        call FeFillRectangle(xrol,xrol+xdrol,yrol,yrol-ydrol,4,0,0,
     1                       LightGray)
        ypom=yrol
        do 1100i=1,RolN
          if(RolA(i)) then
            if(i.eq.RolI) then
              Color1=White
              Color2=Blue
              k=1
            else
              Color1=Black
              Color2=LightGray
              k=0
            endif
          else
            if(i.eq.RolI) then
              Color1=Gray
              Color2=Blue
              k=1
            else
              Color1=WhiteGray
              Color2=LightGray
              k=0
            endif
          endif
          call FeWrMenuItemO(xrol,ypom,xdrol,RolM(i),RolZ(i:i),
     1                       SubM(1,i),SubZ(i),SubA(1,i),SubN(i),
     2                       Color1,Color2,k)
          if(VasekTest.eq.1.and.index(RolZ(:i-1),RolZ(i:i)).gt.0) then
            EdwString(1)='Duplicate identification : '//RolZ
            call FeMsgOut(-1.,-1.,EdwString(1))
          endif
          ypom=ypom-MenuLineWidth
1100    continue
      else if(Action.eq.'remove') then
        call FeDeferOutput
        if(SubState.eq.1) then
          call FeLoadImage(xsub-2.*PixelX,xsub+xdsub+2.*PixelX,
     1                     ysub-ydsub-2.*PixelY,ysub+2.*PixelY,
     2                     'subrol.bmp',0)
          SubState=0
        endif
        call FeLoadImage(xrol-2.*PixelX,xrol+xdrol+2.*PixelX,
     1                   yrol-ydrol-2.*PixelY,yrol+2.*PixelY,
     2                   'roleta.bmp',0)
        RolI=0
        SubI=0
      else if(Action.eq.'test') then
        if(RolI.gt.0.and.SubState.ne.0) then
          if(Xpos.ge.xsub.and.Xpos.le.xsub+xdsub.and.
     1       Ypos.ge.ysub-ydsub.and.Ypos.le.ysub) then
            l=min(ifix((ysub-Ypos)/MenuLineWidth)+1,SubN(RolI))
          else if(Xpos.ge.xrol.and.Xpos.le.xrol+xdrol.and.
     1            Ypos.le.yrol.and.Ypos.ge.yrol-ydrol) then
            l=0
          else
            l=-1
          endif
          if(l.ne.SubI) then
            call FeDeferOutput
            if(SubI.gt.0) then
              if(SubA(SubI,RolI)) then
                Color1=Black
                Color2=LightGray
              else
                Color1=WhiteGray
                Color2=LightGray
              endif
              call FeWrMenuItem(xsub,ysub-float(SubI-1)*MenuLineWidth,
     1                          xdsub,SubM(SubI,RolI),
     2                          SubZ(RolI)(SubI:SubI),
     3                          Color1,Color2)
            endif
            if(l.gt.0) then
              if(SubA(l,RolI)) then
                Color1=White
                Color2=Blue
              else
                Color1=Gray
                Color2=Blue
              endif
              call FeWrMenuItem(xsub,ysub-float(l-1)*MenuLineWidth,
     1                          xdsub,SubM(l,RolI),SubZ(RolI)(l:l),
     2                          Color1,Color2)
            endif
          endif
          SubI=l
        endif
        if(Xpos.ge.xrol.and.Xpos.le.xrol+xdrol.and.
     1     Ypos.le.yrol.and.Ypos.ge.yrol-ydrol) then
          i=min(ifix((yrol-Ypos)/MenuLineWidth)+1,RolN)
        else if(SubState.eq.0) then
          i=0
        else
          i=RolI
        endif
        if(i.ne.RolI.and.SubI.eq.0) then
          call FeDeferOutput
          if(RolI.gt.0) then
            if(RolA(RolI)) then
              Color1=Black
              Color2=LightGray
            else
              Color1=WhiteGray
              Color2=LightGray
            endif
            call FeWrMenuItemO(xrol,yrol-float(RolI-1)*MenuLineWidth,
     1                         xdrol,
     2                         RolM(RolI),RolZ(RolI:RolI),
     3                         SubM(1,RolI),SubZ(RolI),SubA(1,RolI),
     4                         SubN(RolI),Color1,Color2,-1)
          endif
          if(i.gt.0) then
            if(RolA(i)) then
              Color1=White
              Color2=Blue
            else
              Color1=Gray
              Color2=Blue
            endif
            call FeWrMenuItemO(xrol,yrol-float(i-1)*MenuLineWidth,
     1                         xdrol,
     2                         RolM(i),RolZ(i:i),
     3                         SubM(1,i),SubZ(i),SubA(1,i),
     4                         SubN(i),Color1,Color2,1)
          endif
          RolI=i
        endif
      else if(Action.eq.'check') then
        if(Xpos.ge.xrol.and.Xpos.le.xrol+xdrol.and.
     1     Ypos.le.yrol.and.Ypos.ge.yrol-ydrol) then
          RolI=min(ifix((yrol-Ypos)/MenuLineWidth)+1,RolN)
        else
          RolI=0
        endif
        go to 9999
      else if(Action.eq.'switch') then
        if(RolIo.ne.RolI) then
          call FeDeferOutput
          if(RolIo.gt.0) then
            if(RolA(RolIo)) then
              Color1=Black
              Color2=LightGray
            else
              Color1=WhiteGray
              Color2=LightGray
            endif
            call FeWrMenuItemO(xrol,yrol-float(RolIo-1)*MenuLineWidth,
     1                         xdrol,
     2                         RolM(RolIo),RolZ(RolIo:RolIo),
     3                         SubM(1,RolIo),SubZ(RolIo),
     4                         SubA(1,RolIo),SubN(RolIo),Color1,Color2,
     5                         -1)
          endif
          if(RolI.gt.0) then
            if(RolA(RolI)) then
              Color1=White
              Color2=Blue
            else
              Color1=Gray
              Color2=Blue
            endif
            call FeWrMenuItemO(xrol,yrol-float(RolI-1)*MenuLineWidth,
     1                         xdrol,
     2                         RolM(RolI),RolZ(RolI:RolI),
     3                         SubM(1,RolI),SubZ(RolI),
     4                         SubA(1,RolI),SubN(RolI),Color1,Color2,1)
          endif
        else if(SubIo.ne.SubI) then
          call FeDeferOutput
          if(SubIo.gt.0) then
            if(SubA(SubIo,RolI)) then
              Color1=Black
              Color2=LightGray
            else
              Color1=WhiteGray
              Color2=LightGray
            endif
            call FeWrMenuItem(xsub,ysub-float(SubIo-1)*MenuLineWidth,
     1                        xdsub,
     2                        SubM(SubIo,RolI),SubZ(RolI)(SubIo:SubIo),
     3                        Color1,Color2)
          endif
          if(SubI.gt.0) then
            if(SubA(SubI,RolI)) then
              Color1=White
              Color2=Blue
            else
              Color1=Gray
              Color2=Blue
            endif
            call FeWrMenuItem(xsub,ysub-float(SubI-1)*MenuLineWidth,
     1                        xdsub,
     2                        SubM(SubI,RolI),SubZ(RolI)(SubI:SubI),
     3                        Color1,Color2)
          endif
        endif
      endif
      RolIo=RolI
      SubIo=SubI
9999  return
      end
      subroutine FeWrMenuItemO(x,y,xd,Veta,StFlag,SubM,SubZ,SubA,SubN,
     1                         TextColor,BackGroundColor,klic)
      include 'params.cmn'
      include 'basic.cmn'
      include 'fepc.cmn'
      common/subrol/ SubState,xsub,ysub,xdsub,ydsub
      integer SubState,SubN
      character*(*) Veta,SubM(SubN),SubZ
      character*1 StFlag
      integer TextColor,BackGroundColor
      logical SubA(SubN)
      if(SubN.gt.0.and.klic.eq.1) then
        xsub=x+xd-1.+2.*PixelX
        ysub=y
        ydsub=FeYPixRound(float(SubN)*MenuLineWidth)
        xdsub=0.
        do 1000i=1,SubN
          xdsub=max(FeTxLengthUnder(SubM(i))+5.,xdsub)
1000    continue
        xdsub=FeXPixRound(xdsub)
        call FeSaveImage(xsub-2.*PixelX,xsub+xdsub+2.*PixelX,
     1                   ysub-ydsub-2.*PixelY,ysub+2.*PixelY,
     2                   'subrol.bmp')
      endif
      call FeFillRectangle(x,x+xd,y,y-MenuLineWidth,4,0,0,
     1                     BackGroundcolor)
      xpom=x+3.
      ypom=y-MenuLineWidth*.5
      call FeOutStUnder(0,xpom,ypom,Veta,'L',TextColor,TextColor,StFlag)
      if(SubN.gt.0) then
        yu(1)=ypom
        yu(2)=ypom-1.5
        yu(3)=ypom+1.5
        xu(1)=x+xd-1.5
        xu(2)=xu(1)-2.
        xu(3)=xu(2)
        call FeFillPolygon(xu,yu,3,4,0,0,TextColor)
        if(klic.eq.-1.and.SubState.eq.1) then
          call FeLoadImage(xsub-2.*PixelX,xsub+xdsub+2.*PixelX,
     1                     ysub-ydsub-2.*PixelY,ysub+2.*PixelY,
     2                     'subrol.bmp',0)
          SubState=0
        else if(klic.eq.0) then
          SubState=0
        else if(klic.eq.1) then
          call FeDrawFrame(xsub,ysub-ydsub,xdsub,ydsub,2.*PixelX,Gray,
     1                     White,Black,.false.)
          call FeFillRectangle(xsub,xsub+xdsub,ysub,ysub-ydsub,4,0,0,
     1                         LightGray)
          xp=xsub
          yp=ysub
          do 1100i=1,SubN
            if(SubA(i)) then
              call FeWrMenuItem(xp,yp,xdsub,SubM(i),SubZ(i:i),Black,
     1                          LightGray)
            else
              call FeWrMenuItem(xp,yp,xdsub,SubM(i),SubZ(i:i),WhiteGray,
     1                          LightGray)
            endif
            yp=yp-MenuLineWidth
1100      continue
          SubState=1
        endif
      else
        xsub =0.
        xdsub=0.
        ysub =0.
        ydsub=0.
        SubState=0
      endif
      return
      end
      subroutine FeToolBarButton(xp,xk,yp,yk,Text,State,klic)
      include 'params.cmn'
      include 'basic.cmn'
      include 'fepc.cmn'
      character*(*) Text
      character*1 StFlag
      integer ColorRD,ColorLU,State
      if(State.eq.klic) go to 9999
      xpX=FeXPixRound(xp+2.*PixelX)
      xkX=FeXPixRound(xk-2.*PixelX)
      ypX=FeYPixRound(yp+2.*PixelX)
      ykX=FeYPixRound(yk-2.*PixelX)
      wp=FeXPixRound(xkX-xpX)
      hp=FeYPixRound(ykX-ypX)
      if(klic.eq.0) then
        ColorRD=LightGray
        ColorLU=LightGray
        xt=0.
        yt=0.
      else if(klic.lt.0) then
        ColorLU=White
        ColorRD=Gray
        xt=0.
        yt=0.
      else
        ColorRD=White
        ColorLU=Gray
        xt= PixelX
        yt=-PixelY
      endif
      call FeDeferOutput
      call FeDrawFrame(xpX,ypX,wp,hp,2.*PixelX,ColorRD,ColorLU,Black,
     1                 .false.)
      call FeFillRectangle(xpX,xkX,ypX,ykX,4,0,0,LightGray)
      call FeOutStUnder(0,xp+3.+xt,FeYPixRound((yp+yk)*.5)+yt,Text,'L',
     1                  Black,Black,StFlag)
      State=klic
9999  return
      end
      subroutine SetCommands(KteryProgram)
      include 'params.cmn'
      include 'basic.cmn'
      integer FeMenu
      character*8  men(3)
      data men/'%Refine',
     1         '%Fourier',
     2         '%Dist'/
      StartProgram=.false.
      if(KteryProgram.le.0) then
        KteryProgram=FeMenu(-1.,-1.,men,1,3,1,0)
        if(KteryProgram.le.0) go to 9999
      endif
      if(KteryProgram.eq.1) then
        call SetCommandsRefine
      else if(KteryProgram.eq.2) then
        call SetCommandsFourier
      else if(KteryProgram.eq.3) then
        call SetCommandsDist
      endif
9999  return
      end
      subroutine TestDataFiles(Ukoncit)
      include 'params.cmn'
      include 'basic.cmn'
      include 'fepc.cmn'
      character*256 NameOfFile,t256
      character*80 DataFile(12),Radka,Dir
      integer FeFileSize
      logical Ukoncit,ExistFile,FeYesNoHeader,Opravit,FeYesNo
      data DataFile/'lstnewpg.ps','lstprolo.ps','bvparm.cif','cif.dat',
     1              'absor.dat','anom.dat','atoms.dat','eleccoef.dat',
     2              'electab.dat','wavef.dat','wavefc.dat',
     3              'spgroup.dat'/
      Ukoncit=.false.
      Opravit=.false.
      Dir='a2ps'
      do 2000i=1,12
        if(i.eq.8.or.i.eq.9) go to 2000
        if(i.eq.3) then
          Dir='bondval'
        else if(i.eq.4) then
          Dir='cif'
        else if(i.eq.5) then
          Dir='formfac'
        else if(i.eq.12) then
          Dir='symmdat'
        endif
        if(OpSystem.le.0) then
          NameOfFile=JanaDir(:idel(JanaDir))//Dir(:idel(Dir))//ObrLom//
     1               DataFile(i)
        else
          NameOfFile=JanaDir(:idel(JanaDir))//'source/data/'//
     1               DataFile(i)
        endif
1000    if(ExistFile(NameOfFile)) then
          ln=NextLogicNumber()
          open(ln,file=NameOfFile)
          read(ln,FormA80) Radka
          if(Opravit) then
            if(Radka(1:3).ne.'###') rewind ln
            lno=NextLogicNumber()
            call OpenFile(lno,'ven.l90','formatted','unknown')
            if(ErrJana.ne.0) go to 1070
            t256='### '//VersionString(16:idel(VersionString))//
     1           ' ### - forced out by user !!!'
1010        write(lno,FormA1)(t256(j:j),j=1,idel(t256))
            read(ln,FormA256,end=1050) t256
            go to 1010
1050        close(ln)
            close(lno)
            call MoveFile('ven.l90',NameOfFile,.false.)
            go to 2000
1070        close(ln)
            Ukoncit=.true.
            go to 9999
          else
            close(ln)
          endif
          j=index(Radka(4:),'#')+5
          if(Radka(:j).ne.'### '//VersionString(16:idel(VersionString))
     1                 //' ###') then
            TextInfo(1)='The data file "'//
     1                  DataFile(i)(:idel(DataFile(i)))//
     2                  '" does not have'
            TextInfo(2)='proper version string.'
            NInfo=2
            Ukoncit=.not.FeYesNoHeader(-1.,-1.,'Do you want to '//
     1                                 'continue anyhow?',0)
            if(Ukoncit) then
              go to 9999
            else
              if(VasekTest.ne.0) then
                Opravit=FeYesNo(-1.,-1.,'Do you want to skip this '//
     1                          'warning from now on?',0)
                if(Opravit) then
                  go to 1000
                else
                  go to 2100
                endif
              else
                go to 2100
              endif
            endif
          endif
        else
          call FeChybne(-1.,-1.,'the data file "'//
     1      DataFile(i)(:idel(DataFile))//'" does not exist',' ',0,
     2      FatalError)
          Ukoncit=.true.
          go to 9999
        endif
2000  continue
2100  RecLenFacForm=4
      RecLenFacUnform=4
      ln=NextLogicNumber()
      Radka='jtst'
      call CreateTmpFile(Radka,i,0)
      call FeTmpFilesAdd(Radka)
      lrec=4
      open(ln,file=Radka,form='formatted',status='unknown',
     1     access='direct',recl=lrec*RecLenFacForm,err=5000)
      write(ln,'(a16)',rec=1) 'abcdefghabcdefgh'
      close(ln)
      RecLenFacForm=nint(float(lrec*RecLenFacForm)/
     1                   float(FeFileSize(Radka))*float(RecLenFacForm))
      open(ln,file=Radka,form='unformatted',status='unknown',
     1     access='direct',recl=lrec*RecLenFacUnform,err=5000)
      write(ln,rec=1)(i,i=1,4)
      close(ln)
      RecLenFacUnform=nint(float(lrec*RecLenFacUnform)/
     1                float(FeFileSize(Radka))*float(RecLenFacUnform))
5000  call DeleteFile(Radka)
      call FeTmpFilesClear(Radka)
9999  return
      end
      subroutine AboutJana
      include 'params.cmn'
      include 'basic.cmn'
      include 'fepc.cmn'
      Ninfo=7
      TextInfo(1)=VersionString
      TextInfo(2)='                                                  '
      TextInfo(3)='by Vaclav Petricek, Michal Dusek & Lukas Palatinus'
      TextInfo(4)='    Institute of Physics, Academy of Sciences     '
      TextInfo(5)='          of the Czech Republic, Praha            '
      TextInfo(6)='                                                  '
      TextInfo(7)='http://www-xray.fzu.cz/jana                       '
      call FeInfoOut(-1.,-1.,'Jana2000')
      return
      end
      block data BlokDatRed
      include 'params.cmn'
      include 'basic.cmn'
      include 'datred.cmn'
      include 'profil.cmn'
      data CallXShape/' '/,ImportTextB,ImportTextE/
     1                    'import_report_begin','import_report_end'/
      data DiffAxe,DiffAngle/.02,.2/,DRLam/0./
      data SumaObsLimCentr,SumaObsLimExtinct/10.,20./
      data ((abskou(i,j),i=1,19),j=1,49)/
     1 1.00,1.00,1.00,1.00,1.00,1.00,1.00,1.00,1.00,1.00,
     2 1.00,1.00,1.00,1.00,1.00,1.00,1.00,1.00,1.00,
     3 1.16,1.16,1.16,1.16,1.16,1.16,1.16,1.16,1.16,1.16,
     4 1.16,1.16,1.16,1.16,1.16,1.16,1.16,1.16,1.16,
     5 1.35,1.35,1.35,1.34,1.34,1.34,1.34,1.34,1.34,1.34,
     6 1.33,1.33,1.33,1.33,1.33,1.33,1.33,1.33,1.33,
     7 1.56,1.56,1.56,1.55,1.55,1.55,1.55,1.54,1.54,1.53,
     8 1.53,1.53,1.52,1.52,1.51,1.51,1.51,1.51,1.51,
     9 1.80,1.80,1.80,1.79,1.79,1.78,1.78,1.77,1.76,1.75,
     a 1.74,1.73,1.73,1.72,1.71,1.70,1.70,1.70,1.70,
     1 2.08,2.07,2.07,2.06,2.06,2.05,2.03,2.02,2.01,1.99,
     2 1.97,1.96,1.94,1.93,1.92,1.91,1.90,1.90,1.90,
     3 2.39,2.39,2.38,2.37,2.36,2.34,2.32,2.30,2.27,2.25,
     4 2.23,2.20,2.18,2.16,2.14,2.13,2.11,2.11,2.11,
     5 2.75,2.74,2.73,2.72,2.70,2.67,2.64,2.60,2.57,2.53,
     6 2.50,2.46,2.43,2.40,2.37,2.35,2.33,2.32,2.32,
     7 3.15,3.15,3.13,3.11,3.07,3.03,2.99,2.94,2.89,2.83,
     8 2.78,2.73,2.69,2.65,2.61,2.58,2.56,2.55,2.55,
     9 3.61,3.60,3.58,3.54,3.50,3.44,3.37,3.30,3.23,3.16,
     a 3.09,3.02,2.96,2.91,2.86,2.82,2.80,2.78,2.77,
     1 4.12,4.11,4.08,4.03,3.96,3.88,3.79,3.70,3.60,3.50,
     2 3.41,3.33,3.25,3.18,3.12,3.07,3.04,3.02,3.01,
     3 4.70,4.69,4.64,4.57,4.48,4.37,4.25,4.12,3.99,3.87,
     4 3.75,3.64,3.55,3.46,3.39,3.33,3.28,3.26,3.25,
     5 5.35,5.33,5.27,5.17,5.05,4.90,4.74,4.57,4.41,4.25,
     6 4.11,3.97,3.85,3.75,3.66,3.59,3.54,3.50,3.49,
     7 6.08,6.05,5.97,5.84,5.67,5.47,5.27,5.06,4.85,4.66,
     8 4.48,4.32,4.17,4.04,3.94,3.85,3.79,3.75,3.73,
     9 6.90,6.86,6.75,6.57,6.35,6.10,5.83,5.57,5.32,5.08,
     a 4.86,4.67,4.49,4.34,4.22,4.12,4.05,4.00,3.98,
     1 7.80,7.75,7.60,7.38,7.09,6.77,6.44,6.11,5.81,5.52,
     2 5.26,5.03,4.83,4.65,4.51,4.39,4.31,4.26,4.23,
     3 8.81,8.74,8.55,8.25,7.89,7.49,7.08,6.69,6.32,5.98,
     4 5.67,5.40,5.17,4.97,4.80,4.67,4.57,4.51,4.48,
     5 9.92,9.83,9.59,9.21,8.76,8.26,7.76,7.29,6.85,6.45,
     6 6.10,5.78,5.51,5.28,5.09,4.94,4.83,4.77,4.74,
     7 11.2,11.0,10.7,10.3,9.69,9.08,8.48,7.92,7.40,6.94,
     8 6.53,6.17,5.87,5.60,5.39,5.22,5.10,5.02,4.99,
     9 12.5,12.4,12.0,11.4,10.7,9.95,9.24,8.58,7.98,7.44,
     a 6.97,6.57,6.22,5.93,5.69,5.50,5.37,5.28,5.25,
     1 14.0,13.8,13.3,12.6,11.8,10.9,10.0,9.26,8.57,7.96,
     2 7.43,6.97,6.59,6.26,5.99,5.78,5.63,5.54,5.50,
     3 15.6,15.4,14.8,13.9,12.9,11.8,10.9,9.97,9.18,8.49,
     4 7.89,7.38,6.95,6.59,6.30,6.07,5.90,5.80,5.76,
     5 17.4,17.1,16.4,15.3,14.1,12.9,11.7,10.7,9.80,9.03,
     6 8.36,7.80,7.33,6.93,6.61,6.36,6.17,6.06,6.02,
     7 19.4,19.0,18.1,16.8,15.3,13.9,12.6,11.4,10.4,9.57,
     8 8.84,8.22,7.70,7.27,6.92,6.64,6.45,6.32,6.28,
     9 21.5,21.0,19.9,18.4,16.7,15.0,13.5,12.2,11.1,10.1,
     a 9.32,8.65,8.08,7.61,7.23,6.93,6.72,6.59,6.54,
     1 23.8,23.3,21.9,20.0,18.1,16.2,14.5,13.0,11.7,10.7,
     2 9.81,9.07,8.46,7.95,7.54,7.23,6.99,6.85,6.80,
     3 26.3,25.6,24.0,21.8,19.5,17.3,15.4,13.8,12.4,11.3,
     4 10.3,9.51,8.85,8.30,7.86,7.52,7.27,7.12,7.06,
     5 29.0,28.2,26.2,23.7,21.0,18.6,16.4,14.6,13.1,11.8,
     6 10.8,9.94,9.23,8.64,8.17,7.81,7.54,7.38,7.33,
     7 31.9,30.9,28.6,25.6,22.6,19.8,17.4,15.4,13.8,12.4,
     8 11.3,10.4,9.62,8.99,8.49,8.10,7.82,7.65,7.59,
     9 35.0,33.9,31.2,27.7,24.2,21.1,18.5,16.3,14.5,13.0,
     a 11.8,10.8,10.0,9.34,8.81,8.40,8.10,7.92,7.85,
     1 38.4,37.0,33.9,29.9,25.9,22.4,19.5,17.1,15.2,13.6,
     2 12.3,11.3,10.4,9.70,9.13,8.70,8.38,8.18,8.11,
     3 42.0,40.4,36.7,32.1,27.7,23.8,20.6,18.0,15.9,14.2,
     4 12.8,11.7,10.8,10.0,9.45,8.99,8.66,8.45,8.38,
     5 45.8,43.9,39.7,34.4,29.5,25.2,21.7,18.9,16.6,14.8,
     6 13.4,12.2,11.2,10.4,9.77,9.29,8.94,8.72,8.64,
     7 49.9,47.7,42.8,36.8,31.3,26.6,22.8,19.8,17.4,15.4,
     8 13.9,12.6,11.6,10.8,10.1,9.59,9.21,8.99,8.90,
     9 54.3,51.7,46.0,39.3,33.2,28.1,23.9,20.7,18.1,16.1,
     a 14.4,13.1,12.0,11.1,10.4,9.88,9.49,9.25,9.17,
     1 58.9,56.0,49.5,41.9,35.2,29.5,25.1,21.6,18.9,16.7,
     2 14.9,13.5,12.4,11.5,10.7,10.2,9.77,9.52,9.43,
     3 63.8,60.4,53.0,44.6,37.1,31.0,26.2,22.5,19.6,17.3,
     4 15.5,14.0,12.8,11.8,11.1,10.5,10.1,9.79,9.69,
     5 69.0,65.1,56.8,47.3,39.2,32.6,27.4,23.4,20.4,17.9,
     6 16.0,14.5,13.2,12.2,11.4,10.8,10.3,10.1,9.96,
     7 74.6,70.1,60.6,50.2,41.2,34.1,28.6,24.4,21.1,18.6,
     8 16.5,14.9,13.6,12.6,11.7,11.1,10.6,10.3,10.2,
     9 80.4,75.3,64.6,53.1,43.3,35.7,29.8,25.3,21.9,19.2,
     a 17.1,15.4,14.0,12.9,12.0,11.4,10.9,10.6,10.5,
     1 86.5,80.7,68.8,56.0,45.5,37.2,31.0,26.3,22.7,19.8,
     2 17.6,15.8,14.4,13.3,12.4,11.7,11.2,10.9,10.8,
     3 93.0,86.4,73.1,59.1,47.6,38.8,32.2,27.2,23.4,20.5,
     4 18.2,16.3,14.8,13.6,12.7,12.0,11.5,11.1,11.0,
     5 99.8,92.4,77.5,62.2,49.9,40.5,33.4,28.2,24.2,21.1,
     6 18.7,16.8,15.2,14.0,13.0,12.3,11.7,11.4,11.3,
     7 107.,98.6,82.1,65.3,52.1,42.1,34.7,29.2,25.0,21.8,
     8 19.3,17.2,15.7,14.4,13.4,12.6,12.0,11.7,11.5,
     9 114.,105.,86.8,68.6,54.4,43.7,35.9,30.1,25.8,22.4,
     a 19.8,17.7,16.1,14.7,13.7,12.9,12.3,11.9,11.8,
     1 122.,112.,91.7,71.9,56.7,45.4,37.2,31.1,26.6,23.1,
     2 20.3,18.2,16.5,15.1,14.0,13.2,12.6,12.2,12.1,
     3 130.,119.,96.7,75.2,59.0,47.1,38.4,32.1,27.4,23.7,
     4 20.9,18.7,16.9,15.5,14.3,13.5,12.9,12.5,12.3,
     5 139.,126.,102.,78.6,61.3,48.8,39.7,33.1,28.1,24.4,
     6 21.4,19.1,17.3,15.8,14.7,13.8,13.2,12.8,12.6,
     7 148.,134.,107.,82.1,63.7,50.5,41.0,34.1,28.9,25.0,
     8 22.0,19.6,17.7,16.2,15.0,14.1,13.4,13.0,12.9/
      data ((abskou(i,j),i=1,19),j=50,98)/
     9 157.,141.,112.,85.6,66.1,52.2,42.2,35.1,29.7,25.7,
     a 22.6,20.1,18.1,16.6,15.3,14.4,13.7,13.3,13.1,
     1 167.,150.,118.,89.1,68.5,53.9,43.5,36.1,30.5,26.4,
     2 23.1,20.6,18.5,16.9,15.7,14.7,14.0,13.6,13.4,
     3 177.,158.,124.,92.7,71.0,55.6,44.8,37.1,31.3,27.0,
     4 23.7,21.0,19.0,17.3,16.0,15.0,14.3,13.8,13.7,
     5 188.,167.,129.,96.4,73.4,57.4,46.1,38.1,32.2,27.7,
     6 24.2,21.5,19.4,17.7,16.3,15.3,14.6,14.1,13.9,
     7 199.,176.,135.,100.,75.9,59.2,47.4,39.1,33.0,28.3,
     8 24.8,22.0,19.8,18.0,16.7,15.6,14.9,14.4,14.2,
     9 210.,185.,141.,104.,78.4,60.9,48.8,40.1,33.8,29.0,
     a 25.3,22.5,20.2,18.4,17.0,15.9,15.1,14.6,14.5,
     1 222.,194.,147.,108.,80.9,62.7,50.1,41.1,34.6,29.7,
     2 25.9,22.9,20.6,18.8,17.3,16.2,15.4,14.9,14.7,
     3 234.,204.,153.,111.,83.5,64.5,51.4,42.2,35.4,30.3,
     4 26.4,23.4,21.0,19.1,17.7,16.5,15.7,15.2,15.0,
     5 247.,214.,160.,115.,86.0,66.3,52.7,43.2,36.2,31.0,
     6 27.0,23.9,21.5,19.5,18.0,16.8,16.0,15.5,15.3,
     7 260.,224.,166.,119.,88.6,68.1,54.1,44.2,37.0,31.7,
     8 27.6,24.4,21.9,19.9,18.3,17.2,16.3,15.7,15.5,
     9 274.,235.,173.,123.,91.2,69.9,55.4,45.2,37.9,32.3,
     a 28.1,24.9,22.3,20.3,18.7,17.5,16.6,16.0,15.8,
     1 288.,246.,179.,127.,93.8,71.7,56.8,46.3,38.7,33.0,
     2 28.7,25.3,22.7,20.6,19.0,17.8,16.8,16.3,16.1,
     3 303.,257.,186.,131.,96.4,73.6,58.1,47.3,39.5,33.7,
     4 29.3,25.8,23.1,21.0,19.3,18.1,17.1,16.5,16.3,
     5 318.,269.,193.,135.,99.1,75.4,59.5,48.4,40.3,34.4,
     6 29.8,26.3,23.6,21.4,19.7,18.4,17.4,16.8,16.6,
     7 334.,280.,200.,139.,102.,77.2,60.8,49.4,41.2,35.0,
     8 30.4,26.8,24.0,21.7,20.0,18.7,17.7,17.1,16.9,
     9 350.,293.,207.,143.,104.,79.1,62.2,50.4,42.0,35.7,
     a 31.0,27.3,24.4,22.1,20.3,19.0,18.0,17.4,17.1,
     1 366.,305.,214.,148.,107.,81.0,63.5,51.5,42.8,36.4,
     2 31.5,27.8,24.8,22.5,20.7,19.3,18.3,17.6,17.4,
     3 383.,318.,221.,152.,110.,82.8,64.9,52.5,43.6,37.1,
     4 32.1,28.2,25.2,22.9,21.0,19.6,18.5,17.9,17.7,
     5 401.,331.,229.,156.,112.,84.7,66.3,53.6,44.5,37.8,
     6 32.7,28.7,25.7,23.2,21.3,19.9,18.8,18.2,17.9,
     7 419.,344.,236.,160.,115.,86.6,67.7,54.6,45.3,38.4,
     8 33.2,29.2,26.1,23.6,21.7,20.2,19.1,18.4,18.2,
     9 438.,357.,244.,165.,118.,88.5,69.0,55.7,46.1,39.1,
     a 33.8,29.7,26.5,24.0,22.0,20.5,19.4,18.7,18.4,
     1 457.,371.,251.,169.,121.,90.4,70.4,56.7,47.0,39.8,
     2 34.4,30.2,26.9,24.3,22.3,20.8,19.7,19.0,18.7,
     3 477.,385.,259.,173.,123.,92.2,71.8,57.8,47.8,40.5,
     4 34.9,30.7,27.3,24.7,22.7,21.1,20.0,19.3,19.0,
     5 498.,400.,267.,177.,126.,94.1,73.2,58.9,48.7,41.2,
     6 35.5,31.1,27.8,25.1,23.0,21.4,20.3,19.5,19.2,
     7 519.,415.,275.,182.,129.,96.0,74.6,59.9,49.5,41.8,
     8 36.1,31.6,28.2,25.5,23.4,21.7,20.5,19.8,19.5,
     9 540.,430.,283.,186.,132.,98.0,76.0,61.0,50.3,42.5,
     a 36.6,32.1,28.6,25.8,23.7,22.1,20.8,20.1,19.8,
     1 563.,445.,291.,191.,135.,99.9,77.4,62.0,51.2,43.2,
     2 37.2,32.6,29.0,26.2,24.0,22.4,21.1,20.3,20.0,
     3 585.,460.,299.,195.,137.,102.,78.8,63.1,52.0,43.9,
     4 37.8,33.1,29.4,26.6,24.4,22.7,21.4,20.6,20.3,
     5 609.,476.,307.,200.,140.,104.,80.2,64.2,52.8,44.6,
     6 38.4,33.6,29.9,27.0,24.7,23.0,21.7,20.9,20.6,
     7 633.,493.,315.,204.,143.,106.,81.6,65.2,53.7,45.3,
     8 38.9,34.1,30.3,27.3,25.0,23.3,22.0,21.2,20.8,
     9 657.,509.,324.,209.,146.,108.,83.0,66.3,54.5,45.9,
     a 39.5,34.6,30.7,27.7,25.4,23.6,22.3,21.4,21.1,
     1 683.,526.,332.,213.,149.,110.,84.4,67.4,55.4,46.6,
     2 40.1,35.0,31.1,28.1,25.7,23.9,22.5,21.7,21.4,
     3 709.,543.,341.,218.,152.,111.,85.8,68.4,56.2,47.3,
     4 40.6,35.5,31.6,28.5,26.0,24.2,22.8,22.0,21.6,
     5 735.,560.,349.,222.,154.,113.,87.2,69.5,57.1,48.0,
     6 41.2,36.0,32.0,28.8,26.4,24.5,23.1,22.2,21.9,
     7 762.,578.,358.,227.,157.,115.,88.6,70.6,57.9,48.7,
     8 41.8,36.5,32.4,29.2,26.7,24.8,23.4,22.5,22.2,
     9 790.,596.,367.,232.,160.,117.,90.1,71.7,58.8,49.4,
     a 42.4,37.0,32.9,29.6,27.1,25.1,23.7,22.8,22.4,
     1 819.,614.,375.,236.,163.,119.,91.5,72.7,59.6,50.1,
     2 42.9,37.5,33.3,30.0,27.4,25.4,24.0,23.1,22.7,
     3 848.,632.,384.,241.,166.,121.,92.9,73.8,60.4,50.7,
     4 43.5,38.0,33.7,30.3,27.7,25.7,24.3,23.3,23.0,
     5 878.,651.,393.,246.,169.,123.,94.3,74.9,61.3,51.4,
     6 44.1,38.5,34.1,30.7,28.1,26.1,24.5,23.6,23.2,
     7 909.,670.,402.,250.,172.,125.,95.8,76.0,62.1,52.1,
     8 44.7,39.0,34.6,31.1,28.4,26.4,24.8,23.9,23.5,
     9 940.,690.,411.,255.,175.,127.,97.2,77.1,63.0,52.8,
     a 45.2,39.5,35.0,31.5,28.7,26.7,25.1,24.2,23.8,
     1 972.,709.,420.,260.,178.,129.,98.6,78.2,63.9,53.5,
     2 45.8,39.9,35.4,31.8,29.1,27.0,25.4,24.4,24.0,
     31005.,729.,429.,264.,180.,131.,100.,79.3,64.7,54.2,
     4 46.4,40.4,35.8,32.2,29.4,27.3,25.7,24.7,24.3,
     51038.,749.,439.,269.,183.,133.,101.,80.4,65.6,54.9,
     6 46.9,40.9,36.2,32.6,29.7,27.6,26.0,25.0,24.6,
     71072.,770.,448.,274.,186.,135.,103.,81.5,66.4,55.6,
     8 47.5,41.3,36.6,32.9,30.1,27.9,26.3,25.2,24.8,
     91107.,791.,457.,279.,189.,137.,104.,82.6,67.3,56.3,
     a 48.0,41.8,37.0,33.3,30.4,28.2,26.5,25.5,25.1,
     11143.,812.,467.,284.,192.,139.,106.,83.7,68.2,57.0,
     2 48.6,42.2,37.4,33.6,30.7,28.5,26.8,25.8,25.4,
     31180.,833.,476.,288.,195.,141.,107.,84.8,69.1,57.7,
     4 49.1,42.7,37.7,33.9,31.0,28.8,27.1,26.1,25.6,
     51217.,855.,485.,293.,198.,143.,109.,85.9,69.9,58.4,
     6 49.6,43.1,38.1,34.3,31.4,29.1,27.4,26.3,25.9/
      data ((abskou(i,j),i=1,19),j=99,101)/
     71255.,877.,495.,298.,201.,145.,110.,87.0,70.8,59.1,
     8 50.2,43.5,38.4,34.6,31.7,29.5,27.7,26.6,26.2,
     91294.,899.,505.,303.,204.,147.,112.,88.2,71.7,59.8,
     a 50.7,43.9,38.7,34.9,32.0,29.8,28.0,26.9,26.4,
     11333.,921.,514.,308.,207.,149.,113.,89.3,72.6,60.5,
     2 51.2,44.2,39.0,35.2,32.3,30.1,28.3,27.2,26.7/
      data ((absval(i,j),i=1,19),j=1,49)/
     1 1.00,1.00,1.00,1.00,1.00,1.00,1.00,1.00,1.00,1.00,
     2 1.00,1.00,1.00,1.00,1.00,1.00,1.00,1.00,1.00,
     3 1.18,1.18,1.18,1.18,1.18,1.18,1.18,1.18,1.18,1.18,
     4 1.18,1.18,1.18,1.18,1.18,1.18,1.18,1.18,1.18,
     5 1.40,1.40,1.40,1.40,1.40,1.40,1.39,1.39,1.39,1.39,
     6 1.39,1.38,1.38,1.38,1.38,1.38,1.37,1.37,1.37,
     7 1.65,1.65,1.65,1.65,1.65,1.64,1.64,1.63,1.63,1.62,
     8 1.62,1.61,1.61,1.60,1.59,1.59,1.59,1.59,1.59,
     9 1.95,1.95,1.95,1.94,1.94,1.93,1.92,1.91,1.90,1.89,
     a 1.87,1.86,1.85,1.84,1.83,1.82,1.82,1.81,1.81,
     1 2.29,2.29,2.29,2.28,2.27,2.26,2.24,2.22,2.20,2.18,
     2 2.16,2.13,2.12,2.10,2.08,2.07,2.06,2.05,2.05,
     3 2.69,2.69,2.69,2.67,2.65,2.63,2.60,2.57,2.53,2.50,
     4 2.47,2.43,2.40,2.37,2.35,2.33,2.31,2.30,2.30,
     5 3.16,3.16,3.15,3.13,3.09,3.05,3.01,2.96,2.91,2.85,
     6 2.80,2.75,2.71,2.66,2.63,2.60,2.58,2.56,2.56,
     7 3.70,3.70,3.68,3.65,3.60,3.54,3.47,3.39,3.32,3.24,
     8 3.16,3.09,3.03,2.97,2.92,2.88,2.85,2.84,2.83,
     9 4.33,4.33,4.30,4.24,4.17,4.08,3.98,3.87,3.76,3.65,
     a 3.55,3.46,3.37,3.29,3.23,3.18,3.14,3.11,3.11,
     1 5.06,5.05,5.01,4.92,4.81,4.68,4.54,4.39,4.24,4.10,
     2 3.97,3.84,3.73,3.63,3.55,3.48,3.43,3.40,3.39,
     3 5.90,5.88,5.81,5.69,5.54,5.36,5.16,4.96,4.76,4.58,
     4 4.40,4.24,4.10,3.97,3.87,3.79,3.73,3.69,3.68,
     5 6.86,6.84,6.74,6.57,6.35,6.10,5.84,5.57,5.32,5.08,
     6 4.86,4.66,4.49,4.33,4.20,4.11,4.03,3.98,3.97,
     7 7.96,7.93,7.79,7.55,7.25,6.92,6.58,6.23,5.91,5.61,
     8 5.34,5.09,4.88,4.70,4.54,4.43,4.34,4.28,4.27,
     9 9.23,9.18,8.97,8.65,8.25,7.82,7.37,6.94,6.53,6.16,
     a 5.83,5.54,5.29,5.07,4.89,4.75,4.65,4.58,4.57,
     1 10.7,10.6,10.3,9.88,9.35,8.79,8.22,7.68,7.19,6.74,
     2 6.35,6.00,5.71,5.45,5.24,5.08,4.96,4.89,4.87,
     3 12.3,12.2,11.8,11.2,10.6,9.84,9.13,8.47,7.87,7.34,
     4 6.87,6.47,6.13,5.84,5.60,5.42,5.28,5.19,5.17,
     5 14.2,14.0,13.5,12.7,11.9,11.0,10.1,9.30,8.58,7.96,
     6 7.42,6.95,6.57,6.23,5.96,5.75,5.60,5.50,5.48,
     7 16.3,16.0,15.4,14.4,13.3,12.2,11.1,10.2,9.32,8.59,
     8 7.97,7.45,7.01,6.63,6.33,6.09,5.92,5.81,5.78,
     9 18.6,18.3,17.5,16.2,14.8,13.5,12.2,11.1,10.1,9.25,
     a 8.54,7.94,7.45,7.03,6.69,6.44,6.24,6.12,6.09,
     1 21.3,20.9,19.8,18.2,16.5,14.8,13.3,12.0,10.9,9.91,
     2 9.12,8.45,7.91,7.44,7.06,6.78,6.56,6.43,6.40,
     3 24.2,23.7,22.3,20.3,18.2,16.2,14.5,12.9,11.7,10.6,
     4 9.71,8.97,8.36,7.84,7.44,7.13,6.89,6.75,6.71,
     5 27.5,26.9,25.1,22.6,20.1,17.7,15.7,13.9,12.5,11.3,
     6 10.3,9.49,8.82,8.26,7.81,7.47,7.22,7.06,7.02,
     7 31.2,30.4,28.1,25.1,22.0,19.3,16.9,14.9,13.3,12.0,
     8 10.9,10.0,9.29,8.67,8.19,7.82,7.54,7.38,7.33,
     9 35.3,34.2,31.4,27.7,24.1,20.9,18.2,16.0,14.2,12.7,
     a 11.5,10.5,9.76,9.09,8.57,8.17,7.87,7.69,7.64,
     1 39.8,38.5,34.9,30.5,26.2,22.5,19.5,17.0,15.0,13.4,
     2 12.1,11.1,10.2,9.51,8.95,8.53,8.20,8.01,7.96,
     3 44.7,43.1,38.7,33.4,28.5,24.2,20.8,18.1,15.9,14.2,
     4 12.8,11.6,10.7,9.93,9.33,8.88,8.53,8.33,8.27,
     5 50.1,48.1,42.8,36.5,30.8,26.0,22.2,19.2,16.8,14.9,
     6 13.4,12.2,11.2,10.4,9.72,9.23,8.87,8.64,8.58,
     7 56.1,53.5,47.2,39.7,33.2,27.8,23.6,20.3,17.7,15.6,
     8 14.0,12.7,11.7,10.8,10.1,9.59,9.20,8.96,8.90,
     9 62.5,59.4,51.8,43.1,35.7,29.6,25.0,21.4,18.6,16.4,
     a 14.6,13.2,12.1,11.2,10.5,9.95,9.53,9.28,9.21,
     1 69.5,65.8,56.7,46.6,38.2,31.5,26.4,22.5,19.5,17.1,
     2 15.3,13.8,12.6,11.6,10.9,10.3,9.86,9.60,9.53,
     3 77.2,72.6,61.8,50.3,40.8,33.4,27.9,23.7,20.4,17.9,
     4 15.9,14.3,13.1,12.1,11.3,10.7,10.2,9.92,9.84,
     5 85.4,79.9,67.3,54.0,43.5,35.4,29.3,24.8,21.4,18.7,
     6 16.6,14.9,13.6,12.5,11.7,11.0,10.5,10.2,10.2,
     7 94.2,87.6,72.9,57.9,46.2,37.3,30.8,26.0,22.3,19.4,
     8 17.2,15.5,14.1,12.9,12.0,11.4,10.9,10.6,10.5,
     9 104.,95.9,78.9,61.9,48.9,39.3,32.3,27.1,23.2,20.2,
     a 17.9,16.0,14.6,13.4,12.4,11.7,11.2,10.9,10.8,
     1 114.,105.,85.0,65.9,51.7,41.3,33.8,28.3,24.2,21.0,
     2 18.5,16.6,15.1,13.8,12.8,12.1,11.5,11.2,11.1,
     3 125.,114.,91.4,70.1,54.6,43.3,35.5,29.5,25.1,21.7,
     4 19.2,17.1,15.6,14.2,13.2,12.5,11.9,11.5,11.4,
     5 136.,124.,98.0,74.4,57.4,45.4,36.9,30.7,26.1,22.5,
     6 19.8,17.7,16.1,14.7,13.6,12.8,12.2,11.8,11.7,
     7 149.,134.,105.,78.7,60.4,47.5,38.4,31.9,27.0,23.3,
     8 20.5,18.3,16.6,15.1,14.0,13.2,12.6,12.2,12.1,
     9 162.,145.,112.,83.1,63.3,49.5,39.9,33.1,28.0,24.1,
     a 21.2,18.8,17.1,15.6,14.4,13.6,12.9,12.5,12.4,
     1 175.,156.,119.,87.6,66.3,51.6,41.5,34.3,28.9,24.9,
     2 21.8,19.4,17.6,16.0,14.8,13.9,13.2,12.8,12.7,
     3 190.,168.,127.,92.1,69.3,53.8,43.1,35.5,29.9,25.7,
     4 22.5,20.0,18.1,16.4,15.2,14.3,13.6,13.1,13.0,
     5 206.,180.,134.,96.7,72.3,55.9,44.6,36.7,30.9,26.5,
     6 23.2,20.6,18.6,16.9,15.6,14.6,13.9,13.5,13.3,
     7 222.,193.,142.,101.,75.4,58.0,46.2,37.9,31.8,27.3,
     8 23.8,21.1,19.1,17.3,16.0,15.0,14.3,13.8,13.7,
     9 239.,206.,150.,106.,78.5,60.2,47.8,39.1,32.8,28.1,
     a 24.5,21.7,19.6,17.8,16.4,15.4,14.6,14.1,14.0,
     1 257.,220.,158.,111.,81.6,62.3,49.4,40.4,33.8,28.9,
     2 25.2,22.3,20.1,18.2,16.8,15.7,14.9,14.4,14.3,
     3 275.,234.,166.,116.,84.7,64.5,51.0,41.6,34.8,29.7,
     4 25.8,22.9,20.6,18.7,17.2,16.1,15.3,14.8,14.6,
     5 295.,249.,175.,121.,87.8,66.7,52.6,42.8,35.8,30.5,
     6 26.5,23.4,21.1,19.1,17.6,16.5,15.6,15.1,14.9,
     7 316.,264.,183.,125.,91.0,68.9,54.2,44.1,36.7,31.3,
     8 27.2,24.0,21.6,19.6,18.0,16.9,16.0,15.4,15.3/
      data ((absval(i,j),i=1,19),j=50,81)/
     9 337.,280.,192.,130.,94.2,71.1,55.8,45.3,37.7,32.1,
     a 27.9,24.6,22.1,20.0,18.4,17.2,16.3,15.7,15.6,
     1 359.,296.,200.,135.,97.4,73.3,57.5,46.6,38.7,32.9,
     2 28.6,25.2,22.6,20.5,18.8,17.6,16.7,16.1,15.9,
     3 383.,313.,209.,140.,101.,75.5,59.1,47.8,39.7,33.7,
     4 29.2,25.8,23.1,20.9,19.2,18.0,17.0,16.4,16.2,
     5 407.,330.,218.,145.,104.,77.8,60.7,49.1,40.7,34.5,
     6 29.9,26.3,23.6,21.4,19.6,18.3,17.3,16.7,16.6,
     7 432.,348.,228.,150.,107.,80.0,62.4,50.3,41.7,35.3,
     8 30.6,26.9,24.1,21.8,20.0,18.7,17.7,17.1,16.9,
     9 458.,366.,237.,156.,110.,82.3,64.0,51.6,42.7,36.1,
     a 31.3,27.5,24.6,22.3,20.4,19.1,18.0,17.4,17.2,
     1 485.,384.,246.,161.,114.,84.5,65.7,52.9,43.7,37.0,
     2 32.0,28.1,25.2,22.7,20.9,19.5,18.4,17.7,17.5,
     3 513.,403.,255.,166.,117.,86.8,67.3,54.1,44.7,37.8,
     4 32.7,28.7,25.7,23.2,21.3,19.8,18.7,18.0,17.9,
     5 542.,422.,265.,171.,120.,89.1,69.0,55.4,45.7,38.6,
     6 33.4,29.3,26.2,23.6,21.7,20.2,19.1,18.4,18.2,
     7 573.,442.,275.,176.,124.,91.4,70.7,56.7,46.8,39.4,
     8 34.0,29.9,26.7,24.1,22.1,20.6,19.4,18.7,18.5,
     9 604.,462.,284.,182.,127.,93.6,72.4,58.0,47.8,40.3,
     a 34.7,30.5,27.2,24.5,22.5,21.0,19.8,19.0,18.8,
     1 636.,483.,294.,187.,130.,95.9,74.0,59.2,48.8,41.1,
     2 35.4,31.0,27.7,25.0,22.9,21.3,20.1,19.4,19.2,
     3 670.,504.,304.,192.,134.,98.3,75.7,60.5,49.8,41.9,
     4 36.1,31.6,28.3,25.4,23.3,21.7,20.5,19.7,19.5,
     5 704.,525.,314.,198.,137.,101.,77.4,61.8,50.8,42.7,
     6 36.8,32.2,28.8,25.9,23.7,22.1,20.8,20.0,19.8,
     7 740.,547.,324.,203.,140.,103.,79.1,63.1,51.9,43.6,
     8 37.5,32.8,29.3,26.4,24.1,22.5,21.2,20.4,20.25,
     9 777.,569.,334.,209.,144.,105.,80.8,64.4,52.5,44.4,
     a 38.2,33.3,29.8,26.8,24.6,22.8,21.5,20.7,20.5,
     1 814.,591.,345.,214.,147.,108.,82.5,65.7,53.9,45.2,
     2 38.9,34.0,30.3,27.3,25.0,23.2,21.9,21.0,20.8,
     3 853.,614.,355.,219.,151.,110.,84.2,67.0,54.9,46.1,
     4 39.6,34.6,30.9,27.7,25.4,23.6,22.2,21.4,21.1,
     5 894.,638.,365.,225.,154.,112.,85.9,68.3,56.0,46.9,
     6 40.3,35.2,31.4,28.2,25.8,24.0,22.6,21.7,21.5,
     7 935.,661.,376.,231.,158.,115.,87.6,69.6,57.0,47.8,
     8 41.0,35.8,31.9,28.7,26.2,24.4,23.0,22.1,21.8,
     9 978.,685.,386.,236.,161.,117.,89.4,70.9,58.0,48.6,
     a 41.7,36.4,32.4,29.1,26.6,24.8,23.3,22.4,22.1,
     11022.,710.,397.,242.,165.,119.,91.1,72.2,59.1,49.4,
     2 42.4,37.0,33.0,29.6,27.0,25.1,23.7,22.7,22.5,
     31067.,735.,408.,247.,168.,122.,92.8,73.6,60.1,50.3,
     4 43.1,37.6,33.5,30.1,27.5,25.5,24.0,23.1,22.8,
     51113.,760.,418.,253.,172.,124.,94.6,74.9,61.2,51.1,
     6 43.8,38.2,34.0,30.5,27.9,25.9,24.4,23.4,23.1,
     71161.,785.,429.,259.,175.,127.,96.3,76.2,62.2,52.0,
     8 44.6,38.8,34.6,31.0,28.3,26.3,24.7,23.8,23.5,
     91210.,811.,440.,264.,179.,129.,98.1,77.5,63.3,52.8,
     a 45.3,39.5,35.1,31.5,28.7,26.7,25.1,24.1,23.8,
     11260.,837.,451.,270.,182.,131.,99.8,78.9,64.3,53.7,
     2 46.0,40.1,35.6,31.9,29.2,27.1,25.5,24.4,24.1,
     31311.,864.,462.,276.,186.,134.,102.,80.2,65.4,54.5,
     4 46.7,40.7,36.1,32.4,29.6,27.4,25.8,24.8,24.5,
     51364.,891.,473.,281.,190.,136.,103.,81.5,66.4,55.4,
     6 47.4,41.3,36.7,32.9,30.0,27.8,26.2,25.1,24.8,
     71418.,918.,484.,287.,193.,139.,105.,82.9,67.5,56.2,
     8 48.1,41.9,37.2,33.3,30.4,28.2,26.5,25.5,25.2,
     91474.,945.,495.,293.,197.,141.,107.,84.2,68.5,57.1,
     a 48.9,42.5,37.8,33.8,30.8,28.6,26.9,25.8,25.5,
     11530.,974.,507.,299.,200.,144.,109.,85.5,69.6,58.0,
     2 49.5,43.1,38.3,34.3,31.3,29.0,27.3,26.1,25.8/
      data JenSpatne,CheckSplit,CheckBroad,CheckDeviated/4*.true./
      data DevLim,RatioBS,RatioPS,strshld/.2,.333333,.5,6./
      end
      block data BlokEM50EM9
      include 'params.cmn'
      include 'basic.cmn'
      include 'editm50.cmn'
      include 'editm9.cmn'
      data LamTypeD/'Ti','Cr','Fe','Co','Cu','Mo','Ag'/
      data LamAveD/2.7496,2.291,1.9374,1.7905,1.5418,.71073,.5609/
      data LamA2D /2.75207,2.29351,1.93991,1.79278,1.54433,.713543,
     1             .563775/
      data LamA1D /2.74841,2.28962,1.93597,1.78892,1.54051,.70926,
     1             .559363/
      data LamRatD/0.500,0.515,0.500,0.497,0.497,0.499,0.499/
      data EM9Form1,EM9Form2/'(6(3x,a1))','(6i4)'/,EM9ObsLim/3./
      data atn/'H ','He','Li','Be','B ','C ','N ','O ','F ','Ne','Na',
     1         'Mg','Al','Si','P ','S ','Cl','Ar','K ','Ca','Sc','Ti',
     2         'V ','Cr','Mn','Fe','Co','Ni','Cu','Zn','Ga','Ge','As',
     3         'Se','Br','Kr','Rb','Sr','Y ','Zr','Nb','Mo','Tc','Ru',
     4         'Rh','Pd','Ag','Cd','In','Sn','Sb','Te','I ','Xe','Cs',
     5         'Ba','La','Ce','Pr','Nd','Pm','Sm','Eu','Gd','Tb','Dy',
     6         'Ho','Er','Tm','Yb','Lu','Hf','Ta','W ','Re','Os','Ir',
     7         'Pt','Au','Hg','Tl','Pb','Bi','Po','At','Rn','Fr','Ra',
     8         'Ac','Th','Pa','U ','Np','Pu','Am','Cm','Bk','Cf'/
      data ffx/0.00,0.01,0.02,0.03,0.04,0.05,0.06,0.07,0.08,0.09,0.10,
     1         0.11,0.12,0.13,0.14,0.15,0.16,0.17,0.18,0.19,0.20,0.22,
     2         0.24,0.25,0.26,0.28,0.30,0.32,0.34,0.35,0.36,0.38,0.40,
     3         0.42,0.44,0.45,0.46,0.48,0.50,0.55,0.60,0.65,0.70,0.80,
     4         0.90,1.00,1.10,1.20,1.30,1.40,1.50,1.60,1.70,1.80,1.90,
     5         2.00,2.50,3.00,3.50,4.00,5.00,6.00/
      data ffxh/0.0000,0.0215,0.0429,0.0644,0.0859,0.1073,0.1288,0.1503,
     1          0.1718,0.1932,0.2147,0.2576,0.3006,0.3435,0.3864,0.4294,
     2          0.4723,0.5153,0.5582,0.6011,0.6441,0.6870,0.7300,0.7729,
     3          0.8158,0.8588,0.9017,0.9447,0.9876,1.0305,1.0735,1.1164,
     4          1.1593,1.2023,1.2452,1.2882,1.3311,1.3740,1.4170,1.4599,
     5          1.5029,1.5458,1.5887,1.6317,1.6746,1.7176,1.8000,1.8200,
     6          1.8400,1.8600,1.8800,1.9000,1.9200,1.9400,1.9600,1.9800,
     7          2.50,3.00,3.50,4.00,5.00,6.00/
      data nSmbPg/50/
      data SmbPGI/'1','-1',
     1            '2','m','2/m',
     2            '222','mm2','mmm',
     3            '4','-4','4/m','422','4mm','-4m2','4/mmm',
     4            '3','-3',
     5            '321','3m1','-3m1','312','31m','-31m',
     6            '32','3m','-3m',
     7            '6','-6','6/m','622','6mm','-6m2','6/mmm',
     8            '23','m-3','432','-43m','m-3m',
     9            '5','-5','52','5m','-5m','5/m','5/m2m',
     a            '10','-10','-102m',
     1            '235','m-3-5'/
      data SmbPGO/'C1','Ci',
     1            'C2','Cs','C2h',
     2            'D2','C2v','D2h',
     3            'C4','S4','C4h','D4','C4v','D2d','D4h',
     4            'C3','C3i','D3','C3v','D3d','D3','C3v','D3d',
     5            'D3','C3v','D3d',
     6            'C6','C3h','C6h','D6','C6v','D3h','D6h',
     7            'T','Th','O','Td','Oh',
     8            'C5','C5i','D5','C5v','D5d','C5h','D5h',
     9            'C10','C10h','D10h',
     a            'I','Ih'/
      data LaueGroupPointer/2,5,8,11,15,17,20,23,26,29,33,35,38/
      end
      block data BlockBasic
      include 'params.cmn'
      include 'basic.cmn'
      include 'atoms.cmn'
      include 'molec.cmn'
      include 'fepc.cmn'
      data CallSIR97,CallSIR2002/2*' '/
      data ButtonState/mxbut*0/,EdwState/mxedw*0/,QuestState/mxquest*0/,
     1     CrwState/mxcrw*0/,UpDownState/mxud*0/,TahBarStatus/MxTahb*0/,
     2     SbwState/mxSbw*0/,
     3     PixelWindowXposOld,PixelWindowYposOld/2*-1/,
     4     InsertMode/.true./,IgnoreE,IgnoreW/2*.false./
     5     SelwState/mxselw*0/,LblState/mxlbl*0/,MaxRightBut/8/,
     6     TakeMouseMove,DoubleClickAllowed,KartOn,KartPrepnul,PicturOn,
     7     SelwDoubleClickAllowed,SbwDoubleClickAllowed/7*.false./,
     8     KartId/0/,KartUpdateListek/mxkart*0/,mm2X,mm2Y/2*1./,
     9     MotionGrid/2/,
     a     ButtonAlw/mxAlw*0/,NKart,KartNDol/2*0/,
     1     DoubleClickCount/0/,IkonState/mxikon*0/,CrwExGr/mxcrw*0/,
     2     ButtonZ,CrwZ,EdwZ,IkonZ/4*' '/,LwinState/mxlwin*0/
     3     CrwgXd,CrwgYd,CrwXd,CrwYd,EdwYd,ButYd,UpDownXd,UpDownYd,
     4     SelwYd/2*7.,2*5.,5*7./,MenuLineWidth/8./
      data VolaToCoDal,DelejTestIn,SubQuest/.false.,.true.,.false./
      data PowSimOn,RoundAsForActa/.false.,.true./
      data NSendEvent/0/
      data ShiftPressed,CtrlPressed/2*.false./
      data MakeExternalCheck,LastActiveQuest/2*0/
      data ButtonFr,ButtonTo,CrwFr,CrwTo,EdwFr,EdwTo,IkonFr,IkonTo,
     1     LwinFr,LwinTo,SelwFr,SelwTo,UpDownFr,UpDownTo,TahbFr,
     2     TahbTo/1,mxbut,1,mxcrw,1,mxedw,1,mxikon,1,mxlwin,1,mxselw,
     3     1,mxud,1,MxTahb/,SbwFr,SbwTo/1,mxSbw/
      data LastQuest,VasekTest/2*0/
      data lst,out,dta,BatchLN,m40,m50/60,6,5,9,39,50/
      data ExtMFile/'.m40','.m41','.m50','.m91','.m92','.m94','.m95',
     1              '.smr','.cvf'/
      data HCExtension/'.hgl','.ps','.pcx','.wmf','.eps','.asc','.stf',
     1                 '.drg','.3d'/
      data HCMenu/'as %HPGL file',
     1            'as PostScript file',
     2            'as PC%X file',
     3            'as %WMF file',
     4            'as %EPS file',
     5            'as ASC%II file',
     6            'as %stf file',
     7            'for %Dragon',
     8            'for %JMAP3D'/
      data torad,pi,pi2/0.017453293,3.141592654,6.283185308/
      data PrimeNumbers/2,3,5,7,11,13,17,19,23,29/
      data pi4/12.56637061/,Cifry/'0123456789.+-'/,BohrRad/0.529177/
      data ToKeV/12.39852/
      data episq/78.95683521/,indices/'h','k','l','m','n','p'/
      data smbx/'x','y','z'/,smbx6/'x1','x2','x3','x4','x5','x6'/
      data smbt/'t','u','v'/,SmbABC/'a','b','c'/
      data smbc/'PABCIRFX'/,SmbSymmT/'0','s','q','t','h'/
      data FormA256,FormA128,FormA80,FormA1/'(a256)','(a128)','(a80)',
     1                                      '(333a1)'/
      data RealFormat/'(f15.##)'/,FormI15/'(i15)'/
      data FormSG/'(3i3,1x,a8,1x,a40,3(1x,a20))'/
      data format80/'(3i4,i4,13e12.5)'/
      data format91/'(3i4,2f9.1,3i2,8f8.4, e15.6)'/
      data format91pow/'(6i4,2f9.1,3i2,f9.6)'/
      data format92/'(f8.4,f10.0,f8.0,i4)'/
      data format95old/'(i6,3i4,4f7.2,2f9.1,f10.3,2i2/2e15.6,7f8.4)'/
      data format95/'(i6,3i4,4f7.2,2e15.6,f10.3,2i2/2e15.6,8f8.4)'/
      data formatshelx/'(3i4,2f8.2,i4,6f8.5)'/
      data TRank/1,3,6,10,15,21,28/,TRankCumul/1,4,10,20,35,56,84/,
     1     inv/27,81,243,729/,ioffm/0,10,25,46/,ioffv/0,27,108,351/,
     2     cfact/6.e3,24.e4,120.e5,720.e6/
      data cmlt / 1., 3., 3., 3., 6., 3., 1., 3., 3., 1.,
     -            1., 4., 4., 6.,12., 6., 4.,12.,12., 4., 1., 4., 6.,
     1            4., 1.,
     -            1., 5., 5.,10.,20.,10.,10.,30.,30.,10., 5.,20.,30.,
     1           20., 5., 1., 5.,10.,10., 5., 1.,
     -            1., 6., 6.,15.,30.,15.,20.,60.,60.,20.,15.,60.,90.,
     1           60.,15., 6.,30.,60.,60.,30., 6., 1., 6.,15.,20.,15.,
     2            6., 1./
      data ipoc / 1, 2, 5, 8,11,17,20,21,24,27,
     -            1, 2, 6,10,16,28,34,38,50,62,66,67,71,77,81,
     -             1,  2,  7, 12, 22, 42, 52, 62, 92,122,132,137,157,
     1           187,207,212,213,218,228,238,243,
     -             1,  2,  8, 14, 29, 59, 74, 94,154,214,234,249,309,
     1           399,459,474,480,510,570,630,660,666,667,673,688,708,
     2           723,729/
      data idlc / 1, 3, 3, 3, 6, 3, 1, 3, 3, 1,
     -            1, 4, 4, 6,12, 6, 4,12,12, 4, 1, 4, 6, 4, 1,
     -            1, 5, 5,10,20,10,10,30,30,10, 5,20,30,20, 5, 1, 5,10,
     1           10, 5, 1,
     -            1, 6, 6,15,30,15,20,60,60,20,15,60,90,60,15, 6,30,60,
     1           60,30, 6, 1, 6,15,20,15, 6, 1/
      data ipec /21,22,25,37,23,29,53,26,38,41,27,30,39,45,54,57,31,55,
     1           61,42,43,46,58,47,59,62,63,
     -            85, 86, 89,101,149, 87, 93,117,213, 90,102,105,150,
     1           153,165, 91, 94,103,109,118,121,151,157,181,214,217,
     2           229, 95,119,125,215,221,245,106,154,166,169,107,110,
     3           122,155,158,167,173,182,185,218,230,233,111,123,126,
     4           159,183,189,219,222,231,237,246,249,127,223,247,253,
     5           170,171,174,186,234,175,187,190,235,238,250,191,239,
     6           251,254,255,
     -            341, 342, 345, 357, 405, 597, 343, 349, 373, 469, 853,
     1            346, 358, 361, 406, 409, 421, 598, 601, 613, 661, 347,
     2            350, 359, 365, 374, 377, 407, 413, 437, 470, 473, 485,
     3            599, 605, 629, 725, 854, 857, 869, 917, 351, 375, 381,
     4            471, 477, 501, 855, 861, 885, 981, 362, 410, 422, 425,
     5            602, 614, 617, 662, 665, 677, 363, 366, 378, 411, 414,
     6            423, 429, 438, 441, 474, 486, 489, 603, 606, 615, 621,
     7            630, 633, 663, 669, 693, 726, 729, 741, 858, 870, 873,
     8            918, 921, 933, 367, 379, 382, 415, 439, 445, 475, 478,
     9            487, 493, 502, 505, 607, 631, 637, 727, 733, 757, 859,
     a            862, 871, 877, 886, 889, 919, 925, 949, 982, 985, 997,
     1            383, 479, 503, 509, 863, 887, 893, 983, 989,1013, 426,
     2            618, 666, 678, 681, 427, 430, 442, 490, 619, 622, 634,
     3            667, 670, 679, 685, 694, 697, 730, 742, 745, 874, 922,
     4            934, 937, 431, 443, 446, 491, 494, 506, 623, 635, 638,
     5            671, 695, 701, 731, 734, 743, 749, 758, 761, 875, 878,
     6            890, 923, 926, 935, 941, 950, 953, 986, 998,1001, 447,
     7            495, 507, 510, 639, 735, 759, 765, 879, 891, 894, 927,
     8            951, 957, 987, 990, 999,1005,1014,1017, 511, 895, 991,
     9           1015,1021, 682, 683, 686, 698, 746, 938, 687, 699, 702,
     a            747, 750, 762, 939, 942, 954,1002, 703, 751, 763, 766,
     1            943, 955, 958,1003,1006,1018, 767, 959,1007,1019,1022,
     2           1023,
     -           1365,1366,1369,1381,1429,1621,2389,1367,1373,1397,1493,
     1           1877,3413,1370,1382,1385,1430,1433,1445,1622,1625,1637,
     2           1685,2390,2393,2405,2453,2645,1371,1374,1383,1389,1398,
     3           1401,1431,1437,1461,1494,1497,1509,1623,1629,1653,1749,
     4           1878,1881,1893,1941,2391,2397,2421,2517,2901,3414,3417,
     5           3429,3477,3669,1375,1399,1405,1495,1501,1525,1879,1885,
     6           1909,2005,3415,3421,3445,3541,3925,1386,1434,1446,1449,
     7           1626,1638,1641,1686,1689,1701,2394,2406,2409,2454,2457,
     8           2469,2646,2649,2661,2709,1387,1390,1402,1435,1438,1447,
     9           1453,1462,1465,1498,1510,1513,1627,1630,1639,1645,1654,
     a           1657,1687,1693,1717,1750,1753,1765,1882,1894,1897,1942,
     1           1945,1957,2395,2398,2407,2413,2422,2425,2455,2461,2485,
     2           2518,2521,2533,2647,2653,2677,2773,2902,2905,2917,2965,
     3           3418,3430,3433,3478,3481,3493,3670,3673,3685,3733,1391,
     4           1403,1406,1439,1463,1469,1499,1502,1511,1517,1526,1529,
     5           1631,1655,1661,1751,1757,1781,1883,1886,1895,1901,1910,
     6           1913,1943,1949,1973,2006,2009,2021,2399,2423,2429,2519,
     7           2525,2549,2903,2909,2933,3029,3419,3422,3431,3437,3446,
     8           3449,3479,3485,3509,3542,3545,3557,3671,3677,3701,3797,
     9           3926,3929,3941,3989,1407,1503,1527,1533,1887,1911,1917,
     a           2007,2013,2037,3423,3447,3453,3543,3549,3573,3927,3933,
     1           3957,4053,1450,1642,1690,1702,1705,2410,2458,2470,2473,
     2           2650,2662,2665,2710,2713,2725,1451,1454,1466,1514,1643,
     3           1646,1658,1691,1694,1703,1709,1718,1721,1754,1766,1769,
     4           1898,1946,1958,1961,2411,2414,2426,2459,2462,2471,2477,
     5           2486,2489,2522,2534,2537,2651,2654,2663,2669,2678,2681,
     6           2711,2717,2741,2774,2777,2789,2906,2918,2921,2966,2969,
     7           2981,3434,3482,3494,3497,3674,3686,3689,3734,3737,3749,
     8           1455,1467,1470,1515,1518,1530,1647,1659,1662,1695,1719,
     9           1725,1755,1758,1767,1773,1782,1785,1899,1902,1914,1947,
     a           1950,1959,1965,1974,1977,2010,2022,2025,2415,2427,2430,
     1           2463,2487,2493,2523,2526,2535,2541,2550,2553,2655,2679,
     2           2685,2775,2781,2805,2907,2910,2919,2925,2934,2937,2967,
     3           2973,2997,3030,3033,3045,3435,3438,3450,3483,3486,3495,
     4           3501,3510,3513,3546,3558,3561,3675,3678,3687,3693,3702,
     5           3705,3735,3741,3765,3798,3801,3813,3930,3942,3945,3990,
     6           3993,4005,1471,1519,1531,1534,1663,1759,1783,1789,1903,
     7           1915,1918,1951,1975,1981,2011,2014,2023,2029,2038,2041,
     8           2431,2527,2551,2557,2911,2935,2941,3031,3037,3061,3439,
     9           3451,3454,3487,3511,3517,3547,3550,3559,3565,3574,3577,
     a           3679,3703,3709,3799,3805,3829,3931,3934,3943,3949,3958,
     1           3961,3991,3997,4021,4054,4057,4069,1535,1919,2015,2039,
     2           2045,3455,3551,3575,3581,3935,3959,3965,4055,4061,4085,
     3           1706,2474,2666,2714,2726,2729,1707,1710,1722,1770,1962,
     4           2475,2478,2490,2538,2667,2670,2682,2715,2718,2727,2733,
     5           2742,2745,2778,2790,2793,2922,2970,2982,2985,3498,3690,
     6           3738,3750,3753,1711,1723,1726,1771,1774,1786,1963,1966,
     7           1978,2026,2479,2491,2494,2539,2542,2554,2671,2683,2686,
     8           2719,2743,2749,2779,2782,2791,2797,2806,2809,2923,2926,
     9           2938,2971,2974,2983,2989,2998,3001,3034,3046,3049,3499,
     a           3502,3514,3562,3691,3694,3706,3739,3742,3751,3757,3766,
     1           3769,3802,3814,3817,3946,3994,4006,4009,1727,1775,1787,
     2           1790,1967,1979,1982,2027,2030,2042,2495,2543,2555,2558,
     3           2687,2783,2807,2813,2927,2939,2942,2975,2999,3005,3035,
     4           3038,3047,3053,3062,3065,3503,3515,3518,3563,3566,3578,
     5           3695,3707,3710,3743,3767,3773,3803,3806,3815,3821,3830,
     6           3833,3947,3950,3962,3995,3998,4007,4013,4022,4025,4058,
     7           4070,4073,1791,1983,2031,2043,2046,2559,2943,3039,3063,
     8           3069,3519,3567,3579,3582,3711,3807,3831,3837,3951,3963,
     9           3966,3999,4023,4029,4059,4062,4071,4077,4086,4089,2047,
     a           3583,3967,4063,4087,4093,2730,2731,2734,2746,2794,2986,
     1           3754,2735,2747,2750,2795,2798,2810,2987,2990,3002,3050,
     2           3755,3758,3770,3818,4010,2751,2799,2811,2814,2991,3003,
     3           3006,3051,3054,3066,3759,3771,3774,3819,3822,3834,4011,
     4           4014,4026,4074,2815,3007,3055,3067,3070,3775,3823,3835,
     5           3838,4015,4027,4030,4075,4078,4090,3071,3839,4031,4079,
     6           4091,4094,4095/
      data (rtw (i,1),i=1,9)/1.,0.,0.,0.,1.,0.,0.,0.,1./
      data (rtwi(i,1),i=1,9)/1.,0.,0.,0.,1.,0.,0.,0.,1./
      data OrbitName/'s','p','d','f','g','h'/
      data Clm/1.0000,
     1         1.0000,2*1.0000,
     2         0.5000,2*3.0000,2* 6.000,
     3         0.5000,2*1.5000,2*15.000,2* 15.000,
     4         0.1250,2*2.5000,2* 7.500,2*105.000,2*105.00,
     5         0.1250,2*1.8750,2*52.500,2* 52.500,2* 945.0,2*  945.,
     6         0.0625,2*2.6250,2*13.125,2*157.500,2* 472.5,2*10395.,
     6                2*10395.,
     7         0.0625,2*0.4375,2* 7.875,2* 39.375,2*1732.5,2*5197.5,
     8                2*135135.,2*135135./
      data Mlm/0.28209,
     1         0.48860,2*0.48860,
     2         0.31539,2*1.09255,2*1.09255,
     3         0.37318,2*0.45705,2*1.44531,2*0.59004,
     4         0.10579,2*0.66905,2*0.47309,2*1.77013,2*0.62584,
     5         0.11695,2*0.45295,2*2.39677,2*0.48924,2*2.07566,
     5                 2*0.65638,
     6         0.06357,2*0.58262,2*0.46060,2*0.92121,2*0.50457,
     6                 2*2.36662,2*0.68318,
     7         0.06828,2*0.09033,2*0.22127,2*0.15646,2*1.03783,
     7                 2*0.51892,2*2.64596,2*0.70716/
      data Llm/0.079578,
     1         0.318310,2*0.31831,
     2         0.206748,2*0.75000,2*0.75000,
     3         0.244854,2*0.32033,2*1.00000,2*0.42441,
     4         0.069418,2*0.47400,2*0.33059,2*1.25000,2*0.46875,
     5         0.076740,2*0.32298,2*1.68750,2*0.34515,2*1.50000,
     5                  2*0.50930,
     6         0.041710,2*0.41721,2*0.32611,2*0.65132,2*0.36104,
     6                  2*1.75000,2*0.54687,
     7         0.044800,2*0.06488,2*0.15732,2*0.11092,2*0.74044,
     8                  2*0.37723,2*2.00000,2*0.58205/
      data MlmC/0.282090E+00,
     1          0.488600E+00,2*0.488600E+00,
     2          0.630780E+00,2*0.364183E+00,2*0.182092E+00,
     3          0.746360E+00,2*0.304700E+00,2*0.963540E-01,
     3                       2*0.393360E-01,
     4          0.846320E+00,2*0.267620E+00,2*0.630787E-01,
     4                       2*0.168584E-01,2*0.596038E-02,
     5          0.935600E+00,2*0.241573E+00,2*0.456528E-01,
     5                       2*0.931886E-02,2*0.219647E-02,
     5                       2*0.694582E-03,
     6          0.101712E+01,2*0.221950E+00,2*0.350933E-01,
     6                       2*0.584895E-02,2*0.106787E-02,
     6                       2*0.227669E-03,2*0.657220E-04,
     7          0.109248E+01,2*0.206469E+00,2*0.280978E-01,
     7                       2*0.397359E-02,2*0.599036E-03,
     7                       2*0.998403E-04,2*0.195801E-04,
     7                       2*0.523299E-05/
      data LlmC/0.795780E-01,
     1          0.318310E+00,2*0.318310E+00,
     2          0.413496E+00,2*0.250000E+00,2*0.125000E+00,
     3          0.489708E+00,2*0.213553E+00,2*0.666667E-01,
     3                       2*0.282940E-01,
     4          0.555344E+00,2*0.189600E+00,2*0.440787E-01,
     4                       2*0.119048E-01,2*0.446429E-02,
     5          0.613920E+00,2*0.172256E+00,2*0.321429E-01,
     5                       2*0.657429E-02,2*0.158730E-02,
     5                       2*0.538942E-03,
     6          0.667360E+00,2*0.158937E+00,2*0.248465E-01,
     6                       2*0.413537E-02,2*0.764106E-03,
     6                       2*0.168350E-03,2*0.526089E-04,
     7          0.716800E+00,2*0.148297E+00,2*0.199771E-01,
     7                       2*0.281702E-02,2*0.427382E-03,
     7                       2*0.725791E-04,2*0.148000E-04,
     7                       2*0.430717E-05/
      end
      block data BlokFourier
      include 'params.cmn'
      include 'basic.cmn'
      include 'fourier.cmn'
      data IdFour/'harmonic','addbord','maptype','orient',
     1        'positive','negative','calc','peaks','subsys','method',
     2        'chkforeq','weight','#i13','#i14','#i15','#i16','#i17',
     3        '#i18','#i19','#i20',
     4        'snlmn','snlmx','cutting','step','uiso','biso','dmax',
     5        '#r28','#r29','#r30','#r31','#r32','#r33','#r34','#r35',
     6        '#r36','#r37','#r38','#r39','#r40',
     7        'xlim','ylim','zlim','x1lim','x2lim','x3lim','x4lim',
     8        'x5lim','x6lim','center','scope','refm80','#c53','#c54',
     9        '#c55','#c56','#c57','#c58','#c59','#c60'/
      data (DefIntFour(i),i=1,12)/2*1,4,3*-333,6*1/
      data (DefRealFour(i),i=21,27)/0.,10.,0.,.25,2*0.,1./
      end
      block data BlokDist
      include 'params.cmn'
      include 'basic.cmn'
      include 'dist.cmn'
      data IdDist/'round','angles','fullcoor','each','include',
     1            'ttables','lsttype','#i8','#i9','#i10','#i11','#i12',
     2            '#i13','#i14','#i15','#i16','#i17','#i18','#i19',
     3            '#i20',
     4            'dmin','dmax','occcut','occind','#r25','#r26','#r27',
     5            '#r28','#r29','#r30','#r31','#r32','#r33','#r34',
     6            '#r35','#r36','#r37','#r38','#r39','#r40',
     7            'nooft','tzero','select','torsion','plane','bondval',
     8            'selfirst','selsecnd','tfirst','tlast','#c51','#c52',
     9            '#c53','#c54','#c55','#c56','#c57','#c58','#c59',
     a            '#c60'/
      data FormTD,FormTA/'(3f8.3,f9.4)','(3f8.3,f9.2)'/
      data (DefIntDist(i),i=1,20)/2*0,1,10,0,0,0,13*0/
      data (DefRealDist(i),i=21,40)/0.,-1.,0.,.1,16*0./
      end
      block data BlokPwd
      include 'params.cmn'
      include 'basic.cmn'
      include 'powder.cmn'
      data PrfFormat/'(6i4,f5.0,i4,2(2f10.4,e15.6))'/
      end
      block data BlokContour
      include 'params.cmn'
      include 'basic.cmn'
      include 'contour.cmn'
      data IdContour/'#i1','#i2','#i3','#i4','#i5',
     1               '#r1','#r2','#r3','#r4','#r5',
     2               'drawatom','pntplane','dltplane','scpplane',
     3               'shfplane','xtpcurve','pntcurve','plane',
     4               'endplane',
     5               '#c10','#c11','#c12','#c13','#c14','#c15',
     6               '#c16','#c17','#c18','#c19','#c20'/
      data (DefIntContour(i),i=1,5)/5*0/
      data (DefRealContour(i),i=6,10)/5*0./
      data CutOffDist/4./,ConOccLim/.5/
      data CPNIter,CPCrit,CPMaxStep,CPRhoMin,CPDmin,CPDmax,CPDGeom
     1    /40,.0001,.05,2*0.,2*2./,LocDMax/2.5/,DrawStyle/1/,
     2    SkipSameTypesBonds/.false./
      end
      block data BlokRefine
      include 'params.cmn'
      include 'basic.cmn'
      include 'refine.cmn'
      data (IdRefine(i),i=1,120)
     1       /'print','weight','cycles','fofc','fsquare','iext',
     2        'itypex','idistr','autkeys','selsat','derprint','dertest',
     3        'selcomp','skipbad','stat','indtw','autspec','ranpr',
     4        'method','grid','useunobs','overlap','repeat','simul',
     5        'memout','nlebail','esdcorr','auteln','convchck',
     6        'convcycl','twdetail','dolebail','sigmeth','mmaxtw',
     6        'wtsnthl','callfour','keydynam','ncdynam','#i39','#i40',
     7        'badref','yomin','yomax','unstab','snlmn','snlmx','damp',
     8        'corr','radius','twdiff','diff','siglevel','overdiff',
     9        'convlim','toldynam','reddynam','marqlam','uisolim',
     a        '#r59','#r60','#r61','#r62','#r63','#r64','#r65','#r66',
     1        '#r67','#r68','#r69','#r70','#r71','#r72','#r73','#r74',
     2        '#r75','#r76','#r77','#r78','#r79','#r80',
     3        'omdif','thdif','chidif','absorb','dfoftw','checkran',
     4        'skipflag','#c88','#c89','#c90','#c91','#c92','#c93',
     5        '#c94','#c95','#c96','#c97','#c98','#c99','#c100',
     6        'restric','equation','fixed','dontuse','scale','distfix',
     7        'anglefix','torsfix','keep','#a110','#a111','#a112',
     8        '#a113','#a114','#a115','#a116','#a117','#a118','#a119',
     9        '#a120'/
      data (DefIntRefine(i),i=1,40)/-2,0,10,3*0,3*1,-2,4*0,1,0,1,0,1,32,
     1                              1,0,1,2*0,1,0,1,1,1,0,0,4,4,0,0,0,3,
     2                              2*0/
      data (DefRealRefine(i),i=41,80)/3.,5.,200.,2*0.,10.,1.,.9,.01,.1,
     1                                .00001,3.,-0.01,0.05,10.,2.,.001,
     2                                0.2,22*0./
      data label1,label2,label3,l5,l7,l8,l9,l10/'ai','x','y','z','phi',
     1     'chi','psi','Uiso','rho iso','g iso','phason','o'/
      data lk1,lk2/'kappa','kappa'''/
      data lcell/'a','b','c','alpha','beta','gamma'/
      data lShiftPwd/'shift','sycos','sysin'/
      data lPrefPwd/'pref'/,lRoughPwd/'rough'/,lBackgPwd/'bckg'/
      data lGaussPwd/'GU','GV','GW','GP'/,lStPwd/'St'/
      data lLorentzPwd/'LX','LXe','LY','LYe','Dzeta'/
      data lAsymPwd/'asym'/,lAsymPwdD/'S/L','H/L'/
      data cfix/'all','xyz','u','beta','mod','pol','x4','ind','value'/
      data CKeepType/'hydro','geom','ADP'/
      data CKeepHydro/'tetrahed','triang','apical'/
      data CKeepGeom/'plane','rigid'/
      data CKeepADP/'riding',' '/
      end
      block data BlokGrapht
      include 'params.cmn'
      include 'basic.cmn'
      include 'grapht.cmn'
      data gx/0.,1.,.01,0.,1.,.01,0.,1.,.01/,gy/.1,0./,DrawDMax/3./
      data ior/1,2,3/,WhatToDraw/0/
      data UseRefLevel,DrawNonMod,DrawTCommen/3*.false./
      data SmbU/' U11',' U22',' U33',' Ueq'/,OccLimit/0/
      end

