/*
 * StringOperations.cpp
 *
 *  Created on: 13.4.2011
 *      Author: hartman
 */

#include "StringOperations.h"
#include <stdio.h>
#include <stdlib.h>
#include <cmath>

vector<double>* StringOperations::readInterval(string line)
{
	vector<double> *result = new vector<double>();
	string work = line;

	size_t pos = work.find(",");
	if (pos == string::npos)
		pos = work.length();

	while (pos != string::npos)
	{
		// extract interval
		string subinterval = work.substr(0,pos);
		size_t delim1 = subinterval.find(":");

		// checking interval or number
		if (delim1 != string::npos)
		{
			int delim2 = subinterval.rfind(":");

			double start = atof(subinterval.substr(0,delim1).c_str());
			double step = atof(subinterval.substr(delim1+1,delim2).c_str());
			double end = atof(subinterval.substr(delim2+1,subinterval.length()).c_str());

			// generate interval and add it to result
			double d = start;
			bool upward = (end > start);

			while ((upward) ? d < end: d > end)
			{
				result->push_back(d);
				d = (upward) ? d + step:d - step;
			}
		}
		else
		{
			double d = atof(subinterval.c_str());
			result->push_back(d);
		}

		// continue to next step
		if (pos < work.length())
		{
			work = work.substr(pos + 1,work.length());
			pos = work.find(",");
		}
		else
		{
			pos = string::npos;
		}
	}

	return result;
}

string StringOperations::formatOutputNumber(double num)
{
	if (std::isinf(num) == 1)
		return "inf";
	else if (std::isnan(num) == 1)
		return "nan";

	ostringstream oss(ostringstream::out);

	if (num > 0 && num < 1e-300)
	{
		oss << 0.0;
	}
	else
	{
		oss << num;
	}
	string s = oss.str();
	int origsize = (int) s.length();
	int diff = NUM_SIZE - origsize;

	if (diff > 0)
	{
		for (int i = 0; i < diff; i++)
			oss << " ";
	}

	return oss.str();
}

void StringOperations::trim(string &s)
{
	while (s.length() > 0 && s[0] == ' ')
		s.erase(0,1);

	while (s.length() > 0 && (s[s.length()-1] == ' ' || s[s.length()-1] < 32))
		s.erase(s.length()-1,s.length()-1);
}

string StringOperations::spaces(int num)
{
	ostringstream oss(ostringstream::out);

	for (int i = 0; i < num; i++)
		oss << "           ";

	return oss.str();
}

string StringOperations::triuStr(double* triumat, int size)
{
	ostringstream oss(ostringstream::out);
	int indx = 0;
	for (int i = 0; i < size; i++)
	{
		oss << spaces(i);
		for (int j = i; j < size; j++)
		{
			oss << formatOutputNumber(triumat[indx++]) << " ";
		}
		oss << endl;
	}
	return oss.str();
}

string StringOperations::matStr(int* mat, int size)
{
	ostringstream oss(ostringstream::out);
	int indx = 0;
	for (int i = 0; i < size; i++)
	{
		for (int j = 0; j < size; j++)
		{
			oss << formatOutputNumber(mat[indx++]) << " ";
		}
		oss << endl;
	}
	return oss.str();
}

string StringOperations::matStr(double* mat, int size)
{
	ostringstream oss(ostringstream::out);
	int indx = 0;
	for (int i = 0; i < size; i++)
	{
		for (int j = 0; j < size; j++)
		{
			oss << formatOutputNumber(mat[indx++]) << " ";
		}
		oss << endl;
	}
	return oss.str();
}

string StringOperations::vecStr(double* mat, int size)
{
	ostringstream oss(ostringstream::out);
	for (int i = 0; i < size; i++)
	{
		oss << formatOutputNumber(mat[i]) << " ";
	}
	return oss.str();
}

string StringOperations::vecStr(int* mat, int size)
{
	ostringstream oss(ostringstream::out);
	for (int i = 0; i < size; i++)
	{
		oss << mat[i] << " ";
	}
	return oss.str();
}

string StringOperations::triuStr(int* triumat, int size)
{
	ostringstream oss(ostringstream::out);
	int indx = 0;
	for (int i = 0; i < size; i++)
	{
		oss << spaces(i);
		for (int j = i; j < size; j++)
		{
			oss << formatOutputNumber(triumat[indx++]) << " ";
		}
		oss << endl;
	}
	return oss.str();
}

string StringOperations::triuVecStr(vector<double> triumat, int size)
{
	ostringstream oss(ostringstream::out);
	int indx = 0;
	for (int i = 0; i < size; i++)
	{
		oss << spaces(i);
		for (int j = i; j < size; j++)
		{
			oss << formatOutputNumber(triumat[indx++]) << " ";
		}
		oss << endl;
	}
	return oss.str();
}
