/*
 * TestGraph.h
 *
 *  Created on: 26.1.2012
 *      Author: hartman
 */

#ifndef TESTGRAPH_H_
#define TESTGRAPH_H_

#include "../core/Graph.h"

class TestGraph: public Graph {
public:
	//TestGraph();
	TestGraph(int gsize);
	virtual ~TestGraph();

	/*!	Dummy method implementation */
	int maxNumberOfEdges();
	/** Dummy method implementation */
	int numberOfEdges();
	/** Dummy method implementation */
	double* betweenness(double** betweennessData = NULL, int saveData = true);
	/** Dummy method implementation */
	double* clusteringCoefficient(double** clusteringCoeffData = NULL, int saveData = RES_SAVED);
	/*!	Dummy method implementation */
	int numerOfTriangles(int nodeIndex);
	/*!	Dummy method implementation */
	double clusteringCoefficientGlobal();
	/*!	Dummy method implementation */
	vector<vector<int> >* components(vector<vector<int> >** componentsListData = NULL, int saveData = RES_SAVED);
	/*!	Dummy method implementation */
	double characterticPathLength();
	/*!	Dummy method implementation */
	int componentsNum();
	/*!	Dummy method implementation */
	double efficiency();
	/*!	Dummy method implementation */
	double transitivity();
	/*!	Dummy method implementation */
	double assortativeCoefficient();
	/*!	Dummy method implementation */
	double* closeness(double** closenessData = NULL, int saveData = RES_SAVED);
	/*!	Dummy method implementation */
	double* averageNearestNeighbor(double** annData = NULL, int saveData = RES_SAVED);
	/*!	Dummy method implementation */
	int* componentsMat();
	/*!	Dummy method implementation */
	SymMatrix<int>* distanceMatrix(SymMatrix<int>* dmatrix = NULL, int saveData = RES_SAVED);


	void run_tests();

	void init_test();

	bool test_plainIntReturingCopyMethod();
	bool test_plainIntReferenceMethod();
	bool test_plainIntNotSavedMethod();
	bool test_plainIntReferenceWithNoInputMethod();
	bool test_plainIntJustSaveMethod();

	bool test_plainDoubleReturingCopyMethod();
	bool test_plainDoubleReferenceMethod();
	bool test_plainDoubleNotSavedMethod();
	bool test_plainDoubleReferenceWithNoInputMethod();
	bool test_plainDoubleJustSaveMethod();


private:
	TestGraph* g;
};

#endif /* TESTGRAPH_H_ */
