/*
 * testSparseUndiGraph.cpp
 *
 *  Created on: 24.1.2012
 *      Author: hartman
 */

#include <iostream>
#include <stdio.h>
#include <stdlib.h>
#include "testSparseUndiGraph.h"
#include "../aux/StringOperations.h"

using namespace std;

TestSparseUndiGraph::TestSparseUndiGraph() {
	sud = NULL;
}

TestSparseUndiGraph::~TestSparseUndiGraph() {
	// TODO Auto-generated destructor stub
}

void TestSparseUndiGraph::init_test()
{
	sud = (TestSparseUndiGraph *) SparseUndiGraph::sampleErdosRenyi(10,0.5);
}

bool TestSparseUndiGraph::test_degree()
{
	// create and compute with returning a reference
	int* degs = new int[sud->size()];
	sud->degrees(&degs,1);

	// control output and sum degrees
	cout << "---------------- Test Degrees returning a copy call ------------------------" << endl;
	cout << "Number of edges = " << sud->numberOfEdges() << endl; // prints Testing NDW graph
	cout << "Degrees  = [ "; // prints Testing NDW graph
	int sum = 0;
	for (int i = 0; i < sud->size(); i++)
	{
		sum += degs[i];
		cout << degs[i] << " ";
	}
	cout << "]" << endl;
	cout << "Internal = [" << StringOperations::vecStr(sud->degreesVector,sud->size()) << "]" << endl;

	// change array and look for internal vector changes
	cout << "Make correction" << endl;
	degs[2] = -1;
	degs[5] = -1;
	cout << "Output   = [" << StringOperations::vecStr(degs,sud->size()) << "]" << endl;
	cout << "Internal = [" << StringOperations::vecStr(sud->degreesVector,sud->size()) << "]" << endl;

	cout.flush();

	// clean
	delete sud;

	return 0;
}

bool TestSparseUndiGraph::test_betweenness()
{
	// create and compute with returning a reference
	double* BC = new double[sud->size()];
	sud->betweenness(&BC,RES_NOT_SAVED);

	// control output and sum degrees
	cout << "---------------- Test Degrees returning reference call ------------------------" << endl;
	cout << "Number of edges = " << sud->numberOfEdges() << endl; // prints Testing NDW graph
	cout << "BC = [" << StringOperations::vecStr(BC,sud->size()) << "]" << endl;
	//cout << "Internal = [" << StringOperations::vecStr(sud->betweennessVector,sud->size()) << "]" << endl;

	// change array and look for internal vector changes
//	cout << "Make correction" << endl;
//	BC[2] = -1;
//	BC[5] = -1;
//	cout << "BC   = [" << StringOperations::vecStr(BC,sud->size()) << "]" << endl;
//	cout << "Internal = [" << StringOperations::vecStr(sud->betweennessVector,sud->size()) << "]" << endl;

	cout.flush();

	// clean
	delete sud;

	return true;
}

bool TestSparseUndiGraph::test_distance_matrix()
{

	cout << "ER graph" << endl;
	cout << "Adjacent matrix:" << endl;
	cout << sud->to_s() << endl;
	cout << "-------------------------" << endl;
	// ER graph
//	SymMatrix<int> *D = new SymMatrix<int>(fud->size());
//	fud->distanceMatrix(D,RES_SAVED);
	SymMatrix<int> *D = sud->distanceMatrix();
	//cout << "ER graph distance matrix:" << sud->characterticPathLength() << endl;
	cout << "-------------------------" << endl;
	cout << "Distance matrix" << endl;
	cout << D->to_s() << endl;
	int* data = new int[sud->size()*sud->size()];
	D->getFullData(data);
	cout << "Data:" << endl;
	int k = 0;
	for (int i = 0; i < sud->size(); i++)
	{
		for (int j = 0; j < sud->size(); j++)
		{
			cout << data[k++] << " ";
		}
		cout << endl;
	}

//	// complete graph
//	SparseUndiGraph* completeGraph = SparseUndiGraph::K_m(10);
//	SymMatrix<int> *DD = new SymMatrix<int>(10);
//	completeGraph->distanceMatrix(DD,RES_SAVED);
//	cout << "Complete graph distance matrix:" << completeGraph->characterticPathLength()<< endl;
//	cout << DD->to_s() << endl;

//	// null graph
//	SparseUndiGraph* nullGraph = new SparseUndiGraph();
//	SymMatrix<int> *DDD = new SymMatrix<int>(10);
//	nullGraph->distanceMatrix(DDD,RES_SAVED);
//	cout << "Null graph distance matrix:" << nullGraph->characterticPathLength()<< endl;
//	cout << DDD->to_s() << endl;

	delete sud;
//	delete nullGraph;
//	delete completeGraph;

	return true;
}


void TestSparseUndiGraph::run_tests()
{
	init_test();
	//test_degree();
	test_distance_matrix();
}
