#include <cstring>
#include <math.h>
#include <matrix.h>
#include <mex.h>
#include "core/Graph.h"

#define G_IN prhs[0]
#define CMP_OUT plhs[0]

void mexFunction(int nlhs, mxArray * plhs[], int nrhs, const mxArray * prhs[]){   
    
    Graph* g;
    unsigned long * G_ptr;
    int* CMP_out;
    int gsize, glen;
    
    /* check input parameters */
    if(nrhs != 1)
    {
        mexErrMsgTxt("One input argument is required: Graph handle.");
    }
    if(nlhs != 1)
    {
        mexErrMsgTxt("One output argument is required: vector for betweenness centrality.");
    }
    
    /* check handle */
    if (!mxIsUint64(G_IN))
    {
        mexErrMsgTxt("Graph handle should be uint64 number.");
    }    
    
    /* get pointer to class */
    G_ptr = (unsigned long*)mxGetData(G_IN);
    g = (Graph *) (*G_ptr);
    gsize = g->size();
    glen = gsize*gsize;
    
    /* allocate output argument */
    if (CMP_OUT == NULL)
    {
        CMP_OUT = mxCreateNumericMatrix(glen, 1, mxINT32_CLASS,0);
    }
    CMP_out = (int*)mxGetPr(CMP_OUT);
    //mexPrintf("Size is %d BC %d = [",gsize,g->numberOfEdges());
     
    CMP_out = g->componentsMat();
    
    //mexPrintf("%f \n",*CMP_out);
}
