#include <cstring>
#include <math.h>
#include <matrix.h>
#include <mex.h>
#include "core/FullUndiGraph.h"

#define A_IN prhs[0]
#define G_OUT plhs[0]

void mexFunction(int nlhs, mxArray * plhs[], int nrhs, const mxArray * prhs[]){   
    
    bool * A;
    FullUndiGraph* g;
    unsigned long * G_out;
    int nrows, ncols;
    
    /* check input parameters */
    if(nrhs < 1 || nrhs > 2)
    {
        mexErrMsgTxt("Input arguments can be: \n "
                "\t 1. weighted graph and threshold, \n"
                "\t 2. double connectivity matrix and threshold, \n"
                "\t 3. integer (bool) connectivity matrix only. \n");
    }
    else if(nlhs != 1)
    {
        mexErrMsgTxt("One output argument is required: the unweighted graph handle.");
    }
    
    /* check input arguments square matrix */
    nrows = mxGetM(A_IN);
    ncols = mxGetN(A_IN);
    
    if (ncols != nrows || (!mxIsLogical(A_IN) && !mxIsNumeric(A_IN))) // numeric matrix
    {
        mexErrMsgTxt("Input argument has to be binary square matrix.");
    }
    
    /* allocate output argument */
    G_OUT = mxCreateNumericMatrix(1, 1, mxUINT64_CLASS, mxREAL);
    G_out = (unsigned long*)mxGetData(G_OUT);

    /* construct the graph */
    bool* mat = (bool*)mxGetPr(A_IN);
//     for (int i = 0; i < nrows; i++)
//     {
//         for (int j = 0; j < nrows; j++)
//         {
//             mexPrintf("%d ", mat[i*nrows + j]);
//         }
//         mexPrintf("\n");
//     }    
    
    
    int len = nrows*(nrows + 1) / 2;
    
    bool* tmat;
    // create triangular
    if (mxIsLogical(A_IN))
    {
        tmat = new bool[len];
        bool* source = mat;
        bool* dest = tmat;
        int amount = nrows;
        for (int i; i < nrows; i++)
        {
            memcpy(dest, source, amount*sizeof(bool));
            dest += amount;
            source += (nrows + 1);
            amount--;
        } 
    }
    else
    {
        tmat = new bool[len];
        int idx = 0;
        int where = 0;
        for (int i = 0; i < nrows; i++, where += nrows)
        {
            int there = where;
            for (int j = i; j < nrows; j++, there++)
                tmat[idx] = (bool) mat[where];
        }
    }
//    mexPrintf("\n");
//    int idx = 0;
//     for (int i = 0; i < nrows; i++)
//     {
//         for (int j = i; j < nrows; j++)
//         {
//             mexPrintf("%d ", tmat[idx++]);
//         }
//         mexPrintf("\n");
//     }
        
    g = new FullUndiGraph(tmat,nrows);
    
    //mexPrintf("Size of graph is %d and %d \n",nrows, g->size());
    
    *G_out = (unsigned long)g;           
}
