#include <cstring>
#include <math.h>
#include <matrix.h>
#include <mex.h>
#include "core/Graph.h"

#define G_IN prhs[0]
#define M_OUT plhs[0]

void mexFunction(int nlhs, mxArray * plhs[], int nrhs, const mxArray * prhs[]){   
    
    Graph* g;
    unsigned long * G_ptr;
    int* M_out;
    int gsize;
    
    /* check input parameters */
    if(nrhs != 1)
    {
        mexErrMsgTxt("One input argument is required: Graph handle.");
    }
    if(nlhs != 1)
    {
        mexErrMsgTxt("One output argument is required: vector for betweenness centrality.");
    }
    
    /* check handle */
    if (!mxIsUint64(G_IN))
    {
        mexErrMsgTxt("Graph handle should be uint64 number.");
    }    
    
    /* get pointer to class */
    G_ptr = (unsigned long*)mxGetData(G_IN);
    g = (Graph *) (*G_ptr);
    gsize = g->size();

        /* allocate output argument */
    if (M_OUT == NULL)
    {
        M_OUT = mxCreateNumericMatrix(1, 1, mxINT32_CLASS, mxREAL);
    }
    M_out = (int*)mxGetPr(M_OUT);
     
    /* construct the graph */
    *M_out = g->numberOfEdges();
    
}
