#include <cstring>
#include <math.h>
#include <matrix.h>
#include <mex.h>
#include "core/Graph.h"

#define G_IN prhs[0]
#define T_OUT plhs[0]

void mexFunction(int nlhs, mxArray * plhs[], int nrhs, const mxArray * prhs[]){   
    
    Graph* g;
    unsigned long * G_ptr;
    double* T_out;
    int gsize;
    
    /* check input parameters */
    if(nrhs != 1)
    {
        mexErrMsgTxt("One input argument is required: Graph handle.");
    }
    if(nlhs != 1)
    {
        mexErrMsgTxt("One output argument is required: vector for efficiency.");
    }
    
    /* check handle */
    if (!mxIsUint64(G_IN))
    {
        mexErrMsgTxt("Graph handle should be uint64 number.");
    }    
    
    /* get pointer to class */
    G_ptr = (unsigned long*)mxGetData(G_IN);
    g = (Graph *) (*G_ptr);
    gsize = g->size();

        /* allocate output argument */
    if (T_OUT == NULL)
    {
        T_OUT = mxCreateDoubleMatrix(1, 1, mxREAL);
        //mexPrintf("NULL applied");
    }
    T_out = (double*)mxGetPr(T_OUT);
    //mexPrintf("Size is %d BC %d = [",gsize,g->numberOfEdges());
     
    /* construct the graph */
    *T_out = g->transitivity();
    
    //mexPrintf("%f \n",*T_out);
}
