classdef ndw_graph < handle 
    properties(Hidden = true, SetAccess = 'protected'), %-properties-
        handle              % handle to graph instance in cpp
    end % -----------------------------------------------------------------
    
    properties(GetAccess = 'protected', SetAccess = 'protected'), %-properties-
        k_vector = []       % degrees 
        BC_vector = []      % betweennesss centrality
        CC_vector = []      % clusterin coefficient
        CL_vector = []      % closeness
        ANN_vector = []     % average nearest neighbor
        D_mat = []          % distance matrix
        CMP_mat = []        % component matrix
    end % -----------------------------------------------------------------
        
    methods  % ------------ constructor and descructor section ------------
        
        function delete(hObject)                % destructor
            ndw_del_graph(hObject.handle);
        end
        
    end % -----------------------------------------------------------------
    
    
    methods  % ---------- Methods implemented in separate files -----------
        %
        [ k ] = degrees(hObject) % 
        [ m ] = num_edges(hObject) %
        [ BC ] = betweenness(hObject) %
        [ CC ] = clustering(hObject) %
        [ CC_glob ] = clustering_coeff(hObject) %
        [ CMP ] = components(hObject)
        [ CMP_num ] = components_num(hObject) %
        [ D ] = distance_mat(hObject) %
        [ CP_glob ] = charpath_len(hObject) %
        [ E ] = efficiency(hObject) %
        [ T ] = transitivity(hObject) %
        [ r ] = assortative_coeff(hObject) %
        [ CL ] = closeness(hObject) %
        [ ANN ] = average_nearest_neighbor(hObject) %
    end % -----------------------------------------------------------------
    
    methods(Static)  % -------------------- Static methods ----------------
        [ ER_graph_handle ] = rand_ER_graph(n,p)
        [ K_n ] = complete_graph(n)
    end % -----------------------------------------------------------------
    
end