/*
 * FullUndiGraph.cpp
 *
 *  Created on: 13.1.2012
 *      Author: hartman
 */

#include "FullUndiGraph.h"
#include <cstdlib>
#include <sstream>
#include <iostream>
#include <time.h>
#include <ctime>
#include <queue>
#include <vector>
#include <list>
#include <stack>
#include <algorithm>

FullUndiGraph::FullUndiGraph() {
}

FullUndiGraph::FullUndiGraph(SymMatrix<bool> *mat) {

	initialSettings();

	data = *mat;
	n = data.size();
	m = -1;
}

FullUndiGraph::FullUndiGraph(bool *mat, int n)
{
	initialSettings();

	data.setData(mat,n,true,false);
	this->n = data.size();
}

FullUndiGraph::FullUndiGraph(int *mat, int n)
{
	initialSettings();

	// new matrix of specified type with given length and no initialization
	int len = n*(n+1) / 2;
	bool* bmat = new bool[len];
	for (int i = 0; i < len; i++)
		bmat[i] = (mat[i] > 0.5) ? true:false;

	data.setData(bmat, n, true, false);
	this->n = data.size();
}


FullUndiGraph::~FullUndiGraph() {
	if (D != NULL && ((dGet & CHAR_STATE_GET) != 0))
		delete D;
}

int FullUndiGraph::numberOfEdges()
{
	bool* rawData = data.getData();
	int numEdges = 0;
	for (int i = 0; i < data.len(); i++)
		if (rawData[i])
			numEdges++;
	return numEdges;
}



int *FullUndiGraph::degrees(int** degreesData, int saveData)
{
	// ----------------- Init data storage --------------------------
	// determine input state
	int input_state = get_input_state(degreesData, degreesVector);
	// create reference to array of size n
	if (input_state == INPUT_NONE)
	{
		degreesData = new int*[0];
		*degreesData = new int[n];
	}

	// ------------------ computation part --------------------------
	// if no internal vector exists compute
	if (input_state == INPUT_NONE || input_state == INPUT_DATA)
	{
		int* results = *degreesData;
		memset(results, 0, sizeof(*results)*n);

		for (int i = 0; i < n; i++)
			for (int j = 0; j < n; j++)
				results[i] += (int) data(i,j);
//		memset(results, 0, sizeof(*results)*n);
//
//		// go through triangular matrix
//		int i = 0;
//		int j = 0;
//		int rowsize = n - 1;
//		for (int k = 0; k < data.len(); k++,j++)
//		{
//			if (data[k])
//			{
//				results[i]++;
//				results[j]++;
//			}
//
//			if (j == rowsize)
//			{
//				i++;
//				j = i;
//				rowsize--;
//			}
//		}
	}


	// ----------------- Storing data  --------------------------
	return close_int_method(input_state, saveData, degreesData, degreesVector, degreesVectorGet, size());
}

double *FullUndiGraph::betweenness(double **betweennessData, int saveData)
{
	// ----------------- Init data storage --------------------------
	// determine input state
	int input_state = get_input_state(betweennessData, betweennessVector);
	// create reference to array of size n
	if (input_state == INPUT_NONE)
	{
		betweennessData = new double*[0];
		*betweennessData = new double[n];
	}

	// ------------------ computation part --------------------------
	// if no internal vector exists compute
	if (input_state == INPUT_NONE || input_state == INPUT_DATA)
	{

			// put results into this array
			double* results = *betweennessData;
			memset(results,0,sizeof(double)*n);

			// process variables
			bc_sigma_t* sigma = new bc_sigma_t[n];
			bc_d_t* d = new bc_d_t[n];
			double* delta = new double[n];
			list<int>* P = new list<int>[n];

			// auxiliary fields with -1 and 0
			bc_d_t* d2 = new bc_d_t[n];
			std::fill(d2,d2+n,-1);
			double* delta2 = new double[n];
			memset(delta2,0,sizeof(*delta)*n);

			// stack
			int* S = new int[n];
			int sidx = 0;

			// queue
			int* Q = new int[n];
			int qstart = 0;
			int qend = 0;

			for (int s = 0; s < n; s++)
			{

				#if (INDICATION)
					cout << "\r Betweeness:" << s << "/" << n;
					cout.flush();
				#endif

				//stack<int> S;

				//memset(sigma,0,sizeof(bc_sigma_t)*n); // - not needed
				//std::fill(d,d+n,-1);
				memcpy(d,d2,n*sizeof(bc_d_t));

//				for (int j = 0; j < n; j++)
//				{
//					sigma[j] = 0;
//					d[j] = -1;
//				}
				sigma[s] = 1;
				d[s] = 0;


				//queue<int> Q;
				//Q.push(s);  // maybe push_back
				qstart = 0;
				qend = 0;
				Q[qend++] = s;

				//while (!Q.empty())
				for (int q = qstart; q < qend; q++)
				{
					//int v = Q.front();
					//Q.pop();
					int v = Q[qstart++];
					S[sidx++] = v;
					//S.push(v);

					// go through all neighbors
					int wdeg = n;
					bc_d_t d_v = d[v];
					bc_sigma_t sigma_v = sigma[v];
					for (int wid = 0; wid < wdeg; wid++)
					{
						if (data(v,wid) != 0) // TODO: check appropriate v usage
						{
							int w = wid;

							if (w != v) // only neighs
							{
								if (d[w] < 0)
								{
									//Q.push(w);
									Q[qend++] = w;
									d[w] = d_v + 1;
									sigma[w] = sigma_v;
									//P[w][pix[w]++] = v;
									P[w].push_back(v);
								}
								else if (d[w] == d_v + 1)
								{
									sigma[w] += sigma_v;
									P[w].push_back(v);
									//P[w][pix[w]++] = v;
									#if (DEBUG)
										cout << " sigma[" << w << "] = " << sigma[w] << endl;
									#endif

								}
							}
						}
					}
				}

				memcpy(delta,delta2,sizeof(double)*n);

//				for (int j = 0; j < n; j++)
//					delta[j] = 0.0;


				//while (!S.empty())
				for (int i = sidx - 1; i >= 0; i--)
				{
					//int w = S.top();
					//S.pop();
					int w = S[i];
					list<int>::iterator it;

					#if (DEBUG)
						//cout << "Prvek:" << w << endl;
					#endif

					double wcoeff = (1.0+delta[w]) / ((double)sigma[w]);


					//for (int k = 0; k<pix[w]; k++)
					for (it = P[w].begin() ; it != P[w].end(); it++)
					{
						// original
						int v = *it;  // int v = (int) *it
						delta[v] = delta[v] + sigma[v]*wcoeff;


						// int v = P[w].list[k];
						// delta[v] = delta[v] + sigma[v]*wcoeff;

						// My P
						//int v = P[w][k];  // int v = (int) *it
						//delta[v] = delta[v] + sigma[v]*wcoeff;

						#if (DEBUG)
							cout << "\t "<< delta[v] << "=" << sigma[v] << "/" << sigma[w] << "*(1 + " << delta[w] << ")" << endl;
						#endif
					}

					if (w != s)
					{
						results[w] = results[w] + delta[w];
						#if (DEBUG)
							cout << "\t Cb = "<< results[w] << endl;
						#endif
					}

					//P[w].count = 0;
				}

				// delete aux data
				for (int i = 0;  i < sidx; i++)
				{
					P[i].clear();
					// pix[w] = 0;
					// P[i].count = 0;
				}

				sidx = 0;
			}

			delete[] P;
			delete[] S;
			delete[] sigma;
			delete[] d;
			delete[] delta;
	}

	// ----------------- Storing data  --------------------------
	return close_double_method(input_state, saveData, betweennessData, betweennessVector, betweennessVectorGet, n);
}

int FullUndiGraph::numerOfTriangles(int nodeIndex)
{
	// TODO
	// auxiliary array with one on neighbor positions
	bool* nodeNeighs = new bool[data.size()];
	for (int j = 0; j < data.size(); j++)
	{
		//nodeNeighs[j] = (this->operator ()(nodeIndex,j) == 1) ? 1:0;
		nodeNeighs[j] = (data(nodeIndex,j) == 1) ? 1:0;
	}

	// go through matrix and sum suited elements (i.e. those [i,j] for which a_{nodeIndex,j} == 1)
	int sum = 0;
	int i = 0;
	int rlen = data.size();
	int indx = 0;

	while (indx < data.len())
	{
		// jump over non-interesting data.size()
		while (i < data.size() && nodeNeighs[i] == 0)
		{
			i++;
			indx += rlen;
			rlen--;
		}

		// for jumping over end
		if (i >= data.size())
			break;

		// go through elements of row
		for (int j = i; j < data.size(); j++)
		{
			// for nonexcluded and non-zero elements
			if (nodeNeighs[j] != 0 && data[indx] != 0)
			{
				sum += 2; // sum this and symmetric one
			}
			indx++;
		}

		// jump to next row
		i++;
		rlen--;
	}

	if (nodeNeighs != NULL)
		delete nodeNeighs;

	return sum;
}

FullUndiGraph *FullUndiGraph::sampleErdosRenyi(int num, double p)
{
	// create graph
	//FullUndiGraph* fud = new FullUndiGraph();
	//fud->n = num; // set number of vertices

	// create auxiliary variables
	//int maxNumEdges = maxNumberOfEdges();
	//int matSize = maxNumEdges + num;
	srand ( time(NULL) );

	// create data storage and fill it
	int matSize = num*(num + 1) / 2;
	bool* rawData = new bool[matSize];
	int idx = 0;
	int shift = num;
	for (int i = 0; i < matSize; i++)
	{
		if (i == idx)
		{
			rawData[i] = false; // diagonal is zero
			idx = idx + shift;
			shift--;
		}
		else
		{
			rawData[i] = (rand()/(RAND_MAX + 1.0) < p);
		}
	}

	// create data storage itself
	SymMatrix<bool> *mat = new SymMatrix<bool>(rawData,num,true,false);

	return new FullUndiGraph(mat);
}

SymMatrix<int> *FullUndiGraph::distanceMatrix(SymMatrix<int> *dmatrix, int saveData)
{
	// ----------------- Init data storage --------------------------
	// determine input state
	int input_state = get_input_state(dmatrix, D);
	// create reference to array of size n
	if (input_state == INPUT_NONE)
	{
		dmatrix = new SymMatrix<int>(this->n);
	}

	// ------------------ computation part --------------------------
	// if no internal vector exists compute
	if (input_state == INPUT_NONE || input_state == INPUT_DATA)
	{
		// there is never path longer than this
		int infinite = data.size() + 1;
		int rowsize = data.size();

		// preparation work
		// new matrix with no element to init
		//D = new SymMatrix<int>(data.size(),NULL);
		SymMatrix<int> *DD = dmatrix;
		int j = 0;	// just indicator of already passed part of row - not an index
		for (int i = 0; i < data.len(); i++)
		{
			#if (INDICATION)
				cout << "\r Distance Matrix (prep):" << i << "/" << data.len();
				cout.flush();
			#endif

			// diagonal elements are not modified
			if (j != 0)
			{
				// just zero should be converted into infinite
				if (data[i] == 0)
				{
					(*DD)[i] = infinite;
				}
				else
				{
					(*DD)[i] = 1;  // we know now that on data[i] there is one
				}
			}
			else
			{
				(*DD)[i] = 0;  // we know now that on data[i] there is one
			}

			j++;
			if (j >= rowsize)
			{
				j = 0;
				rowsize--;
			}
		}

		int ij,ji,ik,kj;
		int irow,jrow;

		int krow = 0;
		for (int k = 0; k < n; k++)
		{
			irow = 0;
			for (int i = 0; i < n; i++)
			{
				ik = (i <= k) ? irow + k:krow + i;

				jrow = 0;
				for (int j = 0; j <= i; j++)
				{
					//ij = (i <= j) ? irow + j:jrow + i;
					ij = jrow + i;
					ji = jrow + i;
					kj = (k <= j) ? krow + j:jrow + k;

					if ((*DD)[ij] > ((*DD)[ik] + (*DD)[kj]))
					{
						(*DD)[ij] = (*DD)[ik] + (*DD)[kj];
						(*DD)[ij] = (*DD)[ji];
					}
					jrow += (n - j - 1);
				}
				irow += (n - i - 1);
			}
			krow += (n - k - 1);
		}

//		int ij,ji,ik,kj;
//		int irow,jrow,krow;
//
//		for (int k = 0; k < data.size(); k++)
//		{
//			krow = k*data.size() - (k*(k+1)/2);
//
//			for (int i = 0; i < data.size(); i++)
//			{
//				irow = i*data.size() - (i*(i+1)/2);
//				ik = (i <= k) ? irow + k:krow + i;
//
//				for (int j = 0; j <= i; j++)
//				{
//					jrow = j*data.size() - (j*(j+1)/2);
//					//ij = (i <= j) ? irow + j:jrow + i;
//					ij = jrow + i;
//					ji = jrow + i;
//					kj = (k <= j) ? krow + j:jrow + k;
//
//					if ((*DD)[ij] > ((*DD)[ik] + (*DD)[kj]))
//					{
//						(*DD)[ij] = (*DD)[ik] + (*DD)[kj];
//						(*DD)[ij] = (*DD)[ji];
//					}
//				}
//			}
//		}

	}

	return close_symmat_int_method(input_state, saveData, &dmatrix, D, dGet, size());
}


FullUndiGraph* FullUndiGraph::K_m(int m)
{
	// create data storage and fill it
	int matSize = m*(m + 1) / 2;
	bool* rawData = new bool[matSize];
	int idx = 0;
	int shift = m;
	for (int i = 0; i < matSize; i++)
	{
		if (i == idx)
		{
			rawData[i] = false; // diagonal is zero
			idx = idx + shift;
			shift--;
		}
		else
		{
			rawData[i] = true; // off-diagonal are ones
		}
	}

	// create data storage itself
	SymMatrix<bool> *mat = new SymMatrix<bool>(rawData,m,true,false);

	return new FullUndiGraph(mat);
}

void FullUndiGraph::initialSettings()
{
	D = NULL;
	dGet = false;
}

double FullUndiGraph::characterticPathLength()
{
	// compute distance matrix if necessary
	if (D == NULL)
		distanceMatrix(NULL, RES_SAVED);

	// get characteristic path length
//	int sum = 0;
//	double n = 0;
//	for (int i = 0; i < D->len(); i++)
//	{
//		int d = (*D)[i];
//		if (d < D->size())
//			sum += 2*d;
//		else
//			n++;
//
//		#if (INDICATION)
//			cout << "\r Average SP:" << i << "/" << data.len();
//			cout.flush();
//		#endif
//	}
//	double divisor = ((double)D->size())*(D->size()-1) - n;
//	result = (1/divisor)*sum;
	return D->meanOfNonzero(D->size() + 1);
}

double *FullUndiGraph::clusteringCoefficient(double **clusteringCoeffData, int saveData)
{
	// ----------------- Init data storage --------------------------
	// determine input state
	int input_state = get_input_state(clusteringCoeffData, clusteringCoeffVector);
	// create reference to array of size n
	if (input_state == INPUT_NONE)
	{
		clusteringCoeffData = new double*[0];
		*clusteringCoeffData = new double[n];
	}

	// ------------------ computation part --------------------------
	// if no internal vector exists compute
	if (input_state == INPUT_NONE || input_state == INPUT_DATA)
	{
		double* results = *clusteringCoeffData;

		if (degreesVector == NULL)
			degrees(NULL, RES_SAVED);

		for (int i = 0; i < data.size(); i++)
		{
			int k = degreesVector[i];
			if (k >= 2)
			{
				double a = numerOfTriangles(i);
				double ci = a/ (double) (k*k-k);
				results[i] = ci;
			}
			else
			{
				results[i] = 0;
			}

			#if (INDICATION)
				cout << "\r Clustering coeficient:" << i << "/" << data.size();
				cout.flush();
			#endif
		}
	}

	// ----------------- Storing data  --------------------------
	return close_double_method(input_state, saveData, clusteringCoeffData, clusteringCoeffVector, clusteringCoeffVectorGet, size());
}

double FullUndiGraph::clusteringCoefficientGlobal()
{
	if (clusteringCoeffVector == NULL)
		clusteringCoefficient(NULL, RES_SAVED);

	double CC = 0;
	for (int i = 0; i < n; i++)
	{
		CC += clusteringCoeffVector[i];
	}
	CC /= n;

	return CC;
}

void FullUndiGraph::visit(vector<vector<int> > *cmps, int i)
{
	visited[i] = true;
	(*cmps)[componentIndex].push_back(i);
	for (int j = 0; j < data.size(); j++)
	{
		if (data(i,j) && visited[j] == false)
		{
			visit(cmps, j);
		}
	}
}

vector<vector<int> > *FullUndiGraph::components(vector<vector<int> > **componentsListData, int saveData)
{

	// ----------------- Init data storage --------------------------
	// determine input state
	int input_state = get_input_state(componentsListData, componentsList);
	// create reference to array of size n
	if (input_state == INPUT_NONE)
	{
		componentsListData = new vector<vector<int> >*[0];
		*componentsListData = new vector<vector<int> >();
	}

	// ------------------ computation part --------------------------
	// if no internal vector exists compute
	if (input_state == INPUT_NONE || input_state == INPUT_DATA)
	{
		vector<vector<int> > *results = *componentsListData;

		visited = new bool[data.size()];
		for (int i = 0; i < data.size(); i++)
			visited[i] = false;


		componentIndex = -1;
		for (int i = 0; i < data.size(); i++)
		{
			if (visited[i] == false)
			{
				componentIndex++;
				results->push_back(vector<int>());

				visit(results, i);
			}
		}
	}

	return close_vecvec_int_method(input_state, saveData, componentsListData, componentsList, componentsGet, size());
}

bool FullUndiGraph::connected()
{
	visited = new bool[data.size()];
	for (int i = 0; i < data.size(); i++)
		visited[i] = false;

	bool connected = true;
	for (int i = 0; i < data.size(); i++)
	{
		if (visited[i] == false)
		{
			if (i > 0)
			{
				connected = false;
				break;
			}

			visit(i);
		}
	}

	return connected;
}

void FullUndiGraph::visit(int i)
{
	visited[i] = true;
	for (int j = 0; j < data.size(); j++)
		if (data(i,j) && visited[j] == false)
			visit(j);
}

int FullUndiGraph::componentsNum()
{
	visited = new bool[data.size()];
	for (int i = 0; i < data.size(); i++)
		visited[i] = false;

	int cmpNum = 0;
	for (int i = 0; i < data.size(); i++)
	{
		if (visited[i] == false)
		{
			cmpNum++;

			visit(i);
		}
	}

	return cmpNum;
}

string FullUndiGraph::to_s()
{
	std::stringstream matstr;
	matstr << "Full graph n = ";
	matstr << data.size();
	matstr << " m = ";
	matstr << numberOfEdges();
	matstr << "\n Matrix:\n";
	matstr << data.to_s();
	return matstr.str();
}

void FullUndiGraph::updateStructure(bool *mat, int n, bool triu)
{
}

void FullUndiGraph::changeState()
{
	UndiGraph::changeState();


}

double FullUndiGraph::efficiency()
{
	// compute distance matrix if necessary
	if (D == NULL)
		distanceMatrix(NULL, RES_SAVED);

	return D->meanOfNonzeroReciprocal(D->size() + 1);
}

double FullUndiGraph::transitivity()
{
	if (degreesVector == NULL)
		degrees(NULL, RES_SAVED);

	int denom = 0;
	double nom = 0;
	for (int i = 0; i < data.size(); i++)
	{
		int k = degreesVector[i];

		denom += (k*k - k);

		nom += numerOfTriangles(i);
	}

	return (nom / (double) denom);
}

double FullUndiGraph::assortativeCoefficient()
{
	double result = -1;

	if (degreesVector == NULL)
		degrees(NULL, RES_SAVED);

	int sum1d = 0;
	double sum2 = 0.0;
	int sum3d = 0;

	int rowbegin = 0;
	int i = 0; // row index
	int j = rowbegin; // column index

	int nonZeroElements = 0;

	// iterate over all edges
	for (int k = 0; k < data.len(); k++)
	{
		// if there is an edge
		if (data[k] == 1)
		{
			// count down sum
			sum1d += degreesVector[i] + degreesVector[j];
			sum2 += pow((double) degreesVector[i],2) + pow((double) degreesVector[j],2);
			sum3d += degreesVector[i] * degreesVector[j];

			nonZeroElements++;
		}

		j++;
		if (j >= data.size())
		{
			rowbegin++;
			j = rowbegin;
			i++;
		}
	}

	double sum1 = (double) sum1d;
	double sum3 = (double) sum3d;

	// update number of edges
	if (m == -1)
		m = nonZeroElements;

	// inverse number of edges
	double invl = 1/ (double) m;

	// assortative coeficient itself from Newman
	result = (invl * sum3 - pow(invl*0.5*sum1,2))/(invl*0.5*sum2 - pow(invl*0.5*sum1,2));

	return result;
}

double *FullUndiGraph::closeness(double **closenessData, int saveData)
{
	// ----------------- Init data storage --------------------------
	// determine input state
	int input_state = get_input_state(closenessData, closenessVector);
	// create reference to array of size n
	if (input_state == INPUT_NONE)
	{
		closenessData = new double*[0];
		*closenessData = new double[n];
	}

	// ------------------ computation part --------------------------
	// if no internal vector exists compute
	if (input_state == INPUT_NONE || input_state == INPUT_DATA)
	{
		// enumerate distance matrix to know all shortest paths
		if (D == NULL)
			distanceMatrix(NULL, RES_SAVED);

		// for each vertex count paths to others - sum all elements of distance matrix on one row

		// initialize sum of distances and degrees
		int* distsum = new int[data.size()];
		int* sizes = new int[data.size()];
		for (int i = 0; i < data.size(); i++)
		{
			distsum[i] = 0;
			sizes[i] = data.size();
		}

		// init maximal infinite value
		int infty = D->size() + 1;

		// count down distance sum and size of neighborhood
		int rowsize = data.size();
		int j = 0;
		int k = 0;
		for (int i=0; i < data.len(); i++)
		{
			if (j != 0)
			{
				if ((*D)[i] >= infty)
				{
					sizes[k]--;
					if (j != 0)
						sizes[k+j]--;

					// for other approaches
					// distsum[k] = INFTY_SUM;
					// if (j != 0)
					// 	distsum[k+j] = INFTY_SUM;
					// 	continue;
				}
				else
				{
					distsum[k] += (*D)[i];
					if (j != 0)
						distsum[k+j] += (*D)[i];
				}
			}

			j++;
			if (j >= rowsize)
			{
				j = 0;
				rowsize--;
				k++;
			}
		}

		// apply inverse
		for (int j =0; j < data.size(); j++)
		{
			if (distsum[j] == 0)
			{
				(*closenessData)[j] = 0;
			}
			else
			{
				// invdistsum[j] = (sizes[j] - 1) / ((double)distsum[j]);
				(*closenessData)[j] = 1 / ((double)distsum[j]);
			}
		}
	}

	// ----------------- Storing data  --------------------------
	return close_double_method(input_state, saveData, closenessData, closenessVector, closenessVectorGet, n);
}

double *FullUndiGraph::averageNearestNeighbor(double **annData, int saveData)
{
	// ----------------- Init data storage --------------------------
	// determine input state
	int input_state = get_input_state(annData, closenessVector);
	// create reference to array of size n
	if (input_state == INPUT_NONE)
	{
		annData = new double*[0];
		*annData = new double[n];
	}

	// ------------------ computation part --------------------------
	// if no internal vector exists compute
	if (input_state == INPUT_NONE || input_state == INPUT_DATA)
	{
		if (degreesVector == NULL)
			degrees(NULL, RES_SAVED);

		double* results = *annData;

		// enumerate average nearest neighbours
		results = new double[data.size()];

		for (int i = 0; i < data.size(); i++)
		{
			results[i] = 0.0;

			if (degreesVector[i] != 0)
			{
				for (int j = 0; j < data.size(); j++)
				{
					//if (this->operator ()(i,j) == 1)
					if (data(i,j) == 1)
						results[i] += degreesVector[j];
				}
				results[i] = results[i] / (double) degreesVector[i];
			}
		}
	}

	// ----------------- Storing data  --------------------------
	return close_double_method(input_state, saveData, annData, annVector, annVectorGet, n);
}

int *FullUndiGraph::componentsMat()
{
	if (componentsList == NULL)
		components(NULL, RES_SAVED);

	// get components number
	int cmpnum = componentsList->size();
	// get minimal and maximal number of elements in components
	int maxelems = 0;
	int minelems = data.size();
	int csize = 0;
	for (int i = 0; i < cmpnum; i++)
	{
		csize = (*componentsList)[i].size();
		if (csize > maxelems)
			maxelems = csize;
		if (csize < minelems)
			minelems = csize;
	}

	int clen = cmpnum*maxelems;
	int zlen = n - minelems;

	// create results
	int* results = new int[clen];
	int* pos = results;
	int* zeros = new int[zlen];
	memset(zeros,0,sizeof(double)*zlen);

	// copy components
	for (int i = 0; i < cmpnum; i++)
	{
		csize = (*componentsList)[i].size();
		int* from = &(*componentsList)[i].front();

		// fill data
		memcpy(pos,from,sizeof(int)*csize);

		pos = pos + csize;

		// fill resulting zeros
		memcpy(pos,zeros,sizeof(int)*(n - csize));
	}

	return results;
}






