/*
 * Graph.cpp
 *
 *  Created on: 13.1.2012
 *      Author: hartman
 */

#include "Graph.h"

Graph::Graph() {
	testingDoubleVector = NULL;
	testingIntVector = NULL;
	testingDoubleVectorGet = CHAR_STATE_INITIAL;
	testingIntVectorGet = CHAR_STATE_INITIAL;

	betweennessVector = NULL;
	betweennessVectorGet = CHAR_STATE_INITIAL;
	clusteringCoeffVector = NULL;
	clusteringCoeffVectorGet = CHAR_STATE_INITIAL;
	closenessVector = NULL;
	closenessVectorGet = CHAR_STATE_INITIAL;
	annVector = NULL;
	annVectorGet = CHAR_STATE_INITIAL;

	componentsList = NULL;
	componentsGet = CHAR_STATE_INITIAL;
	visited = NULL;
	componentIndex = 0;

	n = 0;
}

Graph::~Graph() {
	if (((testingDoubleVectorGet & CHAR_STATE_GET) != 0) && testingDoubleVector != NULL)
		delete testingDoubleVector;
	if (((testingIntVectorGet & CHAR_STATE_GET) != 0) && testingIntVector != NULL)
		delete testingIntVector;
	if (((betweennessVectorGet & CHAR_STATE_GET) != 0) && betweennessVector != NULL)
		delete betweennessVector;
	if (((clusteringCoeffVectorGet & CHAR_STATE_GET) != 0) && clusteringCoeffVector != NULL)
		delete clusteringCoeffVector;
}

int Graph::size()
{
	return n;
}

double* Graph::close_double_method(int input_state, int save, double** data, double* &vector, char_state_t &vectorGet, int n)
{
	// if no storage vector existed before
	if (input_state == INPUT_NONE || input_state == INPUT_DATA)
	{
		if (save == RES_SAVED || save == RES_JUST_SAVED)	// save reference
		{
			vector = *data;

			if (save == RES_JUST_SAVED)
				vectorGet = CHAR_STATE_GET;
		}
		else if (save == RES_COPY_SAVED)	// save a copy
		{
			vector = new double[n];
			memcpy(vector,*data,n*sizeof(double));
		}
	}
	// storage vector had to exist before - and so it contained results (no computation)
	else
	{
		if (save == RES_SAVED || save == RES_JUST_SAVED)	// save reference
		{
			// if both exist delete data to enable reference
			if (input_state == INPUT_BOTH)
				delete *data;

			*data = vector;

			if (save == RES_JUST_SAVED)
				vectorGet = CHAR_STATE_GET;
		}
		else if (save == RES_COPY_SAVED)	// save a copy
		{
			// if only vector exists create data to enable existence of two copies
			if (input_state == INPUT_VECTOR)
				*data = new double[n];

			memcpy(*data,vector,n*sizeof(double));
		}
	}

	// return reference to computed data (those has to exists in all cases)
	return *data;
}

/*!
 *  Method to return double data according to preset behavior
 */
int* Graph::close_int_method(int input_state, int save, int** data, int* &vector, char_state_t &vectorGet, int n)
{
	// if no storage vector existed before
	if (input_state == INPUT_NONE || input_state == INPUT_DATA)
	{
		if (save == RES_SAVED || save == RES_JUST_SAVED)	// save reference
		{
			vector = *data;

			if (save == RES_JUST_SAVED)
				vectorGet = CHAR_STATE_GET;
		}
		else if (save == RES_COPY_SAVED)	// save a copy
		{
			vector = new int[n];
			memcpy(vector,*data,n*sizeof(int));
		}
	}
	// storage vector had to exist before - and so it contained results (no computation)
	else
	{
		if (save == RES_SAVED || save == RES_JUST_SAVED)	// save reference
		{
			// if both exist delete data to enable reference
			if (input_state == INPUT_BOTH)
				delete *data;

			*data = vector;
			if (save == RES_JUST_SAVED)
				vectorGet = CHAR_STATE_GET;
		}
		else if (save == RES_COPY_SAVED)	// save a copy
		{
			// if only vector exists create data to enable existence of two copies
			if (input_state == INPUT_VECTOR)
				*data = new int[n];

			memcpy(*data,vector,n*sizeof(int));
		}
	}

	// return reference to computed data (those has to exists in all cases)
	return *data;
}

SymMatrix<int>* Graph::close_symmat_int_method(int input_state, int save, SymMatrix<int>** data, SymMatrix<int>* &vector, char_state_t &vectorGet, int n)
{
	// if no storage vector existed before
	if (input_state == INPUT_NONE || input_state == INPUT_DATA)
	{
		if (save == RES_SAVED || save == RES_JUST_SAVED)	// save reference
		{
			vector = *data;

			if (save == RES_JUST_SAVED)
				vectorGet = CHAR_STATE_GET;
		}
		else if (save == RES_COPY_SAVED)	// save a copy
		{
			vector = (*data)->clone();
		}
	}
	// storage vector had to exist before - and so it contained results (no computation)
	else
	{
		if (save == RES_SAVED || save == RES_JUST_SAVED)	// save reference
		{
			// if both exist delete data to enable reference
			if (input_state == INPUT_BOTH)
				delete *data;

			*data = vector;
			if (save == RES_JUST_SAVED)
				vectorGet = CHAR_STATE_GET;
		}
		else if (save == RES_COPY_SAVED)	// save a copy
		{
			// if only vector exists create data to enable existence of two copies
			if (input_state == INPUT_VECTOR)
				*data = vector->clone();
			else
				(*data)->setData(vector,true);
		}
	}

	// return reference to computed data (those has to exists in all cases)
	return *data;
}

double* Graph::plainDoubleReturingMethod(double** data, int saveData)
{
	// ----------------- Init data storage --------------------------
	// determine input state
	int input_state = get_input_state(data, testingIntVector);
	// create reference to array of size n
	if (input_state == INPUT_NONE)
	{
		data = new double*[0];
		*data = new double[n];
	}

	// ------------------ computation part --------------------------
	// if no internal vector exists compute
	if (input_state == INPUT_NONE || input_state == INPUT_DATA)
	{
		// return existing array or create computational array
		for (int i = 0; i < size(); i++)
		{
			(*data)[i] = i;
		}
	}

	// ----------------- Storing data  --------------------------
	return close_double_method(input_state, saveData, data, testingDoubleVector, testingDoubleVectorGet, size());
}

int *Graph::plainIntReturingMethod(int** data, int saveData)
{
	// ----------------- Init data storage --------------------------
	// determine input state
	int input_state = get_input_state(data, testingIntVector);
	// create reference to array of size n
	if (input_state == INPUT_NONE)
	{
		data = new int*[0];
		*data = new int[n];
	}

	// ------------------ computation part --------------------------
	// if no internal vector exists compute
	if (input_state == INPUT_NONE || input_state == INPUT_DATA)
	{
		// return existing array or create computational array
		for (int i = 0; i < size(); i++)
		{
			(*data)[i] = i;
		}
	}

	// ----------------- Storing data  --------------------------
	return close_int_method(input_state, saveData, data, testingIntVector, testingIntVectorGet, size());
}

vector<vector<int> > *Graph::close_vecvec_int_method(int input_state, int save, vector<vector<int> > **data, vector<vector<int> > *&vectorRef, char_state_t & vectorGet, int n)
{
	// TODO recheck
	// if no storage vector existed before
	if (input_state == INPUT_NONE || input_state == INPUT_DATA)
	{
		if (save == RES_SAVED || save == RES_JUST_SAVED)	// save reference
		{
			vectorRef = *data;

			if (save == RES_JUST_SAVED)
				vectorGet = true;
		}
		else if (save == RES_COPY_SAVED)	// save a copy
		{
			// TODO
//			vectorRef = new vector<vector<int> >((*data)->size());
//			for (size_t i = 0; i < (*data)->size(); i++)
//				copy((**data)[i].begin(), (**data)[i].end(), vectorRef[i].begin());
		}
	}
	// storage vector had to exist before - and so it contained results (no computation)
	else
	{
		if (save == RES_SAVED || save == RES_JUST_SAVED)	// save reference
		{
			// if both exist delete data to enable reference
			if (input_state == INPUT_BOTH)
				delete *data;

			*data = vectorRef;
			if (save == RES_JUST_SAVED)
				vectorGet = true;
		}
		else if (save == RES_COPY_SAVED)	// save a copy
		{
			// if both exist delete data to enable reference
			if (input_state == INPUT_BOTH)
				delete *data;

			// TODO
//			*data = new vector<vector<int> >(vectorRef->size());
//			for (size_t i = 0; i < vectorRef->size(); i++)
//				copy((*vectorRef)[i].begin(), (*vectorRef)[i].end(), (**data)[i].begin());
		}
	}

	// return reference to computed data (those has to exists in all cases)
	return *data;
}

double Graph::density()
{
	return numberOfEdges() / maxNumberOfEdges();
}

void Graph::changeState()
{
	// TODO
}










