/*
 * TypesDefs.h
 *
 *  Created on: 6.3.2012
 *      Author: hartman
 */

#ifndef TYPESDEFS_H_
#define TYPESDEFS_H_

// =========================== CONSTANTS ======================================

// ------------------------ METHODS PARAMETERS --------------------------------
/*! Compute results but not save, if already computed and saved => do nothing.
 * Responsibility of deleting remains as it was */
#define RES_NOT_SAVED 0
/*! Compute results, save and return reference if already computed and saved =>
 * just return. Responsibility of deleting remains on object (beware: after its
 * removal outside pointer is no longer valid pointer to results) */
#define RES_SAVED 1
/*! Compute results, save and return a copy, if already computed and saved =>
 * create a copy and return it. Responsibility of deleting remains on object
 * and outside caller has to delete its own copy. */
#define RES_COPY_SAVED 2
/*! Compute results, save and return reference, if already computed and saved =>
 * just return. Responsibility of deleting goes to caller (beware: after object's
 * removal outside pointer has to be also deleted) */
#define RES_JUST_SAVED 3

// ------------------------ INPUTS AND VECTORS --------------------------------
/** Neither data inputs nor storage vector are defined */
#define INPUT_NONE 0
/** Only storage vector is given */
#define INPUT_VECTOR 1
/** Only input data are given */
#define INPUT_DATA 2
/** Both vector and data are given */
#define INPUT_BOTH 3

// ------------------ STATE OF CHARACTERISTICS VECTORS ------------------------
/** Initial state of characteristic  */
#define CHAR_STATE_INITIAL 0
/** Indicator that characteristic has been accessed from outside and responsibility
 * of its deletion is transfered there */
#define CHAR_STATE_GET 1
/** Indicator that the structure of graph has changed and the characteristic is
 * no longer valid. However memory stays allocated.*/
#define CHAR_STATE_NOTVALID 2

/** Type for characteristic access state that should attain values: CHAR_STATE_INITIAL, CHAR_STATE_GET, CHAR_STATE_NOTVALID. */
typedef char char_state_t;

// ============================= TYPES ========================================

/*! Type used for sizes and indexing vectors and matrices */
typedef int idx_size_t;

/*! Type used for real data type */
typedef double real_data_t;

/*! Type used for integer data type */
typedef int int_data_t;

/*! Type used for integer data type. It can contains values BINARY_1 or BINARY_0 */
typedef bool binary_data_t;

/*! Indicator of yes for binary format used for binary_data_t */
#define BINARY_1 true

/*! Indicator of no for binary format used for binary_data_t */
#define BINARY_0 false

/*! Type used for auxiliary variable during computation of betweeneess centrality by Brandes algorithm */
//typedef unsigned long long bc_sigma_t;
typedef unsigned long bc_sigma_t;

/*! Type used for auxiliary variable during computation of betweeneess centrality by Brandes algorithm */
//typedef long bc_d_t;
typedef long bc_d_t;

/*! Type for BC auxiliary variable */
typedef double bc_aux_t;

typedef long attr_id_t;

typedef struct {
	attr_id_t* list;
	attr_id_t count;
	attr_id_t degree;
} plist_t;


#endif /* TYPESDEFS_H_ */
