/*
 * UndiGraph.h
 *
 *  Created on: 13.1.2012
 *      Author: hartman
 */

#ifndef UNDIGRAPH_H_
#define UNDIGRAPH_H_
#include "BinaryGraph.h"

class UndiGraph: public BinaryGraph {
public:
	UndiGraph();
	virtual ~UndiGraph();

	/*!
	 * 	Maximum number of edges this particular graph can have (depends on directionality, multiplicity etc.)
	 *
	 * @return Maximum number of edges in this graph.
	 */
	int maxNumberOfEdges();

	/*!
	 * Number edges adjacent to each of the vertex regardless of their possible orientation or weights.
	 *
	 * @return Degrees, i.e. number of adjacent edges to each vertex.
	 */
	virtual int* degrees(int** degreesData = NULL, int saveData = true) = 0;

protected:
	/*! Node degrees vector */
	int* degreesVector;

	/*! Inidicator that degrees vector has been get as a reference from outside*/
	char_state_t degreesVectorGet;

	/*!
	 * 	Method that is called if the structure of graph changes and so corresponding characteristics are no longer valid.
	 */
	void changeState();

};

#endif /* UNDIGRAPH_H_ */
