/*
 * TestFullUndiGraph.cpp
 *
 *  Created on: 28.1.2012
 *      Author: hartman
 */

#include "TestFullUndiGraph.h"

TestFullUndiGraph::TestFullUndiGraph() {
	fud = NULL;

}

TestFullUndiGraph::~TestFullUndiGraph() {
	// TODO Auto-generated destructor stub
}

void TestFullUndiGraph::run_tests()
{
	init_test();
	test_degree();
	//test_distance_matrix();
	//init_test();
	//test_clustering_coeff();
	//init_test();
	//test_components();
}

bool TestFullUndiGraph::test_degree()
{
	// create and compute with returning a reference
	int* degs = new int[fud->size()];
	fud->degrees(&degs,1);

	// control output and sum degrees
	cout << "---------------- Test Degrees returning a copy call ------------------------" << endl;
	cout << "Number of edges = " << fud->numberOfEdges() << endl; // prints Testing NDW graph
	cout << "Degrees  = [ "; // prints Testing NDW graph
	int sum = 0;
	for (int i = 0; i < fud->size(); i++)
	{
		sum += degs[i];
		cout << degs[i] << " ";
	}
	cout << "]" << endl;
	cout << "Internal = [" << StringOperations::vecStr(fud->degreesVector,fud->size()) << "]" << endl;

	// change array and look for internal vector changes
	cout << "Make correction" << endl;
	degs[2] = -1;
	degs[5] = -1;
	cout << "Output   = [" << StringOperations::vecStr(degs,fud->size()) << "]" << endl;
	cout << "Internal = [" << StringOperations::vecStr(fud->degreesVector,fud->size()) << "]" << endl;

	cout.flush();

	// clean
	delete fud;

	return 0;
}

bool TestFullUndiGraph::test_distance_matrix()
{

	// ER graph
//	SymMatrix<int> *D = new SymMatrix<int>(fud->size());
//	fud->distanceMatrix(D,RES_SAVED);
	SymMatrix<int> *D = fud->distanceMatrix();
	cout << "ER graph distance matrix:" << fud->characterticPathLength() << endl;
	cout << D->to_s() << endl;
	int* data = new int[fud->size()*fud->size()];
	D->getFullData(data);
	cout << "Data:" << endl;
	int k = 0;
	for (int i = 0; i < fud->size(); i++)
	{
		for (int j = 0; j < fud->size(); j++)
		{
			cout << data[k++] << " ";
		}
		cout << endl;
	}

	// complete graph
	FullUndiGraph* completeGraph = FullUndiGraph::K_m(10);
	SymMatrix<int> *DD = new SymMatrix<int>(10);
	completeGraph->distanceMatrix(DD,RES_SAVED);
	cout << "Complete graph distance matrix:" << completeGraph->characterticPathLength()<< endl;
	cout << DD->to_s() << endl;

	// null graph
	SymMatrix<bool> *ee = new SymMatrix<bool>(10);
	FullUndiGraph* nullGraph = new FullUndiGraph(ee);
	SymMatrix<int> *DDD = new SymMatrix<int>(10);
	nullGraph->distanceMatrix(DDD,RES_SAVED);
	cout << "Null graph distance matrix:" << nullGraph->characterticPathLength()<< endl;
	cout << DDD->to_s() << endl;

	delete fud;
	delete nullGraph;
	delete completeGraph;

	return true;
}


void TestFullUndiGraph::init_test()
{
	fud = (TestFullUndiGraph *) FullUndiGraph::sampleErdosRenyi(10,0.3);

	cout << "---------------- Matrix ------------------------" << endl;
	cout << fud->data.to_s();
	cout.flush();

}

bool TestFullUndiGraph::test_clustering_coeff()
{
	// ER graph
	cout << "CC for ER graph:" << fud->clusteringCoefficientGlobal() << endl;

	// complete graph
	FullUndiGraph* completeGraph = FullUndiGraph::K_m(10);
	cout << "CC for K_m:" << completeGraph->clusteringCoefficientGlobal() << endl;

	// null graph
	SymMatrix<bool> *ee = new SymMatrix<bool>(10);
	FullUndiGraph* nullGraph = new FullUndiGraph(ee);
	cout << "CC for I_n:" << nullGraph->clusteringCoefficientGlobal() << endl;

	delete fud;
	delete nullGraph;
	delete completeGraph;

	return true;
}

bool TestFullUndiGraph::test_components()
{
	// ER graph
//	vector<vector<int> > *cmps = fud->components(NULL, RES_SAVED);
//	cout << "CC for ER graph:" << cmps->size() << endl;
//	delete cmps;
//
//	// complete graph
//	FullUndiGraph* completeGraph = FullUndiGraph::K_m(10);
//	cmps = completeGraph->components(NULL, RES_SAVED);
//	cout << "CC for K_m:" << cmps->size() << endl;
//
//	// null graph
//	SymMatrix<bool> *ee = new SymMatrix<bool>(10,false,false);
//	FullUndiGraph* nullGraph = new FullUndiGraph(ee);
//	cmps = nullGraph->components(NULL, RES_SAVED);
//	cout << "CC for I_n:" << cmps->size() << endl;

	cout << "CC for ER graph:" << fud->componentsNum() << endl;

	// complete graph
	FullUndiGraph* completeGraph = FullUndiGraph::K_m(10);
	cout << "CC for K_m:" << completeGraph->componentsNum() << endl;

	// null graph
	SymMatrix<bool> *ee = new SymMatrix<bool>(10);
	FullUndiGraph* nullGraph = new FullUndiGraph(ee);
	cout << "CC for I_n:" << nullGraph->componentsNum() << endl;

	delete fud;
	delete nullGraph;
	delete completeGraph;

	return true;
}

int *TestFullUndiGraph::degrees(int **degreesData, int saveData)
{
	return NULL;
}









