/*
 * TestGraph.cpp
 *
 *  Created on: 26.1.2012
 *      Author: hartman
 */

#include <iostream>
#include <stdio.h>
#include <stdlib.h>
#include "TestGraph.h"
#include "../aux/StringOperations.h"

//TestGraph::TestGraph() {
//	n = 0;
//	g = NULL;
//}

TestGraph::TestGraph(int gsize) {
	n = gsize;
	g = NULL;
}

TestGraph::~TestGraph() {
	if (g != NULL)
		delete g;
}

int TestGraph::numberOfEdges()
{
	return n;
}

void TestGraph::run_tests()
{
	init_test();
	test_plainIntReturingCopyMethod();

	init_test();
	test_plainIntReferenceMethod();

	init_test();
	test_plainIntNotSavedMethod();

	init_test();
	test_plainIntReferenceWithNoInputMethod();

	init_test();
	test_plainIntJustSaveMethod();


	init_test();
	test_plainDoubleReturingCopyMethod();

	init_test();
	test_plainDoubleReferenceMethod();

	init_test();
	test_plainDoubleNotSavedMethod();

	init_test();
	test_plainDoubleReferenceWithNoInputMethod();

	init_test();
	test_plainDoubleJustSaveMethod();
}



void TestGraph::init_test()
{
	g = new TestGraph(10);
}

bool TestGraph::test_plainIntReturingCopyMethod()
{
	// create and compute with returning a reference
	int* data = new int[g->size()];
	g->plainIntReturingMethod(&data,RES_COPY_SAVED);

	// control output and sum degrees
	cout << "---------------- Test plain method returning a copy call ------------------------" << endl;
	cout << "data  = [ "; // prints Testing NDW graph
	int sum = 0;
	for (int i = 0; i < g->size(); i++)
	{
		sum += data[i];
		cout << data[i] << " ";
	}
	cout << "]" << endl;
	cout << "Internal = [" << StringOperations::vecStr(g->testingIntVector,g->size()) << "]" << endl;

	// change array and look for internal vector changes
	cout << "Make correction" << endl;
	data[2] = -1;
	data[5] = -1;
	cout << "Output   = [" << StringOperations::vecStr(data,g->size()) << "]" << endl;
	cout << "Internal = [" << StringOperations::vecStr(g->testingIntVector,g->size()) << "]" << endl;

	cout.flush();

	// clean
	delete g;
	g = NULL;
	delete data;

	return true;
}



bool TestGraph::test_plainIntReferenceMethod()
{
	// create and compute with returning a reference
	int* data = new int[g->size()];
	g->plainIntReturingMethod(&data,RES_SAVED);

	// control output and sum degrees
	cout << "---------------- Test plain method returning a reference ------------------------" << endl;
	cout << "data  = [ "; // prints Testing NDW graph
	int sum = 0;
	for (int i = 0; i < g->size(); i++)
	{
		sum += data[i];
		cout << data[i] << " ";
	}
	cout << "]" << endl;
	cout << "Internal = [" << StringOperations::vecStr(g->testingIntVector,g->size()) << "]" << endl;

	// change array and look for internal vector changes
	cout << "Make correction" << endl;
	data[2] = -1;
	data[5] = -1;
	cout << "Output   = [" << StringOperations::vecStr(data,g->size()) << "]" << endl;
	cout << "Internal = [" << StringOperations::vecStr(g->testingIntVector,g->size()) << "]" << endl;

	cout.flush();

	// clean
	delete g;
	g = NULL;

	// data has
	data = NULL;

	return true;
}

bool TestGraph::test_plainIntNotSavedMethod()
{
	// create and compute with returning a reference
	int* data = new int[g->size()];
	g->plainIntReturingMethod(&data,RES_NOT_SAVED);

	// control output and sum degrees
	cout << "---------------- Test plain method returning data without saving ------------------------" << endl;
	cout << "data  = [ "; // prints Testing NDW graph
	int sum = 0;
	for (int i = 0; i < g->size(); i++)
	{
		sum += data[i];
		cout << data[i] << " ";
	}
	cout << "]" << endl;
	cout << "Internal = [" << ((g->testingIntVector == NULL) ? "NULL":StringOperations::vecStr(g->testingIntVector,g->size())) << "]" << endl;

	// change array and look for internal vector changes
	cout << "Make correction" << endl;
	data[2] = -1;
	data[5] = -1;
	cout << "Output   = [" << StringOperations::vecStr(data,g->size()) << "]" << endl;
	cout << "Internal = [" << ((g->testingIntVector == NULL) ? "NULL":StringOperations::vecStr(g->testingIntVector,g->size())) << "]" << endl;

	cout.flush();

	// clean
	delete g;
	g = NULL;
	delete data;

	return true;
}

bool TestGraph::test_plainIntReferenceWithNoInputMethod()
{
	// create and compute with returning a reference
	int* data = new int[g->size()];
	data = g->plainIntReturingMethod();

	// control output and sum degrees
	cout << "---------------- Test plain method returning a reference with no input ------------------------" << endl;
	cout << "data  = [ "; // prints Testing NDW graph
	int sum = 0;
	for (int i = 0; i < g->size(); i++)
	{
		sum += data[i];
		cout << data[i] << " ";
	}
	cout << "]" << endl;
	cout << "Internal = [" << StringOperations::vecStr(g->testingIntVector,g->size()) << "]" << endl;

	// change array and look for internal vector changes
	cout << "Make correction" << endl;
	data[2] = -1;
	data[5] = -1;
	cout << "Output   = [" << StringOperations::vecStr(data,g->size()) << "]" << endl;
	cout << "Internal = [" << StringOperations::vecStr(g->testingIntVector,g->size()) << "]" << endl;

	cout.flush();

	// clean
	delete g;
	g = NULL;

	// data has
	data = NULL;

	return true;
}

bool TestGraph::test_plainDoubleReturingCopyMethod()
{
	// create and compute with returning a reference
	double* data = new double[g->size()];
	g->plainDoubleReturingMethod(&data,RES_COPY_SAVED);

	// control output and sum degrees
	cout << "---------------- Test plain double method returning a copy call ------------------------" << endl;
	cout << "data    = [ "; // prints Testing NDW graph
	int sum = 0;
	for (int i = 0; i < g->size(); i++)
	{
		sum += data[i];
		cout << StringOperations::formatOutputNumber(data[i]) << " ";
	}
	cout << "]" << endl;
	cout << "Internal = [" << StringOperations::vecStr(g->testingDoubleVector,g->size()) << "]" << endl;

	// change array and look for internal vector changes
	cout << "Make correction" << endl;
	data[2] = -1;
	data[5] = -1;
	cout << "Output   = [" << StringOperations::vecStr(data,g->size()) << "]" << endl;
	cout << "Internal = [" << StringOperations::vecStr(g->testingDoubleVector,g->size()) << "]" << endl;

	cout.flush();

	// clean
	delete g;
	g = NULL;
	delete data;

	return true;
}



bool TestGraph::test_plainDoubleReferenceMethod()
{
	// create and compute with returning a reference
	double* data = new double[g->size()];
	g->plainDoubleReturingMethod(&data,RES_SAVED);

	// control output and sum degrees
	cout << "---------------- Test plain double method returning a copy call ------------------------" << endl;
	cout << "data    = [ "; // prints Testing NDW graph
	int sum = 0;
	for (int i = 0; i < g->size(); i++)
	{
		sum += data[i];
		cout << StringOperations::formatOutputNumber(data[i]) << " ";
	}
	cout << "]" << endl;
	cout << "Internal = [" << StringOperations::vecStr(g->testingDoubleVector,g->size()) << "]" << endl;

	// change array and look for internal vector changes
	cout << "Make correction" << endl;
	data[2] = -1;
	data[5] = -1;
	cout << "Output   = [" << StringOperations::vecStr(data,g->size()) << "]" << endl;
	cout << "Internal = [" << StringOperations::vecStr(g->testingDoubleVector,g->size()) << "]" << endl;

	cout.flush();

	// clean
	delete g;
	g = NULL;

	// data has
	data = NULL;

	return true;
}

bool TestGraph::test_plainDoubleNotSavedMethod()
{
	// create and compute with returning a reference
	double* data = new double[g->size()];
	g->plainDoubleReturingMethod(&data,RES_NOT_SAVED);

	// control output and sum degrees
	cout << "---------------- Test plain double method returning data without saving ------------------------" << endl;
	cout << "data    = [ "; // prints Testing NDW graph
	int sum = 0;
	for (int i = 0; i < g->size(); i++)
	{
		sum += data[i];
		cout << StringOperations::formatOutputNumber(data[i]) << " ";
	}
	cout << "]" << endl;
	cout << "Internal = [" << ((g->testingDoubleVector == NULL) ? "NULL":StringOperations::vecStr(g->testingDoubleVector,g->size())) << "]" << endl;

	// change array and look for internal vector changes
	cout << "Make correction" << endl;
	data[2] = -1;
	data[5] = -1;
	cout << "Output   = [" << StringOperations::vecStr(data,g->size()) << "]" << endl;
	cout << "Internal = [" << ((g->testingDoubleVector == NULL) ? "NULL":StringOperations::vecStr(g->testingDoubleVector,g->size())) << "]" << endl;

	cout.flush();

	// clean
	delete g;
	g = NULL;
	delete data;

	return true;
}

bool TestGraph::test_plainDoubleReferenceWithNoInputMethod()
{
	// create and compute with returning a reference
	double* data = new double[g->size()];
	data = g->plainDoubleReturingMethod();

	// control output and sum degrees
	cout << "---------------- Test plain double method returning a copy call ------------------------" << endl;
	cout << "data    = [ "; // prints Testing NDW graph
	int sum = 0;
	for (int i = 0; i < g->size(); i++)
	{
		sum += data[i];
		cout << StringOperations::formatOutputNumber(data[i]) << " ";
	}
	cout << "]" << endl;
	cout << "Internal = [" << StringOperations::vecStr(g->testingDoubleVector,g->size()) << "]" << endl;

	// change array and look for internal vector changes
	cout << "Make correction" << endl;
	data[2] = -1;
	data[5] = -1;
	cout << "Output   = [" << StringOperations::vecStr(data,g->size()) << "]" << endl;
	cout << "Internal = [" << StringOperations::vecStr(g->testingDoubleVector,g->size()) << "]" << endl;

	cout.flush();

	// clean
	delete g;
	g = NULL;

	// data has
	data = NULL;

	return true;
}


double *TestGraph::betweenness(double **betweennessData, int saveData)
{
	return NULL;
}

bool TestGraph::test_plainIntJustSaveMethod()
{
	// create and compute with returning a reference
	int* data = new int[g->size()];
	g->plainIntReturingMethod(&data,RES_JUST_SAVED);

	// control output and sum degrees
	cout << "---------------- Test plain method save and returning a reference but keeping responsibility outside ------------------------" << endl;
	cout << "data  = [ "; // prints Testing NDW graph
	int sum = 0;
	for (int i = 0; i < g->size(); i++)
	{
		sum += data[i];
		cout << data[i] << " ";
	}
	cout << "]" << endl;
	cout << "Internal = [" << StringOperations::vecStr(g->testingIntVector,g->size()) << "]" << endl;

	// change array and look for internal vector changes
	cout << "Make correction" << endl;
	data[2] = -1;
	data[5] = -1;
	cout << "Output   = [" << StringOperations::vecStr(data,g->size()) << "]" << endl;
	cout << "Internal = [" << StringOperations::vecStr(g->testingIntVector,g->size()) << "]" << endl;

	cout.flush();

	// clean
	delete g;
	g = NULL;

	// data has
	delete data;
	data = NULL;

	return true;
}



bool TestGraph::test_plainDoubleJustSaveMethod()
{
	// create and compute with returning a reference
	double* data = new double[g->size()];
	g->plainDoubleReturingMethod(&data,RES_JUST_SAVED);

	// control output and sum degrees
	cout << "---------------- Test plain double method returning a copy call ------------------------" << endl;
	cout << "data    = [ "; // prints Testing NDW graph
	int sum = 0;
	for (int i = 0; i < g->size(); i++)
	{
		sum += data[i];
		cout << StringOperations::formatOutputNumber(data[i]) << " ";
	}
	cout << "]" << endl;
	cout << "Internal = [" << StringOperations::vecStr(g->testingDoubleVector,g->size()) << "]" << endl;

	// change array and look for internal vector changes
	cout << "Make correction" << endl;
	data[2] = -1;
	data[5] = -1;
	cout << "Output   = [" << StringOperations::vecStr(data,g->size()) << "]" << endl;
	cout << "Internal = [" << StringOperations::vecStr(g->testingDoubleVector,g->size()) << "]" << endl;

	cout.flush();

	// clean
	delete g;
	g = NULL;

	// data has
	delete data;
	data = NULL;

	return true;
}

int TestGraph::maxNumberOfEdges()
{
	return 0;
}



int TestGraph::numerOfTriangles(int nodeIndex)
{
	return 0;
}

double *TestGraph::clusteringCoefficient(double **clusteringCoeffData, int saveData)
{
	return NULL;
}

double TestGraph::clusteringCoefficientGlobal()
{
	return -1;
}

vector<vector<int> > *TestGraph::components(vector<vector<int> > **componentsListData, int saveData)
{
	return NULL;
}

double TestGraph::characterticPathLength()
{
	return 0;
}

int TestGraph::componentsNum()
{
	return 0;
}

double TestGraph::efficiency()
{
	return 0;
}

double TestGraph::transitivity()
{
	return 0;
}

double TestGraph::assortativeCoefficient()
{
	return 0;
}

double *TestGraph::closeness(double **closenessData, int saveData)
{
	return NULL;
}

double *TestGraph::averageNearestNeighbor(double **annData, int saveData)
{
	return NULL;
}

int* componentsMat()
{
	return NULL;
}

int *TestGraph::componentsMat()
{
	return NULL;
}



SymMatrix<int> *TestGraph::distanceMatrix(SymMatrix<int> *dmatrix, int saveData)
{
	return NULL;
}











































