#include <cstring>
#include <math.h>
#include <matrix.h>
#include <mex.h>
#include "core/SparseUndiGraph.h"

#define A_IN prhs[0]
#define G_OUT plhs[0]

void mexFunction(int nlhs, mxArray * plhs[], int nrhs, const mxArray * prhs[]){   
    
    bool * A;
    SparseUndiGraph* g;
    unsigned long * G_out;
    int nrows, ncols;
    
    /* check input parameters */
    if(nrhs < 1 || nrhs > 2)
    {
        mexErrMsgTxt("Input arguments can be: \n "
                "\t 1. weighted graph and threshold, \n"
                "\t 2. double connectivity matrix and threshold, \n"
                "\t 3. integer (bool) connectivity matrix only. \n");
    }
    else if(nlhs != 1)
    {
        mexErrMsgTxt("One output argument is required: the unweighted graph handle.");
    }
    
    /* check input arguments square matrix */
    nrows = mxGetM(A_IN);
    ncols = mxGetN(A_IN);
    
    if (ncols != nrows || !mxIsLogical(A_IN)) // numeric matrix
    {
        mexErrMsgTxt("Input argument has to be logical square matrix.");
    }
    
    /* allocate output argument */
    G_OUT = mxCreateNumericMatrix(1, 1, mxUINT64_CLASS, mxREAL);
    G_out = (unsigned long*)mxGetData(G_OUT);

    /* construct the graph */
    bool* mat = (bool*)mxGetPr(A_IN);
//     for (int i = 0; i < nrows; i++)
//     {
//         for (int j = 0; j < nrows; j++)
//         {
//             mexPrintf("%d ", mat[i*ncols + j]);
//         }
//         mexPrintf("\n");
//     }
        
    
    g = new SparseUndiGraph(mat,nrows);
    
    //mexPrintf("Size of graph is %d and %d",nrows, g->size());
    
    *G_out = (unsigned long)g;       
    
    //mexPrintf("Graph object of size %d has been created.\n", nrows);
    
}
