#include <cstring>
#include <math.h>
#include <matrix.h>
#include <mex.h>
#include "core/UndiGraph.h"

#define G_IN prhs[0]
#define K_OUT plhs[0]

void mexFunction(int nlhs, mxArray * plhs[], int nrhs, const mxArray * prhs[]){   
    
    UndiGraph* g;
    unsigned long * G_ptr;
    int* K_out;
    int gsize;
    
    /* check input parameters */
    if(nrhs != 1)
    {
        mexErrMsgTxt("One input argument is required: Graph handle.");
    }
    if(nlhs != 1)
    {
        mexErrMsgTxt("One output argument is required: vector for degrees.");
    }
    
    /* check handle */
    if (!mxIsUint64(G_IN))
    {
        mexErrMsgTxt("Graph handle should be uint64 number.");
    }    
    
    /* get pointer to class */
    G_ptr = (unsigned long*)mxGetData(G_IN);
    g = (UndiGraph *) (*G_ptr);
    gsize = g->size();

        /* allocate output argument */
    if (K_OUT == NULL)
    {
        K_OUT = mxCreateNumericMatrix(gsize, 1, mxINT32_CLASS, mxREAL);
        mexPrintf("NULL applied");
    }
    K_out = (int*)mxGetPr(K_OUT);
    
    /* construct the graph */
    g->degrees(&K_out, 2);
    
    mexPrintf("k = [");
    for (int i = 0; i < gsize; i++)
    {
        mexPrintf("%d ",K_out[i]);
    }
    mexPrintf("]\n");
}
