#include <cstring>
#include <math.h>
#include <mex.h>
#include <iostream>
#include <typeinfo>
#include "core/Graph.h"

using namespace std;

#define G_IN prhs[0]

void mexFunction(int nlhs, mxArray * plhs[], int nrhs, const mxArray * prhs[]){   
    
    Graph* g;
    unsigned long * G_ptr;
    
    /* check input parameters */
    if(nrhs != 1)
    {
        mexErrMsgTxt("One input argument is required: Graph handle.");
    }
    
    /* check handle */
    if (!mxIsUint64(G_IN))
    {
        mexErrMsgTxt("Graph handle should be uint64 number.");
    }    
    
    /* get pointer to class */
    G_ptr = (unsigned long*)mxGetData(G_IN);
    g = (Graph *) (*G_ptr);

    /* free the graph pointer handle */
    delete g;
    
    //mexPrintf("Graph object has been deleted.\n");

}
