#include <cstring>
#include <math.h>
#include <matrix.h>
#include <mex.h>
#include "core/Graph.h"

#define G_IN prhs[0]
#define D_OUT plhs[0]

void mexFunction(int nlhs, mxArray * plhs[], int nrhs, const mxArray * prhs[]){   
    
    Graph* g;
    unsigned long * G_ptr;
    int* D_out;
    int gsize, glen;
    
    /* check input parameters */
    if(nrhs != 1)
    {
        mexErrMsgTxt("One input argument is required: Graph handle.");
    }
    if(nlhs != 1)
    {
        mexErrMsgTxt("One output argument is required: vector for betweenness centrality.");
    }
    
    /* check handle */
    if (!mxIsUint64(G_IN))
    {
        mexErrMsgTxt("Graph handle should be uint64 number.");
    }    
    
    /* get pointer to class */
    G_ptr = (unsigned long*)mxGetData(G_IN);
    g = (Graph *) (*G_ptr);
    gsize = g->size();
    glen = gsize*gsize;
    
    /* allocate output argument */
    if (D_OUT == NULL)
    {
        D_OUT = mxCreateNumericMatrix(gsize, gsize, mxINT32_CLASS, mxREAL);
    }
    D_out = (int*)mxGetPr(D_OUT);
    
    /* construct the graph */
    SymMatrix<int> *mat = g->distanceMatrix();
    
    //mexPrintf("Matrix (%d):\n",glen);
    //mexPrintf("%s \n",mat->to_s().c_str());
    
    mat->getFullData(D_out);
//     
//     mexPrintf("Data:\n");
// 	int k = 0;
// 	for (int i = 0; i < gsize; i++)
// 	{
// 		for (int j = 0; j < gsize; j++)
// 		{
// 			mexPrintf("%d ",D_out[k++]);
// 		}
// 		mexPrintf("\n");
// 	}

    
    //mexPrintf("%f \n",*D_out);
}
