#include <cstring>
#include <math.h>
#include <matrix.h>
#include <mex.h>
#include "core/FullUndiGraph.h"

#define N_IN prhs[0]
#define P_IN prhs[1]
#define G_OUT plhs[0]

void mexFunction(int nlhs, mxArray * plhs[], int nrhs, const mxArray * prhs[]){   
    
    FullUndiGraph* g;
    unsigned long * G_out;
    
    /* check input parameters */
    if(nrhs < 2 || nrhs > 3)
    {
        mexErrMsgTxt("Input arguments can be: \n "
                "\t 1. weighted graph and threshold, \n"
                "\t 2. double connectivity matrix and threshold, \n"
                "\t 3. integer (bool) connectivity matrix only. \n");
    }
    else if(nlhs != 1)
    {
        mexErrMsgTxt("One output argument is required: the unweighted graph handle.");
    }
    
    if (!mxIsNumeric(N_IN) || !mxIsNumeric(P_IN)) // numeric matrix
    {
        mexErrMsgTxt("Input arguments have to be size and probability.");
    }
    
    /* get inputs */
    int n = (int) mxGetScalar(N_IN);
    double p = (double) mxGetScalar(P_IN);
    
    /* allocate output argument */
    G_OUT = mxCreateNumericMatrix(1, 1, mxUINT64_CLASS, mxREAL);
    G_out = (unsigned long*)mxGetData(G_OUT);

    g = FullUndiGraph::sampleErdosRenyi(n,p);
    
    //mexPrintf("Size of graph is %d and %d \n",n, g->size());
    
    *G_out = (unsigned long)g;           
}
