%% create graph matrix
n = 10;
t = 0.3;
A = triu(rand(n));
A(logical(eye(n))) = 0;
A = A + A';
A = (A > t);
B = A .* 1;

gs = ndw_sparsegraph(A);
g = ndw_fullgraph(A);

%% test num_edges - O.K.
fprintf('-------------- num edges -------------------');
ndw_m = g.num_edges
ndw_sp_m = gs.num_edges
real_m = sum(sum(B))/2
m = real_m - ndw_m
sp_m = real_m - ndw_sp_m

%% test degrees - O.K.
fprintf('-------------- degrees -------------------');
ndw_k = g.degrees;
ndw_sp_k = gs.degrees;
real_k = sum(B);
[ndw_k ndw_sp_k real_k']
k = real_k - double(ndw_k');
sp_k = real_k - double(ndw_sp_k');
[k' sp_k']

%% test betweenness - O.K.
fprintf('-------------- Betweenness centrality -------------------');
ndw_bc = g.betweenness;
ndw_sp_bc = gs.betweenness;
bct_bc = betweenness_bin(B);
[ndw_bc ndw_sp_bc bct_bc']
bc = ndw_bc - bct_bc';
sp_bc = ndw_sp_bc - bct_bc';
[bc sp_bc]

%% test clustering coefficient - O.K.
fprintf('-------------- Clustering coefficient -------------------');
ndw_c = g.clustering;
ndw_sp_c = gs.clustering;
bct_c = clustering_coef_bu(B);
[ndw_c ndw_sp_c bct_c]
c = ndw_c - bct_c
c = ndw_sp_c - bct_c

%% test Transitivity - O.K. - no solution for sparse graph
fprintf('-------------- Transitivity -------------------');
ndw_t = g.transitivity;
ndw_sp_t = gs.transitivity;
bct_t = transitivity_bu(B);
[ndw_t ndw_sp_t bct_t]
t = ndw_t - bct_t

%% test Characteristic path, Efficiency and distance matrix - O.K.
%
ndw_D = g.distance_mat;
ndw_sp_D = gs.distance_mat;
bct_D = distance_bin(B);

ndw_cp = g.charpath_len;
ndw_e = g.efficiency;
ndw_sp_cp = g.charpath_len;
ndw_sp_e = g.efficiency;
[bct_cp,bct_e] = charpath(bct_D);

[ndw_e ndw_sp_e bct_e]
[ndw_sp_cp ndw_sp_cp bct_cp]

e = ndw_e - bct_e
cp = ndw_cp - bct_cp
D = ndw_D == bct_D
D2 = ndw_sp_D == bct_D

